require ( "util" )
require ( "prototypes.pipe-connectors" )
require( "prototypes.colors" )

local icons = "__GreenTec__/graphics/icons/";
local entities = "__GreenTec__/graphics/entities/";

if settings.startup[ "land-mine-to-grid" ].value == true
  then
  --tweack
  data.raw[ "land-mine" ][ "land-mine" ].flags =
  {
    "placeable-player",
    "placeable-enemy",
    "player-creation",
    "not-on-map"
  }
end

function organic_accumulator_picture( tint, repeat_count )
  return
  {
    layers =
    {
      {
        filename = entities.."organic-accumulator.png",
        priority = "high",
        width = 66,
        height = 94,
        repeat_count = repeat_count,
        shift = util.by_pixel( 0, -10 ),
        tint = tint,
        animation_speed = 0.5,
        hr_version =
        {
          filename = entities.."hr-organic-accumulator.png",
          priority = "high",
          width = 130,
          height = 189,
          repeat_count = repeat_count,
          shift = util.by_pixel( 0, -11 ),
          tint = tint,
          animation_speed = 0.5,
          scale = 0.5
        }
      },
      {
        filename = "__base__/graphics/entity/accumulator/accumulator-shadow.png",
        priority = "high",
        width = 120,
        height = 54,
        repeat_count = repeat_count,
        shift = util.by_pixel( 28, 6 ),
        draw_as_shadow = true,
        hr_version =
        {
          filename = "__base__/graphics/entity/accumulator/hr-accumulator-shadow.png",
          priority = "high",
          width = 234,
          height = 106,
          repeat_count = repeat_count,
          shift = util.by_pixel( 29, 6 ),
          draw_as_shadow = true,
          scale = 0.5
        }
      }
    }
  }
end

function organic_accumulator_charge( )
  return
  {
    layers =
    {
      organic_accumulator_picture( color, 24 ),
      {
        filename = "__base__/graphics/entity/accumulator/accumulator-charge.png",
        width = 90,
        height = 100,
        line_length = 6,
        frame_count = 24,
        blend_mode = "additive",
        shift = util.by_pixel( 0, -22 ),
        hr_version =
        {
          filename = "__base__/graphics/entity/accumulator/hr-accumulator-charge.png",
          width = 178,
          height = 206,
          line_length = 6,
          frame_count = 24,
          blend_mode = "additive",
          shift = util.by_pixel( 0, -22 ),
          scale = 0.5
        }
      }
    }
  }
end

function organic_accumulator_discharge( )
  return
  {
    layers =
    {
      organic_accumulator_picture( color, 24 ),
      {
        filename = "__base__/graphics/entity/accumulator/accumulator-discharge.png",
        width = 88,
        height = 104,
        line_length = 6,
        frame_count = 24,
        blend_mode = "additive",
        shift = util.by_pixel( -2, -22 ),
        hr_version =
        {
          filename = "__base__/graphics/entity/accumulator/hr-accumulator-discharge.png",
          width = 170,
          height = 210,
          line_length = 6,
          frame_count = 24,
          blend_mode = "additive",
          shift = util.by_pixel( -1, -23 ),
          scale = 0.5
        }
      }
    }
  }
end

data.raw[ "accumulator" ][ "accumulator" ].fast_replaceable_group = "accumulator"
data.raw[ "solar-panel" ][ "solar-panel" ].fast_replaceable_group = "solar-panel"

data:extend({
  -- seedling
  {
    type = "simple-entity-with-force",
    name = "seedling",
    icon = icons.."seedling.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "green-production",
    order = "b[seedling]",
    flags = { "placeable-neutral", "placeable-player", "player-creation", "breaths-air" },
    create_ghost_on_death = false,
    minable = {
      mining_particle = "wooden-particle",
      mining_time = 0.25,
      result = "seedling",
      count = 1
    },
    corpse = nil,
    remains_when_mined = nil,
    max_health = 5,
    collision_box = {{ -0.1, -0.1 }, { 0.1, 0.1 }},
    selection_box = {{ -0.5, -0.5 }, { 0.5, 0.5 }},
    vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.8 },
    picture = {
      filename = icons.."seedling.png",
      priority = "extra-high",
      width = 64,
      height = 64,
      scale = 0.56
    },
  },
  -- organic farm
  {
    type = "assembling-machine",
    name = "organic-farm",
    icon = icons.."organic-farm.png",
    icon_size = 64,
    flags = { "placeable-neutral", "placeable-player", "player-creation" },
    minable = { hardness = 0.2, mining_time = 0.5, result = "organic-farm" },
    max_health = 250,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    resistances = {{ type = "fire", percent = 40 }},
    fluid_boxes =
    {
      {
        production_type = "input",
        pipe_picture = pipePicturesOrganicFarm( ),
        pipe_covers = pipecoverspictures( ),
        base_area = 10,
        base_level = -1,
        pipe_connections = {
          { type = "input", position = { -1, -4 }},
          { type = "input", position = { 1, -4 }},
        }
      },
      off_when_no_fluid_recipe = true
    },
    collision_box = {{ -3.2, -3.2 }, { 3.2, 3.2 }},
    selection_box = {{ -3.5, -3.5 }, { 3.5, 3.5 }},
    animation =
    {
      filename = entities.."organic-farm-idle.png",
      priority = "high",
      width = 270,
      height = 224,
      frame_count = 1,
      shift = { 0.88, 0 },
    },
    working_visualisations =
    {
      {
        light = { intensity = 1, size = 32 },
        animation =
        {
          filename = entities.."organic-farm-working.png",
          width = 270,
          height = 224,
          frame_count = 1,
          shift = { 0.88, 0 },
        }
      }
    },
    crafting_categories = { "organic-farm" },
    crafting_speed = 1,
    energy_source =
    {
      type = "electric",
      usage_priority = "primary-input",
      drain = "20.0kW",
      emissions_per_minute = 10,
    },
    energy_usage = "100.0kW",
    ingredient_count = 4,
    open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.48 },
    close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.48 },
    vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.8 },
    working_sound =
    {
      sound =
      {
        {
          filename = "__GreenTec__/sounds/organic-farm.ogg",
          volume = 0.48
        },
      },
      idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.48 },
      apparent_volume = 1.6
    },
    module_specification =
    {
      module_slots = 4
    },
    allowed_effects = { "consumption", "speed", "productivity", "pollution" },
    map_color = map_color
  },
  -- cokery
  {
    type = "assembling-machine",
    name = "cokery",
    icon = icons.."cokery.png",
    icon_size = 64,
    flags = { "placeable-neutral", "placeable-player", "player-creation" },
    minable = { mining_time = 0.2, result = "cokery" },
    max_health = 400,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    resistances =
    {
      {
        type = "fire",
        percent = 100
      }
    },
    collision_box = {{ -1.2, -1.2 }, { 1.2, 1.2 }},
    selection_box = {{ -1.5, -1.5 }, { 1.5, 1.5 }},
    alert_icon_shift = util.by_pixel( -3, -12 ),
    animation =
    {
      layers =
      {
        {
          filename = entities.."cokery.png",
          priority = "high",
          width = 108,
          height = 114,
          frame_count = 32,
          line_length = 8,
          shift = util.by_pixel( 0, 2 ),
          hr_version =
          {
            filename = entities.."hr-cokery.png",
            priority = "high",
            width = 214,
            height = 226,
            frame_count = 32,
            line_length = 8,
            shift = util.by_pixel( 0, 2 ),
            scale = 0.5
          }
        },
        {
          filename = "__base__/graphics/entity/assembling-machine-1/assembling-machine-1-shadow.png",
          priority = "high",
          width = 95,
          height = 83,
          frame_count = 1,
          line_length = 1,
          repeat_count = 32,
          draw_as_shadow = true,
          shift = util.by_pixel( 8.5, 5.5 ),
          hr_version =
          {
            filename = "__base__/graphics/entity/assembling-machine-1/hr-assembling-machine-1-shadow.png",
            priority = "high",
            width = 190,
            height = 165,
            frame_count = 1,
            line_length = 1,
            repeat_count = 32,
            draw_as_shadow = true,
            shift = util.by_pixel( 8.5, 5 ),
            scale = 0.5
          }
        }
      }
    },
    working_visualisations =
    {
      {
        draw_as_light = true,
        fadeout = true,
        animation =
        {
          layers =
          {
            {
              filename = "__base__/graphics/entity/electric-furnace/electric-furnace-heater.png",
              priority = "high",
              width = 25,
              height = 15,
              frame_count = 12,
              animation_speed = 0.5,
              shift = { 0.0, 1.0 },
              hr_version =
              {
                filename = "__base__/graphics/entity/electric-furnace/hr-electric-furnace-heater.png",
                priority = "high",
                width = 60,
                height = 56,
                frame_count = 12,
                animation_speed = 0.5,
                shift = util.by_pixel( 0.0, 34.5 ),
                scale = 0.5
              }
            }
          }
        },
      },
      {
        light = { intensity = 1, size = 8, color = { r = 128, g = 64, b = 0 }},
        draw_as_light = true,
        draw_as_sprite = false,
        fadeout = true,
        animation =
        {
          filename = "__base__/graphics/entity/electric-furnace/electric-furnace-ground-light.png",
          blend_mode = "additive",
          width = 82,
          height = 64,
          shift = util.by_pixel( 4, 68 ),
          hr_version =
          {
            filename = "__base__/graphics/entity/electric-furnace/hr-electric-furnace-ground-light.png",
            blend_mode = "additive",
            width = 166,
            height = 124,
            shift = util.by_pixel( 3, 69 ),
            scale = 0.5,
          }
        },
      }
    },
    crafting_categories = { "coal-smelting" },
    crafting_speed = 1,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      drain = "20kW",
      emissions_per_minute = 5,
    },
    energy_usage = "100.0kW",
    open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.8 },
    close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.8 },
    vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.8 },
    working_sound =
    {
      sound =
      {
        {
          filename = "__base__/sound/electric-furnace.ogg",
          volume = 0.48
        },
        {
          filename = "__base__/sound/assembling-machine-t1-1.ogg",
          volume = 0.48
        }
      },
      idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.48 },
      apparent_volume = 1.6
    },
    module_specification =
    {
      module_slots = 4
    },
    allowed_effects = { "consumption", "speed", "productivity", "pollution" },
  },
  -- organic accumulator
  {
    type = "accumulator",
    name = "organic-accumulator",
    icon = icons.."organic-accumulator.png",
    icon_size = 64,
    flags = { "placeable-neutral", "player-creation" },
    minable = { hardness = 0.2, mining_time = 0.5, result = "organic-accumulator" },
    max_health = 400,
    corpse = "medium-remnants",
    fast_replaceable_group = "accumulator",
    collision_box = {{ -0.88, -0.88 }, { 0.88, 0.88 }},
    selection_box = {{ -1, -1 }, { 1, 1 }},
    drawing_box = {{ -1, -1.5 }, { 1, 1 }},
    map_color = map_color,
    energy_source =
    {
      type = "electric",
      buffer_capacity = "25MJ",
      usage_priority = "tertiary",
      input_flow_limit = "1MW",
      output_flow_limit = "1MW"
    },
    picture = organic_accumulator_picture( ),
    charge_animation = organic_accumulator_charge( ),
    water_reflection = accumulator_reflection( ),
    discharge_animation = organic_accumulator_discharge( ),
    charge_cooldown = 60,
    discharge_cooldown = 60,
    vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.4 },
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/accumulator-working.ogg",
        volume = 0.4
      },
      idle_sound =
      {
        filename = "__base__/sound/accumulator-idle.ogg",
        volume = 0.32
      },
      max_sounds_per_type = 3,
      audible_distance_modifier = 0.5,
      fade_in_ticks = 4,
      fade_out_ticks = 20
    },
    circuit_wire_connection_point = circuit_connector_definitions[ "accumulator" ].points,
    circuit_connector_sprites = circuit_connector_definitions[ "accumulator" ].sprites,
    circuit_wire_max_distance = default_circuit_wire_max_distance,
    default_output_signal = { type = "virtual", name = "signal-A" }
  },
  -- organic solar panel
  {
    type = "solar-panel",
    name = "organic-solar-panel",
    icon = icons.."organic-solar-panel.png",
    icon_size = 64,
    flags = { "placeable-neutral", "player-creation" },
    minable = { hardness = 0.2, mining_time = 1, result = "organic-solar-panel" },
    max_health = 400,
    corpse = "big-remnants",
    fast_replaceable_group = "solar-panel",
    collision_box = {{ -1.4, -1.4 }, { 1.4, 1.4 }},
    selection_box = {{ -1.5, -1.5 }, { 1.5, 1.5 }},
    map_color = map_color,
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      layers =
      {
        {
          filename = entities.."organic-solar-panel.png",
          priority = "high",
          width = 116,
          height = 112,
          shift = util.by_pixel( -3, 3 ),
          hr_version =
          {
            filename = entities.."hr-organic-solar-panel.png",
            priority = "high",
            width = 230,
            height = 224,
            shift = util.by_pixel( -3, 3.5 ),
            scale = 0.5
          }
        },
        {
          filename = "__base__/graphics/entity/solar-panel/solar-panel-shadow.png",
          priority = "high",
          width = 112,
          height = 90,
          shift = util.by_pixel( 10, 6 ),
          draw_as_shadow = true,
          hr_version =
          {
            filename = "__base__/graphics/entity/solar-panel/hr-solar-panel-shadow.png",
            priority = "high",
            width = 220,
            height = 180,
            shift = util.by_pixel( 9.5, 6 ),
            draw_as_shadow = true,
            scale = 0.5
          }
        }
      }
    },
    overlay =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/solar-panel/solar-panel-shadow-overlay.png",
          priority = "high",
          width = 108,
          height = 90,
          shift = util.by_pixel( 11, 6 ),
          hr_version =
          {
            filename = "__base__/graphics/entity/solar-panel/hr-solar-panel-shadow-overlay.png",
            priority = "high",
            width = 214,
            height = 180,
            shift = util.by_pixel( 10.5, 6 ),
            scale = 0.5
          }
        }
      }
    },
    vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    production = "250kW"
  },
})
