local icons = "__GreenTec__/graphics/icons/";
local entities = "__GreenTec__/graphics/entities/";
local sounds = "__GreenTec__/sounds/";

local dragonFire = table.deepcopy( data.raw[ "fire" ][ "fire-flame-on-tree" ])
dragonFire.name = "dragon-fire"
dragonFire.initial_lifetime = 300
dragonFire.damage_per_tick = { amount = 50 / 60, type = "fire" }
dragonFire.on_fuel_added_action = nil
dragonFire.damage_multiplier_decrease_per_tick = 0.005
dragonFire.emissions_per_tick = 0
dragonFire.maximum_damage_multiplier = 10
dragonFire.spread_delay = 300
dragonFire.burnt_patch_lifetime = 300
dragonFire.spread_delay_deviation = 60
dragonFire.fade_in_duration = 60
dragonFire.fade_out_duration = 60
dragonFire.lifetime_increase_by = 300
dragonFire.maximum_spread_count = 1
dragonFire.maximum_lifetime = 600

local wormFire = table.deepcopy( data.raw[ "fire" ][ "acid-splash-fire-worm-small" ])
wormFire.name = "worm-fire"
wormFire.initial_lifetime = 300
wormFire.damage_per_tick = { amount = 50 / 60, type = "acid" }
wormFire.on_fuel_added_action = nil
wormFire.damage_multiplier_decrease_per_tick = 0.005
wormFire.emissions_per_tick = 0
wormFire.maximum_damage_multiplier = 10
wormFire.spread_delay = 300
wormFire.burnt_patch_lifetime = 300
wormFire.spread_delay_deviation = 60
wormFire.fade_in_duration = 60
wormFire.fade_out_duration = 60
wormFire.lifetime_increase_by = 300
wormFire.maximum_spread_count = 1
wormFire.maximum_lifetime = 600
wormFire.on_damage_tick_effect = {
  type = "direct",
  ignore_collision_condition = true,
  trigger_target_mask = { "ground-unit" },
  filter_enabled = true,
  action_delivery =
  {
    type = "instant",
    target_effects =
    {
      {
        type = "create-sticker",
        sticker = "worm-fire-sticker",
        show_in_tooltip = false
      }
    }
  }
}

data:extend({
  dragonFire,
  wormFire,
  {
    type = "sticker",
    name = "dragon-fire-sticker",
    flags = { "not-on-map" },
    duration_in_ticks = 300,
    animation =
    {
      filename = "__base__/graphics/entity/fire-flame/fire-flame-13.png",
      line_length = 8,
      width = 60,
      height = 118,
      frame_count = 25,
      blend_mode = "normal",
      animation_speed = 1,
      scale = 0.2,
      tint = { r = 0.5, g = 0.5, b = 0.5, a = 0.18 },
    },
    duration_in_ticks = 30 * 60,
    damage_interval = 10,
    damage_per_tick = { amount = 50 / 60, type = "fire" },
    spread_fire_entity = "dragon-fire",
    fire_spread_cooldown = 30,
    fire_spread_radius = 0.75
  },
  {
    type = "sticker",
    name = "worm-fire-sticker",
    flags = { "not-on-map" },
    animation =
    {
      filename = "__base__/graphics/entity/acid-sticker/acid-sticker.png",
      priority = "extra-high",
      line_length = 5,
      width = 16,
      height = 18,
      frame_count = 50,
      animation_speed = 0.5,
      tint = { r = 0.714, g = 0.669, b = 0.291, a = 0.745 },
      shift = util.by_pixel ( 2, 0 ),
      hr_version =
      {
        filename = "__base__/graphics/entity/acid-sticker/hr-acid-sticker.png",
        line_length = 5,
        width = 30,
        height = 34,
        frame_count = 50,
        animation_speed = 0.5,
        tint = { r = 0.714, g = 0.669, b = 0.291, a = 0.745 },
        shift = util.by_pixel( 1.5, 0 ),
        scale = 0.5
      }
    },
    duration_in_ticks = 30 * 60,
    damage_interval = 10,
    target_movement_modifier_from = 0.5,
    target_movement_modifier_to = 1
  },
  {
    type = "ammo",
    name = "dragon-shotgun-shell",
    icon = icons.."dragon-shotgun-shell.png",
    icon_size = 64, icon_mipmaps = 4,
    ammo_type =
    {
      category = "shotgun-shell",
      target_type = "direction",
      clamp_position = true,
      action =
      {
        {
          type = "direct",
          action_delivery =
          {
            type = "instant",
            source_effects =
            {
              {
                type = "create-explosion",
                entity_name = "explosion-gunshot"
              }
            }
          }
        },
        {
          type = "direct",
          repeat_count = 24,
          action_delivery =
          {
            type = "projectile",
            projectile = "dragon-shotgun-pellet",
            starting_speed = 1,
            starting_speed_deviation = 0.1,
            direction_deviation = 0.5,
            range_deviation = 0.5,
            max_range = 16
          }
        }
      }
    },
    magazine_size = 10,
    subgroup = "green-ammo",
    order = "a[dragon-shotgun-pellet]",
    stack_size = 200
  },
  {
    type = "ammo",
    name = "worm-shotgun-shell",
    icon = icons.."worm-shotgun-shell.png",
    icon_size = 64, icon_mipmaps = 4,
    ammo_type =
    {
      category = "shotgun-shell",
      target_type = "direction",
      clamp_position = true,
      action =
      {
        {
          type = "direct",
          action_delivery =
          {
            type = "instant",
            source_effects =
            {
              {
                type = "create-explosion",
                entity_name = "explosion-gunshot"
              }
            }
          }
        },
        {
          type = "direct",
          repeat_count = 24,
          action_delivery =
          {
            type = "projectile",
            projectile = "worm-shotgun-pellet",
            starting_speed = 1,
            starting_speed_deviation = 0.1,
            direction_deviation = 0.5,
            range_deviation = 0.5,
            max_range = 16
          }
        }
      }
    },
    magazine_size = 10,
    subgroup = "green-ammo",
    order = "b[worm-shotgun-shell]",
    stack_size = 200
  },
  {
    type = "projectile",
    name = "dragon-shotgun-pellet",
    flags = { "not-on-map" },
    collision_box = {{ -0.05, -0.25 }, { 0.05, 0.25 }},
    acceleration = 0,
    direction_only = true,
    light = { intensity = 8, size = 8, color = { r = 1, g = 0.5 }},
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "damage",
            damage = { amount = 4, type = "impact" }
          },
          {
            type = "damage",
            damage = { amount = 4, type = "fire" }
          },
          {
            type = "push-back",
            distance = 2
          },
          {
            type = "nested-result",
            action =
            {
              type = "area",
              radius = 2,
              action_delivery =
              {
                type = "instant",
                target_effects =
                {
                  {
                    type = "create-sticker",
                    sticker = "dragon-fire-sticker"
                  },
                  {
                    type = "create-fire",
                    show_in_tooltip = true,
                    entity_name = "dragon-fire"
                  }
                }
              }
            }
          }
        }
      }
    },
    animation =
    {
      filename = "__base__/graphics/entity/piercing-bullet/piercing-bullet.png",
      frame_count = 1,
      width = 3,
      height = 50,
      priority = "high"
    }
  },
  {
    type = "projectile",
    name = "worm-shotgun-pellet",
    flags = { "not-on-map" },
    collision_box = {{ -0.05, -0.25 }, { 0.05, 0.25 }},
    acceleration = 0,
    direction_only = true,
    light = { intensity = 8, size = 8, color = { r = 0.5, g = 1 }},
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "damage",
            damage = { amount = 4, type = "impact" }
          },
          {
            type = "damage",
            damage = { amount = 4, type = "acid" }
          },
          {
            type = "push-back",
            distance = 2
          },
          {
            type = "nested-result",
            action =
            {
              type = "area",
              radius = 2,
              action_delivery =
              {
                type = "instant",
                target_effects =
                {
                  {
                    type = "create-sticker",
                    sticker = "worm-fire-sticker"
                  },
                  {
                    type = "create-fire",
                    show_in_tooltip = true,
                    entity_name = "worm-fire"
                  }
                }
              }
            }
          }
        }
      }
    },
    animation =
    {
      filename = "__base__/graphics/entity/piercing-bullet/piercing-bullet.png",
      frame_count = 1,
      width = 3,
      height = 50,
      priority = "high"
    }
  },
})
