require( "prototypes.colors" )

local icons = "__GreenTec__/graphics/icons/";

data.raw[ "item" ][ "solid-fuel" ].fuel_emissions_multiplier = 0.4,

data:extend({
  -- garden tools
  {
    type = "selection-tool",
    name = "garden-tools",
    icon_size = 64, icon_mipmaps = 4,
    stack_size = 1,
    -- icon = icons.."garden-tools-item.png",
    icons = {
      {
        icon = "__base__/graphics/icons/upgrade-planner.png",
      },
      {
        icon = "__base__/graphics/icons/steel-axe.png",
      }
    },
    draw_label_for_cursor_render = true,
    subgroup = "green-production",
    order = "z[seedling]",
    flags = { "only-in-cursor", "hidden", "not-stackable", "spawnable" },
    tile_filters = { "tutorial-grid" },
    entity_filters = {
      "dry-tree",
      "dead-tree-desert",
      "dead-grey-trunk",
      "dead-dry-hairy-tree",
      "dry-hairy-tree",
      "tree-06",
      "tree-06-brown",
      "rock-big",
      "sand-rock-big",
      "rock-huge",
      "item-on-ground"
    },
    entity_filter_mode = "whitelist",
    tile_filter_mode = "whitelist",
    selection_color = { r = 0, g = 1, b = 0, a = 0.64 },
    alt_selection_color = { r = 1, g = 0, b = 0, a = 0.64 },
    selection_mode = { "deconstruct" },
    alt_selection_mode = { "nothing" },
    selection_cursor_box_type = "entity",
    alt_selection_cursor_box_type = "entity",
    can_be_mod_opened = false,
    show_in_library = false
  },
  -- garden tools
  {
    type = "selection-tool",
    name = "resource-tools",
    icon_size = 64, icon_mipmaps = 4,
    stack_size = 1,
    icons = {
      {
        icon = "__base__/graphics/icons/upgrade-planner.png",
      },
      {
        icon = "__base__/graphics/icons/fluid/water.png",
      }
    },
    draw_label_for_cursor_render = true,
    subgroup = "green-production",
    order = "z[seedling]",
    flags = { "only-in-cursor", "hidden", "not-stackable", "spawnable" },
    entity_filters = {
      "iron-ore",
      "copper-ore",
      "coal",
      "stone",
      -- "uranium-ore",
    },
    alt_entity_filters = {
      "iron-water-ore",
      "copper-water-ore",
      "stone-water-ore",
      "coal-water-ore",
    },
    entity_filter_mode = "whitelist",
    alt_entity_filter_mode = "whitelist",
    selection_color = { r = 0, g = 1, b = 0, a = 0.64 },
    selection_mode_flags = { "any-entity", "any-tile" },
    alt_selection_color = { r = 1, g = 0, b = 0, a = 0.64 },
    selection_mode = { "any-entity" },
    alt_selection_mode = { "any-entity" },
    entity_filter_slots = 4,
    selection_cursor_box_type = "entity",
    alt_selection_cursor_box_type = "entity",
    can_be_mod_opened = false,
    show_in_library = false
  },
  -- organic solar panel
  {
    type = "item",
    name = "organic-solar-panel",
    icon = icons.."organic-solar-panel.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "green-energy",
    order = "c[organic-solar-panel]",
    place_result = "organic-solar-panel",
    stack_size = 50,
  },
  -- organic accumulator
  {
    type = "item",
    name = "organic-accumulator",
    icon = icons.."organic-accumulator.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "green-energy",
    order = "d[organic-accumulator]",
    place_result = "organic-accumulator",
    stack_size = 50,
  },
  --organic farm
  {
    type = "item",
    name = "organic-farm",
    icon = icons.."organic-farm.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "green-production",
    order = "a[organic-farm]",
    place_result = "organic-farm",
    stack_size = 10,
  },
  -- organic farm
  {
    type = "item",
    name = "cokery",
    icon = icons.."cokery.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "cokery",
    order = "a[cokery]",
    place_result = "cokery",
    stack_size = 10,
  },
  -- seedling
  {
    type = "item",
    name = "seedling",
    icon = icons.."seedling.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "green-production",
    order = "b[seedling]",
    place_result = "seedling",
    stack_size = 200,
  },
  -- seedling-landfill
  {
    type = "item",
    name = "seedling-landfill",
    icon = icons.."seedling-landfill.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "green-production",
    order = "d[seedling-landfill]",
    place_as_tile =
    {
      result = "grass-4",
      condition_size = 1,
      condition = { "ground-tile" },
    },
    stack_size = 200,
  },
  -- absorbtion-brick
  {
    type = "item",
    name = "absorbtion-brick",
    icons = {
      {
        icon = "__base__/graphics/icons/stone-brick.png",
        icon_size = 64,
        icon_mipmaps = 4,
        tint = color
      },
    },
    subgroup = "green-production",
    order = "e[absorbtion-brick]",
    place_as_tile =
    {
      result = "absorbtion-bricks",
      condition_size = 1,
      condition = { "water-tile" },
    },
    stack_size = 200,
  },
  -- organic concrete
  {
    type = "item",
    name = "organic-concrete",
    icons = {
      {
        icon = "__base__/graphics/icons/concrete.png",
        icon_size = 64,
        icon_mipmaps = 4,
        tint = color
      },
    },
    subgroup = "green-production",
    order = "f[organic-concrete]",
    place_as_tile =
    {
      result = "organic-concrete",
      condition_size = 1,
      condition = { "water-tile" },
    },
    stack_size = 200,
  },
  -- hazard organic concrete
  {
    type = "item",
    name = "hazard-organic-concrete",
    icons = {
      {
        icon = "__base__/graphics/icons/hazard-concrete.png",
        icon_size = 64,
        icon_mipmaps = 4,
        tint = color
      },
    },
    subgroup = "green-production",
    flags = { "hidden" },
    order = "f[hazard-organic-concrete]",
    place_as_tile =
    {
      result = "hazard-organic-concrete-left",
      condition_size = 1,
      condition = { "water-tile" },
    },
    stack_size = 200,
  },
  -- refined organic concrete
  {
    type = "item",
    name = "refined-organic-concrete",
    icons = {
      {
        icon = "__base__/graphics/icons/refined-concrete.png",
        icon_size = 64,
        icon_mipmaps = 4,
        tint = color
      },
    },
    subgroup = "green-production",
    order = "g[refined-organic-concrete]",
    place_as_tile =
    {
      result = "refined-organic-concrete",
      condition_size = 1,
      condition = { "water-tile" },
    },
    stack_size = 200,
  },
  -- refined hazard organic concrete
  {
    type = "item",
    name = "refined-hazard-organic-concrete",
    icons = {
      {
        icon = "__base__/graphics/icons/refined-hazard-concrete.png",
        icon_size = 64,
        icon_mipmaps = 4,
        tint = color
      },
    },
    subgroup = "green-production",
    flags = { "hidden" },
    order = "g[refined-hazard-organic-concrete]",
    place_as_tile =
    {
      result = "refined-hazard-organic-concrete-left",
      condition_size = 1,
      condition = { "water-tile" },
    },
    stack_size = 200,
  },
  --
  {
    type = "capsule",
    name = "raw-fish",
    icon = "__base__/graphics/icons/fish.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "raw-resource",
    capsule_action =
    {
      type = "use-on-self",
      attack_parameters =
      {
        type = "projectile",
        activation_type = "consume",
        ammo_category = "capsule",
        cooldown = 30,
        range = 0,
        ammo_type =
        {
          category = "capsule",
          target_type = "position",
          action =
          {
            type = "direct",
            action_delivery =
            {
              type = "instant",
              target_effects =
              {
                {
                  type = "damage",
                  damage = { type = "acid", amount = 40 }
                },
                {
                  type = "play-sound",
                  sound = {
                    {
                      filename = "__base__/sound/eat.ogg",
                      volume = 0.6
                    },
                    {
                      filename = "__base__/sound/eat-1.ogg",
                      volume = 0.6
                    },
                    {
                      filename = "__base__/sound/eat-2.ogg",
                      volume = 0.6
                    },
                    {
                      filename = "__base__/sound/eat-3.ogg",
                      volume = 0.6
                    },
                    {
                      filename = "__base__/sound/eat-4.ogg",
                      volume = 0.6
                    }
                  }
                }
              }
            }
          }
        }
      }
    },
    order = "h[raw-fish]",
    stack_size = 100
  },
  --
  {
    type = "capsule",
    name = "fried-fish",
    icon = icons.."fried-fish.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "green-production",
    order = "h[fried-fish]",
    capsule_action =
    {
      type = "use-on-self",
      attack_parameters =
      {
        type = "projectile",
        activation_type = "consume",
        ammo_category = "capsule",
        cooldown = 30,
        range = 0,
        ammo_type =
        {
          category = "capsule",
          target_type = "position",
          action =
          {
            type = "direct",
            action_delivery =
            {
              type = "instant",
              target_effects =
              {
                {
                  type = "damage",
                  damage = { type = "physical", amount = -100 }
                },
                {
                  type = "play-sound",
                  sound = {
                    {
                      filename = "__base__/sound/eat.ogg",
                      volume = 0.6
                    },
                    {
                      filename = "__base__/sound/eat-1.ogg",
                      volume = 0.6
                    },
                    {
                      filename = "__base__/sound/eat-2.ogg",
                      volume = 0.6
                    },
                    {
                      filename = "__base__/sound/eat-3.ogg",
                      volume = 0.6
                    },
                    {
                      filename = "__base__/sound/eat-4.ogg",
                      volume = 0.6
                    }
                  }
                }
              }
            }
          }
        }
      }
    },
    stack_size = 100
  },
  -- wood pulp
  {
    type = "item",
    name = "woodpulp",
    icon = icons.."woodpulp.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "cokery",
    order = "a[woodpulp]",
    stack_size = 200,
  },
  -- ash
  {
    type = "item",
    name = "ash",
    icon = icons.."ash.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "cokery",
    order = "b[ash]",
    stack_size = 200,
  },
  -- flux
  {
    type = "item",
    name = "flux",
    icon = icons.."flux.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "cokery",
    order = "c[flux]",
    stack_size = 200,
  },
  -- fluxed-iron-ore
  {
    type = "item",
    name = "fluxed-iron-ore",
    icon = icons.."fluxed-iron-ore.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "cokery",
    order = "c[fluxed-iron-ore]",
    stack_size = 100,
  },
  -- fluxed-copper-ore
  {
    type = "item",
    name = "fluxed-copper-ore",
    icon = icons.."fluxed-copper-ore.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "cokery",
    order = "c[fluxed-copper-ore]",
    stack_size = 100,
  },
  -- fluxed-copper-ore
  {
    type = "item",
    name = "fluxed-iron",
    icon = icons.."fluxed-iron.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "cokery",
    order = "c[fluxed-iron]",
    stack_size = 100,
  },
  -- purified fuel
  {
    type = "item",
    name = "purified-fuel",
    icon = icons.."purified-fuel.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "cokery",
    order = "c[purified-fuel]",
    fuel_value = "20MJ",
    fuel_acceleration_multiplier = 1.05,
    fuel_top_speed_multiplier = 1.05,
    fuel_emissions_multiplier = 0.4,
    fuel_category = "chemical",
    stack_size = 50,
  },
  -- bio fuel
  {
    type = "item",
    name = "bio-fuel",
    icon = icons.."bio-fuel.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "cokery",
    order = "d[bio-fuel]",
    fuel_value = "25MJ",
    fuel_acceleration_multiplier = 1.1,
    fuel_top_speed_multiplier = 1.1,
    fuel_emissions_multiplier = 0.2,
    fuel_category = "chemical",
    stack_size = 50,
  },
  -- fertiliser
  {
    type = "capsule",
    name = "gt-fertiliser",
    icon = icons.."fertiliser.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "organic-materials",
    order = "a[gt-fertiliser]",
    capsule_action =
    {
      type = "throw",
      attack_parameters =
      {
        type = "projectile",
        ammo_category = "capsule",
        cooldown = 60,
        projectile_creation_distance = 0.6,
        range = 20,
        ammo_type =
        {
          category = "capsule",
          target_type = "position",
          action =
          {
            type = "direct",
            action_delivery =
            {
              type = "projectile",
              projectile = "fertiliser-capsule",
              starting_speed = 0.2
            }
          }
        }
      }
    },
    stack_size = 100,
  },
  -- adv fertiliser
  {
    type = "capsule",
    name = "advanced-fertiliser",
    icon = icons.."advanced-fertiliser.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "organic-materials",
    order = "b[advanced-fertiliser]",
    capsule_action =
    {
      type = "throw",
      attack_parameters =
      {
        type = "projectile",
        ammo_category = "capsule",
        cooldown = 60,
        projectile_creation_distance = 0.6,
        range = 20,
        ammo_type =
        {
          category = "capsule",
          target_type = "position",
          action =
          {
            type = "direct",
            action_delivery =
            {
              type = "projectile",
              projectile = "advanced-fertiliser-capsule",
              starting_speed = 0.2
            }
          }
        }
      }
    },
    stack_size = 100,
  },
  -- celluluse
  {
    type = "item",
    name = "cellulose",
    icon = icons.."cellulose.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "organic-materials",
    order = "c[cellulose]",
    stack_size = 200,
  },
})
