local icons = "__GreenTec__/graphics/icons/";
if settings.startup[ "flamethrower-ammo-crafting-with-fluid" ].value == true
  then
  data:extend({
    -- tweack
    {
      type = "recipe",
      name = "flamethrower-ammo",
      category = "crafting-with-fluid",
      energy_required = 10,
      ingredients =
      {
        { type = "item", name = "steel-plate", amount = 5 },
        { type = "fluid", name = "light-oil", amount = 100 },
      },
      result = "flamethrower-ammo",
      enabled = false,
    },
  })
end

data:extend({
  -- organic solar panel
  {
    type = "recipe",
    name = "organic-solar-panel",
    energy_required = 20,
    category = "crafting-with-fluid",
    subgroup = "green-energy",
    order = "c[organic-solar-panel]",
    ingredients =
    {
      { type = "item", name = "solar-panel", amount = 5 },
      { type = "item", name = "plastic-bar", amount = 25 },
      { type = "item", name = "copper-cable", amount = 50 },
      { type = "item", name = "advanced-circuit", amount = 5 },
      { type = "fluid", name = "biomass", amount = 500 },
    },
    result = "organic-solar-panel",
    emissions_multiplier = 0.5,
    enabled = false,
  },
  -- organic accumulator
  {
    type = "recipe",
    name = "organic-accumulator",
    energy_required = 20,
    category = "crafting-with-fluid",
    subgroup = "green-energy",
    order = "d[organic-accumulator]",
    ingredients =
    {
      { type = "item", name = "accumulator", amount = 5 },
      { type = "item", name = "plastic-bar", amount = 25 },
      { type = "item", name = "copper-cable", amount = 50 },
      { type = "item", name = "advanced-circuit", amount = 5 },
      { type = "fluid", name = "biomass", amount = 500 },
    },
    result = "organic-accumulator",
    emissions_multiplier = 0.5,
    enabled = false,
  },
  -- organic farm
  {
    type = "recipe",
    name = "organic-farm",
    subgroup = "green-production",
    order = "a[organic-farm]",
    energy_required = 10,
    ingredients =
    {
      { "iron-stick", 40 },
      { "small-lamp", 20 },
      { "copper-cable", 10 },
      { "stone-brick", 10 },
    },
    result_count = 1,
    result = "organic-farm",
    enabled = false,
  },
  -- seedling landfill
  {
    type = "recipe",
    name = "seedling-landfill",
    icon = icons.."seedling-landfill-recipe.png",
    icon_size = 64, icon_mipmaps = 4,
    energy_required = 20,
    overload_multiplier = 2,
    category = "organic-farm",
    subgroup = "coating",
    order = "a[seedling-landfill]",
    ingredients =
    {
      { type = "item", name = "seedling", amount = 10 },
      { type = "item", name = "ash", amount = 20 },
      { type = "item", name = "woodpulp", amount = 20 },
      { type = "fluid", name = "water", amount = 100 },
    },
    result = "seedling-landfill",
    result_count = 5,
    emissions_multiplier = -0.25,
    enabled = false,
  },
  -- absorbtion brick
  {
    type = "recipe",
    name = "absorbtion-brick",
    energy_required = 10,
    overload_multiplier = 2,
    category = "organic-farm",
    subgroup = "coating",
    order = "b[absorbtion-brick]",
    ingredients =
    {
      { type = "item", name = "seedling", amount = 5 },
      { type = "item", name = "ash", amount = 20 },
      { type = "item", name = "woodpulp", amount = 20 },
      { type = "fluid", name = "water", amount = 100 },
    },
    result = "absorbtion-brick",
    result_count = 5,
    emissions_multiplier = -0.25,
    enabled = false,
  },
  -- organic concrete
  {
    type = "recipe",
    name = "organic-concrete",
    energy_required = 20,
    overload_multiplier = 2,
    category = "organic-farm",
    subgroup = "coating",
    order = "c[organic-concrete]",
    ingredients =
    {
      { type = "item", name = "absorbtion-brick", amount = 10 },
      { type = "item", name = "ash", amount = 20 },
      { type = "item", name = "woodpulp", amount = 20 },
      { type = "fluid", name = "biomass", amount = 50 },
    },
    result = "organic-concrete",
    result_count = 5,
    emissions_multiplier = -0.5,
    enabled = false,
  },
  -- refined organic concrete
  {
    type = "recipe",
    name = "refined-organic-concrete",
    energy_required = 40,
    overload_multiplier = 2,
    category = "organic-farm",
    subgroup = "coating",
    order = "d[refined-organic-concrete]",
    ingredients =
    {
      { type = "item", name = "organic-concrete", amount = 10 },
      { type = "item", name = "cellulose", amount = 10 },
      { type = "item", name = "plastic-bar", amount = 10 },
      { type = "fluid", name = "biomass", amount = 100 },
    },
    result = "refined-organic-concrete",
    result_count = 5,
    emissions_multiplier = -1,
    enabled = false,
  },
  -- fried fish
  {
    type = "recipe",
    name = "fried-fish",
    category = "smelting",
    subgroup = "green-smelting",
    order = "a[fried-fish]",
    energy_required = 2,
    ingredients = {{ "raw-fish", 1 }},
    result = "fried-fish",
    emissions_multiplier = 0.5,
    enabled = true,
  },
  -- smelting absorbtion brick
  {
    type = "recipe",
    name = "stone-brick-2",
    category = "smelting",
    subgroup = "green-smelting",
    order = "b[stone-brick-2]",
    energy_required = 3.2,
    ingredients = {{ "absorbtion-brick", 1 }},
    result = "stone-brick",
    emissions_multiplier = 0.5,
    enabled = false,
  },
  -- smelting organic-concrete
  {
    type = "recipe",
    name = "concrete-2",
    category = "smelting",
    subgroup = "green-smelting",
    order = "c[concrete-2]",
    energy_required = 6.4,
    ingredients = {{ "organic-concrete", 2 }},
    result = "concrete",
    emissions_multiplier = 0.5,
    enabled = false,
  },
  -- smelting refined organic concrete
  {
    type = "recipe",
    name = "refined-concrete-2",
    category = "smelting",
    subgroup = "green-smelting",
    order = "d[refined-concrete-2]",
    energy_required = 12.8,
    ingredients = {{ "refined-organic-concrete", 4 }},
    result = "refined-concrete",
    emissions_multiplier = 0.5,
    enabled = false,
  },
  -- seedlings from water (basic)
  {
    type = "recipe",
    name = "seedling-mk1",
    icon = icons.."seedling1.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "organic-farm",
    subgroup = "seedling",
    order = "a[seedling-mk1]",
    energy_required = 80,
    overload_multiplier = 2,
    ingredients =
    {
      { type = "item", name = "wood", amount = 10 },
      { type = "fluid", name = "water", amount = 100 },
    },
    result_count = 20,
    result = "seedling",
    emissions_multiplier = -1,
    enabled = false,
  },
  -- seedlings from water & ash
  {
    type = "recipe",
    name = "seedling-mk2",
    icon = icons.."seedling2.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "organic-farm",
    subgroup = "seedling",
    order = "b[seedling-mk2]",
    energy_required = 40,
    overload_multiplier = 2,
    ingredients =
    {
      { type = "item", name = "wood", amount = 10 },
      { type = "item", name = "ash", amount = 20 },
      { type = "fluid", name = "water", amount = 100 },
    },
    result_count = 20,
    result = "seedling",
    emissions_multiplier = -2,
    enabled = false,
  },
  -- seedlings from water & fertiliser
  {
    type = "recipe",
    name = "seedling-mk3",
    icon = icons.."seedling3.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "organic-farm",
    subgroup = "seedling",
    order = "c[seedling-mk3]",
    energy_required = 20,
    overload_multiplier = 2,
    ingredients =
    {
      { type = "item", name = "wood", amount = 10 },
      { type = "item", name = "gt-fertiliser", amount = 10 },
      { type = "fluid", name = "water", amount = 100 },
    },
    result_count = 20,
    result = "seedling",
    emissions_multiplier = -3,
    enabled = false,
  },
  -- seedlings from water & advanced-fertiliser
  {
    type = "recipe",
    name = "seedling-mk4",
    icon = icons.."seedling4.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "organic-farm",
    subgroup = "seedling",
    order = "d[seedling-mk4]",
    energy_required = 10,
    overload_multiplier = 2,
    ingredients =
    {
      { type = "item", name = "wood", amount = 10 },
      { type = "item", name = "advanced-fertiliser", amount = 10 },
      { type = "fluid", name = "water", amount = 100 },
    },
    result_count = 20,
    result = "seedling",
    emissions_multiplier = -4,
    enabled = false,
  },
  -- raw wood from water (basic)
  {
    type = "recipe",
    name = "wood-mk1",
    icon = icons.."wood-mk1.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "organic-farm",
    subgroup = "wood",
    order = "a[wood-mk1]",
    energy_required = 320,
    overload_multiplier = 2,
    ingredients =
    {
      { type = "item", name = "seedling", amount = 20 },
      { type = "fluid", name = "water", amount = 200 },
    },
    result_count = 80,
    result = "wood",
    emissions_multiplier = -1,
    enabled = false,
  },
  -- raw wood from water & ash
  {
    type = "recipe",
    name = "wood-mk2",
    icon = icons.."wood-mk2.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "organic-farm",
    subgroup = "wood",
    order = "b[wood-mk2]",
    energy_required = 160,
    overload_multiplier = 2,
    ingredients =
    {
      { type = "item", name = "seedling", amount = 20 },
      { type = "item", name = "ash", amount = 40 },
      { type = "fluid", name = "water", amount = 200 },
    },
    result_count = 80,
    result = "wood",
    emissions_multiplier = -2,
    enabled = false,
  },
  -- raw wood from water & fertiliser
  {
    type = "recipe",
    name = "wood-mk3",
    icon = icons.."wood-mk3.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "organic-farm",
    subgroup = "wood",
    order = "c[wood-mk3]",
    energy_required = 80,
    overload_multiplier = 2,
    ingredients =
    {
      { type = "item", name = "seedling", amount = 20 },
      { type = "item", name = "gt-fertiliser", amount = 10 },
      { type = "fluid", name = "water", amount = 200 },
    },
    result_count = 80,
    result = "wood",
    emissions_multiplier = -3,
    enabled = false,
  },
  -- raw wood from advanced-fertiliser
  {
    type = "recipe",
    name = "wood-mk4",
    icon = icons.."wood-mk4.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "organic-farm",
    subgroup = "wood",
    order = "d[wood-mk4]",
    energy_required = 40,
    overload_multiplier = 2,
    ingredients =
    {
      { type = "item", name = "seedling", amount = 20 },
      { type = "item", name = "advanced-fertiliser", amount = 10 },
      { type = "fluid", name = "water", amount = 200 },
    },
    result_count = 80,
    result = "wood",
    emissions_multiplier = -4,
    enabled = false,
  },
  -- cokery
  {
    type = "recipe",
    name = "cokery",
    subgroup = "green-production",
    order = "b[cokery]",
    energy_required = 10,
    ingredients =
    {
      { "assembling-machine-1", 2 },
      { "stone-furnace", 2 },
      { "iron-gear-wheel", 10 },
      { "stone-brick", 10 },
    },
    result_count = 1,
    result = "cokery",
    enabled = false,
  },
  -- woodpulp
  {
    type = "recipe",
    name = "woodpulp",
    category = "coal-smelting",
    subgroup = "cokery",
    order = "b[woodpulp]",
    energy_required = 4,
    overload_multiplier = 2,
    ingredients = {{ "wood", 10 }},
    result = "woodpulp",
    result_count = 40,
    allow_decomposition = false,
    enabled = false,
  },
  -- ash
  {
    type = "recipe",
    name = "ash",
    category = "coal-smelting",
    subgroup = "cokery",
    order = "c[ash]",
    energy_required = 4,
    overload_multiplier = 2,
    ingredients = {{ "wood", 10 }},
    result_count = 40,
    result = "ash",
    allow_decomposition = false,
    enabled = false,
  },
  -- flux
  {
    type = "recipe",
    name = "flux",
    category = "coal-smelting",
    subgroup = "cokery",
    order = "f[flux]",
    energy_required = 8,
    overload_multiplier = 2,
    ingredients = {
      { "ash", 10 },
      { "stone", 10 }
    },
    result_count = 10,
    result = "flux",
    allow_decomposition = false,
    enabled = false,
  },
  -- fluxed-iron-ore
  {
    type = "recipe",
    name = "fluxed-iron-ore",
    category = "coal-smelting",
    subgroup = "cokery",
    order = "g[fluxed-iron-ore]",
    energy_required = 2,
    ingredients = {
      { "iron-ore", 8 },
      { "flux", 2 }
    },
    result_count = 10,
    result = "fluxed-iron-ore",
    allow_decomposition = false,
    enabled = false,
  },
  -- fluxed-copper-ore
  {
    type = "recipe",
    name = "fluxed-copper-ore",
    category = "coal-smelting",
    subgroup = "cokery",
    order = "h[fluxed-copper-ore]",
    energy_required = 2,
    ingredients = {
      { "copper-ore", 8 },
      { "flux", 2 }
    },
    result_count = 10,
    result = "fluxed-copper-ore",
    allow_decomposition = false,
    enabled = false,
  },
  -- fluxed-steel
  {
    type = "recipe",
    name = "fluxed-iron",
    category = "coal-smelting",
    subgroup = "cokery",
    order = "i[fluxed-iron]",
    energy_required = 2,
    ingredients = {
      { "iron-plate", 8 },
      { "flux", 2 }
    },
    result_count = 2,
    result = "fluxed-iron",
    allow_decomposition = false,
    enabled = false,
  },
  {
    type = "recipe",
    name = "iron-plate-2",
    category = "smelting",
    subgroup = "green-smelting",
    order = "e[iron-plate-2]",
    energy_required = 2.8,
    ingredients = {{ "fluxed-iron-ore", 1 }},
    emissions_multiplier = 0.5,
    result = "iron-plate",
    enabled = false,
  },
  {
    type = "recipe",
    name = "copper-plate-2",
    category = "smelting",
    subgroup = "green-smelting",
    order = "f[copper-plate-2]",
    energy_required = 2.8,
    ingredients = {{ "fluxed-copper-ore", 1 }},
    emissions_multiplier = 0.5,
    result = "copper-plate",
    enabled = false,
  },
  {
    type = "recipe",
    name = "steel-plate-2",
    category = "smelting",
    subgroup = "green-smelting",
    order = "g[steel-plate-2]",
    energy_required = 14,
    ingredients = {{ "fluxed-iron", 1 }},
    emissions_multiplier = 0.5,
    result = "steel-plate",
    enabled = false,
  },
  -- coal
  {
    type = "recipe",
    name = "coal",
    category = "coal-smelting",
    subgroup = "cokery",
    order = "d[coal]",
    energy_required = 4,
    ingredients = {{ "wood", 10 }},
    result_count = 5,
    result = "coal",
    enabled = false,
  },
  -- purified-fuel
  {
    type = "recipe",
    name = "purified-fuel",
    category = "coal-smelting",
    subgroup = "cokery",
    order = "e[purified-fuel]",
    energy_required = 20,
    main_product = "purified-fuel",
    ingredients = {{ "coal", 25 }},
    results =
    {
      { "purified-fuel", 5 },
      { "ash", 20 }
    },
    always_show_products = true,
    enabled = false,
  },
  -- bio-fuel
  {
    type = "recipe",
    name = "bio-fuel",
    category = "chemistry",
    subgroup = "biomass",
    order = "d[bio-fuel]",
    energy_required = 20,
    emissions_multiplier = 0.2,
    ingredients = {
      { "purified-fuel", 25 },
      { type = "fluid", name = "biomass", amount = 50 },
      { type = "fluid", name = "nitrogen", amount = 100 }
    },
    crafting_machine_tint =
    {
      primary = coal_color,
      secondary = nitrogen_color,
      tertiary = bioamss_color,
      quaternary = biofuel_color,
    },
    results = {{ "bio-fuel", 25 }},
    enabled = false,
  },
  -- heavy oil from purified fuel
  {
    type = "recipe",
    name = "heavy-oil-from-purified-fuel",
    icon = icons.."heavy-oil-from-purified-fuel.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "chemistry",
    subgroup = "organic-materials",
    order = "g[heavy-oil-from-purified-fuel]",
    energy_required = 20,
    emissions_multiplier = 0.2,
    ingredients =
    {
      { type = "item", name = "purified-fuel", amount = 10 },
      { type = "fluid", name = "steam", amount = 100 }
    },
    results =
    {
      { type = "fluid", name = "heavy-oil", amount = 330 }
    },
    crafting_machine_tint =
    {
      primary = coal_color,
      secondary = steam_color,
      tertiary = heavy_oil_color,
      quaternary = heavy_oil_color
    },
    enabled = false,
  },
  -- air
  {
    type = "recipe",
    name = "air",
    icon = icons.."air.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "chemistry",
    subgroup = "green-chemistry",
    order = "a[air]",
    energy_required = 5,
    ingredients = { },
    results =
    {
      { type = "fluid", name = "air", amount = 10000 }
    },
    crafting_machine_tint =
    {
      primary = air_color,
      secondary = air_color,
      tertiary = air_color,
      quaternary = air_color
    },
    emissions_multiplier = 0.1,
    enabled = false,
  },
  -- nitrogen
  {
    type = "recipe",
    name = "nitrogen",
    icon = icons.."nitrogen.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "chemistry",
    subgroup = "green-chemistry",
    order = "b[nitrogen]",
    energy_required = 5,
    ingredients =
    {
      { type = "fluid", name = "air", amount = 2000 }
    },
    results =
    {
      { type = "fluid", name = "nitrogen", amount = 1000 },
    },
    crafting_machine_tint =
    {
      primary = air_color,
      secondary = air_color,
      tertiary = nitrogen_color,
      quaternary = nitrogen_color
    },
    emissions_multiplier = 0.1,
    enabled = false,
  },
  -- water
  {
    type = "recipe",
    name = "water-from-air",
    category = "chemistry",
    subgroup = "green-chemistry",
    order = "c[water-from-air]",
    energy_required = 1,
    ingredients =
    {
      { type = "fluid", name = "air", amount = 2000 }
    },
    results =
    {
      { type = "fluid", name = "water", amount = 200 }
    },
    crafting_machine_tint =
    {
      primary = air_color,
      secondary = air_color,
      tertiary = air_color,
      quaternary = water_color
    },
    emissions_multiplier = 0.1,
    enabled = false,
  },
  -- steam
  {
    type = "recipe",
    name = "steam-from-water",
    category = "chemistry",
    subgroup = "green-chemistry",
    order = "d[steam-from-water]",
    energy_required = 10,
    ingredients =
    {
      { type = "fluid", name = "water", amount = 100 }
    },
    results =
    {
      { type = "fluid", name = "steam", amount = 100, temperature = 120 }
    },
    crafting_machine_tint =
    {
      primary = water_color,
      secondary = water_color,
      tertiary = steam_color,
      quaternary = steam_color
    },
    emissions_multiplier = 0.1,
    enabled = false,
  },
  -- bio acid
  {
    type = "recipe",
    name = "organic-acid",
    category = "chemistry",
    subgroup = "green-chemistry",
    order = "e[organic-acid]",
    energy_required = 10,
    ingredients =
    {
      { type = "item", name = "sulfur", amount = 5 },
      { type = "fluid", name = "water", amount = 50 },
      { type = "fluid", name = "biomass", amount = 50 },
    },
    results =
    {
      { type = "fluid", name = "sulfuric-acid", amount = 50 },
    },
    crafting_machine_tint =
    {
      primary = sulfur_color,
      secondary = water_color,
      tertiary = bioamss_color,
      quaternary = sulfuric_acid_color
    },
    emissions_multiplier = 0.5,
    allow_decomposition = false,
    enabled = false,
  },
  -- base biomass
  {
    type = "recipe",
    name = "biomass",
    category = "chemistry",
    subgroup = "biomass",
    order = "a[biomass]",
    energy_required = 40,
    ingredients =
    {
      { type = "item", name = "raw-fish", amount = 10 },
      { type = "item", name = "gt-fertiliser", amount = 10 },
      { type = "fluid", name = "water", amount = 100 },
    },
    results =
    {
      { type = "fluid", name = "biomass", amount = 50 },
    },
    crafting_machine_tint =
    {
      primary = light_oil_color,
      secondary = sulfur_color,
      tertiary = water_color,
      quaternary = biomass_color
    },
    emissions_multiplier = -1,
    allow_decomposition = false,
    enabled = false,
  },
  -- biomass with ash
  {
    type = "recipe",
    name = "biomass-with-ash",
    category = "chemistry",
    subgroup = "biomass",
    order = "b[biomass-with-ash]",
    energy_required = 10,
    ingredients =
    {
      { type = "item", name = "ash", amount = 20 },
      { type = "fluid", name = "water", amount = 100 },
      { type = "fluid", name = "biomass", amount = 20 },
    },
    results =
    {
      { type = "fluid", name = "biomass", amount = 120 },
    },
    crafting_machine_tint =
    {
      primary = ash_color,
      secondary = water_color,
      tertiary = bioamss_color,
      quaternary = biomass_color
    },
    emissions_multiplier = -2,
    allow_decomposition = false,
    enabled = false,
  },
  -- biomass to heavy-oil
  {
    type = "recipe",
    name = "biomass-conversion",
    icon = icons.."biomass-conversion.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "chemistry",
    subgroup = "biomass",
    order = "c[biomass-conversion]",
    energy_required = 4,
    main_product = "petroleum-gas",
    ingredients =
    {
      { type = "fluid", name = "biomass", amount = 100 },
      { type = "fluid", name = "nitrogen", amount = 100 },
    },
    results =
    {
      { type = "fluid", name = "petroleum-gas", amount = 80 },
    },
    crafting_machine_tint =
    {
      primary = biomass_color,
      secondary = nitrogen_color,
      tertiary = petroleum_gas_color,
      quaternary = petroleum_gas_color
    },
    emissions_multiplier = 0.5,
    allow_decomposition = false,
    enabled = false,
  },
  -- sulfuric acid to sulfur
  {
    type = "recipe",
    name = "organic-sulfur",
    category = "chemistry",
    subgroup = "organic-materials",
    order = "a[organic-sulfur]",
    energy_required = 10,
    main_product = "sulfur",
    ingredients =
    {
      { type = "item", name = "woodpulp", amount = 20 },
      { type = "fluid", name = "sulfuric-acid", amount = 10 },
    },
    results =
    {
      { type = "item", name = "sulfur", amount = 10 }
    },
    crafting_machine_tint =
    {
      primary = woodpulp_color,
      secondary = sulfuric_acid_color,
      tertiary = sulfur_color,
      quaternary = sulfur_color
    },
    emissions_multiplier = 0.5,
    allow_decomposition = false,
    enabled = false,
  },
  -- fertiliser
  {
    type = "recipe",
    name = "gt-fertiliser",
    icon = icons.."fertiliser.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "chemistry",
    subgroup = "organic-materials",
    order = "b[gt-fertiliser]",
    energy_required = 5,
    overload_multiplier = 2,
    ingredients =
    {
      { type = "item", name = "sulfur", amount = 2 },
      { type = "item", name = "ash", amount = 20 },
      { type = "fluid", name = "nitrogen", amount = 200 },
    },
    results =
    {
      { type = "item", name = "gt-fertiliser", amount = 10 }
    },
    crafting_machine_tint =
    {
      primary = sulfur_color,
      secondary = ash_color,
      tertiary = nitrogen_color,
      quaternary = sulfur_color
    },
    enabled = false,
  },
  -- advanced fertiliser
  {
    type = "recipe",
    name = "advanced-fertiliser",
    icon = icons.."advanced-fertiliser.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "chemistry",
    subgroup = "organic-materials",
    order = "c[advanced-fertiliser]",
    energy_required = 10,
    overload_multiplier = 2,
    ingredients =
    {
      { type = "item", name = "woodpulp", amount = 20 },
      { type = "item", name = "gt-fertiliser", amount = 20 },
      { type = "fluid", name = "biomass", amount = 20 },
    },
    results =
    {
      { type = "item", name = "advanced-fertiliser", amount = 20 }
    },
    crafting_machine_tint =
    {
      primary = woodpulp_color,
      secondary = sulfur_color,
      tertiary = bioamss_color,
      quaternary = biomass_color
    },
    emissions_multiplier = 0.5,
    enabled = false,
  },
  -- cellulose
  {
    type = "recipe",
    name = "cellulose",
    icon = icons.."cellulose.png",
    icon_size = 64, icon_mipmaps = 4,
    category = "chemistry",
    subgroup = "organic-materials",
    order = "d[cellulose]",
    energy_required = 5,
    ingredients =
    {
      { type = "item", name = "woodpulp", amount = 10 },
      { type = "fluid", name = "water", amount = 20 },
      { type = "fluid", name = "sulfuric-acid", amount = 10 },
    },
    results =
    {
      { type = "item", name = "cellulose", amount = 10 }
    },
    crafting_machine_tint =
    {
      primary = woodpulp_color,
      secondary = water_color,
      tertiary = sulfuric_acid_color,
      quaternary = cellulose_color
    },
    allow_decomposition = false,
    enabled = false,
  },
  -- plastic from cellulose
  {
    type = "recipe",
    name = "organic-plastic",
    category = "chemistry",
    subgroup = "organic-materials",
    order = "e[organic-plastic]",
    energy_required = 1,
    ingredients =
    {
      { type = "item", name = "cellulose", amount = 2 },
      { type = "fluid", name = "petroleum-gas", amount = 10 },
    },
    results =
    {
      { type = "item", name = "plastic-bar", amount = 2 }
    },
    crafting_machine_tint =
    {
      primary = cellulose_color,
      secondary = petroleum_gas_color,
      tertiary = plastic_color,
      quaternary = plastic_color
    },
    emissions_multiplier = 0.5,
    allow_decomposition = false,
    enabled = false,
  },
  -- bio battery
  {
    type = "recipe",
    name = "organic-battery",
    category = "chemistry",
    subgroup = "organic-materials",
    order = "f[organic-battery]",
    energy_required = 5,
    ingredients =
    {
      { type = "item", name = "plastic-bar", amount = 2 },
      { type = "item", name = "cellulose", amount = 2 },
      { type = "fluid", name = "biomass", amount = 10 },
      { type = "fluid", name = "nitrogen", amount = 100 },
    },
    results =
    {
      { type = "item", name = "battery", amount = 1 },
    },
    crafting_machine_tint =
    {
      primary = plastic_color,
      secondary = nitrogen_color,
      tertiary = bioamss_color,
      quaternary = ash_color
    },
    emissions_multiplier = 0.5,
    allow_decomposition = false,
    enabled = false,
  },
})

