require( "prototypes.colors" )

local tile_transitions = require( "prototypes.tile-transitions" )
local concrete_tile_build_sounds = {
  small = {
    { filename = "__core__/sound/build-concrete-small.ogg", volume = 0.4 },
    { filename = "__core__/sound/build-concrete-small-1.ogg", volume = 0.4 },
    { filename = "__core__/sound/build-concrete-small-2.ogg", volume = 0.4 },
    { filename = "__core__/sound/build-concrete-small-3.ogg", volume = 0.4 },
    { filename = "__core__/sound/build-concrete-small-4.ogg", volume = 0.4 },
    { filename = "__core__/sound/build-concrete-small-5.ogg", volume = 0.4 }
  },
  medium = {
    { filename = "__core__/sound/build-concrete-medium.ogg", volume = 0.5 },
    { filename = "__core__/sound/build-concrete-medium-1.ogg", volume = 0.5 },
    { filename = "__core__/sound/build-concrete-medium-2.ogg", volume = 0.5 },
    { filename = "__core__/sound/build-concrete-medium-3.ogg", volume = 0.5 },
    { filename = "__core__/sound/build-concrete-medium-4.ogg", volume = 0.5 },
    { filename = "__core__/sound/build-concrete-medium-5.ogg", volume = 0.5 }
  },
  large = {
    { filename = "__core__/sound/build-concrete-large.ogg", volume = 0.5 },
    { filename = "__core__/sound/build-concrete-large-1.ogg", volume = 0.5 },
    { filename = "__core__/sound/build-concrete-large-2.ogg", volume = 0.5 },
    { filename = "__core__/sound/build-concrete-large-3.ogg", volume = 0.5 },
    { filename = "__core__/sound/build-concrete-large-4.ogg", volume = 0.5 },
    { filename = "__core__/sound/build-concrete-large-5.ogg", volume = 0.5 }
  },
}
local mined_sounds = { filename = "__base__/sound/deconstruct-bricks.ogg", volume = 0.64 }
local grass_sounds =
{
  {
    filename = "__base__/sound/walking/grass-01.ogg",
    volume = 0.8
  },
  {
    filename = "__base__/sound/walking/grass-02.ogg",
    volume = 0.8
  },
  {
    filename = "__base__/sound/walking/grass-03.ogg",
    volume = 0.8
  },
  {
    filename = "__base__/sound/walking/grass-04.ogg",
    volume = 0.8
  },
  {
    filename = "__base__/sound/walking/grass-05.ogg",
    volume = 0.8
  },
  {
    filename = "__base__/sound/walking/grass-06.ogg",
    volume = 0.8
  },
  {
    filename = "__base__/sound/walking/grass-07.ogg",
    volume = 0.8
  },
  {
    filename = "__base__/sound/walking/grass-08.ogg",
    volume = 0.8
  },
  {
    filename = "__base__/sound/walking/grass-09.ogg",
    volume = 0.8
  },
  {
    filename = "__base__/sound/walking/grass-10.ogg",
    volume = 0.8
  }
}
local refined_concrete_sounds =
{
  {
    filename = "__base__/sound/walking/refined-concrete-01.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/walking/refined-concrete-02.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/walking/refined-concrete-03.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/walking/refined-concrete-04.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/walking/refined-concrete-05.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/walking/refined-concrete-06.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/walking/refined-concrete-07.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/walking/refined-concrete-08.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/walking/refined-concrete-09.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/walking/refined-concrete-10.ogg",
    volume = 0.5
  },
  {
    filename = "__base__/sound/walking/refined-concrete-11.ogg",
    volume = 0.5
  }
}

data.raw[ "tile" ][ "grass-4" ].build_sound = concrete_tile_build_sounds

data:extend({
  -- seedling landfill
  {
    name = "seedling-landfill",
    type = "tile",
    collision_mask = { "ground-tile" },
    layer = 26,
    variants = tile_variations_template(
      "__base__/graphics/terrain/grass-1.png", "__base__/graphics/terrain/masks/transition-3.png",
      "__base__/graphics/terrain/hr-grass-1.png", "__base__/graphics/terrain/masks/hr-transition-3.png",
      {
        max_size = 4,
        [ 1 ] = { weights = { 0.085, 0.085, 0.085, 0.085, 0.087, 0.085, 0.065, 0.085, 0.045, 0.045, 0.045, 0.045, 0.005, 0.025, 0.045, 0.045 }},
        [ 2 ] = { probability = 0.91, weights = { 0.150, 0.150, 0.150, 0.150, 0.018, 0.020, 0.015, 0.025, 0.015, 0.020, 0.025, 0.015, 0.025, 0.025, 0.010, 0.025 }, },
        [ 4 ] = { probability = 0.91, weights = { 0.100, 0.80, 0.80, 0.100, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01 }, },
      }
    ),
    
    transitions = grass_transitions,
    transitions_between_transitions = grass_transitions_between_transitions,
    map_color = { r = 0.2, g = 0.2, b = 0.1 },
    pollution_absorption_per_second = 0.0001,
    build_sound = concrete_tile_build_sounds,
  },
  -- absorbtion brick
  {
    type = "tile",
    name = "absorbtion-bricks",
    needs_correction = false,
    flags = { "placeable-neutral", "breaths-air" },
    minable = { mining_time = 0.1, result = "absorbtion-brick" },
    mined_sound = mined_sounds,
    collision_mask = { "ground-tile" },
    walking_speed_modifier = 1.2,
    layer = 60,
    decorative_removal_probability = 0,
    variants =
    {
      main =
      {
        {
          picture = "__base__/graphics/terrain/stone-path/stone-path-1.png",
          count = 16,
          size = 1,
          hr_version =
          {
            picture = "__base__/graphics/terrain/stone-path/hr-stone-path-1.png",
            count = 16,
            size = 1,
            scale = 0.5
          }
        },
        {
          picture = "__base__/graphics/terrain/stone-path/stone-path-2.png",
          count = 16,
          size = 2,
          probability = 0.39,
          hr_version =
          {
            picture = "__base__/graphics/terrain/stone-path/hr-stone-path-2.png",
            count = 16,
            size = 2,
            probability = 0.39,
            scale = 0.5
          }
        },
        {
          picture = "__base__/graphics/terrain/stone-path/stone-path-4.png",
          count = 16,
          size = 4,
          probability = 1,
          hr_version =
          {
            picture = "__base__/graphics/terrain/stone-path/hr-stone-path-4.png",
            count = 16,
            size = 4,
            probability = 1,
            scale = 0.5
          }
        }
      },
      inner_corner =
      {
        picture = "__base__/graphics/terrain/stone-path/stone-path-inner-corner.png",
        count = 16,
        tall = true,
        hr_version =
        {
          picture = "__base__/graphics/terrain/stone-path/hr-stone-path-inner-corner.png",
          count = 16,
          tall = true,
          scale = 0.5
        }
      },
      outer_corner =
      {
        picture = "__base__/graphics/terrain/stone-path/stone-path-outer-corner.png",
        count = 8,
        tall = true,
        hr_version =
        {
          picture = "__base__/graphics/terrain/stone-path/hr-stone-path-outer-corner.png",
          count = 8,
          tall = true,
          scale = 0.5
        }
      },
      side =
      {
        picture = "__base__/graphics/terrain/stone-path/stone-path-side.png",
        count = 16,
        tall = true,
        hr_version =
        {
          picture = "__base__/graphics/terrain/stone-path/hr-stone-path-side.png",
          count = 16,
          tall = true,
          scale = 0.5
        }
      },
      u_transition =
      {
        picture = "__base__/graphics/terrain/stone-path/stone-path-u.png",
        count = 8,
        tall = true,
        hr_version =
        {
          picture = "__base__/graphics/terrain/stone-path/hr-stone-path-u.png",
          count = 8,
          tall = true,
          scale = 0.5
        }
      },
      o_transition =
      {
        picture = "__base__/graphics/terrain/stone-path/stone-path-o.png",
        count = 4,
        hr_version =
        {
          picture = "__base__/graphics/terrain/stone-path/hr-stone-path-o.png",
          count = 4,
          scale = 0.5
        }
      }
    },
    transitions = tile_transitions.organic_transitions( ),
    transitions_between_transitions = tile_transitions.organic_transitions_between_transitions( ),
    walking_sound = grass_sounds,
    tint = color,
    map_color = map_color,
    pollution_absorption_per_second = 0.001,
    build_sound = concrete_tile_build_sounds,
    vehicle_friction_modifier = 1.6,
  },
  --
  {
    type = "tile",
    name = "organic-concrete",
    flags = { "placeable-neutral", "breaths-air" },
    needs_correction = false,
    next_direction = "hazard-organic-concrete-left",
    minable = { mining_time = 0.1, result = "organic-concrete" },
    mined_sound = mined_sounds,
    collision_mask = { "ground-tile" },
    walking_speed_modifier = 1.3,
    layer = 61,
    transition_overlay_layer_offset = 2, -- need to render border overlay on top of hazard-concrete
    decorative_removal_probability = 0,
    variants =
    {
      main =
      {
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 1
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 2,
          probability = 0.39
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 4,
          probability = 1
        }
      },
      inner_corner =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-inner-corner.png",
        count = 16,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-inner-corner.png",
          count = 16,
          scale = 0.5
        }
      },
      inner_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-inner-corner-mask.png",
        count = 16,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-inner-corner-mask.png",
          count = 16,
          scale = 0.5
        }
      },
      
      outer_corner =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-outer-corner.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-outer-corner.png",
          count = 8,
          scale = 0.5
        }
      },
      outer_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-outer-corner-mask.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-outer-corner-mask.png",
          count = 8,
          scale = 0.5
        }
      },
      
      side =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-side.png",
        count = 16,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-side.png",
          count = 16,
          scale = 0.5
        }
      },
      side_mask =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-side-mask.png",
        count = 16,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-side-mask.png",
          count = 16,
          scale = 0.5
        }
      },
      
      u_transition =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-u.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-u.png",
          count = 8,
          scale = 0.5
        }
      },
      u_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-u-mask.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-u-mask.png",
          count = 8,
          scale = 0.5
        }
      },
      
      o_transition =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-o.png",
        count = 4,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-o.png",
          count = 4,
          scale = 0.5
        }
      },
      o_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-o-mask.png",
        count = 4,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-o-mask.png",
          count = 4,
          scale = 0.5
        }
      },
      
      material_background =
      {
        picture = "__base__/graphics/terrain/concrete/concrete.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete.png",
          count = 8,
          scale = 0.5
        }
      }
    },
    
    transitions = tile_transitions.organic_transitions( ),
    transitions_between_transitions = tile_transitions.organic_transitions_between_transitions( ),
    walking_sound = grass_sounds,
    tint = color,
    map_color = map_color,
    pollution_absorption_per_second = 0.002,
    build_sound = concrete_tile_build_sounds,
    vehicle_friction_modifier = 1.4
  },
  --
  {
    type = "tile",
    name = "hazard-organic-concrete-left",
    flags = { "placeable-neutral", "breaths-air" },
    needs_correction = false,
    next_direction = "hazard-organic-concrete-right",
    transition_merges_with_tile = "organic-concrete",
    minable = { mining_time = 0.1, result = "organic-concrete" },
    mined_sound = mined_sounds,
    collision_mask = { "ground-tile" },
    walking_speed_modifier = 1.2,
    layer = 62,
    decorative_removal_probability = 1,
    variants =
    {
      main =
      {
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 1
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 2,
          probability = 0.39
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 4,
          probability = 1
        }
      },
      
      inner_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-inner-corner-mask.png",
        count = 1,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-hazard-concrete-inner-corner-mask.png",
          count = 1,
          scale = 0.5
        }
      },
      outer_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-outer-corner-mask.png",
        count = 1,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-hazard-concrete-outer-corner-mask.png",
          count = 1,
          scale = 0.5
        }
      },
      
      side_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-side-mask.png",
        count = 1,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-hazard-concrete-side-mask.png",
          count = 1,
          scale = 0.5
        }
      },
      
      u_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-u-mask.png",
        count = 1,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-hazard-concrete-u-mask.png",
          count = 1,
          scale = 0.5
        }
      },
      
      o_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-o-mask.png",
        count = 1,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-hazard-concrete-o-mask.png",
          count = 1,
          scale = 0.5
        }
      },
      
      material_background =
      {
        picture = "__base__/graphics/terrain/hazard-concrete-left/hazard-concrete-left.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/hazard-concrete-left/hr-hazard-concrete-left.png",
          count = 8,
          scale = 0.5
        }
      }
    },
    walking_sound = refined_concrete_sounds,
    tint = color,
    map_color = map_hazard_color,
    pollution_absorption_per_second = 0.002,
    build_sound = concrete_tile_build_sounds,
    vehicle_friction_modifier = 20
  },
  --
  {
    type = "tile",
    name = "hazard-organic-concrete-right",
    flags = { "placeable-neutral", "breaths-air" },
    needs_correction = false,
    next_direction = "organic-concrete",
    transition_merges_with_tile = "organic-concrete",
    minable = { mining_time = 0.1, result = "organic-concrete" },
    mined_sound = mined_sounds,
    collision_mask = { "ground-tile" },
    walking_speed_modifier = 1.2,
    layer = 62,
    decorative_removal_probability = 1,
    variants =
    {
      main =
      {
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 1
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 2,
          probability = 0.39
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 4,
          probability = 1
        }
      },
      inner_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-inner-corner-mask.png",
        count = 1
      },
      outer_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-outer-corner-mask.png",
        count = 1
      },
      
      side_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-side-mask.png",
        count = 1
      },
      
      u_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-u-mask.png",
        count = 1
      },
      
      o_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-o-mask.png",
        count = 1
      },
      
      material_background =
      {
        picture = "__base__/graphics/terrain/hazard-concrete-right/hazard-concrete-right.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/hazard-concrete-right/hr-hazard-concrete-right.png",
          count = 8,
          scale = 0.5
        }
      }
    },
    walking_sound = refined_concrete_sounds,
    tint = color,
    map_color = map_hazard_color,
    pollution_absorption_per_second = 0.002,
    build_sound = concrete_tile_build_sounds,
    vehicle_friction_modifier = 20
  },
  --
  {
    type = "tile",
    name = "refined-organic-concrete",
    flags = { "placeable-neutral" },
    needs_correction = false,
    next_direction = "refined-hazard-organic-concrete-left",
    minable = { mining_time = 0.1, result = "refined-organic-concrete" },
    mined_sound = mined_sounds,
    collision_mask = { "ground-tile" },
    walking_speed_modifier = 1.4,
    layer = 64,
    transition_overlay_layer_offset = 2, -- need to render border overlay on top of hazard-concrete
    decorative_removal_probability = 0,
    variants =
    {
      main =
      {
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 1
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 2,
          probability = 0.39
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 4,
          probability = 1
        }
      },
      inner_corner =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-inner-corner.png",
        count = 16,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-inner-corner.png",
          count = 16,
          scale = 0.5
        }
      },
      inner_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-inner-corner-mask.png",
        count = 16,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-inner-corner-mask.png",
          count = 16,
          scale = 0.5
        }
      },
      
      outer_corner =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-outer-corner.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-outer-corner.png",
          count = 8,
          scale = 0.5
        }
      },
      outer_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-outer-corner-mask.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-outer-corner-mask.png",
          count = 8,
          scale = 0.5
        }
      },
      
      side =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-side.png",
        count = 16,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-side.png",
          count = 16,
          scale = 0.5
        }
      },
      side_mask =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-side-mask.png",
        count = 16,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-side-mask.png",
          count = 16,
          scale = 0.5
        }
      },
      
      u_transition =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-u.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-u.png",
          count = 8,
          scale = 0.5
        }
      },
      u_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-u-mask.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-u-mask.png",
          count = 8,
          scale = 0.5
        }
      },
      
      o_transition =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-o.png",
        count = 4,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-o.png",
          count = 4,
          scale = 0.5
        }
      },
      o_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/concrete-o-mask.png",
        count = 4,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-concrete-o-mask.png",
          count = 4,
          scale = 0.5
        }
      },
      
      material_background =
      {
        picture = "__base__/graphics/terrain/concrete/refined-concrete.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-refined-concrete.png",
          count = 8,
          scale = 0.5
        }
      }
    },
    
    transitions = tile_transitions.organic_transitions( ),
    transitions_between_transitions = tile_transitions.organic_transitions_between_transitions( ),
    walking_sound = grass_sounds,
    tint = color,
    map_color = map_color,
    pollution_absorption_per_second = 0.004,
    build_sound = concrete_tile_build_sounds,
    vehicle_friction_modifier = 1.2
  },
  {
    type = "tile",
    name = "refined-hazard-organic-concrete-left",
    flags = { "placeable-neutral" },
    needs_correction = false,
    next_direction = "refined-hazard-organic-concrete-right",
    transition_merges_with_tile = "refined-organic-concrete",
    minable = { mining_time = 0.1, result = "refined-organic-concrete" },
    mined_sound = mined_sounds,
    collision_mask = { "ground-tile" },
    walking_speed_modifier = 1.4,
    layer = 65,
    decorative_removal_probability = 1,
    variants =
    {
      main =
      {
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 1
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 2,
          probability = 0.39
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 4,
          probability = 1
        }
      },
      
      inner_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-inner-corner-mask.png",
        count = 1,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-hazard-concrete-inner-corner-mask.png",
          count = 1,
          scale = 0.5
        }
      },
      outer_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-outer-corner-mask.png",
        count = 1,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-hazard-concrete-outer-corner-mask.png",
          count = 1,
          scale = 0.5
        }
      },
      
      side_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-side-mask.png",
        count = 1,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-hazard-concrete-side-mask.png",
          count = 1,
          scale = 0.5
        }
      },
      
      u_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-u-mask.png",
        count = 1,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-hazard-concrete-u-mask.png",
          count = 1,
          scale = 0.5
        }
      },
      
      o_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-o-mask.png",
        count = 1,
        hr_version =
        {
          picture = "__base__/graphics/terrain/concrete/hr-hazard-concrete-o-mask.png",
          count = 1,
          scale = 0.5
        }
      },
      
      material_background =
      {
        picture = "__base__/graphics/terrain/hazard-concrete-left/refined-hazard-concrete-left.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/hazard-concrete-left/hr-refined-hazard-concrete-left.png",
          count = 8,
          scale = 0.5
        }
      }
    },
    walking_sound = refined_concrete_sounds,
    tint = color,
    map_color = map_hazard_color,
    pollution_absorption_per_second = 0.004,
    build_sound = concrete_tile_build_sounds,
    vehicle_friction_modifier = 20
  },
  {
    type = "tile",
    name = "refined-hazard-organic-concrete-right",
    flags = { "placeable-neutral" },
    needs_correction = false,
    next_direction = "refined-organic-concrete",
    transition_merges_with_tile = "refined-organic-concrete",
    minable = { mining_time = 0.1, result = "refined-organic-concrete" },
    mined_sound = mined_sounds,
    collision_mask = { "ground-tile" },
    walking_speed_modifier = 1.4,
    layer = 65,
    decorative_removal_probability = 1,
    variants =
    {
      main =
      {
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 1
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 2,
          probability = 0.39
        },
        {
          picture = "__base__/graphics/terrain/concrete/concrete-dummy.png",
          count = 1,
          size = 4,
          probability = 1
        }
      },
      inner_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-inner-corner-mask.png",
        count = 1
      },
      outer_corner_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-outer-corner-mask.png",
        count = 1
      },
      
      side_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-side-mask.png",
        count = 1
      },
      
      u_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-u-mask.png",
        count = 1
      },
      
      o_transition_mask =
      {
        picture = "__base__/graphics/terrain/concrete/hazard-concrete-o-mask.png",
        count = 1
      },
      
      material_background =
      {
        picture = "__base__/graphics/terrain/hazard-concrete-right/refined-hazard-concrete-right.png",
        count = 8,
        hr_version =
        {
          picture = "__base__/graphics/terrain/hazard-concrete-right/hr-refined-hazard-concrete-right.png",
          count = 8,
          scale = 0.5
        }
      }
    },
    walking_sound = refined_concrete_sounds,
    tint = color,
    map_color = map_hazard_color,
    pollution_absorption_per_second = 0.004,
    build_sound = concrete_tile_build_sounds,
    vehicle_friction_modifier = 20
  },
})
