--------------------------------------------------
-- created by sanagi
-- https://www.nexusmods.com/monsterhunterrise/mods/1325?tab=description
--------------------------------------------------
-- updates
-- 2022-08-05	ver1.0	Initial version. Supported for Insect Glaive and Bow.
-- 2022-08-06	ver1.1	Newly supports GreatSword and LongSword. Newly supporting for Training Area.
-- 2022-08-07	ver1.11	Bug: shows only in training area. -> comment outed the issue part witch judging training area.
-- 2022-08-07	ver1.12	Bug Fixed. Can use in training area (truely). Newly supports Hunting Horn.
-- 2022-08-08	ver1.4	Newly supported SwordShield, Dual Blades, Hammer, SwitchAxe, Lance, GunLance.
--------------------------------------------------


local folderName = "DetailedBuffs"
local modUtils = require(folderName .. "/mod_utils")

local player = modUtils.getCurrentPlayer()
local playerActionField = modUtils.getType("snow.player.PlayerBase"):get_field("<RefPlayerAction>k__BackingField");

local weaponType = nil
local weaponFlagField = modUtils.getType("snow.player.PlayerAction"):get_field("_weaponFlag");
local weaponTypeField = modUtils.getType("snow.player.PlayerBase"):get_field("_playerWeaponType");

-- Weapons
-- GS
local GS_chargeLv        = 0
local GS_PowerSheatheSec = 0.0

-- SAxe
local SA_SwitchGauge = 0
local SA_AmpGauge    = 0
local SA_AmpBuffSec  = 0.0

-- LS
local LS_SpiritGaugeLevel    = 0
local LS_SpiritGaugeLevelSec = 0.0
local LS_SpiritGaugeSec      = 0.0

-- Hammer
local HM_ChargeLevel    = 0
local HM_ImpactPullsSec = 0.0

-- GunLance
local GL_ChargeDragonSlayCannonTime = 0.0
local GL_ShotDamageUpDurationTimer  = 0.0
local GL_ExplodePileBuffTimer       = 0.0

-- Lance
local LA_ChargePowerUp   = nil
local LA_GuardRageBuffLv = 0
local LA_GuardRageTimer  = 0.0
local LA_RutenBuffTimer  = 0.0

--SSword
local SS_OilBuff = 0.0

-- DBlades
local DB_KijinKyoukaGuage         = 0.0
local DB_SharpnessRecoveryBuffSec = 0.0

-- Horn
local HH_InfernalGuage  = 0
local HH_ShockwaveTimer = 0.0

-- IG
local redExtractField    = modUtils.getType("snow.player.InsectGlaive"):get_field("_RedExtractiveTime");
local whiteExtractField  = modUtils.getType("snow.player.InsectGlaive"):get_field("_WhiteExtractiveTime");
local orangeExtractField = modUtils.getType("snow.player.InsectGlaive"):get_field("_OrangeExtractiveTime");
local redExtractTime     = nil
local whiteExtractTime   = nil
local orangeExtractTime  = nil
local fullExtractSec   = 0.0
local redExtractSec    = 0.0
local whiteExtractSec  = 0.0
local orangeExtractSec = 0.0

-- Bow
local chargeLv     = 0
local wireBuffSec  = 0.0
local arrowBuffSec = 0.0


local line_count = 0

local settings = {
    bg = true,
    bg_color = 2248146944.0,
    border_color = 3366295651.0,
    color = 4291480266.0,
    show = true,

	show_GS_chargeLv = true,
	show_GS_PowerSheatheSec = true,

	show_SA_SwitchGauge = true,
	show_SA_AmpGauge    = true,
	show_SA_AmpBuffSec  = true,

	show_LS_SpiritGaugeLevel = true,
	show_LS_SpiritGaugeLevelSec = true,
	show_LS_SpiritGaugeSec = true,

	show_HM_ChargeLevel    = true,
	show_HM_ImpactPullsSec = true,

	show_GL_ChargeDragonSlayCannonTime = true,
	show_GL_ShotDamageUpDurationTimer  = true,
	show_GL_ExplodePileBuffTimer       = true,

	show_LA_ChargePowerUp   = true,
	show_LA_GuardRageBuffLv = true,
	show_LA_GuardRageTimer  = true,
	show_LA_RutenBuffTimer  = true,

	show_SS_OilBuff = true,

	show_DB_KijinKyoukaGuage         = true,
	show_DB_SharpnessRecoveryBuffSec = true,

	show_HH_InfernalGuage  = true,
	show_HH_ShockwaveTimer = true,

    show_full = true,
    show_red = true,
    show_orange = true,
    show_white = true,

    show_arrowbuff = true,
    show_chlv = true,
    show_wirebuff = true,

    size = 20.0,
    xpos = 564.0,
    ypos = 117.0
}



local function load_settings()
    local l_settings = json.load_file('DetailedBuffs_settings.json')
    if l_settings then
        settings = l_settings
    end
end

load_settings()

local function assertSafety(obj, objName)
    if obj:get_reference_count() == 1 then
        modUtils.info(objName .. " was disposed by the game, breaking")
        error("")
    end
end

local function resetSavedValues()
	--GS
	GS_chargeLv        = 0
	GS_PowerSheatheSec = 0.0
	-- SAxe
	SA_SwitchGauge = 0
	SA_AmpGauge    = 0
	SA_AmpBuffSec  = 0.0
	-- LS
	LS_SpiritGaugeLevel    = 0
	LS_SpiritGaugeLevelSec = 0.0
	LS_SpiritGaugeSec      = 0.0
	-- Hammer
	HM_ChargeLevel    = 0
	HM_ImpactPullsSec = 0.0

	-- GunLance
	GL_ChargeDragonSlayCannonTime = 0.0
	GL_ShotDamageUpDurationTimer  = 0.0
	GL_ExplodePileBuffTimer       = 0.0

	-- Lance
	LA_ChargePowerUp   = nil
	LA_GuardRageBuffLv = 0
	LA_GuardRageTimer  = 0.0
	LA_RutenBuffTimer  = 0.0
	--SSword
	SS_OilBuff = 0.0
	-- DBlades
	DB_KijinKyoukaGuage         = 0.0
	DB_SharpnessRecoveryBuffSec = 0.0
	-- Horn
	HH_InfernalGuage  = 0
	HH_ShockwaveTimer = 0.0
	-- IG
	redExtractTime    = nil
	whiteExtractTime  = nil
	orangeExtractTime = nil
	fullExtractSec   = 0.0
	redExtractSec    = 0.0
	whiteExtractSec  = 0.0
	orangeExtractSec = 0.0
	-- Bow
	chargeLv     = 0
	wireBuffSec  = 0.0
	arrowBuffSec = 0.0
end

local function get_questman()
    if not questman then
        questman = sdk.get_managed_singleton('snow.QuestManager')
    end
    return questman
end
local function get_quest_status()
    return get_questman():get_field("_QuestStatus")
end
local function get_quest_endflow()
    return get_questman():get_field("_EndFlow")
end

local function get_weapon()
	assertSafety(player, "player")
	weaponType = weaponTypeField:get_data(player)
	if weaponType == 0 or weaponType == 1 or weaponType == 2 or weaponType == 5 or weaponType == 6 or weaponType == 7 or weaponType == 8 or weaponType == 9 or weaponType == 10 or weaponType == 12 or weaponType == 13 then
		-- 0 :GreatSword
		-- 1 :SlashAxe
		-- 2 :LongSword
		-- 3 :LightBowgun
		-- 4 :HeavyBowgun
		-- 5 :Hammer
		-- 6 :GunLance
		-- 7 :Lance
		-- 8 :Sword and Shield
		-- 9 :DualBlade
		-- 10:HuntingHorn
		-- 11:ChargeBlade
		-- 12:InsectGlaive
		-- 13:Bow
		return
	else
	    resetSavedValues()
	    return
	end
end

re.on_frame(function()
	player = modUtils.getCurrentPlayer()

	if player ~= nil then
		get_weapon()

		-- GreatSword
		if weaponType == 0 then
	    	-- tameLvTimeTbl, tameLvTimeTblJump, _tameTimer
	    	GS_chargeLv        = modUtils.getType("snow.player.GreatSword"):get_field("_TameLv"):get_data(player)
	    	GS_PowerSheatheSec = math.floor(modUtils.getType("snow.player.GreatSword"):get_field("MoveWpOffBuffGreatSwordTimer"):get_data(player)/60 *10)/10
		-- SAxe
		elseif weaponType == 1 then
			-- ken Gauge
			SA_SwitchGauge = modUtils.getType("snow.player.SlashAxe"):get_field("_BottleGauge"):get_data(player)
			-- kakusei gauge
			SA_AmpGauge    = math.floor(modUtils.getType("snow.player.SlashAxe"):get_field("_BottleAwakeGauge"):get_data(player) *10)/10
			-- kakusei time now
			SA_AmpBuffSec  = math.floor(modUtils.getType("snow.player.SlashAxe"):get_field("_BottleAwakeDurationTimer"):get_data(player)/60 *10)/10
	    -- LS
		elseif weaponType == 2 then
			-- engetu nai
			-- Kijin Lv
			LS_SpiritGaugeLevel = modUtils.getType("snow.player.LongSword"):get_field("_LongSwordGaugeLv"):get_data(player)
			-- Kijin Sec
			LS_SpiritGaugeLevelSec = math.floor(modUtils.getType("snow.player.LongSword"):get_field("_LongSwordGaugeLvTimer"):get_data(player)/60 *10)/10

			local LS_SpiritGauge = modUtils.getType("snow.player.LongSword"):get_field("_LongSwordGauge"):get_data(player)
			local LS_SpiritGaugeTimer = modUtils.getType("snow.player.LongSword"):get_field("_LongSwordGaugeTimer"):get_data(player)/60
			if LS_SpiritGauge == 0 then
				LS_SpiritGaugeSec = 0.0
			else
				-- convert value to time
				LS_SpiritGaugeSec = math.floor((LS_SpiritGauge + LS_SpiritGaugeTimer)*10 )/10 -1
			end
		-- Hammer
		elseif weaponType == 5 then
			HM_ChargeLevel    = modUtils.getType("snow.player.Hammer"):get_field("<NowChargeLevel>k__BackingField"):get_data(player)
			HM_ImpactPullsSec = math.floor(modUtils.getType("snow.player.Hammer"):get_field("_ImpactPullsTimer"):get_data(player)/60 *10)/10
		-- GunLance
		elseif weaponType == 6 then
			GL_ChargeDragonSlayCannonTime = math.floor(modUtils.getType("snow.player.GunLance"):get_method("get_ChargeDragonSlayCannonTime"):call(player) *10)/10
			if GL_ChargeDragonSlayCannonTime == 0 then
				GL_ChargeDragonSlayCannonTime = "Ready!"
			end
			GL_ShotDamageUpDurationTimer = math.floor(modUtils.getType("snow.player.GunLance"):get_field("_ShotDamageUpDurationTimer"):get_data(player)/60 *10)/10
			GL_ExplodePileBuffTimer = math.floor(modUtils.getType("snow.player.GunLance"):get_field("_ExplodePileBuffTimer"):get_data(player)/60 *10)/10
		-- Lance
		elseif weaponType == 7 then
			-- ChainDeathMatch
			LA_ChargePowerUp    = 0.0
			local LA_ChargePowerUp_flg = modUtils.getType("snow.player.Lance"):get_field("_IsChargePowerUp"):get_data(player)
			local LA_ChargeTime        = modUtils.getType("snow.player.Lance"):get_field("_ChargeTime"):get_data(player)/60
			local LA_ChargePowerUpTime = modUtils.getType("snow.player.Lance"):get_field("_ChargePowerUpTime"):get_data(player)/60
			-- charge
			if LA_ChargePowerUp_flg or (LA_ChargePowerUpTime - LA_ChargeTime)<0 then
				LA_ChargePowerUp = "Ready!"
			else
				LA_ChargePowerUp = math.floor( (LA_ChargePowerUpTime - LA_ChargeTime) *10)/10
			end
			-- Buffs
			LA_GuardRageBuffLv   = modUtils.getType("snow.player.Lance"):get_field("_GuardRageBuffType"):get_data(player)
			LA_GuardRageTimer    = math.floor(modUtils.getType("snow.player.Lance"):get_field("_GuardRageTimer"):get_data(player)/60 *10)/10
			LA_RutenBuffTimer    = math.floor(modUtils.getType("snow.player.Lance"):get_field("_RutenTimer"):get_data(player)/60 *10)/10
		--SSword
		elseif weaponType == 8 then
			SS_OilBuff = math.floor(modUtils.getType("snow.player.ShortSword"):get_method("get_OilBuffTimer"):call(player)/60 *10)/10
		-- DBlades
		elseif weaponType == 9 then
			-- miss spell with Gauge :(
			DB_KijinKyoukaGuage         = math.floor(modUtils.getType("snow.player.DualBlades"):get_field("<KijinKyoukaGuage>k__BackingField"):get_data(player) *10)/10
			DB_SharpnessRecoveryBuffSec = math.floor(modUtils.getType("snow.player.DualBlades"):get_field("SharpnessRecoveryBuffValidTimer"):get_data(player)/60 *10)/10
		-- HHorn
		elseif weaponType == 10 then
			--BlastSpeaker, BlastSepeaker, Revolt, Music
	    	-- kien
	    	HH_InfernalGuage  = math.floor(modUtils.getType("snow.player.Horn"):get_field("<RevoltGuage>k__BackingField"):get_data(player))
			-- kyouda
	    	HH_ShockwaveTimer = math.floor(modUtils.getType("snow.player.Horn"):get_field("_ImpactPullsTimer"):get_data(player) /60 *10)/10
		-- IG
		elseif weaponType == 12 then
	        redExtractTime = redExtractField:get_data(player)
	        whiteExtractTime = whiteExtractField:get_data(player)
	        orangeExtractTime = orangeExtractField:get_data(player)

	        redExtractSec = math.floor(redExtractTime/60 *10)/10
	        whiteExtractSec = math.floor(whiteExtractTime/60 *10)/10
	        orangeExtractSec = math.floor(orangeExtractTime/60 *10)/10

	        fullflg = redExtractSec * whiteExtractSec * orangeExtractSec

	        if fullflg > 0 then
	        	fullExtractSec = redExtractSec
	        else
	        	fullExtractSec = 0.0
	        end
	    -- Bow
	    elseif weaponType == 13 then
	    	chargeLv  = modUtils.getType("snow.player.Bow"):get_method("get_ChargeLv"):call(player)
	    	local wireBuffTime  = modUtils.getType("snow.player.Bow"):get_field("_WireBuffAttackUpTimer"):get_data(player)
	    	local arrowBuffTime = modUtils.getType("snow.player.Bow"):get_field("_WireBuffArrowUpTimer"):get_data(player)
	    	wireBuffSec  = math.floor(wireBuffTime/60 *10)/10
	    	arrowBuffSec = math.floor(arrowBuffTime/60 *10)/10
	    end
    else
        resetSavedValues()
    end
end)

local function check_for_line(str)
    if line_count > 0 then
        return str .. '\n'
    else
        return str
    end
end

local function get_string()
    local string_ = ''
    -- GS
    if weaponType == 0 then
    	if settings.show_GS_chargeLv then
			string_ = check_for_line(string_) .. "ChargeLv      :" .. GS_chargeLv
			line_count = line_count + 1
		end
		if settings.show_GS_PowerSheatheSec then
			string_ = check_for_line(string_) .. "PowerSheathe  :" .. GS_PowerSheatheSec
			line_count = line_count + 1
		end
	-- SAxe
	elseif weaponType == 1 then
		if settings.show_SA_SwitchGauge then
			string_ = check_for_line(string_) .. "SwitchGauge :" .. SA_SwitchGauge
			line_count = line_count + 1
		end
		if settings.show_SA_AmpGauge then
			string_ = check_for_line(string_) .. "AmpGauge    :" .. SA_AmpGauge
			line_count = line_count + 1
		end
		if settings.show_SA_AmpBuffSec then
			string_ = check_for_line(string_) .. "AmpBuffSec  :" .. SA_AmpBuffSec
			line_count = line_count + 1
		end
	-- LS
    elseif weaponType == 2 then
	    if settings.show_LS_SpiritGaugeLevel then
	        string_ = check_for_line(string_) .. "SGLevel :" .. LS_SpiritGaugeLevel
	        line_count = line_count + 1
	    end
	    if settings.show_LS_SpiritGaugeLevelSec then
	        string_ = check_for_line(string_) .. "SGLvSec :" .. LS_SpiritGaugeLevelSec
	        line_count = line_count + 1
	    end
	    if settings.show_LS_SpiritGaugeSec then
	        string_ = check_for_line(string_) .. "SGSec   :" .. LS_SpiritGaugeSec
	        line_count = line_count + 1
	    end
	-- Hammer
	elseif weaponType == 5 then
	    if settings.show_HM_ChargeLevel then
	        string_ = check_for_line(string_) .. "ChargeLv   :" .. HM_ChargeLevel
	        line_count = line_count + 1
	    end
	    if settings.show_HM_ImpactPullsSec then
	        string_ = check_for_line(string_) .. "ImpactBuff :" .. HM_ImpactPullsSec
	        line_count = line_count + 1
	    end
	-- GunLance
	elseif weaponType == 6 then
		if settings.show_GL_ChargeDragonSlayCannonTime then
	        string_ = check_for_line(string_) .. "WyvernCannon :" .. GL_ChargeDragonSlayCannonTime
	        line_count = line_count + 1
	    end
	    if settings.show_GL_ShotDamageUpDurationTimer then
	        string_ = check_for_line(string_) .. "GSplitter    :" .. GL_ShotDamageUpDurationTimer
	        line_count = line_count + 1
	    end
	    if settings.show_GL_ExplodePileBuffTimer then
	        string_ = check_for_line(string_) .. "ECannon      :" .. GL_ExplodePileBuffTimer
	        line_count = line_count + 1
	    end
	-- Lance
	elseif weaponType == 7 then
		if settings.show_LA_ChargePowerUp then
	        string_ = check_for_line(string_) .. "DashRemain  :" .. LA_ChargePowerUp
	        line_count = line_count + 1
	    end
	    if settings.show_LA_GuardRageBuffLv then
	        string_ = check_for_line(string_) .. "ARageBuffLv :" .. LA_GuardRageBuffLv
	        line_count = line_count + 1
	    end
	    if settings.show_LA_GuardRageTimer then
	        string_ = check_for_line(string_) .. "ARageBuff   :" .. LA_GuardRageTimer
	        line_count = line_count + 1
	    end
	    if settings.show_LA_RutenBuffTimer then
	        string_ = check_for_line(string_) .. "SpiralBuff  :" .. LA_RutenBuffTimer
	        line_count = line_count + 1
	    end
	--SSword
	elseif weaponType == 8 then
		if settings.show_SS_OilBuff then
	        string_ = check_for_line(string_) .. "OilBuff :" .. SS_OilBuff
	        line_count = line_count + 1
	    end
	-- DBlades
	elseif weaponType == 9 then
		if settings.show_DB_KijinKyoukaGuage then
	        string_ = check_for_line(string_) .. "DemonGauge    :" .. DB_KijinKyoukaGuage
	        line_count = line_count + 1
	    end
	    if settings.show_DB_SharpnessRecoveryBuffSec then
	        string_ = check_for_line(string_) .. "SharpnessBuff :" .. DB_SharpnessRecoveryBuffSec
	        line_count = line_count + 1
	    end
	-- HHorn
    elseif weaponType == 10 then
		if settings.show_HH_InfernalGuage then
	        string_ = check_for_line(string_) .. "Infernal  :" .. HH_InfernalGuage
	        line_count = line_count + 1
	    end
	    if settings.show_HH_ShockwaveTimer then
	        string_ = check_for_line(string_) .. "Shockwave :" .. HH_ShockwaveTimer
	        line_count = line_count + 1
	    end
    -- IG
    elseif weaponType == 12 then
	    if settings.show_full then
	        string_ = check_for_line(string_) .. "Full  :" .. fullExtractSec
	        line_count = line_count + 1
	    end
	    if settings.show_red then
	        string_ = check_for_line(string_) .. "Red   :" .. redExtractSec
	        line_count = line_count + 1
	    end
	    if settings.show_white then
	        string_ = check_for_line(string_) .. "White :" .. whiteExtractSec
	        line_count = line_count + 1
	    end
	    if settings.show_orange then
	        string_ = check_for_line(string_) .. "Orange:" .. orangeExtractSec
	        line_count = line_count + 1
	    end
	-- Bow
	elseif weaponType == 13 then
		if settings.show_chlv then
	        string_ = check_for_line(string_) .. "ChargeLv :" .. chargeLv
	        line_count = line_count + 1
	    end
	    if settings.show_wirebuff then
	        string_ = check_for_line(string_) .. "WireBuff :" .. wireBuffSec
	        line_count = line_count + 1
	    end
	    if settings.show_arrowbuff then
	        string_ = check_for_line(string_) .. "ArrowBuff:" .. arrowBuffSec
	        line_count = line_count + 1
	    end
	end

    line_count = 0
    return string_
end

local function display()
	if not settings.show then return false end
	if not (weaponType == 0 or weaponType == 1 or weaponType == 2 or weaponType == 5 or weaponType == 6 or weaponType == 7 or weaponType == 8 or weaponType == 9 or weaponType == 10 or weaponType == 12 or weaponType == 13) then return false end

	-- TraningArea
	local VillageArea = sdk.get_managed_singleton("snow.VillageAreaManager")
	if VillageArea then
		local VillageLocation = VillageArea:get_field("<_CurrentAreaNo>k__BackingField")
		if VillageLocation == 5 then
			return true
		end
	end

	local questendflow = get_quest_endflow()
	local queststatus = get_quest_status()
    if (queststatus == 2 or queststatus == 3) and questendflow < 2 then
        return true
    else
        return false
    end

end

d2d.register(function()
    font = d2d.Font.new('Consolas', settings.size)
    x,y = d2d.surface_size()
end,
function()
    if display() then
        text = get_string()

        bg_w,bg_h = font:measure(text)
        if settings.bg then d2d.fill_rect(settings.xpos-8, settings.ypos+1, bg_w+15, bg_h, settings.bg_color) end
        if settings.bg then d2d.outline_rect(settings.xpos-8, settings.ypos+1, bg_w+15, bg_h, 3, settings.border_color) end
        d2d.text(font,text, settings.xpos, settings.ypos, settings.color)
    end
end)

re.on_draw_ui(function()
    if imgui.tree_node("DetailedBuffs") then
        _,settings.show = imgui.checkbox('Show', settings.show)

        -- GS
        if weaponType     == 0 then
			_,settings.show_GS_chargeLv        = imgui.checkbox('Show ChargeLv', settings.show_GS_chargeLv)
			_,settings.show_GS_PowerSheatheSec = imgui.checkbox('Show PowerSheathe', settings.show_GS_PowerSheatheSec)
		-- SAxe
		elseif weaponType == 1 then
			_,settings.show_SA_SwitchGauge = imgui.checkbox('Show SwitchGauge', settings.show_SA_SwitchGauge)
	        _,settings.show_SA_AmpGauge    = imgui.checkbox('Show AmpGauge', settings.show_SA_AmpGauge)
	        _,settings.show_SA_AmpBuffSec  = imgui.checkbox('Show AmpBuff Sec', settings.show_SA_AmpBuffSec)
		-- LS
        elseif weaponType == 2 then
	        _,settings.show_LS_SpiritGaugeLevel    = imgui.checkbox('Show SpiritGauge Level', settings.show_LS_SpiritGaugeLevel)
	        _,settings.show_LS_SpiritGaugeLevelSec = imgui.checkbox('Show SpiritGauge Level Sec', settings.show_LS_SpiritGaugeLevelSec)
	        _,settings.show_LS_SpiritGaugeSec      = imgui.checkbox('Show SpiritGauge Sec', settings.show_LS_SpiritGaugeSec)
		-- Hammer
		elseif weaponType == 5 then
			_,settings.show_HM_ChargeLevel    = imgui.checkbox('Show ChargeLv', settings.show_HM_ChargeLevel)
	        _,settings.show_HM_ImpactPullsSec = imgui.checkbox('Show ImpactPulls Sec', settings.show_HM_ImpactPullsSec)
		-- GunLance
		elseif weaponType == 6 then
			_,settings.show_GL_ChargeDragonSlayCannonTime = imgui.checkbox('Show WyvernCannon', settings.show_GL_ChargeDragonSlayCannonTime)
			_,settings.show_GL_ShotDamageUpDurationTimer  = imgui.checkbox('Show GroundSplitter Sec', settings.show_GL_ShotDamageUpDurationTimer)
			_,settings.show_GL_ExplodePileBuffTimer       = imgui.checkbox('Show EruptingCannon Sec', settings.show_GL_ExplodePileBuffTimer)
	    -- Lance
		elseif weaponType == 7 then
			_,settings.show_LA_ChargePowerUp   = imgui.checkbox('Show DashBuffRemaining Sec', settings.show_LA_ChargePowerUp)
			_,settings.show_LA_GuardRageBuffLv = imgui.checkbox('Show AnchorRageBuff Level', settings.show_LA_GuardRageBuffLv)
			_,settings.show_LA_GuardRageTimer = imgui.checkbox('Show AnchorRageBuff Sec', settings.show_LA_GuardRageTimer)
			_,settings.show_LA_RutenBuffTimer = imgui.checkbox('Show SpiralBuff Sec', settings.show_LA_RutenBuffTimer)
		--SSword
		elseif weaponType == 8 then
			_,settings.show_SS_OilBuff = imgui.checkbox('Show OilBuff Sec', settings.show_SS_OilBuff)
		-- DBlades
        elseif weaponType == 9 then
	        _,settings.show_DB_KijinKyoukaGuage         = imgui.checkbox('Show DemonGauge', settings.show_DB_KijinKyoukaGuage)
	        _,settings.show_DB_SharpnessRecoveryBuffSec = imgui.checkbox('Show SharpnessRecoveryBuff Sec', settings.show_DB_SharpnessRecoveryBuffSec)
		-- HHorn
        elseif weaponType == 10 then
			_,settings.show_HH_InfernalGuage    = imgui.checkbox('Show InfernalGauge', settings.show_HH_InfernalGuage)
	        _,settings.show_HH_ShockwaveTimer   = imgui.checkbox('Show Shockwave Sec', settings.show_HH_ShockwaveTimer)
        -- IG
        elseif weaponType == 12 then
	        _,settings.show_full = imgui.checkbox('Show Full', settings.show_full)
	        _,settings.show_red = imgui.checkbox('Show Red', settings.show_red)
	        _,settings.show_white = imgui.checkbox('Show White', settings.show_white)
	        _,settings.show_orange = imgui.checkbox('Show Orange', settings.show_orange)
	  	-- Bow
	    elseif weaponType == 13 then
	        _,settings.show_chlv = imgui.checkbox('Show ChargeLv', settings.show_chlv)
	        _,settings.show_wirebuff = imgui.checkbox('Show WireBuff', settings.show_wirebuff)
	        _,settings.show_arrowbuff = imgui.checkbox('Show ArrowBuff', settings.show_arrowbuff)
	    end

        _,settings.bg = imgui.checkbox('Show Background', settings.bg)
        _,settings.size = imgui.slider_int('Font size (reqs script restart)', settings.size, 1, 100)
        _,settings.xpos = imgui.slider_int('X Pos', settings.xpos, 0, x)
        _,settings.ypos = imgui.slider_int('Y Pos', settings.ypos, 0, y)
        if imgui.tree_node("Font color") then _,settings.color = imgui.color_picker_argb('',settings.color) end
        if imgui.tree_node("BG color") then _,settings.bg_color = imgui.color_picker_argb('',settings.bg_color) end
        if imgui.tree_node("Border color") then _,settings.border_color = imgui.color_picker_argb('',settings.border_color) end
    end
end
)

re.on_config_save(function()
    json.dump_file('DetailedBuffs_settings.json', settings)
end)
