local settings = json.load_file("HardOrSoft.json") or {}
settings.enable = settings.enable == nil and true or settings.enable
settings.weakness = settings.weakness == nil and "Orange" or settings.weakness
settings.mindEye = settings.mindEye == nil and "Large Gray" or settings.mindEye
settings.neither = settings.neither == nil and "White" or settings.neither
settings.weaknessGunner = settings.weaknessGunner == nil and "Orange" or settings.weaknessGunner
settings.neitherGunner = settings.neitherGunner == nil and "White" or settings.neitherGunner
settings.explosion = settings.explosion == nil and "Red" or settings.explosion
settings.buddyAttack = settings.buddyAttack == nil and "Hide" or settings.buddyAttack


local numberColor = {
    "White",
    "Orange",
    "Large Orange",
    "Gray",
    "Red",
    "Large Gray",
    "Hide"
}

function is_module_available(name)
	if package.loaded[name] then
		return true;
	else
		for _, searcher in ipairs(package.searchers or package.loaders) do
			local loader = searcher(name);

			if type(loader) == 'function' then
				package.preload[name] = loader;
				return true;
			end
		end

		return false;
	end
end

if is_module_available("ModOptionsMenu.ModMenuApi") then
    modUI = require("ModOptionsMenu.ModMenuApi");

    local name = "Hard or Soft";
    local description = "Change the color of the damage to the site where the Mind's Eye and Weakness Exploit are triggered.";
    local modObj = modUI.OnMenu(name, description, function()
        local changed = false;
        local configChanged = false;

	    changed, settings.enable = modUI.CheckBox("Enable", settings.enable);
        if changed then
            configChanged = configChanged or changed;
        end

        modUI.Header("Blademaster");
        
        changed, new_value = modUI.Options("Weakness Exploit", FindIndex(numberColor,settings.weakness), numberColor);
        if changed then
            settings.weakness = numberColor[new_value];
            configChanged = configChanged or changed;
        end

        changed, new_value = modUI.Options("Mind's Eye", FindIndex(numberColor,settings.mindEye), numberColor);
        if changed then
            settings.mindEye = numberColor[new_value];
            configChanged = configChanged or changed;
        end
    
        changed, new_value = modUI.Options("Neither", FindIndex(numberColor,settings.neither), numberColor);
        if changed then
            settings.neither = numberColor[new_value];
            configChanged = configChanged or changed;
        end

        modUI.Header("Gunner");

        changed, new_value = modUI.Options("Weakness Exploit", FindIndex(numberColor,settings.weaknessGunner), numberColor);
        if changed then
            settings.weaknessGunner = numberColor[new_value];
            configChanged = configChanged or changed;
        end

        changed, new_value = modUI.Options("Neither", FindIndex(numberColor,settings.neitherGunner), numberColor);
        if changed then
            settings.neitherGunner = numberColor[new_value];
            configChanged = configChanged or changed;
        end

        modUI.Header("Other");

        changed, new_value = modUI.Options("Explosion", FindIndex(numberColor,settings.explosion), numberColor);
        if changed then
            settings.explosion = numberColor[new_value];
            configChanged = configChanged or changed;
        end

        changed, new_value = modUI.Options("Buddy Attack", FindIndex(numberColor,settings.buddyAttack), numberColor);
        if changed then
            settings.buddyAttack = numberColor[new_value];
            configChanged = configChanged or changed;
        end

    	if configChanged then
            SaveSettings();
        end

    end)
end

local next_arg
sdk.hook(
    sdk.find_type_definition("snow.enemy.EnemyUtility"):get_method("getHitUIColorType"),
    function(args)
        next_arg = sdk.to_managed_object(args[2])
    end,

    function(retval)
        if not settings.enable then
            return retval
        end

        -- 3:近接 4:ガンナーとガンスの砲撃 5,6：オトモ 
        local calcParam = next_arg:get_field("_CalcParam")
        local ownerType = calcParam:call("get_OwnerType()")

        -- Buddy
        if ownerType == 5 or ownerType == 6 then
            return sdk.to_ptr(FindIndex(numberColor,settings.buddyAttack) - 1)
        end

        if ownerType ~= 3 and ownerType ~= 4 then
            return retval
        end

        -- 0:斬 1:打 2:弾 3:砲撃徹甲拡散爆弾
        local calcType = calcParam:call("get_CalcType()")

        -- Blademaster
        if calcType == 0 or calcType == 1 then
            if calcParam:call("get_PhysicalMeatAdjustRate()") > 0.445 then
                return sdk.to_ptr(FindIndex(numberColor,settings.weakness) - 1)
            end
            if retval == sdk.to_ptr(0) then
                return sdk.to_ptr(FindIndex(numberColor,settings.mindEye) - 1)
            end
            return sdk.to_ptr(FindIndex(numberColor,settings.neither) - 1)
        end

        -- Gunner
        if calcType == 2 then
            if retval == sdk.to_ptr(1) then
                return sdk.to_ptr(FindIndex(numberColor,settings.weaknessGunner) - 1)
            end
            return sdk.to_ptr(FindIndex(numberColor,settings.neitherGunner) - 1)
        end

        --explosion
        if calcType == 3 then
            return sdk.to_ptr(FindIndex(numberColor,settings.explosion) - 1)
        end

        return retval
    end
)

function FindIndex (table, value, nullable)
	for i = 1, #table do
		if table[i] == value then
			return i;
		end
	end

	if not nullable then
		return 1;
	end
	
    return nil;
end

function SaveSettings()
	json.dump_file("HardOrSoft.json", settings)
end

re.on_draw_ui(function()

    if imgui.tree_node("Hard or Soft") then

        changed, settings.enable = imgui.checkbox("Enabled", settings.enable);

        changed, new_value = imgui.combo("Weakness Exploit", FindIndex(numberColor,settings.weakness), numberColor);
        if changed then
            settings.weakness = numberColor[new_value];
        end

        changed, new_value = imgui.combo("Mind's Eye", FindIndex(numberColor,settings.mindEye), numberColor);
        if changed then
            settings.mindEye = numberColor[new_value];
        end
    
        changed, new_value = imgui.combo("Neither", FindIndex(numberColor,settings.neither), numberColor);
        if changed then
            settings.neither = numberColor[new_value];
        end

        changed, new_value = imgui.combo("Weakness Exploit (Gunner)", FindIndex(numberColor,settings.weaknessGunner), numberColor);
        if changed then
            settings.weaknessGunner = numberColor[new_value];
        end

        changed, new_value = imgui.combo("Neither (Gunner)", FindIndex(numberColor,settings.neitherGunner), numberColor);
        if changed then
            settings.neitherGunner = numberColor[new_value];
        end

        changed, new_value = imgui.combo("Explosion", FindIndex(numberColor,settings.explosion), numberColor);
        if changed then
            settings.explosion = numberColor[new_value];
        end

        changed, new_value = imgui.combo("Buddy Attack", FindIndex(numberColor,settings.buddyAttack), numberColor);
        if changed then
            settings.buddyAttack = numberColor[new_value];
        end

		imgui.tree_pop()
    end
end)

re.on_config_save(function()
	SaveSettings()
end)