log.info("[No Mandatory Wyvern Rides] started loading")

local BlockRideEnabled = true
local BlockRideEnabledWhenNotQuestHost = true
local BlockRideLesserOpeningOnly = false
local BlockRideEnabledForAllPlayersWhenHost = false 

local RideBlock_debugLogs = false;

function RideBlock_logDebug(argStr)
	local debugString = "[No Mandatory Wyvern Rides] "..argStr;
	if RideBlock_debugLogs then
		log.info(debugString);
	end
end

re.on_draw_ui(function()
	if imgui.button("[No Mandatory Wyvern Rides] Options") then
		drawRideBlockWindow = true
	end
    if drawRideBlockWindow then
        if imgui.begin_window("[No Mandatory Wyvern Rides] Options", true, 64) then
			changed, value = imgui.checkbox('Enable Mod', BlockRideEnabled)
			if changed then
				BlockRideEnabled = value
			end
			imgui.text("     ")
			changed, value = imgui.checkbox('Enabled when not Quest Host', BlockRideEnabledWhenNotQuestHost)
			if changed then
				BlockRideEnabledWhenNotQuestHost = value
			end
			imgui.text("  No knockdown or extended stagger means less damage time, but another player will probably trigger a Ride anyways.")
			imgui.text("     ")
			changed, value = imgui.checkbox("Enabled but only use Lesser Opening", BlockRideLesserOpeningOnly)
			if changed then
				BlockRideLesserOpeningOnly = value
			end
			imgui.text("  Only use the client side method, so a few hits will wake up the monster even when Hosting")
			imgui.text("     ")
			changed, value = imgui.checkbox('Enabled for all Players when Quest Host', BlockRideEnabledForAllPlayersWhenHost)
			if changed then
				BlockRideEnabledForAllPlayersWhenHost = value
			end
			imgui.text("  Suggested only to use this option when playing with friends. Players in pick-up games could be rather confused.")
			imgui.text("     ")
		else
            drawRideBlockWindow = false
        end
    end
end)

--stronger method blocks the Monster from requesting a Ride, but only works if player is Host
sdk.hook(sdk.find_type_definition("snow.enemy.EnemyCharacterBase"):get_method("requestMarionetteRideOn"),
function(args)
	if not BlockRideEnabled then
		return sdk.PreHookResult.CALL_ORIGINAL
	end
	local PlayerManager = sdk.get_managed_singleton("snow.player.PlayerManager");
	local DmgSourcePlayerIndex = sdk.to_int64(args[3]);
	local WeaponDrawn = PlayerManager:call("getPlayer", DmgSourcePlayerIndex):call("isWeaponOn");
	RideBlock_logDebug("requestMarionetteRideOn"..":"..tostring(DmgSourcePlayerIndex == 0)..":"..tostring(BlockRideEnabledForAllPlayersWhenHost)..":"..tostring(WeaponDrawn)..":"..tostring(BlockRideLesserOpeningOnly))
	if (DmgSourcePlayerIndex == 0 or BlockRideEnabledForAllPlayersWhenHost) and WeaponDrawn then
		return sdk.PreHookResult.SKIP_ORIGINAL
	end
end,
function(retval)
	return retval;
end
);

--lesser method works when Player is not host, but the Monster will break out of stun when hit a few times
sdk.hook(sdk.find_type_definition("snow.player.PlayerQuestBase"):get_method("isMarionetteRideOnEnablePlAction"),
function(args)

end,
function(retval)
	if not BlockRideEnabled then
		return retval
	end
	local PlayerManager = sdk.get_managed_singleton("snow.player.PlayerManager")
	local LobbyManager = sdk.get_managed_singleton("snow.LobbyManager")
	local isHost = LobbyManager:call("isQuestHost", true)
	local WeaponDrawn = PlayerManager:call("findMasterPlayer"):call("isWeaponOn")
	RideBlock_logDebug("isMarionetteRideOnEnablePlAction"..":"..tostring(WeaponDrawn)..":"..tostring(BlockRideLesserOpeningOnly)..":"..tostring(isHost))
	if (not BlockRideEnabledWhenNotQuestHost) and (not isHost) then
		RideBlock_logDebug("Passing because NotHost, BlockNotHost flag false")
		return retval
	elseif WeaponDrawn and BlockRideLesserOpeningOnly then
		RideBlock_logDebug("Blocking because WeaponOn, LesserOnlyFLag")
		return false
	elseif WeaponDrawn and (not isHost) then
		RideBlock_logDebug("Blocking because WeaponOn, NotHost")
		return false
	else
		RideBlock_logDebug("Passing Val")
		return retval
	end
end
);

log.info("[No Mandatory Wyvern Rides] finished loading")