/*
 * Decompiled with CFR 0.152.
 */
package html_article_generator;

import html_article_generator.ArticleImage;
import html_article_generator.ArticleView;
import java.util.ArrayList;

public class Article {
    private static final int CHRISTMAS_THEME = 0;
    private static final int COLOURFUL_THEME = 1;
    private static final int TRADITIONAL_THEME = 2;
    private static final int SIMPLE_THEME = 3;
    private static final int MODERN_THEME = 4;
    private static final int NAME = 0;
    private static final int URL = 1;
    private String title;
    private String summaryText;
    private String date;
    private String favIconURL;
    private String mainContent;
    private ArrayList<ArticleImage> images;
    private ArrayList<String[]> relatedLinks;
    private int theme;
    private ArticleView articleView;
    private String christmasCSS;
    private String colourfulCSS;
    private String traditionalCSS;
    private String simpleCSS;
    private String modernCSS;

    public Article(String title, String summaryText, String date, String favIconURL, String mainContent, ArrayList<ArticleImage> images, ArrayList<String[]> relatedLinks, int theme) {
        this.title = title;
        this.summaryText = summaryText;
        this.date = date;
        this.favIconURL = favIconURL;
        this.mainContent = mainContent;
        this.images = images;
        this.relatedLinks = relatedLinks;
        this.articleView = null;
        this.setTheme(theme);
        this.initialiseCSSVars();
    }

    public Article() {
        this.title = "";
        this.summaryText = "";
        this.date = "";
        this.favIconURL = "";
        this.mainContent = "";
        this.images = new ArrayList();
        this.relatedLinks = new ArrayList();
        this.articleView = null;
        this.setTheme(0);
        this.initialiseCSSVars();
    }

    private void initialiseCSSVars() {
        this.christmasCSS = "#title\n\t{\n\t\tfont-family: sans-serif;\n\t\tfont-size: 25pt;\n\t\tcolor: white;\n\t\tfont-weight: bold;\n\t\tpadding: 10px;\n\t\tpadding-bottom: 0px\n\t}\n\t#summaryText\n\t{\n\t\tfont-family: sans-serif;\n\t\tfont-size: 15pt;\n\t\tcolor: white;\n\t\tfont-weight: bold;\n\t\tpadding: 10px;\n\t\tpadding-bottom: 0px\n\t}\n\t#articleDate\n\t{\n\t\tfont-family: sans-serif;\n\t\tfont-size: 12pt;\n\t\tcolor: white;\n\t\tbackground-color: #03bb20;\n\t\tmargin: 0px;\n\t\tpadding: 10px;\n\t\tborder-radius: 0 0 8px 8px\n\t}\n\t#titleBackground\n\t{\n\t\twidth: 600px;\n\t\tbackground-color: #ea4505;\n\t\tmargin: auto;\n\t\tpadding-bottom: 0px;\n\t\tpadding-left: 0px;\n\t\tpadding-right: 0px;\n\t\tborder-radius: 8px;\n\t}\n\t#relatedLinks a\n\t{\n\t\tdisplay: inline-block;\n\t\tborder-radius: 5pt;\n\t\tbackground-color: #ea4505;\n\t\tborder-bottom: 5px solid #03bb20;\n\t\tpadding: 10px;\n\t\tcolor: white;\n\t\tfont-weight: bold;\n\t\tmargin: 4px\n\t}\n\t#mainContent\n\t{\n\t\twidth: 600px;\n\t\tmargin: auto;\n\t\tfont-family: sans-serif;\n\t\ttext-align: justify\n\t}\n\t#mainContent img\n\t{\n\t\twidth: 100%;\n\t\ttop: 4px;\n\t\tposition: relative;\n\t\tborder-radius: 5px 5px 0 0\n\t}\n\t\n\t.imageCaption\n\t{\n\t\tbackground-color: #03bb20;\n\t\twidth: 100%;\n\t\tpadding: 7px;\n\t\tborder-bottom: 5px solid #ea4505;\n\t\tborder-radius: 0 0 5px 5px;\n\t\tfont-family: sans-serif;\n\t\tcolor: white;\n\t\tfont-size: 11pt;\n\t\tbox-sizing: border-box\n\t}";
        this.colourfulCSS = "#title\n\t{\n\t\tfont-family: sans-serif;\n\t\tfont-size: 25pt;\n\t\tcolor: rgb(228, 36, 5);\n\t\tfont-weight: bold;\n\t\tpadding: 10px;\n\t\tpadding-bottom: 0px\n\t}\n\t#summaryText\n\t{\n\t\tfont-family: sans-serif;\n\t\tfont-size: 15pt;\n\t\tcolor: rgb(228, 36, 5);\n\t\tfont-weight: bold;\n\t\tpadding: 10px;\n\t\tpadding-bottom: 0px\n\t}\n\t#articleDate\n\t{\n\t\tfont-family: sans-serif;\n\t\tfont-size: 12pt;\n\t\tcolor: white;\n\t\tbackground-color: #04d2b4;\n\t\tmargin: 0px;\n\t\tpadding: 10px;\n\t\tborder-radius: 0 0 8px 8px\n\t}\n\t#titleBackground\n\t{\n\t\twidth: 600px;\n\t\tbackground-color: #f3bd05;\n\t\tmargin: auto;\n\t\tpadding-bottom: 0px;\n\t\tpadding-left: 0px;\n\t\tpadding-right: 0px;\n\t\tborder-radius: 8px;\n\t}\n\t\n\t#relatedLinks a\n\t{\n\t\tdisplay: inline-block;\n\t\tborder-radius: 8pt;\n\t\tbackground-color: #f3bd05;\n\t\tpadding: 10px;\n\t\tcolor: rgb(209, 33, 5);\n\t\tfont-weight: bold;\n\t\tmargin: 4px\t}\t\n\t#mainContent\n\t{\n\t\twidth: 600px;\n\t\tmargin: auto;\n\t\tfont-family: sans-serif;\n\t\ttext-align: justify\n\t}\n\t#mainContent img\n\t{\n\t\twidth: 100%;\n\t\ttop: 4px;\n\t\tposition: relative;\n\t\tborder-radius: 5px 5px 0 0\n\t}\n\t\n\t.imageCaption\n\t{\n\t\tbackground-color: #21b4d5;\n\t\twidth: 100%;\n\t\tpadding: 7px;\n\t\tborder-bottom: 5px solid #f3bd05;\n\t\tborder-radius: 0 0 5px 5px;\n\t\tfont-family: sans-serif;\n\t\tcolor: white;\n\t\tfont-size: 11pt;\n\t\tbox-sizing: border-box\n\t}";
        this.traditionalCSS = "#title\n\t{\n\t\tfont-family: serif;\n\t\tfont-size: 25pt;\n\t\tcolor: black;\n\t\tfont-weight: bold;\n\t\tpadding: 0px\n\t}\n\t#summaryText\n\t{\n\t\tfont-family: serif;\n\t\tfont-size: 15pt;\n\t\tcolor: black;\n\t\tfont-weight: bold;\n\t\tpadding: 0px;\n\t}\n\t#articleDate\n\t{\n\t\tfont-family: serif;\n\t\tfont-size: 12pt;\n\t\tcolor: black;\n\t\tbackground-color: #d5d5d5;\n\t\tmargin: 0px;\n\t\tpadding: 10px;\n\t\tfont-style: italic;\n\t\ttext-align: left\n\t}\n\t#titleBackground\n\t{\n\t\twidth: 600px;\n\t\tbackground-color: #d5d5d5;\n\t\tmargin: auto;\n\t\tpadding-bottom: 0px;\n\t\tpadding-left: 0px;\n\t\tpadding-right: 0px;\n\t\tborder: 2px solid black;\n\t\ttext-align: center\n\t}\n\t#relatedLinks a\n\t{\n\t\tdisplay: list-item;\n\t\tpadding: 10px;\n\t\tcolor: black;\n\t\tfont-weight: bold\n\t}\n\t#mainContent\n\t{\n\t\twidth: 600px;\n\t\tmargin: auto;\n\t\tfont-family: serif;\n\t\ttext-align: justify\n\t}\n\t#mainContent img\n\t{\n\t\twidth: 100%;\n\t\ttop: 4px;\n\t\tposition: relative;\n\t\tborder: 2px solid black\t}\n\t\n\t.imageCaption\n\t{\n\t\tbackground-color: white;\n\t\twidth: 100%;\n\t\tpadding: 7px;\n\t\tborder-radius: 0 0 5px 5px;\n\t\tfont-family: serif;\n\t\tcolor: black;\n\t\tfont-size: 11pt;\n\t\tfont-style: italic;\n\t\ttext-align: center;\n\t\tbox-sizing: border-box\n\t}";
        this.simpleCSS = "#title\n\t{\n\t\tfont-family: sans-serif;\n\t\tfont-size: 25pt;\n\t\tcolor: white;\n\t\tfont-weight: bold;\n\t\tpadding: 10px;\n\t\tpadding-bottom: 0px\n\t}\n\t#summaryText\n\t{\n\t\tfont-family: sans-serif;\n\t\tfont-size: 15pt;\n\t\tcolor: white;\n\t\tfont-weight: bold;\n\t\tpadding: 10px;\n\t\tpadding-bottom: 0px\n\t}\n\t#articleDate\n\t{\n\t\tfont-family: sans-serif;\n\t\tfont-size: 12pt;\n\t\tcolor: white;\n\t\tbackground-color: black;\n\t\tmargin: 0px;\n\t\tpadding: 10px\n\t}\n\t#titleBackground\n\t{\n\t\twidth: 600px;\n\t\tbackground-color: black;\n\t\tmargin: auto;\n\t\tpadding-bottom: 0px;\n\t\tpadding-left: 0px;\n\t\tpadding-right: 0px\n\t}\n\t#relatedLinks a\n\t{\n\t\tdisplay: inline-block;\n\t\tborder-radius: 0pt;\n\t\tbackground-color: #dddddd;\n\t\tpadding: 10px;\n\t\tcolor: black;\n\t\tfont-weight: bold;\n\t\tmargin: 4px\n\t}\t\n\t#mainContent\n\t{\n\t\twidth: 600px;\n\t\tmargin: auto;\n\t\tfont-family: sans-serif;\n\t\ttext-align: justify\n\t}\n\t#mainContent img\n\t{\n\t\twidth: 100%;\n\t\ttop: 4px;\n\t\tposition: relative\n\t}\n\t\n\t.imageCaption\n\t{\n\t\tbackground-color: #dddddd;\n\t\twidth: 100%;\n\t\tpadding: 7px;\n\t\tfont-family: sans-serif;\n\t\tcolor: black;\n\t\tfont-size: 11pt;\n\t\tbox-sizing: border-box\n\n\t}\t}";
        this.modernCSS = "#title\n\t{\n\t\tfont-family: verdana, sans-serif;\n\t\tfont-size: 28pt;\n\t\tcolor: black;\n\t\tfont-weight: bold;\n\t\tpadding: 20px;\n\t\tpadding-bottom: 0px\n\t}\n\t#summaryText\n\t{\n\t\tfont-family: verdana, sans-serif;\n\t\tfont-size: 15pt;\n\t\tcolor: black;\n\t\tfont-weight: bold;\n\t\tpadding: 20px;\n\t\tpadding-bottom: 0px\n\t}\n\t#articleDate\n\t{\n\t\tfont-family: sans-serif;\n\t\tfont-size: 12pt;\n\t\tcolor: black;\n\t\tbackground-color: rgba(0, 0, 0, 0);\n\t\tmargin: 0px;\n\t\tpadding: 20px;\n\t\tborder-radius: 21px\n\t}\n\t#titleBackground\n\t{\n\t\twidth: 600px;\n\t\tbackground-color: #d3d3e2;\n\t\tmargin: auto;\n\t\tpadding-bottom: 0px;\n\t\tpadding-left: 0px;\n\t\tpadding-right: 0px;\n\t\tborder-radius: 25px;\n\t\tbox-shadow: -10px -10px 20px rgba(0, 0, 0, 0.38) inset, 10px 10px 20px rgba(255, 255, 255, 1) inset;\n\t}\n\t#relatedLinks a\n\t{\n\t\tdisplay: inline-block;\n\t\tborder-radius: 12pt;\n\t\tbackground-color: #ccccdb;\n\t\tpadding: 16px;\n\t\tcolor: black;\n\t\tfont-weight: bold;\n\t\tmargin: 3px;\n\t\tbox-sizing: border-box;\n\t\tbox-shadow: -7px -7px 7px rgba(0, 0, 0, 0.35) inset, 7px 7px 7px rgba(255, 255, 255, 0.7) inset\n\t}\n\t#mainContent\n\t{\n\t\twidth: 600px;\n\t\tmargin: auto;\n\t\tfont-family: sans-serif;\n\t\ttext-align: justify\n\t}\n\t#mainContent img\n\t{\n\t\twidth: 100%;\n\t\tposition: relative;\n\t\tborder-radius: 16px\n\t}\n\t\n\t.imageCaption\n\t{\n\t\tbackground-color: #ccccdb;\n\t\twidth: 100%;\n\t\tpadding: 13px;\n\t\tborder-radius: 16px;\n\t\tfont-family: sans-serif;\n\t\tcolor: black;\n\t\tfont-size: 11pt;\n\t\tbox-sizing: border-box;\nbox-shadow: -10px -10px 10px rgba(0, 0, 0, 0.35) inset, 10px 10px 10px rgba(255, 255, 255, 0.7) inset\n\t}";
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title, boolean ... updateView) {
        this.title = title;
        if (updateView.length == 0) {
            this.publishChange();
        }
    }

    public String getSummaryText() {
        return this.summaryText;
    }

    public void setSummaryText(String summaryText, boolean ... updateView) {
        this.summaryText = summaryText;
        if (updateView.length == 0) {
            this.publishChange();
        }
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date, boolean ... updateView) {
        this.date = date;
        if (updateView.length == 0) {
            this.publishChange();
        }
    }

    public String getFavIconURL() {
        return this.favIconURL;
    }

    public void setFavIconURL(String favIconURL, boolean ... updateView) {
        this.favIconURL = favIconURL;
        if (updateView.length == 0) {
            this.publishChange();
        }
    }

    public String getMainContent() {
        return this.mainContent;
    }

    public void setMainContent(String mainContent, boolean ... updateView) {
        this.mainContent = mainContent;
        if (updateView.length == 0) {
            this.publishChange();
        }
    }

    public ArrayList<ArticleImage> getImages() {
        return this.images;
    }

    public void setImages(ArrayList<ArticleImage> images, boolean ... updateView) {
        this.images = images;
        if (updateView.length == 0) {
            this.publishChange();
        }
    }

    public void addImage(ArticleImage newImage, boolean ... updateView) {
        if (this.images != null) {
            this.images.add(newImage);
        }
        if (updateView.length == 0) {
            this.publishChange();
        }
    }

    public ArrayList<String[]> getRelatedLinks() {
        return this.relatedLinks;
    }

    public void setRelatedLinks(ArrayList<String[]> relatedLinks, boolean ... updateView) {
        this.relatedLinks = relatedLinks;
        if (updateView.length == 0) {
            this.publishChange();
        }
    }

    public void addRelatedLink(String[] link, boolean ... updateView) {
        this.relatedLinks.add(link);
        if (updateView.length == 0) {
            this.publishChange();
        }
    }

    public void publishChange() {
        if (this.articleView != null) {
            this.articleView.updateUI(this);
        }
    }

    public String convertToHTML() {
        String themeCSS = "";
        switch (this.theme) {
            case 0: {
                themeCSS = this.christmasCSS;
                break;
            }
            case 1: {
                themeCSS = this.colourfulCSS;
                break;
            }
            case 2: {
                themeCSS = this.traditionalCSS;
                break;
            }
            case 3: {
                themeCSS = this.simpleCSS;
                break;
            }
            case 4: {
                themeCSS = this.modernCSS;
                break;
            }
            default: {
                themeCSS = this.christmasCSS;
            }
        }
        String formattedMainContent = this.mainContent.replace("<::heading::>", "</p><h3>").replace("<::/heading::>", "</h3><p>");
        String mainContentWithImages = formattedMainContent.replace("<::image::>", "\n<div>\n<img src=\"").replace("<::/image::>", "\" ");
        mainContentWithImages = mainContentWithImages.replace("<::altText::>", " alt=\"").replace("<::/altText::>", "\" />");
        mainContentWithImages = mainContentWithImages.replace("<::imageCaption::>", "<div class=\"imageCaption\">").replace("<::/imageCaption::>", "</div>\n</div>");
        StringBuilder HTMLString = new StringBuilder();
        HTMLString.append("<!DOCTYPE html>");
        HTMLString.append("<html>\n");
        HTMLString.append("<head>\n");
        HTMLString.append("<link rel=\"icon\" type=\"image/x-icon\" href=\"" + this.favIconURL + "\">");
        HTMLString.append("<title>" + this.title + "</title>");
        HTMLString.append("<style>\n");
        HTMLString.append(themeCSS);
        HTMLString.append("</style>\n");
        HTMLString.append("</head>\n");
        HTMLString.append("<body>\n");
        HTMLString.append("<div id=\"titleBackground\">");
        HTMLString.append("<h1 id=\"title\">" + this.title + "</h1>");
        HTMLString.append("<p id=\"summaryText\">" + this.summaryText + "</p>");
        HTMLString.append("<p id=\"articleDate\">" + this.date + "</p>");
        HTMLString.append("</div>");
        HTMLString.append("<br>");
        HTMLString.append("<div id=\"mainContent\">\n");
        HTMLString.append("<p>");
        HTMLString.append(mainContentWithImages);
        HTMLString.append("\n</p>\n");
        if (this.relatedLinks.size() > 0) {
            HTMLString.append("<p>Related Links: </p>\n");
        }
        HTMLString.append("<div id=\"relatedLinks\">\n");
        for (String[] link : this.relatedLinks) {
            HTMLString.append("<a href=\"" + link[1] + "\">" + link[0] + "</a>");
        }
        HTMLString.append("</div>\n");
        HTMLString.append("</div>\n\n");
        HTMLString.append("</body>\n");
        HTMLString.append("</html>");
        return HTMLString.toString();
    }

    public void addObserver(ArticleView articleView) {
        this.articleView = articleView;
    }

    public int getTheme() {
        return this.theme;
    }

    public void setTheme(int theme) {
        this.theme = theme;
        this.publishChange();
    }

    public ArticleMemento save() {
        return new ArticleMemento(this);
    }

    public void revert(Object savedState) {
        ArticleMemento memento = (ArticleMemento)savedState;
        this.title = memento.title;
        this.summaryText = memento.summaryText;
        this.date = memento.date;
        this.favIconURL = memento.favIconURL;
        this.mainContent = memento.mainContent;
        this.theme = memento.theme;
        this.images.clear();
        int i2 = 0;
        while (i2 < memento.images.size()) {
            this.images.add(new ArticleImage(memento.images.get(i2).getImageURL(), memento.images.get(i2).getCaptionText(), memento.images.get(i2).getAltText()));
            ++i2;
        }
        this.relatedLinks.clear();
        i2 = 0;
        while (i2 < memento.relatedLinks.size()) {
            this.relatedLinks.add(new String[]{memento.relatedLinks.get(i2)[0], memento.relatedLinks.get(i2)[1]});
            ++i2;
        }
        this.publishChange();
    }

    private class ArticleMemento {
        private String title;
        private String summaryText;
        private String date;
        private String favIconURL;
        private String mainContent;
        private ArrayList<ArticleImage> images;
        private ArrayList<String[]> relatedLinks;
        private int theme;

        public ArticleMemento(Article article2) {
            this.title = article2.title;
            this.summaryText = article2.summaryText;
            this.date = article2.date;
            this.favIconURL = article2.favIconURL;
            this.mainContent = article2.mainContent;
            this.images = new ArrayList();
            this.relatedLinks = new ArrayList();
            this.theme = article2.theme;
            int i2 = 0;
            while (i2 < article2.images.size()) {
                this.images.add(new ArticleImage(article2.images.get(i2).getImageURL(), article2.images.get(i2).getCaptionText(), article2.images.get(i2).getAltText()));
                ++i2;
            }
            i2 = 0;
            while (i2 < article2.relatedLinks.size()) {
                this.relatedLinks.add(new String[]{article2.relatedLinks.get(i2)[0], article2.relatedLinks.get(i2)[1]});
                ++i2;
            }
        }
    }
}

