/*
 * Decompiled with CFR 0.152.
 */
package html_article_generator;

import html_article_generator.Article;
import html_article_generator.ArticleCaretaker;
import html_article_generator.ArticleImage;
import html_article_generator.ArticleView;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ArticleController
implements ActionListener,
KeyListener,
ListSelectionListener {
    private ArticleView articleView;
    private Article article;

    public ArticleController(ArticleView articleView, Article article) {
        this.articleView = articleView;
        this.article = article;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int clickedOk;
        int yesOrCancel;
        if (e.getSource() == this.articleView.about) {
            JOptionPane.showMessageDialog(null, "This is an application for automatically creating custom web pages\nbased on the content you enter.\nFor help visit the discussion page of the HTML Article Generator\nSourceForge site. \n\nHTML Article Generator version 1.0 (March 2021)", "About HTML Article Generator", 1);
        }
        if (e.getSource() == this.articleView.save) {
            ArticleCaretaker.save(this.article);
        }
        if (e.getSource() == this.articleView.restore) {
            ArticleCaretaker.revert(this.article);
        }
        if (e.getSource() == this.articleView.export) {
            FileDialog exportDialog = new FileDialog((Frame)this.articleView.mainWindow, "Export as HTML", 1);
            exportDialog.setFile("Article.html");
            exportDialog.setVisible(true);
            String fullFilePath = String.valueOf(exportDialog.getDirectory()) + exportDialog.getFile();
            String articleAsHTML = this.article.convertToHTML();
            if (exportDialog.getDirectory() != null && exportDialog.getFile() != null) {
                try {
                    FileWriter saveHTML = new FileWriter(fullFilePath);
                    saveHTML.write(articleAsHTML);
                    saveHTML.flush();
                    saveHTML.close();
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(exportDialog, "Error - Invalid file path.");
                }
            }
        }
        if (e.getSource() == this.articleView.makeHeading) {
            this.article.setMainContent(String.valueOf(this.article.getMainContent()) + "\n<::heading::>Insert Heading Here<::/heading::>", new boolean[0]);
        }
        if (e.getSource() == this.articleView.addImage && (yesOrCancel = JOptionPane.showConfirmDialog(null, this.articleView.imageInputDialog, "Insert New Image", 2)) == 0) {
            ArticleImage newImage = new ArticleImage(this.articleView.imageURLTextbox.getText(), this.articleView.imageCaptionTextbox.getText(), this.articleView.imageAltTextTextbox.getText());
            this.article.addImage(newImage, new boolean[0]);
            this.article.setMainContent(String.valueOf(this.article.getMainContent()) + "\n<::image::>" + this.articleView.imageURLTextbox.getText() + "<::/image::><::altText::>" + this.articleView.imageAltTextTextbox.getText() + "<::/altText::>\n<::imageCaption::>" + this.articleView.imageCaptionTextbox.getText() + "<::/imageCaption::>", new boolean[0]);
        }
        if (e.getSource() == this.articleView.addLink && (clickedOk = JOptionPane.showConfirmDialog(null, this.articleView.linkInputDialog, "Add Related Link", 2)) == 0) {
            String[] linkNameAndURL = new String[]{this.articleView.linkNameTextbox.getText(), this.articleView.linkURLTextbox.getText()};
            if (!linkNameAndURL[1].contains("https://") && !linkNameAndURL[1].contains("http://")) {
                linkNameAndURL[1] = "https://" + linkNameAndURL[1];
            }
            this.article.addRelatedLink(linkNameAndURL, new boolean[0]);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.articleView.titleTextbox) {
            this.article.setTitle(this.articleView.titleTextbox.getText(), false);
        }
        if (e.getSource() == this.articleView.summaryTextbox) {
            this.article.setSummaryText(this.articleView.summaryTextbox.getText(), false);
        }
        if (e.getSource() == this.articleView.dateTextbox) {
            this.article.setDate(this.articleView.dateTextbox.getText(), false);
        }
        if (e.getSource() == this.articleView.favIconURLTextbox) {
            this.article.setFavIconURL(this.articleView.favIconURLTextbox.getText(), false);
        }
        if (e.getSource() == this.articleView.mainContentTextbox) {
            this.article.setMainContent(this.articleView.mainContentTextbox.getText(), false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.articleView.themeList) {
            this.article.setTheme(this.articleView.themeList.getSelectedIndex());
        }
    }
}

