/*
 * Decompiled with CFR 0.152.
 */
package html_article_generator;

import html_article_generator.Article;
import html_article_generator.ArticleImage;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ArticleView {
    JFrame mainWindow = new JFrame("HTML Article Generator");
    JPanel allUI = new JPanel();
    private final int WINDOW_X = 200;
    private final int WINDOW_Y = 200;
    private final int WINDOW_WIDTH = 800;
    private final int WINDOW_HEIGHT = 600;
    private final int TEXTBOX_HEIGHT = 30;
    String[] themes = new String[]{"Christmas", "Colourful", "Traditional", "Simple", "Modern"};
    JPanel saveRestoreExportButtons = new JPanel();
    JButton save = new JButton("Save");
    JButton restore = new JButton("Restore Previous Save");
    JButton export = new JButton("Export");
    JButton about = new JButton("About");
    JPanel editorUI = new JPanel();
    JLabel titleLabel = new JLabel("Title: ");
    JTextField titleTextbox = new JTextField();
    JLabel summaryLabel = new JLabel("Summary Text Below Title: ");
    JTextField summaryTextbox = new JTextField();
    JLabel dateLabel = new JLabel("Date: ");
    JTextField dateTextbox = new JTextField();
    JLabel favIconURLLabel = new JLabel("Favourite Icon URL: ");
    JTextField favIconURLTextbox = new JTextField();
    JLabel mainContentLabel = new JLabel("Main Content and Headings: ");
    JButton makeHeading = new JButton("Heading");
    JTextArea mainContentTextbox = new JTextArea();
    JScrollPane mainContentScrollpane = new JScrollPane(this.mainContentTextbox);
    JLabel imagesLabel = new JLabel("Images: ");
    JTextField imagesTextbox = new JTextField();
    JButton addImage = new JButton("Add Image");
    JPanel imageInputDialog = new JPanel();
    JTextField imageURLTextbox = new JTextField();
    JTextField imageCaptionTextbox = new JTextField();
    JTextField imageAltTextTextbox = new JTextField();
    JLabel relatedLinksLabel = new JLabel("Related Links: ");
    JTextField relatedLinksTextbox = new JTextField();
    JButton addLink = new JButton("Add Link");
    JPanel linkInputDialog = new JPanel();
    JTextField linkNameTextbox = new JTextField();
    JTextField linkURLTextbox = new JTextField();
    JLabel themeLabel = new JLabel("Theme: ");
    JList<String> themeList = new JList<String>(this.themes);

    public ArticleView() {
        FlowLayout flowLayoutEngine = new FlowLayout(1);
        this.save.setVisible(true);
        this.restore.setVisible(true);
        this.export.setVisible(true);
        this.about.setVisible(true);
        this.saveRestoreExportButtons.setLayout(flowLayoutEngine);
        this.saveRestoreExportButtons.setVisible(true);
        this.saveRestoreExportButtons.add(this.save);
        this.saveRestoreExportButtons.add(this.restore);
        this.saveRestoreExportButtons.add(this.export);
        this.saveRestoreExportButtons.add(this.about);
        this.titleLabel.setVisible(true);
        this.titleTextbox.setPreferredSize(new Dimension(190, 30));
        this.titleTextbox.setVisible(true);
        this.summaryLabel.setVisible(true);
        this.summaryTextbox.setPreferredSize(new Dimension(205, 30));
        this.summaryTextbox.setVisible(true);
        this.dateLabel.setVisible(true);
        this.dateTextbox.setPreferredSize(new Dimension(90, 30));
        this.dateTextbox.setVisible(true);
        this.favIconURLLabel.setVisible(true);
        this.favIconURLTextbox.setPreferredSize(new Dimension(110, 30));
        this.favIconURLTextbox.setVisible(true);
        this.mainContentLabel.setVisible(true);
        this.mainContentScrollpane.setPreferredSize(new Dimension(380, 250));
        this.mainContentScrollpane.setVisible(true);
        this.makeHeading.setVisible(true);
        this.imagesLabel.setVisible(true);
        this.imagesTextbox.setPreferredSize(new Dimension(170, 30));
        this.imagesTextbox.setVisible(true);
        this.addImage.setVisible(true);
        this.imageURLTextbox.setPreferredSize(new Dimension(120, 30));
        this.imageCaptionTextbox.setPreferredSize(new Dimension(170, 30));
        this.imageAltTextTextbox.setPreferredSize(new Dimension(120, 30));
        this.imageInputDialog.add(new JLabel("Image URL: "));
        this.imageInputDialog.add(this.imageURLTextbox);
        this.imageInputDialog.add(new JLabel("Image Caption: "));
        this.imageInputDialog.add(this.imageCaptionTextbox);
        this.imageInputDialog.add(new JLabel("HTML Alt Text: "));
        this.imageInputDialog.add(this.imageAltTextTextbox);
        this.relatedLinksLabel.setVisible(true);
        this.relatedLinksTextbox.setPreferredSize(new Dimension(170, 30));
        this.relatedLinksTextbox.setVisible(true);
        this.addLink.setVisible(true);
        this.linkNameTextbox.setPreferredSize(new Dimension(110, 30));
        this.linkURLTextbox.setPreferredSize(new Dimension(180, 30));
        this.linkInputDialog.add(new JLabel("Link Name: "));
        this.linkInputDialog.add(this.linkNameTextbox);
        this.linkInputDialog.add(new JLabel("Link URL: "));
        this.linkInputDialog.add(this.linkURLTextbox);
        this.themeLabel.setVisible(true);
        this.themeList.setSelectionMode(0);
        this.themeList.setVisible(true);
        this.themeList.setSelectedIndex(0);
        this.editorUI.setLayout(flowLayoutEngine);
        this.editorUI.setVisible(true);
        this.editorUI.add(this.titleLabel);
        this.editorUI.add(this.titleTextbox);
        this.editorUI.add(this.summaryLabel);
        this.editorUI.add(this.summaryTextbox);
        this.editorUI.add(this.dateLabel);
        this.editorUI.add(this.dateTextbox);
        this.editorUI.add(this.favIconURLLabel);
        this.editorUI.add(this.favIconURLTextbox);
        this.editorUI.add(this.mainContentLabel);
        this.editorUI.add(this.makeHeading);
        this.editorUI.add(this.mainContentScrollpane);
        this.editorUI.add(this.imagesLabel);
        this.editorUI.add(this.imagesTextbox);
        this.editorUI.add(this.addImage);
        this.editorUI.add(this.relatedLinksLabel);
        this.editorUI.add(this.relatedLinksTextbox);
        this.editorUI.add(this.addLink);
        this.editorUI.add(this.themeLabel);
        this.editorUI.add(this.themeList);
        this.allUI.setLayout(new GridLayout(1, 2));
        this.allUI.add(this.editorUI);
        this.allUI.add(this.saveRestoreExportButtons);
        this.mainWindow.add(this.allUI);
        this.mainWindow.setDefaultCloseOperation(3);
        this.mainWindow.setBounds(200, 200, 800, 600);
        this.mainWindow.setVisible(true);
        this.mainWindow.setResizable(false);
    }

    public void updateUI(Article article) {
        this.titleTextbox.setText(article.getTitle());
        this.summaryTextbox.setText(article.getSummaryText());
        this.dateTextbox.setText(article.getDate());
        this.favIconURLTextbox.setText(article.getFavIconURL());
        this.mainContentTextbox.setText(article.getMainContent());
        this.themeList.setSelectedIndex(article.getTheme());
        String relatedLinksList = "";
        for (String[] link : article.getRelatedLinks()) {
            relatedLinksList = String.valueOf(relatedLinksList) + "\"" + link[1] + "\", ";
        }
        this.relatedLinksTextbox.setText(relatedLinksList);
        String imageURLList = "";
        for (ArticleImage image : article.getImages()) {
            imageURLList = String.valueOf(imageURLList) + "\"" + image.getImageURL() + "\", ";
        }
        this.imagesTextbox.setText(imageURLList);
    }
}

