/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.MethodDescriptor;
import org.junit.jupiter.api.MethodOrdererContext;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassUtils;

@API(status=API.Status.EXPERIMENTAL, since="5.4")
public interface MethodOrderer {
    public void orderMethods(MethodOrdererContext var1);

    default public Optional<ExecutionMode> getDefaultExecutionMode() {
        return Optional.of(ExecutionMode.SAME_THREAD);
    }

    public static class Alphanumeric
    implements MethodOrderer {
        private static final Comparator<MethodDescriptor> comparator = Comparator.comparing(descriptor -> descriptor.getMethod().getName()).thenComparing(descriptor -> Alphanumeric.parameterList(descriptor.getMethod()));

        @Override
        public void orderMethods(MethodOrdererContext context) {
            context.getMethodDescriptors().sort(comparator);
        }

        private static String parameterList(Method method) {
            return ClassUtils.nullSafeToString(method.getParameterTypes());
        }
    }

    public static class OrderAnnotation
    implements MethodOrderer {
        @Override
        public void orderMethods(MethodOrdererContext context) {
            context.getMethodDescriptors().sort(Comparator.comparingInt(OrderAnnotation::getOrder));
        }

        private static int getOrder(MethodDescriptor descriptor) {
            return descriptor.findAnnotation(Order.class).map(Order::value).orElse(0x3FFFFFFF);
        }
    }

    public static class Random
    implements MethodOrderer {
        private static final Logger logger = LoggerFactory.getLogger(Random.class);
        private static final long DEFAULT_SEED = System.nanoTime();
        public static final String RANDOM_SEED_PROPERTY_NAME = "junit.jupiter.execution.order.random.seed";

        @Override
        public void orderMethods(MethodOrdererContext context) {
            Collections.shuffle(context.getMethodDescriptors(), new java.util.Random(this.getCustomSeed(context).orElse(DEFAULT_SEED)));
        }

        private Optional<Long> getCustomSeed(MethodOrdererContext context) {
            return context.getConfigurationParameter(RANDOM_SEED_PROPERTY_NAME).map(configurationParameter -> {
                Long seed = null;
                try {
                    seed = Long.valueOf(configurationParameter);
                    logger.config(() -> String.format("Using custom seed for configuration parameter [%s] with value [%s].", RANDOM_SEED_PROPERTY_NAME, configurationParameter));
                }
                catch (NumberFormatException ex) {
                    logger.warn(ex, () -> String.format("Failed to convert configuration parameter [%s] with value [%s] to a long. Using default seed [%s] as fallback.", RANDOM_SEED_PROPERTY_NAME, configurationParameter, DEFAULT_SEED));
                }
                return seed;
            });
        }

        static {
            logger.info(() -> "MethodOrderer.Random default seed: " + DEFAULT_SEED);
        }
    }
}

