/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.migrationsupport.rules;

import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.migrationsupport.rules.TestRuleSupport;
import org.junit.jupiter.migrationsupport.rules.adapter.ExpectedExceptionAdapter;
import org.junit.rules.ExpectedException;

@API(status=API.Status.EXPERIMENTAL, since="5.0")
public class ExpectedExceptionSupport
implements AfterEachCallback,
TestExecutionExceptionHandler {
    private static final String EXCEPTION_WAS_HANDLED = "exceptionWasHandled";
    private final TestRuleSupport support = new TestRuleSupport(ExpectedExceptionAdapter::new, ExpectedException.class);

    @Override
    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.getStore(context).put(EXCEPTION_WAS_HANDLED, Boolean.TRUE);
        this.support.handleTestExecutionException(context, throwable);
    }

    @Override
    public void afterEach(ExtensionContext context) throws Exception {
        boolean handled = this.getStore(context).getOrComputeIfAbsent(EXCEPTION_WAS_HANDLED, key -> Boolean.FALSE, Boolean.class);
        if (!handled) {
            this.support.afterEach(context);
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create(this.getClass(), context.getUniqueId()));
    }
}

