/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.migrationsupport.rules;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.Rule;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.migrationsupport.rules.adapter.AbstractTestRuleAdapter;
import org.junit.jupiter.migrationsupport.rules.adapter.GenericBeforeAndAfterAdvice;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedField;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedMember;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedMethod;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.rules.TestRule;

class TestRuleSupport
implements BeforeEachCallback,
TestExecutionExceptionHandler,
AfterEachCallback {
    private static final Consumer<List<TestRuleAnnotatedMember>> NO_OP = members -> {};
    private final Class<? extends TestRule> ruleType;
    private final Function<TestRuleAnnotatedMember, AbstractTestRuleAdapter> adapterGenerator;

    TestRuleSupport(Function<TestRuleAnnotatedMember, AbstractTestRuleAdapter> adapterGenerator, Class<? extends TestRule> ruleType) {
        this.adapterGenerator = adapterGenerator;
        this.ruleType = ruleType;
    }

    private List<TestRuleAnnotatedMember> findRuleAnnotatedMembers(Object testInstance) {
        ArrayList result = new ArrayList();
        this.findAnnotatedMethods(testInstance).stream().map(method -> new TestRuleAnnotatedMethod(testInstance, (Method)method)).forEach(result::add);
        this.findAnnotatedFields(testInstance).stream().map(field -> new TestRuleAnnotatedField(testInstance, (Field)field)).forEach(result::add);
        Collections.reverse(result);
        return Collections.unmodifiableList(result);
    }

    private List<Method> findAnnotatedMethods(Object testInstance) {
        Predicate<Method> isRuleMethod = method -> AnnotationUtils.isAnnotated(method, Rule.class);
        Predicate<Method> hasCorrectReturnType = method -> TestRule.class.isAssignableFrom(method.getReturnType());
        return ReflectionUtils.findMethods(testInstance.getClass(), isRuleMethod.and(hasCorrectReturnType));
    }

    private List<Field> findAnnotatedFields(Object testInstance) {
        return AnnotationUtils.findPublicAnnotatedFields(testInstance.getClass(), TestRule.class, Rule.class);
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        this.invokeAppropriateMethodOnRuleAnnotatedMembers(context, NO_OP, GenericBeforeAndAfterAdvice::before);
    }

    @Override
    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        long numRuleAnnotatedMembers = this.invokeAppropriateMethodOnRuleAnnotatedMembers(context, Collections::reverse, advice -> {
            try {
                advice.handleTestExecutionException(throwable);
            }
            catch (Throwable t) {
                throw ExceptionUtils.throwAsUncheckedException(t);
            }
        });
        if (numRuleAnnotatedMembers == 0L) {
            throw throwable;
        }
    }

    @Override
    public void afterEach(ExtensionContext context) {
        this.invokeAppropriateMethodOnRuleAnnotatedMembers(context, Collections::reverse, GenericBeforeAndAfterAdvice::after);
    }

    private long invokeAppropriateMethodOnRuleAnnotatedMembers(ExtensionContext context, Consumer<List<TestRuleAnnotatedMember>> ordering, Consumer<GenericBeforeAndAfterAdvice> methodCaller) {
        return Stream.of(this.getRuleAnnotatedMembers(context)).map(ArrayList::new).peek(ordering).flatMap(Collection::stream).filter(annotatedMember -> this.ruleType.isInstance(annotatedMember.getTestRule())).map(this.adapterGenerator).peek(methodCaller).count();
    }

    private List<TestRuleAnnotatedMember> getRuleAnnotatedMembers(ExtensionContext context) {
        Object testInstance = context.getRequiredTestInstance();
        ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create(TestRuleSupport.class, context.getRequiredTestClass());
        return context.getStore(namespace).getOrComputeIfAbsent("rule-annotated-members", key -> this.findRuleAnnotatedMembers(testInstance), List.class);
    }
}

