/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.concurrency.JFXUtilities;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;

public class RecursiveTreeItem<T extends RecursiveTreeObject<T>>
extends TreeItem<T> {
    private Callback<RecursiveTreeObject<T>, ObservableList<T>> childrenFactory;
    private ObjectProperty<Predicate<TreeItem<T>>> predicate = new SimpleObjectProperty(t -> true);
    ObservableList<TreeItem<T>> originalItems = FXCollections.observableArrayList();
    FilteredList<TreeItem<T>> filteredItems;

    public RecursiveTreeItem(Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this(null, null, func);
    }

    public RecursiveTreeItem(T value, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this(value, null, func);
    }

    public RecursiveTreeItem(T value, Node graphic, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        super(value, graphic);
        this.childrenFactory = func;
        this.init((RecursiveTreeObject<T>)value);
    }

    public RecursiveTreeItem(ObservableList<T> dataList, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        RecursiveTreeObject<T> root = new RecursiveTreeObject<T>();
        root.setChildren(dataList);
        this.childrenFactory = func;
        this.init(root);
    }

    private void init(RecursiveTreeObject<T> value) {
        if (value != null) {
            this.addChildrenListener(value);
        }
        this.valueProperty().addListener((o, oldValue, newValue) -> {
            if (newValue != null) {
                this.addChildrenListener((RecursiveTreeObject<T>)newValue);
            }
        });
        this.filteredItems.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> child -> {
            if (child instanceof RecursiveTreeItem && !((RecursiveTreeItem)child).originalItems.isEmpty()) {
                RecursiveTreeItem filterableChild = (RecursiveTreeItem)((Object)((Object)child));
                filterableChild.setPredicate((Predicate)this.predicate.get());
            }
            if (this.predicate.get() == null) {
                return true;
            }
            if (child.getChildren().size() > 0) {
                return true;
            }
            if (child.getValue() instanceof RecursiveTreeObject && ((RecursiveTreeObject)child.getValue()).getClass() == RecursiveTreeObject.class) {
                return child.getChildren().size() != 0;
            }
            return ((Predicate)this.predicate.get()).test(child);
        }, (Observable[])new Observable[]{this.predicate}));
        this.filteredItems.predicateProperty().addListener((o, oldVal, newVal) -> JFXUtilities.runInFXAndWait(() -> {
            this.getChildren().clear();
            this.getChildren().addAll(this.filteredItems);
        }));
    }

    private void addChildrenListener(RecursiveTreeObject<T> value) {
        ObservableList children = (ObservableList)this.childrenFactory.call(value);
        this.originalItems = FXCollections.observableArrayList();
        for (RecursiveTreeObject child : children) {
            this.originalItems.add(new RecursiveTreeItem<RecursiveTreeObject>(child, this.getGraphic(), this.childrenFactory));
        }
        this.filteredItems = new FilteredList(this.originalItems, t -> true);
        this.getChildren().addAll(this.originalItems);
        children.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(t -> {
                        RecursiveTreeItem<RecursiveTreeObject> newItem = new RecursiveTreeItem<RecursiveTreeObject>((RecursiveTreeObject)t, this.getGraphic(), (Callback<RecursiveTreeObject<RecursiveTreeObject>, ObservableList<RecursiveTreeObject>>)this.childrenFactory);
                        this.getChildren().add(newItem);
                        this.originalItems.add(newItem);
                    });
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(t -> {
                    for (int i = 0; i < this.getChildren().size(); ++i) {
                        if (!((RecursiveTreeObject)((TreeItem)this.getChildren().get(i)).getValue()).equals(t)) continue;
                        this.originalItems.remove(this.getChildren().remove(i));
                        --i;
                    }
                });
            }
        });
    }

    public final ObjectProperty<Predicate<TreeItem<T>>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<TreeItem<T>> getPredicate() {
        return (Predicate)this.predicateProperty().get();
    }

    public final void setPredicate(Predicate<TreeItem<T>> predicate) {
        this.predicateProperty().set(predicate);
    }
}

