/*
 * Decompiled with CFR 0.152.
 */
package moe.mickey.minecraft.skin.fx;

import javafx.scene.image.Image;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import org.apache.commons.lang3.ArrayUtils;

public class SkinCube
extends MeshView {
    private double width;
    private double height;
    private double depth;
    private boolean isSlim;
    private Image skin;
    private Mesh model;

    public SkinCube(float width, float height, float depth, float scaleX, float scaleY, float startX, float startY, float enlarge, boolean isSlim) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.isSlim = isSlim;
        this.model = new Model(width + enlarge, height + enlarge, depth + enlarge, scaleX, scaleY, startX, startY, isSlim);
        this.setMesh(this.model);
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getWidth() {
        return this.width;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getHeight() {
        return this.height;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public double getDepth() {
        return this.depth;
    }

    public boolean isSlim() {
        return this.isSlim;
    }

    public Mesh getModel() {
        return this.model;
    }

    public void setModel(Mesh model) {
        this.model = model;
        this.setMesh(model);
    }

    public static class Model
    extends TriangleMesh {
        public Model(float width, float height, float depth, float scaleX, float scaleY, float startX, float startY, boolean isSlim) {
            this.getPoints().addAll(Model.createPoints(width, height, depth));
            this.getTexCoords().addAll(Model.createTexCoords(width, height, depth, scaleX, scaleY, startX, startY, isSlim));
            this.getFaces().addAll(Model.createFaces());
        }

        public static float[] createPoints(float width, float height, float depth) {
            return new float[]{-(width /= 2.0f), -(height /= 2.0f), depth /= 2.0f, width, -height, depth, -width, height, depth, width, height, depth, -width, -height, -depth, width, -height, -depth, -width, height, -depth, width, height, -depth};
        }

        public static float[] createTexCoords(float width, float height, float depth, float scaleX, float scaleY, float startX, float startY, boolean isSlim) {
            float x = (width + depth) * 2.0f;
            float y = height + depth;
            float half_width = width / x * scaleX;
            float half_depth = depth / x * scaleX;
            float top_x = depth / x * scaleX + startX;
            float top_y = startY;
            float arm4 = isSlim ? half_depth : half_width;
            float bottom_x = startX;
            float middle_y = depth / y * scaleY + top_y;
            float bottom_y = scaleY + top_y;
            return new float[]{top_x, top_y, top_x + half_width, top_y, top_x + half_width * 2.0f, top_y, bottom_x, middle_y, bottom_x + half_depth, middle_y, bottom_x + half_depth + half_width, middle_y, bottom_x + scaleX - arm4, middle_y, bottom_x + scaleX, middle_y, bottom_x, bottom_y, bottom_x + half_depth, bottom_y, bottom_x + half_depth + half_width, bottom_y, bottom_x + scaleX - arm4, bottom_y, bottom_x + scaleX, bottom_y};
        }

        public static int[] createFaces() {
            int[] faces = new int[]{5, 0, 4, 1, 0, 5, 5, 0, 0, 5, 1, 4, 0, 5, 4, 6, 6, 11, 0, 5, 6, 11, 2, 10, 1, 4, 0, 5, 2, 10, 1, 4, 2, 10, 3, 9, 5, 3, 1, 4, 3, 9, 5, 3, 3, 9, 7, 8, 4, 6, 5, 7, 7, 12, 4, 6, 7, 12, 6, 11, 3, 5, 2, 6, 6, 2, 3, 5, 6, 2, 7, 1};
            int[] copy = (int[])faces.clone();
            ArrayUtils.reverse(copy);
            for (int i = 0; i < copy.length; i += 2) {
                int tmp = copy[i];
                copy[i] = copy[i + 1];
                copy[i + 1] = tmp;
            }
            return ArrayUtils.addAll(faces, copy);
        }
    }
}

