/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class Metadata {
    public static final String NAME = "HMCL";
    public static final String FULL_NAME = "Hello Minecraft! Launcher";
    public static final String VERSION = System.getProperty("hmcl.version.override", JarUtils.thisJar().flatMap(JarUtils::getImplementationVersion).orElse("@develop@"));
    public static final String TITLE = "HMCL " + VERSION;
    public static final String FULL_TITLE = "Hello Minecraft! Launcher v" + VERSION;
    public static final String UPDATE_URL = System.getProperty("hmcl.update_source.override", "https://hmcl.huangyuhui.net/api/update_link");
    public static final String CONTACT_URL = "https://hmcl.huangyuhui.net/contact";
    public static final String HELP_URL = "https://hmcl.huangyuhui.net/help";
    public static final String CHANGELOG_URL = "https://hmcl.huangyuhui.net/changelog/";
    public static final String PUBLISH_URL = "http://www.mcbbs.net/thread-142335-1-1.html";
    public static final String EULA_URL = "https://hmcl.huangyuhui.net/eula";
    public static final String BUILD_CHANNEL = JarUtils.thisJar().flatMap(JarUtils::getManifest).map(manifest -> manifest.getMainAttributes().getValue("Build-Channel")).orElse("nightly");
    public static final Path MINECRAFT_DIRECTORY = OperatingSystem.getWorkingDirectory("minecraft");
    public static final Path HMCL_DIRECTORY = Metadata.getHMCLDirectory();

    private Metadata() {
    }

    private static Path getHMCLDirectory() {
        String home = System.getProperty("user.home", ".");
        if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX) {
            String xdgCache = System.getenv("XDG_CACHE_HOME");
            if (StringUtils.isNotBlank(xdgCache)) {
                return Paths.get(xdgCache, "hmcl");
            }
            return Paths.get(home, ".cache", "hmcl");
        }
        return OperatingSystem.getWorkingDirectory("hmcl");
    }

    public static boolean isStable() {
        return "stable".equals(BUILD_CHANNEL);
    }

    public static boolean isDev() {
        return "dev".equals(BUILD_CHANNEL);
    }

    public static boolean isNightly() {
        return !Metadata.isStable() && !Metadata.isDev();
    }
}

