/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.countly;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.io.HttpRequest;

public class Countly {
    private String deviceId;
    private String endpoint;
    private String serverURL;
    private static final String APP_KEY = "";

    public void sendMetric(String metrics) throws IOException {
        HttpRequest.GET(this.serverURL + this.endpoint, Pair.pair("begin_session", "1"), Pair.pair("session_id", "1"), Pair.pair("metrics", metrics), Pair.pair("device_id", this.deviceId), Pair.pair("timestamp", Long.toString(System.currentTimeMillis())), Pair.pair("tz", Integer.toString(TimeZone.getDefault().getOffset(new Date().getTime()) / 60000)), Pair.pair("hour", Integer.toString(Countly.currentHour())), Pair.pair("dow", Integer.toString(this.currentDayOfWeek())), Pair.pair("app_key", APP_KEY), Pair.pair("sdk_name", "java-native"), Pair.pair("sdk_version", "20.11.1")).getString();
    }

    private static int getTimezoneOffset() {
        return TimeZone.getDefault().getOffset(new Date().getTime()) / 60000;
    }

    private static String getLocale() {
        Locale locale = Locale.getDefault();
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    private static int currentHour() {
        return Calendar.getInstance().get(11);
    }

    private int currentDayOfWeek() {
        int day = Calendar.getInstance().get(7);
        switch (day) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return 0;
    }
}

