/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Path;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Hex;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.Validation;

public final class AssetObject
implements Validation {
    private final String hash;
    private final long size;

    public AssetObject() {
        this("", 0L);
    }

    public AssetObject(String hash, long size) {
        this.hash = hash;
        this.size = size;
    }

    public String getHash() {
        return this.hash;
    }

    public long getSize() {
        return this.size;
    }

    public String getLocation() {
        return this.hash.substring(0, 2) + "/" + this.hash;
    }

    @Override
    public void validate() throws JsonParseException {
        if (StringUtils.isBlank(this.hash) || this.hash.length() < 2) {
            throw new JsonParseException("AssetObject hash cannot be blank.");
        }
    }

    public boolean validateChecksum(Path file, boolean defaultValue) throws IOException {
        if (this.hash == null) {
            return defaultValue;
        }
        return Hex.encodeHex(DigestUtils.digest("SHA-1", file)).equalsIgnoreCase(this.hash);
    }
}

