/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.Zipper;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class LogExporter {
    private LogExporter() {
    }

    public static CompletableFuture<Void> exportLogs(Path zipFile, DefaultGameRepository gameRepository, String versionId, String logs, String launchScript) {
        Path runDirectory = gameRepository.getRunDirectory(versionId).toPath();
        Path baseDirectory = gameRepository.getBaseDirectory().toPath();
        ArrayList<String> versions = new ArrayList<String>();
        String currentVersionId = versionId;
        HashSet<String> resolvedSoFar = new HashSet<String>();
        while (!resolvedSoFar.contains(currentVersionId)) {
            resolvedSoFar.add(currentVersionId);
            Version currentVersion = gameRepository.getVersion(currentVersionId);
            versions.add(currentVersionId);
            if (!StringUtils.isNotBlank(currentVersion.getInheritsFrom())) break;
            currentVersionId = currentVersion.getInheritsFrom();
        }
        return CompletableFuture.runAsync(() -> {
            try (Zipper zipper = new Zipper(zipFile);){
                if (Files.exists(runDirectory.resolve("logs").resolve("debug.log"), new LinkOption[0])) {
                    zipper.putFile(runDirectory.resolve("logs").resolve("debug.log"), "debug.log");
                }
                if (Files.exists(runDirectory.resolve("logs").resolve("latest.log"), new LinkOption[0])) {
                    zipper.putFile(runDirectory.resolve("logs").resolve("latest.log"), "latest.log");
                }
                zipper.putTextFile(Logging.getLogs(), "hmcl.log");
                zipper.putTextFile(logs, "minecraft.log");
                zipper.putTextFile(launchScript, OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? "launch.bat" : "launch.sh");
                for (String id : versions) {
                    Path versionJson = baseDirectory.resolve("versions").resolve(id).resolve(id + ".json");
                    if (!Files.exists(versionJson, new LinkOption[0])) continue;
                    zipper.putFile(versionJson, id + ".json");
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, Schedulers.io());
    }
}

