/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class OSRestriction {
    private final OperatingSystem name;
    private final String version;
    private final String arch;

    public OSRestriction() {
        this(OperatingSystem.UNKNOWN);
    }

    public OSRestriction(OperatingSystem name) {
        this(name, null);
    }

    public OSRestriction(OperatingSystem name, String version) {
        this(name, version, null);
    }

    public OSRestriction(OperatingSystem name, String version, String arch) {
        this.name = name;
        this.version = version;
        this.arch = arch;
    }

    public OperatingSystem getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean allow() {
        if (this.name != OperatingSystem.UNKNOWN && this.name != OperatingSystem.CURRENT_OS) {
            return false;
        }
        if (this.version != null && Lang.test(() -> !Pattern.compile(this.version).matcher(OperatingSystem.SYSTEM_VERSION).matches())) {
            return false;
        }
        if (this.arch != null) {
            return !Lang.test(() -> !Pattern.compile(this.arch).matcher(Architecture.SYSTEM_ARCH.getCheckedName()).matches());
        }
        return true;
    }
}

