/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.server;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.server.ServerModpackManifest;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Hex;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public class ServerModpackCompletionTask
extends Task<Void> {
    private final DefaultDependencyManager dependencyManager;
    private final DefaultGameRepository repository;
    private final String version;
    private ModpackConfiguration<ServerModpackManifest> manifest;
    private GetTask dependent;
    private ServerModpackManifest remoteManifest;
    private final List<Task<?>> dependencies = new ArrayList();

    public ServerModpackCompletionTask(DefaultDependencyManager dependencyManager, String version) {
        this(dependencyManager, version, null);
    }

    public ServerModpackCompletionTask(DefaultDependencyManager dependencyManager, String version, ModpackConfiguration<ServerModpackManifest> manifest) {
        this.dependencyManager = dependencyManager;
        this.repository = dependencyManager.getGameRepository();
        this.version = version;
        if (manifest == null) {
            try {
                File manifestFile = this.repository.getModpackConfiguration(version);
                if (manifestFile.exists()) {
                    this.manifest = (ModpackConfiguration)JsonUtils.GSON.fromJson(FileUtils.readText(manifestFile), new TypeToken<ModpackConfiguration<ServerModpackManifest>>(){}.getType());
                }
            }
            catch (Exception e) {
                Logging.LOG.log(Level.WARNING, "Unable to read Server modpack manifest.json", e);
            }
        } else {
            this.manifest = manifest;
        }
        this.setStage("hmcl.modpack.download");
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() throws Exception {
        if (this.manifest == null || StringUtils.isBlank(this.manifest.getManifest().getFileApi())) {
            return;
        }
        this.dependent = new GetTask(new URL(this.manifest.getManifest().getFileApi() + "/server-manifest.json"));
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return this.dependent == null ? Collections.emptySet() : Collections.singleton(this.dependent);
    }

    private Map<String, String> toMap(Collection<ServerModpackManifest.Addon> addons) {
        return addons.stream().collect(Collectors.toMap(ServerModpackManifest.Addon::getId, ServerModpackManifest.Addon::getVersion));
    }

    @Override
    public void execute() throws Exception {
        Path actualPath;
        if (this.manifest == null || StringUtils.isBlank(this.manifest.getManifest().getFileApi())) {
            return;
        }
        try {
            this.remoteManifest = JsonUtils.fromNonNullJson((String)this.dependent.getResult(), ServerModpackManifest.class);
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
        Map<String, String> oldAddons = this.toMap(this.manifest.getManifest().getAddons());
        Map<String, String> newAddons = this.toMap(this.remoteManifest.getAddons());
        if (!Objects.equals(oldAddons, newAddons)) {
            GameBuilder builder = this.dependencyManager.gameBuilder().name(this.version);
            for (ServerModpackManifest.Addon addon : this.remoteManifest.getAddons()) {
                builder.version(addon.getId(), addon.getVersion());
            }
            this.dependencies.add(builder.buildAsync());
        }
        Path rootPath = this.repository.getVersionRoot(this.version).toPath();
        Map files = this.manifest.getManifest().getFiles().stream().collect(Collectors.toMap(ModpackConfiguration.FileInformation::getPath, Function.identity()));
        Set remoteFiles = this.remoteManifest.getFiles().stream().map(ModpackConfiguration.FileInformation::getPath).collect(Collectors.toSet());
        int total = 0;
        for (ModpackConfiguration.FileInformation file : this.remoteManifest.getFiles()) {
            boolean download;
            actualPath = rootPath.resolve(file.getPath());
            if (!files.containsKey(file.getPath())) {
                download = true;
            } else if (!Files.exists(actualPath, new LinkOption[0])) {
                download = true;
            } else {
                String fileHash = Hex.encodeHex(DigestUtils.digest("SHA-1", actualPath));
                String oldHash = ((ModpackConfiguration.FileInformation)files.get(file.getPath())).getHash();
                boolean bl = download = !Objects.equals(oldHash, file.getHash()) && Objects.equals(oldHash, fileHash);
            }
            if (!download) continue;
            ++total;
            this.dependencies.add(new FileDownloadTask(new URL(this.remoteManifest.getFileApi() + "/overrides/" + NetworkUtils.encodeLocation(file.getPath())), actualPath.toFile(), new FileDownloadTask.IntegrityCheck("SHA-1", file.getHash())).withCounter("hmcl.modpack.download"));
        }
        for (ModpackConfiguration.FileInformation file : this.manifest.getManifest().getFiles()) {
            actualPath = rootPath.resolve(file.getPath());
            if (!Files.exists(actualPath, new LinkOption[0]) || remoteFiles.contains(file.getPath())) continue;
            Files.deleteIfExists(actualPath);
        }
        this.getProperties().put("total", this.dependencies.size());
        this.notifyPropertiesChanged();
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        if (this.manifest == null || StringUtils.isBlank(this.manifest.getManifest().getFileApi())) {
            return;
        }
        File manifestFile = this.repository.getModpackConfiguration(this.version);
        FileUtils.writeText(manifestFile, JsonUtils.GSON.toJson(new ModpackConfiguration<ServerModpackManifest>(this.remoteManifest, this.manifest.getType(), this.manifest.getName(), this.manifest.getVersion(), this.remoteManifest.getFiles())));
    }
}

