/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Level;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.Config;
import org.jackhuang.hmcl.setting.ConfigUpgrader;
import org.jackhuang.hmcl.setting.GlobalConfig;
import org.jackhuang.hmcl.setting.SambaException;
import org.jackhuang.hmcl.setting.Settings;
import org.jackhuang.hmcl.util.InvocationDispatcher;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class ConfigHolder {
    public static final String CONFIG_FILENAME = "hmcl.json";
    public static final String CONFIG_FILENAME_LINUX = ".hmcl.json";
    public static final Path GLOBAL_CONFIG_PATH = Metadata.HMCL_DIRECTORY.resolve("config.json");
    private static Path configLocation;
    private static Config configInstance;
    private static GlobalConfig globalConfigInstance;
    private static boolean newlyCreated;
    private static final InvocationDispatcher<String> configWriter;
    private static final InvocationDispatcher<String> globalConfigWriter;

    private ConfigHolder() {
    }

    public static Config config() {
        if (configInstance == null) {
            throw new IllegalStateException("Configuration hasn't been loaded");
        }
        return configInstance;
    }

    public static GlobalConfig globalConfig() {
        if (globalConfigInstance == null) {
            throw new IllegalStateException("Configuration hasn't been loaded");
        }
        return globalConfigInstance;
    }

    public static boolean isNewlyCreated() {
        return newlyCreated;
    }

    public static synchronized void init() throws IOException {
        if (configInstance != null) {
            throw new IllegalStateException("Configuration is already loaded");
        }
        configLocation = ConfigHolder.locateConfig();
        Logging.LOG.log(Level.INFO, "Config location: " + configLocation);
        configInstance = ConfigHolder.loadConfig();
        configInstance.addListener(source -> ConfigHolder.markConfigDirty());
        globalConfigInstance = ConfigHolder.loadGlobalConfig();
        globalConfigInstance.addListener(source -> ConfigHolder.markGlobalConfigDirty());
        Settings.init();
        if (newlyCreated) {
            ConfigHolder.saveConfigSync();
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                try {
                    Files.setAttribute(configLocation, "dos:hidden", true, new LinkOption[0]);
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to set hidden attribute of " + configLocation, e);
                }
            }
        }
        if (!Files.isWritable(configLocation)) {
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && configLocation.getFileSystem() == FileSystems.getDefault() && configLocation.toFile().canWrite()) {
                throw new SambaException();
            }
            throw new IOException("Config at " + configLocation + " is not writable");
        }
    }

    private static Path locateConfig() {
        Path exePath = Paths.get("", new String[0]);
        try {
            Path jarPath = Paths.get(ConfigHolder.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toAbsolutePath();
            if (Files.isRegularFile(jarPath, new LinkOption[0]) && Files.isWritable(jarPath)) {
                exePath = jarPath = jarPath.getParent();
                Path config = jarPath.resolve(CONFIG_FILENAME);
                if (Files.isRegularFile(config, new LinkOption[0])) {
                    return config;
                }
                Path dotConfig = jarPath.resolve(CONFIG_FILENAME_LINUX);
                if (Files.isRegularFile(dotConfig, new LinkOption[0])) {
                    return dotConfig;
                }
            }
        }
        catch (Throwable jarPath) {
            // empty catch block
        }
        Path config = Paths.get(CONFIG_FILENAME, new String[0]);
        if (Files.isRegularFile(config, new LinkOption[0])) {
            return config;
        }
        Path dotConfig = Paths.get(CONFIG_FILENAME_LINUX, new String[0]);
        if (Files.isRegularFile(dotConfig, new LinkOption[0])) {
            return dotConfig;
        }
        return exePath.resolve(OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? CONFIG_FILENAME : CONFIG_FILENAME_LINUX);
    }

    private static Config loadConfig() throws IOException {
        if (Files.exists(configLocation, new LinkOption[0])) {
            try {
                String content = FileUtils.readText(configLocation);
                Config deserialized = Config.fromJson(content);
                if (deserialized != null) {
                    Map raw = new Gson().fromJson(content, Map.class);
                    ConfigUpgrader.upgradeConfig(deserialized, raw);
                    return deserialized;
                }
                Logging.LOG.info("Config is empty");
            }
            catch (JsonParseException e) {
                Logging.LOG.log(Level.WARNING, "Malformed config.", e);
            }
        }
        Logging.LOG.info("Creating an empty config");
        newlyCreated = true;
        return new Config();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToConfig(String content) throws IOException {
        Logging.LOG.info("Saving config");
        Path path = configLocation;
        synchronized (path) {
            FileUtils.saveSafely(configLocation, content);
        }
    }

    static void markConfigDirty() {
        configWriter.accept(configInstance.toJson());
    }

    private static void saveConfigSync() throws IOException {
        ConfigHolder.writeToConfig(configInstance.toJson());
    }

    private static GlobalConfig loadGlobalConfig() throws IOException {
        if (Files.exists(GLOBAL_CONFIG_PATH, new LinkOption[0])) {
            try {
                String content = FileUtils.readText(GLOBAL_CONFIG_PATH);
                GlobalConfig deserialized = GlobalConfig.fromJson(content);
                if (deserialized != null) {
                    return deserialized;
                }
                Logging.LOG.info("Config is empty");
            }
            catch (JsonParseException e) {
                Logging.LOG.log(Level.WARNING, "Malformed config.", e);
            }
        }
        Logging.LOG.info("Creating an empty global config");
        return new GlobalConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToGlobalConfig(String content) throws IOException {
        Logging.LOG.info("Saving global config");
        Path path = GLOBAL_CONFIG_PATH;
        synchronized (path) {
            FileUtils.saveSafely(GLOBAL_CONFIG_PATH, content);
        }
    }

    static void markGlobalConfigDirty() {
        globalConfigWriter.accept(globalConfigInstance.toJson());
    }

    private static void saveGlobalConfigSync() throws IOException {
        ConfigHolder.writeToConfig(globalConfigInstance.toJson());
    }

    static {
        configWriter = InvocationDispatcher.runOn(Lang::thread, content -> {
            try {
                ConfigHolder.writeToConfig(content);
            }
            catch (IOException e) {
                Logging.LOG.log(Level.SEVERE, "Failed to save config", e);
            }
        });
        globalConfigWriter = InvocationDispatcher.runOn(Lang::thread, content -> {
            try {
                ConfigHolder.writeToGlobalConfig(content);
            }
            catch (IOException e) {
                Logging.LOG.log(Level.SEVERE, "Failed to save config", e);
            }
        });
    }
}

