/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.scene.paint.Color;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.ResourceNotFoundError;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

@JsonAdapter(value=TypeAdapter.class)
public class Theme {
    public static final Theme BLUE = new Theme("blue", "#5C6BC0");
    public static final Color BLACK = Color.web((String)"#292929");
    public static final Color[] SUGGESTED_COLORS = new Color[]{Color.web((String)"#3D6DA3"), Color.web((String)"#283593"), Color.web((String)"#43A047"), Color.web((String)"#E67E22"), Color.web((String)"#9C27B0"), Color.web((String)"#B71C1C")};
    private final Color paint;
    private final String color;
    private final String name;

    Theme(String name, String color) {
        this.name = name;
        this.color = Objects.requireNonNull(color);
        this.paint = Color.web((String)color);
    }

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isCustom() {
        return this.name.startsWith("#");
    }

    public boolean isLight() {
        return Color.web((String)this.color).grayscale().getRed() >= 0.5;
    }

    public Color getForegroundColor() {
        return this.isLight() ? Color.BLACK : Color.WHITE;
    }

    public String[] getStylesheets(String overrideFontFamily) {
        String css;
        Color textFill = this.getForegroundColor();
        String fontFamily = System.getProperty("hmcl.font.override") != null ? System.getProperty("hmcl.font.override") : (overrideFontFamily != null ? overrideFontFamily : null);
        try {
            File temp = File.createTempFile("hmcl", ".css");
            FileUtils.writeText(temp, IOUtils.readFullyAsString(ResourceNotFoundError.getResourceAsStream("/assets/css/custom.css")).replace("%base-color%", this.color).replace("%base-red%", Integer.toString((int)Math.ceil(this.paint.getRed() * 256.0))).replace("%base-green%", Integer.toString((int)Math.ceil(this.paint.getGreen() * 256.0))).replace("%base-blue%", Integer.toString((int)Math.ceil(this.paint.getBlue() * 256.0))).replace("%base-rippler-color%", String.format("rgba(%d, %d, %d, 0.3)", (int)Math.ceil(this.paint.getRed() * 256.0), (int)Math.ceil(this.paint.getGreen() * 256.0), (int)Math.ceil(this.paint.getBlue() * 256.0))).replace("%disabled-font-color%", String.format("rgba(%d, %d, %d, 0.7)", (int)Math.ceil(textFill.getRed() * 256.0), (int)Math.ceil(textFill.getGreen() * 256.0), (int)Math.ceil(textFill.getBlue() * 256.0))).replace("%font-color%", Theme.getColorDisplayName(this.getForegroundColor())).replace("%font%", Optional.ofNullable(fontFamily).map(f -> "-fx-font-family: \"" + f + "\";").orElse("")));
            css = temp.toURI().toString();
        }
        catch (IOException | NullPointerException e) {
            Logging.LOG.log(Level.SEVERE, "Unable to create theme stylesheet. Fallback to blue theme.", e);
            css = "/assets/css/blue.css";
        }
        return new String[]{css, "/assets/css/root.css"};
    }

    public static Theme custom(String color) {
        if (!color.startsWith("#")) {
            throw new IllegalArgumentException();
        }
        return new Theme(color, color);
    }

    public static Optional<Theme> getTheme(String name) {
        if (name == null) {
            return Optional.empty();
        }
        if (name.equalsIgnoreCase("blue")) {
            return Optional.of(Theme.custom("#5C6BC0"));
        }
        if (name.equalsIgnoreCase("darker_blue")) {
            return Optional.of(Theme.custom("#283593"));
        }
        if (name.equalsIgnoreCase("green")) {
            return Optional.of(Theme.custom("#43A047"));
        }
        if (name.equalsIgnoreCase("orange")) {
            return Optional.of(Theme.custom("#E67E22"));
        }
        if (name.equalsIgnoreCase("purple")) {
            return Optional.of(Theme.custom("#9C27B0"));
        }
        if (name.equalsIgnoreCase("red")) {
            return Optional.of(Theme.custom("#F44336"));
        }
        if (name.startsWith("#")) {
            try {
                Color.web((String)name);
                return Optional.of(Theme.custom(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static String getColorDisplayName(Color c) {
        return c != null ? String.format("#%02x%02x%02x", Math.round(c.getRed() * 255.0), Math.round(c.getGreen() * 255.0), Math.round(c.getBlue() * 255.0)).toUpperCase() : null;
    }

    public static ObjectBinding<Color> foregroundFillBinding() {
        return BindingMapping.of(ConfigHolder.config().themeProperty()).map(Theme::getForegroundColor);
    }

    public static ObjectBinding<Color> blackFillBinding() {
        return Bindings.createObjectBinding(() -> BLACK, (Observable[])new Observable[0]);
    }

    public static ObjectBinding<Color> whiteFillBinding() {
        return Bindings.createObjectBinding(() -> Color.WHITE, (Observable[])new Observable[0]);
    }

    public static class TypeAdapter
    extends com.google.gson.TypeAdapter<Theme> {
        @Override
        public void write(JsonWriter out, Theme value) throws IOException {
            out.value(value.getName().toLowerCase());
        }

        @Override
        public Theme read(JsonReader in) throws IOException {
            return Theme.getTheme(in.nextString()).orElse(BLUE);
        }
    }
}

