/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskListener;
import org.jetbrains.annotations.Nullable;

public abstract class TaskExecutor {
    protected final Task<?> firstTask;
    protected final List<TaskListener> taskListeners = new ArrayList<TaskListener>();
    protected final AtomicInteger totTask = new AtomicInteger(0);
    protected final AtomicBoolean cancelled = new AtomicBoolean(false);
    protected Exception exception;
    private final List<String> stages;

    public TaskExecutor(Task<?> task) {
        this.firstTask = task;
        this.stages = task instanceof Task.StagesHintTask ? ((Task.StagesHintTask)task).getStages() : Collections.emptyList();
    }

    public void addTaskListener(TaskListener taskListener) {
        this.taskListeners.add(taskListener);
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public abstract TaskExecutor start();

    public abstract boolean test();

    public abstract void cancel();

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public int getTaskCount() {
        return this.totTask.get();
    }

    public List<String> getStages() {
        return this.stages;
    }
}

