/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.download.java.JavaRepository;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.EnumCommonDirectory;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.account.AccountListPage;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.InputDialogPane;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PromptDialogPane;
import org.jackhuang.hmcl.ui.construct.TaskExecutorDialogPane;
import org.jackhuang.hmcl.ui.decorator.DecoratorController;
import org.jackhuang.hmcl.ui.download.DownloadPage;
import org.jackhuang.hmcl.ui.download.ModpackInstallWizardProvider;
import org.jackhuang.hmcl.ui.main.LauncherSettingsPage;
import org.jackhuang.hmcl.ui.main.RootPage;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerPage;
import org.jackhuang.hmcl.ui.versions.GameListPage;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.FutureCallback;
import org.jackhuang.hmcl.util.Lazy;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.JavaVersion;

public final class Controllers {
    private static DoubleProperty stageWidth = new SimpleDoubleProperty();
    private static DoubleProperty stageHeight = new SimpleDoubleProperty();
    private static Scene scene;
    private static Stage stage;
    private static Lazy<VersionPage> versionPage;
    private static Lazy<GameListPage> gameListPage;
    private static Lazy<RootPage> rootPage;
    private static DecoratorController decorator;
    private static Lazy<DownloadPage> downloadPage;
    private static Lazy<AccountListPage> accountListPage;
    private static Lazy<MultiplayerPage> multiplayerPage;
    private static Lazy<LauncherSettingsPage> settingsPage;

    private Controllers() {
    }

    public static Scene getScene() {
        return scene;
    }

    public static Stage getStage() {
        return stage;
    }

    public static VersionPage getVersionPage() {
        return versionPage.get();
    }

    public static GameListPage getGameListPage() {
        return gameListPage.get();
    }

    public static RootPage getRootPage() {
        return rootPage.get();
    }

    public static MultiplayerPage getMultiplayerPage() {
        return multiplayerPage.get();
    }

    public static LauncherSettingsPage getSettingsPage() {
        return settingsPage.get();
    }

    public static AccountListPage getAccountListPage() {
        return accountListPage.get();
    }

    public static DownloadPage getDownloadPage() {
        return downloadPage.get();
    }

    public static DecoratorController getDecorator() {
        return decorator;
    }

    public static void onApplicationStop() {
        ConfigHolder.config().setHeight(stageHeight.get());
        ConfigHolder.config().setWidth(stageWidth.get());
        stageHeight = null;
        stageWidth = null;
    }

    public static void initialize(Stage stage) {
        Logging.LOG.info("Start initializing application");
        Controllers.stage = stage;
        stage.setHeight(ConfigHolder.config().getHeight());
        stageHeight.bind((ObservableValue)stage.heightProperty());
        stage.setWidth(ConfigHolder.config().getWidth());
        stageWidth.bind((ObservableValue)stage.widthProperty());
        stage.setOnCloseRequest(e -> Launcher.stopApplication());
        decorator = new DecoratorController(stage, (Node)Controllers.getRootPage());
        if (ConfigHolder.config().getCommonDirType() == EnumCommonDirectory.CUSTOM && !FileUtils.canCreateDirectory(ConfigHolder.config().getCommonDirectory())) {
            ConfigHolder.config().setCommonDirType(EnumCommonDirectory.DEFAULT);
            Controllers.dialog(I18n.i18n("launcher.cache_directory.invalid"));
        }
        Task.runAsync(JavaVersion::initialize).thenRunAsync(JavaRepository::initialize).start();
        scene = new Scene((Parent)decorator.getDecorator());
        scene.setFill((Paint)Color.TRANSPARENT);
        stage.setMinHeight(508.0);
        stage.setMinWidth(818.0);
        decorator.getDecorator().prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        decorator.getDecorator().prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        scene.getStylesheets().setAll((Object[])ConfigHolder.config().getTheme().getStylesheets(ConfigHolder.config().getLauncherFontFamily()));
        stage.getIcons().add((Object)FXUtils.newImage("/assets/img/icon.png"));
        stage.setTitle(Metadata.FULL_TITLE);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setScene(scene);
        if (ConfigHolder.globalConfig().getAgreementVersion() < 1) {
            JFXDialogLayout agreementPane = new JFXDialogLayout();
            agreementPane.setHeading(new Node[]{new Label(I18n.i18n("launcher.agreement"))});
            agreementPane.setBody(new Node[]{new Label(I18n.i18n("launcher.agreement.hint"))});
            JFXHyperlink agreementLink = new JFXHyperlink(I18n.i18n("launcher.agreement"));
            agreementLink.setOnAction(e -> FXUtils.openLink("https://hmcl.huangyuhui.net/eula"));
            JFXButton yesButton = new JFXButton(I18n.i18n("launcher.agreement.accept"));
            yesButton.getStyleClass().add((Object)"dialog-accept");
            yesButton.setOnAction(e -> {
                ConfigHolder.globalConfig().setAgreementVersion(1);
                agreementPane.fireEvent(new DialogCloseEvent());
            });
            JFXButton noButton = new JFXButton(I18n.i18n("launcher.agreement.decline"));
            noButton.getStyleClass().add((Object)"dialog-cancel");
            noButton.setOnAction(e -> System.exit(1));
            agreementPane.setActions(new Node[]{agreementLink, yesButton, noButton});
            Controllers.dialog((Region)agreementPane);
        }
    }

    public static void dialog(Region content) {
        if (decorator != null) {
            decorator.showDialog((Node)content);
        }
    }

    public static void dialog(String text) {
        Controllers.dialog(text, null);
    }

    public static void dialog(String text, String title) {
        Controllers.dialog(text, title, MessageDialogPane.MessageType.INFO);
    }

    public static void dialog(String text, String title, MessageDialogPane.MessageType type) {
        Controllers.dialog(text, title, type, null);
    }

    public static void dialog(String text, String title, MessageDialogPane.MessageType type, Runnable ok) {
        Controllers.dialog((Region)new MessageDialogPane.Builder(text, title, type).ok(ok).build());
    }

    public static void confirm(String text, String title, Runnable yes, Runnable no) {
        Controllers.confirm(text, title, MessageDialogPane.MessageType.QUESTION, yes, no);
    }

    public static void confirm(String text, String title, MessageDialogPane.MessageType type, Runnable yes, Runnable no) {
        Controllers.dialog((Region)new MessageDialogPane.Builder(text, title, type).yesOrNo(yes, no).build());
    }

    public static void confirmAction(String text, String title, MessageDialogPane.MessageType type, ButtonBase actionButton) {
        Controllers.dialog((Region)new MessageDialogPane.Builder(text, title, type).actionOrCancel(actionButton, null).build());
    }

    public static void confirmAction(String text, String title, MessageDialogPane.MessageType type, ButtonBase actionButton, Runnable cancel) {
        Controllers.dialog((Region)new MessageDialogPane.Builder(text, title, type).actionOrCancel(actionButton, cancel).build());
    }

    public static CompletableFuture<String> prompt(String title, FutureCallback<String> onResult) {
        return Controllers.prompt(title, onResult, "");
    }

    public static CompletableFuture<String> prompt(String title, FutureCallback<String> onResult, String initialValue) {
        InputDialogPane pane = new InputDialogPane(title, initialValue, onResult);
        Controllers.dialog((Region)pane);
        return pane.getCompletableFuture();
    }

    public static CompletableFuture<List<PromptDialogPane.Builder.Question<?>>> prompt(PromptDialogPane.Builder builder) {
        PromptDialogPane pane = new PromptDialogPane(builder);
        Controllers.dialog((Region)pane);
        return pane.getCompletableFuture();
    }

    public static TaskExecutorDialogPane taskDialog(TaskExecutor executor, String title) {
        return Controllers.taskDialog(executor, title, null);
    }

    public static TaskExecutorDialogPane taskDialog(TaskExecutor executor, String title, Consumer<Region> onCancel) {
        TaskExecutorDialogPane pane = new TaskExecutorDialogPane(onCancel);
        pane.setTitle(title);
        pane.setExecutor(executor);
        Controllers.dialog((Region)pane);
        return pane;
    }

    public static TaskExecutorDialogPane taskDialog(Task<?> task, String title, Consumer<Region> onCancel) {
        TaskExecutor executor = task.executor();
        TaskExecutorDialogPane pane = new TaskExecutorDialogPane(onCancel);
        pane.setTitle(title);
        pane.setExecutor(executor);
        Controllers.dialog((Region)pane);
        executor.start();
        return pane;
    }

    public static void navigate(Node node) {
        decorator.navigate(node);
    }

    public static void showToast(String content) {
        decorator.showToast(content);
    }

    public static void onHyperlinkAction(String href) {
        if (href.startsWith("hmcl://")) {
            if ("hmcl://settings/feedback".equals(href)) {
                Controllers.getSettingsPage().showFeedback();
                Controllers.navigate((Node)Controllers.getSettingsPage());
            }
        } else {
            FXUtils.openLink(href);
        }
    }

    public static boolean isStopped() {
        return decorator == null;
    }

    public static void shutdown() {
        rootPage = null;
        versionPage = null;
        gameListPage = null;
        settingsPage = null;
        decorator = null;
        stage = null;
        scene = null;
    }

    static {
        versionPage = new Lazy<VersionPage>(VersionPage::new);
        gameListPage = new Lazy<GameListPage>(() -> {
            GameListPage gameListPage = new GameListPage();
            gameListPage.selectedProfileProperty().bindBidirectional(Profiles.selectedProfileProperty());
            gameListPage.profilesProperty().bindContent(Profiles.profilesProperty());
            FXUtils.applyDragListener((Node)gameListPage, it -> "zip".equals(FileUtils.getExtension(it)), modpacks -> {
                File modpack = (File)modpacks.get(0);
                Controllers.getDecorator().startWizard(new ModpackInstallWizardProvider(Profiles.getSelectedProfile(), modpack), I18n.i18n("install.modpack"));
            });
            return gameListPage;
        });
        rootPage = new Lazy<RootPage>(RootPage::new);
        downloadPage = new Lazy<DownloadPage>(DownloadPage::new);
        accountListPage = new Lazy<AccountListPage>(() -> {
            AccountListPage accountListPage = new AccountListPage();
            accountListPage.selectedAccountProperty().bindBidirectional(Accounts.selectedAccountProperty());
            accountListPage.accountsProperty().bindContent(Accounts.accountsProperty());
            accountListPage.authServersProperty().bindContentBidirectional(ConfigHolder.config().getAuthlibInjectorServers());
            return accountListPage;
        });
        multiplayerPage = new Lazy<MultiplayerPage>(MultiplayerPage::new);
        settingsPage = new Lazy<LauncherSettingsPage>(LauncherSettingsPage::new);
    }
}

