/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import java.util.logging.Level;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;

public class UpgradeDialog
extends JFXDialogLayout {
    public UpgradeDialog(RemoteVersion remoteVersion, Runnable updateRunnable) {
        this.setHeading(new Node[]{new Label(I18n.i18n("update.changelog"))});
        String url = "https://hmcl.huangyuhui.net/changelog/" + remoteVersion.getChannel().channelName + ".html";
        try {
            WebView webView = new WebView();
            webView.getEngine().setUserDataDirectory(Metadata.HMCL_DIRECTORY.toFile());
            WebEngine engine = webView.getEngine();
            engine.load(url);
            engine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue == Worker.State.FAILED) {
                    Logging.LOG.warning("Failed to load update log, trying to open it in browser");
                    FXUtils.openLink(url);
                    this.setBody(new Node[0]);
                }
            });
            this.setBody(new Node[]{webView});
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e2) {
            Logging.LOG.log(Level.WARNING, "WebView is missing or initialization failed", e2);
            FXUtils.openLink(url);
        }
        JFXButton updateButton = new JFXButton(I18n.i18n("update.accept"));
        updateButton.getStyleClass().add((Object)"dialog-accept");
        updateButton.setOnMouseClicked(e -> updateRunnable.run());
        JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
        cancelButton.getStyleClass().add((Object)"dialog-cancel");
        cancelButton.setOnMouseClicked(e -> this.fireEvent(new DialogCloseEvent()));
        this.setActions(new Node[]{updateButton, cancelButton});
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
    }
}

