/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;

class ComponentListCell
extends StackPane {
    private final Node content;
    private Animation expandAnimation;
    private Rectangle clipRect;
    private final BooleanProperty expanded = new SimpleBooleanProperty((Object)this, "expanded", false);

    ComponentListCell(Node content) {
        this.content = content;
        this.updateLayout();
    }

    private void updateClip(double newHeight) {
        if (this.clipRect != null) {
            this.clipRect.setHeight(newHeight);
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.clipRect == null) {
            this.clipRect = new Rectangle(0.0, 0.0, this.getWidth(), this.getHeight());
        } else {
            this.clipRect.setX(0.0);
            this.clipRect.setY(0.0);
            this.clipRect.setHeight(this.getHeight());
            this.clipRect.setWidth(this.getWidth());
        }
    }

    private void updateLayout() {
        if (this.content instanceof ComponentList) {
            Node rightNode;
            Node leftNode;
            ComponentList list = (ComponentList)this.content;
            this.content.getStyleClass().remove((Object)"options-list");
            this.content.getStyleClass().add((Object)"options-sublist");
            this.getStyleClass().add((Object)"no-padding");
            VBox groupNode = new VBox();
            Node expandIcon = SVG.expand(Theme.blackFillBinding(), 20.0, 20.0);
            JFXButton expandButton = new JFXButton();
            expandButton.setGraphic(expandIcon);
            expandButton.getStyleClass().add((Object)"options-list-item-expand-button");
            VBox labelVBox = new VBox();
            labelVBox.setMouseTransparent(true);
            labelVBox.setAlignment(Pos.CENTER_LEFT);
            boolean overrideHeaderLeft = false;
            if (list instanceof ComponentSublist && (leftNode = ((ComponentSublist)list).getHeaderLeft()) != null) {
                labelVBox.getChildren().setAll((Object[])new Node[]{leftNode});
                overrideHeaderLeft = true;
            }
            if (!overrideHeaderLeft) {
                Label label = new Label();
                label.textProperty().bind((ObservableValue)list.titleProperty());
                labelVBox.getChildren().add((Object)label);
                if (list.isHasSubtitle()) {
                    Label subtitleLabel = new Label();
                    subtitleLabel.textProperty().bind((ObservableValue)list.subtitleProperty());
                    subtitleLabel.getStyleClass().add((Object)"subtitle-label");
                    labelVBox.getChildren().add((Object)subtitleLabel);
                }
            }
            HBox header = new HBox();
            header.setSpacing(16.0);
            header.getChildren().add((Object)labelVBox);
            header.setPadding(new Insets(10.0, 16.0, 10.0, 16.0));
            header.setAlignment(Pos.CENTER_LEFT);
            HBox.setHgrow((Node)labelVBox, (Priority)Priority.ALWAYS);
            if (list instanceof ComponentSublist && (rightNode = ((ComponentSublist)list).getHeaderRight()) != null) {
                header.getChildren().add((Object)rightNode);
            }
            header.getChildren().add((Object)expandButton);
            RipplerContainer headerRippler = new RipplerContainer((Node)header);
            groupNode.getChildren().add((Object)headerRippler);
            VBox container = new VBox();
            container.setPadding(new Insets(8.0, 16.0, 10.0, 16.0));
            FXUtils.setLimitHeight((Region)container, 0.0);
            FXUtils.setOverflowHidden((Region)container);
            container.getChildren().setAll((Object[])new Node[]{this.content});
            groupNode.getChildren().add((Object)container);
            Runnable onExpand = () -> {
                if (this.expandAnimation != null && this.expandAnimation.getStatus() == Animation.Status.RUNNING) {
                    this.expandAnimation.stop();
                }
                this.setExpanded(!this.isExpanded());
                if (this.isExpanded()) {
                    list.onExpand();
                    list.layout();
                }
                Platform.runLater(() -> {
                    double contentHeight;
                    double newAnimatedHeight = (this.content.prefHeight(-1.0) + 8.0 + 10.0) * (double)(this.isExpanded() ? 1 : -1);
                    double newHeight = this.isExpanded() ? this.getHeight() + newAnimatedHeight : this.prefHeight(-1.0);
                    double d = contentHeight = this.isExpanded() ? newAnimatedHeight : 0.0;
                    if (this.isExpanded()) {
                        this.updateClip(newHeight);
                    }
                    this.expandAnimation = new Timeline(new KeyFrame[]{new KeyFrame(new Duration(320.0), new KeyValue[]{new KeyValue((WritableValue)container.minHeightProperty(), (Object)contentHeight, FXUtils.SINE), new KeyValue((WritableValue)container.maxHeightProperty(), (Object)contentHeight, FXUtils.SINE)})});
                    if (!this.isExpanded()) {
                        this.expandAnimation.setOnFinished(e2 -> this.updateClip(newHeight));
                    }
                    this.expandAnimation.play();
                });
            };
            headerRippler.setOnMouseClicked(e -> onExpand.run());
            expandButton.setOnMouseClicked(e -> onExpand.run());
            this.expandedProperty().addListener((a, b, newValue) -> expandIcon.setRotate(newValue != false ? 180.0 : 0.0));
            this.getChildren().setAll((Object[])new Node[]{groupNode});
        } else {
            this.getStyleClass().remove((Object)"no-padding");
            this.getChildren().setAll((Object[])new Node[]{this.content});
        }
    }

    public boolean isExpanded() {
        return this.expanded.get();
    }

    public BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded.set(expanded);
    }
}

