/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXProgressBar;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.util.i18n.I18n;

public class DialogPane
extends JFXDialogLayout {
    private final StringProperty title = new SimpleStringProperty();
    private final BooleanProperty valid = new SimpleBooleanProperty();
    protected final SpinnerPane acceptPane = new SpinnerPane();
    protected final JFXButton cancelButton = new JFXButton();
    protected final Label warningLabel = new Label();
    private final JFXProgressBar progressBar = new JFXProgressBar();

    public DialogPane() {
        Label titleLabel = new Label();
        titleLabel.textProperty().bind((ObservableValue)this.title);
        this.setHeading(new Node[]{titleLabel});
        this.getChildren().add((Object)this.progressBar);
        this.progressBar.setVisible(false);
        StackPane.setMargin((Node)this.progressBar, (Insets)new Insets(-24.0, -24.0, -16.0, -24.0));
        StackPane.setAlignment((Node)this.progressBar, (Pos)Pos.TOP_CENTER);
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
        JFXButton acceptButton = new JFXButton(I18n.i18n("button.ok"));
        acceptButton.setOnAction(e -> this.onAccept());
        acceptButton.disableProperty().bind((ObservableValue)this.valid.not());
        acceptButton.getStyleClass().add((Object)"dialog-accept");
        this.acceptPane.getStyleClass().add((Object)"small-spinner-pane");
        this.acceptPane.setContent((Node)acceptButton);
        this.cancelButton.setText(I18n.i18n("button.cancel"));
        this.cancelButton.setOnAction(e -> this.onCancel());
        this.cancelButton.getStyleClass().add((Object)"dialog-cancel");
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)this.cancelButton).fire());
        this.setActions(new Node[]{this.warningLabel, this.acceptPane, this.cancelButton});
    }

    protected JFXProgressBar getProgressBar() {
        return this.progressBar;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public BooleanProperty validProperty() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid.set(valid);
    }

    protected void onCancel() {
        this.fireEvent(new DialogCloseEvent());
    }

    protected void onAccept() {
        this.fireEvent(new DialogCloseEvent());
    }

    protected void setLoading() {
        this.acceptPane.showSpinner();
        this.warningLabel.setText("");
    }

    protected void onSuccess() {
        this.acceptPane.hideSpinner();
        this.fireEvent(new DialogCloseEvent());
    }

    protected void onFailure(String msg) {
        this.acceptPane.hideSpinner();
        this.warningLabel.setText(msg);
    }
}

