/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXCheckBox;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TreeTableCell;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class JFXCheckBoxTreeTableCell<S, T>
extends TreeTableCell<S, T> {
    private final CheckBox checkBox;
    private boolean showLabel;
    private ObservableValue<Boolean> booleanProperty;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>((Object)this, "converter"){

        protected void invalidated() {
            JFXCheckBoxTreeTableCell.this.updateShowLabel();
        }
    };
    private ObjectProperty<Callback<Integer, ObservableValue<Boolean>>> selectedStateCallback = new SimpleObjectProperty((Object)this, "selectedStateCallback");

    public JFXCheckBoxTreeTableCell() {
        this(null, null);
    }

    public JFXCheckBoxTreeTableCell(Callback<Integer, ObservableValue<Boolean>> getSelectedProperty) {
        this(getSelectedProperty, null);
    }

    public JFXCheckBoxTreeTableCell(Callback<Integer, ObservableValue<Boolean>> getSelectedProperty, StringConverter<T> converter) {
        this.getStyleClass().add((Object)"check-box-tree-table-cell");
        this.checkBox = new JFXCheckBox();
        this.setGraphic(null);
        this.setSelectedStateCallback(getSelectedProperty);
        this.setConverter(converter);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public final ObjectProperty<Callback<Integer, ObservableValue<Boolean>>> selectedStateCallbackProperty() {
        return this.selectedStateCallback;
    }

    public final void setSelectedStateCallback(Callback<Integer, ObservableValue<Boolean>> value) {
        this.selectedStateCallbackProperty().set(value);
    }

    public final Callback<Integer, ObservableValue<Boolean>> getSelectedStateCallback() {
        return (Callback)this.selectedStateCallbackProperty().get();
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            ObservableValue<?> obsValue;
            StringConverter<T> c = this.getConverter();
            if (this.showLabel) {
                this.setText(c.toString(item));
            }
            this.setGraphic((Node)this.checkBox);
            if (this.booleanProperty instanceof BooleanProperty) {
                this.checkBox.selectedProperty().unbindBidirectional((Property)((BooleanProperty)this.booleanProperty));
            }
            if ((obsValue = this.getSelectedProperty()) instanceof BooleanProperty) {
                this.booleanProperty = obsValue;
                this.checkBox.selectedProperty().bindBidirectional((Property)((BooleanProperty)this.booleanProperty));
            }
            this.checkBox.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.getTreeTableView().editableProperty().and((ObservableBooleanValue)this.getTableColumn().editableProperty()).and((ObservableBooleanValue)this.editableProperty())));
        }
    }

    private void updateShowLabel() {
        this.showLabel = this.converter != null;
        this.checkBox.setAlignment(this.showLabel ? Pos.CENTER_LEFT : Pos.CENTER);
    }

    private ObservableValue<?> getSelectedProperty() {
        return this.getSelectedStateCallback() != null ? (ObservableValue)this.getSelectedStateCallback().call((Object)this.getIndex()) : this.getTableColumn().getCellObservableValue(this.getIndex());
    }
}

