/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageDialogPane
extends StackPane {
    @FXML
    private Label content;
    @FXML
    private Label graphic;
    @FXML
    private Label title;
    @FXML
    private HBox actions;
    @Nullable
    private ButtonBase cancelButton;

    public MessageDialogPane(@NotNull String text, @Nullable String title, @NotNull MessageType type) {
        FXUtils.loadFXML((Node)this, "/assets/fxml/message-dialog.fxml");
        this.content.setText(text);
        if (title != null) {
            this.title.setText(title);
        }
        switch (type) {
            case INFO: {
                this.graphic.setGraphic(SVG.infoCircle(Theme.blackFillBinding(), 40.0, 40.0));
                break;
            }
            case ERROR: {
                this.graphic.setGraphic(SVG.closeCircle(Theme.blackFillBinding(), 40.0, 40.0));
                break;
            }
            case SUCCESS: {
                this.graphic.setGraphic(SVG.checkCircle(Theme.blackFillBinding(), 40.0, 40.0));
                break;
            }
            case WARNING: {
                this.graphic.setGraphic(SVG.alert(Theme.blackFillBinding(), 40.0, 40.0));
                break;
            }
            case QUESTION: {
                this.graphic.setGraphic(SVG.helpCircle(Theme.blackFillBinding(), 40.0, 40.0));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized message box message type " + (Object)((Object)type));
            }
        }
        FXUtils.onEscPressed((Node)this, () -> {
            if (this.cancelButton != null) {
                this.cancelButton.fire();
            }
        });
    }

    public void addButton(Node btn) {
        btn.addEventHandler(ActionEvent.ACTION, e -> this.fireEvent(new DialogCloseEvent()));
        this.actions.getChildren().add((Object)btn);
    }

    public void setCancelButton(@Nullable ButtonBase btn) {
        this.cancelButton = btn;
    }

    public ButtonBase getCancelButton() {
        return this.cancelButton;
    }

    public static class Builder {
        private final MessageDialogPane dialog;

        public Builder(String text, String title, MessageType type) {
            this.dialog = new MessageDialogPane(text, title, type);
        }

        public Builder addAction(Node actionNode) {
            this.dialog.addButton(actionNode);
            return this;
        }

        public Builder ok(Runnable ok) {
            JFXButton btnOk = new JFXButton(I18n.i18n("button.ok"));
            btnOk.getStyleClass().add((Object)"dialog-accept");
            if (ok != null) {
                btnOk.setOnAction(e -> ok.run());
            }
            this.dialog.addButton((Node)btnOk);
            this.dialog.setCancelButton((ButtonBase)btnOk);
            return this;
        }

        public Builder yesOrNo(Runnable yes, Runnable no) {
            JFXButton btnYes = new JFXButton(I18n.i18n("button.yes"));
            btnYes.getStyleClass().add((Object)"dialog-accept");
            if (yes != null) {
                btnYes.setOnAction(e -> yes.run());
            }
            this.dialog.addButton((Node)btnYes);
            JFXButton btnNo = new JFXButton(I18n.i18n("button.no"));
            btnNo.getStyleClass().add((Object)"dialog-cancel");
            if (no != null) {
                btnNo.setOnAction(e -> no.run());
            }
            this.dialog.addButton((Node)btnNo);
            this.dialog.setCancelButton((ButtonBase)btnNo);
            return this;
        }

        public Builder actionOrCancel(ButtonBase actionButton, Runnable cancel) {
            this.dialog.addButton((Node)actionButton);
            JFXButton btnCancel = new JFXButton(I18n.i18n("button.cancel"));
            btnCancel.getStyleClass().add((Object)"dialog-cancel");
            if (cancel != null) {
                btnCancel.setOnAction(e -> cancel.run());
            }
            this.dialog.addButton((Node)btnCancel);
            this.dialog.setCancelButton((ButtonBase)btnCancel);
            return this;
        }

        public Builder cancelOnTimeout(final long timeoutMs) {
            if (this.dialog.getCancelButton() == null) {
                throw new IllegalStateException("Call ok/yesOrNo/actionOrCancel before calling cancelOnTimeout");
            }
            final ButtonBase cancelButton = this.dialog.getCancelButton();
            final String originalText = cancelButton.getText();
            Timer timer = Lang.getTimer();
            timer.scheduleAtFixedRate(new TimerTask(){
                long timeout;
                {
                    this.timeout = timeoutMs;
                }

                @Override
                public void run() {
                    if (this.timeout <= 0L) {
                        this.cancel();
                        FXUtils.runInFX(() -> cancelButton.fire());
                        return;
                    }
                    this.timeout -= 1000L;
                    long currentTimeout = this.timeout;
                    FXUtils.runInFX(() -> cancelButton.setText(originalText + " (" + currentTimeout / 1000L + ")"));
                }
            }, 1000L, 1000L);
            return this;
        }

        public MessageDialogPane build() {
            return this.dialog;
        }
    }

    public static enum MessageType {
        ERROR,
        INFO,
        WARNING,
        QUESTION,
        SUCCESS;


        public String getDisplayName() {
            return I18n.i18n("message." + this.name().toLowerCase(Locale.ROOT));
        }
    }
}

