/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXColorPicker;
import com.jfoenix.controls.JFXRadioButton;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.NamedArg;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.util.i18n.I18n;

public class MultiColorItem
extends ComponentList {
    private final StringProperty customTitle = new SimpleStringProperty((Object)this, "customTitle", I18n.i18n("selector.custom"));
    private final StringProperty chooserTitle = new SimpleStringProperty((Object)this, "chooserTitle", I18n.i18n("selector.choose_file"));
    private final ToggleGroup group = new ToggleGroup();
    private final JFXColorPicker colorPicker = new JFXColorPicker();
    private final JFXRadioButton radioCustom = new JFXRadioButton();
    private final BorderPane custom = new BorderPane();
    private final VBox pane = new VBox();
    private final boolean hasCustom;
    private Consumer<Toggle> toggleSelectedListener;
    private Consumer<Color> colorConsumer;

    public MultiColorItem(@NamedArg(value="hasCustom", defaultValue="true") boolean hasCustom) {
        this.hasCustom = hasCustom;
        this.radioCustom.textProperty().bind((ObservableValue)this.customTitleProperty());
        this.radioCustom.setToggleGroup(this.group);
        this.colorPicker.disableProperty().bind((ObservableValue)this.radioCustom.selectedProperty().not());
        this.colorPicker.setOnAction(e -> Optional.ofNullable(this.colorConsumer).ifPresent(c -> c.accept(this.colorPicker.getValue())));
        this.custom.setLeft((Node)this.radioCustom);
        this.custom.setStyle("-fx-padding: 3;");
        HBox right = new HBox();
        right.setSpacing(3.0);
        right.getChildren().addAll((Object[])new Node[]{this.colorPicker});
        this.custom.setRight((Node)right);
        FXUtils.setLimitHeight((Region)this.custom, 40.0);
        this.pane.setStyle("-fx-padding: 0 0 10 0;");
        this.pane.setSpacing(8.0);
        if (hasCustom) {
            this.pane.getChildren().add((Object)this.custom);
        }
        this.getContent().add((Object)this.pane);
        this.group.selectedToggleProperty().addListener((a, b, newValue) -> {
            if (this.toggleSelectedListener != null) {
                this.toggleSelectedListener.accept((Toggle)newValue);
            }
        });
    }

    public Node createChildren(String title) {
        return this.createChildren(title, null);
    }

    public Node createChildren(String title, Object userData) {
        return this.createChildren(title, "", userData);
    }

    public Node createChildren(String title, String subtitle, Object userData) {
        BorderPane pane = new BorderPane();
        pane.setStyle("-fx-padding: 3;");
        JFXRadioButton left = new JFXRadioButton(title);
        left.setToggleGroup(this.group);
        left.setUserData(userData);
        pane.setLeft((Node)left);
        Label right = new Label(subtitle);
        right.getStyleClass().add((Object)"subtitle-label");
        right.setStyle("-fx-font-size: 10;");
        pane.setRight((Node)right);
        return pane;
    }

    public void loadChildren(Collection<Node> list) {
        this.pane.getChildren().setAll(list);
        if (this.hasCustom) {
            this.pane.getChildren().add((Object)this.custom);
        }
    }

    public ToggleGroup getGroup() {
        return this.group;
    }

    public String getCustomTitle() {
        return (String)this.customTitle.get();
    }

    public StringProperty customTitleProperty() {
        return this.customTitle;
    }

    public void setCustomTitle(String customTitle) {
        this.customTitle.set((Object)customTitle);
    }

    public String getChooserTitle() {
        return (String)this.chooserTitle.get();
    }

    public StringProperty chooserTitleProperty() {
        return this.chooserTitle;
    }

    public void setChooserTitle(String chooserTitle) {
        this.chooserTitle.set((Object)chooserTitle);
    }

    public void setCustomUserData(Object userData) {
        this.radioCustom.setUserData(userData);
    }

    public boolean isCustomToggle(Toggle toggle) {
        return this.radioCustom == toggle;
    }

    public void setToggleSelectedListener(Consumer<Toggle> consumer) {
        this.toggleSelectedListener = consumer;
    }

    public void setOnColorPickerChanged(Consumer<Color> consumer) {
        this.colorConsumer = consumer;
    }

    public void setColor(Color color) {
        this.colorPicker.setValue(color);
    }
}

