/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.InstallerItem;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.download.VersionsPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public class InstallersPage
extends Control
implements WizardPage {
    protected final WizardController controller;
    protected InstallerItem.InstallerItemGroup group = new InstallerItem.InstallerItemGroup();
    protected JFXTextField txtName = new JFXTextField();
    protected BooleanProperty installable = new SimpleBooleanProperty();

    public InstallersPage(WizardController controller, HMCLGameRepository repository, String gameVersion, DownloadProvider downloadProvider) {
        this.controller = controller;
        this.txtName.getValidators().addAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !repository.versionIdConflicts((String)str)), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
        this.installable.bind((ObservableValue)Bindings.createBooleanBinding(this.txtName::validate, (Observable[])new Observable[]{this.txtName.textProperty()}));
        this.txtName.setText(gameVersion);
        this.group.game.installable.setValue(Boolean.valueOf(false));
        for (InstallerItem library : this.group.getLibraries()) {
            String libraryId = library.getLibraryId();
            if (libraryId.equals("game")) continue;
            library.action.set(e -> {
                if ("fabric-api".equals(libraryId)) {
                    Controllers.dialog(I18n.i18n("install.installer.fabric-api.warning"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING);
                }
                if (library.incompatibleLibraryName.get() == null) {
                    controller.onNext((Node)new VersionsPage(controller, I18n.i18n("install.installer.choose", I18n.i18n("install.installer." + libraryId)), gameVersion, downloadProvider, libraryId, () -> controller.onPrev(false)));
                }
            });
            library.removeAction.set(e -> {
                controller.getSettings().remove(libraryId);
                this.reload();
            });
        }
    }

    @Override
    public String getTitle() {
        return I18n.i18n("install.new_game");
    }

    private String getVersion(String id) {
        return ((RemoteVersion)this.controller.getSettings().get(id)).getSelfVersion();
    }

    protected void reload() {
        for (InstallerItem library : this.group.getLibraries()) {
            String libraryId = library.getLibraryId();
            if (this.controller.getSettings().containsKey(libraryId)) {
                library.libraryVersion.set((Object)this.getVersion(libraryId));
                library.removable.set(true);
                continue;
            }
            library.libraryVersion.set(null);
            library.removable.set(false);
        }
    }

    @Override
    public void onNavigate(Map<String, Object> settings) {
        this.reload();
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
    }

    @FXML
    protected void onInstall() {
        this.controller.getSettings().put("name", this.txtName.getText());
        this.controller.onFinish();
    }

    protected Skin<?> createDefaultSkin() {
        return new InstallersPageSkin(this);
    }

    protected static class InstallersPageSkin
    extends SkinBase<InstallersPage> {
        protected InstallersPageSkin(InstallersPage control) {
            super((Control)control);
            BorderPane root = new BorderPane();
            root.setPadding(new Insets(16.0));
            ComponentList list = new ComponentList();
            list.getStyleClass().add((Object)"no-padding");
            root.setCenter((Node)list);
            HBox versionNamePane = new HBox(8.0);
            versionNamePane.setAlignment(Pos.CENTER_LEFT);
            versionNamePane.setPadding(new Insets(20.0, 8.0, 20.0, 16.0));
            control.txtName.setMaxWidth(300.0);
            versionNamePane.getChildren().setAll((Object[])new Node[]{new Label(I18n.i18n("archive.name")), control.txtName});
            list.getContent().add((Object)versionNamePane);
            VBox libraryPane = new VBox((Node[])control.group.getLibraries());
            list.getContent().add((Object)libraryPane);
            JFXButton installButton = new JFXButton(I18n.i18n("button.install"));
            installButton.disableProperty().bind((ObservableValue)control.installable.not());
            installButton.getStyleClass().add((Object)"jfx-button-raised");
            installButton.setButtonType(JFXButton.ButtonType.RAISED);
            installButton.setPrefWidth(100.0);
            installButton.setPrefHeight(40.0);
            installButton.setOnMouseClicked(e -> control.onInstall());
            BorderPane.setAlignment((Node)installButton, (Pos)Pos.CENTER_RIGHT);
            root.setBottom((Node)installButton);
            this.getChildren().setAll((Object[])new Node[]{root});
        }
    }
}

