/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.ManuallyCreatedModpackException;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class LocalModpackPage
extends StackPane
implements WizardPage {
    private final WizardController controller;
    private Modpack manifest = null;
    @FXML
    private Region borderPane;
    @FXML
    private Label lblName;
    @FXML
    private Label lblVersion;
    @FXML
    private Label lblAuthor;
    @FXML
    private Label lblModpackLocation;
    @FXML
    private JFXTextField txtModpackName;
    @FXML
    private JFXButton btnInstall;
    @FXML
    private SpinnerPane spinnerPane;
    private final BooleanProperty installAsVersion = new SimpleBooleanProperty(true);
    private Charset charset;
    public static final String MODPACK_FILE = "MODPACK_FILE";
    public static final String MODPACK_NAME = "MODPACK_NAME";
    public static final String MODPACK_MANIFEST = "MODPACK_MANIFEST";
    public static final String MODPACK_CHARSET = "MODPACK_CHARSET";
    public static final String MODPACK_MANUALLY_CREATED = "MODPACK_MANUALLY_CREATED";

    public LocalModpackPage(WizardController controller) {
        File selectedFile;
        this.controller = controller;
        FXUtils.loadFXML((Node)this, "/assets/fxml/download/modpack.fxml");
        Profile profile = (Profile)controller.getSettings().get("PROFILE");
        Optional<String> name = Lang.tryCast(controller.getSettings().get(MODPACK_NAME), String.class);
        if (name.isPresent()) {
            this.txtModpackName.setText(name.get());
            this.txtModpackName.setDisable(true);
        } else {
            FXUtils.onChangeAndOperate(this.installAsVersion, installAsVersion -> {
                if (installAsVersion.booleanValue()) {
                    this.txtModpackName.getValidators().setAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !profile.getRepository().versionIdConflicts((String)str)), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
                } else {
                    this.txtModpackName.getValidators().setAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !ModpackHelper.isExternalGameNameConflicts(str) && Profiles.getProfiles().stream().noneMatch(p -> p.getName().equals(str))), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
                }
            });
            this.btnInstall.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(this.txtModpackName::validate, (Observable[])new Observable[]{this.txtModpackName.textProperty()}).not());
        }
        Optional<File> filePath = Lang.tryCast(controller.getSettings().get(MODPACK_FILE), File.class);
        if (filePath.isPresent()) {
            selectedFile = filePath.get();
        } else {
            FileChooser chooser = new FileChooser();
            chooser.setTitle(I18n.i18n("modpack.choose"));
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.zip"}));
            selectedFile = chooser.showOpenDialog((Window)Controllers.getStage());
            if (selectedFile == null) {
                controller.onEnd();
                return;
            }
            controller.getSettings().put(MODPACK_FILE, selectedFile);
        }
        this.spinnerPane.showSpinner();
        Task.supplyAsync(() -> CompressingUtils.findSuitableEncoding(selectedFile.toPath())).thenApplyAsync(encoding -> {
            this.charset = encoding;
            this.manifest = ModpackHelper.readModpackManifest(selectedFile.toPath(), encoding);
            return this.manifest;
        }).whenComplete(Schedulers.javafx(), (manifest, exception) -> {
            if (exception instanceof ManuallyCreatedModpackException) {
                this.spinnerPane.hideSpinner();
                this.lblName.setText(selectedFile.getName());
                this.installAsVersion.set(false);
                this.lblModpackLocation.setText(selectedFile.getAbsolutePath());
                if (!name.isPresent()) {
                    this.txtModpackName.setText(FileUtils.getNameWithoutExtension(selectedFile));
                }
                Controllers.confirm(I18n.i18n("modpack.type.manual.warning"), I18n.i18n("install.modpack"), MessageDialogPane.MessageType.WARNING, () -> {}, controller::onEnd);
                controller.getSettings().put(MODPACK_MANUALLY_CREATED, true);
            } else if (exception != null) {
                Logging.LOG.log(Level.WARNING, "Failed to read modpack manifest", exception);
                Controllers.dialog(I18n.i18n("modpack.task.install.error"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                Platform.runLater(controller::onEnd);
            } else {
                this.spinnerPane.hideSpinner();
                controller.getSettings().put(MODPACK_MANIFEST, manifest);
                this.lblName.setText(manifest.getName());
                this.lblVersion.setText(manifest.getVersion());
                this.lblAuthor.setText(manifest.getAuthor());
                this.lblModpackLocation.setText(selectedFile.getAbsolutePath());
                if (!name.isPresent()) {
                    this.txtModpackName.setText(manifest.getName().trim());
                }
            }
        }).start();
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        settings.remove(MODPACK_FILE);
    }

    @FXML
    private void onInstall() {
        if (!this.txtModpackName.validate()) {
            return;
        }
        this.controller.getSettings().put(MODPACK_NAME, this.txtModpackName.getText());
        this.controller.getSettings().put(MODPACK_CHARSET, this.charset);
        this.controller.onFinish();
    }

    @FXML
    private void onDescribe() {
        if (this.manifest != null) {
            FXUtils.showWebDialog(I18n.i18n("modpack.description"), this.manifest.getDescription());
        }
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.task.install");
    }
}

