/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.mod.server.ServerModpackManifest;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.i18n.I18n;

public class RemoteModpackPage
extends StackPane
implements WizardPage {
    private final WizardController controller;
    private final ServerModpackManifest manifest;
    @FXML
    private Region borderPane;
    @FXML
    private Label lblName;
    @FXML
    private Label lblVersion;
    @FXML
    private Label lblAuthor;
    @FXML
    private Label lblModpackLocation;
    @FXML
    private JFXTextField txtModpackName;
    @FXML
    private JFXButton btnInstall;
    @FXML
    private SpinnerPane spinnerPane;
    public static final String MODPACK_SERVER_MANIFEST = "MODPACK_SERVER_MANIFEST";
    public static final String MODPACK_NAME = "MODPACK_NAME";
    public static final String MODPACK_MANIFEST = "MODPACK_MANIFEST";

    public RemoteModpackPage(WizardController controller) {
        this.controller = controller;
        FXUtils.loadFXML((Node)this, "/assets/fxml/download/modpack.fxml");
        Profile profile = (Profile)controller.getSettings().get("PROFILE");
        Optional<String> name = Lang.tryCast(controller.getSettings().get(MODPACK_NAME), String.class);
        if (name.isPresent()) {
            this.txtModpackName.setText(name.get());
            this.txtModpackName.setDisable(true);
        }
        this.manifest = Lang.tryCast(controller.getSettings().get(MODPACK_SERVER_MANIFEST), ServerModpackManifest.class).orElseThrow(() -> new IllegalStateException("MODPACK_SERVER_MANIFEST should exist"));
        this.lblModpackLocation.setText(this.manifest.getFileApi());
        try {
            controller.getSettings().put(MODPACK_MANIFEST, this.manifest.toModpack(null));
        }
        catch (IOException e) {
            Controllers.dialog(I18n.i18n("modpack.type.server.malformed"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
            Platform.runLater(controller::onEnd);
            return;
        }
        this.lblName.setText(this.manifest.getName());
        this.lblVersion.setText(this.manifest.getVersion());
        this.lblAuthor.setText(this.manifest.getAuthor());
        if (!name.isPresent()) {
            this.txtModpackName.setText(this.manifest.getName().trim());
            this.txtModpackName.getValidators().addAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !profile.getRepository().versionIdConflicts((String)str)), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
            this.btnInstall.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(this.txtModpackName::validate, (Observable[])new Observable[]{this.txtModpackName.textProperty()}).not());
        }
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        settings.remove(MODPACK_SERVER_MANIFEST);
    }

    @FXML
    private void onInstall() {
        if (!this.txtModpackName.validate()) {
            return;
        }
        this.controller.getSettings().put(MODPACK_NAME, this.txtModpackName.getText());
        this.controller.onFinish();
    }

    @FXML
    private void onDescribe() {
        FXUtils.showWebDialog(I18n.i18n("modpack.description"), this.manifest.getDescription());
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.task.install");
    }
}

