/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXPopup;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.IconedMenuItem;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MDListCell;
import org.jackhuang.hmcl.ui.construct.PopupMenu;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.ModListPage;
import org.jackhuang.hmcl.ui.versions.ModTranslations;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Lazy;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jetbrains.annotations.NotNull;

class ModListPageSkin
extends SkinBase<ModListPage> {
    private static Lazy<PopupMenu> menu = new Lazy<PopupMenu>(PopupMenu::new);
    private static Lazy<JFXPopup> popup = new Lazy<JFXPopup>(() -> new JFXPopup((Region)menu.get()));

    ModListPageSkin(ModListPage skinnable) {
        super((Control)skinnable);
        StackPane pane = new StackPane();
        pane.setPadding(new Insets(10.0));
        pane.getStyleClass().addAll((Object[])new String[]{"notice-pane"});
        ComponentList root = new ComponentList();
        root.getStyleClass().add((Object)"no-padding");
        JFXListView listView = new JFXListView();
        TransitionPane toolBarPane = new TransitionPane();
        HBox toolbarNormal = new HBox();
        Object[] objectArray = new Node[5];
        objectArray[0] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG::refresh, skinnable::refresh);
        objectArray[1] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.add"), SVG::plus, skinnable::add);
        objectArray[2] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("folder.mod"), SVG::folderOpen, () -> skinnable.openModFolder());
        objectArray[3] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.check_updates"), SVG::update, () -> skinnable.checkUpdates());
        objectArray[4] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("download"), SVG::downloadOutline, () -> skinnable.download());
        toolbarNormal.getChildren().setAll(objectArray);
        HBox toolbarSelecting = new HBox();
        toolbarSelecting.getChildren().setAll((Object[])new Node[]{ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.remove"), SVG::delete, () -> Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("button.remove"), () -> skinnable.removeSelected((ObservableList<ModInfoObject>)listView.getSelectionModel().getSelectedItems()), null)), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.enable"), SVG::check, () -> skinnable.enableSelected((ObservableList<ModInfoObject>)listView.getSelectionModel().getSelectedItems())), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.disable"), SVG::close, () -> skinnable.disableSelected((ObservableList<ModInfoObject>)listView.getSelectionModel().getSelectedItems())), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.select_all"), SVG::selectAll, () -> listView.getSelectionModel().selectAll()), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.cancel"), SVG::cancel, () -> listView.getSelectionModel().clearSelection())});
        FXUtils.onChangeAndOperate(listView.getSelectionModel().selectedItemProperty(), selectedItem -> {
            if (selectedItem == null) {
                toolBarPane.setContent((Node)toolbarNormal, ContainerAnimations.FADE.getAnimationProducer());
            } else {
                toolBarPane.setContent((Node)toolbarSelecting, ContainerAnimations.FADE.getAnimationProducer());
            }
        });
        root.getContent().add((Object)toolBarPane);
        SpinnerPane center = new SpinnerPane();
        ComponentList.setVgrow((Node)center, Priority.ALWAYS);
        center.getStyleClass().add((Object)"large-spinner-pane");
        center.loadingProperty().bind((ObservableValue)skinnable.loadingProperty());
        listView.setCellFactory(x -> new ModInfoListCell(listView));
        listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Bindings.bindContent((List)listView.getItems(), skinnable.getItems());
        center.setContent((Node)listView);
        root.getContent().add((Object)center);
        Label label = new Label(I18n.i18n("mods.not_modded"));
        label.prefWidthProperty().bind((ObservableValue)pane.widthProperty().add(-100));
        FXUtils.onChangeAndOperate(skinnable.moddedProperty(), modded -> {
            if (modded.booleanValue()) {
                pane.getChildren().setAll((Object[])new Node[]{root});
            } else {
                pane.getChildren().setAll((Object[])new Node[]{label});
            }
        });
        this.getChildren().setAll((Object[])new Node[]{pane});
    }

    static class ModInfoDialog
    extends JFXDialogLayout {
        ModInfoDialog(ModInfoObject modInfo) {
            HBox titleContainer = new HBox();
            titleContainer.setSpacing(8.0);
            ImageView imageView = new ImageView();
            if (StringUtils.isNotBlank(modInfo.getModInfo().getLogoPath())) {
                Task.supplyAsync(() -> {
                    try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(modInfo.getModInfo().getFile());){
                        Path iconPath = fs.getPath(modInfo.getModInfo().getLogoPath(), new String[0]);
                        if (Files.exists(iconPath, new LinkOption[0])) {
                            ByteArrayOutputStream stream = new ByteArrayOutputStream();
                            Files.copy(iconPath, stream);
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stream.toByteArray());
                            return byteArrayInputStream;
                        }
                    }
                    return null;
                }).whenComplete(Schedulers.javafx(), (stream, exception) -> {
                    if (stream != null) {
                        imageView.setImage(new Image((InputStream)stream, 40.0, 40.0, true, true));
                    } else {
                        imageView.setImage(new Image("/assets/img/command.png", 40.0, 40.0, true, true));
                    }
                }).start();
            }
            TwoLineListItem title = new TwoLineListItem();
            title.setTitle(modInfo.getModInfo().getName());
            if (StringUtils.isNotBlank(modInfo.getModInfo().getVersion())) {
                title.getTags().setAll((Object[])new String[]{modInfo.getModInfo().getVersion()});
            }
            title.setSubtitle(FileUtils.getName(modInfo.getModInfo().getFile()));
            titleContainer.getChildren().setAll((Object[])new Node[]{FXUtils.limitingSize((Node)imageView, 40.0, 40.0), title});
            this.setHeading(new Node[]{titleContainer});
            Label description = new Label(modInfo.getModInfo().getDescription().toString());
            this.setBody(new Node[]{description});
            if (StringUtils.isNotBlank(modInfo.getModInfo().getUrl())) {
                JFXHyperlink officialPageButton = new JFXHyperlink();
                officialPageButton.setText(I18n.i18n("mods.url"));
                officialPageButton.setOnAction(e -> {
                    this.fireEvent(new DialogCloseEvent());
                    FXUtils.openLink(modInfo.getModInfo().getUrl());
                });
                this.getActions().add((Object)officialPageButton);
            }
            if (modInfo.getMod() != null && StringUtils.isNotBlank(modInfo.getMod().getMcbbs())) {
                JFXHyperlink mcbbsButton = new JFXHyperlink();
                mcbbsButton.setText(I18n.i18n("mods.mcbbs"));
                mcbbsButton.setOnAction(e -> {
                    this.fireEvent(new DialogCloseEvent());
                    FXUtils.openLink(ModManager.getMcbbsUrl(modInfo.getMod().getMcbbs()));
                });
                this.getActions().add((Object)mcbbsButton);
            }
            if (modInfo.getMod() == null || StringUtils.isBlank(modInfo.getMod().getMcmod())) {
                JFXHyperlink searchButton = new JFXHyperlink();
                searchButton.setText(I18n.i18n("mods.mcmod.search"));
                searchButton.setOnAction(e -> {
                    this.fireEvent(new DialogCloseEvent());
                    FXUtils.openLink(NetworkUtils.withQuery("https://search.mcmod.cn/s", Lang.mapOf(Pair.pair("key", modInfo.getModInfo().getName()), Pair.pair("site", "all"), Pair.pair("filter", "0"))));
                });
                this.getActions().add((Object)searchButton);
            } else {
                JFXHyperlink mcmodButton = new JFXHyperlink();
                mcmodButton.setText(I18n.i18n("mods.mcmod.page"));
                mcmodButton.setOnAction(e -> {
                    this.fireEvent(new DialogCloseEvent());
                    FXUtils.openLink(ModManager.getMcmodUrl(modInfo.getMod().getMcmod()));
                });
                this.getActions().add((Object)mcmodButton);
            }
            JFXButton okButton = new JFXButton();
            okButton.getStyleClass().add((Object)"dialog-accept");
            okButton.setText(I18n.i18n("button.ok"));
            okButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
            this.getActions().add((Object)okButton);
            FXUtils.onEscPressed((Node)this, () -> ((JFXButton)okButton).fire());
        }
    }

    class ModInfoListCell
    extends MDListCell<ModInfoObject> {
        JFXCheckBox checkBox;
        TwoLineListItem content;
        JFXButton restoreButton;
        JFXButton infoButton;
        JFXButton revealButton;
        BooleanProperty booleanProperty;

        ModInfoListCell(JFXListView<ModInfoObject> listView) {
            super(listView);
            this.checkBox = new JFXCheckBox();
            this.content = new TwoLineListItem();
            this.restoreButton = new JFXButton();
            this.infoButton = new JFXButton();
            this.revealButton = new JFXButton();
            HBox container = new HBox(8.0);
            container.setPickOnBounds(false);
            container.setAlignment(Pos.CENTER_LEFT);
            HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
            this.content.setMouseTransparent(true);
            this.setSelectable();
            this.restoreButton.getStyleClass().add((Object)"toggle-icon4");
            this.restoreButton.setGraphic(FXUtils.limitingSize(SVG.restore(Theme.blackFillBinding(), 24.0, 24.0), 24.0, 24.0));
            FXUtils.installFastTooltip((Node)this.restoreButton, I18n.i18n("mods.restore"));
            this.revealButton.getStyleClass().add((Object)"toggle-icon4");
            this.revealButton.setGraphic(FXUtils.limitingSize(SVG.folderOutline(Theme.blackFillBinding(), 24.0, 24.0), 24.0, 24.0));
            this.infoButton.getStyleClass().add((Object)"toggle-icon4");
            this.infoButton.setGraphic(FXUtils.limitingSize(SVG.informationOutline(Theme.blackFillBinding(), 24.0, 24.0), 24.0, 24.0));
            container.getChildren().setAll((Object[])new Node[]{this.checkBox, this.content, this.restoreButton, this.revealButton, this.infoButton});
            StackPane.setMargin((Node)container, (Insets)new Insets(8.0));
            this.getContainer().getChildren().setAll((Object[])new Node[]{container});
        }

        @Override
        protected void updateControl(ModInfoObject dataItem, boolean empty) {
            if (empty) {
                return;
            }
            this.content.setTitle(dataItem.getTitle());
            if (dataItem.getMod() != null && I18n.getCurrentLocale().getLocale() == Locale.CHINA) {
                this.content.getTags().setAll((Object[])new String[]{dataItem.getMod().getDisplayName()});
            } else {
                this.content.getTags().clear();
            }
            this.content.setSubtitle(dataItem.getSubtitle());
            if (this.booleanProperty != null) {
                this.checkBox.selectedProperty().unbindBidirectional((Property)this.booleanProperty);
            }
            this.booleanProperty = dataItem.active;
            this.checkBox.selectedProperty().bindBidirectional((Property)this.booleanProperty);
            this.restoreButton.setVisible(!dataItem.getModInfo().getMod().getOldFiles().isEmpty());
            this.restoreButton.setOnMouseClicked(e -> {
                ((PopupMenu)((Object)((Object)menu.get()))).getContent().setAll((Collection)dataItem.getModInfo().getMod().getOldFiles().stream().map(localModFile -> new IconedMenuItem(null, localModFile.getVersion(), () -> ((ModListPage)ModListPageSkin.this.getSkinnable()).rollback(dataItem.getModInfo(), (LocalModFile)localModFile))).collect(Collectors.toList()));
                ((JFXPopup)((Object)((Object)popup.get()))).show((Node)this.restoreButton, JFXPopup.PopupVPosition.TOP, JFXPopup.PopupHPosition.RIGHT, 0.0, this.restoreButton.getHeight());
            });
            this.revealButton.setOnMouseClicked(e -> FXUtils.showFileInExplorer(dataItem.getModInfo().getFile()));
            this.infoButton.setOnMouseClicked(e -> Controllers.dialog((Region)new ModInfoDialog(dataItem)));
        }
    }

    static class ModInfoObject
    extends RecursiveTreeObject<ModInfoObject>
    implements Comparable<ModInfoObject> {
        private final BooleanProperty active;
        private final LocalModFile localModFile;
        private final String message;
        private final ModTranslations.Mod mod;

        ModInfoObject(LocalModFile localModFile) {
            this.localModFile = localModFile;
            this.active = localModFile.activeProperty();
            StringBuilder message = new StringBuilder(localModFile.getName());
            if (StringUtils.isNotBlank(localModFile.getVersion())) {
                message.append(", ").append(I18n.i18n("archive.version")).append(": ").append(localModFile.getVersion());
            }
            if (StringUtils.isNotBlank(localModFile.getGameVersion())) {
                message.append(", ").append(I18n.i18n("archive.game_version")).append(": ").append(localModFile.getGameVersion());
            }
            if (StringUtils.isNotBlank(localModFile.getAuthors())) {
                message.append(", ").append(I18n.i18n("archive.author")).append(": ").append(localModFile.getAuthors());
            }
            this.message = message.toString();
            this.mod = ModTranslations.getModById(localModFile.getId());
        }

        String getTitle() {
            return this.localModFile.getFileName();
        }

        String getSubtitle() {
            return this.message;
        }

        LocalModFile getModInfo() {
            return this.localModFile;
        }

        public ModTranslations.Mod getMod() {
            return this.mod;
        }

        @Override
        public int compareTo(@NotNull ModInfoObject o) {
            return this.localModFile.getFileName().toLowerCase().compareTo(o.localModFile.getFileName().toLowerCase());
        }
    }
}

