/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import org.jackhuang.hmcl.game.GameDirectoryType;
import org.jackhuang.hmcl.game.GameVersion;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.NativesDirectoryType;
import org.jackhuang.hmcl.game.ProcessPriority;
import org.jackhuang.hmcl.setting.LauncherVisibility;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.ImagePickerItem;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.MultiFileItem;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.construct.NumberValidator;
import org.jackhuang.hmcl.ui.construct.OptionToggleButton;
import org.jackhuang.hmcl.ui.construct.PageAware;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.VersionIconDialog;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.BindingMapping;
import org.jackhuang.hmcl.util.javafx.SafeStringConverter;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class VersionSettingsPage
extends StackPane
implements DecoratorPage,
VersionPage.VersionLoadable,
PageAware {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)new DecoratorPage.State("", null, false, false, false));
    private final boolean globalSetting;
    private VersionSetting lastVersionSetting = null;
    private Profile profile;
    private WeakListenerHolder listenerHolder;
    private String versionId;
    private boolean javaItemsLoaded;
    private final VBox rootPane;
    private final JFXTextField txtWidth;
    private final JFXTextField txtHeight;
    private final JFXTextField txtJVMArgs;
    private final JFXTextField txtGameArgs;
    private final JFXTextField txtMetaspace;
    private final JFXTextField txtWrapper;
    private final JFXTextField txtPreLaunchCommand;
    private final JFXTextField txtPostExitCommand;
    private final JFXTextField txtServerIP;
    private final ComponentList componentList;
    private final JFXComboBox<LauncherVisibility> cboLauncherVisibility;
    private final JFXCheckBox chkAutoAllocate;
    private final JFXCheckBox chkFullscreen;
    private final OptionToggleButton noJVMArgsPane;
    private final OptionToggleButton noGameCheckPane;
    private final OptionToggleButton noJVMCheckPane;
    private final OptionToggleButton useNativeGLFWPane;
    private final OptionToggleButton useNativeOpenALPane;
    private final ComponentSublist javaSublist;
    private final MultiFileItem<Pair<JavaVersionType, JavaVersion>> javaItem;
    private final MultiFileItem.Option<Pair<JavaVersionType, JavaVersion>> javaAutoDeterminedOption;
    private final MultiFileItem.FileOption<Pair<JavaVersionType, JavaVersion>> javaCustomOption;
    private final ComponentSublist gameDirSublist;
    private final MultiFileItem<GameDirectoryType> gameDirItem;
    private final MultiFileItem.FileOption<GameDirectoryType> gameDirCustomOption;
    private final ComponentSublist nativesDirSublist;
    private final MultiFileItem<NativesDirectoryType> nativesDirItem;
    private final MultiFileItem.FileOption<NativesDirectoryType> nativesDirCustomOption;
    private final JFXComboBox<ProcessPriority> cboProcessPriority;
    private final OptionToggleButton showLogsPane;
    private ImagePickerItem iconPickerItem;
    private final InvalidationListener specificSettingsListener;
    private final InvalidationListener javaListener = any -> this.initJavaSubtitle();
    private final StringProperty selectedVersion = new SimpleStringProperty();
    private final BooleanProperty navigateToSpecificSettings = new SimpleBooleanProperty(false);
    private final BooleanProperty enableSpecificSettings = new SimpleBooleanProperty(false);
    private final IntegerProperty maxMemory = new SimpleIntegerProperty();
    private final ObjectProperty<OperatingSystem.PhysicalMemoryStatus> memoryStatus = new SimpleObjectProperty((Object)OperatingSystem.PhysicalMemoryStatus.INVALID);
    private final BooleanProperty modpack = new SimpleBooleanProperty();

    public VersionSettingsPage(boolean globalSetting) {
        this.globalSetting = globalSetting;
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.getChildren().setAll((Object[])new Node[]{scrollPane});
        this.rootPane = new VBox();
        this.rootPane.setFillWidth(true);
        scrollPane.setContent((Node)this.rootPane);
        FXUtils.smoothScrolling(scrollPane);
        this.rootPane.getStyleClass().add((Object)"card-list");
        if (globalSetting) {
            HintPane skinHint = new HintPane(MessageDialogPane.MessageType.INFO);
            skinHint.setText(I18n.i18n("settings.skin"));
            this.rootPane.getChildren().add((Object)skinHint);
            HintPane specificSettingsHint = new HintPane(MessageDialogPane.MessageType.WARNING);
            Text text = new Text();
            text.textProperty().bind(BindingMapping.of(this.selectedVersion).map(selectedVersion -> I18n.i18n("settings.type.special.edit.hint", selectedVersion)));
            JFXHyperlink specificSettingsLink = new JFXHyperlink();
            specificSettingsLink.setText(I18n.i18n("settings.type.special.edit"));
            specificSettingsLink.setOnMouseClicked(e -> this.editSpecificSettings());
            specificSettingsHint.setChildren(new Node[]{text, specificSettingsLink});
            specificSettingsHint.managedProperty().bind((ObservableValue)this.navigateToSpecificSettings);
            specificSettingsHint.visibleProperty().bind((ObservableValue)this.navigateToSpecificSettings);
            this.rootPane.getChildren().addAll((Object[])new Node[]{specificSettingsHint});
        }
        if (!globalSetting) {
            ComponentList iconPickerItemWrapper = new ComponentList();
            this.rootPane.getChildren().add((Object)iconPickerItemWrapper);
            this.iconPickerItem = new ImagePickerItem();
            this.iconPickerItem.setImage(new Image("/assets/img/icon.png"));
            this.iconPickerItem.setTitle(I18n.i18n("settings.icon"));
            this.iconPickerItem.setOnSelectButtonClicked((EventHandler<? super MouseEvent>)((EventHandler)e -> this.onExploreIcon()));
            this.iconPickerItem.setOnDeleteButtonClicked((EventHandler<? super MouseEvent>)((EventHandler)e -> this.onDeleteIcon()));
            iconPickerItemWrapper.getContent().setAll((Object[])new Node[]{this.iconPickerItem});
            BorderPane settingsTypePane = new BorderPane();
            settingsTypePane.disableProperty().bind((ObservableValue)this.modpack);
            this.rootPane.getChildren().add((Object)settingsTypePane);
            JFXCheckBox enableSpecificCheckBox = new JFXCheckBox();
            enableSpecificCheckBox.selectedProperty().bindBidirectional((Property)this.enableSpecificSettings);
            settingsTypePane.setLeft((Node)enableSpecificCheckBox);
            enableSpecificCheckBox.setText(I18n.i18n("settings.type.special.enable"));
            BorderPane.setAlignment((Node)enableSpecificCheckBox, (Pos)Pos.CENTER_RIGHT);
            JFXButton editGlobalSettingsButton = new JFXButton();
            settingsTypePane.setRight((Node)editGlobalSettingsButton);
            editGlobalSettingsButton.setText(I18n.i18n("settings.type.global.edit"));
            editGlobalSettingsButton.getStyleClass().add((Object)"jfx-button-raised");
            editGlobalSettingsButton.setButtonType(JFXButton.ButtonType.RAISED);
            editGlobalSettingsButton.disableProperty().bind((ObservableValue)enableSpecificCheckBox.selectedProperty());
            BorderPane.setAlignment((Node)editGlobalSettingsButton, (Pos)Pos.CENTER_RIGHT);
            editGlobalSettingsButton.setOnMouseClicked(e -> this.editGlobalSettings());
        }
        this.componentList = new ComponentList();
        this.componentList.setDepth(1);
        this.javaItem = new MultiFileItem();
        this.javaSublist = new ComponentSublist();
        this.javaSublist.getContent().add(this.javaItem);
        this.javaSublist.setTitle(I18n.i18n("settings.game.java_directory"));
        this.javaSublist.setHasSubtitle(true);
        this.javaAutoDeterminedOption = new MultiFileItem.Option<Pair<JavaVersionType, Object>>(I18n.i18n("settings.game.java_directory.auto"), Pair.pair(JavaVersionType.AUTO, null));
        this.javaCustomOption = new MultiFileItem.FileOption<Pair<JavaVersionType, Object>>(I18n.i18n("settings.custom"), Pair.pair(JavaVersionType.CUSTOM, null)).setChooserTitle(I18n.i18n("settings.game.java_directory.choose"));
        this.gameDirItem = new MultiFileItem();
        this.gameDirSublist = new ComponentSublist();
        this.gameDirSublist.getContent().add(this.gameDirItem);
        this.gameDirSublist.setTitle(I18n.i18n("settings.game.working_directory"));
        this.gameDirSublist.setHasSubtitle(true);
        this.gameDirItem.disableProperty().bind((ObservableValue)this.modpack);
        this.gameDirCustomOption = new MultiFileItem.FileOption<GameDirectoryType>(I18n.i18n("settings.custom"), GameDirectoryType.CUSTOM).setChooserTitle(I18n.i18n("settings.game.working_directory.choose")).setDirectory(true);
        this.gameDirItem.loadChildren(Arrays.asList(new MultiFileItem.Option<GameDirectoryType>(I18n.i18n("settings.advanced.game_dir.default"), GameDirectoryType.ROOT_FOLDER), new MultiFileItem.Option<GameDirectoryType>(I18n.i18n("settings.advanced.game_dir.independent"), GameDirectoryType.VERSION_FOLDER), this.gameDirCustomOption));
        VBox maxMemoryPane = new VBox(8.0);
        Label title = new Label(I18n.i18n("settings.memory"));
        VBox.setMargin((Node)title, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
        this.chkAutoAllocate = new JFXCheckBox(I18n.i18n("settings.memory.auto_allocate"));
        VBox.setMargin((Node)this.chkAutoAllocate, (Insets)new Insets(0.0, 0.0, 8.0, 5.0));
        HBox lowerBoundPane = new HBox(8.0);
        lowerBoundPane.setAlignment(Pos.CENTER);
        VBox.setMargin((Node)lowerBoundPane, (Insets)new Insets(0.0, 0.0, 0.0, 16.0));
        Label label = new Label();
        label.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (this.chkAutoAllocate.isSelected()) {
                return I18n.i18n("settings.memory.lower_bound");
            }
            return I18n.i18n("settings.memory");
        }, (Observable[])new Observable[]{this.chkAutoAllocate.selectedProperty()}));
        JFXSlider slider = new JFXSlider(0.0, 1.0, 0.0);
        HBox.setMargin((Node)slider, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
        HBox.setHgrow((Node)slider, (Priority)Priority.ALWAYS);
        slider.setValueFactory((Callback<JFXSlider, StringBinding>)((Callback)self -> Bindings.createStringBinding(() -> (int)(self.getValue() * 100.0) + "%", (Observable[])new Observable[]{self.valueProperty()})));
        AtomicBoolean changedByTextField = new AtomicBoolean(false);
        FXUtils.onChangeAndOperate(this.maxMemory, maxMemory -> {
            changedByTextField.set(true);
            slider.setValue((double)maxMemory.intValue() * 1.0 / (double)OperatingSystem.TOTAL_MEMORY);
            changedByTextField.set(false);
        });
        slider.valueProperty().addListener((value, oldVal, newVal) -> {
            if (changedByTextField.get()) {
                return;
            }
            this.maxMemory.set((int)(((Number)value.getValue()).doubleValue() * (double)OperatingSystem.TOTAL_MEMORY));
        });
        JFXTextField txtMaxMemory = new JFXTextField();
        FXUtils.setLimitWidth((Region)txtMaxMemory, 60.0);
        FXUtils.setValidateWhileTextChanged((Node)txtMaxMemory, true);
        txtMaxMemory.textProperty().bindBidirectional((Property)this.maxMemory, SafeStringConverter.fromInteger());
        txtMaxMemory.setValidators(new NumberValidator(I18n.i18n("input.number"), false));
        lowerBoundPane.getChildren().setAll((Object[])new Node[]{label, slider, txtMaxMemory, new Label("MB")});
        StackPane progressBarPane = new StackPane();
        progressBarPane.setAlignment(Pos.CENTER_LEFT);
        VBox.setMargin((Node)progressBarPane, (Insets)new Insets(8.0, 0.0, 0.0, 16.0));
        progressBarPane.setMinHeight(4.0);
        progressBarPane.getStyleClass().add((Object)"memory-total");
        StackPane usedMemory = new StackPane();
        usedMemory.getStyleClass().add((Object)"memory-used");
        usedMemory.maxWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> progressBarPane.getWidth() * ((double)((OperatingSystem.PhysicalMemoryStatus)this.memoryStatus.get()).getUsed() * 1.0 / (double)((OperatingSystem.PhysicalMemoryStatus)this.memoryStatus.get()).getTotal()), (Observable[])new Observable[]{progressBarPane.widthProperty(), this.memoryStatus}));
        StackPane allocateMemory = new StackPane();
        allocateMemory.getStyleClass().add((Object)"memory-allocate");
        allocateMemory.maxWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> progressBarPane.getWidth() * Math.min(1.0, (double)(HMCLGameRepository.getAllocatedMemory((long)this.maxMemory.get() * 1024L * 1024L, ((OperatingSystem.PhysicalMemoryStatus)this.memoryStatus.get()).getAvailable(), this.chkAutoAllocate.isSelected()) + ((OperatingSystem.PhysicalMemoryStatus)this.memoryStatus.get()).getUsed()) / (double)((OperatingSystem.PhysicalMemoryStatus)this.memoryStatus.get()).getTotal()), (Observable[])new Observable[]{progressBarPane.widthProperty(), this.maxMemory, this.memoryStatus, this.chkAutoAllocate.selectedProperty()}));
        progressBarPane.getChildren().setAll((Object[])new Node[]{allocateMemory, usedMemory});
        BorderPane digitalPane = new BorderPane();
        VBox.setMargin((Node)digitalPane, (Insets)new Insets(0.0, 0.0, 0.0, 16.0));
        Label lblPhysicalMemory = new Label();
        lblPhysicalMemory.getStyleClass().add((Object)"memory-label");
        digitalPane.setLeft((Node)lblPhysicalMemory);
        lblPhysicalMemory.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> I18n.i18n("settings.memory.used_per_total", ((OperatingSystem.PhysicalMemoryStatus)this.memoryStatus.get()).getUsedGB(), ((OperatingSystem.PhysicalMemoryStatus)this.memoryStatus.get()).getTotalGB()), (Observable[])new Observable[]{this.memoryStatus}));
        Label lblAllocateMemory = new Label();
        lblAllocateMemory.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            long maxMemory = (long)Lang.parseInt(this.maxMemory.get(), 0) * 1024L * 1024L;
            return I18n.i18n(((OperatingSystem.PhysicalMemoryStatus)this.memoryStatus.get()).hasAvailable() && maxMemory > ((OperatingSystem.PhysicalMemoryStatus)this.memoryStatus.get()).getAvailable() ? (this.chkAutoAllocate.isSelected() ? "settings.memory.allocate.auto.exceeded" : "settings.memory.allocate.manual.exceeded") : (this.chkAutoAllocate.isSelected() ? "settings.memory.allocate.auto" : "settings.memory.allocate.manual"), OperatingSystem.PhysicalMemoryStatus.toGigaBytes(maxMemory), OperatingSystem.PhysicalMemoryStatus.toGigaBytes(HMCLGameRepository.getAllocatedMemory(maxMemory, ((OperatingSystem.PhysicalMemoryStatus)this.memoryStatus.get()).getAvailable(), this.chkAutoAllocate.isSelected())), OperatingSystem.PhysicalMemoryStatus.toGigaBytes(((OperatingSystem.PhysicalMemoryStatus)this.memoryStatus.get()).getAvailable()));
        }, (Observable[])new Observable[]{this.memoryStatus, this.maxMemory, this.chkAutoAllocate.selectedProperty()}));
        lblAllocateMemory.getStyleClass().add((Object)"memory-label");
        digitalPane.setRight((Node)lblAllocateMemory);
        maxMemoryPane.getChildren().setAll((Object[])new Node[]{title, this.chkAutoAllocate, lowerBoundPane, progressBarPane, digitalPane});
        BorderPane launcherVisibilityPane = new BorderPane();
        Label label2 = new Label(I18n.i18n("settings.advanced.launcher_visible"));
        launcherVisibilityPane.setLeft((Node)label2);
        BorderPane.setAlignment((Node)label2, (Pos)Pos.CENTER_LEFT);
        this.cboLauncherVisibility = new JFXComboBox();
        launcherVisibilityPane.setRight(this.cboLauncherVisibility);
        BorderPane.setAlignment(this.cboLauncherVisibility, (Pos)Pos.CENTER_RIGHT);
        FXUtils.setLimitWidth(this.cboLauncherVisibility, 300.0);
        BorderPane dimensionPane = new BorderPane();
        label = new Label(I18n.i18n("settings.game.dimension"));
        dimensionPane.setLeft((Node)label);
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
        BorderPane right = new BorderPane();
        dimensionPane.setRight((Node)right);
        HBox hbox = new HBox();
        right.setLeft((Node)hbox);
        hbox.setPrefWidth(210.0);
        hbox.setSpacing(3.0);
        hbox.setAlignment(Pos.CENTER);
        BorderPane.setAlignment((Node)hbox, (Pos)Pos.CENTER);
        this.txtWidth = new JFXTextField();
        this.txtWidth.setPromptText("800");
        this.txtWidth.setPrefWidth(100.0);
        FXUtils.setValidateWhileTextChanged((Node)this.txtWidth, true);
        this.txtWidth.getValidators().setAll((Object[])new ValidatorBase[]{new NumberValidator(I18n.i18n("input.number"), false)});
        Label x = new Label("x");
        this.txtHeight = new JFXTextField();
        this.txtHeight.setPromptText("480");
        this.txtHeight.setPrefWidth(100.0);
        FXUtils.setValidateWhileTextChanged((Node)this.txtHeight, true);
        this.txtHeight.getValidators().setAll((Object[])new ValidatorBase[]{new NumberValidator(I18n.i18n("input.number"), false)});
        hbox.getChildren().setAll((Object[])new Node[]{this.txtWidth, x, this.txtHeight});
        this.chkFullscreen = new JFXCheckBox();
        right.setRight((Node)this.chkFullscreen);
        this.chkFullscreen.setText(I18n.i18n("settings.game.fullscreen"));
        this.chkFullscreen.setAlignment(Pos.CENTER);
        BorderPane.setAlignment((Node)this.chkFullscreen, (Pos)Pos.CENTER);
        BorderPane.setMargin((Node)this.chkFullscreen, (Insets)new Insets(0.0, 0.0, 0.0, 7.0));
        this.showLogsPane = new OptionToggleButton();
        this.showLogsPane.setTitle(I18n.i18n("settings.show_log"));
        BorderPane processPriorityPane = new BorderPane();
        Label label3 = new Label(I18n.i18n("settings.advanced.process_priority"));
        processPriorityPane.setLeft((Node)label3);
        BorderPane.setAlignment((Node)label3, (Pos)Pos.CENTER_LEFT);
        this.cboProcessPriority = new JFXComboBox();
        processPriorityPane.setRight(this.cboProcessPriority);
        BorderPane.setAlignment(this.cboProcessPriority, (Pos)Pos.CENTER_RIGHT);
        FXUtils.setLimitWidth(this.cboProcessPriority, 300.0);
        GridPane serverPane = new GridPane();
        ColumnConstraints title2 = new ColumnConstraints();
        ColumnConstraints value2 = new ColumnConstraints();
        value2.setFillWidth(true);
        value2.setHgrow(Priority.ALWAYS);
        value2.setHalignment(HPos.RIGHT);
        serverPane.setHgap(16.0);
        serverPane.setVgap(8.0);
        serverPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{title2, value2});
        this.txtServerIP = new JFXTextField();
        this.txtServerIP.setPromptText(I18n.i18n("settings.advanced.server_ip.prompt"));
        FXUtils.setLimitWidth((Region)this.txtServerIP, 300.0);
        serverPane.addRow(0, new Node[]{new Label(I18n.i18n("settings.advanced.server_ip")), this.txtServerIP});
        this.componentList.getContent().setAll((Object[])new Node[]{this.javaSublist, this.gameDirSublist, maxMemoryPane, launcherVisibilityPane, dimensionPane, this.showLogsPane, processPriorityPane, serverPane});
        HBox advancedHintPane = new HBox();
        advancedHintPane.setAlignment(Pos.CENTER);
        advancedHintPane.setPadding(new Insets(16.0, 0.0, 8.0, 0.0));
        Label advanced = new Label(I18n.i18n("settings.advanced"));
        advanced.setStyle("-fx-font-size: 12px;");
        advancedHintPane.getChildren().setAll((Object[])new Node[]{advanced});
        ComponentList customCommandsPane = new ComponentList();
        customCommandsPane.disableProperty().bind((ObservableValue)this.enableSpecificSettings.not());
        GridPane pane = new GridPane();
        pane.setHgap(16.0);
        pane.setVgap(8.0);
        pane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), FXUtils.getColumnHgrowing()});
        this.txtGameArgs = new JFXTextField();
        this.txtGameArgs.setPromptText(I18n.i18n("settings.advanced.minecraft_arguments.prompt"));
        this.txtGameArgs.getStyleClass().add((Object)"fit-width");
        pane.addRow(0, new Node[]{new Label(I18n.i18n("settings.advanced.minecraft_arguments")), this.txtGameArgs});
        this.txtPreLaunchCommand = new JFXTextField();
        this.txtPreLaunchCommand.setPromptText(I18n.i18n("settings.advanced.precall_command.prompt"));
        this.txtPreLaunchCommand.getStyleClass().add((Object)"fit-width");
        pane.addRow(1, new Node[]{new Label(I18n.i18n("settings.advanced.precall_command")), this.txtPreLaunchCommand});
        this.txtWrapper = new JFXTextField();
        this.txtWrapper.setPromptText(I18n.i18n("settings.advanced.wrapper_launcher.prompt"));
        this.txtWrapper.getStyleClass().add((Object)"fit-width");
        pane.addRow(2, new Node[]{new Label(I18n.i18n("settings.advanced.wrapper_launcher")), this.txtWrapper});
        this.txtPostExitCommand = new JFXTextField();
        this.txtPostExitCommand.setPromptText(I18n.i18n("settings.advanced.post_exit_command.prompt"));
        this.txtPostExitCommand.getStyleClass().add((Object)"fit-width");
        pane.addRow(3, new Node[]{new Label(I18n.i18n("settings.advanced.post_exit_command")), this.txtPostExitCommand});
        HintPane hintPane = new HintPane();
        hintPane.setText(I18n.i18n("settings.advanced.custom_commands.hint"));
        GridPane.setColumnSpan((Node)hintPane, (Integer)2);
        pane.addRow(4, new Node[]{hintPane});
        customCommandsPane.getContent().setAll((Object[])new Node[]{pane});
        ComponentList jvmPane = new ComponentList();
        jvmPane.disableProperty().bind((ObservableValue)this.enableSpecificSettings.not());
        GridPane pane2 = new GridPane();
        ColumnConstraints title3 = new ColumnConstraints();
        ColumnConstraints value3 = new ColumnConstraints();
        value3.setFillWidth(true);
        value3.setHgrow(Priority.ALWAYS);
        pane2.setHgap(16.0);
        pane2.setVgap(8.0);
        pane2.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{title3, value3});
        this.txtJVMArgs = new JFXTextField();
        this.txtJVMArgs.setPromptText(I18n.i18n("settings.advanced.jvm_args.prompt"));
        this.txtJVMArgs.getStyleClass().add((Object)"fit-width");
        pane2.addRow(0, new Node[]{new Label(I18n.i18n("settings.advanced.jvm_args")), this.txtJVMArgs});
        this.txtMetaspace = new JFXTextField();
        this.txtMetaspace.setPromptText(I18n.i18n("settings.advanced.java_permanent_generation_space.prompt"));
        this.txtMetaspace.getStyleClass().add((Object)"fit-width");
        FXUtils.setValidateWhileTextChanged((Node)this.txtMetaspace, true);
        this.txtMetaspace.setValidators(new NumberValidator(I18n.i18n("input.number"), true));
        pane2.addRow(1, new Node[]{new Label(I18n.i18n("settings.advanced.java_permanent_generation_space")), this.txtMetaspace});
        jvmPane.getContent().setAll((Object[])new Node[]{pane2});
        ComponentList workaroundPane = new ComponentList();
        workaroundPane.disableProperty().bind((ObservableValue)this.enableSpecificSettings.not());
        HintPane workaroundWarning = new HintPane(MessageDialogPane.MessageType.WARNING);
        workaroundWarning.setText(I18n.i18n("settings.advanced.workaround.warning"));
        this.nativesDirItem = new MultiFileItem();
        this.nativesDirSublist = new ComponentSublist();
        this.nativesDirSublist.getContent().add(this.nativesDirItem);
        this.nativesDirSublist.setTitle(I18n.i18n("settings.advanced.natives_directory"));
        this.nativesDirSublist.setHasSubtitle(true);
        this.nativesDirCustomOption = new MultiFileItem.FileOption<NativesDirectoryType>(I18n.i18n("settings.advanced.natives_directory.custom"), NativesDirectoryType.CUSTOM).setChooserTitle(I18n.i18n("settings.advanced.natives_directory.choose")).setDirectory(true);
        this.nativesDirItem.loadChildren(Arrays.asList(new MultiFileItem.Option<NativesDirectoryType>(I18n.i18n("settings.advanced.natives_directory.default"), NativesDirectoryType.VERSION_FOLDER), this.nativesDirCustomOption));
        HintPane nativesDirHint = new HintPane(MessageDialogPane.MessageType.WARNING);
        nativesDirHint.setText(I18n.i18n("settings.advanced.natives_directory.hint"));
        this.nativesDirItem.getChildren().add((Object)nativesDirHint);
        this.noJVMArgsPane = new OptionToggleButton();
        this.noJVMArgsPane.setTitle(I18n.i18n("settings.advanced.no_jvm_args"));
        this.noGameCheckPane = new OptionToggleButton();
        this.noGameCheckPane.setTitle(I18n.i18n("settings.advanced.dont_check_game_completeness"));
        this.noJVMCheckPane = new OptionToggleButton();
        this.noJVMCheckPane.setTitle(I18n.i18n("settings.advanced.dont_check_jvm_validity"));
        this.useNativeGLFWPane = new OptionToggleButton();
        this.useNativeGLFWPane.setTitle(I18n.i18n("settings.advanced.use_native_glfw"));
        this.useNativeOpenALPane = new OptionToggleButton();
        this.useNativeOpenALPane.setTitle(I18n.i18n("settings.advanced.use_native_openal"));
        workaroundPane.getContent().setAll((Object[])new Node[]{this.nativesDirSublist, this.noJVMArgsPane, this.noGameCheckPane, this.noJVMCheckPane, this.useNativeGLFWPane, this.useNativeOpenALPane});
        this.rootPane.getChildren().addAll((Object[])new Node[]{this.componentList, advancedHintPane, ComponentList.createComponentListTitle(I18n.i18n("settings.advanced.custom_commands")), customCommandsPane, ComponentList.createComponentListTitle(I18n.i18n("settings.advanced.jvm")), jvmPane, ComponentList.createComponentListTitle(I18n.i18n("settings.advanced.workaround")), workaroundWarning, workaroundPane});
        this.initialize();
        this.specificSettingsListener = any -> this.enableSpecificSettings.set(!this.lastVersionSetting.isUsesGlobal());
        this.addEventHandler(Navigator.NavigationEvent.NAVIGATED, this::onDecoratorPageNavigating);
        this.cboLauncherVisibility.getItems().setAll((Object[])LauncherVisibility.values());
        this.cboLauncherVisibility.setConverter(FXUtils.stringConverter(e -> I18n.i18n("settings.advanced.launcher_visibility." + e.name().toLowerCase())));
        this.cboProcessPriority.getItems().setAll((Object[])ProcessPriority.values());
        this.cboProcessPriority.setConverter(FXUtils.stringConverter(e -> I18n.i18n("settings.advanced.process_priority." + e.name().toLowerCase())));
    }

    private void initialize() {
        this.memoryStatus.set((Object)OperatingSystem.getPhysicalMemoryStatus().orElse(OperatingSystem.PhysicalMemoryStatus.INVALID));
        Task.supplyAsync(JavaVersion::getJavas).thenAcceptAsync(Schedulers.javafx(), list -> {
            boolean isX86 = Architecture.SYSTEM_ARCH.isX86() && list.stream().allMatch(java -> java.getArchitecture().isX86());
            List options = list.stream().map(javaVersion -> new MultiFileItem.Option<Pair<JavaVersionType, JavaVersion>>(I18n.i18n("settings.game.java_directory.template", javaVersion.getVersion(), isX86 ? I18n.i18n("settings.game.java_directory.bit", javaVersion.getBits().getBit()) : javaVersion.getPlatform().getArchitecture().getDisplayName()), Pair.pair(JavaVersionType.DETECTED, javaVersion)).setSubtitle(javaVersion.getBinary().toString())).collect(Collectors.toList());
            options.add(0, this.javaAutoDeterminedOption);
            options.add(this.javaCustomOption);
            this.javaItem.loadChildren(options);
            this.javaItemsLoaded = true;
            this.initializeSelectedJava();
        }).start();
        this.javaItem.setSelectedData(null);
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            this.javaCustomOption.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Java", new String[]{"java.exe", "javaw.exe"}));
        }
        this.enableSpecificSettings.addListener((a, b, newValue) -> {
            if (this.versionId == null) {
                return;
            }
            if (newValue.booleanValue()) {
                this.profile.getRepository().specializeVersionSetting(this.versionId);
            } else {
                this.profile.getRepository().globalizeVersionSetting(this.versionId);
            }
            Platform.runLater(() -> this.loadVersion(this.profile, this.versionId));
        });
        this.componentList.disableProperty().bind((ObservableValue)this.enableSpecificSettings.not());
    }

    @Override
    public void loadVersion(Profile profile, String versionId) {
        this.profile = profile;
        this.versionId = versionId;
        this.listenerHolder = new WeakListenerHolder();
        if (versionId == null) {
            this.enableSpecificSettings.set(true);
            this.state.set((Object)DecoratorPage.State.fromTitle(Profiles.getProfileDisplayName(profile) + " - " + I18n.i18n("settings.type.global.manage")));
            this.listenerHolder.add(FXUtils.onWeakChangeAndOperate(profile.selectedVersionProperty(), selectedVersion -> {
                this.selectedVersion.setValue(selectedVersion);
                VersionSetting specializedVersionSetting = profile.getRepository().getLocalVersionSetting((String)selectedVersion);
                if (specializedVersionSetting != null) {
                    this.navigateToSpecificSettings.bind((ObservableValue)specializedVersionSetting.usesGlobalProperty().not());
                } else {
                    this.navigateToSpecificSettings.unbind();
                    this.navigateToSpecificSettings.set(false);
                }
            }));
        } else {
            this.navigateToSpecificSettings.unbind();
            this.navigateToSpecificSettings.set(false);
        }
        VersionSetting versionSetting = profile.getVersionSetting(versionId);
        this.modpack.set(versionId != null && profile.getRepository().isModpack(versionId));
        if (this.lastVersionSetting != null) {
            FXUtils.unbindInt(this.txtWidth, (Property<Number>)this.lastVersionSetting.widthProperty());
            FXUtils.unbindInt(this.txtHeight, (Property<Number>)this.lastVersionSetting.heightProperty());
            this.maxMemory.unbindBidirectional((Property)this.lastVersionSetting.maxMemoryProperty());
            this.javaCustomOption.valueProperty().unbindBidirectional((Property)this.lastVersionSetting.javaDirProperty());
            this.gameDirCustomOption.valueProperty().unbindBidirectional((Property)this.lastVersionSetting.gameDirProperty());
            this.nativesDirCustomOption.valueProperty().unbindBidirectional((Property)this.lastVersionSetting.nativesDirProperty());
            FXUtils.unbindString(this.txtJVMArgs, (Property<String>)this.lastVersionSetting.javaArgsProperty());
            FXUtils.unbindString(this.txtGameArgs, (Property<String>)this.lastVersionSetting.minecraftArgsProperty());
            FXUtils.unbindString(this.txtMetaspace, (Property<String>)this.lastVersionSetting.permSizeProperty());
            FXUtils.unbindString(this.txtWrapper, (Property<String>)this.lastVersionSetting.wrapperProperty());
            FXUtils.unbindString(this.txtPreLaunchCommand, (Property<String>)this.lastVersionSetting.preLaunchCommandProperty());
            FXUtils.unbindString(this.txtPostExitCommand, (Property<String>)this.lastVersionSetting.postExitCommandProperty());
            FXUtils.unbindString(this.txtServerIP, (Property<String>)this.lastVersionSetting.serverIpProperty());
            FXUtils.unbindBoolean(this.chkAutoAllocate, (Property<Boolean>)this.lastVersionSetting.autoMemoryProperty());
            FXUtils.unbindBoolean(this.chkFullscreen, (Property<Boolean>)this.lastVersionSetting.fullscreenProperty());
            this.noGameCheckPane.selectedProperty().unbindBidirectional((Property)this.lastVersionSetting.notCheckGameProperty());
            this.noJVMCheckPane.selectedProperty().unbindBidirectional((Property)this.lastVersionSetting.notCheckJVMProperty());
            this.noJVMArgsPane.selectedProperty().unbindBidirectional((Property)this.lastVersionSetting.noJVMArgsProperty());
            this.showLogsPane.selectedProperty().unbindBidirectional((Property)this.lastVersionSetting.showLogsProperty());
            this.useNativeGLFWPane.selectedProperty().unbindBidirectional((Property)this.lastVersionSetting.useNativeGLFWProperty());
            this.useNativeOpenALPane.selectedProperty().unbindBidirectional((Property)this.lastVersionSetting.useNativeOpenALProperty());
            FXUtils.unbindEnum(this.cboLauncherVisibility);
            FXUtils.unbindEnum(this.cboProcessPriority);
            this.lastVersionSetting.usesGlobalProperty().removeListener(this.specificSettingsListener);
            this.lastVersionSetting.javaDirProperty().removeListener(this.javaListener);
            this.lastVersionSetting.javaProperty().removeListener(this.javaListener);
            this.gameDirItem.selectedDataProperty().unbindBidirectional(this.lastVersionSetting.gameDirTypeProperty());
            this.gameDirSublist.subtitleProperty().unbind();
            this.nativesDirItem.selectedDataProperty().unbindBidirectional(this.lastVersionSetting.nativesDirTypeProperty());
            this.nativesDirSublist.subtitleProperty().unbind();
        }
        this.javaItem.setToggleSelectedListener(null);
        FXUtils.bindInt(this.txtWidth, (Property<Number>)versionSetting.widthProperty());
        FXUtils.bindInt(this.txtHeight, (Property<Number>)versionSetting.heightProperty());
        this.maxMemory.bindBidirectional((Property)versionSetting.maxMemoryProperty());
        this.javaCustomOption.bindBidirectional((Property<String>)versionSetting.javaDirProperty());
        this.gameDirCustomOption.bindBidirectional((Property<String>)versionSetting.gameDirProperty());
        this.nativesDirCustomOption.bindBidirectional((Property<String>)versionSetting.nativesDirProperty());
        FXUtils.bindString(this.txtJVMArgs, (Property<String>)versionSetting.javaArgsProperty());
        FXUtils.bindString(this.txtGameArgs, (Property<String>)versionSetting.minecraftArgsProperty());
        FXUtils.bindString(this.txtMetaspace, (Property<String>)versionSetting.permSizeProperty());
        FXUtils.bindString(this.txtWrapper, (Property<String>)versionSetting.wrapperProperty());
        FXUtils.bindString(this.txtPreLaunchCommand, (Property<String>)versionSetting.preLaunchCommandProperty());
        FXUtils.bindString(this.txtServerIP, (Property<String>)versionSetting.serverIpProperty());
        FXUtils.bindBoolean(this.chkAutoAllocate, (Property<Boolean>)versionSetting.autoMemoryProperty());
        FXUtils.bindBoolean(this.chkFullscreen, (Property<Boolean>)versionSetting.fullscreenProperty());
        this.noGameCheckPane.selectedProperty().bindBidirectional((Property)versionSetting.notCheckGameProperty());
        this.noJVMCheckPane.selectedProperty().bindBidirectional((Property)versionSetting.notCheckJVMProperty());
        this.noJVMArgsPane.selectedProperty().bindBidirectional((Property)versionSetting.noJVMArgsProperty());
        this.showLogsPane.selectedProperty().bindBidirectional((Property)versionSetting.showLogsProperty());
        this.useNativeGLFWPane.selectedProperty().bindBidirectional((Property)versionSetting.useNativeGLFWProperty());
        this.useNativeOpenALPane.selectedProperty().bindBidirectional((Property)versionSetting.useNativeOpenALProperty());
        FXUtils.bindEnum(this.cboLauncherVisibility, versionSetting.launcherVisibilityProperty());
        FXUtils.bindEnum(this.cboProcessPriority, versionSetting.processPriorityProperty());
        versionSetting.usesGlobalProperty().addListener(this.specificSettingsListener);
        if (versionId != null) {
            this.enableSpecificSettings.set(!versionSetting.isUsesGlobal());
        }
        this.javaItem.setToggleSelectedListener(newValue -> {
            if (this.javaCustomOption.isSelected()) {
                versionSetting.setUsesCustomJavaDir();
            } else if (this.javaAutoDeterminedOption.isSelected()) {
                versionSetting.setJavaAutoSelected();
            } else {
                versionSetting.setJavaVersion((JavaVersion)((Pair)newValue.getUserData()).getValue());
            }
        });
        versionSetting.javaDirProperty().addListener(this.javaListener);
        versionSetting.defaultJavaPathPropertyProperty().addListener(this.javaListener);
        versionSetting.javaProperty().addListener(this.javaListener);
        this.gameDirItem.selectedDataProperty().bindBidirectional(versionSetting.gameDirTypeProperty());
        this.gameDirSublist.subtitleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Paths.get(profile.getRepository().getRunDirectory(versionId).getAbsolutePath(), new String[0]).normalize().toString(), (Observable[])new Observable[]{versionSetting.gameDirProperty(), versionSetting.gameDirTypeProperty()}));
        this.nativesDirItem.selectedDataProperty().bindBidirectional(versionSetting.nativesDirTypeProperty());
        this.nativesDirSublist.subtitleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Paths.get(profile.getRepository().getRunDirectory(versionId).getAbsolutePath() + "/natives", new String[0]).normalize().toString(), (Observable[])new Observable[]{versionSetting.nativesDirProperty(), versionSetting.nativesDirTypeProperty()}));
        this.lastVersionSetting = versionSetting;
        this.initJavaSubtitle();
        this.loadIcon();
    }

    private void initializeSelectedJava() {
        if (this.lastVersionSetting == null || !this.javaItemsLoaded) {
            return;
        }
        if (this.lastVersionSetting.isUsesCustomJavaDir()) {
            this.javaCustomOption.setSelected(true);
        } else if (this.lastVersionSetting.isJavaAutoSelected()) {
            this.javaAutoDeterminedOption.setSelected(true);
        } else {
            this.lastVersionSetting.getJavaVersion(null, null).thenAcceptAsync(Schedulers.javafx(), javaVersion -> this.javaItem.setSelectedData(Pair.pair(JavaVersionType.DETECTED, javaVersion))).start();
        }
    }

    private void initJavaSubtitle() {
        FXUtils.checkFxUserThread();
        this.initializeSelectedJava();
        VersionSetting versionSetting = this.lastVersionSetting;
        if (versionSetting == null) {
            return;
        }
        Profile profile = this.profile;
        String versionId = this.versionId;
        boolean autoSelected = versionSetting.isJavaAutoSelected();
        if (autoSelected && versionId == null) {
            this.javaSublist.setSubtitle(I18n.i18n("settings.game.java_directory.auto"));
            return;
        }
        Task.composeAsync(Schedulers.javafx(), () -> {
            if (versionId == null) {
                return versionSetting.getJavaVersion(VersionNumber.asVersion("Unknown"), null);
            }
            return versionSetting.getJavaVersion(VersionNumber.asVersion(GameVersion.minecraftVersion(profile.getRepository().getVersionJar(versionId)).orElse("Unknown")), profile.getRepository().getVersion(versionId));
        }).thenAcceptAsync(Schedulers.javafx(), javaVersion -> this.javaSublist.setSubtitle(Optional.ofNullable(javaVersion).map(JavaVersion::getBinary).map(Path::toString).orElseGet(() -> autoSelected ? I18n.i18n("settings.game.java_directory.auto.not_found") : I18n.i18n("settings.game.java_directory.invalid")))).start();
    }

    private void editSpecificSettings() {
        Versions.modifyGameSettings(this.profile, this.profile.getSelectedVersion());
    }

    private void editGlobalSettings() {
        Versions.modifyGlobalSettings(this.profile);
    }

    private void onExploreIcon() {
        if (this.versionId == null) {
            return;
        }
        Controllers.dialog((Region)new VersionIconDialog(this.profile, this.versionId, this::loadIcon));
    }

    private void onDeleteIcon() {
        VersionSetting localVersionSetting;
        if (this.versionId == null) {
            return;
        }
        File iconFile = this.profile.getRepository().getVersionIconFile(this.versionId);
        if (iconFile.exists()) {
            iconFile.delete();
        }
        if ((localVersionSetting = this.profile.getRepository().getLocalVersionSettingOrCreate(this.versionId)) != null) {
            localVersionSetting.setVersionIcon(VersionIconType.DEFAULT);
        }
        this.loadIcon();
    }

    private void loadIcon() {
        if (this.versionId == null) {
            return;
        }
        this.iconPickerItem.setImage(this.profile.getRepository().getVersionIconImage(this.versionId));
        FXUtils.limitSize(this.iconPickerItem.getImageView(), 32.0, 32.0);
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    private static enum JavaVersionType {
        DETECTED,
        CUSTOM,
        AUTO;

    }
}

