/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.File;
import java.util.Date;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.versions.DatapackListPage;
import org.jackhuang.hmcl.ui.versions.WorldExportPage;
import org.jackhuang.hmcl.ui.versions.WorldListItemSkin;
import org.jackhuang.hmcl.ui.wizard.SinglePageWizardProvider;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.Locales;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public class WorldListItem
extends Control {
    private final StringProperty title = new SimpleStringProperty();
    private final StringProperty subtitle = new SimpleStringProperty();
    private final ObjectProperty<Image> image = new SimpleObjectProperty();
    private final World world;

    public WorldListItem(World world) {
        this.world = world;
        this.title.set((Object)StringUtils.parseColorEscapes(world.getWorldName()));
        this.subtitle.set((Object)I18n.i18n("world.description", world.getFileName(), Locales.SIMPLE_DATE_FORMAT.get().format(new Date(world.getLastPlayed())), world.getGameVersion() == null ? I18n.i18n("message.unknown") : world.getGameVersion()));
    }

    protected Skin<?> createDefaultSkin() {
        return new WorldListItemSkin(this);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public ObjectProperty<Image> imageProperty() {
        return this.image;
    }

    public void export() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("world.export.title"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("world"), new String[]{"*.zip"}));
        fileChooser.setInitialFileName(this.world.getWorldName());
        File file = fileChooser.showSaveDialog((Window)Controllers.getStage());
        if (file == null) {
            return;
        }
        Controllers.getDecorator().startWizard(new SinglePageWizardProvider(controller -> new WorldExportPage(this.world, file.toPath(), controller::onFinish)));
    }

    public void reveal() {
        try {
            FXUtils.openFolder(this.world.getFile().toFile());
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
    }

    public void manageDatapacks() {
        if (this.world.getGameVersion() == null || VersionNumber.isIntVersionNumber(this.world.getGameVersion()) && VersionNumber.asVersion(this.world.getGameVersion()).compareTo(VersionNumber.asVersion("1.13")) < 0) {
            Controllers.dialog(I18n.i18n("world.datapack.1_13"));
            return;
        }
        Controllers.navigate((Node)new DatapackListPage(this.world.getWorldName(), this.world.getFile()));
    }
}

