/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.Objects;

public abstract class Result<T> {
    public T get() {
        throw new IllegalStateException("TriState not ok");
    }

    public boolean isOK() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public static <T> Result<T> ok(T result) {
        return new OK<T>(Objects.requireNonNull(result));
    }

    public static <T> Result<T> error() {
        return Error.INSTANCE;
    }

    private static class Error<T>
    extends Result<T> {
        public static final Error<Void> INSTANCE = new Error();

        private Error() {
        }

        @Override
        public boolean isError() {
            return true;
        }
    }

    private static class OK<T>
    extends Result<T> {
        private final T result;

        public OK(T result) {
            this.result = result;
        }

        @Override
        public T get() {
            return this.result;
        }
    }
}

