/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.util.JavaFXPatcher;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.ChecksumMismatchException;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class SelfDependencyPatcher {
    private static final String DEPENDENCIES_LIST_FILE = "/assets/openjfx-dependencies.json";

    private SelfDependencyPatcher() {
    }

    public static void patch() throws PatchException, IncompatibleVersionException, CancellationException {
        try {
            Class.forName("javafx.application.Application");
            return;
        }
        catch (Exception exception) {
        }
        catch (UnsupportedClassVersionError error) {
            throw new IncompatibleVersionException();
        }
        if (JavaVersion.CURRENT_JAVA.getParsedVersion() < 11) {
            throw new IncompatibleVersionException();
        }
        if (DependencyDescriptor.CURRENT_ARCH_CLASSIFIER == null) {
            throw new IncompatibleVersionException();
        }
        Logging.LOG.info("Missing JavaFX dependencies, attempting to patch in missing classes");
        List<DependencyDescriptor> missingDependencies = SelfDependencyPatcher.checkMissingDependencies();
        if (!missingDependencies.isEmpty()) {
            try {
                SelfDependencyPatcher.fetchDependencies(missingDependencies);
            }
            catch (IOException e) {
                throw new PatchException("Failed to download dependencies", e);
            }
        }
        try {
            SelfDependencyPatcher.loadFromCache();
        }
        catch (IOException ex) {
            throw new PatchException("Failed to load JavaFX cache", ex);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException ex) {
            throw new PatchException("Failed to add dependencies to classpath!", ex);
        }
        Logging.LOG.info(" - Done!");
    }

    private static Repository showChooseRepositoryDialog() {
        AbstractButton button;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (String line : I18n.i18n("repositories.chooser").split("\n")) {
            panel.add(new JLabel(line));
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Repository repository : Repository.REPOSITORIES) {
            button = new JRadioButton(repository.name);
            button.putClientProperty("repository", repository);
            buttonGroup.add(button);
            panel.add(button);
            if (repository != Repository.DEFAULT) continue;
            button.setSelected(true);
        }
        int res = JOptionPane.showConfirmDialog(null, panel, I18n.i18n("repositories.chooser.title"), 2);
        if (res == 0) {
            Enumeration<AbstractButton> buttons = buttonGroup.getElements();
            while (buttons.hasMoreElements()) {
                button = buttons.nextElement();
                if (!button.isSelected()) continue;
                return (Repository)button.getClientProperty("repository");
            }
        } else {
            Logging.LOG.info("User choose not to download JavaFX");
            System.exit(0);
        }
        throw new AssertionError();
    }

    private static void loadFromCache() throws IOException, ReflectiveOperationException {
        Logging.LOG.info(" - Loading dependencies...");
        Set<String> modules = DependencyDescriptor.JFX_DEPENDENCIES.stream().filter(DependencyDescriptor::isSupported).map(it -> it.module).collect(Collectors.toSet());
        Path[] jars = (Path[])DependencyDescriptor.JFX_DEPENDENCIES.stream().filter(DependencyDescriptor::isSupported).map(DependencyDescriptor::localPath).toArray(Path[]::new);
        JavaFXPatcher.patch(modules, jars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fetchDependencies(List<DependencyDescriptor> dependencies) throws IOException {
        ProgressFrame dialog;
        boolean isFirstTime = true;
        byte[] buffer = new byte[8192];
        Repository repository = Repository.DEFAULT;
        int count = 0;
        while (true) {
            AtomicBoolean isCancelled = new AtomicBoolean();
            AtomicBoolean showDetails = new AtomicBoolean();
            dialog = new ProgressFrame(I18n.i18n("download.javafx"));
            dialog.setProgressMaximum(dependencies.size() + 1);
            dialog.setProgress(count);
            dialog.setOnCancel(() -> isCancelled.set(true));
            dialog.setOnChangeSource(() -> {
                isCancelled.set(true);
                showDetails.set(true);
            });
            dialog.setVisible(true);
            try {
                if (isFirstTime) {
                    isFirstTime = false;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Files.createDirectories(DependencyDescriptor.DEPENDENCIES_DIR_PATH, new FileAttribute[0]);
                for (int i = count; i < dependencies.size(); ++i) {
                    if (isCancelled.get()) {
                        throw new CancellationException();
                    }
                    DependencyDescriptor dependency = dependencies.get(i);
                    String url = repository.resolveDependencyURL(dependency);
                    SwingUtilities.invokeLater(() -> {
                        dialog.setCurrent(dependency.module);
                        dialog.incrementProgress();
                    });
                    Logging.LOG.info("Downloading " + url);
                    try (InputStream is = new URL(url).openStream();
                         OutputStream os = Files.newOutputStream(dependency.localPath(), new OpenOption[0]);){
                        int read;
                        while ((read = is.read(buffer, 0, 8192)) >= 0) {
                            if (isCancelled.get()) {
                                try {
                                    os.close();
                                }
                                finally {
                                    Files.deleteIfExists(dependency.localPath());
                                }
                                throw new CancellationException();
                            }
                            os.write(buffer, 0, read);
                        }
                    }
                    SelfDependencyPatcher.verifyChecksum(dependency);
                    ++count;
                }
            }
            catch (CancellationException e) {
                dialog.dispose();
                if (showDetails.get()) {
                    repository = SelfDependencyPatcher.showChooseRepositoryDialog();
                    continue;
                }
                throw e;
            }
            break;
        }
        dialog.dispose();
    }

    private static List<DependencyDescriptor> checkMissingDependencies() {
        ArrayList<DependencyDescriptor> missing = new ArrayList<DependencyDescriptor>();
        for (DependencyDescriptor dependency : DependencyDescriptor.JFX_DEPENDENCIES) {
            if (!dependency.isSupported()) continue;
            if (!Files.exists(dependency.localPath(), new LinkOption[0])) {
                missing.add(dependency);
                continue;
            }
            try {
                SelfDependencyPatcher.verifyChecksum(dependency);
            }
            catch (ChecksumMismatchException e) {
                Logging.LOG.warning("Corrupted dependency " + dependency.filename() + ": " + e.getMessage());
                missing.add(dependency);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return missing;
    }

    private static void verifyChecksum(DependencyDescriptor dependency) throws IOException, ChecksumMismatchException {
        ChecksumMismatchException.verifyChecksum(dependency.localPath(), "SHA-1", dependency.sha1());
    }

    static class DependencyDescriptor {
        private static final Path DEPENDENCIES_DIR_PATH = Metadata.HMCL_DIRECTORY.resolve("dependencies");
        public static final String CURRENT_ARCH_CLASSIFIER = DependencyDescriptor.currentArchClassifier();
        public static final List<DependencyDescriptor> JFX_DEPENDENCIES = DependencyDescriptor.readDependencies();
        public String module;
        public String groupId;
        public String artifactId;
        public String version;
        public Map<String, String> sha1;

        DependencyDescriptor() {
        }

        private static List<DependencyDescriptor> readDependencies() {
            String content;
            try (InputStream in = SelfDependencyPatcher.class.getResourceAsStream(SelfDependencyPatcher.DEPENDENCIES_LIST_FILE);){
                content = IOUtils.readFullyAsString(in, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return (List)new Gson().fromJson(content, TypeToken.getParameterized(List.class, new Type[]{DependencyDescriptor.class}).getType());
        }

        private static String currentArchClassifier() {
            if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX) {
                switch (Architecture.CURRENT_ARCH) {
                    case X86_64: {
                        return "linux";
                    }
                    case ARM32: {
                        return "linux-arm32-monocle";
                    }
                    case ARM64: {
                        return "linux-aarch64";
                    }
                }
            } else if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
                switch (Architecture.CURRENT_ARCH) {
                    case X86_64: {
                        return "mac";
                    }
                    case ARM64: {
                        return "mac-aarch64";
                    }
                }
            } else if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                switch (Architecture.CURRENT_ARCH) {
                    case X86_64: {
                        return "win";
                    }
                    case X86: {
                        return "win-x86";
                    }
                }
            }
            return null;
        }

        public String filename() {
            if (CURRENT_ARCH_CLASSIFIER == null) {
                return null;
            }
            return this.artifactId + "-" + this.version + "-" + CURRENT_ARCH_CLASSIFIER + ".jar";
        }

        public String sha1() {
            if (CURRENT_ARCH_CLASSIFIER == null) {
                return null;
            }
            return this.sha1.get(CURRENT_ARCH_CLASSIFIER);
        }

        public Path localPath() {
            if (CURRENT_ARCH_CLASSIFIER == null) {
                return null;
            }
            return DEPENDENCIES_DIR_PATH.resolve(this.filename());
        }

        public boolean isSupported() {
            return CURRENT_ARCH_CLASSIFIER != null && this.sha1.containsKey(CURRENT_ARCH_CLASSIFIER);
        }
    }

    public static class IncompatibleVersionException
    extends Exception {
    }

    public static class PatchException
    extends Exception {
        PatchException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ProgressFrame
    extends JDialog {
        private final JProgressBar progressBar;
        private final JLabel progressText;
        private final JButton btnChangeSource;
        private final JButton btnCancel;

        public ProgressFrame(String title) {
            JPanel panel = new JPanel();
            this.setResizable(false);
            this.setTitle(title);
            this.setDefaultCloseOperation(2);
            this.setBounds(100, 100, 500, 200);
            this.setContentPane(panel);
            this.setLocationRelativeTo(null);
            JPanel content = new JPanel();
            content.setLayout(new BoxLayout(content, 1));
            for (String note : I18n.i18n("download.javafx.notes").split("\n")) {
                content.add(new JLabel(note));
            }
            content.add(new JLabel("<html><br/></html>"));
            this.progressText = new JLabel(I18n.i18n("download.javafx.prepare"));
            content.add(this.progressText);
            this.progressBar = new JProgressBar();
            content.add(this.progressBar);
            JPanel buttonBar = new JPanel();
            this.btnChangeSource = new JButton(I18n.i18n("button.change_source"));
            this.btnCancel = new JButton(I18n.i18n("button.cancel"));
            buttonBar.add(this.btnChangeSource);
            buttonBar.add(this.btnCancel);
            panel.setLayout(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 5));
            panel.add((Component)content, "Center");
            panel.add((Component)buttonBar, "South");
        }

        public void setCurrent(String component) {
            this.progressText.setText(I18n.i18n("download.javafx.component", component));
        }

        public void setProgressMaximum(int total) {
            this.progressBar.setMaximum(total);
        }

        public void setProgress(int n) {
            this.progressBar.setValue(n);
        }

        public void incrementProgress() {
            this.progressBar.setValue(this.progressBar.getValue() + 1);
        }

        public void setOnCancel(final Runnable action) {
            this.btnCancel.addActionListener(e -> action.run());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    action.run();
                }
            });
        }

        public void setOnChangeSource(Runnable action) {
            this.btnChangeSource.addActionListener(e -> action.run());
        }
    }

    static final class Repository {
        public static final List<Repository> REPOSITORIES;
        public static final Repository CUSTOM;
        public static final Repository MAVEN_CENTRAL;
        public static final Repository ALIYUN_MIRROR;
        public static final Repository DEFAULT;
        private final String name;
        private final String url;

        Repository(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String resolveDependencyURL(DependencyDescriptor descriptor) {
            return String.format("%s/%s/%s/%s/%s", this.url, descriptor.groupId.replace('.', '/'), descriptor.artifactId, descriptor.version, descriptor.filename());
        }

        static {
            MAVEN_CENTRAL = new Repository(I18n.i18n("repositories.maven_central"), "https://repo1.maven.org/maven2");
            ALIYUN_MIRROR = new Repository(I18n.i18n("repositories.aliyun_mirror"), "https://maven.aliyun.com/repository/central");
            String customUrl = System.getProperty("hmcl.openjfx.repo");
            if (customUrl == null) {
                CUSTOM = null;
                DEFAULT = System.getProperty("user.country", "").equalsIgnoreCase("CN") ? ALIYUN_MIRROR : MAVEN_CENTRAL;
                REPOSITORIES = Collections.unmodifiableList(Arrays.asList(MAVEN_CENTRAL, ALIYUN_MIRROR));
            } else {
                DEFAULT = CUSTOM = new Repository(String.format(I18n.i18n("repositories.custom"), customUrl), customUrl);
                REPOSITORIES = Collections.unmodifiableList(Arrays.asList(MAVEN_CENTRAL, ALIYUN_MIRROR, CUSTOM));
            }
        }
    }
}

