/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import org.jackhuang.hmcl.util.io.IOUtils;

public class HttpMultipartRequest
implements Closeable {
    private final String boundary = "*****" + System.currentTimeMillis() + "*****";
    private final HttpURLConnection urlConnection;
    private final ByteArrayOutputStream stream;
    private final String endl = "\r\n";

    public HttpMultipartRequest(HttpURLConnection urlConnection) throws IOException {
        this.urlConnection = urlConnection;
        urlConnection.setDoOutput(true);
        urlConnection.setUseCaches(false);
        urlConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.stream = new ByteArrayOutputStream();
    }

    private void addLine(String content) throws IOException {
        this.stream.write(content.getBytes(StandardCharsets.UTF_8));
        this.stream.write("\r\n".getBytes(StandardCharsets.UTF_8));
    }

    public HttpMultipartRequest file(String name, String filename, String contentType, InputStream inputStream) throws IOException {
        this.addLine("--" + this.boundary);
        this.addLine(String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", name, filename));
        this.addLine("Content-Type: " + contentType);
        this.addLine("");
        IOUtils.copyTo(inputStream, this.stream);
        this.addLine("");
        return this;
    }

    public HttpMultipartRequest param(String name, String value) throws IOException {
        this.addLine("--" + this.boundary);
        this.addLine(String.format("Content-Disposition: form-data; name=\"%s\"", name));
        this.addLine("");
        this.addLine(value);
        return this;
    }

    @Override
    public void close() throws IOException {
        this.addLine("--" + this.boundary + "--");
        this.urlConnection.setRequestProperty("Content-Length", "" + this.stream.size());
        try (OutputStream os = this.urlConnection.getOutputStream();){
            IOUtils.write(this.stream.toByteArray(), os);
        }
    }
}

