/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.javafx;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.javafx.AutomatedToggleGroup;
import org.jackhuang.hmcl.util.javafx.BindingMapping;
import org.jackhuang.hmcl.util.javafx.MappedProperty;
import org.jackhuang.hmcl.util.javafx.ReadWriteComposedProperty;
import org.jackhuang.hmcl.util.javafx.ReferenceHolder;

public final class ExtendedProperties {
    private static final String PROP_PREFIX = ExtendedProperties.class.getName();

    public static <T> ObjectProperty<T> selectedItemPropertyFor(ComboBox<T> comboBox) {
        return (ObjectProperty)comboBox.getProperties().computeIfAbsent((Object)(PROP_PREFIX + ".comboxBox.selectedItem"), any -> ExtendedProperties.createPropertyForSelectionModel(comboBox, comboBox.selectionModelProperty()));
    }

    private static <T> ObjectProperty<T> createPropertyForSelectionModel(Object bean, Property<? extends SelectionModel<T>> modelProperty) {
        return new ReadWriteComposedProperty<Object>(bean, "extra.selectedItem", (ObservableValue<Object>)BindingMapping.of(modelProperty).flatMap(SelectionModel::selectedItemProperty), obj -> ((SelectionModel)modelProperty.getValue()).select(obj));
    }

    public static ObjectProperty<Toggle> selectedTogglePropertyFor(ToggleGroup toggleGroup) {
        return (ObjectProperty)toggleGroup.getProperties().computeIfAbsent((Object)(PROP_PREFIX + ".toggleGroup.selectedToggle"), any -> ExtendedProperties.createPropertyForToggleGroup(toggleGroup));
    }

    private static ObjectProperty<Toggle> createPropertyForToggleGroup(ToggleGroup toggleGroup) {
        return new ReadWriteComposedProperty<Toggle>(toggleGroup, "extra.selectedToggle", (ObservableValue<Toggle>)toggleGroup.selectedToggleProperty(), arg_0 -> ((ToggleGroup)toggleGroup).selectToggle(arg_0));
    }

    public static <T> ObjectProperty<T> createSelectedItemPropertyFor(ObservableList<? extends Toggle> items, Class<T> userdataType) {
        return ExtendedProperties.selectedItemPropertyFor(new AutomatedToggleGroup(items), userdataType);
    }

    public static <T> ObjectProperty<T> selectedItemPropertyFor(ToggleGroup toggleGroup, Class<T> userdataType) {
        return (ObjectProperty)toggleGroup.getProperties().computeIfAbsent(Pair.pair(PROP_PREFIX + ".toggleGroup.selectedItem", userdataType), any -> ExtendedProperties.createMappedPropertyForToggleGroup(toggleGroup, toggle -> toggle == null ? null : userdataType.cast(toggle.getUserData())));
    }

    private static <T> ObjectProperty<T> createMappedPropertyForToggleGroup(ToggleGroup toggleGroup, Function<Toggle, T> mapper) {
        ObjectProperty<Toggle> selectedToggle = ExtendedProperties.selectedTogglePropertyFor(toggleGroup);
        AtomicReference pendingItemHolder = new AtomicReference();
        Consumer<Object> itemSelector = newItem -> {
            Optional<Toggle> toggleToSelect = toggleGroup.getToggles().stream().filter(toggle -> Objects.equals(newItem, mapper.apply((Toggle)toggle))).findFirst();
            if (toggleToSelect.isPresent()) {
                pendingItemHolder.set(null);
                selectedToggle.set((Object)toggleToSelect.get());
            } else {
                pendingItemHolder.set(Optional.ofNullable(newItem));
                selectedToggle.set(null);
            }
        };
        ReadWriteComposedProperty<Object> property = new ReadWriteComposedProperty<Object>(toggleGroup, "extra.selectedItem", (ObservableValue<Object>)BindingMapping.of(ExtendedProperties.selectedTogglePropertyFor(toggleGroup)).map(mapper), itemSelector);
        InvalidationListener onTogglesChanged = any -> {
            Optional pendingItem = (Optional)pendingItemHolder.get();
            if (pendingItem != null) {
                itemSelector.accept(pendingItem.orElse(null));
            }
        };
        toggleGroup.getToggles().addListener((InvalidationListener)new WeakInvalidationListener(onTogglesChanged));
        property.addListener(new ReferenceHolder(onTogglesChanged));
        return property;
    }

    public static ObjectProperty<Boolean> reversedSelectedPropertyFor(CheckBox checkbox) {
        return (ObjectProperty)checkbox.getProperties().computeIfAbsent((Object)(PROP_PREFIX + ".checkbox.reservedSelected"), any -> new MappedProperty<Boolean, Boolean>(checkbox, "ext.reservedSelected", (Property<Boolean>)checkbox.selectedProperty(), it -> it == false, it -> it == false));
    }

    public static ObjectProperty<Boolean> classPropertyFor(Node node, String cssClass) {
        return (ObjectProperty)node.getProperties().computeIfAbsent((Object)(PROP_PREFIX + ".cssClass." + cssClass), any -> {
            ObservableList classes = node.getStyleClass();
            return new ReadWriteComposedProperty<Boolean>(node, "extra.cssClass." + cssClass, (ObservableValue<Boolean>)Bindings.createBooleanBinding(() -> classes.contains((Object)cssClass), (Observable[])new Observable[]{classes}), state -> {
                if (state.booleanValue()) {
                    if (!classes.contains((Object)cssClass)) {
                        classes.add((Object)cssClass);
                    }
                } else {
                    classes.remove((Object)cssClass);
                }
            });
        });
    }

    private ExtendedProperties() {
    }
}

