/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.javafx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import org.jackhuang.hmcl.util.javafx.ReferenceHolder;

public final class MappedObservableList {
    private MappedObservableList() {
    }

    public static <T, U> ObservableList<U> create(ObservableList<T> origin, Function<T, U> mapper) {
        ObservableList target = origin.stream().map(mapper).collect(Collectors.toCollection(FXCollections::observableArrayList));
        MappedObservableListUpdater<T, U> listener = new MappedObservableListUpdater<T, U>(origin, target, mapper);
        target.addListener((InvalidationListener)new ReferenceHolder(listener));
        origin.addListener((ListChangeListener)new WeakListChangeListener(listener));
        return FXCollections.unmodifiableObservableList((ObservableList)target);
    }

    private static class MappedObservableListUpdater<T, U>
    implements ListChangeListener<T> {
        private ObservableList<T> origin;
        private ObservableList<U> target;
        private Function<T, U> mapper;
        private List<U> buffer;

        MappedObservableListUpdater(ObservableList<T> origin, ObservableList<U> target, Function<T, U> mapper) {
            this.origin = origin;
            this.target = target;
            this.mapper = mapper;
            this.buffer = new ArrayList<U>(target);
        }

        public void onChanged(ListChangeListener.Change<? extends T> change) {
            IdentityHashMap cache = new IdentityHashMap();
            while (change.next()) {
                int from = change.getFrom();
                int to = change.getTo();
                if (change.wasPermutated()) {
                    Object[] temp = new Object[to - from];
                    for (int i = 0; i < temp.length; ++i) {
                        temp[i] = this.buffer.get(from + i);
                    }
                    for (int idx = from; idx < to; ++idx) {
                        this.buffer.set(change.getPermutation(idx), temp[idx - from]);
                    }
                    continue;
                }
                if (change.wasRemoved()) {
                    List originRemoved = change.getRemoved();
                    List<U> targetRemoved = this.buffer.subList(from, from + originRemoved.size());
                    for (int i = 0; i < targetRemoved.size(); ++i) {
                        this.pushCache(cache, originRemoved.get(i), targetRemoved.get(i));
                    }
                    targetRemoved.clear();
                }
                if (!change.wasAdded()) continue;
                Object[] toAdd = new Object[to - from];
                for (int i = 0; i < toAdd.length; ++i) {
                    toAdd[i] = this.map(cache, this.origin.get(from + i));
                }
                this.buffer.addAll(from, Arrays.asList(toAdd));
            }
            this.target.setAll(this.buffer);
        }

        private void pushCache(Map<T, LinkedList<U>> cache, T key, U value) {
            cache.computeIfAbsent(key, any -> new LinkedList()).push(value);
        }

        private U map(Map<T, LinkedList<U>> cache, T key) {
            LinkedList<U> stack = cache.get(key);
            if (stack != null && !stack.isEmpty()) {
                return stack.pop();
            }
            return this.mapper.apply(key);
        }
    }
}

