/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class CommandBuilder {
    private static final Pattern UNSTABLE_OPTION_PATTERN = Pattern.compile("-XX:(?<key>[a-zA-Z0-9]+)=(?<value>.*)");
    private static final Pattern UNSTABLE_BOOLEAN_OPTION_PATTERN = Pattern.compile("-XX:(?<value>[+\\-])(?<key>[a-zA-Z0-9]+)");
    private final OperatingSystem os;
    private final List<Item> raw = new ArrayList<Item>();

    public CommandBuilder() {
        this(OperatingSystem.CURRENT_OS);
    }

    public CommandBuilder(OperatingSystem os) {
        this.os = os;
    }

    private String parse(String s) {
        if (OperatingSystem.WINDOWS == this.os) {
            return CommandBuilder.parseBatch(s);
        }
        return CommandBuilder.parseShell(s);
    }

    public CommandBuilder add(String ... args) {
        for (String s : args) {
            this.raw.add(new Item(s, true));
        }
        return this;
    }

    public CommandBuilder addAll(Collection<String> args) {
        for (String s : args) {
            this.raw.add(new Item(s, true));
        }
        return this;
    }

    public CommandBuilder addWithoutParsing(String ... args) {
        for (String s : args) {
            this.raw.add(new Item(s, false));
        }
        return this;
    }

    public CommandBuilder addAllWithoutParsing(Collection<String> args) {
        for (String s : args) {
            this.raw.add(new Item(s, false));
        }
        return this;
    }

    public String addDefault(String opt) {
        for (Item item : this.raw) {
            if (!item.arg.equals(opt)) continue;
            return item.arg;
        }
        this.raw.add(new Item(opt, true));
        return null;
    }

    public String addDefault(String opt, String value) {
        for (Item item : this.raw) {
            if (!item.arg.startsWith(opt)) continue;
            Logging.LOG.info("Default option '" + opt + value + "' is suppressed by '" + item.arg + "'");
            return item.arg;
        }
        this.raw.add(new Item(opt + value, true));
        return null;
    }

    public String addUnstableDefault(String opt, boolean value) {
        for (Item item : this.raw) {
            Matcher matcher = UNSTABLE_BOOLEAN_OPTION_PATTERN.matcher(item.arg);
            if (!matcher.matches() || !matcher.group("key").equals(opt)) continue;
            return item.arg;
        }
        if (value) {
            this.raw.add(new Item("-XX:+" + opt, true));
        } else {
            this.raw.add(new Item("-XX:-" + opt, true));
        }
        return null;
    }

    public String addUnstableDefault(String opt, String value) {
        for (Item item : this.raw) {
            Matcher matcher = UNSTABLE_OPTION_PATTERN.matcher(item.arg);
            if (!matcher.matches() || !matcher.group("key").equals(opt)) continue;
            return item.arg;
        }
        this.raw.add(new Item("-XX:" + opt + "=" + value, true));
        return null;
    }

    public boolean removeIf(Predicate<String> pred) {
        return this.raw.removeIf((? super E i) -> pred.test(i.arg));
    }

    public String toString() {
        return this.raw.stream().map(i -> i.parse ? this.parse(i.arg) : i.arg).collect(Collectors.joining(" "));
    }

    public List<String> asList() {
        return this.raw.stream().map(i -> i.arg).collect(Collectors.toList());
    }

    public List<String> asMutableList() {
        return this.raw.stream().map(i -> i.arg).collect(Collectors.toCollection(ArrayList::new));
    }

    public static String pwshString(String str) {
        return "'" + str.replace("'", "''") + "'";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasExecutionPolicy() {
        if (OperatingSystem.CURRENT_OS != OperatingSystem.WINDOWS) {
            return true;
        }
        try {
            Process process = Runtime.getRuntime().exec("powershell -Command Get-ExecutionPolicy");
            if (!process.waitFor(5L, TimeUnit.SECONDS)) {
                process.destroy();
                return false;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), OperatingSystem.NATIVE_CHARSET));){
                String policy = reader.readLine();
                boolean bl = "Unrestricted".equalsIgnoreCase(policy) || "RemoteSigned".equalsIgnoreCase(policy);
                return bl;
            }
        }
        catch (Throwable throwable6) {
            return false;
        }
    }

    public static boolean setExecutionPolicy() {
        if (OperatingSystem.CURRENT_OS != OperatingSystem.WINDOWS) {
            return true;
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"powershell", "-Command", "Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope CurrentUser"});
            if (!process.waitFor(5L, TimeUnit.SECONDS)) {
                process.destroy();
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private static String parseBatch(String s) {
        String escape = " \t\"^&<>|";
        if (StringUtils.containsOne(s, escape.toCharArray())) {
            return '\"' + s.replace("\\", "\\\\").replace("\"", "\\\"") + '\"';
        }
        return s;
    }

    private static String parseShell(String s) {
        String escaping = " \t\"!#$&'()*,;<=>?[\\]^`{|}~";
        String escaped = "\"$&`";
        if (s.indexOf(32) >= 0 || s.indexOf(9) >= 0 || StringUtils.containsOne(s, escaping.toCharArray())) {
            for (char ch : escaped.toCharArray()) {
                s = s.replace("" + ch, "\\" + ch);
            }
            return '\"' + s + '\"';
        }
        return s;
    }

    private static class Item {
        String arg;
        boolean parse;

        Item(String arg, boolean parse) {
            this.arg = arg;
            this.parse = parse;
        }

        public String toString() {
            return this.parse ? (OperatingSystem.WINDOWS == OperatingSystem.CURRENT_OS ? CommandBuilder.parseBatch(this.arg) : CommandBuilder.parseShell(this.arg)) : this.arg;
        }
    }
}

