/*

	TVP2 ( T Visual Presenter 2 )  A script authoring tool
	Copyright (C) 2000-2009 W.Dee <dee@kikyou.info> and contributors

	See details of license at "license.txt"
*/
/* This file is always generated by makestub.pl . */
/* Modification by hand will be lost. */
#ifndef __TP_STUB_H__
#define __TP_STUB_H__

#include <Windows.h>
#include <Objidl.h>

#ifndef __cplusplus
	#error Sorry, currently tp_stub.h can only be used in C++ mode.
#endif

#ifndef _WIN32
	#error Sorry, currently tp_stub.h can only be used in Win32 VC++ or Borland compilers.
#endif


typedef __int8 tjs_int8;
typedef unsigned __int8 tjs_uint8;
typedef __int16 tjs_int16;
typedef unsigned __int16 tjs_uint16;
typedef __int32 tjs_int32;
typedef unsigned __int32 tjs_uint32;
typedef __int64 tjs_int64;
typedef unsigned __int64 tjs_uint64;
typedef int tjs_int;    /* at least 32bits */
typedef unsigned int tjs_uint;    /* at least 32bits */

#ifdef __cplusplus
typedef wchar_t tjs_char;
#else
typedef unsigned short tjs_char;
#endif

typedef char tjs_nchar;
typedef double tjs_real;

#define TJS_HOST_IS_BIG_ENDIAN 0
#define TJS_HOST_IS_LITTLE_ENDIAN 1

#ifndef TJS_INTF_METHOD
#define TJS_INTF_METHOD __cdecl
	/* TJS_INTF_METHOD is "cdecl" (by default)
		since TJS2 2.4.14 (kirikir2 2.25 beta 1) */
#endif

#define TJS_USERENTRY __cdecl

#define TJS_I64_VAL(x) ((tjs_int64)(x##i64))
#define TJS_UI64_VAL(x) ((tjs_uint64)(x##i64))



#define TJS_W(X) L##X
#define TJS_N(X) X


typedef tjs_int32 tjs_error;

typedef tjs_int64 tTVInteger;
typedef tjs_real tTVReal;


/* IEEE double manipulation support
 (TJS requires IEEE double(64-bit float) native support on machine or C++ compiler) */

/*

63 62       52 51                         0
+-+-----------+---------------------------+
|s|    exp    |         significand       |
+-+-----------+---------------------------+

s = sign,  negative if this is 1, otherwise positive.



*/

/* double related constants */
#define TJS_IEEE_D_EXP_MAX 1023
#define TJS_IEEE_D_EXP_MIN -1022
#define TJS_IEEE_D_SIGNIFICAND_BITS 52

#define TJS_IEEE_D_EXP_BIAS 1023

/* component extraction */
#define TJS_IEEE_D_SIGN_MASK              (TJS_UI64_VAL(0x8000000000000000))
#define TJS_IEEE_D_EXP_MASK               (TJS_UI64_VAL(0x7ff0000000000000))
#define TJS_IEEE_D_SIGNIFICAND_MASK       (TJS_UI64_VAL(0x000fffffffffffff))
#define TJS_IEEE_D_SIGNIFICAND_MSB_MASK   (TJS_UI64_VAL(0x0008000000000000))

#define TJS_IEEE_D_GET_SIGN(x)   ((bool)(x & TJS_IEEE_D_SIGN_MASK))
#define TJS_IEEE_D_GET_EXP(x)  ((tjs_int)(((x & TJS_IEEE_D_EXP_MASK) >> \
								TJS_IEEE_D_SIGNIFICAND_BITS) - TJS_IEEE_D_EXP_BIAS))
#define TJS_IEEE_D_GET_SIGNIFICAND(x) (x & TJS_IEEE_D_SIGNIFICAND_MASK)

/* component composition */
#define TJS_IEEE_D_MAKE_SIGN(x)  ((x)?TJS_UI64_VAL(0x8000000000000000):TJS_UI64_VAL(0))
#define TJS_IEEE_D_MAKE_EXP(x)   ((tjs_uint64)(x + TJS_IEEE_D_EXP_BIAS) << 52)
#define TJS_IEEE_D_MAKE_SIGNIFICAND(x) ((tjs_uint64)(x))

/* special expression */
 /* (quiet) NaN */
  #define TJS_IEEE_D_P_NaN (tjs_uint64)(TJS_IEEE_D_EXP_MASK|TJS_IEEE_D_SIGNIFICAND_MSB_MASK)
  #define TJS_IEEE_D_N_NaN (tjs_uint64)(TJS_IEEE_D_SIGN_MASK|TJS_IEEE_D_P_NaN)
 /* infinite */
  #define TJS_IEEE_D_P_INF (tjs_uint64)(TJS_IEEE_D_EXP_MASK)
  #define TJS_IEEE_D_N_INF (tjs_uint64)(TJS_IEEE_D_SIGN_MASK|TJS_IEEE_D_P_INF)

/* special expression check */
  #define TJS_IEEE_D_IS_NaN(x) ((TJS_IEEE_D_EXP_MASK & (x)) == TJS_IEEE_D_EXP_MASK) && \
				(((x) & TJS_IEEE_D_SIGNIFICAND_MSB_MASK) || \
				(!((x) & TJS_IEEE_D_SIGNIFICAND_MSB_MASK) && \
				((x) & (TJS_IEEE_D_SIGNIFICAND_MASK ^ TJS_IEEE_D_SIGNIFICAND_MSB_MASK))))
  #define TJS_IEEE_D_IS_INF(x) (((TJS_IEEE_D_EXP_MASK & (x)) == TJS_IEEE_D_EXP_MASK) && \
				(!((x) & TJS_IEEE_D_SIGNIFICAND_MASK)))



//---------------------------------------------------------------------------
// tTJSVariantString stuff
//---------------------------------------------------------------------------
#define TJS_VS_SHORT_LEN 21


//---------------------------------------------------------------------------
// tTJSVariantString
//---------------------------------------------------------------------------
#pragma pack(push, 4)
struct tTJSVariantString_S
{
	tjs_int RefCount; // reference count - 1
	tjs_char *LongString;
	tjs_char ShortString[TJS_VS_SHORT_LEN +1];
	tjs_int Length; // string length
	tjs_uint32 HeapFlag;
	tjs_uint32 Hint;

};
#pragma pack(pop)


//---------------------------------------------------------------------------
// tTJSRefHolder : a object holder for classes that has AddRef and Release methods
//---------------------------------------------------------------------------
template <typename T>
class tTJSRefHolder
{
private:
	T *Object;
public:
	tTJSRefHolder(T * ref) { Object = ref; Object->AddRef(); }
	tTJSRefHolder(const tTJSRefHolder<T> &ref)
	{
		Object = ref.Object;
		Object->AddRef();
	}
	~tTJSRefHolder() { Object->Release(); }

	T* GetObject() { Object->AddRef(); return Object; }
	T* GetObjectNoAddRef() { return Object; }

	const tTJSRefHolder & operator = (const tTJSRefHolder & rhs)
	{
		if(rhs.Object != Object)
		{
			Object->Release();
			Object = rhs.Object;
			Object->AddRef();
		}
		return *this;
	}
};





//---------------------------------------------------------------------------
// floating-point class checker
//---------------------------------------------------------------------------
// constants used in TJSGetFPClass
#define TJS_FC_CLASS_MASK 7
#define TJS_FC_SIGN_MASK 8

#define TJS_FC_CLASS_NORMAL 0
#define TJS_FC_CLASS_NAN 1
#define TJS_FC_CLASS_INF 2

#define TJS_FC_IS_NORMAL(x)  (((x)&TJS_FC_CLASS_MASK) == TJS_FC_CLASS_NORMAL)
#define TJS_FC_IS_NAN(x)  (((x)&TJS_FC_CLASS_MASK) == TJS_FC_CLASS_NAN)
#define TJS_FC_IS_INF(x)  (((x)&TJS_FC_CLASS_MASK) == TJS_FC_CLASS_INF)

#define TJS_FC_IS_NEGATIVE(x) ((bool)((x) & TJS_FC_SIGN_MASK))
#define TJS_FC_IS_POSITIVE(x) (!TJS_FC_IS_NEGATIVE(x))




//---------------------------------------------------------------------------
// tTJSStringBufferLength
//---------------------------------------------------------------------------
#pragma pack(push, 4)
class tTJSStringBufferLength
{
public:
	tjs_int n;
	tTJSStringBufferLength(tjs_int n) {this->n = n;}
};
#pragma pack(pop)


//---------------------------------------------------------------------------
// tTJSString
//---------------------------------------------------------------------------
#pragma pack(push, 4)
class tTJSVariantString;
struct tTJSString_S
{
	tTJSVariantString *Ptr;
};
#pragma pack(pop)
class tTJSString;


typedef tTJSString ttstr;


//---------------------------------------------------------------------------
// call flag type
//---------------------------------------------------------------------------
#define TJS_MEMBERENSURE		0x00000200 // create a member if not exists
#define TJS_MEMBERMUSTEXIST     0x00000400 // member *must* exist ( for Dictionary/Array )
#define TJS_IGNOREPROP			0x00000800 // ignore property invoking
#define TJS_HIDDENMEMBER		0x00001000 // member is hidden
#define TJS_STATICMEMBER		0x00010000 // member is not registered to the
										   // object (internal use)

#define TJS_ENUM_NO_VALUE		0x00100000 // values are not retrieved
										   // (for EnumMembers)

#define TJS_NIS_REGISTER		0x00000001 // set native pointer
#define TJS_NIS_GETINSTANCE		0x00000002 // get native pointer

#define TJS_CII_ADD				0x00000001 // register name
										   // 'num' argument passed to CII is to be igonored.
#define TJS_CII_GET				0x00000000 // retrieve name

#define TJS_CII_SET_FINALIZE	0x00000002 // register "finalize" method name
										   // (set empty string not to call the method)
										   // 'num' argument passed to CII is to be igonored.
#define TJS_CII_SET_MISSING		0x00000003 // register "missing" method name.
										   // the method is called when the member is not present.
										   // (set empty string not to call the method)
										   // 'num' argument passed to CII is to be igonored.
										   // the method is to be called with three arguments;
										   // get_or_set    : false for get, true for set
										   // name          : member name
										   // value         : value property; you must
										   //               : dereference using unary '*' operator.
										   // the method must return true for found, false for not-found.

#define TJS_OL_LOCK				0x00000001 // Lock the object
#define TJS_OL_UNLOCK			0x00000002 // Unlock the object



//---------------------------------------------------------------------------
// 	Operation  flag
//---------------------------------------------------------------------------

#define TJS_OP_BAND				0x0001
#define TJS_OP_BOR				0x0002
#define TJS_OP_BXOR				0x0003
#define TJS_OP_SUB				0x0004
#define TJS_OP_ADD				0x0005
#define TJS_OP_MOD				0x0006
#define TJS_OP_DIV				0x0007
#define TJS_OP_IDIV				0x0008
#define TJS_OP_MUL				0x0009
#define TJS_OP_LOR				0x000a
#define TJS_OP_LAND				0x000b
#define TJS_OP_SAR				0x000c
#define TJS_OP_SAL				0x000d
#define TJS_OP_SR				0x000e
#define TJS_OP_INC				0x000f
#define TJS_OP_DEC				0x0010

#define TJS_OP_MASK				0x001f

#define TJS_OP_MIN				TJS_OP_BAND
#define TJS_OP_MAX				TJS_OP_DEC

/* SAR = Shift Arithmetic Right, SR = Shift (bitwise) Right */



//---------------------------------------------------------------------------
// iTJSDispatch
//---------------------------------------------------------------------------
/*
	iTJSDispatch interface
*/
class tTJSVariant;
class tTJSVariantClosure;
class tTJSVariantString;
class iTJSNativeInstance;
class iTJSDispatch2
{
/*
	methods, that have "ByNum" at the end of the name, have
	"num" parameter that enables the function to call a member with number directly.
	following two have the same effect:
	FuncCall(NULL, L"123", NULL, 0, NULL, NULL);
	FuncCallByNum(NULL, 123, NULL, 0, NULL, NULL);
*/

public:
	virtual tjs_uint TJS_INTF_METHOD AddRef(void) = 0;
	virtual tjs_uint TJS_INTF_METHOD Release(void) = 0;

public:

	virtual tjs_error TJS_INTF_METHOD
	FuncCall( // function invocation
		tjs_uint32 flag,			// calling flag
		const tjs_char * membername,// member name ( NULL for a default member )
		tjs_uint32 *hint,			// hint for the member name (in/out)
		tTJSVariant *result,		// result
		tjs_int numparams,			// number of parameters
		tTJSVariant **param,		// parameters
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	FuncCallByNum( // function invocation by index number
		tjs_uint32 flag,			// calling flag
		tjs_int num,				// index number
		tTJSVariant *result,		// result
		tjs_int numparams,			// number of parameters
		tTJSVariant **param,		// parameters
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	PropGet( // property get
		tjs_uint32 flag,			// calling flag
		const tjs_char * membername,// member name ( NULL for a default member )
		tjs_uint32 *hint,			// hint for the member name (in/out)
		tTJSVariant *result,		// result
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	PropGetByNum( // property get by index number
		tjs_uint32 flag,			// calling flag
		tjs_int num,				// index number
		tTJSVariant *result,		// result
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	PropSet( // property set
		tjs_uint32 flag,			// calling flag
		const tjs_char *membername,	// member name ( NULL for a default member )
		tjs_uint32 *hint,			// hint for the member name (in/out)
		const tTJSVariant *param,	// parameters
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	PropSetByNum( // property set by index number
		tjs_uint32 flag,			// calling flag
		tjs_int num,				// index number
		const tTJSVariant *param,	// parameters
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	GetCount( // get member count
		tjs_int *result,         	// variable that receives the result
		const tjs_char *membername,	// member name ( NULL for a default member )
		tjs_uint32 *hint,			// hint for the member name (in/out)
		iTJSDispatch2 *objthis      // object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	GetCountByNum( // get member count by index number
		tjs_int *result,			// variable that receives the result
		tjs_int num,				// by index number
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	PropSetByVS( // property set by tTJSVariantString, for internal use
		tjs_uint32 flag,			// calling flag
		tTJSVariantString *membername, // member name ( NULL for a default member )
		const tTJSVariant *param,	// parameters
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	EnumMembers( // enumerate members
		tjs_uint32 flag,			// enumeration flag
		tTJSVariantClosure *callback,	// callback function interface ( called on each member )
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	DeleteMember( // delete member
		tjs_uint32 flag,			// calling flag
		const tjs_char *membername,	// member name ( NULL for a default member )
		tjs_uint32 *hint,			// hint for the member name (in/out)
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	DeleteMemberByNum( // delete member by index number
		tjs_uint32 flag,			// calling flag
		tjs_int num,				// index number
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	Invalidate( // invalidation
		tjs_uint32 flag,			// calling flag
		const tjs_char *membername,	// member name ( NULL for a default member )
		tjs_uint32 *hint,			// hint for the member name (in/out)
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	InvalidateByNum( // invalidation by index number
		tjs_uint32 flag,			// calling flag
		tjs_int num,				// index number
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	IsValid( // get validation, returns TJS_S_TRUE (valid) or TJS_S_FALSE (invalid)
		tjs_uint32 flag,			// calling flag
		const tjs_char *membername,	// member name ( NULL for a default member )
		tjs_uint32 *hint,			// hint for the member name (in/out)
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	IsValidByNum( // get validation by index number, returns TJS_S_TRUE (valid) or TJS_S_FALSE (invalid)
		tjs_uint32 flag,			// calling flag
		tjs_int num,				// index number
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	CreateNew( // create new object
		tjs_uint32 flag,			// calling flag
		const tjs_char * membername,// member name ( NULL for a default member )
		tjs_uint32 *hint,			// hint for the member name (in/out)
		iTJSDispatch2 **result,		// result
		tjs_int numparams,			// number of parameters
		tTJSVariant **param,		// parameters
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	CreateNewByNum( // create new object by index number
		tjs_uint32 flag,			// calling flag
		tjs_int num,				// index number
		iTJSDispatch2 **result,		// result
		tjs_int numparams,			// number of parameters
		tTJSVariant **param,		// parameters
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	Reserved1(
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	IsInstanceOf( // class instance matching returns TJS_S_FALSE or TJS_S_TRUE
		tjs_uint32 flag,			// calling flag
		const tjs_char *membername,	// member name ( NULL for a default member )
		tjs_uint32 *hint,			// hint for the member name (in/out)
		const tjs_char *classname,	// class name to inquire
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	IsInstanceOfByNum( // class instance matching by index number
		tjs_uint32 flag,			// calling flag
		tjs_int num,					// index number
		const tjs_char *classname,	// class name to inquire
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	Operation( // operation with member
		tjs_uint32 flag,			// calling flag
		const tjs_char *membername,	// member name ( NULL for a default member )
		tjs_uint32 *hint,			// hint for the member name (in/out)
		tTJSVariant *result,		// result ( can be NULL )
		const tTJSVariant *param,	// parameters
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	OperationByNum( // operation with member by index number
		tjs_uint32 flag,			// calling flag
		tjs_int num,				// index number
		tTJSVariant *result,		// result ( can be NULL )
		const tTJSVariant *param,	// parameters
		iTJSDispatch2 *objthis		// object as "this"
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	NativeInstanceSupport( // support for native instance
		tjs_uint32 flag,			// calling flag
		tjs_int32 classid,			// native class ID
		iTJSNativeInstance **pointer// object pointer
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	ClassInstanceInfo( // support for class instance information
		tjs_uint32 flag,			// calling flag
		tjs_uint num,				// index number
		tTJSVariant *value			// the name
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	Reserved2(
		) = 0;

	virtual tjs_error TJS_INTF_METHOD
	Reserved3(
		) = 0;


};
//---------------------------------------------------------------------------
class iTJSNativeInstance
{
public:
	virtual tjs_error TJS_INTF_METHOD Construct(tjs_int numparams,
		tTJSVariant **param, iTJSDispatch2 *tjs_obj) = 0;
		// TJS constructor
	virtual void TJS_INTF_METHOD Invalidate() = 0;
		// called before destruction
	virtual void TJS_INTF_METHOD Destruct() = 0;
		// must destruct itself
};


//---------------------------------------------------------------------------
// return values as tjs_error
//---------------------------------------------------------------------------
#define TJS_E_MEMBERNOTFOUND		(-1001)
#define TJS_E_NOTIMPL				(-1002)
#define TJS_E_INVALIDPARAM			(-1003)
#define TJS_E_BADPARAMCOUNT			(-1004)
#define TJS_E_INVALIDTYPE			(-1005)
#define TJS_E_INVALIDOBJECT			(-1006)
#define TJS_E_ACCESSDENYED			(-1007)
#define TJS_E_NATIVECLASSCRASH		(-1008)

#define TJS_S_TRUE					(1)
#define TJS_S_FALSE					(2)

#define TJS_S_OK                    (0)
#define TJS_E_FAIL					(-1)

#define TJS_S_MAX (2)
	// maximum possible number of success status.
	// numbers over this may be regarded as a failure in
	// strict-checking mode.

#ifdef TJS_STRICT_ERROR_CODE_CHECK
	static inline bool TJS_FAILED(tjs_error hr)
	{
		if(hr < 0) return true;
		if(hr > TJS_S_MAX) return true;
		return false;
	}
#else
	#define TJS_FAILED(x)				((x)<0)
#endif
#define TJS_SUCCEEDED(x)			(!TJS_FAILED(x))

static inline bool TJSIsObjectValid(tjs_error hr)
{
	// checks object validity by returning value of iTJSDispatch2::IsValid

	if(hr == TJS_S_TRUE) return true;  // mostly expected value for valid object
	if(hr == TJS_E_NOTIMPL) return true; // also valid for object which does not implement IsValid

	return false; // otherwise the object is not valid
}



//---------------------------------------------------------------------------
// tTJSNativeInstanceType
//---------------------------------------------------------------------------
enum tTJSNativeInstanceType
{
	nitClass,
	nitMethod,
	nitProperty
};
//---------------------------------------------------------------------------





//---------------------------------------------------------------------------
// tTJSNativeInstance
//---------------------------------------------------------------------------
class tTJSNativeInstance : public iTJSNativeInstance
{
public:
	virtual tjs_error TJS_INTF_METHOD Construct(tjs_int numparams,
		tTJSVariant **param, iTJSDispatch2 *tjs_obj) {return TJS_S_OK;}
	virtual void TJS_INTF_METHOD Invalidate() {;}
	virtual void TJS_INTF_METHOD Destruct() { delete this; }
	virtual ~tTJSNativeInstance() {;};
};
//---------------------------------------------------------------------------





//---------------------------------------------------------------------------
// tTJSNativeClassMethod
//---------------------------------------------------------------------------
typedef tjs_error (TJS_INTF_METHOD *tTJSNativeClassMethodCallback)
	(tTJSVariant *result,tjs_int numparams, tTJSVariant **param,
	iTJSDispatch2 *objthis);


class tTJSNativeClassMethod : public iTJSDispatch2 { };






//---------------------------------------------------------------------------
// tTJSNativeClassProperty
//---------------------------------------------------------------------------
typedef tjs_error (TJS_INTF_METHOD *tTJSNativeClassPropertyGetCallback)
	(tTJSVariant *result, iTJSDispatch2 *objthis);
typedef tjs_error (TJS_INTF_METHOD *tTJSNativeClassPropertySetCallback)
	(const tTJSVariant *param, iTJSDispatch2 *objthis);


class tTJSNativeClassProperty : public iTJSDispatch2 { };





//---------------------------------------------------------------------------
// tTJSNativeClassForPlugin : service class for plugins
//---------------------------------------------------------------------------
typedef iTJSNativeInstance * (TJS_INTF_METHOD *tTJSCreateNativeInstance)();


class tTJSNativeClass : public iTJSDispatch2 { };
class tTJSNativeClassForPlugin : public tTJSNativeClass { };





//---------------------------------------------------------------------------
// following macros are to be written in the constructor of child class
// to define native methods/properties.


#define TJS_NCM_REG_THIS classobj
#define TJS_NATIVE_SET_ClassID TJS_NATIVE_CLASSID_NAME = TJS_NCM_CLASSID;



#define TJS_GET_NATIVE_INSTANCE(varname, typename) \
		if(!objthis) return TJS_E_NATIVECLASSCRASH; \
		typename *varname; \
		{ \
			tjs_error hr; \
			hr = objthis->NativeInstanceSupport(TJS_NIS_GETINSTANCE, \
					TJS_NATIVE_CLASSID_NAME, (iTJSNativeInstance**)&varname); \
			if(TJS_FAILED(hr)) return TJS_E_NATIVECLASSCRASH; \
		}

#define TJS_GET_NATIVE_INSTANCE_OUTER(classname, varname, typename) \
		if(!objthis) return TJS_E_NATIVECLASSCRASH; \
		typename *varname; \
		{ \
			tjs_error hr; \
			hr = objthis->NativeInstanceSupport(TJS_NIS_GETINSTANCE, \
					classname::ClassID, (iTJSNativeInstance**)&varname); \
			if(TJS_FAILED(hr)) return TJS_E_NATIVECLASSCRASH; \
		}

#define TJS_BEGIN_NATIVE_MEMBERS(classname) \
	{ \
		static const tjs_char *__classname = TJS_W(#classname); \
		static tjs_int32 TJS_NCM_CLASSID = \
			TJSRegisterNativeClass(__classname); \
		TJSNativeClassSetClassID(TJS_NCM_REG_THIS, TJS_NCM_CLASSID); \
		TJS_NATIVE_SET_ClassID

#define TJS_BEGIN_NATIVE_METHOD_DECL(name) \
		struct NCM_##name { \
			static tjs_error TJS_INTF_METHOD \
			Process( tTJSVariant *result, \
				tjs_int numparams, tTJSVariant **param,	iTJSDispatch2 *objthis) {

#define TJS_END_NATIVE_METHOD_DECL_INT \
			} \
		};

#define TJS_END_NATIVE_METHOD_DECL(name) \
		TJS_END_NATIVE_METHOD_DECL_INT \
		TJSNativeClassRegisterNCM(TJS_NCM_REG_THIS, TJS_W(#name), \
		TJSCreateNativeClassMethod(NCM_##name::Process), __classname, nitMethod);

#define TJS_END_NATIVE_HIDDEN_METHOD_DECL(name) \
		TJS_END_NATIVE_METHOD_DECL_INT \
		TJSNativeClassRegisterNCM(TJS_NCM_REG_THIS, TJS_W(#name), \
		TJSCreateNativeClassMethod(NCM_##name::Process), __classname, nitMethod, \
		TJS_HIDDENMEMBER);

#define TJS_END_NATIVE_STATIC_METHOD_DECL(name) \
		TJS_END_NATIVE_METHOD_DECL_INT \
		TJSNativeClassRegisterNCM(TJS_NCM_REG_THIS, TJS_W(#name), \
		TJSCreateNativeClassMethod(NCM_##name::Process), __classname, nitMethod, \
		TJS_STATICMEMBER);

#define TJS_END_NATIVE_METHOD_DECL_OUTER(object, name) \
		TJS_END_NATIVE_METHOD_DECL_INT \
		TJSNativeClassRegisterNCM((object), TJS_W(#name), \
		TJSCreateNativeClassMethod(NCM_##name::Process), \
		(object)->GetClassName().c_str(), nitMethod);

#define TJS_END_NATIVE_STATIC_METHOD_DECL_OUTER(object, name) \
		TJS_END_NATIVE_METHOD_DECL_INT \
		TJSNativeClassRegisterNCM((object), TJS_W(#name), \
		TJSCreateNativeClassMethod(NCM_##name::Process), \
		(object)->GetClassName().c_str(), nitMethod, TJS_STATICMEMBER);


#define TJS_DECL_EMPTY_FINALIZE_METHOD \
	TJS_BEGIN_NATIVE_METHOD_DECL(finalize) \
	{ return TJS_S_OK; } \
	TJS_END_NATIVE_METHOD_DECL(finalize)

#define TJS_NATIVE_CONSTRUCTOR_CALL_NATIVE_CONSTRUCTOR(varname, typename) \
				typename *varname; \
				{ \
					tjs_error hr; \
					hr = objthis->NativeInstanceSupport(TJS_NIS_GETINSTANCE, \
						TJS_NATIVE_CLASSID_NAME, \
						(iTJSNativeInstance**)&varname); \
					if(TJS_FAILED(hr)) return TJS_E_NATIVECLASSCRASH; \
					if(!varname) return TJS_E_NATIVECLASSCRASH; \
					hr = varname->Construct(numparams, param, objthis); \
					if(TJS_FAILED(hr)) return hr; \
				}

#define TJS_BEGIN_NATIVE_CONSTRUCTOR_DECL_NO_INSTANCE(classname) \
		struct NCM_##classname { \
			static tjs_error TJS_INTF_METHOD \
			Process(tTJSVariant *result, \
			tjs_int numparams, tTJSVariant **param,	iTJSDispatch2 *objthis) {

#define TJS_BEGIN_NATIVE_CONSTRUCTOR_DECL(varname, typename, classname) \
		TJS_BEGIN_NATIVE_CONSTRUCTOR_DECL_NO_INSTANCE(classname) \
		TJS_NATIVE_CONSTRUCTOR_CALL_NATIVE_CONSTRUCTOR(varname, typename)

#define TJS_END_NATIVE_CONSTRUCTOR_DECL(name) \
		TJS_END_NATIVE_METHOD_DECL_INT \
		TJSNativeClassRegisterNCM(TJS_NCM_REG_THIS, TJS_W(#name), \
		TJSCreateNativeClassConstructor(NCM_##name::Process), __classname, \
		nitMethod);

#define TJS_END_NATIVE_STATIC_CONSTRUCTOR_DECL(name) \
		TJS_END_NATIVE_METHOD_DECL_INT \
		TJSNativeClassRegisterNCM(TJS_NCM_REG_THIS, TJS_W(#name), \
		TJSCreateNativeClassConstructor(NCM_##name::Process), __classname, \
		nitMethod, TJS_STATICMEMBER);

#define TJS_BEGIN_NATIVE_PROP_DECL(name) \
		struct NCM_##name

#define TJS_END_NATIVE_PROP_DECL(name) \
		;TJSNativeClassRegisterNCM(TJS_NCM_REG_THIS, TJS_W(#name), \
		TJSCreateNativeClassProperty(NCM_##name::Get, NCM_##name::Set), \
		__classname, nitProperty);

#define TJS_END_NATIVE_PROP_DECL_OUTER(object, name) \
		;TJSNativeClassRegisterNCM((object), TJS_W(#name), \
		TJSCreateNativeClassProperty(NCM_##name::Get, NCM_##name::Set), \
		(object)->GetClassName().c_str(), nitProperty);

#define TJS_END_NATIVE_STATIC_PROP_DECL(name) \
		;TJSNativeClassRegisterNCM(TJS_NCM_REG_THIS, TJS_W(#name), \
		TJSCreateNativeClassProperty(NCM_##name::Get, NCM_##name::Set), \
		__classname, nitProperty, TJS_STATICMEMBER);

#define TJS_END_NATIVE_STATIC_PROP_DECL_OUTER(object, name) \
		;TJSNativeClassRegisterNCM((object), TJS_W(#name), \
		TJSCreateNativeClassProperty(NCM_##name::Get, NCM_##name::Set), \
		(object)->GetClassName().c_str(), nitProperty, TJS_STATICMEMBER);


#define TJS_BEGIN_NATIVE_PROP_GETTER \
		static tjs_error TJS_INTF_METHOD Get(tTJSVariant *result, \
		iTJSDispatch2 *objthis) { \

#define TJS_END_NATIVE_PROP_GETTER \
		}

#define TJS_DENY_NATIVE_PROP_GETTER \
		static tjs_error TJS_INTF_METHOD Get(tTJSVariant *result, \
		iTJSDispatch2 *objthis) \
		{ return TJS_E_ACCESSDENYED; }

#define TJS_BEGIN_NATIVE_PROP_SETTER \
		static tjs_error TJS_INTF_METHOD Set(const tTJSVariant *param, \
		iTJSDispatch2 *objthis) { \

#define TJS_END_NATIVE_PROP_SETTER \
		}

#define TJS_DENY_NATIVE_PROP_SETTER \
		static tjs_error TJS_INTF_METHOD Set(const tTJSVariant *param, \
		iTJSDispatch2 *objthis) \
		{ return TJS_E_ACCESSDENYED; }

#define TJS_END_NATIVE_MEMBERS \
	}

#define TJS_PARAM_EXIST(num) (numparams>(num) ? param[num]->Type()!=tvtVoid : false)




//---------------------------------------------------------------------------
// tTJSVariantOctet
//---------------------------------------------------------------------------

#pragma pack(push, 4)
struct tTJSVariantOctet_S
{
	tjs_uint Length;
	tjs_int RefCount;
	tjs_uint8 *Data;
};
#pragma pack(pop)


//---------------------------------------------------------------------------
// tTJSVariant_S
//---------------------------------------------------------------------------
#ifdef __BORLANDC__
#pragma option push -b
#endif
enum tTJSVariantType
{
	tvtVoid,  // empty
	tvtObject,
	tvtString,
	tvtOctet,  // octet binary data
	tvtInteger,
	tvtReal
};
#ifdef __BORLANDC__
#pragma option pop
#endif


#pragma pack(push, 4)
class iTJSDispatch2;
struct tTJSVariantClosure_S
{
	iTJSDispatch2 *Object;
	iTJSDispatch2 *ObjThis;
};
class tTJSVariantClosure;

class tTJSVariantString;
class tTJSVariantOctet;
struct tTJSVariant_S
{
	//---- data members -----------------------------------------------------

	#define tTJSVariant_BITCOPY(a,b) \
	{\
		*(tTJSVariant_S*)&(a) = *(tTJSVariant_S*)&(b); \
	}

	union
	{
		tTJSVariantClosure_S Object;
		tTVInteger Integer;
		tTVReal Real;
		tTJSVariantString *String;
		tTJSVariantOctet *Octet;
	};
	tTJSVariantType vt;
};
#pragma pack(pop)


//---------------------------------------------------------------------------
// tTJSVariantClosure
//---------------------------------------------------------------------------


void TJSThrowNullAccess();



class tTJSVariantClosure : public tTJSVariantClosure_S
{
	// tTJSVariantClosure does not provide any function of object lifetime
	// namagement. ( AddRef and Release are provided but tTJSVariantClosure
	// has no responsibility for them )

public:
	tTJSVariantClosure() {;} // note that default constructor does nothing 

	tTJSVariantClosure(iTJSDispatch2 *obj, iTJSDispatch2 *objthis = NULL)
	{ Object = obj, ObjThis = objthis; }

	iTJSDispatch2 * SelectObjectNoAddRef()
		{ return ObjThis ? ObjThis : Object; }

public:

	bool operator == (const tTJSVariantClosure &rhs)
	{
		return Object == rhs.Object && ObjThis == rhs.ObjThis;
	}

	bool operator != (const tTJSVariantClosure &rhs)
	{
		return ! this->operator ==(rhs);
	}


	void AddRef()
	{
		if(Object) Object->AddRef();
		if(ObjThis) ObjThis->AddRef();
	}

	void Release()
	{
		if(Object) Object->Release();
		if(ObjThis) ObjThis->Release();
	}


	tjs_error
	FuncCall(tjs_uint32 flag, const tjs_char * membername, tjs_uint32 *hint,
		tTJSVariant *result,
		tjs_int numparams, tTJSVariant **param, iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->FuncCall(flag, membername, hint, result, numparams, param,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	FuncCallByNum(tjs_uint32 flag, tjs_int num, tTJSVariant *result,
		tjs_int numparams, tTJSVariant **param, iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->FuncCallByNum(flag, num, result, numparams, param,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	PropGet(tjs_uint32 flag, const tjs_char * membername, tjs_uint32 *hint,
		tTJSVariant *result,
		iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->PropGet(flag, membername, hint, result,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	PropGetByNum(tjs_uint32 flag, tjs_int num, tTJSVariant *result,
		iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->PropGetByNum(flag, num, result,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	PropSet(tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint,
		const tTJSVariant *param,
		iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->PropSet(flag, membername, hint, param,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	PropSetByNum(tjs_uint32 flag, tjs_int num, const tTJSVariant *param,
		iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->PropSetByNum(flag, num, param,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	GetCount(tjs_int *result, const tjs_char *membername, tjs_uint32 *hint,
		iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->GetCount(result, membername, hint,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	GetCountByNum(tjs_int *result, tjs_int num, iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->GetCountByNum(result, num,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	PropSetByVS(tjs_uint32 flag, tTJSVariantString *membername,
		const tTJSVariant *param, iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->PropSetByVS(flag, membername, param,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	EnumMembers(tjs_uint32 flag, tTJSVariantClosure *callback,
		iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->EnumMembers(flag, callback,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	DeleteMember(tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint,
		iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->DeleteMember(flag, membername, hint,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	DeleteMemberByNum(tjs_uint32 flag, tjs_int num, iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->DeleteMemberByNum(flag, num,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	Invalidate(tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint,
		iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->Invalidate(flag, membername, hint,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	InvalidateByNum(tjs_uint32 flag, tjs_int num, iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->InvalidateByNum(flag, num,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	IsValid(tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint,
		iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->IsValid(flag, membername, hint,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	IsValidByNum(tjs_uint32 flag, tjs_int num, iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->IsValidByNum(flag, num,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	CreateNew(tjs_uint32 flag, const tjs_char * membername, tjs_uint32 *hint,
		iTJSDispatch2 **result,
		tjs_int numparams, tTJSVariant **param,	iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->CreateNew(flag, membername, hint, result, numparams,
			param, ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	CreateNewByNum(tjs_uint32 flag, tjs_int num, iTJSDispatch2 **result,
		tjs_int numparams, tTJSVariant **param,	iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->CreateNewByNum(flag, num, result, numparams, param,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

/*
	tjs_error
	Reserved1() { }
*/

	tjs_error
	IsInstanceOf(tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint,
		const tjs_char *classname, iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->IsInstanceOf(flag, membername, hint, classname,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	IsInstanceOf(tjs_uint32 flag, tjs_int num, tjs_char *classname,
		iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->IsInstanceOfByNum(flag, num, classname,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	Operation(tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint,
		tTJSVariant *result, const tTJSVariant *param,	iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->Operation(flag, membername, hint, result, param,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

	tjs_error
	OperationByNum(tjs_uint32 flag, tjs_int num, tTJSVariant *result,
		const tTJSVariant *param,	iTJSDispatch2 *objthis) const
	{
		if(!Object) TJSThrowNullAccess();
		return Object->OperationByNum(flag, num, result, param,
			ObjThis?ObjThis:(objthis?objthis:Object));
	}

/*
	tjs_error
	Reserved2() { }
*/

/*
	tjs_error
	Reserved3() { }
*/

};






//---------------------------------------------------------------------------
// iTJSTextStream - used by Array.save/load Dictionaty.save/load
//---------------------------------------------------------------------------
class tTJSString;
class iTJSTextReadStream
{
public:
	virtual tjs_uint TJS_INTF_METHOD Read(tTJSString & targ, tjs_uint size) = 0;
	virtual void TJS_INTF_METHOD Destruct() = 0; // must delete itself
};
//---------------------------------------------------------------------------
class iTJSTextWriteStream
{
public:
	virtual void TJS_INTF_METHOD Write(const tTJSString & targ) = 0;
	virtual void TJS_INTF_METHOD Destruct() = 0; // must delete itself
};
//---------------------------------------------------------------------------
extern iTJSTextReadStream * (*TJSCreateTextStreamForRead)(const tTJSString &name,
	const tTJSString &modestr);
extern iTJSTextWriteStream * (*TJSCreateTextStreamForWrite)(const tTJSString &name,
	const tTJSString &modestr);
extern class tTJSBinaryStream * (*TJSCreateBinaryStreamForRead)(const tTJSString &name,
	const tTJSString &modestr);
extern class tTJSBinaryStream * (*TJSCreateBinaryStreamForWrite)(const tTJSString &name,
	const tTJSString &modestr);
//---------------------------------------------------------------------------






//---------------------------------------------------------------------------
// tTJSBinaryStream constants
//---------------------------------------------------------------------------
#define TJS_BS_READ 0
#define TJS_BS_WRITE 1
#define TJS_BS_APPEND 2
#define TJS_BS_UPDATE 3

#define TJS_BS_ACCESS_MASK 0x0f

#define TJS_BS_SEEK_SET 0
#define TJS_BS_SEEK_CUR 1
#define TJS_BS_SEEK_END 2
//---------------------------------------------------------------------------






//---------------------------------------------------------------------------
// tTJSDispatch
//---------------------------------------------------------------------------
/*
	tTJSDispatch is a base class that implements iTJSDispatch2, and every methods.
	most methods are maked as simply returning "TJS_E_NOTIMPL";
	methods, those access the object by index, call another methods that access
	the object by string.
*/
/*
#define TJS_SELECT_OBJTHIS(__closure__, __override__) \
	((__closure__).ObjThis?((__override__)?(__override__):(__closure__).ObjThis):(__override__))
*/
#define TJS_SELECT_OBJTHIS(__closure__, __override__) \
	((__closure__).ObjThis?(__closure__).ObjThis:(__override__))

class tTJSDispatch : public iTJSDispatch2
{
	virtual void BeforeDestruction(void) {;}
	bool BeforeDestructionCalled;
		// BeforeDestruction will be certainly called before object destruction
private:
	tjs_uint RefCount;
public:
	tTJSDispatch();
	virtual ~tTJSDispatch();

//	bool DestructionTrace;

public:
	tjs_uint TJS_INTF_METHOD  AddRef(void);
	tjs_uint TJS_INTF_METHOD  Release(void);

protected:
	tjs_uint GetRefCount() { return RefCount; }

public:
	tjs_error TJS_INTF_METHOD
	FuncCall(
		tjs_uint32 flag,
		const tjs_char * membername,
		tjs_uint32 *hint,
		tTJSVariant *result,
		tjs_int numparams,
		tTJSVariant **param,
		iTJSDispatch2 *objthis
		)
	{
		return membername?TJS_E_MEMBERNOTFOUND:TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	FuncCallByNum(
		tjs_uint32 flag,
		tjs_int num,
		tTJSVariant *result,
		tjs_int numparams,
		tTJSVariant **param,
		iTJSDispatch2 *objthis
		);

	tjs_error TJS_INTF_METHOD
	PropGet(
		tjs_uint32 flag,
		const tjs_char * membername,
		tjs_uint32 *hint,
		tTJSVariant *result,
		iTJSDispatch2 *objthis
		)
	{
		return membername?TJS_E_MEMBERNOTFOUND:TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	PropGetByNum(
		tjs_uint32 flag,
		tjs_int num,
		tTJSVariant *result,
		iTJSDispatch2 *objthis
		);

	tjs_error TJS_INTF_METHOD
	PropSet(
		tjs_uint32 flag,
		const tjs_char *membername,
		tjs_uint32 *hint,
		const tTJSVariant *param,
		iTJSDispatch2 *objthis
		)
	{
		return membername?TJS_E_MEMBERNOTFOUND:TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	PropSetByNum(
		tjs_uint32 flag,
		tjs_int num,
		const tTJSVariant *param,
		iTJSDispatch2 *objthis
		);
	
	tjs_error TJS_INTF_METHOD
	GetCount(
		tjs_int *result,
		const tjs_char *membername,
		tjs_uint32 *hint,
		iTJSDispatch2 *objthis
		)
	{
		return TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	GetCountByNum(
		tjs_int *result,
		tjs_int num,
		iTJSDispatch2 *objthis
		);


	tjs_error TJS_INTF_METHOD
	PropSetByVS(tjs_uint32 flag, tTJSVariantString *membername,
		const tTJSVariant *param, iTJSDispatch2 *objthis)
	{
		return TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	EnumMembers(tjs_uint32 flag, tTJSVariantClosure *callback, iTJSDispatch2 *objthis)
	{
		return TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	DeleteMember(
		tjs_uint32 flag,
		const tjs_char *membername,
		tjs_uint32 *hint,
		iTJSDispatch2 *objthis
		)
	{
		return membername?TJS_E_MEMBERNOTFOUND:TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	DeleteMemberByNum(
		tjs_uint32 flag,
		tjs_int num,
		iTJSDispatch2 *objthis
		);

	tjs_error TJS_INTF_METHOD
	Invalidate(
		tjs_uint32 flag,
		const tjs_char *membername,
		tjs_uint32 *hint,
		iTJSDispatch2 *objthis
		)
	{
		return membername?TJS_E_MEMBERNOTFOUND:TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	InvalidateByNum(
		tjs_uint32 flag,
		tjs_int num,
		iTJSDispatch2 *objthis
		);

	tjs_error TJS_INTF_METHOD
	IsValid(
		tjs_uint32 flag,
		const tjs_char *membername,
		tjs_uint32 *hint,
		iTJSDispatch2 *objthis
		)
	{
		return membername?TJS_E_MEMBERNOTFOUND:TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	IsValidByNum(
		tjs_uint32 flag,
		tjs_int num,
		iTJSDispatch2 *objthis
		);

	tjs_error TJS_INTF_METHOD
	CreateNew(
		tjs_uint32 flag,
		const tjs_char * membername,
		tjs_uint32 *hint,
		iTJSDispatch2 **result,
		tjs_int numparams,
		tTJSVariant **param,
		iTJSDispatch2 *objthis
		)
	{
		return membername?TJS_E_MEMBERNOTFOUND:TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	CreateNewByNum(
		tjs_uint32 flag,
		tjs_int num,
		iTJSDispatch2 **result,
		tjs_int numparams,
		tTJSVariant **param,
		iTJSDispatch2 *objthis
		);

	tjs_error TJS_INTF_METHOD
	Reserved1(
		)
	{
		return TJS_E_NOTIMPL;
	}


	tjs_error TJS_INTF_METHOD
	IsInstanceOf(
		tjs_uint32 flag,
		const tjs_char *membername,
		tjs_uint32 *hint,
		const tjs_char *classname,
		iTJSDispatch2 *objthis
		)
	{
		return membername?TJS_E_MEMBERNOTFOUND:TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	IsInstanceOfByNum(
		tjs_uint32 flag,
		tjs_int num,
		const tjs_char *classname,
		iTJSDispatch2 *objthis
		);

	tjs_error TJS_INTF_METHOD
	Operation(
		tjs_uint32 flag,
		const tjs_char *membername,
		tjs_uint32 *hint,
		tTJSVariant *result,
		const tTJSVariant *param,
		iTJSDispatch2 *objthis
		);

	tjs_error TJS_INTF_METHOD
	OperationByNum(
		tjs_uint32 flag,
		tjs_int num,
		tTJSVariant *result,
		const tTJSVariant *param,
		iTJSDispatch2 *objthis
		);


	tjs_error TJS_INTF_METHOD
	NativeInstanceSupport(
		tjs_uint32 flag,
		tjs_int32 classid,
		iTJSNativeInstance **pointer
		)
	{
		return TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	ClassInstanceInfo(
		tjs_uint32 flag,
		tjs_uint num,
		tTJSVariant *value
		)
	{
		return TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	Reserved2(
		)
	{
		return TJS_E_NOTIMPL;
	}

	tjs_error TJS_INTF_METHOD
	Reserved3(
		)
	{
		return TJS_E_NOTIMPL;
	}


};
//---------------------------------------------------------------------------


#ifdef __BORLANDC__
#pragma warn -8027
#endif

//---------------------------------------------------------------------------
// function import pointers
//---------------------------------------------------------------------------

extern void * TVPGetImportFuncPtr(const char *name);


extern void * TVPImportFuncPtr3d4b725f0b4234d79524822e7c34486b;
extern void * TVPImportFuncPtr3fc0c32ee41ea0c515f8fbb681e37982;
extern void * TVPImportFuncPtre8dbd4fe012262d9da831e0735aa33b3;
extern void * TVPImportFuncPtrace6cce1353865d7376caca1f2124216;
extern void * TVPImportFuncPtr5055344aa8055bc238b79e5f88fc3300;
extern void * TVPImportFuncPtr8238c542b814acf1a83c00cced57ba26;
extern void * TVPImportFuncPtrbd2a14ca8c345fd7f151b08d1792fb60;
extern void * TVPImportFuncPtr16d432f9f86738a7688cbfc9b12441ec;
extern void * TVPImportFuncPtr6dac00582b8ba529e548ef058c4e869e;
extern void * TVPImportFuncPtr9193ae470b5efdfe617b5e94cd8f5da6;
extern void * TVPImportFuncPtrec455b6ef0f5da178063db3875973260;
extern void * TVPImportFuncPtra56aaf685bd171b63b0ef3c894d80ecf;
extern void * TVPImportFuncPtr9a5fe199cebb9841f94ac0bb7a4a3b6a;
extern void * TVPImportFuncPtr2acb76a1f86e34afc5fe934d406c6c4c;
extern void * TVPImportFuncPtr3a4d914ca7d24989c236ad223c002d49;
extern void * TVPImportFuncPtr8fca7d3a123df1eacf228ba89f6a02ff;
extern void * TVPImportFuncPtr58be195f96a36c158d638e3b0c79308b;
extern void * TVPImportFuncPtreaa4d5b1d186a807a63311ab6d5e16e4;
extern void * TVPImportFuncPtr246f30d208c1d3a4e2b558090f403734;
extern void * TVPImportFuncPtr3206ef9b7a8013d6572decdea49e7e2e;
extern void * TVPImportFuncPtrc5a30d297c3a121879b1392bc6c604ef;
extern void * TVPImportFuncPtre398f5aef0ab92bc1323f3b094722fb1;
extern void * TVPImportFuncPtr0733b0ac80880897d327dc6f3b04ea9e;
extern void * TVPImportFuncPtr4cb055ed9d8ef71d1af10898965c940c;
extern void * TVPImportFuncPtref8d198596b7d3143d02ed4450ccefa1;
extern void * TVPImportFuncPtrd48ea419e040ffe8c20c1e86d80c9a5f;
extern void * TVPImportFuncPtr679b215ff76a269871d5f325b981e561;
extern void * TVPImportFuncPtr1039eff4a4443f9238438485a35a93a7;
extern void * TVPImportFuncPtr2f873b0ee1c6591ba28bc4b9c0e4c954;
extern void * TVPImportFuncPtra583ffb56cdb2ede691e15053a8a165a;
extern void * TVPImportFuncPtre09ed277802c1b117e1908421448886d;
extern void * TVPImportFuncPtre76dfb9e00f4a9d491117d815f30db7f;
extern void * TVPImportFuncPtrb000dd8934508d8ec6d6ef976a6ff49b;
extern void * TVPImportFuncPtrd98ab5c968ebfde4e924901d09190774;
extern void * TVPImportFuncPtr661e8c10d5d477e6823a840244937cd8;
extern void * TVPImportFuncPtr6b39e70ea89c4f883689f51289029b69;
extern void * TVPImportFuncPtr4a18b1c0afe37b84e2b35a7fc07c4e0f;
extern void * TVPImportFuncPtr48b85c8774d91ca40b2992f0e452f19e;
extern void * TVPImportFuncPtr5ea8db9a9193fe6bab53baf2bee06b6b;
extern void * TVPImportFuncPtr46b92626ff6894e993c4f193a129540b;
extern void * TVPImportFuncPtr6efc1d1f66f0e01a81faf767d7576816;
extern void * TVPImportFuncPtr4ededf58eae77c320b4a6f5f701acafb;
extern void * TVPImportFuncPtr028d5fda2f4568f6ab14b49d89650a4d;
extern void * TVPImportFuncPtr11912984b8c094d2df26bf3c3677d096;
extern void * TVPImportFuncPtr6c0df790c33142e286aea9af6993d931;
extern void * TVPImportFuncPtrc27d85b695cd6e144210785bdfd446ce;
extern void * TVPImportFuncPtr8422ef7f42009be0ad58a09d64149051;
extern void * TVPImportFuncPtree07e6522577952453206ede39cdf54c;
extern void * TVPImportFuncPtr786a65424247e711f6ca31f0a10603d7;
extern void * TVPImportFuncPtr995a222f2038dd2007f2c1f6429bd19e;
extern void * TVPImportFuncPtrda8c6e750d6a9c0557a56ef7f7fd8e88;
extern void * TVPImportFuncPtr9cf7b0f119bcf3fa4564837ae25429b3;
extern void * TVPImportFuncPtr17cbcacad2ed350215d7d700c676ea40;
extern void * TVPImportFuncPtr2bd375c0598e9148d88579a51b2f07a8;
extern void * TVPImportFuncPtr4d2c157f8b0b49e57c3e9b5abc9deb0f;
extern void * TVPImportFuncPtr4b7eaccf64af0f3a4c4fe64f4e2dd3fd;
extern void * TVPImportFuncPtr3a4d2602c392a8d1f4c38d537a8c95e0;
extern void * TVPImportFuncPtr8d915d35ef8e857f245c5d46798618e4;
extern void * TVPImportFuncPtr1e463482afa8ca30f5fa7bea4fa5741d;
extern void * TVPImportFuncPtrfdf270e4080c986abd1649fa9fffdeab;
extern void * TVPImportFuncPtr972e0f9a6ec4648a9fb82bcf5d9095ff;
extern void * TVPImportFuncPtr9d76731c37c4664d654db026644c64b4;
extern void * TVPImportFuncPtr4f1620cb699874b9c8cedf6e321c606e;
extern void * TVPImportFuncPtref1c6b2b601d1b0ff70272a4d447aa3c;
extern void * TVPImportFuncPtr9b7872860c95cfdafb056ab30318e99c;
extern void * TVPImportFuncPtr53360f194a04fc142ddae2b9a3ab4c92;
extern void * TVPImportFuncPtrce1dcb05e5e7c4cafbc4ed37f63b256e;
extern void * TVPImportFuncPtr841ce4492b37321eea0c1b500de9b352;
extern void * TVPImportFuncPtr61785de870894968cd9d95e17e88eafc;
extern void * TVPImportFuncPtrad3236e727398311c3b8e1ddd5f4b293;
extern void * TVPImportFuncPtr80e0b7be488545ff9b8bc52c9ab5fba5;
extern void * TVPImportFuncPtr4eaa3e4efb319707db6ef81db1c6f147;
extern void * TVPImportFuncPtr693a0152f098caee7fc77f545dd3e954;
extern void * TVPImportFuncPtr42840710f5fba9bb32b95290b1796a55;
extern void * TVPImportFuncPtradec3f9ef429aa9a284081f0fc6a1b5b;
extern void * TVPImportFuncPtr674a7948152a1d7a49050b9d98796403;
extern void * TVPImportFuncPtraa6f132b2031c83062f6149c90f2df5f;
extern void * TVPImportFuncPtrb52f446e22bb92d495f7e65ac71c9bf9;
extern void * TVPImportFuncPtrd4899fd4a8beb06f192dcb1d300e3319;
extern void * TVPImportFuncPtrd3f5ec78464d29ee6988a1f90c2e3e1b;
extern void * TVPImportFuncPtra463ad6a757c3f04e09a72e288737d06;
extern void * TVPImportFuncPtr27857bb89d35113183b682c3917d6c7a;
extern void * TVPImportFuncPtra5f80951cfb882ac6a3e06c0b9a95807;
extern void * TVPImportFuncPtr35aadb63079c8bd84ebc0389bae306e0;
extern void * TVPImportFuncPtrfb6573df5887c2020ae58136f8342ed4;
extern void * TVPImportFuncPtr86c67d2197c46824ab10f59e568ad13a;
extern void * TVPImportFuncPtr263a0c5b335b2c4d5bc1f55b51b8315e;
extern void * TVPImportFuncPtr975c1099e57ab67122ddef0f44fd7dd5;
extern void * TVPImportFuncPtr04493e5237a7ca97afd391cb7e831ba0;
extern void * TVPImportFuncPtr9996100acc7705cb2b0c904d6bad4401;
extern void * TVPImportFuncPtr5d91cff3b2a26ff7c0543e0f6d737117;
extern void * TVPImportFuncPtref1dedc2cb58dc4e1afc14238b6fc518;
extern void * TVPImportFuncPtrf18397fe81c043ba2346e31b359f6a73;
extern void * TVPImportFuncPtr2ee45ad60b0c06a8d0feebc3a6aad9e7;
extern void * TVPImportFuncPtr44500491c57e17032951fe6ed268ff1d;
extern void * TVPImportFuncPtr056f5d278c75750df792bf8b081fbf7d;
extern void * TVPImportFuncPtr04233bc4f7d4df92c260d23110320afe;
extern void * TVPImportFuncPtrcdc475c4419e77c22508e337428c4074;
extern void * TVPImportFuncPtr06bacb2910308a47bbe27ff7efa1226d;
extern void * TVPImportFuncPtr521e053199a4aeb4e0f24d9f4a6cc682;
extern void * TVPImportFuncPtr02164e6fb4c925843ac774ec1e4c6e5d;
extern void * TVPImportFuncPtr5110cbbcddbd9688281ee5418e3f9023;
extern void * TVPImportFuncPtr1db54b61f00bf931452218c4a39e79ef;
extern void * TVPImportFuncPtr9d0edd8f51f155767301017bd3d256da;
extern void * TVPImportFuncPtr8f744c5aa8df5471939b960bc759f12b;
extern void * TVPImportFuncPtrba7ff7b0b4192bd2cc7f49c7b688ad57;
extern void * TVPImportFuncPtr7773ac921bb82c85de3be69ef86265fd;
extern void * TVPImportFuncPtr114a781ed71edace31abb352a2671f41;
extern void * TVPImportFuncPtr2bc5f4a97decfa82c625430479ec512b;
extern void * TVPImportFuncPtr066fb79f94523d95d12480f23c58cc8e;
extern void * TVPImportFuncPtr803906b8de16ff825d4e69e1952d872f;
extern void * TVPImportFuncPtr34cc96a5118ee1e12b0750ea64d40b1f;
extern void * TVPImportFuncPtrdbe821fb8b651d42a9c8e730517c408c;
extern void * TVPImportFuncPtr8970ba46068ac74746c3e84299937d8f;
extern void * TVPImportFuncPtr438e27dcbb077284213eb4d7dcd43f8f;
extern void * TVPImportFuncPtra98d712ca19a49afe07d0a7c5d064cef;
extern void * TVPImportFuncPtr08aef69683bcfe2a5c63d4c7866de8e9;
extern void * TVPImportFuncPtrdbc9bc2e27068c8426b1c6a7f89424e0;
extern void * TVPImportFuncPtr5eeb98ca016123f57966457533bb639e;
extern void * TVPImportFuncPtr98fdc846d0b4a83412f3521f65bb98b4;
extern void * TVPImportFuncPtr3309591d3c7f6f688e81588f169dba21;
extern void * TVPImportFuncPtrd83a866389246d824efcc83303a04484;
extern void * TVPImportFuncPtr6cf6f332a6a14a15e8dce62301f5c840;
extern void * TVPImportFuncPtr566eeea3c5f009b0fc6fa123ba30f496;
extern void * TVPImportFuncPtr88806e38e35c73b36acadd4061a4fe0b;
extern void * TVPImportFuncPtr3bb69d3886159aaecc333b6ff17287bf;
extern void * TVPImportFuncPtr3e36278551a9c8b29cb2e8017db6af0d;
extern void * TVPImportFuncPtr5de99d84f3dc902cb0812fb85a7d5c88;
extern void * TVPImportFuncPtr31e85cbc73f8fbd4cea895a751480059;
extern void * TVPImportFuncPtr6ae29e405ede762f1a89a9dd526cb36e;
extern void * TVPImportFuncPtrc95bd66d95c153cdac41b5243e555f5f;
extern void * TVPImportFuncPtr72a67e9c52fd27dbb66eded47efeea74;
extern void * TVPImportFuncPtrfb13e41bda53e4e59403e3e14effccd6;
extern void * TVPImportFuncPtr9a5c710e620e47f105752453ad5d6ab1;
extern void * TVPImportFuncPtr18f1ad16c11429707cbf8ea4d1d4a21e;
extern void * TVPImportFuncPtr550f317b573a1256af00586890ae82f1;
extern void * TVPImportFuncPtrcd50da721dfb63f36c1ebb1226830428;
extern void * TVPImportFuncPtrfbba3dd6a087599d1277ae58f6cec18e;
extern void * TVPImportFuncPtr43cc5b5a61a6090af83333d115b5b868;
extern void * TVPImportFuncPtr616fb5060d81eb5bab58647596582df4;
extern void * TVPImportFuncPtr168cf4c1b9ef70b98f2e0ab3695a4f3b;
extern void * TVPImportFuncPtr314573cca30a7c2aecc9166fbf5400c9;
extern void * TVPImportFuncPtr03da356426c038fad663c836c3e330ef;
extern void * TVPImportFuncPtr31dbebdedc08d75e34a2cd564ce60586;
extern void * TVPImportFuncPtrd9224ad7a0de743a7eea15fdb2c5f934;
extern void * TVPImportFuncPtrc01b0720b49ce4f792446d8965d2c31f;
extern void * TVPImportFuncPtr4af47e46a11e1357cb994f405289d13e;
extern void * TVPImportFuncPtr25b6dafa19bfa5bde1a8b519da248f82;
extern void * TVPImportFuncPtr72425405819c900aec719491cbd90c6d;
extern void * TVPImportFuncPtra79942af73f33bff6e432c9fd808e469;
extern void * TVPImportFuncPtrdf106470a4141ebc7eda22160859ffdc;
extern void * TVPImportFuncPtr469bc225b0ecd9561aae5a46b85ded42;
extern void * TVPImportFuncPtra6663c078b3aa79b39ee2d09f3875765;
extern void * TVPImportFuncPtrefbe634ce4f13633e220cae167cf63fb;
extern void * TVPImportFuncPtr57f4147bcc09e4e4442ffc9b0895727e;
extern void * TVPImportFuncPtr1fb2d2e44cf83aebef7b26fd6b20bc2b;
extern void * TVPImportFuncPtrbd6aa777bac947f5cffd891e9c724794;
extern void * TVPImportFuncPtr83c662330b75d616cdc8a4e11d7ababa;
extern void * TVPImportFuncPtrbbde02fe30c8a6cadb7073174ea3a874;
extern void * TVPImportFuncPtrcc1c14f63867f90bc883de03e9212cbc;
extern void * TVPImportFuncPtr236e007b32bc2631b5f6dc1eda6be0a9;
extern void * TVPImportFuncPtrcfbb9809e0e6d954b2652856e935ced9;
extern void * TVPImportFuncPtr60ee96ae4a7704340bef20fb35ba6ade;
extern void * TVPImportFuncPtr564b37278b50f4e5597dff6540868d49;
extern void * TVPImportFuncPtr890b3a4831b824653e919b4a5197358d;
extern void * TVPImportFuncPtr2dfa6c77c5051d160b8a06f540e0d68b;
extern void * TVPImportFuncPtr05f88567d510fd84659ccbf493f647ed;
extern void * TVPImportFuncPtr7166b8f7bb9688c980e4fa172f06f30c;
extern void * TVPImportFuncPtrb9456ecba8b7898d80d2e5caa64035c9;
extern void * TVPImportFuncPtrdd44464bd8430a5be5fef0cffcd97117;
extern void * TVPImportFuncPtra57696ca0c157cd7d3cd4e58c1df957c;
extern void * TVPImportFuncPtr1aea9f8a38bbb875b6d052f330da9178;
extern void * TVPImportFuncPtr2d3b3d6e22ee139cda9eee47dc031945;
extern void * TVPImportFuncPtr8ff49e56c3c4c566561dcdd5c9ecc4db;
extern void * TVPImportFuncPtr490b547e93e40082d0b83312467104f9;
extern void * TVPImportFuncPtr2c1ef06748df47df52b586ac0fbc6a34;
extern void * TVPImportFuncPtrb6b2a03160b88239eccd18d89b1537d3;
extern void * TVPImportFuncPtr8becefbd52c76c7ecb0ea7b7f50b7915;
extern void * TVPImportFuncPtr74b9687a3bfd3b2c7abe226efc4225c1;
extern void * TVPImportFuncPtr7cafc2bf5965b594e60830e3057bbd58;
extern void * TVPImportFuncPtr80f111939c5694cbf43d07cf0ad1726c;
extern void * TVPImportFuncPtr8dc9cef84191f79b38403a2070952fd4;
extern void * TVPImportFuncPtr1d42bd1e659b36886c20567497b7ee96;
extern void * TVPImportFuncPtr0848fbdc7eeddb12c80bcd9c31383a64;
extern void * TVPImportFuncPtr1f1123c906c28ab6d16b6bef3f7ae978;
extern void * TVPImportFuncPtrb84394e20cc73a90349cf5be4e783111;
extern void * TVPImportFuncPtr76e0db3797851fe8ff90cf84780c50ad;
extern void * TVPImportFuncPtr6616241156c22bced42cd9f2f647677e;
extern void * TVPImportFuncPtr1ace346a3dd546c66ad115a33d8cf693;
extern void * TVPImportFuncPtr96fb9bbe33531d4268573355c658e165;
extern void * TVPImportFuncPtrc90b5737134c76f9ed0bb5da7cfaad8c;
extern void * TVPImportFuncPtr070ed05259a265cabdd82bfedabdd638;
extern void * TVPImportFuncPtr008b7e3a4c5bb23ee991f684a5064737;
extern void * TVPImportFuncPtrb64741dc4544ed43c44ddb6d0eb838ea;
extern void * TVPImportFuncPtr5b83e28b2d9ab0f75d7c7f6f61b5ded6;
extern void * TVPImportFuncPtrb948c9f43837efa489b0b91f3f675710;
extern void * TVPImportFuncPtreb83216f6f718245468ef48b97ab4c2d;
extern void * TVPImportFuncPtrc66ab4868b743de9c0ba8b26c67b23da;
extern void * TVPImportFuncPtr586e16d502a6ad98b08161bdb090f8b6;
extern void * TVPImportFuncPtrd8bc9c71c80b200c39b29167d795cad0;
extern void * TVPImportFuncPtr85df4beb87f6503891e116ce046353c3;
extern void * TVPImportFuncPtr35b6a7e1c73f257aae91e05fa9826e84;
extern void * TVPImportFuncPtra25b46701e25030af1ed847e0df229eb;
extern void * TVPImportFuncPtrc8906bf1efa5e86f9fddfab55a01c8f6;
extern void * TVPImportFuncPtr8141059f613820f694608af28e20cbad;
extern void * TVPImportFuncPtrcf2690e47099ac6378ed50df4a8a8e90;
extern void * TVPImportFuncPtr810c7054e44f535cf250f00707105417;
extern void * TVPImportFuncPtr52a9af7905ddc71d8b4e0ef7366eebdd;
extern void * TVPImportFuncPtr1635dbae2d91b338ddfd0430f8aa7f10;
extern void * TVPImportFuncPtr30df0c29ad8f672f7fe0742b4b11cd7f;
extern void * TVPImportFuncPtr61c82dec644c58290a25f34a69478870;
extern void * TVPImportFuncPtrf08e347d2d47dc5fc9a3cb59355b4fbb;
extern void * TVPImportFuncPtr5c62e59c2062f658d4c79d5257a9a586;
extern void * TVPImportFuncPtr259c72d8bfed1210ca71c54f24cacc7a;
extern void * TVPImportFuncPtr801a92ace08eb7ed001406869a39a75f;
extern void * TVPImportFuncPtre22e647af4ded8e51b1e76c845b4c8e2;
extern void * TVPImportFuncPtr12902221314df9bcf7f7cb74a5242fe0;
extern void * TVPImportFuncPtrb10feea1619ba8ac11237c12002cdb3e;
extern void * TVPImportFuncPtr19755b50d241edcb477bdcac22663778;
extern void * TVPImportFuncPtr040a0ecf46963e094ee8ec32ab3f1962;
extern void * TVPImportFuncPtr525c529dc687b5d86424d775d00bdfce;
extern void * TVPImportFuncPtrc96107b91e2a215f560a2612c6e85931;
extern void * TVPImportFuncPtrb8788eaa2ca495263c6ea2df264af5f5;
extern void * TVPImportFuncPtr4c6494008c520d896d699f82aca30b25;
extern void * TVPImportFuncPtr7d8f8d5e0832ecf248b19a89801ead0e;
extern void * TVPImportFuncPtr70849965060a6402f41b0b11ec2bb3a7;
extern void * TVPImportFuncPtrc72efa6b4efaa6664ae637a03e98e866;
extern void * TVPImportFuncPtra250e46575d0df1166e1542613218a5c;
extern void * TVPImportFuncPtra7bcff67b8d380c225b9d0d83921b3ae;
extern void * TVPImportFuncPtrfb68a3aa16bd2eb7d7550283170321bf;
extern void * TVPImportFuncPtr35b4299ede11f511b331b713ba9f38a8;
extern void * TVPImportFuncPtrefe52691cff20b2dfaa16e8e16caac0a;
extern void * TVPImportFuncPtr38eed43ef69251c34dc45695b8cf35c0;
extern void * TVPImportFuncPtr2058b65abdfb7598910f0d584d40a19d;
extern void * TVPImportFuncPtr1ebecaefe2ffdc811fccbac42e67e544;
extern void * TVPImportFuncPtr09e0f0912f8d758d3736ece9478c2686;
extern void * TVPImportFuncPtr23d61eda3959b087b618e348471e2c36;
extern void * TVPImportFuncPtre99b22c79b5bf04f3382f959c7bb69ca;
extern void * TVPImportFuncPtr9c4bb9ebee4db0fcebeae11c34950f97;
extern void * TVPImportFuncPtr505a9563aeb1b0255cfcc8197bee7d9e;
extern void * TVPImportFuncPtrf5ab80fc67ee04570330b9035144e760;
extern void * TVPImportFuncPtraf50188bbaa019ee88b19ecd931f7cce;
extern void * TVPImportFuncPtr268c452e85a6ac75301a6132f4f5e38b;
extern void * TVPImportFuncPtr646770a19b1768b372c9991ef0d3de85;
extern void * TVPImportFuncPtr5ec88e04fcb8e1877752281e172173ed;
extern void * TVPImportFuncPtr923f8161f2d2ba0e883bc4edc2901960;
extern void * TVPImportFuncPtr6f70cdb7586cbe571204f286f43c9780;
extern void * TVPImportFuncPtr9a4eaa6a627038799015c093609bdde7;
extern void * TVPImportFuncPtrc8bb6590f4a7adc906d7b3e42d907267;
extern void * TVPImportFuncPtr8323d57f26876d87271dbfa257b7f7e2;
extern void * TVPImportFuncPtr4d6f148e8997e1ae0cc0006ec1bd9618;
extern void * TVPImportFuncPtr7f03a4ddb254d0518642d15513eaea85;
extern void * TVPImportFuncPtr4add3926c72ba9df9259be58b680de0d;
extern void * TVPImportFuncPtr075d42cff8dc0c1fbd99c7459a63e526;
extern void * TVPImportFuncPtrb6bc45b28e194c7ac98bfdea88edee36;
extern void * TVPImportFuncPtr6dff6abb075da1a304520e60c011ef7b;
extern void * TVPImportFuncPtr892ffbdb8375851fc557e4abe9589b77;
extern void * TVPImportFuncPtrb2f3538284fc2adda2a43272ee654a96;
extern void * TVPImportFuncPtre0ff899ea4a9cc49a0e3b38deaf93b45;
extern void * TVPImportFuncPtr4b9c9ac2aafad07af4b16f34e9d4bba2;
extern void * TVPImportFuncPtrc2e423356d9ca3f26f9c1d294ee9b742;
extern void * TVPImportFuncPtrc07314686fdf5815ce9b058020da942b;
extern void * TVPImportFuncPtr4a197be1985d45ee86d5672d24134560;
extern void * TVPImportFuncPtrdec720a9c3cd2b378f195cf71a9ff8b0;
extern void * TVPImportFuncPtr5726a5c7af641ebaa504dc9ec8380938;
extern void * TVPImportFuncPtr1c53bc96ac9dfd483c2227bc5fa44825;
extern void * TVPImportFuncPtr1940c8fa03145aa029d0b7718ce0c809;
extern void * TVPImportFuncPtrb37f047c0f9bd143b34a2fc87ce5f16e;
extern void * TVPImportFuncPtrdec35fbd2a24fc32e5c220174d864cf4;
extern void * TVPImportFuncPtr86fd45a126296891aee413388597203e;
extern void * TVPImportFuncPtr603243e54f3508c37d993e8359b735dc;
extern void * TVPImportFuncPtrc3eadbd75b32dabe6faecebf492eb486;
extern void * TVPImportFuncPtr725e49de1d970ef04b179776666f2c34;
extern void * TVPImportFuncPtr55a9b73f877bfd4c6d8157e7b1c458df;
extern void * TVPImportFuncPtrd070209f152dd22087e6e996e02c85cf;
extern void * TVPImportFuncPtr308f905626bc51c7ef9b65b2c0ca34b2;
extern void * TVPImportFuncPtr95aab2a1ac9491e8026f4977e0918760;
extern void * TVPImportFuncPtr0c99a79e866f08b4df3914e83fc203dc;
extern void * TVPImportFuncPtr900476efbc2031e643c042ca8e63a3d7;
extern void * TVPImportFuncPtr07dfce61d490cf671a2d5359d713d64a;
extern void * TVPImportFuncPtr52d30ac8479ef7e870b5aff076482799;
extern void * TVPImportFuncPtr8e4d0392ed46e87f94e5fcf675a124a1;
extern void * TVPImportFuncPtr73f46e08d17e707725f433b454f05a89;
extern void * TVPImportFuncPtr80d60e682fa72973071e335db272a2a2;
extern void * TVPImportFuncPtr6bd6262185fa0b9cf1750f6a525d893a;
extern void * TVPImportFuncPtrcf29f737d4eb450b26789d421d0ec69a;
extern void * TVPImportFuncPtr13c0e371c08fd1b9da2f0c103d01c59a;
extern void * TVPImportFuncPtr82693e38df8f033ea98f9b7969d66d7b;
extern void * TVPImportFuncPtr6e3f8a3b18f55dae6153a889f00a3e87;
extern void * TVPImportFuncPtrefe14a197131b4813656d6669cc3475b;
extern void * TVPImportFuncPtrba4ecf60f872f757b69c84f457b3e941;
extern void * TVPImportFuncPtrdffedabe32ce886e3b7e695b44ad3547;
extern void * TVPImportFuncPtrf518c60b165658d19a0fadd8f69586aa;
extern void * TVPImportFuncPtr6fefcb1c2ca01a876c301ab41dbdab9f;
extern void * TVPImportFuncPtrdf55083347df0483b4ca6ba1e4f0b9a0;
extern void * TVPImportFuncPtrd8d28310f702714733c4c5dc850058df;
extern void * TVPImportFuncPtr52d24c38b05be174bc5c4fdcf02e9b9f;
extern void * TVPImportFuncPtrf27f455c8f30cbaf1706faac3c7b8e02;
extern void * TVPImportFuncPtr78ec453a50b2800bb01347e8ebbac000;
extern void * TVPImportFuncPtr0936d0f6fc53339d255893e58bcc6699;
extern void * TVPImportFuncPtrf4f7181b7fd679784c50b0cc7ba4c60e;
extern void * TVPImportFuncPtr79816d7e5741c2416fefe2c2a8baef00;
extern void * TVPImportFuncPtr42a3d248fab928f16555abcceca62834;
extern void * TVPImportFuncPtr926d6212b8b1b238e7bef9b17a3ee643;
extern void * TVPImportFuncPtr236e3d626784d80ca2cc5b2fe14cd9c6;
extern void * TVPImportFuncPtr1bfac11a5f95c842f97a8bb57d4019de;
extern void * TVPImportFuncPtr198ce21c54b0cea4c1bf5eeba35349ab;
extern void * TVPImportFuncPtr590a1ec7f64904eaa32b5c771bb5f8cd;
extern void * TVPImportFuncPtrdd13d4bc2b48540a92f047bf015b829b;
extern void * TVPImportFuncPtr0ff502d492598d2211405180bfb4d1e1;
extern void * TVPImportFuncPtrcf5401746759bfe38918087aaab6c57b;
extern void * TVPImportFuncPtr04e84aa7d8cf0477d55c700164544b38;
extern void * TVPImportFuncPtr449039d3afbfbd52a63130a3b227a490;
extern void * TVPImportFuncPtr347a4fa85af84e223c4b61d33ead694a;
extern void * TVPImportFuncPtr4ad1dd24b3b4769ee10149eea006af7a;
extern void * TVPImportFuncPtrb246b17b62d273bdc04e9d9e827f5c74;
extern void * TVPImportFuncPtr9974ebc6296f925cff55d8bcb2d52ce9;
extern void * TVPImportFuncPtr0e0c9d9107d8c56b8bc4d4198ae9208a;
extern void * TVPImportFuncPtrc23ece207f6ec2dd7c76ef873047aee3;
extern void * TVPImportFuncPtr81507020bc646be2f53ab95b9430ba27;
extern void * TVPImportFuncPtracc0d3861d1b971abcbdda1c075dd681;
extern void * TVPImportFuncPtrff2dccead1b31e3f34e8be3e2ba5bbf1;
extern void * TVPImportFuncPtre17db0d4f69625c61aba7fffe540dded;
extern void * TVPImportFuncPtr5bbc872e7bba5b761c509d31116e4460;
extern void * TVPImportFuncPtr4adf361303eae78829250c7b732a5722;
extern void * TVPImportFuncPtrbf172364c57c1aa561b145fd5cacda0c;
extern void * TVPImportFuncPtrd7687aa80dac10f88deac7aa7e70538a;
extern void * TVPImportFuncPtrb18b7259f98029f745c75291d6855ab1;
extern void * TVPImportFuncPtrb79e5d877116025576ca1f76af124009;
extern void * TVPImportFuncPtr8aea098dfe8a36c705cc2a9e1a189b84;
extern void * TVPImportFuncPtr4ccd3f6ab60d61be6dbfc59e8e3d1726;
extern void * TVPImportFuncPtr3d70bb72a7d7765c7e8ea580079ab7e9;
extern void * TVPImportFuncPtreba9b272d78a4b0cd7f9212e29a58607;
extern void * TVPImportFuncPtrcfbe8ee9d43aa64ae4190eac91f7c55f;
extern void * TVPImportFuncPtra4308a386968ef5d23025ab8a9e8c6db;
extern void * TVPImportFuncPtr5a4fcbe1e398e3d9690d571acbbbae9f;
extern void * TVPImportFuncPtrb8305ae2ae49a3f7f711105e77bafdf0;
extern void * TVPImportFuncPtrfb3b405f8747b54f26c332b9e6af81cd;
extern void * TVPImportFuncPtrb7ccd11d130f186883c109d2ba17b598;
extern void * TVPImportFuncPtrcf8ab6c24f25993ccc7663e572ac2991;
extern void * TVPImportFuncPtrba40ffbca76695b54a02aa8c1f1e047b;
extern void * TVPImportFuncPtrc97720e639e95ba5130ce9dd78d30403;
extern void * TVPImportFuncPtrc5557ac5391b1b831a22e64b65d1746c;
extern void * TVPImportFuncPtr3243a4c32d4f674f1bbc8d3895257568;
extern void * TVPImportFuncPtr78390a3d08879903ee9558e9df68db4d;
extern void * TVPImportFuncPtr58e9454d7096a52808f9a83b9ce25ff0;
extern void * TVPImportFuncPtrcdefadd0c3bf15b4639b2f0338a40585;
extern void * TVPImportFuncPtr4bf80e9bac16b9e3f9bf385b2fbce657;
extern void * TVPImportFuncPtr51aeacf2b6ef9deb01c3b3db201d6bf9;
extern void * TVPImportFuncPtr9ed5432d73448da47991df9577ee97bc;
extern void * TVPImportFuncPtrcf1d02d1cc1aff0aae6c038c95dac80f;
extern void * TVPImportFuncPtrddb0e05c72c0692e78af885ac7ec82dc;
extern void * TVPImportFuncPtra3029db6292616cd16c228b91dc4af13;
extern void * TVPImportFuncPtr2d90871c6bc15a9e8d97d24c29e78e3b;
extern void * TVPImportFuncPtr0af6744e35e38276d6a98c1f382b1519;
extern void * TVPImportFuncPtrad40567a051208757642e5e087f3e741;
extern void * TVPImportFuncPtr6a15185daab9b274963fe5ef46305775;
extern void * TVPImportFuncPtr073a2332a8ab3ed31ab81daea3d3f2c4;
extern void * TVPImportFuncPtr01216e91225e06c7422bef0c2febc0cc;
extern void * TVPImportFuncPtr16ce22ad500a5bdfd5d5743c847a28b6;
extern void * TVPImportFuncPtr59251c4104f736fa2690c5f77fb0a908;
extern void * TVPImportFuncPtrf923750e0fdb51a6fc6c304832cb3dd3;
extern void * TVPImportFuncPtrbc77a1e312ff7827d90387fb92f0f5b0;
extern void * TVPImportFuncPtr2090afd7ae8bcb021ec4d04947d0d845;
extern void * TVPImportFuncPtr3a0f858bdf86199dc2d00b583a3b915f;
extern void * TVPImportFuncPtr0d316a141f7a502ff8d9ffe2d38d25a8;
extern void * TVPImportFuncPtrb31ff64ae2d8f93dbf28161d5080b295;
extern void * TVPImportFuncPtrd9b1c73516daea6a9c6564e2b731615a;
extern void * TVPImportFuncPtr003f9d3de568fcd71dd532f33d38839c;
extern void * TVPImportFuncPtr5da29a19bbe279a89be00e16c59d7641;
extern void * TVPImportFuncPtrc1b52e8f3578d11f369552a887e13c5b;
extern void * TVPImportFuncPtrdcd6ba3960e3e2cf6dbe585b1f67b0ac;
extern void * TVPImportFuncPtr5b1fa785e397e643dd09cb43c2f2f4db;
extern void * TVPImportFuncPtr29af78765c764c566e6adc77e0ea7041;
extern void * TVPImportFuncPtr9e0df54e4c24ee28d5517c1743faa3a3;
extern void * TVPImportFuncPtrd3aaa55d66777d7308ffa7a348c84841;
extern void * TVPImportFuncPtrb426fbfb6ccb4e89c252b6af566995b8;
extern void * TVPImportFuncPtr678c2b211f8d8f661f6fdd95c52fbaa8;
extern void * TVPImportFuncPtr9ec5b02d14238454101dad083b5dfc3b;
extern void * TVPImportFuncPtr471b3daf08ed9b828679d0dae78250ed;
extern void * TVPImportFuncPtrd0bb2c604ee6f0bba72ddc017f6416eb;
extern void * TVPImportFuncPtr3ab4d4d7b57eea827e7bb7c263afb951;
extern void * TVPImportFuncPtrdc025d3981a832b095736a0214b98797;
extern void * TVPImportFuncPtr9982ebedc12d343cb098e2a7b25bdef1;
extern void * TVPImportFuncPtr81eeacbed5ee6129bef4b370e28b5d10;
extern void * TVPImportFuncPtr6ed1088905d99012d2fb5827ea19527e;
extern void * TVPImportFuncPtrb4d6c64cc0004ffaba804f0e8f02ab9b;
extern void * TVPImportFuncPtr2c3e08b8df93ec50451edd916c707030;
extern void * TVPImportFuncPtreba070d1583ca5f5d02630ba33a5504b;
extern void * TVPImportFuncPtree474537852ce5eb165cb1761950faba;
extern void * TVPImportFuncPtreed221c603243522667e2f1c6ace3ba4;
extern void * TVPImportFuncPtr1f973c5e3cfaf00fa752b7e22d7ba481;
extern void * TVPImportFuncPtrb9d5260bba9edd7503f1adf882218979;
extern void * TVPImportFuncPtraedbd2eda61145de808e295331884245;
extern void * TVPImportFuncPtrce0f184e84752eb279e4f900d8b53c18;
extern void * TVPImportFuncPtr0217d49393163b80897d044c1d93092f;
extern void * TVPImportFuncPtr5bbd9d5b364840e9615af35a62f69d7d;
extern void * TVPImportFuncPtr2b2837e81fcaeec35f61a2a3ecf2fb2d;
extern void * TVPImportFuncPtrbb0706a78e9066944bfbffd1406be2d4;
extern void * TVPImportFuncPtr770e67c91215292980b88cc6efb9f2a5;
extern void * TVPImportFuncPtr068ab11f05731f2c2e9ea8c5fdb16a9f;
extern void * TVPImportFuncPtrb9873a0ad2653952cb2948b817e786e4;
extern void * TVPImportFuncPtr11d9804ae4db32d731af69c397769cbf;
extern void * TVPImportFuncPtr421f5aa6dbaaaf946f74942c77aac9bc;
extern void * TVPImportFuncPtr563ee9dcb14a2914fc246e64679f42b5;
extern void * TVPImportFuncPtre23a54b6b80bd03111a40f669524724f;
extern void * TVPImportFuncPtrc90c8bbd18a7190636ae4269c36ad005;
extern void * TVPImportFuncPtr03c54a8e8c86e171f868a624e490691f;
extern void * TVPImportFuncPtr30b63f3cc59b39f1a71829bbbdf6e45d;
extern void * TVPImportFuncPtr705bcc30a0561ec679c2267e1a573b23;
extern void * TVPImportFuncPtr5c627d080007e455b0393a9b4457cd4d;
extern void * TVPImportFuncPtr72a64cecd44d80f95fc93faf0d239e32;
extern void * TVPImportFuncPtref838904712bfdc614dbc689fbe7fb18;
extern void * TVPImportFuncPtracc97936adc40656e824cfdf7a34e20c;
extern void * TVPImportFuncPtr5ea1ba3602f9d9fee344de6c3406d7a3;
extern void * TVPImportFuncPtrd25f0771b8fc7715d69f01d950463a49;
extern void * TVPImportFuncPtrf8ab11c930782ce058e517d0440ec87f;
extern void * TVPImportFuncPtrb8157e369d53c2d944b76494980ced7b;
extern void * TVPImportFuncPtraba94f656b4c1de827d11c72b36a5e9c;
extern void * TVPImportFuncPtr0656942f5a95783a4de73ca6e654d3b5;
extern void * TVPImportFuncPtr5c2b7d12713dd5a94ef8e6eff1f79752;
extern void * TVPImportFuncPtr6f1d30ac7e812cc5a059459c47638cd0;
extern void * TVPImportFuncPtr1d51684322635e7848ef53f7f6be8a1e;
extern void * TVPImportFuncPtra1f2d56d138a4038fe1678328910a81d;
extern void * TVPImportFuncPtrc135ef491b533febfd49696d22a1dd3d;
extern void * TVPImportFuncPtr579117a873b466d78bf93e49c4a078da;
extern void * TVPImportFuncPtrec8fa08705639eb7ae5d44ab63dea5e8;
extern void * TVPImportFuncPtrb49dc1cda6109256815dae7b4293725d;
extern void * TVPImportFuncPtr912a670f56707ac70f2fee13660c2af8;
extern void * TVPImportFuncPtrd0159986645df76b8c66fdb662efffde;
extern void * TVPImportFuncPtrcd7a2e6f91bf8d2daa3e28139d7d9f5c;
extern void * TVPImportFuncPtr676004ca892b2bfee6859d0bb132fdd7;
extern void * TVPImportFuncPtrd4b161d8a745baa5e2113669773a758f;
extern void * TVPImportFuncPtref7537293f6e3b6127480f6c5fd018a1;
extern void * TVPImportFuncPtr6f6f73b75cffe40a28566d1832ae1224;
extern void * TVPImportFuncPtr7adc5aad39e459e01543d07c239efe57;
extern void * TVPImportFuncPtr3ff6b480097eec3f5fdb7bfad685fd2a;
extern void * TVPImportFuncPtrb2c50c3a1dfea7e9d05fed69818bafc3;
extern void * TVPImportFuncPtr8024df9077e2c85b5b718ad2c87e57e7;
extern void * TVPImportFuncPtr989769d4eb8e42e9c9bbe721b296406c;
extern void * TVPImportFuncPtrcc1ac928b5c31570dfba7ed8f565be4b;
extern void * TVPImportFuncPtr62931efed5729a332e60bd1f7c7cecdf;
extern void * TVPImportFuncPtr53c18160b157088f72a9afd79737b48b;
extern void * TVPImportFuncPtr48135697fd7f4df87402a7dd4d761555;
extern void * TVPImportFuncPtre2c71cf04e876069eb7315c800a96898;
extern void * TVPImportFuncPtr1f63c018cf805ca1168af192cf8a4b41;
extern void * TVPImportFuncPtr704a9574dafd3669e10d546549948e03;
extern void * TVPImportFuncPtr97905c510b9502c20c9322c9f5fb4188;
extern void * TVPImportFuncPtrb23e84230c4736667279c7a71f4ca53e;
extern void * TVPImportFuncPtreb41fc900b0a6e3aba9d531f266137f1;
extern void * TVPImportFuncPtr5bd02c627b74bbb22d5a525b8bcbbd27;
extern void * TVPImportFuncPtrcc82e6a6b31ea743b9ebbdeed1ddedc3;
extern void * TVPImportFuncPtr247b25d497e48bc0191fdb2ac530f4ca;
extern void * TVPImportFuncPtr6bbea3af36c35631641cc8356ff65475;
extern void * TVPImportFuncPtrcac02dfd62ba94abf6a346bef0bf3ab9;
extern void * TVPImportFuncPtr68eeb36d76d88ff00014f04b23454254;
extern void * TVPImportFuncPtr65e03b1c849b6e9cb5c478024aa9a5b7;
extern void * TVPImportFuncPtr7670c0c5630625ee6a73b7b9ee093650;
extern void * TVPImportFuncPtr68a0abce6eefa08e74353ec48c4c87a8;
extern void * TVPImportFuncPtrccb6e098b9a0791a0f20e9f1af55e341;
extern void * TVPImportFuncPtr0f817efe47b451fd719c05a104c2b803;
extern void * TVPImportFuncPtrefad1a3d774747bd2b5adb221ede2678;
extern void * TVPImportFuncPtr563285ed004ddd2945f91db7b5347d3c;
extern void * TVPImportFuncPtr4c032260ef83d44bfe05fdc16843a8f9;
extern void * TVPImportFuncPtr96fd614457f06499a430b0c6e0e8a941;
extern void * TVPImportFuncPtrd6e36d304ff7253088ab4bc1aaf13a98;
extern void * TVPImportFuncPtreddacf49735189e23d9d49831851ffdb;
extern void * TVPImportFuncPtr20275a5de4aef464b85d3f6db2800063;
extern void * TVPImportFuncPtr872d1c626e6d4e3d5e86a257f0b14536;
extern void * TVPImportFuncPtra7ebb70cdec339f26c2ea7fd9a471b88;
extern void * TVPImportFuncPtrd748ffef5cde2a6a3333e75b7fa3fb49;
extern void * TVPImportFuncPtr15e1fe0e6230e7b60e216e266f927f7b;
extern void * TVPImportFuncPtrf8179eafd0cbe8116874310519207dc0;
extern void * TVPImportFuncPtraccbc3bed3223d552de2723366cfc2b6;
extern void * TVPImportFuncPtre2c3e74d2a20a601c1f393348f58aeb2;
extern void * TVPImportFuncPtre0163a6ca3397c2e71715132cccefa1d;
extern void * TVPImportFuncPtr2c3ea1ea88799dfde81025bf1959333a;
extern void * TVPImportFuncPtra6bb56b3f4b7a89fe78d63956a0f444c;
extern void * TVPImportFuncPtr09a81ac18a121d8fbb67285a081bf9c6;
extern void * TVPImportFuncPtr46fdfe0f5369bf234c3ed60a43947d9d;
extern void * TVPImportFuncPtrd866cb6c8a47444bbac60eeffbfc6d96;
extern void * TVPImportFuncPtr7b5718fc67458089c685dbb900126890;
extern void * TVPImportFuncPtr5713dfe9525662357d3819229e0204c2;
extern void * TVPImportFuncPtr8954a6b4a7f8b378c2af16a00d5059b0;
extern void * TVPImportFuncPtr2ed4faa38db6f3dee0dea18ebe973d35;
extern void * TVPImportFuncPtrd0338dedb0af532d22f2075a85373548;
extern void * TVPImportFuncPtr583d57c3bb9491f8f9904c266d3f52e8;
extern void * TVPImportFuncPtr8ac206da43e322eb8e34fce2b0959656;
extern void * TVPImportFuncPtr14f5f97d90bd8da89b68d035367f4ba4;
extern void * TVPImportFuncPtrac3b21181ef4c1be73cf5e0edb4e1a8f;
extern void * TVPImportFuncPtr1d7d97509292a4ca9269f2539dcc70fd;
extern void * TVPImportFuncPtrc4033f54a99517783b8d6ad23c90aeed;
extern void * TVPImportFuncPtrf19e38d48755c971fc35408ac65562fa;
extern void * TVPImportFuncPtre01204e226d8aa9520b3620b68da6196;
extern void * TVPImportFuncPtrb50000da98f1257cf789fc63fb1fda02;
extern void * TVPImportFuncPtrc55f38b1a7623646aa5cc45d4f4f479b;
extern void * TVPImportFuncPtr983d270549ec0e83e2a863b43e1e6f70;
extern void * TVPImportFuncPtrb48d779dc6a881c67c5f8fa12655aa28;
extern void * TVPImportFuncPtrd3967c6e24d0c4ad107a03c1cadd57b1;
extern void * TVPImportFuncPtr6b6f416b5725a7cafb4774ffc3a00f10;
extern void * TVPImportFuncPtrbc7fc5dfa228152a09d2230823c2fe71;
extern void * TVPImportFuncPtra1cb941317b947beb88e29fa8d46a2be;
extern void * TVPImportFuncPtr8e185e82bb27a7fb40f0b08f560a57e9;
extern void * TVPImportFuncPtr4b7b264b61ee0eea68213934217f5865;
extern void * TVPImportFuncPtre872f12593d6853ebdffebbb5d003c10;
extern void * TVPImportFuncPtre86fcf60fa658129d937de3728d3c432;
extern void * TVPImportFuncPtr350741a7398a187628866f5b397c7a99;
extern void * TVPImportFuncPtr3b5a3e187077b0b5eac9a040c99dd9e7;
extern void * TVPImportFuncPtr2d9b2bb2cd57220048fe170f1e960cb7;
extern void * TVPImportFuncPtr260624e275a20115e8861eb7b0383971;
extern void * TVPImportFuncPtr15b31724287dbbecb775b2e46dc35fb9;
extern void * TVPImportFuncPtrff652293eef07b5a7ec4f372e5504e2c;
extern void * TVPImportFuncPtr99b773033e9a2c631b483d4d0e3881f8;
extern void * TVPImportFuncPtr3787960fc29b8545629d894ff46d4641;
extern void * TVPImportFuncPtr3fc76257bb1639de4bfa0c0fcedf9c4a;
extern void * TVPImportFuncPtr292ee2eeb8131e34368ba9ee144b737a;
extern void * TVPImportFuncPtrec144655bc61bfa2c6e9505cc1a0a298;
extern void * TVPImportFuncPtr230218bdabfc34178a8306a54276a3c8;
extern void * TVPImportFuncPtr617dfb046aaf40078ee76715fa4756af;
extern void * TVPImportFuncPtr8116bb2b26dcafd9fefca76e9f1d9b24;
extern void * TVPImportFuncPtr12962f857563cd39b3cb1f9894775cc7;
extern void * TVPImportFuncPtr50c0d25cd9af311a5fb0aca78f691c3b;
extern void * TVPImportFuncPtr6c37a1ccda816c4fbab4f0117ca75e8a;
extern void * TVPImportFuncPtre21c21762dd0e36d6f7d2cedaac97383;
extern void * TVPImportFuncPtr487ee86557f94113db9a981e08d29caa;
extern void * TVPImportFuncPtrdfdfe0e494845bf484612cc97145f85c;
extern void * TVPImportFuncPtre74dc11dbd56fb450eed1388a65d3102;
extern void * TVPImportFuncPtr6981c02247de5799ea7dfbd79fdc208d;
extern void * TVPImportFuncPtr7c559043315f6ecd7a86ec7d8d820f6d;
extern void * TVPImportFuncPtr3a8b6aca73c83d6fc9ce813661ec734d;
extern void * TVPImportFuncPtr20d7ce65e240b745b10616bb5da1f897;
extern void * TVPImportFuncPtrf4d1217249674ac9274d358c381afc0b;
extern void * TVPImportFuncPtrca77323bbe361f88f68536018fa94c50;
extern void * TVPImportFuncPtr17983ecc7e7fe370bce664281a84c948;
extern void * TVPImportFuncPtr61a2f61030362903d00ba21a3cebecdd;
extern void * TVPImportFuncPtre9f985403dbd18540d8230a2af6ed76b;
extern void * TVPImportFuncPtrbe0523c9a72ba26cb4bfa3cb188cacf6;
extern void * TVPImportFuncPtr8ac7cf651223c8ba53df90cf4f3d3bbc;
extern void * TVPImportFuncPtr873e73aa35096ad4c684d394a10135a6;
extern void * TVPImportFuncPtr3342548f105147c86019ae31ece01d4e;
extern void * TVPImportFuncPtr607ee0956cbb16b2afb7cb2227aa6267;
extern void * TVPImportFuncPtr816d84c86e86d5e7c0018d551e741e4f;
extern void * TVPImportFuncPtr985fcda0141eb3b4c6bd8342e947f130;
extern void * TVPImportFuncPtrd00e4f9e493334d2f65ea379ff03d717;
extern void * TVPImportFuncPtr0c246e6c7c8798e4c10d2bbfc66326c9;
extern void * TVPImportFuncPtr501015843a83368b3ff1c7c9ef5f3bcb;
extern void * TVPImportFuncPtr61d5fc5a060f346752a3a8b6886d17bc;
extern void * TVPImportFuncPtr0debe3e1caf0f57572a59917851676d3;
extern void * TVPImportFuncPtree3a36682f48639166ba04a19fe1b332;
extern void * TVPImportFuncPtr4d99b9e38121251b40a90cd2bd5fea63;
extern void * TVPImportFuncPtrf1509827696ebf5627bee1a45d675fb8;
extern void * TVPImportFuncPtrbbb625e23229350453161810c41419dd;
extern void * TVPImportFuncPtr489a6aae30de0feff5d3c5fbd42ae325;
extern void * TVPImportFuncPtr186a94b2fed609ed2d2a7ac1a2bed87f;
extern void * TVPImportFuncPtrbde8efb9971664f2b52fe912745e2791;
extern void * TVPImportFuncPtr386d6fa5cb73e3519b62d20470e5414b;
extern void * TVPImportFuncPtrc61f97ec3d99bdbb23afe93870001bbf;
extern void * TVPImportFuncPtrf92821f2b23662c6f1256511a626cd3f;
extern void * TVPImportFuncPtr76b0732e3e2886897d5f26b4b0545dee;
extern void * TVPImportFuncPtr903ed11ef3863850e837bd4b3b1d61a1;
extern void * TVPImportFuncPtr2661124b39595ffafe2fb0bfb7bd2efc;
extern void * TVPImportFuncPtrd0b7170e54398c2f9d27dcc513c4cf46;
extern void * TVPImportFuncPtr31bdd2a1eed3785c1422fab5ea6b3ce7;
extern void * TVPImportFuncPtrdbc300d1dadc1a60cb0dcadfb92f1aee;
extern void * TVPImportFuncPtr1d4d9f8bdf55bd4c78abd90656af0364;
extern void * TVPImportFuncPtr5c7049e712e84b40ac05942421202de5;
extern void * TVPImportFuncPtr5dca8992bb340d70ba65ddab65c28371;
extern void * TVPImportFuncPtr85f1f38f783ebfcf638f3c443bc9b204;
extern void * TVPImportFuncPtr7d61d143884bfa4b6c50dae11c2b659f;
extern void * TVPImportFuncPtr793a2ad7ad3411be3670576a8e6ddcf8;
extern void * TVPImportFuncPtr68d8eec33254f1684e53bbc0aa8b2466;
extern void * TVPImportFuncPtrb09652d2197b29f7d38aff0298c69f17;
extern void * TVPImportFuncPtrbe7db03ddcf1886cb7233e58f19c8c77;
extern void * TVPImportFuncPtrb4c8fedc1ffbe30d9703cb2b8d3c0e7b;
extern void * TVPImportFuncPtr77efef3b4ffc0cb577b76304e06e39f3;
extern void * TVPImportFuncPtr0e55187bde599d6585eaabd2c4ac3f02;
extern void * TVPImportFuncPtrf72e3fc3b97a9141b6f516f5e53bf9b8;
extern void * TVPImportFuncPtre7a1ac237f00bb6320d0e0ac7e6d51c6;
extern void * TVPImportFuncPtrd87682f6d691350878077bd101b7f0fc;
extern void * TVPImportFuncPtrd7ae155eaabd8e65d6b4d356fe4af496;
extern void * TVPImportFuncPtrbe3a1844ea6af533bd4e7b0a76c826a1;
extern void * TVPImportFuncPtraa531d2c3c87f456e48a14722faa1c1f;
extern void * TVPImportFuncPtr6889cd886e1c2e7faf541528636c16c3;
extern void * TVPImportFuncPtr5d9266e6a8a154fe4ba80b0995e109ab;
extern void * TVPImportFuncPtra7dc19b023737979ad1ae1ae01d560d2;
extern void * TVPImportFuncPtrd20444b7a6243d668a0d3956d95af510;
extern void * TVPImportFuncPtr1458dec9eee36816c8002d4049840355;
extern void * TVPImportFuncPtr21137ff5351245b1611852301b7f5796;
extern void * TVPImportFuncPtrc07fc4e45fc2dc44d839c5e012d0be60;
extern void * TVPImportFuncPtr6815b962a3122ae967284239932cc656;
extern void * TVPImportFuncPtre96cccbe1f16b0fb74673f2ec3343ff8;
extern void * TVPImportFuncPtre8cd7494f919b18a992cb8c2722b2bf0;
extern void * TVPImportFuncPtr990fdefcafc0de5e8e1f502c1b341e44;
extern void * TVPImportFuncPtrde5d83ba307e822825062377fb76c2ba;
extern void * TVPImportFuncPtr5e28bcc0f5ad6a038eb5a6535b56386c;
extern void * TVPImportFuncPtre33419e8ede4bb501ab1787cf17c7ca5;
extern void * TVPImportFuncPtr1cd7cb9580c0cf723dea402b85a720b1;
extern void * TVPImportFuncPtrd18ca17fad389ff60ce3caa769083798;
extern void * TVPImportFuncPtr0a959a5ff02530a8eb122e7e1f8ceed3;
extern void * TVPImportFuncPtra4774ea559e64b4667b3845f8540d207;
extern void * TVPImportFuncPtr52eae3e8106494bfa604c15492ecb9f4;
extern void * TVPImportFuncPtr882f458df5e05bb9ab2222e79f6c81cf;
extern void * TVPImportFuncPtr6069a18bf7d3f394c230cdcf2f574ef4;
extern void * TVPImportFuncPtr75b60565caf44027cc52b2b5cf6b0ea3;
extern void * TVPImportFuncPtr9d735149c3ad586363895f76645abf2e;
extern void * TVPImportFuncPtrea5168fae254acdd8c8db6f1f3d2da03;
extern void * TVPImportFuncPtrf5a42bd5239e1a0be29f92eb838d2c8c;
extern void * TVPImportFuncPtr7cc8cd9f415b183b42c546635aeade7f;
extern void * TVPImportFuncPtrad2fefa53e05528f9c1fe29d27db0f37;
extern void * TVPImportFuncPtrf3e06fed4c82a9bd1b53252abaf50847;
extern void * TVPImportFuncPtr960db7ea36202bf7ec3bf6b767cc045e;
extern void * TVPImportFuncPtr7bf5d357eb52dd206a269b54c8136e0e;
extern void * TVPImportFuncPtrba1c9b771c5cdb725128de684af3c9ca;
extern void * TVPImportFuncPtr69cc6311196adc134fd153c4c5346bc5;
extern void * TVPImportFuncPtr8ed68f8e79efe1c767f92e7d92eb8b54;
extern void * TVPImportFuncPtr60da1e9ec15b251ff18ddcdf8a3e93e0;
extern void * TVPImportFuncPtref47304bad87a036e38f0319b48c1f6e;
extern void * TVPImportFuncPtr182d19020e4e2d5cd1462d7c8ef24d1f;
extern void * TVPImportFuncPtr9e1fa429a92a5c99d397a06c20fd6705;
extern void * TVPImportFuncPtr74ac7c291299eb928aa4c2899df5567e;
extern void * TVPImportFuncPtrfb645d9ec0ef3fd2aba2b762ef6b9a15;
extern void * TVPImportFuncPtrf988626275257574050ac789f9060a3b;
extern void * TVPImportFuncPtr1831064ed23493cef407648763ba4d69;
extern void * TVPImportFuncPtr305390c94750daa7124db3ff6e77931c;
extern void * TVPImportFuncPtr4fb384a391bfcf6a3a2932661d3051aa;
extern void * TVPImportFuncPtr305537c4820e23cf217a15efb56dba1c;
extern void * TVPImportFuncPtraacf83677ca7df75117f7bafa7a53791;
extern void * TVPImportFuncPtrd14b922fefc6c07aa536b94762579fe5;
extern void * TVPImportFuncPtr00fd650a79c603bdeb2f8e36f667a782;
extern void * TVPImportFuncPtra36ee133c07c30185b0bbc6375954e88;
extern void * TVPImportFuncPtrdc657ecacf8e578870314427216864d9;
extern void * TVPImportFuncPtre79d02b58a8bfdee439bc0694d7edd6d;
extern void * TVPImportFuncPtr6b7537b66b71d27384bea45bc2bf24b4;
extern void * TVPImportFuncPtrb3456dbad652b52f5bce1889b6f4d0ef;
extern void * TVPImportFuncPtr9a50803a03e1ccb60120dff8b92ecdcd;
extern void * TVPImportFuncPtr0f6b3940dc72e3e56cd15216b53b9126;
extern void * TVPImportFuncPtr23b647f1c825e214a7465de3ebe9968d;
extern void * TVPImportFuncPtr8ec96bc7b777180f23e1a2e43bf9a413;
extern void * TVPImportFuncPtrcffd45014652659638d59abe11daf3be;
extern void * TVPImportFuncPtra784285a35b1bc76bb367305b5099e35;
extern void * TVPImportFuncPtr03773751329896facf2003ab79bbc475;
extern void * TVPImportFuncPtr923884216edf134d07d8e70f8f57e827;
extern void * TVPImportFuncPtre48798dc69498f80b6633bb405eda6eb;
extern void * TVPImportFuncPtr998a5e1aa5cd85689795348fc540a655;
extern void * TVPImportFuncPtr5f6d263c0d48d03f6eb0dc44c9dd0be2;


//---------------------------------------------------------------------------
// tTJSVariantString
//---------------------------------------------------------------------------

class tTJSVariantString : protected tTJSVariantString_S
{
	// do not create an instance of this class directly.

public:
	void AddRef()
	{
		if(!TVPImportFuncPtr8dc9cef84191f79b38403a2070952fd4)
		{
			static char funcname[] = "void tTJSVariantString::AddRef()";
			TVPImportFuncPtr8dc9cef84191f79b38403a2070952fd4 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantString *);
		((__functype)(TVPImportFuncPtr8dc9cef84191f79b38403a2070952fd4))(this);
	}

	void Release()
	{
		if(!TVPImportFuncPtr1d42bd1e659b36886c20567497b7ee96)
		{
			static char funcname[] = "void tTJSVariantString::Release()";
			TVPImportFuncPtr1d42bd1e659b36886c20567497b7ee96 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantString *);
		((__functype)(TVPImportFuncPtr1d42bd1e659b36886c20567497b7ee96))(this);
	}

	void SetString(const tjs_char * ref , tjs_int maxlen = - 1)
	{
		if(!TVPImportFuncPtr0848fbdc7eeddb12c80bcd9c31383a64)
		{
			static char funcname[] = "void tTJSVariantString::SetString(const tjs_char *,tjs_int)";
			TVPImportFuncPtr0848fbdc7eeddb12c80bcd9c31383a64 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantString *, const tjs_char *, tjs_int);
		((__functype)(TVPImportFuncPtr0848fbdc7eeddb12c80bcd9c31383a64))(this, ref, maxlen);
	}

	void SetString(const tjs_nchar * ref)
	{
		if(!TVPImportFuncPtr1f1123c906c28ab6d16b6bef3f7ae978)
		{
			static char funcname[] = "void tTJSVariantString::SetString(const tjs_nchar *)";
			TVPImportFuncPtr1f1123c906c28ab6d16b6bef3f7ae978 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantString *, const tjs_nchar *);
		((__functype)(TVPImportFuncPtr1f1123c906c28ab6d16b6bef3f7ae978))(this, ref);
	}

	void AllocBuffer(tjs_uint len)
	{
		if(!TVPImportFuncPtrb84394e20cc73a90349cf5be4e783111)
		{
			static char funcname[] = "void tTJSVariantString::AllocBuffer(tjs_uint)";
			TVPImportFuncPtrb84394e20cc73a90349cf5be4e783111 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantString *, tjs_uint);
		((__functype)(TVPImportFuncPtrb84394e20cc73a90349cf5be4e783111))(this, len);
	}

	void ResetString(const tjs_char * ref)
	{
		if(!TVPImportFuncPtr76e0db3797851fe8ff90cf84780c50ad)
		{
			static char funcname[] = "void tTJSVariantString::ResetString(const tjs_char *)";
			TVPImportFuncPtr76e0db3797851fe8ff90cf84780c50ad = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantString *, const tjs_char *);
		((__functype)(TVPImportFuncPtr76e0db3797851fe8ff90cf84780c50ad))(this, ref);
	}

	void AppendBuffer(tjs_uint applen)
	{
		if(!TVPImportFuncPtr6616241156c22bced42cd9f2f647677e)
		{
			static char funcname[] = "void tTJSVariantString::AppendBuffer(tjs_uint)";
			TVPImportFuncPtr6616241156c22bced42cd9f2f647677e = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantString *, tjs_uint);
		((__functype)(TVPImportFuncPtr6616241156c22bced42cd9f2f647677e))(this, applen);
	}

	void Append(const tjs_char * str)
	{
		if(!TVPImportFuncPtr1ace346a3dd546c66ad115a33d8cf693)
		{
			static char funcname[] = "void tTJSVariantString::Append(const tjs_char *)";
			TVPImportFuncPtr1ace346a3dd546c66ad115a33d8cf693 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantString *, const tjs_char *);
		((__functype)(TVPImportFuncPtr1ace346a3dd546c66ad115a33d8cf693))(this, str);
	}

	void Append(const tjs_char * str , tjs_int applen)
	{
		if(!TVPImportFuncPtr96fb9bbe33531d4268573355c658e165)
		{
			static char funcname[] = "void tTJSVariantString::Append(const tjs_char *,tjs_int)";
			TVPImportFuncPtr96fb9bbe33531d4268573355c658e165 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantString *, const tjs_char *, tjs_int);
		((__functype)(TVPImportFuncPtr96fb9bbe33531d4268573355c658e165))(this, str, applen);
	}

	tTJSVariantString * FixLength()
	{
		if(!TVPImportFuncPtrc90b5737134c76f9ed0bb5da7cfaad8c)
		{
			static char funcname[] = "tTJSVariantString * tTJSVariantString::FixLength()";
			TVPImportFuncPtrc90b5737134c76f9ed0bb5da7cfaad8c = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariantString *(__stdcall * __functype)(tTJSVariantString *);
		return ((__functype)(TVPImportFuncPtrc90b5737134c76f9ed0bb5da7cfaad8c))(this);
	}

	tjs_uint32 * GetHint()
	{
		if(!TVPImportFuncPtr070ed05259a265cabdd82bfedabdd638)
		{
			static char funcname[] = "tjs_uint32 * tTJSVariantString::GetHint()";
			TVPImportFuncPtr070ed05259a265cabdd82bfedabdd638 = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_uint32 *(__stdcall * __functype)(tTJSVariantString *);
		return ((__functype)(TVPImportFuncPtr070ed05259a265cabdd82bfedabdd638))(this);
	}

	operator const tjs_char *() const
	{
		if(!TVPImportFuncPtr008b7e3a4c5bb23ee991f684a5064737)
		{
			static char funcname[] = "tTJSVariantString::operator const tjs_char *() const";
			TVPImportFuncPtr008b7e3a4c5bb23ee991f684a5064737 = TVPGetImportFuncPtr(funcname);
		}
		typedef const tjs_char *(__stdcall * __functype)(const tTJSVariantString *);
		return ((__functype)(TVPImportFuncPtr008b7e3a4c5bb23ee991f684a5064737))(this);
	}

	tjs_int GetLength() const
	{
		if(!TVPImportFuncPtrb64741dc4544ed43c44ddb6d0eb838ea)
		{
			static char funcname[] = "tjs_int tTJSVariantString::GetLength() const";
			TVPImportFuncPtrb64741dc4544ed43c44ddb6d0eb838ea = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_int(__stdcall * __functype)(const tTJSVariantString *);
		return ((__functype)(TVPImportFuncPtrb64741dc4544ed43c44ddb6d0eb838ea))(this);
	}

	tTVInteger ToInteger() const
	{
		if(!TVPImportFuncPtr5b83e28b2d9ab0f75d7c7f6f61b5ded6)
		{
			static char funcname[] = "tTVInteger tTJSVariantString::ToInteger() const";
			TVPImportFuncPtr5b83e28b2d9ab0f75d7c7f6f61b5ded6 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTVInteger(__stdcall * __functype)(const tTJSVariantString *);
		return ((__functype)(TVPImportFuncPtr5b83e28b2d9ab0f75d7c7f6f61b5ded6))(this);
	}

	tTVReal ToReal() const
	{
		if(!TVPImportFuncPtrb948c9f43837efa489b0b91f3f675710)
		{
			static char funcname[] = "tTVReal tTJSVariantString::ToReal() const";
			TVPImportFuncPtrb948c9f43837efa489b0b91f3f675710 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTVReal(__stdcall * __functype)(const tTJSVariantString *);
		return ((__functype)(TVPImportFuncPtrb948c9f43837efa489b0b91f3f675710))(this);
	}

	void ToNumber(tTJSVariant & dest) const
	{
		if(!TVPImportFuncPtreb83216f6f718245468ef48b97ab4c2d)
		{
			static char funcname[] = "void tTJSVariantString::ToNumber(tTJSVariant &) const";
			TVPImportFuncPtreb83216f6f718245468ef48b97ab4c2d = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(const tTJSVariantString *, tTJSVariant &);
		((__functype)(TVPImportFuncPtreb83216f6f718245468ef48b97ab4c2d))(this, dest);
	}

	tjs_int GetRefCount() const
	{
		if(!TVPImportFuncPtrc66ab4868b743de9c0ba8b26c67b23da)
		{
			static char funcname[] = "tjs_int tTJSVariantString::GetRefCount() const";
			TVPImportFuncPtrc66ab4868b743de9c0ba8b26c67b23da = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_int(__stdcall * __functype)(const tTJSVariantString *);
		return ((__functype)(TVPImportFuncPtrc66ab4868b743de9c0ba8b26c67b23da))(this);
	}

};
//---------------------------------------------------------------------------
// tTJSVariantOctet
//---------------------------------------------------------------------------

class tTJSVariantOctet : protected tTJSVariantOctet_S
{
	// do not create an instance of this class directly.

public:
	tTJSVariantOctet(const tjs_uint8 * data , tjs_uint length)
	{
		if(!TVPImportFuncPtr8970ba46068ac74746c3e84299937d8f)
		{
			static char funcname[] = "tTJSVariantOctet::tTJSVariantOctet(const tjs_uint8 *,tjs_uint)";
			TVPImportFuncPtr8970ba46068ac74746c3e84299937d8f = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantOctet *, const tjs_uint8 *, tjs_uint);
		((__functype)(TVPImportFuncPtr8970ba46068ac74746c3e84299937d8f))(this, data, length);
	}

	tTJSVariantOctet(const tjs_uint8 * data1 , tjs_uint len1 , const tjs_uint8 * data2 , tjs_uint len2)
	{
		if(!TVPImportFuncPtr438e27dcbb077284213eb4d7dcd43f8f)
		{
			static char funcname[] = "tTJSVariantOctet::tTJSVariantOctet(const tjs_uint8 *,tjs_uint,const tjs_uint8 *,tjs_uint)";
			TVPImportFuncPtr438e27dcbb077284213eb4d7dcd43f8f = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantOctet *, const tjs_uint8 *, tjs_uint , const tjs_uint8 *, tjs_uint);
		((__functype)(TVPImportFuncPtr438e27dcbb077284213eb4d7dcd43f8f))(this, data1, len1, data2, len2);
	}

	tTJSVariantOctet(const tTJSVariantOctet * o1 , const tTJSVariantOctet * o2)
	{
		if(!TVPImportFuncPtra98d712ca19a49afe07d0a7c5d064cef)
		{
			static char funcname[] = "tTJSVariantOctet::tTJSVariantOctet(const tTJSVariantOctet *,const tTJSVariantOctet *)";
			TVPImportFuncPtra98d712ca19a49afe07d0a7c5d064cef = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantOctet *, const tTJSVariantOctet *, const tTJSVariantOctet *);
		((__functype)(TVPImportFuncPtra98d712ca19a49afe07d0a7c5d064cef))(this, o1, o2);
	}

	~ tTJSVariantOctet()
	{
		if(!TVPImportFuncPtr08aef69683bcfe2a5c63d4c7866de8e9)
		{
			static char funcname[] = "tTJSVariantOctet::~ tTJSVariantOctet()";
			TVPImportFuncPtr08aef69683bcfe2a5c63d4c7866de8e9 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantOctet *);
		((__functype)(TVPImportFuncPtr08aef69683bcfe2a5c63d4c7866de8e9))(this);
	}

	void AddRef()
	{
		if(!TVPImportFuncPtrdbc9bc2e27068c8426b1c6a7f89424e0)
		{
			static char funcname[] = "void tTJSVariantOctet::AddRef()";
			TVPImportFuncPtrdbc9bc2e27068c8426b1c6a7f89424e0 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantOctet *);
		((__functype)(TVPImportFuncPtrdbc9bc2e27068c8426b1c6a7f89424e0))(this);
	}

	void Release()
	{
		if(!TVPImportFuncPtr5eeb98ca016123f57966457533bb639e)
		{
			static char funcname[] = "void tTJSVariantOctet::Release()";
			TVPImportFuncPtr5eeb98ca016123f57966457533bb639e = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariantOctet *);
		((__functype)(TVPImportFuncPtr5eeb98ca016123f57966457533bb639e))(this);
	}

	tjs_uint GetLength() const
	{
		if(!TVPImportFuncPtr98fdc846d0b4a83412f3521f65bb98b4)
		{
			static char funcname[] = "tjs_uint tTJSVariantOctet::GetLength() const";
			TVPImportFuncPtr98fdc846d0b4a83412f3521f65bb98b4 = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_uint(__stdcall * __functype)(const tTJSVariantOctet *);
		return ((__functype)(TVPImportFuncPtr98fdc846d0b4a83412f3521f65bb98b4))(this);
	}

	const tjs_uint8 * GetData() const
	{
		if(!TVPImportFuncPtr3309591d3c7f6f688e81588f169dba21)
		{
			static char funcname[] = "const tjs_uint8 * tTJSVariantOctet::GetData() const";
			TVPImportFuncPtr3309591d3c7f6f688e81588f169dba21 = TVPGetImportFuncPtr(funcname);
		}
		typedef const tjs_uint8 *(__stdcall * __functype)(const tTJSVariantOctet *);
		return ((__functype)(TVPImportFuncPtr3309591d3c7f6f688e81588f169dba21))(this);
	}

};
//---------------------------------------------------------------------------
// tTJSVariant
//---------------------------------------------------------------------------

class tTJSVariant : protected tTJSVariant_S
{

public:
	void ChangeClosureObjThis(iTJSDispatch2 * objthis)
	{
		if(!TVPImportFuncPtr3d4b725f0b4234d79524822e7c34486b)
		{
			static char funcname[] = "void tTJSVariant::ChangeClosureObjThis(iTJSDispatch2 *)";
			TVPImportFuncPtr3d4b725f0b4234d79524822e7c34486b = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, iTJSDispatch2 *);
		((__functype)(TVPImportFuncPtr3d4b725f0b4234d79524822e7c34486b))(this, objthis);
	}

	tTJSVariant()
	{
		if(!TVPImportFuncPtr3fc0c32ee41ea0c515f8fbb681e37982)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant()";
			TVPImportFuncPtr3fc0c32ee41ea0c515f8fbb681e37982 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr3fc0c32ee41ea0c515f8fbb681e37982))(this);
	}

	tTJSVariant(const tTJSVariant & ref)
	{
		if(!TVPImportFuncPtre8dbd4fe012262d9da831e0735aa33b3)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(const tTJSVariant &)";
			TVPImportFuncPtre8dbd4fe012262d9da831e0735aa33b3 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtre8dbd4fe012262d9da831e0735aa33b3))(this, ref);
	}

	tTJSVariant(iTJSDispatch2 * ref)
	{
		if(!TVPImportFuncPtrace6cce1353865d7376caca1f2124216)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(iTJSDispatch2 *)";
			TVPImportFuncPtrace6cce1353865d7376caca1f2124216 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, iTJSDispatch2 *);
		((__functype)(TVPImportFuncPtrace6cce1353865d7376caca1f2124216))(this, ref);
	}

	tTJSVariant(iTJSDispatch2 * obj , iTJSDispatch2 * objthis)
	{
		if(!TVPImportFuncPtr5055344aa8055bc238b79e5f88fc3300)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(iTJSDispatch2 *,iTJSDispatch2 *)";
			TVPImportFuncPtr5055344aa8055bc238b79e5f88fc3300 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, iTJSDispatch2 *, iTJSDispatch2 *);
		((__functype)(TVPImportFuncPtr5055344aa8055bc238b79e5f88fc3300))(this, obj, objthis);
	}

	tTJSVariant(const tjs_char * ref)
	{
		if(!TVPImportFuncPtr8238c542b814acf1a83c00cced57ba26)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(const tjs_char *)";
			TVPImportFuncPtr8238c542b814acf1a83c00cced57ba26 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tjs_char *);
		((__functype)(TVPImportFuncPtr8238c542b814acf1a83c00cced57ba26))(this, ref);
	}

	tTJSVariant(const tTJSString & ref)
	{
		if(!TVPImportFuncPtrbd2a14ca8c345fd7f151b08d1792fb60)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(const tTJSString &)";
			TVPImportFuncPtrbd2a14ca8c345fd7f151b08d1792fb60 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSString &);
		((__functype)(TVPImportFuncPtrbd2a14ca8c345fd7f151b08d1792fb60))(this, ref);
	}

	tTJSVariant(const tjs_nchar * ref)
	{
		if(!TVPImportFuncPtr16d432f9f86738a7688cbfc9b12441ec)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(const tjs_nchar *)";
			TVPImportFuncPtr16d432f9f86738a7688cbfc9b12441ec = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tjs_nchar *);
		((__functype)(TVPImportFuncPtr16d432f9f86738a7688cbfc9b12441ec))(this, ref);
	}

	tTJSVariant(const tjs_uint8 * ref , tjs_uint len)
	{
		if(!TVPImportFuncPtr6dac00582b8ba529e548ef058c4e869e)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(const tjs_uint8 *,tjs_uint)";
			TVPImportFuncPtr6dac00582b8ba529e548ef058c4e869e = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tjs_uint8 *, tjs_uint);
		((__functype)(TVPImportFuncPtr6dac00582b8ba529e548ef058c4e869e))(this, ref, len);
	}

	tTJSVariant(bool ref)
	{
		if(!TVPImportFuncPtr9193ae470b5efdfe617b5e94cd8f5da6)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(bool)";
			TVPImportFuncPtr9193ae470b5efdfe617b5e94cd8f5da6 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, bool);
		((__functype)(TVPImportFuncPtr9193ae470b5efdfe617b5e94cd8f5da6))(this, ref);
	}

	tTJSVariant(tjs_int32 ref)
	{
		if(!TVPImportFuncPtrec455b6ef0f5da178063db3875973260)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(tjs_int32)";
			TVPImportFuncPtrec455b6ef0f5da178063db3875973260 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, tjs_int32);
		((__functype)(TVPImportFuncPtrec455b6ef0f5da178063db3875973260))(this, ref);
	}

	tTJSVariant(tjs_int64 ref)
	{
		if(!TVPImportFuncPtra56aaf685bd171b63b0ef3c894d80ecf)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(tjs_int64)";
			TVPImportFuncPtra56aaf685bd171b63b0ef3c894d80ecf = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, tjs_int64);
		((__functype)(TVPImportFuncPtra56aaf685bd171b63b0ef3c894d80ecf))(this, ref);
	}

	tTJSVariant(tjs_real ref)
	{
		if(!TVPImportFuncPtr9a5fe199cebb9841f94ac0bb7a4a3b6a)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(tjs_real)";
			TVPImportFuncPtr9a5fe199cebb9841f94ac0bb7a4a3b6a = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, tjs_real);
		((__functype)(TVPImportFuncPtr9a5fe199cebb9841f94ac0bb7a4a3b6a))(this, ref);
	}

	tTJSVariant(const tjs_uint8 * * src)
	{
		if(!TVPImportFuncPtr2acb76a1f86e34afc5fe934d406c6c4c)
		{
			static char funcname[] = "tTJSVariant::tTJSVariant(const tjs_uint8 * *)";
			TVPImportFuncPtr2acb76a1f86e34afc5fe934d406c6c4c = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tjs_uint8 * *);
		((__functype)(TVPImportFuncPtr2acb76a1f86e34afc5fe934d406c6c4c))(this, src);
	}

	~ tTJSVariant()
	{
		if(!TVPImportFuncPtr3a4d914ca7d24989c236ad223c002d49)
		{
			static char funcname[] = "tTJSVariant::~ tTJSVariant()";
			TVPImportFuncPtr3a4d914ca7d24989c236ad223c002d49 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr3a4d914ca7d24989c236ad223c002d49))(this);
	}

	tTJSVariantType Type()
	{
		if(!TVPImportFuncPtr8fca7d3a123df1eacf228ba89f6a02ff)
		{
			static char funcname[] = "tTJSVariantType tTJSVariant::Type()";
			TVPImportFuncPtr8fca7d3a123df1eacf228ba89f6a02ff = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariantType(__stdcall * __functype)(tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr8fca7d3a123df1eacf228ba89f6a02ff))(this);
	}

	void Clear()
	{
		if(!TVPImportFuncPtr58be195f96a36c158d638e3b0c79308b)
		{
			static char funcname[] = "void tTJSVariant::Clear()";
			TVPImportFuncPtr58be195f96a36c158d638e3b0c79308b = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr58be195f96a36c158d638e3b0c79308b))(this);
	}

	tTJSVariantClosure & AsObjectClosure()
	{
		if(!TVPImportFuncPtreaa4d5b1d186a807a63311ab6d5e16e4)
		{
			static char funcname[] = "tTJSVariantClosure & tTJSVariant::AsObjectClosure()";
			TVPImportFuncPtreaa4d5b1d186a807a63311ab6d5e16e4 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariantClosure &(__stdcall * __functype)(tTJSVariant *);
		return ((__functype)(TVPImportFuncPtreaa4d5b1d186a807a63311ab6d5e16e4))(this);
	}

	void ToObject()
	{
		if(!TVPImportFuncPtr246f30d208c1d3a4e2b558090f403734)
		{
			static char funcname[] = "void tTJSVariant::ToObject()";
			TVPImportFuncPtr246f30d208c1d3a4e2b558090f403734 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr246f30d208c1d3a4e2b558090f403734))(this);
	}

	operator iTJSDispatch2 *()
	{
		if(!TVPImportFuncPtr3206ef9b7a8013d6572decdea49e7e2e)
		{
			static char funcname[] = "tTJSVariant::operator iTJSDispatch2 *()";
			TVPImportFuncPtr3206ef9b7a8013d6572decdea49e7e2e = TVPGetImportFuncPtr(funcname);
		}
		typedef iTJSDispatch2 *(__stdcall * __functype)(tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr3206ef9b7a8013d6572decdea49e7e2e))(this);
	}

	void ToString()
	{
		if(!TVPImportFuncPtrc5a30d297c3a121879b1392bc6c604ef)
		{
			static char funcname[] = "void tTJSVariant::ToString()";
			TVPImportFuncPtrc5a30d297c3a121879b1392bc6c604ef = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtrc5a30d297c3a121879b1392bc6c604ef))(this);
	}

	tjs_uint32 * GetHint()
	{
		if(!TVPImportFuncPtre398f5aef0ab92bc1323f3b094722fb1)
		{
			static char funcname[] = "tjs_uint32 * tTJSVariant::GetHint()";
			TVPImportFuncPtre398f5aef0ab92bc1323f3b094722fb1 = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_uint32 *(__stdcall * __functype)(tTJSVariant *);
		return ((__functype)(TVPImportFuncPtre398f5aef0ab92bc1323f3b094722fb1))(this);
	}

	void ToOctet()
	{
		if(!TVPImportFuncPtr0733b0ac80880897d327dc6f3b04ea9e)
		{
			static char funcname[] = "void tTJSVariant::ToOctet()";
			TVPImportFuncPtr0733b0ac80880897d327dc6f3b04ea9e = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr0733b0ac80880897d327dc6f3b04ea9e))(this);
	}

	void ToInteger()
	{
		if(!TVPImportFuncPtr4cb055ed9d8ef71d1af10898965c940c)
		{
			static char funcname[] = "void tTJSVariant::ToInteger()";
			TVPImportFuncPtr4cb055ed9d8ef71d1af10898965c940c = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr4cb055ed9d8ef71d1af10898965c940c))(this);
	}

	void ToReal()
	{
		if(!TVPImportFuncPtref8d198596b7d3143d02ed4450ccefa1)
		{
			static char funcname[] = "void tTJSVariant::ToReal()";
			TVPImportFuncPtref8d198596b7d3143d02ed4450ccefa1 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtref8d198596b7d3143d02ed4450ccefa1))(this);
	}

	tTJSVariant & operator =(const tTJSVariant & ref)
	{
		if(!TVPImportFuncPtrd48ea419e040ffe8c20c1e86d80c9a5f)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(const tTJSVariant &)";
			TVPImportFuncPtrd48ea419e040ffe8c20c1e86d80c9a5f = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtrd48ea419e040ffe8c20c1e86d80c9a5f))(this, ref);
	}

	void CopyRef(const tTJSVariant & ref)
	{
		if(!TVPImportFuncPtr679b215ff76a269871d5f325b981e561)
		{
			static char funcname[] = "void tTJSVariant::CopyRef(const tTJSVariant &)";
			TVPImportFuncPtr679b215ff76a269871d5f325b981e561 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr679b215ff76a269871d5f325b981e561))(this, ref);
	}

	tTJSVariant & operator =(iTJSDispatch2 * ref)
	{
		if(!TVPImportFuncPtr1039eff4a4443f9238438485a35a93a7)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(iTJSDispatch2 *)";
			TVPImportFuncPtr1039eff4a4443f9238438485a35a93a7 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, iTJSDispatch2 *);
		return ((__functype)(TVPImportFuncPtr1039eff4a4443f9238438485a35a93a7))(this, ref);
	}

	tTJSVariant & SetObject(iTJSDispatch2 * ref)
	{
		if(!TVPImportFuncPtr2f873b0ee1c6591ba28bc4b9c0e4c954)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::SetObject(iTJSDispatch2 *)";
			TVPImportFuncPtr2f873b0ee1c6591ba28bc4b9c0e4c954 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, iTJSDispatch2 *);
		return ((__functype)(TVPImportFuncPtr2f873b0ee1c6591ba28bc4b9c0e4c954))(this, ref);
	}

	tTJSVariant & SetObject(iTJSDispatch2 * object , iTJSDispatch2 * objthis)
	{
		if(!TVPImportFuncPtra583ffb56cdb2ede691e15053a8a165a)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::SetObject(iTJSDispatch2 *,iTJSDispatch2 *)";
			TVPImportFuncPtra583ffb56cdb2ede691e15053a8a165a = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, iTJSDispatch2 *, iTJSDispatch2 *);
		return ((__functype)(TVPImportFuncPtra583ffb56cdb2ede691e15053a8a165a))(this, object, objthis);
	}

	tTJSVariant & operator =(tTJSVariantClosure ref)
	{
		if(!TVPImportFuncPtre09ed277802c1b117e1908421448886d)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(tTJSVariantClosure)";
			TVPImportFuncPtre09ed277802c1b117e1908421448886d = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, tTJSVariantClosure);
		return ((__functype)(TVPImportFuncPtre09ed277802c1b117e1908421448886d))(this, ref);
	}

	tTJSVariant & operator =(tTJSVariantString * ref)
	{
		if(!TVPImportFuncPtre76dfb9e00f4a9d491117d815f30db7f)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(tTJSVariantString *)";
			TVPImportFuncPtre76dfb9e00f4a9d491117d815f30db7f = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, tTJSVariantString *);
		return ((__functype)(TVPImportFuncPtre76dfb9e00f4a9d491117d815f30db7f))(this, ref);
	}

	tTJSVariant & operator =(tTJSVariantOctet * ref)
	{
		if(!TVPImportFuncPtrb000dd8934508d8ec6d6ef976a6ff49b)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(tTJSVariantOctet *)";
			TVPImportFuncPtrb000dd8934508d8ec6d6ef976a6ff49b = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, tTJSVariantOctet *);
		return ((__functype)(TVPImportFuncPtrb000dd8934508d8ec6d6ef976a6ff49b))(this, ref);
	}

	tTJSVariant & operator =(const tTJSString & ref)
	{
		if(!TVPImportFuncPtrd98ab5c968ebfde4e924901d09190774)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(const tTJSString &)";
			TVPImportFuncPtrd98ab5c968ebfde4e924901d09190774 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, const tTJSString &);
		return ((__functype)(TVPImportFuncPtrd98ab5c968ebfde4e924901d09190774))(this, ref);
	}

	tTJSVariant & operator =(const tjs_char * ref)
	{
		if(!TVPImportFuncPtr661e8c10d5d477e6823a840244937cd8)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(const tjs_char *)";
			TVPImportFuncPtr661e8c10d5d477e6823a840244937cd8 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, const tjs_char *);
		return ((__functype)(TVPImportFuncPtr661e8c10d5d477e6823a840244937cd8))(this, ref);
	}

	tTJSVariant & operator =(const tjs_nchar * ref)
	{
		if(!TVPImportFuncPtr6b39e70ea89c4f883689f51289029b69)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(const tjs_nchar *)";
			TVPImportFuncPtr6b39e70ea89c4f883689f51289029b69 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, const tjs_nchar *);
		return ((__functype)(TVPImportFuncPtr6b39e70ea89c4f883689f51289029b69))(this, ref);
	}

	tTJSVariant & operator =(bool ref)
	{
		if(!TVPImportFuncPtr4a18b1c0afe37b84e2b35a7fc07c4e0f)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(bool)";
			TVPImportFuncPtr4a18b1c0afe37b84e2b35a7fc07c4e0f = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, bool);
		return ((__functype)(TVPImportFuncPtr4a18b1c0afe37b84e2b35a7fc07c4e0f))(this, ref);
	}

	tTJSVariant & operator =(tjs_int32 ref)
	{
		if(!TVPImportFuncPtr48b85c8774d91ca40b2992f0e452f19e)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(tjs_int32)";
			TVPImportFuncPtr48b85c8774d91ca40b2992f0e452f19e = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, tjs_int32);
		return ((__functype)(TVPImportFuncPtr48b85c8774d91ca40b2992f0e452f19e))(this, ref);
	}

	tTJSVariant & operator =(const tTVInteger ref)
	{
		if(!TVPImportFuncPtr5ea8db9a9193fe6bab53baf2bee06b6b)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(const tTVInteger)";
			TVPImportFuncPtr5ea8db9a9193fe6bab53baf2bee06b6b = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, const tTVInteger);
		return ((__functype)(TVPImportFuncPtr5ea8db9a9193fe6bab53baf2bee06b6b))(this, ref);
	}

	tTJSVariant & operator =(tjs_real ref)
	{
		if(!TVPImportFuncPtr46b92626ff6894e993c4f193a129540b)
		{
			static char funcname[] = "tTJSVariant & tTJSVariant::operator =(tjs_real)";
			TVPImportFuncPtr46b92626ff6894e993c4f193a129540b = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant &(__stdcall * __functype)(tTJSVariant *, tjs_real);
		return ((__functype)(TVPImportFuncPtr46b92626ff6894e993c4f193a129540b))(this, ref);
	}

	void logicalorequal(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtr6efc1d1f66f0e01a81faf767d7576816)
		{
			static char funcname[] = "void tTJSVariant::logicalorequal(const tTJSVariant &)";
			TVPImportFuncPtr6efc1d1f66f0e01a81faf767d7576816 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr6efc1d1f66f0e01a81faf767d7576816))(this, rhs);
	}

	void logicalandequal(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtr4ededf58eae77c320b4a6f5f701acafb)
		{
			static char funcname[] = "void tTJSVariant::logicalandequal(const tTJSVariant &)";
			TVPImportFuncPtr4ededf58eae77c320b4a6f5f701acafb = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr4ededf58eae77c320b4a6f5f701acafb))(this, rhs);
	}

	void operator |=(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtr028d5fda2f4568f6ab14b49d89650a4d)
		{
			static char funcname[] = "void tTJSVariant::operator |=(const tTJSVariant &)";
			TVPImportFuncPtr028d5fda2f4568f6ab14b49d89650a4d = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr028d5fda2f4568f6ab14b49d89650a4d))(this, rhs);
	}

	void increment()
	{
		if(!TVPImportFuncPtr11912984b8c094d2df26bf3c3677d096)
		{
			static char funcname[] = "void tTJSVariant::increment()";
			TVPImportFuncPtr11912984b8c094d2df26bf3c3677d096 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr11912984b8c094d2df26bf3c3677d096))(this);
	}

	void decrement()
	{
		if(!TVPImportFuncPtr6c0df790c33142e286aea9af6993d931)
		{
			static char funcname[] = "void tTJSVariant::decrement()";
			TVPImportFuncPtr6c0df790c33142e286aea9af6993d931 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr6c0df790c33142e286aea9af6993d931))(this);
	}

	void operator ^=(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtrc27d85b695cd6e144210785bdfd446ce)
		{
			static char funcname[] = "void tTJSVariant::operator ^=(const tTJSVariant &)";
			TVPImportFuncPtrc27d85b695cd6e144210785bdfd446ce = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtrc27d85b695cd6e144210785bdfd446ce))(this, rhs);
	}

	void operator &=(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtr8422ef7f42009be0ad58a09d64149051)
		{
			static char funcname[] = "void tTJSVariant::operator &=(const tTJSVariant &)";
			TVPImportFuncPtr8422ef7f42009be0ad58a09d64149051 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr8422ef7f42009be0ad58a09d64149051))(this, rhs);
	}

	void operator >>=(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtree07e6522577952453206ede39cdf54c)
		{
			static char funcname[] = "void tTJSVariant::operator >>=(const tTJSVariant &)";
			TVPImportFuncPtree07e6522577952453206ede39cdf54c = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtree07e6522577952453206ede39cdf54c))(this, rhs);
	}

	void rbitshiftequal(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtr786a65424247e711f6ca31f0a10603d7)
		{
			static char funcname[] = "void tTJSVariant::rbitshiftequal(const tTJSVariant &)";
			TVPImportFuncPtr786a65424247e711f6ca31f0a10603d7 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr786a65424247e711f6ca31f0a10603d7))(this, rhs);
	}

	void operator <<=(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtr995a222f2038dd2007f2c1f6429bd19e)
		{
			static char funcname[] = "void tTJSVariant::operator <<=(const tTJSVariant &)";
			TVPImportFuncPtr995a222f2038dd2007f2c1f6429bd19e = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr995a222f2038dd2007f2c1f6429bd19e))(this, rhs);
	}

	void operator %=(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtrda8c6e750d6a9c0557a56ef7f7fd8e88)
		{
			static char funcname[] = "void tTJSVariant::operator %=(const tTJSVariant &)";
			TVPImportFuncPtrda8c6e750d6a9c0557a56ef7f7fd8e88 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtrda8c6e750d6a9c0557a56ef7f7fd8e88))(this, rhs);
	}

	void operator /=(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtr9cf7b0f119bcf3fa4564837ae25429b3)
		{
			static char funcname[] = "void tTJSVariant::operator /=(const tTJSVariant &)";
			TVPImportFuncPtr9cf7b0f119bcf3fa4564837ae25429b3 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr9cf7b0f119bcf3fa4564837ae25429b3))(this, rhs);
	}

	void idivequal(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtr17cbcacad2ed350215d7d700c676ea40)
		{
			static char funcname[] = "void tTJSVariant::idivequal(const tTJSVariant &)";
			TVPImportFuncPtr17cbcacad2ed350215d7d700c676ea40 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr17cbcacad2ed350215d7d700c676ea40))(this, rhs);
	}

	void operator *=(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtr2bd375c0598e9148d88579a51b2f07a8)
		{
			static char funcname[] = "void tTJSVariant::operator *=(const tTJSVariant &)";
			TVPImportFuncPtr2bd375c0598e9148d88579a51b2f07a8 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr2bd375c0598e9148d88579a51b2f07a8))(this, rhs);
	}

	void logicalnot()
	{
		if(!TVPImportFuncPtr4d2c157f8b0b49e57c3e9b5abc9deb0f)
		{
			static char funcname[] = "void tTJSVariant::logicalnot()";
			TVPImportFuncPtr4d2c157f8b0b49e57c3e9b5abc9deb0f = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr4d2c157f8b0b49e57c3e9b5abc9deb0f))(this);
	}

	void bitnot()
	{
		if(!TVPImportFuncPtr4b7eaccf64af0f3a4c4fe64f4e2dd3fd)
		{
			static char funcname[] = "void tTJSVariant::bitnot()";
			TVPImportFuncPtr4b7eaccf64af0f3a4c4fe64f4e2dd3fd = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr4b7eaccf64af0f3a4c4fe64f4e2dd3fd))(this);
	}

	void tonumber()
	{
		if(!TVPImportFuncPtr3a4d2602c392a8d1f4c38d537a8c95e0)
		{
			static char funcname[] = "void tTJSVariant::tonumber()";
			TVPImportFuncPtr3a4d2602c392a8d1f4c38d537a8c95e0 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr3a4d2602c392a8d1f4c38d537a8c95e0))(this);
	}

	void changesign()
	{
		if(!TVPImportFuncPtr8d915d35ef8e857f245c5d46798618e4)
		{
			static char funcname[] = "void tTJSVariant::changesign()";
			TVPImportFuncPtr8d915d35ef8e857f245c5d46798618e4 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *);
		((__functype)(TVPImportFuncPtr8d915d35ef8e857f245c5d46798618e4))(this);
	}

	void operator -=(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtr1e463482afa8ca30f5fa7bea4fa5741d)
		{
			static char funcname[] = "void tTJSVariant::operator -=(const tTJSVariant &)";
			TVPImportFuncPtr1e463482afa8ca30f5fa7bea4fa5741d = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr1e463482afa8ca30f5fa7bea4fa5741d))(this, rhs);
	}

	void operator +=(const tTJSVariant & rhs)
	{
		if(!TVPImportFuncPtrfdf270e4080c986abd1649fa9fffdeab)
		{
			static char funcname[] = "void tTJSVariant::operator +=(const tTJSVariant &)";
			TVPImportFuncPtrfdf270e4080c986abd1649fa9fffdeab = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSVariant *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtrfdf270e4080c986abd1649fa9fffdeab))(this, rhs);
	}

	tTJSVariantType Type() const
	{
		if(!TVPImportFuncPtr972e0f9a6ec4648a9fb82bcf5d9095ff)
		{
			static char funcname[] = "tTJSVariantType tTJSVariant::Type() const";
			TVPImportFuncPtr972e0f9a6ec4648a9fb82bcf5d9095ff = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariantType(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr972e0f9a6ec4648a9fb82bcf5d9095ff))(this);
	}

	bool NormalCompare(const tTJSVariant & val2) const
	{
		if(!TVPImportFuncPtr9d76731c37c4664d654db026644c64b4)
		{
			static char funcname[] = "bool tTJSVariant::NormalCompare(const tTJSVariant &) const";
			TVPImportFuncPtr9d76731c37c4664d654db026644c64b4 = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr9d76731c37c4664d654db026644c64b4))(this, val2);
	}

	bool DiscernCompare(const tTJSVariant & val2) const
	{
		if(!TVPImportFuncPtr4f1620cb699874b9c8cedf6e321c606e)
		{
			static char funcname[] = "bool tTJSVariant::DiscernCompare(const tTJSVariant &) const";
			TVPImportFuncPtr4f1620cb699874b9c8cedf6e321c606e = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr4f1620cb699874b9c8cedf6e321c606e))(this, val2);
	}

	bool DiscernCompareStrictReal(const tTJSVariant & val2) const
	{
		if(!TVPImportFuncPtref1c6b2b601d1b0ff70272a4d447aa3c)
		{
			static char funcname[] = "bool tTJSVariant::DiscernCompareStrictReal(const tTJSVariant &) const";
			TVPImportFuncPtref1c6b2b601d1b0ff70272a4d447aa3c = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtref1c6b2b601d1b0ff70272a4d447aa3c))(this, val2);
	}

	bool GreaterThan(const tTJSVariant & val2) const
	{
		if(!TVPImportFuncPtr9b7872860c95cfdafb056ab30318e99c)
		{
			static char funcname[] = "bool tTJSVariant::GreaterThan(const tTJSVariant &) const";
			TVPImportFuncPtr9b7872860c95cfdafb056ab30318e99c = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr9b7872860c95cfdafb056ab30318e99c))(this, val2);
	}

	bool LittlerThan(const tTJSVariant & val2) const
	{
		if(!TVPImportFuncPtr53360f194a04fc142ddae2b9a3ab4c92)
		{
			static char funcname[] = "bool tTJSVariant::LittlerThan(const tTJSVariant &) const";
			TVPImportFuncPtr53360f194a04fc142ddae2b9a3ab4c92 = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr53360f194a04fc142ddae2b9a3ab4c92))(this, val2);
	}

	bool IsInstanceOf(const tjs_char * classname) const
	{
		if(!TVPImportFuncPtrce1dcb05e5e7c4cafbc4ed37f63b256e)
		{
			static char funcname[] = "bool tTJSVariant::IsInstanceOf(const tjs_char *) const";
			TVPImportFuncPtrce1dcb05e5e7c4cafbc4ed37f63b256e = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSVariant *, const tjs_char *);
		return ((__functype)(TVPImportFuncPtrce1dcb05e5e7c4cafbc4ed37f63b256e))(this, classname);
	}

	iTJSDispatch2 * AsObject() const
	{
		if(!TVPImportFuncPtr841ce4492b37321eea0c1b500de9b352)
		{
			static char funcname[] = "iTJSDispatch2 * tTJSVariant::AsObject() const";
			TVPImportFuncPtr841ce4492b37321eea0c1b500de9b352 = TVPGetImportFuncPtr(funcname);
		}
		typedef iTJSDispatch2 *(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr841ce4492b37321eea0c1b500de9b352))(this);
	}

	iTJSDispatch2 * AsObjectNoAddRef() const
	{
		if(!TVPImportFuncPtr61785de870894968cd9d95e17e88eafc)
		{
			static char funcname[] = "iTJSDispatch2 * tTJSVariant::AsObjectNoAddRef() const";
			TVPImportFuncPtr61785de870894968cd9d95e17e88eafc = TVPGetImportFuncPtr(funcname);
		}
		typedef iTJSDispatch2 *(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr61785de870894968cd9d95e17e88eafc))(this);
	}

	iTJSDispatch2 * AsObjectThis() const
	{
		if(!TVPImportFuncPtrad3236e727398311c3b8e1ddd5f4b293)
		{
			static char funcname[] = "iTJSDispatch2 * tTJSVariant::AsObjectThis() const";
			TVPImportFuncPtrad3236e727398311c3b8e1ddd5f4b293 = TVPGetImportFuncPtr(funcname);
		}
		typedef iTJSDispatch2 *(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtrad3236e727398311c3b8e1ddd5f4b293))(this);
	}

	iTJSDispatch2 * AsObjectThisNoAddRef() const
	{
		if(!TVPImportFuncPtr80e0b7be488545ff9b8bc52c9ab5fba5)
		{
			static char funcname[] = "iTJSDispatch2 * tTJSVariant::AsObjectThisNoAddRef() const";
			TVPImportFuncPtr80e0b7be488545ff9b8bc52c9ab5fba5 = TVPGetImportFuncPtr(funcname);
		}
		typedef iTJSDispatch2 *(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr80e0b7be488545ff9b8bc52c9ab5fba5))(this);
	}

	tTJSVariantClosure & AsObjectClosureNoAddRef() const
	{
		if(!TVPImportFuncPtr4eaa3e4efb319707db6ef81db1c6f147)
		{
			static char funcname[] = "tTJSVariantClosure & tTJSVariant::AsObjectClosureNoAddRef() const";
			TVPImportFuncPtr4eaa3e4efb319707db6ef81db1c6f147 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariantClosure &(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr4eaa3e4efb319707db6ef81db1c6f147))(this);
	}

	tTJSVariantString * AsString() const
	{
		if(!TVPImportFuncPtr693a0152f098caee7fc77f545dd3e954)
		{
			static char funcname[] = "tTJSVariantString * tTJSVariant::AsString() const";
			TVPImportFuncPtr693a0152f098caee7fc77f545dd3e954 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariantString *(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr693a0152f098caee7fc77f545dd3e954))(this);
	}

	tTJSVariantString * AsStringNoAddRef() const
	{
		if(!TVPImportFuncPtr42840710f5fba9bb32b95290b1796a55)
		{
			static char funcname[] = "tTJSVariantString * tTJSVariant::AsStringNoAddRef() const";
			TVPImportFuncPtr42840710f5fba9bb32b95290b1796a55 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariantString *(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr42840710f5fba9bb32b95290b1796a55))(this);
	}

	const tjs_char * GetString() const
	{
		if(!TVPImportFuncPtradec3f9ef429aa9a284081f0fc6a1b5b)
		{
			static char funcname[] = "const tjs_char * tTJSVariant::GetString() const";
			TVPImportFuncPtradec3f9ef429aa9a284081f0fc6a1b5b = TVPGetImportFuncPtr(funcname);
		}
		typedef const tjs_char *(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtradec3f9ef429aa9a284081f0fc6a1b5b))(this);
	}

	tTJSVariantOctet * AsOctet() const
	{
		if(!TVPImportFuncPtr674a7948152a1d7a49050b9d98796403)
		{
			static char funcname[] = "tTJSVariantOctet * tTJSVariant::AsOctet() const";
			TVPImportFuncPtr674a7948152a1d7a49050b9d98796403 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariantOctet *(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr674a7948152a1d7a49050b9d98796403))(this);
	}

	tTJSVariantOctet * AsOctetNoAddRef() const
	{
		if(!TVPImportFuncPtraa6f132b2031c83062f6149c90f2df5f)
		{
			static char funcname[] = "tTJSVariantOctet * tTJSVariant::AsOctetNoAddRef() const";
			TVPImportFuncPtraa6f132b2031c83062f6149c90f2df5f = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariantOctet *(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtraa6f132b2031c83062f6149c90f2df5f))(this);
	}

	tTVInteger AsInteger() const
	{
		if(!TVPImportFuncPtrb52f446e22bb92d495f7e65ac71c9bf9)
		{
			static char funcname[] = "tTVInteger tTJSVariant::AsInteger() const";
			TVPImportFuncPtrb52f446e22bb92d495f7e65ac71c9bf9 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTVInteger(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtrb52f446e22bb92d495f7e65ac71c9bf9))(this);
	}

	void AsNumber(tTJSVariant & targ) const
	{
		if(!TVPImportFuncPtrd4899fd4a8beb06f192dcb1d300e3319)
		{
			static char funcname[] = "void tTJSVariant::AsNumber(tTJSVariant &) const";
			TVPImportFuncPtrd4899fd4a8beb06f192dcb1d300e3319 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(const tTJSVariant *, tTJSVariant &);
		((__functype)(TVPImportFuncPtrd4899fd4a8beb06f192dcb1d300e3319))(this, targ);
	}

	operator tTVInteger() const
	{
		if(!TVPImportFuncPtrd3f5ec78464d29ee6988a1f90c2e3e1b)
		{
			static char funcname[] = "tTJSVariant::operator tTVInteger() const";
			TVPImportFuncPtrd3f5ec78464d29ee6988a1f90c2e3e1b = TVPGetImportFuncPtr(funcname);
		}
		typedef tTVInteger(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtrd3f5ec78464d29ee6988a1f90c2e3e1b))(this);
	}

	operator bool() const
	{
		if(!TVPImportFuncPtra463ad6a757c3f04e09a72e288737d06)
		{
			static char funcname[] = "tTJSVariant::operator bool() const";
			TVPImportFuncPtra463ad6a757c3f04e09a72e288737d06 = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtra463ad6a757c3f04e09a72e288737d06))(this);
	}

	operator tjs_int() const
	{
		if(!TVPImportFuncPtr27857bb89d35113183b682c3917d6c7a)
		{
			static char funcname[] = "tTJSVariant::operator tjs_int() const";
			TVPImportFuncPtr27857bb89d35113183b682c3917d6c7a = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_int(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr27857bb89d35113183b682c3917d6c7a))(this);
	}

	tTVReal AsReal() const
	{
		if(!TVPImportFuncPtra5f80951cfb882ac6a3e06c0b9a95807)
		{
			static char funcname[] = "tTVReal tTJSVariant::AsReal() const";
			TVPImportFuncPtra5f80951cfb882ac6a3e06c0b9a95807 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTVReal(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtra5f80951cfb882ac6a3e06c0b9a95807))(this);
	}

	operator tTVReal() const
	{
		if(!TVPImportFuncPtr35aadb63079c8bd84ebc0389bae306e0)
		{
			static char funcname[] = "tTJSVariant::operator tTVReal() const";
			TVPImportFuncPtr35aadb63079c8bd84ebc0389bae306e0 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTVReal(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr35aadb63079c8bd84ebc0389bae306e0))(this);
	}

	tTJSVariant operator ||(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtrfb6573df5887c2020ae58136f8342ed4)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator ||(const tTJSVariant &) const";
			TVPImportFuncPtrfb6573df5887c2020ae58136f8342ed4 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtrfb6573df5887c2020ae58136f8342ed4))(this, rhs);
	}

	tTJSVariant operator &&(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr86c67d2197c46824ab10f59e568ad13a)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator &&(const tTJSVariant &) const";
			TVPImportFuncPtr86c67d2197c46824ab10f59e568ad13a = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr86c67d2197c46824ab10f59e568ad13a))(this, rhs);
	}

	tTJSVariant operator |(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr263a0c5b335b2c4d5bc1f55b51b8315e)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator |(const tTJSVariant &) const";
			TVPImportFuncPtr263a0c5b335b2c4d5bc1f55b51b8315e = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr263a0c5b335b2c4d5bc1f55b51b8315e))(this, rhs);
	}

	tTJSVariant operator ^(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr975c1099e57ab67122ddef0f44fd7dd5)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator ^(const tTJSVariant &) const";
			TVPImportFuncPtr975c1099e57ab67122ddef0f44fd7dd5 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr975c1099e57ab67122ddef0f44fd7dd5))(this, rhs);
	}

	tTJSVariant operator &(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr04493e5237a7ca97afd391cb7e831ba0)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator &(const tTJSVariant &) const";
			TVPImportFuncPtr04493e5237a7ca97afd391cb7e831ba0 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr04493e5237a7ca97afd391cb7e831ba0))(this, rhs);
	}

	tTJSVariant operator !=(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr9996100acc7705cb2b0c904d6bad4401)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator !=(const tTJSVariant &) const";
			TVPImportFuncPtr9996100acc7705cb2b0c904d6bad4401 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr9996100acc7705cb2b0c904d6bad4401))(this, rhs);
	}

	tTJSVariant operator ==(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr5d91cff3b2a26ff7c0543e0f6d737117)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator ==(const tTJSVariant &) const";
			TVPImportFuncPtr5d91cff3b2a26ff7c0543e0f6d737117 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr5d91cff3b2a26ff7c0543e0f6d737117))(this, rhs);
	}

	tTJSVariant operator <(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtref1dedc2cb58dc4e1afc14238b6fc518)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator <(const tTJSVariant &) const";
			TVPImportFuncPtref1dedc2cb58dc4e1afc14238b6fc518 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtref1dedc2cb58dc4e1afc14238b6fc518))(this, rhs);
	}

	tTJSVariant operator >(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtrf18397fe81c043ba2346e31b359f6a73)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator >(const tTJSVariant &) const";
			TVPImportFuncPtrf18397fe81c043ba2346e31b359f6a73 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtrf18397fe81c043ba2346e31b359f6a73))(this, rhs);
	}

	tTJSVariant operator <=(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr2ee45ad60b0c06a8d0feebc3a6aad9e7)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator <=(const tTJSVariant &) const";
			TVPImportFuncPtr2ee45ad60b0c06a8d0feebc3a6aad9e7 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr2ee45ad60b0c06a8d0feebc3a6aad9e7))(this, rhs);
	}

	tTJSVariant operator >=(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr44500491c57e17032951fe6ed268ff1d)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator >=(const tTJSVariant &) const";
			TVPImportFuncPtr44500491c57e17032951fe6ed268ff1d = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr44500491c57e17032951fe6ed268ff1d))(this, rhs);
	}

	tTJSVariant operator >>(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr056f5d278c75750df792bf8b081fbf7d)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator >>(const tTJSVariant &) const";
			TVPImportFuncPtr056f5d278c75750df792bf8b081fbf7d = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr056f5d278c75750df792bf8b081fbf7d))(this, rhs);
	}

	tTJSVariant rbitshift(tjs_int count) const
	{
		if(!TVPImportFuncPtr04233bc4f7d4df92c260d23110320afe)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::rbitshift(tjs_int) const";
			TVPImportFuncPtr04233bc4f7d4df92c260d23110320afe = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, tjs_int);
		return ((__functype)(TVPImportFuncPtr04233bc4f7d4df92c260d23110320afe))(this, count);
	}

	tTJSVariant operator <<(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtrcdc475c4419e77c22508e337428c4074)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator <<(const tTJSVariant &) const";
			TVPImportFuncPtrcdc475c4419e77c22508e337428c4074 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtrcdc475c4419e77c22508e337428c4074))(this, rhs);
	}

	tTJSVariant operator %(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr06bacb2910308a47bbe27ff7efa1226d)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator %(const tTJSVariant &) const";
			TVPImportFuncPtr06bacb2910308a47bbe27ff7efa1226d = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr06bacb2910308a47bbe27ff7efa1226d))(this, rhs);
	}

	tTJSVariant operator /(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr521e053199a4aeb4e0f24d9f4a6cc682)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator /(const tTJSVariant &) const";
			TVPImportFuncPtr521e053199a4aeb4e0f24d9f4a6cc682 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr521e053199a4aeb4e0f24d9f4a6cc682))(this, rhs);
	}

	tTJSVariant idiv(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr02164e6fb4c925843ac774ec1e4c6e5d)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::idiv(const tTJSVariant &) const";
			TVPImportFuncPtr02164e6fb4c925843ac774ec1e4c6e5d = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr02164e6fb4c925843ac774ec1e4c6e5d))(this, rhs);
	}

	tTJSVariant operator *(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr5110cbbcddbd9688281ee5418e3f9023)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator *(const tTJSVariant &) const";
			TVPImportFuncPtr5110cbbcddbd9688281ee5418e3f9023 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr5110cbbcddbd9688281ee5418e3f9023))(this, rhs);
	}

	tTJSVariant operator !() const
	{
		if(!TVPImportFuncPtr1db54b61f00bf931452218c4a39e79ef)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator !() const";
			TVPImportFuncPtr1db54b61f00bf931452218c4a39e79ef = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr1db54b61f00bf931452218c4a39e79ef))(this);
	}

	tTJSVariant operator ~() const
	{
		if(!TVPImportFuncPtr9d0edd8f51f155767301017bd3d256da)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator ~() const";
			TVPImportFuncPtr9d0edd8f51f155767301017bd3d256da = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr9d0edd8f51f155767301017bd3d256da))(this);
	}

	tTJSVariant operator -(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr8f744c5aa8df5471939b960bc759f12b)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator -(const tTJSVariant &) const";
			TVPImportFuncPtr8f744c5aa8df5471939b960bc759f12b = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr8f744c5aa8df5471939b960bc759f12b))(this, rhs);
	}

	tTJSVariant operator +() const
	{
		if(!TVPImportFuncPtrba7ff7b0b4192bd2cc7f49c7b688ad57)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator +() const";
			TVPImportFuncPtrba7ff7b0b4192bd2cc7f49c7b688ad57 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtrba7ff7b0b4192bd2cc7f49c7b688ad57))(this);
	}

	tTJSVariant operator -() const
	{
		if(!TVPImportFuncPtr7773ac921bb82c85de3be69ef86265fd)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator -() const";
			TVPImportFuncPtr7773ac921bb82c85de3be69ef86265fd = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *);
		return ((__functype)(TVPImportFuncPtr7773ac921bb82c85de3be69ef86265fd))(this);
	}

	tTJSVariant operator +(const tTJSVariant & rhs) const
	{
		if(!TVPImportFuncPtr114a781ed71edace31abb352a2671f41)
		{
			static char funcname[] = "tTJSVariant tTJSVariant::operator +(const tTJSVariant &) const";
			TVPImportFuncPtr114a781ed71edace31abb352a2671f41 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariant(__stdcall * __functype)(const tTJSVariant *, const tTJSVariant &);
		return ((__functype)(TVPImportFuncPtr114a781ed71edace31abb352a2671f41))(this, rhs);
	}

	static void * operator new(size_t size)
	{
		if(!TVPImportFuncPtr2bc5f4a97decfa82c625430479ec512b)
		{
			static char funcname[] = "void * tTJSVariant::operator new(size_t)";
			TVPImportFuncPtr2bc5f4a97decfa82c625430479ec512b = TVPGetImportFuncPtr(funcname);
		}
		typedef void *(__stdcall * __functype)(size_t);
		return ((__functype)(TVPImportFuncPtr2bc5f4a97decfa82c625430479ec512b))(size);
	}

	static void operator delete(void * p)
	{
		if(!TVPImportFuncPtr066fb79f94523d95d12480f23c58cc8e)
		{
			static char funcname[] = "void tTJSVariant::operator delete(void *)";
			TVPImportFuncPtr066fb79f94523d95d12480f23c58cc8e = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(void *);
		((__functype)(TVPImportFuncPtr066fb79f94523d95d12480f23c58cc8e))(p);
	}

	static void * operator new [](size_t size)
	{
		if(!TVPImportFuncPtr803906b8de16ff825d4e69e1952d872f)
		{
			static char funcname[] = "void * tTJSVariant::operator new [](size_t)";
			TVPImportFuncPtr803906b8de16ff825d4e69e1952d872f = TVPGetImportFuncPtr(funcname);
		}
		typedef void *(__stdcall * __functype)(size_t);
		return ((__functype)(TVPImportFuncPtr803906b8de16ff825d4e69e1952d872f))(size);
	}

	static void operator delete [](void * p)
	{
		if(!TVPImportFuncPtr34cc96a5118ee1e12b0750ea64d40b1f)
		{
			static char funcname[] = "void tTJSVariant::operator delete [](void *)";
			TVPImportFuncPtr34cc96a5118ee1e12b0750ea64d40b1f = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(void *);
		((__functype)(TVPImportFuncPtr34cc96a5118ee1e12b0750ea64d40b1f))(p);
	}

	static void * operator new(size_t size , void * buf)
	{
		if(!TVPImportFuncPtrdbe821fb8b651d42a9c8e730517c408c)
		{
			static char funcname[] = "void * tTJSVariant::operator new(size_t,void *)";
			TVPImportFuncPtrdbe821fb8b651d42a9c8e730517c408c = TVPGetImportFuncPtr(funcname);
		}
		typedef void *(__stdcall * __functype)(size_t , void *);
		return ((__functype)(TVPImportFuncPtrdbe821fb8b651d42a9c8e730517c408c))(size, buf);
	}

};
//---------------------------------------------------------------------------
// tTJSString
//---------------------------------------------------------------------------

class tTJSString : protected tTJSString_S
{

public:
	tTJSString()
	{
		if(!TVPImportFuncPtrd83a866389246d824efcc83303a04484)
		{
			static char funcname[] = "tTJSString::tTJSString()";
			TVPImportFuncPtrd83a866389246d824efcc83303a04484 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *);
		((__functype)(TVPImportFuncPtrd83a866389246d824efcc83303a04484))(this);
	}

	tTJSString(const tTJSString & rhs)
	{
		if(!TVPImportFuncPtr6cf6f332a6a14a15e8dce62301f5c840)
		{
			static char funcname[] = "tTJSString::tTJSString(const tTJSString &)";
			TVPImportFuncPtr6cf6f332a6a14a15e8dce62301f5c840 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, const tTJSString &);
		((__functype)(TVPImportFuncPtr6cf6f332a6a14a15e8dce62301f5c840))(this, rhs);
	}

	tTJSString(tTJSVariantString * vstr)
	{
		if(!TVPImportFuncPtr566eeea3c5f009b0fc6fa123ba30f496)
		{
			static char funcname[] = "tTJSString::tTJSString(tTJSVariantString *)";
			TVPImportFuncPtr566eeea3c5f009b0fc6fa123ba30f496 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, tTJSVariantString *);
		((__functype)(TVPImportFuncPtr566eeea3c5f009b0fc6fa123ba30f496))(this, vstr);
	}

	tTJSString(const tjs_char * str)
	{
		if(!TVPImportFuncPtr88806e38e35c73b36acadd4061a4fe0b)
		{
			static char funcname[] = "tTJSString::tTJSString(const tjs_char *)";
			TVPImportFuncPtr88806e38e35c73b36acadd4061a4fe0b = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, const tjs_char *);
		((__functype)(TVPImportFuncPtr88806e38e35c73b36acadd4061a4fe0b))(this, str);
	}

	tTJSString(const tjs_nchar * str)
	{
		if(!TVPImportFuncPtr3bb69d3886159aaecc333b6ff17287bf)
		{
			static char funcname[] = "tTJSString::tTJSString(const tjs_nchar *)";
			TVPImportFuncPtr3bb69d3886159aaecc333b6ff17287bf = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, const tjs_nchar *);
		((__functype)(TVPImportFuncPtr3bb69d3886159aaecc333b6ff17287bf))(this, str);
	}

	tTJSString(const tTJSStringBufferLength len)
	{
		if(!TVPImportFuncPtr3e36278551a9c8b29cb2e8017db6af0d)
		{
			static char funcname[] = "tTJSString::tTJSString(const tTJSStringBufferLength)";
			TVPImportFuncPtr3e36278551a9c8b29cb2e8017db6af0d = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, const tTJSStringBufferLength);
		((__functype)(TVPImportFuncPtr3e36278551a9c8b29cb2e8017db6af0d))(this, len);
	}

	tTJSString(tjs_char rch)
	{
		if(!TVPImportFuncPtr5de99d84f3dc902cb0812fb85a7d5c88)
		{
			static char funcname[] = "tTJSString::tTJSString(tjs_char)";
			TVPImportFuncPtr5de99d84f3dc902cb0812fb85a7d5c88 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, tjs_char);
		((__functype)(TVPImportFuncPtr5de99d84f3dc902cb0812fb85a7d5c88))(this, rch);
	}

	tTJSString(const tTJSVariant & val)
	{
		if(!TVPImportFuncPtr31e85cbc73f8fbd4cea895a751480059)
		{
			static char funcname[] = "tTJSString::tTJSString(const tTJSVariant &)";
			TVPImportFuncPtr31e85cbc73f8fbd4cea895a751480059 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, const tTJSVariant &);
		((__functype)(TVPImportFuncPtr31e85cbc73f8fbd4cea895a751480059))(this, val);
	}

	tTJSString(const tTJSString & str , int n)
	{
		if(!TVPImportFuncPtr6ae29e405ede762f1a89a9dd526cb36e)
		{
			static char funcname[] = "tTJSString::tTJSString(const tTJSString &,int)";
			TVPImportFuncPtr6ae29e405ede762f1a89a9dd526cb36e = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, const tTJSString &, int);
		((__functype)(TVPImportFuncPtr6ae29e405ede762f1a89a9dd526cb36e))(this, str, n);
	}

	tTJSString(const tjs_char * str , int n)
	{
		if(!TVPImportFuncPtrc95bd66d95c153cdac41b5243e555f5f)
		{
			static char funcname[] = "tTJSString::tTJSString(const tjs_char *,int)";
			TVPImportFuncPtrc95bd66d95c153cdac41b5243e555f5f = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, const tjs_char *, int);
		((__functype)(TVPImportFuncPtrc95bd66d95c153cdac41b5243e555f5f))(this, str, n);
	}

	tTJSString(tjs_int n)
	{
		if(!TVPImportFuncPtr72a67e9c52fd27dbb66eded47efeea74)
		{
			static char funcname[] = "tTJSString::tTJSString(tjs_int)";
			TVPImportFuncPtr72a67e9c52fd27dbb66eded47efeea74 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, tjs_int);
		((__functype)(TVPImportFuncPtr72a67e9c52fd27dbb66eded47efeea74))(this, n);
	}

	~ tTJSString()
	{
		if(!TVPImportFuncPtrfb13e41bda53e4e59403e3e14effccd6)
		{
			static char funcname[] = "tTJSString::~ tTJSString()";
			TVPImportFuncPtrfb13e41bda53e4e59403e3e14effccd6 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *);
		((__functype)(TVPImportFuncPtrfb13e41bda53e4e59403e3e14effccd6))(this);
	}

	tTJSString & operator =(const tTJSString & rhs)
	{
		if(!TVPImportFuncPtr9a5c710e620e47f105752453ad5d6ab1)
		{
			static char funcname[] = "tTJSString & tTJSString::operator =(const tTJSString &)";
			TVPImportFuncPtr9a5c710e620e47f105752453ad5d6ab1 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSString &(__stdcall * __functype)(tTJSString *, const tTJSString &);
		return ((__functype)(TVPImportFuncPtr9a5c710e620e47f105752453ad5d6ab1))(this, rhs);
	}

	tTJSString & operator =(const tjs_char * rhs)
	{
		if(!TVPImportFuncPtr18f1ad16c11429707cbf8ea4d1d4a21e)
		{
			static char funcname[] = "tTJSString & tTJSString::operator =(const tjs_char *)";
			TVPImportFuncPtr18f1ad16c11429707cbf8ea4d1d4a21e = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSString &(__stdcall * __functype)(tTJSString *, const tjs_char *);
		return ((__functype)(TVPImportFuncPtr18f1ad16c11429707cbf8ea4d1d4a21e))(this, rhs);
	}

	tTJSString & operator =(const tjs_nchar * rhs)
	{
		if(!TVPImportFuncPtr550f317b573a1256af00586890ae82f1)
		{
			static char funcname[] = "tTJSString & tTJSString::operator =(const tjs_nchar *)";
			TVPImportFuncPtr550f317b573a1256af00586890ae82f1 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSString &(__stdcall * __functype)(tTJSString *, const tjs_nchar *);
		return ((__functype)(TVPImportFuncPtr550f317b573a1256af00586890ae82f1))(this, rhs);
	}

	void operator +=(const tTJSString & ref)
	{
		if(!TVPImportFuncPtrcd50da721dfb63f36c1ebb1226830428)
		{
			static char funcname[] = "void tTJSString::operator +=(const tTJSString &)";
			TVPImportFuncPtrcd50da721dfb63f36c1ebb1226830428 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, const tTJSString &);
		((__functype)(TVPImportFuncPtrcd50da721dfb63f36c1ebb1226830428))(this, ref);
	}

	void operator +=(const tTJSVariantString * ref)
	{
		if(!TVPImportFuncPtrfbba3dd6a087599d1277ae58f6cec18e)
		{
			static char funcname[] = "void tTJSString::operator +=(const tTJSVariantString *)";
			TVPImportFuncPtrfbba3dd6a087599d1277ae58f6cec18e = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, const tTJSVariantString *);
		((__functype)(TVPImportFuncPtrfbba3dd6a087599d1277ae58f6cec18e))(this, ref);
	}

	void operator +=(const tjs_char * ref)
	{
		if(!TVPImportFuncPtr43cc5b5a61a6090af83333d115b5b868)
		{
			static char funcname[] = "void tTJSString::operator +=(const tjs_char *)";
			TVPImportFuncPtr43cc5b5a61a6090af83333d115b5b868 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, const tjs_char *);
		((__functype)(TVPImportFuncPtr43cc5b5a61a6090af83333d115b5b868))(this, ref);
	}

	void operator +=(tjs_char rch)
	{
		if(!TVPImportFuncPtr616fb5060d81eb5bab58647596582df4)
		{
			static char funcname[] = "void tTJSString::operator +=(tjs_char)";
			TVPImportFuncPtr616fb5060d81eb5bab58647596582df4 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, tjs_char);
		((__functype)(TVPImportFuncPtr616fb5060d81eb5bab58647596582df4))(this, rch);
	}

	void Clear()
	{
		if(!TVPImportFuncPtr168cf4c1b9ef70b98f2e0ab3695a4f3b)
		{
			static char funcname[] = "void tTJSString::Clear()";
			TVPImportFuncPtr168cf4c1b9ef70b98f2e0ab3695a4f3b = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *);
		((__functype)(TVPImportFuncPtr168cf4c1b9ef70b98f2e0ab3695a4f3b))(this);
	}

	tjs_char * AllocBuffer(tjs_uint len)
	{
		if(!TVPImportFuncPtr314573cca30a7c2aecc9166fbf5400c9)
		{
			static char funcname[] = "tjs_char * tTJSString::AllocBuffer(tjs_uint)";
			TVPImportFuncPtr314573cca30a7c2aecc9166fbf5400c9 = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_char *(__stdcall * __functype)(tTJSString *, tjs_uint);
		return ((__functype)(TVPImportFuncPtr314573cca30a7c2aecc9166fbf5400c9))(this, len);
	}

	tjs_char * AppendBuffer(tjs_uint len)
	{
		if(!TVPImportFuncPtr03da356426c038fad663c836c3e330ef)
		{
			static char funcname[] = "tjs_char * tTJSString::AppendBuffer(tjs_uint)";
			TVPImportFuncPtr03da356426c038fad663c836c3e330ef = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_char *(__stdcall * __functype)(tTJSString *, tjs_uint);
		return ((__functype)(TVPImportFuncPtr03da356426c038fad663c836c3e330ef))(this, len);
	}

	void FixLen()
	{
		if(!TVPImportFuncPtr31dbebdedc08d75e34a2cd564ce60586)
		{
			static char funcname[] = "void tTJSString::FixLen()";
			TVPImportFuncPtr31dbebdedc08d75e34a2cd564ce60586 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *);
		((__functype)(TVPImportFuncPtr31dbebdedc08d75e34a2cd564ce60586))(this);
	}

	void Replace(const tTJSString & from , const tTJSString & to , bool forall = true)
	{
		if(!TVPImportFuncPtrd9224ad7a0de743a7eea15fdb2c5f934)
		{
			static char funcname[] = "void tTJSString::Replace(const tTJSString &,const tTJSString &,bool)";
			TVPImportFuncPtrd9224ad7a0de743a7eea15fdb2c5f934 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *, const tTJSString &, const tTJSString &, bool);
		((__functype)(TVPImportFuncPtrd9224ad7a0de743a7eea15fdb2c5f934))(this, from, to, forall);
	}

	void ToLowerCase()
	{
		if(!TVPImportFuncPtrc01b0720b49ce4f792446d8965d2c31f)
		{
			static char funcname[] = "void tTJSString::ToLowerCase()";
			TVPImportFuncPtrc01b0720b49ce4f792446d8965d2c31f = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *);
		((__functype)(TVPImportFuncPtrc01b0720b49ce4f792446d8965d2c31f))(this);
	}

	void ToUppserCase()
	{
		if(!TVPImportFuncPtr4af47e46a11e1357cb994f405289d13e)
		{
			static char funcname[] = "void tTJSString::ToUppserCase()";
			TVPImportFuncPtr4af47e46a11e1357cb994f405289d13e = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(tTJSString *);
		((__functype)(TVPImportFuncPtr4af47e46a11e1357cb994f405289d13e))(this);
	}

	tjs_uint32 * GetHint()
	{
		if(!TVPImportFuncPtr25b6dafa19bfa5bde1a8b519da248f82)
		{
			static char funcname[] = "tjs_uint32 * tTJSString::GetHint()";
			TVPImportFuncPtr25b6dafa19bfa5bde1a8b519da248f82 = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_uint32 *(__stdcall * __functype)(tTJSString *);
		return ((__functype)(TVPImportFuncPtr25b6dafa19bfa5bde1a8b519da248f82))(this);
	}

	tjs_char * Independ()
	{
		if(!TVPImportFuncPtr72425405819c900aec719491cbd90c6d)
		{
			static char funcname[] = "tjs_char * tTJSString::Independ()";
			TVPImportFuncPtr72425405819c900aec719491cbd90c6d = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_char *(__stdcall * __functype)(tTJSString *);
		return ((__functype)(TVPImportFuncPtr72425405819c900aec719491cbd90c6d))(this);
	}

	const tjs_char * c_str() const
	{
		if(!TVPImportFuncPtra79942af73f33bff6e432c9fd808e469)
		{
			static char funcname[] = "const tjs_char * tTJSString::c_str() const";
			TVPImportFuncPtra79942af73f33bff6e432c9fd808e469 = TVPGetImportFuncPtr(funcname);
		}
		typedef const tjs_char *(__stdcall * __functype)(const tTJSString *);
		return ((__functype)(TVPImportFuncPtra79942af73f33bff6e432c9fd808e469))(this);
	}

	tTJSVariantString * AsVariantStringNoAddRef() const
	{
		if(!TVPImportFuncPtrdf106470a4141ebc7eda22160859ffdc)
		{
			static char funcname[] = "tTJSVariantString * tTJSString::AsVariantStringNoAddRef() const";
			TVPImportFuncPtrdf106470a4141ebc7eda22160859ffdc = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSVariantString *(__stdcall * __functype)(const tTJSString *);
		return ((__functype)(TVPImportFuncPtrdf106470a4141ebc7eda22160859ffdc))(this);
	}

	tjs_int64 AsInteger() const
	{
		if(!TVPImportFuncPtr469bc225b0ecd9561aae5a46b85ded42)
		{
			static char funcname[] = "tjs_int64 tTJSString::AsInteger() const";
			TVPImportFuncPtr469bc225b0ecd9561aae5a46b85ded42 = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_int64(__stdcall * __functype)(const tTJSString *);
		return ((__functype)(TVPImportFuncPtr469bc225b0ecd9561aae5a46b85ded42))(this);
	}

	bool operator ==(const tTJSString & ref) const
	{
		if(!TVPImportFuncPtra6663c078b3aa79b39ee2d09f3875765)
		{
			static char funcname[] = "bool tTJSString::operator ==(const tTJSString &) const";
			TVPImportFuncPtra6663c078b3aa79b39ee2d09f3875765 = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSString *, const tTJSString &);
		return ((__functype)(TVPImportFuncPtra6663c078b3aa79b39ee2d09f3875765))(this, ref);
	}

	bool operator !=(const tTJSString & ref) const
	{
		if(!TVPImportFuncPtrefbe634ce4f13633e220cae167cf63fb)
		{
			static char funcname[] = "bool tTJSString::operator !=(const tTJSString &) const";
			TVPImportFuncPtrefbe634ce4f13633e220cae167cf63fb = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSString *, const tTJSString &);
		return ((__functype)(TVPImportFuncPtrefbe634ce4f13633e220cae167cf63fb))(this, ref);
	}

	tjs_int CompareIC(const tTJSString & ref) const
	{
		if(!TVPImportFuncPtr57f4147bcc09e4e4442ffc9b0895727e)
		{
			static char funcname[] = "tjs_int tTJSString::CompareIC(const tTJSString &) const";
			TVPImportFuncPtr57f4147bcc09e4e4442ffc9b0895727e = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_int(__stdcall * __functype)(const tTJSString *, const tTJSString &);
		return ((__functype)(TVPImportFuncPtr57f4147bcc09e4e4442ffc9b0895727e))(this, ref);
	}

	bool operator ==(const tjs_char * ref) const
	{
		if(!TVPImportFuncPtr1fb2d2e44cf83aebef7b26fd6b20bc2b)
		{
			static char funcname[] = "bool tTJSString::operator ==(const tjs_char *) const";
			TVPImportFuncPtr1fb2d2e44cf83aebef7b26fd6b20bc2b = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSString *, const tjs_char *);
		return ((__functype)(TVPImportFuncPtr1fb2d2e44cf83aebef7b26fd6b20bc2b))(this, ref);
	}

	bool operator !=(const tjs_char * ref) const
	{
		if(!TVPImportFuncPtrbd6aa777bac947f5cffd891e9c724794)
		{
			static char funcname[] = "bool tTJSString::operator !=(const tjs_char *) const";
			TVPImportFuncPtrbd6aa777bac947f5cffd891e9c724794 = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSString *, const tjs_char *);
		return ((__functype)(TVPImportFuncPtrbd6aa777bac947f5cffd891e9c724794))(this, ref);
	}

	tjs_int CompareIC(const tjs_char * ref) const
	{
		if(!TVPImportFuncPtr83c662330b75d616cdc8a4e11d7ababa)
		{
			static char funcname[] = "tjs_int tTJSString::CompareIC(const tjs_char *) const";
			TVPImportFuncPtr83c662330b75d616cdc8a4e11d7ababa = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_int(__stdcall * __functype)(const tTJSString *, const tjs_char *);
		return ((__functype)(TVPImportFuncPtr83c662330b75d616cdc8a4e11d7ababa))(this, ref);
	}

	bool operator <(const tTJSString & ref) const
	{
		if(!TVPImportFuncPtrbbde02fe30c8a6cadb7073174ea3a874)
		{
			static char funcname[] = "bool tTJSString::operator <(const tTJSString &) const";
			TVPImportFuncPtrbbde02fe30c8a6cadb7073174ea3a874 = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSString *, const tTJSString &);
		return ((__functype)(TVPImportFuncPtrbbde02fe30c8a6cadb7073174ea3a874))(this, ref);
	}

	bool operator >(const tTJSString & ref) const
	{
		if(!TVPImportFuncPtrcc1c14f63867f90bc883de03e9212cbc)
		{
			static char funcname[] = "bool tTJSString::operator >(const tTJSString &) const";
			TVPImportFuncPtrcc1c14f63867f90bc883de03e9212cbc = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSString *, const tTJSString &);
		return ((__functype)(TVPImportFuncPtrcc1c14f63867f90bc883de03e9212cbc))(this, ref);
	}

	tTJSString operator +(const tTJSString & ref) const
	{
		if(!TVPImportFuncPtr236e007b32bc2631b5f6dc1eda6be0a9)
		{
			static char funcname[] = "tTJSString tTJSString::operator +(const tTJSString &) const";
			TVPImportFuncPtr236e007b32bc2631b5f6dc1eda6be0a9 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSString(__stdcall * __functype)(const tTJSString *, const tTJSString &);
		return ((__functype)(TVPImportFuncPtr236e007b32bc2631b5f6dc1eda6be0a9))(this, ref);
	}

	tTJSString operator +(const tjs_char * ref) const
	{
		if(!TVPImportFuncPtrcfbb9809e0e6d954b2652856e935ced9)
		{
			static char funcname[] = "tTJSString tTJSString::operator +(const tjs_char *) const";
			TVPImportFuncPtrcfbb9809e0e6d954b2652856e935ced9 = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSString(__stdcall * __functype)(const tTJSString *, const tjs_char *);
		return ((__functype)(TVPImportFuncPtrcfbb9809e0e6d954b2652856e935ced9))(this, ref);
	}

	tTJSString operator +(tjs_char rch) const
	{
		if(!TVPImportFuncPtr60ee96ae4a7704340bef20fb35ba6ade)
		{
			static char funcname[] = "tTJSString tTJSString::operator +(tjs_char) const";
			TVPImportFuncPtr60ee96ae4a7704340bef20fb35ba6ade = TVPGetImportFuncPtr(funcname);
		}
		typedef tTJSString(__stdcall * __functype)(const tTJSString *, tjs_char);
		return ((__functype)(TVPImportFuncPtr60ee96ae4a7704340bef20fb35ba6ade))(this, rch);
	}

	tjs_char operator [](tjs_uint i) const
	{
		if(!TVPImportFuncPtr564b37278b50f4e5597dff6540868d49)
		{
			static char funcname[] = "tjs_char tTJSString::operator [](tjs_uint) const";
			TVPImportFuncPtr564b37278b50f4e5597dff6540868d49 = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_char(__stdcall * __functype)(const tTJSString *, tjs_uint);
		return ((__functype)(TVPImportFuncPtr564b37278b50f4e5597dff6540868d49))(this, i);
	}

	void AsLowerCase(tTJSString & dest) const
	{
		if(!TVPImportFuncPtr890b3a4831b824653e919b4a5197358d)
		{
			static char funcname[] = "void tTJSString::AsLowerCase(tTJSString &) const";
			TVPImportFuncPtr890b3a4831b824653e919b4a5197358d = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(const tTJSString *, tTJSString &);
		((__functype)(TVPImportFuncPtr890b3a4831b824653e919b4a5197358d))(this, dest);
	}

	void AsUpperCase(tTJSString & dest) const
	{
		if(!TVPImportFuncPtr2dfa6c77c5051d160b8a06f540e0d68b)
		{
			static char funcname[] = "void tTJSString::AsUpperCase(tTJSString &) const";
			TVPImportFuncPtr2dfa6c77c5051d160b8a06f540e0d68b = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(const tTJSString *, tTJSString &);
		((__functype)(TVPImportFuncPtr2dfa6c77c5051d160b8a06f540e0d68b))(this, dest);
	}

	void EscapeC(tTJSString & dest) const
	{
		if(!TVPImportFuncPtr05f88567d510fd84659ccbf493f647ed)
		{
			static char funcname[] = "void tTJSString::EscapeC(tTJSString &) const";
			TVPImportFuncPtr05f88567d510fd84659ccbf493f647ed = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(const tTJSString *, tTJSString &);
		((__functype)(TVPImportFuncPtr05f88567d510fd84659ccbf493f647ed))(this, dest);
	}

	void UnescapeC(tTJSString & dest) const
	{
		if(!TVPImportFuncPtr7166b8f7bb9688c980e4fa172f06f30c)
		{
			static char funcname[] = "void tTJSString::UnescapeC(tTJSString &) const";
			TVPImportFuncPtr7166b8f7bb9688c980e4fa172f06f30c = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(const tTJSString *, tTJSString &);
		((__functype)(TVPImportFuncPtr7166b8f7bb9688c980e4fa172f06f30c))(this, dest);
	}

	bool StartsWith(const tjs_char * string) const
	{
		if(!TVPImportFuncPtrb9456ecba8b7898d80d2e5caa64035c9)
		{
			static char funcname[] = "bool tTJSString::StartsWith(const tjs_char *) const";
			TVPImportFuncPtrb9456ecba8b7898d80d2e5caa64035c9 = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSString *, const tjs_char *);
		return ((__functype)(TVPImportFuncPtrb9456ecba8b7898d80d2e5caa64035c9))(this, string);
	}

	bool StartsWith(const tTJSString & string) const
	{
		if(!TVPImportFuncPtrdd44464bd8430a5be5fef0cffcd97117)
		{
			static char funcname[] = "bool tTJSString::StartsWith(const tTJSString &) const";
			TVPImportFuncPtrdd44464bd8430a5be5fef0cffcd97117 = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSString *, const tTJSString &);
		return ((__functype)(TVPImportFuncPtrdd44464bd8430a5be5fef0cffcd97117))(this, string);
	}

	tjs_int GetNarrowStrLen() const
	{
		if(!TVPImportFuncPtra57696ca0c157cd7d3cd4e58c1df957c)
		{
			static char funcname[] = "tjs_int tTJSString::GetNarrowStrLen() const";
			TVPImportFuncPtra57696ca0c157cd7d3cd4e58c1df957c = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_int(__stdcall * __functype)(const tTJSString *);
		return ((__functype)(TVPImportFuncPtra57696ca0c157cd7d3cd4e58c1df957c))(this);
	}

	void ToNarrowStr(tjs_nchar * dest , tjs_int destmaxlen) const
	{
		if(!TVPImportFuncPtr1aea9f8a38bbb875b6d052f330da9178)
		{
			static char funcname[] = "void tTJSString::ToNarrowStr(tjs_nchar *,tjs_int) const";
			TVPImportFuncPtr1aea9f8a38bbb875b6d052f330da9178 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(const tTJSString *, tjs_nchar *, tjs_int);
		((__functype)(TVPImportFuncPtr1aea9f8a38bbb875b6d052f330da9178))(this, dest, destmaxlen);
	}

	bool IsEmpty() const
	{
		if(!TVPImportFuncPtr2d3b3d6e22ee139cda9eee47dc031945)
		{
			static char funcname[] = "bool tTJSString::IsEmpty() const";
			TVPImportFuncPtr2d3b3d6e22ee139cda9eee47dc031945 = TVPGetImportFuncPtr(funcname);
		}
		typedef bool(__stdcall * __functype)(const tTJSString *);
		return ((__functype)(TVPImportFuncPtr2d3b3d6e22ee139cda9eee47dc031945))(this);
	}

	tjs_int GetLen() const
	{
		if(!TVPImportFuncPtr8ff49e56c3c4c566561dcdd5c9ecc4db)
		{
			static char funcname[] = "tjs_int tTJSString::GetLen() const";
			TVPImportFuncPtr8ff49e56c3c4c566561dcdd5c9ecc4db = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_int(__stdcall * __functype)(const tTJSString *);
		return ((__functype)(TVPImportFuncPtr8ff49e56c3c4c566561dcdd5c9ecc4db))(this);
	}

	tjs_int length() const
	{
		if(!TVPImportFuncPtr490b547e93e40082d0b83312467104f9)
		{
			static char funcname[] = "tjs_int tTJSString::length() const";
			TVPImportFuncPtr490b547e93e40082d0b83312467104f9 = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_int(__stdcall * __functype)(const tTJSString *);
		return ((__functype)(TVPImportFuncPtr490b547e93e40082d0b83312467104f9))(this);
	}

	tjs_char GetLastChar() const
	{
		if(!TVPImportFuncPtr2c1ef06748df47df52b586ac0fbc6a34)
		{
			static char funcname[] = "tjs_char tTJSString::GetLastChar() const";
			TVPImportFuncPtr2c1ef06748df47df52b586ac0fbc6a34 = TVPGetImportFuncPtr(funcname);
		}
		typedef tjs_char(__stdcall * __functype)(const tTJSString *);
		return ((__functype)(TVPImportFuncPtr2c1ef06748df47df52b586ac0fbc6a34))(this);
	}

	static void * operator new(size_t size)
	{
		if(!TVPImportFuncPtrb6b2a03160b88239eccd18d89b1537d3)
		{
			static char funcname[] = "void * tTJSString::operator new(size_t)";
			TVPImportFuncPtrb6b2a03160b88239eccd18d89b1537d3 = TVPGetImportFuncPtr(funcname);
		}
		typedef void *(__stdcall * __functype)(size_t);
		return ((__functype)(TVPImportFuncPtrb6b2a03160b88239eccd18d89b1537d3))(size);
	}

	static void operator delete(void * p)
	{
		if(!TVPImportFuncPtr8becefbd52c76c7ecb0ea7b7f50b7915)
		{
			static char funcname[] = "void tTJSString::operator delete(void *)";
			TVPImportFuncPtr8becefbd52c76c7ecb0ea7b7f50b7915 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(void *);
		((__functype)(TVPImportFuncPtr8becefbd52c76c7ecb0ea7b7f50b7915))(p);
	}

	static void * operator new [](size_t size)
	{
		if(!TVPImportFuncPtr74b9687a3bfd3b2c7abe226efc4225c1)
		{
			static char funcname[] = "void * tTJSString::operator new [](size_t)";
			TVPImportFuncPtr74b9687a3bfd3b2c7abe226efc4225c1 = TVPGetImportFuncPtr(funcname);
		}
		typedef void *(__stdcall * __functype)(size_t);
		return ((__functype)(TVPImportFuncPtr74b9687a3bfd3b2c7abe226efc4225c1))(size);
	}

	static void operator delete [](void * p)
	{
		if(!TVPImportFuncPtr7cafc2bf5965b594e60830e3057bbd58)
		{
			static char funcname[] = "void tTJSString::operator delete [](void *)";
			TVPImportFuncPtr7cafc2bf5965b594e60830e3057bbd58 = TVPGetImportFuncPtr(funcname);
		}
		typedef void(__stdcall * __functype)(void *);
		((__functype)(TVPImportFuncPtr7cafc2bf5965b594e60830e3057bbd58))(p);
	}

	static void * operator new(size_t size , void * buf)
	{
		if(!TVPImportFuncPtr80f111939c5694cbf43d07cf0ad1726c)
		{
			static char funcname[] = "void * tTJSString::operator new(size_t,void *)";
			TVPImportFuncPtr80f111939c5694cbf43d07cf0ad1726c = TVPGetImportFuncPtr(funcname);
		}
		typedef void *(__stdcall * __functype)(size_t , void *);
		return ((__functype)(TVPImportFuncPtr80f111939c5694cbf43d07cf0ad1726c))(size, buf);
	}

	
	friend tTJSString operator + (const tjs_char *lhs, const tTJSString &rhs);
	

};

//---------------------------------------------------------------------------
// stubs (misc)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// iTVPStorageMedia
//---------------------------------------------------------------------------
/*
	abstract class for managing media ( like file: http: etc.)
*/


	// for plug-in
class tTJSBinaryStream;


//---------------------------------------------------------------------------
class iTVPStorageLister // callback class for GetListAt
{
public:
	virtual void TJS_INTF_METHOD Add(const ttstr &file) = 0;
};
//---------------------------------------------------------------------------
class iTVPStorageMedia
{
public:
	virtual void TJS_INTF_METHOD AddRef() = 0;
	virtual void TJS_INTF_METHOD Release() = 0;

	virtual void TJS_INTF_METHOD GetName(ttstr &name) = 0;
		// returns media name like "file", "http" etc.

//	virtual bool TJS_INTF_METHOD IsCaseSensitive() = 0;
		// returns whether this media is case sensitive or not

	virtual void TJS_INTF_METHOD NormalizeDomainName(ttstr &name) = 0;
		// normalize domain name according with the media's rule

	virtual void TJS_INTF_METHOD NormalizePathName(ttstr &name) = 0;
		// normalize path name according with the media's rule

	// "name" below is normalized but does not contain media, eg.
	// not "media://domain/path" but "domain/path"

	virtual bool TJS_INTF_METHOD CheckExistentStorage(const ttstr &name) = 0;
		// check file existence

	virtual tTJSBinaryStream * TJS_INTF_METHOD Open(const ttstr & name, tjs_uint32 flags) = 0;
		// open a storage and return a tTJSBinaryStream instance.
		// name does not contain in-archive storage name but
		// is normalized.

	virtual void TJS_INTF_METHOD GetListAt(const ttstr &name, iTVPStorageLister * lister) = 0;
		// list files at given place

	virtual void TJS_INTF_METHOD GetLocallyAccessibleName(ttstr &name) = 0;
		// basically the same as above,
		// check wether given name is easily accessible from local OS filesystem.
		// if true, returns local OS native name. otherwise returns an empty string.
};
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Extraction filter related
//---------------------------------------------------------------------------
#pragma pack(push, 4)
struct tTVPXP3ExtractionFilterInfo
{
	const tjs_uint SizeOfSelf; // structure size of tTVPXP3ExtractionFilterInfo itself
	const tjs_uint64 Offset; // offset of the buffer data in uncompressed stream position
	void * Buffer; // target data buffer
	const tjs_uint BufferSize; // buffer size in bytes pointed by "Buffer"
	const tjs_uint32 FileHash; // hash value of the file (since inteface v2)

	tTVPXP3ExtractionFilterInfo(tjs_uint64 offset, void *buffer,
		tjs_uint buffersize, tjs_uint32 filehash) :
			Offset(offset), Buffer(buffer), BufferSize(buffersize),
			FileHash(filehash),
			SizeOfSelf(sizeof(tTVPXP3ExtractionFilterInfo)) {;}
};
#pragma pack(pop)

#ifndef TVP_tTVPXP3ArchiveExtractionFilter_CONVENTION
	#ifdef _WIN32
		#define	TVP_tTVPXP3ArchiveExtractionFilter_CONVENTION _stdcall
	#else
		#define TVP_tTVPXP3ArchiveExtractionFilter_CONVENTION
	#endif
#endif
	// TVP_tTVPXP3ArchiveExtractionFilter_CONV is _stdcall on win32 platforms,
	// for backward application compatibility.

typedef void (TVP_tTVPXP3ArchiveExtractionFilter_CONVENTION *
	tTVPXP3ArchiveExtractionFilter)(tTVPXP3ExtractionFilterInfo *info);




//---------------------------------------------------------------------------
// Script Event Related
//---------------------------------------------------------------------------
#define TVP_EPT_POST			0x00  // normal post, simply add to queue
#define TVP_EPT_REMOVE_POST		0x01
		// remove event in pending queue that has same target, source, tag and
		// name before post
		// (for input events, only the source and the tag are to be checked)
#define TVP_EPT_IMMEDIATE		0x02
		// the event will be delivered immediately

#define TVP_EPT_DISCARDABLE		0x10
		// the event can be discarded when event system is disabled

#define TVP_EPT_NORMAL			0x00
		// (with TVP_EPT_POST only)
		// the event will have normal priority.

#define TVP_EPT_EXCLUSIVE		0x20
		// (with TVP_EPT_POST only)
		// the event is given priority and other posted events are not processed
		// until the exclusive event is processed.

#define TVP_EPT_IDLE			0x40
		// (with TVP_EPT_POST only)
		// the event is only delivered after the system processes all other events.
		// this will have a priority roughly identical to "continuous" events.

#define TVP_EPT_PRIO_MASK		0xe0

#define TVP_EPT_METHOD_MASK		0x0f


class tTVPContinuousEventCallbackIntf // callback class for continuous event delivering
{
public:
	virtual void TJS_INTF_METHOD OnContinuousCallback(tjs_uint64 tick) = 0;
};


//---------------------------------------------------------------------------
// System "Compact" Event related
//---------------------------------------------------------------------------
#define TVP_COMPACT_LEVEL_IDLE        5  // the application is in idle state
#define TVP_COMPACT_LEVEL_DEACTIVATE 10  // the application had been deactivated
#define TVP_COMPACT_LEVEL_MINIMIZE   15  // the application had been minimized
#define TVP_COMPACT_LEVEL_MAX       100  // strongest level, should clear all caches
//---------------------------------------------------------------------------
class tTVPCompactEventCallbackIntf // callback class for compact event delivering
{
public:
	virtual void TJS_INTF_METHOD OnCompact(tjs_int level) = 0;
};


//---------------------------------------------------------------------------
// AsyncTrigger related
//---------------------------------------------------------------------------
enum tTVPAsyncTriggerMode
{
	atmNormal, atmExclusive, atmAtIdle
};


//---------------------------------------------------------------------------
// iTVPFunctionExporter, exporting main module's functions
//---------------------------------------------------------------------------
struct iTVPFunctionExporter
{
	virtual bool TJS_INTF_METHOD QueryFunctions(const tjs_char **name, void **function,
		tjs_uint count) = 0;
	virtual bool TJS_INTF_METHOD QueryFunctionsByNarrowString(const char **name,
		void **function, tjs_uint count) = 0;
};
//---------------------------------------------------------------------------





//---------------------------------------------------------------------------
// this stub includes exported function from Independent implementation of
// MD5 (RFC 1321) by Aladdin Enterprises.
//---------------------------------------------------------------------------
// TVP_md5_init, TVP_md5_append, TVP_md5_finish are exported
typedef struct TVP_md5_state_s { tjs_uint8 buffer[4*2+8+4*4+8+64]; } TVP_md5_state_t; // md5_state_t 
//---------------------------------------------------------------------------




//---------------------------------------------------------------------------
// data types for TVPDoTryBlock
//---------------------------------------------------------------------------
	// TVPDoTryBlock executes specified 'tryblock' in try block.
	// If any exception occured,
	// 'catchblock' is to be executed. 'data' is applicatoin defined data
	// block passed to 'tryblock' and 'catchblock' and 'finallyblock'.
	// if the 'catchblock' returns true, the exception is to be rethrown.
	// if false then the exception is to be vanished.
	// 'finallyblock' can be null, is to be executed whatever the exception
	// is generated or not.

struct tTVPExceptionDesc
{
	ttstr type; // the exception type, currently 'eTJS' or 'unknown'
	ttstr message; // the exception message (if exists. otherwise empty).
};

typedef void (TJS_USERENTRY *tTVPTryBlockFunction)(void * data);
typedef bool (TJS_USERENTRY *tTVPCatchBlockFunction)(void * data, const tTVPExceptionDesc & desc);
typedef void (TJS_USERENTRY *tTVPFinallyBlockFunction)(void *data);
//---------------------------------------------------------------------------






const tjs_int TVPMaxThreadNum = 8;
typedef void (TJS_USERENTRY *TVP_THREAD_TASK_FUNC)(void *);
typedef void * TVP_THREAD_PARAM;


//---------------------------------------------------------------------------
// KAG Parser debug level
//---------------------------------------------------------------------------
enum tTVPKAGDebugLevel
{
	tkdlNone, // none is reported
	tkdlSimple, // simple report
	tkdlVerbose // complete report ( verbose )
};


//---------------------------------------------------------------------------
// tTVPClipboardFormat
//---------------------------------------------------------------------------
enum tTVPClipboardFormat
{
	cbfText = 1
};


//---------------------------------------------------------------------------
// Sound Global Focus Mode
//---------------------------------------------------------------------------
enum tTVPSoundGlobalFocusMode
{
	/*0*/ sgfmNeverMute,			// never mutes
	/*1*/ sgfmMuteOnMinimize,		// will mute on the application minimize
	/*2*/ sgfmMuteOnDeactivate		// will mute on the application deactivation
};
//---------------------------------------------------------------------------





//---------------------------------------------------------------------------
// PCM data format (internal use)
//---------------------------------------------------------------------------
struct tTVPWaveFormat
{
	tjs_uint SamplesPerSec; // sample granule per sec
	tjs_uint Channels;
	tjs_uint BitsPerSample; // per one sample
	tjs_uint BytesPerSample; // per one sample
	tjs_uint64 TotalSamples; // in sample granule; unknown for zero
	tjs_uint64 TotalTime; // in ms; unknown for zero
	tjs_uint32 SpeakerConfig; // bitwise OR of SPEAKER_* constants
	bool IsFloat; // true if the data is IEEE floating point
	bool Seekable;
};
//---------------------------------------------------------------------------





//---------------------------------------------------------------------------
// IDirectSound former declaration
//---------------------------------------------------------------------------
#ifndef __DSOUND_INCLUDED__
struct IDirectSound;
#endif





//---------------------------------------------------------------------------
// font ralated constants
//---------------------------------------------------------------------------
#define TVP_TF_ITALIC    0x01
#define TVP_TF_BOLD      0x02
#define TVP_TF_UNDERLINE 0x04
#define TVP_TF_STRIKEOUT 0x08


//---------------------------------------------------------------------------
#define TVP_FSF_FIXEDPITCH   1      // fsfFixedPitch
#define TVP_FSF_SAMECHARSET  2      // fsfSameCharSet
#define TVP_FSF_NOVERTICAL   4      // fsfNoVertical
#define TVP_FSF_TRUETYPEONLY 8      // fsfTrueTypeOnly
#define TVP_FSF_USEFONTFACE  0x100  // fsfUseFontFace



//---------------------------------------------------------------------------
// mouse button
//---------------------------------------------------------------------------
enum tTVPMouseButton
{
	mbLeft,
	mbRight,
	mbMiddle
};



//---------------------------------------------------------------------------
// IME modes : comes from VCL's TImeMode
//---------------------------------------------------------------------------
enum tTVPImeMode
{
	imDisable,
	imClose,
	imOpen,
	imDontCare,
	imSAlpha,
	imAlpha,
	imHira,
	imSKata,
	imKata,
	imChinese,
	imSHanguel,
	imHanguel
};


//---------------------------------------------------------------------------
// shift state
//---------------------------------------------------------------------------
#define TVP_SS_SHIFT   0x01
#define TVP_SS_ALT     0x02
#define TVP_SS_CTRL    0x04
#define TVP_SS_LEFT    0x08
#define TVP_SS_RIGHT   0x10
#define TVP_SS_MIDDLE  0x20
#define TVP_SS_DOUBLE  0x40
#define TVP_SS_REPEAT  0x80


inline bool TVPIsAnyMouseButtonPressedInShiftStateFlags(tjs_uint32 state)
{ return (state & 
	(TVP_SS_LEFT | TVP_SS_RIGHT | TVP_SS_MIDDLE | TVP_SS_DOUBLE)) != 0; }



//---------------------------------------------------------------------------
// JoyPad virtual key codes
//---------------------------------------------------------------------------
// These VKs are KIRIKIRI specific. Not widely used.
#define VK_PAD_FIRST	0x1B0   // first PAD related key code
#define VK_PADLEFT		0x1B5
#define VK_PADUP		0x1B6
#define VK_PADRIGHT		0x1B7
#define VK_PADDOWN		0x1B8
#define VK_PAD1			0x1C0
#define VK_PAD2			0x1C1
#define VK_PAD3			0x1C2
#define VK_PAD4			0x1C3
#define VK_PAD5			0x1C4
#define VK_PAD6			0x1C5
#define VK_PAD7			0x1C6
#define VK_PAD8			0x1C7
#define VK_PAD9			0x1C8
#define VK_PAD10		0x1C9
#define VK_PADANY		0x1DF   // returns whether any one of pad buttons are pressed,
							    // in System.getKeyState
#define VK_PAD_LAST		0x1DF   // last PAD related key code
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// tTVPBBBltMethod and tTVPBBStretchType
//---------------------------------------------------------------------------
enum tTVPBBBltMethod
{
	bmCopy,
	bmCopyOnAlpha,
	bmAlpha,
	bmAlphaOnAlpha,
	bmAdd,
	bmSub,
	bmMul,
	bmDodge,
	bmDarken,
	bmLighten,
	bmScreen,
	bmAddAlpha,
	bmAddAlphaOnAddAlpha,
	bmAddAlphaOnAlpha,
	bmAlphaOnAddAlpha,
	bmCopyOnAddAlpha,
	bmPsNormal,
	bmPsAdditive,
	bmPsSubtractive,
	bmPsMultiplicative,
	bmPsScreen,
	bmPsOverlay,
	bmPsHardLight,
	bmPsSoftLight,
	bmPsColorDodge,
	bmPsColorDodge5,
	bmPsColorBurn,
	bmPsLighten,
	bmPsDarken,
	bmPsDifference,
	bmPsDifference5,
	bmPsExclusion
};

enum tTVPBBStretchType
{
	stNearest = 0, // primal method; nearest neighbor method
	stFastLinear = 1, // fast linear interpolation (does not have so much precision)
	stLinear = 2,  // (strict) linear interpolation
	stCubic = 3,    // cubic interpolation

	stTypeMask = 0xf, // stretch type mask
	stFlagMask = 0xf0, // flag mask

	stRefNoClip = 0x10 // referencing source is not limited by the given rectangle
						// (may allow to see the border pixel to interpolate)
};


//---------------------------------------------------------------------------
// layer / blending types
//---------------------------------------------------------------------------
enum tTVPLayerType
{
	ltBinder = 0,
	ltCoverRect = 1,
	ltOpaque = 1, // the same as ltCoverRect
	ltTransparent = 2, // alpha blend
	ltAlpha = 2, // the same as ltTransparent
	ltAdditive = 3,
	ltSubtractive = 4,
	ltMultiplicative = 5,
	ltEffect = 6,
	ltFilter = 7,
	ltDodge = 8,
	ltDarken = 9,
	ltLighten = 10,
	ltScreen = 11,
	ltAddAlpha = 12, // additive alpha blend
	ltPsNormal = 13,
	ltPsAdditive = 14,
	ltPsSubtractive = 15,
	ltPsMultiplicative = 16,
	ltPsScreen = 17,
	ltPsOverlay = 18,
	ltPsHardLight = 19,
	ltPsSoftLight = 20,
	ltPsColorDodge = 21,
	ltPsColorDodge5 = 22,
	ltPsColorBurn = 23,
	ltPsLighten = 24,
	ltPsDarken = 25,
	ltPsDifference = 26,
	ltPsDifference5 = 27,
	ltPsExclusion = 28
};
//---------------------------------------------------------------------------
static bool inline TVPIsTypeUsingAlpha(tTVPLayerType type)
	{
		return
			type == ltAlpha				||
			type == ltPsNormal			||
			type == ltPsAdditive		||
			type == ltPsSubtractive		||
			type == ltPsMultiplicative	||
			type == ltPsScreen			||
			type == ltPsOverlay			||
			type == ltPsHardLight		||
			type == ltPsSoftLight		||
			type == ltPsColorDodge		||
			type == ltPsColorDodge5		||
			type == ltPsColorBurn		||
			type == ltPsLighten			||
			type == ltPsDarken			||
			type == ltPsDifference		||
			type == ltPsDifference5		||
			type == ltPsExclusion		;
	}

static bool inline TVPIsTypeUsingAddAlpha(tTVPLayerType type)
	{
		return type == ltAddAlpha;
	}

static bool inline TVPIsTypeUsingAlphaChannel(tTVPLayerType type)
	{
		return
			TVPIsTypeUsingAddAlpha(type) ||
			TVPIsTypeUsingAlpha(type);
	}
//---------------------------------------------------------------------------






//---------------------------------------------------------------------------
// tTVPRect - simple rectangle structure
//---------------------------------------------------------------------------
#pragma pack(push, 4)
struct tTVPPoint
{
	tjs_int x;
	tjs_int y;
};
#pragma pack(pop)
//---------------------------------------------------------------------------
struct tTVPPointD
{
	double x;
	double y;
};
//---------------------------------------------------------------------------
struct tTVPRect
{
	tTVPRect(tjs_int l, tjs_int t, tjs_int r, tjs_int b)
		{ left = l, top = t, right = r, bottom =b; }

	tTVPRect() {};

	union
	{
		struct
		{
			tjs_int left;
			tjs_int top;
			tjs_int right;
			tjs_int bottom;
		};

		struct
		{
			// capital style
			tjs_int Left;
			tjs_int Top;
			tjs_int Right;
			tjs_int Bottom;
		};

		struct
		{
			tTVPPoint upper_left;
			tTVPPoint bottom_right;
		};
	};

	tjs_int get_width() const { return right - left; }
	tjs_int get_height() const { return bottom - top; }

	void set_width(tjs_int w) { right = left + w; }
	void set_height(tjs_int h) { bottom = top + h; }

	void add_offsets(tjs_int x, tjs_int y)
	{
		left += x; right += x;
		top += y; bottom += y;
	}

	void set_offsets(tjs_int x, tjs_int y)
	{
		tjs_int w = get_width();
		tjs_int h = get_height();
		left = x;
		top = y;
		right = x + w;
		bottom = y + h;
	}

	void set_size(tjs_int w, tjs_int h)
	{
		right = left + w;
		bottom = top + h;
	}

	void clear()
	{
		left = top = right = bottom = 0;
	}

	bool is_empty() const
	{
		return left >= right || top >= bottom;
	}

	bool do_union(const tTVPRect & ref)
	{
		if(ref.is_empty()) return false;
		if(left > ref.left) left = ref.left;
		if(top > ref.top) top = ref.top;
		if(right < ref.right) right = ref.right;
		if(bottom < ref.bottom) bottom = ref.bottom;
		return true;
	}
#ifndef __TP_STUB_H__
	bool clip(const tTVPRect &ref)
	{
		// Clip (take the intersection of) the rectangle with rectangle. 
		// returns whether the rectangle remains.
		return TVPIntersectRect(this, *this, ref);
	}
#endif
	bool intersects_with_no_empty_check(const tTVPRect & ref) const
	{
		// returns wether this has intersection with "ref"
		return !(
			left >= ref.right ||
			top >= ref.bottom ||
			right <= ref.left ||
			bottom <= ref.top );
	}

	bool intersects_with(const tTVPRect & ref) const
	{
		// returns wether this has intersection with "ref"
		if(ref.is_empty() || is_empty()) return false;
		return intersects_with_no_empty_check(ref);
	}

	bool included_in_no_empty_check(const tTVPRect & ref) const
	{
		// returns wether this is included in "ref"
		return
			ref.left <= left &&
			ref.top <= top &&
			ref.right >= right &&
			ref.bottom >= bottom;
	}

	bool included_in(const tTVPRect & ref) const
	{
		// returns wether this is included in "ref"
		if(ref.is_empty() || is_empty()) return false;
		return included_in_no_empty_check(ref);
	}

public: // comparison operators for sorting
	bool operator < (const tTVPRect & rhs) const
		{ return top < rhs.top || (top == rhs.top && left < rhs.left); }
	bool operator > (const tTVPRect & rhs) const
		{ return top > rhs.top || (top == rhs.top && left > rhs.left); }

	// comparison methods
	bool operator == (const tTVPRect & rhs) const
		{ return top == rhs.top && left == rhs.left && right == rhs.right && bottom == rhs.bottom; }
	bool operator != (const tTVPRect & rhs) const { return !this->operator ==(rhs); }
};
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
// drawn face types
//---------------------------------------------------------------------------
enum tTVPDrawFace
{
	dfBoth  = 0,
	dfAlpha = 0,
	dfAddAlpha = 4,
	dfMain = 1,
	dfOpaque = 1,
	dfMask = 2,
	dfProvince = 3,
	dfAuto = 128 // face is chosen automatically from the layer type
};
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// alias to blending types
//---------------------------------------------------------------------------
enum tTVPBlendOperationMode
{
	omPsNormal = ltPsNormal,
	omPsAdditive = ltPsAdditive,
	omPsSubtractive = ltPsSubtractive,
	omPsMultiplicative = ltPsMultiplicative,
	omPsScreen = ltPsScreen,
	omPsOverlay = ltPsOverlay,
	omPsHardLight = ltPsHardLight,
	omPsSoftLight = ltPsSoftLight,
	omPsColorDodge = ltPsColorDodge,
	omPsColorDodge5 = ltPsColorDodge5,
	omPsColorBurn = ltPsColorBurn,
	omPsLighten = ltPsLighten,
	omPsDarken = ltPsDarken,
	omPsDifference = ltPsDifference,
	omPsDifference5 = ltPsDifference5,
	omPsExclusion = ltPsExclusion,
	omAdditive = ltAdditive,
	omSubtractive = ltSubtractive,
	omMultiplicative = ltMultiplicative,
	omDodge = ltDodge,
	omDarken = ltDarken,
	omLighten = ltLighten,
	omScreen = ltScreen,
	omAlpha = ltTransparent,
	omAddAlpha = ltAddAlpha,
	omOpaque = ltCoverRect,

	omAuto = 128   // operation mode is guessed from the source layer type
};
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// layer hit test type
//---------------------------------------------------------------------------
enum tTVPHitType {htMask, htProvince};
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// color key types
//---------------------------------------------------------------------------
#define TVP_clAdapt				((tjs_uint32)(0x01ffffff))
#define TVP_clNone				((tjs_uint32)(0x1fffffff))
#define TVP_clPalIdx			((tjs_uint32)(0x03000000))
#define TVP_clAlphaMat			((tjs_uint32)(0x04000000))
#define TVP_Is_clPalIdx(n)		((tjs_uint32)(((n)&0xff000000) == TVP_clPalIdx))
#define TVP_get_clPalIdx(n)		((tjs_uint32)((n)&0xff))
#define TVP_Is_clAlphaMat(n)	((tjs_uint32)(((n)&0xff000000) == TVP_clAlphaMat))
#define TVP_get_clAlphaMat(n)	((tjs_uint32)((n)&0xffffff))
//---------------------------------------------------------------------------


class tTJSNI_BaseLayer;
//---------------------------------------------------------------------------
// abstract class of Layer Manager 
//---------------------------------------------------------------------------
class iTVPLayerManager
{
public:
//-- object lifetime management
	//! @brief	ե󥿤򥤥󥯥Ȥ
	virtual void TJS_INTF_METHOD AddRef() = 0;

	//! @brief	ե󥿤ǥȤ
	virtual void TJS_INTF_METHOD Release() = 0;

//-- draw device specific information
	//! @brief	軭ǥХФO
	//! @param	data	軭ǥХФ
	//! @note	軭ǥХФ쥤ޥͩ`O롣
	//!			쥤ޥͩ`ǤϤˤĤƤv֪ʤ
	//!			軭ǥХȤĿӡʹäꡢضȽYӤĤƹ롣
	virtual void TJS_INTF_METHOD SetDrawDeviceData(void * data) = 0;

	//! @brief	軭ǥХФȡä
	//! @return	軭ǥХФ
	virtual void * TJS_INTF_METHOD GetDrawDeviceData() const = 0;

//-- layer metrics
	//! @brief	ץ饤ޥ쥤Υȡä
	//! @param	w	쥤κ(ԥgλ)
	//! @param	h	쥤οk(ԥgλ)
	//! @return	ȡä˳ɹ桢ʧЂ
	virtual bool TJS_INTF_METHOD GetPrimaryLayerSize(tjs_int &w, tjs_int &h) const = 0;

//-- layer structure information
	//! @brief	ץ饤ޥ쥤ȡ
	//! @return	ץ饤ޥ쥤
	virtual tTJSNI_BaseLayer * TJS_INTF_METHOD GetPrimaryLayer() const = 0;

	//! @brief	ե`Τ쥤ȡ
	//! @return	ե`Τ쥤
	virtual tTJSNI_BaseLayer * TJS_INTF_METHOD GetFocusedLayer() const = 0;

	//! @brief	ե`Τ쥤O
	//! @param	layer	ե`Τ쥤
	virtual void TJS_INTF_METHOD SetFocusedLayer(tTJSNI_BaseLayer * layer) = 0;

//-- HID releted
	//! @brief		å줿
	//! @param		x		ץ饤ޥ쥤Ϥˤ x λ
	//! @param		y		ץ饤ޥ쥤Ϥˤ y λ
	virtual void TJS_INTF_METHOD NotifyClick(tjs_int x, tjs_int y) = 0;

	//! @brief		֥륯å줿
	//! @param		x		ץ饤ޥ쥤Ϥˤ x λ
	//! @param		y		ץ饤ޥ쥤Ϥˤ y λ
	virtual void TJS_INTF_METHOD NotifyDoubleClick(tjs_int x, tjs_int y) = 0;

	//! @brief		ޥܥѺ¤줿
	//! @param		x		ץ饤ޥ쥤Ϥˤ x λ
	//! @param		y		ץ饤ޥ쥤Ϥˤ y λ
	//! @param		mb		ɤΥޥܥ
	//! @param		flags	ե饰(TVP_SS_*νMߺϤ碌)
	virtual void TJS_INTF_METHOD NotifyMouseDown(tjs_int x, tjs_int y, tTVPMouseButton mb, tjs_uint32 flags) = 0;

	//! @brief		ޥܥx줿
	//! @param		x		ץ饤ޥ쥤Ϥˤ x λ
	//! @param		y		ץ饤ޥ쥤Ϥˤ y λ
	//! @param		mb		ɤΥޥܥ
	//! @param		flags	ե饰(TVP_SS_*νMߺϤ碌)
	virtual void TJS_INTF_METHOD NotifyMouseUp(tjs_int x, tjs_int y, tTVPMouseButton mb, tjs_uint32 flags) = 0;

	//! @brief		ޥƄӤ
	//! @param		x		ץ饤ޥ쥤Ϥˤ x λ
	//! @param		y		ץ饤ޥ쥤Ϥˤ y λ
	//! @param		flags	ե饰(TVP_SS_*νMߺϤ碌)
	virtual void TJS_INTF_METHOD NotifyMouseMove(tjs_int x, tjs_int y, tjs_uint32 flags) = 0;

	//! @brief		ޥץŤ
	//! @note		ޥץŤ٤Ϥ˥ɥФ롣
	virtual void TJS_INTF_METHOD ReleaseCapture() = 0;

	//! @brief		ޥץ饤ޥ쥤ƄӤ
	virtual void TJS_INTF_METHOD NotifyMouseOutOfWindow() = 0;

	//! @brief		`Ѻ줿
	//! @param		key		륭``
	//! @param		shift	եȥ`״B
	virtual void TJS_INTF_METHOD NotifyKeyDown(tjs_uint key, tjs_uint32 shift) = 0;

	//! @brief		`x줿
	//! @param		key		륭``
	//! @param		shift	եȥ`״B
	virtual void TJS_INTF_METHOD NotifyKeyUp(tjs_uint key, tjs_uint32 shift) = 0;

	//! @brief		`ˤ
	//! @param		key		֥`
	virtual void TJS_INTF_METHOD NotifyKeyPress(tjs_char key) = 0;

	//! @brief		ޥۥ`뤬ܞ
	//! @param		shift	եȥ`״B
	//! @param		delta	ܞ
	//! @param		x		ץ饤ޥ쥤Ϥˤ x λ
	//! @param		y		ץ饤ޥ쥤Ϥˤ y λ
	virtual void TJS_INTF_METHOD NotifyMouseWheel(tjs_uint32 shift, tjs_int delta, tjs_int x, tjs_int y) = 0;

	//! @brief		״BΥå
	//! @note		ɥs1뤪ˡ쥤ޥͩ`㤬`״B
	//!				٥å뤿˺Ф롣쥤״BΉ仯`Ȥ
	//!				ͬڤФ줿ϡȤХޥ`¤˥쥤䤬F
	//!				Τˤ⤫餺ޥ`뤬Υ쥤ָ״ˉʤ
	//!				Ȥä״rk롣Τ褦״rˌI뤿ᡢɥ
	//!				Υ᥽åɤs1뤪˺Ф롣
	virtual void TJS_INTF_METHOD RecheckInputState() = 0;

//-- invalidation/update
	//! @brief		軭ǥХ쥤γʽO
	//! @param		type	쥤ʽ
	//! @note		ǥեȤ ltOpaque 軭ǥХʽλȤ
	//!				ʤФʽָ롣ץ饤ޥ쥤 type
	//!				ץѥƥͬˉ뤳ȡ
	virtual void TJS_INTF_METHOD SetDesiredLayerType(tTVPLayerType type) = 0;

	//! @brief		ضξΤ軭Ҫ󤹤
	//! @param		r		ץ饤ޥ쥤Ϥˤ
	//! @note		ضξΤ軭쥤ޥͩ`ˌҪ󤹤롣
	//!				ҪӛhǤΥ᥽åɤϤˑ롣gHˤ줬
	//!				㤵Τ UpdateToDrawDevice() ȤǤ롣
	virtual void TJS_INTF_METHOD RequestInvalidation(const tTVPRect &r) = 0; // draw device -> layer

	//! @brief		ݤ軭Ф
	//! @note		ݤ軭ФH˺֡Υ᥽åڤǤϡ쥤ޥͩ`
	//!				iTVPDrawDevice::StartBitmapCompletion()
	//!				iTVPDrawDevice::NotifyBitmapCompleted()
	//!				iTVPDrawDevice::EndBitmapCompletion() θ᥽åɤä
	//!				ޤޤǤˉФ줿Iʤɤ혴軭ǥХͤ롣
	virtual void TJS_INTF_METHOD UpdateToDrawDevice() = 0;

//-- debug assist
	//! @brief		(Window->DrawDevice) 쥤䘋򥳥󥽩`˥פ
	virtual void TJS_INTF_METHOD DumpLayerStructure() = 0;
};
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Window related constants
//---------------------------------------------------------------------------
enum tTVPUpdateType
{
	utNormal, // only needed region
	utEntire // entire of window
};
//---------------------------------------------------------------------------
enum tTVPBorderStyle
{
	bsNone=0,  bsSingle=1,  bsSizeable=2,  bsDialog=3,  bsToolWindow=4,
	bsSizeToolWin =5
};
//---------------------------------------------------------------------------
enum tTVPMouseCursorState
{
	mcsVisible, // the mouse cursor is visible
	mcsTempHidden, // the mouse cursor is temporarily hidden
	mcsHidden // the mouse cursor is invisible
};
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
//! @brief Window basic interface
//---------------------------------------------------------------------------
class iTVPWindow
{
public:
	//! @brief	ԪΥ줿
	//! @note	軭ǥХԪΥ줿Ȥ֪ͨ뤿˺֡
	//!			ɥ iTVPDrawDevice::GetSrcSize() ӳԪ
	//!			ȡäᡢ`ʤɤӋФäƤ 
	//!			iTVPDrawDevice::SetTargetWindow() ӳ
	virtual void TJS_INTF_METHOD NotifySrcResize() = 0;

	//! @brief		ޥ`״ǥեȤˑ
	//! @note		ޥ`״ǥեȤˑϤ˺
	virtual void TJS_INTF_METHOD SetDefaultMouseCursor() = 0; // set window mouse cursor to default

	//! @brief		ޥ`״O
	//! @param		cursor		ޥ`״
	virtual void TJS_INTF_METHOD SetMouseCursor(tjs_int cursor) = 0; // set window mouse cursor

	//! @brief		ޥ`λäȡä
	//! @param		x			軭ڤˤˤޥ`xλ
	//! @param		y			軭ڤˤˤޥ`yλ
	virtual void TJS_INTF_METHOD GetCursorPos(tjs_int &x, tjs_int &y) = 0;
		// get mouse cursor position in primary layer's coordinates

	//! @brief		ޥ`λäO
	//! @param		x			軭ڤˤˤޥ`xλ
	//! @param		y			軭ڤˤˤޥ`yλ
	virtual void TJS_INTF_METHOD SetCursorPos(tjs_int x, tjs_int y) = 0;

	//! @brief		ɥΥޥץŤ
	//! @note		ɥΥޥץŤ٤Ϥ˺֡
	//! @note		Υ᥽åɤǤϻĤˤ ::ReleaseCapture() ʤɤ
	//!				ޥΥץ_Ť뤳ȡ
	virtual void TJS_INTF_METHOD WindowReleaseCapture() = 0;

	//! @brief		ĩ`åץҥȤO
	//! @param		text		ҥȥƥ(ФΈϤϥҥȤαʾ򥭥󥻥뤹)
	virtual void TJS_INTF_METHOD SetHintText(const ttstr & text) = 0;

	//! @brief		עҕݥȤO
	//! @param		layer		եκޤ쥤
	//! @param		x			軭ڤˤˤעҕݥȤxλ
	//! @param		y			軭ڤˤˤעҕݥȤyλ
	virtual void TJS_INTF_METHOD SetAttentionPoint(tTJSNI_BaseLayer *layer,
		tjs_int l, tjs_int t) = 0;

	//! @brief		עҕݥȤν
	virtual void TJS_INTF_METHOD DisableAttentionPoint() = 0;

	//! @brief		IME`ɤO
	//! @param		mode		IME`
	virtual void TJS_INTF_METHOD SetImeMode(tTVPImeMode mode) = 0;

	//! @brief		IME`ɤΥꥻå
	virtual void TJS_INTF_METHOD ResetImeMode() = 0;

	//! @brief		iTVPWindow::Update() κӳҪ󤹤
	//! @note		ɥˌ iTVPWindow::Update() Τmʥߥ󥰤
	//!				ӳȤҪ󤹤롣
	//!				iTVPWindow::Update() ӳޤǤϺλ RequestUpdate() 
	//!				ǤℿͬǤ롣ޤһ iTVPWindow::Update() 
	//!				ӳȡ٤ RequestUpdate() Фʤޤ
	//!				iTVPWindow::Update() ϺФʤ
	virtual void TJS_INTF_METHOD RequestUpdate() = 0;


	//! @brief		WindowiTJSDispatch2󥿩`ե`ȡä
	virtual iTJSDispatch2 * GetWindowDispatch() = 0;

};
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// window message receivers
//---------------------------------------------------------------------------
enum tTVPWMRRegMode { wrmRegister=0, wrmUnregister=1 };
#pragma pack(push, 4)
struct tTVPWindowMessage
{
	unsigned int Msg; // window message
	int WParam;  // WPARAM
	int LParam;  // LPARAM
	int Result;  // result
};
#pragma pack(pop)
typedef bool (__stdcall * tTVPWindowMessageReceiver)
	(void *userdata, tTVPWindowMessage *Message);

#define TVP_WM_DETACH (WM_USER+106)  // before re-generating the window
#define TVP_WM_ATTACH (WM_USER+107)  // after re-generating the window




//---------------------------------------------------------------------------
// DirectDraw former declaration
//---------------------------------------------------------------------------
#ifndef __DDRAW_INCLUDED__
struct IDirectDraw2;
struct IDirectDraw7;
struct IDirectDrawSurface;
struct IDirectDrawClipper;
#endif



//---------------------------------------------------------------------------
//! @brief		軭ǥХ󥿩`ե`
//---------------------------------------------------------------------------
class iTVPDrawDevice
{
public:
//---- ֥g
	//! @brief		(WindowDrawDevice) 軭ǥХƗ
	//! @note		ɥƗȤ뤤Ϥۤ軭ǥХ
	//!				O줿ˤ軭ǥХҪʤʤäH˺Ф롣
	//!				ͨǤ delete this gФ軭ǥХƗ뤬ǰ
	//!				AddLayerManager() Ǥ軭ǥХι¤äƤ
	//!				쥤ޥͩ`򤹤٤ Release 롣
	//!				쥤ޥͩ` Release Ф RemoveLayerManager() Ф
	//!				Ԥ뤳Ȥע⤹뤳ȡ
	virtual void TJS_INTF_METHOD Destruct() = 0;

//---- window interface vB
	//! @brief		(WindowDrawDevice) ɥ󥿩`ե`O
	//! @param		window		ɥ󥿩`ե`
	//! @note		(TJS) Window.drawDevice ץѥƥOֱ˺Ф롣
	virtual void TJS_INTF_METHOD SetWindowInterface(iTVPWindow * window) = 0;

//---- LayerManager ιvB
	//! @brief		(WindowDrawDevice) 쥤ޥͩ`׷Ӥ
	//! @note		ץ饤ޥ쥤䤬ɥ׷ӤȡԄӵĤ˥쥤ޥͩ`㤬
	//!				ɤ졢줬軭ǥХˤ⤳Υ᥽åɤκӳˤ֪ͨ롣
	//!				軭ǥХǤ iTVPLayerManager::AddRef() ӳơ׷Ӥ줿
	//!				쥤ޥͩ`å뤳ȡ
	virtual void TJS_INTF_METHOD AddLayerManager(iTVPLayerManager * manager) = 0;

	//! @brief		(WindowDrawDevice) 쥤ޥͩ`
	//! @note		ץ饤ޥ쥤䤬 invalidate H˺ӳ롣
	//TODO: ץ饤ޥ쥤o뤤ϥɥƗrνK˄I
	virtual void TJS_INTF_METHOD RemoveLayerManager(iTVPLayerManager * manager) = 0;

//---- 軭λ?vB
	//! @brief		(WindowDrawDevice) 軭ȥɥO
	//! @param		wnd		ɥϥɥ
	//! @param		is_main	ᥤ󥦥ɥΈϤ
	//! @note		ɥ軭ȤȤʤ륦ɥϥɥָ뤿˺Ф롣
	//!				ФСWindow.borderStyle ץѥƥ줿ꡢե륹`
	//!				ФȤե륹`󤫤rʤɡɥɤ
	//!				Ȥ뤬Τ褦ʈϤˤϡɥäƗֱǰ
	//!				wnd = NULL ״BǤΥ᥽åɤФ뤳Ȥע⡣ɥ
	//!				줿ȡ٤ЄʥɥϥɥäƤΥ᥽åɤФ롣
	//!				Υ᥽åɤϡɥɤ줿ֱ˺Ф뱣^Ϥʤ
	//!				Ƥһ˥ɥʾ줿ֱ˺Ф롣
	virtual void TJS_INTF_METHOD SetTargetWindow(HWND wnd, bool is_main) = 0;

	//! @brief		(Window->DrawDevice) 軭ΤO
	//! @note		ɥ顢軭ȤȤʤΤO뤿˺Ф롣
	//!				軭ǥХϡSetTargetWindow() ָ줿ɥΥ饤IΡ
	//!				Υ᥽åɤָ줿Τ˱ʾФҪ롣
	//!				ξΤϡGetSrcSize ǷˌWindow.zoomNumer  Window.zoomDenum
	//!				ץѥƥˤ뒈ʤ䡢Window.layerLeft  Window.layerTop ζ줿
	//!				ΤǤ롣
	//!				Υ᥽åɤˤä軭ΤäȤƤ⡢Υߥ󥰤
	//!				軭ǥХȤ軭ФҪϤʤ(ҪЄe᥽åɤˤ
	//!				軭αҪԤ֪ͨ뤿)
	virtual void TJS_INTF_METHOD SetDestRectangle(const tTVPRect & rect) = 0;

	//! @brief		(Window->DrawDevice) ԪΥä
	//! @note		ɥ顢軭ΤΥQ뤿ԪΥ
	//!				ҪˤʤäH˺Ф롣ɥϤȤ SetDestRectangle()
	//!				᥽åɤ軭Τ֪ͨƤʤΤǡ
	//!				ʤ餫ζΤ륵ǤҪϱؤʤ
	virtual void TJS_INTF_METHOD GetSrcSize(tjs_int &w, tjs_int &h) = 0;

	//! @brief		(LayerManagerDrawDevice) 쥤䥵֪ͨ
	//! @param		manager		쥤ޥͩ`
	//! @note		쥤ޥͩ`˥åƤץ饤ޥ쥤Υä
	//!				H˺ӳ
	virtual void TJS_INTF_METHOD NotifyLayerResize(iTVPLayerManager * manager) = 0;

	//! @brief		(LayerManagerDrawDevice) 쥤λΉ֪ͨ
	//! @param		manager		쥤ޥͩ`
	//! @note		쥤λˉ仯äH˺ӳ롣
	//!				֪ͨܤȡä iTVPLayerManager::UpdateToDrawDevice()
	//!				ӳСԓ֤軭ǥХˌ軭뤳ȤǤ롣
	//!				֪ͨܤȡäƤoҕ뤳ȤϿܡΈϤϡ
	//!				Τ iTVPLayerManager::UpdateToDrawDevice() Hˡ
	//!				ޤǤΉ֤٤軭롣
	virtual void TJS_INTF_METHOD NotifyLayerImageChange(iTVPLayerManager * manager) = 0;

//---- ``󥿩`ե`vB
	//! @brief		(WindowDrawDevice) å줿
	//! @param		x		軭ڤˤ x λ(軭ΤϤԭ)
	//! @param		y		軭ڤˤ y λ(軭ΤϤԭ)
	virtual void TJS_INTF_METHOD OnClick(tjs_int x, tjs_int y) = 0;

	//! @brief		(WindowDrawDevice) ֥륯å줿
	//! @param		x		軭ڤˤ x λ(軭ΤϤԭ)
	//! @param		y		軭ڤˤ y λ(軭ΤϤԭ)
	virtual void TJS_INTF_METHOD OnDoubleClick(tjs_int x, tjs_int y) = 0;

	//! @brief		(WindowDrawDevice) ޥܥѺ¤줿
	//! @param		x		軭ڤˤ x λ(軭ΤϤԭ)
	//! @param		y		軭ڤˤ y λ(軭ΤϤԭ)
	//! @param		mb		ɤΥޥܥ
	//! @param		flags	ե饰(TVP_SS_*νMߺϤ碌)
	virtual void TJS_INTF_METHOD OnMouseDown(tjs_int x, tjs_int y, tTVPMouseButton mb, tjs_uint32 flags) = 0;

	//! @brief		(WindowDrawDevice) ޥܥx줿
	//! @param		x		軭ڤˤ x λ(軭ΤϤԭ)
	//! @param		y		軭ڤˤ y λ(軭ΤϤԭ)
	//! @param		mb		ɤΥޥܥ
	//! @param		flags	ե饰(TVP_SS_*νMߺϤ碌)
	virtual void TJS_INTF_METHOD OnMouseUp(tjs_int x, tjs_int y, tTVPMouseButton mb, tjs_uint32 flags) = 0;

	//! @brief		(WindowDrawDevice) ޥƄӤ
	//! @param		x		軭ڤˤ x λ(軭ΤϤԭ)
	//! @param		y		軭ڤˤ y λ(軭ΤϤԭ)
	//! @param		flags	ե饰(TVP_SS_*νMߺϤ碌)
	virtual void TJS_INTF_METHOD OnMouseMove(tjs_int x, tjs_int y, tjs_uint32 flags) = 0;

	//! @brief		(WindowDrawDevice) 쥤ΥޥץŤ
	//! @note		쥤ΥޥץŤ٤Ϥ˥ɥФ롣
	//! @note		WindowReleaseCapture() Ȼͬʤȡ
	virtual void TJS_INTF_METHOD OnReleaseCapture() = 0;

	//! @brief		(WindowDrawDevice) ޥ軭ƄӤ
	virtual void TJS_INTF_METHOD OnMouseOutOfWindow() = 0;

	//! @brief		(WindowDrawDevice) `Ѻ줿
	//! @param		key		륭``
	//! @param		shift	եȥ`״B
	virtual void TJS_INTF_METHOD OnKeyDown(tjs_uint key, tjs_uint32 shift) = 0;

	//! @brief		(WindowDrawDevice) `x줿
	//! @param		key		륭``
	//! @param		shift	եȥ`״B
	virtual void TJS_INTF_METHOD OnKeyUp(tjs_uint key, tjs_uint32 shift) = 0;

	//! @brief		(WindowDrawDevice) `ˤ
	//! @param		key		֥`
	virtual void TJS_INTF_METHOD OnKeyPress(tjs_char key) = 0;

	//! @brief		(WindowDrawDevice) ޥۥ`뤬ܞ
	//! @param		shift	եȥ`״B
	//! @param		delta	ܞ
	//! @param		x		軭ڤˤ x λ(軭ΤϤԭ)
	//! @param		y		軭ڤˤ y λ(軭ΤϤԭ)
	virtual void TJS_INTF_METHOD OnMouseWheel(tjs_uint32 shift, tjs_int delta, tjs_int x, tjs_int y) = 0;

	//! @brief		(Window->DrawDevice) ״BΥå
	//! @note		ɥs1뤪ˡ쥤ޥͩ`㤬`״B
	//!				٥å뤿˺Ф롣쥤״BΉ仯`Ȥ
	//!				ͬڤФ줿ϡȤХޥ`¤˥쥤䤬F
	//!				Τˤ⤫餺ޥ`뤬Υ쥤ָ״ˉʤ
	//!				Ȥä״rk롣Τ褦״rˌI뤿ᡢɥ
	//!				Υ᥽åɤs1뤪˺Ф롣
	virtual void TJS_INTF_METHOD RecheckInputState() = 0;

	//! @brief		(LayerManagerDrawDevice) ޥ`״ǥեȤˑ
	//! @param		manager		쥤ޥͩ`
	//! @note		ޥ`״ǥեȤˑϤ˺Ф
	virtual void TJS_INTF_METHOD SetDefaultMouseCursor(iTVPLayerManager * manager) = 0;

	//! @brief		(LayerManagerDrawDevice) ޥ`״O
	//! @param		manager		쥤ޥͩ`
	//! @param		cursor		ޥ`״
	virtual void TJS_INTF_METHOD SetMouseCursor(iTVPLayerManager * manager, tjs_int cursor) = 0;

	//! @brief		(LayerManagerDrawDevice) ޥ`λäȡä
	//! @param		manager		쥤ޥͩ`
	//! @param		x			ץ饤ޥ쥤Ϥˤˤޥ`xλ
	//! @param		y			ץ饤ޥ쥤Ϥˤˤޥ`yλ
	//! @note		ˤϥץ饤ޥ쥤ϤˤʤΤǡҪʤЉQФ
	virtual void TJS_INTF_METHOD GetCursorPos(iTVPLayerManager * manager, tjs_int &x, tjs_int &y) = 0;

	//! @brief		(LayerManagerDrawDevice) ޥ`λäO
	//! @param		manager		쥤ޥͩ`
	//! @param		x			ץ饤ޥ쥤Ϥˤˤޥ`xλ
	//! @param		y			ץ饤ޥ쥤Ϥˤˤޥ`yλ
	//! @note		ˤϥץ饤ޥ쥤ϤˤʤΤǡҪʤЉQФ
	virtual void TJS_INTF_METHOD SetCursorPos(iTVPLayerManager * manager, tjs_int x, tjs_int y) = 0;

	//! @brief		(LayerManagerDrawDevice) ɥΥޥץŤ
	//! @param		manager		쥤ޥͩ`
	//! @note		ɥΥޥץŤ٤Ϥ˥쥤ޥͩ`㤫Ф롣
	//! @note		ɥΥޥץ OnReleaseCapture() _ŤǤ쥤Υޥץ
	//!				Ȯʤ뤳Ȥע⡣ɥΥޥץOSΥɥƥ
	//!				CܤǤ뤬쥤ΥޥץϼＪ郎쥤ޥͩ`㤴Ȥ
	//!				Ԥ˹ƤǤ롣Υ᥽åɤǤϻĤˤ ::ReleaseCapture() ʤɤ
	//!				ޥΥץ_Ť롣
	virtual void TJS_INTF_METHOD WindowReleaseCapture(iTVPLayerManager * manager) = 0;

	//! @brief		(LayerManagerDrawDevice) ĩ`åץҥȤO
	//! @param		manager		쥤ޥͩ`
	//! @param		text		ҥȥƥ(ФΈϤϥҥȤαʾ򥭥󥻥뤹)
	virtual void TJS_INTF_METHOD SetHintText(iTVPLayerManager * manager, const ttstr & text) = 0;

	//! @brief		(LayerManagerDrawDevice) עҕݥȤO
	//! @param		manager		쥤ޥͩ`
	//! @param		layer		եκޤ쥤
	//! @param		x			ץ饤ޥ쥤ϤˤˤעҕݥȤxλ
	//! @param		y			ץ饤ޥ쥤ϤˤˤעҕݥȤyλ
	//! @note		עҕݥȤͨåλäΤȤǡIMEΥݥå?ɥ
	//!				ʾ줿ꡢ`aΒR򒈴󤷤ꤹ롣IMEݥåȥɥ
	//!				ʾꡢδ_֤򤽤˱ʾꤹHΥեȤ layer ѥ`
	//!				ʾ쥤䤬֤ˤ뤬ץ饰󤫤餽äO
	//!				륤󥿩`ե`ϽΤȤʤ
	//! @note		ˤϥץ饤ޥ쥤ϤˤʤΤǡҪʤЉQФ
	virtual void TJS_INTF_METHOD SetAttentionPoint(iTVPLayerManager * manager, tTJSNI_BaseLayer *layer,
							tjs_int l, tjs_int t) = 0;

	//! @brief		(LayerManagerDrawDevice) עҕݥȤν
	//! @param		manager		쥤ޥͩ`
	virtual void TJS_INTF_METHOD DisableAttentionPoint(iTVPLayerManager * manager) = 0;

	//! @brief		(LayerManagerDrawDevice) IME`ɤO
	//! @param		manager		쥤ޥͩ`
	//! @param		mode		IME`
	virtual void TJS_INTF_METHOD SetImeMode(iTVPLayerManager * manager, tTVPImeMode mode) = 0;

	//! @brief		(LayerManagerDrawDevice) IME`ɤΥꥻå
	//! @param		manager		쥤ޥͩ`
	virtual void TJS_INTF_METHOD ResetImeMode(iTVPLayerManager * manager) = 0;

//---- ץ饤ޥ쥤vB
	//! @brief		(WindowDrawDevice) ץ饤ޥ쥤ȡ
	//! @return		ץ饤ޥ쥤
	//! @note		Window.primaryLayer i߳줿HˤΥ᥽åɤФ롣
	//!				˺Ф뤳ȤϤʤ
	virtual tTJSNI_BaseLayer * TJS_INTF_METHOD GetPrimaryLayer() = 0;

	//! @brief		(WindowDrawDevice) ե`Τ쥤ȡ
	//! @return		ե`Τ쥤(NULL=ե`Τ쥤䤬ʤ)
	//! @note		Window.focusedLayer i߳줿HˤΥ᥽åɤФ롣
	//!				˺Ф뤳ȤϤʤ
	virtual tTJSNI_BaseLayer * TJS_INTF_METHOD GetFocusedLayer() = 0;

	//! @brief		(WindowDrawDevice) ե`Τ쥤O
	//! @param		layer		ե`Τ쥤(NULL=ե`Τ쥤䤬ʤ״Bˤ)
	//! @note		Window.focusedLayer zޤ줿HˤΥ᥽åɤФ롣
	//!				˺Ф뤳ȤϤʤ
	virtual void TJS_INTF_METHOD SetFocusedLayer(tTJSNI_BaseLayer * layer) = 0;


//---- 軭vB
	//! @brief		(WindowDrawDevice) 軭ΤΟo֪ͨ
	//! @param		rect		軭ڤˤˤ롢oˤʤäI
	//!							(軭ΤϤԭ)
	//! @note		軭Τһ뤤ȫoˤʤäH˥ɥ֪ͨ롣
	//!				軭ǥХϡʤ٤礤rڤ˟oˤʤä֤軭٤Ǥ롣
	virtual void TJS_INTF_METHOD RequestInvalidation(const tTVPRect & rect) = 0;

	//! @brief		(WindowDrawDevice) ¤Ҫ
	//! @note		軭Τݤ¤״B˸¤٤ߥ󥰤ǡɥФ롣
	//!				iTVPWindow::RequestUpdate() ᡢƥब軭ߥ󥰤äH
	//!				Ф롣ͨ軭ǥХϤΥߥ󥰤äƥե`
	//!				`ե`˻軭롣
	virtual void TJS_INTF_METHOD Update() = 0;

	//! @brief		(Window->DrawDevice) αʾ
	//! @note		ե`󥵩`ե`軭줿򡢥󥹥`˱ʾ
	//!				(뤤ϥեåפ) ߥ󥰤ǺФ롣ͨ Update ֱ
	//!				Ф뤬VSync ЄˤʤäƤϤ Update ֱǤϤʤ
	//!				VBlank Ф˺ФԤ롣ե`󥵩`ե`
	//!				ʹʤϤϟoҕƤޤʤ
	virtual void TJS_INTF_METHOD Show() = 0;

//---- LayerManager λܤɤvB
	//! @brief		(LayerManager->DrawDevice) ӥåȥޥåפ軭_ʼ
	//! @param		manager		軭_ʼ쥤ޥͩ`
	//! @note		쥤ޥͩ`㤫軭ǥХػܞͤǰ˺Ф롣
	//!				ΤȡNotifyBitmapCompleted() λФ졢
	//!				EndBitmapCompletion() Ф롣
	//!				ҪʤСΥߥ󥰤軭ǥХȤǥ`ե`Υåʤɤ
	//!				Фȡ
	virtual void TJS_INTF_METHOD StartBitmapCompletion(iTVPLayerManager * manager) = 0;

	//! @brief		(LayerManager->DrawDevice) ӥåȥޥåפ軭֪ͨ
	//! @param		manager		ṩԪΥ쥤ޥͩ`
	//! @param		x			ץ饤ޥ쥤Ϥˤˤ뻭λ
	//! @param		y			ץ饤ޥ쥤Ϥˤˤ뻭϶λ
	//! @param		bits		ӥåȥޥåץǩ`
	//! @param		bitmapinfo	ӥåȥޥåפʽ
	//! @param		cliprect	bits Τɤβ֤ʹä
	//! @param		type		ṩ뻭붨ϳɥ`
	//! @param		opacity		ṩ뻭붨벻͸(0255)
	//! @note		쥤ޥͩ`㤬ϳɤˤY軭ǥХ軭Ƥ餤H
	//!				Ф롣һĤθ¤}ξΤǘɤϤ뤿ᡢΥ᥽åɤ
	//!				StartBitmapCompletion()  EndBitmapCompletion() g}غФԤ롣
	//!				Ĥˤϡbits  bitmapinfo ǱӥåȥޥåפΤcliprect 
	//!				ʾΤ x, y λäܞͤФ褤軭Τδ󤭤˺Ϥ碌
	//!				sСʤɤ軭ǥХȤ浹ҊҪ롣
	virtual void TJS_INTF_METHOD NotifyBitmapCompleted(iTVPLayerManager * manager,
		tjs_int x, tjs_int y, const void * bits, const BITMAPINFO * bitmapinfo,
		const tTVPRect &cliprect, tTVPLayerType type, tjs_int opacity) = 0;

	//! @brief		(LayerManager->DrawDevice) ӥåȥޥåפ軭Kˤ
	//! @param		manager		軭Kˤ쥤ޥͩ`
	virtual void TJS_INTF_METHOD EndBitmapCompletion(iTVPLayerManager * manager) = 0;

//---- ǥХå֧Ԯ
	//! @brief		(Window->DrawDevice) 쥤䘋򥳥󥽩`˥פ
	virtual void TJS_INTF_METHOD DumpLayerStructure() = 0;

	//! @brief		(Window->DrawDevice) ¾ΤαʾФɤO
	//! @param		b		ʾФɤ
	//! @note		쥤ʾCָ¤ФHξΤʾ
	//!				ָ¤mƤ뤿֧ԮCܡ
	//!				gװҪϤʤgװ뤳Ȥޤ
	virtual void TJS_INTF_METHOD SetShowUpdateRect(bool b) = 0;
};
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// tTVPVideoOverlayMode
//---------------------------------------------------------------------------
enum tTVPVideoOverlayMode {
	vomOverlay,		// Overlay
	vomLayer,		// Draw Layer
	vomMixer,		// VMR
};






//---------------------------------------------------------------------------
// tTVPPeriodEventType : event type in onPeriod event
//---------------------------------------------------------------------------
enum tTVPPeriodEventReason
{
	perLoop, // the event is by loop rewind
	perPeriod, // the event is by period point specified by the user
	perPrepare, // the event is by prepare() method
	perSegLoop, // the event is by segment loop rewind
};





//---------------------------------------------------------------------------
// scroll transition handler
//---------------------------------------------------------------------------
enum tTVPScrollTransFrom
{
	sttLeft, sttTop, sttRight, sttBottom
};
enum tTVPScrollTransStay
{
	ststNoStay, ststStayDest, ststStaySrc
};


//---------------------------------------------------------------------------
// tTVPTransType
//---------------------------------------------------------------------------
// transition type
#ifdef __BORLANDC__
	#pragma option push -b
#endif
enum tTVPTransType
{
	ttSimple, // transition using only one(self) layer ( eg. simple fading )
	ttExchange // transition using two layer ( eg. cross fading )
};
#ifdef __BORLANDC__
	#pragma option pop
#endif
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
// tTVPTransUpdateType
//---------------------------------------------------------------------------
// transition update type
#ifdef __BORLANDC__
	#pragma option push -b
#endif
enum tTVPTransUpdateType
{
	tutDivisibleFade,
	tutDivisible,
	tutGiveUpdate
};
#ifdef __BORLANDC__
	#pragma option pop
#endif
/*
	there are two types of transition update method;
	tutDivisibleFade, tutDivisible and tutGiveUpdate.

	tutDivisibleFade
		used when the transition processing is region-divisible and
		the transition updates entire area of the layer.
		update area is always given by iTVPTransHandler::Process caller.
		handler must use only given area of the source bitmap on each
		callbacking.

	tutDivisible
		same as tutDivisibleFade, except for its usage of source area.
		handler can use any area of the source bitmap.
		this will somewhat slower than tutDivisibleFade.

	tutGiveUpdate
		used when the transition processing is not region-divisible or
		the transition updates only some small regions rather than entire
		area.
		update area is given by callee of iTVPTransHandler::Process, 
		via iTVPLayerUpdater interface.
*/
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
// iTVPScanLineProvider
//---------------------------------------------------------------------------
// provides layer scanline
class iTVPScanLineProvider
{
public:
	virtual tjs_error TJS_INTF_METHOD AddRef() = 0;
	virtual tjs_error TJS_INTF_METHOD Release() = 0;
		// call "Release" when done with this object

	virtual tjs_error TJS_INTF_METHOD GetWidth(/*out*/tjs_int *width) = 0;
		// return image width
	virtual tjs_error TJS_INTF_METHOD GetHeight(/*out*/tjs_int *height) = 0;
		// return image height
	virtual tjs_error TJS_INTF_METHOD GetPixelFormat(/*out*/tjs_int *bpp) = 0;
		// return image bit depth
	virtual tjs_error TJS_INTF_METHOD GetPitchBytes(/*out*/tjs_int *pitch) = 0;
		// return image bitmap data width in bytes ( offset to next down line )
	virtual tjs_error TJS_INTF_METHOD GetScanLine(/*in*/tjs_int line,
			/*out*/const void ** scanline) = 0;
		// return image pixel scan line pointer
	virtual tjs_error TJS_INTF_METHOD GetScanLineForWrite(/*in*/tjs_int line,
			/*out*/void ** scanline) = 0;
		// return image pixel scan line pointer for writing
};
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
// iTVPSimpleOptionProvider
//---------------------------------------------------------------------------
// provides option set
class iTVPSimpleOptionProvider
{
public:
	virtual tjs_error TJS_INTF_METHOD AddRef() = 0;
	virtual tjs_error TJS_INTF_METHOD Release() = 0;
		// call this when done with this object

	virtual tjs_error TJS_INTF_METHOD GetAsNumber(
			/*in*/const tjs_char *name, /*out*/tjs_int64 *value) = 0;
		// retrieve option as a number.
	virtual tjs_error TJS_INTF_METHOD GetAsString(
			/*in*/const tjs_char *name, /*out*/const tjs_char **out) = 0;
		// retrieve option as a string.
		// note that you must use the returned string as an one time string
		// pointer; you cannot hold its pointer and/or use it later.

	virtual tjs_error TJS_INTF_METHOD GetValue(
			/*in*/const tjs_char *name, /*out*/tTJSVariant *dest) = 0;
		// retrieve option as a tTJSVariant.

	virtual tjs_error TJS_INTF_METHOD Reserved2() = 0;

	virtual tjs_error TJS_INTF_METHOD GetDispatchObject(iTJSDispatch2 **dsp)
		 = 0;
		// retrieve internal dispatch object ( if exists )
};
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// iTVPSimpleImageProvider
//---------------------------------------------------------------------------
// image loader
class iTVPSimpleImageProvider
{
public:
	virtual tjs_error TJS_INTF_METHOD LoadImage(
			/*in*/const tjs_char *name, /*in*/tjs_int bpp,
			/*in*/tjs_uint32 key, 
			/*in*/tjs_uint w,
			/*in*/tjs_uint h,
			/*out*/iTVPScanLineProvider ** scpro) = 0;
		// load an image.
		// returned image be an 8bpp bitmap when bpp == 8, otherwise
		// 32bpp.
		// key is a color key. pass 0x02ffffff for not to apply color key.
		// you must release "scpro" when you done with it.
		// w and h are desired size of the image. if the actual size is smaller
		// than these, the image is to be tiled. give 0, 0 to obtain original
		// sized image.
};
//---------------------------------------------------------------------------




//---------------------------------------------------------------------------
// iTVPLayerUpdater
//---------------------------------------------------------------------------
// layer update region notification interface
class iTVPLayerUpdater
{
public:
	virtual tjs_error TJS_INTF_METHOD UpdateRect(tjs_int left,
		tjs_int top, tjs_int right, tjs_int bottom);
		// notify that the layer image had been changed.
};
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
// tTVPDivisibleData
//---------------------------------------------------------------------------
// structure used by iTVPDivisibleTransHandler::Process
#ifdef _WIN32
#pragma pack(push, 4)
#endif

struct tTVPDivisibleData
{
	/*const*/tjs_int Left; // processing rectangle left
	/*const*/tjs_int Top; // processing rectangle top
	/*const*/tjs_int Width; // processing rectangle width
	/*const*/tjs_int Height; // processing rectangle height
	iTVPScanLineProvider *Dest; // destination image
	tjs_int DestLeft; // destination image rectangle's left
	tjs_int DestTop; // destination image rectangle's top
	/*const*/iTVPScanLineProvider *Src1; // source 1 (self layer image)
	/*const*/tjs_int Src1Left; // source 1 image rectangle's left
	/*const*/tjs_int Src1Top; // source 1 image rectangle's top
	/*const*/iTVPScanLineProvider *Src2; // source 2 (other layer image)
	/*const*/tjs_int Src2Left; // source 2 image rectangle's left
	/*const*/tjs_int Src2Top; // source 2 image rectangle's top
};
/* note that "Src2" will be null when transition type is ttSimple. */
/* Src1Left, Src1Top, Src2Left, Src2Top are not used when the transition is
	tutDivisible. */

#ifdef _WIN32
#pragma pack(pop)
#endif



//---------------------------------------------------------------------------
// iTVPBaseTransHandler
//---------------------------------------------------------------------------
class iTVPBaseTransHandler
{
public:
	virtual tjs_error TJS_INTF_METHOD AddRef() = 0;
	virtual tjs_error TJS_INTF_METHOD Release() = 0;

	virtual tjs_error TJS_INTF_METHOD SetOption(
			/*in*/iTVPSimpleOptionProvider *options // option provider
		) = 0;
		// Set option for current processing transition
};
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
// iTVPDivisibleTransHandler
//---------------------------------------------------------------------------
class iTVPDivisibleTransHandler : public iTVPBaseTransHandler
{
public:
	virtual tjs_error TJS_INTF_METHOD StartProcess(
			/*in*/tjs_uint64 tick) = 0;
		// called before one processing time unit.
		// expected return values are:
		// TJS_S_TRUE: continue processing
		// TJS_S_FALSE: break processing

	virtual tjs_error TJS_INTF_METHOD EndProcess() = 0;
		// called after one processing time unit.
		// expected return values are:
		// TJS_S_TRUE: continue processing
		// TJS_S_FALSE: break processing

	virtual tjs_error TJS_INTF_METHOD Process(
			/*in,out*/tTVPDivisibleData *data) = 0;
		// called during StartProcess and EndProcess per an update rectangle.
		// the handler processes given rectangle and put result image to
		// "Dest"( in tTVPDivisibleData ).
		// given "Dest" is a internal image buffer, but callee can change
		// the "Dest" pointer to Src1 or Src2. Also DestLeft and DestTop can
		// be changed to point destination image part.

	virtual tjs_error TJS_INTF_METHOD MakeFinalImage(
			/*in,out*/iTVPScanLineProvider ** dest, // destination
			/*in*/iTVPScanLineProvider * src1, // source 1
			/*in*/iTVPScanLineProvider * src2 // source 2
			) = 0;
		// will be called after StartProcess/EndProcess returns TJS_S_FALSE.
		// this function does not called in some occasions.
		// fill "dest" to make a final image.
		// dest can be set to either src1 or src2.
};
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
// iTVPGiveUpdateTransHandler
//---------------------------------------------------------------------------
class iTVPGiveUpdateTransHandler : public iTVPBaseTransHandler
{
public:
	virtual tjs_error TJS_INTF_METHOD Process(
			/*in*/tjs_uint64 tick, // tick count provided by the system in ms
			/*in*/iTVPLayerUpdater * updater, // layer updater object
			/*in*/iTVPScanLineProvider * dest, // destination
			/*in*/iTVPScanLineProvider * src1, // source 1
			/*in*/iTVPScanLineProvider * src2 // source 2
		) = 0;
	// process the transition.
	// callee must call updater->UpdateLayerRect when changing the layer image.
	// updater->UpdateLayerRect can be called more than once.
};
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
// iTVPTransHandlerProvider
//---------------------------------------------------------------------------
// transition handler provider abstract class
class iTVPTransHandlerProvider
{
public:
	virtual tjs_error TJS_INTF_METHOD AddRef() = 0;
	virtual tjs_error TJS_INTF_METHOD Release() = 0;

	virtual tjs_error TJS_INTF_METHOD GetName(
			/*out*/const tjs_char ** name) = 0;
		// return this transition name

	virtual tjs_error TJS_INTF_METHOD StartTransition(
			/*in*/iTVPSimpleOptionProvider *options, // option provider
			/*in*/iTVPSimpleImageProvider *imagepro, // image provider
			/*in*/tTVPLayerType layertype, // destination layer type
			/*in*/tjs_uint src1w, tjs_uint src1h, // source 1 size
			/*in*/tjs_uint src2w, tjs_uint src2h, // source 2 size
			/*out*/tTVPTransType *type, // transition type
			/*out*/tTVPTransUpdateType * updatetype, // update typwe
			/*out*/iTVPBaseTransHandler ** handler // transition handler
			) = 0;
		// start transition and return a handler.
		// "handler" is an object of iTVPDivisibleTransHandler when
		// updatetype is tutDivisibleFade or tutDivisible.
		// Otherwise is an object of iTVPGiveUpdateTransHandler ( cast to
		// each class to use it )
		// layertype is the destination layer type.
};
//---------------------------------------------------------------------------


#ifdef __cplusplus
 extern "C" {
#endif


#pragma pack(push, 4)
typedef struct
{
	/* structure used for adjustment of gamma levels */

	float RGamma; /* R gamma   ( 0.10 -- 1.00 -- 9.99) */
	tjs_int RFloor;   /* output floor value  ( 0 -- 255 ) */
	tjs_int RCeil;    /* output ceil value ( 0 -- 255 ) */
	float GGamma; /* G */
	tjs_int GFloor;
	tjs_int GCeil;
	float BGamma; /* B */
	tjs_int BFloor;
	tjs_int BCeil;
} tTVPGLGammaAdjustData;
#pragma pack(pop)


#pragma pack(push, 4)
typedef struct
{
	tjs_uint8 B[256];
	tjs_uint8 G[256];
	tjs_uint8 R[256];
} tTVPGLGammaAdjustTempData;
#pragma pack(pop)


#ifdef __cplusplus
 }
#endif


#define TVP_RGB2COLOR(r,g,b) ((((r)<<16) + ((g)<<8) + (b)) | 0xff000000)
#define TVP_RGBA2COLOR(r,g,b,a) \
	(((a)<<24) +  (((r)<<16) + ((g)<<8) + (b)))


//---------------------------------------------------------------------------
// CPU Types
//---------------------------------------------------------------------------


#define TVP_CPU_HAS_FPU 0x000010000
#define TVP_CPU_HAS_MMX 0x000020000
#define TVP_CPU_HAS_3DN 0x000040000
#define TVP_CPU_HAS_SSE 0x000080000
#define TVP_CPU_HAS_CMOV 0x000100000
#define TVP_CPU_HAS_E3DN 0x000200000
#define TVP_CPU_HAS_EMMX 0x000400000
#define TVP_CPU_HAS_SSE2 0x000800000
#define TVP_CPU_HAS_TSC 0x001000000
#define TVP_CPU_FEATURE_MASK 0x0ffff0000
#define TVP_CPU_IS_INTEL 0x000000010
#define TVP_CPU_IS_AMD 0x000000020
#define TVP_CPU_IS_IDT 0x000000030
#define TVP_CPU_IS_CYRIX 0x000000040
#define TVP_CPU_IS_NEXGEN 0x000000050
#define TVP_CPU_IS_RISE 0x000000060
#define TVP_CPU_IS_UMC 0x000000070
#define TVP_CPU_IS_TRANSMETA 0x000000080
#define TVP_CPU_IS_UNKNOWN 0x000000000
#define TVP_CPU_VENDOR_MASK 0x000000ff0
#define TVP_CPU_FAMILY_MASK 0x00000000f















































//---------------------------------------------------------------------------




//---------------------------------------------------------------------------
// stubs
//---------------------------------------------------------------------------

inline tjs_int TJS_atoi(const tjs_char * s)
{
	if(!TVPImportFuncPtr586e16d502a6ad98b08161bdb090f8b6)
	{
		static char funcname[] = "tjs_int ::TJS_atoi(const tjs_char *)";
		TVPImportFuncPtr586e16d502a6ad98b08161bdb090f8b6 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)(const tjs_char *);
	return ((__functype)(TVPImportFuncPtr586e16d502a6ad98b08161bdb090f8b6))(s);
}
inline tjs_char * TJS_int_to_str(tjs_int value , tjs_char * string)
{
	if(!TVPImportFuncPtrd8bc9c71c80b200c39b29167d795cad0)
	{
		static char funcname[] = "tjs_char * ::TJS_int_to_str(tjs_int,tjs_char *)";
		TVPImportFuncPtrd8bc9c71c80b200c39b29167d795cad0 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_char * (__stdcall * __functype)(tjs_int , tjs_char *);
	return ((__functype)(TVPImportFuncPtrd8bc9c71c80b200c39b29167d795cad0))(value, string);
}
inline tjs_char * TJS_tTVInt_to_str(tjs_int64 value , tjs_char * string)
{
	if(!TVPImportFuncPtr85df4beb87f6503891e116ce046353c3)
	{
		static char funcname[] = "tjs_char * ::TJS_tTVInt_to_str(tjs_int64,tjs_char *)";
		TVPImportFuncPtr85df4beb87f6503891e116ce046353c3 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_char * (__stdcall * __functype)(tjs_int64 , tjs_char *);
	return ((__functype)(TVPImportFuncPtr85df4beb87f6503891e116ce046353c3))(value, string);
}
inline tjs_int TJS_strnicmp(const tjs_char * s1 , const tjs_char * s2 , size_t maxlen)
{
	if(!TVPImportFuncPtr35b6a7e1c73f257aae91e05fa9826e84)
	{
		static char funcname[] = "tjs_int ::TJS_strnicmp(const tjs_char *,const tjs_char *,size_t)";
		TVPImportFuncPtr35b6a7e1c73f257aae91e05fa9826e84 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)(const tjs_char *, const tjs_char *, size_t);
	return ((__functype)(TVPImportFuncPtr35b6a7e1c73f257aae91e05fa9826e84))(s1, s2, maxlen);
}
inline tjs_int TJS_stricmp(const tjs_char * s1 , const tjs_char * s2)
{
	if(!TVPImportFuncPtra25b46701e25030af1ed847e0df229eb)
	{
		static char funcname[] = "tjs_int ::TJS_stricmp(const tjs_char *,const tjs_char *)";
		TVPImportFuncPtra25b46701e25030af1ed847e0df229eb = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)(const tjs_char *, const tjs_char *);
	return ((__functype)(TVPImportFuncPtra25b46701e25030af1ed847e0df229eb))(s1, s2);
}
inline void TJS_strcpy_maxlen(tjs_char * d , const tjs_char * s , size_t len)
{
	if(!TVPImportFuncPtrc8906bf1efa5e86f9fddfab55a01c8f6)
	{
		static char funcname[] = "void ::TJS_strcpy_maxlen(tjs_char *,const tjs_char *,size_t)";
		TVPImportFuncPtrc8906bf1efa5e86f9fddfab55a01c8f6 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_char *, const tjs_char *, size_t);
	((__functype)(TVPImportFuncPtrc8906bf1efa5e86f9fddfab55a01c8f6))(d, s, len);
}
inline void TJS_strcpy(tjs_char * d , const tjs_char * s)
{
	if(!TVPImportFuncPtr8141059f613820f694608af28e20cbad)
	{
		static char funcname[] = "void ::TJS_strcpy(tjs_char *,const tjs_char *)";
		TVPImportFuncPtr8141059f613820f694608af28e20cbad = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_char *, const tjs_char *);
	((__functype)(TVPImportFuncPtr8141059f613820f694608af28e20cbad))(d, s);
}
inline size_t TJS_strlen(const tjs_char * d)
{
	if(!TVPImportFuncPtrcf2690e47099ac6378ed50df4a8a8e90)
	{
		static char funcname[] = "size_t ::TJS_strlen(const tjs_char *)";
		TVPImportFuncPtrcf2690e47099ac6378ed50df4a8a8e90 = TVPGetImportFuncPtr(funcname);
	}
	typedef size_t (__stdcall * __functype)(const tjs_char *);
	return ((__functype)(TVPImportFuncPtrcf2690e47099ac6378ed50df4a8a8e90))(d);
}
inline tjs_char * TJSVS_malloc(tjs_uint len)
{
	if(!TVPImportFuncPtr810c7054e44f535cf250f00707105417)
	{
		static char funcname[] = "tjs_char * ::TJSVS_malloc(tjs_uint)";
		TVPImportFuncPtr810c7054e44f535cf250f00707105417 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_char * (__stdcall * __functype)(tjs_uint);
	return ((__functype)(TVPImportFuncPtr810c7054e44f535cf250f00707105417))(len);
}
inline tjs_char * TJSVS_realloc(tjs_char * buf , tjs_uint len)
{
	if(!TVPImportFuncPtr52a9af7905ddc71d8b4e0ef7366eebdd)
	{
		static char funcname[] = "tjs_char * ::TJSVS_realloc(tjs_char *,tjs_uint)";
		TVPImportFuncPtr52a9af7905ddc71d8b4e0ef7366eebdd = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_char * (__stdcall * __functype)(tjs_char *, tjs_uint);
	return ((__functype)(TVPImportFuncPtr52a9af7905ddc71d8b4e0ef7366eebdd))(buf, len);
}
inline void TJSVS_free(tjs_char * buf)
{
	if(!TVPImportFuncPtr1635dbae2d91b338ddfd0430f8aa7f10)
	{
		static char funcname[] = "void ::TJSVS_free(tjs_char *)";
		TVPImportFuncPtr1635dbae2d91b338ddfd0430f8aa7f10 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_char *);
	((__functype)(TVPImportFuncPtr1635dbae2d91b338ddfd0430f8aa7f10))(buf);
}
inline tTJSVariantString * TJSAllocVariantString(const tjs_char * ref1 , const tjs_char * ref2)
{
	if(!TVPImportFuncPtr30df0c29ad8f672f7fe0742b4b11cd7f)
	{
		static char funcname[] = "tTJSVariantString * ::TJSAllocVariantString(const tjs_char *,const tjs_char *)";
		TVPImportFuncPtr30df0c29ad8f672f7fe0742b4b11cd7f = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(const tjs_char *, const tjs_char *);
	return ((__functype)(TVPImportFuncPtr30df0c29ad8f672f7fe0742b4b11cd7f))(ref1, ref2);
}
inline tTJSVariantString * TJSAllocVariantString(const tjs_char * ref , tjs_int n)
{
	if(!TVPImportFuncPtr61c82dec644c58290a25f34a69478870)
	{
		static char funcname[] = "tTJSVariantString * ::TJSAllocVariantString(const tjs_char *,tjs_int)";
		TVPImportFuncPtr61c82dec644c58290a25f34a69478870 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(const tjs_char *, tjs_int);
	return ((__functype)(TVPImportFuncPtr61c82dec644c58290a25f34a69478870))(ref, n);
}
inline tTJSVariantString * TJSAllocVariantString(const tjs_char * ref)
{
	if(!TVPImportFuncPtrf08e347d2d47dc5fc9a3cb59355b4fbb)
	{
		static char funcname[] = "tTJSVariantString * ::TJSAllocVariantString(const tjs_char *)";
		TVPImportFuncPtrf08e347d2d47dc5fc9a3cb59355b4fbb = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(const tjs_char *);
	return ((__functype)(TVPImportFuncPtrf08e347d2d47dc5fc9a3cb59355b4fbb))(ref);
}
inline tTJSVariantString * TJSAllocVariantString(const tjs_nchar * ref)
{
	if(!TVPImportFuncPtr5c62e59c2062f658d4c79d5257a9a586)
	{
		static char funcname[] = "tTJSVariantString * ::TJSAllocVariantString(const tjs_nchar *)";
		TVPImportFuncPtr5c62e59c2062f658d4c79d5257a9a586 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(const tjs_nchar *);
	return ((__functype)(TVPImportFuncPtr5c62e59c2062f658d4c79d5257a9a586))(ref);
}
inline tTJSVariantString * TJSAllocVariantString(const tjs_uint8 * * src)
{
	if(!TVPImportFuncPtr259c72d8bfed1210ca71c54f24cacc7a)
	{
		static char funcname[] = "tTJSVariantString * ::TJSAllocVariantString(const tjs_uint8 * *)";
		TVPImportFuncPtr259c72d8bfed1210ca71c54f24cacc7a = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(const tjs_uint8 * *);
	return ((__functype)(TVPImportFuncPtr259c72d8bfed1210ca71c54f24cacc7a))(src);
}
inline tTJSVariantString * TJSAllocVariantStringBuffer(tjs_uint len)
{
	if(!TVPImportFuncPtr801a92ace08eb7ed001406869a39a75f)
	{
		static char funcname[] = "tTJSVariantString * ::TJSAllocVariantStringBuffer(tjs_uint)";
		TVPImportFuncPtr801a92ace08eb7ed001406869a39a75f = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(tjs_uint);
	return ((__functype)(TVPImportFuncPtr801a92ace08eb7ed001406869a39a75f))(len);
}
inline tTJSVariantString * TJSAppendVariantString(tTJSVariantString * str , const tjs_char * app)
{
	if(!TVPImportFuncPtre22e647af4ded8e51b1e76c845b4c8e2)
	{
		static char funcname[] = "tTJSVariantString * ::TJSAppendVariantString(tTJSVariantString *,const tjs_char *)";
		TVPImportFuncPtre22e647af4ded8e51b1e76c845b4c8e2 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(tTJSVariantString *, const tjs_char *);
	return ((__functype)(TVPImportFuncPtre22e647af4ded8e51b1e76c845b4c8e2))(str, app);
}
inline tTJSVariantString * TJSAppendVariantString(tTJSVariantString * str , const tTJSVariantString * app)
{
	if(!TVPImportFuncPtr12902221314df9bcf7f7cb74a5242fe0)
	{
		static char funcname[] = "tTJSVariantString * ::TJSAppendVariantString(tTJSVariantString *,const tTJSVariantString *)";
		TVPImportFuncPtr12902221314df9bcf7f7cb74a5242fe0 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(tTJSVariantString *, const tTJSVariantString *);
	return ((__functype)(TVPImportFuncPtr12902221314df9bcf7f7cb74a5242fe0))(str, app);
}
inline tTJSVariantString * TJSFormatString(const tjs_char * format , tjs_uint numparams , tTJSVariant * * params)
{
	if(!TVPImportFuncPtrb10feea1619ba8ac11237c12002cdb3e)
	{
		static char funcname[] = "tTJSVariantString * ::TJSFormatString(const tjs_char *,tjs_uint,tTJSVariant * *)";
		TVPImportFuncPtrb10feea1619ba8ac11237c12002cdb3e = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(const tjs_char *, tjs_uint , tTJSVariant * *);
	return ((__functype)(TVPImportFuncPtrb10feea1619ba8ac11237c12002cdb3e))(format, numparams, params);
}
inline const tjs_char * TJSVariantTypeToTypeString(tTJSVariantType type)
{
	if(!TVPImportFuncPtr19755b50d241edcb477bdcac22663778)
	{
		static char funcname[] = "const tjs_char * ::TJSVariantTypeToTypeString(tTJSVariantType)";
		TVPImportFuncPtr19755b50d241edcb477bdcac22663778 = TVPGetImportFuncPtr(funcname);
	}
	typedef const tjs_char * (__stdcall * __functype)(tTJSVariantType);
	return ((__functype)(TVPImportFuncPtr19755b50d241edcb477bdcac22663778))(type);
}
inline tTJSString TJSVariantToReadableString(const tTJSVariant & val , tjs_int maxlen = 512)
{
	if(!TVPImportFuncPtr040a0ecf46963e094ee8ec32ab3f1962)
	{
		static char funcname[] = "tTJSString ::TJSVariantToReadableString(const tTJSVariant &,tjs_int)";
		TVPImportFuncPtr040a0ecf46963e094ee8ec32ab3f1962 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSString (__stdcall * __functype)(const tTJSVariant &, tjs_int);
	return ((__functype)(TVPImportFuncPtr040a0ecf46963e094ee8ec32ab3f1962))(val, maxlen);
}
inline tTJSString TJSVariantToExpressionString(const tTJSVariant & val)
{
	if(!TVPImportFuncPtr525c529dc687b5d86424d775d00bdfce)
	{
		static char funcname[] = "tTJSString ::TJSVariantToExpressionString(const tTJSVariant &)";
		TVPImportFuncPtr525c529dc687b5d86424d775d00bdfce = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSString (__stdcall * __functype)(const tTJSVariant &);
	return ((__functype)(TVPImportFuncPtr525c529dc687b5d86424d775d00bdfce))(val);
}
inline void * TJSAlignedAlloc(tjs_uint bytes , tjs_uint align_bits)
{
	if(!TVPImportFuncPtrc96107b91e2a215f560a2612c6e85931)
	{
		static char funcname[] = "void * ::TJSAlignedAlloc(tjs_uint,tjs_uint)";
		TVPImportFuncPtrc96107b91e2a215f560a2612c6e85931 = TVPGetImportFuncPtr(funcname);
	}
	typedef void * (__stdcall * __functype)(tjs_uint , tjs_uint);
	return ((__functype)(TVPImportFuncPtrc96107b91e2a215f560a2612c6e85931))(bytes, align_bits);
}
inline void TJSAlignedDealloc(void * ptr)
{
	if(!TVPImportFuncPtrb8788eaa2ca495263c6ea2df264af5f5)
	{
		static char funcname[] = "void ::TJSAlignedDealloc(void *)";
		TVPImportFuncPtrb8788eaa2ca495263c6ea2df264af5f5 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(void *);
	((__functype)(TVPImportFuncPtrb8788eaa2ca495263c6ea2df264af5f5))(ptr);
}
inline tjs_uint32 TJSGetFPClass(tjs_real r)
{
	if(!TVPImportFuncPtr4c6494008c520d896d699f82aca30b25)
	{
		static char funcname[] = "tjs_uint32 ::TJSGetFPClass(tjs_real)";
		TVPImportFuncPtr4c6494008c520d896d699f82aca30b25 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_uint32 (__stdcall * __functype)(tjs_real);
	return ((__functype)(TVPImportFuncPtr4c6494008c520d896d699f82aca30b25))(r);
}
inline tTJSString operator +(const tjs_char * lhs , const tTJSString & rhs)
{
	if(!TVPImportFuncPtr7d8f8d5e0832ecf248b19a89801ead0e)
	{
		static char funcname[] = "tTJSString ::operator +(const tjs_char *,const tTJSString &)";
		TVPImportFuncPtr7d8f8d5e0832ecf248b19a89801ead0e = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSString (__stdcall * __functype)(const tjs_char *, const tTJSString &);
	return ((__functype)(TVPImportFuncPtr7d8f8d5e0832ecf248b19a89801ead0e))(lhs, rhs);
}
inline tTJSString TJSInt32ToHex(tjs_uint32 num , int zeropad = 8)
{
	if(!TVPImportFuncPtr70849965060a6402f41b0b11ec2bb3a7)
	{
		static char funcname[] = "tTJSString ::TJSInt32ToHex(tjs_uint32,int)";
		TVPImportFuncPtr70849965060a6402f41b0b11ec2bb3a7 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSString (__stdcall * __functype)(tjs_uint32 , int);
	return ((__functype)(TVPImportFuncPtr70849965060a6402f41b0b11ec2bb3a7))(num, zeropad);
}
inline tjs_int32 TJSRegisterNativeClass(const tjs_char * name)
{
	if(!TVPImportFuncPtrc72efa6b4efaa6664ae637a03e98e866)
	{
		static char funcname[] = "tjs_int32 ::TJSRegisterNativeClass(const tjs_char *)";
		TVPImportFuncPtrc72efa6b4efaa6664ae637a03e98e866 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int32 (__stdcall * __functype)(const tjs_char *);
	return ((__functype)(TVPImportFuncPtrc72efa6b4efaa6664ae637a03e98e866))(name);
}
inline tjs_int32 TJSFindNativeClassID(const tjs_char * name)
{
	if(!TVPImportFuncPtra250e46575d0df1166e1542613218a5c)
	{
		static char funcname[] = "tjs_int32 ::TJSFindNativeClassID(const tjs_char *)";
		TVPImportFuncPtra250e46575d0df1166e1542613218a5c = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int32 (__stdcall * __functype)(const tjs_char *);
	return ((__functype)(TVPImportFuncPtra250e46575d0df1166e1542613218a5c))(name);
}
inline const tjs_char * TJSFindNativeClassName(tjs_int32 id)
{
	if(!TVPImportFuncPtra7bcff67b8d380c225b9d0d83921b3ae)
	{
		static char funcname[] = "const tjs_char * ::TJSFindNativeClassName(tjs_int32)";
		TVPImportFuncPtra7bcff67b8d380c225b9d0d83921b3ae = TVPGetImportFuncPtr(funcname);
	}
	typedef const tjs_char * (__stdcall * __functype)(tjs_int32);
	return ((__functype)(TVPImportFuncPtra7bcff67b8d380c225b9d0d83921b3ae))(id);
}
inline tTJSNativeClassMethod * TJSCreateNativeClassMethod(tTJSNativeClassMethodCallback callback)
{
	if(!TVPImportFuncPtrfb68a3aa16bd2eb7d7550283170321bf)
	{
		static char funcname[] = "tTJSNativeClassMethod * ::TJSCreateNativeClassMethod(tTJSNativeClassMethodCallback)";
		TVPImportFuncPtrfb68a3aa16bd2eb7d7550283170321bf = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSNativeClassMethod * (__stdcall * __functype)(tTJSNativeClassMethodCallback);
	return ((__functype)(TVPImportFuncPtrfb68a3aa16bd2eb7d7550283170321bf))(callback);
}
inline tTJSNativeClassMethod * TJSCreateNativeClassConstructor(tTJSNativeClassMethodCallback callback)
{
	if(!TVPImportFuncPtr35b4299ede11f511b331b713ba9f38a8)
	{
		static char funcname[] = "tTJSNativeClassMethod * ::TJSCreateNativeClassConstructor(tTJSNativeClassMethodCallback)";
		TVPImportFuncPtr35b4299ede11f511b331b713ba9f38a8 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSNativeClassMethod * (__stdcall * __functype)(tTJSNativeClassMethodCallback);
	return ((__functype)(TVPImportFuncPtr35b4299ede11f511b331b713ba9f38a8))(callback);
}
inline tTJSNativeClassProperty * TJSCreateNativeClassProperty(tTJSNativeClassPropertyGetCallback get , tTJSNativeClassPropertySetCallback set)
{
	if(!TVPImportFuncPtrefe52691cff20b2dfaa16e8e16caac0a)
	{
		static char funcname[] = "tTJSNativeClassProperty * ::TJSCreateNativeClassProperty(tTJSNativeClassPropertyGetCallback,tTJSNativeClassPropertySetCallback)";
		TVPImportFuncPtrefe52691cff20b2dfaa16e8e16caac0a = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSNativeClassProperty * (__stdcall * __functype)(tTJSNativeClassPropertyGetCallback , tTJSNativeClassPropertySetCallback);
	return ((__functype)(TVPImportFuncPtrefe52691cff20b2dfaa16e8e16caac0a))(get, set);
}
inline void TJSNativeClassRegisterNCM(tTJSNativeClass * cls , const tjs_char * name , iTJSDispatch2 * dsp , const tjs_char * classname , tTJSNativeInstanceType type , tjs_uint32 flags = 0)
{
	if(!TVPImportFuncPtr38eed43ef69251c34dc45695b8cf35c0)
	{
		static char funcname[] = "void ::TJSNativeClassRegisterNCM(tTJSNativeClass *,const tjs_char *,iTJSDispatch2 *,const tjs_char *,tTJSNativeInstanceType,tjs_uint32)";
		TVPImportFuncPtr38eed43ef69251c34dc45695b8cf35c0 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tTJSNativeClass *, const tjs_char *, iTJSDispatch2 *, const tjs_char *, tTJSNativeInstanceType , tjs_uint32);
	((__functype)(TVPImportFuncPtr38eed43ef69251c34dc45695b8cf35c0))(cls, name, dsp, classname, type, flags);
}
inline void TJSNativeClassSetClassID(tTJSNativeClass * cls , tjs_int32 classid)
{
	if(!TVPImportFuncPtr2058b65abdfb7598910f0d584d40a19d)
	{
		static char funcname[] = "void ::TJSNativeClassSetClassID(tTJSNativeClass *,tjs_int32)";
		TVPImportFuncPtr2058b65abdfb7598910f0d584d40a19d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tTJSNativeClass *, tjs_int32);
	((__functype)(TVPImportFuncPtr2058b65abdfb7598910f0d584d40a19d))(cls, classid);
}
inline tTJSNativeClassForPlugin * TJSCreateNativeClassForPlugin(const ttstr & name , tTJSCreateNativeInstance createinstance)
{
	if(!TVPImportFuncPtr1ebecaefe2ffdc811fccbac42e67e544)
	{
		static char funcname[] = "tTJSNativeClassForPlugin * ::TJSCreateNativeClassForPlugin(const ttstr &,tTJSCreateNativeInstance)";
		TVPImportFuncPtr1ebecaefe2ffdc811fccbac42e67e544 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSNativeClassForPlugin * (__stdcall * __functype)(const ttstr &, tTJSCreateNativeInstance);
	return ((__functype)(TVPImportFuncPtr1ebecaefe2ffdc811fccbac42e67e544))(name, createinstance);
}
inline void TJSThrowNullAccess()
{
	if(!TVPImportFuncPtr09e0f0912f8d758d3736ece9478c2686)
	{
		static char funcname[] = "void ::TJSThrowNullAccess()";
		TVPImportFuncPtr09e0f0912f8d758d3736ece9478c2686 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtr09e0f0912f8d758d3736ece9478c2686))();
}
inline void TJSThrowDivideByZero()
{
	if(!TVPImportFuncPtr23d61eda3959b087b618e348471e2c36)
	{
		static char funcname[] = "void ::TJSThrowDivideByZero()";
		TVPImportFuncPtr23d61eda3959b087b618e348471e2c36 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtr23d61eda3959b087b618e348471e2c36))();
}
inline tTJSVariantOctet * TJSAllocVariantOctet(const tjs_uint8 * data , tjs_uint length)
{
	if(!TVPImportFuncPtre99b22c79b5bf04f3382f959c7bb69ca)
	{
		static char funcname[] = "tTJSVariantOctet * ::TJSAllocVariantOctet(const tjs_uint8 *,tjs_uint)";
		TVPImportFuncPtre99b22c79b5bf04f3382f959c7bb69ca = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantOctet * (__stdcall * __functype)(const tjs_uint8 *, tjs_uint);
	return ((__functype)(TVPImportFuncPtre99b22c79b5bf04f3382f959c7bb69ca))(data, length);
}
inline tTJSVariantOctet * TJSAllocVariantOctet(const tjs_uint8 * data1 , tjs_uint len1 , const tjs_uint8 * data2 , tjs_uint len2)
{
	if(!TVPImportFuncPtr9c4bb9ebee4db0fcebeae11c34950f97)
	{
		static char funcname[] = "tTJSVariantOctet * ::TJSAllocVariantOctet(const tjs_uint8 *,tjs_uint,const tjs_uint8 *,tjs_uint)";
		TVPImportFuncPtr9c4bb9ebee4db0fcebeae11c34950f97 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantOctet * (__stdcall * __functype)(const tjs_uint8 *, tjs_uint , const tjs_uint8 *, tjs_uint);
	return ((__functype)(TVPImportFuncPtr9c4bb9ebee4db0fcebeae11c34950f97))(data1, len1, data2, len2);
}
inline tTJSVariantOctet * TJSAllocVariantOctet(const tTJSVariantOctet * o1 , const tTJSVariantOctet * o2)
{
	if(!TVPImportFuncPtr505a9563aeb1b0255cfcc8197bee7d9e)
	{
		static char funcname[] = "tTJSVariantOctet * ::TJSAllocVariantOctet(const tTJSVariantOctet *,const tTJSVariantOctet *)";
		TVPImportFuncPtr505a9563aeb1b0255cfcc8197bee7d9e = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantOctet * (__stdcall * __functype)(const tTJSVariantOctet *, const tTJSVariantOctet *);
	return ((__functype)(TVPImportFuncPtr505a9563aeb1b0255cfcc8197bee7d9e))(o1, o2);
}
inline tTJSVariantOctet * TJSAllocVariantOctet(const tjs_uint8 * * src)
{
	if(!TVPImportFuncPtrf5ab80fc67ee04570330b9035144e760)
	{
		static char funcname[] = "tTJSVariantOctet * ::TJSAllocVariantOctet(const tjs_uint8 * *)";
		TVPImportFuncPtrf5ab80fc67ee04570330b9035144e760 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantOctet * (__stdcall * __functype)(const tjs_uint8 * *);
	return ((__functype)(TVPImportFuncPtrf5ab80fc67ee04570330b9035144e760))(src);
}
inline void TJSDeallocVariantOctet(tTJSVariantOctet * o)
{
	if(!TVPImportFuncPtraf50188bbaa019ee88b19ecd931f7cce)
	{
		static char funcname[] = "void ::TJSDeallocVariantOctet(tTJSVariantOctet *)";
		TVPImportFuncPtraf50188bbaa019ee88b19ecd931f7cce = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tTJSVariantOctet *);
	((__functype)(TVPImportFuncPtraf50188bbaa019ee88b19ecd931f7cce))(o);
}
inline tTJSVariantString * TJSOctetToListString(const tTJSVariantOctet * oct)
{
	if(!TVPImportFuncPtr268c452e85a6ac75301a6132f4f5e38b)
	{
		static char funcname[] = "tTJSVariantString * ::TJSOctetToListString(const tTJSVariantOctet *)";
		TVPImportFuncPtr268c452e85a6ac75301a6132f4f5e38b = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(const tTJSVariantOctet *);
	return ((__functype)(TVPImportFuncPtr268c452e85a6ac75301a6132f4f5e38b))(oct);
}
inline tTJSVariantString * TJSObjectToString(const tTJSVariantClosure & dsp)
{
	if(!TVPImportFuncPtr646770a19b1768b372c9991ef0d3de85)
	{
		static char funcname[] = "tTJSVariantString * ::TJSObjectToString(const tTJSVariantClosure &)";
		TVPImportFuncPtr646770a19b1768b372c9991ef0d3de85 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(const tTJSVariantClosure &);
	return ((__functype)(TVPImportFuncPtr646770a19b1768b372c9991ef0d3de85))(dsp);
}
inline tTJSVariantString * TJSIntegerToString(tjs_int64 i)
{
	if(!TVPImportFuncPtr5ec88e04fcb8e1877752281e172173ed)
	{
		static char funcname[] = "tTJSVariantString * ::TJSIntegerToString(tjs_int64)";
		TVPImportFuncPtr5ec88e04fcb8e1877752281e172173ed = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(tjs_int64);
	return ((__functype)(TVPImportFuncPtr5ec88e04fcb8e1877752281e172173ed))(i);
}
inline tTJSVariantString * TJSRealToString(tjs_real r)
{
	if(!TVPImportFuncPtr923f8161f2d2ba0e883bc4edc2901960)
	{
		static char funcname[] = "tTJSVariantString * ::TJSRealToString(tjs_real)";
		TVPImportFuncPtr923f8161f2d2ba0e883bc4edc2901960 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(tjs_real);
	return ((__functype)(TVPImportFuncPtr923f8161f2d2ba0e883bc4edc2901960))(r);
}
inline tTJSVariantString * TJSRealToHexString(tjs_real r)
{
	if(!TVPImportFuncPtr6f70cdb7586cbe571204f286f43c9780)
	{
		static char funcname[] = "tTJSVariantString * ::TJSRealToHexString(tjs_real)";
		TVPImportFuncPtr6f70cdb7586cbe571204f286f43c9780 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSVariantString * (__stdcall * __functype)(tjs_real);
	return ((__functype)(TVPImportFuncPtr6f70cdb7586cbe571204f286f43c9780))(r);
}
inline tTVInteger TJSStringToInteger(const tjs_char * str)
{
	if(!TVPImportFuncPtr9a4eaa6a627038799015c093609bdde7)
	{
		static char funcname[] = "tTVInteger ::TJSStringToInteger(const tjs_char *)";
		TVPImportFuncPtr9a4eaa6a627038799015c093609bdde7 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTVInteger (__stdcall * __functype)(const tjs_char *);
	return ((__functype)(TVPImportFuncPtr9a4eaa6a627038799015c093609bdde7))(str);
}
inline tTVReal TJSStringToReal(const tjs_char * str)
{
	if(!TVPImportFuncPtrc8bb6590f4a7adc906d7b3e42d907267)
	{
		static char funcname[] = "tTVReal ::TJSStringToReal(const tjs_char *)";
		TVPImportFuncPtrc8bb6590f4a7adc906d7b3e42d907267 = TVPGetImportFuncPtr(funcname);
	}
	typedef tTVReal (__stdcall * __functype)(const tjs_char *);
	return ((__functype)(TVPImportFuncPtrc8bb6590f4a7adc906d7b3e42d907267))(str);
}
inline iTJSDispatch2 * TJSCreateArrayObject(iTJSDispatch2 * * classout = NULL)
{
	if(!TVPImportFuncPtr8323d57f26876d87271dbfa257b7f7e2)
	{
		static char funcname[] = "iTJSDispatch2 * ::TJSCreateArrayObject(iTJSDispatch2 * *)";
		TVPImportFuncPtr8323d57f26876d87271dbfa257b7f7e2 = TVPGetImportFuncPtr(funcname);
	}
	typedef iTJSDispatch2 * (__stdcall * __functype)(iTJSDispatch2 * *);
	return ((__functype)(TVPImportFuncPtr8323d57f26876d87271dbfa257b7f7e2))(classout);
}
inline tjs_int TJSGetArrayElementCount(iTJSDispatch2 * dsp)
{
	if(!TVPImportFuncPtr4d6f148e8997e1ae0cc0006ec1bd9618)
	{
		static char funcname[] = "tjs_int ::TJSGetArrayElementCount(iTJSDispatch2 *)";
		TVPImportFuncPtr4d6f148e8997e1ae0cc0006ec1bd9618 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)(iTJSDispatch2 *);
	return ((__functype)(TVPImportFuncPtr4d6f148e8997e1ae0cc0006ec1bd9618))(dsp);
}
inline tjs_int TJSCopyArrayElementTo(iTJSDispatch2 * dsp , tTJSVariant * dest , tjs_uint start , tjs_int count)
{
	if(!TVPImportFuncPtr7f03a4ddb254d0518642d15513eaea85)
	{
		static char funcname[] = "tjs_int ::TJSCopyArrayElementTo(iTJSDispatch2 *,tTJSVariant *,tjs_uint,tjs_int)";
		TVPImportFuncPtr7f03a4ddb254d0518642d15513eaea85 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)(iTJSDispatch2 *, tTJSVariant *, tjs_uint , tjs_int);
	return ((__functype)(TVPImportFuncPtr7f03a4ddb254d0518642d15513eaea85))(dsp, dest, start, count);
}
inline iTJSDispatch2 * TJSCreateDictionaryObject(iTJSDispatch2 * * classout = NULL)
{
	if(!TVPImportFuncPtr4add3926c72ba9df9259be58b680de0d)
	{
		static char funcname[] = "iTJSDispatch2 * ::TJSCreateDictionaryObject(iTJSDispatch2 * *)";
		TVPImportFuncPtr4add3926c72ba9df9259be58b680de0d = TVPGetImportFuncPtr(funcname);
	}
	typedef iTJSDispatch2 * (__stdcall * __functype)(iTJSDispatch2 * *);
	return ((__functype)(TVPImportFuncPtr4add3926c72ba9df9259be58b680de0d))(classout);
}
inline ttstr TJSGetMessageMapMessage(const tjs_char * name)
{
	if(!TVPImportFuncPtr075d42cff8dc0c1fbd99c7459a63e526)
	{
		static char funcname[] = "ttstr ::TJSGetMessageMapMessage(const tjs_char *)";
		TVPImportFuncPtr075d42cff8dc0c1fbd99c7459a63e526 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)(const tjs_char *);
	return ((__functype)(TVPImportFuncPtr075d42cff8dc0c1fbd99c7459a63e526))(name);
}
inline ttstr TJSMapGlobalStringMap(const ttstr & string)
{
	if(!TVPImportFuncPtrb6bc45b28e194c7ac98bfdea88edee36)
	{
		static char funcname[] = "ttstr ::TJSMapGlobalStringMap(const ttstr &)";
		TVPImportFuncPtrb6bc45b28e194c7ac98bfdea88edee36 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtrb6bc45b28e194c7ac98bfdea88edee36))(string);
}
inline void TJSDoVariantOperation(tjs_int op , tTJSVariant & target , const tTJSVariant * param)
{
	if(!TVPImportFuncPtr6dff6abb075da1a304520e60c011ef7b)
	{
		static char funcname[] = "void ::TJSDoVariantOperation(tjs_int,tTJSVariant &,const tTJSVariant *)";
		TVPImportFuncPtr6dff6abb075da1a304520e60c011ef7b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_int , tTJSVariant &, const tTJSVariant *);
	((__functype)(TVPImportFuncPtr6dff6abb075da1a304520e60c011ef7b))(op, target, param);
}
inline void TJSDoRehash()
{
	if(!TVPImportFuncPtr892ffbdb8375851fc557e4abe9589b77)
	{
		static char funcname[] = "void ::TJSDoRehash()";
		TVPImportFuncPtr892ffbdb8375851fc557e4abe9589b77 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtr892ffbdb8375851fc557e4abe9589b77))();
}
inline iTJSDispatch2 * TJSCreateCustomObject()
{
	if(!TVPImportFuncPtrb2f3538284fc2adda2a43272ee654a96)
	{
		static char funcname[] = "iTJSDispatch2 * ::TJSCreateCustomObject()";
		TVPImportFuncPtrb2f3538284fc2adda2a43272ee654a96 = TVPGetImportFuncPtr(funcname);
	}
	typedef iTJSDispatch2 * (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtrb2f3538284fc2adda2a43272ee654a96))();
}
inline ttstr TVPGetTemporaryName()
{
	if(!TVPImportFuncPtre0ff899ea4a9cc49a0e3b38deaf93b45)
	{
		static char funcname[] = "ttstr ::TVPGetTemporaryName()";
		TVPImportFuncPtre0ff899ea4a9cc49a0e3b38deaf93b45 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtre0ff899ea4a9cc49a0e3b38deaf93b45))();
}
inline ttstr TVPGetAppPath()
{
	if(!TVPImportFuncPtr4b9c9ac2aafad07af4b16f34e9d4bba2)
	{
		static char funcname[] = "ttstr ::TVPGetAppPath()";
		TVPImportFuncPtr4b9c9ac2aafad07af4b16f34e9d4bba2 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtr4b9c9ac2aafad07af4b16f34e9d4bba2))();
}
inline void TVPRegisterStorageMedia(iTVPStorageMedia * media)
{
	if(!TVPImportFuncPtrc2e423356d9ca3f26f9c1d294ee9b742)
	{
		static char funcname[] = "void ::TVPRegisterStorageMedia(iTVPStorageMedia *)";
		TVPImportFuncPtrc2e423356d9ca3f26f9c1d294ee9b742 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(iTVPStorageMedia *);
	((__functype)(TVPImportFuncPtrc2e423356d9ca3f26f9c1d294ee9b742))(media);
}
inline void TVPUnregisterStorageMedia(iTVPStorageMedia * media)
{
	if(!TVPImportFuncPtrc07314686fdf5815ce9b058020da942b)
	{
		static char funcname[] = "void ::TVPUnregisterStorageMedia(iTVPStorageMedia *)";
		TVPImportFuncPtrc07314686fdf5815ce9b058020da942b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(iTVPStorageMedia *);
	((__functype)(TVPImportFuncPtrc07314686fdf5815ce9b058020da942b))(media);
}
inline bool TVPIsExistentStorageNoSearch(const ttstr & name)
{
	if(!TVPImportFuncPtr4a197be1985d45ee86d5672d24134560)
	{
		static char funcname[] = "bool ::TVPIsExistentStorageNoSearch(const ttstr &)";
		TVPImportFuncPtr4a197be1985d45ee86d5672d24134560 = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtr4a197be1985d45ee86d5672d24134560))(name);
}
inline bool TVPIsExistentStorageNoSearchNoNormalize(const ttstr & name)
{
	if(!TVPImportFuncPtrdec720a9c3cd2b378f195cf71a9ff8b0)
	{
		static char funcname[] = "bool ::TVPIsExistentStorageNoSearchNoNormalize(const ttstr &)";
		TVPImportFuncPtrdec720a9c3cd2b378f195cf71a9ff8b0 = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtrdec720a9c3cd2b378f195cf71a9ff8b0))(name);
}
inline ttstr TVPNormalizeStorageName(const ttstr & name)
{
	if(!TVPImportFuncPtr5726a5c7af641ebaa504dc9ec8380938)
	{
		static char funcname[] = "ttstr ::TVPNormalizeStorageName(const ttstr &)";
		TVPImportFuncPtr5726a5c7af641ebaa504dc9ec8380938 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtr5726a5c7af641ebaa504dc9ec8380938))(name);
}
inline void TVPSetCurrentDirectory(const ttstr & name)
{
	if(!TVPImportFuncPtr1c53bc96ac9dfd483c2227bc5fa44825)
	{
		static char funcname[] = "void ::TVPSetCurrentDirectory(const ttstr &)";
		TVPImportFuncPtr1c53bc96ac9dfd483c2227bc5fa44825 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &);
	((__functype)(TVPImportFuncPtr1c53bc96ac9dfd483c2227bc5fa44825))(name);
}
inline void TVPGetLocalName(ttstr & name)
{
	if(!TVPImportFuncPtr1940c8fa03145aa029d0b7718ce0c809)
	{
		static char funcname[] = "void ::TVPGetLocalName(ttstr &)";
		TVPImportFuncPtr1940c8fa03145aa029d0b7718ce0c809 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(ttstr &);
	((__functype)(TVPImportFuncPtr1940c8fa03145aa029d0b7718ce0c809))(name);
}
inline ttstr TVPExtractStorageExt(const ttstr & name)
{
	if(!TVPImportFuncPtrb37f047c0f9bd143b34a2fc87ce5f16e)
	{
		static char funcname[] = "ttstr ::TVPExtractStorageExt(const ttstr &)";
		TVPImportFuncPtrb37f047c0f9bd143b34a2fc87ce5f16e = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtrb37f047c0f9bd143b34a2fc87ce5f16e))(name);
}
inline ttstr TVPExtractStorageName(const ttstr & name)
{
	if(!TVPImportFuncPtrdec35fbd2a24fc32e5c220174d864cf4)
	{
		static char funcname[] = "ttstr ::TVPExtractStorageName(const ttstr &)";
		TVPImportFuncPtrdec35fbd2a24fc32e5c220174d864cf4 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtrdec35fbd2a24fc32e5c220174d864cf4))(name);
}
inline ttstr TVPExtractStoragePath(const ttstr & name)
{
	if(!TVPImportFuncPtr86fd45a126296891aee413388597203e)
	{
		static char funcname[] = "ttstr ::TVPExtractStoragePath(const ttstr &)";
		TVPImportFuncPtr86fd45a126296891aee413388597203e = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtr86fd45a126296891aee413388597203e))(name);
}
inline ttstr TVPChopStorageExt(const ttstr & name)
{
	if(!TVPImportFuncPtr603243e54f3508c37d993e8359b735dc)
	{
		static char funcname[] = "ttstr ::TVPChopStorageExt(const ttstr &)";
		TVPImportFuncPtr603243e54f3508c37d993e8359b735dc = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtr603243e54f3508c37d993e8359b735dc))(name);
}
inline void TVPAddAutoPath(const ttstr & name)
{
	if(!TVPImportFuncPtrc3eadbd75b32dabe6faecebf492eb486)
	{
		static char funcname[] = "void ::TVPAddAutoPath(const ttstr &)";
		TVPImportFuncPtrc3eadbd75b32dabe6faecebf492eb486 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &);
	((__functype)(TVPImportFuncPtrc3eadbd75b32dabe6faecebf492eb486))(name);
}
inline void TVPRemoveAutoPath(const ttstr & name)
{
	if(!TVPImportFuncPtr725e49de1d970ef04b179776666f2c34)
	{
		static char funcname[] = "void ::TVPRemoveAutoPath(const ttstr &)";
		TVPImportFuncPtr725e49de1d970ef04b179776666f2c34 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &);
	((__functype)(TVPImportFuncPtr725e49de1d970ef04b179776666f2c34))(name);
}
inline ttstr TVPGetPlacedPath(const ttstr & name)
{
	if(!TVPImportFuncPtr55a9b73f877bfd4c6d8157e7b1c458df)
	{
		static char funcname[] = "ttstr ::TVPGetPlacedPath(const ttstr &)";
		TVPImportFuncPtr55a9b73f877bfd4c6d8157e7b1c458df = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtr55a9b73f877bfd4c6d8157e7b1c458df))(name);
}
inline bool TVPIsExistentStorage(const ttstr & name)
{
	if(!TVPImportFuncPtrd070209f152dd22087e6e996e02c85cf)
	{
		static char funcname[] = "bool ::TVPIsExistentStorage(const ttstr &)";
		TVPImportFuncPtrd070209f152dd22087e6e996e02c85cf = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtrd070209f152dd22087e6e996e02c85cf))(name);
}
inline void TVPClearStorageCaches()
{
	if(!TVPImportFuncPtr308f905626bc51c7ef9b65b2c0ca34b2)
	{
		static char funcname[] = "void ::TVPClearStorageCaches()";
		TVPImportFuncPtr308f905626bc51c7ef9b65b2c0ca34b2 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtr308f905626bc51c7ef9b65b2c0ca34b2))();
}
inline iTJSTextReadStream * TVPCreateTextStreamForRead(const ttstr & name , const ttstr & modestr)
{
	if(!TVPImportFuncPtr95aab2a1ac9491e8026f4977e0918760)
	{
		static char funcname[] = "iTJSTextReadStream * ::TVPCreateTextStreamForRead(const ttstr &,const ttstr &)";
		TVPImportFuncPtr95aab2a1ac9491e8026f4977e0918760 = TVPGetImportFuncPtr(funcname);
	}
	typedef iTJSTextReadStream * (__stdcall * __functype)(const ttstr &, const ttstr &);
	return ((__functype)(TVPImportFuncPtr95aab2a1ac9491e8026f4977e0918760))(name, modestr);
}
inline iTJSTextWriteStream * TVPCreateTextStreamForWrite(const ttstr & name , const ttstr & modestr)
{
	if(!TVPImportFuncPtr0c99a79e866f08b4df3914e83fc203dc)
	{
		static char funcname[] = "iTJSTextWriteStream * ::TVPCreateTextStreamForWrite(const ttstr &,const ttstr &)";
		TVPImportFuncPtr0c99a79e866f08b4df3914e83fc203dc = TVPGetImportFuncPtr(funcname);
	}
	typedef iTJSTextWriteStream * (__stdcall * __functype)(const ttstr &, const ttstr &);
	return ((__functype)(TVPImportFuncPtr0c99a79e866f08b4df3914e83fc203dc))(name, modestr);
}
inline tjs_int TVPWideCharToUtf8String(const tjs_char * in , char * out)
{
	if(!TVPImportFuncPtr900476efbc2031e643c042ca8e63a3d7)
	{
		static char funcname[] = "tjs_int ::TVPWideCharToUtf8String(const tjs_char *,char *)";
		TVPImportFuncPtr900476efbc2031e643c042ca8e63a3d7 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)(const tjs_char *, char *);
	return ((__functype)(TVPImportFuncPtr900476efbc2031e643c042ca8e63a3d7))(in, out);
}
inline tjs_int TVPUtf8ToWideCharString(const char * in , tjs_char * out)
{
	if(!TVPImportFuncPtr07dfce61d490cf671a2d5359d713d64a)
	{
		static char funcname[] = "tjs_int ::TVPUtf8ToWideCharString(const char *,tjs_char *)";
		TVPImportFuncPtr07dfce61d490cf671a2d5359d713d64a = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)(const char *, tjs_char *);
	return ((__functype)(TVPImportFuncPtr07dfce61d490cf671a2d5359d713d64a))(in, out);
}
inline void TVPSetXP3ArchiveExtractionFilter(tTVPXP3ArchiveExtractionFilter filter)
{
	if(!TVPImportFuncPtr52d30ac8479ef7e870b5aff076482799)
	{
		static char funcname[] = "void ::TVPSetXP3ArchiveExtractionFilter(tTVPXP3ArchiveExtractionFilter)";
		TVPImportFuncPtr52d30ac8479ef7e870b5aff076482799 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tTVPXP3ArchiveExtractionFilter);
	((__functype)(TVPImportFuncPtr52d30ac8479ef7e870b5aff076482799))(filter);
}
inline void TVPBreathe()
{
	if(!TVPImportFuncPtr8e4d0392ed46e87f94e5fcf675a124a1)
	{
		static char funcname[] = "void ::TVPBreathe()";
		TVPImportFuncPtr8e4d0392ed46e87f94e5fcf675a124a1 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtr8e4d0392ed46e87f94e5fcf675a124a1))();
}
inline bool TVPGetBreathing()
{
	if(!TVPImportFuncPtr73f46e08d17e707725f433b454f05a89)
	{
		static char funcname[] = "bool ::TVPGetBreathing()";
		TVPImportFuncPtr73f46e08d17e707725f433b454f05a89 = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtr73f46e08d17e707725f433b454f05a89))();
}
inline void TVPSetSystemEventDisabledState(bool en)
{
	if(!TVPImportFuncPtr80d60e682fa72973071e335db272a2a2)
	{
		static char funcname[] = "void ::TVPSetSystemEventDisabledState(bool)";
		TVPImportFuncPtr80d60e682fa72973071e335db272a2a2 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(bool);
	((__functype)(TVPImportFuncPtr80d60e682fa72973071e335db272a2a2))(en);
}
inline bool TVPGetSystemEventDisabledState()
{
	if(!TVPImportFuncPtr6bd6262185fa0b9cf1750f6a525d893a)
	{
		static char funcname[] = "bool ::TVPGetSystemEventDisabledState()";
		TVPImportFuncPtr6bd6262185fa0b9cf1750f6a525d893a = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtr6bd6262185fa0b9cf1750f6a525d893a))();
}
inline void TVPPostEvent(iTJSDispatch2 * source , iTJSDispatch2 * target , ttstr & eventname , tjs_uint32 tag , tjs_uint32 flag , tjs_uint numargs , tTJSVariant * args)
{
	if(!TVPImportFuncPtrcf29f737d4eb450b26789d421d0ec69a)
	{
		static char funcname[] = "void ::TVPPostEvent(iTJSDispatch2 *,iTJSDispatch2 *,ttstr &,tjs_uint32,tjs_uint32,tjs_uint,tTJSVariant *)";
		TVPImportFuncPtrcf29f737d4eb450b26789d421d0ec69a = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(iTJSDispatch2 *, iTJSDispatch2 *, ttstr &, tjs_uint32 , tjs_uint32 , tjs_uint , tTJSVariant *);
	((__functype)(TVPImportFuncPtrcf29f737d4eb450b26789d421d0ec69a))(source, target, eventname, tag, flag, numargs, args);
}
inline tjs_int TVPCancelEvents(iTJSDispatch2 * source , iTJSDispatch2 * target , const ttstr & eventname , tjs_uint32 tag = 0)
{
	if(!TVPImportFuncPtr13c0e371c08fd1b9da2f0c103d01c59a)
	{
		static char funcname[] = "tjs_int ::TVPCancelEvents(iTJSDispatch2 *,iTJSDispatch2 *,const ttstr &,tjs_uint32)";
		TVPImportFuncPtr13c0e371c08fd1b9da2f0c103d01c59a = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)(iTJSDispatch2 *, iTJSDispatch2 *, const ttstr &, tjs_uint32);
	return ((__functype)(TVPImportFuncPtr13c0e371c08fd1b9da2f0c103d01c59a))(source, target, eventname, tag);
}
inline bool TVPAreEventsInQueue(iTJSDispatch2 * source , iTJSDispatch2 * target , const ttstr & eventname , tjs_uint32 tag)
{
	if(!TVPImportFuncPtr82693e38df8f033ea98f9b7969d66d7b)
	{
		static char funcname[] = "bool ::TVPAreEventsInQueue(iTJSDispatch2 *,iTJSDispatch2 *,const ttstr &,tjs_uint32)";
		TVPImportFuncPtr82693e38df8f033ea98f9b7969d66d7b = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(iTJSDispatch2 *, iTJSDispatch2 *, const ttstr &, tjs_uint32);
	return ((__functype)(TVPImportFuncPtr82693e38df8f033ea98f9b7969d66d7b))(source, target, eventname, tag);
}
inline tjs_int TVPCountEventsInQueue(iTJSDispatch2 * source , iTJSDispatch2 * target , const ttstr & eventname , tjs_uint32 tag)
{
	if(!TVPImportFuncPtr6e3f8a3b18f55dae6153a889f00a3e87)
	{
		static char funcname[] = "tjs_int ::TVPCountEventsInQueue(iTJSDispatch2 *,iTJSDispatch2 *,const ttstr &,tjs_uint32)";
		TVPImportFuncPtr6e3f8a3b18f55dae6153a889f00a3e87 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)(iTJSDispatch2 *, iTJSDispatch2 *, const ttstr &, tjs_uint32);
	return ((__functype)(TVPImportFuncPtr6e3f8a3b18f55dae6153a889f00a3e87))(source, target, eventname, tag);
}
inline void TVPCancelEventsByTag(iTJSDispatch2 * source , iTJSDispatch2 * target , tjs_uint32 tag = 0)
{
	if(!TVPImportFuncPtrefe14a197131b4813656d6669cc3475b)
	{
		static char funcname[] = "void ::TVPCancelEventsByTag(iTJSDispatch2 *,iTJSDispatch2 *,tjs_uint32)";
		TVPImportFuncPtrefe14a197131b4813656d6669cc3475b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(iTJSDispatch2 *, iTJSDispatch2 *, tjs_uint32);
	((__functype)(TVPImportFuncPtrefe14a197131b4813656d6669cc3475b))(source, target, tag);
}
inline void TVPCancelSourceEvents(iTJSDispatch2 * source)
{
	if(!TVPImportFuncPtrba4ecf60f872f757b69c84f457b3e941)
	{
		static char funcname[] = "void ::TVPCancelSourceEvents(iTJSDispatch2 *)";
		TVPImportFuncPtrba4ecf60f872f757b69c84f457b3e941 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(iTJSDispatch2 *);
	((__functype)(TVPImportFuncPtrba4ecf60f872f757b69c84f457b3e941))(source);
}
inline iTJSDispatch2 * TVPCreateEventObject(const tjs_char * type , iTJSDispatch2 * targthis , iTJSDispatch2 * targ)
{
	if(!TVPImportFuncPtrdffedabe32ce886e3b7e695b44ad3547)
	{
		static char funcname[] = "iTJSDispatch2 * ::TVPCreateEventObject(const tjs_char *,iTJSDispatch2 *,iTJSDispatch2 *)";
		TVPImportFuncPtrdffedabe32ce886e3b7e695b44ad3547 = TVPGetImportFuncPtr(funcname);
	}
	typedef iTJSDispatch2 * (__stdcall * __functype)(const tjs_char *, iTJSDispatch2 *, iTJSDispatch2 *);
	return ((__functype)(TVPImportFuncPtrdffedabe32ce886e3b7e695b44ad3547))(type, targthis, targ);
}
inline void TVPAddContinuousEventHook(tTVPContinuousEventCallbackIntf * cb)
{
	if(!TVPImportFuncPtrf518c60b165658d19a0fadd8f69586aa)
	{
		static char funcname[] = "void ::TVPAddContinuousEventHook(tTVPContinuousEventCallbackIntf *)";
		TVPImportFuncPtrf518c60b165658d19a0fadd8f69586aa = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tTVPContinuousEventCallbackIntf *);
	((__functype)(TVPImportFuncPtrf518c60b165658d19a0fadd8f69586aa))(cb);
}
inline void TVPRemoveContinuousEventHook(tTVPContinuousEventCallbackIntf * cb)
{
	if(!TVPImportFuncPtr6fefcb1c2ca01a876c301ab41dbdab9f)
	{
		static char funcname[] = "void ::TVPRemoveContinuousEventHook(tTVPContinuousEventCallbackIntf *)";
		TVPImportFuncPtr6fefcb1c2ca01a876c301ab41dbdab9f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tTVPContinuousEventCallbackIntf *);
	((__functype)(TVPImportFuncPtr6fefcb1c2ca01a876c301ab41dbdab9f))(cb);
}
inline void TVPAddCompactEventHook(tTVPCompactEventCallbackIntf * cb)
{
	if(!TVPImportFuncPtrdf55083347df0483b4ca6ba1e4f0b9a0)
	{
		static char funcname[] = "void ::TVPAddCompactEventHook(tTVPCompactEventCallbackIntf *)";
		TVPImportFuncPtrdf55083347df0483b4ca6ba1e4f0b9a0 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tTVPCompactEventCallbackIntf *);
	((__functype)(TVPImportFuncPtrdf55083347df0483b4ca6ba1e4f0b9a0))(cb);
}
inline void TVPRemoveCompactEventHook(tTVPCompactEventCallbackIntf * cb)
{
	if(!TVPImportFuncPtrd8d28310f702714733c4c5dc850058df)
	{
		static char funcname[] = "void ::TVPRemoveCompactEventHook(tTVPCompactEventCallbackIntf *)";
		TVPImportFuncPtrd8d28310f702714733c4c5dc850058df = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tTVPCompactEventCallbackIntf *);
	((__functype)(TVPImportFuncPtrd8d28310f702714733c4c5dc850058df))(cb);
}
inline ttstr TVPGetPlatformName()
{
	if(!TVPImportFuncPtr52d24c38b05be174bc5c4fdcf02e9b9f)
	{
		static char funcname[] = "ttstr ::TVPGetPlatformName()";
		TVPImportFuncPtr52d24c38b05be174bc5c4fdcf02e9b9f = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtr52d24c38b05be174bc5c4fdcf02e9b9f))();
}
inline ttstr TVPGetOSName()
{
	if(!TVPImportFuncPtrf27f455c8f30cbaf1706faac3c7b8e02)
	{
		static char funcname[] = "ttstr ::TVPGetOSName()";
		TVPImportFuncPtrf27f455c8f30cbaf1706faac3c7b8e02 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtrf27f455c8f30cbaf1706faac3c7b8e02))();
}
inline bool TVPGetAsyncKeyState(tjs_uint keycode , bool getcurrent = true)
{
	if(!TVPImportFuncPtr78ec453a50b2800bb01347e8ebbac000)
	{
		static char funcname[] = "bool ::TVPGetAsyncKeyState(tjs_uint,bool)";
		TVPImportFuncPtr78ec453a50b2800bb01347e8ebbac000 = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(tjs_uint , bool);
	return ((__functype)(TVPImportFuncPtr78ec453a50b2800bb01347e8ebbac000))(keycode, getcurrent);
}
inline iTJSDispatch2 * TVPGetScriptDispatch()
{
	if(!TVPImportFuncPtr0936d0f6fc53339d255893e58bcc6699)
	{
		static char funcname[] = "iTJSDispatch2 * ::TVPGetScriptDispatch()";
		TVPImportFuncPtr0936d0f6fc53339d255893e58bcc6699 = TVPGetImportFuncPtr(funcname);
	}
	typedef iTJSDispatch2 * (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtr0936d0f6fc53339d255893e58bcc6699))();
}
inline void TVPExecuteScript(const ttstr & content , tTJSVariant * result = NULL)
{
	if(!TVPImportFuncPtrf4f7181b7fd679784c50b0cc7ba4c60e)
	{
		static char funcname[] = "void ::TVPExecuteScript(const ttstr &,tTJSVariant *)";
		TVPImportFuncPtrf4f7181b7fd679784c50b0cc7ba4c60e = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &, tTJSVariant *);
	((__functype)(TVPImportFuncPtrf4f7181b7fd679784c50b0cc7ba4c60e))(content, result);
}
inline void TVPExecuteScript(const ttstr & content , iTJSDispatch2 * context , tTJSVariant * result = NULL)
{
	if(!TVPImportFuncPtr79816d7e5741c2416fefe2c2a8baef00)
	{
		static char funcname[] = "void ::TVPExecuteScript(const ttstr &,iTJSDispatch2 *,tTJSVariant *)";
		TVPImportFuncPtr79816d7e5741c2416fefe2c2a8baef00 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &, iTJSDispatch2 *, tTJSVariant *);
	((__functype)(TVPImportFuncPtr79816d7e5741c2416fefe2c2a8baef00))(content, context, result);
}
inline void TVPExecuteExpression(const ttstr & content , tTJSVariant * result = NULL)
{
	if(!TVPImportFuncPtr42a3d248fab928f16555abcceca62834)
	{
		static char funcname[] = "void ::TVPExecuteExpression(const ttstr &,tTJSVariant *)";
		TVPImportFuncPtr42a3d248fab928f16555abcceca62834 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &, tTJSVariant *);
	((__functype)(TVPImportFuncPtr42a3d248fab928f16555abcceca62834))(content, result);
}
inline void TVPExecuteExpression(const ttstr & content , iTJSDispatch2 * context , tTJSVariant * result = NULL)
{
	if(!TVPImportFuncPtr926d6212b8b1b238e7bef9b17a3ee643)
	{
		static char funcname[] = "void ::TVPExecuteExpression(const ttstr &,iTJSDispatch2 *,tTJSVariant *)";
		TVPImportFuncPtr926d6212b8b1b238e7bef9b17a3ee643 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &, iTJSDispatch2 *, tTJSVariant *);
	((__functype)(TVPImportFuncPtr926d6212b8b1b238e7bef9b17a3ee643))(content, context, result);
}
inline void TVPExecuteScript(const ttstr & content , const ttstr & name , tjs_int lineofs , tTJSVariant * result = NULL)
{
	if(!TVPImportFuncPtr236e3d626784d80ca2cc5b2fe14cd9c6)
	{
		static char funcname[] = "void ::TVPExecuteScript(const ttstr &,const ttstr &,tjs_int,tTJSVariant *)";
		TVPImportFuncPtr236e3d626784d80ca2cc5b2fe14cd9c6 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &, const ttstr &, tjs_int , tTJSVariant *);
	((__functype)(TVPImportFuncPtr236e3d626784d80ca2cc5b2fe14cd9c6))(content, name, lineofs, result);
}
inline void TVPExecuteScript(const ttstr & content , const ttstr & name , tjs_int lineofs , iTJSDispatch2 * context , tTJSVariant * result = NULL)
{
	if(!TVPImportFuncPtr1bfac11a5f95c842f97a8bb57d4019de)
	{
		static char funcname[] = "void ::TVPExecuteScript(const ttstr &,const ttstr &,tjs_int,iTJSDispatch2 *,tTJSVariant *)";
		TVPImportFuncPtr1bfac11a5f95c842f97a8bb57d4019de = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &, const ttstr &, tjs_int , iTJSDispatch2 *, tTJSVariant *);
	((__functype)(TVPImportFuncPtr1bfac11a5f95c842f97a8bb57d4019de))(content, name, lineofs, context, result);
}
inline void TVPExecuteExpression(const ttstr & content , const ttstr & name , tjs_int lineofs , tTJSVariant * result = NULL)
{
	if(!TVPImportFuncPtr198ce21c54b0cea4c1bf5eeba35349ab)
	{
		static char funcname[] = "void ::TVPExecuteExpression(const ttstr &,const ttstr &,tjs_int,tTJSVariant *)";
		TVPImportFuncPtr198ce21c54b0cea4c1bf5eeba35349ab = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &, const ttstr &, tjs_int , tTJSVariant *);
	((__functype)(TVPImportFuncPtr198ce21c54b0cea4c1bf5eeba35349ab))(content, name, lineofs, result);
}
inline void TVPExecuteExpression(const ttstr & content , const ttstr & name , tjs_int lineofs , iTJSDispatch2 * context , tTJSVariant * result = NULL)
{
	if(!TVPImportFuncPtr590a1ec7f64904eaa32b5c771bb5f8cd)
	{
		static char funcname[] = "void ::TVPExecuteExpression(const ttstr &,const ttstr &,tjs_int,iTJSDispatch2 *,tTJSVariant *)";
		TVPImportFuncPtr590a1ec7f64904eaa32b5c771bb5f8cd = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &, const ttstr &, tjs_int , iTJSDispatch2 *, tTJSVariant *);
	((__functype)(TVPImportFuncPtr590a1ec7f64904eaa32b5c771bb5f8cd))(content, name, lineofs, context, result);
}
inline void TVPExecuteStorage(const ttstr & name , tTJSVariant * result = NULL , bool isexpression = false , const tjs_char * modestr = NULL)
{
	if(!TVPImportFuncPtrdd13d4bc2b48540a92f047bf015b829b)
	{
		static char funcname[] = "void ::TVPExecuteStorage(const ttstr &,tTJSVariant *,bool,const tjs_char *)";
		TVPImportFuncPtrdd13d4bc2b48540a92f047bf015b829b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &, tTJSVariant *, bool , const tjs_char *);
	((__functype)(TVPImportFuncPtrdd13d4bc2b48540a92f047bf015b829b))(name, result, isexpression, modestr);
}
inline void TVPExecuteStorage(const ttstr & name , iTJSDispatch2 * context , tTJSVariant * result = NULL , bool isexpression = false , const tjs_char * modestr = NULL)
{
	if(!TVPImportFuncPtr0ff502d492598d2211405180bfb4d1e1)
	{
		static char funcname[] = "void ::TVPExecuteStorage(const ttstr &,iTJSDispatch2 *,tTJSVariant *,bool,const tjs_char *)";
		TVPImportFuncPtr0ff502d492598d2211405180bfb4d1e1 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &, iTJSDispatch2 *, tTJSVariant *, bool , const tjs_char *);
	((__functype)(TVPImportFuncPtr0ff502d492598d2211405180bfb4d1e1))(name, context, result, isexpression, modestr);
}
inline void TVPDumpScriptEngine()
{
	if(!TVPImportFuncPtrcf5401746759bfe38918087aaab6c57b)
	{
		static char funcname[] = "void ::TVPDumpScriptEngine()";
		TVPImportFuncPtrcf5401746759bfe38918087aaab6c57b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtrcf5401746759bfe38918087aaab6c57b))();
}
inline void TVPExecuteBytecode(const tjs_uint8 * content , size_t len , iTJSDispatch2 * context , tTJSVariant * result = NULL , const tjs_char * name = NULL)
{
	if(!TVPImportFuncPtr04e84aa7d8cf0477d55c700164544b38)
	{
		static char funcname[] = "void ::TVPExecuteBytecode(const tjs_uint8 *,size_t,iTJSDispatch2 *,tTJSVariant *,const tjs_char *)";
		TVPImportFuncPtr04e84aa7d8cf0477d55c700164544b38 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const tjs_uint8 *, size_t , iTJSDispatch2 *, tTJSVariant *, const tjs_char *);
	((__functype)(TVPImportFuncPtr04e84aa7d8cf0477d55c700164544b38))(content, len, context, result, name);
}
inline void TVPCreateMessageMapFile(const ttstr & filename)
{
	if(!TVPImportFuncPtr449039d3afbfbd52a63130a3b227a490)
	{
		static char funcname[] = "void ::TVPCreateMessageMapFile(const ttstr &)";
		TVPImportFuncPtr449039d3afbfbd52a63130a3b227a490 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &);
	((__functype)(TVPImportFuncPtr449039d3afbfbd52a63130a3b227a490))(filename);
}
inline bool TVPCheckExistentLocalFolder(const ttstr & name)
{
	if(!TVPImportFuncPtr347a4fa85af84e223c4b61d33ead694a)
	{
		static char funcname[] = "bool ::TVPCheckExistentLocalFolder(const ttstr &)";
		TVPImportFuncPtr347a4fa85af84e223c4b61d33ead694a = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtr347a4fa85af84e223c4b61d33ead694a))(name);
}
inline bool TVPCheckExistentLocalFile(const ttstr & name)
{
	if(!TVPImportFuncPtr4ad1dd24b3b4769ee10149eea006af7a)
	{
		static char funcname[] = "bool ::TVPCheckExistentLocalFile(const ttstr &)";
		TVPImportFuncPtr4ad1dd24b3b4769ee10149eea006af7a = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtr4ad1dd24b3b4769ee10149eea006af7a))(name);
}
inline bool TVPCreateFolders(const ttstr & folder)
{
	if(!TVPImportFuncPtrb246b17b62d273bdc04e9d9e827f5c74)
	{
		static char funcname[] = "bool ::TVPCreateFolders(const ttstr &)";
		TVPImportFuncPtrb246b17b62d273bdc04e9d9e827f5c74 = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(const ttstr &);
	return ((__functype)(TVPImportFuncPtrb246b17b62d273bdc04e9d9e827f5c74))(folder);
}
inline IStream * TVPCreateIStream(const ttstr & name , tjs_uint32 flags)
{
	if(!TVPImportFuncPtr9974ebc6296f925cff55d8bcb2d52ce9)
	{
		static char funcname[] = "IStream * ::TVPCreateIStream(const ttstr &,tjs_uint32)";
		TVPImportFuncPtr9974ebc6296f925cff55d8bcb2d52ce9 = TVPGetImportFuncPtr(funcname);
	}
	typedef IStream * (__stdcall * __functype)(const ttstr &, tjs_uint32);
	return ((__functype)(TVPImportFuncPtr9974ebc6296f925cff55d8bcb2d52ce9))(name, flags);
}
inline tTJSBinaryStream * TVPCreateBinaryStreamAdapter(IStream * refstream)
{
	if(!TVPImportFuncPtr0e0c9d9107d8c56b8bc4d4198ae9208a)
	{
		static char funcname[] = "tTJSBinaryStream * ::TVPCreateBinaryStreamAdapter(IStream *)";
		TVPImportFuncPtr0e0c9d9107d8c56b8bc4d4198ae9208a = TVPGetImportFuncPtr(funcname);
	}
	typedef tTJSBinaryStream * (__stdcall * __functype)(IStream *);
	return ((__functype)(TVPImportFuncPtr0e0c9d9107d8c56b8bc4d4198ae9208a))(refstream);
}
inline void TVPThrowPluginUnboundFunctionError(const char * funcname)
{
	if(!TVPImportFuncPtrc23ece207f6ec2dd7c76ef873047aee3)
	{
		static char funcname[] = "void ::TVPThrowPluginUnboundFunctionError(const char *)";
		TVPImportFuncPtrc23ece207f6ec2dd7c76ef873047aee3 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const char *);
	((__functype)(TVPImportFuncPtrc23ece207f6ec2dd7c76ef873047aee3))(funcname);
}
inline void TVPThrowPluginUnboundFunctionError(const tjs_char * funcname)
{
	if(!TVPImportFuncPtr81507020bc646be2f53ab95b9430ba27)
	{
		static char funcname[] = "void ::TVPThrowPluginUnboundFunctionError(const tjs_char *)";
		TVPImportFuncPtr81507020bc646be2f53ab95b9430ba27 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const tjs_char *);
	((__functype)(TVPImportFuncPtr81507020bc646be2f53ab95b9430ba27))(funcname);
}
inline void * TVP_malloc(size_t size)
{
	if(!TVPImportFuncPtracc0d3861d1b971abcbdda1c075dd681)
	{
		static char funcname[] = "void * ::TVP_malloc(size_t)";
		TVPImportFuncPtracc0d3861d1b971abcbdda1c075dd681 = TVPGetImportFuncPtr(funcname);
	}
	typedef void * (__stdcall * __functype)(size_t);
	return ((__functype)(TVPImportFuncPtracc0d3861d1b971abcbdda1c075dd681))(size);
}
inline void * TVP_realloc(void * pp , size_t size)
{
	if(!TVPImportFuncPtrff2dccead1b31e3f34e8be3e2ba5bbf1)
	{
		static char funcname[] = "void * ::TVP_realloc(void *,size_t)";
		TVPImportFuncPtrff2dccead1b31e3f34e8be3e2ba5bbf1 = TVPGetImportFuncPtr(funcname);
	}
	typedef void * (__stdcall * __functype)(void *, size_t);
	return ((__functype)(TVPImportFuncPtrff2dccead1b31e3f34e8be3e2ba5bbf1))(pp, size);
}
inline void TVP_free(void * pp)
{
	if(!TVPImportFuncPtre17db0d4f69625c61aba7fffe540dded)
	{
		static char funcname[] = "void ::TVP_free(void *)";
		TVPImportFuncPtre17db0d4f69625c61aba7fffe540dded = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(void *);
	((__functype)(TVPImportFuncPtre17db0d4f69625c61aba7fffe540dded))(pp);
}
inline tjs_int TVPGetAutoLoadPluginCount()
{
	if(!TVPImportFuncPtr5bbc872e7bba5b761c509d31116e4460)
	{
		static char funcname[] = "tjs_int ::TVPGetAutoLoadPluginCount()";
		TVPImportFuncPtr5bbc872e7bba5b761c509d31116e4460 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtr5bbc872e7bba5b761c509d31116e4460))();
}
inline int ZLIB_uncompress(unsigned char * dest , unsigned long * destlen , const unsigned char * source , unsigned long sourcelen)
{
	if(!TVPImportFuncPtr4adf361303eae78829250c7b732a5722)
	{
		static char funcname[] = "int ::ZLIB_uncompress(unsigned char *,unsigned long *,const unsigned char *,unsigned long)";
		TVPImportFuncPtr4adf361303eae78829250c7b732a5722 = TVPGetImportFuncPtr(funcname);
	}
	typedef int (__stdcall * __functype)(unsigned char *, unsigned long *, const unsigned char *, unsigned long);
	return ((__functype)(TVPImportFuncPtr4adf361303eae78829250c7b732a5722))(dest, destlen, source, sourcelen);
}
inline int ZLIB_compress(unsigned char * dest , unsigned long * destlen , const unsigned char * source , unsigned long sourcelen)
{
	if(!TVPImportFuncPtrbf172364c57c1aa561b145fd5cacda0c)
	{
		static char funcname[] = "int ::ZLIB_compress(unsigned char *,unsigned long *,const unsigned char *,unsigned long)";
		TVPImportFuncPtrbf172364c57c1aa561b145fd5cacda0c = TVPGetImportFuncPtr(funcname);
	}
	typedef int (__stdcall * __functype)(unsigned char *, unsigned long *, const unsigned char *, unsigned long);
	return ((__functype)(TVPImportFuncPtrbf172364c57c1aa561b145fd5cacda0c))(dest, destlen, source, sourcelen);
}
inline int ZLIB_compress2(unsigned char * dest , unsigned long * destlen , const unsigned char * source , unsigned long sourcelen , int level)
{
	if(!TVPImportFuncPtrd7687aa80dac10f88deac7aa7e70538a)
	{
		static char funcname[] = "int ::ZLIB_compress2(unsigned char *,unsigned long *,const unsigned char *,unsigned long,int)";
		TVPImportFuncPtrd7687aa80dac10f88deac7aa7e70538a = TVPGetImportFuncPtr(funcname);
	}
	typedef int (__stdcall * __functype)(unsigned char *, unsigned long *, const unsigned char *, unsigned long , int);
	return ((__functype)(TVPImportFuncPtrd7687aa80dac10f88deac7aa7e70538a))(dest, destlen, source, sourcelen, level);
}
inline void TVP_md5_init(TVP_md5_state_t * pms)
{
	if(!TVPImportFuncPtrb18b7259f98029f745c75291d6855ab1)
	{
		static char funcname[] = "void ::TVP_md5_init(TVP_md5_state_t *)";
		TVPImportFuncPtrb18b7259f98029f745c75291d6855ab1 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(TVP_md5_state_t *);
	((__functype)(TVPImportFuncPtrb18b7259f98029f745c75291d6855ab1))(pms);
}
inline void TVP_md5_append(TVP_md5_state_t * pms , const tjs_uint8 * data , int nbytes)
{
	if(!TVPImportFuncPtrb79e5d877116025576ca1f76af124009)
	{
		static char funcname[] = "void ::TVP_md5_append(TVP_md5_state_t *,const tjs_uint8 *,int)";
		TVPImportFuncPtrb79e5d877116025576ca1f76af124009 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(TVP_md5_state_t *, const tjs_uint8 *, int);
	((__functype)(TVPImportFuncPtrb79e5d877116025576ca1f76af124009))(pms, data, nbytes);
}
inline void TVP_md5_finish(TVP_md5_state_t * pms , tjs_uint8 * digest)
{
	if(!TVPImportFuncPtr8aea098dfe8a36c705cc2a9e1a189b84)
	{
		static char funcname[] = "void ::TVP_md5_finish(TVP_md5_state_t *,tjs_uint8 *)";
		TVPImportFuncPtr8aea098dfe8a36c705cc2a9e1a189b84 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(TVP_md5_state_t *, tjs_uint8 *);
	((__functype)(TVPImportFuncPtr8aea098dfe8a36c705cc2a9e1a189b84))(pms, digest);
}
inline HWND TVPGetApplicationWindowHandle()
{
	if(!TVPImportFuncPtr4ccd3f6ab60d61be6dbfc59e8e3d1726)
	{
		static char funcname[] = "HWND ::TVPGetApplicationWindowHandle()";
		TVPImportFuncPtr4ccd3f6ab60d61be6dbfc59e8e3d1726 = TVPGetImportFuncPtr(funcname);
	}
	typedef HWND (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtr4ccd3f6ab60d61be6dbfc59e8e3d1726))();
}
inline void TVPProcessApplicationMessages()
{
	if(!TVPImportFuncPtr3d70bb72a7d7765c7e8ea580079ab7e9)
	{
		static char funcname[] = "void ::TVPProcessApplicationMessages()";
		TVPImportFuncPtr3d70bb72a7d7765c7e8ea580079ab7e9 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtr3d70bb72a7d7765c7e8ea580079ab7e9))();
}
inline void TVPHandleApplicationMessage()
{
	if(!TVPImportFuncPtreba9b272d78a4b0cd7f9212e29a58607)
	{
		static char funcname[] = "void ::TVPHandleApplicationMessage()";
		TVPImportFuncPtreba9b272d78a4b0cd7f9212e29a58607 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtreba9b272d78a4b0cd7f9212e29a58607))();
}
inline bool TVPRegisterGlobalObject(const tjs_char * name , iTJSDispatch2 * dsp)
{
	if(!TVPImportFuncPtrcfbe8ee9d43aa64ae4190eac91f7c55f)
	{
		static char funcname[] = "bool ::TVPRegisterGlobalObject(const tjs_char *,iTJSDispatch2 *)";
		TVPImportFuncPtrcfbe8ee9d43aa64ae4190eac91f7c55f = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(const tjs_char *, iTJSDispatch2 *);
	return ((__functype)(TVPImportFuncPtrcfbe8ee9d43aa64ae4190eac91f7c55f))(name, dsp);
}
inline bool TVPRemoveGlobalObject(const tjs_char * name)
{
	if(!TVPImportFuncPtra4308a386968ef5d23025ab8a9e8c6db)
	{
		static char funcname[] = "bool ::TVPRemoveGlobalObject(const tjs_char *)";
		TVPImportFuncPtra4308a386968ef5d23025ab8a9e8c6db = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(const tjs_char *);
	return ((__functype)(TVPImportFuncPtra4308a386968ef5d23025ab8a9e8c6db))(name);
}
inline void TVPDoTryBlock(tTVPTryBlockFunction tryblock , tTVPCatchBlockFunction catchblock , tTVPFinallyBlockFunction finallyblock , void * data)
{
	if(!TVPImportFuncPtr5a4fcbe1e398e3d9690d571acbbbae9f)
	{
		static char funcname[] = "void ::TVPDoTryBlock(tTVPTryBlockFunction,tTVPCatchBlockFunction,tTVPFinallyBlockFunction,void *)";
		TVPImportFuncPtr5a4fcbe1e398e3d9690d571acbbbae9f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tTVPTryBlockFunction , tTVPCatchBlockFunction , tTVPFinallyBlockFunction , void *);
	((__functype)(TVPImportFuncPtr5a4fcbe1e398e3d9690d571acbbbae9f))(tryblock, catchblock, finallyblock, data);
}
inline bool TVPGetFileVersionOf(const char * module_filename , tjs_int & major , tjs_int & minor , tjs_int & release , tjs_int & build)
{
	if(!TVPImportFuncPtrb8305ae2ae49a3f7f711105e77bafdf0)
	{
		static char funcname[] = "bool ::TVPGetFileVersionOf(const char *,tjs_int &,tjs_int &,tjs_int &,tjs_int &)";
		TVPImportFuncPtrb8305ae2ae49a3f7f711105e77bafdf0 = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(const char *, tjs_int &, tjs_int &, tjs_int &, tjs_int &);
	return ((__functype)(TVPImportFuncPtrb8305ae2ae49a3f7f711105e77bafdf0))(module_filename, major, minor, release, build);
}
inline bool TVPGetCommandLine(const tjs_char * name , tTJSVariant * value = NULL)
{
	if(!TVPImportFuncPtrfb3b405f8747b54f26c332b9e6af81cd)
	{
		static char funcname[] = "bool ::TVPGetCommandLine(const tjs_char *,tTJSVariant *)";
		TVPImportFuncPtrfb3b405f8747b54f26c332b9e6af81cd = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(const tjs_char *, tTJSVariant *);
	return ((__functype)(TVPImportFuncPtrfb3b405f8747b54f26c332b9e6af81cd))(name, value);
}
inline tjs_int TVPGetCommandLineArgumentGeneration()
{
	if(!TVPImportFuncPtrb7ccd11d130f186883c109d2ba17b598)
	{
		static char funcname[] = "tjs_int ::TVPGetCommandLineArgumentGeneration()";
		TVPImportFuncPtrb7ccd11d130f186883c109d2ba17b598 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtrb7ccd11d130f186883c109d2ba17b598))();
}
inline void TVPSetCommandLine(const tjs_char * name , const ttstr & value)
{
	if(!TVPImportFuncPtrcf8ab6c24f25993ccc7663e572ac2991)
	{
		static char funcname[] = "void ::TVPSetCommandLine(const tjs_char *,const ttstr &)";
		TVPImportFuncPtrcf8ab6c24f25993ccc7663e572ac2991 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const tjs_char *, const ttstr &);
	((__functype)(TVPImportFuncPtrcf8ab6c24f25993ccc7663e572ac2991))(name, value);
}
inline tjs_uint32 TVPGetCPUType()
{
	if(!TVPImportFuncPtrba40ffbca76695b54a02aa8c1f1e047b)
	{
		static char funcname[] = "tjs_uint32 ::TVPGetCPUType()";
		TVPImportFuncPtrba40ffbca76695b54a02aa8c1f1e047b = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_uint32 (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtrba40ffbca76695b54a02aa8c1f1e047b))();
}
inline tjs_int TVPGetProcessorNum()
{
	if(!TVPImportFuncPtrc97720e639e95ba5130ce9dd78d30403)
	{
		static char funcname[] = "tjs_int ::TVPGetProcessorNum()";
		TVPImportFuncPtrc97720e639e95ba5130ce9dd78d30403 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtrc97720e639e95ba5130ce9dd78d30403))();
}
inline tjs_int TVPGetThreadNum()
{
	if(!TVPImportFuncPtrc5557ac5391b1b831a22e64b65d1746c)
	{
		static char funcname[] = "tjs_int ::TVPGetThreadNum()";
		TVPImportFuncPtrc5557ac5391b1b831a22e64b65d1746c = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtrc5557ac5391b1b831a22e64b65d1746c))();
}
inline void TVPBeginThreadTask(tjs_int num)
{
	if(!TVPImportFuncPtr3243a4c32d4f674f1bbc8d3895257568)
	{
		static char funcname[] = "void ::TVPBeginThreadTask(tjs_int)";
		TVPImportFuncPtr3243a4c32d4f674f1bbc8d3895257568 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_int);
	((__functype)(TVPImportFuncPtr3243a4c32d4f674f1bbc8d3895257568))(num);
}
inline void TVPExecThreadTask(TVP_THREAD_TASK_FUNC func , TVP_THREAD_PARAM param)
{
	if(!TVPImportFuncPtr78390a3d08879903ee9558e9df68db4d)
	{
		static char funcname[] = "void ::TVPExecThreadTask(TVP_THREAD_TASK_FUNC,TVP_THREAD_PARAM)";
		TVPImportFuncPtr78390a3d08879903ee9558e9df68db4d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(TVP_THREAD_TASK_FUNC , TVP_THREAD_PARAM);
	((__functype)(TVPImportFuncPtr78390a3d08879903ee9558e9df68db4d))(func, param);
}
inline void TVPEndThreadTask()
{
	if(!TVPImportFuncPtr58e9454d7096a52808f9a83b9ce25ff0)
	{
		static char funcname[] = "void ::TVPEndThreadTask()";
		TVPImportFuncPtr58e9454d7096a52808f9a83b9ce25ff0 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtr58e9454d7096a52808f9a83b9ce25ff0))();
}
inline void TVPAddLog(const ttstr & line)
{
	if(!TVPImportFuncPtrcdefadd0c3bf15b4639b2f0338a40585)
	{
		static char funcname[] = "void ::TVPAddLog(const ttstr &)";
		TVPImportFuncPtrcdefadd0c3bf15b4639b2f0338a40585 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &);
	((__functype)(TVPImportFuncPtrcdefadd0c3bf15b4639b2f0338a40585))(line);
}
inline void TVPAddImportantLog(const ttstr & line)
{
	if(!TVPImportFuncPtr4bf80e9bac16b9e3f9bf385b2fbce657)
	{
		static char funcname[] = "void ::TVPAddImportantLog(const ttstr &)";
		TVPImportFuncPtr4bf80e9bac16b9e3f9bf385b2fbce657 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &);
	((__functype)(TVPImportFuncPtr4bf80e9bac16b9e3f9bf385b2fbce657))(line);
}
inline void TVPPushEnvironNoise(const void * buf , tjs_int bufsize)
{
	if(!TVPImportFuncPtr51aeacf2b6ef9deb01c3b3db201d6bf9)
	{
		static char funcname[] = "void ::TVPPushEnvironNoise(const void *,tjs_int)";
		TVPImportFuncPtr51aeacf2b6ef9deb01c3b3db201d6bf9 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const void *, tjs_int);
	((__functype)(TVPImportFuncPtr51aeacf2b6ef9deb01c3b3db201d6bf9))(buf, bufsize);
}
inline void TVPGetRandomBits128(void * dest)
{
	if(!TVPImportFuncPtr9ed5432d73448da47991df9577ee97bc)
	{
		static char funcname[] = "void ::TVPGetRandomBits128(void *)";
		TVPImportFuncPtr9ed5432d73448da47991df9577ee97bc = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(void *);
	((__functype)(TVPImportFuncPtr9ed5432d73448da47991df9577ee97bc))(dest);
}
inline bool TVPClipboardHasFormat(tTVPClipboardFormat format)
{
	if(!TVPImportFuncPtrcf1d02d1cc1aff0aae6c038c95dac80f)
	{
		static char funcname[] = "bool ::TVPClipboardHasFormat(tTVPClipboardFormat)";
		TVPImportFuncPtrcf1d02d1cc1aff0aae6c038c95dac80f = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(tTVPClipboardFormat);
	return ((__functype)(TVPImportFuncPtrcf1d02d1cc1aff0aae6c038c95dac80f))(format);
}
inline void TVPClipboardSetText(const ttstr & text)
{
	if(!TVPImportFuncPtrddb0e05c72c0692e78af885ac7ec82dc)
	{
		static char funcname[] = "void ::TVPClipboardSetText(const ttstr &)";
		TVPImportFuncPtrddb0e05c72c0692e78af885ac7ec82dc = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const ttstr &);
	((__functype)(TVPImportFuncPtrddb0e05c72c0692e78af885ac7ec82dc))(text);
}
inline bool TVPClipboardGetText(ttstr & text)
{
	if(!TVPImportFuncPtra3029db6292616cd16c228b91dc4af13)
	{
		static char funcname[] = "bool ::TVPClipboardGetText(ttstr &)";
		TVPImportFuncPtra3029db6292616cd16c228b91dc4af13 = TVPGetImportFuncPtr(funcname);
	}
	typedef bool (__stdcall * __functype)(ttstr &);
	return ((__functype)(TVPImportFuncPtra3029db6292616cd16c228b91dc4af13))(text);
}
inline tjs_uint64 TVPGetTickCount()
{
	if(!TVPImportFuncPtr2d90871c6bc15a9e8d97d24c29e78e3b)
	{
		static char funcname[] = "tjs_uint64 ::TVPGetTickCount()";
		TVPImportFuncPtr2d90871c6bc15a9e8d97d24c29e78e3b = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_uint64 (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtr2d90871c6bc15a9e8d97d24c29e78e3b))();
}
inline ttstr TVPFormatMessage(const tjs_char * msg , const ttstr & p1)
{
	if(!TVPImportFuncPtr0af6744e35e38276d6a98c1f382b1519)
	{
		static char funcname[] = "ttstr ::TVPFormatMessage(const tjs_char *,const ttstr &)";
		TVPImportFuncPtr0af6744e35e38276d6a98c1f382b1519 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)(const tjs_char *, const ttstr &);
	return ((__functype)(TVPImportFuncPtr0af6744e35e38276d6a98c1f382b1519))(msg, p1);
}
inline ttstr TVPFormatMessage(const tjs_char * msg , const ttstr & p1 , const ttstr & p2)
{
	if(!TVPImportFuncPtrad40567a051208757642e5e087f3e741)
	{
		static char funcname[] = "ttstr ::TVPFormatMessage(const tjs_char *,const ttstr &,const ttstr &)";
		TVPImportFuncPtrad40567a051208757642e5e087f3e741 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)(const tjs_char *, const ttstr &, const ttstr &);
	return ((__functype)(TVPImportFuncPtrad40567a051208757642e5e087f3e741))(msg, p1, p2);
}
inline void TVPThrowExceptionMessage(const tjs_char * msg)
{
	if(!TVPImportFuncPtr6a15185daab9b274963fe5ef46305775)
	{
		static char funcname[] = "void ::TVPThrowExceptionMessage(const tjs_char *)";
		TVPImportFuncPtr6a15185daab9b274963fe5ef46305775 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const tjs_char *);
	((__functype)(TVPImportFuncPtr6a15185daab9b274963fe5ef46305775))(msg);
}
inline void TVPThrowExceptionMessage(const tjs_char * msg , const ttstr & p1 , tjs_int num)
{
	if(!TVPImportFuncPtr073a2332a8ab3ed31ab81daea3d3f2c4)
	{
		static char funcname[] = "void ::TVPThrowExceptionMessage(const tjs_char *,const ttstr &,tjs_int)";
		TVPImportFuncPtr073a2332a8ab3ed31ab81daea3d3f2c4 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const tjs_char *, const ttstr &, tjs_int);
	((__functype)(TVPImportFuncPtr073a2332a8ab3ed31ab81daea3d3f2c4))(msg, p1, num);
}
inline void TVPThrowExceptionMessage(const tjs_char * msg , const ttstr & p1)
{
	if(!TVPImportFuncPtr01216e91225e06c7422bef0c2febc0cc)
	{
		static char funcname[] = "void ::TVPThrowExceptionMessage(const tjs_char *,const ttstr &)";
		TVPImportFuncPtr01216e91225e06c7422bef0c2febc0cc = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const tjs_char *, const ttstr &);
	((__functype)(TVPImportFuncPtr01216e91225e06c7422bef0c2febc0cc))(msg, p1);
}
inline void TVPThrowExceptionMessage(const tjs_char * msg , const ttstr & p1 , const ttstr & p2)
{
	if(!TVPImportFuncPtr16ce22ad500a5bdfd5d5743c847a28b6)
	{
		static char funcname[] = "void ::TVPThrowExceptionMessage(const tjs_char *,const ttstr &,const ttstr &)";
		TVPImportFuncPtr16ce22ad500a5bdfd5d5743c847a28b6 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const tjs_char *, const ttstr &, const ttstr &);
	((__functype)(TVPImportFuncPtr16ce22ad500a5bdfd5d5743c847a28b6))(msg, p1, p2);
}
inline ttstr TVPGetAboutString()
{
	if(!TVPImportFuncPtr59251c4104f736fa2690c5f77fb0a908)
	{
		static char funcname[] = "ttstr ::TVPGetAboutString()";
		TVPImportFuncPtr59251c4104f736fa2690c5f77fb0a908 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtr59251c4104f736fa2690c5f77fb0a908))();
}
inline ttstr TVPGetVersionInformation()
{
	if(!TVPImportFuncPtrf923750e0fdb51a6fc6c304832cb3dd3)
	{
		static char funcname[] = "ttstr ::TVPGetVersionInformation()";
		TVPImportFuncPtrf923750e0fdb51a6fc6c304832cb3dd3 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtrf923750e0fdb51a6fc6c304832cb3dd3))();
}
inline ttstr TVPGetVersionString()
{
	if(!TVPImportFuncPtrbc77a1e312ff7827d90387fb92f0f5b0)
	{
		static char funcname[] = "ttstr ::TVPGetVersionString()";
		TVPImportFuncPtrbc77a1e312ff7827d90387fb92f0f5b0 = TVPGetImportFuncPtr(funcname);
	}
	typedef ttstr (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtrbc77a1e312ff7827d90387fb92f0f5b0))();
}
inline void TVPGetSystemVersion(tjs_int & major , tjs_int & minor , tjs_int & release , tjs_int & build)
{
	if(!TVPImportFuncPtr2090afd7ae8bcb021ec4d04947d0d845)
	{
		static char funcname[] = "void ::TVPGetSystemVersion(tjs_int &,tjs_int &,tjs_int &,tjs_int &)";
		TVPImportFuncPtr2090afd7ae8bcb021ec4d04947d0d845 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_int &, tjs_int &, tjs_int &, tjs_int &);
	((__functype)(TVPImportFuncPtr2090afd7ae8bcb021ec4d04947d0d845))(major, minor, release, build);
}
inline void TVPGetTJSVersion(tjs_int & major , tjs_int & minor , tjs_int & release)
{
	if(!TVPImportFuncPtr3a0f858bdf86199dc2d00b583a3b915f)
	{
		static char funcname[] = "void ::TVPGetTJSVersion(tjs_int &,tjs_int &,tjs_int &)";
		TVPImportFuncPtr3a0f858bdf86199dc2d00b583a3b915f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_int &, tjs_int &, tjs_int &);
	((__functype)(TVPImportFuncPtr3a0f858bdf86199dc2d00b583a3b915f))(major, minor, release);
}
inline void TVPConvertPCMTo16bits(tjs_int16 * output , const void * input , const tTVPWaveFormat & format , tjs_int count , bool downmix)
{
	if(!TVPImportFuncPtr0d316a141f7a502ff8d9ffe2d38d25a8)
	{
		static char funcname[] = "void ::TVPConvertPCMTo16bits(tjs_int16 *,const void *,const tTVPWaveFormat &,tjs_int,bool)";
		TVPImportFuncPtr0d316a141f7a502ff8d9ffe2d38d25a8 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_int16 *, const void *, const tTVPWaveFormat &, tjs_int , bool);
	((__functype)(TVPImportFuncPtr0d316a141f7a502ff8d9ffe2d38d25a8))(output, input, format, count, downmix);
}
inline void TVPConvertPCMTo16bits(tjs_int16 * output , const void * input , tjs_int channels , tjs_int bytespersample , tjs_int bitspersample , bool isfloat , tjs_int count , bool downmix)
{
	if(!TVPImportFuncPtrb31ff64ae2d8f93dbf28161d5080b295)
	{
		static char funcname[] = "void ::TVPConvertPCMTo16bits(tjs_int16 *,const void *,tjs_int,tjs_int,tjs_int,bool,tjs_int,bool)";
		TVPImportFuncPtrb31ff64ae2d8f93dbf28161d5080b295 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_int16 *, const void *, tjs_int , tjs_int , tjs_int , bool , tjs_int , bool);
	((__functype)(TVPImportFuncPtrb31ff64ae2d8f93dbf28161d5080b295))(output, input, channels, bytespersample, bitspersample, isfloat, count, downmix);
}
inline void TVPConvertPCMToFloat(float * output , const void * input , tjs_int channels , tjs_int bytespersample , tjs_int bitspersample , bool isfloat , tjs_int count)
{
	if(!TVPImportFuncPtrd9b1c73516daea6a9c6564e2b731615a)
	{
		static char funcname[] = "void ::TVPConvertPCMToFloat(float *,const void *,tjs_int,tjs_int,tjs_int,bool,tjs_int)";
		TVPImportFuncPtrd9b1c73516daea6a9c6564e2b731615a = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(float *, const void *, tjs_int , tjs_int , tjs_int , bool , tjs_int);
	((__functype)(TVPImportFuncPtrd9b1c73516daea6a9c6564e2b731615a))(output, input, channels, bytespersample, bitspersample, isfloat, count);
}
inline void TVPConvertPCMToFloat(float * output , const void * input , const tTVPWaveFormat & format , tjs_int count)
{
	if(!TVPImportFuncPtr003f9d3de568fcd71dd532f33d38839c)
	{
		static char funcname[] = "void ::TVPConvertPCMToFloat(float *,const void *,const tTVPWaveFormat &,tjs_int)";
		TVPImportFuncPtr003f9d3de568fcd71dd532f33d38839c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(float *, const void *, const tTVPWaveFormat &, tjs_int);
	((__functype)(TVPImportFuncPtr003f9d3de568fcd71dd532f33d38839c))(output, input, format, count);
}
inline void TVPReleaseDirectSound()
{
	if(!TVPImportFuncPtr5da29a19bbe279a89be00e16c59d7641)
	{
		static char funcname[] = "void ::TVPReleaseDirectSound()";
		TVPImportFuncPtr5da29a19bbe279a89be00e16c59d7641 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtr5da29a19bbe279a89be00e16c59d7641))();
}
inline IDirectSound * TVPGetDirectSound()
{
	if(!TVPImportFuncPtrc1b52e8f3578d11f369552a887e13c5b)
	{
		static char funcname[] = "IDirectSound * ::TVPGetDirectSound()";
		TVPImportFuncPtrc1b52e8f3578d11f369552a887e13c5b = TVPGetImportFuncPtr(funcname);
	}
	typedef IDirectSound * (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtrc1b52e8f3578d11f369552a887e13c5b))();
}
inline void TVPMIDIOutData(const tjs_uint8 * data , int len)
{
	if(!TVPImportFuncPtrdcd6ba3960e3e2cf6dbe585b1f67b0ac)
	{
		static char funcname[] = "void ::TVPMIDIOutData(const tjs_uint8 *,int)";
		TVPImportFuncPtrdcd6ba3960e3e2cf6dbe585b1f67b0ac = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(const tjs_uint8 *, int);
	((__functype)(TVPImportFuncPtrdcd6ba3960e3e2cf6dbe585b1f67b0ac))(data, len);
}
inline void TVPClearGraphicCache()
{
	if(!TVPImportFuncPtr5b1fa785e397e643dd09cb43c2f2f4db)
	{
		static char funcname[] = "void ::TVPClearGraphicCache()";
		TVPImportFuncPtr5b1fa785e397e643dd09cb43c2f2f4db = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtr5b1fa785e397e643dd09cb43c2f2f4db))();
}
inline tjs_uint32 TVPToActualColor(tjs_uint32 col)
{
	if(!TVPImportFuncPtr29af78765c764c566e6adc77e0ea7041)
	{
		static char funcname[] = "tjs_uint32 ::TVPToActualColor(tjs_uint32)";
		TVPImportFuncPtr29af78765c764c566e6adc77e0ea7041 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_uint32 (__stdcall * __functype)(tjs_uint32);
	return ((__functype)(TVPImportFuncPtr29af78765c764c566e6adc77e0ea7041))(col);
}
inline tjs_uint32 TVPFromActualColor(tjs_uint32 col)
{
	if(!TVPImportFuncPtr9e0df54e4c24ee28d5517c1743faa3a3)
	{
		static char funcname[] = "tjs_uint32 ::TVPFromActualColor(tjs_uint32)";
		TVPImportFuncPtr9e0df54e4c24ee28d5517c1743faa3a3 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_uint32 (__stdcall * __functype)(tjs_uint32);
	return ((__functype)(TVPImportFuncPtr9e0df54e4c24ee28d5517c1743faa3a3))(col);
}
inline iTJSDispatch2 * TVPGetObjectFrom_NI_BaseLayer(tTJSNI_BaseLayer * layer)
{
	if(!TVPImportFuncPtrd3aaa55d66777d7308ffa7a348c84841)
	{
		static char funcname[] = "iTJSDispatch2 * ::TVPGetObjectFrom_NI_BaseLayer(tTJSNI_BaseLayer *)";
		TVPImportFuncPtrd3aaa55d66777d7308ffa7a348c84841 = TVPGetImportFuncPtr(funcname);
	}
	typedef iTJSDispatch2 * (__stdcall * __functype)(tTJSNI_BaseLayer *);
	return ((__functype)(TVPImportFuncPtrd3aaa55d66777d7308ffa7a348c84841))(layer);
}
inline tjs_uint32 TVPGetCurrentShiftKeyState()
{
	if(!TVPImportFuncPtrb426fbfb6ccb4e89c252b6af566995b8)
	{
		static char funcname[] = "tjs_uint32 ::TVPGetCurrentShiftKeyState()";
		TVPImportFuncPtrb426fbfb6ccb4e89c252b6af566995b8 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_uint32 (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtrb426fbfb6ccb4e89c252b6af566995b8))();
}
inline void TVPEnsureDirectDrawObject()
{
	if(!TVPImportFuncPtr678c2b211f8d8f661f6fdd95c52fbaa8)
	{
		static char funcname[] = "void ::TVPEnsureDirectDrawObject()";
		TVPImportFuncPtr678c2b211f8d8f661f6fdd95c52fbaa8 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtr678c2b211f8d8f661f6fdd95c52fbaa8))();
}
inline IDirectDraw2 * TVPGetDirectDrawObjectNoAddRef()
{
	if(!TVPImportFuncPtr9ec5b02d14238454101dad083b5dfc3b)
	{
		static char funcname[] = "IDirectDraw2 * ::TVPGetDirectDrawObjectNoAddRef()";
		TVPImportFuncPtr9ec5b02d14238454101dad083b5dfc3b = TVPGetImportFuncPtr(funcname);
	}
	typedef IDirectDraw2 * (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtr9ec5b02d14238454101dad083b5dfc3b))();
}
inline IDirectDraw7 * TVPGetDirectDraw7ObjectNoAddRef()
{
	if(!TVPImportFuncPtr471b3daf08ed9b828679d0dae78250ed)
	{
		static char funcname[] = "IDirectDraw7 * ::TVPGetDirectDraw7ObjectNoAddRef()";
		TVPImportFuncPtr471b3daf08ed9b828679d0dae78250ed = TVPGetImportFuncPtr(funcname);
	}
	typedef IDirectDraw7 * (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtr471b3daf08ed9b828679d0dae78250ed))();
}
inline IDirectDrawSurface * TVPGetDDPrimarySurfaceNoAddRef()
{
	if(!TVPImportFuncPtrd0bb2c604ee6f0bba72ddc017f6416eb)
	{
		static char funcname[] = "IDirectDrawSurface * ::TVPGetDDPrimarySurfaceNoAddRef()";
		TVPImportFuncPtrd0bb2c604ee6f0bba72ddc017f6416eb = TVPGetImportFuncPtr(funcname);
	}
	typedef IDirectDrawSurface * (__stdcall * __functype)();
	return ((__functype)(TVPImportFuncPtrd0bb2c604ee6f0bba72ddc017f6416eb))();
}
inline void TVPSetDDPrimaryClipper(IDirectDrawClipper * clipper)
{
	if(!TVPImportFuncPtr3ab4d4d7b57eea827e7bb7c263afb951)
	{
		static char funcname[] = "void ::TVPSetDDPrimaryClipper(IDirectDrawClipper *)";
		TVPImportFuncPtr3ab4d4d7b57eea827e7bb7c263afb951 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(IDirectDrawClipper *);
	((__functype)(TVPImportFuncPtr3ab4d4d7b57eea827e7bb7c263afb951))(clipper);
}
inline void TVPReleaseDDPrimarySurface()
{
	if(!TVPImportFuncPtrdc025d3981a832b095736a0214b98797)
	{
		static char funcname[] = "void ::TVPReleaseDDPrimarySurface()";
		TVPImportFuncPtrdc025d3981a832b095736a0214b98797 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)();
	((__functype)(TVPImportFuncPtrdc025d3981a832b095736a0214b98797))();
}
inline iTVPScanLineProvider * TVPSLPLoadImage(const ttstr & name , tjs_int bpp , tjs_uint32 key , tjs_uint w , tjs_uint h)
{
	if(!TVPImportFuncPtr9982ebedc12d343cb098e2a7b25bdef1)
	{
		static char funcname[] = "iTVPScanLineProvider * ::TVPSLPLoadImage(const ttstr &,tjs_int,tjs_uint32,tjs_uint,tjs_uint)";
		TVPImportFuncPtr9982ebedc12d343cb098e2a7b25bdef1 = TVPGetImportFuncPtr(funcname);
	}
	typedef iTVPScanLineProvider * (__stdcall * __functype)(const ttstr &, tjs_int , tjs_uint32 , tjs_uint , tjs_uint);
	return ((__functype)(TVPImportFuncPtr9982ebedc12d343cb098e2a7b25bdef1))(name, bpp, key, w, h);
}
inline void TVPAddTransHandlerProvider(iTVPTransHandlerProvider * pro)
{
	if(!TVPImportFuncPtr81eeacbed5ee6129bef4b370e28b5d10)
	{
		static char funcname[] = "void ::TVPAddTransHandlerProvider(iTVPTransHandlerProvider *)";
		TVPImportFuncPtr81eeacbed5ee6129bef4b370e28b5d10 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(iTVPTransHandlerProvider *);
	((__functype)(TVPImportFuncPtr81eeacbed5ee6129bef4b370e28b5d10))(pro);
}
inline void TVPRemoveTransHandlerProvider(iTVPTransHandlerProvider * pro)
{
	if(!TVPImportFuncPtr6ed1088905d99012d2fb5827ea19527e)
	{
		static char funcname[] = "void ::TVPRemoveTransHandlerProvider(iTVPTransHandlerProvider *)";
		TVPImportFuncPtr6ed1088905d99012d2fb5827ea19527e = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(iTVPTransHandlerProvider *);
	((__functype)(TVPImportFuncPtr6ed1088905d99012d2fb5827ea19527e))(pro);
}
inline void TVPAlphaBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrb4d6c64cc0004ffaba804f0e8f02ab9b)
	{
		static char funcname[] = "void ::TVPAlphaBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrb4d6c64cc0004ffaba804f0e8f02ab9b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrb4d6c64cc0004ffaba804f0e8f02ab9b))(dest, src, len);
}
inline void TVPAlphaBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr2c3e08b8df93ec50451edd916c707030)
	{
		static char funcname[] = "void ::TVPAlphaBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr2c3e08b8df93ec50451edd916c707030 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr2c3e08b8df93ec50451edd916c707030))(dest, src, len);
}
inline void TVPAlphaBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtreba070d1583ca5f5d02630ba33a5504b)
	{
		static char funcname[] = "void ::TVPAlphaBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtreba070d1583ca5f5d02630ba33a5504b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtreba070d1583ca5f5d02630ba33a5504b))(dest, src, len, opa);
}
inline void TVPAlphaBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtree474537852ce5eb165cb1761950faba)
	{
		static char funcname[] = "void ::TVPAlphaBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtree474537852ce5eb165cb1761950faba = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtree474537852ce5eb165cb1761950faba))(dest, src, len, opa);
}
inline void TVPAlphaBlend_d(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtreed221c603243522667e2f1c6ace3ba4)
	{
		static char funcname[] = "void ::TVPAlphaBlend_d(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtreed221c603243522667e2f1c6ace3ba4 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtreed221c603243522667e2f1c6ace3ba4))(dest, src, len);
}
inline void TVPAlphaBlend_a(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr1f973c5e3cfaf00fa752b7e22d7ba481)
	{
		static char funcname[] = "void ::TVPAlphaBlend_a(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr1f973c5e3cfaf00fa752b7e22d7ba481 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr1f973c5e3cfaf00fa752b7e22d7ba481))(dest, src, len);
}
inline void TVPAlphaBlend_do(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrb9d5260bba9edd7503f1adf882218979)
	{
		static char funcname[] = "void ::TVPAlphaBlend_do(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrb9d5260bba9edd7503f1adf882218979 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrb9d5260bba9edd7503f1adf882218979))(dest, src, len, opa);
}
inline void TVPAlphaBlend_ao(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtraedbd2eda61145de808e295331884245)
	{
		static char funcname[] = "void ::TVPAlphaBlend_ao(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtraedbd2eda61145de808e295331884245 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtraedbd2eda61145de808e295331884245))(dest, src, len, opa);
}
inline void TVPAlphaColorMat(tjs_uint32 * dest , const tjs_uint32 color , tjs_int len)
{
	if(!TVPImportFuncPtrce0f184e84752eb279e4f900d8b53c18)
	{
		static char funcname[] = "void ::TVPAlphaColorMat(tjs_uint32 *,const tjs_uint32,tjs_int)";
		TVPImportFuncPtrce0f184e84752eb279e4f900d8b53c18 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtrce0f184e84752eb279e4f900d8b53c18))(dest, color, len);
}
inline void TVPAdditiveAlphaBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr0217d49393163b80897d044c1d93092f)
	{
		static char funcname[] = "void ::TVPAdditiveAlphaBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr0217d49393163b80897d044c1d93092f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr0217d49393163b80897d044c1d93092f))(dest, src, len);
}
inline void TVPAdditiveAlphaBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr5bbd9d5b364840e9615af35a62f69d7d)
	{
		static char funcname[] = "void ::TVPAdditiveAlphaBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr5bbd9d5b364840e9615af35a62f69d7d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr5bbd9d5b364840e9615af35a62f69d7d))(dest, src, len);
}
inline void TVPAdditiveAlphaBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr2b2837e81fcaeec35f61a2a3ecf2fb2d)
	{
		static char funcname[] = "void ::TVPAdditiveAlphaBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr2b2837e81fcaeec35f61a2a3ecf2fb2d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr2b2837e81fcaeec35f61a2a3ecf2fb2d))(dest, src, len, opa);
}
inline void TVPAdditiveAlphaBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrbb0706a78e9066944bfbffd1406be2d4)
	{
		static char funcname[] = "void ::TVPAdditiveAlphaBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrbb0706a78e9066944bfbffd1406be2d4 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrbb0706a78e9066944bfbffd1406be2d4))(dest, src, len, opa);
}
inline void TVPAdditiveAlphaBlend_a(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr770e67c91215292980b88cc6efb9f2a5)
	{
		static char funcname[] = "void ::TVPAdditiveAlphaBlend_a(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr770e67c91215292980b88cc6efb9f2a5 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr770e67c91215292980b88cc6efb9f2a5))(dest, src, len);
}
inline void TVPAdditiveAlphaBlend_ao(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr068ab11f05731f2c2e9ea8c5fdb16a9f)
	{
		static char funcname[] = "void ::TVPAdditiveAlphaBlend_ao(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr068ab11f05731f2c2e9ea8c5fdb16a9f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr068ab11f05731f2c2e9ea8c5fdb16a9f))(dest, src, len, opa);
}
inline void TVPConvertAdditiveAlphaToAlpha(tjs_uint32 * buf , tjs_int len)
{
	if(!TVPImportFuncPtrb9873a0ad2653952cb2948b817e786e4)
	{
		static char funcname[] = "void ::TVPConvertAdditiveAlphaToAlpha(tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrb9873a0ad2653952cb2948b817e786e4 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrb9873a0ad2653952cb2948b817e786e4))(buf, len);
}
inline void TVPConvertAlphaToAdditiveAlpha(tjs_uint32 * buf , tjs_int len)
{
	if(!TVPImportFuncPtr11d9804ae4db32d731af69c397769cbf)
	{
		static char funcname[] = "void ::TVPConvertAlphaToAdditiveAlpha(tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr11d9804ae4db32d731af69c397769cbf = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr11d9804ae4db32d731af69c397769cbf))(buf, len);
}
inline void TVPStretchAlphaBlend(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtr421f5aa6dbaaaf946f74942c77aac9bc)
	{
		static char funcname[] = "void ::TVPStretchAlphaBlend(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr421f5aa6dbaaaf946f74942c77aac9bc = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr421f5aa6dbaaaf946f74942c77aac9bc))(dest, len, src, srcstart, srcstep);
}
inline void TVPStretchAlphaBlend_HDA(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtr563ee9dcb14a2914fc246e64679f42b5)
	{
		static char funcname[] = "void ::TVPStretchAlphaBlend_HDA(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr563ee9dcb14a2914fc246e64679f42b5 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr563ee9dcb14a2914fc246e64679f42b5))(dest, len, src, srcstart, srcstep);
}
inline void TVPStretchAlphaBlend_o(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtre23a54b6b80bd03111a40f669524724f)
	{
		static char funcname[] = "void ::TVPStretchAlphaBlend_o(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtre23a54b6b80bd03111a40f669524724f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtre23a54b6b80bd03111a40f669524724f))(dest, len, src, srcstart, srcstep, opa);
}
inline void TVPStretchAlphaBlend_HDA_o(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtrc90c8bbd18a7190636ae4269c36ad005)
	{
		static char funcname[] = "void ::TVPStretchAlphaBlend_HDA_o(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrc90c8bbd18a7190636ae4269c36ad005 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrc90c8bbd18a7190636ae4269c36ad005))(dest, len, src, srcstart, srcstep, opa);
}
inline void TVPStretchAlphaBlend_d(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtr03c54a8e8c86e171f868a624e490691f)
	{
		static char funcname[] = "void ::TVPStretchAlphaBlend_d(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr03c54a8e8c86e171f868a624e490691f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr03c54a8e8c86e171f868a624e490691f))(dest, len, src, srcstart, srcstep);
}
inline void TVPStretchAlphaBlend_a(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtr30b63f3cc59b39f1a71829bbbdf6e45d)
	{
		static char funcname[] = "void ::TVPStretchAlphaBlend_a(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr30b63f3cc59b39f1a71829bbbdf6e45d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr30b63f3cc59b39f1a71829bbbdf6e45d))(dest, len, src, srcstart, srcstep);
}
inline void TVPStretchAlphaBlend_do(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtr705bcc30a0561ec679c2267e1a573b23)
	{
		static char funcname[] = "void ::TVPStretchAlphaBlend_do(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr705bcc30a0561ec679c2267e1a573b23 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr705bcc30a0561ec679c2267e1a573b23))(dest, len, src, srcstart, srcstep, opa);
}
inline void TVPStretchAlphaBlend_ao(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtr5c627d080007e455b0393a9b4457cd4d)
	{
		static char funcname[] = "void ::TVPStretchAlphaBlend_ao(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr5c627d080007e455b0393a9b4457cd4d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr5c627d080007e455b0393a9b4457cd4d))(dest, len, src, srcstart, srcstep, opa);
}
inline void TVPStretchAdditiveAlphaBlend(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtr72a64cecd44d80f95fc93faf0d239e32)
	{
		static char funcname[] = "void ::TVPStretchAdditiveAlphaBlend(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr72a64cecd44d80f95fc93faf0d239e32 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr72a64cecd44d80f95fc93faf0d239e32))(dest, len, src, srcstart, srcstep);
}
inline void TVPInterpStretchAdditiveAlphaBlend(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src1 , const tjs_uint32 * src2 , tjs_int blend_y , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtref838904712bfdc614dbc689fbe7fb18)
	{
		static char funcname[] = "void ::TVPInterpStretchAdditiveAlphaBlend(tjs_uint32 *,tjs_int,const tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtref838904712bfdc614dbc689fbe7fb18 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtref838904712bfdc614dbc689fbe7fb18))(dest, destlen, src1, src2, blend_y, srcstart, srcstep);
}
inline void TVPStretchAdditiveAlphaBlend_HDA(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtracc97936adc40656e824cfdf7a34e20c)
	{
		static char funcname[] = "void ::TVPStretchAdditiveAlphaBlend_HDA(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtracc97936adc40656e824cfdf7a34e20c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtracc97936adc40656e824cfdf7a34e20c))(dest, len, src, srcstart, srcstep);
}
inline void TVPStretchAdditiveAlphaBlend_o(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtr5ea1ba3602f9d9fee344de6c3406d7a3)
	{
		static char funcname[] = "void ::TVPStretchAdditiveAlphaBlend_o(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr5ea1ba3602f9d9fee344de6c3406d7a3 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr5ea1ba3602f9d9fee344de6c3406d7a3))(dest, len, src, srcstart, srcstep, opa);
}
inline void TVPInterpStretchAdditiveAlphaBlend_o(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src1 , const tjs_uint32 * src2 , tjs_int blend_y , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtrd25f0771b8fc7715d69f01d950463a49)
	{
		static char funcname[] = "void ::TVPInterpStretchAdditiveAlphaBlend_o(tjs_uint32 *,tjs_int,const tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrd25f0771b8fc7715d69f01d950463a49 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrd25f0771b8fc7715d69f01d950463a49))(dest, destlen, src1, src2, blend_y, srcstart, srcstep, opa);
}
inline void TVPStretchAdditiveAlphaBlend_HDA_o(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtrf8ab11c930782ce058e517d0440ec87f)
	{
		static char funcname[] = "void ::TVPStretchAdditiveAlphaBlend_HDA_o(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrf8ab11c930782ce058e517d0440ec87f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrf8ab11c930782ce058e517d0440ec87f))(dest, len, src, srcstart, srcstep, opa);
}
inline void TVPStretchAdditiveAlphaBlend_a(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtrb8157e369d53c2d944b76494980ced7b)
	{
		static char funcname[] = "void ::TVPStretchAdditiveAlphaBlend_a(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrb8157e369d53c2d944b76494980ced7b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrb8157e369d53c2d944b76494980ced7b))(dest, len, src, srcstart, srcstep);
}
inline void TVPStretchAdditiveAlphaBlend_ao(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtraba94f656b4c1de827d11c72b36a5e9c)
	{
		static char funcname[] = "void ::TVPStretchAdditiveAlphaBlend_ao(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtraba94f656b4c1de827d11c72b36a5e9c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtraba94f656b4c1de827d11c72b36a5e9c))(dest, len, src, srcstart, srcstep, opa);
}
inline void TVPLinTransAlphaBlend(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtr0656942f5a95783a4de73ca6e654d3b5)
	{
		static char funcname[] = "void ::TVPLinTransAlphaBlend(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr0656942f5a95783a4de73ca6e654d3b5 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr0656942f5a95783a4de73ca6e654d3b5))(dest, len, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPLinTransAlphaBlend_HDA(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtr5c2b7d12713dd5a94ef8e6eff1f79752)
	{
		static char funcname[] = "void ::TVPLinTransAlphaBlend_HDA(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr5c2b7d12713dd5a94ef8e6eff1f79752 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr5c2b7d12713dd5a94ef8e6eff1f79752))(dest, len, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPLinTransAlphaBlend_o(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtr6f1d30ac7e812cc5a059459c47638cd0)
	{
		static char funcname[] = "void ::TVPLinTransAlphaBlend_o(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr6f1d30ac7e812cc5a059459c47638cd0 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr6f1d30ac7e812cc5a059459c47638cd0))(dest, len, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPLinTransAlphaBlend_HDA_o(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtr1d51684322635e7848ef53f7f6be8a1e)
	{
		static char funcname[] = "void ::TVPLinTransAlphaBlend_HDA_o(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr1d51684322635e7848ef53f7f6be8a1e = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr1d51684322635e7848ef53f7f6be8a1e))(dest, len, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPLinTransAlphaBlend_d(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtra1f2d56d138a4038fe1678328910a81d)
	{
		static char funcname[] = "void ::TVPLinTransAlphaBlend_d(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtra1f2d56d138a4038fe1678328910a81d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtra1f2d56d138a4038fe1678328910a81d))(dest, len, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPLinTransAlphaBlend_a(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtrc135ef491b533febfd49696d22a1dd3d)
	{
		static char funcname[] = "void ::TVPLinTransAlphaBlend_a(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrc135ef491b533febfd49696d22a1dd3d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrc135ef491b533febfd49696d22a1dd3d))(dest, len, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPLinTransAlphaBlend_do(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtr579117a873b466d78bf93e49c4a078da)
	{
		static char funcname[] = "void ::TVPLinTransAlphaBlend_do(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr579117a873b466d78bf93e49c4a078da = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr579117a873b466d78bf93e49c4a078da))(dest, len, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPLinTransAlphaBlend_ao(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtrec8fa08705639eb7ae5d44ab63dea5e8)
	{
		static char funcname[] = "void ::TVPLinTransAlphaBlend_ao(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrec8fa08705639eb7ae5d44ab63dea5e8 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrec8fa08705639eb7ae5d44ab63dea5e8))(dest, len, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPLinTransAdditiveAlphaBlend(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtrb49dc1cda6109256815dae7b4293725d)
	{
		static char funcname[] = "void ::TVPLinTransAdditiveAlphaBlend(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrb49dc1cda6109256815dae7b4293725d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrb49dc1cda6109256815dae7b4293725d))(dest, len, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPInterpLinTransAdditiveAlphaBlend(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtr912a670f56707ac70f2fee13660c2af8)
	{
		static char funcname[] = "void ::TVPInterpLinTransAdditiveAlphaBlend(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr912a670f56707ac70f2fee13660c2af8 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr912a670f56707ac70f2fee13660c2af8))(dest, destlen, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPLinTransAdditiveAlphaBlend_HDA(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtrd0159986645df76b8c66fdb662efffde)
	{
		static char funcname[] = "void ::TVPLinTransAdditiveAlphaBlend_HDA(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrd0159986645df76b8c66fdb662efffde = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrd0159986645df76b8c66fdb662efffde))(dest, len, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPLinTransAdditiveAlphaBlend_o(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtrcd7a2e6f91bf8d2daa3e28139d7d9f5c)
	{
		static char funcname[] = "void ::TVPLinTransAdditiveAlphaBlend_o(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrcd7a2e6f91bf8d2daa3e28139d7d9f5c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrcd7a2e6f91bf8d2daa3e28139d7d9f5c))(dest, len, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPInterpLinTransAdditiveAlphaBlend_o(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtr676004ca892b2bfee6859d0bb132fdd7)
	{
		static char funcname[] = "void ::TVPInterpLinTransAdditiveAlphaBlend_o(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr676004ca892b2bfee6859d0bb132fdd7 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr676004ca892b2bfee6859d0bb132fdd7))(dest, destlen, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPLinTransAdditiveAlphaBlend_HDA_o(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtrd4b161d8a745baa5e2113669773a758f)
	{
		static char funcname[] = "void ::TVPLinTransAdditiveAlphaBlend_HDA_o(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrd4b161d8a745baa5e2113669773a758f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrd4b161d8a745baa5e2113669773a758f))(dest, len, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPLinTransAdditiveAlphaBlend_a(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtref7537293f6e3b6127480f6c5fd018a1)
	{
		static char funcname[] = "void ::TVPLinTransAdditiveAlphaBlend_a(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtref7537293f6e3b6127480f6c5fd018a1 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtref7537293f6e3b6127480f6c5fd018a1))(dest, len, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPLinTransAdditiveAlphaBlend_ao(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtr6f6f73b75cffe40a28566d1832ae1224)
	{
		static char funcname[] = "void ::TVPLinTransAdditiveAlphaBlend_ao(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr6f6f73b75cffe40a28566d1832ae1224 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr6f6f73b75cffe40a28566d1832ae1224))(dest, len, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPCopyOpaqueImage(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr7adc5aad39e459e01543d07c239efe57)
	{
		static char funcname[] = "void ::TVPCopyOpaqueImage(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr7adc5aad39e459e01543d07c239efe57 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr7adc5aad39e459e01543d07c239efe57))(dest, src, len);
}
inline void TVPConstAlphaBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr3ff6b480097eec3f5fdb7bfad685fd2a)
	{
		static char funcname[] = "void ::TVPConstAlphaBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr3ff6b480097eec3f5fdb7bfad685fd2a = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr3ff6b480097eec3f5fdb7bfad685fd2a))(dest, src, len, opa);
}
inline void TVPConstAlphaBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrb2c50c3a1dfea7e9d05fed69818bafc3)
	{
		static char funcname[] = "void ::TVPConstAlphaBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrb2c50c3a1dfea7e9d05fed69818bafc3 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrb2c50c3a1dfea7e9d05fed69818bafc3))(dest, src, len, opa);
}
inline void TVPConstAlphaBlend_d(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr8024df9077e2c85b5b718ad2c87e57e7)
	{
		static char funcname[] = "void ::TVPConstAlphaBlend_d(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr8024df9077e2c85b5b718ad2c87e57e7 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr8024df9077e2c85b5b718ad2c87e57e7))(dest, src, len, opa);
}
inline void TVPConstAlphaBlend_a(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr989769d4eb8e42e9c9bbe721b296406c)
	{
		static char funcname[] = "void ::TVPConstAlphaBlend_a(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr989769d4eb8e42e9c9bbe721b296406c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr989769d4eb8e42e9c9bbe721b296406c))(dest, src, len, opa);
}
inline void TVPStretchCopyOpaqueImage(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtrcc1ac928b5c31570dfba7ed8f565be4b)
	{
		static char funcname[] = "void ::TVPStretchCopyOpaqueImage(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrcc1ac928b5c31570dfba7ed8f565be4b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrcc1ac928b5c31570dfba7ed8f565be4b))(dest, destlen, src, srcstart, srcstep);
}
inline void TVPStretchConstAlphaBlend(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtr62931efed5729a332e60bd1f7c7cecdf)
	{
		static char funcname[] = "void ::TVPStretchConstAlphaBlend(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr62931efed5729a332e60bd1f7c7cecdf = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr62931efed5729a332e60bd1f7c7cecdf))(dest, len, src, srcstart, srcstep, opa);
}
inline void TVPInterpStretchConstAlphaBlend(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src1 , const tjs_uint32 * src2 , tjs_int blend_y , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtr53c18160b157088f72a9afd79737b48b)
	{
		static char funcname[] = "void ::TVPInterpStretchConstAlphaBlend(tjs_uint32 *,tjs_int,const tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr53c18160b157088f72a9afd79737b48b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr53c18160b157088f72a9afd79737b48b))(dest, destlen, src1, src2, blend_y, srcstart, srcstep, opa);
}
inline void TVPStretchConstAlphaBlend_HDA(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtr48135697fd7f4df87402a7dd4d761555)
	{
		static char funcname[] = "void ::TVPStretchConstAlphaBlend_HDA(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr48135697fd7f4df87402a7dd4d761555 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr48135697fd7f4df87402a7dd4d761555))(dest, len, src, srcstart, srcstep, opa);
}
inline void TVPStretchConstAlphaBlend_d(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtre2c71cf04e876069eb7315c800a96898)
	{
		static char funcname[] = "void ::TVPStretchConstAlphaBlend_d(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtre2c71cf04e876069eb7315c800a96898 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtre2c71cf04e876069eb7315c800a96898))(dest, len, src, srcstart, srcstep, opa);
}
inline void TVPStretchConstAlphaBlend_a(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep , tjs_int opa)
{
	if(!TVPImportFuncPtr1f63c018cf805ca1168af192cf8a4b41)
	{
		static char funcname[] = "void ::TVPStretchConstAlphaBlend_a(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr1f63c018cf805ca1168af192cf8a4b41 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr1f63c018cf805ca1168af192cf8a4b41))(dest, len, src, srcstart, srcstep, opa);
}
inline void TVPLinTransCopyOpaqueImage(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtr704a9574dafd3669e10d546549948e03)
	{
		static char funcname[] = "void ::TVPLinTransCopyOpaqueImage(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr704a9574dafd3669e10d546549948e03 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr704a9574dafd3669e10d546549948e03))(dest, destlen, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPLinTransConstAlphaBlend(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtr97905c510b9502c20c9322c9f5fb4188)
	{
		static char funcname[] = "void ::TVPLinTransConstAlphaBlend(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr97905c510b9502c20c9322c9f5fb4188 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr97905c510b9502c20c9322c9f5fb4188))(dest, len, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPInterpLinTransConstAlphaBlend(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtrb23e84230c4736667279c7a71f4ca53e)
	{
		static char funcname[] = "void ::TVPInterpLinTransConstAlphaBlend(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrb23e84230c4736667279c7a71f4ca53e = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrb23e84230c4736667279c7a71f4ca53e))(dest, destlen, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPLinTransConstAlphaBlend_HDA(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtreb41fc900b0a6e3aba9d531f266137f1)
	{
		static char funcname[] = "void ::TVPLinTransConstAlphaBlend_HDA(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtreb41fc900b0a6e3aba9d531f266137f1 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtreb41fc900b0a6e3aba9d531f266137f1))(dest, len, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPLinTransConstAlphaBlend_d(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtr5bd02c627b74bbb22d5a525b8bcbbd27)
	{
		static char funcname[] = "void ::TVPLinTransConstAlphaBlend_d(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr5bd02c627b74bbb22d5a525b8bcbbd27 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr5bd02c627b74bbb22d5a525b8bcbbd27))(dest, len, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPLinTransConstAlphaBlend_a(tjs_uint32 * dest , tjs_int len , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch , tjs_int opa)
{
	if(!TVPImportFuncPtrcc82e6a6b31ea743b9ebbdeed1ddedc3)
	{
		static char funcname[] = "void ::TVPLinTransConstAlphaBlend_a(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrcc82e6a6b31ea743b9ebbdeed1ddedc3 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrcc82e6a6b31ea743b9ebbdeed1ddedc3))(dest, len, src, sx, sy, stepx, stepy, srcpitch, opa);
}
inline void TVPConstAlphaBlend_SD(tjs_uint32 * dest , const tjs_uint32 * src1 , const tjs_uint32 * src2 , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr247b25d497e48bc0191fdb2ac530f4ca)
	{
		static char funcname[] = "void ::TVPConstAlphaBlend_SD(tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr247b25d497e48bc0191fdb2ac530f4ca = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr247b25d497e48bc0191fdb2ac530f4ca))(dest, src1, src2, len, opa);
}
inline void TVPConstAlphaBlend_SD_a(tjs_uint32 * dest , const tjs_uint32 * src1 , const tjs_uint32 * src2 , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr6bbea3af36c35631641cc8356ff65475)
	{
		static char funcname[] = "void ::TVPConstAlphaBlend_SD_a(tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr6bbea3af36c35631641cc8356ff65475 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr6bbea3af36c35631641cc8356ff65475))(dest, src1, src2, len, opa);
}
inline void TVPConstAlphaBlend_SD_d(tjs_uint32 * dest , const tjs_uint32 * src1 , const tjs_uint32 * src2 , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrcac02dfd62ba94abf6a346bef0bf3ab9)
	{
		static char funcname[] = "void ::TVPConstAlphaBlend_SD_d(tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrcac02dfd62ba94abf6a346bef0bf3ab9 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrcac02dfd62ba94abf6a346bef0bf3ab9))(dest, src1, src2, len, opa);
}
inline void TVPInitUnivTransBlendTable(tjs_uint32 * table , tjs_int phase , tjs_int vague)
{
	if(!TVPImportFuncPtr68eeb36d76d88ff00014f04b23454254)
	{
		static char funcname[] = "void ::TVPInitUnivTransBlendTable(tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr68eeb36d76d88ff00014f04b23454254 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr68eeb36d76d88ff00014f04b23454254))(table, phase, vague);
}
inline void TVPInitUnivTransBlendTable_d(tjs_uint32 * table , tjs_int phase , tjs_int vague)
{
	if(!TVPImportFuncPtr65e03b1c849b6e9cb5c478024aa9a5b7)
	{
		static char funcname[] = "void ::TVPInitUnivTransBlendTable_d(tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr65e03b1c849b6e9cb5c478024aa9a5b7 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr65e03b1c849b6e9cb5c478024aa9a5b7))(table, phase, vague);
}
inline void TVPInitUnivTransBlendTable_a(tjs_uint32 * table , tjs_int phase , tjs_int vague)
{
	if(!TVPImportFuncPtr7670c0c5630625ee6a73b7b9ee093650)
	{
		static char funcname[] = "void ::TVPInitUnivTransBlendTable_a(tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr7670c0c5630625ee6a73b7b9ee093650 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr7670c0c5630625ee6a73b7b9ee093650))(table, phase, vague);
}
inline void TVPUnivTransBlend(tjs_uint32 * dest , const tjs_uint32 * src1 , const tjs_uint32 * src2 , const tjs_uint8 * rule , const tjs_uint32 * table , tjs_int len)
{
	if(!TVPImportFuncPtr68a0abce6eefa08e74353ec48c4c87a8)
	{
		static char funcname[] = "void ::TVPUnivTransBlend(tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,const tjs_uint8 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr68a0abce6eefa08e74353ec48c4c87a8 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, const tjs_uint8 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr68a0abce6eefa08e74353ec48c4c87a8))(dest, src1, src2, rule, table, len);
}
inline void TVPUnivTransBlend_switch(tjs_uint32 * dest , const tjs_uint32 * src1 , const tjs_uint32 * src2 , const tjs_uint8 * rule , const tjs_uint32 * table , tjs_int len , tjs_int src1lv , tjs_int src2lv)
{
	if(!TVPImportFuncPtrccb6e098b9a0791a0f20e9f1af55e341)
	{
		static char funcname[] = "void ::TVPUnivTransBlend_switch(tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,const tjs_uint8 *,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrccb6e098b9a0791a0f20e9f1af55e341 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, const tjs_uint8 *, const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrccb6e098b9a0791a0f20e9f1af55e341))(dest, src1, src2, rule, table, len, src1lv, src2lv);
}
inline void TVPUnivTransBlend_d(tjs_uint32 * dest , const tjs_uint32 * src1 , const tjs_uint32 * src2 , const tjs_uint8 * rule , const tjs_uint32 * table , tjs_int len)
{
	if(!TVPImportFuncPtr0f817efe47b451fd719c05a104c2b803)
	{
		static char funcname[] = "void ::TVPUnivTransBlend_d(tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,const tjs_uint8 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr0f817efe47b451fd719c05a104c2b803 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, const tjs_uint8 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr0f817efe47b451fd719c05a104c2b803))(dest, src1, src2, rule, table, len);
}
inline void TVPUnivTransBlend_switch_d(tjs_uint32 * dest , const tjs_uint32 * src1 , const tjs_uint32 * src2 , const tjs_uint8 * rule , const tjs_uint32 * table , tjs_int len , tjs_int src1lv , tjs_int src2lv)
{
	if(!TVPImportFuncPtrefad1a3d774747bd2b5adb221ede2678)
	{
		static char funcname[] = "void ::TVPUnivTransBlend_switch_d(tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,const tjs_uint8 *,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrefad1a3d774747bd2b5adb221ede2678 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, const tjs_uint8 *, const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrefad1a3d774747bd2b5adb221ede2678))(dest, src1, src2, rule, table, len, src1lv, src2lv);
}
inline void TVPUnivTransBlend_a(tjs_uint32 * dest , const tjs_uint32 * src1 , const tjs_uint32 * src2 , const tjs_uint8 * rule , const tjs_uint32 * table , tjs_int len)
{
	if(!TVPImportFuncPtr563285ed004ddd2945f91db7b5347d3c)
	{
		static char funcname[] = "void ::TVPUnivTransBlend_a(tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,const tjs_uint8 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr563285ed004ddd2945f91db7b5347d3c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, const tjs_uint8 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr563285ed004ddd2945f91db7b5347d3c))(dest, src1, src2, rule, table, len);
}
inline void TVPUnivTransBlend_switch_a(tjs_uint32 * dest , const tjs_uint32 * src1 , const tjs_uint32 * src2 , const tjs_uint8 * rule , const tjs_uint32 * table , tjs_int len , tjs_int src1lv , tjs_int src2lv)
{
	if(!TVPImportFuncPtr4c032260ef83d44bfe05fdc16843a8f9)
	{
		static char funcname[] = "void ::TVPUnivTransBlend_switch_a(tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,const tjs_uint8 *,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr4c032260ef83d44bfe05fdc16843a8f9 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, const tjs_uint8 *, const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr4c032260ef83d44bfe05fdc16843a8f9))(dest, src1, src2, rule, table, len, src1lv, src2lv);
}
inline void TVPApplyColorMap(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color)
{
	if(!TVPImportFuncPtr96fd614457f06499a430b0c6e0e8a941)
	{
		static char funcname[] = "void ::TVPApplyColorMap(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtr96fd614457f06499a430b0c6e0e8a941 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtr96fd614457f06499a430b0c6e0e8a941))(dest, src, len, color);
}
inline void TVPApplyColorMap_o(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color , tjs_int opa)
{
	if(!TVPImportFuncPtrd6e36d304ff7253088ab4bc1aaf13a98)
	{
		static char funcname[] = "void ::TVPApplyColorMap_o(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32,tjs_int)";
		TVPImportFuncPtrd6e36d304ff7253088ab4bc1aaf13a98 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtrd6e36d304ff7253088ab4bc1aaf13a98))(dest, src, len, color, opa);
}
inline void TVPApplyColorMap65(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color)
{
	if(!TVPImportFuncPtreddacf49735189e23d9d49831851ffdb)
	{
		static char funcname[] = "void ::TVPApplyColorMap65(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtreddacf49735189e23d9d49831851ffdb = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtreddacf49735189e23d9d49831851ffdb))(dest, src, len, color);
}
inline void TVPApplyColorMap65_o(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color , tjs_int opa)
{
	if(!TVPImportFuncPtr20275a5de4aef464b85d3f6db2800063)
	{
		static char funcname[] = "void ::TVPApplyColorMap65_o(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32,tjs_int)";
		TVPImportFuncPtr20275a5de4aef464b85d3f6db2800063 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtr20275a5de4aef464b85d3f6db2800063))(dest, src, len, color, opa);
}
inline void TVPApplyColorMap_HDA(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color)
{
	if(!TVPImportFuncPtr872d1c626e6d4e3d5e86a257f0b14536)
	{
		static char funcname[] = "void ::TVPApplyColorMap_HDA(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtr872d1c626e6d4e3d5e86a257f0b14536 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtr872d1c626e6d4e3d5e86a257f0b14536))(dest, src, len, color);
}
inline void TVPApplyColorMap_HDA_o(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color , tjs_int opa)
{
	if(!TVPImportFuncPtra7ebb70cdec339f26c2ea7fd9a471b88)
	{
		static char funcname[] = "void ::TVPApplyColorMap_HDA_o(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32,tjs_int)";
		TVPImportFuncPtra7ebb70cdec339f26c2ea7fd9a471b88 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtra7ebb70cdec339f26c2ea7fd9a471b88))(dest, src, len, color, opa);
}
inline void TVPApplyColorMap65_HDA(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color)
{
	if(!TVPImportFuncPtrd748ffef5cde2a6a3333e75b7fa3fb49)
	{
		static char funcname[] = "void ::TVPApplyColorMap65_HDA(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtrd748ffef5cde2a6a3333e75b7fa3fb49 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtrd748ffef5cde2a6a3333e75b7fa3fb49))(dest, src, len, color);
}
inline void TVPApplyColorMap65_HDA_o(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color , tjs_int opa)
{
	if(!TVPImportFuncPtr15e1fe0e6230e7b60e216e266f927f7b)
	{
		static char funcname[] = "void ::TVPApplyColorMap65_HDA_o(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32,tjs_int)";
		TVPImportFuncPtr15e1fe0e6230e7b60e216e266f927f7b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtr15e1fe0e6230e7b60e216e266f927f7b))(dest, src, len, color, opa);
}
inline void TVPApplyColorMap_d(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color)
{
	if(!TVPImportFuncPtrf8179eafd0cbe8116874310519207dc0)
	{
		static char funcname[] = "void ::TVPApplyColorMap_d(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtrf8179eafd0cbe8116874310519207dc0 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtrf8179eafd0cbe8116874310519207dc0))(dest, src, len, color);
}
inline void TVPApplyColorMap65_d(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color)
{
	if(!TVPImportFuncPtraccbc3bed3223d552de2723366cfc2b6)
	{
		static char funcname[] = "void ::TVPApplyColorMap65_d(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtraccbc3bed3223d552de2723366cfc2b6 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtraccbc3bed3223d552de2723366cfc2b6))(dest, src, len, color);
}
inline void TVPApplyColorMap_a(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color)
{
	if(!TVPImportFuncPtre2c3e74d2a20a601c1f393348f58aeb2)
	{
		static char funcname[] = "void ::TVPApplyColorMap_a(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtre2c3e74d2a20a601c1f393348f58aeb2 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtre2c3e74d2a20a601c1f393348f58aeb2))(dest, src, len, color);
}
inline void TVPApplyColorMap65_a(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color)
{
	if(!TVPImportFuncPtre0163a6ca3397c2e71715132cccefa1d)
	{
		static char funcname[] = "void ::TVPApplyColorMap65_a(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtre0163a6ca3397c2e71715132cccefa1d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtre0163a6ca3397c2e71715132cccefa1d))(dest, src, len, color);
}
inline void TVPApplyColorMap_do(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color , tjs_int opa)
{
	if(!TVPImportFuncPtr2c3ea1ea88799dfde81025bf1959333a)
	{
		static char funcname[] = "void ::TVPApplyColorMap_do(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32,tjs_int)";
		TVPImportFuncPtr2c3ea1ea88799dfde81025bf1959333a = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtr2c3ea1ea88799dfde81025bf1959333a))(dest, src, len, color, opa);
}
inline void TVPApplyColorMap65_do(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color , tjs_int opa)
{
	if(!TVPImportFuncPtra6bb56b3f4b7a89fe78d63956a0f444c)
	{
		static char funcname[] = "void ::TVPApplyColorMap65_do(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32,tjs_int)";
		TVPImportFuncPtra6bb56b3f4b7a89fe78d63956a0f444c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtra6bb56b3f4b7a89fe78d63956a0f444c))(dest, src, len, color, opa);
}
inline void TVPApplyColorMap_ao(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color , tjs_int opa)
{
	if(!TVPImportFuncPtr09a81ac18a121d8fbb67285a081bf9c6)
	{
		static char funcname[] = "void ::TVPApplyColorMap_ao(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32,tjs_int)";
		TVPImportFuncPtr09a81ac18a121d8fbb67285a081bf9c6 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtr09a81ac18a121d8fbb67285a081bf9c6))(dest, src, len, color, opa);
}
inline void TVPApplyColorMap65_ao(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_uint32 color , tjs_int opa)
{
	if(!TVPImportFuncPtr46fdfe0f5369bf234c3ed60a43947d9d)
	{
		static char funcname[] = "void ::TVPApplyColorMap65_ao(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_uint32,tjs_int)";
		TVPImportFuncPtr46fdfe0f5369bf234c3ed60a43947d9d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtr46fdfe0f5369bf234c3ed60a43947d9d))(dest, src, len, color, opa);
}
inline void TVPConstColorAlphaBlend(tjs_uint32 * dest , tjs_int len , tjs_uint32 color , tjs_int opa)
{
	if(!TVPImportFuncPtrd866cb6c8a47444bbac60eeffbfc6d96)
	{
		static char funcname[] = "void ::TVPConstColorAlphaBlend(tjs_uint32 *,tjs_int,tjs_uint32,tjs_int)";
		TVPImportFuncPtrd866cb6c8a47444bbac60eeffbfc6d96 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtrd866cb6c8a47444bbac60eeffbfc6d96))(dest, len, color, opa);
}
inline void TVPConstColorAlphaBlend_d(tjs_uint32 * dest , tjs_int len , tjs_uint32 color , tjs_int opa)
{
	if(!TVPImportFuncPtr7b5718fc67458089c685dbb900126890)
	{
		static char funcname[] = "void ::TVPConstColorAlphaBlend_d(tjs_uint32 *,tjs_int,tjs_uint32,tjs_int)";
		TVPImportFuncPtr7b5718fc67458089c685dbb900126890 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtr7b5718fc67458089c685dbb900126890))(dest, len, color, opa);
}
inline void TVPConstColorAlphaBlend_a(tjs_uint32 * dest , tjs_int len , tjs_uint32 color , tjs_int opa)
{
	if(!TVPImportFuncPtr5713dfe9525662357d3819229e0204c2)
	{
		static char funcname[] = "void ::TVPConstColorAlphaBlend_a(tjs_uint32 *,tjs_int,tjs_uint32,tjs_int)";
		TVPImportFuncPtr5713dfe9525662357d3819229e0204c2 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_uint32 , tjs_int);
	((__functype)(TVPImportFuncPtr5713dfe9525662357d3819229e0204c2))(dest, len, color, opa);
}
inline void TVPRemoveConstOpacity(tjs_uint32 * dest , tjs_int len , tjs_int strength)
{
	if(!TVPImportFuncPtr8954a6b4a7f8b378c2af16a00d5059b0)
	{
		static char funcname[] = "void ::TVPRemoveConstOpacity(tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr8954a6b4a7f8b378c2af16a00d5059b0 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr8954a6b4a7f8b378c2af16a00d5059b0))(dest, len, strength);
}
inline void TVPRemoveOpacity(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len)
{
	if(!TVPImportFuncPtr2ed4faa38db6f3dee0dea18ebe973d35)
	{
		static char funcname[] = "void ::TVPRemoveOpacity(tjs_uint32 *,const tjs_uint8 *,tjs_int)";
		TVPImportFuncPtr2ed4faa38db6f3dee0dea18ebe973d35 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int);
	((__functype)(TVPImportFuncPtr2ed4faa38db6f3dee0dea18ebe973d35))(dest, src, len);
}
inline void TVPRemoveOpacity_o(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_int strength)
{
	if(!TVPImportFuncPtrd0338dedb0af532d22f2075a85373548)
	{
		static char funcname[] = "void ::TVPRemoveOpacity_o(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_int)";
		TVPImportFuncPtrd0338dedb0af532d22f2075a85373548 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrd0338dedb0af532d22f2075a85373548))(dest, src, len, strength);
}
inline void TVPRemoveOpacity65(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len)
{
	if(!TVPImportFuncPtr583d57c3bb9491f8f9904c266d3f52e8)
	{
		static char funcname[] = "void ::TVPRemoveOpacity65(tjs_uint32 *,const tjs_uint8 *,tjs_int)";
		TVPImportFuncPtr583d57c3bb9491f8f9904c266d3f52e8 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int);
	((__functype)(TVPImportFuncPtr583d57c3bb9491f8f9904c266d3f52e8))(dest, src, len);
}
inline void TVPRemoveOpacity65_o(tjs_uint32 * dest , const tjs_uint8 * src , tjs_int len , tjs_int strength)
{
	if(!TVPImportFuncPtr8ac206da43e322eb8e34fce2b0959656)
	{
		static char funcname[] = "void ::TVPRemoveOpacity65_o(tjs_uint32 *,const tjs_uint8 *,tjs_int,tjs_int)";
		TVPImportFuncPtr8ac206da43e322eb8e34fce2b0959656 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr8ac206da43e322eb8e34fce2b0959656))(dest, src, len, strength);
}
inline void TVPAddBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr14f5f97d90bd8da89b68d035367f4ba4)
	{
		static char funcname[] = "void ::TVPAddBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr14f5f97d90bd8da89b68d035367f4ba4 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr14f5f97d90bd8da89b68d035367f4ba4))(dest, src, len);
}
inline void TVPAddBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrac3b21181ef4c1be73cf5e0edb4e1a8f)
	{
		static char funcname[] = "void ::TVPAddBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrac3b21181ef4c1be73cf5e0edb4e1a8f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrac3b21181ef4c1be73cf5e0edb4e1a8f))(dest, src, len);
}
inline void TVPAddBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr1d7d97509292a4ca9269f2539dcc70fd)
	{
		static char funcname[] = "void ::TVPAddBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr1d7d97509292a4ca9269f2539dcc70fd = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr1d7d97509292a4ca9269f2539dcc70fd))(dest, src, len, opa);
}
inline void TVPAddBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrc4033f54a99517783b8d6ad23c90aeed)
	{
		static char funcname[] = "void ::TVPAddBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrc4033f54a99517783b8d6ad23c90aeed = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrc4033f54a99517783b8d6ad23c90aeed))(dest, src, len, opa);
}
inline void TVPSubBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrf19e38d48755c971fc35408ac65562fa)
	{
		static char funcname[] = "void ::TVPSubBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrf19e38d48755c971fc35408ac65562fa = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrf19e38d48755c971fc35408ac65562fa))(dest, src, len);
}
inline void TVPSubBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtre01204e226d8aa9520b3620b68da6196)
	{
		static char funcname[] = "void ::TVPSubBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtre01204e226d8aa9520b3620b68da6196 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtre01204e226d8aa9520b3620b68da6196))(dest, src, len);
}
inline void TVPSubBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrb50000da98f1257cf789fc63fb1fda02)
	{
		static char funcname[] = "void ::TVPSubBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrb50000da98f1257cf789fc63fb1fda02 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrb50000da98f1257cf789fc63fb1fda02))(dest, src, len, opa);
}
inline void TVPSubBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrc55f38b1a7623646aa5cc45d4f4f479b)
	{
		static char funcname[] = "void ::TVPSubBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrc55f38b1a7623646aa5cc45d4f4f479b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrc55f38b1a7623646aa5cc45d4f4f479b))(dest, src, len, opa);
}
inline void TVPMulBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr983d270549ec0e83e2a863b43e1e6f70)
	{
		static char funcname[] = "void ::TVPMulBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr983d270549ec0e83e2a863b43e1e6f70 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr983d270549ec0e83e2a863b43e1e6f70))(dest, src, len);
}
inline void TVPMulBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrb48d779dc6a881c67c5f8fa12655aa28)
	{
		static char funcname[] = "void ::TVPMulBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrb48d779dc6a881c67c5f8fa12655aa28 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrb48d779dc6a881c67c5f8fa12655aa28))(dest, src, len);
}
inline void TVPMulBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrd3967c6e24d0c4ad107a03c1cadd57b1)
	{
		static char funcname[] = "void ::TVPMulBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrd3967c6e24d0c4ad107a03c1cadd57b1 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrd3967c6e24d0c4ad107a03c1cadd57b1))(dest, src, len, opa);
}
inline void TVPMulBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr6b6f416b5725a7cafb4774ffc3a00f10)
	{
		static char funcname[] = "void ::TVPMulBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr6b6f416b5725a7cafb4774ffc3a00f10 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr6b6f416b5725a7cafb4774ffc3a00f10))(dest, src, len, opa);
}
inline void TVPColorDodgeBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrbc7fc5dfa228152a09d2230823c2fe71)
	{
		static char funcname[] = "void ::TVPColorDodgeBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrbc7fc5dfa228152a09d2230823c2fe71 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrbc7fc5dfa228152a09d2230823c2fe71))(dest, src, len);
}
inline void TVPColorDodgeBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtra1cb941317b947beb88e29fa8d46a2be)
	{
		static char funcname[] = "void ::TVPColorDodgeBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtra1cb941317b947beb88e29fa8d46a2be = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtra1cb941317b947beb88e29fa8d46a2be))(dest, src, len);
}
inline void TVPColorDodgeBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr8e185e82bb27a7fb40f0b08f560a57e9)
	{
		static char funcname[] = "void ::TVPColorDodgeBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr8e185e82bb27a7fb40f0b08f560a57e9 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr8e185e82bb27a7fb40f0b08f560a57e9))(dest, src, len, opa);
}
inline void TVPColorDodgeBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr4b7b264b61ee0eea68213934217f5865)
	{
		static char funcname[] = "void ::TVPColorDodgeBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr4b7b264b61ee0eea68213934217f5865 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr4b7b264b61ee0eea68213934217f5865))(dest, src, len, opa);
}
inline void TVPDarkenBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtre872f12593d6853ebdffebbb5d003c10)
	{
		static char funcname[] = "void ::TVPDarkenBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtre872f12593d6853ebdffebbb5d003c10 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtre872f12593d6853ebdffebbb5d003c10))(dest, src, len);
}
inline void TVPDarkenBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtre86fcf60fa658129d937de3728d3c432)
	{
		static char funcname[] = "void ::TVPDarkenBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtre86fcf60fa658129d937de3728d3c432 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtre86fcf60fa658129d937de3728d3c432))(dest, src, len);
}
inline void TVPDarkenBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr350741a7398a187628866f5b397c7a99)
	{
		static char funcname[] = "void ::TVPDarkenBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr350741a7398a187628866f5b397c7a99 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr350741a7398a187628866f5b397c7a99))(dest, src, len, opa);
}
inline void TVPDarkenBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr3b5a3e187077b0b5eac9a040c99dd9e7)
	{
		static char funcname[] = "void ::TVPDarkenBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr3b5a3e187077b0b5eac9a040c99dd9e7 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr3b5a3e187077b0b5eac9a040c99dd9e7))(dest, src, len, opa);
}
inline void TVPLightenBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr2d9b2bb2cd57220048fe170f1e960cb7)
	{
		static char funcname[] = "void ::TVPLightenBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr2d9b2bb2cd57220048fe170f1e960cb7 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr2d9b2bb2cd57220048fe170f1e960cb7))(dest, src, len);
}
inline void TVPLightenBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr260624e275a20115e8861eb7b0383971)
	{
		static char funcname[] = "void ::TVPLightenBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr260624e275a20115e8861eb7b0383971 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr260624e275a20115e8861eb7b0383971))(dest, src, len);
}
inline void TVPLightenBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr15b31724287dbbecb775b2e46dc35fb9)
	{
		static char funcname[] = "void ::TVPLightenBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr15b31724287dbbecb775b2e46dc35fb9 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr15b31724287dbbecb775b2e46dc35fb9))(dest, src, len, opa);
}
inline void TVPLightenBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrff652293eef07b5a7ec4f372e5504e2c)
	{
		static char funcname[] = "void ::TVPLightenBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrff652293eef07b5a7ec4f372e5504e2c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrff652293eef07b5a7ec4f372e5504e2c))(dest, src, len, opa);
}
inline void TVPScreenBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr99b773033e9a2c631b483d4d0e3881f8)
	{
		static char funcname[] = "void ::TVPScreenBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr99b773033e9a2c631b483d4d0e3881f8 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr99b773033e9a2c631b483d4d0e3881f8))(dest, src, len);
}
inline void TVPScreenBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr3787960fc29b8545629d894ff46d4641)
	{
		static char funcname[] = "void ::TVPScreenBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr3787960fc29b8545629d894ff46d4641 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr3787960fc29b8545629d894ff46d4641))(dest, src, len);
}
inline void TVPScreenBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr3fc76257bb1639de4bfa0c0fcedf9c4a)
	{
		static char funcname[] = "void ::TVPScreenBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr3fc76257bb1639de4bfa0c0fcedf9c4a = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr3fc76257bb1639de4bfa0c0fcedf9c4a))(dest, src, len, opa);
}
inline void TVPScreenBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr292ee2eeb8131e34368ba9ee144b737a)
	{
		static char funcname[] = "void ::TVPScreenBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr292ee2eeb8131e34368ba9ee144b737a = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr292ee2eeb8131e34368ba9ee144b737a))(dest, src, len, opa);
}
inline void TVPStretchCopy(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtrec144655bc61bfa2c6e9505cc1a0a298)
	{
		static char funcname[] = "void ::TVPStretchCopy(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrec144655bc61bfa2c6e9505cc1a0a298 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrec144655bc61bfa2c6e9505cc1a0a298))(dest, destlen, src, srcstart, srcstep);
}
inline void TVPInterpStretchCopy(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src1 , const tjs_uint32 * src2 , tjs_int blend_y , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtr230218bdabfc34178a8306a54276a3c8)
	{
		static char funcname[] = "void ::TVPInterpStretchCopy(tjs_uint32 *,tjs_int,const tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr230218bdabfc34178a8306a54276a3c8 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr230218bdabfc34178a8306a54276a3c8))(dest, destlen, src1, src2, blend_y, srcstart, srcstep);
}
inline void TVPFastLinearInterpH2F(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src)
{
	if(!TVPImportFuncPtr617dfb046aaf40078ee76715fa4756af)
	{
		static char funcname[] = "void ::TVPFastLinearInterpH2F(tjs_uint32 *,tjs_int,const tjs_uint32 *)";
		TVPImportFuncPtr617dfb046aaf40078ee76715fa4756af = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *);
	((__functype)(TVPImportFuncPtr617dfb046aaf40078ee76715fa4756af))(dest, destlen, src);
}
inline void TVPFastLinearInterpH2B(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src)
{
	if(!TVPImportFuncPtr8116bb2b26dcafd9fefca76e9f1d9b24)
	{
		static char funcname[] = "void ::TVPFastLinearInterpH2B(tjs_uint32 *,tjs_int,const tjs_uint32 *)";
		TVPImportFuncPtr8116bb2b26dcafd9fefca76e9f1d9b24 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *);
	((__functype)(TVPImportFuncPtr8116bb2b26dcafd9fefca76e9f1d9b24))(dest, destlen, src);
}
inline void TVPFastLinearInterpV2(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src0 , const tjs_uint32 * src1)
{
	if(!TVPImportFuncPtr12962f857563cd39b3cb1f9894775cc7)
	{
		static char funcname[] = "void ::TVPFastLinearInterpV2(tjs_uint32 *,tjs_int,const tjs_uint32 *,const tjs_uint32 *)";
		TVPImportFuncPtr12962f857563cd39b3cb1f9894775cc7 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, const tjs_uint32 *);
	((__functype)(TVPImportFuncPtr12962f857563cd39b3cb1f9894775cc7))(dest, destlen, src0, src1);
}
inline void TVPStretchColorCopy(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src , tjs_int srcstart , tjs_int srcstep)
{
	if(!TVPImportFuncPtr50c0d25cd9af311a5fb0aca78f691c3b)
	{
		static char funcname[] = "void ::TVPStretchColorCopy(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr50c0d25cd9af311a5fb0aca78f691c3b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr50c0d25cd9af311a5fb0aca78f691c3b))(dest, destlen, src, srcstart, srcstep);
}
inline void TVPLinTransCopy(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtr6c37a1ccda816c4fbab4f0117ca75e8a)
	{
		static char funcname[] = "void ::TVPLinTransCopy(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr6c37a1ccda816c4fbab4f0117ca75e8a = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr6c37a1ccda816c4fbab4f0117ca75e8a))(dest, destlen, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPInterpLinTransCopy(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtre21c21762dd0e36d6f7d2cedaac97383)
	{
		static char funcname[] = "void ::TVPInterpLinTransCopy(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtre21c21762dd0e36d6f7d2cedaac97383 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtre21c21762dd0e36d6f7d2cedaac97383))(dest, destlen, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPLinTransColorCopy(tjs_uint32 * dest , tjs_int destlen , const tjs_uint32 * src , tjs_int sx , tjs_int sy , tjs_int stepx , tjs_int stepy , tjs_int srcpitch)
{
	if(!TVPImportFuncPtr487ee86557f94113db9a981e08d29caa)
	{
		static char funcname[] = "void ::TVPLinTransColorCopy(tjs_uint32 *,tjs_int,const tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr487ee86557f94113db9a981e08d29caa = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , const tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr487ee86557f94113db9a981e08d29caa))(dest, destlen, src, sx, sy, stepx, stepy, srcpitch);
}
inline void TVPMakeAlphaFromKey(tjs_uint32 * dest , tjs_int len , tjs_uint32 key)
{
	if(!TVPImportFuncPtrdfdfe0e494845bf484612cc97145f85c)
	{
		static char funcname[] = "void ::TVPMakeAlphaFromKey(tjs_uint32 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtrdfdfe0e494845bf484612cc97145f85c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtrdfdfe0e494845bf484612cc97145f85c))(dest, len, key);
}
inline void TVPCopyMask(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtre74dc11dbd56fb450eed1388a65d3102)
	{
		static char funcname[] = "void ::TVPCopyMask(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtre74dc11dbd56fb450eed1388a65d3102 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtre74dc11dbd56fb450eed1388a65d3102))(dest, src, len);
}
inline void TVPCopyColor(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr6981c02247de5799ea7dfbd79fdc208d)
	{
		static char funcname[] = "void ::TVPCopyColor(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr6981c02247de5799ea7dfbd79fdc208d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr6981c02247de5799ea7dfbd79fdc208d))(dest, src, len);
}
inline void TVPBindMaskToMain(tjs_uint32 * main , const tjs_uint8 * mask , tjs_int len)
{
	if(!TVPImportFuncPtr7c559043315f6ecd7a86ec7d8d820f6d)
	{
		static char funcname[] = "void ::TVPBindMaskToMain(tjs_uint32 *,const tjs_uint8 *,tjs_int)";
		TVPImportFuncPtr7c559043315f6ecd7a86ec7d8d820f6d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int);
	((__functype)(TVPImportFuncPtr7c559043315f6ecd7a86ec7d8d820f6d))(main, mask, len);
}
inline void TVPFillARGB(tjs_uint32 * dest , tjs_int len , tjs_uint32 value)
{
	if(!TVPImportFuncPtr3a8b6aca73c83d6fc9ce813661ec734d)
	{
		static char funcname[] = "void ::TVPFillARGB(tjs_uint32 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtr3a8b6aca73c83d6fc9ce813661ec734d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtr3a8b6aca73c83d6fc9ce813661ec734d))(dest, len, value);
}
inline void TVPFillARGB_NC(tjs_uint32 * dest , tjs_int len , tjs_uint32 value)
{
	if(!TVPImportFuncPtr20d7ce65e240b745b10616bb5da1f897)
	{
		static char funcname[] = "void ::TVPFillARGB_NC(tjs_uint32 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtr20d7ce65e240b745b10616bb5da1f897 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtr20d7ce65e240b745b10616bb5da1f897))(dest, len, value);
}
inline void TVPFillColor(tjs_uint32 * dest , tjs_int len , tjs_uint32 color)
{
	if(!TVPImportFuncPtrf4d1217249674ac9274d358c381afc0b)
	{
		static char funcname[] = "void ::TVPFillColor(tjs_uint32 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtrf4d1217249674ac9274d358c381afc0b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtrf4d1217249674ac9274d358c381afc0b))(dest, len, color);
}
inline void TVPFillMask(tjs_uint32 * dest , tjs_int len , tjs_uint32 mask)
{
	if(!TVPImportFuncPtrca77323bbe361f88f68536018fa94c50)
	{
		static char funcname[] = "void ::TVPFillMask(tjs_uint32 *,tjs_int,tjs_uint32)";
		TVPImportFuncPtrca77323bbe361f88f68536018fa94c50 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tjs_uint32);
	((__functype)(TVPImportFuncPtrca77323bbe361f88f68536018fa94c50))(dest, len, mask);
}
inline void TVPAddSubVertSum16(tjs_uint16 * dest , const tjs_uint32 * addline , const tjs_uint32 * subline , tjs_int len)
{
	if(!TVPImportFuncPtr17983ecc7e7fe370bce664281a84c948)
	{
		static char funcname[] = "void ::TVPAddSubVertSum16(tjs_uint16 *,const tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr17983ecc7e7fe370bce664281a84c948 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint16 *, const tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr17983ecc7e7fe370bce664281a84c948))(dest, addline, subline, len);
}
inline void TVPAddSubVertSum16_d(tjs_uint16 * dest , const tjs_uint32 * addline , const tjs_uint32 * subline , tjs_int len)
{
	if(!TVPImportFuncPtr61a2f61030362903d00ba21a3cebecdd)
	{
		static char funcname[] = "void ::TVPAddSubVertSum16_d(tjs_uint16 *,const tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr61a2f61030362903d00ba21a3cebecdd = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint16 *, const tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr61a2f61030362903d00ba21a3cebecdd))(dest, addline, subline, len);
}
inline void TVPAddSubVertSum32(tjs_uint32 * dest , const tjs_uint32 * addline , const tjs_uint32 * subline , tjs_int len)
{
	if(!TVPImportFuncPtre9f985403dbd18540d8230a2af6ed76b)
	{
		static char funcname[] = "void ::TVPAddSubVertSum32(tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtre9f985403dbd18540d8230a2af6ed76b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtre9f985403dbd18540d8230a2af6ed76b))(dest, addline, subline, len);
}
inline void TVPAddSubVertSum32_d(tjs_uint32 * dest , const tjs_uint32 * addline , const tjs_uint32 * subline , tjs_int len)
{
	if(!TVPImportFuncPtrbe0523c9a72ba26cb4bfa3cb188cacf6)
	{
		static char funcname[] = "void ::TVPAddSubVertSum32_d(tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrbe0523c9a72ba26cb4bfa3cb188cacf6 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrbe0523c9a72ba26cb4bfa3cb188cacf6))(dest, addline, subline, len);
}
inline void TVPDoBoxBlurAvg16(tjs_uint32 * dest , tjs_uint16 * sum , const tjs_uint16 * add , const tjs_uint16 * sub , tjs_int n , tjs_int len)
{
	if(!TVPImportFuncPtr8ac7cf651223c8ba53df90cf4f3d3bbc)
	{
		static char funcname[] = "void ::TVPDoBoxBlurAvg16(tjs_uint32 *,tjs_uint16 *,const tjs_uint16 *,const tjs_uint16 *,tjs_int,tjs_int)";
		TVPImportFuncPtr8ac7cf651223c8ba53df90cf4f3d3bbc = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_uint16 *, const tjs_uint16 *, const tjs_uint16 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr8ac7cf651223c8ba53df90cf4f3d3bbc))(dest, sum, add, sub, n, len);
}
inline void TVPDoBoxBlurAvg16_d(tjs_uint32 * dest , tjs_uint16 * sum , const tjs_uint16 * add , const tjs_uint16 * sub , tjs_int n , tjs_int len)
{
	if(!TVPImportFuncPtr873e73aa35096ad4c684d394a10135a6)
	{
		static char funcname[] = "void ::TVPDoBoxBlurAvg16_d(tjs_uint32 *,tjs_uint16 *,const tjs_uint16 *,const tjs_uint16 *,tjs_int,tjs_int)";
		TVPImportFuncPtr873e73aa35096ad4c684d394a10135a6 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_uint16 *, const tjs_uint16 *, const tjs_uint16 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr873e73aa35096ad4c684d394a10135a6))(dest, sum, add, sub, n, len);
}
inline void TVPDoBoxBlurAvg32(tjs_uint32 * dest , tjs_uint32 * sum , const tjs_uint32 * add , const tjs_uint32 * sub , tjs_int n , tjs_int len)
{
	if(!TVPImportFuncPtr3342548f105147c86019ae31ece01d4e)
	{
		static char funcname[] = "void ::TVPDoBoxBlurAvg32(tjs_uint32 *,tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr3342548f105147c86019ae31ece01d4e = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr3342548f105147c86019ae31ece01d4e))(dest, sum, add, sub, n, len);
}
inline void TVPDoBoxBlurAvg32_d(tjs_uint32 * dest , tjs_uint32 * sum , const tjs_uint32 * add , const tjs_uint32 * sub , tjs_int n , tjs_int len)
{
	if(!TVPImportFuncPtr607ee0956cbb16b2afb7cb2227aa6267)
	{
		static char funcname[] = "void ::TVPDoBoxBlurAvg32_d(tjs_uint32 *,tjs_uint32 *,const tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr607ee0956cbb16b2afb7cb2227aa6267 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_uint32 *, const tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr607ee0956cbb16b2afb7cb2227aa6267))(dest, sum, add, sub, n, len);
}
inline void TVPSwapLine8(tjs_uint8 * line1 , tjs_uint8 * line2 , tjs_int len)
{
	if(!TVPImportFuncPtr816d84c86e86d5e7c0018d551e741e4f)
	{
		static char funcname[] = "void ::TVPSwapLine8(tjs_uint8 *,tjs_uint8 *,tjs_int)";
		TVPImportFuncPtr816d84c86e86d5e7c0018d551e741e4f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, tjs_uint8 *, tjs_int);
	((__functype)(TVPImportFuncPtr816d84c86e86d5e7c0018d551e741e4f))(line1, line2, len);
}
inline void TVPSwapLine32(tjs_uint32 * line1 , tjs_uint32 * line2 , tjs_int len)
{
	if(!TVPImportFuncPtr985fcda0141eb3b4c6bd8342e947f130)
	{
		static char funcname[] = "void ::TVPSwapLine32(tjs_uint32 *,tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr985fcda0141eb3b4c6bd8342e947f130 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr985fcda0141eb3b4c6bd8342e947f130))(line1, line2, len);
}
inline void TVPReverse8(tjs_uint8 * pixels , tjs_int len)
{
	if(!TVPImportFuncPtrd00e4f9e493334d2f65ea379ff03d717)
	{
		static char funcname[] = "void ::TVPReverse8(tjs_uint8 *,tjs_int)";
		TVPImportFuncPtrd00e4f9e493334d2f65ea379ff03d717 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, tjs_int);
	((__functype)(TVPImportFuncPtrd00e4f9e493334d2f65ea379ff03d717))(pixels, len);
}
inline void TVPReverse32(tjs_uint32 * pixels , tjs_int len)
{
	if(!TVPImportFuncPtr0c246e6c7c8798e4c10d2bbfc66326c9)
	{
		static char funcname[] = "void ::TVPReverse32(tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr0c246e6c7c8798e4c10d2bbfc66326c9 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr0c246e6c7c8798e4c10d2bbfc66326c9))(pixels, len);
}
inline void TVPDoGrayScale(tjs_uint32 * dest , tjs_int len)
{
	if(!TVPImportFuncPtr501015843a83368b3ff1c7c9ef5f3bcb)
	{
		static char funcname[] = "void ::TVPDoGrayScale(tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr501015843a83368b3ff1c7c9ef5f3bcb = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr501015843a83368b3ff1c7c9ef5f3bcb))(dest, len);
}
inline void TVPInitGammaAdjustTempData(tTVPGLGammaAdjustTempData * temp , const tTVPGLGammaAdjustData * data)
{
	if(!TVPImportFuncPtr61d5fc5a060f346752a3a8b6886d17bc)
	{
		static char funcname[] = "void ::TVPInitGammaAdjustTempData(tTVPGLGammaAdjustTempData *,const tTVPGLGammaAdjustData *)";
		TVPImportFuncPtr61d5fc5a060f346752a3a8b6886d17bc = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tTVPGLGammaAdjustTempData *, const tTVPGLGammaAdjustData *);
	((__functype)(TVPImportFuncPtr61d5fc5a060f346752a3a8b6886d17bc))(temp, data);
}
inline void TVPUninitGammaAdjustTempData(tTVPGLGammaAdjustTempData * temp)
{
	if(!TVPImportFuncPtr0debe3e1caf0f57572a59917851676d3)
	{
		static char funcname[] = "void ::TVPUninitGammaAdjustTempData(tTVPGLGammaAdjustTempData *)";
		TVPImportFuncPtr0debe3e1caf0f57572a59917851676d3 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tTVPGLGammaAdjustTempData *);
	((__functype)(TVPImportFuncPtr0debe3e1caf0f57572a59917851676d3))(temp);
}
inline void TVPAdjustGamma(tjs_uint32 * dest , tjs_int len , tTVPGLGammaAdjustTempData * temp)
{
	if(!TVPImportFuncPtree3a36682f48639166ba04a19fe1b332)
	{
		static char funcname[] = "void ::TVPAdjustGamma(tjs_uint32 *,tjs_int,tTVPGLGammaAdjustTempData *)";
		TVPImportFuncPtree3a36682f48639166ba04a19fe1b332 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tTVPGLGammaAdjustTempData *);
	((__functype)(TVPImportFuncPtree3a36682f48639166ba04a19fe1b332))(dest, len, temp);
}
inline void TVPAdjustGamma_a(tjs_uint32 * dest , tjs_int len , tTVPGLGammaAdjustTempData * temp)
{
	if(!TVPImportFuncPtr4d99b9e38121251b40a90cd2bd5fea63)
	{
		static char funcname[] = "void ::TVPAdjustGamma_a(tjs_uint32 *,tjs_int,tTVPGLGammaAdjustTempData *)";
		TVPImportFuncPtr4d99b9e38121251b40a90cd2bd5fea63 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_int , tTVPGLGammaAdjustTempData *);
	((__functype)(TVPImportFuncPtr4d99b9e38121251b40a90cd2bd5fea63))(dest, len, temp);
}
inline void TVPChBlurMulCopy65(tjs_uint8 * dest , const tjs_uint8 * src , tjs_int len , tjs_int level)
{
	if(!TVPImportFuncPtrf1509827696ebf5627bee1a45d675fb8)
	{
		static char funcname[] = "void ::TVPChBlurMulCopy65(tjs_uint8 *,const tjs_uint8 *,tjs_int,tjs_int)";
		TVPImportFuncPtrf1509827696ebf5627bee1a45d675fb8 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint8 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrf1509827696ebf5627bee1a45d675fb8))(dest, src, len, level);
}
inline void TVPChBlurAddMulCopy65(tjs_uint8 * dest , const tjs_uint8 * src , tjs_int len , tjs_int level)
{
	if(!TVPImportFuncPtrbbb625e23229350453161810c41419dd)
	{
		static char funcname[] = "void ::TVPChBlurAddMulCopy65(tjs_uint8 *,const tjs_uint8 *,tjs_int,tjs_int)";
		TVPImportFuncPtrbbb625e23229350453161810c41419dd = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint8 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrbbb625e23229350453161810c41419dd))(dest, src, len, level);
}
inline void TVPChBlurCopy65(tjs_uint8 * dest , tjs_int destpitch , tjs_int destwidth , tjs_int destheight , const tjs_uint8 * src , tjs_int srcpitch , tjs_int srcwidth , tjs_int srcheight , tjs_int blurwidth , tjs_int blurlevel)
{
	if(!TVPImportFuncPtr489a6aae30de0feff5d3c5fbd42ae325)
	{
		static char funcname[] = "void ::TVPChBlurCopy65(tjs_uint8 *,tjs_int,tjs_int,tjs_int,const tjs_uint8 *,tjs_int,tjs_int,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtr489a6aae30de0feff5d3c5fbd42ae325 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, tjs_int , tjs_int , tjs_int , const tjs_uint8 *, tjs_int , tjs_int , tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr489a6aae30de0feff5d3c5fbd42ae325))(dest, destpitch, destwidth, destheight, src, srcpitch, srcwidth, srcheight, blurwidth, blurlevel);
}
inline void TVPBLExpand1BitTo8BitPal(tjs_uint8 * dest , const tjs_uint8 * buf , tjs_int len , const tjs_uint32 * pal)
{
	if(!TVPImportFuncPtr186a94b2fed609ed2d2a7ac1a2bed87f)
	{
		static char funcname[] = "void ::TVPBLExpand1BitTo8BitPal(tjs_uint8 *,const tjs_uint8 *,tjs_int,const tjs_uint32 *)";
		TVPImportFuncPtr186a94b2fed609ed2d2a7ac1a2bed87f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint8 *, tjs_int , const tjs_uint32 *);
	((__functype)(TVPImportFuncPtr186a94b2fed609ed2d2a7ac1a2bed87f))(dest, buf, len, pal);
}
inline void TVPBLExpand1BitTo8Bit(tjs_uint8 * dest , const tjs_uint8 * buf , tjs_int len)
{
	if(!TVPImportFuncPtrbde8efb9971664f2b52fe912745e2791)
	{
		static char funcname[] = "void ::TVPBLExpand1BitTo8Bit(tjs_uint8 *,const tjs_uint8 *,tjs_int)";
		TVPImportFuncPtrbde8efb9971664f2b52fe912745e2791 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint8 *, tjs_int);
	((__functype)(TVPImportFuncPtrbde8efb9971664f2b52fe912745e2791))(dest, buf, len);
}
inline void TVPBLExpand1BitTo32BitPal(tjs_uint32 * dest , const tjs_uint8 * buf , tjs_int len , const tjs_uint32 * pal)
{
	if(!TVPImportFuncPtr386d6fa5cb73e3519b62d20470e5414b)
	{
		static char funcname[] = "void ::TVPBLExpand1BitTo32BitPal(tjs_uint32 *,const tjs_uint8 *,tjs_int,const tjs_uint32 *)";
		TVPImportFuncPtr386d6fa5cb73e3519b62d20470e5414b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , const tjs_uint32 *);
	((__functype)(TVPImportFuncPtr386d6fa5cb73e3519b62d20470e5414b))(dest, buf, len, pal);
}
inline void TVPBLExpand4BitTo8BitPal(tjs_uint8 * dest , const tjs_uint8 * buf , tjs_int len , const tjs_uint32 * pal)
{
	if(!TVPImportFuncPtrc61f97ec3d99bdbb23afe93870001bbf)
	{
		static char funcname[] = "void ::TVPBLExpand4BitTo8BitPal(tjs_uint8 *,const tjs_uint8 *,tjs_int,const tjs_uint32 *)";
		TVPImportFuncPtrc61f97ec3d99bdbb23afe93870001bbf = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint8 *, tjs_int , const tjs_uint32 *);
	((__functype)(TVPImportFuncPtrc61f97ec3d99bdbb23afe93870001bbf))(dest, buf, len, pal);
}
inline void TVPBLExpand4BitTo8Bit(tjs_uint8 * dest , const tjs_uint8 * buf , tjs_int len)
{
	if(!TVPImportFuncPtrf92821f2b23662c6f1256511a626cd3f)
	{
		static char funcname[] = "void ::TVPBLExpand4BitTo8Bit(tjs_uint8 *,const tjs_uint8 *,tjs_int)";
		TVPImportFuncPtrf92821f2b23662c6f1256511a626cd3f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint8 *, tjs_int);
	((__functype)(TVPImportFuncPtrf92821f2b23662c6f1256511a626cd3f))(dest, buf, len);
}
inline void TVPBLExpand4BitTo32BitPal(tjs_uint32 * dest , const tjs_uint8 * buf , tjs_int len , const tjs_uint32 * pal)
{
	if(!TVPImportFuncPtr76b0732e3e2886897d5f26b4b0545dee)
	{
		static char funcname[] = "void ::TVPBLExpand4BitTo32BitPal(tjs_uint32 *,const tjs_uint8 *,tjs_int,const tjs_uint32 *)";
		TVPImportFuncPtr76b0732e3e2886897d5f26b4b0545dee = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , const tjs_uint32 *);
	((__functype)(TVPImportFuncPtr76b0732e3e2886897d5f26b4b0545dee))(dest, buf, len, pal);
}
inline void TVPBLExpand8BitTo8BitPal(tjs_uint8 * dest , const tjs_uint8 * buf , tjs_int len , const tjs_uint32 * pal)
{
	if(!TVPImportFuncPtr903ed11ef3863850e837bd4b3b1d61a1)
	{
		static char funcname[] = "void ::TVPBLExpand8BitTo8BitPal(tjs_uint8 *,const tjs_uint8 *,tjs_int,const tjs_uint32 *)";
		TVPImportFuncPtr903ed11ef3863850e837bd4b3b1d61a1 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint8 *, tjs_int , const tjs_uint32 *);
	((__functype)(TVPImportFuncPtr903ed11ef3863850e837bd4b3b1d61a1))(dest, buf, len, pal);
}
inline void TVPBLExpand8BitTo32BitPal(tjs_uint32 * dest , const tjs_uint8 * buf , tjs_int len , const tjs_uint32 * pal)
{
	if(!TVPImportFuncPtr2661124b39595ffafe2fb0bfb7bd2efc)
	{
		static char funcname[] = "void ::TVPBLExpand8BitTo32BitPal(tjs_uint32 *,const tjs_uint8 *,tjs_int,const tjs_uint32 *)";
		TVPImportFuncPtr2661124b39595ffafe2fb0bfb7bd2efc = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int , const tjs_uint32 *);
	((__functype)(TVPImportFuncPtr2661124b39595ffafe2fb0bfb7bd2efc))(dest, buf, len, pal);
}
inline void TVPExpand8BitTo32BitGray(tjs_uint32 * dest , const tjs_uint8 * buf , tjs_int len)
{
	if(!TVPImportFuncPtrd0b7170e54398c2f9d27dcc513c4cf46)
	{
		static char funcname[] = "void ::TVPExpand8BitTo32BitGray(tjs_uint32 *,const tjs_uint8 *,tjs_int)";
		TVPImportFuncPtrd0b7170e54398c2f9d27dcc513c4cf46 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int);
	((__functype)(TVPImportFuncPtrd0b7170e54398c2f9d27dcc513c4cf46))(dest, buf, len);
}
inline void TVPBLConvert15BitTo8Bit(tjs_uint8 * dest , const tjs_uint16 * buf , tjs_int len)
{
	if(!TVPImportFuncPtr31bdd2a1eed3785c1422fab5ea6b3ce7)
	{
		static char funcname[] = "void ::TVPBLConvert15BitTo8Bit(tjs_uint8 *,const tjs_uint16 *,tjs_int)";
		TVPImportFuncPtr31bdd2a1eed3785c1422fab5ea6b3ce7 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint16 *, tjs_int);
	((__functype)(TVPImportFuncPtr31bdd2a1eed3785c1422fab5ea6b3ce7))(dest, buf, len);
}
inline void TVPBLConvert15BitTo32Bit(tjs_uint32 * dest , const tjs_uint16 * buf , tjs_int len)
{
	if(!TVPImportFuncPtrdbc300d1dadc1a60cb0dcadfb92f1aee)
	{
		static char funcname[] = "void ::TVPBLConvert15BitTo32Bit(tjs_uint32 *,const tjs_uint16 *,tjs_int)";
		TVPImportFuncPtrdbc300d1dadc1a60cb0dcadfb92f1aee = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint16 *, tjs_int);
	((__functype)(TVPImportFuncPtrdbc300d1dadc1a60cb0dcadfb92f1aee))(dest, buf, len);
}
inline void TVPBLConvert24BitTo8Bit(tjs_uint8 * dest , const tjs_uint8 * buf , tjs_int len)
{
	if(!TVPImportFuncPtr1d4d9f8bdf55bd4c78abd90656af0364)
	{
		static char funcname[] = "void ::TVPBLConvert24BitTo8Bit(tjs_uint8 *,const tjs_uint8 *,tjs_int)";
		TVPImportFuncPtr1d4d9f8bdf55bd4c78abd90656af0364 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint8 *, tjs_int);
	((__functype)(TVPImportFuncPtr1d4d9f8bdf55bd4c78abd90656af0364))(dest, buf, len);
}
inline void TVPBLConvert24BitTo32Bit(tjs_uint32 * dest , const tjs_uint8 * buf , tjs_int len)
{
	if(!TVPImportFuncPtr5c7049e712e84b40ac05942421202de5)
	{
		static char funcname[] = "void ::TVPBLConvert24BitTo32Bit(tjs_uint32 *,const tjs_uint8 *,tjs_int)";
		TVPImportFuncPtr5c7049e712e84b40ac05942421202de5 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int);
	((__functype)(TVPImportFuncPtr5c7049e712e84b40ac05942421202de5))(dest, buf, len);
}
inline void TVPConvert24BitTo32Bit(tjs_uint32 * dest , const tjs_uint8 * buf , tjs_int len)
{
	if(!TVPImportFuncPtr5dca8992bb340d70ba65ddab65c28371)
	{
		static char funcname[] = "void ::TVPConvert24BitTo32Bit(tjs_uint32 *,const tjs_uint8 *,tjs_int)";
		TVPImportFuncPtr5dca8992bb340d70ba65ddab65c28371 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint8 *, tjs_int);
	((__functype)(TVPImportFuncPtr5dca8992bb340d70ba65ddab65c28371))(dest, buf, len);
}
inline void TVPBLConvert32BitTo8Bit(tjs_uint8 * dest , const tjs_uint32 * buf , tjs_int len)
{
	if(!TVPImportFuncPtr85f1f38f783ebfcf638f3c443bc9b204)
	{
		static char funcname[] = "void ::TVPBLConvert32BitTo8Bit(tjs_uint8 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr85f1f38f783ebfcf638f3c443bc9b204 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr85f1f38f783ebfcf638f3c443bc9b204))(dest, buf, len);
}
inline void TVPBLConvert32BitTo32Bit_NoneAlpha(tjs_uint32 * dest , const tjs_uint32 * buf , tjs_int len)
{
	if(!TVPImportFuncPtr7d61d143884bfa4b6c50dae11c2b659f)
	{
		static char funcname[] = "void ::TVPBLConvert32BitTo32Bit_NoneAlpha(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr7d61d143884bfa4b6c50dae11c2b659f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr7d61d143884bfa4b6c50dae11c2b659f))(dest, buf, len);
}
inline void TVPBLConvert32BitTo32Bit_MulAddAlpha(tjs_uint32 * dest , const tjs_uint32 * buf , tjs_int len)
{
	if(!TVPImportFuncPtr793a2ad7ad3411be3670576a8e6ddcf8)
	{
		static char funcname[] = "void ::TVPBLConvert32BitTo32Bit_MulAddAlpha(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr793a2ad7ad3411be3670576a8e6ddcf8 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr793a2ad7ad3411be3670576a8e6ddcf8))(dest, buf, len);
}
inline void TVPBLConvert32BitTo32Bit_AddAlpha(tjs_uint32 * dest , const tjs_uint32 * buf , tjs_int len)
{
	if(!TVPImportFuncPtr68d8eec33254f1684e53bbc0aa8b2466)
	{
		static char funcname[] = "void ::TVPBLConvert32BitTo32Bit_AddAlpha(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr68d8eec33254f1684e53bbc0aa8b2466 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr68d8eec33254f1684e53bbc0aa8b2466))(dest, buf, len);
}
inline void TVPDither32BitTo16Bit565(tjs_uint16 * dest , const tjs_uint32 * src , tjs_int len , tjs_int xofs , tjs_int yofs)
{
	if(!TVPImportFuncPtrb09652d2197b29f7d38aff0298c69f17)
	{
		static char funcname[] = "void ::TVPDither32BitTo16Bit565(tjs_uint16 *,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrb09652d2197b29f7d38aff0298c69f17 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint16 *, const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrb09652d2197b29f7d38aff0298c69f17))(dest, src, len, xofs, yofs);
}
inline void TVPDither32BitTo16Bit555(tjs_uint16 * dest , const tjs_uint32 * src , tjs_int len , tjs_int xofs , tjs_int yofs)
{
	if(!TVPImportFuncPtrbe7db03ddcf1886cb7233e58f19c8c77)
	{
		static char funcname[] = "void ::TVPDither32BitTo16Bit555(tjs_uint16 *,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrbe7db03ddcf1886cb7233e58f19c8c77 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint16 *, const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrbe7db03ddcf1886cb7233e58f19c8c77))(dest, src, len, xofs, yofs);
}
inline void TVPDither32BitTo8Bit(tjs_uint8 * dest , const tjs_uint32 * src , tjs_int len , tjs_int xofs , tjs_int yofs)
{
	if(!TVPImportFuncPtrb4c8fedc1ffbe30d9703cb2b8d3c0e7b)
	{
		static char funcname[] = "void ::TVPDither32BitTo8Bit(tjs_uint8 *,const tjs_uint32 *,tjs_int,tjs_int,tjs_int)";
		TVPImportFuncPtrb4c8fedc1ffbe30d9703cb2b8d3c0e7b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint32 *, tjs_int , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrb4c8fedc1ffbe30d9703cb2b8d3c0e7b))(dest, src, len, xofs, yofs);
}
inline void TVPTLG5ComposeColors3To4(tjs_uint8 * outp , const tjs_uint8 * upper , tjs_uint8 * const * buf , tjs_int width)
{
	if(!TVPImportFuncPtr77efef3b4ffc0cb577b76304e06e39f3)
	{
		static char funcname[] = "void ::TVPTLG5ComposeColors3To4(tjs_uint8 *,const tjs_uint8 *,tjs_uint8 * const *,tjs_int)";
		TVPImportFuncPtr77efef3b4ffc0cb577b76304e06e39f3 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint8 *, tjs_uint8 * const *, tjs_int);
	((__functype)(TVPImportFuncPtr77efef3b4ffc0cb577b76304e06e39f3))(outp, upper, buf, width);
}
inline void TVPTLG5ComposeColors4To4(tjs_uint8 * outp , const tjs_uint8 * upper , tjs_uint8 * const * buf , tjs_int width)
{
	if(!TVPImportFuncPtr0e55187bde599d6585eaabd2c4ac3f02)
	{
		static char funcname[] = "void ::TVPTLG5ComposeColors4To4(tjs_uint8 *,const tjs_uint8 *,tjs_uint8 * const *,tjs_int)";
		TVPImportFuncPtr0e55187bde599d6585eaabd2c4ac3f02 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint8 *, const tjs_uint8 *, tjs_uint8 * const *, tjs_int);
	((__functype)(TVPImportFuncPtr0e55187bde599d6585eaabd2c4ac3f02))(outp, upper, buf, width);
}
inline tjs_int TVPTLG5DecompressSlide(tjs_uint8 * out , const tjs_uint8 * in , tjs_int insize , tjs_uint8 * text , tjs_int initialr)
{
	if(!TVPImportFuncPtrf72e3fc3b97a9141b6f516f5e53bf9b8)
	{
		static char funcname[] = "tjs_int ::TVPTLG5DecompressSlide(tjs_uint8 *,const tjs_uint8 *,tjs_int,tjs_uint8 *,tjs_int)";
		TVPImportFuncPtrf72e3fc3b97a9141b6f516f5e53bf9b8 = TVPGetImportFuncPtr(funcname);
	}
	typedef tjs_int (__stdcall * __functype)(tjs_uint8 *, const tjs_uint8 *, tjs_int , tjs_uint8 *, tjs_int);
	return ((__functype)(TVPImportFuncPtrf72e3fc3b97a9141b6f516f5e53bf9b8))(out, in, insize, text, initialr);
}
inline void TVPTLG6DecodeGolombValuesForFirst(tjs_int8 * pixelbuf , tjs_int pixel_count , tjs_uint8 * bit_pool)
{
	if(!TVPImportFuncPtre7a1ac237f00bb6320d0e0ac7e6d51c6)
	{
		static char funcname[] = "void ::TVPTLG6DecodeGolombValuesForFirst(tjs_int8 *,tjs_int,tjs_uint8 *)";
		TVPImportFuncPtre7a1ac237f00bb6320d0e0ac7e6d51c6 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_int8 *, tjs_int , tjs_uint8 *);
	((__functype)(TVPImportFuncPtre7a1ac237f00bb6320d0e0ac7e6d51c6))(pixelbuf, pixel_count, bit_pool);
}
inline void TVPTLG6DecodeGolombValues(tjs_int8 * pixelbuf , tjs_int pixel_count , tjs_uint8 * bit_pool)
{
	if(!TVPImportFuncPtrd87682f6d691350878077bd101b7f0fc)
	{
		static char funcname[] = "void ::TVPTLG6DecodeGolombValues(tjs_int8 *,tjs_int,tjs_uint8 *)";
		TVPImportFuncPtrd87682f6d691350878077bd101b7f0fc = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_int8 *, tjs_int , tjs_uint8 *);
	((__functype)(TVPImportFuncPtrd87682f6d691350878077bd101b7f0fc))(pixelbuf, pixel_count, bit_pool);
}
inline void TVPTLG6DecodeLineGeneric(tjs_uint32 * prevline , tjs_uint32 * curline , tjs_int width , tjs_int start_block , tjs_int block_limit , tjs_uint8 * filtertypes , tjs_int skipblockbytes , tjs_uint32 * in , tjs_uint32 initialp , tjs_int oddskip , tjs_int dir)
{
	if(!TVPImportFuncPtrd7ae155eaabd8e65d6b4d356fe4af496)
	{
		static char funcname[] = "void ::TVPTLG6DecodeLineGeneric(tjs_uint32 *,tjs_uint32 *,tjs_int,tjs_int,tjs_int,tjs_uint8 *,tjs_int,tjs_uint32 *,tjs_uint32,tjs_int,tjs_int)";
		TVPImportFuncPtrd7ae155eaabd8e65d6b4d356fe4af496 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_uint32 *, tjs_int , tjs_int , tjs_int , tjs_uint8 *, tjs_int , tjs_uint32 *, tjs_uint32 , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrd7ae155eaabd8e65d6b4d356fe4af496))(prevline, curline, width, start_block, block_limit, filtertypes, skipblockbytes, in, initialp, oddskip, dir);
}
inline void TVPTLG6DecodeLine(tjs_uint32 * prevline , tjs_uint32 * curline , tjs_int width , tjs_int block_count , tjs_uint8 * filtertypes , tjs_int skipblockbytes , tjs_uint32 * in , tjs_uint32 initialp , tjs_int oddskip , tjs_int dir)
{
	if(!TVPImportFuncPtrbe3a1844ea6af533bd4e7b0a76c826a1)
	{
		static char funcname[] = "void ::TVPTLG6DecodeLine(tjs_uint32 *,tjs_uint32 *,tjs_int,tjs_int,tjs_uint8 *,tjs_int,tjs_uint32 *,tjs_uint32,tjs_int,tjs_int)";
		TVPImportFuncPtrbe3a1844ea6af533bd4e7b0a76c826a1 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, tjs_uint32 *, tjs_int , tjs_int , tjs_uint8 *, tjs_int , tjs_uint32 *, tjs_uint32 , tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrbe3a1844ea6af533bd4e7b0a76c826a1))(prevline, curline, width, block_count, filtertypes, skipblockbytes, in, initialp, oddskip, dir);
}
inline void TVPPsAlphaBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtraa531d2c3c87f456e48a14722faa1c1f)
	{
		static char funcname[] = "void ::TVPPsAlphaBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtraa531d2c3c87f456e48a14722faa1c1f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtraa531d2c3c87f456e48a14722faa1c1f))(dest, src, len);
}
inline void TVPPsAlphaBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr6889cd886e1c2e7faf541528636c16c3)
	{
		static char funcname[] = "void ::TVPPsAlphaBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr6889cd886e1c2e7faf541528636c16c3 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr6889cd886e1c2e7faf541528636c16c3))(dest, src, len, opa);
}
inline void TVPPsAlphaBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr5d9266e6a8a154fe4ba80b0995e109ab)
	{
		static char funcname[] = "void ::TVPPsAlphaBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr5d9266e6a8a154fe4ba80b0995e109ab = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr5d9266e6a8a154fe4ba80b0995e109ab))(dest, src, len);
}
inline void TVPPsAlphaBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtra7dc19b023737979ad1ae1ae01d560d2)
	{
		static char funcname[] = "void ::TVPPsAlphaBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtra7dc19b023737979ad1ae1ae01d560d2 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtra7dc19b023737979ad1ae1ae01d560d2))(dest, src, len, opa);
}
inline void TVPPsAddBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrd20444b7a6243d668a0d3956d95af510)
	{
		static char funcname[] = "void ::TVPPsAddBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrd20444b7a6243d668a0d3956d95af510 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrd20444b7a6243d668a0d3956d95af510))(dest, src, len);
}
inline void TVPPsAddBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr1458dec9eee36816c8002d4049840355)
	{
		static char funcname[] = "void ::TVPPsAddBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr1458dec9eee36816c8002d4049840355 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr1458dec9eee36816c8002d4049840355))(dest, src, len, opa);
}
inline void TVPPsAddBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr21137ff5351245b1611852301b7f5796)
	{
		static char funcname[] = "void ::TVPPsAddBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr21137ff5351245b1611852301b7f5796 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr21137ff5351245b1611852301b7f5796))(dest, src, len);
}
inline void TVPPsAddBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrc07fc4e45fc2dc44d839c5e012d0be60)
	{
		static char funcname[] = "void ::TVPPsAddBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrc07fc4e45fc2dc44d839c5e012d0be60 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrc07fc4e45fc2dc44d839c5e012d0be60))(dest, src, len, opa);
}
inline void TVPPsSubBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr6815b962a3122ae967284239932cc656)
	{
		static char funcname[] = "void ::TVPPsSubBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr6815b962a3122ae967284239932cc656 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr6815b962a3122ae967284239932cc656))(dest, src, len);
}
inline void TVPPsSubBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtre96cccbe1f16b0fb74673f2ec3343ff8)
	{
		static char funcname[] = "void ::TVPPsSubBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtre96cccbe1f16b0fb74673f2ec3343ff8 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtre96cccbe1f16b0fb74673f2ec3343ff8))(dest, src, len, opa);
}
inline void TVPPsSubBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtre8cd7494f919b18a992cb8c2722b2bf0)
	{
		static char funcname[] = "void ::TVPPsSubBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtre8cd7494f919b18a992cb8c2722b2bf0 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtre8cd7494f919b18a992cb8c2722b2bf0))(dest, src, len);
}
inline void TVPPsSubBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr990fdefcafc0de5e8e1f502c1b341e44)
	{
		static char funcname[] = "void ::TVPPsSubBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr990fdefcafc0de5e8e1f502c1b341e44 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr990fdefcafc0de5e8e1f502c1b341e44))(dest, src, len, opa);
}
inline void TVPPsMulBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrde5d83ba307e822825062377fb76c2ba)
	{
		static char funcname[] = "void ::TVPPsMulBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrde5d83ba307e822825062377fb76c2ba = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrde5d83ba307e822825062377fb76c2ba))(dest, src, len);
}
inline void TVPPsMulBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr5e28bcc0f5ad6a038eb5a6535b56386c)
	{
		static char funcname[] = "void ::TVPPsMulBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr5e28bcc0f5ad6a038eb5a6535b56386c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr5e28bcc0f5ad6a038eb5a6535b56386c))(dest, src, len, opa);
}
inline void TVPPsMulBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtre33419e8ede4bb501ab1787cf17c7ca5)
	{
		static char funcname[] = "void ::TVPPsMulBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtre33419e8ede4bb501ab1787cf17c7ca5 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtre33419e8ede4bb501ab1787cf17c7ca5))(dest, src, len);
}
inline void TVPPsMulBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr1cd7cb9580c0cf723dea402b85a720b1)
	{
		static char funcname[] = "void ::TVPPsMulBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr1cd7cb9580c0cf723dea402b85a720b1 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr1cd7cb9580c0cf723dea402b85a720b1))(dest, src, len, opa);
}
inline void TVPPsScreenBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrd18ca17fad389ff60ce3caa769083798)
	{
		static char funcname[] = "void ::TVPPsScreenBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrd18ca17fad389ff60ce3caa769083798 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrd18ca17fad389ff60ce3caa769083798))(dest, src, len);
}
inline void TVPPsScreenBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr0a959a5ff02530a8eb122e7e1f8ceed3)
	{
		static char funcname[] = "void ::TVPPsScreenBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr0a959a5ff02530a8eb122e7e1f8ceed3 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr0a959a5ff02530a8eb122e7e1f8ceed3))(dest, src, len, opa);
}
inline void TVPPsScreenBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtra4774ea559e64b4667b3845f8540d207)
	{
		static char funcname[] = "void ::TVPPsScreenBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtra4774ea559e64b4667b3845f8540d207 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtra4774ea559e64b4667b3845f8540d207))(dest, src, len);
}
inline void TVPPsScreenBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr52eae3e8106494bfa604c15492ecb9f4)
	{
		static char funcname[] = "void ::TVPPsScreenBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr52eae3e8106494bfa604c15492ecb9f4 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr52eae3e8106494bfa604c15492ecb9f4))(dest, src, len, opa);
}
inline void TVPPsOverlayBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr882f458df5e05bb9ab2222e79f6c81cf)
	{
		static char funcname[] = "void ::TVPPsOverlayBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr882f458df5e05bb9ab2222e79f6c81cf = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr882f458df5e05bb9ab2222e79f6c81cf))(dest, src, len);
}
inline void TVPPsOverlayBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr6069a18bf7d3f394c230cdcf2f574ef4)
	{
		static char funcname[] = "void ::TVPPsOverlayBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr6069a18bf7d3f394c230cdcf2f574ef4 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr6069a18bf7d3f394c230cdcf2f574ef4))(dest, src, len, opa);
}
inline void TVPPsOverlayBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr75b60565caf44027cc52b2b5cf6b0ea3)
	{
		static char funcname[] = "void ::TVPPsOverlayBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr75b60565caf44027cc52b2b5cf6b0ea3 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr75b60565caf44027cc52b2b5cf6b0ea3))(dest, src, len);
}
inline void TVPPsOverlayBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr9d735149c3ad586363895f76645abf2e)
	{
		static char funcname[] = "void ::TVPPsOverlayBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr9d735149c3ad586363895f76645abf2e = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr9d735149c3ad586363895f76645abf2e))(dest, src, len, opa);
}
inline void TVPPsHardLightBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrea5168fae254acdd8c8db6f1f3d2da03)
	{
		static char funcname[] = "void ::TVPPsHardLightBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrea5168fae254acdd8c8db6f1f3d2da03 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrea5168fae254acdd8c8db6f1f3d2da03))(dest, src, len);
}
inline void TVPPsHardLightBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrf5a42bd5239e1a0be29f92eb838d2c8c)
	{
		static char funcname[] = "void ::TVPPsHardLightBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrf5a42bd5239e1a0be29f92eb838d2c8c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrf5a42bd5239e1a0be29f92eb838d2c8c))(dest, src, len, opa);
}
inline void TVPPsHardLightBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr7cc8cd9f415b183b42c546635aeade7f)
	{
		static char funcname[] = "void ::TVPPsHardLightBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr7cc8cd9f415b183b42c546635aeade7f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr7cc8cd9f415b183b42c546635aeade7f))(dest, src, len);
}
inline void TVPPsHardLightBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrad2fefa53e05528f9c1fe29d27db0f37)
	{
		static char funcname[] = "void ::TVPPsHardLightBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrad2fefa53e05528f9c1fe29d27db0f37 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrad2fefa53e05528f9c1fe29d27db0f37))(dest, src, len, opa);
}
inline void TVPPsSoftLightBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrf3e06fed4c82a9bd1b53252abaf50847)
	{
		static char funcname[] = "void ::TVPPsSoftLightBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrf3e06fed4c82a9bd1b53252abaf50847 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrf3e06fed4c82a9bd1b53252abaf50847))(dest, src, len);
}
inline void TVPPsSoftLightBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr960db7ea36202bf7ec3bf6b767cc045e)
	{
		static char funcname[] = "void ::TVPPsSoftLightBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr960db7ea36202bf7ec3bf6b767cc045e = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr960db7ea36202bf7ec3bf6b767cc045e))(dest, src, len, opa);
}
inline void TVPPsSoftLightBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr7bf5d357eb52dd206a269b54c8136e0e)
	{
		static char funcname[] = "void ::TVPPsSoftLightBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr7bf5d357eb52dd206a269b54c8136e0e = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr7bf5d357eb52dd206a269b54c8136e0e))(dest, src, len);
}
inline void TVPPsSoftLightBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrba1c9b771c5cdb725128de684af3c9ca)
	{
		static char funcname[] = "void ::TVPPsSoftLightBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrba1c9b771c5cdb725128de684af3c9ca = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrba1c9b771c5cdb725128de684af3c9ca))(dest, src, len, opa);
}
inline void TVPPsColorDodgeBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr69cc6311196adc134fd153c4c5346bc5)
	{
		static char funcname[] = "void ::TVPPsColorDodgeBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr69cc6311196adc134fd153c4c5346bc5 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr69cc6311196adc134fd153c4c5346bc5))(dest, src, len);
}
inline void TVPPsColorDodgeBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr8ed68f8e79efe1c767f92e7d92eb8b54)
	{
		static char funcname[] = "void ::TVPPsColorDodgeBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr8ed68f8e79efe1c767f92e7d92eb8b54 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr8ed68f8e79efe1c767f92e7d92eb8b54))(dest, src, len, opa);
}
inline void TVPPsColorDodgeBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr60da1e9ec15b251ff18ddcdf8a3e93e0)
	{
		static char funcname[] = "void ::TVPPsColorDodgeBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr60da1e9ec15b251ff18ddcdf8a3e93e0 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr60da1e9ec15b251ff18ddcdf8a3e93e0))(dest, src, len);
}
inline void TVPPsColorDodgeBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtref47304bad87a036e38f0319b48c1f6e)
	{
		static char funcname[] = "void ::TVPPsColorDodgeBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtref47304bad87a036e38f0319b48c1f6e = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtref47304bad87a036e38f0319b48c1f6e))(dest, src, len, opa);
}
inline void TVPPsColorDodge5Blend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr182d19020e4e2d5cd1462d7c8ef24d1f)
	{
		static char funcname[] = "void ::TVPPsColorDodge5Blend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr182d19020e4e2d5cd1462d7c8ef24d1f = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr182d19020e4e2d5cd1462d7c8ef24d1f))(dest, src, len);
}
inline void TVPPsColorDodge5Blend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr9e1fa429a92a5c99d397a06c20fd6705)
	{
		static char funcname[] = "void ::TVPPsColorDodge5Blend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr9e1fa429a92a5c99d397a06c20fd6705 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr9e1fa429a92a5c99d397a06c20fd6705))(dest, src, len, opa);
}
inline void TVPPsColorDodge5Blend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr74ac7c291299eb928aa4c2899df5567e)
	{
		static char funcname[] = "void ::TVPPsColorDodge5Blend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr74ac7c291299eb928aa4c2899df5567e = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr74ac7c291299eb928aa4c2899df5567e))(dest, src, len);
}
inline void TVPPsColorDodge5Blend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrfb645d9ec0ef3fd2aba2b762ef6b9a15)
	{
		static char funcname[] = "void ::TVPPsColorDodge5Blend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrfb645d9ec0ef3fd2aba2b762ef6b9a15 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrfb645d9ec0ef3fd2aba2b762ef6b9a15))(dest, src, len, opa);
}
inline void TVPPsColorBurnBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrf988626275257574050ac789f9060a3b)
	{
		static char funcname[] = "void ::TVPPsColorBurnBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrf988626275257574050ac789f9060a3b = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrf988626275257574050ac789f9060a3b))(dest, src, len);
}
inline void TVPPsColorBurnBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr1831064ed23493cef407648763ba4d69)
	{
		static char funcname[] = "void ::TVPPsColorBurnBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr1831064ed23493cef407648763ba4d69 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr1831064ed23493cef407648763ba4d69))(dest, src, len, opa);
}
inline void TVPPsColorBurnBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr305390c94750daa7124db3ff6e77931c)
	{
		static char funcname[] = "void ::TVPPsColorBurnBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr305390c94750daa7124db3ff6e77931c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr305390c94750daa7124db3ff6e77931c))(dest, src, len);
}
inline void TVPPsColorBurnBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr4fb384a391bfcf6a3a2932661d3051aa)
	{
		static char funcname[] = "void ::TVPPsColorBurnBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr4fb384a391bfcf6a3a2932661d3051aa = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr4fb384a391bfcf6a3a2932661d3051aa))(dest, src, len, opa);
}
inline void TVPPsLightenBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr305537c4820e23cf217a15efb56dba1c)
	{
		static char funcname[] = "void ::TVPPsLightenBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr305537c4820e23cf217a15efb56dba1c = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr305537c4820e23cf217a15efb56dba1c))(dest, src, len);
}
inline void TVPPsLightenBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtraacf83677ca7df75117f7bafa7a53791)
	{
		static char funcname[] = "void ::TVPPsLightenBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtraacf83677ca7df75117f7bafa7a53791 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtraacf83677ca7df75117f7bafa7a53791))(dest, src, len, opa);
}
inline void TVPPsLightenBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrd14b922fefc6c07aa536b94762579fe5)
	{
		static char funcname[] = "void ::TVPPsLightenBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrd14b922fefc6c07aa536b94762579fe5 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrd14b922fefc6c07aa536b94762579fe5))(dest, src, len);
}
inline void TVPPsLightenBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr00fd650a79c603bdeb2f8e36f667a782)
	{
		static char funcname[] = "void ::TVPPsLightenBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr00fd650a79c603bdeb2f8e36f667a782 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr00fd650a79c603bdeb2f8e36f667a782))(dest, src, len, opa);
}
inline void TVPPsDarkenBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtra36ee133c07c30185b0bbc6375954e88)
	{
		static char funcname[] = "void ::TVPPsDarkenBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtra36ee133c07c30185b0bbc6375954e88 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtra36ee133c07c30185b0bbc6375954e88))(dest, src, len);
}
inline void TVPPsDarkenBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrdc657ecacf8e578870314427216864d9)
	{
		static char funcname[] = "void ::TVPPsDarkenBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrdc657ecacf8e578870314427216864d9 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrdc657ecacf8e578870314427216864d9))(dest, src, len, opa);
}
inline void TVPPsDarkenBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtre79d02b58a8bfdee439bc0694d7edd6d)
	{
		static char funcname[] = "void ::TVPPsDarkenBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtre79d02b58a8bfdee439bc0694d7edd6d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtre79d02b58a8bfdee439bc0694d7edd6d))(dest, src, len);
}
inline void TVPPsDarkenBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr6b7537b66b71d27384bea45bc2bf24b4)
	{
		static char funcname[] = "void ::TVPPsDarkenBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr6b7537b66b71d27384bea45bc2bf24b4 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr6b7537b66b71d27384bea45bc2bf24b4))(dest, src, len, opa);
}
inline void TVPPsDiffBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtrb3456dbad652b52f5bce1889b6f4d0ef)
	{
		static char funcname[] = "void ::TVPPsDiffBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtrb3456dbad652b52f5bce1889b6f4d0ef = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtrb3456dbad652b52f5bce1889b6f4d0ef))(dest, src, len);
}
inline void TVPPsDiffBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr9a50803a03e1ccb60120dff8b92ecdcd)
	{
		static char funcname[] = "void ::TVPPsDiffBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr9a50803a03e1ccb60120dff8b92ecdcd = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr9a50803a03e1ccb60120dff8b92ecdcd))(dest, src, len, opa);
}
inline void TVPPsDiffBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr0f6b3940dc72e3e56cd15216b53b9126)
	{
		static char funcname[] = "void ::TVPPsDiffBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr0f6b3940dc72e3e56cd15216b53b9126 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr0f6b3940dc72e3e56cd15216b53b9126))(dest, src, len);
}
inline void TVPPsDiffBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr23b647f1c825e214a7465de3ebe9968d)
	{
		static char funcname[] = "void ::TVPPsDiffBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr23b647f1c825e214a7465de3ebe9968d = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr23b647f1c825e214a7465de3ebe9968d))(dest, src, len, opa);
}
inline void TVPPsDiff5Blend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr8ec96bc7b777180f23e1a2e43bf9a413)
	{
		static char funcname[] = "void ::TVPPsDiff5Blend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr8ec96bc7b777180f23e1a2e43bf9a413 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr8ec96bc7b777180f23e1a2e43bf9a413))(dest, src, len);
}
inline void TVPPsDiff5Blend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtrcffd45014652659638d59abe11daf3be)
	{
		static char funcname[] = "void ::TVPPsDiff5Blend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtrcffd45014652659638d59abe11daf3be = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtrcffd45014652659638d59abe11daf3be))(dest, src, len, opa);
}
inline void TVPPsDiff5Blend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtra784285a35b1bc76bb367305b5099e35)
	{
		static char funcname[] = "void ::TVPPsDiff5Blend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtra784285a35b1bc76bb367305b5099e35 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtra784285a35b1bc76bb367305b5099e35))(dest, src, len);
}
inline void TVPPsDiff5Blend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr03773751329896facf2003ab79bbc475)
	{
		static char funcname[] = "void ::TVPPsDiff5Blend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr03773751329896facf2003ab79bbc475 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr03773751329896facf2003ab79bbc475))(dest, src, len, opa);
}
inline void TVPPsExclusionBlend(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr923884216edf134d07d8e70f8f57e827)
	{
		static char funcname[] = "void ::TVPPsExclusionBlend(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr923884216edf134d07d8e70f8f57e827 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr923884216edf134d07d8e70f8f57e827))(dest, src, len);
}
inline void TVPPsExclusionBlend_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtre48798dc69498f80b6633bb405eda6eb)
	{
		static char funcname[] = "void ::TVPPsExclusionBlend_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtre48798dc69498f80b6633bb405eda6eb = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtre48798dc69498f80b6633bb405eda6eb))(dest, src, len, opa);
}
inline void TVPPsExclusionBlend_HDA(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len)
{
	if(!TVPImportFuncPtr998a5e1aa5cd85689795348fc540a655)
	{
		static char funcname[] = "void ::TVPPsExclusionBlend_HDA(tjs_uint32 *,const tjs_uint32 *,tjs_int)";
		TVPImportFuncPtr998a5e1aa5cd85689795348fc540a655 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int);
	((__functype)(TVPImportFuncPtr998a5e1aa5cd85689795348fc540a655))(dest, src, len);
}
inline void TVPPsExclusionBlend_HDA_o(tjs_uint32 * dest , const tjs_uint32 * src , tjs_int len , tjs_int opa)
{
	if(!TVPImportFuncPtr5f6d263c0d48d03f6eb0dc44c9dd0be2)
	{
		static char funcname[] = "void ::TVPPsExclusionBlend_HDA_o(tjs_uint32 *,const tjs_uint32 *,tjs_int,tjs_int)";
		TVPImportFuncPtr5f6d263c0d48d03f6eb0dc44c9dd0be2 = TVPGetImportFuncPtr(funcname);
	}
	typedef void (__stdcall * __functype)(tjs_uint32 *, const tjs_uint32 *, tjs_int , tjs_int);
	((__functype)(TVPImportFuncPtr5f6d263c0d48d03f6eb0dc44c9dd0be2))(dest, src, len, opa);
}

#ifdef __BORLANDC__
#pragma warn .8027
#endif

//---------------------------------------------------------------------------
// Stub library setup
//---------------------------------------------------------------------------
extern bool TVPInitImportStub(iTVPFunctionExporter * exporter);
extern void TVPUninitImportStub();
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Global reference count
//---------------------------------------------------------------------------
extern tjs_int TVPPluginGlobalRefCount;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// exception protected function stub
//---------------------------------------------------------------------------

extern tjs_uint Try_iTJSDispatch2_AddRef(iTJSDispatch2 * _this);
extern tjs_uint Try_iTJSDispatch2_Release(iTJSDispatch2 * _this);
extern tjs_error Try_iTJSDispatch2_FuncCall(iTJSDispatch2 * _this, tjs_uint32 flag, const tjs_char * membername, tjs_uint32 *hint, tTJSVariant *result, tjs_int numparams, tTJSVariant **param, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_FuncCallByNum(iTJSDispatch2 * _this, tjs_uint32 flag, tjs_int num, tTJSVariant *result, tjs_int numparams, tTJSVariant **param, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_PropGet(iTJSDispatch2 * _this, tjs_uint32 flag, const tjs_char * membername, tjs_uint32 *hint, tTJSVariant *result, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_PropGetByNum(iTJSDispatch2 * _this, tjs_uint32 flag, tjs_int num, tTJSVariant *result, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_PropSet(iTJSDispatch2 * _this, tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint, const tTJSVariant *param, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_PropSetByNum(iTJSDispatch2 * _this, tjs_uint32 flag, tjs_int num, const tTJSVariant *param, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_GetCount(iTJSDispatch2 * _this, tjs_int *result, const tjs_char *membername, tjs_uint32 *hint, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_GetCountByNum(iTJSDispatch2 * _this, tjs_int *result, tjs_int num, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_PropSetByVS(iTJSDispatch2 * _this, tjs_uint32 flag, tTJSVariantString *membername, const tTJSVariant *param, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_EnumMembers(iTJSDispatch2 * _this, tjs_uint32 flag, tTJSVariantClosure *callback, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_DeleteMember(iTJSDispatch2 * _this, tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_DeleteMemberByNum(iTJSDispatch2 * _this, tjs_uint32 flag, tjs_int num, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_Invalidate(iTJSDispatch2 * _this, tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_InvalidateByNum(iTJSDispatch2 * _this, tjs_uint32 flag, tjs_int num, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_IsValid(iTJSDispatch2 * _this, tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_IsValidByNum(iTJSDispatch2 * _this, tjs_uint32 flag, tjs_int num, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_CreateNew(iTJSDispatch2 * _this, tjs_uint32 flag, const tjs_char * membername, tjs_uint32 *hint, iTJSDispatch2 **result, tjs_int numparams, tTJSVariant **param, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_CreateNewByNum(iTJSDispatch2 * _this, tjs_uint32 flag, tjs_int num, iTJSDispatch2 **result, tjs_int numparams, tTJSVariant **param, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_Reserved1(iTJSDispatch2 * _this);
extern tjs_error Try_iTJSDispatch2_IsInstanceOf(iTJSDispatch2 * _this, tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint, const tjs_char *classname, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_IsInstanceOfByNum(iTJSDispatch2 * _this, tjs_uint32 flag, tjs_int num, const tjs_char *classname, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_Operation(iTJSDispatch2 * _this, tjs_uint32 flag, const tjs_char *membername, tjs_uint32 *hint, tTJSVariant *result, const tTJSVariant *param, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_OperationByNum(iTJSDispatch2 * _this, tjs_uint32 flag, tjs_int num, tTJSVariant *result, const tTJSVariant *param, iTJSDispatch2 *objthis);
extern tjs_error Try_iTJSDispatch2_NativeInstanceSupport(iTJSDispatch2 * _this, tjs_uint32 flag, tjs_int32 classid, iTJSNativeInstance **pointer);
extern tjs_error Try_iTJSDispatch2_ClassInstanceInfo(iTJSDispatch2 * _this, tjs_uint32 flag, tjs_uint num, tTJSVariant *value);
extern tjs_error Try_iTJSDispatch2_Reserved2(iTJSDispatch2 * _this);
extern tjs_error Try_iTJSDispatch2_Reserved3(iTJSDispatch2 * _this);
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// other compatibility function stub
//---------------------------------------------------------------------------
extern ttstr TVPGetLocallyAccessibleName(const ttstr &name);


#endif
