@replaceMethod(DodgeEvents)
  protected func OnEnter(stateContext: ref<StateContext>, scriptInterface: ref<StateGameScriptInterface>) -> Void {
    let crossHairNPC: NPCNextToTheCrosshair;
    let fierceDashPerkIsBought: Bool;
    let inputSchemeNum: Uint32;
    let inputSchemesBB: ref<IBlackboard>;
    let isAirDash: Bool;
    let isPlayerInElevator: Bool;
    let isPlayerInTheAir: Bool;
    let maxDistToTarget: Float;
    let npcGObj: wref<GameObject>;
    let npcdata: ref<IBlackboard>;
    let puppet: ref<ScriptedPuppet>;
    let shouldLeapToTarget: Bool;
    let targetObjectMax: ref<GameObject>;
    let targetObjectMin: ref<GameObject>;
    let ownerID: StatsObjectID = Cast<StatsObjectID>(scriptInterface.executionOwnerEntityID);
    let questSystem: ref<QuestsSystem> = scriptInterface.GetQuestsSystem();
    let dodgeHeading: Float = stateContext.GetConditionFloat(n"DodgeDirection");
    let playerDevelopmentData: ref<PlayerDevelopmentData> = PlayerDevelopmentSystem.GetData(scriptInterface.executionOwner);
    let isExhausted: Bool = false;
    let locomotionState: CName = stateContext.GetStateMachineCurrentState(n"Locomotion");
    this.m_currentNumberOfJumps = stateContext.GetIntParameter(n"currentNumberOfJumps", true);
    super.OnEnter(stateContext, scriptInterface);
    if Equals(locomotionState, n"chargeJump") {
      stateContext.SetPermanentBoolParameter(n"isGravityAffectedByChargedJump", true, true);
    };
    inputSchemesBB = GameInstance.GetBlackboardSystem(scriptInterface.GetGame()).Get(GetAllBlackboardDefs().InputSchemes);
    if IsDefined(inputSchemesBB) {
      inputSchemeNum = inputSchemesBB.GetUint(GetAllBlackboardDefs().InputSchemes.Scheme);
    };
    this.m_crouching = (Equals(locomotionState, n"crouch") || Equals(locomotionState, n"crouchSprint")) && (inputSchemeNum != 0u || !scriptInterface.IsActionJustTapped(n"ToggleCrouch"));
    if this.m_crouching {
      puppet = scriptInterface.owner as ScriptedPuppet;
      if IsDefined(puppet) {
        puppet.GetPuppetPS().SetCrouch(true);
      };
      scriptInterface.GetAudioSystem().NotifyGameTone(n"EnterCrouch");
      scriptInterface.GetSpatialQueriesSystem().GetPlayerObstacleSystem().OnEnterCrouch(scriptInterface.owner);
      this.SetBlackboardIntVariable(scriptInterface, GetAllBlackboardDefs().PlayerStateMachine.Locomotion, 13);
      scriptInterface.SetAnimationParameterFloat(n"crouch", 1.00);
    } else {
      if Equals(locomotionState, n"crouch") || Equals(locomotionState, n"crouchSprint") {
        stateContext.SetConditionBoolParameter(n"CrouchToggled", false, true);
      };
      this.SetBlackboardIntVariable(scriptInterface, GetAllBlackboardDefs().PlayerStateMachine.Locomotion, 7);
    };
    npcdata = GameInstance.GetBlackboardSystem(scriptInterface.GetGame()).Get(GetAllBlackboardDefs().UI_NPCNextToTheCrosshair);
    crossHairNPC = FromVariant<NPCNextToTheCrosshair>(npcdata.GetVariant(GetAllBlackboardDefs().UI_NPCNextToTheCrosshair.NameplateData));
    npcGObj = crossHairNPC.npc as ScriptedPuppet;
    shouldLeapToTarget = npcGObj.IsHostile();
    isPlayerInTheAir = !this.IsTouchingGround(scriptInterface);
    isPlayerInElevator = GameInstance.GetBlackboardSystem(scriptInterface.GetGame()).GetLocalInstanced(scriptInterface.ownerEntityID, GetAllBlackboardDefs().PlayerStateMachine).GetBool(GetAllBlackboardDefs().PlayerStateMachine.IsPlayerInsideElevator);
    if !isPlayerInElevator && playerDevelopmentData.IsNewPerkBought(gamedataNewPerkType.Reflexes_Central_Milestone_2) >= 0 {
      if isPlayerInTheAir && playerDevelopmentData.IsNewPerkBought(gamedataNewPerkType.Reflexes_Central_Milestone_3) >= 0 {
      this.Dodge(stateContext, scriptInterface, isExhausted);
      if !stateContext.GetConditionBool(n"CrouchToggled") {
        scriptInterface.PushAnimationEvent(n"Dodge");
      };
      if StatusEffectHelper.HasStatusEffectWithTagConst(scriptInterface.executionOwner as PlayerPuppet, n"SecondChancePerkTimeDilation") {
        this.PlaySound(n"lcm_dash", scriptInterface);
      };
      this.PlayRumbleBasedOnDodgeDirection(stateContext, scriptInterface);
      };
      stateContext.SetPermanentBoolParameter(n"TemporarySpeedLimitIgnore", true, true);
      fierceDashPerkIsBought = playerDevelopmentData.IsNewPerkBoughtAnyLevel(gamedataNewPerkType.Reflexes_Central_Perk_2_1);
      maxDistToTarget = this.GetStaticFloatParameterDefault("maxDistToTarget", 5.00);
      maxDistToTarget = fierceDashPerkIsBought ? maxDistToTarget * 2.00 : maxDistToTarget;
      targetObjectMax = DefaultTransition.GetTargetObject(scriptInterface, maxDistToTarget, true);
      targetObjectMin = DefaultTransition.GetTargetObject(scriptInterface, this.GetStaticFloatParameterDefault("minDistToTarget", 1.00), true);
      if shouldLeapToTarget && AbsF(dodgeHeading) < 60.00 && (IsDefined(targetObjectMin) || IsDefined(targetObjectMax)) {
        this.LeapToTarget(stateContext, scriptInterface, npcGObj);
        this.PlayRumbleBasedOnDodgeDirection(stateContext, scriptInterface);
      } else {
        if isPlayerInTheAir {
          isAirDash = this.TreatDashAsAirDash(scriptInterface);
        };
        this.Dash(stateContext, scriptInterface, isExhausted, isAirDash);
        this.PlayRumbleBasedOnDodgeDirection(stateContext, scriptInterface, isExhausted);
      };
      if !isExhausted {
        this.PlaySound(n"lcm_dash", scriptInterface);
        GameObjectEffectHelper.StartEffectEvent(scriptInterface.executionOwner, n"dash");
        StatusEffectHelper.ApplyStatusEffect(scriptInterface.owner, t"BaseStatusEffect.PlayerJustDashed", scriptInterface.owner.GetEntityID());
      };
      scriptInterface.PushAnimationEvent(n"Dodge");
    } else {
      this.Dodge(stateContext, scriptInterface, isExhausted);
      if !stateContext.GetConditionBool(n"CrouchToggled") {
        scriptInterface.PushAnimationEvent(n"Dodge");
      };
      if StatusEffectHelper.HasStatusEffectWithTagConst(scriptInterface.executionOwner as PlayerPuppet, n"SecondChancePerkTimeDilation") {
        this.PlaySound(n"lcm_dash", scriptInterface);
      };
      this.PlayRumbleBasedOnDodgeDirection(stateContext, scriptInterface);
    };
    questSystem.SetFact(n"gmpl_player_dodged", questSystem.GetFact(n"gmpl_player_dodged") + 1);
    this.m_blockStatFlag = RPGManager.CreateStatModifier(gamedataStatType.IsDodging, gameStatModifierType.Additive, 1.00);
    StatusEffectHelper.ApplyStatusEffect(scriptInterface.executionOwner, t"BaseStatusEffect.DodgeBuff");
    StatusEffectHelper.ApplyStatusEffect(scriptInterface.executionOwner, t"BaseStatusEffect.JustDodgedBuffer");
    StatusEffectHelper.ApplyStatusEffect(scriptInterface.executionOwner, t"BaseStatusEffect.PlayerJustDodgedLocomotionBuffer");
    if !isExhausted && (dodgeHeading < -45.00 || dodgeHeading > 45.00) {
      StatusEffectHelper.ApplyStatusEffect(scriptInterface.executionOwner, t"BaseStatusEffect.DodgeInvulnerability");
    };
    scriptInterface.GetStatsSystem().AddModifier(ownerID, this.m_blockStatFlag);
    this.SetDetailedState(scriptInterface, gamePSMDetailedLocomotionStates.Dodge);
    this.LogSpecialMovementToTelemetry(scriptInterface, telemetryMovementType.Dodge);
  }

@replaceMethod(LocomotionTransition)
  protected final const func WantsToDodge(const stateContext: ref<StateContext>, const scriptInterface: ref<StateGameScriptInterface>) -> Bool {
    let disableAirDash: StateResultBool;
    let isAirDashPerkBought: Bool;
    let isInCooldown: Bool;
    let isStaminaPositive: Bool;
    if !scriptInterface.HasStatFlag(gamedataStatType.HasDodge) {
      return false;
    };
    if StatusEffectSystem.ObjectHasStatusEffect(scriptInterface.executionOwner, t"BaseStatusEffect.HealFood3") {
      return false;
    };
    isInCooldown = StatusEffectSystem.ObjectHasStatusEffect(scriptInterface.executionOwner, t"BaseStatusEffect.DodgeCooldown") || StatusEffectSystem.ObjectHasStatusEffect(scriptInterface.executionOwner, t"BaseStatusEffect.DodgeAirCooldown");
    if isInCooldown {
      return false;
    };
    disableAirDash = stateContext.GetPermanentBoolParameter(n"disableAirDash");
    isAirDashPerkBought = PlayerDevelopmentSystem.GetInstance(scriptInterface.executionOwner).IsNewPerkBought(scriptInterface.executionOwner, gamedataNewPerkType.Reflexes_Central_Milestone_3) >= 0;
    isStaminaPositive = GameInstance.GetStatPoolsSystem(scriptInterface.executionOwner.GetGame()).GetStatPoolValue(Cast<StatsObjectID>(scriptInterface.executionOwner.GetEntityID()), gamedataStatPoolType.Stamina, true) > 0.00;
    if !this.IsTouchingGround(scriptInterface) && (!isAirDashPerkBought) {
      return false;
    };
    if this.IsCurrentFallSpeedTooFastToEnter(stateContext, scriptInterface) {
      return false;
    };
    if scriptInterface.IsActionJustTapped(n"Dodge") {
      if scriptInterface.IsMoveInputConsiderable() {
        stateContext.SetConditionFloatParameter(n"DodgeDirection", scriptInterface.GetInputHeading(), true);
        scriptInterface.localBlackboard.SetFloat(GetAllBlackboardDefs().PlayerStateMachine.DodgeTimeStamp, EngineTime.ToFloat(GameInstance.GetSimTime(scriptInterface.GetGame())));
        return true;
      };
      if this.GetStaticBoolParameterDefault("dodgeWithNoMovementInput", false) {
        stateContext.SetConditionFloatParameter(n"DodgeDirection", -180.00, true);
        scriptInterface.localBlackboard.SetFloat(GetAllBlackboardDefs().PlayerStateMachine.DodgeTimeStamp, EngineTime.ToFloat(GameInstance.GetSimTime(scriptInterface.GetGame())));
        return true;
      };
    };
    if this.WantsToDodgeFromMovementInput(stateContext, scriptInterface) && GameplaySettingsSystem.GetMovementDodgeEnabled(scriptInterface.executionOwner) {
      return true;
    };
    return false;
  }
