--
--	Grail NPCs
--	Written by scott@mithrandir.com
--
--	Version History
--		Stopped keeping history as it was not maintained.
--
--	Each NPC value is a table that can contain:
--		[1]	code information (see below) like map location
--		[2] optional friendly notes
--		[3] optional faction association
--
--	NPC Codes
--		A:npcId			npcId that is what Blizzard returns for this alias NPC
--		Created			indicates item is created by player
--		D:<npc list>	comma separated list of NPC IDs that drop this item
--		H<holidayCode>	holidayCode is a single character indicating the holiday the NPC is available
--		K:<quest list>	comma separated list of quest IDs for which this is killed
--		Mailbox			indicates item in a mailbox (any map area)
--		Mailbox<mapId>	indicates item in a mailbox in the specified map area
--		N:npcId			npcId whose name is to be used for this NPC
--		Near			indicates the NPC is nearby (any map area)
--		Near<mapId>		indicates the NPC is nearby in the specified map area
--		Preowned		indicates item is already owned
--		Q:<quest list>	comma separated list of quest IDs to which this is associated
--		Self			special NPC indicator for Self (the player)
--		X				indicates NPC is in heroic only
--		Z<mapId>		indicates NPC found in the map area
--		anything else should be the format (without spaces):
--			mapId [mapLevel] : xx.xx , yy.yy > realMapId
--		the "[mapLevel]" is only required for maps with levels, most do not need it
--		the "> realMapId" indicates the coordinates are in a map that contains the realMap...this allows an outer map to show a point for maps that are contained within
--
--	Known issues
--
--
--	Alliance Garrison small plot top step locations:
--		18:	971:46.99,59.27
--		19:	971:50.03,57.75
--		20:	971:51.19,63.58
--	Alliance Garrison medium plot basic entrance locations:
--		22:	971:35.53,49.36
--		25: 971:51.21,47.04
--	Alliance Garrison large plot basic entrance locations:
--		23:	971:45.25,42.49
--		24:	971:40.09,56.58
--
--	Horde Garrison small plot top step locations:
--		18:	976:52.44,37.06
--		19:	976:48.38,33.59
--		20: 976:52.59,40.81
--	Horde Garrison medium plot basic entrance locations:
--		22: 976:51.43,57.39
--		25:	976:57.75,28.14
--	Horde Garrison large plot basic entrance locations:
--		23: 976:58.88,49.06
--		24: 976:60.36,36.51
--
--	Dungeon entrances:
--		Ulduar					495:41.57,17.83
--		Thunder					928:63.73,32.23
--		SM Graveyard 762[1]		20:84.87,30.61
--		SM Cathedral 762[4]		20:85.35,30.62
--		SM Library 762[2]		20:85.29,32.14
--		SM Armory 762[3]		20:85.62,31.59
--		Mechanar				479:70.59,69.73
--		Tempest Keep			479:73.73,63.74
--		Botanica				479:71.72,55.02
--		Arcatraz				479:74.37,57.74
--		Auchanai Crypts			478:34.34,65.61
--		Sethekk Halls			478:44.91,65.61
--		Shadow Labyrinth		478:39.63,73.54
--		Mana Tombs				478:39.63,57.67
--		Blood Furnace			465:46.03,51.79
--		Shattered Halls			465:47.68,51.99
--		Hellfire Ramparts		465:47.63,53.57
--		Black Temple			473:71.05,46.45
--		Grim Batol				700:19.18,54.01
--		Gate of the Setting Sun	811:15.84,74.39
--		Shado-Pan Monastery		809:36.66,47.33
--		Temple of Jade Serpent	806:56.18,57.87
--		Auchindoun				946:46.31,73.93
--		Bloodmaul Slag Mines	941:49.85,24.75
--		Zul Aman				463:82.14,64.35
--
--	UTF-8 file
--
Grail_NPCs_File_Version = 015

if Grail.npcsVersionNumber >= Grail_NPCs_File_Version then return end
Grail.npcsVersionNumber = Grail_NPCs_File_Version

local originalMem = gcinfo()

Grail.npcs = {}

local _, release, _, interface = GetBuildInfo()
release = tonumber(release)
interface = tonumber(interface)

local G = Grail.npcs

if release >= 0 then
--G[-1160863]={'863:8.26,22.70'}
--G[-1430864]={'864:53.98,35.35'}
--G[-1960895]={'895:33.55,26.54'}
--G[-1390896]={'896:48.91,6.94'}
--G[-1110942]={'942:45.55,72.59'}
--G[-1260862]={'862:51.19,11.33'}
--G[-1170863]={'863:39.58,54.83'}
--G[-1180863]={'863:39.39,79.58'}
--G[-1440864]={'864:78.13,60.12'}
--G[-1460864]={'864:77.98,79.21'}
--G[-1270862]={'862:70.45,39.57'}
--G[-1470864]={'864:46.94,44.29'}
--G[-1290862]={'862:18.80,13.94'}
--G[-1480864]={'864:37.73,82.45'}
--G[-1300862]={'862:77.02,49.16'}
--G[-1980895]={'895:71.00,49.45'}
--G[-1410896]={'896:89.57,18.21'}
--G[-151161]={'1161:31.68,64.00'}
--G[-1420896]={'896:97.31,36.54'}
--G[-1310862]={'862:73.22,28.29'}

G[-2420895]={'895:25.21,59.24 N:0'}
G[-2410895]={'895:76.69,43.23 N:0'}
G[-2400895]={'895:76.98,47.93 N:0'}
G[-2390895]={'895:20.36,46.55 N:0'}
G[-2380895]={'895:74.63,35.46 N:0'}
G[-2370895]={'895:88.48,29.51 N:0'}
G[-2360895]={'895:66.50,50.46 N:0'}
G[-2350895]={'895:77.14,41.33 N:0'}
G[-2340895]={'895:49.53,70.47 N:0'}
G[-2330895]={'895:45.54,44.55 N:0'}
G[-2320895]={'895:68.22,63.49 N:0'}
G[-2310895]={'895:57.88,76.02 N:0'}
G[-2300895]={'895:57.35,61.85 N:0'}
G[-2290895]={'895:39.39,47.46 N:0'}
G[-2280895]={'895:76.64,43.13 N:0'}
G[-2270895]={'895:21.79,50.32 N:0'}
G[-2260895]={'895:84.72,47.30 N:0'}
G[-2250895]={'895:79.13,37.45 N:0'}
G[-2240895]={'895:84.45,79.66 N:0'}
G[-2230895]={'895:64.99,35.22 N:0'}
G[-2220895]={'895:79.23,38.17 N:0'}
G[-2210895]={'895:81.87,40.64 N:0'}
G[-2200895]={'895:64.96,35.30 N:0'}
G[-2190895]={'895:85.94,42.40 N:0'}
G[-2180895]={'895:82.63,36.09 N:0'}
G[-2170895]={'895:88.48,29.37 N:0'}
G[-2160895]={'895:77.02,5.86 N:0'}
G[-2150895]={'895:19.53,48.94 N:0'}
G[-2140895]={'895:26.90,50.23 N:0'}
G[-2130895]={'895:26.44,59.40 N:0'}
G[-2120895]={'895:17.44,54.52 N:0'}
G[-2110895]={'895:29.99,50.40 N:0'}
G[-2100895]={'895:75.21,23.97 N:0'}
G[-2090895]={'895:21.80,58.45 N:0'}
G[-2080895]={'895:21.52,30.91 N:0'}
G[-2070895]={'895:18.62,52.42 N:0'}
G[-2060895]={'895:24.89,60.01 N:0'}
G[-2050895]={'895:26.78,60.27 N:0'}
G[-2040895]={'895:23.04,53.41 N:0'}
G[-2030895]={'895:40.72,58.25 N:0'}
G[-2020895]={'895:30.22,88.99 N:0'}
G[-2010895]={'895:75.37,24.09 N:0'}
G[-2000895]={'895:21.50,30.75 N:0'}
G[-1990895]={'895:69.79,34.57 N:0'}
G[-1980895]={'895:61.02,17.25 N:0'}
G[-1970895]={'895:34.61,36.96 N:0'}
G[-1960895]={'895:60.01,22.17 N:0'}
G[-1950895]={'895:70.42,30.36 N:0'}
G[-1940895]={'895:83.53,44.73 N:0'}
G[-1930895]={'895:56.89,16.62 N:0'}
G[-1920895]={'895:68.49,68.73 N:0'}
G[-1910895]={'895:67.76,17.72 N:0'}
G[-1900895]={'895:35.95,57.52 N:0'}
G[-1890895]={'895:55.25,51.41 N:0'}
G[-1880895]={'895:14.13,61.47 N:0'}
G[-1870895]={'895:72.47,81.01 N:0'}
G[-1860895]={'895:56.72,16.58 N:0'}
G[-1850895]={'895:72.17,29.51 N:0'}
G[-1840895]={'895:40.39,42.85 N:0'}
G[-1830895]={'895:52.82,35.48 N:0'}
G[-1820895]={'895:30.36,46.61 N:0'}
G[-1810895]={'895:76.58,84.31 N:0'}
G[-1800895]={'895:72.08,39.95 N:0'}
G[-1790895]={'895:85.22,73.47 N:0'}
G[-1780895]={'895:56.29,1.36 N:0'}
G[-1770895]={'895:71.34,29.90 N:0'}
G[-1760895]={'895:70.50,30.54 N:0'}
G[-1750895]={'895:66.17,6.26 N:0'}
G[-1740895]={'895:80.21,47.75 N:0'}
G[-1730895]={'895:42.03,56.22 N:0'}
G[-1720895]={'895:77.03,83.85 N:0'}
G[-1710895]={'895:63.62,50.30 N:0'}
G[-1710864]={'864:88.39,27.75 N:0'}
G[-1700895]={'895:41.33,14.09 N:0'}
G[-1700864]={'864:85.31,30.07 N:0'}
G[-1690895]={'895:64.57,35.38 N:0'}
G[-1690864]={'864:75.74,56.64 N:0'}
G[-1680896]={'896:38.14,49.19 N:0'}
G[-1680895]={'895:60.52,47.20 N:0'}
G[-1680864]={'864:34.72,42.37 N:0'}
G[-1670896]={'896:31.86,32.80 N:0'}
G[-1670895]={'895:84.53,78.89 N:0'}
G[-1670864]={'864:29.19,46.51 N:0'}
G[-1660896]={'896:56.46,33.98 N:0'}
G[-1660895]={'895:47.22,54.20 N:0'}
G[-1660864]={'864:70.35,41.12 N:0'}
G[-1650896]={'896:91.49,37.85 N:0'}
G[-1650895]={'895:70.25,12.41 N:0'}
G[-1650864]={'864:36.32,38.30 N:0'}
G[-1640896]={'896:69.56,63.70 N:0'}
G[-1640895]={'895:20.59,35.40 N:0'}
G[-1640864]={'864:86.82,68.00 N:0'}
G[-1630896]={'896:64.40,30.21 N:0'}
G[-1630895]={'895:39.89,55.46 N:0'}
G[-1630864]={'864:86.56,31.19 N:0'}
G[-1620896]={'896:93.72,54.68 N:0'}
G[-1620895]={'895:25.21,59.14 N:0'}
G[-1620864]={'864:86.83,67.63 N:0'}
G[-1610896]={'896:80.35,70.86 N:0'}
G[-1610895]={'895:61.84,3.53 N:0'}
G[-1610864]={'864:96.23,20.62 N:0'}
G[-1600896]={'896:79.67,52.56 N:0'}
G[-1600895]={'895:73.77,25.12 N:0'}
G[-1600864]={'864:40.73,41.05 N:0'}
G[-1590896]={'896:56.46,33.98 N:0'}
G[-1590895]={'895:10.00,68.43 N:0'}
G[-1590864]={'864:36.22,51.03 N:0'}
G[-1580896]={'896:33.71,37.66 N:0'}
G[-1580895]={'895:74.10,1.08 N:0'}
G[-1580864]={'864:83.87,33.70 N:0'}
G[-1570896]={'896:89.54,18.16 N:0'}
G[-1570895]={'895:73.08,34.59 N:0'}
G[-1570864]={'864:87.96,35.15 N:0'}
G[-1560896]={'896:89.50,18.19 N:0'}
G[-1560895]={'895:77.03,76.27 N:0'}
G[-1560864]={'864:95.64,24.06 N:0'}
G[-1550896]={'896:30.80,35.88 N:0'}
G[-1550895]={'895:21.15,65.03 N:0'}
G[-1550864]={'864:96.17,29.67 N:0'}
G[-1540896]={'896:40.32,37.56 N:0'}
G[-1540895]={'895:80.82,82.81 N:0'}
G[-1540864]={'864:86.73,38.39 N:0'}
G[-1530896]={'896:39.72,49.40 N:0'}
G[-1530895]={'895:21.52,31.23 N:0'}
G[-1530864]={'864:40.49,48.85 N:0'}
G[-1520896]={'896:28.10,43.10 N:0'}
G[-1520895]={'895:34.42,30.30 N:0'}
G[-1520864]={'864:36.84,38.04 N:0'}
G[-1510896]={'896:44.31,37.77 N:0'}
G[-1510895]={'895:84.61,79.39 N:0'}
G[-1510864]={'864:39.70,54.37 N:0'}
G[-1500896]={'896:33.73,48.17 N:0'}
G[-1500895]={'895:51.58,27.00 N:0'}
G[-1500864]={'864:36.79,69.02 N:0'}
G[-1500862]={'862:77.03,41.75 N:0'}
G[-1490896]={'896:33.36,12.59 N:0'}
G[-1490895]={'895:46.23,20.06 N:0'}
G[-1490864]={'864:33.29,71.66 N:0'}
G[-1490862]={'862:70.49,29.39 N:0'}
G[-1480896]={'896:29.62,40.38 N:0'}
G[-1480895]={'895:25.56,67.50 N:0'}
G[-1480864]={'864:36.72,63.14 N:0'}
G[-1480862]={'862:74.29,64.31 N:0'}
G[-1470896]={'896:37.72,50.19 N:0'}
G[-1470895]={'895:75.67,83.85 N:0'}
G[-1470864]={'864:33.20,48.58 N:0'}
G[-1470862]={'862:80.45,38.75 N:0'}
G[-1460896]={'896:40.16,50.53 N:0'}
G[-1460895]={'895:56.69,26.50 N:0'}
G[-1460864]={'864:41.42,40.17 N:0'}
G[-1460862]={'862:63.54,68.69 N:0'}
G[-1450896]={'896:35.33,41.66 N:0'}
G[-1450895]={'895:80.21,48.27 N:0'}
G[-1450864]={'864:60.29,18.04 N:0'}
G[-1450862]={'862:83.22,52.68 N:0'}
G[-1440896]={'896:58.18,47.91 N:0'}
G[-1440895]={'895:48.87,2.05 N:0'}
G[-1440864]={'864:32.70,64.90 N:0'}	-- -1450864 (replaced with 136336)
G[-1440862]={'862:39.58,36.68 N:0'}
G[-1430896]={'896:44.60,87.62 N:0'}
G[-1430895]={'895:56.10,69.90 N:0'}
G[-1430864]={'864:72.90,50.96 N:0'}	-- -1490864
G[-1430862]={'862:43.62,39.44 N:0'}
G[-1420896]={'896:33.34,12.38 N:0'}
G[-1420895]={'895:38.83,15.25 N:0'}
G[-1420864]={'864:71.94,47.48 N:0'}
G[-1420862]={'862:58.31,2.31 N:0'}
G[-1410896]={'896:94.42,19.81 N:0'}
G[-1410895]={'895:76.00,83.02 N:0'}
G[-1410864]={'864:52.44,24.58 N:0'}
G[-1410862]={'862:58.32,2.01 N:0'}
G[-1400896]={'896:50.29,20.41 N:0'}
G[-1400895]={'895:40.18,42.97 N:0'}
G[-1400864]={'864:83.31,77.45 N:0'}
G[-1400862]={'862:79.15,53.23 N:0'}
G[-1390896]={'896:83.11,1.30 N:0'}
G[-1390895]={'895:77.06,82.63 N:0'}
G[-1390864]={'864:35.38,78.95 N:0'}
G[-1390862]={'862:39.61,71.45 N:0'}
G[-1380896]={'896:96.56,11.88 N:0'}
G[-1380895]={'895:23.86,49.40 N:0'}
G[-1380864]={'864:54.70,15.14 N:0'}
G[-1380862]={'862:76.16,34.90 N:0'}
G[-1370896]={'896:94.07,61.45 N:0'}
G[-1370895]={'895:14.26,44.65 N:0'}
G[-1370864]={'864:45.82,50.72 N:0'}
G[-1370862]={'862:78.64,56.03 N:0'}
G[-1360896]={'896:52.01,46.97 N:0'}
G[-1360895]={'895:26.89,51.29 N:0'}
G[-1360864]={'864:41.34,62.15 N:0'}
G[-1360862]={'862:67.97,42.26 N:0'}
G[-1350896]={'896:76.95,39.07 N:0'}
G[-1350895]={'895:68.29,19.92 N:0'}
G[-1350864]={'864:52.24,60.34 N:0'}
G[-1350862]={'862:35.42,69.66 N:0'}
G[-1350680]={'680:25.94,15.74 N:0'}
G[-1340896]={'896:23.81,52.07 N:0'}
G[-1340895]={'895:25.17,50.92 N:0'}
G[-1340864]={'864:77.92,79.30 N:0'}
G[-1340863]={'863:52.89,12.85 N:0'}
G[-1340862]={'862:71.15,38.86 N:0'}
G[-1340680]={'680:66.68,26.74 N:0'}
G[-1330942]={'942:46.85,46.40 N:0'}
G[-1330896]={'896:99.21,77.32 N:0'}
G[-1330895]={'895:34.75,24.05 N:0'}
G[-1330864]={'864:62.91,34.03 N:0'}
G[-1330863]={'863:48.89,15.85 N:0'}
G[-1330862]={'862:67.05,37.19 N:0'}
G[-1330680]={'680:35.65,48.02 N:0'}
G[-1320942]={'942:26.01,56.58 N:0'}
G[-1320896]={'896:57.75,28.02 N:0'}
G[-1320895]={'895:17.39,41.29 N:0'}
G[-1320864]={'864:44.15,55.48 N:0'}
G[-1320863]={'863:36.48,50.32 N:0'}
G[-1320862]={'862:77.07,36.52 N:0'}
G[-1320680]={'680:10.81,64.12 N:0'}
G[-1310942]={'942:34.19,31.94 N:0'}
G[-1310896]={'896:73.82,18.50 N:0'}
G[-1310895]={'895:70.87,6.28 N:0'}
G[-1310864]={'864:44.87,24.01 N:0'}
G[-1310863]={'863:29.49,30.18 N:0'}
G[-1310862]={'862:75.70,38.77 N:0'}
G[-1310680]={'680:52.11,39.51 N:0'}
G[-1300942]={'942:30.42,56.68 N:0'}
G[-1300896]={'896:44.80,32.88 N:0'}
G[-1300895]={'895:38.75,55.94 N:0'}
G[-1300864]={'864:77.95,41.65 N:0'}
G[-1300863]={'863:81.83,52.83 N:0'}
G[-1300862]={'862:75.27,49.31 N:0'}
G[-1300680]={'680:0.71,30.92 N:0'}
G[-1290942]={'942:34.96,47.99 N:0'}
G[-1290896]={'896:98.70,24.28 N:0'}
G[-1290895]={'895:76.21,8.08 N:0'}
G[-1290864]={'864:45.84,79.63 N:0'}
G[-1290863]={'863:50.85,65.05 N:0'}
G[-1290862]={'862:18.04,3.12 N:0'}
G[-1290680]={'680:59.86,46.00 N:0'}
G[-1290650]={'650:34.95,86.99 N:0'}
G[-1280942]={'942:65.22,59.30 N:0'}
G[-1280896]={'896:98.69,10.66 N:0'}
G[-1280895]={'895:12.14,72.53 N:0'}
G[-1280864]={'864:93.06,47.72 N:0'}
G[-1280863]={'863:50.51,17.31 N:0'}
G[-1280862]={'862:15.22,5.25 N:0'}
G[-1280680]={'680:30.41,60.75 N:0'}
G[-1280650]={'650:66.95,95.63 N:0'}
G[-1270942]={'942:47.10,47.83 N:0'}
G[-1270896]={'896:18.46,55.81 N:0'}
G[-1270895]={'895:38.44,20.71 N:0'}
G[-1270864]={'864:28.87,63.16 N:0'}
G[-1270863]={'863:50.87,64.56 N:0'}
G[-1270862]={'862:43.70,39.32 N:0'}
G[-1270680]={'680:69.13,12.53 N:0'}
G[-1270650]={'650:15.14,98.92 N:0'}
G[-1260942]={'942:47.57,53.41 N:0'}
G[-1260896]={'896:50.60,36.54 N:0'}
G[-1260895]={'895:66.90,13.34 N:0'}
G[-1260864]={'864:44.43,90.51 N:0'}
G[-1260863]={'863:63.06,3.60 N:0'}
G[-1260862]={'862:61.78,46.07 N:0'}	-- -1280862
G[-1260680]={'680:16.36,15.93 N:0'}
G[-1260650]={'650:44.63,10.26 N:0'}
G[-1250942]={'942:34.63,58.00 N:0'}
G[-1250896]={'896:63.32,39.96 N:0'}
G[-1250895]={'895:88.32,29.76 N:0'}
G[-1250864]={'864:72.27,94.69 N:0'}
G[-1250863]={'863:47.03,20.56 N:0'}
G[-1250862]={'862:72.05,63.92 N:0'}
G[-1250680]={'680:75.40,0.37 N:0'}
G[-1250650]={'650:35.00,21.89 N:0'}
G[-1240942]={'942:71.67,83.04 N:0'}
G[-1240896]={'896:88.70,18.89 N:0'}
G[-1240895]={'895:71.92,28.99 N:0'}
G[-1240864]={'864:54.51,87.12 N:0'}
G[-1240863]={'863:52.34,22.45 N:0'}
G[-1240862]={'862:55.48,9.91 N:0'}
G[-1240680]={'680:68.43,20.36 N:0'}
G[-1240650]={'650:77.40,55.35 N:0'}
G[-1230942]={'942:37.67,47.67 N:0'}
G[-1230896]={'896:97.78,10.84 N:0'}
G[-1230895]={'895:19.56,35.42 N:0'}
G[-1230864]={'864:28.66,68.71 N:0'}
G[-1230863]={'863:62.30,8.05 N:0'}
G[-1230862]={'862:16.91,11.12 N:0'}
G[-1230680]={'680:45.90,67.53 N:0'}
G[-1230650]={'650:68.87,84.47 N:0'}
G[-1220942]={'942:36.70,64.03 N:0'}
G[-1220896]={'896:96.67,12.12 N:0'}
G[-1220895]={'895:40.99,46.71 N:0'}
G[-1220864]={'864:56.68,49.73 N:0'}
G[-1220863]={'863:71.11,18.73 N:0'}
G[-1220862]={'862:58.46,44.58 N:0'}
G[-1220680]={'680:7.14,79.19 N:0'}
G[-1220650]={'650:27.43,87.14 N:0'}
G[-1210942]={'942:68.96,51.56 N:0'}
G[-1210896]={'896:59.87,45.30 N:0'}
G[-1210895]={'895:22.89,45.18 N:0'}
G[-1210864]={'864:40.52,68.49 N:0'}
G[-1210863]={'863:62.98,15.34 N:0'}
G[-1210862]={'862:51.15,11.40 N:0'}
G[-1210680]={'680:38.33,23.01 N:0'}
G[-1210650]={'650:73.79,74.92 N:0'}
G[-1200942]={'942:36.41,51.82 N:0'}
G[-1200896]={'896:87.78,37.64 N:0'}
G[-1200895]={'895:73.15,34.71 N:0'}
G[-1200864]={'864:82.37,57.88 N:0'}
G[-1200863]={'863:79.22,19.31 N:0'}
G[-1200862]={'862:55.91,31.32 N:0'}
G[-1200680]={'680:94.01,16.31 N:0'}
G[-1200650]={'650:87.10,60.06 N:0'}
G[-1190942]={'942:44.98,60.09 N:0'}
G[-1190896]={'896:88.98,18.32 N:0'}
G[-1190895]={'895:34.01,54.81 N:0'}
G[-1190864]={'864:44.15,55.48 N:0'}
G[-1190863]={'863:50.74,26.64 N:0'}
G[-1190862]={'862:56.06,39.83 N:0'}
G[-1190680]={'680:69.55,27.22 N:0'}
G[-1190650]={'650:37.53,58.77 N:0'}
G[-1180942]={'942:46.43,50.44 N:0'}
G[-1180896]={'896:83.77,33.64 N:0'}
G[-1180895]={'895:61.84,31.29 N:0'}
G[-1180864]={'864:80.65,64.68 N:0'}
G[-1180863]={'863:69.30,7.97 N:0'}
G[-1180862]={'862:25.32,11.67 N:0'}
G[-1180680]={'680:12.85,10.58 N:0'}
G[-1180650]={'650:68.32,90.62 N:0'}
G[-1180634]={'634:35.80,70.33 N:0'}
G[-1170942]={'942:40.17,63.08 N:0'}
G[-1170896]={'896:66.58,42.68 N:0'}
G[-1170895]={'895:47.78,22.17 N:0'}
G[-1170864]={'864:61.87,43.74 N:0'}
G[-1170863]={'863:16.45,0.26 N:0'}
G[-1170862]={'862:46.61,65.20 N:0'}
G[-1170680]={'680:5.75,90.24 N:0'}
G[-1170650]={'650:59.66,66.13 N:0'}
G[-1170634]={'634:6.11,90.70 N:0'}
G[-1170630]={'630:43.44,73.29 N:0'}
G[-1160942]={'942:42.94,46.61 N:0'}
G[-1160896]={'896:38.14,49.06 N:0'}
G[-1160895]={'895:17.30,31.62 N:0'}
G[-1160864]={'864:62.00,37.90 N:0'}
G[-1160863]={'863:32.80,42.95 N:0'}	-- -1190863
G[-1160862]={'862:58.22,34.04 N:0'}
G[-1160680]={'680:10.27,5.97 N:0'}
G[-1160650]={'650:88.40,87.44 N:0'}
G[-1160634]={'634:21.86,82.56 N:0'}
G[-1160630]={'630:78.19,3.15 N:0'}
G[-1150942]={'942:36.37,54.75 N:0'}
G[-1150896]={'896:32.16,18.39 N:0'}
G[-1150895]={'895:64.70,58.53 N:0'}
G[-1150864]={'864:88.79,50.92 N:0'}
G[-1150863]={'863:46.30,77.30 N:0'}
G[-1150862]={'862:46.60,23.79 N:0'}
G[-1150680]={'680:92.60,0.24 N:0'}
G[-1150650]={'650:44.68,92.70 N:0'}
G[-1150634]={'634:48.54,21.28 N:0'}
G[-1150630]={'630:57.26,16.71 N:0'}
G[-1140942]={'942:50.78,97.92 N:0'}
G[-1140896]={'896:57.10,44.30 N:0'}
G[-1140895]={'895:48.22,55.41 N:0'}
G[-1140864]={'864:84.84,94.47 N:0'}
G[-1140863]={'863:31.55,38.44 N:0'}
G[-1140862]={'862:72.12,65.00 N:0'}
G[-1140680]={'680:99.61,20.66 N:0'}
G[-1140650]={'650:69.19,96.01 N:0'}
G[-1140634]={'634:78.01,76.51 N:0'}
G[-1140630]={'630:42.97,8.06 N:0'}
G[-1130942]={'942:34.45,32.18 N:0'}
G[-1130896]={'896:99.99,17.35 N:0'}
G[-1130895]={'895:88.35,77.94 N:0'}
G[-1130864]={'864:73.68,84.25 N:0'}
G[-1130863]={'863:5.99,55.11 N:0'}
G[-1130862]={'862:72.19,0.41 N:0'}
G[-1130680]={'680:42.22,56.77 N:0'}
G[-1130650]={'650:24.67,82.94 N:0'}
G[-1130634]={'634:29.27,88.76 N:0'}
G[-1130630]={'630:98.58,1.44 N:0'}
G[-1120942]={'942:59.36,69.34 N:0'}
G[-1120896]={'896:18.48,61.06 N:0'}
G[-1120895]={'895:73.93,25.12 N:0'}
G[-1120864]={'864:66.84,24.34 N:0'}
G[-1120863]={'863:39.31,79.70 N:0'}
G[-1120862]={'862:32.30,17.69 N:0'}
G[-1120680]={'680:70.48,22.17 N:0'}
G[-1120650]={'650:22.65,79.31 N:0'}
G[-1120634]={'634:38.15,56.74 N:0'}
G[-1120630]={'630:73.77,13.87 N:0'}
G[-1110942]={'942:78.65,27.11 N:0'}	-- -1120942
G[-1110896]={'896:32.89,56.67 N:0'}
G[-1110895]={'895:13.98,32.33 N:0'}
G[-1110864]={'864:44.15,90.73 N:0'}
G[-1110863]={'863:19.84,20.99 N:0'}
G[-1110862]={'862:52.16,44.53 N:0'}
G[-1110680]={'680:94.37,30.11 N:0'}
G[-1110650]={'650:87.30,74.81 N:0'}
G[-1110634]={'634:44.15,45.11 N:0'}
G[-1110630]={'630:55.00,70.01 N:0'}
G[-1100942]={'942:38.10,56.52 N:0'}
G[-1100896]={'896:33.36,13.01 N:0'}
G[-1100895]={'895:38.07,29.61 N:0'}
G[-1100864]={'864:65.73,66.62 N:0'}
G[-1100863]={'863:6.26,8.74 N:0'}
G[-1100862]={'862:11.50,2.87 N:0'}
G[-1100680]={'680:8.76,1.43 N:0'}
G[-1100650]={'650:60.81,57.45 N:0'}
G[-1100634]={'634:60.36,27.01 N:0'}
G[-1100630]={'630:32.25,29.80 N:0'}
G[-1090942]={'942:45.39,97.10 N:0'}
G[-1090896]={'896:50.04,11.81 N:0'}
G[-1090895]={'895:54.72,1.00 N:0'}
G[-1090864]={'864:74.34,82.91 N:0'}
G[-1090863]={'863:39.35,30.87 N:0'}
G[-1090862]={'862:24.19,20.42 N:0'}
G[-1090680]={'680:43.43,61.58 N:0'}
G[-1090650]={'650:92.80,90.85 N:0'}
G[-1090634]={'634:37.48,64.23 N:0'}
G[-1090630]={'630:35.26,50.35 N:0'}
G[-1080942]={'942:59.59,98.52 N:0'}
G[-1080896]={'896:72.21,7.54 N:0'}
G[-1080895]={'895:17.53,31.94 N:0'}
G[-1080864]={'864:46.22,44.82 N:0'}
G[-1080863]={'863:68.29,50.94 N:0'}
G[-1080862]={'862:21.05,2.70 N:0'}
G[-1080680]={'680:8.90,8.10 N:0'}
G[-1080650]={'650:95.88,76.64 N:0'}
G[-1080641]={'641:79.64,57.22 N:0'}
G[-1080634]={'634:26.93,34.41 N:0'}
G[-1080630]={'630:86.82,19.58 N:0'}
G[-1070942]={'942:31.81,31.52 N:0'}
G[-1070896]={'896:38.59,59.86 N:0'}
G[-1070895]={'895:22.74,46.77 N:0'}
G[-1070864]={'864:35.03,51.82 N:0'}
G[-1070863]={'863:58.94,38.75 N:0'}
G[-1070862]={'862:58.90,59.03 N:0'}
G[-1070680]={'680:90.39,23.50 N:0'}
G[-1070650]={'650:83.62,71.78 N:0'}
G[-1070641]={'641:89.42,89.75 N:0'}
G[-1070634]={'634:8.67,66.77 N:0'}
G[-1070630]={'630:54.17,29.41 N:0'}
G[-1060942]={'942:45.16,97.04 N:0'}
G[-1060896]={'896:78.05,62.97 N:0'}
G[-1060895]={'895:69.50,46.83 N:0'}
G[-1060864]={'864:29.70,46.38 N:0'}
G[-1060863]={'863:69.15,14.39 N:0'}
G[-1060862]={'862:70.72,39.74 N:0'}
G[-1060680]={'680:16.34,92.75 N:0'}
G[-1060650]={'650:69.93,92.04 N:0'}
G[-1060641]={'641:54.21,72.52 N:0'}
G[-1060634]={'634:61.95,60.36 N:0'}
G[-1060630]={'630:99.98,62.66 N:0'}
G[-1050942]={'942:52.70,51.19 N:0'}
G[-1050896]={'896:78.82,6.89 N:0'}
G[-1050895]={'895:16.74,65.98 N:0'}
G[-1050864]={'864:68.96,96.54 N:0'}
G[-1050863]={'863:31.98,99.66 N:0'}
G[-1050862]={'862:21.05,2.70 N:0'}
G[-1050680]={'680:16.34,92.92 N:0'}
G[-1050650]={'650:88.68,98.28 N:0'}
G[-1050641]={'641:92.12,64.54 N:0'}
G[-1050634]={'634:38.54,70.80 N:0'}
G[-1050630]={'630:53.00,38.72 N:0'}
G[-1040942]={'942:40.72,36.73 N:0'}
G[-1040896]={'896:57.48,28.17 N:0'}
G[-1040895]={'895:77.60,58.88 N:0'}
G[-1040864]={'864:72.60,53.56 N:0'}
G[-1040863]={'863:45.08,51.91 N:0'}
G[-1040862]={'862:71.50,30.33 N:0'}
G[-1040680]={'680:43.36,61.66 N:0'}
G[-1040650]={'650:21.46,75.75 N:0'}
G[-1040641]={'641:47.30,95.63 N:0'}
G[-1040634]={'634:60.60,44.98 N:0'}
G[-1040630]={'630:83.73,10.52 N:0'}
G[-1030942]={'942:60.78,40.14 N:0'}
G[-1030896]={'896:38.09,38.45 N:0'}
G[-1030895]={'895:79.86,66.48 N:0'}
G[-1030864]={'864:52.53,25.09 N:0'}
G[-1030863]={'863:67.99,20.39 N:0'}
G[-1030862]={'862:64.26,30.31 N:0'}
G[-1030680]={'680:55.98,50.21 N:0'}
G[-1030650]={'650:29.85,70.93 N:0'}
G[-1030641]={'641:66.44,52.02 N:0'}
G[-1030634]={'634:28.32,23.83 N:0'}
G[-1030630]={'630:45.44,76.73 N:0'}
G[-1020942]={'942:51.38,25.76 N:0'}
G[-1020896]={'896:36.40,36.49 N:0'}
G[-1020895]={'895:15.64,75.12 N:0'}
G[-1020864]={'864:42.52,92.05 N:0'}
G[-1020863]={'863:81.93,52.54 N:0'}
G[-1020862]={'862:40.47,42.76 N:0'}
G[-1020680]={'680:22.83,44.02 N:0'}
G[-1020650]={'650:21.58,80.99 N:0'}
G[-1020641]={'641:63.85,47.36 N:0'}
G[-1020634]={'634:67.31,64.52 N:0'}
G[-1020630]={'630:84.74,14.57 N:0'}
G[-1010942]={'942:33.89,31.94 N:0'}
G[-1010896]={'896:23.99,30.34 N:0'}
G[-1010895]={'895:49.80,67.92 N:0'}
G[-1010864]={'864:88.51,28.04 N:0'}
G[-1010863]={'863:42.86,60.74 N:0'}
G[-1010862]={'862:46.63,71.03 N:0'}
G[-1010680]={'680:52.98,65.53 N:0'}
G[-1010650]={'650:47.77,63.61 N:0'}
G[-1010641]={'641:69.98,57.41 N:0'}
G[-1010634]={'634:71.07,47.20 N:0'}
G[-1010630]={'630:34.88,27.95 N:0'}
G[-1000942]={'942:24.73,93.63 N:0'}
G[-1000896]={'896:40.30,38.92 N:0'}
G[-1000895]={'895:66.79,57.28 N:0'}
G[-1000864]={'864:49.83,26.54 N:0'}
G[-1000863]={'863:18.48,33.58 N:0'}
G[-1000862]={'862:49.72,57.13 N:0'}
G[-1000680]={'680:29.31,88.62 N:0'}
G[-1000650]={'650:85.56,93.08 N:0'}
G[-1000641]={'641:60.93,35.95 N:0'}
G[-1000634]={'634:12.40,99.08 N:0'}
G[-1000630]={'630:61.92,40.84 N:0'}
G[-990942]={'942:68.29,38.76 N:0'}
G[-990896]={'896:50.46,3.73 N:0'}
G[-990895]={'895:67.22,55.31 N:0'}
G[-990864]={'864:43.85,53.89 N:0'}
G[-990863]={'863:18.66,26.02 N:0'}
G[-990862]={'862:46.80,71.75 N:0'}
G[-990680]={'680:86.51,22.09 N:0'}
G[-990650]={'650:7.45,82.81 N:0'}
G[-990641]={'641:33.50,40.94 N:0'}
G[-990634]={'634:56.12,41.28 N:0'}
G[-990630]={'630:61.92,40.97 N:0'}
G[-980942]={'942:67.32,49.63 N:0'}
G[-980896]={'896:28.03,26.00 N:0'}
G[-980895]={'895:18.40,70.59 N:0'}
G[-980864]={'864:68.15,81.04 N:0'}
G[-980863]={'863:53.40,42.89 N:0'}
G[-980862]={'862:56.71,23.61 N:0'}
G[-980680]={'680:18.22,47.00 N:0'}
G[-980650]={'650:68.71,72.88 N:0'}
G[-980641]={'641:82.94,21.01 N:0'}
G[-980634]={'634:39.44,65.97 N:0'}
G[-980630]={'630:50.45,82.26 N:0'}
G[-970942]={'942:81.62,58.64 N:0'}
G[-970896]={'896:55.64,44.93 N:0'}
G[-970895]={'895:30.62,46.11 N:0'}
G[-970864]={'864:92.12,70.07 N:0'}
G[-970863]={'863:48.28,99.37 N:0'}
G[-970862]={'862:47.73,15.39 N:0'}
G[-970680]={'680:61.19,39.49 N:0'}	-- -960680
G[-970650]={'650:3.59,81.75 N:0'}
G[-970641]={'641:41.56,78.26 N:0'}
G[-970634]={'634:62.29,73.57 N:0'}
G[-970630]={'630:84.68,14.64 N:0'}
G[-960942]={'942:68.34,68.29 N:0'}
G[-960896]={'896:21.25,66.37 N:0'}
G[-960895]={'895:33.75,78.48 N:0'}
G[-960864]={'864:74.87,42.62 N:0'}
G[-960863]={'863:33.81,86.12 N:0'}
G[-960862]={'862:23.96,20.60 N:0'}
G[-960680]={'680:83.18,31.14 N:0'}	-- -950680
G[-960650]={'650:97.31,71.63 N:0'}
G[-960641]={'641:96.04,98.58 N:0'}
G[-960634]={'634:12.43,31.33 N:0'}
G[-960630]={'630:95.32,4.99 N:0'}
G[-950942]={'942:44.60,77.17 N:0'}
G[-950896]={'896:99.87,17.53 N:0'}
G[-950895]={'895:46.02,19.70 N:0'}
G[-950864]={'864:81.92,55.50 N:0'}
G[-950863]={'863:24.94,8.43 N:0'}
G[-950862]={'862:70.52,39.76 N:0'}
G[-950680]={'680:22.79,33.27 N:0'}
G[-950650]={'650:3.59,81.71 N:0'}
G[-950641]={'641:62.32,42.79 N:0'}
G[-950634]={'634:58.48,67.23 N:0'}
G[-950630]={'630:46.87,77.55 N:0'}
G[-940942]={'942:57.51,83.56 N:0'}
G[-940896]={'896:98.50,10.11 N:0'}
G[-940895]={'895:20.42,52.64 N:0'}
G[-940864]={'864:47.22,87.03 N:0'}
G[-940863]={'863:23.49,63.25 N:0'}
G[-940862]={'862:41.33,1.19 N:0'}
G[-940680]={'680:6.45,8.50 N:0'}
G[-940650]={'650:97.55,94.97 N:0'}
G[-940641]={'641:73.08,36.61 N:0'}
G[-940634]={'634:37.96,42.63 N:0'}
G[-940630]={'630:92.79,17.89 N:0'}
G[-930942]={'942:37.48,39.61 N:0'}
G[-930896]={'896:30.84,18.42 N:0'}
G[-930895]={'895:52.65,21.03 N:0'}
G[-930864]={'864:51.18,36.34 N:0'}
G[-930863]={'863:34.67,84.38 N:0'}
G[-930862]={'862:48.26,14.31 N:0'}
G[-930680]={'680:52.94,65.58 N:0'}
G[-930650]={'650:55.66,45.51 N:0'}
G[-930641]={'641:62.47,49.51 N:0'}
G[-930634]={'634:72.81,41.10 N:0'}
G[-930630]={'630:44.16,85.54 N:0'}
G[-920942]={'942:34.36,26.31 N:0'}
G[-920896]={'896:58.53,33.01 N:0'}
G[-920895]={'895:47.51,52.76 N:0'}
G[-920864]={'864:85.82,47.09 N:0'}
G[-920863]={'863:32.40,46.32 N:0'}
G[-920862]={'862:43.93,25.28 N:0'}
G[-920680]={'680:94.67,23.47 N:0'}
G[-920650]={'650:49.13,43.83 N:0'}
G[-920641]={'641:96.08,27.21 N:0'}
G[-920634]={'634:25.57,92.80 N:0'}
G[-920630]={'630:72.85,37.35 N:0'}	-- -910630
G[-910942]={'942:25.06,93.79 N:0'}
G[-910896]={'896:35.14,31.02 N:0'}
G[-910895]={'895:42.96,16.68 N:0'}
G[-910864]={'864:48.83,49.88 N:0'}
G[-910863]={'863:6.38,9.40 N:0'}
G[-910862]={'862:75.54,35.83 N:0'}
G[-910680]={'680:45.95,56.67 N:0'}
G[-910650]={'650:30.66,29.12 N:0'}
G[-910641]={'641:44.34,51.85 N:0'}
G[-910634]={'634:73.10,69.53 N:0'}
G[-910630]={'630:63.50,2.28 N:0'}
G[-900942]={'942:62.83,91.60 N:0'}
G[-900896]={'896:89.17,48.28 N:0'}
G[-900895]={'895:72.21,40.20 N:0'}
G[-900864]={'864:41.43,62.43 N:0'}
G[-900863]={'863:72.79,48.40 N:0'}
G[-900862]={'862:22.65,21.66 N:0'}
G[-900680]={'680:66.11,10.18 N:0'}
G[-900650]={'650:82.52,91.98 N:0'}
G[-900641]={'641:28.66,49.46 N:0'}
G[-900634]={'634:22.05,9.28 N:0'}
G[-900630]={'630:92.76,17.94 N:0'}
G[-890942]={'942:49.55,55.63 N:0'}
G[-890896]={'896:67.87,44.25 N:0'}
G[-890895]={'895:60.51,47.70 N:0'}
G[-890864]={'864:86.98,67.83 N:0'}
G[-890863]={'863:53.04,13.22 N:0'}
G[-890862]={'862:60.13,57.54 N:0'}
G[-890680]={'680:2.64,45.65 N:0'}
G[-890650]={'650:35.28,63.67 N:0'}
G[-890641]={'641:39.38,50.49 N:0'}
G[-890634]={'634:14.09,7.24 N:0'}
G[-890630]={'630:86.87,10.43 N:0'}
G[-880942]={'942:43.29,55.44 N:0'}
G[-880896]={'896:49.50,43.47 N:0'}
G[-880895]={'895:34.98,44.35 N:0'}
G[-880864]={'864:45.84,79.41 N:0'}
G[-880863]={'863:2.87,11.28 N:0'}
G[-880862]={'862:79.96,35.83 N:0'}
G[-880680]={'680:41.94,79.92 N:0'}
G[-880650]={'650:33.98,28.32 N:0'}
G[-880641]={'641:76.50,85.72 N:0'}
G[-880634]={'634:54.78,65.89 N:0'}
G[-880630]={'630:50.37,1.14 N:0'}
G[-870942]={'942:49.42,70.03 N:0'}
G[-870896]={'896:85.48,13.09 N:0'}
G[-870895]={'895:50.92,66.97 N:0'}
G[-870864]={'864:66.99,67.83 N:0'}
G[-870863]={'863:26.63,81.95 N:0'}
G[-870862]={'862:39.76,71.97 N:0'}
G[-870680]={'680:19.89,35.11 N:0'}
G[-870650]={'650:39.90,10.45 N:0'}	-- -840650
G[-870641]={'641:39.38,50.44 N:0'}
G[-870634]={'634:30.55,82.54 N:0'}	-- -860634
G[-870630]={'630:51.37,64.07 N:0'}
G[-860942]={'942:51.85,80.00 N:0'}
G[-860896]={'896:67.30,1.30 N:0'}
G[-860895]={'895:13.90,63.51 N:0'}
G[-860864]={'864:38.19,41.41 N:0'}
G[-860863]={'863:57.73,67.73 N:0'}
G[-860862]={'862:61.69,64.51 N:0'}
G[-860680]={'680:1.19,31.65 N:0'}
G[-860650]={'650:49.01,49.47 N:0'}
G[-860641]={'641:97.82,1.84 N:0'}
G[-860634]={'634:85.15,11.69 N:0'}	-- -840634
G[-860630]={'630:83.48,30.03 N:0'}
G[-850942]={'942:67.86,76.80 N:0'}
G[-850896]={'896:27.91,13.51 N:0'}
G[-850895]={'895:58.07,66.04 N:0'}
G[-850864]={'864:37.06,45.90 N:0'}
G[-850863]={'863:35.35,32.13 N:0'}
G[-850862]={'862:68.51,48.85 N:0'}
G[-850680]={'680:45.92,28.65 N:0'}
G[-850650]={'650:79.90,99.09 N:0'}
G[-850641]={'641:80.05,27.30 N:0'}
G[-850634]={'634:13.95,14.12 N:0'}
G[-850630]={'630:50.22,82.37 N:0'}
G[-840942]={'942:82.93,48.81 N:0'}
G[-840896]={'896:54.75,10.92 N:0'}
G[-840895]={'895:13.28,59.40 N:0'}
G[-840864]={'864:53.51,53.65 N:0'}
G[-840863]={'863:44.49,48.83 N:0'}
G[-840862]={'862:59.85,35.60 N:0'}
G[-840680]={'680:33.56,83.06 N:0'}
G[-840650]={'650:6.19,71.71 N:0'}
G[-840641]={'641:71.85,88.72 N:0'}
G[-840634]={'634:51.59,74.55 N:0'}	-- -850634
G[-840630]={'630:78.81,57.16 N:0'}
G[-830942]={'942:60.20,40.98 N:0'}
G[-830896]={'896:23.62,14.42 N:0'}
G[-830895]={'895:45.03,44.14 N:0'}
G[-830864]={'864:48.99,72.30 N:0'}
G[-830863]={'863:87.31,95.83 N:0'}
G[-830862]={'862:43.28,12.80 N:0'}
G[-830680]={'680:36.95,20.93 N:0'}
G[-830650]={'650:58.30,71.29 N:0'}
G[-830641]={'641:97.67,9.08 N:0'}
G[-830634]={'634:25.27,40.69 N:0'}
G[-830630]={'630:56.61,56.50 N:0'}
G[-820942]={'942:46.73,36.96 N:0'}
G[-820896]={'896:28.20,13.92 N:0'}
G[-820895]={'895:9.99,64.89 N:0'}
G[-820864]={'864:70.20,56.93 N:0'}
G[-820863]={'863:49.56,37.92 N:0'}
G[-820862]={'862:62.57,3.97 N:0'}
G[-820680]={'680:24.23,29.95 N:0'}
G[-820650]={'650:56.68,59.21 N:0'}
G[-820641]={'641:34.16,58.28 N:0'}
G[-820634]={'634:23.29,25.98 N:0'}
G[-820630]={'630:76.43,32.67 N:0'}
G[-810942]={'942:34.91,78.07 N:0'}
G[-810896]={'896:34.95,33.09 N:0'}
G[-810895]={'895:74.86,78.95 N:0'}
G[-810864]={'864:58.53,41.16 N:0'}
G[-810863]={'863:1.58,41.55 N:0'}
G[-810862]={'862:80.93,21.42 N:0'}
G[-810680]={'680:59.15,42.40 N:0'}
G[-810650]={'650:19.65,81.31 N:0'}
G[-810641]={'641:42.72,37.62 N:0'}
G[-810634]={'634:62.59,67.21 N:0'}
G[-810630]={'630:67.58,55.68 N:0'}
G[-800942]={'942:42.31,74.84 N:0'}
G[-800896]={'896:95.38,33.17 N:0'}
G[-800895]={'895:60.44,2.96 N:0'}
G[-800864]={'864:57.08,48.74 N:0'}
G[-800863]={'863:4.62,23.99 N:0'}
G[-800862]={'862:26.43,17.62 N:0'}
G[-800680]={'680:20.45,12.72 N:0'}
G[-800650]={'650:88.92,93.06 N:0'}
G[-800641]={'641:76.46,74.89 N:0'}
G[-800634]={'634:35.25,54.49 N:0'}
G[-800630]={'630:41.34,76.05 N:0'}
G[-790942]={'942:52.73,69.82 N:0'}
G[-790896]={'896:27.19,57.90 N:0'}
G[-790895]={'895:18.36,74.60 N:0'}
G[-790864]={'864:52.44,24.85 N:0'}
G[-790863]={'863:51.06,64.82 N:0'}
G[-790862]={'862:37.79,78.90 N:0'}
G[-790680]={'680:45.77,56.91 N:0'}
G[-790650]={'650:66.49,82.62 N:0'}
G[-790641]={'641:60.00,49.92 N:0'}
G[-790634]={'634:7.80,14.61 N:0'}
G[-790630]={'630:50.66,82.17 N:0'}
G[-780942]={'942:38.66,29.64 N:0'}
G[-780896]={'896:25.76,69.71 N:0'}
G[-780895]={'895:20.33,40.04 N:0'}
G[-780864]={'864:97.07,26.28 N:0'}
G[-780863]={'863:25.13,64.82 N:0'}
G[-780862]={'862:58.44,2.17 N:0'}
G[-780680]={'680:34.17,60.91 N:0'}
G[-780650]={'650:43.96,49.88 N:0'}
G[-780641]={'641:91.20,9.60 N:0'}
G[-780634]={'634:15.97,98.97 N:0'}
G[-780630]={'630:86.72,10.63 N:0'}
G[-770942]={'942:42.17,63.34 N:0'}
G[-770896]={'896:69.91,60.41 N:0'}
G[-770895]={'895:67.66,12.64 N:0'}
G[-770864]={'864:95.49,77.80 N:0'}
G[-770863]={'863:75.80,36.01 N:0'}
G[-770862]={'862:25.32,11.49 N:0'}
G[-770680]={'680:21.19,91.51 N:0'}
G[-770650]={'650:19.64,67.07 N:0'}
G[-770641]={'641:59.98,31.65 N:0'}
G[-770634]={'634:17.36,37.48 N:0'}
G[-770630]={'630:76.94,14.00 N:0'}
G[-760942]={'942:73.22,67.57 N:0'}
G[-760896]={'896:45.13,32.22 N:0'}
G[-760895]={'895:46.00,37.81 N:0'}
G[-760864]={'864:88.54,59.68 N:0'}
G[-760863]={'863:7.65,46.43 N:0'}
G[-760862]={'862:42.35,2.17 N:0'}
G[-760680]={'680:25.17,62.28 N:0'}
G[-760650]={'650:20.37,70.42 N:0'}
G[-760641]={'641:99.80,98.47 N:0'}
G[-760634]={'634:15.93,72.17 N:0'}
G[-760630]={'630:66.00,39.79 N:0'}
G[-750942]={'942:63.14,74.74 N:0'}
G[-750896]={'896:91.87,46.66 N:0'}
G[-750895]={'895:25.16,59.14 N:0'}
G[-750864]={'864:66.62,21.54 N:0'}
G[-750863]={'863:1.79,70.62 N:0'}
G[-750862]={'862:77.00,27.88 N:0'}
G[-750680]={'680:52.98,65.58 N:0'}
G[-750650]={'650:51.81,68.66 N:0'}
G[-750641]={'641:56.15,87.36 N:0'}
G[-750634]={'634:7.35,64.78 N:0'}
G[-750630]={'630:69.36,15.16 N:0'}
G[-740942]={'942:21.80,95.30 N:0'}
G[-740896]={'896:92.43,44.12 N:0'}
G[-740895]={'895:41.92,36.37 N:0'}
G[-740864]={'864:46.17,61.68 N:0'}
G[-740863]={'863:29.30,50.69 N:0'}
G[-740862]={'862:65.61,30.45 N:0'}
G[-740680]={'680:88.71,1.37 N:0'}
G[-740650]={'650:15.52,99.49 N:0'}
G[-740641]={'641:46.61,69.91 N:0'}
G[-740634]={'634:72.98,69.46 N:0'}
G[-740630]={'630:92.79,17.94 N:0'}
G[-730942]={'942:59.45,69.58 N:0'}
G[-730896]={'896:49.17,74.05 N:0'}
G[-730895]={'895:22.56,36.45 N:0'}
G[-730864]={'864:24.70,68.51 N:0'}
G[-730863]={'863:14.16,30.24 N:0'}
G[-730862]={'862:57.94,56.92 N:0'}
G[-730680]={'680:18.63,39.73 N:0'}
G[-730650]={'650:50.64,97.14 N:0'}
G[-730641]={'641:73.54,76.74 N:0'}
G[-730634]={'634:28.60,85.33 N:0'}
G[-730630]={'630:87.08,10.54 N:0'}
G[-720942]={'942:67.18,42.59 N:0'}
G[-720896]={'896:31.95,40.67 N:0'}
G[-720895]={'895:76.52,31.44 N:0'}
G[-720864]={'864:50.61,30.88 N:0'}
G[-720863]={'863:12.28,40.06 N:0'}
G[-720862]={'862:70.94,32.10 N:0'}
G[-720680]={'680:86.53,0.70 N:0'}
G[-720650]={'650:43.60,91.07 N:0'}
G[-720641]={'641:54.70,73.25 N:0'}
G[-720634]={'634:7.12,42.19 N:0'}
G[-720630]={'630:79.78,9.52 N:0'}
G[-710942]={'942:35.89,36.94 N:0'}
G[-710896]={'896:29.34,63.86 N:0'}
G[-710895]={'895:88.52,80.12 N:0'}
G[-710864]={'864:47.05,44.80 N:0'}
G[-710863]={'863:6.26,9.08 N:0'}
G[-710862]={'862:58.01,53.68 N:0'}
G[-710680]={'680:71.67,28.68 N:0'}
G[-710650]={'650:97.45,94.91 N:0'}
G[-710646]={'646:53.29,51.69 N:0'}
G[-710641]={'641:99.76,70.23 N:0'}
G[-710634]={'634:15.79,99.21 N:0'}
G[-710630]={'630:89.43,11.77 N:0'}
G[-701355]={'1355:71.49,31.74 N:0'}
G[-700942]={'942:38.15,51.69 N:0'}
G[-700896]={'896:66.95,40.83 N:0'}
G[-700895]={'895:12.85,44.59 N:0'}
G[-700864]={'864:34.27,62.83 N:0'}
G[-700863]={'863:64.14,10.94 N:0'}
G[-700862]={'862:42.06,35.93 N:0'}
G[-700680]={'680:94.67,37.38 N:0'}
G[-700650]={'650:33.61,98.15 N:0'}
G[-700646]={'646:66.82,45.03 N:0'}
G[-700641]={'641:90.72,62.45 N:0'}
G[-700634]={'634:56.88,46.06 N:0'}
G[-700630]={'630:43.36,8.36 N:0'}
G[-691355]={'1355:37.14,16.16 N:0'}
G[-690942]={'942:63.64,83.59 N:0'}
G[-690896]={'896:98.86,24.38 N:0'}
G[-690895]={'895:12.56,38.54 N:0'}
G[-690864]={'864:85.03,93.72 N:0'}
G[-690863]={'863:62.11,77.76 N:0'}
G[-690862]={'862:74.10,39.44 N:0'}
G[-690680]={'680:46.20,56.80 N:0'}
G[-690650]={'650:30.64,84.62 N:0'}
G[-690646]={'646:66.59,29.68 N:0'}
G[-690641]={'641:77.91,71.54 N:0'}
G[-690634]={'634:54.80,45.42 N:0'}
G[-690630]={'630:49.51,8.65 N:0'}
G[-681355]={'1355:50.37,17.42 N:0'}
G[-680942]={'942:49.97,56.18 N:0'}
G[-680896]={'896:83.75,34.29 N:0'}
G[-680895]={'895:45.94,63.04 N:0'}
G[-680864]={'864:75.34,76.48 N:0'}
G[-680863]={'863:53.08,54.26 N:0'}
G[-680862]={'862:27.86,5.76 N:0'}
G[-680680]={'680:37.54,55.59 N:0'}
G[-680650]={'650:43.41,72.52 N:0'}
G[-680646]={'646:49.26,67.01 N:0'}
G[-680641]={'641:74.10,54.17 N:0'}
G[-680634]={'634:40.58,72.20 N:0'}
G[-680630]={'630:53.28,43.77 N:0'}
G[-671355]={'1355:53.44,24.04 N:0'}
G[-670942]={'942:22.54,73.02 N:0'}
G[-670896]={'896:71.36,59.18 N:0'}
G[-670895]={'895:90.30,77.13 N:0'}
G[-670864]={'864:90.36,62.34 N:0'}
G[-670863]={'863:24.65,4.80 N:0'}
G[-670862]={'862:65.29,10.19 N:0'}
G[-670680]={'680:49.00,58.26 N:0'}
G[-670650]={'650:84.24,75.70 N:0'}
G[-670646]={'646:45.32,67.67 N:0'}
G[-670641]={'641:90.49,38.65 N:0'}
G[-670634]={'634:62.59,80.52 N:0'}
G[-670630]={'630:62.01,40.97 N:0'}
G[-661355]={'1355:70.32,50.58 N:0'}
G[-660942]={'942:77.18,29.19 N:0'}
G[-660896]={'896:50.76,29.95 N:0'}
G[-660895]={'895:86.13,38.58 N:0'}
G[-660864]={'864:95.25,61.55 N:0'}
G[-660863]={'863:3.88,16.91 N:0'}
G[-660862]={'862:48.44,34.97 N:0'}
G[-660680]={'680:1.61,54.56 N:0'}
G[-660650]={'650:37.34,41.07 N:0'}
G[-660646]={'646:43.47,36.73 N:0'}
G[-660641]={'641:99.62,98.71 N:0'}
G[-660634]={'634:7.02,42.34 N:0'}
G[-660630]={'630:78.83,57.25 N:0'}
G[-651355]={'1355:28.00,31.45 N:0'}
G[-650942]={'942:67.02,41.99 N:0'}
G[-650896]={'896:23.51,54.71 N:0'}
G[-650895]={'895:71.97,81.28 N:0'}
G[-650864]={'864:31.00,80.99 N:0'}
G[-650863]={'863:73.51,61.94 N:0'}
G[-650862]={'862:43.37,39.44 N:0'}
G[-650680]={'680:61.05,39.49 N:0'}
G[-650650]={'650:82.53,75.17 N:0'}
G[-650646]={'646:60.46,26.56 N:0'}
G[-650641]={'641:72.27,81.40 N:0'}
G[-650634]={'634:16.21,99.10 N:0'}
G[-650630]={'630:86.79,10.43 N:0'}
G[-641355]={'1355:42.72,77.73 N:0'}
G[-640942]={'942:70.61,85.94 N:0'}
G[-640896]={'896:22.71,49.40 N:0'}
G[-640895]={'895:41.03,29.33 N:0'}
G[-640864]={'864:83.94,95.13 N:0'}
G[-640863]={'863:48.53,98.40 N:0'}
G[-640862]={'862:57.94,48.98 N:0'}
G[-640680]={'680:6.09,96.24 N:0'}
G[-640650]={'650:70.86,97.16 N:0'}
G[-640646]={'646:46.35,20.76 N:0'}
G[-640641]={'641:90.38,38.81 N:0'}
G[-640634]={'634:7.92,97.94 N:0'}
G[-640630]={'630:92.74,17.94 N:0'}
G[-631355]={'1355:59.58,41.90 N:0'}
G[-630942]={'942:60.75,52.80 N:0'}
G[-630896]={'896:63.74,29.69 N:0'}
G[-630895]={'895:59.70,32.99 N:0'}
G[-630864]={'864:65.74,66.77 N:0'}
G[-630863]={'863:35.96,76.04 N:0'}
G[-630862]={'862:8.31,2.71 N:0'}
G[-630680]={'680:21.80,42.67 N:0'}
G[-630650]={'650:43.33,72.65 N:0'}
G[-630646]={'646:63.97,15.19 N:0'}
G[-630641]={'641:91.32,97.38 N:0'}
G[-630634]={'634:83.92,9.00 N:0'}
G[-630630]={'630:55.09,29.50 N:0'}
G[-630062]={'62:40.48,84.28 N:0'}
G[-621355]={'1355:38.67,20.17 N:0'}
G[-620942]={'942:58.46,92.81 N:0'}
G[-620896]={'896:80.60,57.98 N:0'}
G[-620895]={'895:40.36,42.85 N:0'}
G[-620864]={'864:64.01,47.35 N:0'}
G[-620863]={'863:55.44,57.71 N:0'}
G[-620862]={'862:72.37,0.38 N:0'}
G[-620680]={'680:16.45,92.92 N:0'}
G[-620650]={'650:55.79,53.61 N:0'}
G[-620646]={'646:64.07,15.19 N:0'}
G[-620641]={'641:47.77,95.99 N:0'}
G[-620634]={'634:22.20,19.16 N:0'}
G[-620630]={'630:84.76,14.66 N:0'}
G[-620062]={'62:43.65,28.86 N:0'}
G[-611355]={'1355:42.72,77.73 N:0'}
G[-610942]={'942:61.56,56.81 N:0'}
G[-610896]={'896:18.46,56.49 N:0'}
G[-610895]={'895:15.42,52.97 N:0'}
G[-610864]={'864:94.63,37.86 N:0'}
G[-610863]={'863:61.78,56.68 N:0'}
G[-610862]={'862:39.66,36.80 N:0'}
G[-610680]={'680:45.86,56.67 N:0'}
G[-610650]={'650:23.26,74.05 N:0'}
G[-610646]={'646:64.07,15.34 N:0'}
G[-610641]={'641:64.63,40.61 N:0'}
G[-610634]={'634:77.08,54.05 N:0'}
G[-610630]={'630:84.70,14.62 N:0'}
G[-610062]={'62:38.47,76.26 N:0'}
G[-601355]={'1355:45.11,22.14 N:0'}
G[-600942]={'942:45.12,73.49 N:0'}
G[-600896]={'896:31.83,24.38 N:0'}
G[-600895]={'895:12.43,41.74 N:0'}
G[-600864]={'864:35.30,79.34 N:0'}
G[-600863]={'863:81.68,61.08 N:0'}
G[-600862]={'862:53.23,44.51 N:0'}
G[-600680]={'680:52.92,65.58 N:0'}
G[-600650]={'650:3.56,81.73 N:0'}
G[-600646]={'646:7.24,27.31 N:0'}
G[-600641]={'641:55.12,96.34 N:0'}
G[-600634]={'634:30.41,82.54 N:0'}
G[-600630]={'630:78.84,57.22 N:0'}
G[-600062]={'62:45.49,58.46 N:0'}
G[-591355]={'1355:67.86,21.12 N:0'}
G[-590942]={'942:62.02,63.63 N:0'}
G[-590896]={'896:29.28,69.03 N:0'}
G[-590895]={'895:41.37,34.59 N:0'}
G[-590864]={'864:85.35,57.10 N:0'}
G[-590863]={'863:23.51,63.45 N:0'}
G[-590862]={'862:56.87,23.01 N:0'}
G[-590680]={'680:8.24,79.30 N:0'}
G[-590650]={'650:71.73,65.86 N:0'}
G[-590646]={'646:63.86,15.50 N:0'}
G[-590641]={'641:39.35,50.47 N:0'}
G[-590634]={'634:41.63,34.07 N:0'}
G[-590630]={'630:30.76,45.43 N:0'}
G[-590062]={'62:46.32,85.79 N:0'}
G[-581355]={'1355:53.34,24.18 N:0'}
G[-580942]={'942:71.53,54.20 N:0'}
G[-580896]={'896:65.00,21.51 N:0'}
G[-580895]={'895:75.06,22.51 N:0'}
G[-580864]={'864:50.21,81.61 N:0'}
G[-580863]={'863:21.26,38.27 N:0'}
G[-580862]={'862:49.07,9.13 N:0'}
G[-580680]={'680:43.45,61.69 N:0'}
G[-580650]={'650:44.71,22.63 N:0'}
G[-580646]={'646:7.26,27.46 N:0'}
G[-580641]={'641:75.46,84.36 N:0'}
G[-580634]={'634:4.56,42.13 N:0'}
G[-580630]={'630:37.24,43.02 N:0'}
G[-580062]={'62:43.65,53.19 N:0'}
G[-571355]={'1355:63.80,57.02 N:0'}
G[-570942]={'942:33.23,38.29 N:0'}
G[-570896]={'896:34.70,19.75 N:0'}
G[-570895]={'895:42.73,57.80 N:0'}
G[-570864]={'864:30.56,61.82 N:0'}
G[-570863]={'863:60.98,25.96 N:0'}
G[-570862]={'862:78.13,55.54 N:0'}
G[-570680]={'680:43.38,61.64 N:0'}
G[-570650]={'650:41.30,72.48 N:0'}
G[-570646]={'646:7.29,27.42 N:0'}
G[-570641]={'641:87.78,38.60 N:0'}
G[-570634]={'634:3.64,13.86 N:0'}
G[-570630]={'630:63.51,41.06 N:0'}
G[-570062]={'62:47.82,55.45 N:0'}
G[-561355]={'1355:66.92,35.75 N:0'}
G[-560942]={'942:42.55,76.69 N:0'}
G[-560896]={'896:38.07,49.06 N:0'}
G[-560895]={'895:44.89,67.17 N:0'}
G[-560864]={'864:58.68,41.52 N:0'}
G[-560863]={'863:48.95,50.91 N:0'}
G[-560862]={'862:13.38,12.77 N:0'}
G[-560680]={'680:35.09,40.92 N:0'}
G[-560650]={'650:40.56,49.26 N:0'}
G[-560646]={'646:55.52,53.76 N:0'}
G[-560641]={'641:86.82,8.81 N:0'}
G[-560634]={'634:15.88,98.97 N:0'}
G[-560630]={'630:86.87,10.54 N:0'}
G[-560062]={'62:40.82,84.79 N:0'}
G[-551355]={'1355:39.42,21.22 N:0'}
G[-550942]={'942:56.13,64.30 N:0'}
G[-550896]={'896:59.73,19.65 N:0'}
G[-550895]={'895:75.06,22.51 N:0'}
G[-550864]={'864:43.75,86.32 N:0'}
G[-550863]={'863:3.37,82.70 N:0'}
G[-550862]={'862:55.99,24.14 N:0'}
G[-550680]={'680:18.23,93.02 N:0'}
G[-550650]={'650:36.65,16.14 N:0'}
G[-550646]={'646:54.08,32.92 N:0'}
G[-550641]={'641:99.71,98.47 N:0'}
G[-550634]={'634:51.90,33.40 N:0'}
G[-550630]={'630:98.28,14.87 N:0'}
G[-550062]={'62:43.82,48.67 N:0'}
G[-541355]={'1355:40.47,77.31 N:0'}
G[-540942]={'942:27.91,59.70 N:0'}
G[-540896]={'896:22.16,30.26 N:0'}
G[-540895]={'895:71.18,18.38 N:0'}
G[-540864]={'864:47.11,39.01 N:0'}
G[-540863]={'863:73.95,10.71 N:0'}
G[-540862]={'862:44.00,76.36 N:0'}
G[-540680]={'680:45.95,56.80 N:0'}
G[-540650]={'650:33.70,20.34 N:0'}
G[-540646]={'646:81.40,44.78 N:0'}
G[-540641]={'641:60.51,31.33 N:0'}
G[-540634]={'634:5.57,83.91 N:0'}
G[-540630]={'630:53.28,16.17 N:0'}
G[-540062]={'62:33.62,84.05 N:0'}
G[-531355]={'1355:59.28,24.21 N:0'}
G[-530942]={'942:41.92,28.37 N:0'}
G[-530896]={'896:21.79,22.45 N:0'}
G[-530895]={'895:55.09,32.45 N:0'}
G[-530864]={'864:80.77,47.77 N:0'}
G[-530863]={'863:14.35,30.70 N:0'}
G[-530862]={'862:41.34,1.31 N:0'}
G[-530680]={'680:59.50,61.93 N:0'}
G[-530650]={'650:20.05,66.81 N:0'}
G[-530646]={'646:58.76,28.30 N:0'}
G[-530641]={'641:39.33,50.38 N:0'}
G[-530634]={'634:78.51,57.26 N:0'}
G[-530630]={'630:46.91,41.43 N:0'}
G[-530062]={'62:43.82,58.21 N:0'}
G[-521355]={'1355:37.21,19.29 N:0'}
G[-520942]={'942:73.08,32.37 N:0'}
G[-520896]={'896:64.93,54.11 N:0'}
G[-520895]={'895:16.68,63.49 N:0'}
G[-520864]={'864:84.54,92.84 N:0'}
G[-520863]={'863:81.85,30.90 N:0'}
G[-520862]={'862:16.84,11.44 N:0'}
G[-520680]={'680:34.39,25.63 N:0'}
G[-520650]={'650:3.54,81.67 N:0'}
G[-520646]={'646:57.80,45.04 N:0'}
G[-520641]={'641:59.67,31.49 N:0'}
G[-520634]={'634:56.12,40.92 N:0'}
G[-520630]={'630:84.71,14.62 N:0'}
G[-520062]={'62:58.51,24.33 N:0'}
G[-511355]={'1355:44.25,78.82 N:0'}
G[-510942]={'942:47.22,65.83 N:0'}
G[-510896]={'896:98.56,77.66 N:0'}
G[-510895]={'895:59.98,47.00 N:0'}
G[-510864]={'864:36.16,43.65 N:0'}
G[-510863]={'863:43.01,38.81 N:0'}
G[-510862]={'862:28.84,13.26 N:0'}
G[-510680]={'680:6.09,63.47 N:0'}
G[-510650]={'650:19.40,66.94 N:0'}
G[-510646]={'646:48.04,16.93 N:0'}
G[-510641]={'641:30.47,62.42 N:0'}
G[-510634]={'634:15.97,99.10 N:0'}
G[-510630]={'630:88.22,22.79 N:0'}
G[-510062]={'62:61.41,9.21 N:0'}
G[-501355]={'1355:59.51,13.80 N:0'}
G[-500942]={'942:62.88,32.79 N:0'}
G[-500896]={'896:25.48,41.09 N:0'}
G[-500895]={'895:78.89,53.65 N:0'}
G[-500864]={'864:57.23,73.27 N:0'}
G[-500863]={'863:68.43,94.00 N:0'}
G[-500862]={'862:58.60,74.18 N:0'}
G[-500680]={'680:43.40,61.64 N:0'}
G[-500650]={'650:80.15,65.31 N:0'}
G[-500646]={'646:43.46,36.78 N:0'}
G[-500641]={'641:88.85,82.59 N:0'}
G[-500634]={'634:4.90,69.28 N:0'}
G[-500630]={'630:92.73,17.87 N:0'}
G[-500062]={'62:35.62,81.78 N:0'}
G[-491355]={'1355:83.92,35.96 N:0'}
G[-490942]={'942:30.72,74.89 N:0'}
G[-490896]={'896:58.58,10.55 N:0'}
G[-490895]={'895:20.48,39.93 N:0'}
G[-490864]={'864:66.42,55.12 N:0'}
G[-490863]={'863:68.48,35.01 N:0'}
G[-490862]={'862:23.64,17.05 N:0'}
G[-490680]={'680:86.50,0.70 N:0'}
G[-490650]={'650:83.62,71.48 N:0'}
G[-490646]={'646:66.34,17.32 N:0'}
G[-490641]={'641:99.80,98.60 N:0'}
G[-490634]={'634:54.76,45.42 N:0'}
G[-490630]={'630:49.93,41.52 N:0'}
G[-490062]={'62:62.20,9.30 N:0'}
G[-481355]={'1355:75.83,48.40 N:0'}
G[-480942]={'942:47.20,65.83 N:0'}
G[-480896]={'896:21.62,26.58 N:0'}
G[-480895]={'895:76.33,7.62 N:0'}
G[-480864]={'864:45.09,46.18 N:0'}
G[-480863]={'863:47.90,97.26 N:0'}
G[-480862]={'862:49.09,29.21 N:0'}
G[-480680]={'680:70.32,8.94 N:0'}
G[-480650]={'650:41.59,94.76 N:0'}
G[-480646]={'646:33.12,33.35 N:0'}
G[-480641]={'641:88.15,67.18 N:0'}
G[-480634]={'634:12.40,37.69 N:0'}
G[-480630]={'630:87.08,10.20 N:0'}
G[-480062]={'62:38.14,44.91 N:0'}
G[-471355]={'1355:77.75,27.87 N:0'}
G[-470942]={'942:27.19,97.18 N:0'}
G[-470896]={'896:82.70,15.28 N:0'}
G[-470895]={'895:22.56,74.80 N:0'}
G[-470864]={'864:94.56,93.61 N:0'}
G[-470863]={'863:72.14,40.64 N:0'}
G[-470862]={'862:69.21,20.28 N:0'}
G[-470680]={'680:0.53,41.70 N:0'}
G[-470650]={'650:47.74,68.83 N:0'}
G[-470646]={'646:53.46,14.86 N:0'}
G[-470641]={'641:96.04,33.91 N:0'}
G[-470634]={'634:39.28,53.30 N:0'}
G[-470630]={'630:63.04,41.06 N:0'}
G[-470062]={'62:67.22,18.58 N:0'}
G[-461355]={'1355:75.32,24.56 N:0'}
G[-460942]={'942:49.46,37.10 N:0'}
G[-460896]={'896:57.71,28.02 N:0'}
G[-460895]={'895:14.95,33.62 N:0'}
G[-460864]={'864:88.39,88.08 N:0'}
G[-460863]={'863:77.57,45.18 N:0'}
G[-460862]={'862:56.48,22.30 N:0'}
G[-460680]={'680:47.56,71.33 N:0'}
G[-460650]={'650:82.50,75.17 N:0'}
G[-460646]={'646:73.02,30.25 N:0'}
G[-460641]={'641:54.03,83.38 N:0'}
G[-460634]={'634:84.94,11.43 N:0'}
G[-460630]={'630:51.30,41.63 N:0'}
G[-460062]={'62:69.22,19.07 N:0'}
G[-451355]={'1355:45.54,29.70 N:0'}
G[-450942]={'942:48.58,64.74 N:0'}
G[-450896]={'896:59.02,17.35 N:0'}
G[-450895]={'895:58.36,50.40 N:0'}
G[-450882]={'882:34.86,37.46 N:0'}
G[-450864]={'864:86.10,69.88 N:0'}
G[-450863]={'863:12.47,71.87 N:0'}
G[-450862]={'862:34.49,6.54 N:0'}
G[-450680]={'680:52.91,65.50 N:0'}
G[-450650]={'650:69.80,81.64 N:0'}
G[-450646]={'646:49.02,55.52 N:0'}
G[-450641]={'641:39.35,50.41 N:0'}
G[-450634]={'634:72.95,69.56 N:0'}
G[-450630]={'630:88.99,32.46 N:0'}
G[-450062]={'62:52.31,32.13 N:0'}
G[-441355]={'1355:62.54,51.82 N:0'}
G[-440942]={'942:50.02,79.26 N:0'}
G[-440896]={'896:32.02,24.25 N:0'}
G[-440895]={'895:50.69,27.04 N:0'}
G[-440882]={'882:55.18,63.87 N:0'}
G[-440864]={'864:40.76,74.96 N:0'}
G[-440863]={'863:82.08,77.27 N:0'}
G[-440862]={'862:77.68,9.89 N:0'}
G[-440680]={'680:63.01,60.66 N:0'}
G[-440650]={'650:43.20,7.54 N:0'}
G[-440646]={'646:31.04,60.45 N:0'}
G[-440641]={'641:99.76,43.71 N:0'}
G[-440634]={'634:38.34,27.17 N:0'}
G[-440630]={'630:37.11,83.51 N:0'}
G[-440062]={'62:40.48,82.54 N:0'}
G[-431355]={'1355:78.81,42.43 N:0'}
G[-430942]={'942:59.45,91.89 N:0'}
G[-430896]={'896:60.78,47.34 N:0'}
G[-430895]={'895:49.89,68.81 N:0'}
G[-430882]={'882:57.48,30.37 N:0'}
G[-430864]={'864:53.53,34.93 N:0'}
G[-430863]={'863:24.39,48.35 N:0'}
G[-430862]={'862:64.53,22.92 N:0'}
G[-430680]={'680:2.11,93.56 N:0'}
G[-430650]={'650:3.56,81.69 N:0'}
G[-430646]={'646:59.24,45.53 N:0'}
G[-430641]={'641:64.39,60.62 N:0'}
G[-430634]={'634:15.93,46.99 N:0'}
G[-430630]={'630:86.79,10.54 N:0'}
G[-430062]={'62:37.97,76.02 N:0'}
G[-430014]={'14:30.71,44.82 N:0'}
G[-421355]={'1355:41.64,23.68 N:0'}
G[-420942]={'942:34.82,47.80 N:0'}
G[-420896]={'896:34.70,69.30 N:0'}
G[-420895]={'895:41.77,76.80 N:0'}
G[-420882]={'882:44.50,71.65 N:0'}
G[-420864]={'864:55.94,53.52 N:0'}
G[-420863]={'863:60.89,98.26 N:0'}
G[-420862]={'862:59.57,18.47 N:0'}
G[-420680]={'680:45.92,2.35 N:0'}
G[-420650]={'650:97.42,94.99 N:0'}
G[-420646]={'646:31.17,61.61 N:0'}
G[-420641]={'641:56.24,65.28 N:0'}
G[-420634]={'634:16.21,98.72 N:0'}
G[-420630]={'630:43.28,56.06 N:0'}
G[-420062]={'62:61.04,18.58 N:0'}
G[-420014]={'14:21.34,21.97 N:0'}
G[-411355]={'1355:35.08,48.69 N:0'}
G[-410942]={'942:56.12,64.27 N:0'}
G[-410896]={'896:63.57,59.44 N:0'}
G[-410895]={'895:50.34,60.33 N:0'}
G[-410882]={'882:37.16,43.90 N:0'}
G[-410864]={'864:77.51,38.46 N:0'}
G[-410863]={'863:52.89,91.09 N:0'}
G[-410862]={'862:57.73,3.81 N:0'}
G[-410680]={'680:80.98,63.50 N:0'}
G[-410650]={'650:69.02,60.19 N:0'}
G[-410646]={'646:55.10,50.56 N:0'}
G[-410641]={'641:99.71,98.60 N:0'}
G[-410634]={'634:17.81,37.48 N:0'}
G[-410630]={'630:65.61,41.02 N:0'}
G[-410062]={'62:54.34,8.79 N:0'}
G[-410014]={'14:29.88,60.00 N:0'}
G[-401355]={'1355:31.28,37.54 N:0'}
G[-400942]={'942:31.30,61.60 N:0'}
G[-400896]={'896:24.87,16.09 N:0'}
G[-400895]={'895:57.59,26.50 N:0'}
G[-400882]={'882:46.98,66.13 N:0'}
G[-400864]={'864:70.44,76.86 N:0'}
G[-400863]={'863:49.92,67.48 N:0'}
G[-400862]={'862:40.50,68.35 N:0'}
G[-400680]={'680:46.20,56.40 N:0'}
G[-400650]={'650:50.64,76.47 N:0'}
G[-400646]={'646:31.10,59.96 N:0'}
G[-400641]={'641:59.87,31.95 N:0'}
G[-400634]={'634:51.42,55.34 N:0'}
G[-400630]={'630:96.98,14.75 N:0'}
G[-400062]={'62:49.50,24.84 N:0'}
G[-400014]={'14:65.31,70.79 N:0'}
G[-391355]={'1355:36.39,11.48 N:0'}
G[-390942]={'942:38.43,63.69 N:0'}
G[-390896]={'896:71.06,7.60 N:0'}
G[-390895]={'895:76.36,7.64 N:0'}
G[-390882]={'882:52.90,66.96 N:0'}
G[-390864]={'864:59.87,60.96 N:0'}
G[-390863]={'863:68.01,29.16 N:0'}
G[-390862]={'862:69.25,32.64 N:0'}
G[-390680]={'680:10.81,19.12 N:0'}
G[-390650]={'650:52.18,68.66 N:0'}
G[-390646]={'646:58.60,28.37 N:0'}
G[-390641]={'641:93.65,23.21 N:0'}
G[-390634]={'634:39.89,28.20 N:0'}
G[-390630]={'630:61.39,43.12 N:0'}
G[-390062]={'62:41.82,76.77 N:0'}
G[-390014]={'14:46.24,52.07 N:0'}
G[-381355]={'1355:61.46,24.07 N:0'}
G[-380942]={'942:70.77,85.33 N:0'}
G[-380896]={'896:80.98,37.77 N:0'}
G[-380895]={'895:25.04,60.07 N:0'}
G[-380882]={'882:23.53,38.93 N:0'}
G[-380864]={'864:93.44,88.61 N:0'}
G[-380863]={'863:7.67,22.16 N:0'}
G[-380862]={'862:81.01,40.08 N:0'}
G[-380680]={'680:83.00,11.07 N:0'}
G[-380650]={'650:23.07,89.64 N:0'}
G[-380646]={'646:82.09,48.07 N:0'}
G[-380641]={'641:37.95,52.59 N:0'}
G[-380634]={'634:62.26,57.26 N:0'}
G[-380630]={'630:56.41,66.79 N:0'}
G[-380062]={'62:43.32,19.32 N:0'}
G[-380014]={'14:57.37,44.39 N:0'}
G[-371355]={'1355:38.01,55.75 N:0'}
G[-370942]={'942:30.63,57.58 N:0'}
G[-370896]={'896:70.03,61.56 N:0'}
G[-370895]={'895:23.66,29.59 N:0'}
G[-370885]={'885:71.95,69.02 N:0'}
G[-370882]={'882:39.59,54.76 N:0'}
G[-370864]={'864:37.57,89.19 N:0'}
G[-370863]={'863:10.79,46.26 N:0'}
G[-370862]={'862:21.23,7.91 N:0'}
G[-370680]={'680:17.68,93.02 N:0'}
G[-370650]={'650:79.76,83.32 N:0'}
G[-370646]={'646:41.25,77.84 N:0'}
G[-370641]={'641:67.27,73.79 N:0'}
G[-370634]={'634:73.50,40.61 N:0'}
G[-370630]={'630:59.18,41.73 N:0'}
G[-370062]={'62:47.48,44.66 N:0'}
G[-370014]={'14:62.90,81.09 N:0'}
G[-361355]={'1355:35.45,34.87 N:0'}
G[-360942]={'942:78.49,27.00 N:0'}
G[-360896]={'896:83.07,33.37 N:0'}
G[-360895]={'895:52.07,67.98 N:0'}
G[-360885]={'885:71.74,50.36 N:0'}
G[-360882]={'882:35.90,53.98 N:0'}
G[-360864]={'864:85.56,43.98 N:0'}
G[-360863]={'863:38.78,26.73 N:0'}
G[-360862]={'862:59.69,56.60 N:0'}
G[-360680]={'680:94.33,13.07 N:0'}
G[-360650]={'650:70.30,61.04 N:0'}
G[-360646]={'646:54.13,65.01 N:0'}
G[-360641]={'641:67.66,31.86 N:0'}
G[-360634]={'634:15.88,99.10 N:0'}
G[-360630]={'630:44.88,83.47 N:0'}
G[-360062]={'62:44.65,43.91 N:0'}
G[-360014]={'14:62.12,31.45 N:0'}
G[-351355]={'1355:42.60,77.84 N:0'}
G[-350942]={'942:70.98,32.15 N:0'}
G[-350896]={'896:76.74,14.58 N:0'}
G[-350895]={'895:58.74,15.35 N:0'}
G[-350885]={'885:61.80,37.03 N:0'}
G[-350882]={'882:38.08,64.38 N:0'}
G[-350864]={'864:59.49,8.36 N:0'}
G[-350863]={'863:29.60,76.53 N:0'}
G[-350862]={'862:68.03,33.86 N:0'}
G[-350680]={'680:3.73,93.70 N:0'}
G[-350650]={'650:88.65,84.89 N:0'}
G[-350646]={'646:50.96,42.31 N:0'}
G[-350641]={'641:67.35,38.79 N:0'}
G[-350634]={'634:17.71,37.48 N:0'}
G[-350630]={'630:32.25,29.67 N:0'}
G[-350062]={'62:50.83,31.87 N:0'}
G[-350014]={'14:18.69,28.22 N:0'}
G[-341355]={'1355:36.25,72.21 N:0'}
G[-340942]={'942:31.61,55.28 N:0'}
G[-340896]={'896:27.11,54.68 N:0'}
G[-340895]={'895:75.09,11.95 N:0'}
G[-340885]={'885:60.74,48.37 N:0'}
G[-340882]={'882:31.79,31.11 N:0'}
G[-340864]={'864:83.59,74.65 N:0'}
G[-340863]={'863:15.90,55.91 N:0'}
G[-340862]={'862:45.12,9.43 N:0'}
G[-340680]={'680:2.73,23.74 N:0'}
G[-340650]={'650:16.72,93.27 N:0'}
G[-340646]={'646:53.81,14.75 N:0'}
G[-340641]={'641:42.62,51.25 N:0'}
G[-340634]={'634:10.12,27.53 N:0'}
G[-340630]={'630:57.20,16.72 N:0'}
G[-340062]={'62:37.65,84.54 N:0'}
G[-340014]={'14:14.55,36.59 N:0'}
G[-331355]={'1355:41.83,41.34 N:0'}
G[-330942]={'942:64.98,50.76 N:0'}
G[-330896]={'896:59.54,71.88 N:0'}
G[-330895]={'895:48.94,37.04 N:0'}
G[-330885]={'885:61.45,20.80 N:0'}
G[-330882]={'882:64.44,28.58 N:0'}
G[-330864]={'864:77.25,94.71 N:0'}
G[-330863]={'863:59.44,91.78 N:0'}
G[-330862]={'862:63.63,18.90 N:0'}
G[-330680]={'680:48.47,82.81 N:0'}
G[-330650]={'650:97.88,71.23 N:0'}
G[-330646]={'646:50.78,41.73 N:0'}
G[-330641]={'641:38.26,61.57 N:0'}
G[-330634]={'634:66.20,47.78 N:0'}
G[-330630]={'630:60.61,71.54 N:0'}
G[-330062]={'62:58.19,23.85 N:0'}
G[-330014]={'14:42.73,56.42 N:0'}
G[-321355]={'1355:64.88,36.66 N:0'}
G[-320942]={'942:69.40,51.58 N:0'}
G[-320896]={'896:70.61,50.60 N:0'}
G[-320895]={'895:57.73,46.77 N:0'}
G[-320885]={'885:57.53,15.64 N:0'}
G[-320882]={'882:67.58,43.81 N:0'}
G[-320864]={'864:95.47,68.29 N:0'}
G[-320863]={'863:49.22,33.90 N:0'}
G[-320862]={'862:67.14,33.42 N:0'}
G[-320680]={'680:45.86,56.80 N:0'}
G[-320650]={'650:19.55,67.30 N:0'}
G[-320646]={'646:38.60,46.63 N:0'}
G[-320641]={'641:57.38,54.53 N:0'}
G[-320634]={'634:48.45,21.25 N:0'}
G[-320630]={'630:67.27,26.95 N:0'}
G[-320062]={'62:41.65,76.51 N:0'}
G[-320014]={'14:57.29,54.31 N:0'}
G[-311355]={'1355:68.33,49.81 N:0'}
G[-310942]={'942:64.04,99.40 N:0'}
G[-310896]={'896:79.99,6.89 N:0'}
G[-310895]={'895:39.45,47.44 N:0'}
G[-310885]={'885:55.30,21.59 N:0'}
G[-310882]={'882:43.15,48.46 N:0'}
G[-310864]={'864:63.27,23.37 N:0'}
G[-310863]={'863:46.66,73.67 N:0'}
G[-310862]={'862:18.67,19.36 N:0'}
G[-310680]={'680:20.72,92.97 N:0'}
G[-310650]={'650:52.10,68.66 N:0'}
G[-310646]={'646:47.13,69.85 N:0'}
G[-310641]={'641:40.67,60.32 N:0'}
G[-310634]={'634:38.74,54.78 N:0'}
G[-310630]={'630:46.00,16.07 N:0'}
G[-310062]={'62:40.14,61.48 N:0'}
G[-310014]={'14:52.02,76.65 N:0'}
G[-301355]={'1355:33.25,40.00 N:0'}
G[-301161]={'1161:79.96,96.95 N:0'}
G[-300942]={'942:59.04,55.81 N:0'}
G[-300896]={'896:37.91,50.26 N:0'}
G[-300895]={'895:17.01,66.97 N:0'}
G[-300885]={'885:73.71,49.03 N:0'}
G[-300882]={'882:69.63,52.00 N:0'}
G[-300864]={'864:52.66,15.73 N:0'}
G[-300863]={'863:38.44,99.69 N:0'}
G[-300862]={'862:64.26,32.51 N:0'}
G[-300830]={'830:33.78,72.27 N:0'}
G[-300680]={'680:57.95,61.80 N:0'}
G[-300650]={'650:45.87,60.49 N:0'}
G[-300646]={'646:38.27,60.08 N:0'}
G[-300641]={'641:34.14,60.32 N:0'}
G[-300634]={'634:55.41,42.60 N:0'}
G[-300630]={'630:51.14,37.12 N:0'}
G[-300062]={'62:39.47,33.13 N:0'}
G[-300014]={'14:25.16,48.49 N:0'}
G[-291355]={'1355:60.61,50.94 N:0'}
G[-291161]={'1161:65.30,79.64 N:0'}
G[-290942]={'942:41.32,73.97 N:0'}
G[-290896]={'896:36.13,10.89 N:0'}
G[-290895]={'895:62.65,23.18 N:0'}
G[-290885]={'885:64.03,66.06 N:0'}
G[-290882]={'882:74.54,35.98 N:0'}
G[-290864]={'864:53.98,60.67 N:0'}
G[-290863]={'863:62.07,65.42 N:0'}
G[-290862]={'862:55.71,7.66 N:0'}
G[-290830]={'830:38.31,60.24 N:0'}
G[-290680]={'680:49.51,72.54 N:0'}
G[-290650]={'650:2.47,83.38 N:0'}
G[-290646]={'646:53.75,65.76 N:0'}
G[-290641]={'641:49.49,77.09 N:0'}
G[-290634]={'634:44.20,67.64 N:0'}
G[-290630]={'630:54.30,44.40 N:0'}
G[-290062]={'62:57.00,15.31 N:0'}
G[-290014]={'14:49.06,84.20 N:0'}
G[-281355]={'1355:56.16,28.89 N:0'}
G[-281161]={'1161:21.93,14.08 N:0'}
G[-280942]={'942:70.81,85.36 N:0'}
G[-280896]={'896:72.84,60.49 N:0'}
G[-280895]={'895:26.94,50.44 N:0'}
G[-280885]={'885:59.68,39.99 N:0'}
G[-280882]={'882:59.87,70.96 N:0'}
G[-280864]={'864:84.18,93.72 N:0'}
G[-280863]={'863:20.31,7.17 N:0'}
G[-280862]={'862:40.64,70.89 N:0'}
G[-280830]={'830:54.54,56.00 N:0'}
G[-280680]={'680:30.32,60.44 N:0'}
G[-280650]={'650:46.18,27.88 N:0'}
G[-280646]={'646:47.82,67.33 N:0'}
G[-280641]={'641:55.57,78.15 N:0'}
G[-280634]={'634:74.17,88.98 N:0'}
G[-280630]={'630:65.69,48.40 N:0'}
G[-280062]={'62:39.15,61.71 N:0'}
G[-280014]={'14:47.62,77.99 N:0'}
G[-271355]={'1355:61.15,28.78 N:0'}
G[-271161]={'1161:70.54,65.42 N:0'}
G[-270942]={'942:40.35,34.37 N:0'}
G[-270896]={'896:80.16,33.09 N:0'}
G[-270895]={'895:65.75,0.45 N:0'}
G[-270885]={'885:51.59,41.22 N:0'}
G[-270882]={'882:43.79,60.42 N:0'}
G[-270864]={'864:30.19,52.55 N:0'}
G[-270863]={'863:8.26,55.54 N:0'}
G[-270862]={'862:50.60,23.81 N:0'}
G[-270830]={'830:56.29,66.78 N:0'}
G[-270680]={'680:45.91,74.74 N:0'}
G[-270650]={'650:40.15,62.90 N:0'}
G[-270646]={'646:49.11,55.55 N:0'}
G[-270641]={'641:48.92,39.78 N:0'}
G[-270634]={'634:61.87,90.26 N:0'}
G[-270630]={'630:64.19,19.32 N:0'}
G[-270062]={'62:36.47,82.80 N:0'}
G[-270014]={'14:51.16,40.08 N:0'}
G[-261355]={'1355:53.44,23.68 N:0'}
G[-261161]={'1161:73.44,17.34 N:0'}
G[-260942]={'942:59.89,45.85 N:0'}
G[-260896]={'896:68.80,20.51 N:0'}
G[-260895]={'895:70.64,0.35 N:0'}
G[-260885]={'885:53.33,51.99 N:0'}
G[-260882]={'882:33.51,47.90 N:0'}
G[-260864]={'864:37.44,85.11 N:0'}
G[-260863]={'863:47.43,98.40 N:0'}
G[-260862]={'862:66.67,32.21 N:0'}
G[-260830]={'830:49.72,16.84 N:0'}
G[-260680]={'680:47.36,75.28 N:0'}
G[-260650]={'650:44.67,9.95 N:0'}
G[-260646]={'646:66.67,29.60 N:0'}
G[-260641]={'641:65.79,51.78 N:0'}
G[-260634]={'634:59.87,42.16 N:0'}
G[-260630]={'630:56.26,16.53 N:0'}
G[-260062]={'62:41.14,35.89 N:0'}
G[-260014]={'14:35.63,64.19 N:0'}
G[-251355]={'1355:64.48,16.12 N:0'}
G[-251161]={'1161:68.20,22.10 N:0'}
G[-250942]={'942:69.15,90.99 N:0'}
G[-250896]={'896:56.54,33.95 N:0'}
G[-250895]={'895:58.03,76.14 N:0'}
G[-250885]={'885:56.06,28.69 N:0'}
G[-250882]={'882:24.98,57.11 N:0'}
G[-250864]={'864:59.47,61.16 N:0'}
G[-250863]={'863:27.17,39.46 N:0'}
G[-250862]={'862:65.27,2.54 N:0'}
G[-250830]={'830:43.04,60.20 N:0'}
G[-250680]={'680:20.46,44.67 N:0'}
G[-250650]={'650:25.57,42.29 N:0'}
G[-250646]={'646:79.17,40.87 N:0'}
G[-250641]={'641:50.23,46.54 N:0'}
G[-250634]={'634:60.90,68.12 N:0'}
G[-250630]={'630:48.27,25.15 N:0'}
G[-250062]={'62:57.35,15.57 N:0'}
G[-250014]={'14:67.55,60.91 N:0'}
G[-241355]={'1355:68.54,32.79 N:0'}
G[-241161]={'1161:81.80,89.09 N:0'}
G[-240942]={'942:51.29,55.55 N:0'}
G[-240896]={'896:27.54,59.18 N:0'}
G[-240895]={'895:14.63,38.21 N:0'}
G[-240885]={'885:57.71,17.31 N:0'}
G[-240882]={'882:23.58,38.94 N:0'}
G[-240864]={'864:68.56,48.28 N:0'}
G[-240863]={'863:28.16,33.84 N:0'}
G[-240862]={'862:39.92,71.08 N:0'}
G[-240830]={'830:34.59,68.03 N:0'}
G[-240680]={'680:31.22,69.18 N:0'}
G[-240650]={'650:46.44,60.98 N:0'}
G[-240646]={'646:51.60,42.16 N:0'}
G[-240641]={'641:39.98,90.56 N:0'}
G[-240634]={'634:69.19,45.91 N:0'}
G[-240630]={'630:56.91,63.49 N:0'}
G[-240062]={'62:56.52,30.37 N:0'}
G[-240014]={'14:56.91,34.65 N:0'}
G[-231355]={'1355:78.43,28.64 N:0'}
G[-231161]={'1161:79.74,96.53 N:0'}
G[-230942]={'942:37.34,72.30 N:0'}
G[-230896]={'896:86.52,2.60 N:0'}
G[-230895]={'895:33.13,26.23 N:0'}
G[-230885]={'885:71.77,68.40 N:0'}
G[-230882]={'882:64.54,56.32 N:0'}
G[-230864]={'864:69.32,43.94 N:0'}
G[-230863]={'863:15.38,56.17 N:0'}
G[-230862]={'862:56.18,23.01 N:0'}
G[-230830]={'830:58.28,29.72 N:0'}
G[-230680]={'680:59.74,60.84 N:0'}
G[-230650]={'650:43.79,58.09 N:0'}
G[-230646]={'646:38.56,60.16 N:0'}
G[-230641]={'641:65.13,59.18 N:0'}
G[-230634]={'634:55.39,26.06 N:0'}
G[-230630]={'630:35.36,50.36 N:0'}
G[-230062]={'62:44.00,80.78 N:0'}
G[-230014]={'14:50.18,40.55 N:0'}
G[-221355]={'1355:27.95,29.35 N:0'}
G[-221161]={'1161:90.05,73.03 N:0'}
G[-220942]={'942:47.80,95.43 N:0'}
G[-220896]={'896:48.37,6.55 N:0'}
G[-220895]={'895:43.74,35.89 N:0'}
G[-220885]={'885:65.59,26.05 N:0'}
G[-220882]={'882:46.94,66.15 N:0'}
G[-220864]={'864:78.09,55.89 N:0'}
G[-220863]={'863:40.46,30.53 N:0'}
G[-220862]={'862:18.56,16.08 N:0'}
G[-220830]={'830:66.65,72.63 N:0'}
G[-220680]={'680:27.64,22.70 N:0'}
G[-220650]={'650:51.06,42.48 N:0'}
G[-220646]={'646:49.30,67.62 N:0'}
G[-220641]={'641:25.98,66.45 N:0'}
G[-220634]={'634:45.20,78.82 N:0'}
G[-220630]={'630:32.62,54.44 N:0'}
G[-220543]={'543:56.01,6.68 N:0'}
G[-220062]={'62:40.97,55.96 N:0'}
G[-220014]={'14:26.74,32.70 N:0'}
G[-211355]={'1355:60.75,12.85 N:0'}
G[-211161]={'1161:31.68,64.08 N:0'}
G[-210942]={'942:50.02,72.12 N:0'}
G[-210896]={'896:40.37,37.82 N:0'}
G[-210895]={'895:20.59,35.42 N:0'}
G[-210885]={'885:57.36,33.42 N:0'}
G[-210882]={'882:32.47,41.01 N:0'}
G[-210864]={'864:27.41,50.23 N:0'}
G[-210863]={'863:39.52,49.34 N:0'}
G[-210862]={'862:81.80,37.65 N:0'}
G[-210830]={'830:51.50,63.59 N:0'}
G[-210680]={'680:44.93,75.98 N:0'}
G[-210650]={'650:40.07,13.57 N:0'}
G[-210646]={'646:45.15,47.95 N:0'}
G[-210641]={'641:64.72,74.56 N:0'}
G[-210634]={'634:71.16,47.51 N:0'}
G[-210630]={'630:58.99,72.96 N:0'}
G[-210543]={'543:59.62,33.29 N:0'}
G[-210062]={'62:33.19,83.26 N:0'}
G[-210014]={'14:53.32,57.55 N:0'}
G[-201355]={'1355:42.32,68.31 N:0'}
G[-201161]={'1161:90.44,76.04 N:0'}
G[-200942]={'942:31.90,31.52 N:0'}
G[-200896]={'896:62.09,19.02 N:0'}
G[-200895]={'895:57.82,55.88 N:0'}
G[-200885]={'885:56.53,54.06 N:0'}
G[-200882]={'882:36.70,44.22 N:0'}
G[-200864]={'864:59.71,61.11 N:0'}
G[-200863]={'863:68.73,57.60 N:0'}
G[-200862]={'862:50.26,54.33 N:0'}
G[-200830]={'830:69.97,66.62 N:0'}
G[-200680]={'680:32.78,79.79 N:0'}
G[-200650]={'650:28.96,41.60 N:0'}
G[-200646]={'646:66.90,45.43 N:0'}
G[-200641]={'641:57.37,80.66 N:0'}
G[-200634]={'634:75.87,90.12 N:0'}
G[-200630]={'630:66.04,47.09 N:0'}
G[-200627]={'627:28.59,22.18 N:0'}
G[-200543]={'543:68.63,34.22 N:0'}
G[-200062]={'62:50.86,19.08 N:0'}
G[-200014]={'14:52.97,60.05 N:0'}
G[-191355]={'1355:44.95,50.76 N:0'}
G[-191161]={'1161:31.46,63.92 N:0'}
G[-190942]={'942:56.96,75.98 N:0'}
G[-190896]={'896:32.16,18.42 N:0'}
G[-190895]={'895:73.23,39.04 N:0'}
G[-190885]={'885:73.59,72.15 N:0'}
G[-190882]={'882:57.45,30.23 N:0'}
G[-190864]={'864:72.77,60.85 N:0'}
G[-190863]={'863:15.69,56.11 N:0'}
G[-190862]={'862:39.50,36.80 N:0'}
G[-190830]={'830:29.66,57.86 N:0'}
G[-190680]={'680:45.85,42.58 N:0'}
G[-190650]={'650:45.78,14.06 N:0'}
G[-190646]={'646:53.53,74.56 N:0'}
G[-190641]={'641:51.13,76.22 N:0'}
G[-190634]={'634:78.04,73.51 N:0'}
G[-190630]={'630:45.55,32.96 N:0'}
G[-190627]={'627:28.71,22.91 N:0'}
G[-190543]={'543:57.00,35.88 N:0'}
G[-190062]={'62:32.71,84.62 N:0'}
G[-190014]={'14:79.35,29.12 N:0'}
G[-181355]={'1355:26.19,31.98 N:0'}
G[-181161]={'1161:73.83,17.34 N:0'}
G[-180942]={'942:65.38,60.07 N:0'}
G[-180896]={'896:80.28,44.85 N:0'}
G[-180895]={'895:85.50,43.19 N:0'}
G[-180885]={'885:77.96,67.41 N:0'}
G[-180882]={'882:58.69,29.34 N:0'}
G[-180864]={'864:47.67,20.20 N:0'}
G[-180863]={'863:32.63,55.77 N:0'}
G[-180862]={'862:47.92,54.22 N:0'}
G[-180830]={'830:44.79,77.88 N:0'}
G[-180680]={'680:18.90,23.61 N:0'}
G[-180650]={'650:36.72,44.31 N:0'}
G[-180646]={'646:79.02,41.06 N:0'}
G[-180641]={'641:52.28,6.50 N:0'}
G[-180634]={'634:79.00,57.81 N:0'}
G[-180630]={'630:39.73,48.13 N:0'}
G[-180627]={'627:28.83,22.73 N:0'}
G[-180543]={'543:46.38,92.46 N:0'}
G[-180062]={'62:38.01,26.91 N:0'}
G[-180014]={'14:27.41,31.50 N:0'}
G[-171355]={'1355:65.96,23.68 N:0'}
G[-171161]={'1161:74.50,17.84 N:0'}
G[-170942]={'942:63.34,75.85 N:0'}
G[-170896]={'896:28.87,27.23 N:0'}
G[-170895]={'895:18.04,42.24 N:0'}
G[-170885]={'885:66.14,52.99 N:0'}
G[-170882]={'882:62.54,46.11 N:0'}
G[-170864]={'864:58.68,41.41 N:0'}
G[-170863]={'863:0.07,3.06 N:0'}
G[-170862]={'862:74.03,28.17 N:0'}
G[-170830]={'830:42.86,52.00 N:0'}
G[-170680]={'680:30.07,35.57 N:0'}
G[-170650]={'650:52.21,79.81 N:0'}
G[-170646]={'646:45.78,67.64 N:0'}
G[-170641]={'641:48.17,66.91 N:0'}
G[-170634]={'634:44.27,48.01 N:0'}
G[-170630]={'630:37.13,8.68 N:0'}
G[-170627]={'627:40.19,24.55 N:0'}
G[-170543]={'543:43.10,65.92 N:0'}
G[-170542]={'542:71.80,34.57 N:0'}
G[-170062]={'62:43.94,75.97 N:0'}
G[-170014]={'14:61.89,31.07 N:0'}
G[-161355]={'1355:50.32,17.04 N:0'}
G[-161161]={'1161:51.42,61.16 N:0'}
G[-160942]={'942:65.96,74.63 N:0'}
G[-160896]={'896:89.01,18.37 N:0'}
G[-160895]={'895:64.58,35.38 N:0'}
G[-160885]={'885:71.83,68.81 N:0'}
G[-160882]={'882:52.91,70.00 N:0'}
G[-160864]={'864:75.25,59.92 N:0'}
G[-160863]={'863:14.35,30.56 N:0'}
G[-160862]={'862:27.87,19.31 N:0'}
G[-160830]={'830:34.40,67.18 N:0'}
G[-160680]={'680:47.46,81.97 N:0'}
G[-160650]={'650:58.81,69.39 N:0'}
G[-160646]={'646:45.68,59.13 N:0'}
G[-160641]={'641:46.36,74.57 N:0'}
G[-160634]={'634:56.54,30.20 N:0'}
G[-160630]={'630:63.77,28.50 N:0'}
G[-160627]={'627:40.23,23.73 N:0'}
G[-160543]={'543:60.88,53.39 N:0'}
G[-160542]={'542:60.45,12.34 N:0'}
G[-160062]={'62:42.08,66.86 N:0'}
G[-160014]={'14:32.93,38.53 N:0'}
G[-151462]={'1462:62.11,76.89 N:0'}
G[-151355]={'1355:77.47,43.76 N:0'}
G[-151161]={'1161:11.00,9.90 N:0'}
G[-150942]={'942:72.18,52.11 N:0'}
G[-150896]={'896:80.54,71.02 N:0'}
G[-150895]={'895:73.55,27.81 N:0'}
G[-150885]={'885:74.83,62.59 N:0'}
G[-150882]={'882:27.38,36.25 N:0'}
G[-150864]={'864:49.01,89.12 N:0'}
G[-150863]={'863:35.85,54.57 N:0'}
G[-150862]={'862:56.62,48.16 N:0'}
G[-150830]={'830:34.54,68.16 N:0'}
G[-150680]={'680:45.82,42.64 N:0'}
G[-150650]={'650:41.76,72.75 N:0'}
G[-150646]={'646:38.54,27.03 N:0'}
G[-150641]={'641:54.96,72.55 N:0'}
G[-150634]={'634:33.67,50.65 N:0'}
G[-150630]={'630:47.52,40.56 N:0'}
G[-150627]={'627:40.22,24.10 N:0'}
G[-150543]={'543:51.36,77.64 N:0'}
G[-150542]={'542:52.98,14.77 N:0'}
G[-150539]={'539:50.41,89.60 N:0'}
G[-150525]={'525:49.15,21.37 N:0'}
G[-150062]={'62:40.16,62.10 N:0'}
G[-150014]={'14:50.99,36.50 N:0'}
G[-141462]={'1462:80.85,18.88 N:0'}
G[-141355]={'1355:25.46,26.67 N:0'}
G[-141161]={'1161:54.54,43.68 N:0'}
G[-140942]={'942:78.31,27.00 N:0'}
G[-140896]={'896:87.74,46.58 N:0'}
G[-140895]={'895:70.46,55.74 N:0'}
G[-140885]={'885:60.18,22.70 N:0'}
G[-140882]={'882:55.28,13.84 N:0'}
G[-140864]={'864:39.08,84.08 N:0'}
G[-140863]={'863:1.81,92.43 N:0'}
G[-140862]={'862:63.22,14.02 N:0'}
G[-140830]={'830:35.98,68.71 N:0'}
G[-140680]={'680:64.22,41.94 N:0'}
G[-140650]={'650:44.91,66.14 N:0'}
G[-140646]={'646:68.10,29.14 N:0'}
G[-140641]={'641:66.77,45.94 641:54.78,52.78 N:0'}
G[-140634]={'634:37.07,66.88 N:0'}
G[-140630]={'630:26.82,49.05 N:0'}
G[-140627]={'627:40.33,23.94 N:0'}
G[-140543]={'543:49.23,80.94 N:0'}
G[-140542]={'542:39.46,61.66 N:0'}
G[-140539]={'539:63.70,93.94 N:0'}
G[-140525]={'525:42.58,12.62 N:0'}
G[-140062]={'62:44.23,58.70 N:0'}
G[-140014]={'14:22.20,50.99 N:0'}
G[-131462]={'1462:63.35,42.95 N:0'}
G[-131355]={'1355:45.91,76.54 N:0'}
G[-131161]={'1161:60.84,39.83 N:0'}
G[-130942]={'942:36.30,67.68 N:0'}
G[-130896]={'896:68.85,3.20 N:0'}
G[-130895]={'895:48.98,23.64 N:0'}
G[-130885]={'885:60.68,66.20 N:0'}
G[-130882]={'882:58.12,29.85 N:0'}
G[-130864]={'864:92.93,82.56 N:0'}
G[-130863]={'863:58.77,83.92 N:0'}
G[-130862]={'862:19.89,15.25 N:0'}
G[-130830]={'830:58.71,75.97 N:0'}
G[-130680]={'680:23.57,40.19 N:0'}
G[-130650]={'650:33.59,25.06 N:0'}
G[-130646]={'646:49.09,55.46 N:0'}
G[-130641]={'641:39.25,52.58 N:0'}
G[-130634]={'634:53.39,54.14 N:0'}
G[-130630]={'630:51.78,44.29 N:0'}
G[-130627]={'627:40.19,24.71 N:0'}
G[-130550]={'550:55.06,12.38 N:0'}
G[-130543]={'543:44.93,48.23 N:0'}
G[-130542]={'542:75.05,26.11 N:0'}
G[-130539]={'539:42.08,57.34 N:0'}	-- ? 53.12,65.38
G[-130535]={'535:42.79,60.78 N:0'}
G[-130525]={'525:70.11,26.84 N:0'}
G[-130062]={'62:41.38,78.42 N:0'}
G[-130051]={'51:74.10,44.46 N:0','Down in temple'}
G[-130038]={'38:74.10,44.46 N:0','Down in temple'}
G[-130014]={'14:59.24,28.22 N:0'}
G[-121462]={'1462:68.91,35.05 N:0'}
G[-121355]={'1355:77.45,35.64 N:0'}
G[-121161]={'1161:73.22,11.32 N:0'}
G[-120942]={'942:34.70,67.86 N:0'}
G[-120896]={'896:96.61,44.67 N:0'}
G[-120895]={'895:63.60,57.22 N:0'}
G[-120885]={'885:54.27,25.53 N:0'}
G[-120882]={'882:40.42,59.65 N:0'}
G[-120864]={'864:89.33,80.38 N:0'}
G[-120863]={'863:40.46,30.53 N:0'}
G[-120862]={'862:60.33,12.27 N:0'}
G[-120830]={'830:55.01,56.51 N:0'}
G[-120680]={'680:73.83,52.69 N:0'}
G[-120650]={'650:41.83,10.54 N:0'}
G[-120646]={'646:39.05,30.06 N:0'}
G[-120641]={'641:66.20,44.76 N:0'}
G[-120634]={'634:37.39,63.52 N:0'}
G[-120630]={'630:47.67,13.15 N:0'}
G[-120627]={'627:40.16,25.36 N:0'}
G[-120550]={'550:38.52,39.49 N:0'}
G[-120543]={'543:42.24,63.34 N:0'}
G[-120542]={'542:72.90,32.44 N:0'}
G[-120539]={'539:58.48,32.70 N:0'}
G[-120535]={'535:83.64,30.93 N:0'}
G[-120525]={'525:64.02,16.66 N:0'}
G[-120284]={'284:68.39,64.35 N:0'}
G[-120062]={'62:38.98,42.62 N:0'}
G[-120051]={'51:76.62,41.53 N:0'}
G[-120038]={'38:76.62,41.53 N:0'}
G[-120014]={'14:23.70,49.61 N:0'}
G[-111462]={'1462:63.14,39.29 N:0'}
G[-111355]={'1355:39.11,54.24 N:0'}
G[-111161]={'1161:57.94,40.42 N:0'}
G[-110942]={'942:57.77,66.80 N:0'}
G[-110896]={'896:24.46,22.03 N:0'}
G[-110895]={'895:67.36,51.64 N:0'}
G[-110885]={'885:57.60,33.83 N:0'}
G[-110882]={'882:50.03,43.23 N:0'}
G[-110864]={'864:46.92,27.12 N:0'}
G[-110863]={'863:54.11,81.10 N:0'}
G[-110862]={'862:64.96,4.20 N:0'}
G[-110830]={'830:66.60,64.16 N:0'}
G[-110790]={'790:49.95,67.94 N:0'}
G[-110680]={'680:34.23,49.44 N:0'}
G[-110650]={'650:45.37,49.25 N:0'}
G[-110646]={'646:51.04,54.95 N:0'}
G[-110641]={'641:59.41,84.12 N:0'}
G[-110634]={'634:41.51,37.12 N:0'}
G[-110630]={'630:57.82,43.42 N:0'}
G[-110627]={'627:40.17,25.20 N:0'}
G[-110581]={'581:33.48,27.74 N:0'}
G[-110550]={'550:39.69,14.87 N:0'}
G[-110543]={'543:52.36,64.17 N:0'}
G[-110542]={'542:70.51,21.94 N:0'}
G[-110539]={'539:58.12,59.79 N:0'}
G[-110535]={'535:73.60,23.92 N:0'}
G[-110525]={'525:66.80,49.53 N:0'}
G[-110418]={'418:45.15,84.88 N:0'}
G[-110284]={'284:66.03,71.46 N:0'}
G[-110062]={'62:62.75,9.34 N:0'}
G[-110051]={'51:77.58,46.02 N:0'}
G[-110038]={'38:77.58,46.02 N:0'}
G[-110014]={'14:62.52,68.97 N:0'}
G[-101462]={'1462:68.91,35.12 N:0'}
G[-101355]={'1355:39.46,53.57 N:0'}
G[-101161]={'1161:54.37,45.02 N:0'}
G[-100942]={'942:62.48,41.47 N:0'}
G[-100896]={'896:59.45,21.92 N:0'}
G[-100895]={'895:76.24,64.52 N:0'}
G[-100885]={'885:63.08,42.81 N:0'}
G[-100882]={'882:55.46,63.74 N:0'}
G[-100864]={'864:95.08,70.36 N:0'}
G[-100863]={'863:61.57,68.10 N:0'}
G[-100862]={'862:71.69,65.22 N:0'}
G[-100857]={'857:66.52,29.42 N:0'}
G[-100830]={'830:55.83,35.54 N:0'}
G[-100811]={'811:22.75,27.54 N:0'}
G[-100790]={'790:50.97,65.93 N:0'}
G[-100753]={'753[1]:53.98,21.30 N:0'}
G[-100680]={'680:22.79,35.49 N:0'}
G[-100673]={'673:61.20,44.29 N:0'}
G[-100650]={'650:38.52,39.78 N:0'}
G[-100649]={'649:65.87,47.27 N:0'}
G[-100646]={'646:43.70,58.39 N:0'}
G[-100641]={'641:46.22,67.82 N:0'}
G[-100634]={'634:42.02,64.49 N:0'}
G[-100630]={'630:57.99,58.20 N:0'}
G[-100627]={'627:40.20,24.41 N:0'}
G[-100606]={'606:7.56,34.57 N:0'}
G[-100588]={'588:42.33,81.16 N:0'}
G[-100587]={'587:63.61,45.19 N:0'}
G[-100581]={'581:33.59,30.45 N:0'}
G[-100550]={'550:44.12,74.66 N:0'}
G[-100543]={'543:48.04,55.65 N:0'}
G[-100542]={'542:67.45,21.81 N:0'}
G[-100539]={'539:25.62,32.89 N:0'}
G[-100535]={'535:55.28,23.50 N:0'}
G[-100525]={'525:20.94,57.92 N:0'}
G[-100418]={'418:66.52,29.42 N:0'}
G[-100390]={'390:22.75,27.54 N:0'}
G[-100283]={'283:53.98,21.30 N:0'}
G[-100261]={'261:39.07,46.91 N:0'}
G[-100210]={'210:61.20,44.29 N:0'}
G[-100201]={'201:64.93,16.64 N:0'}
G[-100198]={'198:7.56,34.57 N:0'}
G[-100081]={'81:39.07,46.91 N:0'}
G[-100078]={'78:64.93,16.64 N:0'}
G[-100063]={'63:40.51,53.32 N:0'}
G[-100062]={'62:61.73,17.81 N:0'}
G[-100051]={'51:74.82,49.36 N:0'}
G[-100050]={'50:78.51,35.68 N:0'}
G[-100049]={'49:32.38,39.40 N:0'}
G[-100043]={'43:40.51,53.32 N:0'}
G[-100038]={'38:74.82,49.36 N:0'}
G[-100037]={'37:78.51,35.68 N:0'}
G[-100036]={'36:32.38,39.40 N:0'}
G[-100032]={'32:23.06,35.52 N:0'}
G[-100028]={'28:23.06,35.52 N:0'}
G[-100014]={'14:38.97,39.65 N:0'}
G[-100011]={'11:62.86,61.80 N:0'}
G[-100010]={'10:62.86,61.80 N:0'}
G[0]={'Self'}
G[1]={'1 AdventureGuide'}
G[3]={'376:51.70,48.32'}
G[4]={'467:41.78,71.14 N:100020483'}
G[46]={'37:79.78,55.52'}
G[68]={'84:70.25,83.80'}
G[114]={'52:54,36'}
G[126]={'52:53,11'}
G[171]={'52:53,11'}
G[197]={'425:33.54,52.98'}
G[198]={'425:38.77,43.48 37:49.66,39.40>425','Upstairs'}
G[210]={'47:17.63,28.95'}
G[233]={'52:56.04,31.23'}
G[234]={'52:56.33,47.53'}
G[235]={'52:56.42,30.53'} -- also moves to 39:56.48,30.38
G[240]={'37:42.11,65.93'}
G[241]={'37:42.1,67.2'}
G[244]={'37:34.6,84.4'}
G[246]={'37:34.4,84.3'}
G[247]={'37:43.1,85.8'}
G[248]={'37:34.9,84'}
G[251]={'37:43.1,89.6'}
G[252]={'37:29.9,86'}
G[253]={'37:43.3,65.8'}
G[255]={'37:43.10,85.52'}
G[261]={'37:73.97,72.18'}
G[263]={'47:71.93,46.44'}
G[264]={'47:73.53,46.91'}
G[265]={'47:75.81,45.29'}
G[267]={'47:72.45,46.91'}
G[268]={'47:72.60,47.75'}
G[272]={'47:73.90,43.92'}
G[273]={'47:74.09,44.72'}
G[276]={'47:79.54,47.46'}
G[278]={'37:79.46,68.71'}
G[288]={'47:18.62,58.35'}
G[289]={'47:87.43,35.23'}
G[294]={'37:84.60,69.38'}
G[295]={'37:43.77,65.82'}
G[302]={'47:81.95,59.24'}
G[311]={'47:7.8,34.6'}
G[331]={'84:49.26,87.77','In tower'}
G[332]={'84:81.32,63.51'}
G[342]={'49:22.04,42.70'}
G[344]={'49:28.90,41.12'}
G[352]={'84:70.93,72.48'}
G[375]={'425:39.31,43.77 37:49.81,39.49>425'}
G[376]={'84:49.53,44.60'}
G[379]={'49:15.62,65.33'}
G[382]={'49:31.85,44.90'}
G[384]={'37:84.15,65.49'}
G[392]={'52:30.51,85.61'}
G[415]={'49:29.4,43.4 49:29.4,43.5 49:29.5,43.1 49:29.8,43.6 49:31.1,47.4 49:31.1,47.5'}
G[423]={'49:16.87,57.92'}
G[430]={'49:22,33'}
G[445]={'49:22,33'}
G[446]={'49:22,33'}
G[448]={'37:24.81,95.17'}
G[456]={'52:56.2,7.2'}
G[459]={'425:39.54,55.11 37:49.87,42.65>425'}
G[460]={'27:33.25,38.39>469 469:37.68,37.95'}
G[461]={'84:39.25,84.96','In basement'}
G[464]={'49:15.32,64.59','Top of tower'}
G[466]={'84:69.16,82.73'}
G[469]={'50:47.57,10.26'}
G[513]={'52:40,14'}
G[514]={'37:41.70,65.55'}
G[515]={'52:53,9'}
G[522]={'47:17.61,29.02'}
G[523]={'52:56.6,49.4'}
G[576]={'47:74.20,47.02'}
G[580]={'49:17.76,22.10'}
G[620]={'52:56,31'}
G[658]={'427:65.68,43.56 27:35.56,70.32>427'}
G[661]={'47:75.39,49.01'}
G[663]={'47:75.33,48.01'}
G[715]={'50:44.02,23.29 50:44.18,22.97'} -- 689:35.7,10.7
G[716]={'50:44.24,22.13'}
G[717]={'50:44.50,22.67'}
G[718]={'50:43.72,22.28 50:44.18,22.27'}
G[733]={'50:47.53,10.74'}
G[739]={'50:47.25,11.11'}
G[770]={'50:47.10,10.70'}
G[773]={'50:43.61,23.13'} -- 689:27,77.2
G[786]={'427:42.71,62.24 27:32.06,74.17>427'}
G[793]={'49:32.31,39.43'}
G[821]={'52:56.46,47.57'}
G[823]={'425:35.71,39.76'}
G[837]={'427:60.72,14.68 27:35.6,64.8>427'}
G[878]={'52:56.39,47.35'}
G[888]={'47:45.11,67.02'}
G[895]={'427:63.65,20.09 27:36.1,65.9>427'}
G[900]={'49:28.67,40.95'}
G[911]={'425:40.87,53.80 37:50.24,42.28>425'}
G[912]={'427:61.89,19.01 27:35.8,65.7>427'}
G[914]={'84:79.44,68.89','Upstairs'}
G[915]={'425:41.13,45.29 37:50.31,39.91>425'}
G[916]={'427:59.56,20.41 27:35.5,66>427'}
G[918]={'84:77.51,65.35'}
G[925]={'425:41.55,53.24 37:50.43,42.12>425'}
G[926]={'427:61.91,24.55 27:35.8,66.7>427'}
G[928]={'84:52.85,44.91'}
G[931]={'49:29.42,53.76'}
G[951]={'425:35.48,37.78 37:48.75,37.82>425'} -- 30:48.56,38.03 30:48.46,38.25
G[963]={'37:24.23,74.46'}
G[1068]={'15:17.7,43.8'}
G[1071]={'56:49.80,18.26'}
G[1073]={'48:64.25,26.69'}
G[1089]={'48:23.33,74.94'}
G[1090]={'48:23.30,75.06'}
G[1092]={'48:23.38,75.04'}
G[1104]={'427:61.70,22.07 27:35.80,66.26>427'}
G[1105]={'48:37.24,47.39'}
G[1139]={'48:34.6,43.2 48:34.6,44.6 48:34.7,43.6'}
G[1141]={'84:51.77,93.60'}
G[1142]={'50:46,51'}
G[1144]={'50:46,51'}
G[1153]={'48:37.1,46.3 48:37.2,47.8'}
G[1154]={'48:81.76,61.67'}
G[1156]={'48:81.92,64.61'}
G[1165]={'48:68.01,66.02'}
G[1187]={'48:83.46,65.41'}
G[1217]={'56:10.59,60.59'}
G[1239]={'56:10.95,59.73'}
G[1243]={'27:40.7,65.1 27:47.8,63.4 27:47.8,63.5'}
G[1247]={'27:54.49,50.85'}
G[1252]={'27:53.9,52.1'}
G[1254]={'27:76.32,54.67'}
G[1261]={'27:70.64,48.95'} -- 27:70.67,48.87
G[1265]={'27:70.28,48.16'}
G[1266]={'27:34.6,51.6'}
G[1267]={'27:53.93,50.68'}
G[1269]={'27:53.3,51.9'}
G[1274]={'87:41,54.8'}
G[1293]={'115:85.95,50.86','In mausoleum'}
G[1298]={'84:58.35,69.03'}
G[1317]={'84:52.89,74.44'}
G[1323]={'84:77.18,61.00'}
G[1340]={'48:35.06,46.60'}
G[1343]={'48:25.45,17.95'}
G[1344]={'48:65.33,65.98'}
G[1345]={'48:64.89,66.65'}
G[1354]={'427:43.22,63.12 27:32.16,74.34>427'}
G[1355]={'27:75.6,52.8'}
G[1356]={'87:75.8,11.8'}
G[1365]={'HV 87:30.25,59.43'}
G[1374]={'27:54.2,51.2'}
G[1376]={'27:50.4,49.1 27:57.5,47.4'}
G[1378]={'27:49.4,48.4 27:49.5,48.4 27:53.3,51.9'}
G[1379]={'48:56.3,65.9 48:56.5,65.9 48:58.5,64.5'}
G[1416]={'84:59.72,33.79'}
G[1422]={'50:46.99,10.85'}
G[1427]={'84:62.31,67.94'}
G[1428]={'84:58.10,67.49'}
G[1429]={'84:52.58,83.40'}
G[1431]={'84:60.27,76.75'}
G[1432]={'84:63.77,73.59'}
G[1435]={'84:40.13,85.29'}
G[1449]={'210:54.18,46.44'}
G[1465]={'48:37.19,46.40'}
G[1484]={'56:11.86,57.90'}
G[1493]={'210:35.46,63.66'}
G[1495]={'18:65.49,60.25'}
G[1496]={'18:52.54,54.82'}
G[1499]={'18:61.02,50.56'} -- 20:61.08,50.65 20:60.95,50.46 20:60.91,50.59 20:61.08,50.52 20:60.99,50.47
G[1500]={'18:54.60,29.89'}
G[1515]={'18:60.54,51.86'}
G[1518]={'18:44.62,53.78'}
G[1519]={'18:44.75,53.67'}
G[1521]={'18:65.25,60.42'}
G[1535]={'18:34,48'}
G[1547]={'18:66,56 K:24992'}
G[1548]={'18:56.6,63.8 K:24992'}
G[1561]={'210:41.28,61.15'}
G[1568]={'465:43.42,79.91 18:30.06,71.29>465'}
G[1569]={'465:46.65,58.80 18:30.84,66.20>465'}
G[1570]={'465:55.47,37.75 18:32.97,61.12>465'}
G[1571]={'56:9.4,59.6'}
G[1572]={'48:33.93,50.94'}
G[1573]={'87:55.54,47.76'}
G[1658]={'18:52.6,26.2'}
G[1661]={'465:46.74,58.22 18:30.87,66.05>465'}
G[1682]={'48:35.46,48.53'}
G[1684]={'48:41.52,39.04'}
G[1694]={'27:50.1,49.4 27:57.2,47.7'}
G[1699]={'27:54.73,50.59'}
G[1740]={'465:49.89,56.23 18:31.63,65.57>465'}
G[1745]={'18:60.13,52.39'}
G[1747]={'84:85.71,31.58'}
G[1776]={'51:26.8,33.4 51:26.9,33.7'}
G[1777]={'48:35.43,42.84'}
G[1780]={'21:34.27,16.60'}
G[1854]={'22:52.01,82.88','Circles the statue'}
G[1860]={'895:87.30,50.02'}
G[1872]={'27:53.13,49.99'}
G[1931]={'18:44.70,52.62'}
G[1938]={'21:47.07,43.21'}
G[1959]={'87:41.44,52.29'}
G[1960]={'48:14.00,56.49'}
G[1963]={'48:34.83,49.28'}
G[1977]={'27:75.90,54.31'}
G[1992]={'57:42.52,58.18'}
G[2020]={'57:37.05,25.42'}
G[2055]={'998:48.4,69.2'}
G[2057]={'48:56.36,65.98'}
G[2077]={'460:45.94,72.89 57:58.04,38.79>460'}
G[2078]={'57:55.69,52.00'}
G[2079]={'460:45.62,74.55 57:57.96,39.19>460'}
G[2080]={'57:59.93,59.76'}	-- TODO: Determine if the original stuff with him can be given to the second location.  I know "The Shimmering Frond" and "Timberling Sprouts" can go to both.  If the early stuff needs to be done at the original dude, I think it would be best to alias the second one and just make other quests be able to be turned in to either one.
G[2081]={'57:55.66,51.99'}
G[2083]={'57:55.77,50.44'}
G[2104]={'56:10.52,55.71'}
G[2107]={'57:64.58,51.13','Upstairs'}
G[2119]={'465:54.17,56.38 18:32.66,65.61>465'}
G[2122]={'465:53.67,56.54 18:32.54,65.65>465'}
G[2123]={'465:47.74,58.16 18:31.11,66.03>465'}
G[2124]={'465:47.04,58.28 18:30.94,66.07>465'}
G[2126]={'465:46.95,59.38 18:30.91,66.34>465'}
G[2150]={'57:59.52,49.18'}
G[2151]={'57:49.35,44.68'}
G[2211]={'18:60.04,52.87','Upstairs'}
G[2215]={'25:29.23,63.34'}
G[2227]={'998:57.61,93.82'}
G[2229]={'25:57.68,46.90'}
G[2278]={'25:57.27,46.34'}
G[2285]={'84:81.55,34.07'}
G[2299]={'36:72.09,65.69'}
G[2307]={'465:45.93,80.47 18:30.67,71.42>465'}
G[2368]={'25:56.4,84'}
G[2369]={'25:52.4,77'}
G[2370]={'25:58.2,84'}
G[2371]={'25:52.6,75.6'}
G[2372]={'25:56.4,74.2 25:57,74.6 25:57.2,74.3 25:57.4,75.6 25:57.6,74.6 25:57.7,74.4 25:57.9,72.3 25:58.2,73.3 25:58.5,73.1 25:58.7,75 25:58.9,74.4'}
G[2373]={'25:59.6,73.6'}
G[2391]={'25:49.10,66.36'}
G[2397]={'25:57.68,45.24'}
G[2409]={'47:77.49,44.29'}
G[2418]={'25:57.19,45.53'}
G[2419]={'25:57.16,45.53'}
G[2437]={'25:57.00,45.72'}
G[2439]={'84:85.68,31.03'}
G[2460]={'87:26.06,69.82'}
G[2461]={'87:26.01,69.65'}
G[2464]={'50:38.40,50.46'}
G[2465]={'50:38.35,51.07'}
G[2486]={'210:41.81,72.84'}
G[2487]={'210:41.10,73.27'}
G[2488]={'210:40.68,73.82'}
G[2490]={'210:42.58,72.00'}
G[2493]={'210:43.39,71.49'}
G[2495]={'50:43.66,23.46'}
G[2496]={'210:41.18,73.06'} -- 689:27.2,76.9
G[2497]={'50:38.42,48.71'}
G[2500]={'210:40.32,67.79'}
G[2501]={'210:42.07,73.39'}
G[2502]={'210:40.54,67.72'}
G[2519]={'50:63.09,41.51'}
G[2545]={'210:44.45,92.89','Walks a short path here'} -- 673:44.57,93.58 673:44.41,92.65
G[2546]={'210:46.70,95.34','Inside lower ship'}
G[2547]={'210:46.7,95'}
G[2548]={'210:44.43,91.55','Inside lower ship'} -- 673:44.50,91.57 673:44.41,91.45
G[2549]={'210:44.45,91.89'}
G[2592]={'14:30.02,59.70'}
G[2608]={'14:39.98,47.82'}
G[2610]={'14:26,83.9'}
G[2634]={'210:59.46,79.05'}
G[2650]={'26:25,59'}
G[2653]={'26:35,65'}
G[2654]={'26:36,71'}
G[2696]={'14:43.2,92.6'}
G[2700]={'14:39.97,48.86'}
G[2705]={'25:52.2,58.6'}
G[2707]={'26:35,71'}
G[2712]={'14:54.82,55.38'}
G[2713]={'14:54.89,55.46'}
G[2748]={'230:56.6,53.6'}
G[2763]={'14:29.95,59.13'}
G[2766]={'14:25.2,85.5 14:25.4,85.2 14:25.5,85.2'}
G[2768]={'14:27.58,83.01'}
G[2769]={'14:27.72,83.27'}
G[2771]={'14:68.98,34.80'}
G[2774]={'14:27.56,82.91'}
G[2784]={'87:40,55'}
G[2785]={'15:26.21,62.30'}
G[2787]={'14:69.68,36.53'}
G[2789]={'14:40.34,49.14'}
G[2835]={'14:39.90,47.34'}
G[2858]={'210:40.60,73.42'}
G[2859]={'210:41.67,74.53'}
G[2860]={'15:49.49,36.99'}
G[2916]={'87:77.53,11.81'}
G[2918]={'87:33.10,48.58'}
G[2920]={'15:26.28,62.54'}
G[2941]={'32:37.94,30.86'}
G[2947]={'7:48.79,58.79'}
G[2948]={'7:48.62,59.80'}
G[2976]={'7:53.58,48.27'}
G[2980]={'462:39.45,37.25 7:48.95,78.35>462'}
G[2981]={'462:27.74,28.32 7:45.15,75.46>462'}
G[2984]={'7:32.8,36.1'}
G[2985]={'7:47.50,61.32'}
G[2987]={'7:49.59,17.59'}
G[2988]={'7:57.05,60.43'}
G[2994]={'7:60.79,22.67'}
G[2995]={'88:47.02,49.61'}
G[3007]={'88:41.8,42.8'}
G[3009]={'998:46.61,33.15'}
G[3026]={'88:51.75,53.09'}
G[3028]={'88:56.14,46.37'}
G[3032]={'88:21.96,18.83'}	-- Replaced by 51639?
G[3033]={'88:76.47,27.25'}
G[3034]={'88:77.15,27.04'}
G[3039]={'88:57.29,89.78'}
G[3042]={'88:56.98,89.55'}
G[3045]={'88:24.54,22.56'}
G[3047]={'88:22.74,14.53'}
G[3050]={'88:44.1,44.6'}
G[3052]={'7:49.68,17.23'}
G[3054]={'7:47.88,57.10'}
G[3055]={'7:47.16,56.66'}
G[3056]={'7:44.42,17.19'}
G[3057]={'88:60,51.7'}
G[3059]={'7:45,75.4'}
G[3060]={'7:45.22,75.12'}
G[3061]={'7:45.27,75.30'}
G[3062]={'7:45.1,75.1'}
G[3064]={'7:48.6,59'}
G[3079]={'7:46.06,58.19'}
G[3139]={'1:51.95,43.50'}
G[3140]={'1:55.42,75.10'}
G[3142]={'1:52.24,43.15'}
G[3143]={'461:44.93,66.43 1:44.95,66.42>461'}
G[3144]={'86:49.20,72.26'}
G[3145]={'461:45.82,63.44 1:43.46,67.50>461'}
G[3153]={'461:43.56,71.15 1:42.88,69.47>461'}
G[3154]={'1:42.9,69.3'}
G[3155]={'461:41.53,68.56 1:42.36,68.81>461'}
G[3156]={'461:41.59,65.61 1:41.59,65.61>461'}
G[3157]={'461:41.63,69.32 1:42.39,69.00>461'}
G[3188]={'1:55.95,74.72'}
G[3193]={'1:43.38,30.63'}
G[3208]={'1:56.41,20.04'}
G[3216]={'85:58.22,54.61'}
G[3230]={'100:55,36'}
G[3233]={'7:49.52,17.10'}
G[3278]={'10:28.60,33.69'}
G[3279]={'10:26.38,28.59'}
G[3285]={'10:50.32,25.68'}
G[3287]={'461:34.62,44.21 1:40.60,62.58>461'}
G[3292]={'10:67.69,72.85'}
G[3293]={'1:46.37,22.94'}
G[3309]={'85:49.6,69.4'}
G[3310]={'86:49.64,59.21'}
G[3326]={'86:54.27,34.67'}
G[3332]={'85:66.4,41.7'}
G[3336]={'1:50.85,43.59'}
G[3337]={'10:67.66,39.39'}
G[3338]={'10:49.99,59.84'}
G[3339]={'10:67.72,74.00'}
G[3341]={'199:49.22,82.37'}
G[3344]={'85:39,47.4'}
G[3345]={'86:53.48,49.54'}
G[3347]={'86:55.68,45.76'}
G[3352]={'86:63.88,32.52'}
G[3353]={'85:73.3,45.4'}
G[3355]={'85:76.3,34.6'}
G[3359]={'86:66.47,49.02'}
G[3362]={'85:61.1,35.2 85:61.2,34 85:61.4,35.5 85:61.5,34.3 85:61.5,35.4 85:61.5,35.5 85:69.2,13.2'}
G[3383]={'10:77.29,91.32'}
G[3387]={'199:41.52,47.19'}
G[3389]={'10:37.83,55.27'}
G[3390]={'10:48.59,58.33'}
G[3391]={'10:68.41,69.06'}
G[3399]={'86:32.24,69.65'}
G[3411]={'65:72.05,91.20'}
G[3412]={'86:56.30,56.37'}
G[3418]={'199:41.62,46.51'}
G[3429]={'10:48.70,59.60'}
G[3432]={'10:55.17,41.02'}
G[3433]={'199:41.73,46.64'}
G[3439]={'10:57.54,18.31'}
G[3441]={'88:61.52,80.85'}
G[3442]={'10:62.29,17.48'}
G[3446]={'10:67.86,71.50'}
G[3448]={'10:49.49,58.67'}
G[3449]={'10:30.58,45.93'}
G[3453]={'10:69.59,72.98'}
G[3454]={'199:68.6,44.5'}
G[3464]={'10:66.86,72.79'}
G[3467]={'10:69.91,85.21'}
G[3471]={'10:50.35,25.66'}
G[3489]={'10:50.6,57.8'}
G[3494]={'10:68.39,69.20'}
G[3502]={'10:68.32,71.27'}
G[3514]={'460:47.20,55.95 57:58.35,34.60>460'}
G[3515]={'57:55.82,53.90'}
G[3516]={'89:24.4,48.8 89:24.5,48.8 89:33.8,10 89:34.3,8.2 89:34.4,8.5 89:34.5,8.4 89:34.6,10.6 89:34.8,9 89:35.3,9.6 89:35.5,9.1 89:39.4,10.7'}
G[3517]={'57:43.96,44.17'}
G[3518]={'84:27.7,38 84:43.2,73.6 84:59.9,69.3 84:59.9,70.1 84:60.1,71.3 84:60.2,68 84:60.3,66.8 84:60.3,71.9 84:60.4,72.5 84:60.5,67.6 84:60.5,72.4 84:60.6,67.4 84:60.8,73.1 84:61,73.7 84:61.4,66.4 84:61.4,74.5 84:61.5,74.8 84:61.6,66.5 84:61.8,66.1 84:61.9,73.8 84:62.4,71 84:62.4,71.6 84:62.4,73.3 84:62.6,72.7 84:62.8,65.9 84:62.9,70.3 84:63.3,71.3 84:63.3,72 84:63.5,71.7 84:63.6,66.3 84:63.6,72.5 84:63.7,71.4 84:63.8,66.5 84:64.1,75 84:64.3,70.4 84:64.3,73.7 84:64.4,67.6 84:64.5,66.4 84:64.5,67.4 84:64.5,73.4 84:64.5,74.5 84:64.6,70.2 84:64.7,74.2 84:64.9,68.4 84:65,68.9 84:65,75.5 84:65.2,76.7 84:65.4,70.6 84:65.5,69.4 84:65.5,76.1 84:65.6,74.8 84:66.2,76.8 84:66.4,70.4 84:66.4,71.4 84:66.4,71.9 84:66.5,71.4 84:66.6,71.6 84:67.3,72.5 84:67.6,72.4 84:67.6,72.7'}
G[3519]={'57:39.50,29.86'}
G[3521]={'10:67.81,40.56'}
G[3535]={'57:52,63.8'}
G[3567]={'57:55.55,49.99'}
G[3568]={'57:34.50,27.82'}
G[3593]={'460:49.19,52.44'}
G[3594]={'460:49.21,53.19 57:58.85,33.92>460'}
G[3595]={'460:47.59,59.45 57:58.45,35.47>460'}
G[3596]={'460:49.21,60.54 57:58.85,35.74>460'}
G[3597]={'460:46.60,56.65 57:58.20,34.78>460'}
G[3610]={'57:55.61,51.49'}
G[3615]={'10:48.7,58.7'}
G[3653]={'279:35.82,35.71'}
G[3654]={'279:33.63,14.74'}
G[3658]={'10:50.32,59.31'}
G[3674]={'279:61.62,73.41'}
G[3685]={'7:47.5,58.5 7:47.6,58'}
G[3690]={'7:47.6,58'}
G[3691]={'63:36.6,49.6'}
G[3694]={'62:42.51,45.15'}
G[3698]={'63:18,60'}
G[3838]={'57:55.41,88.40'}
G[3841]={'62:51.72,17.65'}
G[3845]={'63:18.3,20.4 63:18.3,20.5'}
G[3846]={'63:18.2,20.6 63:18.3,20.4'}
G[3847]={'63:26.8,36.7'}
G[3848]={'63:85.3,44.4 63:85.3,44.7'}
G[3880]={'63:59,58.8'}
G[3881]={'1:50.74,42.84'}
G[3885]={'63:35.6,71.4 63:35.6,71.5'}
G[3887]={'310:0.00,0.00'}
G[3891]={'63:20.3,38.8'}
G[3894]={'63:37.3,51.8'}
G[3897]={'63:50.9,75.1'}
G[3901]={'63:86.3,44.1 63:86.4,43.1 63:86.7,43 63:87,43.5'}
G[3916]={'63:59.1,59.7'}
G[3920]={'63:78.3,44.9'}
G[3936]={'69:46.03,49.11'}
G[3978]={'88:33.9,47 88:34,46.4 88:34.1,47.6 88:34.6,47.4 88:34.8,48'}
G[3995]={'65:71.12,91.22'}
G[3996]={'63:35.8,49.2'}
G[4008]={'65:64.98,82.66'}
G[4046]={'88:70.3,30.8 88:70.7,30.7'}
G[4079]={'63:34.9,49.8'}
G[4087]={'89:56.54,45.99'}
G[4138]={'89:43.5,25.9'}
G[4155]={'89:43.4,51.3 89:43.6,51.2'}
G[4156]={'89:49.10,60.95'}
G[4160]={'89:53.90,38.52'}
G[4202]={'65:63.1,46'}
G[4210]={'89:49.87,36.65'}
G[4214]={'89:40.4,39.2'}
G[4217]={'89:40.5,27.6'}
G[4256]={'87:51.47,26.32'}
G[4265]={'57:56.73,53.51'}
G[4267]={'63:34.41,47.99'}
G[4278]={'310:30.30,69.70'}
G[4311]={'1:46.01,13.79'}
G[4321]={'70:67.48,51.30'}
G[4407]={'65:40.12,31.96'}
G[4421]={'301:22.41,31.65'}
G[4468]={'26:63,76.6'}
G[4486]={'14:13.76,33.91'}
G[4498]={'66:52.2,53.5'}
G[4500]={'70:36.29,31.41'}
G[4501]={'70:37.15,33.08'}
G[4502]={'70:37.36,31.39'}
G[4508]={'301:33,33'}
G[4544]={'69:74.7,43.5 69:75,43 69:76,42.8'}
G[4549]={'998:65.95,49.66'}
G[4551]={'998:63.27,48.58'}
G[4552]={'998:62.17,44.90'}
G[4556]={'998:61.50,41.80'}
G[4563]={'998:86.23,15.97'}
G[4566]={'998:84.97,14.05'}
G[4573]={'998:81.71,31.23'}
G[4584]={'998:84.87,73.54'}
G[4586]={'998:6.3,68.3 998:35,2.2 998:63.9,80.6 998:75,74 998:75.1,172.2 998:75.2,74.5 998:75.4,72.8 998:75.6,74.5 998:75.8,73.4 998:75.8,73.6 998:76.2,72.4 998:78.6,9.2'}
G[4593]={'998:46.90,15.22'}
G[4606]={'998:49.28,17.05'}
G[4611]={'998:47.78,73.37'}
G[4618]={'15:26.19,62.45'}
G[4656]={'66:33.8,53.6'}
G[4663]={'66:55,28.8'}
G[4664]={'66:56,29.6'}
G[4665]={'66:52.6,29.4'}
G[4666]={'66:55.8,28.6'}
G[4667]={'66:55,26.4'}
G[4672]={'66:75.91,26.57'}
G[4673]={'66:74.78,13.30'}
G[4730]={'89:42.49,32.60'}
G[4732]={'37:84.32,64.87'}
G[4752]={'85:61.4,34.4 85:61.4,34.7 85:61.4,35.5 85:61.5,34.4 85:61.5,34.5 85:69.4,12.6'}
G[4753]={'89:42.77,32.93'}
G[4772]={'27:71.15,48.41'}
G[4773]={'18:61.88,51.86'}
G[4787]={'221:20.83,75.28'}
G[4791]={'70:35.21,30.66'}
G[4792]={'70:55.44,26.27'}
G[4794]={'70:68.27,48.71'}
G[4854]={'230:22.90,26.22'}
G[4855]={'230:24.13,27.03'}
G[4880]={'70:46.89,17.52'}
G[4921]={'70:66.16,46.07'}
G[4926]={'70:36.42,31.88'}
G[4941]={'70:64.75,50.42'}
G[4943]={'88:54.05,80.72'}
G[4944]={'70:68.21,48.62'}
G[4948]={'70:68.04,48.11'}
G[4949]={'85:32.3,37.8 85:32.5,38.7 85:32.8,37.8'}
G[4968]={'70:66.26,49.05','Top floor of tower'}
G[4983]={'70:40.96,36.71'}
G[5086]={'70:59.67,41.06'}
G[5087]={'70:36.53,30.80'}
G[5089]={'70:36.09,54.31'}
G[5099]={'87:25.71,69.67'}
G[5111]={'87:18.14,51.41'}
G[5115]={'87:71.00,89.69'}
G[5146]={'87:25.93,6.14','Up the ramp'}
G[5147]={'87:23.69,5.05','Up the ramp'}
G[5150]={'87:55.09,58.26','Upstairs'}
G[5159]={'87:60.09,36.44'}
G[5161]={'87:48.11,7.64'}
G[5165]={'87:51.83,14.75'}
G[5173]={'87:50.06,7.42'}
G[5174]={'87:68.46,43.55'}
G[5177]={'87:66.59,55.70'}
G[5225]={'51:77.49,42.61'}
G[5296]={'69:53.2,31.8'}
G[5297]={'69:54.6,33.8'}
G[5299]={'69:53.6,32'}
G[5385]={'17:63.19,16.85'}
G[5387]={'87:69.91,18.55'}
G[5390]={'69:75.1,42.8'}
G[5393]={'17:60.10,13.49'}
G[5395]={'66:56.3,59.4 66:56.3,59.5'}
G[5396]={'66:66.67,10.94'}
G[5412]={'66:56.3,59.4 66:56.3,59.5'}
G[5419]={'71:48,41'}
G[5457]={'71:33.6,48'}
G[5494]={'84:55.03,69.69'}
G[5496]={'84:39.66,85.71'}
G[5499]={'84:55.65,86.09'}
G[5504]={'84:64.55,37.58'}
G[5511]={'84:63.65,36.98'}
G[5518]={'84:62.84,31.97'}
G[5519]={'84:63.53,31.08'}
G[5543]={'88:28.03,25.22'}
G[5594]={'71:50.9,27 71:50.9,28'}
G[5636]={'26:9.90,44.23'}
G[5637]={'87:68.40,19.95'}
G[5638]={'66:66.2,9.7'}
G[5639]={'86:46.78,58.89 86:52.25,54.33'}
G[5640]={'86:27.99,61.31'}
G[5641]={'66:52.6,54.3'}
G[5642]={'66:66.44,11.82'}
G[5752]={'66:66.74,10.87'}
G[5767]={'279:46.61,58.42'}
G[5768]={'279:46.65,59.21'}
G[5769]={'88:30.3,68.5 88:30.7,68.4 88:30.9,68.9 88:30.9,69.5 88:45.7,22.7 88:78.1,29.5 88:78.4,28.4 88:78.4,28.7 88:78.5,28.3 88:78.5,28.7'}
G[5770]={'88:75.3,30.5 88:75.5,30.4 88:75.6,31.1 88:75.7,31.5'}
G[5775]={'279:56.79,47.81'}
G[5860]={'32:23.18,35.31'}
G[5887]={'461:41.72,69.98 1:42.40,69.18>461'}
G[5907]={'10:56.4,40.4 10:56.4,40.6 10:56.8,40.3'}
G[5977]={'17:41.79,33.62'}
G[6019]={'66:47.83,61.82'}
G[6030]={'48:23.6,74.4 48:23.6,74.5'}
G[6031]={'87:48.77,42.55'}
G[6034]={'89:60.3,37.1 89:60.5,37'}
G[6073]={'63:82.6,69.6'}
G[6115]={'63:82.6,69.6'}
G[6206]={'227:68.41,62.58'}
G[6218]={'226:0.00,0.00'}
G[6229]={'228:40.88,87.93'}
G[6234]={'229:28.70,47.59'}
G[6235]={'226:0.00,0.00'}
G[6294]={'87:74.34,9.47'}
G[6329]={'226:0.00,0.00'}
G[6391]={'226:0.00,0.00'}
G[6546]={'70:46.02,57.10'}
G[6566]={'998:77.87,75.96'}
G[6569]={'87:69.22,50.57'}
G[6577]={'48:81.65,64.75'}
G[6606]={'10:56.36,19.72'}
G[6706]={'66:64.66,10.53'}
G[6735]={'89:62.54,32.77'}
G[6736]={'57:55.37,52.23'}
G[6740]={'84:60.42,75.24'}
G[6741]={'998:67.73,37.88'}
G[6746]={'88:45.80,64.65'}
G[6766]={'25:67.2,46.4 25:67.2,46.7 25:69.1,44.2 25:70.5,44.9'}
G[6774]={'37:45.38,48.99'}
G[6780]={'460:54.56,84.72 57:60.17,41.71>460'}
G[6782]={'427:87.50,44.46 27:40.88,70.67>427'}
G[6785]={'18:61.87,51.96'}
G[6826]={'87:36.36,3.63'}
G[6887]={'62:39.1,43.1'}
G[6929]={'86:53.63,78.79'}
G[7010]={'85:55.2,55.8'}
G[7023]={'230:29.07,59.02'}
G[7024]={'52:68.32,70.38'}
G[7025]={'36:34.38,36.88'}
G[7079]={'226:0.00,0.00'}
G[7100]={'77:60.48,22.24'}
G[7156]={'77:63.2,9'}
G[7157]={'77:62.8,13.6'}
G[7158]={'77:63.8,6.8'}
G[7172]={'231:50.26,34.47'}
G[7206]={'230:43.95,41.09'}
G[7269]={'219:57.2,55.6'}
G[7272]={'219:57.97,25.81'}
G[7286]={'219:44.03,16.40'}
G[7291]={'230:26.53,34.81'}
G[7313]={'57:39.18,29.88 57:39.25,29.73'}
G[7316]={'89:36.08,53.48'}
G[7317]={'57:45.03,53.48',"In Ban'ethil Barrow Den"}
G[7323]={'25:71.41,44.96'}
G[7361]={'226:75.99,66.68'}
G[7363]={'17:48.77,31.75'}
G[7406]={'210:43,72.1'}
G[7407]={'219:58.16,89.10 71:39.22,21.34>219'}
G[7431]={'83:52.37,23.75'}
G[7434]={'83:46.62,23.54'}
G[7438]={'83:67.8,50.2'}
G[7439]={'83:67.8,50.2'}
G[7440]={'83:24.2,50.4'}
G[7441]={'83:24.4,47.6'}
G[7442]={'83:24.4,47.6'}
G[7443]={'83:56.67,39.55'}
G[7444]={'83:53.06,31.70'}
G[7453]={'83:64.20,37.28'}
G[7455]={'83:51.48,31.02'}
G[7456]={'83:52.75,34.36'}
G[7505]={'17:39.2,36.2'}
G[7506]={'17:39.2,36.2'}
G[7623]={'51:49.4,55.4 51:49.4,55.5 51:49.5,55.4 51:49.5,55.5'}
G[7740]={'89:44.9,80.9'}
G[7776]={'69:41.4,15.4 69:41.4,15.5 69:41.6,15.3 69:76.1,43.8'}
G[7783]={'17:62.31,26.08'}
G[7784]={'71:59.79,64.08'}
G[7790]={'85:76.2,37.4 85:76.2,37.5 85:76.6,37.6 85:76.7,37.4'}
G[7795]={'219:31.09,44.20'}
G[7800]={'228:0.00,0.00'}
G[7804]={'71:42.46,24.03'}
G[7806]={'26:49.34,37.67'}
G[7807]={'69:53.35,55.70'}
G[7823]={'71:51.36,29.48'}
G[7824]={'71:52.04,27.61'}
G[7846]={'17:54.7,51.2'}
G[7854]={'69:52.8,47.1'}
G[7875]={'69:74.9,42.6'}
G[7944]={'87:69.53,50.33'}
G[7952]={'1:55.2,75.6'}
G[7953]={'1:55.28,75.49'}
G[7954]={'27:56.27,46.42'}
G[7955]={'27:56.3,46.3'}
G[7995]={'26:59.4,77.8'}
G[7999]={'89:43.01,78.04'}
G[8018]={'26:11.08,46.15'}
G[8115]={'69:74.4,43.4 69:74.4,43.5 69:74.5,43.4'}
G[8126]={'71:52.37,28.31'}
G[8296]={'17:46.7,27.9', 'In cave'}
G[8297]={'17:46.3,39'}
G[8298]={'17:73.6,55.6'}
G[8299]={'17:59.1,35.5'}
G[8300]={'17:49,35.6'}
G[8301]={'17:46.8,13.3'}
G[8302]={'17:52.7,26.9'}
G[8303]={'17:54,37'}
G[8304]={'17:37.1,28.3'}
G[8356]={'88:46.97,58.22'}
G[8359]={'88:45.73,55.86'}
G[8379]={'76:29.3,40.2 76:29.7,40.4 76:29.8,40.5'}
G[8416]={'427:41.67,63.33 27:31.89,74.38>427'}
G[8436]={'32:29.51,26.27'}
G[8516]={'300:52.9,32 300:59.1,31.4 300:59.9,29 300:60,29.6 300:43.3,29.3 300:43.3,29.6 300:43.4,27.5 300:43.7,30.2 300:43.8,26.3 300:43.8,27 300:44.4,25.1 300:44.4,31 300:44.7,24.5 300:45.2,31.5 300:45.3,23.3 300:45.4,23.9 300:45.6,23.1 300:46,32.2 300:46.1,22.4 300:46.1,24.6 300:46.1,32.6 300:46.3,23.6 300:46.6,22.4 300:46.8,32.7 300:46.9,23 300:47.1,23.8 300:50.4,35.6 300:50.5,34.9 300:50.7,34.1 300:50.9,33.3 300:51.1,32 300:51.6,30.8 300:52,30 300:52.3,29.3 300:52.5,29.5 300:52.7,28.7 300:53.3,28.2 300:54.1,28.4 300:55.1,28.8 300:55.5,29.6 300:55.7,29.2 300:56.7,30.3 300:57.1,30.9 300:57.4,31.9 300:58.3,33.3 300:58.4,32.2 300:58.6,33.9 300:59,34.9 300:59.3,35.5 300:59.9,36.3 300:59.9,36.7 300:60.5,37.1 300:61.1,36.2 300:61.1,38.4 300:61.8,37.4 300:62.3,39.3 300:62.4,39.7 300:63,40.2 300:63.5,40.3 300:64.4,41.1 300:64.8,41.2 300:66.2,41.1 300:67.4,41.1 300:67.9,40.7 300:68,32.3 300:68,40.3 300:68.1,34.4 300:68.1,34.6 300:68.4,33.1 300:68.4,35.8 300:68.7,36.1 300:68.7,36.7 300:68.9,32.3 300:68.9,37.7 300:68.9,38.9 300:69,33.1 300:69.1,39.5 300:69.5,31.8 300:69.5,39.7 300:69.8,31.4 300:71,30.6 300:71.3,29.8 300:71.6,30.1 300:72.3,29.1 300:72.8,28.5 300:72.9,28.2 300:73.9,27.6 300:74,23.8 300:74.1,24.7 300:74.1,27.2 300:74.2,25.9 300:74.4,23.3 300:74.5,25.3 300:74.5,26.1 300:74.7,24 300:74.7,26.6 300:74.9,22.7 300:75.1,22 300:75.7,21.5 300:76.3,21.1 300:76.7,20.6 300:77,19.8 300:77.3,19.4 300:77.6,15.6 300:77.7,15.4 300:78,18.5 300:78.1,16.8 300:78.3,18.1 300:78.5,16.7'}
G[8551]={'23:55.36,60.64'}
G[8576]={'76:26.82,76.95'}
G[8582]={'10:42.35,15.18'}
G[8586]={'76:42.42,23.59'}
G[8587]={'76:22,51'}
G[8609]={'17:61.25,21.59'}
G[8659]={'86:54.79,45.84','Top of tower'}
G[8670]={'84:60.84,70.78'}
G[8674]={'88:45.11,59.75'}
G[8719]={'84:61.11,70.62'}
G[8890]={'242:46.52,88.19'}
G[8895]={'242:27.27,55.52'}
G[8904]={'242:0.00,0.00'}
G[8960]={'77:38.3,39.1 77:38.4,56.4 77:38.7,46.2 77:39.1,38.3 77:39.3,51.4 77:39.6,39.6 77:39.8,39 77:40.3,34 77:40.9,34.9 77:41.2,34 77:43.9,66.4 77:44.3,66.7 77:44.3,67.8 77:45.3,68 77:45.4,66.2 77:45.4,68.9 77:45.5,66.2 77:45.5,67.6 77:45.5,68.8 77:45.9,66.9 77:46,69.5 77:46.2,17.5 77:49.2,36.8 77:49.5,34.5 77:49.7,34.2 77:50.5,17.2 77:50.9,32.7 205:41.3,34.3'}
G[8962]={'49:28.27,48.87'}
G[8965]={'49:28.35,48.87'}
G[9016]={'242:23.78,54.02'}
G[9029]={'242:50.57,62.81'}
G[9116]={'77:42.01,71.80'}
G[9117]={'78:54.20,62.50'}
G[9167]={'78:32.94,62.86'}
G[9176]={'36:40.2,60.4 36:40.2,60.5 36:43.6,60.1'}
G[9177]={'36:71.86,67.96'}
G[9270]={'78:55.08,62.23'}
G[9271]={'78:55.02,62.23'}
G[9272]={'78:31.87,50.28'}
G[9296]={'425:33.38,54.66'}
G[9298]={'83:25.12,58.49'}
G[9316]={'10:44.37,24.86'}
G[9499]={'242:0.00,0.00'}
G[9502]={'242:0.00,0.00'}
G[9503]={'243:51.10,60.60'}
G[9517]={'77:39.53,46.98'}
G[9540]={'17:61.47,18.64'}
G[9550]={'HV 86:51.03,71.01'}
G[9562]={'36:73.46,66.27'}
G[9563]={'36:72,64'}
G[9568]={'253:0.00,0.00'}
G[9616]={'87:75.78,23.27'}
G[9618]={'78:43.45,40.93'}
G[9619]={'78:71.24,76.58'}
G[9623]={'78:63.80,19.74'}
G[9736]={'254:0.00,0.00'}
G[9796]={'461:42.98,62.43 1:42.73,67.24>461'}
G[9860]={'77:38.87,50.36'}
G[9877]={'77:36.94,55.51'}
G[9997]={'78:55.10,62.67'}
G[9998]={'78:43.44,41.33'}
G[9999]={'78:51.96,49.81'}
G[10076]={'242:0.00,0.00'}
G[10176]={'461:45.20,68.38 1:45.18,68.38>461'}
G[10181]={'998:58.05,91.77'}
G[10184]={'248:68.80,28.23'}
G[10260]={'36:54.57,23.97',[3]='015'}
G[10299]={'253:30.49,39.73 36:24.30,25.66>250'}
G[10302]={'78:55.35,62.49'}
G[10305]={'83:59.31,49.79'}
G[10307]={'83:25.21,58.47'}
G[10387]={'317:73.63,20.34'}
G[10418]={'317:39.15,31.62'}
G[10422]={'317:35.76,34.74'}
G[10424]={'317:38.71,38.78'}
G[10435]={'318:57.03,19.71'}
G[10439]={'318:39.65,22.64'}
G[10445]={'HF 407:55.56,54.99'}
G[10516]={'317:48.89,27.43'}
G[10558]={'317:50.44,29.69'}
G[10578]={'1:55.74,75.36'}
G[10583]={'78:55.98,64.16'}
G[10616]={'37:81.4,66.2'}
G[10618]={'83:46.68,17.72'}
G[10665]={'18:60.13,52.69'}
G[10666]={'18:44.36,53.06'} -- 20:44.37,53.14 20:45.09,53.36 20:44.19,53.93
G[10667]={'23:35.26,68.10'}
G[10738]={'83:36.96,55.59'}
G[10808]={'317:44.03,27.27'}
G[10813]={'317:23.62,78.72'}
G[10822]={'23:67.34,8.92'}
G[10837]={'18:83.26,68.99'}
G[10838]={'22:42.70,84.01'}
G[10839]={'18:83.2,68.6'}
G[10840]={'22:42.97,83.55'}
G[10897]={'80:48.11,67.33'}
G[10916]={'83:29.6,54.8'}
G[10920]={'83:46.85,53.84 77:51.2,80.4'}
G[10921]={'77:50.91,80.14'}
G[10922]={'77:43.97,61.83'}
G[10923]={'77:51.12,80.49'}
G[10926]={'23:32.45,83.65'}
G[10929]={'83:58.01,63.77'}
G[10977]={'78:54.83,63.82'}
G[10997]={'317:4.67,52.41'}
G[11017]={'86:56.8,56.4'}
G[11019]={'77:44.1,61.9'}
G[11031]={'998:76.8,74.6'}
G[11032]={'317:27.35,43.50'}
G[11033]={'23:74.92,53.50'}
G[11034]={'23:75.86,51.97'}
G[11035]={'23:53.22,54.58'}
G[11036]={'23:75.61,52.04'}
G[11053]={'22:43.40,83.74'}
G[11055]={'18:83.4,69.9'}
G[11057]={'18:83.28,69.24'}
G[11063]={'23:35.56,68.88'}
G[11078]={'22:62.54,58.58'}
G[11079]={'83:48.67,41.02'}
G[11118]={'83:59.86,51.19'}
G[11138]={'83:60.99,48.61'}
G[11139]={'83:58.84,48.27'}
G[11142]={'317:81.99,28.86'}
G[11191]={'83:59.87,49.19'}
G[11192]={'83:59.81,49.13'}
G[11193]={'83:59.78,49.25'}
G[11219]={'63:27.2,35.6'}
G[11259]={'66:55.4,55.7 66:55.5,55.8'}
G[11317]={'66:22.4,73.1 66:22.5,73'}
G[11378]={'461:46.20,63.26 1:46.20,63.26>461'}
G[11401]={'89:43.40,79.39'}
G[11406]={'87:26.2,8.00'}
G[11438]={'66:62.3,38.9'}
G[11486]={'238:60.54,23.47'}
G[11520]={'213:42.2,58.2'}
G[11554]={'77:51.41,80.44'}
G[11555]={'77:64.41,5.13'}
G[11556]={'83:21.05,46.18'}
G[11557]={'77:64.89,5.25'}
G[11558]={'77:64.58,3.81 77:64.65,5.90 77:64.55,4.80'}
G[11583]={'287:72,79'}
G[11596]={'66:60.86,61.86'}
G[11616]={'22:48.13,32.36'}
G[11624]={'66:25.8,68.2'}
G[11625]={'66:66.51,37.53'}
G[11626]={'66:45.37,75.29'}
G[11697]={'63:82.6,69.6'}
G[11701]={'78:71.4,73.9 78:71.5,74'}
G[11711]={'62:47.70,88.91'}
G[11730]={'81:57.6,79'}
G[11732]={'81:56,80'}
G[11798]={'80:44.29,45.85'}
G[11800]={'80:44.15,45.22'}
G[11801]={'80:51.69,45.09'}
G[11806]={'63:26.68,36.89'}
G[11811]={'71:55.23,60.26'}
G[11814]={'86:32.78,65.16'}
G[11820]={'63:73.77,61.61'}
G[11821]={'65:64.93,82.60'}
G[11832]={'80:36.3,41.9 80:36.5,42.1'}
G[11857]={'199:44.18,33.68'}
G[11858]={'65:72.2,83.9'}
G[11941]={'27:54.6,50.3'}
G[11943]={'1:51.4,41.5 1:51.5,41.5'}
G[12029]={'80:53.33,42.70'}
G[12031]={'66:22.7,72.1'}
G[12032]={'66:22.7,72.5 66:22.8,72.4 202:54.9,16.6'}
G[12042]={'80:52.51,40.55'}
G[12096]={'91:43.12,17.61'}
G[12097]={'91:46.7,84.1'}
G[12225]={'280:0.00,0.00'}
G[12238]={'280:25.7,78.4'}
G[12277]={'66:33.94,53.48'}
G[12340]={'66:23.3,72.8'}
G[12384]={'23:11.34,28.60'}
G[12578]={'77:60.52,25.30'}
G[12596]={'22:42.92,85.06'}
G[12617]={'23:75.85,53.41'}
G[12636]={'23:75.81,53.29'}
G[12676]={'63:73.6,76.6'}
G[12677]={'63:62,49.4'}
G[12678]={'63:41.6,67.4'}
G[12696]={'63:49.75,65.08'}
G[12717]={'63:12.76,34.19'}
G[12719]={'63:12.7,35.3'}
G[12721]={'63:38.88,42.38'}
G[12724]={'63:73.86,62.48'}
G[12737]={'63:74.19,60.72'}
G[12757]={'63:37.77,43.49'}
G[12759]={'63:48.23,69.75'}
G[12818]={'63:41.49,34.46'}
G[12837]={'63:74.11,60.91'}
G[12858]={'63:68.34,75.30'}
G[12863]={'63:12.46,35.14'}
G[12867]={'63:73.56,60.87'}
G[12877]={'63:73.04,62.47'}
G[12919]={'70:58.76,60.17'}
G[12920]={'14:68.51,37.82'}
G[12939]={'70:67.76,48.97'}
G[12944]={'243:50.31,58.48'}
G[12997]={'499:52.90,55.35','Deeprun Tram Ironforge side'}
G[13018]={'499:51.75,55.06','Deeprun Tram Stormwind side'}
G[13136]={'81:63.2,45.8'}
G[13158]={'18:87.50,43.29'}
G[13159]={'37:78.8,67.2'}
G[13176]={'91:49.6,82.7'}
G[13179]={'91:49.8,85.6 91:50.4,31 91:50.5,30.9 91:51.3,33'}
G[13180]={'91:49.7,85.7 91:50.2,60.2 91:53.9,27'}
G[13181]={'91:44.3,15.3 91:44.3,15.9 91:45.2,14 91:45.4,14.6 91:45.5,14.4 91:45.5,14.6 91:46.8,16.2 91:47.5,39.6 91:47.7,39 91:49.7,85.5 91:50.3,78.6 91:50.5,80 91:50.6,80.6 91:50.7,81.8'}
G[13236]={'91:50.2,85.1'}
G[13257]={'91:43.4,15.6'}
G[13283]={'84:79.46,61.26'}
G[13417]={'86:39.55,47.33'}
G[13418]={'HV 86:52.52,77.05'}
G[13429]={'HV 998:68.25,38.87'}
G[13431]={'HV 88:42.45,55.28'}
G[13433]={'HV 87:33.55,67.93'}
G[13434]={'HV 87:33.5,67.6'}
G[13435]={'HV 84:62.81,70.06'}
G[13437]={'91:43.3,18.1 91:48.3,84.3 91:48.4,84.6 91:48.5,84.9 91:49.1,81.5 91:50.6,75.7 91:51.3,61'}
G[13438]={'91:43.1,18.2 91:50.4,65.4 91:50.4,65.5 91:50.5,65.6'}
G[13439]={'91:43.2,18.3 91:44.2,16.1 91:44.8,16.4 91:45.4,16.5 91:45.7,16.5 91:46.8,16.5 91:47.2,16.3 91:47.5,40 91:47.6,39.4 91:47.8,37 91:47.8,38.2 91:48,36.2 91:48,41.3 91:48.3,41.9 91:48.4,16 91:48.6,43.1 91:48.7,35.4 91:48.7,51.3 91:48.7,52 91:48.9,44.3 91:48.9,47.3 91:48.9,47.9 91:48.9,48.6 91:49,16 91:49.1,44.9 91:49.2,46.1 91:49.2,53.4 91:49.4,59.1 91:49.7,16 91:49.7,19.3 91:49.7,19.9 91:49.8,18.1 91:49.8,54.1 91:49.9,57.8 91:50,16.9 91:50.1,57.1 91:50.2,55.3 91:50.2,55.9 91:50.3,21.1 91:50.3,78.9 91:50.3,81.4 91:50.4,60.3 91:50.4,78 91:50.4,80 91:50.4,81.6 91:50.5,81.6 91:50.6,63.4 91:50.6,77.7 91:50.7,22 91:50.7,77.1 91:50.7,81.4 91:50.8,22.6 91:50.8,60.4 91:50.9,60.5 91:51,62.3 91:51.1,23.9 91:51.1,27.4 91:51.1,28 91:51.2,25.1 91:51.2,26.1 91:51.2,28.6 91:51.4,32.8 91:51.6,29.2 91:51.6,32.2 91:51.6,32.9 91:51.8,31 91:51.9,30.4 91:51.9,64.6 91:52.3,66.1'}
G[13442]={'91:43.9,12.7'}
G[13444]={'HV 87:33.15,65.45'}
G[13445]={'HV 86:49.63,78.00'}
G[13596]={'280:0.00,0.00'}
G[13616]={'91:57,82.5'}
G[13617]={'91:42.55,16.82'}
G[13636]={'25:42.34,41.14'}
G[13776]={''}
G[13777]={'25:43.1,43.9'}
G[13797]={'91:45.6,16.6'}
G[13798]={'91:49.3,81.8 91:50.2,80.4 91:50.4,81.3 91:50.7,81.3 91:50.7,81.7'}
G[13816]={'25:45.4,45.3 91:42.6,13.4 91:42.6,13.8'}
G[13817]={'25:58.69,34.24'}
G[13840]={'25:57.79,33.32'}
G[13841]={'25:44.7,46.2'}
G[14266]={'48:61.71,73.04'}
G[14305]={'HC Near'}
G[14322]={'234:62.6,66.2'}
G[14324]={'235:31.81,31.21'}
G[14325]={'234:49.8,78.2'}
G[14326]={'234:69.8,76.6'}
G[14338]={'234:27.8,55.1 234:28.4,55.5 234:28.5,55.4 234:28.5,55.5'}
G[14347]={'81:29.6,10.6'}
G[14358]={'236:48.36,53.75 69:60.32,30.15>234','Upstairs'}
G[14368]={'234:72.4,16.4 234:72.4,16.8 234:72.4,17.5 234:72.5,16.3 234:73,16.6 234:73.1,15.4 234:73.5,15.3 234:73.6,16.6 234:73.7,17.5 234:74.3,16.4 234:74.8,16.7 234:74.9,16.4 234:75,17.5'}
G[14375]={'85:45.2,69.5 85:45.2,72.4 85:45.3,69.2 85:45.3,73.1 85:45.9,73.3 85:46.1,67.8 85:46.1,75.6 85:46.5,76.7 85:46.6,67.4 85:46.7,63.7 85:46.7,67.5 85:46.7,76.1 85:47,64.5 85:47.1,77.9 85:47.4,79 85:47.6,79 85:48.2,66.4 85:48.2,79.8 85:48.3,66.5 85:48.7,71.9 85:48.7,83.5 85:48.8,66.4 85:48.8,79.6 85:49,66.5 85:49,82.6 85:49.1,82.4 85:49.4,81.3 85:49.5,80.2 85:49.5,81.5 85:49.6,66.3 85:49.6,81.1 85:49.9,71.8 85:50,64.1 85:50,70.5 85:50.3,66.7 85:50.6,66.3 85:50.7,80.6 85:50.8,64 85:50.9,66.7 85:51,64.6 85:51.4,67.8 85:51.4,69.9 85:51.4,72.4 85:51.4,79.3 85:51.4,80.2 85:51.5,64.2 85:51.5,66.4 85:51.5,78.9 85:51.5,81.1 85:51.6,67.8 85:51.6,78.2 85:51.6,80.4 85:51.7,81.8 85:51.8,69.4 85:51.8,70 85:51.8,76.9 85:51.9,66.9 85:51.9,71 85:51.9,71.6 85:51.9,72.5 85:51.9,74.6 85:51.9,75.9 85:52,83.1 85:52,83.7 85:52.1,73.9 85:52.2,84.8 85:52.3,85.7 85:52.5,75.7 85:52.5,81.1 85:52.5,81.9 85:52.6,77.6 85:52.7,77 85:53,74.7 85:53.1,74.3 85:53.1,79.5 85:53.6,74 85:53.9,73.1'}
G[14381]={'234:74,13 234:74.3,12.3 234:75.1,12.3'}
G[14382]={'234:78.1,12 234:78.6,11.4 234:79.1,11.5 234:79.4,12.9 234:79.7,13.4 234:79.7,14 234:80,11.3 234:80.1,12.1 234:80.7,12.2 234:81.3,12.5 234:81.4,11.3 234:81.6,12.3 234:81.9,11.4 234:81.9,12.9 234:82.5,12.4 234:82.8,13 234:82.9,11.4'}
G[14383]={'234:83.2,23 234:83.3,24.9 234:83.3,26.2 234:83.4,22.4 234:83.4,23.8 234:83.6,26.5 234:83.8,21.1 234:84,24.2 234:84.2,22.3 234:84.2,25 234:84.3,23 234:84.3,25.5 234:84.5,21.8 234:84.5,23.3 234:84.5,23.9 234:84.5,25.2 234:84.5,26.3'}
G[14387]={'36:54.22,83.34'}
G[14392]={'85:51.2,82.4 85:51.3,83.5 85:51.4,74.5 85:51.4,83.1 85:51.5,83.1 85:51.5,83.5 85:51.7,75.7 85:51.7,76.5 85:51.8,75.3 85:52.4,78.4 85:52.4,82.4 85:52.5,82.6 85:52.6,82.1 85:52.9,78 85:53,77.2 85:53.1,79.1'}
G[14394]={'84:67.17,85.49'}
G[14435]={'81:27,14'}
G[14437]={'36:8.39,35.78'}
G[14444]={'HC Near'}
G[14508]={'210:45.01,25.39','Walks around arena at times'}
G[14624]={'32:38.67,28.68'}
G[14625]={'32:38.11,26.97'}
G[14626]={'32:36.14,28.25 32:37.38,28.93'}
G[14627]={'32:38.46,27.86'}
G[14628]={'32:43.77,28.70'}
G[14634]={'32:37.73,26.58'}
G[14636]={'32:45.86,29.65'}
G[14637]={'69:48.68,44.81'}
G[14720]={'86:48.38,71.27'}
G[14721]={'84:71.45,80.45'}
G[14725]={'89:63.2,22.5 89:63.8,22.7'}
G[14726]={'85:63.4,51.1 85:63.5,51'}
G[14727]={'85:37.3,87.5 85:37.8,87.8 85:38,87.2'}
G[14728]={'88:43.3,42.8 88:43.7,42.5 88:43.9,42.1'}
G[14729]={'998:5.4,58.4 998:44.1,34.9 998:63,71.2 998:70.9,29.6 998:71.4,28.3 998:71.4,28.8 998:71.9,28.9 998:72.1,28.3 998:72.3,29.5 998:72.5,28.4 998:72.5,29.4 998:72.6,29.9'}
G[14731]={'26:78.13,81.39'}
G[14733]={'63:61.9,83.9'}
G[14739]={'26:78.80,78.25'}
G[14740]={'26:80.33,81.53'}
G[14741]={'26:79.16,79.53'}
G[14753]={'63:61.5,83.8'}
G[14754]={'10:40.2,20'}
G[14822]={'HF 407:53.22,75.84'}
G[14828]={'HF 407:47.76,64.79'}
G[14829]={'HF 407:51.10,82.04'}
G[14832]={'HF 407:47.90,67.12'}
G[14833]={'HF 407:55.00,70.78'}
G[14841]={'HF 407:49.24,60.79'}
G[14844]={'HF 407:50.55,69.56'}
G[14845]={'HF 407:52.91,67.93'}
G[14847]={'HF 407:51.89,60.93'}
G[14871]={'HF 407:55.93,70.72'}
G[14875]={'224:14.2,15.5'}
G[14902]={'224:15.3,14.5'}
G[14903]={'224:15.3,16.1'}
G[14904]={'224:15.3,16'}
G[14905]={'224:14.1,13.7'}
G[14910]={'224:15.3,15.4 224:15.3,15.5'}
G[14921]={'224:15.1,16'}
G[14983]={'14:39.95,46.68'}
G[15011]={'HH 27:59.6,34.4'}
G[15012]={'HH 1:46.1,13.7'}
G[15021]={'14:68.4,30.4 14:73.3,29.8'}
G[15042]={'337:62.3,56.5'}
G[15070]={'224:14.5,15.8'}
G[15077]={'HX 210:41.6,73.0'}
G[15078]={'HX 210:41.5,73.0'}
G[15079]={'HX 210:41.4,73.0'}
G[15116]={'HX 86:52.36,77.13'}
G[15119]={'HX 87:28.17,74.93'}
G[15126]={'14:68.4,30.4 14:68.4,30.5 14:68.5,30.4 14:68.5,30.5 14:73.4,29.8'}
G[15127]={'14:40.1,46.6'}
G[15170]={'81:46.42,79.07'}
G[15171]={'81:46.01,79.40'}
G[15174]={'81:55.53,36.77'}
G[15177]={'81:54.40,32.73'}
G[15181]={'81:53.21,32.50'}
G[15182]={'81:54.6,32','Top of tower'}
G[15183]={'81:53.62,35.31'}
G[15189]={'81:55.38,36.26'}
G[15190]={'81:55.30,36.20'}
G[15191]={'81:54.89,36.02'}
G[15192]={'75:41.77,49.88'}	-- should this get a pointer from outside the caverns in Tanaris?
G[15194]={'81:68.65,63.04'}
G[15197]={'HW 998:67.42,13.20'}
G[15270]={'81:53.19,35.20'}
G[15278]={'467:61.03,45.13 94:38.02,21.00>467'}
G[15279]={'467:64.76,46.50 94:39.23,21.46>467'}
G[15280]={'467:65.48,43.74 94:39.4,20.6>467'}
G[15281]={'467:52.88,49.77 94:35.37,22.52>467'}
G[15283]={'467:63.87,46.45 94:38.94,21.45>467'}
G[15284]={'467:65.32,43.20 94:39.4,20.45>467'}
G[15285]={'467:63.84,42.10 94:38.9,20.1>467'}
G[15295]={'467:63.97,42.83 94:38.97,20.26>467'}
G[15296]={'467:61.80,39.36 94:38.27,19.12>467'}
G[15297]={'467:58.47,38.79 94:37.20,19.05>467'}
G[15298]={'467:41.09,70.78 94:31.57,29.48>467','Up on platform'}
G[15301]={'94:40.42,32.21'}
G[15303]={'HF 407:52.50,56.13'}
G[15306]={'81:53.16,35.11'}
G[15309]={'998:67.48,6.62'}
G[15310]={'37:32.04,50.39'}
G[15339]={'247:39.95,75.32'}
G[15340]={'247:30.93,37.96'}
G[15378]={'319:51.6,84.6 81:28.7,89.7>319'}
G[15379]={'321:50.40,84.39'}
G[15380]={'319:50.6,85.6 81:28.7,89.7>319'}
G[15395]={'77:64.01,10.31'}
G[15397]={'94:43.68,71.30'}
G[15398]={'94:34,80'}
G[15399]={'94:60.32,62.77'}
G[15400]={'94:59.52,62.60'}
G[15401]={'94:36.70,57.44'}
G[15402]={'94:54.28,70.97'}
G[15403]={'94:48.16,46.00'}
G[15404]={'94:36.36,66.77'}
G[15405]={'94:44.63,53.14'}
G[15406]={'94:70.45,72.35'}
G[15407]={'94:62.2,79.6'}
G[15409]={'94:35.0,84.6'}
G[15416]={'94:50.33,50.76'}
G[15417]={'94:44.72,69.63'}
G[15418]={'94:47.25,46.30'}
G[15433]={'94:48.15,47.66'}
G[15498]={'327:59.39,14.05'}
G[15499]={'327:59.48,14.05'}
G[15500]={'327:59.53,14.00'}
G[15502]={'319:59.3,68.4'}
G[15503]={'319:59.4,68.5'}
G[15504]={'319:59.2,68.5'}
G[15513]={'467:64.20,42.07 94:39.05,20.01>467'}
G[15549]={'HL 242:50.53,62.95 36:14.58,9.21>242'}
G[15556]={'HL 281:51.46,93.73 66:29.10,62.56>281'}
G[15557]={'HL 36:70.12,45.40'}
G[15558]={'HL 48:33.33,46.55'}
G[15559]={'HL 26:50.00,48.03'}
G[15560]={'HL 252:61.78,40.08 36:24.30,25.66>250'}
G[15561]={'HL 21:44.96,41.15'}
G[15562]={'HL 37:34.56,50.26'}
G[15563]={'HL 17:54.28,49.49'}
G[15564]={'HL 998:66.62,38.20','Upstairs, outside'}
G[15565]={'HL 37:39.79,63.67'}
G[15566]={'HL 23:75.73,54.56'}
G[15567]={'HL 32:21.30,79.10'}
G[15568]={'HL 18:61.86,53.91'}
G[15569]={'HL 27:53.92,49.93'}
G[15570]={'HL 81:30.80,13.32'}
G[15572]={'HL 1:53.22,43.61'}
G[15573]={'HL 71:37.24,79.05'}
G[15574]={'HL 83:59.96,49.94'}
G[15575]={'HL 7:48.50,53.25'}
G[15576]={'HL 210:39.94,72.51','On roof'}
G[15577]={'HL 52:56.63,47.09','Top of tower'}
G[15578]={'HL 219:34.51,39.35 71:39.22,21.34>219'}
G[15579]={'HL 86:52.28,59.95'}
G[15580]={'HL 88:72.96,23.31'}
G[15581]={'HL 69:76.71,37.89'}
G[15582]={'HL 10:68.36,69.96'}
G[15583]={'HL 78:50.37,76.17'}
G[15584]={'HL 64:46.34,51.00'}
G[15585]={'HL 36:52.39,23.94'}
G[15586]={'HL 71:51.40,28.81'}
G[15587]={'HL 69:62.56,31.07'}
G[15588]={'HL 199:41.60,47.44'}
G[15592]={'HL 23:35.58,68.82'}
G[15593]={'HL 220:62.93,34.38 51:69.68,53.45>220'}
G[15594]={'HL 22:69.18,73.44','On ramparts'}
G[15595]={'HL 57:56.85,53.10'}
G[15596]={'HL 50:71.04,34.29'}
G[15597]={'HL 10:48.52,59.26'}
G[15598]={'HL 89:39.22,31.86'}
G[15599]={'HL 81:53.02,35.47'}
G[15600]={'HL 76:64.73,79.35'}
G[15601]={'HL 62:49.53,18.95'}
G[15602]={'HL 22:63.51,36.13','In cave'}
G[15603]={'HL 77:38.36,52.85'}
G[15604]={'HL 64:77.09,75.61'}
G[15605]={'HL 63:35.54,48.92'}
G[15606]={'HL 83:53.22,56.75'}
G[15607]={'HL 317:78.64,22.09 23:27.07,15.77>317'}
G[15608]={''}
G[15651]={'94:33.82,55.58'}
G[15659]={'84:62.39,75.02'}
G[15670]={'94:28.2,60.4'}
G[15693]={'81:33.25,81.23'}
G[15700]={'HQ 85:38,86'}
G[15727]={'321:54.82,59.15'}
G[15732]={'27:60.30,33.84 56:9.17,60.70 71:52.57,28.06 84:67.84,71.45 125:49.33,44.85 210:40.28,67.64'}
G[15864]={'HL 80:53.65,35.26'}
G[15871]={'HL 87:29.22,17.12'}
G[15891]={'HL 86:49.89,81.20 998:66.0,36.8 88:38.38,63.40'}
G[15892]={'HL 87:30.90,61.58'}
G[15895]={'HL 37:34.24,50.56 87:28.83,16.22 89:38.60,30.27 86:52.38,58.49 111:53.2,32.8 88:71.10,28.25 998:65.60,35.99 125:47.63,43.76 103:74.01,57.48 110:73.05,82.56 390:85.30,64.90 390:62.92,19.27'}
G[15920]={'94:29.90,58.52'} -- 462:30.22,58.33 462:29.88,58.48 462:29.85,58.46 462:30.25,58.44
G[15921]={'94:36.35,66.62'}
G[15924]={'94:67.80,56.54'}
G[15939]={'94:43.34,70.82'}
G[15941]={'94:45.19,56.43'}
G[15942]={'94:46.93,71.78'}
G[15945]={'94:44.87,61.04'}
G[15951]={'94:60.32,61.38','Up ramp'}
G[15965]={'94:69.23,52.15'}
G[15968]={'94:36.6,60.6'}
G[15969]={'94:68.71,46.95'}
G[15970]={'94:55.70,54.50'}
G[15989]={'164:0.00,0.00'}
G[15991]={'108:57.7,56'}
G[16112]={'23:75.35,76.18'}
G[16115]={'23:76.70,73.10'}
G[16116]={'23:72.65,74.84'}
G[16128]={'125:30.63,48.59'}
G[16134]={'23:73.78,51.88'}
G[16135]={'23:30.22,56.88'}
G[16144]={'94:38.15,73.55'}
G[16183]={'94:49,89'}
G[16191]={'110:53.93,71.02'}
G[16192]={'94:54.37,50.72'}
G[16196]={'94:49,89'}
G[16197]={'95:46.33,28.37'}
G[16198]={'95:47.66,34.86'}
G[16199]={'95:46.02,31.97'}
G[16200]={'95:46.03,33.57'}
G[16201]={'95:72.30,19.10'}
G[16202]={'95:72.50,32.13'}
G[16203]={'95:71.95,32.64'}
G[16204]={'95:54.86,48.57'}
G[16205]={'95:48.91,31.32'}
G[16210]={'94:44.03,70.76'}
G[16213]={'95:45.48,32.43'}
G[16219]={'95:69.3,15.2'}
G[16220]={'95:72.37,29.64'}
G[16224]={'95:47.25,28.54'}
G[16227]={'10:69.13,70.70'}
G[16231]={'95:44.89,32.52'}
G[16237]={'95:60.29,35.63'}
G[16239]={'95:55.08,48.83'}
G[16240]={'95:54.83,48.35'}
G[16251]={'95:44.74,32.28'}
G[16252]={'95:44.77,32.44'}
G[16253]={'95:48.43,30.93'}
G[16261]={'94:43.69,71.55'}
G[16280]={'94:61.32,54.03'}
G[16289]={'95:44.85,32.81'}
G[16291]={'95:55,48.6'}
G[16293]={'95:31.44,48.32'}
G[16295]={'95:62.90,32.77'}
G[16314]={'95:16.2,57.6'}
G[16339]={'95:79.67,17.68'}
G[16362]={'94:44.2,85.4'}
G[16365]={'23:75.66,52.05'}
G[16388]={'Z350'}
G[16397]={'94:43.57,71.21'}
G[16399]={'210:48.3,63.3'}
G[16416]={'83:58.03,52.21'}
G[16417]={'71:50.4,27.2'}
G[16418]={'10:65.83,71.92'}
G[16462]={'95:72.20,29.77'}
G[16463]={'95:72.32,31.26'}
G[16464]={'95:72.62,31.56'}
G[16475]={'468:61.18,29.49 97:84.3,43>468'}
G[16477]={'468:52.76,35.88 97:80.4,45.8>468'}
G[16480]={'95:46.40,56.43'}
G[16499]={'468:51.55,44.45 97:79.8,49.4>468'}
G[16500]={'468:50.88,42.34 97:79.6,48.8>468'}
G[16501]={'468:51.11,41.13 97:79.7,48.3>468'}
G[16502]={'468:52.12,41.43 97:80,49.5>468'}
G[16503]={'468:50.87,43.85 97:79.6,49.4>468'}
G[16514]={'468:49.87,37.34 97:79.2,46.4>468'}
G[16522]={'468:27.78,80.42 97:69.27,65.77>468'}
G[16535]={'468:50.65,48.75 97:79.4,51.4>468'}
G[16546]={'468:33.90,69.38 97:72,60.8>468'}
G[16551]={'97:48.7,50.3'}
G[16553]={'97:48.4,49.2'}
G[16554]={'97:64.5,54.1'}
G[16574]={'100:54.3,37.9'}
G[16575]={'100:55.1,36.3'}
G[16576]={'100:65.1,44.2'}
G[16577]={'100:55.2,39.1'}
G[16583]={'100:53.2,38.2'}
G[16588]={'100:52.3,36.4'}
G[16601]={'95:57.54,14.94'}
G[16642]={'110:66.73,16.78'}
G[16648]={'110:73.05,45.28'}
G[16653]={'110:59.16,19.70'}
G[16655]={'110:71.2,56.2'}
G[16658]={'110:53.10,26.65'}
G[16661]={'110:71.73,55.75'}
G[16674]={'110:84.71,28.06'}
G[16681]={'110:92.20.37.53'}
G[16684]={'110:79.66,52.14'}
G[16721]={'97:24.45,54.55'}
G[16723]={'103:27.77,60.01'}
G[16749]={'103:47.26,62.31'}
G[16756]={'103:38.9,51.1'}
G[16761]={'103:38.93,84.85'}
G[16768]={'103:57.0,50.6'}
G[16781]={'109:32.26,68.44'}
G[16789]={'100:28.4,60.3 100:28.5,60.2'}
G[16790]={'100:27.7,60.4'}
G[16791]={'100:27,59.6'}
G[16792]={'100:27,59.8'}
G[16793]={'100:26.4,60.4 100:26.5,60.3'}
G[16794]={'100:26.8,59.7'}
G[16796]={'100:23.42,36.55'}
G[16797]={'100:23.35,37.43 100:23.36,39.32 100:23.37,41.20'}
G[16799]={'100:23.1,40.3'}
G[16802]={'110:53.81,20.26'}
G[16808]={'246:67.31,55.47'}
G[16813]={'Z350'}
G[16814]={'Z350'}
G[16815]={'Z350'}
G[16817]={'HM 84:49.53,72.26 87:63.77,25.33 89:62.17,48.67 103:41.6,24.7 111:61.36,31.92'}
G[16818]={'HM 86:47.73,38.20 88:21.61,27.73 998:67.64,8.27 110:69.86,42.96'}
G[16819]={'100:56.64,66.69'}
G[16820]={'100:50.91,60.20'}
G[16822]={'100:54.67,62.36'}
G[16825]={'100:54.29,63.58'}
G[16826]={'100:54.22,63.59'}
G[16827]={'100:50.88,60.35'}
G[16833]={'100:23.14,40.17'}
G[16834]={'100:23.01,40.37'}
G[16837]={'100:52,62.4 100:52,62.5'}
G[16839]={'100:56.69,66.51'}
G[16841]={'17:54.66,50.44'}
G[16845]={'100:32,27.9'}
G[16850]={'100:23.89,72.17'}
G[16851]={'100:23.98,72.34'}
G[16852]={'100:26.90,37.45'}
G[16857]={'100:49.4,65.6'}
G[16858]={'100:61,81.6'}
G[16885]={'100:16.03,52.15'}
G[16888]={'100:15.80,52.17'}
G[16915]={'100:51.36,30.53'}
G[16924]={'94:47.77,46.58'}
G[16991]={'100:15.70,52.08'}
G[16993]={'100:24.6,76.1'}
G[17006]={'100:23.09,40.22'}
G[17015]={'100:26.4,61.8 100:27.1,61.9'}
G[17062]={'100:33.6,43.6'}
G[17071]={'468:50.50,47.87 97:79.4,51>468'}
G[17079]={'81:54.6,62.8'}
G[17080]={'81:39.57,46.97'}
G[17081]={'81:53,34.7'}
G[17082]={'81:54.49,32.94'}
G[17084]={'100:25.85,74.85'}
G[17085]={'100:28.99,81.46'}
G[17089]={'468:50.20,43.14 97:79.28,49.13>468'}
G[17092]={'25:56.74,47.47'}
G[17094]={'50:38.12,50.09'}
G[17095]={'70:35.86,31.74'}
G[17098]={'85:31.8,38.3 85:49.1,71.6 85:49.2,71'}
G[17101]={'97:61.1,54.2'}
G[17106]={'63:35,49.9'}
G[17110]={'97:49.8,51.9'}
G[17114]={'97:49.37,51.08'}
G[17116]={'97:47.2,50.6'}
G[17120]={'103:55.6,82.6'}
G[17122]={'103:47.59,88.32'}
G[17123]={'100:32.1,28.3'}
G[17127]={'51:26.86,33.57'}
G[17192]={'97:33.83,18.41'}
G[17204]={'103:29.38,33.36 103:31.27,27.71'}
G[17214]={'97:48.39,51.77'}
G[17215]={'97:48.39,51.48'}
G[17226]={'100:26.3,63.7 100:26.4,63.1 100:27,62.7 100:27.1,62.1'}
G[17232]={'97:49.39,50.95'}
G[17240]={'97:47,70.1'}
G[17241]={'97:47.1,70.3'}
G[17242]={'97:47.2,70.1'}
G[17246]={'97:46.7,70.5'}
G[17287]={'63:84,62.7'}
G[17291]={'63:86.9,44.8'}
G[17303]={'63:84,62.7'}
G[17304]={'63:90.94,58.14'}
G[17307]={'347:36.71,81.31'}
G[17308]={'347:42.18,70.96'}
G[17310]={'63:83.9,63'}
G[17311]={'12:28.92,32.71 97:16.37,94.03'}
G[17312]={'97:13.62,73.22'}
G[17326]={'106:48.44,94.17'}
G[17355]={'63:73.16,60.11'}
G[17360]={'97:49.44,50.97'}
G[17361]={'97:55.2,41.7'}
G[17362]={'97:64.48,39.78'}
G[17363]={'97:63.1,67.8'}
G[17364]={'97:28.11,62.39'}
G[17377]={'261:58.07,41.68'}
G[17421]={'106:42.1,21.2'}
G[17423]={'106:52.7,53.3'}
G[17424]={'106:54.7,54'}
G[17433]={'106:55.08,58.00'}
G[17434]={'106:53.3,57.7'}
G[17440]={'97:46.6,20.7'}
G[17441]={'97:44.65,23.49'}
G[17442]={'97:44.8,23.8'}
G[17443]={'97:46.9,22.2'}
G[17445]={'97:46.8,21.2'}
G[17468]={'103:32.86,54.48'}
G[17480]={'97:50.02,50.52'}
G[17488]={'97:48.9,51.1'}
G[17493]={'100:55.2,36.1'}
G[17508]={'106:37.4,61.4 106:37.6,61.3'}
G[17514]={'103:46.4,63.1 103:46.6,62.7'}
G[17528]={'106:38.42,82.00'}
G[17538]={'103:57.89,41.42'}
G[17545]={'107:35.4,77.8 107:35.5,77.7'}
G[17554]={'106:57.68,53.88'}
G[17555]={'103:54.48,36.31'}
G[17584]={'103:81.49,51.43','On the surface'}
G[17586]={'106:63.1,87.9'}
G[17587]={'97:37.6,19.7 97:40.0,37.6 97:42.0,57.6 97:40.6,71 97:46.7,31.9 97:54.0,42.6 97:55.8,29.0 97:55.8,48.2 97:57.6,60.8 97:58.6,41.6'}
G[17599]={'106:63.43,88.73'}
G[17600]={'106:61.2,48.4 106:61.2,48.5'}
G[17613]={'42:47,75.4 42:47,75.5'}
G[17614]={'97:24.2,54.3'}
G[17634]={'102:68.66,50.21'}
G[17636]={'109:32.3,63.6'}
G[17637]={'102:34.1,51'}
G[17642]={'106:55.9,56.9'}
G[17649]={'106:63.00,87.55'}
G[17658]={'106:52.69,53.22'}
G[17663]={'106:56.3,56.8'}
G[17674]={'106:73.9,33.4 106:74.3,34 106:74.5,33.6 106:74.6,33.4 106:75.1,34.6'}
G[17676]={'106:53.3,57.1'}
G[17682]={'106:68.26,81.08'}
G[17684]={'106:55.43,55.26'}
G[17686]={'106:24.88,34.36'}
G[17703]={'106:53.3,54.1 106:53.4,54.5 106:53.5,54.5 106:53.6,54.4 106:54.1,61.5 106:54.2,58.2 106:54.3,55.5 106:54.3,58.7 106:54.3,60.4 106:54.3,60.7 106:54.5,56 106:54.5,59.5 106:54.5,60.7 106:54.6,58.3 106:54.7,55.1 106:54.8,56.9 106:55.1,59.1 106:55.4,54.4 106:55.5,54.4 106:55.6,56.6 106:55.8,55.2 106:56,55.8'}
G[17712]={'106:79,22.3 106:79.1,22.7'}
G[17798]={'263:77.76,43.87'}
G[17825]={'106:54.44,54.45'}
G[17831]={'102:23.32,66.21','Sometimes on a quest - will be back'}
G[17834]={'102:78.54,63.15'}
G[17841]={'102:78.40,62.01'}
G[17843]={'106:55.63,55.21'}
G[17844]={'106:55.55,55.43'}
G[17849]={'94:42.03,35.65'}
G[17856]={'102:19.54,50.05'}
G[17858]={'102:79.08,65.27'}
G[17866]={'102:19.65,49.69'}
G[17876]={'N:4949'}
G[17877]={'102:19.80,50.83'}
G[17881]={'273:47.92,68.38'}
G[17882]={'262:26.97,46.22'}
G[17904]={'102:79.11,64.88'}
G[17909]={'102:80.32,64.17'}
G[17923]={'102:19.12,63.48'}	-- 467:19.04,62.36 467:19.00,63.38 467:19.18,64.59 pacing between the points
G[17924]={'102:19.67,52.06'}
G[17925]={'102:19.14,49.38'}
G[17926]={'106:30.3,46'}
G[17927]={'106:30.3,46'}
G[17942]={'265:85.65,67.46'}
G[17956]={'102:80.39,64.16'}
G[17969]={'102:83.37,85.53'}
G[17977]={'266:34.09,41.27'}
G[17982]={'106:30.82,46.66'}
G[17986]={'106:30.76,46.84'}
G[18003]={'102:68.20,49.38'}
G[18004]={'102:68.34,50.08'}
G[18005]={'102:67.81,47.91'}
G[18006]={'102:67.65,47.87'}
G[18007]={'102:68.62,48.73'}
G[18008]={'102:41.95,27.19'}
G[18009]={'102:40.85,28.66'}
G[18010]={'102:41.61,27.29'}
G[18011]={'102:85.2,54.7'}
G[18012]={'102:85,54.1'}
G[18013]={'102:30.7,50.9'}
G[18014]={'102:32.9,48.9'}
G[18015]={'102:31.7,49.3'}
G[18016]={'102:84.4,54.4 102:84.5,54.4'}
G[18017]={'102:32.4,51.9'}
G[18018]={'102:32.2,49.5'}
G[18019]={'102:41.21,28.68'}
G[18020]={'106:51.8,52.1'}
G[18024]={'106:55.5,52.4 106:55.5,52.5'}
G[18035]={'102:80.8,36.3'}
G[18063]={'107:55.4,37.7 107:55.5,37.7'}
G[18066]={'107:54.8,39.4 107:54.8,39.5'}
G[18067]={'107:54.8,39.8'}
G[18068]={'107:54.6,39.9'}
G[18070]={'102:80.37,64.72'}
G[18071]={'107:60.66,22.65'}
G[18072]={'107:60.65,22.10'}
G[18073]={'107:60.80,22.38'}
G[18074]={'107:60.50,22.38'}
G[18090]={'107:55.4,37.4 107:55.4,37.5'}
G[18091]={'102:32,50.4'}
G[18096]={'274:50.44,31.56'}
G[18098]={'105:36.30,67.56'}
G[18099]={'107:61.58,22.03 107:62.14,22.80 107:61.99,24.02 107:61.20,24.91 107:60.57,24.96 107:60.08,24.38 107:59.88,23.31 107:59.58,22.47 107:59.86,21.36 107:60.40,20.87 107:60.92,21.51','Wandering around'}
G[18106]={'107:55.6,37.6'}
G[18124]={'102:81,42'}
G[18141]={'107:56.6,34.3'}
G[18165]={'25:30.9,30.8'}
G[18166]={'111:54.74,44.33'}
G[18180]={'107:71.52,40.81'}
G[18183]={'107:55.48,68.70'}
G[18200]={'107:71.57,40.53'}
G[18209]={'107:33.18,42.31'}
G[18210]={'107:31.4,44.1 107:31.5,44'}
G[18218]={'107:71.38,40.63'}
G[18221]={'51:69.90,36.55'}
G[18222]={'107:54.47,72.08'}
G[18223]={'107:54.61,72.21'}
G[18224]={'107:54.46,72.31'}
G[18229]={'107:32.4,36 107:32.5,36.1'}
G[18233]={'107:55.51,68.78'}
G[18234]={'107:55.3,37.1 107:55.3,37.7 107:55.4,38.6 107:55.5,38.5 107:55.6,37 107:55.7,37.8'}
G[18248]={'105:52,58.2'}
G[18249]={'108:49.7,43.4'}
G[18252]={'108:58.53,53.56'}
G[18253]={'42:47.2,75.1'}
G[18255]={'42:47.30,74.93'}
G[18261]={'107:73.80,62.60'}
G[18262]={'108:19.3,64.1 108:19.8,62.1 108:20,63 108:20,63.5 108:20.5,62.8'}
G[18265]={'107:31.36,57.78'}
G[18266]={'100:56.33,62.85'}
G[18267]={'100:55.9,39.1'}
G[18273]={'108:19.7,60.8 108:77.4,87.8'}
G[18276]={'107:30.78,58.14'}
G[18285]={'102:32.80,59.60'}
G[18294]={'107:71.38,40.57'}
G[18295]={'102:68.55,49.36'}
G[18300]={'107:55.6,37.6'}
G[18301]={'107:55.2,36.1'}
G[18302]={'107:56.4,34.4 107:56.6,34.3 107:57.1,34.8'}
G[18333]={'107:31.77,56.79'}
G[18335]={'107:51.94,34.78'}
G[18340]={'102:70.51,80.31'}
G[18343]={'272:32.61,60.35'}
G[18344]={'272:32.56,52.69'}
G[18353]={'107:55.05,70.54'}
G[18369]={'107:72.56,70.69'}
G[18373]={'256:0.00,0.00'}
G[18383]={'108:48.8,45.6'}
G[18384]={'108:50.1,46.4'}
G[18385]={'108:50.1,44.9'}
G[18386]={'108:48.9,44.7'}
G[18387]={'108:58.29,54.76'}
G[18389]={'108:57.83,54.24'}
G[18390]={'108:57.40,55.43'}
G[18407]={'107:55.8,37.9'}
G[18408]={'107:54.74,70.88'}
G[18414]={'107:32.3,36.2'}
G[18415]={'107:32.3,36.2'}
G[18416]={'107:53.03,7084 107:53.58,70.99 107:53.85,71.35 107:53.57,71.99 107:54.30,72.34 107:54.53,72.66 107:54.54,73.61 107:55.33,73.26 107:55.69,72.65 107:55.36,71.52 107:54.71,70.37 107:54.33,70.35 107:54.12,69.42 107:53.71,68.69 107:53.86,69.97','Wandering the village'}
G[18417]={'107:27.34,43.08'}
G[18424]={'108:44.03,22.44 108:44.75,21.71 108:44.89,21.12 108:43.69,23.07 108:43.29,23.02 108:43.37,22.59 108:43.44,22.39 108:44.40,24.77'}
G[18427]={'106:53.66,56.26'}
G[18445]={'107:29.52,26.01 N:18369'}
G[18446]={'108:44.33,26.31'}
G[18447]={'108:50,45.9'}
G[18459]={'108:57.01,53.49'}
G[18471]={'107:42.8,20.8'}
G[18473]={'259:32.81,32.17'}
G[18481]={'111:53.99,44.73'}
G[18482]={'108:11.8,99.2 108:36.4,30.2 108:36.5,30.3 108:36.6,30.6 108:38,26.4 108:38.1,26.5 108:38.7,26.6 108:39.4,24.1 108:39.4,26.3 108:39.5,26.5 108:39.6,24.1 108:40.3,24.9 108:40.4,25.6 108:40.5,25.6 108:40.7,25.4 108:41.9,26.4 108:42.3,26.5 108:42.5,26.6 108:43.3,26.4 108:43.5,26.3 108:43.6,26.5 108:44.5,26.2 108:44.6,26.5 108:45.5,26.4 108:45.5,26.5 108:46,66.7 108:46.5,26.4 108:47.2,27.1 108:47.4,66.7 108:47.9,27.2 108:47.9,66.8 108:48.4,27.5 108:48.5,27.4 108:48.6,27.7 108:48.7,67 108:49.6,28.2 108:50.4,29.2 108:50.5,29.2 108:50.6,29.5 108:84.4,54.2 108:84.8,55.4 108:86.2,55.9 108:90.2,54.7 108:90.6,54.1 108:92.3,52.7 108:94.6,51.1 108:96.6,54.1 108:97.6,53.3 108:98.2,52.4 111:9,92.8 111:37.3,26.3 111:37.7,24.6 111:37.9,26.3 111:77.4,66.9 111:77.4,67.7 111:77.5,64.4 111:77.5,64.7 111:77.6,62.9 111:78,61.3 111:78.1,61.9 111:78.8,61.5 111:79.1,57.1 111:79.1,61.4 111:79.2,58.5 111:79.8,21.3 111:79.8,21.9 111:80.1,55.4 111:80.4,55.6 111:80.4,57.1 111:80.7,55.2 111:80.7,55.9 111:80.9,54.4 111:81.1,30 111:81.1,30.7 111:81.3,34 111:81.5,33.7 111:81.5,54.5 111:81.6,54.1 111:81.8,34.9 111:81.9,53.3 111:82.2,36.4 111:82.2,40.8 111:82.3,52.2 111:82.6,40.3 111:82.8,41.2 111:82.8,51.9 111:82.8,52.5 111:82.9,41.8 111:83,47.3 111:83,49.1 111:83.1,44.3 111:83.1,44.9 111:83.1,47.8 111:83.1,53.5 111:83.2,49.7 111:83.3,54.5 111:83.5,47.1 111:83.6,40.3 111:83.7,54 111:83.9,53.2 111:84,54.5 111:84.3,55.7 111:84.6,54.5'}
G[18484]={'111:72.23,30.73'}
G[18528]={'104:65.3,44'}
G[18530]={'111:42.6,91.4'}
G[18531]={'111:45.20,81.45'}
G[18537]={'111:30.72,34.60'} -- 479:29.6,14.5 479:30.7,17.4 479:30.7,17.5 481:25,21.5 481:41.6,65.2 481:82.6,49.3
G[18538]={'111:23.97,29.72'}	-- 479:29.5,13.9
G[18565]={'108:69.74,44.23'}
G[18566]={'108:63.38,42.72'}
G[18584]={'111:77.2,34.7'}
G[18594]={'111:54.61,80.71'}
G[18596]={'111:54.98,22.53'}
G[18597]={'111:64.47,15.12'}
G[18653]={'111:63.94,15.55'}
G[18675]={'108:37.06,49.53'}
G[18687]={'107:26.1,60.6'}
G[18704]={'108:58.11,53.42'}
G[18705]={'108:49.3,45.9'}
G[18708]={'260:77.70,38.73'}
G[18712]={'108:48.9,44.7'}
G[18713]={'108:57.51,55.77'}
G[18714]={'108:39,43.8'}
G[18715]={'108:40.46,36.15'}
G[18723]={''}		-- Old Hillsbrad
G[18745]={'108:57.18,55.74'}
G[18760]={'108:73.92,35.19'}
G[18785]={'100:25.19,37.23'}
G[18788]={'102:67.83,51.46'}
G[18789]={'107:54.17,75.06'}
G[18803]={'106:55.16,55.97'}
G[18804]={'106:56.1,54.5 106:56.3,54.3'}
G[18809]={'108:59.45,55.42'}
G[18816]={'107:41.2,44.3'}
G[18817]={'107:41.2,44.3'}
G[18891]={'260:17.18,22.21'}
G[18893]={'111:50.24,45.35'}
G[18927]={'84:61.67,74.19'}
G[18930]={'100:87.4,48.2'}
G[18931]={'100:87.37,52.42'}
G[18937]={'105:37.82,61.40'}
G[18938]={'109:33.75,63.99'}
G[18939]={'104:37.61,55.45'}
G[18940]={'111:64.07,41.13'}
G[18944]={'100:84.7,50.2 100:84.8,50.6 100:86.3,50.6 100:86.4,50.3 100:86.5,50.3 100:86.6,50.6 100:88.3,50.3 100:89.4,50.2'}
G[19020]={'107:55.50,36.01'}
G[19035]={'107:61.70,67.09','Pacing about'}
G[19045]={'111:57.99,15.17'}
G[19133]={'107:55.4,37.4 107:55.4,37.5 107:55.5,37.3'}
G[19137]={'107:55.01,70.39'}
G[19148]={'87:30.80,62.93'}
G[19169]={'110:89.66,49.09'}
G[19171]={'103:51.92,42.65'} -- 13:29.36,28.27 464:21.36,54.25>13
G[19172]={'87:58.14,49.39'}
G[19173]={'89:44.71,52.78'}
G[19175]={'86:51.54,75.05'}
G[19176]={'86:40.32,48.97'}
G[19177]={'86:49.98,61.47'}
G[19178]={'998:63.17,47.40'}
G[19188]={'100:15.2,40.8'}
G[19202]={'111:62.81,35.59'}
G[19217]={'109:31.4,66.2'}
G[19219]={'267:50.34,39.53'}
G[19220]={'267:0.00,0.00'}
G[19227]={'111:65.65,69.29'}
G[19229]={'100:87.34,50.75'}
G[19253]={'100:87.4,49.8'}
G[19254]={'17:54.4,50.4 17:54.4,50.5 17:54.5,50.4 17:54.5,50.7'}
G[19255]={'100:55.9,36.8'}
G[19256]={'100:58,41.3'}
G[19273]={'100:65.9,43.6'}
G[19293]={'100:15.62,52.04'}
G[19294]={'100:15.96,51.57'}
G[19306]={'272:32.52,50.64'}
G[19308]={'100:54.68,62.78'}
G[19309]={'100:61.70,60.90'}
G[19310]={'100:71.34,62.76'}
G[19333]={'104:29.8,31.3'}
G[19344]={'100:49.24,74.83'}
G[19361]={'100:16.27,65.08'}
G[19367]={'100:49.15,74.84'}
G[19370]={'104:36.8,54.8'}
G[19401]={'100:66.1,43.8'}
G[19402]={'102:83.35,37.54'}
G[19409]={'100:71.40,62.48'}
G[19412]={'Z256'}
G[19417]={'108:35.07,66.19'}
G[19428]={'258:0.00,0.00'}
G[19456]={'94:37.59,86.23'}
G[19466]={'109:32.1,64.2'}
G[19467]={'109:30.7,17.5 109:32,64.2'}
G[19468]={'109:32,64.1'}
G[19469]={'109:32,64.1'}
G[19471]={'105:53.1,54.5 105:53.2,54.4'}
G[19475]={'111:61.65,52.16'}
G[19481]={'109:58.3,86.4 109:58.4,86.5'}
G[19488]={'109:57.5,86.3'}
G[19489]={'109:57.5,86.3'}
G[19569]={'109:20.2,55.9 109:21.3,55.7 109:21.8,55.6'}
G[19570]={'109:32.6,64.4'}
G[19578]={'109:31.5,56.6'}
G[19581]={'104:63.33,30.40'}
G[19583]={'109:45.31,34.88'}
G[19589]={'109:32,55.4'}
G[19606]={'108:49.8,45.3'}
G[19617]={'109:32.3,63.9'}
G[19622]={'334:49.82,15.60'}
G[19634]={'109:34.1,68.1'}
G[19644]={'Near'}
G[19645]={'109:32.9,64.7'}
G[19670]={'108:39.42,58.53'}
G[19671]={'Z272'}
G[19674]={'108:39.38,58.47'}
G[19678]={'111:64.71,70.68'}
G[19682]={'100:61.7,81.7'}
G[19683]={'100:61.8,81.5'}
G[19684]={'111:59.67,41.43 111:77.20,43.53 111:60.71,14.64'}
G[19690]={'109:26.9,77'}
G[19697]={'108:35.09,65.09'}
G[19698]={'108:35.1,65.2'}
G[19709]={'109:32.4,66.7'}
G[19715]={'111:49.41,35.21 111:52.44,33.20 111:56.29,33.45 111:59.70,36.21 111:61.64,40.87 111:61.43,48.58 111:58.53,54.45 111:53.52,56.94 111:48.19,53.04','Walks in circle around outside of Terrace of Light'}
G[19720]={'111:43.63,29.77'}
G[19728]={'109:46.6,56.4 109:46.6,56.5'}
G[19736]={'100:61.7,81.7'}
G[19832]={'109:37.3,63.8'}
G[19840]={'109:48.2,86.7'}
G[19844]={'107:51.81,56.85'}
G[19860]={'71:51.63,28.00'}
G[19880]={'109:32.4,64.3 109:32.5,64.2'}
G[19935]={'71:57.5,56.5 71:57.6,55.9 71:57.7,55.2 71:57.9,58.4 71:58.2,54.3 71:58.2,58.7 71:58.6,54.5 71:59,58.9 71:59.1,53.9 71:59.6,54.1 71:59.8,58.2 71:60.2,57.4 71:60.3,54.7 71:60.5,55.1 71:60.5,56.8 71:60.6,55.8'}
G[19936]={'71:57.6,55.8 71:57.6,56.8 71:57.7,57.5 71:57.9,54.8 71:58.3,54.4 71:58.3,58.7 71:58.7,54.5 71:58.8,58.8 71:59.1,54 71:59.5,54.1 71:59.7,58.2 71:60,54.5 71:60,58.8 71:60.2,57.3 71:60.5,55.1 71:60.5,56.8 71:60.6,55.8 71:60.6,58'}
G[19937]={'100:56.9,77.4'}
G[19945]={'105:34.41,77.74'}
G[19990]={'105:42,21'}
G[19995]={'105:43,53'}
G[19998]={'105:40,56'}
G[20066]={'109:46.7,57'}
G[20067]={'109:44,36'}
G[20071]={'109:58.3,31.6 109:58.8,31 109:60,30.9'}
G[20084]={'109:45.8,36'}
G[20092]={'109:58.4,31.4'}
G[20102]={'10:69.03,70.67'}
G[20110]={'109:71.2,35.2'}
G[20112]={'109:34.6,37.9'}
G[20130]={'71:58.06,54.10'}
G[20142]={'71:65.35,49.72'}
G[20154]={'109:70.9,38.8'}
G[20159]={'100:5.1,51.1 100:5.7,51.1 100:6.4,50.4 100:6.5,50.5 100:6.7,50.4 100:8.4,50.1 100:9,50.5 100:9.4,50.4 100:9.6,50.5 100:9.7,50.4 100:10.5,50.3 100:11.4,50.7 100:11.6,50.5 100:12.1,50.1 100:13.2,50.1 100:13.5,50.1 100:14.9,50.1 100:15.5,51.6 100:15.6,50.9 100:16.1,50.1 100:16.5,50.7 100:17.1,50 100:17.8,49.9 100:19.2,49.6 100:19.4,48.9 100:19.5,49.4 100:19.5,49.6 100:20.7,49.2 100:21.6,49.7 100:22,49.2 100:23.2,49.2 100:23.2,49.5 100:23.8,49.5 100:24.2,49.3 100:24.7,49.3 100:24.7,49.5 100:25.3,61.9 100:25.4,60.3 100:25.5,60.7 100:25.6,61.5 100:25.7,59.7 100:26,49.4 100:26,63 100:26.1,49.5 100:26.1,58.3 100:26.3,58.8 100:26.6,58.7 100:26.7,49.4 100:26.9,49.6 100:27.4,58.2 100:27.6,57.9 100:28.1,50.1 100:28.4,57.3 100:28.5,57.5 100:28.9,50.4 100:29,50.7 100:29.1,57 100:30,51.5 100:30.2,51.4 100:30.3,57.1 100:30.7,57.3 100:31.1,52.4 100:31.1,57.5 100:31.3,52.9 100:31.6,53.3 100:31.7,53.6 100:31.8,57.5 100:31.9,57.4 100:32,54.6 100:32.3,56.4 100:32.5,56.3 100:32.5,56.6 100:45.8,52.2 100:46.6,52.1 100:48,52 100:48.8,51.8 100:50.3,55.4 100:50.3,55.9 100:50.5,54.7 100:51.5,54.1 100:51.9,52.8 100:83.3,65.9 100:85.9,64.9 100:86.8,64.9 100:90.2,65.1 100:91.1,65.1 100:91.9,65'}
G[20162]={'109:33.8,64.2'}
G[20201]={'Z273'}
G[20205]={'109:44.8,36.7'}
G[20206]={'100:56.38,62.91'}
G[20232]={'100:79.34,33.86'}
G[20233]={'468:49.72,37.53 97:79.1,46.6>468'}
G[20234]={'100:78.41,34.90'}
G[20235]={'100:78.26,34.45'}
G[20281]={'109:48.1,63.4 109:48.1,63.5 109:48.7,63.5 109:49.4,64.7 109:49.4,65.8 109:49.5,65.8'}
G[20341]={'109:34.6,37.8'}
G[20393]={'109:26.4,42.3 109:26.4,42.5'}
G[20406]={'998:57.98,90.45'}
G[20407]={'84:65.94,31.37'}
G[20415]={'109:58,84.8 109:58.6,84.8 109:59.1,78.9 109:59.1,79.5 109:59.2,80.7 109:59.2,82.4 109:59.2,83 109:59.2,83.8'}
G[20448]={'109:59.4,32.3 109:59.5,32.3'}
G[20449]={'109:59.2,32.4 109:59.3,32.5'}
G[20450]={'109:59.1,32.1 109:59.9,31.9 109:60.1,32.5'}
G[20463]={'109:57.7,85.2'}
G[20464]={'109:57.7,85'}
G[20470]={'109:44.7,34.9'}
G[20471]={'109:44.7,34.9'}
G[20482]={'109:56.8,38.7'}
G[20494]={'104:29.1,29.4 104:29.1,29.5'}
G[20510]={'104:37.6,56'}
G[20515]={'109:65.20,66.81'}
G[20518]={'109:71.2,39'}
G[20551]={'109:59.4,45.1'}
G[20552]={'109:60.9,41.6'}
G[20604]={'103:62.8,66.9 103:63.6,68.1'}
G[20612]={'110:56.6,52.8'}
G[20677]={'100:13.12,61.03'}
G[20678]={'100:15.6,58.7'}
G[20679]={'100:13.01,58.43'}
G[20735]={'125:57.22,66.83'}
G[20763]={'109:57,37.7 109:57.1,35.3 109:57.1,37.1 109:57.2,32.3 109:57.2,35.8 109:57.8,32.1'}
G[20779]={'109:54.8,43.4'}
G[20780]={'109:34.8,38.2'}
G[20793]={'100:68.30,28.54'}
G[20810]={'109:46.4,56.4 109:46.4,56.5 109:46.5,56.4 109:46.5,56.5'}
G[20811]={'109:43.5,35.1'}
G[20871]={'109:42.3,32.6'}
G[20907]={'109:60.1,31.8'}
G[20912]={'269:0.00,0.00'}
G[20913]={'109:44.7,14.5'}
G[20914]={'103:81.4,52.6'}
G[20920]={'109:26.2,41.6'}
G[20921]={'109:46.4,56.1 109:46.5,56.1'}
G[21006]={'108:69.66,44.17 108:69.67,43.95'}
G[21007]={'108:63.29,42.39 108:63.41,42.47 108:63.21,42.30 108:63.33,42.68'}
G[21024]={'104:42.2,45'}
G[21027]={'104:52.1,18.8 104:52.3,19.5 104:52.4,20.5 104:52.5,20.4 104:52.5,20.6 104:53,21.9 104:53.3,24.5 104:53.4,19.4 104:53.4,24.4 104:53.6,19.5 104:53.7,21.9 104:53.8,24.7 104:54.2,18.8 104:54.2,24.2 104:54.3,21.3 104:54.5,21.2 104:54.5,23.8 104:54.9,19.3 104:55,23.4 104:55.3,20 104:55.5,20.2 104:55.7,22.6 104:55.8,20.6 104:55.9,22'}
G[21066]={'105:36.3,67.2'}
G[21088]={'105:76,60.4'}
G[21107]={'105:61.15,70.44'}
G[21110]={'105:60.9,68.2'}
G[21112]={'105:60.7,69'}
G[21117]={'105:52.2,57.6'}
G[21118]={'105:60.1,68.3 105:60.3,69 105:60.5,68.3 105:60.5,69.3'}
G[21133]={'100:70.96,63.37'}
G[21147]={'105:51.9,58.4 105:51.9,58.5'}
G[21151]={'105:37.4,64.7 105:37.5,64.7'}
G[21158]={'105:36.3,66.3 105:36.6,66.5'}
G[21175]={'100:55.1,36'}
G[21183]={'104:53.9,23.4 104:53.9,23.5'}
G[21197]={'105:37.4,65 105:37.5,65'}
G[21209]={'100:51.15,60.22'}
G[21256]={'100:55.1,36.3'}
G[21257]={'100:66.2,42'}
G[21277]={'105:44,51.9'}
G[21279]={'100:61.2,81.7'}
G[21283]={'100:55.2,38.7'}
G[21291]={'104:44.6,23.7'}
G[21292]={'104:29.6,50.4 104:29.6,50.5'}
G[21293]={'104:47.5,57.2'}
G[21300]={'105:68.96,33.00'}
G[21311]={'105:52.8,58.9'}
G[21318]={'104:29.6,50.4 104:29.6,50.5'}
G[21330]={'104:35.8,57.7'}
G[21349]={'105:45,72.3'}
G[21357]={'104:39.5,53.7'}
G[21359]={'104:30.4,32.4 104:30.4,32.5 104:30.5,32.4 104:30.5,32.5'}
G[21400]={'108:57.66,53.31'}
G[21402]={'104:62.5,28.5 104:62.6,28.4'}
G[21411]={'111:63.95,70.03'}
G[21460]={'105:60.3,68.3'}
G[21465]={'108:77.57,38.72'}
G[21469]={'105:37,65.7'}
G[21471]={'104:40.4,41.3 104:40.5,41.3'}
G[21475]={'104:38.6,38.2'}
G[21496]={'105:75.2,62.1'}
G[21499]={'104:24,35'}
G[21657]={'104:57.1,55.5 104:57.3,54.8 104:57.3,56.6 104:57.4,54.3 104:57.5,54.6 104:57.6,57.2 104:58.3,53.8 104:58.4,58.2 104:58.6,53.5 104:58.7,53.4 104:59.2,58.4 104:59.3,58.6 104:59.5,53.4 104:59.6,58.4 104:60,53.9 104:60.2,59 104:60.4,59.5 104:60.5,59.4 104:60.6,54.2 104:61.2,54.8 104:61.2,58 104:61.4,60.1 104:61.6,58.4 104:62,55.3 104:62.2,63.4 104:62.3,60.2 104:62.3,61.5 104:62.4,55.6 104:62.5,55.4 104:62.9,60.4 104:62.9,60.5 104:63,55.7 104:63.7,61 104:63.9,56.1 104:64.4,56.7 104:64.5,56.4 104:64.7,60.8 104:65.1,57.1 104:65.6,60.7 104:65.9,57.4 104:66.1,57.6 104:66.2,60.4 104:66.5,57.7 104:66.5,60.3 104:66.5,60.5 104:67.8,60.4 104:67.9,58.2 104:68,58.5 104:68.3,60.5 104:68.3,83.9 104:68.5,58.4 104:68.8,60.9 104:69.1,83.7 104:69.2,61.7 104:69.2,85.4 104:69.3,58.6 104:69.4,63.2 104:69.4,63.6 104:69.6,63.4 104:69.7,63.8 104:69.7,84.1 104:69.8,58.9 104:70.4,86 104:70.6,59.2 104:70.6,64 104:70.9,59.8 104:71.1,85.8 104:71.2,63.4 104:71.3,60.7 104:71.5,63.5 104:71.6,62.9 104:71.7,60.9 104:71.8,62.4 104:72.1,85.3'}
G[21690]={'105:55.1,72.8'}
G[21691]={'105:60.4,69.1 105:60.5,69'}
G[21700]={'104:58.1,48.3'}
G[21755]={'105:60.3,69'}
G[21769]={'104:28.4,26.5 104:28.5,26.4 104:28.5,26.5'}
G[21770]={'104:30,28.3'}
G[21771]={'104:30.4,30.9 104:30.5,30.9'}
G[21772]={'104:29.9,27.7'}
G[21773]={'104:36.3,56.9'}
G[21774]={'104:36.4,55.7 104:36.4,56.7 104:36.6,55.6 104:36.6,56.5 104:36.8,55.2 104:38.1,54.5 104:61.8,84 104:90.2,83 104:90.3,83.9 104:90.4,82 104:90.7,82.7 104:90.7,84'}
G[21775]={'104:38.3,54'}
G[21777]={'104:36.6,55.2'}
G[21782]={'105:62.2,39.1'}
G[21789]={'104:27.4,21.2 104:27.5,21.2'}
G[21790]={'104:40.8,22.3'}
G[21797]={'104:58.2,70.8'}
G[21810]={'105:59,36'}
G[21822]={'104:61.2,29.2'}
G[21824]={'105:60.4,68.8'}
G[21826]={'104:57.3,49.6'}
G[21860]={'104:61.2,29.2'}
G[21895]={'105:75.8,61.4 105:75.8,61.5'}
G[21896]={'105:75.8,61.4 105:75.8,61.5'}
G[21902]={'108:39.51,54.37'}
G[21937]={'104:36.4,56.9'}
G[21938]={'104:28.5,26.5'}
G[21950]={'105:52.7,59'}
G[21953]={'104:54.7,58.2'}
G[21954]={'104:55.8,58.2'}
G[21955]={'104:56.3,59.5'}
G[21962]={'Z269'}
G[21983]={'105:61.9,39.4 105:61.9,39.5'}
G[21984]={'105:51.8,58.4 105:51.8,58.5'}
G[21998]={'104:21.8,40.9 104:23.1,37.1 104:23.5,34.1 104:23.6,36.9 104:27.2,42.5 104:27.4,21 104:28.4,32.6 104:28.6,32.7 104:28.8,26.9 104:29.4,28.2 104:29.8,28.4 104:30.2,28.6 104:30.3,31 104:30.8,37.9 104:30.9,30.4 104:33,39.2 104:33.9,43 104:35.3,42.5 104:35.6,41.9 104:36,39.1 104:36,68.4 104:36,69.1 104:36.7,69.4 104:37,47.9 104:37.1,37.5 104:37.2,68.3 104:37.4,69.7 104:37.7,21.5 104:37.7,38.2 104:37.7,68.2 104:37.8,38.5 104:38.4,70.2 104:38.7,71.4 104:38.7,71.9 104:39.2,69.6 104:39.3,59 104:39.3,59.9 104:39.5,65.2 104:39.8,70.5 104:40,69.6 104:40.3,69.2 104:40.4,72.2 104:40.7,38.9 104:40.7,68.1 104:40.8,69.3 104:41.1,69.6 104:41.1,71.4 104:41.5,70 104:41.9,45.6 104:42.1,72.8 104:42.2,44 104:42.2,45.1 104:42.2,68.7 104:42.4,70.7 104:42.5,67.4 104:42.5,68.4 104:42.5,72.8 104:42.8,55.6 104:42.8,70.7 104:42.9,69.4 104:43,72.2 104:43.1,51.8 104:43.1,62.6 104:43.4,66.4 104:43.4,69.9 104:43.5,63.3 104:43.5,71.2 104:43.6,73.1 104:44,72.4 104:44.1,40.2 104:44.5,52.9 104:44.6,48.4 104:44.7,44.8 104:45.8,55.5 104:46.6,48.6 104:46.9,57.1 104:47,66.3 104:47.1,63.2 104:47.2,71.6 104:47.4,47.1 104:47.4,65.4 104:47.6,57.2 104:47.7,62.7 104:48.3,57.5 104:48.4,66.5 104:48.9,63.3 104:49.2,58.6 104:49.3,61.2 104:49.3,71.2 104:49.6,59.4 104:49.6,62.4 104:49.6,71.3 104:50.2,64.6 104:50.3,63.5 104:50.4,57.4 104:50.4,57.5 104:50.4,60.8 104:50.4,68.3 104:50.4,69.9 104:50.6,63.2 104:50.8,58.1 104:50.8,58.6 104:50.8,61.3 104:50.8,65.6 104:50.9,59.8 104:50.9,64.4 104:50.9,66.8 104:51,61.6 104:51,64.5 104:51,69 104:51.1,70.6 104:51.2,68.2 104:51.3,57.4 104:51.3,69.6 104:51.5,67.8 104:51.6,57.4 104:51.6,66.3 104:51.8,53.9 104:51.8,63 104:51.8,63.7 104:51.9,61 104:51.9,72.8 104:52,65.2 104:52.1,58.2 104:52.1,60.4 104:52.1,67 104:52.1,70.3 104:52.1,72.4 104:52.2,23 104:52.2,58.9 104:52.3,62.1 104:52.4,68.5 104:52.4,70.9 104:52.5,58.3 104:52.5,72.8 104:52.6,20.8 104:52.6,59.9 104:52.6,63.6 104:52.7,69.6 104:52.8,64.5 104:52.9,57.1 104:52.9,67.4 104:52.9,71.2 104:53,59 104:53,61.2 104:53,68.4 104:53,73.8 104:53.1,68.8 104:53.2,62.6 104:53.2,66 104:53.4,22.6 104:53.4,62 104:53.4,71.6 104:53.5,62.2 104:53.5,67.1 104:53.5,71.6 104:53.6,59.7 104:53.6,64.6 104:53.6,71.4 104:53.7,61.1 104:53.7,67.9 104:53.8,69.9 104:54.1,64.4 104:54.2,63.4 104:54.2,69 104:54.4,66.1 104:54.5,58.7 104:54.5,61.1 104:54.6,59.6 104:54.6,63.2 104:54.6,63.9 104:54.6,64.5 104:54.6,65.5 104:54.8,68.9 104:54.9,38.8 104:55,49.6 104:55,69.5 104:55.3,48.3 104:55.6,59.1 104:55.7,45.2 104:55.7,67.2 104:55.8,36.6 104:56.1,61.4 104:56.9,69.1 104:58.2,70.7 104:58.6,66.4 104:58.8,41.4 104:58.8,58.5 104:59,58.3 104:59,66.7 104:59.6,56.5 104:59.7,43.1 104:59.7,70.2 104:60,42.2 104:61.1,35.2 104:61.1,67.5 104:61.2,40.6 104:61.4,63.9 104:61.7,41 104:62.3,40.3 104:62.3,55.5 104:63.2,30.5 104:63.4,47.9 104:63.4,51.4 104:64,46.5 104:64.3,39.1 104:64.4,88 104:64.7,85.1 104:65,86.1 104:69.4,50.8 104:96.8,90.1'}
G[22004]={'105:75.3,60.9'}
G[22007]={'105:61.9,39.4 105:62,39.5'}
G[22020]={'105:62.7,40.3'}
G[22024]={'104:35.2,39.3 104:35.2,40.2 104:35.2,40.8 104:35.4,37.4 104:35.4,38.3 104:35.4,41.8 104:35.5,41.9'}
G[22042]={'104:38.7,54.2'}
G[22043]={'104:31,29.9'}
G[22053]={'105:61.3,38.4 105:61.3,38.5'}
G[22059]={'104:23.6,36.8 104:34.9,67.6 104:35.6,42.5 104:36,67.9 104:36.3,55.1 104:36.3,69.5 104:36.4,56.7 104:36.6,47.5 104:36.6,56.3 104:36.6,56.5 104:37,54.8 104:37.1,68 104:37.2,66.8 104:37.5,54.9 104:37.6,55.5 104:37.7,38.6 104:37.7,67.1 104:38.1,54.4 104:38.1,67.6 104:38.2,70.2 104:38.4,57.2 104:38.4,68.5 104:38.6,55.3 104:38.7,53.7 104:39.1,45.1 104:39.1,69.1 104:39.3,69.7 104:39.7,50.6 104:40,71.5 104:40.2,71.3 104:40.3,69.3 104:40.6,55.4 104:40.6,71 104:40.7,60.2 104:40.9,21.7 104:41.2,69.2 104:41.3,70.1 104:41.8,69.2 104:42.1,45.2 104:42.1,71.4 104:42.2,72.9 104:42.3,70 104:42.5,62.3 104:42.6,68 104:42.7,72.2 104:42.8,69.3 104:42.8,69.5 104:43,70.6 104:43.2,59.1 104:43.4,54.3 104:43.4,73.2 104:43.5,70.9 104:43.5,71.8 104:43.8,70.3 104:43.9,45.4 104:44,59.2 104:44.1,72.6 104:45.2,62.1 104:45.4,55.8 104:46.7,48.9 104:46.7,54 104:46.9,58.8 104:47.5,53.7 104:49.3,58.1 104:49.3,71.3 104:49.7,68.9 104:50.1,59.8 104:50.2,62 104:50.3,62.6 104:50.4,58.3 104:50.4,64.4 104:50.8,58.8 104:50.8,62.1 104:50.9,57.7 104:50.9,59.9 104:50.9,66.7 104:50.9,69.7 104:51,64.5 104:51.1,62.8 104:51.1,69 104:51.1,70.6 104:51.3,71.5 104:51.4,61.2 104:51.4,64 104:51.4,65.6 104:51.4,68 104:51.5,62 104:51.5,72.8 104:51.8,63.2 104:51.8,66.3 104:52,58.3 104:52,64.4 104:52,65.2 104:52.1,60 104:52.1,66.5 104:52.2,59.1 104:52.2,60.7 104:52.2,68.7 104:52.2,72.4 104:52.3,67.6 104:52.3,69.6 104:52.4,71 104:52.6,69.4 104:52.7,64.1 104:52.7,66 104:52.8,71 104:52.9,63.2 104:52.9,68.4 104:52.9,69.5 104:53,61.2 104:53,65.3 104:53.2,62.2 104:53.2,66.5 104:53.3,59.7 104:53.4,59.2 104:53.4,71.9 104:53.5,59.9 104:53.5,71.5 104:53.6,63.7 104:53.8,61.1 104:53.8,69.9 104:54,67.6 104:54.1,68.7 104:54.2,56.5 104:54.2,62.7 104:54.2,65.3 104:54.2,70.5 104:54.6,49.9 104:54.7,58.8 104:54.7,63.8 104:54.7,68.8 104:55.3,50.7 104:55.5,68.9 104:55.8,59 104:55.8,66.2 104:55.9,56.4 104:56.2,57.1 104:56.4,58.4 104:56.5,57 104:56.8,68.9 104:57.4,66.8 104:57.4,73.9 104:58.3,70.7 104:59,58.7 104:62.5,88.5 104:64.6,62.5 104:67.3,87.3 104:69.8,51.6 104:93,97.3 104:96.9,99'}
G[22103]={'105:53.2,41.1'}
G[22107]={'100:61.2,81.3'}
G[22112]={'104:69.8,61.4'}
G[22113]={'104:59.4,58.7 104:62.5,60.3'}
G[22127]={'105:62.5,38.4'}
G[22133]={'105:62.6,38.3'}
G[22149]={'105:62,38'}
G[22150]={'105:62,38'}
G[22211]={'104:56.3,58.7'}
G[22214]={'104:62.2,29.2'}
G[22215]={'105:36.4,23.4 105:36.5,23.5 105:36.6,23.2 105:37.2,22.2'}
G[22216]={'105:61.68,39.62'}
G[22231]={'100:61.6,81.8'}
G[22272]={'108:37.37,51.28'} -- 478:37.37,50.94 478:37.59,51.41 478:37.16,50.92 478:37.52,51.24 478:37.51,51.54
G[22278]={'108:37.45,50.76'}
G[22292]={'111:52.53,21.00'}
G[22293]={'109:38.1,25.6'}
G[22312]={'105:74.9,60.5'}
G[22364]={'108:31.43,75.65'}
G[22365]={'108:37.73,51.35'}
G[22370]={'108:37.25,50.84 108:37.29,50.99 108:37.71,51.76 108:38.37,51.22 108:38.16,50.50 108:37.83,50.02'}
G[22373]={'111:51.78,20.79'}
G[22377]={'108:30.62,49.07','In Shadow Tomb'}
G[22386]={'105:50,36'}
G[22420]={'108:37.86,51.68'}
G[22421]={'Z265 X'}
G[22423]={'105:1.7,91.6 105:60.8,60 105:61.4,60.5 105:61.7,58.9 105:61.7,60.7 105:62.2,60.4 105:62.3,62.3 105:62.3,65.2 105:62.4,62.5 105:62.5,59.2 105:62.6,64.2 105:62.8,60.4 105:62.8,60.9 105:63,62.1 105:63,63.1 105:63,65 105:63.2,66.5 105:63.4,65.7 105:63.4,67.8 105:63.5,59.3 105:63.5,66 105:63.6,72 105:63.7,62.9 105:63.7,67.6 105:63.9,67.1 105:64,61.9 105:64,65.2 105:64.2,69.8 105:64.3,68.9 105:64.9,67.6 105:64.9,69.3 105:65.1,70.3 105:65.5,70.3'}
G[22424]={'108:53.71,72.38'}
G[22429]={'111:48.6,18.6','Walks in this area'} -- 481:49.61,16.42 481:51.67,15.10 481:52.08,17.73 481:50.13,18.25 481:45.39,22.67 481:46.43,20.02
G[22430]={'100:54.32,63.64','Upstairs'}
G[22433]={'104:65.9,87.1'}
G[22446]={'108:31.01,76.12'}
G[22456]={'108:31.06,76.53'}
G[22458]={'108:30.10,76.14'}
G[22462]={'108:49.71,76.19'}
G[22479]={'109:66.4,67.2'}
G[22481]={'108:30.98,76.18'}
G[22485]={'102:41.28,29.00'}
G[22488]={'105:32.2,91.2'}
G[22489]={'105:53,96.2'}
G[22497]={'111:56.44,49.13'}
G[22818]={'HC Near'}
G[22819]={'111:75.06,47.88'}
G[22820]={'332:48,18.2 102:51.90,33.40>332'}
G[22823]={'102:19.2,51.6'}
G[22836]={'107:31.49,57.61'}
G[22893]={'107:42.8,20.7'}
G[22899]={'109:45.8,36.2'}
G[22914]={'FC Near'}
G[22919]={'105:52.9,15 N:20482'}
G[22931]={'77:51.53,80.87'}
G[22935]={'63:85.09,43.45'}
G[22940]={'111:64.96,68.09'}
G[22941]={'105:55.48,44.86','On tower'}
G[22995]={'105:55.42,45.25'}
G[23010]={'HV 103:55.81,48.84'}
G[23035]={'259:32.55,59.78 N:80648'}
G[23038]={'108:64.09,66.89'}
G[23042]={'108:64.05,66.88'}
G[23048]={'108:64.54,66.69'}
G[23053]={'105:55.3,45.9 105:55.5,45.7 105:55.6,47.9 105:55.9,46.7'}
G[23066]={'108:69.2,78.2'}
G[23120]={'105:27.6,52.8'}
G[23127]={'87:55.3,29.1'}
G[23128]={'85:49.2,71.2'}
G[23139]={'104:66.2,85.7'}
G[23140]={'104:66.1,86.4'}
G[23141]={'104:66,86.4'}
G[23149]={'104:63,87.8 104:65.3,90.2'}
G[23158]={'Z339'}
G[23166]={'104:71.6,87.7'}
G[23233]={'105:28.8,57.4'}
G[23253]={'105:28.9,57.9'}
G[23265]={'107:55.7,37.4'}
G[23267]={'104:74.6,86.6'}
G[23268]={'107:55.40,68.69'}
G[23270]={'111:47.24,26.30'}
G[23271]={'111:35.06,32.36'}
G[23272]={'111:44.8,76.2'}
G[23273]={'111:60.86,63.53'}
G[23280]={'105:52,54.4 105:52,54.5'}
G[23286]={'104:67.8,83.4'}
G[23291]={'104:66.8,86.1'}
G[23300]={'105:28.4,58 105:28.5,58.1'}
G[23306]={'108:64.23,66.97'}
G[23316]={'105:28.4,57.6 105:28.5,57.6'}
G[23324]={'104:74.2,88.6'}
G[23334]={'105:27.4,52.7 105:27.5,52.7'}
G[23335]={'105:28,51.4 105:28,51.5'}
G[23340]={'104:64.6,82.2 104:64.7,83.3 104:64.7,83.9 104:64.7,85.1 104:65.2,85.7'}
G[23342]={'104:63.2,83.5 104:64.7,83.1 104:64.7,84.3 104:64.7,84.9 104:65.2,85.5 104:66.7,87.8 104:67.2,82.4 104:67.2,82.7 104:67.8,83.6 104:68,84.9'}
G[23344]={'104:64.7,85.9 104:64.8,82.9 104:64.9,84.1 104:65.2,85.3 104:66.9,82.8'}
G[23345]={'104:64.7,83.2 104:64.7,83.8 104:64.7,85.7 104:64.8,82 104:65,81.4 104:65.2,85.1 104:65.7,80.9 104:66.7,82.3 104:66.9,82.6 104:67.6,84.2 104:67.9,86 104:68.1,83.3 104:68.3,87.1 104:68.3,87.8 104:68.9,89 104:69.1,83.9 104:69.4,90 104:69.7,81.8 104:69.8,79.8 104:69.8,81 104:70.1,78.9 104:70.4,88.1 104:71.3,79.1 104:71.3,90.8 104:71.7,79.3 104:72.4,80.4 104:72.4,86 104:72.6,81.4 104:72.6,82.2 104:72.7,82.8 104:74.1,83.2 104:75.1,87.6 104:75.2,83.3 104:75.4,88.8 104:75.8,90.4 104:75.9,86.4 104:75.9,86.5 104:76.1,82.8 104:76.1,84.2 104:76.3,82.2 104:76.5,82.1 104:78.5,81.6 N:13437'}
G[23346]={'104:62.2,85.4 104:64.7,82.3 104:64.7,83.2 104:64.7,84.4 104:64.7,85.6 104:65.2,85 104:66.2,88.4 N:13181'}
G[23348]={'104:64.7,83 104:64.7,83.6 104:65.4,85.4 104:65.4,85.5 104:65.5,85.4 104:65.5,85.5'}
G[23376]={'104:63.4,87.5 104:63.8,87.4 104:64.5,86.8 104:64.5,87.5 104:65.4,89.4 104:65.4,89.5 104:65.5,88.3 104:65.5,88.8'}
G[23383]={'108:61,75 108:68.4,73.8 108:75.04,86.27'}
G[23413]={'105:28.28,52.10'}
G[23415]={'108:63.50,65.81'}
G[23427]={'104:66.2,85.7'}
G[23428]={'105:28.1,58.6'}
G[23433]={'111:66.62,16.42'}
G[23434]={'104:56.4,58.6 104:56.5,58.6 104:57.1,58.2'}
G[23449]={'111:64.31,42.33'}
G[23452]={'104:62.39,29.29'}
G[23461]={'111:66.4,18 111:66.4,18.7 111:66.7,18.4 111:66.8,18.6'}
G[23462]={'111:67.92,17.03'}
G[23463]={'111:67.50,18.83'}
G[23464]={'111:68.04,18.12'}
G[23465]={'111:65.89,19.13'}
G[23466]={'111:66.02,17.33'}
G[23473]={'105:27.9,52.2'}
G[23486]={'27:55.13,37.72'}
G[23546]={'117:60.53,61.08 117:60.39,60.99 117:60.56,61.28'}
G[23547]={'117:61.15,62.64 117:60.80,62.52'}
G[23548]={'117:60.17,61.03 117:60.54,61.28'}
G[23558]={'HB 27:53.68,38.55'}
G[23566]={'70:68.36,51.03'}
G[23567]={'70:29.79,47.67 70:29.73,47.62'}
G[23568]={'70:46.62,24.61'}
G[23569]={'70:63.74,17.04'}
G[23570]={'70:41.54,72.98'}
G[23572]={'70:42.33,72.93'}
G[23574]={'333:35.51,24.73'}
G[23579]={'70:41.86,73.99'}
G[23600]={'70:46.14,57.36 70:46.10,57.43'}
G[23601]={'70:46.05,57.24'}
G[23618]={'7:48.35,53.10'}
G[23627]={'HB 27:56.12,38.05'}
G[23628]={'HB 27:56.58,36.91'}
G[23706]={'1:40.73,17.35'}
G[23709]={'27:55.92,37.03'}
G[23710]={'HB 27:56.37,37.84'}
G[23723]={'70:46.66,23.05'}
G[23728]={'117:60.12,62.43'}
G[23729]={'117:58.77,62.76'}
G[23730]={'117:62.3,57.7'}
G[23736]={'117:59.79,63.24'}
G[23749]={'117:28.87,44.24 117:28.81,44.06','Pacing on the second floor of the keep'}
G[23770]={'117:33.97,43.80'}
G[23773]={'117:31.17,40.84'}
G[23778]={'117:78.68,37.13'}
G[23780]={'117:78.60,31.22'}
G[23784]={'117:83.23,43.11'}
G[23797]={'70:53.57,56.91'}
G[23804]={'117:40.29,60.26'}
G[23831]={'117:31.7,42'}
G[23833]={'117:24.24,32.46'}
G[23835]={'70:68.26,51.81','Also circles the fountain'}
G[23843]={'70:55.40,26.36 70:55.58,26.14'}
G[23859]={'117:31.25,43.97'}
G[23863]={'333:0.00,0.00'}
G[23870]={'117:36.4,48.4 117:37.4,51.9 117:41.2,49.3'}
G[23872]={'243:47.63,60.09'}
G[23888]={'117:28.94,44.19'}
G[23891]={'117:30.27,28.65'}
G[23892]={'70:72.11,47.05'}
G[23895]={'117:28.97,41.91'}
G[23896]={'70:69.24,51.89'}
G[23904]={'HW Z302'}
G[23905]={'70:69.61,51.77'}
G[23906]={'117:44.47,57.59'}
G[23938]={'117:79.15,31.22'}
G[23948]={'111:75.26,33.43'}
G[23951]={'70:65.08,47.13'}
G[23954]={'135:73.81,36.69'}
G[23961]={'133:68.49,67.11'}
G[23973]={'1:52.5,41.2 94:47.25,46.48'}
G[23975]={'117:59.80,61.48'}
G[23976]={'117:29.11,41.78'}
G[23978]={'117:31.61,41.50'}
G[24018]={'117:38.79,13.07'}
G[24027]={'117:71.12,39.08'}
G[24032]={'117:49.56,11.59'}
G[24037]={'117:84.66,36.45'}
G[24038]={'117:28.86,43.97'}
G[24056]={'117:60.27,18.69'}
G[24060]={'Near117'}
G[24061]={'117:60.06,16.10'}
G[24106]={'117:55.96,55.79'}
G[24108]={'1:41.54,17.63'}
G[24111]={'133:67.60,70.96 117:57.34,46.99>133'} -- 491:59.56,48.87
G[24117]={'117:61.49,22.85'}
G[24122]={'117:59.18,54.57'}
G[24123]={'117:49.31,11.98'}
G[24125]={'117:53,66.1'}
G[24126]={'117:78.54,28.98'}
G[24127]={'117:48.38,11.03'}
G[24129]={'117:48.04,10.74'}
G[24130]={'Near117'}
G[24131]={'117:62.66,16.80'}
G[24135]={'117:48.16,10.67'}
G[24137]={'133:67.7,66.4 133:67.9,66.3 133:67.9,66.5 133:67.9,67.3 133:68.1,68.2 133:68.2,69.6 133:68.3,68.3 133:68.4,68.7 133:68.4,68.9 133:68.4,69.6 133:68.5,67.4 133:68.5,67.7 133:68.5,68.2 133:68.5,68.9 133:68.6,68.8 133:68.6,69.5'}
G[24139]={'117:62.59,16.82'}
G[24145]={'117:56.64,52.38'}
G[24150]={'117:56.90,53.77'}
G[24151]={'117:55.70,57.37'}
G[24152]={'117:26.43,24.50'}
G[24155]={'117:52.01,67.38'}
G[24157]={'117:53.07,66.93'}
G[24176]={'117:60.17,15.62'}
G[24186]={'117:31.16,24.51'}
G[24189]={'117:59.34,55.42'}
G[24191]={'117:59.75,62.43'}
G[24209]={'117:31.28,24.35'}
G[24218]={'117:25.96,24.43'}
G[24227]={'117:30.05,28.64 117:30.13,28.79 117:30.27,28.77'} -- pacing back and forth
G[24234]={'117:48.43,10.44'}
G[24251]={'117:53.58,66.36'}
G[24252]={'117:53.68,65.21'}
G[24256]={'117:48.93,11.98'}
G[24261]={'117:29.68,5.67'}
G[24273]={'117:30.05,28.59'}
G[24282]={'117:61.83,17.19'}
G[24283]={'117:30.77,41.61'}
G[24328]={'117:62.27,17.22'}
G[24359]={'117:26.14,24.58','Circling the fire'}
G[24362]={'117:49.22,12.25'}
G[24369]={'111:75.13,36.68'}
G[24370]={'111:75.49,37.22'}
G[24376]={'117:62.58,16.53'}
G[24390]={'117:48.09,10.48'}
G[24393]={'111:61.75,15.56'}
G[24399]={'117:30.81,28.56'}
G[24458]={'117:65.87,36.78'}
G[24468]={'HB 27:53.54,38.57'}
G[24473]={'117:30.41,26.18'}
G[24494]={'117:30.64,42.78'}
G[24495]={'HB 1:40.32,17.88'}
G[24497]={'HB 1:42.61,17.86'}
G[24498]={'HB 1:40.6,18.2'}
G[24499]={'HB 1:4.19,17.2'}
G[24510]={'HB 1:42.68,17.73'}
G[24519]={'27:53.30,51.47 37:42.62,64.39 97:49.16,51.34'}
G[24525]={'117:35.56,80.62'}
G[24537]={'117:35.60,80.24'}
G[24539]={'117:35.10,80.94'}
G[24541]={'117:36.33,80.48'}
G[24544]={'117:19.78,22.21'}
G[24548]={'117:67.35,60.32'}
G[24634]={'117:64.43,46.95'}
G[24643]={'117:23.08,62.66'}
G[24657]={'HB 1:41.23,18.53'}
G[24702]={'114:77.07,37.82'}
G[24703]={'114:75.90,37.24'}
G[24706]={'114:75.9,37.2'}
G[24709]={'114:75.9,37.3'}
G[24710]={'HB 27:55.13,38.08'}
G[24711]={'HB 1:41.58,18.46'}
G[24717]={'117:74.95,65.41'}
G[24727]={'111:31.33,27.87'}
G[24729]={'84:81.83,28.00'} --301:81.40,27.78 301:81.64,28.23 301:81.99,28.74
G[24730]={'114:75.6,35.8'}
G[24733]={'114:76.8,37.9'}
G[24739]={'63:17.9,49.4 63:17.9,49.5'}
G[24741]={'117:35.34,79.47 117:35.49,79.39','Upstairs'}
G[24750]={'117:75.27,64.97'}
G[24755]={'117:25.02,56.96'}
G[24784]={'117:37.75,79.58'}
G[24795]={'114:45.35,34.50'}
G[24807]={'117:75.05,65.51'}
G[24810]={'117:24.60,58.86'}
G[24811]={'117:78.81,48.87'}
G[24813]={'349:42.61,87.19 N:55007'}
G[24822]={'348:0,0'}
G[24848]={'348:0,0'}
G[24851]={'95:74.76,67.15'}
G[24866]={'107:55.9,73.7'}
G[24881]={'107:52.8,36'}
G[24885]={'108:55.81,53.74'}
G[24886]={'108:49.9,46.7'}
G[24910]={'117:35.9,67.3 117:37.2,74.8 117:37.8,75 117:38,77.1 117:38.3,78.3 117:38.4,69.2 117:38.4,69.8 117:38.5,70.4 117:38.5,78.9 117:38.6,71 117:38.7,79.5 117:38.9,72.1 117:39.7,74.4 117:39.7,74.5 117:40.2,81.1 117:40.8,81.6 117:41.1,76.2 117:42,82.4 117:43.1,77.7'}	-- on a boat that sails around a bunch
G[24932]={'111:49.10,42.50'}
G[24937]={'100:58.17,17.59'}
G[24965]={'122:47.2,30.7'}
G[24967]={'122:47.4,30.6'}
G[24975]={'122:51.4,32.6 122:51.5,32.6'}
G[25032]={'122:47.3,30.7'}
G[25034]={'122:47.3,35.1'}
G[25046]={'122:50.6,40.8'}
G[25057]={'122:47.6,35.2'}
G[25061]={'122:47.6,35.2'}
G[25069]={'122:49.4,40.3 122:49.5,40.4'}
G[25088]={'122:53.8,34.2'}
G[25108]={'122:50.5,39.1'}
G[25112]={'122:48.4,36.7 122:48.4,37.7 122:48.7,36.8 122:48.7,37.5'}
G[25133]={'122:47.5,35.3 122:47.6,35.5'}
G[25140]={'111:62.74,35.97'}
G[25163]={'122:51.2,33.3'}
G[25169]={'122:50.2,28.2'}
G[25197]={'114:43.50,13.96'}
G[25199]={'114:42.84,13.65'}
G[25205]={'114:42.00,12.78'}
G[25206]={'114:43.03,13.81'}
G[25208]={'114:37.75,23.02'}
G[25211]={'114:42.03,13.15'}
G[25233]={'117:32.28,46.79'}
G[25235]={'114:57.32,66.64 114:57.40,66.52 114:57.17,66.24'}
G[25237]={'114:41.35,53.59'}
G[25245]={'114:58.29,68.04'}
G[25247]={'114:41.74,54.72'}
G[25249]={'114:58.41,67.79'}
G[25250]={'114:56.67,72.64'}
G[25251]={'114:58.73,68.35'}
G[25256]={'114:41.37,53.70'}
G[25257]={'115:40.7,18 N:18229'}
G[25262]={'114:45.26,33.36'}
G[25272]={'114:41.22,53.35'}
G[25273]={'114:41.62,53.98 114:43.01,55.64'}	-- different dudes standing about
G[25279]={'114:43.19,54.97'}
G[25280]={'114:42.13,56.17'}
G[25285]={'114:56.60,72.47'}
G[25288]={'114:40.36,51.40','On roof'}
G[25289]={'114:42.34,55.99','On roof'}
G[25291]={'114:44.98,33.39'}
G[25292]={'114:54.30,36.10'}
G[25298]={'114:57.83,69.20'}
G[25299]={'114:57.79,69.19'}
G[25301]={'114:56.71,72.62'}
G[25302]={'114:58.53,68.09'}
G[25307]={'114:57.85,67.59'}
G[25314]={'114:32.94,34.41'}
G[25324]={'HM 63:15.8,21'}
G[25326]={'114:49.61,10.59'}
G[25327]={'114:43.33,55.36'}
G[25328]={'114:40.07,52.06'}
G[25329]={'114:32.25,54.08'}
G[25335]={'114:48.32,19.76'}
G[25336]={'114:48.45,19.74'}
G[25339]={'114:50.28,9.73'}
G[25356]={'114:46.37,37.30'}
G[25374]={'114:49.55,9.98'}
G[25376]={'114:46.57,9.35'}
G[25379]={'114:43.72,54.43'}
G[25380]={'114:52.2,52.8'}
G[25381]={'114:52.06,52.49'}
G[25385]={'114:56.05,55.42'}
G[25394]={'114:43.20,55.05'}
G[25395]={'114:56.68,71.45','In bottom of keep'}
G[25425]={'114:56.2,9.1'}
G[25435]={'114:47.13,75.48'}
G[25437]={'114:38.08,52.49'}
G[25438]={'114:37.92,52.59'}
G[25440]={'114:53.10,52.34','Riding in general area'}
G[25450]={'114:43.61,80.53'}
G[25462]={'124:51.3,35.1'}
G[25475]={'114:32.08,54.25'}
G[25476]={'114:32.34,54.27'}
G[25477]={'114:57.58,18.70 114:58.18,18.34'}
G[25480]={'114:46.34,32.84'}
G[25503]={'114:31.7,54.4'}
G[25504]={'114:31.88,52.32','Upstairs'}
G[25516]={'114:87.6,20.1'}
G[25580]={'108:38.7,12.8'}
G[25589]={'114:54.5,11.6 114:55.5,11.4 114:55.5,12 114:55.5,12.6'}
G[25590]={'114:56.98,18.70'}
G[25602]={'114:77.31,36.88'}
G[25604]={'114:74.67,23.66'}
G[25605]={'114:57.50,69.08'}
G[25607]={'114:37.91,52.33'}
G[25636]={'114:44.10,77.89'}
G[25658]={'114:69.8,12.7'}
G[25697]={'265:18.6,50.6 102:48.94,35.80>265'}
G[25702]={'114:57.5,18.7'}
G[25705]={'114:73.42,18.79'}
G[25714]={'114:69.89,14.74'}
G[25729]={'114:34.59,46.43'}
G[25736]={'114:48.96,10.27'}
G[25737]={'114:58.84,68.72'}
G[25747]={'114:57.44,18.74'}
G[25780]={'114:57.06,20.11'}
G[25785]={'114:46.37,32.40'}
G[25807]={'114:61.67,35.78'}
G[25809]={'114:57.05,44.32'}
G[25810]={'114:57.32,44.08'}
G[25811]={'114:56.80,44.04'}
G[25812]={'114:57.19,44.20 114:57.16,43.59 114:56.90,44.13','The bear that circles'}
G[25816]={'114:56.36,69.58'}
G[25825]={'114:55.00,68.93'}
G[25826]={'114:58.55,67.31'}
G[25838]={'114:57.79,55.10'}
G[25849]={'114:77.49,36.97'}
G[25862]={'114:59.43,30.44'}
G[25883]={'HM 63:86.94,41.86'}
G[25884]={'HM 63:51.35,66.15'}
G[25887]={'HM 14:44.30,46.03'}
G[25888]={'HM 97:44.48,52.50'}
G[25889]={'HM 105:41.57,65.90'}
G[25890]={'HM 17:55.53,14.88'}
G[25891]={'HM 106:55.82,67.88'}
G[25892]={'HM 36:68.34,60.63'}
G[25893]={'HM 62:48.73,22.65'}
G[25894]={'HM 66:66.12,17.10'}
G[25895]={'HM 27:53.80,45.24'}
G[25896]={'HM 47:73.69,54.62'}
G[25897]={'HM 70:61.82,40.46'}
G[25898]={'HM 37:43.47,62.63'}
G[25899]={'HM 69:46.82,43.70'}
G[25900]={'HM 100:62.17,58.29'}
G[25902]={'HM 48:32.55,40.95'}
G[25903]={'HM 107:49.61,69.46'}
G[25904]={'HM 49:24.90,53.39'}
G[25905]={'HM 104:39.63,54.64'}
G[25906]={'HM 57:54.88,52.77'}
G[25907]={'HM 108:54.06,55.52'}
G[25908]={'HM 26:14.34,50.08'}
G[25909]={'HM 22:43.47,82.33'}
G[25910]={'HM 52:44.76,62.06'}
G[25911]={'HM 56:13.46,47.07'}
G[25912]={'HM 102:68.80,51.95'}
G[25913]={'HM 109:31.21,62.66'}
G[25914]={'HM 81:60.30,33.51'}
G[25915]={'HM 210:51.96,67.65'}
G[25916]={'HM 71:52.64,30.26'}
G[25917]={'HM 83:61.24,47.25'}
G[25918]={'HM 109:32.11,68.32'}
G[25919]={'HM 81:50.85,41.31'}
G[25920]={'HM 210:50.40,70.38'}
G[25921]={'HM 71:49.82,27.87'}
G[25922]={'HM 83:58.15,47.51'}
G[25923]={'HM 14:69.36,42.57'}
G[25925]={'HM 15:23.09,37.44'}
G[25926]={'HM 105:49.91,58.66'}
G[25927]={'HM 36:51.11,29.21'}
G[25928]={'HM 66:26.15,76.90'}
G[25929]={'HM 1:52.18,47.32'}
G[25930]={'HM 70:33.43,30.91'}
G[25931]={'HM 94:46.40,50.60'}
G[25932]={'HM 69:72.38,47.79'}
G[25933]={'HM 95:46.90,26.34'}
G[25934]={'HM 100:57.12,42.05'}
G[25935]={'HM 25:54.66,50.09'}
G[25936]={'HM 7:51.82,59.25'}
G[25937]={'HM 107:50.91,34.14'}
G[25938]={'HM 104:33.40,30.54'}
G[25939]={'HM 21:49.63,38.22'}
G[25940]={'HM 65:52.92,62.46'}
G[25941]={'HM 51:76.33,13.77'}
G[25942]={'HM 108:52.01,42.91'}
G[25943]={'HM 10:49.96,54.63'}
G[25944]={'HM 26:76.64,74.96'}
G[25946]={'HM 18:57.22,51.76'}
G[25947]={'HM 102:35.44,51.61'}
G[25962]={'HM 14:44.23,45.20 15:19.46,55.80 17:55.54,15.16 22:43.17,82.55 26:14.04,50.08 27:53.76,45.58 36:68.03,60.12 37:43.69,62.23 47:73.64,53.81 48:32.07,41.51 49:25.14,54.20 50:51.97,63.08 51:69.87,16.25 52:44.65,61.21 56:13.59,46.70 57:54.54,52.68 62:48.65,22.88 63:86.48,41.85 65:49.41,50.97 66:66.35,17.00 69:46.96,43.78 70:61.60,41.04 71:52.45,30.54 78:59.55,63.10 81:59.95,33.59 83:61.14,47.65 97:44.45,51.78 100:62.06,57.92 102:69.04,51.92 104:39.59,54.99 105:41.50,65.30 106:56.16,67.08 107:49.92,69.04 108:54.53,55.38 109:31.53,63.02 114:55.11,19.71 115:75.59,43.38 116:33.93,60.18 117:57.97,16.16 119:47.48,66.36 120:41.62,86.83 121:40.51,61.55 127:78.32,75.46 199:48.42,72.45 210:52.10,67.26 241:47.35,28.53 249:53.75,32.05'}
G[25975]={'HM 84:50.05,72.28 87:65.40,25.04 89:63.18,47.50 103:40.88,25.55'}
G[25978]={'114:41.70,54.59'}
G[25982]={'114:77.25,38.47'}
G[25983]={'114:77.6,37'}
G[25984]={'114:64.03,35.76'}
G[25994]={'HM 1:52.41,47.33 7:51.69,59.54 10:49.86,54.97 14:69.93,42.21 15:23.39,37.28 17:45.69,12.99 18:57.44,51.57 21:49.95,38.18 22:29.45,56.90 25:54.81,49.79 26:76.80,75.33 36:50.61,29.33 50:40.53,51.49 51:76.61,13.34 63:51.68,66.21 65:52.76,62.52 66:26.32,76.64 69:72.21,47.89 70:33.65,30.80 71:49.89,27.73 76:60.72,53.31 78:56.63,66.36 81:51.06,41.09 83:58.20,47.71 94:46.60,50.72 95:46.82,26.67 100:56.92,42.15 102:35.42,51.32 104:33.29,30.25 105:49.55,59.04 107:50.76,33.98 108:52.17,42.77 109:32.53,68.44 114:51.15,11.26 115:38.12,48.32 116:19.47,61.28 117:48.62,12.90 119:47.17,61.26 120:40.37,85.23 121:43.56,71.75 127:79.67,53.45 199:40.75,67.60 210:50.19,70.74 241:52.97,46.10 249:53.23,34.62'}
G[26083]={'114:58.21,62.81'}
G[26084]={'114:58.19,62.99'}
G[26085]={'114:58.28,62.77'}
G[26104]={'114:77,37.6'}
G[26110]={'114:33.49,34.38'}
G[26113]={'86:46.60,37.27 88:20.99,26.46 998:68.88,8.45 110:69.50,42.43'}
G[26117]={'114:33.32,34.53'}
G[26125]={'49:59.02,55.01'}
G[26155]={'114:56.7,69.5'}
G[26156]={'115:12.8,51.6'}
G[26158]={'114:78.3,38'}
G[26169]={'114:63.80,46.13'}
G[26170]={'114:84.80,41.68'}
G[26180]={'115:14.2,49.9'}
G[26181]={'115:13.3,48 115:13.3,49.7 115:13.4,49.1 115:13.6,47.9 115:13.8,49.6 115:13.9,48.5'}
G[26186]={'114:82.17,46.40'}
G[26187]={'114:82,46.4'}
G[26194]={'115:48.00,74.87'}
G[26206]={'Near114'}
G[26212]={'116:59.42,25.99'}
G[26213]={'114:63.95,45.71'}
G[26218]={'114:67.21,54.85'}
G[26221]={'HM 84:49.32,72.27 87:65.09,27.72 89:62.11,49.14 103:43.29,26.22 111:60.67,30.63'} -- This NPC is the same for both factions!!!  So Horde is 526221.
G[26226]={'116:59.80,27.57'}
G[26228]={'115:48.26,74.35'}
G[26245]={'115:47.70,76.63'}
G[26260]={'116:65.77,17.80'}
G[26335]={'116:63.68,23.16'}
G[26344]={'115:36.79,65.05'}
G[26361]={'116:59.76,27.44'}
G[26371]={'116:59.08,26.48 116:59.04,26.42 116:59.12,26.17'}
G[26377]={'116:59.09,26.61'}
G[26379]={'115:36.3,45.6 115:38.1,46.3'}
G[26401]={'HM 14:44.22,45.99 15:18.97,56.33 17:55.55,14.76 22:43.44,82.24 26:15.23,50.17 27:53.80,45.14 36:68.32,60.77 37:43.49,62.51 47:73.77,54.50 48:32.58,41.10 49:25.68,53.37 50:52.12,63.57 51:70.13,15.72 52:44.80,62.18 56:13.50,46.98 57:54.83,52.77 62:48.69,22.69 63:86.89,41.84 65:49.35,51.33 66:66.19,17.10 69:46.78,43.67 70:61.87,40.50 71:52.67,30.22 78:59.77,63.25 81:60.38,33.51 83:61.49,47.51 97:44.41,52.47 100:62.45,58.44 102:68.73,51.94 104:39.64,54.56 105:41.53,65.87 106:55.82,67.75 107:49.57,69.41 108:54.01,55.57 109:31.16,62.64 114:55.14,19.91 115:75.24,43.77 116:33.94,60.52 117:57.84,16.17 119:48.37,65.53 120:41.42,86.74 121:40.37,61.39 127:78.07,74.90 199:48.34,72.29 210:52.03,67.71 241:47.32,28.95 249:53.60,31.92 390:79.67,37.44'} -- the one in zone 26 is behind a tree
G[26415]={'115:36.7,46.6'}
G[26420]={'116:79.76,33.61'}
G[26423]={'116:16.43,47.77'}
G[26424]={'116:16.19,47.61'}
G[26440]={'115:48.1,74.9'}
G[26441]={'115:48,74.8'}
G[26443]={'115:57.91,54.17'}
G[26459]={'115:29.04,55.42'}
G[26471]={'115:38,46.3'}
G[26473]={'115:58.98,17.81'}
G[26484]={'116:69.09,40.10'}
G[26500]={'116:13.24,60.87'}
G[26501]={'115:24.20,60.08'}
G[26504]={'115:37.1,48.6'}
G[26505]={'115:36.1,48.8'}
G[26511]={'115:47.71,80.03'}
G[26514]={'116:67.50,15.28'}
G[26519]={'116:15.7,46.8'}
G[26520]={'HM 1:52.15,47.25 7:51.77,59.21 10:49.96,54.54 14:69.41,42.47 15:23.19,37.42 17:46.30,13.73 18:57.29,51.75 21:49.59,38.31 22:29.23,57.34 25:54.70,50.15 26:76.66,75.06 36:51.21,29.26 50:40.51,50.96 51:76.30,13.59 63:51.35,66.22 65:52.95,62.41 66:26.13,77.01 69:72.41,47.76 70:33.49,30.92 71:49.80,27.93 76:60.80,53.56 78:56.25,66.33 81:50.82,41.41 83:58.16,47.43 94:46.40,50.51 95:46.89,26.48 100:57.16,42.00 102:35.47,51.69 104:33.61,30.72 105:49.92,58.74 107:50.97,34.13 108:51.97,42.96 109:32.16,68.33 114:51.16,11.47 115:38.31,48.45 116:19.26,61.17 117:48.64,13.08 119:47.27,61.66 120:40.27,85.41 121:43.42,71.81 127:80.08,53.21 199:40.85,67.73 210:50.34,70.33 241:52.96,45.93 249:53.10,34.54 390:77.88,34.03'}
G[26527]={'130:86.4,61.6 130:86.5,61.4 130:86.5,61.5 N:10667'}
G[26543]={'116:17.41,36.36 N:26500'}
G[26560]={'122:48.36,25.08'}
G[26564]={'115:36.6,47.1'}
G[26574]={'115:37.2,45.8'}
G[26581]={'115:35.9,46.9 115:36.1,46 115:36.2,47.6 115:36.5,46.4 115:36.7,47.6 115:37.1,46.5'}
G[26584]={'116:65.2,47.8'}
G[26588]={'116:49.20,34.10'}
G[26593]={'115:35.21,30.04','Inside cave Maw of Neltharion'}
G[26595]={'115:49.14,75.66'}
G[26602]={'114:56.57,20.06'}
G[26604]={'116:16.67,48.29'}
G[26618]={'115:35.8,48.3'}
G[26632]={'160:60.26,13.17'}
G[26647]={'115:54.69,23.88 115:54.50,23.62 115:54.98,23.85'}
G[26649]={'115:37.3,46.8'}
G[26652]={'115:35.8,45.8 115:35.8,46.9 115:36.4,45.3 115:36.5,45.3 115:36.6,45.5'}
G[26653]={'115:26.2,50.7'}
G[26659]={'115:59.40,18.18'}
G[26660]={'115:55.02,23.43'}
G[26661]={'115:54.70,23.26'}
G[26666]={'116:65.1,47.7'}
G[26673]={'115:29.00,55.45'}
G[26701]={'116:45.00,28.36 N:26500'}
G[26723]={'129:36.26,69.04 N:26206'}
G[26733]={'115:22.6,41.7'}
G[26787]={'116:71.74,26.20 N:26500'}
G[26796]={'129:18.94,52.79'}
G[26798]={'129:19.58,53.31'}
G[26814]={'116:69.48,17.50'}
G[26821]={'116:26.41,35.71'}
G[26837]={'115:28.73,57.10'}
G[26851]={'115:60.32,51.54'}
G[26854]={'115:36.5,47.8'}
G[26859]={'115:47.2,33'}
G[26860]={'116:20.7,64.2'}
G[26861]={'136:0.00,0.00'}
G[26868]={'116:22.6,66.1'}
G[26873]={'115:40.26,66.85'}
G[26875]={'116:31.84,60.17'}
G[26876]={'116:59.89,26.68'}
G[26877]={'115:39.52,25.91'}
G[26878]={'115:77.01,49.79'}
G[26879]={'114:58.96,68.29'}
G[26880]={'116:31.31,59.11'}
G[26881]={'115:29.18,55.33'}
G[26883]={'116:77.09,48.65'}
G[26884]={'116:73.76,34.02'}
G[26885]={'116:76.97,48.44'}
G[26886]={'116:73.91,34.13'}
G[26896]={'115:48.46,24.13'}
G[26905]={'117:58.2,62.1'}
G[26914]={'117:58.6,62.8'}
G[26917]={'115:59.84,54.66'}
G[26924]={'116:69.42,19.48'} -- need to have "On the Other Side" buff to see him
G[26932]={'116:55.13,23.38'}
G[26935]={'116:57.52,41.26'}
G[26944]={'116:65,47.8'}
G[26949]={'115:59.52,53.30'}
G[26953]={'117:78.61,29.49'}
G[26964]={'117:79.4,30.7'}
G[26969]={'114:41.6,53.4 114:41.6,53.5'}
G[26972]={'114:41.97,54.11'}
G[26973]={'115:29.18,55.64'}
G[26978]={'115:64.42,26.94 115:64.47,26.34'}
G[26979]={'115:46.7,33.4 115:46.7,33.5'}
G[26983]={'115:60.02,55.20'}
G[26989]={'114:57.92,71.54'}
G[27001]={'114:57.5,72.3'}
G[27028]={'115:76,62'}
G[27037]={'116:22,65.1'}
G[27046]={'114:33.13,34.44'}
G[27060]={'115:28.9,56.1'}
G[27102]={'116:20.9,64.1 116:23.3,64.9'}
G[27120]={'116:26.4,65.7 116:26.5,65.8'}
G[27136]={'115:78.49,48.34 115:78.64,48.09'}
G[27155]={'115:78.64,48.18'}
G[27156]={'115:77.80,50.33'}
G[27157]={'115:89.67,46.37'}
G[27158]={'115:78.91,45.33'}
G[27159]={'115:77.84,50.29'}
G[27172]={'115:77.7,62.7'}
G[27215]={'HB 27:54.67,38.10'}
G[27216]={'HB 1:4.53,17.6'}
G[27221]={'116:65.2,47.4 116:65.2,47.5'}
G[27227]={'116:65.1,47.3'}
G[27243]={'115:76.8,63.2'}
G[27248]={'115:77,62.9'}
G[27255]={'115:64.10,71.99 115:62.98,72.15 115:62.52,73.64 115:62.59,74.92 115:63.63,75.99 115:64.77,72.52 115:65.01,73.52 115:64.92,75.39 115:64.68,76.36'}
G[27262]={'116:22.5,62.9'}
G[27266]={'116:22.2,64.7'}
G[27267]={'115:76,63.2'}
G[27277]={'116:32.10,59.97'}
G[27295]={'116:31.16,59.47'}
G[27314]={'115:79.14,47.17'}
G[27316]={'115:76.75,47.52 115:76.79,47.35'}
G[27317]={'115:77.10,50.11'}
G[27318]={'115:79.07,53.20'}
G[27319]={'115:85.86,51.02'}
G[27320]={'115:76.4,62.6 115:76.5,62.6 115:77.3,62.2 115:77.6,61.9'}
G[27337]={'115:76.8,63.1'}
G[27344]={'117:79.04,29.71'}
G[27347]={'115:87.17,57.48'}
G[27348]={'115:87.24,57.39'}
G[27350]={'115:73.6,73.4 115:73.6,73.5'}
G[27371]={'116:39.54,43.56'}
G[27388]={'116:21,64.1'}
G[27391]={'116:32.42,59.95'}
G[27412]={'115:81.52,42.20'}
G[27416]={'116:39.64,43.37'}
G[27422]={'116:34.4,32.7 116:34.5,32.6'}
G[27423]={'116:34.5,32.6'}
G[27451]={'116:34.4,33 116:34.5,33'}
G[27464]={'116:33.9,32.8'}
G[27468]={'116:39.36,43.87'}
G[27469]={'116:34.77,55.61'}
G[27478]={'HB 87:18.82,53.09'}
G[27483]={'160:65.67,23.77'}
G[27484]={'116:40.48,42.65'}
G[27486]={'116:26.47,35.77'}
G[27489]={'HB 86:50.37,73.50'}
G[27495]={'116:23.02,80.16'}
G[27497]={'116:21.93,29.93'}
G[27499]={'116:26.46,31.76'}
G[27506]={'115:52.21,50.04'}
G[27520]={'116:22.18,81.23'}
G[27532]={'116:10.1,77.2'}
G[27545]={'116:25.61,33.31'}
G[27546]={'116:35.39,66.89'}
G[27562]={'116:22.12,81.25'}
G[27563]={'116:10.1,77.2'}
G[27565]={'116:11.2,76.6'}
G[27575]={'115:59.24,54.32'}
G[27581]={'116:44.04,47.95'}
G[27582]={'116:59.18,26.18'}
G[27602]={'116:21.99,80.73'}
G[27606]={'116:11.3,76.7'}
G[27646]={'116:64.80,43.41'}
G[27658]={'142:48.2,80.7 142:48.4,80.1 142:48.9,80.4 142:49,80.9 142:49.4,79 142:49.4,79.7 142:49.4,80.6 142:49.6,80.7 142:49.8,79 142:49.9,78.4 142:49.9,79.8 142:50,79.2 142:50,80.3 142:50,81.5 142:50.1,80.8 142:50.1,81.8 142:50.5,80 142:50.5,80.6 142:50.6,80.1 142:50.9,79.2 142:51.5,79.2'}
G[27708]={'116:14.8,86.4 116:14.8,86.5'}
G[27719]={'116:22.4,63.9'}
G[27720]={'116:22.3,64.1'}
G[27759]={'116:14.8,86.6 116:14.9,86.4'}
G[27763]={'115:43,50.9'}
G[27765]={'115:60.07,54.20'}
G[27783]={'116:29.91,59.78'}
G[27784]={'115:76.81,47.52 115:76.67,47.37 115:76.80,47.07 115:76.99,47.27 115:76.85,47.33'}
G[27785]={'115:59.61,54.46'}
G[27801]={'119:64.56,48.60'}
G[27803]={'115:60.00,55.08'}
G[27804]={'115:58.1,55.4 115:58.3,55.8 115:58.6,56.3 115:58.7,56.5'}
G[27828]={'115:84.17,54.68'}
G[27844]={'115:64.74,27.93'}
G[27856]={'115:60.00,54.51 N:10667'}
G[27857]={'115:81.17,50.65'}
G[27872]={'115:37.80,23.41'}
G[27915]={'130:47.7,39.3 130:47.7,39.9 130:47.8,39.3 130:47.9,40.5 130:47.7,39.9 N:10667'}
G[27922]={'117:67.45,60.58'}
G[27978]={'140:51.08,12.64'}
G[27986]={'119:27.10,58.65 N:18180'}
G[27987]={'119:39.68,58.65'}
G[27990]={'115:59.79,54.70'}
G[28012]={'Near142'}
G[28016]={'Near160 N:26423'}
G[28027]={'119:54.58,56.36'}
G[28030]={'121:75.37,58.61'}
G[28031]={'119:26.67,59.03'}
G[28032]={'119:27.24,59.89'}
G[28033]={'119:25.36,58.47'}
G[28034]={'121:38,44'}
G[28035]={'121:40,47'}
G[28036]={'121:40,47'}
G[28037]={'119:25.27,58.44'}
G[28039]={'121:40.27,66.62'}
G[28042]={'121:48.77,78.87'}
G[28043]={'121:48.15,63.88'}
G[28044]={'121:58.07,72.43'}
G[28045]={'121:35.62,52.23'}
G[28046]={'119:26.70,59.55'}
G[28056]={'121:40.41,48.20'}
G[28059]={'121:39.41,66.96'}
G[28062]={'121:40.53,65.61'}
G[28070]={'Near140'}
G[28082]={'119:55.00,69.12'}
G[28092]={'78:47.38,9.22'}
G[28095]={'119:50.53,76.60'}
G[28097]={'119:50.54,77.25'}
G[28099]={'121:40.36,48.21'}
G[28106]={'119:23.4,83.3 119:23.5,83.2'}
G[28107]={'119:33.4,74.8 119:33.5,74.8'}
G[28114]={'119:42.15,38.64'}
G[28120]={'Near119'}
G[28122]={'Near119'} -- about 493:74.50,51.16 when quest 12578 concludes
G[28125]={'121:58.68,72.49'}
G[28126]={'71:50.78,27.55'}
G[28138]={'119:55.49,69.68'}
G[28160]={'125:68.58,42.07'}
G[28179]={'118:87.4,75.9 118:87.5,75.8'}
G[28191]={'119:25.58,66.53'}
G[28195]={'114:78.53,51.53'}
G[28196]={'115:48.51,74.39'}
G[28197]={'117:24.66,57.78'}
G[28204]={'121:41.33,65.13'}
G[28205]={'121:35.03,52.11'}
G[28214]={'Near119'}
G[28216]={'Near119'}
G[28217]={'119:55.70,64.98'}
G[28228]={'115:83.98,26.10'}
G[28244]={'121:40.8,66.7 N:3144'}
G[28266]={'119:25.4,58.4 119:25.4,58.5 119:25.5,58.4 119:25.5,58.5'}
G[28283]={'121:58.06,72.04'}
G[28284]={'121:58.25,72.05'}
G[28309]={'121:40.18,68.93'}
G[28314]={'117:71.46,39.21'}
G[28328]={'119:27.07,59.89'}
G[28357]={'124:47.6,28.9 124:47.7,29.5 124:48.2,28.4 124:48.9,27.4 124:48.9,27.5 124:49.5,28.1'}
G[28374]={'119:42.12,28.90'}
G[28375]={'114:37.84,23.19'}
G[28376]={'119:42.34,28.70'}
G[28377]={'124:52.28,33.97'}
G[28382]={'114:67.27,54.85'}
G[28401]={'121:63.71,70.40'}
G[28444]={'124:48.85,29.70'}
G[28464]={'119:65.08,60.31'}
G[28472]={'124:47.48,26.55'}
G[28479]={'121:59.50,58.05'}
G[28480]={'121:59.39,56.42'}
G[28484]={'121:59.16,56.20'}
G[28497]={'119:26.87,58.94'}
G[28503]={'121:27.08,46.15','In Voltarus above Reliquary of Pain'}
G[28510]={'124:50.9,35.5 124:51,35.3 124:51.3,34 124:51.6,34.3 124:51.6,34.8'}
G[28518]={'121:14.06,73.80'}
G[28519]={'121:21,70.2'}
G[28527]={'121:59.98,57.92'}
G[28532]={'121:14.28,74.04'}
G[28561]={'121:53.39,39.01'}
G[28568]={'119:50.48,62.13'}
G[28574]={'119:50.13,61.36'}
G[28589]={'121:19.87,75.45'}
G[28615]={'121:14.01,73.59'}
G[28618]={'121:32.18,74.39'}
G[28621]={'23:51.35,21.31'}
G[28623]={'121:41.55,64.43'}
G[28624]={'121:60.03,56.71'}
G[28647]={'124:52.4,37.8 124:52.6,37.6 124:53.1,36.4 124:53.1,36.9 124:53.5,36.5 124:53.6,36.4'}
G[28653]={'124:51.8,35.6 124:52.3,34.8 124:52.4,34.3 124:52.5,34.5 124:53.1,33.6 124:53.3,33.4'}
G[28658]={'124:54,35'}
G[28667]={'119:72.46,57.52'}
G[28668]={'119:71.97,57.01 N:28216'}
G[28674]={'125:72.19,45.77'}
G[28699]={'125:36.17,33.55'}
G[28701]={'125:40.67,35.34'}
G[28703]={'125:42.64,32.05'}
G[28705]={'125:40.61,64.85'}
G[28706]={'125:36.58,37.28'}
G[28718]={'125:36.4,28.4'}
G[28742]={'125:53.03,64.95'}
G[28746]={'119:49.95,61.53'}
G[28771]={'119:42.07,28.66'}
G[28787]={'119:35.56,47.41'}
G[28907]={'124:53.48,36.56 N:28377'}
G[28910]={'124:54.68,57.44'}
G[28911]={'124:54.2,57.4'}
G[28912]={'124:62.9,68 124:63.2,68.6 N:26581'}
G[28913]={'124:56.2,80.1 N:26170'}
G[28914]={'124:56.2,80'}
G[28919]={'124:55.8,52.3 124:55.9,52.9'}
G[28923]={'139:19.16,58.53'}
G[29006]={'119:53.3,56.6'}
G[29043]={'119:55.71,69.47'}
G[29047]={'124:54.4,34.2 124:54.4,34.5 124:54.5,34.5 124:54.7,33.4 124:54.8,34.1'}
G[29049]={'125:49.02,37.38'}
G[29053]={'124:52.8,81.3 124:52.9,82.5 124:53,81.7'}
G[29077]={'124:65.67,83.79'}
G[29110]={'124:53.57,36.85 N:25462'}
G[29120]={'159:0.00,0.00'}
G[29137]={'121:32.03,74.42'}
G[29142]={'84:61.30,64.67'}
G[29146]={'119:55.53,68.70'}
G[29149]={'119:54.2,53.9'}
G[29155]={'114:41.58,53.60'}
G[29156]={'125:56.30,46.68'}
G[29157]={'119:26.78,60.08'}
G[29158]={'114:58.58,68.30'}
G[29159]={'117:79.44,29.42'}
G[29160]={'116:20.7,64.3'}
G[29161]={'116:32.01,59.79'}
G[29162]={'115:76.8,63.2'}
G[29169]={'121:40.63,66.89'}
G[29173]={'124:34.4,31 124:34.5,31 124:34.6,31.5 124:38.9,38.2 124:39.1,39.1 124:39.5,38 N:28444'}
G[29211]={'121:36.69,72.48'}
G[29306]={'154:46.95,28.90'}
G[29309]={'132:69.39,27.53'}
G[29310]={'132:29.12,50.34'}
G[29343]={'118:42.9,25'}
G[29344]={'118:19.6,48.1'}
G[29375]={'120:70,59'}
G[29380]={'120:25,46'}
G[29396]={'118:19.7,48.3'}
G[29405]={'118:19.7,47.8'}
G[29428]={'120:40.93,85.31'}
G[29430]={'120:41.67,80.01'}
G[29431]={'120:41.02,86.43'}
G[29432]={'120:50.01,81.77'}	-- 495:50.48,81.65
G[29434]={'120:41.51,74.89 120:42.31,73.97 120:43.48,75.24','In cave'}
G[29445]={'120:33.42,57.96'}
G[29455]={'121:17.64,57.54'}
G[29456]={'118:19.9,47.6'}
G[29473]={'120:41.14,86.14'}
G[29480]={'23:83.88,50.43'}
G[29481]={'120:42.81,68.90'}
G[29527]={'125:52.31,55.61','Upstairs in Curiosities & Moore'}
G[29532]={'126:35.46,57.55'}
G[29535]={'126:63.47,11.63'}
G[29560]={'118:9.5,46.4 118:9.5,47.2 N:29344'}
G[29579]={'Near120 N:28070'}
G[29592]={'120:53.14,65.73'}
G[29593]={'120:30.26,74.76'}
G[29611]={'84:85.78,31.73'}
G[29631]={'125:70,39'}
G[29647]={'121:19.73,56.39'}
G[29650]={'120:29.61,74.07'}
G[29651]={'120:37.31,49.66'}
G[29687]={'121:32.15,75.74'}
G[29688]={'121:25.3,63.9'}
G[29689]={'121:25.28,63.96'}
G[29690]={'121:32.18,75.63'}
G[29721]={'120:40.74,84.55'}
G[29727]={'120:29.18,74.90'}
G[29732]={'120:29.83,75.72'}
G[29733]={'121:32.02,75.61'}
G[29743]={'120:29.40,73.77'}
G[29744]={'120:28.83,74.07'}
G[29750]={'120:29.50,74.33'}
G[29751]={'120:25.24,68.47','In back of cave'}
G[29795]={'118:59.9,34.9 118:60,33.6 118:60.1,33.2 118:60.2,36.1 118:60.3,32.4 118:60.4,36.6 118:60.6,31.8 118:60.7,37.2 118:61.2,38.4 118:61.3,31.1 118:61.4,38.8 118:61.6,31 118:61.6,39.3 118:62.1,40.3 118:62.4,30.4 118:62.4,40.9 118:62.5,30.4 118:62.5,30.5 118:62.6,41.4 118:62.7,41.5 118:63.4,43.2 118:63.5,29.5 118:63.5,43.4 118:63.8,44.4 118:64.1,29 118:64.1,45.2 118:64.3,45.7 118:64.5,28.7 118:64.5,46.2 118:64.7,46.8 118:65,28.3 118:65,47.7 118:65.4,48.7 118:65.5,48.9 118:65.6,27.7 118:65.8,49.5 118:66.3,27 118:66.4,50.8 118:66.7,26.6 118:66.7,51.4 118:67.2,52.3 118:67.4,26.3 118:67.4,52.5 118:67.5,52.4 118:67.9,26.3 118:68.1,52.8 118:68.5,26.4 118:68.6,52.8 118:69.2,26.8 118:69.3,52.4 118:69.4,32 118:69.4,32.6 118:69.4,33.8 118:69.5,27.3 118:69.5,31.2 118:69.5,31.7 118:69.5,32.9 118:69.5,34.3 118:69.5,34.7 118:69.5,51.9 118:69.6,27.6 118:69.6,29.4 118:69.6,29.7 118:69.6,36.1 118:69.6,36.7 118:69.7,38.3 118:69.7,38.9 118:69.7,40.1 118:69.7,51.1 118:69.8,41.3 118:69.8,42 118:69.8,42.6 118:69.8,50.1 118:69.9,44.3 118:69.9,45 118:69.9,46 118:69.9,47.2 118:69.9,48.3 118:69.9,48.5 N:26581'}
G[29796]={'120:50.88,65.59'}
G[29799]={'118:56,38.9 118:56.1,39.8 118:56.3,38.3 118:56.3,40.7 118:56.5,41.3 118:56.7,41.9 118:56.9,38 118:57.2,43.1 118:57.4,38.8 118:57.4,43.6 118:57.5,38.4 118:57.5,39.1 118:57.5,44 118:57.6,39.6 118:57.9,44.6 118:58,40.7 118:58.4,41.7 118:58.4,45.5 118:58.5,41.9 118:58.6,45.8 118:58.9,42.9 118:59.4,44.1 118:59.4,47.3 118:59.5,44.3 118:59.8,45 118:59.9,48.4 118:60,45.5 118:60,48.7 118:60.4,46.5 118:60.4,49.6 118:60.5,49.9 118:60.6,47 118:61,51.2 118:61.1,48.1 118:61.2,51.7 118:61.3,48.6 118:61.4,52.5 118:61.5,49.1 118:61.6,53.1 118:61.7,49.7 118:62,54.1 118:62.3,50.9 118:62.4,55.4 118:62.4,55.9 118:62.4,56.5 118:62.5,51.3 118:62.6,51.5 118:62.9,56.5 118:63,52.5 118:63.4,53.9 118:63.4,56.3 118:63.6,54.4 118:63.6,54.5 118:63.8,55.7 N:26170'}
G[29801]={'120:31.42,38.08'}
G[29804]={'118:44.1,24.7 N:29343'}
G[29806]={'120:37.7,46.4 120:37.7,46.5'}
G[29839]={'120:49.75,71.80'}
G[29855]={'120:40.78,51.20'}
G[29885]={'120:44.39,68.93'}
G[29937]={'120:37.29,49.73'}
G[29950]={'120:30.64,36.33'}
G[29951]={'120:44.49,28.18'}
G[29975]={'120:47.47,69.09 N:29481'}
G[29997]={'120:48.33,72.12'}
G[30002]={'118:44.6,20.4 118:44.6,20.5'}
G[30007]={'121:48.4,56.3 121:48.5,56.3 N:18471'}
G[30009]={'121:48.4,56.4 121:48.5,56.4 121:48.5,56.5 N:22893'}
G[30041]={'120:48.44,72.15'}
G[30052]={'120:39.66,59.90','Walking a path'}
G[30056]={'118:41,23.9'}
G[30074]={'118:43.3,25.3'}
G[30082]={'120:38.26,61.70 N:30052'}
G[30099]={'120:75.38,63.56'}
G[30105]={'120:65.42,60.16'}
G[30115]={'125:30.50,48.83'}
G[30116]={'125:31.27,48.11'}
G[30127]={'120:63.21,63.24 N:30099'}
G[30137]={'126:49.10,46.00'} -- wanders around the whole area 504[2]:55.01,52.22 504[2]:48.91,45.47 504[2]:43.15,38.38
G[30152]={'120:31.28,38.17'}
G[30216]={'118:42.9,25.8 118:43.1,25.3 118:43.4,24.4 118:43.5,24.4 118:43.5,24.5'}
G[30218]={'118:43.2,21.1 N:30056'}
G[30223]={'118:87.1,75.9'}
G[30224]={'118:86.1,75.8'}
G[30226]={'118:86.8,76.6'}
G[30227]={'118:87,79'}
G[30232]={'118:32.4,42.9 118:32.5,42.9'}
G[30247]={'120:36.44,49.09'}
G[30252]={'120:64.84,59.07'}
G[30271]={'127:72.17,80.96'}
G[30294]={'120:63.51,59.75'}
G[30295]={'120:56.2,51.4 120:56.2,51.5 N:29445'}
G[30314]={'118:43.75,24.37'}
G[30344]={'118:61.4,47.4'}
G[30345]={'118:61.4,47.4'}
G[30348]={'HL 114:59.09,65.63'}
G[30357]={'HL 116:60.56,27.68'}
G[30358]={'HL 115:29.75,55.91'}
G[30359]={'HL 120:28.89,73.72'}
G[30360]={'HL 114:33.80,34.36'}
G[30362]={'HL 119:49.77,63.62'}
G[30363]={'HL 115:48.77,78.16'}
G[30364]={'HL 114:57.40,43.72'}
G[30365]={'HL 119:63.81,49.02'}
G[30367]={'HL 116:80.52,37.11'}
G[30368]={'HL 123:49.03,13.95'}
G[30369]={'HL 121:58.91,55.97'}
G[30370]={'HL 120:41.15,84.73'}
G[30371]={'HL 114:42.94,49.58'}
G[30372]={'HL 116:64.18,46.98'}
G[30373]={'HL 115:35.10,48.34'}
G[30374]={'HL 120:64.59,51.33'}
G[30375]={'HL 120:31.26,37.62'}
G[30381]={'120:65.67,51.46'}
G[30382]={'120:39.56,56.36 N:28070'}
G[30390]={'120:71.4,48.9 N:29445'}
G[30395]={'120:61.18,39.01','In cave'}
G[30401]={'120:30.2,74.7'}
G[30406]={'118:36.1,33.1'}
G[30433]={'118:87.80,78.07'}
G[30469]={'120:48.52,54.36','In cave'}
G[30472]={'120:36.97,49.51'}
G[30481]={'Near'}
G[30490]={'126:31.29,49.65'}
G[30531]={'HL 133:47.42,69.63 117:57.34,46.99>133'}
G[30533]={'HL 157:21.8,44.0 115:26.01,50.83>157'}
G[30534]={'HL 160:68.85,79.12 121:28.53,86.94>160'}
G[30535]={'HL 140:29.41,62.04 120:39.54,26.92>140'}
G[30536]={'HL 129:55.23,64.73 114:27.50,26.10>129'}
G[30537]={'HL 154:45.67,61.57 121:76.27,21.19>153'}
G[30538]={'HL 136:48.75,22.94 117:57.25,46.59>136'}
G[30548]={'120:44.52,64.55','In back of cave'}
G[30562]={'118:79.8,30.9'}
G[30569]={'121:70.47,23.28'}
G[30596]={'118:83.1,72.9'}
G[30631]={'118:35.4,66.4'}
G[30657]={'118:85.7,76'}
G[30658]={'168:47.63,89.77 125:66.81,68.15>168'}
G[30671]={'121:70.1,22.9'}
G[30676]={'121:70.06,20.93'}
G[30677]={'118:86,75.8 N:28179'}
G[30683]={'118:82.9,72.8 N:30226'}
G[30686]={'118:83,73'}
G[30708]={'118:35.4,66.4 118:35.4,66.5 118:35.5,66.4 118:35.5,66.5'}
G[30709]={'88:29.2,21.8'}
G[30714]={'118:83,73'}
G[30824]={'118:60,33.8 118:60,35.2 118:60.1,33.2 118:60.1,35.6 118:60.4,32.2 118:60.4,36.5 118:60.5,31.9 118:60.9,37.4 118:61,37.7 118:61.1,31.2 118:61.4,38.6 118:61.6,39.2 118:61.7,30.9 118:62,39.9 118:62.3,40.6 118:62.5,30.6 118:62.7,41.3 118:62.8,41.6 118:63.3,29.8 118:63.4,43.1 118:63.5,43.3 118:63.6,29.5 118:63.7,29.4 118:63.9,44.4 118:64.1,44.9 118:64.3,45.5 118:64.6,28.7 118:64.6,46.4 118:64.8,47 118:65,47.6 118:65.3,28.1 118:65.4,48.5 118:65.5,28 118:65.6,48.8 118:66.1,50 118:66.2,27.2 118:66.3,50.5 118:66.5,26.9 118:66.5,50.9 118:66.8,51.6 118:67.4,26.3 118:67.5,52.4 118:67.8,52.7 118:68.2,26.4 118:68.5,26.4 118:69.1,26.8 118:69.2,52.5 118:69.4,31.4 118:69.4,31.6 118:69.4,33.2 118:69.4,33.8 118:69.4,34.6 118:69.4,52 118:69.5,27.4 118:69.5,30.2 118:69.5,30.5 118:69.5,35 118:69.5,35.7 118:69.5,51.9 118:69.6,27.6 118:69.6,37.4 118:69.6,38.3 118:69.6,38.8 118:69.7,28.8 118:69.7,40 118:69.7,41.2 118:69.7,41.8 118:69.7,42.7 118:69.7,50.8 118:69.8,44.3 118:69.8,45 118:69.8,46 118:69.8,47.2 118:69.8,48.2 118:69.8,49.3 118:69.8,49.6'}
G[30825]={'118:60,34.8 118:60.1,34 118:60.2,33.2 118:60.4,32.4 118:60.4,36.4 118:60.4,36.5 118:60.6,32 118:60.6,36.8 118:60.9,37.5 118:61.4,31.2 118:61.4,38.7 118:61.7,39.3 118:61.9,39.7 118:62.1,30.8 118:62.3,40.6 118:62.5,30.5 118:62.5,41 118:62.8,30.2 118:62.8,41.6 118:63.3,42.8 118:63.5,29.6 118:63.5,43.4 118:63.9,29.3 118:63.9,44.3 118:64.2,45.2 118:64.4,45.8 118:64.6,28.7 118:64.6,46.3 118:64.9,28.4 118:64.9,47.2 118:65.1,47.8 118:65.4,48.5 118:65.5,48.7 118:65.6,27.8 118:65.9,49.6 118:66.3,27.1 118:66.4,50.7 118:66.7,51.3 118:66.8,26.7 118:66.9,51.6 118:67.4,26.4 118:67.6,26.4 118:67.7,52.4 118:68.3,26.5 118:68.3,52.6 118:68.6,26.6 118:68.7,52.6 118:69.4,27.6 118:69.4,31.1 118:69.4,32.2 118:69.4,32.8 118:69.4,34.2 118:69.4,34.5 118:69.4,51.9 118:69.5,28.4 118:69.5,29.1 118:69.5,29.9 118:69.5,30.5 118:69.5,34.4 118:69.5,35.2 118:69.5,35.8 118:69.5,36.5 118:69.5,51.5 118:69.6,38 118:69.6,38.6 118:69.6,51.3 118:69.7,40.4 118:69.7,40.6 118:69.7,41.6 118:69.7,42.6 118:69.7,50.3 118:69.8,44.2 118:69.8,45.3 118:69.8,46 118:69.8,47 118:69.8,48.4 118:69.8,49.1 185:42.2,14.3'}
G[30869]={'123:71.98,30.97'}
G[30871]={'137:43.99,18.21 117:57.25,46.59>136'}
G[30944]={'118:54.1,71.1'}
G[30946]={'118:44,24.6'}
G[30997]={'130:31.4,45.3 130:31.4,45.5 130:32.1,44.4 130:32.1,45.1 130:32.2,44.4 130:32.2,44.8 130:32.4,45.5 130:32.4,45.8 130:32.5,44.9 130:32.5,45.7 130:32.6,44.4 130:32.7,45.3 130:32.8,44.3 N:10667'}
G[31036]={'123:49.83,18.08'}
G[31044]={'118:79.8,71.8 N:28179'}
G[31051]={'123:48.46,21.16'}
G[31052]={'123:53.07,20.88'}
G[31053]={'123:22.27,34.39'}
G[31054]={'123:43.72,17.16'}
G[31069]={'118:79.41,72.37 N:30227'}
G[31078]={'118:19.33,47.78'}
G[31081]={'125:67.73,47.17'}
G[31082]={'124:34,30.3 124:34.2,30.5 N:28510'}
G[31084]={'23:83.42,49.44 N:28444'}
G[31085]={'125:69.38,40.69'}
G[31091]={'123:22.2,35 123:22.3,35.5 123:22.5,35 123:49.8,18 123:50,18.5 123:50.5,18'}
G[31101]={'123:21.8,35.5 123:21.9,35.3 123:51.7,21.1'}
G[31102]={'123:22.5,34.6 123:53.3,20.8 123:53.8,21'}
G[31106]={'123:22,34.4 123:22,34.5 123:47.1,21.1'}
G[31107]={'123:22.4,35.4 123:22.4,35.7 123:22.5,35.4 123:22.5,35.7 123:48.6,24.5 123:48.7,24.2'}
G[31108]={'123:47.2,21 123:71.9,31.3 123:72,31.5'}
G[31109]={'123:51.07,24.63'}
G[31134]={'168:45.99,80.44'}
G[31135]={'118:30.8,29.1'}
G[31151]={'123:21.8,34.4 123:21.8,34.5 123:50.2,17.8'}
G[31153]={'123:50.22,17.74'}
G[31154]={'118:31.6,30.9'}
G[31237]={'118:53.8,87'}
G[31240]={'118:79.5,72.7'}
G[31241]={'118:79.4,72.9 118:79.5,72.8'}
G[31259]={'118:0.7,51.4 118:0.9,57.7 118:1.8,52.6 118:4.1,60.6 118:4.3,65 118:4.6,61.8 118:5.3,63.1 118:5.3,66.9 118:5.7,65.8 118:5.9,64 118:41.2,25.1 118:55.1,41 118:55.2,40.3 118:55.3,41.6 118:55.4,37.4 118:55.4,38.3 118:55.4,38.5 118:55.6,40.1 118:55.8,40.8 118:55.9,41.8 118:56,38.4 118:56,38.8 118:56.1,42.9 118:56.2,37.3 118:56.2,43.6 118:56.4,44.7 118:56.5,41 118:56.5,41.6 118:56.8,36.2 118:56.8,37 118:56.9,44.4 118:57,45.7 118:57.1,45 118:57.2,43.1 118:57.4,37.7 118:57.4,39 118:57.4,46.6 118:57.5,38.3 118:57.5,38.7 118:57.5,43.9 118:57.6,36.9 118:57.8,40.1 118:57.8,46.8 118:57.9,45.5 118:58,40.8 118:58.3,41.5 118:58.3,45.3 118:58.4,48.3 118:58.5,38 118:58.5,47.1 118:58.6,42.3 118:58.6,46.2 118:58.7,38.9 118:58.8,47.6 118:58.9,40 118:59,40.5 118:59,42.9 118:59.1,49.7 118:59.3,50.5 118:59.4,44.1 118:59.4,48.8 118:59.5,48.3 118:59.6,41.1 118:59.8,44.6 118:59.8,48.6 118:60,42.2 118:60,42.5 118:60,44.3 118:60,49.8 118:60.1,46 118:60.3,51.4 118:60.3,52.4 118:60.3,53.1 118:60.4,46.5 118:60.4,53.6 118:60.5,43.4 118:60.5,44.6 118:60.5,49.8 118:60.5,50.9 118:60.6,44.4 118:60.6,53.8 118:60.8,46.3 118:61,47.5 118:61.2,52 118:61.2,52.6 118:61.3,47.4 118:61.3,48.8 118:61.3,54.5 118:61.4,56.3 118:61.5,45.7 118:61.6,53.5 118:61.7,53.3 118:61.9,47.3 118:61.9,49.6 118:62,56.6 118:62.1,47.9 118:62.3,50.6 118:62.3,56.1 118:62.4,49 118:62.4,55.2 118:62.4,57.7 118:62.5,48.4 118:62.5,48.8 118:62.5,49.7 118:62.7,51.8 118:63,50.7 118:63,57.9 118:63.3,52.8 118:63.3,56.5 118:63.4,53.9 118:63.4,56.4 118:63.6,50.4 118:63.6,52.5 118:63.6,54.5 118:63.7,51.2 118:63.7,52.1 118:63.7,57.7 118:64,53.7 118:64,56 118:64.4,56.7 118:64.5,53.4 118:64.5,56.9 118:64.7,53.8 118:64.7,55.5 118:65,55.4'}
G[31261]={'118:2.7,49.1 118:2.9,45.2 118:3.6,44.1 118:4.4,53 118:4.6,53.5 118:5.4,42.1 118:6,42.1 118:6,57.1 118:6.1,56 118:7,58.8 118:7.2,40.4 118:7.4,60.2 118:7.6,60.1 118:7.8,39.8 118:7.8,60.6 118:8.6,62.5 118:9.3,39.2 118:9.8,39.3 118:10.2,39.7 118:10.5,50.5 118:10.5,54.7 118:10.7,48.3 118:10.9,60.6 118:42.4,22.1 118:43.2,24.2 118:43.3,24.5 118:44.4,26.9 118:46,24.6 118:59.9,33.9 118:59.9,34.5 118:60.2,36.3 118:60.2,36.9 118:60.3,31.9 118:60.3,32.7 118:60.5,33.2 118:60.5,33.6 118:60.5,35.2 118:60.7,36.1 118:60.9,31.2 118:60.9,32.4 118:60.9,37 118:61.2,39.1 118:61.4,38.1 118:61.4,39.7 118:61.5,37.9 118:61.6,40 118:61.7,31.6 118:62.2,39.3 118:62.2,41.2 118:62.3,30 118:62.4,30.8 118:62.4,41.7 118:62.5,30.2 118:62.5,40.8 118:62.5,41.8 118:62.6,30.9 118:62.7,40.3 118:63,42.7 118:63.1,29.3 118:63.3,43.6 118:63.6,29.5 118:63.6,42.4 118:63.6,43 118:63.6,44.1 118:63.9,45.6 118:64,45.2 118:64.2,29.1 118:64.3,46.5 118:64.4,28.3 118:64.5,45.9 118:64.6,45.3 118:64.6,46.9 118:64.8,28 118:64.8,28.7 118:64.8,47.6 118:65.3,49.2 118:65.4,27.4 118:65.4,49.5 118:65.5,48 118:65.6,28.5 118:65.6,49.5 118:65.9,49.3 118:66,27.6 118:66.3,26.6 118:66.4,51.4 118:66.4,51.5 118:66.5,27.5 118:66.5,49.9 118:66.9,26.4 118:66.9,50.9 118:67.2,26.6 118:67.3,51.9 118:67.3,52.7 118:67.5,52.2 118:68,26.3 118:68.3,27 118:68.3,52.5 118:68.5,27 118:68.6,52.2 118:68.7,26.2 118:68.7,53 118:69,31.7 118:69.1,29.6 118:69.1,32.7 118:69.1,35.4 118:69.2,29 118:69.2,31 118:69.2,34.2 118:69.2,35.7 118:69.2,36.5 118:69.2,51.1 118:69.3,38.2 118:69.3,40.1 118:69.3,41 118:69.3,41.7 118:69.4,28.1 118:69.4,38.9 118:69.4,42.6 118:69.4,44 118:69.4,44.6 118:69.4,46.2 118:69.4,47.3 118:69.4,47.7 118:69.4,49.2 118:69.4,49.6 118:69.5,29.2 118:69.5,35.2 118:69.5,41.7 118:69.5,50.5 118:69.5,51.6 118:69.6,27.2 118:69.6,30.7 118:69.6,35.8 118:69.6,39.7 118:69.7,31.5 118:69.7,33.4 118:69.7,34.2 118:69.7,44.9 118:69.8,28 118:69.8,30.1 118:69.8,37.3 118:69.8,48.7 118:69.9,38 118:70,39 118:70,40.7 118:70,44.3 118:70.1,42.5 118:70.1,49.9 118:70.2,45.8 118:70.2,46.9 118:70.2,47.5'}
G[31273]={'118:66.9,66.4 118:67.1,67.3 118:67.2,67.5 118:67.2,68.8 118:67.3,69.5 118:67.7,68.3 118:67.8,68.6 118:67.9,71.1 118:68.1,67.4 118:68.5,69.7 118:68.7,64.5 118:68.7,69.1 118:68.8,64.3 118:68.9,65.9 118:69,67.2 118:69.3,67.9 118:70,62.3 118:70,62.5 118:70.4,65 118:70.4,67.3 118:70.5,65 118:70.5,67.2 118:70.8,68.3 118:70.8,68.5'}
G[31279]={'118:31.8,64.8 118:31.9,64.2'}
G[31304]={'118:66.1,65.4 118:66.1,65.5 118:66.3,64.1 118:66.4,66.5 118:66.5,66.5 118:66.7,65.7 118:66.8,64 118:67.2,63.3 118:67.3,69.1 118:67.4,67.6 118:67.5,67.7 118:67.7,70.3 118:67.9,64.5 118:68.1,63.4 118:68.1,63.5 118:68.1,67.4 118:68.1,69.4 118:68.4,62.4 118:68.5,62.3 118:68.6,69.1 118:68.7,66.4 118:68.7,66.5 118:68.8,62.7 118:68.8,64.4 118:68.8,64.5 118:69.1,68.3 118:69.2,70.4 118:69.2,70.5 118:69.5,66 118:69.5,67.3 118:69.5,67.5 118:69.8,63.2 118:69.8,64.6 118:70.2,61.9 118:70.4,64.1 118:70.5,65.1 118:70.8,62.9 118:70.9,63.9 118:71.6,61.1 118:71.6,62.7'}
G[31440]={'118:54.9,84.2'}
G[31444]={'118:51.8,86.7'}
G[31737]={'118:59.9,53.4 118:59.9,53.5 118:60.6,49.8 118:61.6,52.5 118:62.1,51.8 118:62.7,51 118:62.7,51.6'}
G[31776]={'118:57,62.5'}
G[31781]={'118:51.9,57.6'}
G[31808]={'118:62.6,51.3'}
G[31833]={'118:57.4,47.4 118:57.4,47.5 118:57.5,46.7 118:57.6,48.3 118:58.4,46.1 118:59.4,52.6'}
G[31834]={'118:58.3,46'}
G[31868]={'118:68,51.8'}
G[31892]={'118:54.4,59.1 118:54.5,59.5 118:54.6,59.2'}
G[32301]={'118:2.3,44.9 118:3.9,43.1 118:4.4,52.2 118:4.8,42.8 118:4.8,53.1 118:5.3,42.3 118:5.4,53.9 118:6.1,56.4 118:6.8,58.4 118:6.8,59.1 118:7.8,60.7 118:8.5,61.4 118:8.7,39.6 118:8.8,62.1 118:10.1,62.6 118:10.4,40.3 118:10.6,46.8 118:10.6,51.7 118:10.6,53.5 118:10.7,48.2 118:10.7,53.4 118:11,51.4 118:11,61.2 118:46,26.5 118:59.9,33 118:60.1,33.6 118:60.2,34.7 118:60.3,31.8 118:60.3,36 118:60.4,37 118:60.5,33.7 118:60.5,35.3 118:60.5,35.9 118:60.6,32.1 118:60.6,32.6 118:60.7,37.2 118:61.1,38 118:61.1,39 118:61.2,31.4 118:61.4,39.6 118:61.5,38 118:61.5,38.5 118:61.6,31.1 118:61.9,30.4 118:61.9,31.5 118:62,39.9 118:62,40.8 118:62.4,41.6 118:62.6,30.6 118:62.6,40.4 118:62.6,41.2 118:63,30 118:63.2,42.2 118:63.3,29.3 118:63.3,42.9 118:63.4,44.1 118:63.5,42.3 118:63.5,42.7 118:63.6,43.6 118:64.1,29.7 118:64.2,28.4 118:64.2,45.3 118:64.3,28.9 118:64.4,46.1 118:64.4,46.9 118:64.5,45.1 118:64.5,46 118:64.6,28.7 118:64.8,47.4 118:65.1,28.2 118:65.2,48.2 118:65.3,48.6 118:65.4,27.3 118:65.4,49.5 118:65.5,48.4 118:65.6,27.6 118:65.7,49.1 118:65.8,49.6 118:66.3,27.1 118:66.4,50.6 118:66.6,50.4 118:66.7,51.7 118:66.8,51.4 118:67.2,52.5 118:67.3,26.2 118:67.4,26.5 118:67.5,52.2 118:67.9,26.4 118:68,26.5 118:68.1,52.6 118:68.6,53 118:69,26.4 118:69.2,29.1 118:69.2,35 118:69.2,36.9 118:69.2,52 118:69.3,27.3 118:69.3,30.6 118:69.3,33.3 118:69.3,33.7 118:69.3,35.9 118:69.3,39.2 118:69.4,28.1 118:69.4,30.4 118:69.4,32.1 118:69.4,37.9 118:69.4,39.6 118:69.4,41.2 118:69.4,42.3 118:69.4,42.5 118:69.4,44.6 118:69.4,49.3 118:69.4,49.9 118:69.4,50.5 118:69.5,27 118:69.5,28.7 118:69.5,29.6 118:69.5,30.8 118:69.5,32 118:69.5,33.5 118:69.5,35 118:69.5,36.5 118:69.5,51.7 118:69.6,27.5 118:69.6,33.4 118:69.6,38.3 118:69.6,38.8 118:69.7,35.9 118:69.7,40.1 118:69.7,40.8 118:69.8,41.6 118:69.8,43.8 118:69.8,44.7 118:69.8,46.1 118:69.8,48.6 118:69.8,49.9 118:69.9,47 118:69.9,48.3 118:69.9,51.4 118:70.1,42.9'}
G[32302]={'118:41.3,25.3 118:41.6,25.9 118:55.3,39 118:55.4,38.4 118:55.4,39.8 118:55.5,39.3 118:55.7,40.4 118:55.8,37.5 118:55.8,40.9 118:55.9,41.9 118:56.1,37.3 118:56.4,43.2 118:56.6,43.6 118:56.7,43.4 118:57,36.9 118:57.1,44.8 118:57.5,45.4 118:57.7,37.4 118:57.9,45.8 118:58,38.2 118:58.2,39.1 118:58.2,46.6 118:58.3,39.5 118:58.5,40 118:58.5,47.2 118:58.8,47.8 118:58.9,41.1 118:59.2,41.7 118:59.3,48.8 118:59.4,42.5 118:59.5,42.4 118:59.6,49.2 118:59.8,43.3 118:59.8,43.6 118:60,50 118:60.1,50.9 118:60.3,51.5 118:60.4,44.5 118:60.5,44.9 118:60.5,51.4 118:60.6,52.2 118:60.8,45.5 118:60.9,53.3 118:61.2,54 118:61.4,46.9 118:61.4,54.6 118:61.5,47.2 118:61.5,54.3 118:61.5,54.9 118:61.8,48.4 118:61.8,56.3 118:61.8,56.6 118:62.3,49.5 118:62.4,49.3 118:62.4,57.6 118:62.5,50 118:62.6,57.5 118:63.3,51.3 118:63.4,51.5 118:63.4,57.2 118:63.5,51.7 118:63.7,52.6 118:64.1,53.7 118:64.3,54.5 118:64.4,56.4 118:64.4,56.7 118:64.5,55.1 118:64.5,55.7'}
G[32337]={'125:54.00,32.27'}
G[32404]={'118:64.5,44 N:31237'}
G[32408]={'118:68,51.7 N:31237'}
G[32413]={'125:44.64,63.30'}
G[32423]={'118:71.6,37.6 N:31237'}
G[32430]={'118:54,36.9'}
G[32444]={'118:54,42.9'}
G[32497]={'118:49.2,73.1 N:31237'}
G[32516]={'126:43.16,24.42'}
G[32540]={'120:66.16,61.43'}
G[32548]={'114:29.4,24.8 114:29.5,24.8'}
G[32571]={'120:62.61,60.92'}
G[32594]={'120:67.1,60.9'}
G[32599]={'115:79.3,65.1'}
G[32638]={'641:68.32,40.58'}
G[32639]={'539:32.39,41.87'}
G[32641]={'25:57.94,72.62'}
G[32642]={'27:53.63,52.54'}
G[32725]={'627:33.45,47.33'}
G[32798]={'HN 1:51.82,42.07 7:46.93,59.53 18:61.62,53.11 94:47.77,47.13'}
G[32799]={'HN 27:53.99,50.70 37:42.98,65.40 57:55.59,51.36 97:49.07,51.25'}
G[32800]={'118:31.3,62.4 118:31.4,59 118:31.7,57.8 118:31.8,64.8 118:31.9,57.2 118:31.9,64.2 N:31279'}
G[32801]={'HM 114:55.10,19.94'}
G[32802]={'HM 119:48.09,66.36'}
G[32803]={'HM 115:75.29,43.80'}
G[32804]={'HM 117:57.80,16.12'}
G[32805]={'HM 116:33.90,60.45'}
G[32806]={'HM 120:41.44,86.69'}
G[32807]={'HM 127:78.18,74.95'}
G[32808]={'HM 121:40.37,61.30'}
G[32809]={'HM 114:51.13,11.54'}
G[32810]={'HM 119:47.06,61.56'}
G[32811]={'HM 115:38.26,48.47'}
G[32812]={'HM 117:48.61,13.15'}
G[32813]={'HM 116:19.32,61.15'}
G[32814]={'HM 120:40.27,85.35'}
G[32815]={'HM 127:79.97,53.23'}
G[32816]={'HM 121:43.37,71.74'}
G[32836]={'HN 27:54.11,50.82 37:43.04,65.33 57:55.72,51.30 97:49.02,51.19'}
G[32837]={'HN 1:51.90,41.87 7:47.12,59.89 18:61.35,52.98 94:47.65,47.31'}
G[32862]={'62:72.38,18.75'}
G[32863]={'62:58.8,19.4'}
G[32867]={'149:13.21,57.21'}
G[32871]={'149:80.92,45.50'}
G[32912]={'62:50.31,20.33'}
G[32932]={'62:44.6,30.8'}
G[32959]={'62:50.82,17.95'}
G[32960]={'62:50.9,18'}
G[32963]={'62:58.91,19.45'}
G[32964]={'62:64.51,5.47 N:11711'}
G[32965]={'62:58.89,19.41'}
G[32966]={'62:58.88,19.53'}
G[32967]={'62:43.5,80.9'}
G[32968]={'62:43.5,80.9'}
G[32970]={'62:64,5.4'}
G[32971]={'62:50.22,19.78'}
G[32972]={'62:50.93,18.21'}	-- moves about
G[32973]={'62:51.78,18.01'}
G[32977]={'62:51.2,19.6'}
G[32978]={'62:51.2,19.7'} -- 42:56.8,30 removed because it is fleeting
G[32979]={'62:51.00,19.19'}
G[32987]={'62:42.68,45.15'}
G[33022]={'62:58.6,32.6'}
G[33025]={'121:69.99,20.96'}
G[33048]={'62:42.97,39.01'}
G[33055]={'62:63.75,5.98'}
G[33072]={'62:45.4,74.9'}
G[33091]={'62:43.66,53.44'} -- AS
G[33107]={'62:42.6,45.1'}
G[33112]={'62:44.43,56.78'}
G[33117]={'62:40.94,56.48'}
G[33119]={'62:45.4,48.5 62:45.5,48.5'}
G[33126]={'62:42.9,39'}
G[33131]={'62:42.79,40.17'}
G[33132]={'62:42.46,38.56'}
G[33133]={'62:43.68,39.85'}
G[33166]={'62:49.2,57'}
G[33175]={'62:52.4,18'}
G[33176]={'62:69.09,19.24'}
G[33177]={'62:46.8,33.2'}
G[33178]={'62:72.28,19.09'}
G[33182]={'63:29,24.1'}
G[33187]={'63:26.9,22'}
G[33204]={'63:26.8,22'}
G[33222]={'118:76.5,19.2'}
G[33223]={'118:76.6,19.2'}
G[33225]={'118:76.6,19.2'}
G[33231]={'62:42.59,45.29'}
G[33232]={'62:38.6,42.4'}
G[33250]={'62:45.2,75.1'}
G[33253]={'62:44.41,75.47'}
G[33256]={'221:47.95,13.43'}
G[33258]={'221:47.93,13.10'}
G[33260]={'221:48.48,12.05'}
G[33261]={'221:48.48,11.62'}
G[33263]={'10:42.42,15.77'}
G[33276]={'63:26.9,36.7 63:27,36.3'}
G[33280]={'84:53.9,81.4 194:59.7,72.6'}
G[33284]={'10:42.27,15.20'}
G[33294]={'63:64.16,84.50'}
G[33309]={'118:76.6,19.5'}
G[33312]={'118:76.6,19.5'}
G[33315]={'118:76.6,19.4 118:76.6,19.5'}
G[33335]={'118:76.5,19.8'}
G[33361]={'118:76.4,24.5 118:76.5,24.5'}
G[33372]={'118:76,24.4 118:76,24.5'}
G[33373]={'118:76.5,24.2'}
G[33379]={'118:76.4,23.9 118:76.5,23.9'}
G[33403]={'118:76.2,24.6'}
G[33405]={'118:76.4,24.4 118:76.4,24.5 118:76.5,24.5'}
G[33417]={'118:69.4,23 118:69.5,23.1'}
G[33421]={'63:72.93,80.44'}
G[33443]={'63:20.2,38.8'}
G[33445]={'63:26.8,36'}
G[33454]={'63:34.7,48.6'}
G[33532]={'HC Near'}
G[33533]={'HC Near'}
G[33536]={'77:50.3,14.5 77:50.9,14.5 77:51.9,15 77:52.6,14.5 77:53.1,17.4 77:54,16.8 77:54.5,20.6 77:55.2,19 147:53,37.9 147:53,39.1 147:53.1,36 147:53.1,37.3 147:53.2,36 147:53.3,37.2 147:53.3,39 147:53.3,39.6 147:53.3,39.7 147:53.4,38.4 147:53.7,39 147:53.7,39.8 147:53.9,35.9 147:53.9,37.6 147:54.3,35.3 147:54.3,35.4 147:54.3,35.9 147:54.3,36.5 147:54.3,37.7 147:54.4,36.8 147:54.4,38.9 147:54.4,39.5 147:54.5,35.4 147:54.5,38.5 147:54.6,35.5 147:54.6,36.7 147:54.6,37 147:54.6,37.9 147:54.6,38.5 147:54.6,39.5 147:54.7,36 147:54.8,37.9 147:55.5,38 147:55.6,37.4 201:63.9,59.5 207:71.8,47.7 204:52.4,59.4'}
G[33538]={'118:76.4,23.8'}
G[33539]={'118:76.2,24.6'}
G[33540]={'118:76,24.5'}
G[33541]={'118:76.5,24.2'}
G[33542]={'118:76.3,24.3'}
G[33544]={'118:76.4,24.5'}
G[33545]={'118:76,24.4 118:76,24.5'}
G[33547]={'118:76.5,24.3'}
G[33548]={'118:76.4,23.9 118:76.5,23.9'}
G[33549]={'118:76.2,24.6'}
G[33592]={'118:76.3,19.1'}
G[33593]={'118:76.1,19.2'}
G[33625]={'118:76.4,19.4 118:76.4,19.5'}
G[33646]={'118:76.4,19.4 118:76.4,19.5'}
G[33647]={'118:76.4,19.4 118:76.4,19.5 118:76.5,19.5'}
G[33648]={'118:76.5,19.8'}
G[33649]={'118:76.5,19.8'}
G[33652]={'118:76.3,19.1'}
G[33654]={'118:76.4,19.1'}
G[33655]={'118:76.1,19.2'}
G[33656]={'118:76.1,19.1'}
G[33658]={'118:76.3,24.3'}
G[33659]={'118:76.2,24.4'}
G[33726]={'63:73.33,62.19'}
G[33727]={'63:86.4,43.7 63:86.5,43.7'}
G[33759]={'118:69.9,23.4 118:69.9,23.5'}
G[33760]={'63:72.20,57.65','In mine'}
G[33762]={'118:73.8,20'}
G[33763]={'118:69.9,23.4 118:69.9,23.5'}
G[33769]={'118:73.8,19.5'}
G[33770]={'118:73.6,20'}
G[33771]={'118:69.9,23.4'}
G[33777]={'63:75.4,75.8 63:75.6,75.5 63:75.7,75.2'}
G[33817]={'118:69.7,22.8'}
G[33837]={'63:73.61,62.14 N:8582'}
G[33849]={'118:72.59,22.62'}
G[33889]={'63:82.54,53.81'}
G[33956]={'147:14,88.6 147:15.2,89.5 147:15.3,87.3 147:15.3,88.8 147:15.4,88.4 147:15.8,87 147:15.8,88.2 147:15.9,90 147:16.1,88.8 147:16.6,88.1 147:16.6,88.7 147:16.8,89.5'}
G[33957]={'147:14.8,87 147:14.9,87.6 147:15.1,88.7 147:15.5,88.6 147:15.6,87.1 147:15.7,87.6 147:16.1,90.2'}
G[33977]={'63:72.20,57.65 N:33760','In mine'}
G[33981]={'62:57.39,33.85'}
G[34041]={'62:59.1,19.6'}
G[34122]={'63:12.08,33.83'}
G[34195]={'63:94.40,46.82'}
G[34210]={'118:69.5,22.4'}
G[34233]={'63:90.76,58.15'}
G[34239]={'63:36.4,49.8'}
G[34242]={'63:89.6,48.7'}
G[34251]={'63:38,30.1'}
G[34258]={'10:67.44,38.74'}
G[34283]={'63:52.1,56.5'}
G[34284]={'10:66.50,45.55 10:66.49,45.45'}
G[34289]={'63:52.33,56.77'}
G[34290]={'63:52.32,56.51'}
G[34292]={'63:52.09,56.72'}
G[34301]={'62:45.2,74.7'}
G[34303]={'63:11.40,35.36'}
G[34320]={''}
G[34335]={'63:59.1,59.9'}
G[34340]={'62:37.7,82.8'}
G[34341]={'65:74.27,47.72'}
G[34342]={'62:37.7,82.9'}
G[34343]={'62:37.4,82.2 62:37.5,82.3 62:37.7,82.9'}
G[34354]={'63:35.1,71.6'}
G[34358]={'63:59.1,59.9'}
G[34359]={'63:37.99,42.84 63:38.10,43.80 63:39.24,43.58'}
G[34365]={'HC 125:49.36,63.25'}
G[34374]={'63:18.14,20.59'}
G[34377]={'63:62.2,51'}
G[34378]={'63:35.02,72.07'}
G[34395]={'63:37.98,43.86'}
G[34402]={'62:45.3,75.1'}
G[34403]={'62:45.3,75.1'}
G[34404]={'62:45.3,75.1'}
G[34413]={'62:40.61,84.44'}
G[34422]={'62:32.8,84.3 N:33091'}
G[34423]={'62:32.3,85.2'}
G[34435]={'HD 84:47.80,26.69'}
G[34446]={'62:45.7,71.8'}
G[34476]={'HD 998:68.30,15.63'}
G[34477]={'HD 1:47.47,17.63'}
G[34478]={'HD 27:61.66,37.34'}
G[34479]={'HD 89:68.47,39.87'}
G[34480]={'HD 88:57.08,17.37'}
G[34481]={'HD 27:61.63,37.50'}
G[34482]={'HD 1:47.47,17.86'}
G[34483]={'HD 94:47.99,49.47'}
G[34484]={'HD 97:47.61,55.74'}
G[34498]={'62:45.6,71.7'}
G[34510]={'63:38.8,43.3'}
G[34512]={'63:52.09,56.50'}
G[34513]={'10:56.58,40.29'}
G[34518]={'63:60.67,52.68'}
G[34547]={'10:58.01,49.31'}
G[34559]={'63:50.13,67.57'}
G[34560]={'10:53.9,41.5 10:54,41.3'}
G[34569]={'63:49.96,67.24'}
G[34571]={'179:37.41,63.35'}
G[34578]={'10:54.6,41.4 10:54.6,41.5'}
G[34596]={'63:46.16,63.27'}
G[34599]={'63:18,60 N:3698'}
G[34604]={'63:22.3,53.1'}
G[34613]={'10:37.5,45.8'}
G[34626]={'10:60.65,85.37'}
G[34634]={'10:55.11,78.53 10:54.94,78.79'}
G[34638]={'10:55.20,78.40'}
G[34644]={'HY 27:59.81,34.33'}
G[34651]={'10:67.02,74.80'}
G[34653]={'HY 27:52.6,36.4 27:53.4,51.4 27:59.77,34.72 37:34.17,51.08 37:42.25,64.07 57:55.96,51.00 62:50.7,18.8 64:78.31,72.49 89:63.41,47.61 100:55.12,63.40 103:76.17,53.29'}
G[34654]={'HY 1:46.24,14.30 1:52.8,44.1 18:58.7,51.5 25:56.14,47.32 7:46.8,59.1 88:29.93,65.13 998:65.54,8.13 94:46.6,47.3 94:55.5,53.2'}
G[34668]={'194:56.43,76.96'}
G[34673]={'194:60.48,77.57'}
G[34674]={'10:62.6,17'}
G[34675]={'HY 37:34.09,51.54'}
G[34676]={'HY 89:61.48,49.11'}
G[34677]={'HY 998:63.92,11.44'}
G[34678]={'HY 88:30.80,63.69'}
G[34679]={'HY 1:46.59,13.80'}
G[34689]={'194:59.42,73.62'}
G[34692]={'194:57.81,77.14'}
G[34693]={'194:58.88,75.26'} -- 605:59.49,77.73 605:58.30,73.04
G[34695]={'194:59.74,76.02'}
G[34696]={'194:57.90,74.25'}
G[34697]={'194:60.34,77.84'}
G[34698]={'10:62.50,16.76'}
G[34707]={'10:72.60,84.04'}
G[34708]={'HY 27:60.04,34.31'}
G[34710]={'HY 37:33.71,50.63'}
G[34711]={'HY 89:61.89,46.19'}
G[34712]={'HY 998:63.21,8.91'}
G[34713]={'HY 1:46.36,13.86'}
G[34714]={'HY 88:30.4,68.9'}
G[34744]={'HY 37:33.89,50.80'}
G[34749]={'10:77.24,91.39'}
G[34768]={'HY 998:65.26,14.25'}
G[34771]={'118:76.1,24.1'}
G[34828]={'10:62.37,63.90'}
G[34835]={'194:44.3,74.9 194:44.4,75.5 194:44.6,74.4 194:44.7,75.5 194:45.1,74.8'}
G[34841]={'10:38,46.5 10:38.1,46.3'}
G[34850]={'202:59.14,23.91'}
G[34863]={'202:54.63,16.73'}
G[34872]={'194:60.20,74.63'}
G[34874]={'194:58.24,76.53'}
G[34876]={'194:36.4,71.8 194:36.6,71.7 194:36.7,71 194:36.8,70.4'}
G[34877]={'194:35.1,77.7 194:35.4,76.9 194:35.5,78.7 194:35.7,76.4 194:35.7,77.3 194:35.7,77.5 194:36.5,76.6 194:36.6,76.1 194:36.8,75.4'}
G[34878]={'194:41,81.4 194:41,81.5 194:41.7,81.5 194:41.9,80.9 194:42.1,80.4'}
G[34880]={'118:76.3,19.6'}
G[34882]={'118:69.5,23.1'}
G[34884]={'202:55.2,26.5 202:55.4,26.1 202:55.4,27.5 202:55.5,26.7 202:55.5,27.5 202:55.7,29.3 202:55.7,32 202:55.7,38.9 202:55.8,37.7 202:55.9,26.3 202:56,32.8 202:56.1,30.3 202:56.1,30.9 202:56.2,39.5 202:56.3,23.2 202:56.3,37.4 202:56.5,31.7 202:56.5,39.7 202:56.6,30.9 202:56.6,34.1 202:56.6,41.9 202:56.7,35.2 202:56.7,38.6 202:56.8,35.9 202:57,25 202:57.1,25.6 202:57.4,22.3 202:57.4,22.9 202:57.4,23.8 202:57.5,23.9 202:57.5,41.1 202:57.7,30.2 202:57.7,40.4 202:57.8,21.9 202:57.9,23.2 202:58.1,24.5 202:58.1,41.5 202:58.3,31.2 202:58.5,31.4 202:58.6,21.3 202:58.6,42.6 202:58.8,33 202:58.9,24 202:59,30.3 202:59,32.4 202:59,41.7 202:59.2,22 202:59.2,22.7 202:59.5,22.2 202:59.5,29.7 202:59.7,29.3 202:59.8,22.7 202:59.8,26.1 202:59.9,23.5 202:59.9,26.7 202:59.9,30.6 202:59.9,41.3 202:60,28.3 202:60,42.7 202:60.1,36 202:60.1,36.6 202:60.2,24.7 202:60.3,31.7 202:60.3,37.8 202:60.3,42.4 202:60.4,32.9 202:60.4,33.8 202:60.4,34.7 202:60.5,22.3 202:60.5,22.7 202:60.5,33.3 202:60.5,38 202:60.5,41.3 202:60.6,42.5 202:60.7,24.3 202:60.7,25.3 202:60.8,27.2 202:60.8,41.9 202:60.9,28.6 202:60.9,34 202:61,16.8 202:61.1,26.3 202:61.1,35 202:61.1,36.8 202:61.4,28.1 202:61.4,31.1 202:61.4,36.4 202:61.5,22.4 202:61.5,27.4 202:61.5,35.4 202:61.6,17.2 202:61.6,27.6 202:61.6,28.7 202:61.6,31.1 202:61.6,36.2 202:61.6,36.5 202:61.7,25.7 202:61.8,33.7 202:61.8,41.4 202:62.1,32.2 202:62.3,32.5 202:62.4,41.8 202:62.5,32.3 202:62.7,32.7 202:62.9,34 202:63,20.7 202:63,42.1 202:63.3,20.1 202:63.6,33.5 202:63.7,23.4 202:63.7,42.2 202:63.8,16 202:63.8,19.2 202:63.8,44.2 202:64,21.5 202:64,32.3 202:64,44.5 202:64.1,23.9 202:64.1,42.9 202:64.2,33.4 202:64.5,42.5 202:64.6,21.9 202:64.6,41.8 202:64.8,33 202:65,33.5 202:65.3,26.7 202:65.3,37.8 202:65.4,36.9 202:65.6,27.4 202:65.6,41.7 202:65.7,43.7 202:65.8,31.4 202:65.9,28.6 202:66,31.7 202:66.1,29.7 202:66.2,33.1 202:66.2,34.6 202:66.2,38.4 202:66.3,33.8 202:66.5,43.9 202:66.6,34.9 202:66.7,30.2 202:66.7,34.3 202:66.7,36.4 202:67.1,37.3 202:67.2,37.9 202:67.2,38.5 202:67.7,39 202:67.8,37.8 202:68.2,42.1 202:68.3,41 202:68.4,42.7 202:68.5,42 202:68.5,43.3'}
G[34912]={'118:76.2,19.5'}
G[34913]={'202:59.78,22.16 N:34850'}
G[34914]={'118:76.1,24.1'}
G[34936]={'202:59.59,26.79 N:34571'}
G[35053]={'194:56.31,77.10'}
G[35054]={'194:56.31,76.77'}
G[35068]={'86:47.64,71.23'}
G[35077]={'202:55.20,62.89'}
G[35085]={'76:29.12,66.16'}
G[35086]={'76:27.00,77.07'}
G[35087]={'76:29.68,66.88'}
G[35088]={'76:29.72,67.07'}
G[35091]={'76:29.15,66.24'}
G[35094]={'118:69.5,23.1'}
G[35095]={'76:27.01,73.52'}
G[35112]={'202:65.77,77.77'}
G[35115]={'202:65.32,77.65'}
G[35120]={'194:30.11,71.95'}
G[35129]={'76:28.36,75.59'}
G[35136]={'65:70.92,80.57'}
G[35137]={'65:58.80,54.28'}
G[35138]={'65:32.02,61.84'}
G[35142]={'76:70.36,36.25'}
G[35187]={'76:47.23,20.85'}
G[35195]={'76:27,77 N:35086'}
G[35222]={'194:56.71,76.93','Upstairs'}
G[35256]={'HD 125:34.47,38.19'}
G[35260]={'HD 108:39.79,21.80'}
G[35261]={'HD 108:40.17,22.25'}
G[35281]={'89:43.8,78.6'}
G[35286]={'66:54.7,8.8'}
G[35295]={'66:44.6,29.5'}
G[35298]={'66:44.8,29.6'}
G[35369]={'202:56.78,85.49','In basement'}
G[35378]={'202:56.86,81.44'}
G[35384]={'66:76.94,17.99'}
G[35451]={'171:46.04,50.15'}
G[35478]={'66:57.72,49.74'}
G[35481]={'66:36.76,71.68'}
G[35506]={'66:64.8,7.7 66:64.9,7.2 66:65,9.4 66:65.1,10 66:66.3,10.9 66:66.9,10 66:67.4,10.7 66:67.6,10.6 66:68,9.4 66:68,10.3'}
G[35510]={'66:65.1,8.2 66:67,9.7 66:67.6,10.6 66:68.1,10'}
G[35550]={'202:59.37,83.81 N:35112'}
G[35552]={'202:31.13,72.35 N:35077'}
G[35556]={'66:70.65,32.89'}
G[35562]={'66:39.07,26.94'}
G[35566]={'202:48.90,52.76 N:35077'}
G[35591]={'66:51.6,76'}
G[35618]={'202:40.55,39.43'}
G[35632]={'66:53.90,33.27'}
G[35642]={'535:28.37,74.23'}
G[35646]={'393:75.10,43.74'}
G[35648]={'76:47.15,21.06'}
G[35650]={'174:27.87,75.55 N:34668'}
G[35657]={'76:50.68,75.30'}
G[35661]={'66:70.37,32.96'}
G[35754]={'76:47.1,21'}
G[35755]={'76:47.29,21.19'}
G[35756]={'76:47.24,21.27'}
G[35757]={'66:60.9,28.9'}
G[35758]={'174:27.94,74.42 N:34673'}
G[35769]={'174:31.27,79.26 N:34872'}
G[35773]={'66:38.80,26.96'}
G[35786]={'174:27.84,74.29 N:34695'}
G[35817]={'76:52.22,74.24'}
G[35827]={'66:30.94,30.89'}
G[35833]={'76:59.01,71.90'}
G[35837]={'174:31.19,74.12','In cave'}
G[35839]={'202:67.61,64.32'}
G[35840]={'202:70.78,55.08 N:34571'}
G[35867]={'76:55.49,52.13'}
G[35869]={'202:71.40,64.43'}
G[35870]={'202:70.44,65.54'}
G[35871]={'202:71.40,65.73'}
G[35872]={'202:68.03,64.71'}
G[35873]={'202:70.20,65.85'}
G[35874]={'202:71.49,61.20'}
G[35875]={'174:37.62,78.03'}
G[35893]={'174:35.43,75.72'}
G[35902]={'66:29.08,8.08'}
G[35906]={'202:55.72,80.69 N:35115'}
G[35911]={'202:30.37,73.12 N:35112'}
G[35917]={'174:34.61,66.86 N:35893'}
G[36034]={'66:57.46,47.72'}
G[36048]={'66:58.78,46.42'}
G[36052]={'66:58.45,49.85'}
G[36056]={'66:58.29,50.09'}
G[36060]={'66:58.59,48.74'}
G[36077]={'76:50.42,74.29'}
G[36112]={'174:25.28,59.84'}
G[36127]={'174:23.23,67.51'}
G[36132]={'179:37.41,63.24'}
G[36140]={'179:35.94,66.17 N:34850'}
G[36145]={'174:11.77,62.72 N:4949','In ship'}
G[36146]={'76:45.06,75.48'}
G[36161]={'174:12.41,63.14 N:4949'}
G[36163]={'66:71.72,45.57'}
G[36170]={'179:36.51,62.26 N:35115'}
G[36185]={'66:40.50,95.48','Inside cave'}
G[36188]={'174:35.92,66.72 N:4949'}
G[36196]={'280:38.2,58 67:13.02,46.30>280'}
G[36205]={'179:32.77,66.15'}
G[36210]={'76:42.71,25.11'}
G[36290]={'179:28.96,63.92 N:35115'}
G[36291]={'179:28.93,64.02'}
G[36296]={'310:39.31,52.46'}
G[36329]={'66:36.69,71.22'}
G[36332]={'179:36.41,61.25 N:35112'}
G[36334]={'76:55.71,14.76 N:35187'}
G[36335]={'76:32.97,23.55 N:35187'}
G[36336]={'76:62.19,21.07 N:35187'}
G[36337]={'76:31.06,26.77 N:35187'}
G[36361]={'76:55.95,12.15 N:35187'}
G[36372]={'76:25.59,37.96'}
G[36378]={'66:36.39,71.14'}
G[36379]={'76:50.53,74.74'}
G[36398]={'66:72.28,67.35 N:36056'}
G[36410]={'66:54.24,9.28'}
G[36425]={'174:36.02,67.52 N:34668'}
G[36436]={'76:27.92,39.91'}
G[36444]={'66:82.34,80.86 N:36056'}
G[36451]={'179:29.03,65.05 N:34850'}
G[36452]={'179:37.63,65.21 N:34571'}
G[36456]={'179:36.89,84.17'}
G[36457]={'179:37.67,72.76 N:35378'}
G[36458]={'179:32.52,75.49'}
G[36470]={'174:44.54,64.36 N:34872'}
G[36471]={'174:45.36,64.75 N:34872'}
G[36479]={'89:49.8,16.6 89:49.9,15.4 89:49.9,16'}
G[36487]={'66:73.38,73.05 N:36185'}
G[36500]={'76:42.22,76.09'}
G[36502]={'183:44.38,13.63'}
G[36594]={'76:49.56,28.76'}
G[36596]={'76:42.61,23.69'}
G[36597]={'189:0.00,0.00'}
G[36600]={'174:24.64,77.94'}
G[36606]={'179:28.13,50.04'}
G[36608]={'174:24.61,77.87'}
G[36616]={'179:42.58,35.96'}
G[36624]={'118:74.2,31.3'}
G[36642]={'118:53.5,90.7 118:74.5,31.1'}
G[36644]={'7:47.66,59.58'}
G[36648]={'88:60.30,51.69'}
G[36658]={'184:45.72,23.49'}
G[36666]={'183:45.37,14.82'}
G[36669]={'125:40.00,58.09'}
G[36670]={'125:70.05,31.44'}
G[36674]={'84:41.59,47.21'}
G[36676]={'76:67.08,20.53'}
G[36689]={'76:71.81,16.70 N:24848'}
G[36694]={'462:30.92,50.58 7:46.19,82.68>462'}
G[36728]={'76:14.34,65.02'}
G[36729]={'76:12.52,67.45 N:34693'}
G[36730]={'76:14.01,64.84'}
G[36743]={'179:26.44,46.91 N:35112','On top of tower'}
G[36744]={'76:29.38,57.61'}
G[36745]={'76:34.31,44.91'}
G[36746]={'76:29.11,57.94'}
G[36749]={'76:29.46,57.68'}
G[36752]={'76:29.52,66.84'}
G[36785]={'76:14.46,75.57 N:35817'}
G[36795]={'76:39.14,51.77'}
G[36799]={'84:27.37,24.15'}
G[36803]={'462:15.62,30.24 7:41.23,76.08>462'}
G[36894]={'76:34.53,44.68'}
G[36895]={'76:34.46,44.74'}
G[36903]={'76:14.47,65.71'}
G[36915]={'201:45.23,23.35'}
G[36918]={'76:10.55,69.85'}
G[36919]={'76:13.86,64.49 N:36596'}
G[36920]={'76:41.50,53.64'}
G[36921]={'76:41.39,53.93'}
G[36954]={'185:76.92,78.98 N:25462'}
G[36955]={'185:37,10.2 185:41.2,13.9 185:10.9,27.2 185:11.1,29.3 185:11.3,28.1 185:11.5,28.2 185:13,24.2 185:13.2,22.8 185:13.3,22.6 185:13.4,22.3 185:13.6,22.2 185:13.6,22.5 185:13.7,22 185:14.4,21.1 185:14.9,20.7 185:15.2,20.4 185:15.5,20.2 185:15.9,19.4 185:16.7,18.6 185:16.7,19.8 185:17.8,19.4 185:18.4,19.6 185:18.5,18.6 185:19,19.9 185:20.2,20.4 185:20.8,20.8 185:22,21.7 185:22.5,22.3 185:23.1,22.8 185:23.6,23.4 185:24.2,23.9 185:24.6,24 185:24.7,24.5 185:25.7,25.1 185:25.7,25.7 185:26.6,26.9 185:27.1,27.5 185:27.4,25.1 185:27.4,25.8 185:27.6,26 185:28,25.4 185:30.8,29 185:32.6,30.5 185:39.5,34.7 185:39.8,33.1 185:40.5,34.3 185:41.1,34.7 185:48.7,42.8 185:49.6,44.2 185:50.7,44.1 185:51,44.7 185:76,77.5 185:76.1,76.3 185:76.2,76.9 185:76.3,77 185:76.6,76.8 185:76.7,77.6 185:77.6,79.5 N:4968'}
G[36956]={'76:58.10,52.31'}
G[36958]={'76:43.76,77.32'}
G[36959]={'76:60.61,50.53'}
G[36990]={'184:40.2,79.8 184:40.3,79.4 184:40.4,78.9 184:40.4,79.8 184:40.9,79.7 184:40.9,80.5 184:41,79.7 184:41.1,78.9 184:41.3,79.1 184:41.5,79.8 184:47.1,41.4 184:47.1,42.6 184:47.2,42.9 184:47.3,42.1 184:47.4,41.9 184:47.5,41.4 184:47.5,41.9 184:47.6,42.7 184:47.7,42 184:47.8,42.7 184:48.5,42.3 184:48.6,42.4 184:48.6,43.1 184:48.8,42.6 184:49.4,43.5 184:49.8,43.5 184:50,43 184:50.4,43.1 184:50.6,42.3 184:50.6,43 184:50.6,43.6 184:50.8,42.4 184:51,42.7 184:51.6,43 184:51.7,42.7 184:52,42.3 184:52.2,41.5 184:52.4,41.2 184:52.5,42.6 184:52.7,41.2 184:52.8,42 184:52.8,42.3 184:53.1,41.3 184:53.7,41.7 184:54.1,39.9 184:54.3,40.8 184:54.3,41.3 184:54.4,41.7 184:54.6,39.9 184:54.7,40.1 184:54.7,40.7 184:54.9,40.6 N:10181'}
G[36993]={'184:40.3,79.8 184:40.4,79.8 184:40.9,79.9 184:40.9,80 184:40.9,80.5 184:40.9,80.7 184:41.1,79.1 184:41.2,79.4 184:41.5,79.7 184:41.5,79.8 184:42,79 184:46.8,42.5 184:47.1,42.5 184:47.2,43.7 184:47.3,41.8 184:47.4,42.4 184:47.6,42.3 184:47.6,42.5 184:47.7,42.6 184:48.1,42.4 184:49,42.6 184:49.4,43 184:50,43.1 184:50,43.5 184:50.1,43 184:50.5,43.1 184:50.6,43.5 184:51.2,43.2 184:51.4,43.6 184:51.8,42.9 184:52,43 184:52.1,42.2 184:52.1,42.3 184:52.5,42.3 184:52.6,42.8 184:52.8,41.2 184:53,42.1 184:53.1,41.1 184:53.6,41.7 184:54.2,41.4 184:54.3,40.2 184:54.4,40.4 184:54.4,41 184:54.6,39.9 184:54.7,41 184:54.8,39.7 184:54.8,40.9 N:4968'}
G[36999]={'76:59.34,50.74'}
G[37009]={'76:60.56,51.01'}
G[37024]={'7:49.37,17.33'}
G[37061]={'76:66.35,20.26'}
G[37064]={'76:66.54,19.60'}
G[37065]={'179:51.81,80.49 N:34850'}
G[37081]={'427:67.14,41.30 27:36.87,70.05>427'}
G[37087]={'427:61.86,22.54 27:35.79,66.02>427'}
G[37102]={'179:59.86,91.71 N:34571'}
G[37106]={'194:48.76,57.65'}
G[37113]={'427:69.84,44.01 27:37.41,70.58>427'}
G[37115]={'427:61.18,13.80 27:35.7,64.6>427'}
G[37120]={'186:42.4,22.6 186:42.4,22.7 186:42.5,22.4 186:42.9,22.8 186:42.9,22.9 N:28444'}
G[37121]={'427:61.27,14.53 27:35.7,64.8>427'}
G[37135]={'199:31.41,13.33'}
G[37136]={'199:37.13,13.90','In tower'}
G[37137]={'199:37.53,17.00'}
G[37138]={'199:39.48,20.34'}
G[37142]={'76:52.98,49.77'}
G[37153]={'199:37.65,16.64'}
G[37154]={'199:39.63,19.89'}
G[37172]={'HA 85:50.79,75.25'}
G[37179]={'194:47.70,57.75'}
G[37195]={'179:68.71,73.25 N:35077'}
G[37216]={'199:41.50,19.17'}
G[37221]={'185:39.1,13.9 185:40.3,71 185:41.3,72.2 185:41.4,73.4 185:41.6,72.3 185:42.1,72.9 185:42.2,74.5 185:42.4,73.9 185:43,74.4 185:43.1,75.5 185:43.4,75.4 185:43.6,75.4 185:43.7,75.4 185:44,75.7 185:44,76.6 185:44.8,76.2 185:44.8,76.3 185:45.1,76.8 185:45.2,76.9 185:45.5,77.9 N:4968'}
G[37223]={'185:38.9,70 185:40.4,70.8 185:41.5,73.1 185:41.9,74.2 185:42.1,74.7 185:42.3,74.4 185:42.5,73.3 185:42.5,74.2 185:42.7,74.2 185:42.7,75.1 185:43.1,74.8 185:43.2,75.7 185:43.5,75.3 185:43.7,75.2 185:44.3,76 185:44.3,76.1 185:44.4,76.6 185:44.8,76.4 185:44.9,76.4 185:44.9,76.5 185:45.1,77 185:45.2,77.5 185:45.5,77.2 185:45.6,77.3 185:45.6,77.5 185:45.7,78.1 N:10181'}
G[37515]={'199:44.33,33.29'}
G[37516]={'199:44.50,33.55'}
G[37527]={'122:44.4,45.4 122:44.4,45.5 122:44.5,45.4 122:44.5,45.5'}
G[37554]={'185:41.2,13.9 185:12.3,25 185:12.5,24.3 185:12.9,23.5 185:13.2,22.7 185:13.3,22.4 185:13.3,22.6 185:13.5,21.3 185:13.5,21.9 185:13.6,22 185:13.6,22.5 185:14.3,21.2 185:14.9,20 185:15,20.5 185:15.3,20.4 185:15.8,19.9 185:15.9,19.4 185:16.5,19.6 185:17.1,18.4 185:17.1,18.7 185:17.8,18.9 185:19.2,18.8 185:19.8,19.1 185:20.4,19.5 185:20.5,19.1 185:21,19.6 185:21.4,20.6 185:21.6,20.1 185:22.7,21.8 185:23.1,20.9 185:23.7,21.3 185:23.9,22.8 185:24.4,23.6 185:24.5,22.5 185:26.8,25.1 185:26.8,26.5 185:26.9,26.3 185:39.4,33.9 185:40,33.9 185:40.8,35.2 185:50.4,44.4 185:50.8,43.9 185:65.4,63.3 185:74.1,73.6 185:74.7,74.2 185:75.3,74.8 185:75.9,75.4 185:76.3,76.9 185:76.5,76 185:76.6,76.2 185:76.6,77.2 185:76.7,77.6 185:76.8,77.5 185:76.9,77.2 185:77.3,78.5 185:77.7,77.1 185:77.9,78.9 185:78.3,78.2 N:10181'}
G[37570]={'199:50.41,40.67'}
G[37582]={'183:41.1,9.4 183:41.1,9.7 183:41.2,10.1 183:41.4,8.4 183:41.4,9 183:41.5,8.5 183:41.5,10.2 183:41.6,8.6 183:41.8,9.6 183:44.4,12.2 183:63.9,90.2 183:63.9,90.7 183:64.2,90.4 183:64.3,90.5 184:40.9,80.5 184:41.1,79.6 184:41.2,79.1 184:41.3,79.1 184:41.4,80.2 184:41.5,80.2 184:41.6,80.1 184:43.9,25.8 184:44.1,25.1 184:44.2,23.2 184:44.2,23.8 184:44.2,26 184:44.2,26.7 184:44.3,25.2 184:44.5,23.1 184:44.5,23.7 184:44.5,25.4 184:44.5,25.5 184:44.8,24 184:45.2,19.9 184:45.8,19.6 184:46.4,19.4 184:47,19.1 184:47.4,19.1 184:47.6,18.9 184:48.2,18.4 184:48.3,18.4 184:48.4,18.8 184:48.6,18.4 184:48.6,18.7 184:54,39.5 184:54,40.2 184:54.1,40.5 184:54.6,39.9 184:54.9,39.5 185:29.9,57.2 185:30.1,57.7 185:30.2,57.8 185:30.3,57 185:30.4,58.5 185:30.4,58.7 185:30.7,57.1 185:30.8,57.1 185:30.8,57.9 185:31.2,57.7 185:31.3,58.8 185:33.1,61.9 185:39.5,73.6 185:39.8,74.5 185:40.1,72.5 185:40.2,72.2 185:40.2,73.6 185:40.4,73.2 185:40.5,72.1 185:40.5,72.5 185:40.7,72.8 185:40.8,71.8 185:41.3,74.4 185:41.5,72.7 185:41.7,72.9 185:42.2,73.5 185:42.3,73.8 185:42.4,75.3 185:42.5,73.8 185:42.6,74.2 185:42.7,75.2 185:43.3,75 185:43.4,75.5 185:43.9,75.3 185:44.1,75.7 185:44.3,76.2 185:44.3,76.7 185:44.9,76.3 185:44.9,76.9 185:45.2,77.9 185:45.3,76.8 185:45.5,77.3 185:45.6,77.4 185:46,79.1 185:46,79.3 185:46.6,79.3 185:46.9,79.9'}
G[37591]={'184:47,61.7 184:47.3,61.3 184:47.3,61.9 184:47.4,61.1 184:47.5,61.3 184:47.6,60.8 184:54.2,40.1 184:54.3,40 184:54.4,39.3 184:54.5,40.5 184:54.7,39.7 184:54.9,39.5 184:54.9,40.7 184:55.3,39.2 184:64.9,54.9 184:65,55.5 184:65.3,54.1 184:65.4,54.3 184:65.4,54.9 184:65.4,55.9 184:65.6,55 184:65.7,54.4 184:65.7,55 184:65.9,54.2 184:66,55.7 184:66.1,55.6'}
G[37592]={'184:40.9,80.5 184:41.4,79.4 184:46,63.5 184:46.4,62.7 184:46.9,61.5 184:47.3,61.7 184:47.4,61.1 184:47.4,61.3 184:47.5,60.2 184:47.5,61.1 184:47.8,61.5 184:47.8,61.9 184:48,61.1 184:54.2,40.2 184:54.3,40.1 184:54.4,40.6 184:54.5,40.5 184:54.5,40.6 184:54.7,39.9 184:54.7,40 184:65,54.9 184:65.1,54.4 184:65.1,55 184:65.1,55.5 184:65.2,54.3 184:65.6,55.1 184:65.7,54.1 184:65.8,54.2 184:65.8,55 184:65.9,55.8 184:66.1,55.5'}
G[37596]={'183:63.9,90.3 183:64.1,90.9 183:64.5,90.5 N:10181'}
G[37597]={'183:63.8,90.2 183:63.9,90.1 183:64.1,90.8 183:64.6,90.4 183:64.6,90.5 N:4968'}
G[37602]={'194:59.62,76.48'}
G[37660]={'199:43.72,85.51'}
G[37675]={'HA 89:42,52 103:73,56 87:33,66 84:62.41,75.37'}
G[37679]={'199:41.49,46.81'}
G[37717]={'199:41.49,46.59'}
G[37724]={'7:45,75.3'}
G[37737]={'7:45,75.4'}
G[37776]={'125:44.68,71.89 125:46.43,60.97'}
G[37779]={'183:40.8,11.2 183:40.9,10.9 183:41.4,10.1 183:41.4,10.4 183:41.5,10.7 183:41.6,10.2 183:41.8,9.9 183:41.8,10.7 183:44.3,14.5 183:63.8,90.3 183:63.9,90.3 183:64,90.6 183:64.4,90.7 183:64.5,90.4 183:64.7,90.7 184:40.4,79.4 184:40.4,80.3 184:40.9,80.1 184:40.9,80.5 184:41,79.2 184:41,79.3 184:41,80 184:41.5,79.8 184:41.5,80.3 184:43.6,25.4 184:44,26 184:44,26.6 184:44.2,25.8 184:44.3,20.8 184:44.3,23.6 184:44.4,25.4 184:44.5,25.6 184:44.5,26.7 184:44.7,20.4 184:44.8,23.2 184:44.9,20.5 184:45.9,20.1 184:47,19.1 184:47.9,18.9 184:48,19.3 184:48.1,18.4 184:48.3,18.4 184:48.6,18.7 184:53.9,39.7 184:54.7,39.8 184:54.8,39.4 185:29.8,57 185:30.1,57.8 185:30.1,58.6 185:30.3,57.2 185:30.3,58.1 185:30.4,58.6 185:30.5,57.1 185:30.6,57.4 185:30.9,57.8 185:31.3,58.3 185:31.3,58.6 185:31.3,59.1 185:33,60.3 185:33.4,60.9 185:39.5,73.1 185:39.5,73.5 185:39.5,73.6 185:40,72.2 185:40,72.8 185:40.7,71.7 185:40.7,73.5 185:40.8,72.9 185:41,73.6 185:41.2,72.8 185:41.3,72.4 185:41.5,72.4 185:41.5,73.6 185:41.6,73 185:41.8,73.1 185:42.8,74 185:43.2,75.6 185:43.4,74.7 185:43.5,75.4 185:43.5,75.5 185:44.4,76.6 185:44.7,77.2 185:45,77 185:45.1,77.6 185:45.2,78.4 185:45.9,78.3 185:45.9,79 185:46,79.6 185:46.4,79.2 185:47.1,79.5 185:47.2,80 185:47.3,81.6 185:47.7,80.7'}
G[37780]={'125:52.31,22.96 125:53.58,37.05 125:50.14,32.54 125:50.79,18.43'}
G[37783]={'179:70.88,39.83 N:35378'}
G[37803]={'179:70.76,39.94'}
G[37811]={'199:41.64,69.82'}
G[37812]={'199:45.15,85.43'}
G[37815]={'179:60.25,91.85 N:35378'}
G[37822]={'179:63.34,82.91'}
G[37834]={'199:45.09,85.32'}
G[37835]={'199:45.1,85.3'}
G[37837]={'199:41.64,69.81 N:37679'}
G[37847]={'199:44.51,88.09 N:3432'}
G[37873]={'179:69.31,72.97'}
G[37874]={'179:72.72,80.08 N:36132'}
G[37876]={'179:78.28,72.04 N:35112'}
G[37887]={'HA 84:62.52,74.96'}
G[37888]={'23:10.09,65.67'}
G[37908]={'199:42.61,70.22'}
G[37909]={'199:41.10,71.00'}
G[37910]={'199:41.64,69.42'}
G[37915]={'18:83.57,69.95'}
G[37951]={'463:42.82,53.45 1:62.46,84.45>463'}
G[37969]={'463:45.10,85.31 1:63.24,95.34>463'}	-- 891:45.58,85.12 moves about a bit
G[37987]={'463:45.72,85.01 1:45.75,85.01>463'}
G[38005]={'463:56.83,63.69 1:67.24,87.95>463'}
G[38037]={'463:52.55,53.70 1:65.78,84.54>463'}
G[38039]={'HA 89:45.41,57.75 N:37887'}
G[38040]={'HA 103:73.66,57.00 N:37887'}
G[38041]={'HA 87:33.57,65.59 N:37887'}
G[38042]={'HA 86:53.00,76.83 N:37887'}
G[38043]={'HA 110:64.43,66.51 N:37887'}
G[38044]={'HA 88:44.00,52.67 N:37887'}
G[38045]={'HA 998:66.55,38.60 N:37887'}
G[38066]={'HA 84:61.50,75.29'}
G[38113]={'185:36.48,66.89'}
G[38120]={'174:45.34,65.20 N:36379'}
G[38122]={'174:45.25,64.86 N:34673'}
G[38124]={'174:45.27,65.56 N:36077'}
G[38140]={'199:50.74,86.82','Inside fortress dressed as cheese'}
G[38143]={'179:70.66,39.71'}
G[38144]={'179:49.83,56.92 N:36132'}
G[38149]={'179:41.94,37.60 N:35077'}
G[38152]={'199:50.3,87.1 N:38140'}
G[38160]={'183:41.9,12.8 183:42.4,13.8 183:42.7,14.6 183:43.2,13.5 183:43.3,11.9 183:43.3,13.4 183:43.3,14.7 183:43.4,12.4 183:43.4,12.9 183:43.4,13.7 183:43.5,11.8 183:43.6,12.1 183:43.8,13.7 183:43.9,13.2 183:43.9,13.3 183:44,11.3 183:44,15.8 183:44.1,11.1 183:44.1,13.9 183:44.4,14.5 183:44.4,14.8 183:44.5,11.4 183:44.5,11.9 183:44.5,12.9 183:44.6,11.4 183:44.6,14.8 183:44.7,12.4 183:44.7,13.4 183:44.8,14.1 183:44.9,14.6 183:45,15.7 183:45.2,14.1 183:45.4,15.5 183:45.5,12.3 183:45.5,13.6 183:45.5,14.1 183:45.6,13.1 183:45.6,15.2 183:45.7,13 183:45.7,15.1 183:46.1,15.7 183:46.2,15.7 183:48.8,20 183:48.9,19.4 N:4968'}
G[38161]={'183:43.1,13.5 183:43.3,12.4 183:43.4,10 183:43.4,12.3 183:43.4,12.5 183:43.4,12.8 183:43.4,13.6 183:43.4,14.7 183:43.5,13.2 183:43.7,13.4 183:43.7,15.7 183:43.8,11.2 183:43.8,14.2 183:44,15.5 183:44.1,12.1 183:44.1,13.6 183:44.2,11.3 183:44.2,11.9 183:44.2,14.5 183:44.4,14.5 183:44.5,11.4 183:44.5,12.2 183:44.5,12.4 183:44.7,12.5 183:44.8,15.7 183:45,14.7 183:45.1,13 183:45.2,14 183:45.3,14.7 183:45.3,15.5 183:45.4,13.5 183:45.5,12.7 183:45.5,14.9 183:45.5,15.5 183:45.6,14.1 183:45.6,14.4 183:45.7,12.4 183:45.7,13.4 183:45.8,14.9 183:45.9,15.5 183:46.5,15.3 N:10181'}
G[38188]={'184:39.2,15.6 184:39.2,16.5 184:39.3,15.4 184:39.3,15.7 184:39.4,15.4 184:39.4,16.5 184:39.5,15.2 184:39.7,16.2 184:39.7,16.3 184:39.8,15.3 184:40.1,16.8 184:40.1,16.9 184:40.4,17.6 184:40.5,17.3 184:40.5,17.4 184:40.8,17.8 184:41,18.1 184:41.3,18.5 184:41.4,18.7 184:41.6,18.3 184:41.6,18.4 184:41.7,19 184:41.7,19.6 184:41.9,19.3 184:42.3,19.9 184:42.5,19.4 184:42.9,20.3 184:43,19.5 184:43.2,20.9 184:43.4,20.5 184:43.5,20.5 184:43.8,21.2 184:44.2,19.8 184:44.2,21.5 184:44.4,20.3 184:44.8,20.2 184:44.9,21.7 184:45,20.3 184:45.1,20.6 184:45.2,20.7 184:45.2,21.5 184:45.6,20.5 184:45.9,19.4 184:46,19.4 184:46,20.2 184:46.4,20 184:46.6,20.5 184:46.7,20.7 184:47.2,19.4 184:47.2,19.6 184:47.4,19.3 184:47.5,19.5 184:47.8,19.2 184:48.2,18.4 184:48.2,18.9 184:48.4,18.4 184:48.5,19.1 184:48.6,18.9 184:48.7,18.3 N:4968'}
G[38189]={'184:39.1,15.5 184:39.2,15.6 184:39.5,16.4 184:39.7,16.2 184:40.1,16.7 184:40.5,17.3 184:40.5,17.6 184:41.2,18.4 184:41.5,18.6 184:41.9,19.5 184:42,19 184:43.3,20.2 184:43.3,20.3 184:43.4,20.5 184:43.6,19.9 184:43.9,20.1 184:44.1,20.8 184:44.5,20.5 184:45.1,20.2 184:45.1,20.4 184:45.7,19.9 184:45.8,19.8 184:46.9,19.5 184:47.2,19.3 184:47.3,19.4 184:47.3,19.5 184:47.5,19.3 184:47.5,19.5 184:47.5,19.6 184:48.3,18.4 184:48.4,19 184:48.9,18.6 N:10181'}
G[38237]={'78:30.62,51.15'}
G[38242]={'463:50.07,52.74 1:64.94,84.21>463'}
G[38243]={'463:58.06,54.04 1:67.67,84.66>463'}
G[38244]={'463:52.88,49.92 1:65.90,83.25>463'}
G[38245]={'463:58.05,49.25 1:67.66,83.02>463'}
G[38246]={'463:59.69,52.06 1:68.22,83.68>463'}
G[38247]={'463:56.39,50.09 1:67.10,83.31>463'}
G[38255]={'Near78 N:38237'}
G[38263]={'78:76.43,48.34'}
G[38269]={'78:55.72,60.60'}
G[38270]={'78:55.05,60.56'}
G[38274]={'78:71.01,76.60'} -- 201:71.00,76.62 201:70.08,77.47 201:70.47,76.78 201:70.90,75.65
G[38275]={'78:43.2,41.6 78:43.3,41'}
G[38276]={'78:43.2,41.7 78:43.3,41'}
G[38277]={'78:43.2,41.7 78:43.3,41'}
G[38293]={'HA 87:35.35,68.98 89:45.05,56.42 103:76.00,57.74'}
G[38294]={'HK 125:52.42,66.41'}
G[38295]={'HA 110:64.42,70.31 998:64.30,37.55 88:44.22,55.86'}
G[38314]={'199:50.30,40.40'}
G[38316]={'186:39.4,21.6 186:40.1,21.4 186:40.1,21.5'}
G[38323]={'199:49.9,49.6'}
G[38325]={'HA 84:60.61,76.36','In inn, upstairs'}
G[38328]={'HA 86:57.59,60.82'}
G[38343]={'Near78 N:38237'}
G[38378]={'199:29.8,9'}
G[38379]={'199:38.79,11.39'}
G[38380]={'199:35,9.5'}
G[38381]={'174:52.20,73.23'}
G[38383]={'199:39.06,11.44'}
G[38387]={'174:45.17,64.90 N:34668'}
G[38432]={'174:52.20,73.14 N:34874'}
G[38440]={'463:58.95,66.87'}
G[38441]={'174:54.16,17.20'}
G[38442]={'463:58.90,23.09 1:58.91.23.08>463'}
G[38502]={'78:83.50,46.00'}
G[38504]={'78:53.83,62.50'}
G[38517]={'174:53.72,34.93 N:34693'}
G[38534]={'71:51.24,29.96 N:34874'}
G[38535]={'71:51.21,29.92'}
G[38539]={'202:32.38,57.01 N:35112'}
G[38578]={'71:40.25,77.17'}
G[38606]={'186:38.4,20.1 186:38.4,20.7 186:39,20.1 186:39,20.5 186:39,21 186:39.1,20.4 186:39.4,21.5 186:39.7,20.4 186:39.7,20.9 N:4968'}
G[38607]={'186:39,20.7 186:39.3,20.6 186:39.4,20.2 186:39.4,20.3 186:39.4,21.5 186:39.9,20.8'}
G[38608]={'186:39,18.6'}
G[38609]={'186:38.4,20 N:10181'}
G[38611]={'202:38.60,60.22 N:35378'}
G[38619]={'199:69.26,49.09'}
G[38620]={'199:67,46.6'}
G[38621]={'199:64.9,46.1'}
G[38622]={'199:74.00,47.50'}
G[38623]={'199:71,50'}
G[38647]={'174:56.56,71.95'}
G[38703]={'71:71.86,45.42 N:34874'}
G[38704]={'71:72.20,45.22 N:38535'}
G[38706]={'71:55.65,60.86'}
G[38738]={'174:51.79,47.10 N:37106'}
G[38801]={'199:66.97,46.59'}
G[38804]={'199:66.9,46.7'}
G[38849]={'71:44.59,52.66 N:34874'}
G[38871]={'199:56.1,42.7'}
G[38873]={'199:56.2,42.6'}
G[38876]={'199:56.2,42.7'}
G[38878]={'199:61.9,42.1'}
G[38880]={'71:41.86,57.47'}
G[38911]={'465:49.20,56.32 18:31.45,65.60>465'}
G[38912]={'199:56.2,42.7'}
G[38917]={'198:48.43,18.97'}
G[38922]={'71:33.27,77.02'}
G[38925]={'18:44.74,53.65'}
G[38927]={'71:42.30,23.84'}
G[38928]={'174:72.86,57.04 N:34668'}
G[38935]={'174:36.79,43.13 N:4949'}
G[38966]={'463:61.55,65.85 1:61.58,65.88>463'}
G[38977]={'18:61.64,34.56'}
G[38978]={'18:61.60,34.39'}
G[38986]={'199:50,49.5'}
G[39003]={'199:49.8,50.4 199:49.8,50.5'}
G[39007]={'463:60.53,62.88 1:68.51,87.67>463'}
G[39034]={'71:51.79,28.06'}
G[39059]={'71:50.02,82.91 N:38535'}
G[39065]={'174:36.27,43.36 N:35875'}
G[39066]={'174:33.79,38.79 N:35893'}
G[39083]={'199:49.1,66.9'}
G[39084]={'199:49.4,67.5 199:49.5,67.5'}
G[39085]={'199:49.2,67.8'}
G[39116]={'998:49.49,29.65'}
G[39118]={'199:43.5,78.3'}
G[39144]={'70:35.49,30.08'}
G[39154]={'199:43.46,78.23'}
G[39155]={'199:47.2,88.5'}
G[39175]={'78:44.11,40.28'}
G[39178]={'71:52.25,28.07'}
G[39188]={'199:49.3,86.7 N:39155'}
G[39199]={'Near174 N:36077'}
G[39206]={'461:42.11,69.51 1:42.51,69.04>461'}
G[39210]={'199:38.93,10.88'}
G[39211]={'199:49.20,67.80'}
G[39212]={'199:66.38,47.13'}
G[39214]={'461:43.39,70.65 1:42.84,69.34>461'}
G[39218]={'199:49.4,86.9'}
G[39220]={'199:49.6,87.1'}
G[39226]={'205:56.02,13.69'}
G[39256]={'65:71.8,45.4 65:71.8,45.6'}
G[39270]={'1:57.91,45.13'}
G[39322]={'199:68.6,49'}
G[39323]={'1:49.59,40.17','On top of tower'}
G[39324]={'1:35.85,41.37'}
G[39325]={'1:40.49,35.36'}
G[39326]={'1:42.70,49.91'}
G[39341]={'174:56.30,27.32'}
G[39376]={'174:51.37,13.12'}
G[39377]={'69:41.4,15.4 69:41.4,15.5'}
G[39378]={'297:0.00,0.00'}
G[39379]={'1:45.00,14.78'}
G[39380]={'1:44.90,14.82'}
G[39406]={'198:90.15,56.38'}
G[39407]={'69:81.54,42.44'}
G[39413]={'198:89.58,59.09'}
G[39423]={'1:53.10,43.14'}
G[39427]={'198:35.75,19.67'}
G[39429]={'198:35.69,19.43'}
G[39432]={'198:28.4,30 198:28.5,29.9 198:30.1,31.7'}
G[39433]={'198:30.12,31.29'}
G[39434]={'198:28.17,29.88'}
G[39435]={'198:28.62,30.20 198:28.29,29.98'}
G[39442]={'198:76.94,62.04'}
G[39451]={'198:77.05,62.15'}
G[39509]={'186:40.1,21.4 186:40.1,21.5 186:40.1,21.7 186:40.7,21.1 186:40.7,21.3'}
G[39587]={'297:0.00,0.00'}
G[39590]={'1:58.82,23.16'}
G[39604]={'1:56.31,20.27'}
G[39605]={'86:48.11,70.48 N:25237'}
G[39609]={'1:57.65,9.77'}
G[39621]={'198:71.92,58.07'}
G[39622]={''}
G[39627]={'198:32.35,37.16'}
G[39638]={'205:42,68'}
G[39640]={'198:27.25,40.80',"Inside cave Gar'gol's Hovel"}
G[39642]={'198:27.21,35.19'}
G[39643]={'198:27.17,35.22'}
G[39646]={'198:25.80,41.64'}
G[39653]={'69:56.88,54.96'}
G[39656]={'69:51.9,48.1'}
G[39665]={'283:48.01,72.21'}
G[39667]={'201:53.44,43.02'}
G[39679]={'283:0.00,0.00'}
G[39697]={'199:49.22,82.33'}
G[39700]={'283:0.00,0.00'}
G[39705]={'283:0.00,0.00'}
G[39723]={'69:32.61,45.66'}
G[39725]={'69:77.23,56.48'}
G[39731]={'297:0.00,0.00'}
G[39732]={'297:0.00,0.00'}
G[39738]={'198:25.83,41.68'}
G[39840]={'69:51.9,46.6'}
G[39847]={'69:74.6,42.9'}
G[39857]={'198:47.73,35.51 N:33091'}
G[39858]={'198:27.11,62.65 N:5769'}
G[39865]={'80:45.47,44.84'}
G[39869]={'198:47.65,35.51'}
G[39875]={'205:49.24,42.57'}
G[39876]={'205:49.42,42.71 205:49.58,42.13'}
G[39877]={'205:55.54,12.53'}
G[39878]={'205:49.13,41.96'}
G[39881]={'205:49.02,57.02 205:49.41,57.46 205:49.45,57.50 205:49.56,57.41 205:49.46,57.59'}
G[39882]={'205:41.29,34.23'}
G[39883]={'201:57.12,28.78 N:39667'}
G[39884]={'201:57.34,28.90'}
G[39887]={'201:44.73,22.58'}
G[39893]={'69:74.6,42.9'}
G[39894]={'69:52.2,48.1'}
G[39895]={'64:11.13,11.22'}
G[39896]={'69:55.6,57'}
G[39908]={'297:56.16,44.02 N:28070'}
G[39918]={'201:49,42'}
G[39925]={'198:64.01,22.65'}
G[39927]={'198:18.98,40.94'}
G[39928]={'198:19.03,37.01'}
G[39930]={'198:19.22,37.89'}
G[39932]={'198:13.65,32.79'}
G[39933]={'198:22.26,44.92'}
G[39946]={'69:86.07,45.28'}
G[39963]={'64:10.55,8.53'}
G[39992]={'69:88.46,44.44'}
G[40017]={'283:0.00,0.00'}
G[40027]={'64:75.90,74.61'}
G[40028]={'64:75.93,74.69'}
G[40032]={'69:50.69,17.15'}
G[40035]={'69:51.15,17.84'}
G[40052]={'69:56.96,55.38'}
G[40078]={'69:57.08,53.79'}
G[40082]={'64:90.07,53.01'}
G[40093]={'Near198'}
G[40096]={'198:44.50,18.86'}
G[40105]={'201:46.33,46.92 N:36915'}
G[40109]={'71:40.12,76.97'}
G[40129]={'69:65.88,62.86'}
G[40131]={'69:65.94,62.83'}
G[40132]={'69:57.24,54.98'}
G[40139]={'198:56.76,18.83','In Hyjal Barrow Dens'}
G[40172]={'198:22.21,44.91 N:81280'}
G[40178]={'198:52.13,17.42 N:38917'}
G[40221]={'205:64.07,42.29 N:39877'}
G[40224]={'69:53.2,31.8 N:5296'}
G[40226]={'69:45.34,41.26'}
G[40227]={'205:41.13,34.26'}
G[40276]={'201:52,40'}
G[40278]={'198:64.06,22.49'}
G[40289]={'198:62.05,24.92'}
G[40331]={'198:27.06,63.01'}
G[40341]={'198:24.66,55.68'}
G[40344]={'70:41.87,73.88'}
G[40345]={'70:41.82,73.92'}
G[40358]={'70:42.82,72.43'}
G[40367]={'69:77.31,56.79'}
G[40369]={'69:77.2,56.5'}
G[40398]={'204:72.89,37.35'}	-- this technically could be Near
G[40429]={'200:68.1,55.2 200:68.3,54.3 200:68.3,54.5 200:68.3,55.7 200:68.3,56.2 200:68.4,54.1 200:68.4,54.2 200:68.4,55.1 200:68.4,55.4 200:68.4,55.7 200:68.4,55.8 200:68.4,56.6 200:68.5,56.7 200:68.6,54.1 200:68.6,55.3 200:68.6,56.5 200:68.6,56.7 200:68.7,53.7 200:68.7,57 200:68.8,54.4 200:68.8,55.8 200:68.9,55 200:68.9,55.6 200:69,55.6 200:69.1,54.2 200:69.1,54.9 200:69.1,55.7 200:69.2,55 200:69.3,53.4 200:69.5,54.2 200:69.5,55.1 200:69.6,55 200:69.6,55.7 200:69.6,55.8 200:70,55.3 200:70.2,55.3 200:70.2,55.6 200:70.5,55 200:70.6,54.9 200:70.6,55.2 200:70.6,56.3 200:70.7,54.1 200:70.7,55.1 200:71,55.6 200:71.5,54.9 200:72,55.1 200:72.6,55.1 200:74,54.6 200:74.1,53.4 200:74.2,54'}
G[40449]={'64:79.53,74.97'}
G[40475]={'64:76.49,73.63'}
G[40484]={'293:0.00,0.00'}
G[40487]={'64:77.19,74.50'}
G[40510]={'205:67.2,49.6'}
G[40552]={'89:36.61,47.85'}
G[40553]={'57:55.47,50.42'}
G[40554]={'64:77.98,73.32'}
G[40556]={'64:78.10,73.70'}
G[40578]={'198:37.22,56.18'}
G[40580]={'71:42.49,24.27'}
G[40589]={'71:52.56,29.05'}
G[40591]={'64:78.07,73.10'}
G[40595]={'64:78.23,73.64'}
G[40619]={'198:95.35,51.32'}
G[40639]={'205:48.99,49.20'}
G[40640]={'205:39.42,58.97'}
G[40641]={'205:48.99,49.12'}
G[40642]={'205:49.16,56.99 N:39887'}
G[40643]={'205:49.18,56.95'}
G[40644]={'205:49.69,57.15'}
G[40645]={'205:56.98,80.55'}
G[40690]={'201:45.02,23.52 N:39887'}
G[40707]={''}
G[40712]={'219:56.75,89.18 71:39.22,21.34>219'}
G[40720]={'198:37.26,56.17'}
G[40726]={'64:78.12,73.09'}
G[40727]={'64:78.26,73.60'}
G[40737]={'201:44.4,24.8 N:39887'}
G[40768]={'64:79.14,71.94'}
G[40772]={'198:72.22,74.69 N:40619'}
G[40773]={'198:71.92,74.09'}
G[40788]={'323:0.00,0.00'}
G[40809]={'7:47.44,58.64'}
G[40816]={'198:72.23,73.94'}
G[40817]={'283:0.00,0.00'}
G[40825]={'N:36915'}
G[40827]={'71:40.05,77.54'}
G[40833]={'198:63.25,21.52'}
G[40834]={'198:26.25,41.91'}
G[40837]={'198:26.31,41.95'}
G[40851]={'205:49.52,41.22 N:43287'}
G[40852]={'201:56.12,31.13 N:43287'}
G[40855]={'201:45.2,19.7 K:27729'}
G[40866]={'204:56.90,75.53 N:43287'}
G[40867]={'205:48.55,57.43 N:43287'}
G[40871]={'205:51.41,62.43 N:43287'}
G[40879]={'65:72.5,61.4 65:72.5,61.5'}
G[40881]={'65:70.8,62.9'}
G[40885]={'64:91.63,78.55'}
G[40888]={'64:91.68,79.33'}
G[40894]={'63:35.3,71.2'}
G[40895]={'63:35.4,71.2'}
G[40896]={'65:59.5,56.9'}
G[40897]={'65:59.46,56.97'}
G[40898]={'65:58.97,56.36'}
G[40899]={'65:58.7,56'}
G[40900]={'65:58.7,56'}
G[40901]={'65:73.29,56.61'}
G[40902]={'65:66.23,62.93'}
G[40903]={'65:65.76,63.31'}
G[40905]={'65:72.2,62'}
G[40907]={'65:66.06,64.23'}
G[40908]={'65:58.5,55.3'}
G[40913]={'69:76.97,56.63'}
G[40916]={'205:39.1,78.6 205:39.7,54 205:51.2,63'}
G[40917]={'205:39.1,78.6 205:39.6,54 205:51.2,63'}
G[40918]={'205:39.5,54.7 205:51.7,62.5 205:53.9,67.1'}
G[40919]={'205:29.5,78.9 205:39.1,78.6 205:40.6,75.1 205:51.6,62.7'}
G[40920]={'205:39.6,53.8 205:51.3,62.4 205:51.3,62.5'}
G[40921]={'205:50.3,79'}
G[40926]={'65:74.44,47.66 N:35893'}
G[40950]={'27:53.71,52.19'}
G[40951]={'27:53.70,52.10'}
G[40966]={'69:50.21,16.72'}
G[40973]={'65:72.5,61.4 65:72.5,61.5'}
G[40978]={'205:40.56,75.28'}
G[40983]={'201:57.30,29.29 N:26604'}
G[40987]={'201:54,50'}
G[40997]={'198:43.54,45.88','On top floor'}
G[41003]={'198:44.1,46'}
G[41005]={'198:44.44,46.23'}
G[41006]={'198:42.18,45.46'}
G[41017]={'201:53.8,52.6'}
G[41023]={'65:66.13,63.70'}
G[41049]={'205:36.43,78.68 N:40510'}
G[41050]={'205:38.99,58.60'}
G[41054]={'65:58.8,56'}
G[41058]={'64:91.68,78.81 64:91.67,79.17'} -- first for Alliance, second for Horde
G[41060]={'64:96.83,72.47'}
G[41068]={'198:40.35,44.32'}
G[41071]={'65:66.2,54.6'}
G[41074]={'56:49.89,79.24'}
G[41075]={'56:49.94,79.16'}
G[41086]={'56:57.50,71.76'}
G[41124]={'17:40.4,11.7 17:40.5,11.7'}
G[41125]={'17:42.6,13.9'}
G[41128]={'56:57.84,71.50'}
G[41129]={'56:57.47,71.43'}
G[41133]={'17:59.4,3.2 17:59.5,3.4 17:59.5,3.5'}
G[41134]={'17:53.1,80.3 17:62.2,1.4 17:62.2,1.5'}
G[41140]={'1:53.09,43.58'}
G[41159]={'17:54.3,50 17:54.4,50.5'}
G[41167]={'56:47.58,65.48'}
G[41183]={'201:51.6,52'}
G[41184]={'64:88.57,54.86'}
G[41190]={'64:91.39,57.78'}
G[41204]={'64:91.31,53.84'}
G[41205]={'64:86.75,51.58'}
G[41214]={'71:55.88,60.60'}
G[41215]={'71:33.30,77.35'}
G[41227]={'205:37,83'}
G[41229]={'65:71,79.7'}
G[41233]={'65:48.4,51.8'}
G[41238]={'56:57.46,71.63'}
G[41239]={'107:60.4,24 107:60.5,24 N:4949'}
G[41240]={'65:48.64,51.52'}
G[41248]={'201:46.05,46.85'}
G[41252]={'201:46.62,46.73'}
G[41263]={'107:60.4,23.9 107:60.5,23.8'}
G[41265]={'17:73.18,47.44'}
G[41276]={'65:72.1,76'}
G[41277]={'65:72.1,76'}
G[41278]={'65:70.9,79.7 N:17246'}
G[41282]={'65:72.1,76'}
G[41297]={'56:11.09,57.78'}
G[41298]={'27:62.51,53.70'}
G[41307]={'56:15.23,29.38'}
G[41308]={'198:44.34,47.98'}
G[41321]={'56:56.87,71.11'}
G[41322]={'56:56.32,41.85'}
G[41323]={'56:38.6,39'}
G[41324]={'201:63.98,59.80'}
G[41325]={'56:49.90,18.56'}
G[41332]={'48:81.88,64.08'}
G[41340]={'201:63.98,59.80 N:41324'}
G[41341]={'201:63.86,59.94 N:36915'}
G[41344]={'201:64.21,59.89 N:41252'}
G[41347]={'201:63.89,59.39 N:41248'}
G[41350]={'65:72.7,81.1'}
G[41354]={'17:71.05,60.14'}
G[41363]={'27:56.83,47.10'}
G[41381]={'198:27.40,55.63'}
G[41383]={'69:46.77,45.35'}
G[41392]={'64:46.40,57.89'}
G[41402]={'17:60.63,62.96 17:61.59,63.11 17:62.93,64.23'}
G[41411]={'56:38.93,39.35'}
G[41412]={'56:38.63,39.51'}
G[41413]={'56:38.8,39.7'}
G[41415]={'56:26.93,26.08'}
G[41421]={'64:46.81,55.95'}
G[41426]={'56:13.68,38.18'}
G[41428]={'56:14.40,23.92'}
G[41433]={'56:26.77,26.73'}
G[41434]={'65:53.5,42.5 65:53.6,42.4'}
G[41435]={'56:26.82,25.88'}
G[41441]={'65:48.4,51.9 65:48.5,51.9'}
G[41444]={'64:46.8,56.1'}
G[41446]={'64:46.36,57.79'}
G[41456]={'205:33.11,77.89'}
G[41457]={'205:57.16,85.20'}
G[41476]={'205:46.36,78.58'}
G[41480]={'198:19.54,37.78 N:5769'}
G[41482]={'65:39.97,33.55'}
G[41486]={'65:39.6,30.8'}
G[41487]={'65:33.1,59.6'}
G[41488]={'65:39.6,30.8'}
G[41492]={'198:57.12,55.95'}
G[41497]={'198:56.84,56.02'}
G[41498]={'198:64.27,53.60'}
G[41503]={'56:56.39,40.47'}
G[41504]={'198:41.88,60.79 N:40341'}
G[41507]={'198:42.24,60.57'}
G[41530]={'201:60,80.8 201:60,81.5 201:60.1,80.4 201:60.5,80.9'}
G[41531]={'205:51.63,52.22 N:39875'}
G[41535]={'205:56.93,80.49 N:40639'}
G[41540]={'205:62.67,49.88 N:39887'}
G[41541]={'205:62.71,49.94 N:40643'}
G[41578]={'27:70.41,48.92'}
G[41580]={'69:57.08,53.95'}
G[41598]={'204:42.76,37.95 N:39887'}
G[41600]={'204:42.69,37.91 N:36915'}
G[41612]={'56:56.36,39.83'}
G[41615]={'56:56.42,39.92'}
G[41618]={'201:38.75,31.71 N:36915'}
G[41621]={'1:55.89,12.32'}
G[41636]={'204:42.7,37.8 N:40917'}
G[41638]={'65:32.3,60.5 65:32.4,60 65:32.7,61 65:33.1,59.6'}
G[41639]={'204:42.73,37.92 N:40919'}
G[41640]={'204:52.60,27.82 N:39881'}
G[41652]={'204:31.6,59.2'}
G[41657]={'204:30,59'}
G[41662]={'204:54.44,72.91'}
G[41663]={'204:51.4,61.4 204:51.4,61.5 204:51.5,61.4 204:51.5,61.5'}
G[41664]={'65:33.1,59.6'}
G[41665]={'204:55.61,72.99 N:40645'}
G[41666]={'204:55.50,72.90 N:40639'}
G[41667]={'204:55.46,72.97'}
G[41668]={'204:51.5,60.8 N:40921'}
G[41669]={'204:51.4,60.9 204:51.5,60.9 N:40918'}
G[41670]={'204:51.4,60.9 204:51.5,60.9'}
G[41678]={'63:49.87,65.76'}
G[41711]={'201:39,32 N:40917'}
G[41750]={'201:38.9,31.7 201:39.5,31.3 N:40917'}
G[41769]={'201:39.4,30.7 201:39.5,30.7 201:39.6,30.3 N:40917'}
G[41770]={'205:50.3,79 N:40918'}
G[41786]={'27:82.86,48.40'}
G[41802]={'205:62.60,49.56 205:62.69,50.53 N:39881'}
G[41804]={'27:82.64,48.29'}
G[41810]={'205:60.2,63.6 N:40917'}
G[41811]={'205:60.2,63.7 N:40916'}
G[41813]={'205:60.2,63.6 205:60.3,63.4 205:60.5,63.4 205:60.5,63.5 N:40919'}
G[41853]={'27:78.25,20.51'}
G[41861]={'198:62.14,21.59'}
G[41863]={'201:63.9,59.9'}
G[41885]={'201:63.9,59.8 N:41863'}
G[41908]={'204:42.9,51'}
G[41910]={'204:47.36,49.76'}
G[41925]={'204:46,60'}
G[41926]={'204:46,60'}
G[41937]={'65:62,67.8'}
G[41944]={'14:12.94,36.16'}
G[41949]={'14:13.36,35.95'}
G[41966]={'14:13.35,34.18'}
G[41983]={'14:13.06,69.23'}
G[41990]={'65:67.10,64.55','In cave'}
G[41991]={'65:67.14,64.50','In cave'}
G[41992]={'65:67.17,64.46','In cave'}
G[42023]={'65:71.1,91.2'}
G[42028]={'65:65.86,64.14'}
G[42033]={'65:52.95,39.14'}
G[42039]={'65:45.04,32.76'}
G[42047]={'65:45.02,32.82'}
G[42050]={'65:45.12,32.77'}
G[42074]={'205:46.22,79.56 N:40978'}
G[42076]={'205:29.02,78.51 N:40640'}
G[42077]={'205:33.13,75.87 N:40640'}
G[42088]={'14:12.82,34.08'}
G[42091]={'65:39.69,46.41','Top of tree'}
G[42106]={'65:45.60,34.15 N:41023'}
G[42114]={'204:55,46 K:26124'}
G[42115]={'204:57,74 K:26105'}
G[42129]={'87:39.74,57.25'} -- 341:39.80,57.30
G[42130]={'14:67.72,34.80'}
G[42140]={'56:13.93,34.96'}
G[42160]={'56:49.44,17.21'}
G[42170]={'27:87.68,50.20'}
G[42197]={'204:38.75,44.82'}
G[42224]={'27:38.9,33.4 27:39.2,33.9 27:39.5,34.2 27:39.8,32.1 27:39.9,31.2 27:39.9,33.3 27:40.6,33 27:40.9,31.7 27:41.2,30.6'}
G[42256]={'37:81.85,66.05'}
G[42262]={'17:60.20,13.39'}
G[42264]={'17:60.47,13.82'}
G[42288]={'84:50.56,71.87'}
G[42298]={'17:62.25,26.32'}
G[42299]={'17:55.12,49.58'}
G[42308]={'52:60.05,19.28'}
G[42317]={'469:38.71,32.82 27:33.63,36.45>469'}
G[42323]={'27:33.89,34.78>469 469:39.41,28.39'}
G[42324]={'27:34.28,37.51>469 469:40.68,35.73'}
G[42331]={'27:34.53,35.06>469 469:41.09,29.14'}
G[42333]={'324:54.06,38.61'}
G[42334]={'17:34.68,67.80'}
G[42342]={'52:40.52,47.96'}
G[42344]={'17:49.8,71.5'}
G[42348]={'17:47.2,69.1'}
G[42349]={'17:46.36,87.18'}
G[42352]={'17:43.9,87.8 17:44,87.1 17:44.4,86.1 17:44.9,86.2 17:45.1,86.5 17:45.4,88.1 17:45.8,88.3 17:46,88.5 17:46.1,86.5 17:46.2,85.1 17:46.4,86.2 17:46.5,85.4 17:46.5,85.6 17:47.2,88.2 17:47.2,89 17:47.3,87.2 17:47.5,88.6 17:47.6,88.4'}
G[42353]={'469:48.74,52.88 27:37.43,44.04>469'}
G[42366]={'469:38.03,33.56 27:33.38,36.74>469 N:38535'}
G[42396]={'469:39.50,38.39 27:33.93,38.56>469'}
G[42405]={'52:49.65,19.39'}
G[42406]={'52:49.8,18.8'}
G[42410]={'203:64.5,68.7 N:40917'}
G[42411]={'203:69.61,75.34 N:39887'}
G[42425]={'52:42.10,64.13'}
G[42426]={'52:42,63.4'}
G[42443]={29611,''}
G[42464]={'26:77.30,79.97'}
G[42465]={'207:56.34,12.15 207:56.29,13.31 207:56.13,12.91'}
G[42466]={'207:39.94,19.36'}
G[42467]={'207:56.51,42.65'}
G[42469]={'207:34.18,34.29'}
G[42472]={'207:72.22,53.99'}
G[42489]={'469:38.39,33.49 27:33.51,36.71>469'}
G[42491]={'469:38.21,33.67 27:33.44,36.78>469'}
G[42497]={'52:49.5,19.2'}
G[42498]={'52:49.58,19.60'}
G[42506]={'86:56.53,62.49'}
G[42518]={'26:71.45,50.65'}
G[42536]={'26:72,51'}
G[42553]={'469:40.61,28.08 27:34.36,34.66>469'}
G[42555]={'26:73,50'}
G[42558]={'52:49.74,19.50 N:42308'}
G[42573]={'207:49.49,53.35'}
G[42574]={'207:46.53,57.29'}
G[42575]={'52:56.97,47.10'}
G[42600]={3057,''}
G[42609]={'26:73.2,53.6'}
G[42611]={'469:39.23,26.56 27:33.83,34.09>469'}
G[42612]={'26:78.04,78.11'}
G[42613]={'26:78.17,81.31','Upstairs'}
G[42614]={'207:64.13,36.88 N:42466'}
G[42618]={'463:50.03,49.94 1:64.92,83.25>463'}
G[42622]={'26:67.64,66.60'}
G[42624]={'26:67.78,66.29'}
G[42630]={'469:38.20,40.21 27:33.4,39.2>469'}
G[42637]={'86:47.95,71.03 N:25272'}
G[42640]={'76:60.19,50.43'}
G[42641]={'76:60.15,50.39'}
G[42642]={'26:67.81,66.51'}
G[42643]={'76:54.54,51.17'}
G[42651]={'52:42.98,65.01 N:23975'}
G[42672]={'76:26.16,78.84'}
G[42677]={'52:42.4,69.4'}
G[42684]={'207:62.38,47.73 207:62.17,46.64 207:61.87,45.04 207:61.53,44.00 207:62.05,37.59 207:63.95,45.86 207:64.33,49.31 207:65.05,52.76 207:62.46,53.13','Flying around on a gunship'}
G[42708]={'469:37.28,65.21 27:33.09,48.69>469'}
G[42710]={'94:69.21,52.11'}
G[42730]={'207:46.1,45.7'}
G[42731]={'207:46.16,45.74'}
G[42736]={'50:33.72,37.16'}
G[42750]={'52:56.24,47.69 N:234'}
G[42752]={'998:70.4,47 194:69.9,79.7 194:70.4,79.1 205:51.1,63.2 204:42.6,37.7 N:878'}
G[42790]={'50:47.20,10.65'}
G[42811]={'50:63.25,38.77','Upstairs'}
G[42812]={'50:63.46,39.04'}
G[42813]={'50:63.29,39.82'}
G[42814]={'50:63.43,41.07'}
G[42896]={'26:31.82,58.55'}
G[42898]={'26:31.87,58.39'}
G[42899]={'207:56.52,41.05'}
G[42928]={'87:39.21,56.06 N:38607'}
G[42933]={'27:49.91,44.98'}
G[42936]={'89:43.91,76.16'}
G[42968]={'57:55.23,89.19 N:36132'}
G[42975]={'317:73.00,20.60'}
G[42978]={'241:82.50,49.83'}
G[42983]={'37:41.72,64.64'}
G[43000]={'37:81.83,66.55'}
G[43006]={'460:47.38,59.70 57:58.39,35.54>460'}
G[43009]={'110:81.15,37.63'}
G[43010]={'467:64.93,42.38 94:39.3,20.2>467'}
G[43042]={'50:52.64,66.10'}
G[43043]={'210:55.74,41.22 N:52646'}
G[43045]={'50:47.86,11.86 N:52753'}
G[43062]={'86:51.30,55.98'}
G[43063]={'63:49.45,67.09'}
G[43065]={'207:49.62,52.94'}
G[43071]={'207:27.92,68.71'}
G[43072]={'49:77.8,65.8'}
G[43073]={'77:43.58,28.70'}
G[43079]={'77:44.29,61.87'}
G[43082]={'207:60.80,38.99 207:61.33,38.33 207:62.25,38.03 207:64.10,46.81 207:64.64,51.41','In the main cabin on a gunship'}
G[43086]={'51:72.03,12.05'}
G[43087]={'51:70.04,38.56'}
G[43088]={'51:30.78,34.61'}
G[43095]={'210:34.69,29.54 N:34668'}
G[43096]={'210:33.65,29.18'}
G[43097]={'210:35.1,27.6'}
G[43098]={'210:34.6,27.9'}
G[43099]={'210:46.23,28.15'}
G[43107]={'17:47.13,89.35'}
G[43108]={'26:66.3,44.3'}
G[43109]={'26:66.3,44.3'}
G[43116]={'Near207'}
G[43124]={'18:58.84,51.93'}
G[43156]={'26:63.8,60'}
G[43157]={'26:63.9,59.8'}
G[43158]={'207:69.95,60.09'}
G[43160]={'207:28.21,69.62'}
G[43168]={'207:24.52,62.41'}
G[43169]={'207:24.74,62.18'}
G[43184]={'49:26.29,40.12'}
G[43185]={'49:17.94,18.62'}
G[43187]={'241:78.85,51.75'}
G[43190]={'241:73.76,53.86'}
G[43191]={'241:76.53,49.47'}
G[43193]={'241:82.59,49.93 N:42641'}
G[43194]={'49:29.66,44.55'}
G[43200]={'26:30.7,47.1'}
G[43221]={'49:28.66,40.72'} -- 36:28.66,40.74 36:28.89,40.90
G[43239]={'86:65.69,41.08'}
G[43270]={'49:47.52,41.95'}
G[43272]={'49:33.55,11.85'}
G[43274]={'49:25.90,10.49'}
G[43275]={'49:28.31,16.95'}
G[43278]={'425:34.82,54.79 37:48.55,42.57>425'}
G[43287]={'201:42.42,66.13'}
G[43289]={'205:57.11,75.16 N:43287'}
G[43290]={'205:57.05,17.05'}
G[43295]={'203:69.48,75.32'}
G[43298]={'26:34.4,67.9 26:34.5,68.1'}
G[43299]={'26:35.65,68.46'}
G[43300]={'Near49 N:43270'}
G[43302]={'Near49 N:43275'}
G[43303]={'Near49 N:43274'}
G[43305]={'Near49 N:43272'}
G[43319]={'207:24.61,62.18'}
G[43327]={'49:50.60,42.83'}
G[43329]={'49:51.81,40.08'}
G[43344]={'207:34.08,35.23 207:34.56,34.48 207:34.51,33.31'}
G[43371]={'49:52.8,54.6'}
G[43395]={'207:71.79,47.59'}
G[43397]={'207:49.68,52.94'}
G[43438]={'324:62.60,65.06'}
G[43442]={'207:68.47,26.36'}
G[43453]={'47:79.07,44.19 N:35618'}
G[43454]={'210:41.33,61.23'}
G[43455]={'427:61.23,17.47 27:35.7,65.4>427'}
G[43458]={'49:52.55,55.42 N:43184'}
G[43459]={'49:52.43,55.54 N:43270'}
G[43461]={'49:52.41,55.41 N:43274'}
G[43462]={'49:52.54,55.56 N:43275'}
G[43504]={'210:43.84,56.53'}
G[43508]={'49:53.05,67.78'}
G[43546]={'49:70.26,60.14 N:43272'}
G[43549]={'198:71.60,75.35'}
G[43556]={'210:46.65,93.68','Pacing on deck'} -- 673:46.83,94.37 673:46.68,92.97 673:46.67,95.30 673:46.79,94.63
G[43570]={'26:65.77,44.88'}
G[43581]={'241:76.59,49.52 N:43190'}
G[43607]={'49:77.63,65.33 N:43275'}
G[43611]={'49:77.68,65.52 N:43184'}
G[43661]={'210:44.72,92.77'}
G[43690]={'84:61.99,31.21'}
G[43693]={'84:77.43,67.70'}
G[43697]={'47:21,56.6'}
G[43701]={'27:53.81,52.76'}
G[43702]={'27:75.8,54.4'}
G[43727]={'179:41.64,36.51 N:35378'}
G[43730]={'47:18.32,57.66'}
G[43731]={'47:20.02,57.82'}
G[43733]={'49:77.20,65.91 N:43221'}
G[43738]={'47:44.92,67.42'}
G[43769]={'84:70.23,73.36'}
G[43778]={'291:0.00,0.00'}
G[43792]={'207:49.74,53.30 N:42465'}
G[43795]={'88:63.2,79.8'}
G[43804]={'207:57.35,12.53 207:59.36,14.24 N:42472'}
G[43805]={'207:56.07,14.38'}
G[43806]={'207:54.6,14.3 207:55.4,13.1 207:55.5,13.1 207:56.5,13.4 207:56.6,14.1 N:42466'}
G[43809]={'207:56.06,13.46 N:42730'}
G[43812]={'49:58.57,55.65 N:43184'}
G[43818]={'207:49.6,53 N:43065'}
G[43835]={'207:49.27,52.80 N:42730'}
G[43837]={'207:49.4,52.8 207:49.8,52.7'}
G[43849]={'210:42,73.6'}
G[43861]={'47:18.35,58.04 N:311'}
G[43870]={'88:75.32,27.66'}
G[43875]={'325:0.00,0.00'}
G[43881]={'88:25.24,13.82'}
G[43884]={'50:47.13,10.56'}
G[43885]={'50:47.67,10.35'}
G[43886]={'50:47.98,12.01'}
G[43897]={'207:22.68,52.02'}
G[43898]={'207:22.76,52.10'}
G[43929]={'Near'}
G[43943]={'241:74.79,53.06 N:25237'}
G[43991]={'97:49.71,49.10'}
G[44010]={'207:64.47,82.13 N:42684'}
G[44017]={'50:53.46,66.75'}
G[44018]={'50:53.37,66.30'}
G[44019]={'50:53.21,66.93'}
G[44021]={'50:52.66,66.81'}
G[44024]={'241:73.80,53.93'}
G[44025]={'207:63.32,25.03 N:42465'}
G[44028]={'47:20.32,27.63'}
G[44036]={'94:43.96,69.97'}
G[44042]={'241:74.28,53.29 N:43187'}
G[44043]={'50:53.06,66.20 50:52.81,66.77'}
G[44080]={'207:62.61,26.92'}
G[44082]={'210:55.24,42.49'}
G[44083]={'210:55.41,42.19'}
G[44084]={'210:55.63,42.22'}
G[44098]={'47:18.08,25.32'}
G[44099]={'210:55.30,41.93'}
G[44100]={'210:55.01,42.26','Walks in area'} -- 673:55.04,41.85 673:55.02,42.43 673:54.76,42.40
G[44112]={'210:42.43,73.22'}
G[44143]={'207:27.59,44.84'}
G[44169]={'241:75.30,54.85 N:43190'}
G[44182]={'210:50.30,91.52'}
G[44200]={'48:25.40,17.80'}
G[44204]={'207:28.00,68.64'}
G[44216]={'213:70.43,11.40'}
G[44217]={'213:68.62,11.84'}
G[44222]={'207:64.4,82.2 207:64.5,82.2'}
G[44230]={'23:61.64,43.84'}
G[44231]={'23:52.77,53.57'}
G[44232]={'23:34.90,67.89'}
G[44233]={'23:18.46,27.37'}
G[44238]={'84:85.81,25.95 N:26814'}
G[44247]={'84:78.94,71.17'}
G[44293]={'Near84 N:1747'}
G[44303]={'199:66.96,46.59'}
G[44345]={'48:34.80,49.11'}
G[44365]={'21:57.36,10.19 N:10181'}
G[44372]={'207:47,89.4'}
G[44374]={'71:33.21,76.90'}
G[44375]={'221:48.20,13.10 63:16.52,11.03>221'}
G[44395]={'84:57.48,24.90 N:35873'}
G[44402]={'301:67.46,82.77'}
G[44407]={'15:64.34,35.04'}
G[44409]={'15:48.99,36.20'}
G[44410]={'15:21.71,57.80'}
G[44415]={'301:19.92,35'}
G[44441]={'22:41.99,14.73 N:28179','Top of keep'}
G[44451]={'22:49,63.7 N:10181'}
G[44452]={'22:47.77,65.19 N:26581'}
G[44453]={'22:41.07,70.45 N:26170'}
G[44454]={'22:49.27,54.91'}
G[44456]={'22:48.87,54.78'}
G[44457]={'22:48.53,54.90'}
G[44458]={'22:50.65,52.57'}
G[44462]={'22:47.31,64.41'}
G[44466]={'22:47.58,65.56'}
G[44467]={'22:41.26,70.07'}
G[44471]={'22:41.01,70.49'}
G[44472]={'22:48.43,31.95'}	-- 22:48.21,31.79 22:48.60,32.11
G[44490]={'204:69.75,34.42 N:39887'}
G[44540]={'204:69.7,34.4 204:69.7,34.5 N:40917'}
G[44556]={'226:63.02,33.41'}
G[44560]={'227:65.19,47.05'}
G[44561]={'228:23.90,39.07'}
G[44563]={'229:34.53,19.82'}
G[44566]={'323:0.00,0.00'}
G[44615]={'21:57.42,10.14'}
G[44618]={'48:78.56,76.25','In cave'}
G[44635]={'48:73.29,35.98'}
G[44640]={'21:57.52,10.49'}
G[44725]={'86:45.20,53.69'}
G[44726]={'86:44.79,51.56'}
G[44735]={'86:45.50,53.77'}
G[44741]={'304:63.38,94.15'}
G[44749]={'84:33.10,39.50'}
G[44778]={'21:56.77,9.19'}
G[44784]={'21:56.27,8.40'}
G[44789]={'21:58.09,8.99'}
G[44799]={'207:47.31,51.40'}
G[44802]={'207:47.32,51.36'}
G[44804]={'304:66.91,83.75 N:44800'}
G[44806]={'84:34.77,38.22'}
G[44807]={'84:52.00,5.81'}
G[44818]={'207:51.28,50.00'}
G[44819]={'277:0.00,0.00'}
G[44823]={'207:51.29,50.05'}
G[44833]={'71:30.49,65.51 N:39667'}
G[44837]={'300:24.52,23.72 64:47.56,23.60>300'}
G[44853]={'85:48.4,83.3 85:48.5,83.2'}
G[44859]={'48:82.79,63.45'}
G[44860]={'249:64.38,22.33 N:26814'}
G[44866]={'86:54.03,73.30'}
G[44870]={'48:58.53,29.10'}
G[44871]={'85:53.3,74.3 85:53.3,74.5 85:53.7,74.1 85:54,73.4'}
G[44905]={'22:42.65,14.96 N:44458','Top of keep'}
G[44912]={'21:44.79,20.91'}
G[44916]={'21:44.02,21.36'}
G[44917]={'21:43.99,21.29'}
G[44919]={'86:48.92,59.24'}
G[44927]={'462:30.83,49.46 7:46.15,82.31>462'}
G[44929]={'219:58.27,88.68 71:39.22,21.34>219'}
G[44943]={'210:46.68,95.32'}
G[44945]={'207:55.36,14.16'}
G[44968]={'207:61.38,26.17 N:29428'}
G[44969]={'239:11.13,38.78 69:64.84,30.26>234'}
G[44971]={'239:7.04,36.13 69:64.84,30.26>234'}
G[44973]={'207:59.60,14.04 N:43442'}
G[44978]={'86:34.98,67.83'}
G[44991]={'236:90.65,44.86 69:60.32,30.15>234 N:40052'}
G[44999]={'236:87.41,52.39 69:60.32,30.15>234'}
G[45009]={'87:40,55 N:2784'}
G[45012]={'22:50.49,52.71'}
G[45013]={'22:49.3,53.2'}
G[45040]={'235:71.67,91.95 69:62.49,24.90>234'}
G[45042]={'276:33.36,50.18 N:4949'}
G[45043]={'207:20.71,61.58'}
G[45046]={25237,''}
G[45052]={'234:71.3,91.2 234:71.3,93.2 234:71.4,92.4 234:71.6,92.4 234:71.6,92.5 234:71.9,91.2'}
G[45098]={'22:38.8,55.3'}
G[45107]={'306:46.20,51.84 22:69.06,73.00>306'}
G[45108]={'306:47.32,51.76 22:69.06,73.00>306'}
G[45109]={'306:46.03,58.48 22:69.06,73.00>306'}
G[45110]={'306:47.30,58.41 22:69.06,73.00>306'}
G[45129]={'22:39.4,70.6 22:39.6,70.4 22:39.6,70.5 N:44471'}
G[45137]={'86:35.58,69.11'}
G[45147]={'22:42.37,15.20'}
G[45149]={'22:44.82,12.53'}
G[45152]={'22:45.80,18.35'}
G[45155]={'22:57.39,35.63'}
G[45157]={'22:43.21,15.93'}
G[45165]={'22:42.70,84.11'}
G[45167]={'241:79.09,78.29 N:21330'}
G[45168]={'241:77.01,69.86 N:44806'}
G[45169]={'241:76.76,69.83'}
G[45170]={'241:79.29,78.53'}
G[45171]={'241:76.02,79.70'}
G[45172]={'241:67.67,65.96'}
G[45173]={'241:79.43,77.64'}
G[45180]={'249:64.56,28.60 N:26814'}
G[45186]={'249:64.63,28.67'}
G[45195]={'21:45.2,48.3 21:45.2,51.4 21:45.3,49.2 21:45.8,53.6 21:45.9,53.4 21:46.1,51.4 21:46.2,49.4 21:46.2,49.5 21:46.4,51.5 21:46.4,54.6 21:46.7,52 21:46.8,51 21:46.9,52.6 21:47,45.7 21:47,48.5 21:47,49.5 21:47.3,47 21:47.3,48 21:47.4,53.5 21:47.4,55.2 21:47.5,55.4 21:47.5,55.5 21:47.6,50.4 21:47.7,51 21:47.9,51.6 21:47.9,54.3 21:48.4,53.3 21:48.5,50.1 21:48.5,50.5 21:48.8,52.2 21:48.8,53.7 21:49.3,53.2'}
G[45200]={'317:66.25,86.69 23:27.07,15.77>317 N:16115'}
G[45201]={'317:65.25,87.16 23:27.07,15.77>317'}
G[45202]={'249:65,30 K:27187'}
G[45206]={'318:67.92,72.09 23:43.45,19.36>317 N:16112'}
G[45226]={'84:74.54,19.03'}
G[45228]={'21:55.89,46.35'}
G[45244]={'86:50.46,38.36'}
G[45254]={'21:59.27,34.41'}
G[45257]={'17:60.7,28.1'}
G[45258]={'17:60.6,75.4'}
G[45260]={'17:31.4,69.5'}
G[45262]={'17:32.2,44'}
G[45271]={'64:44.63,50.01'}
G[45277]={'64:42.17,48.39'}
G[45278]={'64:42.17,48.39'} -- I cheated and copied from 45277
G[45296]={'249:64.50,28.00 N:26814','Down in Chamber of the Stars'}
G[45301]={'217:56.51,18.13'}	-- 545:51,17
G[45306]={'84:62.99,34.07'}
G[45312]={'217:57.47,18.94 N:44789'}
G[45315]={'217:57.54,18.23'}
G[45320]={'85:45.3,10.6 85:48.4,89.4 85:48.4,89.7 85:48.4,90.5 85:48.5,89.4 85:48.5,89.7'}
G[45323]={'317:66.98,89.33 23:27.07,15.77>317'}
G[45328]={'318:67.62,82.30 23:43.45,19.36>317 N:45323'}
G[45329]={'318:68.04,72.69 23:43.45,19.36>317 N:16115'}
G[45330]={'318:67.11,72.62 23:43.45,19.36>317 N:16116'}
G[45331]={'318:68.64,73.13 23:43.45,19.36>317 N:45201'}
G[45332]={'241:44.04,10.55 N:42730'}
G[45337]={'86:49.18,70.93'}
G[45339]={'86:48.15,72.94'}
G[45340]={'291:44.77,82.41'}
G[45347]={'86:37.92,87.61'}
G[45362]={'241:44.20,18.13 N:42573'}
G[45385]={'64:43.30,43.50'}
G[45386]={'241:43.83,11.33 N:42573'}
G[45389]={'217:65.64,34.10'}
G[45391]={'241:44.00,11.24 N:39875'}
G[45400]={'23:8.82,66.59'}
G[45412]={'318:39.13,20.31'}
G[45417]={'23:9.02,66.52'}
G[45428]={'23:4.14,36.02'}
G[45429]={'23:18.37,74.85'}
G[45430]={''}
G[45431]={'23:74.36,53.33 N:45428'}
G[45432]={'241:44.41,11.56 N:42574'}
G[45442]={'64:39.15,25.76'}
G[45451]={'23:35.71,69.31','Tower top, moving around tower'}
G[45460]={'203:64.4,68.7 203:64.5,68.7 N:39875'}
G[45462]={'203:69.8,75.2 N:39877'}
G[45474]={'Near217 N:44789'}
G[45482]={'23:51.63,21.41'}
G[45500]={'23:35.02,68.15'}
G[45518]={'241:29.30,25.99'}
G[45522]={'241:29.85,31.28'}
G[45525]={'21:51.77,66.05 N:10181'}
G[45528]={'241:29.33,25.97'}
G[45530]={'85:32.2,37.8 85:32.7,37.7 85:33.5,37.9 N:25237'}
G[45540]={'86:36.92,87.48'}
G[45562]={'241:29.80,31.42'}
G[45574]={'23:52.77,51.38'}
G[45575]={'23:53.79,53.99','Tower top'}
G[45617]={'21:51.90,65.01 N:10181'}
G[45626]={'21:51.89,64.73'}
G[45631]={'21:51.70,66.55 N:44640'}
G[45658]={'241:45.27,75.36'}
G[45665]={'241:45.32,75.35'}
G[45668]={'241:43.36,57.35 N:21330'}
G[45669]={'241:43.41,57.34'}
G[45675]={'241:36.37,65.96'}
G[45728]={'25:31.4,37.4'}
G[45729]={'23:75.77,52.41 N:45429'}
G[45730]={'23:28.46,25.91 N:45428'}
G[45735]={'23:61.58,43.13'}
G[45736]={'23:61.32,42.86'}
G[45752]={'21:58.06,69.91'}
G[45772]={'249:45.2,37.8'}
G[45786]={'51:73.16,14.90'}
G[45796]={'241:36.37,65.95 N:332'}
G[45799]={'249:45.25,37.96'}
G[45816]={'23:48.00,23.04'}
G[45817]={'242:46.7,65.3 242:46.8,65.9'}
G[45818]={'242:44,77 242:44.3,77.6 242:44.5,76.9 242:44.8,78.2'}
G[45820]={'242:40.3,67.1 242:40.9,66.4 242:40.9,67.4 242:41,67.5 242:41.5,93.2'}
G[45821]={'242:35.9,77.5 242:36,77.4 242:36.2,76.2'}
G[45823]={'242:35.4,77.8 242:35.9,77.6 242:36,77.3 242:36.1,78.7 242:36.5,78.5 242:36.6,77 242:36.6,78.4'}
G[45824]={'242:51.3,52.2 242:51.3,53.2'}
G[45826]={'23:50.00,19.52'}
G[45828]={'23:17.74,27.88'}
G[45831]={'23:27.65,20.85'}
G[45839]={'242:36.3,74.1 242:36.4,75.4 242:36.4,75.5 242:36.5,75.5 242:36.6,74.9'}
G[45840]={'242:58.1,22.4 242:58.1,22.5 242:58.5,23 242:58.6,21.9'}
G[45849]={'242:37.37,80.07 36:14.58,9.21>242'}
G[45850]={'242:35.99,81.00 36:14.58,9.21>242'}
G[45867]={'23:25.39,19.79'}
G[45868]={'23:29.42,19.66'}
G[45874]={'249:63.44,32.49'}
G[45878]={'Z21 N:35115'}
G[45879]={'Z21'}
G[45880]={'Z21'}
G[45888]={'243:46.89,66.13 36:14.58,9.21>242'}
G[45890]={'243:58.07,22.25 36:14.58,9.21>242'}
G[45891]={'242:36.72,74.59 36:14.58,9.21>242 N:9177'}
G[45892]={'242:36.19,77.28 36:14.58,9.21>242'}
G[45894]={'242:40.95,67.21 36:14.58,9.21>242'}
G[45896]={'21:47.4,77.6'}
G[45898]={'242:44.29,77.79 36:14.58,9.21>242'}
G[45899]={'243:50.77,52.68 36:14.58,9.21>242'}
G[45903]={'242:36.06,77.68 36:14.58,9.21>242'}
G[45948]={'51:84.02,40.12'}
G[45966]={'27:25.76,31.95 30:34.07,32.19 N:42396'}
G[45982]={'241:70.24,43.26'}
G[45983]={'241:70.31,43.39'}
G[46003]={'249:40.00,40.55'}
G[46006]={'22:39.44,69.54'}
G[46010]={'51:73.64,9.16'}
G[46011]={'22:50.50,52.23'}
G[46022]={'23:73.81,52.36'}
G[46071]={'51:69.47,54.52 N:27785'}
G[46077]={'220:49.99,17.15 51:69.68,53.45>220 N:27785'}
G[46089]={'241:78.24,62.54'}
G[46090]={'241:78.46,62.60'}
G[46124]={'21:45.32,84.47 N:10181'}
G[46125]={'21:45.34,84.35 N:44640'}
G[46126]={'249:63.6,32.6 K:27627'}
G[46127]={'249:66.6,27.6 K:27627'}
G[46128]={'249:65.6,32.8 K:27627'}
G[46129]={'249:64.2,27.2 K:27627'}
G[46134]={'249:58.88,46.07'}
G[46135]={'249:54.18,41.88','Inside the dam'}
G[46136]={'249:56.62,54.93 249:56.73,53.84 249:56.49,53.26 249:56.28,53.53 249:55.98,53.96'}
G[46138]={'23:77.54,79.35'}
G[46143]={'241:45.92,65.43'}
G[46172]={'51:69.07,76.50'}
G[46174]={'241:45.78,71.73 241:47.88,74.55'}
G[46175]={'241:53.07,74.59 241:52.89,74.56 241:52.97,74.26 241:52.89,74.09 241:52.70,74.06 241:52.86,74.31 241:53.22,74.10'}
G[46176]={'241:46.50,59.44 241:46.57,59.12 241:46.25,58.73 241:45.96,58.65'}
G[46177]={'241:45.91,65.49'}
G[46182]={'51:74.24,12.17'}
G[46233]={'230:63.97,73.01 15:34.28,10.37>230'}
G[46234]={'230:63.75,72.57 15:34.28,10.37>230'}
G[46235]={'230:64.1,72.6 230:64.2,72.4 230:65,72.7'}
G[46236]={'230:64.1,72.6 230:64.2,72.4 230:64.7,72.8 230:64.8,72.4'}
G[46241]={'230:64.2,72.4 230:64.2,72.5 230:64.7,72.6 230:64.8,72.4'}
G[46242]={'241:37.48,88.64 N:42573'}
G[46243]={'241:37.56,88.73 N:42574'}
G[46247]={'230:63.99,72.12 15:34.28,10.37>230'}
G[46250]={'225:0.00,0.00'}
G[46254]={'225:19.96,31.57 N:448'}
G[46255]={'27:29.52,37.71 30:66.39,81.63'}
G[46260]={'225:49.79,27.31'}
G[46264]={'225:77.22,44.63'}
G[46274]={'27:27.97,37.79 30:53.08,82.32'}
G[46313]={'241:54.81,44.20'}
G[46318]={'241:55.14,43.56'}
G[46319]={'241:53.84,43.26'}
G[46323]={'241:53.30,42.70 N:45675'}
G[46324]={'241:53.21,42.71'}
G[46338]={'201:55.28,38.92'}
G[46409]={'225:42.36,54.01'}
G[46410]={'225:56.61,53.86'}
G[46413]={'241:27.64,63.86','Bottom of lake'}
G[46417]={'225:50.03,58.27'}
G[46458]={'201:58.41,48.68 N:46338'}
G[46463]={'201:58.41,48.67 N:46338'}
G[46474]={'201:60.50,69.61'}
G[46475]={'26:32.2,42.6'}
G[46476]={'26:64,59.9'}
G[46496]={'249:58.4,82.9 249:58.5,82.8'}
G[46513]={'Near241 N:42574'}
G[46583]={'241:52.41,70.33 N:46175'}
G[46585]={'241:46.1,65.6 N:46175'}
G[46590]={'249:70.4,59.2'}
G[46591]={'241:49.01,29.77'}
G[46592]={'249:69.4,58.2 249:69.4,58.5 249:69.6,58.4 249:69.6,58.6 249:69.9,59.5'}
G[46603]={'249:60.28,38.28'}
G[46612]={'291:30.26,28.63 N:42308'}
G[46626]={'241:50.48,70.58 N:46176'}
G[46627]={'241:50.54,70.81 N:46175'}
G[46628]={'241:50.50,70.62 N:46143'}
G[46637]={'86:67.50,38.81'}
G[46638]={'86:67.35,38.73'}
G[46650]={'15:92.64,38.96'}
G[46652]={'15:65.07,38.40'}
G[46653]={'15:64.27,38.13'}
G[46654]={'15:66.39,55.49'}
G[46655]={'15:66.45,55.51'}
G[46657]={'179:51,17 N:45301'}
G[46660]={'15:18.4,41.4 15:18.4,41.5 15:18.5,41.4 15:18.5,41.5'}
G[46664]={'15:47.15,56.47 15:46.83,56.29 15:46.61,56.50'}
G[46671]={'241:37.42,93.23'}
G[46676]={'51:68.20,36.17'}
G[46708]={'85:56.4,61.2 85:56.4,61.5 85:56.5,61.2 85:56.9,61.5'}
G[46717]={'241:45.39,87.97'}
G[46750]={'249:77.27,63.26'}
G[46757]={'15:52.2,51.2 N:46236'}
G[46758]={'15:52.2,51.4 15:52.2,51.5 N:46241'}
G[46759]={'15:52.2,51.4 15:52.2,51.5 N:46235'}
G[46760]={'15:49.25,36.92 N:46234'}
G[46768]={'15:50.27,54.31'}
G[46769]={'15:50.25,53.26'}
G[46804]={'241:60.16,58.00'}
G[46805]={'241:57.48,58.14'}
G[46806]={'241:62.60,48.64'}
G[46811]={'241:50.8,60.2'}
G[46812]={'241:50.8,60.2'}
G[46814]={'241:60.42,58.30'}
G[46850]={'241:62.49,48.41 241:62.55,48.28'}
G[46852]={'15:20.58,56.07'}
G[46853]={'15:20.63,56.19'}
G[46854]={'15:20.58,56.30'}
G[46855]={'Near15 N:46852'}
G[46856]={'Near15 N:46853'}
G[46857]={'Near15 N:46854'}
G[46860]={'15:15.3,42.8 15:15.6,42.8'}
G[46861]={'15:6.2,39.3 15:7.5,42.5 15:7.8,35.8 15:7.9,39.5 15:8.3,36.8 15:8.3,38 15:8.4,38.5 15:8.4,40.5 15:8.5,39.3 15:8.7,37.4 15:8.9,43.4 15:9,37.5 15:9.1,43.8 15:9.2,42.4 15:9.3,40.8 15:9.4,35.6 15:9.4,39.9 15:9.5,37.4 15:9.5,40 15:9.5,40.6 15:9.9,37.9 15:9.9,42.2 15:10.1,38.5 15:10.2,36 15:10.5,37.1 15:10.5,38.1 15:10.5,40.7 15:10.6,35.4 15:10.7,40 15:11.2,39.4 15:11.3,41.8 15:11.6,38.3 15:11.6,42.3 15:12.1,38.9 15:12.4,40.1 15:12.5,39.9 15:13.3,36.2 15:82.1,37.4'}
G[46872]={'249:59.58,72.02 N:45799'}
G[46873]={'249:59.70,71.82 N:39667'}
G[46875]={'249:59.66,71.99 N:46338'}
G[46883]={'249:59.57,47.33'}
G[46889]={'291:28.86,26.13'}
G[46901]={'HD 1:47.35,18.02'}
G[46902]={'291:29.47,25.42'}
G[46906]={'291:28.75,26.22 N:34693'}
G[46908]={'HD 89:69.91,40.62'}
G[46916]={'15:8,40.8 15:8.1,41.5 15:8.4,40.2 15:8.4,42.5 15:8.8,41.8 15:8.8,42.7 15:9.1,38.3 15:9.1,38.9 15:9.2,44.3 15:9.2,44.5 15:9.3,39.7 15:9.4,36.4 15:9.4,37.4 15:9.4,41.1 15:9.5,36.4 15:9.6,38.2 15:9.6,41.3 15:9.6,41.5 15:9.7,46 15:9.8,46.7 15:10,42.6 15:10.1,34.8 15:10.2,38.7 15:10.2,43.9 15:10.3,39.6 15:10.4,37.3 15:10.7,38.7 15:11,38.2 15:11.1,39.9 15:11.2,41.1 15:11.3,36.9 15:11.4,41.6 15:11.5,40.5 15:11.5,41.6 15:11.6,39.1 15:11.7,36.2 15:11.8,38.4 15:11.8,39.9 15:12.1,36.7 15:12.6,39.3 15:12.7,39.7 15:12.8,36.5 15:12.8,37.5 15:13,36.4'}
G[46917]={'15:13,43.4 15:13,43.5 15:13.1,45.2 15:14.3,46.3 15:14.4,42.7 15:14.6,42.7 15:15.4,46.7 15:15.5,46.7 15:17,48 15:17.2,47.4 15:17.4,45.6 15:17.7,44.6 15:18,45.8 15:19.1,46.7 15:19.3,46 15:20.1,44.8 15:21,44 15:21.3,43.3 15:21.9,43.5 15:22.4,43.1 15:22.5,43.4'}
G[46920]={'249:73.6,72.6'}
G[46930]={'15:20.86,55.72'}
G[46935]={'241:50.74,58.31 N:18471'}
G[46936]={'241:50.7,58.4 241:50.7,58.5 N:22893'}
G[46938]={'15:16.7,48.8'}
G[46964]={'310:0.00,0.00 N:35115'}
G[46972]={'15:20.80,57.35'}
G[46978]={'249:43.98,57.08 N:26814'}
G[46987]={'198:28.28,29.74'}
G[46993]={'249:46.8,58.6'}
G[46998]={'198:27.04,62.64 N:46987'}
G[47002]={'198:43.80,45.95 N:46987'}
G[47005]={'249:54.29,35.27 N:39667'}
G[47006]={'310:62.06,57.24'}
G[47011]={'15:18.8,42.9'}
G[47013]={'15:18.8,42.9'}
G[47014]={'249:80.4,47.8'}
G[47018]={'15:18.8,42.9'}
G[47021]={47011,''}
G[47022]={47013,''}
G[47024]={47018,''}
G[47041]={'51:21.2,51.9'}
G[47118]={'241:43.88,57.27'}
G[47119]={'241:81.66,77.11'}
G[47121]={'241:28.54,24.86'}
G[47147]={'241:60.42,57.65'}
G[47154]={'241:48.54,28.11'}
G[47155]={'241:56.78,15.11'}
G[47158]={'249:36.13,15.77 N:26814'}
G[47159]={'249:24.44,64.08 249:24.46,64.27'}
G[47162]={'291:32.89,59.37'}
G[47195]={'207:30.7,77.8 N:44143'}
G[47202]={'249:41,70 K:27940'}
G[47231]={'310:0.00,0.00'}
G[47233]={'86:44.64,61.60'}
G[47240]={'245:73.39,59.18'}
G[47246]={'86:48.49,62.91'}
G[47250]={'27:27.72,31.93 30:50.97,31.92'}
G[47266]={'32:68.57,53.38'}
G[47267]={'32:68.49,53.28'}
G[47268]={'32:68.74,53.34'}
G[47269]={'32:68.91,53.27'}
G[47280]={'Near32 N:47269'}
G[47281]={'32:54.68,72.22 N:47269'}
G[47293]={'310:64.36,57.87 N:44789'}
G[47299]={'32:68.99,53.51'}
G[47317]={'241:61.48,67.42'}
G[47318]={'249:49.67,39.11'}
G[47332]={'Near32 N:47269'}
G[47341]={'77:41.9,72'}
G[47366]={'77:41.89,71.94'}
G[47374]={'Near241'}
G[47383]={'64:69.88,85.17'}
G[47393]={'32:39.42,67.86'}
G[47417]={'241:54.35,43.85 N:43190'}
G[47429]={'32:39.83,67.91 N:47269'}
G[47432]={'25:29.21,64.04'}
G[47440]={'32:38.84,68.92'}
G[47462]={'32:43.06,29.19'}
G[47471]={'64:12.85,33.98'}
G[47492]={'241:27.32,36.79 N:47374'}
G[47493]={'241:29.63,40.98 N:42641'}
G[47551]={'25:33.28,73.63'}
G[47554]={'25:33.29,73.55'}
G[47556]={'77:60.58,9.51'}
G[47571]={'86:49.05,70.56'}
G[47580]={'64:30.47,49.27 N:45442'}
G[47592]={'241:25.99,38.79 N:332'}
G[47603]={'241:21.77,57.09 N:26917'}
G[47605]={'241:22.13,56.55 N:45528'}
G[47611]={'Near241'}
G[47617]={'77:44.1,61.8'}
G[47626]={'292:58.76,39.49'}
G[47670]={'249:24.37,64.55 N:47571'}
G[47671]={'241:36.42,38.12 N:43190'}
G[47681]={'25:36.62,70.20'}
G[47684]={'249:54.91,32.72'}
G[47692]={'77:41.26,49.95'}
G[47696]={'77:41.27,49.90'}
G[47709]={'249:52.9,27.6 249:53,27.2'}
G[47715]={'249:52.98,27.70'}
G[47723]={'241:36.73,37.95'}
G[47739]={'292:60.65,41.24'}
G[47745]={'64:50.14,62.57 N:4046'}
G[47751]={'241:36.39,37.99'}
G[47759]={'25:32.6,78'}
G[47779]={'36:16.99,51.29'}
G[47781]={'25:36.17,61.15'}
G[47789]={'25:38.6,62.6'}
G[47811]={'36:17.27,52.08 N:43184'}
G[47843]={'77:43.45,28.19'}
G[47869]={'25:40.32,59.40'}
G[47875]={'22:44.65,18.47'}
G[47899]={'25:36.34,60.24'}
G[47900]={'25:40.32,59.34'}
G[47902]={'241:59.07,69.80 N:45518'}
G[47904]={'241:59.02,69.81 N:45522'}
G[47905]={'241:44.91,90.90 N:45562','In Obsidian Lair'}
G[47923]={'77:45.6,20.2'}
G[47927]={'32:41.05,68.78'}
G[47931]={'77:61.84,26.77'}
G[47940]={'249:24.40,64.09 N:47159'}
G[47959]={'249:55.02,34.04 N:45799'}
G[47967]={'249:21.85,64.03'}
G[47972]={'249:22.51,63.18 N:47159'}
G[47991]={'241:48.40,14.56 N:42573'}
G[48001]={'36:45.45,46.34'}
G[48010]={'241:49.78,29.17'}
G[48012]={'249:58.97,46.13'}
G[48013]={'241:49.79,29.28'}
G[48014]={'241:49.14,29.31'}
G[48020]={'25:40.30,59.34 N:47900'}
G[48021]={'25:40.26,59.33 N:47869'}
G[48022]={'Near249 N:46883'}
G[48032]={'Near77'} -- initially at 182:48.68,25.16
G[48033]={'36:46.80,44.08'}
G[48034]={'249:63.90,33.85 N:26814'}
G[48038]={'77:48.46,31.04'}
G[48039]={'244:51.42,49.62'}
G[48042]={'Near77'}
G[48044]={'Near77'}
G[48046]={'241:62.56,48.59'}
G[48051]={'276:33.38,50.35 N:4949'}
G[48053]={'241:63.15,47.61'}
G[48059]={'241:48.70,16.63 N:42573'}
G[48061]={'244:51.41,49.61'}
G[48062]={'244:51.4,49 244:51.4,49.6 244:51.5,49.1 244:51.5,49.7'}
G[48066]={'244:50.93,49.70'}
G[48069]={'244:50.6,50.5 244:50.9,49.2 244:50.9,49.7'}
G[48070]={'244:51.4,49 244:51.4,49.6 244:51.5,49.1 244:51.5,49.7'}
G[48071]={'244:51.3,49.1 244:51.4,49.6 244:51.5,49.1 244:51.5,49.7'}
G[48074]={'244:51.42,49.61'}
G[48082]={'249:54.64,41.79 N:26814'}
G[48085]={'36:45.32,51.74'}
G[48099]={'36:39.2,55.4 36:39.2,56.1 36:39.2,56.5'}
G[48100]={'36:45.1,52.5 36:45.3,52.4'}
G[48109]={'36:46.39,46.02 N:43184'}
G[48110]={'36:46.32,45.96 N:43221'}
G[48111]={'36:44.41,63.47'}
G[48126]={'77:43.93,28.16'}
G[48127]={'77:56.3,8.2'}
G[48129]={'25:49.15,66.34'}
G[48133]={'36:30.68,33.72'}
G[48162]={'249:23.55,60.25 N:26814'}
G[48173]={'241:49,29.7 N:46591'}
G[48174]={'241:49.1,29.4 N:48014'}
G[48175]={'241:49.7,29.2 N:48010'}
G[48186]={'249:27.03,7.56 N:26814'}
G[48203]={'249:26.62,8.03'}
G[48208]={'64:43.40,43.44'}
G[48218]={'25:49.56,74.38'}
G[48229]={'291:0.00,0.00'}
G[48237]={'249:56.92,62.43 N:46883'}
G[48250]={'245:74.77,59.60'}
G[48254]={'245:72.94,60.94'}
G[48255]={'245:73.72,57.59'}
G[48264]={'241:44.08,10.54 N:27804'}
G[48265]={'241:44.08,10.54 N:27803'}
G[48273]={'249:22.29,64.93'}
G[48274]={'249:26.61,8.37'}
G[48275]={'249:56.20,33.60 N:26664'}
G[48292]={'36:82.11,31.52 N:10299'}
G[48306]={'36:73.49,67.19 N:43184'}
G[48307]={'36:73.63,67.16 N:43221'}
G[48312]={'36:69.63,42.90','In cave on top of hill'}
G[48314]={'36:70.17,47.29','In cave'}
G[48316]={'36:66.52,40.53 N:48133','In cave'}
G[48318]={'36:17.78,52.77'}
G[48319]={'25:47.9,71.2 25:48.4,72.3 25:48.4,73 25:48.7,71.3 25:48.7,72.4 25:48.7,72.5'}
G[48321]={'36:46.15,41.80'}
G[48322]={'25:47.9,72.5'}
G[48333]={'77:54.7,18.4'}
G[48339]={'77:43.94,27.86'}
G[48346]={'Near36 N:43184'}
G[48349]={'77:44.00,27.86'}
G[48351]={'291:0.00,0.00'}
G[48358]={'245:53.7,80.4 245:53.7,80.5'}
G[48360]={'245:55.2,81.1 245:55.5,80.6'}
G[48361]={'245:55.6,78.4 245:55.7,78.6'}
G[48363]={'245:54.4,79.4 245:54.4,79.6 245:54.5,79.7 245:55,79.2'}
G[48364]={'241:54.39,16.75 N:46804'}
G[48365]={'241:54.76,17.37 241:54.88,17.17 N:21330'}
G[48366]={'241:54.60,17.54'}
G[48367]={'241:54.33,16.75'}
G[48368]={'241:54.3,16.8'}
G[48417]={'292:33.30,48.65'}
G[48419]={'291:59.81,71.78'}
G[48420]={'291:60.32,71.42'}
G[48428]={'249:40,22'}
G[48431]={'249:29.61,21.85 N:48203'}
G[48445]={'291:44.66,82.78'}
G[48459]={'77:43.33,30.43'}
G[48461]={'77:64.09,10.29'}
G[48469]={'77:44.2,28'}
G[48470]={'25:29.30,83.88 N:48218'}
G[48472]={'241:38.12,34.49 N:46591'}
G[48491]={'77:44.34,28.07'}
G[48492]={'77:61.91,26.66'}
G[48493]={'77:56.76,18.50'}
G[48501]={'249:67.34,42.79'}
G[48502]={'292:0.00,0.00'}
G[48503]={'25:27.14,88.35 N:48218'}
G[48513]={'86:36.6,87.0'}
G[48522]={'292:60.67,40.49'}
G[48528]={'249:36.15,20.26 N:26814','In the Chamber of the Moon'}
G[48530]={'241:54.74,17.95 N:48013'}
G[48545]={'25:57.08,46.23 N:44640'}
G[48558]={'249:39.00,23.24 N:26814','In the Chamber of the Moon'}
G[48559]={'36:17.4,51.7 36:17.5,51.7'}
G[48564]={'249:52.02,65.46 N:47684'}
G[48565]={'36:54.6,24.4 36:54.7,24.6 N:48559'}
G[48567]={48559,''}
G[48568]={'36:44.6,44.4 36:44.6,44.5 N:3144'}
G[48569]={'36:54.6,24.4 36:54.6,24.5 N:3144'}
G[48621]={'249:42.16,25.92 N:48203'}
G[48658]={'83:50.72,54.87'}
G[48659]={'83:50.80,55.01'}
G[48660]={'83:50.69,55.07'}
G[48698]={'249:41.35,5.56 N:26814'}
G[48704]={'23:73.74,53.06'}
G[48722]={'83:65.32,46.19'}
G[48723]={'83:65.37,46.20'}
G[48731]={''}
G[48732]={''}
G[48733]={39875,''}
G[48734]={42684,''}
G[48736]={'89:48.13,14.47'}
G[48761]={'249:67.23,42.90 N:46883'}
G[48764]={'62:52.4,30.8'}
G[48797]={'210:39.48,69.54','Swims in harbor'}
G[48808]={'210:40.52,68.20'}
G[48965]={'83:59.74,49.66'}
G[48993]={'241:77.63,16.63 N:42640'}
G[49000]={'241:82.12,80.05 N:47374'}
G[49002]={'241:81.84,80.39'}
G[49020]={'241:78.82,76.90 N:44806'}
G[49022]={'241:80.96,79.40'}
G[49035]={'Z25'}
G[49044]={'465:40.51,78.53 18:29.43,70.94>465'}
G[49151]={'249:33.33,19.66 N:26814'}
G[49201]={'25:60.04,63.67'}
G[49203]={'249:32.59,30.66 N:26814'}
G[49204]={'249:32.59,30.89 N:28070'}
G[49240]={'25:61.86,84.22'}
G[49243]={'25:60.08,63.35'}
G[49248]={'249:44.85,67.32 N:28070'}
G[49252]={'241:81.04,79.34 N:44806'}
G[49345]={'249:52.94,65.51 N:46883'}
G[49351]={'249:44.85,67.32 N:28070'}
G[49358]={'241:55.25,17.32 N:21330'}
G[49374]={'241:55.21,17.31 N:48367'}
G[49378]={'241:80.07,74.53 N:47374','Circling in airship'}
G[49379]={'241:80.05,74.50 N:49002','Circling in airship'}
G[49386]={'241:48.61,30.68'}
G[49387]={'241:53.87,42.08'}
G[49396]={'83:55.94,28.13'}
G[49399]={'83:45.61,41.58'}
G[49400]={'83:46.29,42.58'}
G[49402]={'83:48.08,40.61'}
G[49407]={'83:45.78,41.01'}
G[49408]={'249:26.9,7.4 249:26.9,7.5'}
G[49417]={'241:14.87,16.34 N:45518'}
G[49425]={'465:67.01,42.35 18:35.75,62.23>465'}
G[49436]={'83:55.89,28.27'}
G[49439]={'241:77.69,16.65'}
G[49441]={'241:77.67,16.69'}
G[49444]={'198:42.65,28.14'}
G[49476]={'283:33.08,65.99 N:49444'}
G[49479]={'460:42.53,50.49 57:57.20,33.27>460 N:32973'}
G[49480]={'460:38.91,27.69 57:56.07,26.29 N:1992','In cave'}
G[49523]={'249:41.36,5.57'}
G[49537]={'83:55.97,28.24'}
G[49635]={'210:41.49,74.36'}
G[49636]={'210:41.7,74'}
G[49687]={'25:33.6,49.3'}
G[49748]={'89:45.21,49.88'}
G[49810]={'241:14.15,15.47 N:45528'}
G[49856]={'23:76.16,50.95'}
G[49920]={'15:91.2,37.2 15:91.3,37.7 15:91.5,38'}
G[49941]={'299:47.15,44.40 N:28070'}
G[49943]={'325:54.48,15.83 249:76.75,84.45>325'}
G[50038]={'277:31.69,16.14 249:60.52,64.19>277'}
G[50048]={'324:53.61,94.92'}
G[50049]={'84:37.18,56.26','In basement'}
G[50068]={'198:42.66,45.71'}
G[50082]={'198:43.55,45.89 N:40997'}
G[50084]={'198:41.18,42.59'}
G[50140]={'111:58.25,62.16'}
G[50263]={'83:61.87,74.66'}
G[50270]={'322:49.9,89.7 N:39887'}
G[50272]={'322:49.9,89.1 322:49.9,89.7 322:50,90.9 322:50,91.5 N:40917'}
G[50366]={'83:59.68,50.48'}
G[50367]={'76:50.70,73.90'}
G[50371]={'202:57.91,75.55'}
G[50385]={'293:18.80,55.61 241:19.18,54.01>293'}
G[50387]={'293:19.80,52.55 241:19.18,54.01>293 N:45562'}
G[50390]={'293:19.22,55.45 241:19.18,54.01>293 N:45522'}
G[50401]={'249:45.57,57.76'}
G[50480]={'84:63.77,61.53'}
G[50482]={'85:25.1,90.1 85:71.4,36.3 85:71.8,36.7 85:71.9,36.1 85:72.4,35.4 85:72.5,36.2'}
G[50587]={'81:53.28,33.50'}
G[50588]={'81:53.57,33.35'}
G[50601]={'27:62.55,53.80'}
G[50622]={'241:53.96,41.90'}
G[50631]={'27:76.19,53.04'}
G[50690]={'89:37.64,80.43'}
G[51287]={'245:53.8,80.4 245:54.3,80.7 245:54.5,80.2 245:54.5,80.8'}
G[51288]={'245:74.56,60.93'}
G[51574]={'HM 50:52.05,63.55'}
G[51575]={'HM 76:60.79,53.48'}
G[51582]={'HM 50:40.59,50.94'}
G[51585]={'HM 15:19.00,56.18'}
G[51586]={'HM 199:48.33,72.23'}
G[51587]={'HM 199:40.85,67.79'}
G[51588]={'HM 65:49.30,51.33'}
G[51602]={'HM 51:70.25,15.73'}
G[51603]={'HM 17:46.23,13.78'}
G[51604]={'HM 22:29.17,57.35'}
G[51606]={'HM 78:59.86,63.24'}
G[51607]={'HM 78:56.32,66.34'}
G[51639]={'88:21.96,18.83'}
G[51650]={'HM 241:47.26,28.97'}
G[51651]={'HM 241:53.13,46.18'}
G[51652]={'HM 249:53.15,34.53'}
G[51653]={'HM 249:53.59,31.85'}
G[51664]={'77:36.36,58.26'}
G[51665]={'HW 37:32.04,50.51 N:35873'}
G[51677]={'Near83'}
G[51682]={'HM 198:62.82,22.72'}
G[51697]={'HM 205:49.35,42.00'}
G[51698]={'HM 207:49.40,51.32'}
G[51934]={'37:32.35,50.88'}
G[51988]={'84:56.32,53.99'}
G[51989]={'86:57.97,57.61'}
G[52015]={'245:75.00,60.37'}
G[52019]={'325:29.25,38.64'}
G[52053]={'337:31.77,24.11'}
G[52064]={'HW 37:32.09,50.60'}
G[52122]={'338:70.2,40.6'}
G[52135]={'338:47.01,91.38 N:33091'}
G[52192]={'10:44.33,25.10'}
G[52207]={'10:47.53,39.58'}
G[52219]={'198:24.49,60.90'}
G[52234]={'Near50'}
G[52258]={'337:0.00,0.00'}
G[52281]={'50:52.88,67.35 50:52.58,66.51 50:53.16,65.87 N:44019'}
G[52286]={'337:0.00,0.00'}
G[52292]={'89:43.95,78.87'}
G[52294]={'50:44.13,22.91 N:715'}
G[52309]={'10:41.07,39.21'}
G[52319]={'998:55.29,50.25'}
G[52346]={'50:50.37,21.74'}
G[52371]={'50:76.09,66.65 N:52346','In cave'}
G[52374]={'50:76.09,66.66'}
G[52382]={'86:48.76,70.15'}
G[52408]={'84:49.53,87.50','In tower'}
G[52410]={'50:47.75,12.00 N:469'}
G[52444]={'338:42.52,59.69 N:41006'}
G[52467]={'338:48.54,86.25 N:40331'}
G[52476]={'338:50.94,87.38'}
G[52477]={'338:36.01,59.01 N:40278'}
G[52478]={'338:35.79,59.38 N:39925'}
G[52488]={'338:43.80,88.96'}
G[52489]={'338:50.64,87.26'}
G[52490]={'338:43.04,80.58 N:40997'}
G[52491]={'338:34.50,56.23 N:41003'}
G[52492]={'338:36.29,56.35 N:41005'}
G[52493]={'338:47.55,90.54 N:40139'}
G[52494]={'338:64.88,67.25'}
G[52562]={'69:68.65,73.06'}
G[52624]={'337:0.00,0.00'}
G[52646]={'210:55.30,41.95'}
G[52651]={'88:36.8,59.6'}
G[52654]={'84:25.93,29.29 N:52234'}
G[52657]={'88:35.6,53.8'}
G[52669]={'198:27.17,62.56 N:39928'}
G[52671]={'198:27.10,62.02 N:39930'}
G[52730]={'337:49.34,39.09'}
G[52753]={'50:47.86,11.86'}
G[52767]={'210:41.03,73.13 N:38966',}
G[52793]={'198:60.31,29.86 N:40289'}
G[52823]={'338:52.99,90.91'}
G[52824]={'338:45.58,85.81'}
G[52835]={'114:34.40,25.20'}
G[52838]={'198:27.08,54.48 N:5769'}
G[52844]={'198:26.80,62.15 N:40139'}
G[52845]={'198:27.36,55.23 N:33091'}
G[52906]={'198:26.00,61.28 N:52488'}
G[52921]={'338:66.09,63.97'}
G[52924]={'333:14.19,52.92 N:38966'} -- at end of dungeon is 781:93.33,53.59
G[52925]={'333:13.76,51.83'}
G[52933]={'333:13.74,54.06'}
G[52937]={'198:27.55,62.43'}
G[52986]={'198:27.53,62.50'}
G[52995]={'198:62.10,23.07'}
G[53009]={'114:46.6,35.6 N:24848'}
G[53023]={'X 337:30.75,47.14 50:72.09,32.91>337'}
G[53024]={'X 337:30.59,47.32 50:72.09,32.91>337'}
G[53043]={'X 337:30.51,50.95 50:72.09,32.91>337'}
G[53056]={'338:57.48,49.46'}
G[53073]={'198:27.49,61.58 198:27.14,61.65 198:26.86,61.77'} -- some days he wanders, others he is just in another place
G[53080]={'338:46.88,89.99 N:41492'}
G[53081]={'86:32.62,68.15 N:52234'}
G[53149]={'114:31,24 N:24848'}
G[53151]={'X 337:30.83,47.28 50:72.09,32.91>337'}
G[53196]={'338:46.76,90.18 N:29428'}
G[53210]={'114:31,24 N:24848'}
G[53214]={'338:46.91,90.00'}
G[53215]={'114:23,30.8 N:24848'}
G[53233]={'338:51.89,30.98 N:39925'}
G[53259]={'338:34.30,56.43'}
G[53304]={'338:36.23,56.58 N:29428'}
G[53310]={'338:50,50'}
G[53349]={'114:23.2,22.8 N:24848'}
G[53352]={'84:26.22,29.27'}
G[53365]={'338:50,86 N:52824'}
G[53371]={'86:50,77'}
G[53385]={'338:47.14,90.42 N:33091'}
G[53422]={'86:48.6,71.8 84:54,56'}
G[53466]={'84:54,56 N:53371'}
G[53519]={'249:34.26,77.56 N:35875'}
G[53524]={'249:47.65,88.91'}
G[53528]={'998:62.66,35.48'}
G[53566]={'378:56.67,18.17'}
G[53567]={'370:60.58,21.42 N:52835'} -- 520:60,21
G[53652]={'204:69.81,34.19 N:35875'}
G[53677]={'204:69.54,34.30'}
G[53738]={'207:56.52,12.50 N:35875'}
G[53763]={'998:68.86,7.86'}
G[53783]={'198:19.59,36.38'}
G[53881]={'338:44.08,86.34'}
G[53882]={'338:44.42,88.81'}
G[53925]={'338:51.45,25.79 N:35875'}
G[53949]={'84:60.06,75.13'}
G[53950]={'84:24.04,44.81'}
G[54004]={'86:48.13,46.86'}
G[54014]={'338:49.60,31.77 N:35875'}
G[54021]={'84:64.17,46.28'}
G[54117]={'84:58.89,52.73'}
G[54118]={'84:65.16,33.46 N:54021'}
G[54135]={'378:38.80,25.49','In cave'}
G[54141]={'86:54.42,77.63'}
G[54142]={'1:57.33,9.01 N:53950'}
G[54146]={'86:58.05,48.42'}
G[54163]={'338:66,65 N:29428'}
G[54168]={'198:60.22,29.83 N:4949'}
G[54233]={'114:46,34.8'}
G[54312]={'198:60.22,30.12 N:35875'}
G[54313]={'198:60.63,31.46 N:4949'}
G[54314]={'198:49.10,19.58 N:38917'}
G[54334]={'HF 84:62.11,32.18 84:62.27,72.97 87:27.52,73.32 89:38.56,49.39 111:52.02,29.14 125:49.90,50.37'} -- another one wanders SW
G[54393]={'198:27.75,63.63'}
G[54432]={'402:81.23,23.95'}
G[54476]={'402:79.59,44.97'}
G[54485]={'HF 407:51.63,77.85'}
G[54548]={'400:48.70,19.73 N:4949'}
G[54567]={'378:55.09,32.54'}
G[54568]={'378:50.23,21.27'}
G[54590]={'400:56.8,27.8'}
G[54601]={'HF 407:53.29,54.37'}
G[54603]={'347:48.45,68.07 100:47.63,53.57>347'}
G[54605]={'HF 407:50.69,65.13'}
G[54606]={'347:48.45,68.07 100:47.63,53.57>347 N:17493'}
G[54608]={'378:57.54,34.69 N:53566'}
G[54609]={'378:50.27,21.48 N:53566'}
G[54614]={'371:46.13,84.57'}
G[54615]={'371:50.41,88.26'}
G[54616]={'371:43.59,90.68'}
G[54617]={'371:45.17,94.98'}
G[54629]={'261:50.94,90.22 100:46.03,51.79>261'}
G[54636]={'261:50.94,90.22 100:46.03,51.79>261'}	-- location is just a guess until horde can verify
G[54667]={'265:18.81,11.18 102:48.94,35.80>265'}
G[54668]={'265:17.86,12.08 102:48.94,35.80>265'}
G[54674]={'262:31.47,65.28 102:54.14,34.39>262'}
G[54675]={'262:30.86,65.22 102:54.14,34.39>262 N:54667'}
G[54678]={'262:29.53,64.43 102:54.14,34.39>262'}
G[54692]={'272:34.41,19.47 108:39.63,57.67>272 N:19670'}
G[54694]={'272:32.73,19.43'}
G[54697]={'371:43.49,75.92'}
G[54698]={'256:46.2,23.6 108:34.34,65.61>256'}
G[54725]={'256:44.21,71.01 108:34.34,65.61>256'}
G[54751]={'401:52.12,44.47 N:54476'}
G[54786]={'378:51.41,46.38 N:53566'}
G[54787]={'378:39.40,29.54'}
G[54840]={'258:72.16,35.50 108:44.91,65.61>258'}
G[54847]={'258:47.86,67.01 108:44.91,65.61>258'}
G[54848]={'263:17.88,27.27 102:50.40,33.35>263 N:54667'}
G[54849]={'263:17.48,25.92 102:50.40,33.35>263 N:54678'}
G[54851]={'263:18.83,27.67 102:50.40,33.35>263'}
G[54854]={'371:43.32,76.01'}
G[54870]={'86:48.58,70.56'}
G[54890]={'260:21.28,13.10 108:39.63,73.54>260'}
G[54891]={'260:22.58,12.49 108:39.63,73.54>260'}
G[54913]={'371:45.01,24.96'}
G[54914]={'371:45.21,25.06'}
G[54915]={'371:41.62,23.69'}
G[54917]={'371:41.60,28.33'}
G[54918]={'371:38.94,24.08'}
G[54922]={'371:43.26,24.72'}
G[54926]={'371:43.10,23.60'}
G[54931]={'246:58.61,88.44 100:47.68,51.99>246 N:17493'}
G[54932]={'246:58.8,88.8 100:47.68,51.99>246 N:54636'}
G[54933]={'246:58.61,88.44 100:47.68,51.99>246 N:54603'}
G[54934]={'246:58.62,88.60 100:47.68,51.99>246 N:54629'}
G[54938]={'399:0.00,0.00'}
G[54943]={'378:55.09,32.82'}
G[54960]={'371:58.89,81.48'}
G[54961]={'371:53.66,91.41'}
G[54968]={'400:40,52.6'}
G[54969]={'398:87.34,50.04'}
G[54971]={'399:46.79,44.93 N:4949'}
G[54975]={'378:65.59,42.58 N:54567'}
G[54998]={'371:49.65,45.83'}
G[55007]={'349:42.61,87.19'}
G[55009]={'371:41.03,73.97 N:54697'}
G[55020]={'378:70.62,38.72'}
G[55021]={'378:63.44,41.91'}
G[55054]={'1:63.52,0.01 N:54870'}	-- TODO: Attempt to get the real location on Hellscream's Fist which reports as 4:0,0
G[55084]={'371:41.01,74.08'}
G[55094]={'371:38.01,23.79'}
G[55122]={'371:58.07,80.65'}
G[55135]={'371:30.74,10.21 N:54870'}
G[55136]={'246:67.20,51.70 100:47.68,51.99>246 N:17493'}
G[55138]={'246:67.20,51.70 100:47.68,51.99>246 N:54603'}
G[55172]={'371:28.42,24.94 N:54870'}
G[55180]={'371:28.19,24.82'}
G[55196]={'371:54.18,82.41'}
G[55209]={'371:43.21,75.94'}
G[55210]={'HL 249:31.59,62.99'}
G[55211]={'HL 249:65.52,18.68'}
G[55216]={'HL 207:27.71,69.17'}
G[55217]={'HL 207:49.70,54.88'}
G[55218]={'HL 241:51.87,33.07'}
G[55219]={'HL 241:50.91,70.45'}
G[55224]={'HL 198:26.69,62.05'}
G[55227]={'HL 198:62.54,22.82'}
G[55228]={'HL 205:57.25,86.14'}
G[55234]={'371:46.65,46.15'}
G[55274]={'371:38.66,42.25 N:55234'}	-- TODO: Probably should be a Near, but would like specific area if we can put that capability in place
G[55282]={'371:58.86,81.78 N:54616'}
G[55283]={'371:58.93,81.93'}
G[55284]={'371:59.07,81.89'}
G[55333]={'371:58.98,81.83 N:54617'}
G[55382]={'HF 21:75.48,3.27 86:48.22,62.16 88:43.93,52.60 998:62.06,46.93 111:51.80,29.25 110:74.32,81.89 125:50.27,50.40 N:54334'}
G[55403]={'371:31.14,17.53'}
G[55413]={'371:46.56,45.62 N:55234','Running all around town'}
G[55438]={'371:48.67,24.94'}
G[55477]={'378:68.88,64.97 N:54568'}
G[55478]={'378:69.13,66.65 N:55021'}
G[55479]={'378:68.11,66.40'}
G[55497]={'Near371 N:55403'}
G[55521]={'371:31.14,21.58'}
G[55531]={'129:36.06,81.20'}
G[55532]={'398:84.43,56.05'}
G[55535]={'129:35.25,80.93'}
G[55536]={'129:37.30,81.66 N:55535'}
G[55537]={'129:36.14,83.00 N:55535'}
G[55564]={'159:14.92,83.88 115:26.01,50.83>157'}
G[55583]={'378:30.96,36.73 N:54568'}
G[55585]={'378:29.90,39.77 N:55021'}
G[55586]={'378:30.00,60.36 N:53566'}
G[55588]={'378:31.82,39.70'}
G[55592]={'378:24.64,69.79'}
G[55595]={'378:32.94,35.61 N:54567'}
G[55614]={'371:44.25,15.01'}
G[55624]={'398:27.24,64.21 N:54476'}
G[55646]={'371:28.65,47.46 N:55180'}
G[55647]={'371:28.64,47.38'}
G[55648]={'371:28.60,47.43'}
G[55658]={'132:26.62,50.61'}
G[55672]={'378:19.46,51.23 N:53566'}
G[55677]={'160:35.50,83.17 121:28.53,86.94>160 N:26664'}
G[55737]={'154:36.52,35.09 121:81.22,28.88>153 N:30676'}
G[55738]={'154:57.32,34.60 121:76.27,21.19>153 N:30671'}
G[55768]={'371:27.59,32.68 N:54961'}
G[55788]={'371:52.60,38.12'}
G[55789]={'84:78.80,39.99 N:54617'}	-- 301:26.11,20.63 (location prior to new MoP quests)
G[55809]={'371:45.71,43.70'}
G[55828]={'371:28.62,47.48'}
G[55835]={'140:35.75,34.95 120:39.54,26.92>140'}
G[55940]={'378:42.28,86.34 N:55021'}
G[55942]={'378:36.36,72.51 N:54568'}
G[55943]={'378:50.09,76.66'}
G[55944]={'378:42.21,86.53'}
G[55963]={'371:44.25,15.01 N:55614'}
G[56012]={'378:51.31,48.29 N:55588'}
G[56013]={'378:51.44,48.29'}
G[56027]={'138:11.68,53.71 120:45.37,21.39>138'}
G[56062]={'371:46.46,45.81'}
G[56063]={'371:55.31,45.32'}
G[56064]={'371:54.89,45.31'}
G[56065]={'371:54.56,44.41'}	-- 806:54.92,45.12
G[56072]={'137:45.07,18.05 117:57.25,46.59>136'}
G[56110]={'376:84.08,21.03 N:54926'}
G[56111]={'376:19.87,56.92 N:54913'}
G[56112]={'418:60.08,25.00'}
G[56113]={'376:61.14,34.30'}
G[56114]={'418:67.36,32.74 N:56112'}
G[56115]={'418:76.21,7.07'}
G[56133]={'376:85.94,22.11'}
G[56138]={'376:68.88,43.30'}
G[56204]={'376:83.69,21.02'}
G[56205]={'376:75.21,24.05'}
G[56207]={'376:81.45,25.01'}
G[56208]={'376:78.12,32.90'}
G[56222]={'371:58.97,81.70 N:55196'}
G[56287]={'371:53.78,90.63 N:54961'}
G[56312]={'376:78.18,32.81'}
G[56313]={'371:26.27,37.33'}
G[56327]={'371:25.96,38.73'}
G[56329]={'371:33.35,42.21'}
G[56336]={'371:27.99,47.18'}
G[56339]={'371:28.26,47.78 N:54870'}
G[56345]={'371:50.91,27.07 N:54961'}
G[56346]={'371:50.94,27.03'}
G[56347]={'371:45.43,29.14 372:60.88,37.06'}
G[56348]={'371:47.14,46.16'}
G[56351]={'371:25.88,38.00'}
G[56358]={'371:27.03,50.84'}
G[56364]={'371:59.00,81.99 N:81280'}
G[56366]={'371:58.97,81.69 N:55196'}
G[56406]={'371:28.30,47.79 N:55521'}
G[56416]={'378:36.49,84.23 N:54567'}
G[56418]={'378:39.30,86.22 N:54568'}
G[56432]={'371:65.98,79.28'}
G[56433]={'371:65.98,79.38'}
G[56434]={'371:65.91,79.27 N:1747'}
G[56439]={'429:68.33,57.97'}
G[56440]={'376:82.70,21.22'}
G[56465]={'376:82.66,25.55'}
G[56467]={'371:46.30,29.40 N:56347'}
G[56474]={'376:68.71,43.12'}
G[56490]={'Near371 N:54870'}
G[56525]={'371:28.98,49.08 N:55521'}
G[56541]={'446:20.80,22.12 N:63009'}
G[56611]={'376:68.79,43.25 N:56133'}
G[56662]={'378:15.79,49.11 N:54567'}
G[56707]={'371:46.28,45.46'}
G[56708]={'371:52.58,38.11'}
G[56714]={'376:18.29,31.22'}
G[56720]={'376:19.54,56.88'}
G[56737]={'371:57.95,82.51'}
G[56773]={'376:60.60,33.68'}
G[56774]={'371:45.77,44.00'}
G[56782]={'371:58.13,58.66'}
G[56784]={'371:58.03,59.01'}
G[56786]={'371:56.26,60.44'}
G[56787]={'371:57.53,56.01'}
G[56802]={'376:59.82,27.94'}
G[56832]={'376:64.89,26.94'}
G[56833]={'376:65.47,26.06'}
G[56866]={'376:61.14,34.30 N:56113'}
G[56877]={'437:47.32,65.45'}
G[56884]={'444:69.85,45.33 N:60688'}
G[56899]={'36:54.11,23.86'}
G[57108]={'371:28,47 N:54870'}
G[57198]={'376:11.60,49.53'}
G[57209]={'376:52.60,62.96'}
G[57211]={'376:52.73,62.98'}
G[57242]={'371:55.84,57.08'}
G[57250]={'376:68.81,43.50 N:56133'}
G[57298]={'376:52.95,51.59'}
G[57319]={'371:53.89,61.91'}
G[57324]={'371:53.91,61.94'}
G[57385]={'376:38.58,51.72'}
G[57401]={'376:44.16,34.23'}
G[57402]={'376:44.63,34.05'}
G[57405]={'376:62.66,59.74'}
G[57407]={'376:63.62,58.52'}
G[57408]={'376:41.32,38.13','Underground'}
G[57424]={'376:63.55,58.43'}
G[57706]={'376:32.12,68.33 N:56133'}
G[57707]={'376:32.31,68.45 N:56138'}
G[57708]={'376:32.23,68.47 N:56474'}
G[57739]={'378:38.78,86.33 N:54568'}
G[57744]={'418:75.84,7.60'}
G[57864]={'402:79.65,45.14'}
G[57913]={'398:87.33,49.29 N:10667'}
G[57934]={'376:55.88,49.42 N:56133'}
G[58113]={'418:59.88,24.68'}
G[58114]={'418:59.87,24.81'}
G[58149]={'160:37.18,80.52 121:28.53,86.94>160 N:26500'}
G[58160]={'418:68.80,22.24'}
G[58206]={'Near418 N:56112'}
G[58225]={'371:65.35,31.67'}
G[58228]={'371:57.55,45.10'}
G[58278]={'418:29.68,39.05'}
G[58376]={'418:81.29,6.82'}
G[58379]={'418:76.27,7.12 N:56115'}
G[58408]={'390:56.72,43.57'}
G[58413]={'371:57.33,45.34'}
G[58420]={'371:58.61,43.65'}
G[58421]={'376:16.00,82.48 N:18180'}
G[58422]={'376:16.07,82.62 N:715'}
G[58434]={'376:15.90,82.25'}
G[58444]={'371:58.58,43.65 N:58420'}
G[58465]={'390:33.98,38.00'}
G[58467]={'390:56.79,43.26'}
G[58468]={'390:56.74,42.65'}
G[58469]={'390:56.69,43.14 N:59343'}
G[58470]={'390:56.54,43.21 N:59342'}
G[58471]={'390:33.67,38.40'}	-- *** after Golden Lotus revamp we have: [58471]={58471,'811:21.30,71.50'}
G[58503]={'390:33.97,38.13 N:58465'}
G[58504]={'390:34.06,38.13 N:58471'}
G[58506]={'371:58.02,43.71'}
G[58508]={'371:57.48,44.02'}
G[58509]={'371:58.26,45.05'}
G[58510]={'371:58.47,44.70'}
G[58511]={'371:57.29,43.47'}
G[58547]={'418:44.18,42.94'}
G[58562]={'376:52.22,48.67'}
G[58563]={'376:52.23,48.66'}
G[58564]={'371:57.76,45.07'}
G[58567]={'376:52.01,48.34'}
G[58590]={'435:0.00,0.00'}
G[58607]={'418:15.98,39.79 N:58113'}
G[58609]={'418:40.48,34.65 N:1747'}
G[58630]={'418:29.06,51.14'}
G[58632]={'431:0.00,0.00'}
G[58646]={'376:52.74,47.94'}
G[58647]={'376:53.04,51.71'}
G[58704]={'390:18.11,63.56'}
G[58705]={'376:52.76,51.84'}
G[58706]={'376:53.17,51.79'}	-- probably need to make this a SELLS instead of HAS (so we do not try to kill)
G[58707]={'376:53.07,51.86'}
G[58708]={'376:53.12,52.05'}
G[58709]={'376:34.42,46.76'}
G[58710]={'376:53.56,52.57'}
G[58712]={'376:52.98,51.34'}
G[58713]={'376:52.67,51.99'}
G[58714]={'376:52.60,51.63'}
G[58715]={'376:52.58,51.71'}
G[58716]={'376:53.40,51.60'}
G[58717]={'376:53.18,52.24'}
G[58718]={'376:52.89,52.13'}
G[58721]={'376:52.01,48.02 N:58646'}
G[58723]={'376:51.98,48.02 N:58646'}
G[58735]={'418:67.44,32.70'}
G[58736]={'376:60.97,32.85'}
G[58743]={'390:18.48,71.53'}
G[58745]={'418:67.45,32.63'}
G[58761]={'376:45.10,33.78'}
G[58779]={'418:67.63,25.73'}
G[58785]={'Near376 N:56474'}
G[58814]={'Near418 N:56112'}
G[58818]={'390:33.84,70.44'}
G[58819]={'390:35.37,74.06'}
G[58820]={'390:33.77,69.68'}
G[58821]={'418:24.71,34.04 N:58735'}
G[58843]={'376:20.30,58.67'}
G[58911]={'390:35.27,74.86 N:59333'}
G[58919]={'390:21.47,71.59 N:58465'}
G[58920]={'390:21.39,71.45 N:58471'}
G[58945]={'371:27.58,24.25'}
G[58954]={'418:15.70,39.71'}
G[58962]={'390:20.45,73.51 390:20.05,75.63','Moves between spots'}
G[58970]={'418:24.70,33.99 N:58745'}
G[59022]={'371:54.21,82.49 N:55122'}
G[59048]={'418:25.14,33.46'}
G[59049]={'418:67.76,32.49'}
G[59058]={'371:58.76,81.28'}
G[59073]={'379:72.27,91.85'}
G[59074]={'442:46.56,50.07 442:38.82,56.28'}	-- second position is after he moves if you are not quick enough
G[59076]={'379:70.74,90.36'}
G[59077]={'379:71.57,92.83'}
G[59080]={'479:49.46,36.78'}
G[59119]={'376:31,29'}
G[59120]={'376:29.82,28.74'}
G[59121]={'376:30,42'}
G[59123]={'376:29.75,33.97'}
G[59124]={'376:32.72,30.44'}
G[59138]={'418:40.60,33.69 N:58547'}
G[59150]={'431:0.00,0.00'}
G[59173]={'371:46.92,45.99','Pacing back and forth'}
G[59178]={'371:46.63,45.32 N:55788'}
G[59186]={'371:47.05,46.24'}
G[59188]={'418:40.63,33.73 N:1747'}
G[59189]={'418:40.43,34.70 N:1747'}
G[59254]={'371:52.59,38.09 N:55788'}
G[59263]={'379:74.96,88.86'}
G[59272]={'379:74.67,76.92'}
G[59273]={'379:74.78,88.68'}
G[59332]={'390:33.82,38.50 N:58408'}
G[59333]={'390:33.40,38.04'}
G[59334]={'390:33.13,38.98 N:58468'}
G[59335]={'379:69.98,70.54'}
G[59336]={'390:35.29,76.75 N:58819'}
G[59337]={'390:35.12,75.37 N:58468'}
G[59338]={'390:33.87,72.22 N:58467'}
G[59340]={'390:21.48,71.18 N:58408'}
G[59341]={'390:42.23,45.93'}
G[59342]={'390:43.67,46.09'}
G[59343]={'390:42.32,46.00'}
G[59353]={'379:71.76,70.28'}
G[59354]={'379:71.36,69.30'}
G[59371]={'379:64.70,61.75'}
G[59374]={'381:65.93,60.40 N:59354'}
G[59377]={'371:28.2,46.8 N:54961'}
G[59383]={'371:48.32,46.06'}
G[59391]={'371:48.31,61.35'}
G[59402]={'379:65.49,60.82'}
G[59405]={'379:64.24,61.38'}
G[59411]={'371:44.77,67.09 N:54961'}
G[59418]={'371:49.29,61.47 N:54961'}
G[59441]={'379:71.54,93.08 N:55122','Upstairs'}
G[59442]={'379:71.64,93.11 N:54870','Upstairs'}	-- ?? 809:62.98,80.19
G[59448]={'379:62.76,79.83 N:55521'}
G[59449]={'379:62.68,80.67 N:55180'}
G[59450]={'379:54.17,83.27 N:54616'}
G[59451]={'379:53.67,83.27 N:54614'}
G[59452]={'379:51.97,67.25'}
G[59479]={'442:43.23,44.79'}
G[59492]={'371:43.83,12.53 N:55614'}
G[59533]={'376:42.39,50.00'}
G[59550]={'371:58.56,82.30 N:54616'}
G[59569]={'371:38.82,31.22'}
G[59573]={'379:60.24,85.78'}
G[59584]={'418:67.93,45.23'}
G[59585]={'376:55.59,52.07'}
G[59586]={'418:67.56,43.51'}
G[59597]={'379:64.88,60.49'}
G[59608]={'Near418 N:1747'}
G[59620]={'371:58.85,81.12 N:54961'}
G[59636]={'379:60.17,85.91'}
G[59639]={'376:45,28'}
G[59695]={'379:57.71,61.75'}
G[59696]={'379:57.22,61.20'}
G[59701]={'379:58.09,61.46'}
G[59703]={'379:51.66,67.83'}
G[59704]={'439:75.01,36.13 N:56133'}
G[59716]={'379:57.32,60.19'}
G[59719]={'418:40.42,49.24'}
G[59727]={'371:54.57,61.76'}
G[59732]={'371:57.01,44.03'}
G[59733]={'371:55.38,23.73'}
G[59735]={'371:50.82,26.80'}
G[59736]={'371:43.58,24.54'}
G[59755]={'379:42.45,68.91'}
G[59806]={'379:49.09,70.38 N:59452'}
G[59821]={'379:59.63,78.26'}
G[59822]={'439:76.90,35.23'}
G[59855]={'376:17.97,56.44 N:57744'}
G[59856]={'376:17.99,55.89 N:56714'}
G[59894]={'379:52,67.2'}
G[59899]={'371:49.30,61.42 N:56784'}
G[59905]={'390:57.26,42.99'}
G[59906]={'390:74.17,41.82 N:63266'}
G[60021]={'376:18.16,55.82 N:56474'}
G[60042]={'378:50.22,76.63'}
G[60055]={'378:36.31,72.35'}
G[60135]={'418:67.62,42.50'}
G[60136]={'418:67.49,44.59'}
G[60139]={'418:45.99,78.91'}
G[60161]={'379:44.48,89.92'}
G[60173]={'418:51.53,76.85'}
G[60175]={'379:48.14,49.04'}
G[60178]={'379:42.94,88.32'}
G[60182]={'418:51.65,75.29'}
G[60230]={'376:84.50,21.06'}
G[60231]={'376:56.49,50.36'}
G[60232]={'418:76.74,8.38'}
G[60289]={'418:52.43,77.98'}
G[60299]={'418:45.35,84.05'}
G[60358]={'418:42.27,89.84'}
G[60416]={'379:42.81,69.63'}
G[60422]={'418:51.56,77.42'}
G[60436]={'379:63.17,29.38'}
G[60441]={'418:52.47,76.60'}
G[60491]={'Z379'}
G[60503]={'379:42.42,69.65'}
G[60506]={'418:31.34,63.42'}
G[60528]={'418:31.29,63.59'}
G[60529]={'418:31.36,63.62'}
G[60564]={'379:36.47,77.02'}
G[60566]={'84:74.20,91.99 N:54567'}
G[60570]={'1:45.6,12.6 N:54568'}
G[60578]={'429:35.91,44.60 371:56.18,57.87>429'}
G[60585]={'456:80.53,55.99'}
G[60588]={'418:31.31,63.58 N:60506'}
G[60596]={'379:42.36,69.79'}
G[60622]={'388:67.94,67.67'}
G[60673]={'418:68.35,42.09'}
G[60674]={'418:68.34,43.49'}
G[60675]={'418:67.21,41.14'}
G[60677]={'379:40.31,81.53'}
G[60678]={'379:40.27,81.57'}
G[60679]={'379:42.49,69.32'}
G[60684]={'388:67.25,52.22'}
G[60687]={'388:67.20,52.28'}
G[60688]={'388:71.15,56.69'}
G[60694]={'379:60.61,21.35'}
G[60735]={'388:66.98,51.42'}
G[60757]={'379:67.04,33.34 N:60694'}
G[60785]={'379:60.61,21.35 N:60694'}
G[60795]={'379:43.79,51.05 N:54961'}
G[60857]={'388:67.94,67.68 N:60622'}
G[60864]={'388:82.59,73.02'}
G[60871]={'388:71.18,56.74 N:60688'}
G[60903]={'388:82.71,73.16'}
G[60951]={'388:82.69,73.10 N:60903'}
G[60968]={'379:67.23,55.91 379:70.27,51.27 379:71.76,44.90 379:66.41,46.34 379:68.48,44.60'}	-- Xuen exists in more than one place at the same time, though logically, one probably will get the next fight in the round from the nearest one
G[60970]={'371:58.86,81.67 N:55122'}
G[60973]={'379:75.13,87.93'}
G[60981]={'379:68.54,56.42 N:54913'}
G[61016]={'388:61.58,79.35'}
G[61020]={'388:51.67,87.25'}
G[61021]={'388:76.42,82.53'}
G[61026]={'376:36.19,68.29'}
G[61065]={'Near379 N:60973'}
G[61066]={'388:76.42,82.43 N:60688'}
G[61097]={'379:48.11,48.99 N:60175'}
G[61118]={'379:66.30,50.67'}
G[61121]={'390:84.62,62.42'}
G[61161]={'388:39.21,62.01'}
G[61203]={'448:52.38,68.07 N:62321'}
G[61218]={'371:54.02,91.19 N:54961'}
G[61261]={'388:82.68,73.02 N:60687'}
G[61297]={'Near379'}
G[61371]={'379:62.33,29.05 N:54961'}
G[61398]={'455:39.18,75.02'}
G[61454]={'379:29.27,62.26 N:60684'}
G[61467]={'388:79.38,84.45'}
G[61468]={'388:79.46,84.48 N:61021'}
G[61469]={'388:76.93,78.78 N:61021'}
G[61470]={'388:75.86,83.14'}
G[61473]={'379:43.91,89.55'}
G[61474]={'379:72.54,94.17'}
G[61482]={'388:49.14,71.23'}
G[61485]={'458:50.35,44.23'}
G[61495]={'379:63.44,28.73','Upstairs'}
G[61496]={'379:63.36,30.63'}
G[61503]={'379:63.73,30.71'}
G[61504]={'379:57.73,59.70'}
G[61511]={'379:62.43,30.12'}
G[61512]={'379:34.54,59.12'}
G[61528]={'213:33.97,77.51'}
G[61534]={'Near379 N:61503'}
G[61539]={'388:43.86,65.76'}
G[61580]={'388:39.35,62.29'}
G[61581]={'388:39.34,62.21'}
G[61583]={'388:38.80,62.39'}
G[61584]={'388:39.42,61.96'}
G[61585]={'388:39.15,62.07'}
G[61621]={'379:74.67,76.87 N:59272'}
G[61625]={'388:49.20,71.31'}
G[61636]={'480:50.28,82.49'}
G[61693]={'381:64.64,60.92 N:59354'}
G[61716]={'213:67.95,11.30'}
G[61724]={'213:68.14,11.58'}
G[61744]={'379:53.98,84.26'}
G[61759]={'433:56.72,75.74'}
G[61796]={'84:82.60,28.10 N:29611'}
G[61816]={'379:34.96,59.40'}
G[61819]={'379:31.29,61.51 N:60687'}	-- 809:35.12,59.66
G[61820]={'379:29.24,62.30 N:61016'}
G[61822]={'213:68.31,12.80'}
G[61823]={'213:69.36,10.92'}
G[61847]={'379:57.34,61.69 N:54961'}
G[61850]={'379:57.34,61.69 N:54961'}
G[61880]={'388:70.34,86.66'}
G[61881]={'388:70.46,86.37'}
G[61962]={'390:83.27,29.68 N:54961'}
G[61970]={'422:62.05,56.76'}
G[62092]={'86:70.62,31.38 N:25237'}
G[62112]={'390:14.15,76.98'}
G[62124]={'388:67.37,80.68'}
G[62151]={'422:54.88,36.16'}
G[62166]={'422:72.56,28.67'}
G[62180]={'422:54.32,36.08'}
G[62202]={'422:70.19,25.64'}
G[62203]={'422:73.68,27.58'}
G[62205]={'459:0.00,0.00'}
G[62216]={'379:31.34,61.61 N:60684'}
G[62227]={'Near379 N:60687'}
G[62232]={'Near422 N:62180'}
G[62236]={'445:83.48,56.20 379:36.70,47.46>443 N:60687'}
G[62273]={'388:61.64,79.33 N:60688'}
G[62274]={'388:54.02,78.06 N:60688'}
G[62275]={'388:47.48,78.87 N:60688'}
G[62278]={'388:53.93,78.12'}
G[62295]={'Near388'}
G[62304]={'388:49.01,70.45 N:60687'}
G[62321]={'371:47.38,37.01'}
G[62322]={'371:48.16,34.59'}
G[62377]={'376:48.31,33.47'}
G[62378]={'Near388 N:60864'}
G[62379]={'Near388'}
G[62385]={'376:44.25,34.20'}
G[62410]={'388:76.37,82.46 N:60688'}
G[62412]={'388:61.10,83.03 N:60688'}
G[62436]={'388:67.32,80.85 N:61021'}
G[62444]={'388:74.27,84.96 N:61021'}
G[62491]={'450:49.59,60.71 N:65289'}
G[62519]={'422:55.11,34.25'}
G[62538]={'422:54.98,34.05 N:62202'}
G[62540]={'422:43.32,63.50'}
G[62547]={'388:49.14,71.23 N:61482'}
G[62573]={'388:51.27,83.03'}
G[62658]={'376:70.82,24.09'}
G[62666]={'422:51.21,11.40'}
G[62667]={'422:50.73,11.71'}
G[62668]={'422:51.16,11.19'}
G[62730]={'388:61.60,79.29 N:61016'}
G[62736]={'388:61.12,83.07 N:60688'}
G[62754]={'422:52.98,12.38'}
G[62767]={'422:27.4,16.0'}
G[62771]={'422:38.64,17.25'}
G[62772]={'422:38.16,17.34'}
G[62774]={'422:54.94,34.13'}
G[62779]={'422:50.44,12.05 N:56133'}
G[62786]={'388:53.99,86.96 N:61020'}
G[62788]={'388:53.99,86.96 N:61020'}
G[62802]={'388:46.12,82.47 N:61021'}
G[62810]={'388:28.86,22.58'}
G[62859]={'422:51.13,11.12'}
G[62871]={'379:72.67,92.34'}
G[62872]={'418:51.52,77.18'}
G[62898]={'388:54.29,79.05'}
G[62901]={'388:71.08,57.32'}
G[62903]={'388:74.39,81.46'}
G[62909]={'388:50.08,71.98'}
G[62917]={'433:55.00,72.32'}
G[62923]={'371:22.87,30.60'}
G[62963]={'422:54.13,20.34 N:56133'}
G[62973]={'422:50.18,10.19 N:56133'}
G[62996]={'391:70.03,46.75'}
G[63009]={'388:49.53,70.51'}
G[63013]={'393:40.28,70.73 390:87.29,69.37'}
G[63014]={'37:40.31,66.01'}
G[63054]={'422:51.16,11.36 N:62666'}
G[63061]={'1:52.71,41.29'}
G[63067]={'7:49.21,56.07'}
G[63070]={'57:55.22,51.34'}
G[63071]={'422:25.70,50.29'}
G[63072]={'422:54.37,35.93'}
G[63073]={'18:60.93,54.32'}
G[63075]={'27:53.83,50.09'}
G[63077]={'97:49.31,52.17'}
G[63080]={'94:47.35,47.35'}
G[63083]={'62:50.12,20.17'}
G[63086]={'86:37.57,79.28'}
G[63145]={'376:51.75,47.77'}
G[63146]={'376:51.88,48.26'}
G[63154]={'376:52.01,48.33'}
G[63156]={'376:51.95,48.32'}
G[63193]={'371:27.56,32.63 N:54961'}
G[63194]={'50:46.01,40.44'}
G[63195]={'Near388 N:61016'}
G[63196]={'Near388'}
G[63197]={'Near388'}
G[63217]={'371:30.85,34.06 N:54961'}
G[63218]={'422:50.19,12.44'}
G[63238]={'469:40.08,35.61'}
G[63258]={'425:41.19,52.13'}
G[63265]={'376:52.00,48.31'}
G[63266]={'390:33.49,40.78'}
G[63272]={'465:53.22,56.84'}
G[63285]={'427:63.21,22.26'}
G[63296]={'461:42.08,68.69 1:42.50,68.85>461'}
G[63307]={'371:28.83,32.62 N:54961'}
G[63310]={'463:52.57,51.85 1:65.79,83.91>463'}
G[63314]={'480:50.00,18.54 N:22893'}
G[63315]={'379:68.69,48.39 N:18471'}
G[63317]={'422:55.65,72.54'}
G[63327]={'462:27.97,28.34'}
G[63328]={'Near422 N:62180'}
G[63331]={'460:48.69,52.46 57:58.72,33.73>460'}
G[63332]={'467:63.42,42.64'}
G[63335]={'468:50.46,48.66 97:79.41,51.61>468'}
G[63349]={'422:54.73,72.16'}
G[63367]={'379:72.65,93.01'}
G[63484]={'433:53.52,65.76'}
G[63497]={'390:14.22,79.28'}
G[63498]={'422:56.10,70.18'}
G[63500]={'422:50.21,12.24'}
G[63501]={'422:55.83,34.87'}
G[63508]={'863:67.17,51.03'}
G[63535]={'379:62.36,79.64'}
G[63542]={'379:56.35,84.39'}
G[63577]={'371:46.84,46.16 N:54961'}
G[63596]={'84:69.49,25.16'}
G[63614]={'388:49.01,71.33'}
G[63622]={'Near388'}
G[63623]={'Near388 N:61021'}
G[63624]={'Near388 N:61020'}
G[63626]={'86:52.56,59.27'}
G[63721]={'418:68.43,43.52 N:12919'}
G[63748]={'371:28.18,38.98'}
G[63750]={'379:62.32,29.06 N:54961'}
G[63751]={'379:62.58,79.48'}
G[63754]={'379:53.78,84.11'}
G[63758]={'422:54.26,35.78 N:62540'}
G[63778]={'376:70.01,23.57 376:55.33,50.15 371:45.72,43.81 376:18.55,56.37'}
G[63784]={'379:62.32,29.06 N:54961'}
G[63785]={'422:54.83,36.20'}
G[63809]={'371:30.76,41.09'}
G[63822]={'376:16.19,82.53'}
G[63876]={'422:43.32,63.50 N:62540'}
G[63955]={'Near422'}
G[63983]={'390:83.64,31.09'}
G[63984]={'390:83.41,31.17'}
G[63994]={'390:61.12,20.88'}
G[63996]={'390:62.03,20.62'}
G[64001]={'390:62.68,23.37'}
G[64002]={'390:62.79,20.88'}
G[64007]={'390:63.18,22.31'}
G[64010]={'390:61.25,23.54'}
G[64011]={'390:60.93,23.68'}
G[64013]={'422:43.32,63.50 N:62540'}
G[64028]={'390:86.44,61.56'}
G[64029]={'390:85.22,62.86'}
G[64030]={'390:84.23,61.44'}
G[64031]={'390:84.20,62.53'}
G[64032]={'390:84.63,63.79'}
G[64033]={'390:86.56,60.06'}
G[64036]={'390:87.15,60.81'}
G[64041]={'391:67.19,38.84'}
G[64047]={'392:57.32,77.26'}
G[64076]={'393:30.93,64.01'}
G[64085]={'390:72.4,50.4'}
G[64101]={'393:43.94,46.65'}
G[64144]={'393:36.72,77.67 390:86.90,70.11'}
G[64149]={'393:35.74,67.30'}
G[64231]={'376:53.58,51.23'}
G[64236]={'388:47.48,78.84 N:60688'}
G[64259]={'422:54.90,72.83'}
G[64310]={'371:43.10,68.49'}
G[64314]={'376:53.88,47.41','In small cave'}
G[64315]={'376:55.14,47.38'}
G[64330]={'37:41.66,83.67'}
G[64337]={'Near'}
G[64344]={'422:41.76,72.03 N:62540'}
G[64361]={'442:50.12,48.56 N:56133'}
G[64387]={'444:68.96,43.16 379:36.70,47.46>443 N:63009'}
G[64395]={'376:53.52,51.18'}
G[64399]={'429:35.99,44.12 371:56.18,57.87>429'}
G[64432]={'453:30.28,19.26 390:80.82,32.72>453 N:63266'}
G[64448]={'376:56.02,51.80'}
G[64457]={'376:55.30,50.62'}
G[64464]={'376:52.72,50.42'}
G[64467]={'437:60.91,88.53 390:15.84,74.39>437 N:62112'}
G[64484]={'390:85.88,62.37'}
G[64488]={'390:84.38,61.67'}
G[64490]={'422:41.76,72.03 N:62540'}
G[64508]={'390:85.50,60.20'}
G[64517]={'458:57.90,22.98'}
G[64521]={'379:68.92,46.48'}
G[64531]={'390:62.42,21.55'}
G[64533]={'390:60.53,21.55'}
G[64534]={'390:63.37,20.80'}
G[64540]={'379:68.78,43.13 N:1747'}
G[64542]={'379:68.73,43.02 N:58113'}
G[64559]={'422:44.57,41.40'}
G[64562]={'476:26.83,58.75'}	-- starting skull location
G[64563]={'476:26.89,58.65 N:64562'}	-- starting skull location
G[64566]={'390:62.92,28.19 N:58113'}
G[64572]={'390:86.59,60.00'}
G[64582]={'390:60.82,23.68'}
G[64596]={'371:46.22,84.78 N:66209'}
G[64597]={'376:54.66,47.04'}
G[64599]={'422:55.02,35.55'}
G[64607]={'388:38.07,64.32'}
G[64610]={'390:83.99,58.64 N:58735'}
G[64616]={'433:54.42,72.58'}
G[64672]={'422:56.26,58.22 N:63785'}
G[64691]={'390:82.11,29.59'}
G[64705]={'422:56.24,57.58 N:63785'}
G[64724]={'422:42.15,33.46'}
G[64738]={'432:39.26,13.39 N:64764'}
G[64764]={'432:39.26,13.39'}
G[64815]={'422:54.77,34.07'}
G[64822]={'433:75.30,76.27 N:64616'}
G[64827]={'435:72.70,46.89 N:64764'}
G[64838]={'435:72.70,46.89 N:64764'}
G[64841]={'436:49.03,78.52 N:64842'}
G[64842]={'436:49.03,78.52'}
G[64854]={'436:49.17,24.82 N:64855'}
G[64855]={'436:49.17,24.82'}
G[64901]={'452:43.72,64.86 N:63367'}
G[64922]={'390:83.45,31.05 N:28070'}
G[65189]={'418:31.15,63.16'}
G[65229]={'422:33.41,62.44'}
G[65253]={'422:31.80,88.94 N:63072'}
G[65289]={'418:51.81,76.06'}
G[65327]={'422:72.55,28.57 N:62166'}
G[65341]={'388:48.66,71.06 N:61539'}
G[65354]={'422:66.82,65.33'}
G[65365]={'422:48.11,49.64 N:64815','In Amberglow Hollow underground'}
G[65395]={'422:54.71,34.76'}
G[65502]={'422:66.29,32.01 A:100088715'}
G[65511]={'422:42.53,55.75'}
G[65528]={'376:83.76,20.18'}
G[65558]={'Near378 N:54568'}
G[65648]={'52:60.86,18.51'}
G[65651]={'49:33.29,52.58'}
G[65655]={'47:19.83,43.69'}
G[65656]={'210:51.46,73.39'}
G[65669]={'371:57.52,45.31'}	-- blue
G[65670]={'371:57.52,45.31 N:65669'}	-- green
G[65671]={'371:57.51,45.29 N:65669'}	-- yellow
G[65690]={'388:51.67,87.32 N:61020'}
G[65865]={'424:42.24,62.33'}
G[65908]={'371:46.62,85.16'}
G[65910]={'371:46.25,84.73'}
G[65998]={'371:31.42,21.77'}
G[65999]={'371:31.66,21.91 N:54870'}
G[66023]={'371:46.04,85.14'}
G[66085]={'376:51.99,48.45'}
G[66126]={'1:43.86,28.86'}
G[66129]={'376:52.03,48.41'}
G[66130]={'376:51.75,48.36'}
G[66135]={'10:58.61,53.04'}
G[66136]={'63:20.20,29.55'}
G[66137]={'65:59.66,71.58'}
G[66190]={'371:31.62,11.32 N:54870'}
G[66199]={'371:39.55,90.03'}
G[66209]={'371:46.22,84.69'}
G[66220]={'371:29.18,13.79'}
G[66225]={'371:27.21,15.71'}
G[66247]={'388:74.83,81.36'}
G[66260]={'379:48.59,42.71'}
G[66292]={'371:42.02,92.82'}
G[66296]={'371:46.25,84.81 N:60688'}
G[66352]={'69:59.69,49.75'}
G[66372]={'66:57.11,45.69'}
G[66409]={'388:49.13,71.50'}
G[66412]={'80:46.00,60.39'}
G[66415]={'379:64.31,61.43'}
G[66422]={'199:39.59,79.14'}
G[66442]={'77:40.03,56.58'}
G[66466]={'83:65.69,64.47'}
G[66478]={'26:62.93,54.65'}
G[66512]={'23:67.01,52.37'}
G[66515]={'32:35.42,27.76'}
G[66518]={'51:76.75,41.39'}
G[66520]={'36:25.55,47.62'}
G[66522]={'42:40.18,76.50'}
G[66550]={'100:64.37,49.31'}
G[66551]={'102:17.20,50.52'}
G[66552]={'107:60.99,49.36'}
G[66553]={'111:58.89,70.03'}
G[66557]={'104:30.49,41.82'}
G[66581]={'371:41.46,79.14 N:54617'}
G[66635]={'117:28.59,33.82'}
G[66636]={'127:50.19,59.05'}
G[66638]={'115:59.02,76.99'}
G[66639]={'121:13.18,66.79'}
G[66646]={'371:34.78,10.63 N:54870'}
G[66656]={'371:33.66,10.61 N:54870'}
G[66657]={'371:33.71,10.60 N:60688'}
G[66659]={'371:30.53,7.49'}
G[66660]={'371:30.55,7.14'}
G[66662]={'371:31.99,13.28'}
G[66665]={'371:29.13,13.84 N:60688'}
G[66667]={'371:31.05,11.02 N:55521'}
G[66675]={'118:77.36,19.61'}
G[66730]={'371:47.97,54.12'}
G[66733]={'418:62.19,45.88'}
G[66734]={'376:46.00,43.69'}
G[66738]={'379:35.84,73.69'}
G[66739]={'422:55.10,37.56'}
G[66741]={'390:31.18,74.14'}
G[66769]={'390:33.98,38.00 N:58465'}
G[66815]={'207:49.92,57.05'}
G[66819]={'198:61.37,32.84'}
G[66822]={'241:56.56,56.84'}
G[66824]={'249:56.58,41.91'}
G[66838]={'371:32.06,13.37 N:66853'}
G[66841]={'371:32.04,13.37 N:66853'}
G[66845]={'371:29.13,13.72'}
G[66848]={'371:29.37,13.58 N:66660'}
G[66853]={'371:32.06,13.38'}
G[66875]={'422:55.14,35.38 N:62774'}
G[66918]={'388:36.30,52.26'}
G[66949]={'371:58.93,81.93 N:54617'}
G[66998]={'391:47.50,69.93'}
G[67091]={'422:31.80,88.94 N:63072'}
G[67138]={'422:50.18,10.19 N:56133'}
G[67153]={'371:28.57,22.16 N:55403'}
G[67370]={'407:47.04,62.75'}
G[67386]={'418:16.51,79.14 N:66292','Aboard Skyfire'}
G[67402]={'418:75.86,34.17'}
G[67414]={'488:56.08,75.20 N:38966'}
G[67436]={'418:39.27,61.86'}
G[67438]={'418:13.90,41.20'}
G[67444]={'418:16.72,78.58 N:54614','Aboard Skyfire'}
G[67447]={'418:12.66,62.73 N:3387'}
G[67498]={'418:13.82,41.23 N:67438'}
G[67503]={'418:39.19,61.96 N:67436'}
G[67508]={'418:56.36,42.16'}
G[67533]={'418:20.60,58.04'}
G[67534]={'418:20.48,58.06'}
G[67535]={'418:13.79,55.85'}
G[67536]={'418:26.05,58.07'}
G[67537]={'418:22.56,62.33'}
G[67542]={'418:25.54,60.47'}
G[67553]={'418:25.25,60.42 N:67533'}
G[67554]={'418:22.38,62.27 N:67533'}
G[67555]={'Near418 N:67436'}
G[67556]={'Near418 N:67438'}
G[67557]={'Near418 N:67508'}
G[67558]={'418:84.32,18.86 N:35874'}
G[67562]={'418:13.76,55.79'}
G[67565]={'376:53.37,51.45'}
G[67581]={'379:57.07,79.01 N:16802'}
G[67603]={'379:57.12,78.59 N:67834'}
G[67608]={'418:12.92,56.13 N:55521'}
G[67618]={'418:10.30,55.71 N:55647'}
G[67628]={'418:75.83,34.46 N:55180'}
G[67630]={'418:89.66,32.79 N:54614'}
G[67631]={'418:89.68,33.08'}
G[67660]={'504:28.29,52.42 N:30116'}	-- phase 1 location on ship
G[67662]={'504:33.52,35.15'}	-- phase 2 location at camp.  phase 1 is NPC 567662
G[67663]={'504:32.47,35.24 N:36670'}	-- phase 2 location at camp.  phase 1 is NPC 567663
G[67673]={'504:32.42,35.22 N:34771'}	-- phase 2 location at camp.  phase 1 is NPC 567673
G[67682]={'379:59.83,75.95 N:28070'}
G[67716]={'379:59.81,76.04 N:68275'}
G[67734]={'379:59.97,75.32'}
G[67751]={'418:10.56,53.75'}
G[67767]={'418:10.52,53.48','Circling fire'}
G[67812]={'418:8.74,64.36'}
G[67834]={'390:20.94,15.57'}
G[67840]={'392:32.23,84.67 N:25237'}
G[67844]={'379:55.8,34'}
G[67847]={'418:76.32,34.07 N:47571'}
G[67865]={'418:10.69,53.70 N:63778'}
G[67866]={'379:71.66,93.22 N:56133'}
G[67867]={'418:8.67,64.44 N:25237'}
G[67880]={'418:10.07,53.87'}
G[67881]={'418:89.53,33.54'}
G[67901]={'418:15.69,57.69'}
G[67939]={'418:10.38,53.72 N:54870'}
G[67940]={'418:89.56,32.58 N:55122'}
G[67948]={'394:66.18,33.31 N:1747'}
G[67951]={'387:61.88,25.79 N:67734'}
G[67976]={'418:16.51,79.14 N:7944','Aboard Skyfire'}
G[67983]={'504:38.54,51.12'}
G[67984]={'504:32.70,35.02 N:33538'}	-- phase 1 location
G[67985]={'504:28.21,52.84 N:70358'}	-- phase 1 location on ship
G[67986]={'504:53.94,49.86 N:33542'}	-- Conqueror's Terrace
G[67989]={'504:38.48,51.33 N:68586'}
G[67990]={'504:32.51,35.59 N:16802'}	-- phase 2 location in camp.  phase 1 is NPC 567990
G[67992]={'504:63.24,72.22 N:4968'}	-- Phase 2 location.  Phase 1 is NPC 70370.
G[67993]={'504:34.74,89.19 N:30115'}	-- Phase 1 location.  Phase 2 is NPC 567993.
G[67994]={'504:63.47,73.60'}	-- Phase 2 location.  No Phase 1 location.
G[67995]={'504:34.54,89.46'}	-- Phase 1 location.  Phase 2 is NPC 567995.
G[67996]={'504:63.93,73.99'}	-- Phase 1 location.  Phase 2 is NPC 567996.
G[67997]={'504:64.82,73.17 N:34880'}	-- Phase 1 location.  Phase 2 is NPC 67997.
G[67998]={'504:51.79,47.13'}	-- Beast Pens location
G[67999]={'504:51.85,47.18'}	-- Beast Pens location
G[68000]={'504:63.20,72.29'}
G[68003]={'379:48.80,50.47'}
G[68004]={'379:52.97,46.45 N:1747'}
G[68017]={'394:66.18,33.31 N:1747'}
G[68023]={'379:71.63,93.19 N:38966'}
G[68025]={'461:44.61,66.73 N:4949'}
G[68059]={'461:44.65,66.74 N:4949'}
G[68072]={'Near418 N:25237'}
G[68077]={'57:40,50 N:67834'}
G[68084]={'110:91.2,37.6 N:16802'}
G[68106]={'501:26.80,39.00 N:1747'}
G[68166]={'418:17.33,78.67 N:54616','Aboard Skyfire'}
G[68182]={'418:16.71,78.54','Aboard Skyfire'}
G[68223]={'379:56,32 N:25237'}
G[68226]={'418:88.33,34.69'}
G[68242]={'394:67.47,43.30 N:29611'}
G[68274]={'418:81.49,18.27'}
G[68275]={'418:80.19,16.40'}
G[68287]={'379:60.4,55.2 N:36648'}
G[68311]={'418:85.24,29.13'}
G[68337]={'379:32.6,30.6'}
G[68370]={'379:53.8,49.2 N:16802'}
G[68375]={'379:65.12,60.79'}
G[68392]={'418:85.29,29.12 N:29611'}
G[68399]={'Near418 N:29611'}
G[68417]={'379:59.20,84.26'}
G[68462]={'422:61.17,87.55'}
G[68463]={'388:57.13,42.17'}
G[68464]={'371:28.92,35.99'}
G[68465]={'379:64.94,93.73'}
G[68501]={'379:32.89,26.34 N:68337'}
G[68526]={'500:69.97,47.06'}
G[68531]={'500:23.86,81.90'}
G[68538]={'418:88.89,31.75 N:68003'}
G[68544]={'418:43.45,86.54 N:68003'}
G[68586]={'126:50,48'}
G[68589]={'502:31.50,50.18 N:68586'}
G[68590]={'502:45.24,53.86 N:68586'}
G[68651]={'89:38.92,32.79 N:4968'}
G[68687]={'501:34.27,48.70 N:30115'}
G[68690]={'418:87.91,33.10 N:29611'}
G[68908]={'418:89.80,32.44 N:55283'}
G[68939]={'379:56.38,34.31 N:1747'}
G[68987]={'379:55.96,31.88 N:1747'}
G[69026]={'487:42.03,14.93 N:29611'}
G[69090]={'418:87.72,33.07 N:55122','In the keep'}
G[69227]={'504:46.15,69.11'}
G[69228]={'504:49.77,80.34'}
G[69326]={'504:55.19,30.87'}
G[69359]={'507:41.76,79.30'}
G[69360]={'507:52.01,75.51'}
G[69371]={'504:47.01,66.74'}	-- phase 2 location
G[69389]={'504:38.47,51.17'}
G[69413]={'504:58.67,42.76 N:61021'}
G[69418]={'504:32.63,34.91'} -- phase 1 location
G[69425]={'504:46.73,66.77 N:58113'}	-- phase 2 location
G[69433]={'504:32.78,32.67'}	-- phase 1 location
G[69461]={'504:57.6,33.8'}
G[69522]={'HM 422:56.07,69.59'}
G[69529]={'HM 371:47.18,47.18'}
G[69533]={'HM 418:73.99,9.50'}
G[69535]={'HM 379:71.15,90.86'}
G[69536]={'HM 388:71.52,56.30'}
G[69550]={'HM 376:51.81,51.32'}
G[69551]={'HM 390:77.76,33.99'}
G[69572]={'HM 390:79.67,37.26'}
G[69668]={'504:64.87,72.94'}	-- Phase 1 location.  Phase 2 is NPC 569668.
G[69670]={'504:40.11,59.13'}	-- Phase 2 location.  No phase 1 location? Or is this really phase 1 location?  What differs from NPC 569670 which is at base?
G[69673]={'504:31.46,83.24'}	-- Phase 1 location.  Phase 2 is NPC 569673.
G[69674]={'504:31.67,83.20'}	-- Phase 1 location.  Phase 2 is NPC 569674.
G[69675]={'504:42.32,75.04 N:58735'}	-- Phase 1 location.  Phase 2 is NPC 569675.
G[69677]={'504:63.82,74.03'}	-- Phase 1 location.  Phase 2 is NPC 569677.
G[69678]={'504:64.12,73.91 N:19644'}	-- Phase 1 location.  Phase 2 is NPC 569678.
G[69741]={'504:63.16,73.87 N:4968'}
G[69742]={'504:32.91,32.58 N:16802'}
G[69782]={'433:54.60,71.76 N:64616','Upstairs'}
G[70022]={'507:33.00,53.89','In cave'}
G[70100]={'516:60.26,28.69 N:64616'}
G[70160]={'504:51.42,46.08 N:60688'}
G[70183]={'504:63.25,72.25'}
G[70296]={'84:67.55,18.51'}
G[70297]={'504:63.20,73.90 N:61021'}	-- Alliance version of Taoshi
G[70301]={'86:69.8,40.8'}
G[70316]={'504:51.42,46.18 N:61021'}
G[70320]={'518:35.76,79.84 N:61021'}
G[70358]={'388:50.79,73.38'}
G[70360]={'388:49.93,69.04 N:30115'}
G[70370]={'504:34.60,89.43 N:4968'}	-- Phase 1 position on ship, Phase 2 is NPC 67992
G[70398]={'376:58.92,46.92'}
G[70476]={'433:75.29,76.28 N:64616'}
G[70517]={'504:31.56,83.13 N:20735'}	-- Phase 1 position.  Phase 2 is NPC 570517.
G[70520]={'504:36.72,64.78 N:37527'}	-- phase 2 location	[TODO: Deal with location 928:32.44,35.56 which is at camp when not in the field]
G[70551]={'504:58.78,42.69 N:70358'}
G[70552]={'504:58.70,42.69 N:67998'}
G[70561]={'504:32.45,35.23 N:70567'}
G[70567]={'504:63.24,72.20'}
G[70751]={'503:60.42,77.43'}
G[70752]={'500:52.33,25.38'}	-- 922[2]:54.33,27.92
G[70859]={'525:48.74,65.30 N:4949'}
G[70860]={'526:43.13,41.33'}
G[70902]={'540:60.09,31.98'}
G[70909]={'525:30.90,25.82 N:79917'}
G[70910]={'525:46.40,32.16 N:79917'}
G[70941]={'532:50.60,54.38 N:79917'}
G[70978]={'1:49.69,40.08 N:38966'}
G[70980]={'379:44.97,47.84'}
G[71027]={'1:54.41,9.80 N:55283'}	-- 13:59.53,46.21
G[71143]={'554:33.80,81.59'}
G[71148]={'1:56.39,73.41 N:38966'}
G[71150]={'1:49.75,40.06 N:56133'}
G[71320]={'1:51.79,39.29 N:38243'}
G[71322]={'1:51.79,39.29 N:38243'}	-- this was 71320 until 32810 was turned in
G[71333]={'1:55.03,73.30'}
G[71336]={'390:85.74,59.56'}
G[71352]={'371:58.76,59.20 N:64616'}
G[71424]={'433:73.25,79.63 N:64616'}
G[71426]={'433:75.25,76.32 N:64616'}
G[71483]={'390:62.2,23.8'}
G[71502]={'539:52.03,32.66'}
G[71641]={'539:41.29,55.11'}
G[71823]={'554:44.82,71.98'}
G[71864]={'554:59.06,48.85'}
G[71868]={'555:42.39,70.47'}
G[71869]={'555:62.15,35.29'}
G[71876]={'555:52.87,56.35 N:71869'}
G[71908]={'554:40.39,77.78'}
G[71919]={'554:37.30,78.12'}
G[71939]={'554:21.92,39.75'}
G[71940]={'554:23.09,71.07'}
G[71953]={'554:37.38,55.25'}
G[71955]={'554:34.16,47.49'}
G[71986]={'554:19.13,63.76'}
G[72007]={'554:59.45,40.75'}
G[72045]={'554:26.26,38.58'}
G[72049]={'554:43.57,69.84'}
G[72160]={'51:74.06,44.41'}
G[72193]={'554:33.78,83.32'}
G[72230]={'525:57.14,41.49 N:74651'}
G[72245]={'554:47.36,88.12'}
G[72274]={'525:38.54,52.43'}
G[72297]={'525:68.49,22.45'}
G[72348]={'525:71.71,24.66'}
G[72373]={'525:63.22,60.03'}
G[72413]={'539:77.46,37.61'}
G[72426]={'554:40.93,73.45'}
G[72571]={'550:45.45,35.87'}
G[72623]={'539:29.47,24.55'}
G[72637]={'539:29.26,25.70 N:78430'}
G[72654]={'650:49.41,39.27'}
G[72695]={'554:34.52,53.84 N:64616'}
G[72723]={'390:83.17,29.65 N:64616'}
G[72751]={'554:49.37,69.41 N:1181758'}
G[72754]={'554:34.57,26.67 N:1181758'}
G[72755]={'554:66.06,23.26'}
G[72761]={'554:43.69,53.29'}
G[72762]={'554:43.05,69.04'}
G[72764]={'554:22.31,67.95'}
G[72765]={'554:23.35,33.03'}
G[72767]={'554:28.39,28.31'}
G[72769]={'555:58.81,27.50'}
G[72771]={'555:67.13,22.78'}
G[72775]={'554:65.82,72.98'}
G[72777]={'554:64.77,70.72'}
G[72805]={'554:65.16,55.89'}
G[72807]={'554:51.04,45.83'}
G[72808]={'554:54.64,44.49'}
G[72814]={'525:31.46,16.25 N:78430'}
G[72822]={'550:49.30,47.99 N:3432'}
G[72836]={'525:31.82,11.83 N:78430'}
G[72837]={'525:31.75,11.77'}
G[72841]={'554:29.74,36.90'}
G[72842]={'Z554'}
G[72843]={'Z554'}
G[72844]={'Z554'}
G[72870]={'554:34.58,53.59'}
G[72874]={'525:31.73,11.88 N:78558'}
G[72875]={'554:52.85,75.52'}
G[72876]={'554:56.33,58.82'}
G[72890]={'525:30.79,41.51'}
G[72892]={'554:54.19,75.65'}
G[72894]={'554:52.05,82.57'}
G[72895]={'554:68.27,35.51'}
G[72897]={'554:33.30,34.38'}
G[72908]={'554:40.44,69.08'}
G[72909]={'554:38.74,70.08'}
G[72939]={'86:38.94,46.84'}
G[72940]={'Near525 N:72274'}
G[72970]={'554:62.67,62.81'}
G[72976]={'525:66.03,49.09'}
G[72997]={'554:39.13,46.77 N:62295'}
G[73018]={'554:41.91,73.55'}
G[73021]={'554:37.05,76.37'}
G[73025]={'554:35.59,77.47'}
G[73082]={'554:34.72,59.68'}
G[73097]={'Near525 N:72373'}
G[73136]={'390:67.43,45.84 N:54961'}
G[73138]={'433:54.74,72.72 N:64616'}
G[73157]={'555:48.85,33.45'}
G[73158]={'554:31.07,52.46'}
G[73160]={'Z554'}
G[73161]={'554:24.25,52.64'}
G[73162]={'555:61.08,49.30'}
G[73163]={'554:42.85,69.42'}
G[73166]={'554:22.36,36.25'}
G[73167]={'554:68.47,58.31'}
G[73169]={'554:52.81,82.47'}
G[73170]={'554:56.65,75.84'}
G[73171]={'554:65.88,42.07'}
G[73172]={'554:43.70,34.93'}
G[73173]={'554:42.54,25.71'}
G[73175]={'554:54.69,53.91'}
G[73277]={'554:68.43,44.81'}
G[73279]={'554:14.52,45.19'}
G[73281]={'554:26.06,22.85'}
G[73282]={'554:65.46,30.18'}
G[73284]={'525:67.13,49.16'}
G[73293]={'554:41.25,47.28'}
G[73303]={'554:42.86,55.20'}
G[73318]={'568:50.08,60.07 N:54961'}
G[73325]={'525:22.82,9.39'}
G[73335]={'568:50,60'}
G[73343]={'554:46.77,46.90'}
G[73348]={'554:23.12,71.65'}
G[73353]={'554:22.01,40.93'}
G[73360]={'525:44.63,43.38'}
G[73373]={'525:21.18,41.61'}
G[73395]={'539:46.38,38.62 N:78994'}
G[73425]={'539:40.60,54.82'}
G[73426]={'641:49.07,82.34'}
G[73468]={'539:23.08,24.38'}
G[73480]={'525:21.95,14.64 N:77417'}
G[73570]={'554:65.00,50.60'}
G[73626]={'554:34.68,60.32'}
G[73649]={'554:34.69,52.85'}
G[73657]={'554:41.79,63.73'}
G[73666]={'554:35.79,35.39'}
G[73691]={'390:80.65,33.16 N:10667'}
G[73703]={'554:70.53,80.95'}
G[73877]={'539:47.09,14.40','In cave'}
G[73953]={'539:36.39,19.28 N:76748'}
G[73973]={'539:39.81,18.69 N:77270'}
G[74000]={'525:36.00,25.77 N:79917'}
G[74009]={'221:48.47,12.06 63:16.52,11.03>221 N:44375'}
G[74020]={'394:41.15,43.29'}
G[74043]={'539:49.12,38.51 N:17468'}
G[74056]={'407:48.99,88.33'}
G[74121]={'539:42.14,57.36'}
G[74125]={'543:54.23,55.93'}
G[74146]={'539:42.39,18.51'}
G[74148]={'539:41.76,15.04'}
G[74163]={'525:48.62,64.71 N:70860'}
G[74222]={'525:35.92,25.72'}
G[74223]={'525:46.40,32.04'}
G[74224]={'539:41.46,15.80'}
G[74233]={'539:62.46,36.83'}
G[74253]={'525:57.65,41.58 N:74272'}
G[74254]={'527:50.83,70.15'}
G[74272]={'525:16.78,57.83'}
G[74273]={'526:43.55,23.12 N:70860'}
G[74330]={'525:70.06,38.17 N:74272'}
G[74343]={'539:46.63,37.34'}
G[74358]={'525:41.61,52.91'}
G[74367]={'300:24.52,23.72 64:47.56,23.60>300 N:44837'}
G[74408]={'221:48.46,11.73 63:16.52,11.03>221 N:12736'}
G[74409]={'222:87.49,86.16 N:44375'}
G[74434]={'300:44.37,59.74'}
G[74476]={'221:12.15,41.29'}
G[74507]={'525:19.04,58.36'}
G[74547]={'539:47.04,14.35','In cave'}
G[74565]={'221:54.73,59.05'}
G[74593]={'543:46.58,71.48 N:74651'}
G[74594]={'543:37.28,77.01 N:70860'}
G[74606]={'543:41.45,74.10'}
G[74611]={'543:40.49,71.95'}
G[74635]={'525:24.50,28.81'}
G[74651]={'525:20.80,57.93'}
G[74741]={'539:42.86,40.38'}
G[74790]={'573:66.46,20.89'}
G[74808]={'587:50.82,37.58 N:4949'}
G[74877]={'539:34.21,63.25 N:78994'}
G[74888]={'300:36,70 64:47.56,23.60>300 N:44837'}
G[74927]={'573:64.95,24.79'}
G[74977]={'525:64.97,39.49'}
G[75005]={'539:46.04,38.92'}
G[75008]={'543:41.42,66.11'}
G[75028]={'535:49.79,48.65 N:79537'}
G[75043]={'539:49.43,36.83'}
G[75119]={'535:55.67,67.69 N:79537'}
G[75121]={'535:55.50,67.68'}
G[75127]={'543:52.84,59.69 N:78554'}
G[75136]={'543:63.17,52.40 N:78568'}
G[75145]={'539:52.23,46.05 N:78554'}
G[75146]={'543:63.22,52.26 N:79576'}
G[75155]={'222:84.90,86.10'}
G[75176]={'526:43.13,23.26 N:70860'}
G[75177]={'526:34.22,72.94 N:70860'}
G[75186]={'527:70.75,78.58 N:4949'}
G[75188]={'528:66.41,56.49 N:70860'}
G[75191]={'573:45.14,48.03'}
G[75207]={'543:63.27,54.51'}
G[75246]={'535:61.00,72.53 N:75121'}
G[75249]={'535:60.52,72.40 N:78577'}
G[75250]={'535:57.24,77.05 N:79537'}
G[75256]={'535:57.18,76.93 N:78519'}
G[75273]={'535:56.98,82.90'}
G[75283]={'535:76.27,42.72'}
G[75288]={'535:70.50,56.84'}
G[75290]={'535:76.30,42.85'}
G[75311]={'535:77.75,43.97'}
G[75323]={'535:70.53,57.32'}
G[75324]={'535:70.77,56.78'}
G[75389]={'535:42.96,76.23 N:75121'}
G[75392]={'535:42.89,76.08 N:79537'}
G[75469]={'535:82.64,37.78 N:75311'}
G[75483]={'539:65.82,36.32'}
G[75593]={'543:42.66,37.82'}
G[75606]={'221:48.47,12.06 63:16.52,11.03>221 N:33260'}
G[75607]={'221:48.46,11.73 N:33256'}
G[75710]={'543:47.55,94.09 N:14627'}
G[75747]={'535:63.04,23.45'}
G[75752]={'535:61.40,27.94'}
G[75753]={'535:61.32,27.86'}
G[75803]={'535:69.57,20.46 N:78554'}
G[75804]={'535:69.55,20.52 N:78994'}
G[75805]={'535:54.18,36.42 N:78558'}
G[75806]={'535:61.51,10.95 N:70860'}
G[75808]={'535:58.93,20.15 N:74651'}
G[75815]={'535:55.26,18.09'}
G[75819]={'543:42.76,63.01'}
G[75873]={'535:62.06,10.41 N:3391'}
G[75874]={'535:69.38,20.34 N:78568'}
G[75878]={'543:47.71,93.31 N:78994'}
G[75884]={'539:45.70,26.31'}
G[75896]={'535:73.07,38.74'}
G[75913]={'535:76.72,55.24 N:75896'}
G[75924]={'535:58.95,20.72 N:3391'}
G[75941]={'535:55.68,41.16 N:3391'}
G[75942]={'Near535 N:75968'}
G[75958]={'535:58.91,20.20 N:70860'}
G[75959]={'535:55.60,40.95 N:70860'}
G[75968]={'535:61.79,38.88'}
G[76067]={'539:40.60,54.94 N:78994'}
G[76111]={'17:51.79,28.72 N:9540'}
G[76186]={'539:45.79,26.29'}
G[76200]={'539:56.96,57.49'}
G[76204]={'539:53.60,57.28 N:45417'}
G[76240]={'525:19.74,44.76 N:70860'}
G[76266]={'602:53.59,35.76'}
G[76267]={'602:46.50,30.33'}
G[76292]={'602:47.52,37.27'}
G[76407]={'539:0.00,0.00'}
G[76411]={'587:49.71,49.64 N:74272'}	-- garrison level 1 location
G[76447]={'539:45.49,37.72'}
G[76452]={'525:64.74,39.75'}
G[76484]={'525:76.15,55.16 N:70860'}
G[76487]={'525:73.43,58.83 N:72274'}
G[76492]={'525:76.32,54.98'}
G[76508]={'550:40.75,12.96'}
G[76517]={'543:52.40,78.35'}
G[76518]={'576:37.44,36.94'}
G[76534]={'543:53.13,79.74'}
G[76552]={'539:46.36,38.62 N:79795'}
G[76557]={'525:20.94,57.92 N:70860'}
G[76609]={'17:48.73,31.88 N:41124'}
G[76616]={'525:17.67,56.70 N:74272'}
G[76622]={'525:70.07,38.27 N:4949'}
G[76662]={'525:24.14,39.32'}
G[76665]={'535:65.42,50.73'}
G[76668]={'535:68.69,56.80'}
G[76687]={'535:30.91,70.74'}
G[76688]={'543:46.27,69.28 N:74611'}
G[76720]={'530:53.24,56.18 N:4949'}
G[76725]={'525:76.15,55.16 N:74222'}
G[76730]={'525:76.32,54.98'}
G[76746]={'526:42.77,44.74'}
G[76748]={'539:36.39,19.26'}
G[76790]={'536:52.20,38.77'}
G[76804]={'535:50.01,48.61 N:75121'}
G[76826]={'535:36.20,65.05'}
G[76862]={'525:19.23,59.18'}
G[76872]={'587:43.08,57.13'}
G[76889]={'525:19.53,51.01'}
G[76904]={'535:58.84,12.07'}
G[76926]={'535:63.10,26.06'}
G[76941]={'525:21.63,55.08'}
G[76947]={'535:57.68,84.53'}
G[76969]={'535:57.44,85.27'}
G[76987]={'543:39.32,71.99 N:74606'}
G[76998]={'554:25.45,27.15'}
G[77014]={'543:36.85,67.91'}
G[77031]={'535:56.89,25.97'}
G[77051]={'535:44.61,90.76'}
G[77082]={'535:44.84,90.51'}
G[77093]={'543:53.48,70.74'}
G[77106]={'525:84.11,65.10'}
G[77120]={'618:14.23,45.38 N:45658'}
G[77147]={'525:84.11,65.11'}
G[77160]={'525:86.39,48.92 N:14627'}
G[77161]={'581:64.69,67.37 N:78568'}
G[77167]={'Near525 N:78568'}
G[77184]={'572:64.28,47.02 N:78558'}
G[77209]={'581:41.22,49.31 N:79243'}	-- garrison level 1 location
G[77210]={'525:83.21,62.76'}
G[77211]={'539:46.11,25.49'}
G[77217]={'581:64.50,69.86'}
G[77221]={'86:53.84,78.82'}
G[77270]={'539:46.27,15.88'}
G[77282]={'539:46.37,38.69 N:17468'}
G[77312]={'539:52.23,46.04 N:78554'}
G[77354]={'581:46.99,59.27'}	-- plot 18
G[77356]={'581:46.99,59.27'}	-- plot 18
G[77359]={'581:46.99,59.27'}	-- plot 18
G[77363]={'581:46.99,59.27'}	-- plot 18
G[77365]={'581:46.99,59.27'}	-- plot 18
G[77367]={'581:40.09,56.58'}	-- plot 24
G[77372]={'581:46.99,59.27'}	-- plot 18
G[77377]={'581:40.09,56.58'}	-- plot 24
G[77378]={'581:46.99,59.27'}	-- plot 18
G[77382]={'581:46.99,59.27'}
G[77383]={'581:46.99,59.27'}	-- location is top of stairs for plot 18
G[77417]={'539:19.08,28.56'}
G[77426]={'535:49.03,91.66'}
G[77434]={'535:49.23,87.95'}
G[77441]={'535:63.93,85.30'}
G[77528]={'535:35.64,79.86'}
G[77541]={'535:38.03,78.45'}
G[77548]={'535:34.50,71.50'}
G[77580]={'535:45.70,74.45 N:75121'}
G[77581]={'535:45.70,74.05 N:79537'}
G[77582]={'535:31.21,73.60 N:78519'}
G[77614]={'535:46.24,54.92'}
G[77629]={'535:34.01,73.97'}
G[77730]={'581:65.22,41.84'}	-- garrison level 2 location ? 65.07,42.01
G[77733]={'581:54.52,13.92'}	-- garrison level 2 location, though he moves about a bit
G[77734]={'593:48.02,33.15'}
G[77737]={'535:62.15,63.74'}
G[77775]={'581:46.99,59.27'}	-- plot 18
G[77777]={'581:46.99,59.27'}	-- plot 18
G[77778]={'581:46.99,59.27'}	-- plot 18
G[77781]={'581:46.99,59.27'}	-- plot 18
G[77784]={'535:49.19,92.28','Top of lift'}
G[77789]={'Near'}
G[77791]={'581:46.99,59.27'}	-- plot 18
G[77792]={'581:46.99,59.27'}	-- plot 18
G[77799]={'535:43.42,75.96 N:77082'}
G[77831]={'581:46.99,59.27'}	-- plot 18
G[77853]={'535:84.55,31.70 N:19644'}
G[77857]={'542:51.19,50.56'}
G[77869]={'535:50.42,87.50 N:77737'}
G[77902]={'535:47.14,91.62'}
G[77905]={'593:48.18,32.44'}
G[77911]={'525:82.64,69.83 N:77210'}
G[77928]={'525:78.18,55.14 N:3391'}
G[77940]={'525:84.27,52.26'}
G[77944]={'525:86.41,55.97'}
G[77945]={'525:87.43,52.82'}
G[77979]={'525:46.38,15.97'}
G[77980]={'525:47.01,16.88'}
G[77981]={'525:44.73,12.68'}
G[77982]={'539:59.22,82.25 N:21984'}
G[77988]={'525:42.55,14.80'}
G[77995]={'525:47.83,18.94'}
G[77998]={'525:43.62,15.52'}
G[78028]={'535:57.25,76.89 N:77737'}
G[78030]={'543:41.35,91.47'}
G[78056]={'525:48.70,14.70 N:78239'}
G[78082]={'535:50.39,87.32 N:81789'}
G[78083]={'535:50.51,87.55'}
G[78102]={'535:57.54,76.70'}
G[78116]={'52:55.07,49.60'}
G[78151]={'525:57.62,37.23'}
G[78168]={'539:57.98,88.72'}
G[78185]={'525:48.70,14.70 N:78239'}
G[78187]={'543:39.92,37.15 N:41006'}
G[78192]={'587:41.92,45.49 N:41005'}
G[78197]={'543:40.32,40.30'}
G[78207]={'581:46.99,59.27'}	-- location is top of stairs for plot 18
G[78208]={'525:52.63,40.42'}
G[78209]={'525:52.51,40.42'}
G[78210]={'525:86.58,55.85'}
G[78222]={'526:20.12,52.81'}
G[78239]={'525:40.22,21.46'}
G[78251]={'543:54.16,56.07 N:41006'}
G[78257]={'543:52,54'}
G[78258]={'539:58.14,93.89 N:21984'}
G[78269]={'548:0.00,0.00'}
G[78272]={'525:41.79,69.68 N:70860'}
G[78277]={'550:65.57,58.43'}
G[78278]={'550:76.14,53.08'}
G[78319]={'536:49.84,34.19'}
G[78323]={'Near525 N:3391'}
G[78326]={'535:53.39,50.28'}
G[78327]={'535:51.19,51.52'}
G[78390]={'535:49.46,55.01'}
G[78428]={'525:39.43,23.46'}
G[78430]={'577:49.49,14.21'}
G[78457]={'535:56.41,64.73'}
G[78459]={'550:85.42,65.65'}
G[78466]={'587:52.46,53.40 N:3391'}	-- Garrison Level 1 position
G[78470]={'525:39.54,23.59 N:78239'}
G[78482]={'535:56.85,65.75'}
G[78487]={'587:51.28,51.48 N:26859'}	-- Garrison Level 1 position
G[78495]={'587:40.83,51.93 N:81890'}
G[78501]={'535:52.12,47.59'}
G[78513]={'535:51.65,50.51'}
G[78515]={'535:51.64,50.52'}
G[78519]={'535:56.51,67.13'}
G[78520]={'535:55.12,67.41 N:77737'}
G[78534]={'535:49.89,56.16'}
G[78538]={'535:51.62,50.48'}
G[78550]={'539:60.69,96.27'}
G[78553]={'577:50.05,13.34 N:4949'}
G[78554]={'577:71.49,62.70'}
G[78557]={'588:53.68,68.86'}
G[78558]={'577:54.73,48.26'}
G[78559]={'577:60.26,56.34 N:78558'}
G[78560]={'577:71.95,40.46 N:78558'}
G[78561]={'578:81.32,50.20 N:78558'}
G[78562]={'577:49.51,14.41 N:78558'}
G[78563]={'577:44.40,80.68 N:78558'}
G[78564]={'581:37.34,36.88'}	-- TODO: Really these should be done only on the alias one that has them...wonder how to do that properly if it is even possible.
G[78568]={'577:44.07,29.68'}
G[78569]={'577:44.09,29.57 N:14627'}
G[78573]={'577:62.28,52.99'}
G[78577]={'535:55.57,67.01'}
G[78578]={'525:39.55,19.67'}
G[78659]={'525:51.82,16.75'}
G[78746]={'525:51.81,16.75 N:78659'}
G[78758]={'533:73.43,21.18'}
G[78785]={'525:40.55,21.85 N:78659'}
G[78791]={'525:26.16,53.17'}
G[78792]={'525:39.54,23.59 N:78659'}
G[78810]={'525:38.00,14.80 N:78239'}
G[78821]={'525:37.56,14.12 N:78659'}
G[78870]={'525:25.70,51.70 N:78909'}
G[78882]={'539:58.14,93.89 N:21984'}
G[78883]={'577:54.07,48.78'}
G[78907]={'525:25.71,51.68 N:78909'}
G[78909]={'525:25.48,50.65'}
G[78910]={'525:28.54,50.52'}
G[78926]={'613:51.13,45.14'}
G[78937]={'539:67.97,90.11 N:21984'}
G[78985]={'587:47.64,39.33'}
G[78989]={'525:41,52'}
G[78994]={'577:58.82,14.11'}
G[78996]={'577:43.04,26.36 N:74272'}
G[78999]={'539:58.96,84.82'}
G[79002]={'550:75.14,62.51'}
G[79022]={'550:82.49,79.85'}
G[79043]={'539:40.53,54.92 N:17468'}
G[79047]={'525:30.76,41.45 N:72890'}
G[79061]={'539:43.19,61.34'}
G[79070]={'550:81.28,70.34'}
G[79133]={'535:69.88,20.81'}
G[79159]={'535:69.26,19.29'}
G[79176]={'535:71.06,29.74'}
G[79187]={'535:37.25,79.37'}
G[79188]={'550:79.46,50.24'}
G[79201]={'550:71.13,52.35'}
G[79206]={'539:26.97,8.10 N:17468'}
G[79210]={'535:71.89,29.41'}
G[79229]={'525:59.44,31.79'}
G[79231]={'535:70.23,71.28'}
G[79234]={'535:69.53,71.22'}
G[79243]={'539:29.05,16.21'}
G[79252]={'587:49.54,36.31 N:78430'}	-- Garrison level 1 position
G[79263]={'550:86.38,66.20'}
G[79269]={'588:48.80,37.79'}
G[79281]={'550:83.06,67.97'}
G[79282]={'550:78.79,69.23'}
G[79310]={'550:78.58,48.57'}
G[79312]={'550:78.97,58.88'}
G[79315]={'578:51.16,46.72'}
G[79316]={'578:50.87,49.80'}
G[79320]={'543:42.76,63.06'}
G[79322]={'543:42.75,62.98'}
G[79329]={'535:70.14,20.12 N:80630'}
G[79331]={'543:42.70,63.08'}
G[79335]={'535:83.13,31.72'}
G[79337]={'543:42.76,63.01'}
G[79356]={'535:70.89,30.48 N:79210'}
G[79392]={'535:84.97,30.97'}
G[79393]={'535:84.19,30.31'}
G[79402]={'552:42.52,41.39'}
G[79407]={'587:50.93,46.77'}
G[79415]={'525:21.76,56.41 N:70860'}
G[79416]={'543:41.34,72.69'}
G[79432]={'535:75.88,47.61'}
G[79434]={'535:46.32,74.09 N:77737'}
G[79457]={'581:44.09,53.29 N:78554'}	-- garrison level 1 location
G[79470]={'539:28.79,16.23 N:78554'}
G[79482]={'535:43.04,61.83'}
G[79492]={'581:61.38,74.95'}
G[79514]={'535:43.73,59.19'}
G[79519]={'542:43.64,12.93'}
G[79537]={'577:73.24,38.88'}
G[79539]={'542:37.89,18.02'}
G[79540]={'537:37.92,49.47'}
G[79544]={'535:53.81,89.37'}
G[79567]={'539:28.92,16.40 N:78994'}
G[79573]={'535:69.48,21.45'}
G[79576]={'550:63.52,61.89'}
G[79581]={'550:39.55,73.04'}
G[79598]={'542:50.33,36.73'}
G[79604]={'535:71.44,29.61 N:70860'}
G[79608]={'535:69.67,21.08 N:78994'}
G[79609]={'587:51.18,31.72'}
G[79612]={'535:71.83,29.75'}
G[79618]={'535:69.65,21.61'}
G[79627]={'535:71.24,29.94'}
G[79635]={'539:26.94,8.07 N:17468'}
G[79661]={'578:82.84,44.36'}
G[79674]={'550:63.06,61.95 N:78568'}
G[79675]={'578:50.18,48.28 N:75121'}
G[79680]={'535:71.41,29.65'}
G[79681]={'539:62.56,62.57'}
G[79689]={'535:56.02,68.34 N:16554'}
G[79696]={'535:55.38,66.78'}
G[79703]={'535:60.67,55.19'}
G[79722]={'550:65.88,68.63'}
G[79724]={'535:71.22,47.48'}
G[79725]={'550:34.33,76.84'}
G[79740]={'587:53.92,54.98'}	-- Garrison Level 1 position
G[79743]={'550:66.76,68.66'}
G[79744]={'550:67.34,67.54'}
G[79748]={'542:40.08,43.94'}
G[79774]={'587:43.19,47.81 N:88228'}
G[79779]={'539:60.78,68.39'}
G[79795]={'578:45.37,15.81'}
G[79813]={'587:52.44,37.06'}	-- plot 18 location
G[79814]={'587:52.44,37.06'}	-- plot 18 location
G[79815]={'587:60.36,36.51'}	-- plot 24 location
G[79817]={'587:52.44,37.06'}	-- plot 18 location
G[79820]={'587:52.44,37.06'}	-- plot 18 location
G[79821]={'587:52.44,37.06'}	-- plot 18 location
G[79826]={'587:52.44,37.06'}	-- plot 18 location
G[79829]={'587:52.44,37.06'}	-- plot 18 location
G[79830]={'587:52.44,37.06'}	-- plot 18 location
G[79831]={'587:52.44,37.06'}	-- plot 18 location
G[79832]={'587:52.44,37.06'}	-- plot 18 location
G[79833]={'587:52.44,37.06'}	-- plot 18 location
G[79834]={'587:52.44,37.06'}	-- plot 18 location
G[79836]={'587:61.97,35.39'}
G[79853]={'535:62.89,50.44'}
G[79857]={'587:52.44,37.06'}	-- plot 18 location
G[79858]={'587:32.18,41.68'}	-- garrison level 3 location ? 976:31.72,42.13
G[79862]={'587:52.44,37.06'}	-- plot 18 location
G[79863]={'587:52.44,37.06'}	-- plot 18 location
G[79864]={'587:52.44,37.06'}	-- plot 18 location
G[79867]={'587:52.44,37.06'}	-- plot 18 location
G[79870]={'535:64.21,47.80'}
G[79890]={'542:51.62,31.35'}
G[79892]={'587:38.10,72.21'}
G[79893]={'581:54.07,13.68'}
G[79895]={'542:51.03,33.21'}
G[79896]={'525:55.71,75.30'}
G[79897]={'Near550'}
G[79899]={'550:74.87,61.64 N:79897'}
G[79901]={'535:62.87,50.32'}
G[79917]={'577:41.83,41.67'}
G[79921]={'535:71.19,29.44'}
G[79930]={'535:71.41,20.75'}
G[79953]={'581:40.28,53.61'}	-- garrison level 1 location
G[79954]={'550:63.54,61.83 N:14627'}
G[79963]={'535:69.59,21.55'}
G[79966]={'539:39.82,29.40'}
G[79971]={'587:37,70'}
G[79973]={'542:43.75,25.40'}
G[79978]={'535:58.09,53.06'}
G[79979]={'535:57.42,51.12'}
G[80001]={'550:86.38,66.20'}
G[80003]={'550:82.84,45.07 N:4949'}
G[80005]={'609:25.38,47.43'}
G[80028]={'535:61.35,54.40'}
G[80053]={'535:70.51,27.54'}
G[80057]={'550:75.51,65.35'}
G[80073]={'539:59.52,30.37 N:79537'}
G[80075]={'539:61.91,29.68'}	-- ? 56.24,32.61
G[80076]={'539:59.36,26.56'}
G[80078]={'539:56.51,23.59 N:72413'}
G[80079]={'539:56.49,23.53'}
G[80083]={'550:40.44,76.22'}
G[80103]={'535:81.36,27.92'}
G[80108]={'539:56.91,34.64 N:80075'}
G[80122]={'550:43.65,77.81'}
G[80140]={'550:82.93,44.14 N:11378'}
G[80142]={'535:74.98,31.20 N:78558'}
G[80148]={'539:56.93,34.72'}
G[80153]={'542:46.58,46.53 N:75288'}	-- 948:46.51,45.61
G[80155]={'542:36.97,24.49 N:75324'}
G[80157]={'542:36.88,24.57 N:75323'}
G[80159]={'581:36.86,64.77'}	-- garrison level 2 location ? 33.70,51.29
G[80161]={'550:85.42,54.60 N:18261'}
G[80163]={'581:48.96,42.25'}	-- garrison level 1 location ? 43.21,54.12
G[80165]={'539:43.56,77.29 N:79392'}
G[80178]={'542:47.10,31.63'}
G[80184]={'550:79.87,48.85'}
G[80191]={'550:85.62,55.09'}
G[80193]={'535:84.16,30.74 N:79393'}
G[80196]={'539:46.61,37.74'}
G[80205]={'550:85.66,55.26'}
G[80229]={'535:62.12,69.24 N:79210'}
G[80232]={'542:47.99,34.73 N:23066'}
G[80233]={'542:45.43,36.31'}
G[80248]={'539:46.41,25.23'}
G[80260]={'Near535 N:79392'}
G[80265]={'542:51.57,31.07 N:79519'}
G[80297]={'588:48.31,50.36'}
G[80319]={'551:44.86,19.85 N:18261'}
G[80339]={'535:68.77,70.53 N:79210'}
G[80341]={'Near535 N:79210'}
G[80342]={'535:64.52,81.62 N:79210'}
G[80378]={'539:43.69,51.67'}
G[80389]={'Near535 N:79393'}
G[80390]={'535:68.31,70.33 N:79393'}
G[80396]={'535:62.25,68.29 N:79393'}
G[80429]={'550:68.57,64.43 N:79627'}
G[80434]={'550:75.07,22.74'}
G[80451]={'550:68.59,64.46'}
G[80456]={'525:21.04,57.91 N:74272'}
G[80469]={'542:45.40,36.74 N:85320'}
G[80470]={'542:45.40,36.74'}
G[80481]={'542:52.10,49.95'}
G[80508]={'542:44.49,24.01'}
G[80521]={'577:40.07,48.50 N:78568', 'On top of tank'}	-- WoD 40.10,48.42
G[80552]={'535:58.01,29.37'}
G[80553]={'535:71.17,29.88 N:79393'}
G[80568]={'581:47.01,50.94 N:78994'}	-- garrison level 1 location
G[80586]={'550:70.46,9.75','In cave'}
G[80589]={'542:55.77,54.68'}
G[80593]={'550:71.34,17.88'}
G[80595]={'550:72.78,19.71'}
G[80597]={'550:71.66,19.74 N:74272'}
G[80606]={'539:53.38,68.00'}
G[80607]={'535:61.95,69.28 N:79392'}
G[80608]={'535:69.95,69.45 N:79392'}
G[80617]={'Near535 N:79392'}
G[80623]={'535:71.19,29.85 N:79210'}
G[80624]={'550:63.50,61.85 N:79743'}
G[80627]={'535:62.57,67.87 N:80630'}
G[80628]={'535:69.63,69.85 N:80630'}
G[80630]={'535:64.52,81.77'}
G[80632]={'Near535 N:80630'}
G[80635]={'539:55.67,71.98'}
G[80639]={'542:48.98,48.99'}
G[80640]={'542:68.64,41.67'}
G[80643]={'542:66.39,44.64'}
G[80645]={'581:43.17,44.75 N:78430'}	-- garrison level 2 location
G[80648]={'542:46.78,45.96'}
G[80672]={'535:69.74,20.79 N:79392'}
G[80685]={'543:47,65'}
G[80689]={'543:45,64'}
G[80690]={'543:46.62,71.52'}
G[80696]={'543:47,64'}
G[80707]={'539:53.11,65.38'}
G[80714]={'543:58,60'}
G[80725]={'543:41,60'}
G[80727]={'539:53.69,57.28 N:80635'}
G[80740]={'542:54.86,54.23'}
G[80744]={'543:61.73,52.35'}
G[80746]={'542:52.09,49.41'}
G[80747]={'550:37.20,55.65'}
G[80757]={'543:57.20,61.95'}
G[80758]={'542:62.20,42.62'}
G[80761]={'539:53.45,57.31 N:46022'}
G[80762]={'543:59.32,56.36 N:82476'}
G[80782]={'525:54.27,67.46'}
G[80785]={'543:58,63'}
G[80803]={'577:71.92,62.06'}
G[80827]={'539:45.18,38.83'}
G[80833]={'535:70.84,29.62'}
G[80834]={'542:60.48,38.75'}
G[80854]={'535:69.43,21.14'}
G[80856]={'543:46.07,54.75 N:21984'}
G[80859]={'539:52.60,59.70'}
G[80860]={'542:54.85,54.28 N:80481'}
G[80863]={'542:54.83,54.18 N:80746'}
G[80864]={'550:40.43,56.79 N:80434'}
G[80865]={'539:53.66,57.25 N:45429'}
G[80866]={'550:40.40,56.74'}
G[80874]={'543:64.99,48.53 N:78568'}
G[80895]={'539:55.05,68.20 N:16134'}
G[80907]={'539:54.18,70.76'}
G[80921]={'543:64.21,51.94 N:79576'}
G[80922]={'543:64.20,51.77 N:80987'}
G[80964]={'550:55.97,43.17'}
G[80965]={'535:71.33,29.60 N:79393'}
G[80966]={'535:69.60,21.07 N:79392'}
G[80968]={'535:69.78,20.74 N:80630'}
G[80978]={'543:63.99,57.20 N:78994'}
G[80987]={'543:63.14,52.29'}
G[81019]={'550:46.79,57.39'}
G[81038]={'543:42.01,46.83'}
G[81039]={'550:61.98,40.55'}
G[81043]={'543:41.91,46.90'}
G[81054]={'550:52.37,63.51'}
G[81072]={'550:52.10,68.10'}
G[81076]={'543:52.84,59.87'}
G[81086]={'550:55.50,42.09'}
G[81097]={'550:55.44,42.09'}
G[81103]={'581:43.12,44.89 N:352'}
G[81109]={'542:61.47,72.93'}
G[81123]={'550:62.13,40.43'}
G[81126]={'539:45.81,37.33'}
G[81128]={'542:61.45,72.96'}
G[81134]={'550:56.09,43.79'}
G[81140]={'539:61.86,29.14'}
G[81144]={'550:84.06,76.84'}
G[81152]={'539:40.64,54.88'}
G[81153]={'539:40.66,54.87 N:81152'}
G[81166]={'587:45.41,50.63'}
G[81173]={'539:35.38,36.95'}
G[81176]={'539:35.84,36.96'}
G[81185]={'543:54.82,65.29'}
G[81186]={'550:48,48 N:70860'}
G[81189]={'550:82.88,45.07 N:35875'}
G[81193]={'550:49.38,47.84'}
G[81194]={'550:55.49,42.19'}
G[81195]={'550:56.06,43.76'}
G[81202]={'543:43.56,65.01'}
G[81207]={'543:47.20,55.13'}
G[81209]={'525:38.03,47.46'}
G[81210]={'525:37.75,47.48'}
G[81216]={'550:51.82,58.79'}
G[81218]={'543:54.45,66.66 N:80757'}
G[81230]={'550:46.81,57.51'}
G[81240]={'543:43,48'}
G[81241]={'543:58.91,62.52 N:80757'}
G[81280]={'550:63.08,61.94'}
G[81284]={'539:57.48,57.28'}
G[81292]={'539:44.92,38.51'}
G[81308]={'553:46.32,32.68'}
G[81319]={'550:82.86,45.02 N:74651'}
G[81324]={'539:56.72,23.44'}
G[81335]={'550:55.57,55.91 N:74272'}
G[81346]={'581:44.84,53.01'}
G[81347]={'581:43.15,45.74'}
G[81361]={'550:83.79,76.84'}
G[81409]={'550:58.60,59.82'}
G[81412]={'550:66.97,33.75 N:81039'}
G[81415]={'550:66.94,33.79 N:70860'}
G[81443]={'542:58.48,92.20 N:55521'}
G[81492]={'581:38.26,36.73'}	-- garrison level 2 location, using for garrison level 3 location as well which is so close: 971:38.30,37.01
G[81499]={'539:49.80,81.49'}
G[81514]={'542:61.93,42.24'}
G[81518]={'543:45.94,52.69'}
G[81528]={'543:42.50,59.69'}
G[81529]={'543:38.96,51.16'}
G[81530]={'539:50.00,81.22'}
G[81537]={'543:51.71,66.37'}
G[81540]={'543:51.83,41.28'}
G[81541]={'539:49.28,78.12'}
G[81542]={'539:48.89,81.11'}
G[81543]={'539:47.81,80.37'}
G[81548]={'543:46.12,46.69'}
G[81561]={'543:45.42,77.56'}
G[81575]={'543:42.06,79.23'}
G[81588]={'543:46.08,76.85 N:78568'}
G[81589]={'543:46.11,76.65 N:80987'}
G[81590]={'543:46.05,76.67 N:78994'}
G[81600]={'543:42.11,83.44 N:47267'}
G[81601]={'Near543 N:47267'}
G[81617]={'543:49.42,70.93'}
G[81627]={'539:55.96,32.84'}
G[81630]={'543:47,72'}
G[81631]={'543:49.47,70.94'}
G[81634]={'543:49.46,70.94'}
G[81637]={'539:46.57,77.91'}
G[81659]={'543:47.61,72.74'}
G[81674]={'543:45.87,54.97'}
G[81678]={'526:28.28,45.72'}
G[81685]={'543:45.6,58.8'}
G[81688]={'587:62.05,73.88'}
G[81691]={'544:48.77,30.10'}
G[81697]={'539:46.04,80.57'}
G[81718]={'550:51.37,56.11'}
G[81721]={'543:49.50,48.62'}
G[81731]={'543:49.36,49.66'}
G[81738]={'543:51.89,49.93'}
G[81747]={'543:51.03,51.60'}
G[81749]={'543:54.25,52.55'}
G[81751]={'545:50.10,22.41 N:14627'}
G[81761]={'577:62.20,52.93'}
G[81762]={'577:62.27,52.97'}
G[81763]={'577:62.21,52.94'}
G[81765]={'624:62.10,23.02'}
G[81770]={'542:48.56,44.48 N:79519'}
G[81772]={'543:47.78,93.27 N:80987'}
G[81773]={'542:59.12,79.18 N:81109'}
G[81775]={'543:48.29,47.60'}
G[81784]={'542:59.10,79.22 N:81128'}
G[81789]={'535:55.64,67.77'}
G[81790]={'550:82.58,46.76 N:18261'}
G[81791]={'543:48.13,94.64'}
G[81794]={'550:64.23,59.57 N:81280'}
G[81797]={'550:82.60,46.63 N:18261'}
G[81858]={'539:50.60,82.57'}
G[81870]={'588:45.97,76.23'}
G[81875]={'542:35.49,25.90'}
G[81890]={'542:45.94,46.32'}
G[81891]={'542:45.90,46.36 N:81960'}
G[81902]={'550:89.37,47.38'}
G[81912]={'539:55.99,32.61'}
G[81913]={'542:40.03,44.04 N:81890'}
G[81915]={'542:39.99,60.47 N:81960'}
G[81920]={'542:40.20,43.57'}
G[81929]={'542:39.90,60.87'}
G[81942]={'543:39.84,80.81'}
G[81947]={'587:62.87,34.81'}
G[81948]={'581:40.53,54.00 N:79316'}
G[81949]={'542:39.79,60.68 N:81960'}
G[81953]={'550:51.31,61.59 N:74272'}
G[81955]={'550:79.22,52.65'}
G[81959]={'542:40.27,43.43 N:81890'}
G[81960]={'542:39.13,48.94'}
G[81961]={'542:39.19,48.95 N:81890'}
G[81964]={'542:39.48,61.60 N:81960'}
G[81972]={'542:58.48,92.33 N:81109'}
G[81978]={'542:58.82,92.84 N:81109'}
G[81981]={'587:43.86,83.12'}
G[81987]={'539:55.94,32.90 N:72413'}
G[82029]={'542:38.86,50.05'}
G[82037]={'539:29.01,16.24'}
G[82055]={'542:39.47,52.29'}
G[82070]={'550:71.58,19.72 N:74272'}
G[82078]={'550:82.55,43.97'}
G[82080]={'550:82.60,43.95'}
G[82086]={'543:48.21,71.48'}
G[82092]={'550:63.53,61.42'}
G[82094]={'550:63.48,61.40'}
G[82100]={'542:38.92,48.82'}
G[82101]={'542:38.94,48.86 N:82100'}
G[82104]={'525:59.45,31.80'}
G[82112]={'539:56.93,34.71'}
G[82119]={'550:65.02,58.31'}
G[82123]={'542:32.57,29.05'}	-- ?? 962:41.74,71.49
G[82124]={'542:37.70,51.06','Upstairs in inn'}
G[82126]={'542:37.54,50.76 N:82124','Downstairs in inn'}
G[82138]={'550:71.72,19.65 N:78482'}
G[82179]={'550:55.52,55.92 N:78482'}
G[82181]={'553:46.10,32.79 N:78482'}
G[82194]={'542:37.70,53.81'}
G[82196]={'539:46.07,59.13'}
G[82212]={'542:37.67,53.87'}
G[82214]={'550:71.54,19.76 N:78482'}
G[82222]={'543:52.28,48.97 N:81731'}
G[82225]={'543:52.86,51.73 N:81731'}
G[82227]={'539:58.05,57.64'}
G[82228]={'543:42.06,85.92 N:74606'}
G[82233]={'543:42.05,85.82 N:74651'}
G[82252]={'550:62.14,62.08'}
G[82254]={'543:43.72,84.00'}
G[82256]={'539:49.02,38.62'}
G[82270]={'17:66.59,28.25 N:78554'}
G[82274]={'Near543 N:82254'} -- 949:43.07,83.73
G[82277]={'542:37.75,53.75 N:82194'}
G[82278]={'542:37.69,53.87 N:82212'}
G[82293]={'542:37.60,53.95 N:82212'}
G[82302]={'543:50.33,47.45'}
G[82318]={'539:54,21'}
G[82334]={'543:48.05,94.16 N:82254'}	-- seems Blizzard took this out of a dungeon map 949[17]:50.09,22.35
G[82337]={'543:47.71,93.31 N:74651'}
G[82338]={'543:47.78,93.27 N:74606'}
G[82348]={'539:56.19,32.38 N:78554'}
G[82366]={'539:53.37,67.50'}
G[82375]={'542:36.82,56.94 N:55122'}
G[82402]={'542:36.88,56.67 N:81890'}
G[82403]={'542:36.84,56.78 N:81960'}
G[82437]={'543:59.52,65.93'}
G[82439]={'543:47.64,72.74'}
G[82447]={'17:52.00,28.52'}
G[82466]={'581:47,45'}
G[82468]={'542:61.59,72.85 N:81109'}
G[82476]={'543:58.26,59.90'}
G[82477]={'543:58.97,62.50 N:82476'}
G[82486]={'550:89.00,40.94'}
G[82496]={'539:54,45'}
G[82497]={'539:55,41'}
G[82499]={'543:59.51,57.90'}
G[82509]={'542:47.12,45.85 N:75323'}
G[82537]={'539:56.69,23.01'}
G[82569]={'543:57.05,71.93'}
G[82574]={'543:55.93,71.54 N:85147'}
G[82575]={'543:55.93,71.54 N:85119'}
G[82599]={'550:69.93,52.50'}
G[82610]={'543:46.26,66.70'}
G[82612]={'542:39.55,43.34'}
G[82616]={'525:48.51,24.39'}
G[82621]={'542:50.28,36.70 N:79519'}
G[82622]={'542:41.11,42.89'}
G[82658]={'550:71.11,52.42'}
G[82660]={'588:44.77,74.61'}
G[82664]={'542:39.35,59.82'}
G[82669]={'542:39.24,62.84'}
G[82688]={'550:74,36'}
G[82691]={'542:40.00,43.20'}
G[82709]={'542:39.60,61.20 N:9296'}
G[82713]={'542:56.01,40.85'}
G[82720]={'542:46.54,45.61 N:75288'}
G[82727]={'550:78.29,52.59'}
G[82732]={'543:46.26,69.98'}
G[82746]={'550:67.14,56.04'}
G[82755]={'550:73.52,58.01'}
G[82758]={'550:66.88,51.21'}
G[82759]={'542:56.18,42.54'}
G[82764]={'550:52.48,55.76'}
G[82776]={'581:33.03,35.22'}	-- garrison level 3 location
G[82778]={'550:66.70,56.28'}
G[82786]={'542:60.07,53.55'}
G[82788]={'542:60.20,53.15'}	-- ? 948:60.06,53.63
G[82813]={'542:46.63,46.75'}
G[82816]={'543:44.29,61.65 N:21984'}
G[82826]={'550:76.98,64.34'}
G[82832]={'543:44.29,61.65 N:21984'}
G[82833]={'525:46.41,15.89'}
G[82851]={'17:71.82,47.75 N:4949'}
G[82881]={'539:60.96,24.44'}
G[82893]={'588:43.97,75.34'}
G[82901]={'588:44.79,74.99'}
G[82905]={'543:62.04,53.39'}
G[82909]={'588:43.30,76.66'}
G[82912]={'550:89.56,72.99'}
G[82920]={'535:31.38,27.05'}
G[82922]={'535:37.26,14.67'}
G[82928]={'535:38.18,12.34'}
G[82930]={'535:41.04,42.22'}
G[82942]={'535:33.48,37.91'}
G[82966]={'588:44.76,74.44'}
G[82975]={'550:74.89,11.83'}
G[82988]={'535:37.45,37.39'}
G[82996]={'535:33.54,37.06'}
G[83006]={'581:42.55,52.23'}
G[83008]={'535:47.88,25.17'}
G[83011]={'535:35.05,39.00'}
G[83017]={'535:38.23,12.32'}
G[83051]={'550:49.91,37.09'}
G[83052]={'550:49.90,37.08'}
G[83053]={'550:41.82,36.99'}
G[83054]={'550:41.82,36.99 N:79627'}
G[83058]={'554:25.46,27.21'}
G[83325]={'504:63.24,72.29'}
G[83405]={'543:44.59,61.31'}
G[83409]={'550:40.97,50.04'}
G[83428]={'550:70.40,29.46'}
G[83439]={'587:47.33,37.42'}
G[83448]={'543:50.87,79.91'}
G[83449]={'543:50.45,77.07'}
G[83450]={'543:50.44,76.99'}
G[83455]={'539:51.45,61.61'}
G[83458]={'543:45.6,58.8'}
G[83463]={'542:43.90,48.90'}
G[83482]={'587:47.24,38.11'}	-- garrison level 1 location
G[83489]={'543:45.60,52.82'}
G[83491]={'581:50.05,42.14'}	-- garrison level 1 location
G[83494]={'539:59.08,82.27'}
G[83504]={'587:47.33,37.42'}
G[83509]={'550:93.04,28.47'}
G[83526]={'550:57.87,84.02'}
G[83529]={'542:40.10,43.34 N:44637'}
G[83542]={'550:60.92,47.97'}
G[83549]={'542:39.67,60.85 N:83904'}
G[83569]={'543:46.04,54.75 N:21984'}
G[83570]={'550:36.48,14.52'}
G[83575]={'550:39.69,14.80'}
G[83577]={'550:35.41,19.88'}
G[83603]={'550:80.65,30.48'}
G[83606]={'550:82.85,46.73'}
G[83608]={'542:52.07,23.54 N:44637'}
G[83609]={'542:52.10,23.54 N:83904'}
G[83612]={'595:68.97,41.17'}
G[83616]={'595:68.41,46.78'}
G[83634]={'550:54.81,61.28'}
G[83653]={'542:54.03,23.30'}
G[83680]={'550:61.64,68.89'}
G[83686]={'550:39.63,24.61'}
G[83723]={'550:55.57,55.91 N:74272'}
G[83730]={'550:55.47,55.92 N:78482'}
G[83734]={'550:39.61,24.53 N:83686'}
G[83772]={'542:53.51,27.46 N:44637'}
G[83773]={'542:53.59,27.50 N:83904'}
G[83774]={'543:47.72,52.07'}
G[83820]={'543:44.93,86.88'}
G[83823]={'535:85.18,31.71 N:78558'}
G[83837]={'543:51.07,70.58'}
G[83846]={'620:50.52,66.32'}
G[83848]={'550:40.08,16.16'}
G[83858]={'581:39.18,42.70'}
G[83869]={'588:45.77,28.80'}
G[83888]={'550:53.70,15.01'}
G[83899]={'542:57.07,34.51 N:44637'}
G[83900]={'542:57.13,34.51 N:83904'}
G[83903]={'542:57.10,34.52 N:44637'}
G[83904]={'542:57.14,34.53'}
G[83929]={'535:84.80,31.52 N:78430'}
G[83940]={'542:58.08,36.31'}
G[83959]={'542:46.51,46.82 N:23066'}
G[83995]={'588:45.27,27.13'}
G[84002]={'539:59.51,94.46'}
G[84095]={'535:49.23,88.01'}
G[84122]={'542:46.65,46.75'}
G[84131]={'543:43.94,48.85 N:21984'}
G[84173]={'588:44.61,73.91'}
G[84176]={'543:38.77,73.61'}
G[84185]={'543:40.95,43.07 N:41006'}
G[84223]={'588:42.81,76.81 N:26814'}
G[84243]={'542:47.18,31.74'}
G[84247]={'525:48.80,67.39'}
G[84248]={'581:51.21,47.04'}	-- plot 25
G[84259]={'542:40.11,43.22'}
G[84261]={'542:39.67,60.87'}
G[84262]={'542:46.50,54.33 N:79519'}
G[84263]={'550:84.06,36.79'}
G[84268]={'581:28.73,35.04 N:79953'}	-- garrison level 3, but her location is 971:28.85,35.39 after the shipyard is upgraded to level 3 because there is a ship table in the garrison from that point on
G[84270]={'581:29.30,34.83 N:79243'}	-- garrison level 3
G[84276]={'542:51.35,50.28 N:79519'}
G[84286]={'581:40.35,61.17'}
G[84291]={'542:39.51,61.68 N:84261'}
G[84292]={'542:40.08,42.72 N:84259'}
G[84334]={'535:46.44,27.74'}
G[84347]={'550:77.05,16.63'}
G[84367]={'535:45.34,31.51'}
G[84372]={'539:26.95,7.27'}
G[84385]={'539:44.23,40.93'}
G[84407]={'550:79.19,52.66'}
G[84435]={'550:45.74,15.05'}
G[84459]={'550:49.42,16.59'}
G[84473]={'588:45.11,28.03'}
G[84492]={'539:44.98,39.18'}
G[84494]={'525:46,48'}
G[84499]={'621:0.00,0.00'}
G[84506]={'525:60.28,27.20'}
G[84511]={'581:31.43,33.68 N:79953'}
G[84523]={'539:58,26'}
G[84524]={'581:35.53,49.36'}	-- plot 22
G[84550]={'621:64.79,1.22'}
G[84554]={'621:65.35,1.64'}
G[84632]={'550:77.43,47.36'}
G[84637]={'550:62.97,36.00 N:18471'}
G[84660]={'588:47.14,26.66'}
G[84684]={'581:29.65,34.24 N:79953'}
G[84689]={'525:20,60'}
G[84702]={'550:77.13,36.87 N:78558'}
G[84706]={'550:88.41,22.48'}
G[84720]={'550:56.90,19.11'}
G[84724]={'539:57.85,21.53'}
G[84726]={'550:86.65,28.32'}
G[84728]={'539:58.31,20.84'}
G[84739]={'525:54.39,51.74 N:84966'}
G[84743]={'543:46.19,55.09 N:81202'}
G[84747]={'525:55.92,48.61'}
G[84748]={'543:43.93,48.82 N:81202'}
G[84764]={'550:56.95,18.46'}
G[84776]={'581:43,54'}
G[84784]={'550:56.77,12.90 N:22893'}
G[84807]={'542:47.28,29.18'}
G[84811]={'543:55.91,71.57'}
G[84825]={'539:60.86,32.64'}
G[84830]={'539:46.96,38.65'}
G[84837]={'588:36.49,37.79'}
G[84857]={'581:46.99,59.27'}	-- plot 18
G[84861]={'550:86.65,28.32'}
G[84866]={'542:43.73,47.07'}
G[84871]={'535:44.34,37.95'}
G[84889]={'539:29.88,18.21 N:84892'}
G[84892]={'550:75.73,66.74'}
G[84908]={'539:51.32,81.09'}
G[84911]={'539:46.03,71.41'}
G[84925]={'539:50.15,72.39'}
G[84928]={'17:48.73,31.78 N:4949'}
G[84929]={'17:51.93,28.65 N:78554'}
G[84945]={'539:48.69,78.86'}
G[84947]={'581:35.53,49.36'}	-- plot 22 location
G[84951]={'542:34.14,58.52'}
G[84963]={'539:35.66,72.26'}
G[84965]={'542:55.13,64.43'}
G[84966]={'539:37.34,72.60'}
G[84967]={'587:57.28,53.86'}	-- Garrison level 1 location
G[84973]={'539:74.90,57.99 N:72413'}
G[84974]={'539:75.13,57.89 N:79537'}
G[84975]={'539:75.19,57.53 N:80079'}
G[85043]={'542:69.88,20.73'}
G[85048]={'587:51.43,57.39'}	-- plot 22 location
G[85062]={'542:62.56,73.88'}
G[85068]={'542:72.94,32.13'}
G[85077]={'543:46.36,69.65 N:85147'}
G[85080]={'542:39.98,60.66 N:55122'}
G[85089]={'543:51.30,47.99 N:81731'}
G[85106]={'525:20.08,56.39'}
G[85119]={'543:53.02,59.81'}
G[85124]={'543:45.08,26.44'}
G[85127]={'543:46.45,30.32'}
G[85130]={'543:60.71,64.78 N:85119'}
G[85146]={'578:81.32,50.20'}
G[85147]={'543:45.68,70.60'}
G[85150]={'539:63.10,94.42'}
G[85190]={'542:68.33,38.93'}
G[85199]={'550:65.81,9.02 543:57.60,43.17'}
G[85206]={'542:44.34,12.04'}
G[85213]={'17:66.94,27.92 N:81492'}
G[85219]={'542:32.49,47.25'}
G[85247]={'17:71.88,48.97 N:26859'}
G[85278]={'543:53.31,59.73 N:82610'}
G[85289]={'587:53.81,42.54'}
G[85299]={'542:70.82,23.11'}
G[85303]={'542:71.12,22.32'}
G[85320]={'542:46.21,45.68'}
G[85344]={'581:58.87,53.45'}
G[85369]={'587:61,53'}
G[85378]={'539:46.17,31.40 N:45109'}	-- ? 947:61.47,63.29
G[85379]={'550:58.96,38.52 N:45110'}	-- ? 947:46.22,31.40
G[85413]={'581:51.21,47.04 N:45109'}	-- entrance to plot 25
G[85414]={'587:57.75,28.14 N:45110'}	-- plot 25 location
G[85418]={'581:28.49,38.64'}
G[85425]={'542:47.13,31.68'}
G[85426]={'543:49.40,49.65 N:85436'}
G[85431]={'543:50.88,51.39 N:85436'}	-- Sparring Arena-based location
G[85432]={'543:51.32,47.96 N:85436'}
G[85434]={'535:75.94,43.92'}
G[85436]={'543:52.87,51.78'}
G[85439]={'525:21,56'}
G[85440]={'525:61,71'}
G[85453]={'542:45.62,29.40'}
G[85514]={'581:42.79,45.41'}
G[85519]={'407:47.27,61.99'}
G[85520]={'542:52.90,54.97'}
G[85524]={'543:44.09,63.26'}
G[85538]={'543:44.91,63.99'}
G[85540]={'543:48.08,52.17'}
G[85545]={'525:51.75,21.44'}
G[85546]={'407:48.38,71.36'}
G[85550]={'542:39.66,60.66'}
G[85562]={'543:49.43,49.59'}
G[85566]={'542:40.03,43.92'}
G[85572]={'535:22.25,74.17'}
G[85598]={'542:44.41,24.04 N:75323'}
G[85601]={'543:46.48,93.57 N:82254'}
G[85694]={'543:53,68'}
G[85695]={'543:53,67'}
G[85708]={'581:53.02,14.88'}
G[85718]={'543:44.52,91.53'}
G[85725]={'543:44.66,90.51'}
G[85749]={'588:44.10,74.17'}
G[85751]={'525:20.70,60.22'}
G[85777]={'581:53.26,69.08 N:77031'}	-- garrison level 2 position
G[85779]={'543:50,75'}
G[85786]={'543:51.28,66.24'}
G[85807]={'543:61.47,57.61'}
G[85839]={'581:42.13,45.27'}
G[85840]={'624:42.55,36.40'}
G[85849]={'622:29.65,52.92'}
G[85857]={'581:34.23,32.82'}
G[85882]={'581:62,73'}
G[85889]={'542:61.61,72.80 N:81280'}
G[85892]={'542:50.66,77.19'}
G[85902]={'542:63.05,23.24'}
G[85924]={'543:41,54.6'}
G[85960]={'543:40.14,60.27'}
G[85980]={'543:44.07,48.82'}
G[85984]={'581:53.67,14.60 N:12919'}
G[86024]={'539:50.22,75.86'}
G[86044]={'542:63.21,23.33'}
G[86065]={'622:31.99,50.00'}
G[86069]={'622:35.54,75.80'}
G[86084]={'622:47.98,30.64'}
G[86144]={'542:73.27,42.22'}
G[86155]={'542:74.73,44.25'}
G[86205]={'542:73.79,43.14'}
G[86213]={'539:50.95,79.00'}
G[86260]={'543:57.91,42.70'}
G[86264]={'543:59.47,32.82'}
G[86272]={'503:56.69,76.03'}
G[86312]={'624:44.16,45.46'}
G[86315]={'624:45.54,34.61'}
G[86355]={'542:64.29,37.11 N:80648'}
G[86381]={'542:50.95,55.95'}
G[86390]={'622:51.46,61.59'}
G[86393]={'553:46.11,34.65 N:74272'}
G[86419]={'542:66.50,51.59 N:80758'}
G[86439]={'543:48.4,47.2'}
G[86442]={'535:69.61,20.80'}
G[86475]={'542:64.10,37.01 N:80758'}
G[86499]={'543:45.67,26.72'}
G[86501]={'543:46.36,69.70 N:85147'}
G[86502]={'543:53.02,59.81 N:61020'}
G[86521]={'543:53.29,59.79 N:81280'}
G[86522]={'535:67.54,42.12'}
G[86531]={'535:39.29,38.51'}
G[86536]={'543:50.06,21.66'}
G[86562]={'543:49.58,32.87'}
G[86563]={'627:72.48,45.66 N:78558'}
G[86566]={'543:48.25,20.87'}
G[86577]={'543:45.95,27.91'}
G[86579]={'543:46.01,31.84'}
G[86589]={'581:46.11,45.81'}
G[86597]={'542:35.79,52.20'}
G[86614]={'587:50.91,50.65'}	-- Garrison Level 1 position
G[86629]={'587:51.43,57.39'}	-- plot 22 location
G[86659]={'550:45.83,36.88'}
G[86677]={'581:52.01,44.82'}
G[86696]={'587:52.44,37.06'}	-- plot 18 location
G[86832]={'86:48.11,70.51 N:38966'}
G[86884]={'1:57.68,9.70'}
G[86927]={'Near N:86084'}
G[86934]={'Near N:79979'}
G[86946]={'542:43.83,24.63 N:23066'}
G[86949]={'535:85.01,31.06'}
G[86959]={'550:45.93,34.87'}
G[86964]={'550:46.69,57.48 N:87561'}
G[86973]={'581:45.25,42.49 N:46804'}	-- plot 23 location
G[86974]={'581:45.25,42.49'}	-- plot 23 location
G[86979]={'587:58.88,49.06 N:27221'}	-- plot 23 location
G[87056]={'587:62.18,35.74'}
G[87110]={'550:56.23,9.81'}
G[87116]={'587:51.70,58.70 N:87121'}
G[87121]={'587:51.43,57.39'}	-- plot 22 location
G[87122]={'525:68.63,64.68'}
G[87123]={'542:46.30,45.31'}
G[87124]={'539:50.03,31.26'}
G[87125]={'535:49.08,80.40'}
G[87206]={'581:35.53,49.36'}	-- plot 22 location
G[87207]={'581:52.13,45.48'}
G[87212]={'581:34.62,49.00 N:87215'}
G[87213]={'581:52.51,45.30'}
G[87215]={'581:34.58,49.18'}
G[87216]={'581:34.64,49.24 N:87215'}
G[87217]={'581:35.53,49.36 N:87215'}	-- plot 22 location
G[87242]={'587:58.88,49.06 N:26584'}	-- plot 23 location
G[87305]={'587:51.43,57.39'}	-- plot 22 location
G[87341]={'535:38.85,49.79'}
G[87344]={'550:42.10,36.92'}
G[87346]={'525:73.53,26.65'}
G[87368]={'630:52.20,43.44'}
G[87391]={'622:51.82,61.45'}
G[87393]={'550:50.37,41.28'}
G[87561]={'542:54.20,62.97'}
G[87698]={'539:62.91,33.50'}
G[87700]={'539:56.59,37.14'}
G[87706]={'550:50.26,41.12 N:79201'}
G[87764]={'535:69.46,5.81'}
G[87788]={'550:36.93,24.48'}
G[87971]={'525:74.95,30.05'}
G[87991]={'581:35.53,49.36'}	-- plot 22
G[87992]={'581:35.53,49.36 N:46854'}	-- plot 22
G[87994]={'581:35.53,49.36'}	-- plot 22
G[87995]={'581:35.53,49.36 N:2487'}	-- plot 22
G[87996]={'581:35.53,49.36 N:64842'}	-- plot 22
G[87997]={'581:35.53,49.36 N:11036'}	-- plot 22
G[87998]={'581:35.53,49.36 N:58113'}	-- plot 22
G[87999]={'581:35.53,49.36 N:40997'}	-- plot 22
G[88000]={'581:35.53,49.36 N:49444'}	-- plot 22
G[88001]={'581:35.53,49.36 N:38237'}	-- plot 22
G[88002]={'581:35.53,49.36 N:28444'}	-- plot 22
G[88003]={'581:35.53,49.36'}	-- plot 22
G[88004]={'581:35.53,49.36'}	-- plot 22
G[88005]={'581:35.53,49.36 N:54961'}	-- plot 22
G[88006]={'581:35.53,49.36'}	-- plot 22
G[88007]={'581:35.53,49.36'}	-- plot 22
G[88009]={'581:35.53,49.36'}	-- plot 22
G[88013]={'581:35.53,49.36 N:47269'} -- plot 22
G[88017]={'581:35.53,49.36 N:46338'} -- plot 22
G[88022]={'581:35.53,49.36 N:47869'}	-- plot 22
G[88023]={'581:35.53,49.36 N:61021'} -- plot 22
G[88024]={'581:35.53,49.36 N:9177'} -- plot 22
G[88025]={'581:35.53,49.36 N:39930'}	-- plot 22
G[88026]={'581:35.53,49.36 N:43184'}	-- plot 22
G[88027]={'581:35.53,49.36 N:47366'} -- plot 22
G[88078]={'542:51.18,11.68'}
G[88084]={'630:44.47,39.44'}
G[88086]={'630:53.68,43.95'}
G[88087]={'630:53.03,44.04'}
G[88089]={'630:49.82,38.45'}
G[88090]={'630:45.04,36.88'}
G[88099]={'630:50.18,34.93'}
G[88100]={'630:52.00,42.09'}
G[88101]={'630:50.57,44.71'}
G[88112]={'581:47.38,89.11 N:41003'}
G[88115]={'630:47.00,41.37 N:88867'}
G[88117]={'630:51.96,44.37'}
G[88145]={'581:46.99,59.27'}	-- plot 18
G[88155]={'622:52.03,63.54'}
G[88161]={'624:65.04,59.17'}
G[88173]={'542:39.67,43.06 N:44637'}
G[88179]={'542:40.10,43.36 N:44637'}
G[88187]={'550:35.53,22.13'}
G[88193]={'542:39.42,62.17 N:83609'}
G[88195]={'542:39.73,60.90 N:83904'}
G[88208]={'550:58.15,18.66'}
G[88223]={'581:37.73,35.92 N:78564'}	-- garrison level 2 location ? 37.67,36.23
G[88228]={'587:43.65,47.81'}	-- garrison level 2 location
G[88240]={'550:52.38,19.17'}
G[88276]={'539:43.56,77.29 N:67996'}
G[88279]={'543:58.17,44.27'}
G[88358]={'550:79.68,30.25'}
G[88361]={'550:79.69,30.18'}
G[88392]={'587:52.44,37.06'}	-- plot 18
G[88394]={'543:55.80,43.83'}
G[88412]={'543:44.04,61.55'}
G[88437]={'525:43.47,20.47'}
G[88448]={'588:45.85,28.94 N:47571'}
G[88478]={'550:59.22,16.26'}
G[88487]={'542:54.28,62.96 N:81280'}
G[88494]={'535:37.74,20.62'}
G[88500]={'550:79.46,30.29'}
G[88530]={'543:40.94,43.01 N:41005'}
G[88545]={'581:46.99,59.27'}	-- plot 18
G[88546]={'587:52.44,37.06'}	-- plot 18
G[88570]={'624:64.02,62.06'}
G[88643]={'542:36.46,39.73'}
G[88674]={'542:50.52,32.00'}
G[88782]={'630:47.71,37.75'}
G[88798]={'630:47.06,41.48'}
G[88811]={'550:79.78,29.41'}
G[88855]={'630:62.67,41.24'}
G[88859]={'631:25.32,37.60'}
G[88863]={'630:50.34,61.02'}
G[88867]={'630:51.78,44.29'}
G[88870]={'630:48.86,42.12'}
G[88873]={'630:50.01,48.55'}
G[88890]={'630:54.18,42.01 N:88867'}
G[88892]={'581:61.07,79.30'}
G[88906]={'550:58.51,15.00'}
G[88923]={'630:47.94,48.66'}
G[88932]={'630:48.24,49.09'}
G[88946]={'550:60.44,16.25'}
G[88972]={'539:66.43,26.16 N:79537'}
G[89007]={'630:49.33,50.72'}
G[89009]={'630:57.86,43.35 N:88867'}
G[89016]={'630:41.91,41.90'}
G[89023]={'630:48.38,34.54'}
G[89024]={'630:63.90,41.56'}
G[89025]={'630:61.32,38.60'}
G[89048]={'630:47.97,48.65 N:88923'}
G[89050]={'630:48.06,49.15'}
G[89051]={'630:53.45,62.90 N:88873'}
G[89053]={'630:62.98,57.73'}
G[89056]={'630:48.11,49.01'}
G[89061]={'542:46.80,9.10'}
G[89063]={'542:59.70,11.42'}
G[89082]={'630:49.21,46.54'}
G[89090]={'630:57.81,43.36'}
G[89097]={'632:42.90,31.58'}
G[89101]={'630:53.46,63.73'}
G[89158]={'539:59.78,94.47 N:1229314'}
G[89179]={'543:54.24,55.87 N:41005'}
G[89199]={'632:70.06,47.25'}
G[89257]={'630:56.40,59.26'}
G[89283]={'630:64.63,56.62'}
G[89284]={'630:63.43,56.50'}
G[89287]={'630:63.92,63.72'}
G[89288]={'630:60.13,59.34'}
G[89290]={'630:62.57,59.40'}
G[89326]={'630:53.28,45.31'}
G[89341]={'630:47.12,41.42'}
G[89350]={'630:63.92,63.72'}
G[89362]={'630:43.53,43.47 N:93011'}
G[89386]={'630:47.35,45.90'}
G[89393]={'630:56.94,14.90'}
G[89398]={'630:43.30,43.16 N:95238'}
G[89400]={'534:16.11,44.37 N:79519'}
G[89640]={'630:43.67,43.15'}
G[89650]={'630:47.25,33.94'}
G[89653]={'630:51.56,32.48'}
G[89660]={'631:53.40,47.60'}
G[89661]={'631:28.89,42.42'}
G[89673]={'630:44.47,44.72'}
G[89675]={'534:50.57,42.79'}
G[89683]={'534:25.72,32.02'}
G[89686]={'534:26.52,30.70'}
G[89699]={'534:20.96,51.84'}
G[89706]={'534:21.98,54.44'}
G[89731]={'630:40.29,49.49'}
G[89741]={'534:57.05,65.65'}
G[89744]={'534:44.99,72.50'}
G[89746]={'534:57.69,76.02'}
G[89749]={'534:61.12,75.76'}
G[89753]={'587:40.16,56.67 N:25256'}	-- garrison level 3 location  ? 976:39.96,57.53
G[89754]={'534:50.59,44.29'}
G[89759]={'649:19.66,47.30'}
G[89763]={'581:34.14,32.81 N:38607'}
G[89777]={'534:43.14,35.97'}
G[89793]={'581:34.22,32.75 N:26814'}
G[89794]={'630:47.97,27.17'}
G[89795]={'630:47.99,27.13'}
G[89801]={'630:57.37,14.27'}
G[89802]={'630:59.03,41.55'}
G[89803]={'630:58.80,38.68'}
G[89805]={'581:34.18,32.66'}
G[89806]={'587:40.22,56.02 N:16575'}
G[89810]={'534:40.07,35.75'}
G[89816]={'630:65.48,39.94'}
G[89822]={'534:73.43,71.12 N:74651'}
G[89829]={'634:31.09,55.98'}
G[89834]={'631:61.40,69.32'}
G[89846]={'630:53.45,43.98'}
G[89849]={'631:52.98,47.82'}
G[89850]={'630:59.67,55.16'}
G[89857]={'534:39.52,34.23'}
G[89865]={'630:50.01,35.10'}
G[89884]={'630:45.43,57.76'}
G[89935]={'534:39.44,38.83'}
G[89936]={'534:41.21,35.40'}
G[89937]={'543:56.14,6.65'}
G[89975]={'630:47.95,26.99'}
G[89978]={'630:53.40,16.31'}
G[90005]={'630:57.83,16.30'}
G[90024]={'534:42.09,37.86'}
G[90057]={'630:51.03,31.57'}
G[90065]={'630:46.65,15.78 N:89794'}
G[90066]={'534:51.15,43.08'}
G[90071]={'542:60.43,12.39'}
G[90074]={'534:40.24,35.31'}
G[90107]={'539:56.68,92.27'}
G[90109]={'630:49.31,59.84'}
G[90122]={'534:37,33'}
G[90134]={'630:41.72,31.43'}
G[90139]={'634:63.58,74.54'}
G[90164]={'630:47.35,53.39'}
G[90167]={'630:49.67,15.37 N:90423'}
G[90173]={'630:47.55,51.73'}
G[90176]={'525:70.11,26.86'}
G[90177]={'543:56.74,17.16'}
G[90180]={'543:52.57,9.85 N:80079'}
G[90211]={'534:73.64,43.34'}
G[90217]={'630:49.52,8.72','In cave'}
G[90230]={'630:43.24,44.72'}
G[90233]={'535:67.43,6.57 N:78558'}
G[90237]={'535:67.50,6.63 N:45675'}
G[90238]={'534:69.53,54.18'}
G[90241]={'630:42.77,43.92'}
G[90244]={'630:59.68,12.01'}
G[90250]={'24:52.24,77.95'}
G[90255]={'630:41.25,50.51 N:97644'}
G[90262]={'543:57.14,26.75'}
G[90265]={'534:26.01,30.64'}
G[90286]={'534:32.35,72.25'}
G[90309]={'534:58.50,60.35 N:90177'}
G[90312]={'534:21.47,37.88'}
G[90313]={'630:55.31,27.89'}
G[90317]={'630:43.17,43.61 N:109196'}
G[90318]={'630:55.60,14.86'}
G[90369]={'627:74.94,48.29 N:11034'}	-- 23:74.27,53.25
G[90377]={'630:57.84,12.29'}
G[90379]={'630:49.83,15.57'}
G[90380]={'630:44.98,14.28'}
G[90383]={'630:53.79,16.82 N:91131'}
G[90389]={'630:56.66,17.69'}
G[90390]={'630:57.21,16.37'}
G[90412]={'542:72.82,32.58'}
G[90417]={'627:28.51,48.32 N:78558'}
G[90418]={'627:28.45,48.91 N:67996'}
G[90421]={'534:26.39,76.88'}
G[90423]={'630:49.39,15.53'}
G[90425]={'534:31.77,70.74'}
G[90426]={'534:31.71,67.05'}
G[90429]={'534:31.26,71.97'}
G[90434]={'534:30.74,68.42'}
G[90437]={'534:26.63,75.20'}
G[90438]={'534:26.15,76.28'}
G[90443]={'534:10.73,54.95'}
G[90452]={'534:12.90,56.00'}
G[90463]={'627:28.63,48.21'}
G[90473]={'407:53.25,87.60'}
G[90474]={'Near630 N:97644'}
G[90480]={'630:47.39,9.17'}
G[90481]={'534:61.51,45.84 N:74651'}
G[90482]={'534:16.23,56.89'}
G[90497]={'534:12.76,56.83'}
G[90505]={'630:67.12,51.63'}
G[90517]={'534:31.67,68.25'}
G[90519]={'534:44.83,37.83'}
G[90526]={'630:45.78,11.13'}
G[90537]={'630:45.55,12.67'}
G[90542]={'630:42.65,8.04'}
G[90543]={'630:48.90,26.40 N:90916'}
G[90547]={'630:42.88,8.48'}
G[90553]={'534:9.68,56.22 N:70860'}
G[90584]={'534:44.22,41.54'}
G[90585]={'534:12.82,56.10'}
G[90616]={'630:56.97,13.94'}
G[90620]={'534:20.83,38.07'}
G[90621]={'630:35.65,53.37'}
G[90644]={'534:47.28,70.48'}
G[90648]={'630:44.46,10.69'}
G[90649]={'534:19.34,40.87'}
G[90659]={'630:38.79,57.59'}
G[90660]={'630:39.64,47.39'}
G[90661]={'630:39.64,46.98'}
G[90675]={'581:29.02,40.47'}
G[90703]={'534:25.89,76.11'}
G[90738]={'630:49.94,26.55 N:89794'}
G[90748]={'634:35.83,47.95'}
G[90749]={'634:33.71,51.02 N:66292'}
G[90782]={'534:17.20,42.68'}
G[90783]={'634:33.76,50.76 N:54614'}
G[90785]={'634:34.01,50.45'}
G[90803]={'630:35.39,50.35'}
G[90851]={'534:20.25,51.20'}
G[90866]={'634:33.60,50.82 N:7944'}
G[90885]={'534:20.50,49.69'}
G[90887]={'534:25.20,46.42'}
G[90888]={'534:25.52,46.07'}
G[90894]={'581:34.21,32.73'}
G[90899]={'634:32.30,49.65'}
G[90901]={'630:56.04,29.13'}
G[90903]={'634:32.26,47.51'}
G[90916]={'630:48.66,16.54'}
G[90948]={'634:28.77,55.18'}
G[90963]={'534:58.14,58.68'}
G[90974]={'534:58.43,60.44'}
G[90977]={'534:58.64,60.25'}
G[90985]={'630:43.85,9.10'}
G[90991]={'534:59.85,47.50'}
G[90993]={'534:59.92,47.49'}
G[91007]={'731:19.75,57.53'}
G[91009]={'534:57.03,23.23'}
G[91014]={'581:31.29,39.61 N:91017'}
G[91017]={'581:31.17,39.58'}
G[91020]={'581:34.21,32.73'}
G[91024]={'581:34.21,32.73'}
G[91025]={'581:34.21,32.75'}
G[91026]={'587:33.84,42.42 N:91361'}
G[91029]={'587:40.16,56.67'}
G[91030]={'587:40.16,56.67'}
G[91031]={'587:40.16,56.67'}
G[91033]={'587:40.16,56.67'}
G[91034]={'587:40.16,56.67'}
G[91044]={'641:48.98,89.59'}
G[91045]={'643:59.86,82.92'}
G[91047]={'534:17.01,52.89'}
G[91048]={'630:45.47,10.83'}
G[91061]={'630:40.78,9.32 N:91065'}
G[91065]={'630:47.44,12.18'}
G[91066]={'641:48.87,70.20 N:92783'}
G[91072]={'587:40.93,47.75'}
G[91074]={'630:58.53,54.90'}
G[91093]={'534:41.06,68.68'}
G[91100]={'630:59.29,46.26'}
G[91109]={'641:51.93,64.09 N:33091'}
G[91115]={'630:61.36,62.03'}
G[91121]={'641:42.19,78.18'}
G[91122]={'641:46.60,77.27'}
G[91128]={'630:51.23,32.52'}
G[91130]={'641:45.69,77.55'}
G[91131]={'630:48.25,22.76'}
G[91144]={'676:20.42,61.55'}
G[91150]={'641:44.12,75.49'}
G[91153]={'641:47.14,69.95'}
G[91157]={'630:47.68,28.17'}
G[91158]={'634:36.82,30.95'}
G[91165]={'Near630'}
G[91166]={'630:62.87,51.45 N:91165'}
G[91172]={'627:70.53,44.06 N:78558'}	-- also at 1014[10]:70.85,43.90 when doing the 39733 quest
G[91184]={'630:63.33,53.45'}
G[91187]={'630:32.28,29.83'}
G[91195]={'587:40.48,56.09 N:25256'}
G[91196]={'581:34.23,32.63 N:38607'}
G[91202]={'634:39.72,67.55'}
G[91204]={'634:44.16,69.97'}
G[91205]={'634:45.62,71.57'}
G[91222]={'634:37.38,63.85'}
G[91223]={'641:49.66,85.83'}
G[91227]={'534:22.06,50.57'}
G[91240]={'634:46.26,72.59'}
G[91242]={'543:56.75,17.23'}
G[91243]={'534:13.51,56.85'}
G[91244]={'634:43.33,75.26'}
G[91249]={'634:44.80,77.42 N:96465'}
G[91250]={'534:10.06,54.43'}
G[91251]={'534:16.36,58.41'}
G[91288]={'641:48.42,84.56'}
G[91289]={'630:52.49,22.92'}
G[91290]={'534:57.43,58.88 N:79519'}
G[91291]={'534:25.78,38.87 N:79519'}
G[91292]={'534:60.46,46.24 N:79519'}
G[91299]={'534:27.06,44.42 N:48559'}
G[91308]={'630:59.62,17.12'}
G[91313]={'534:31.87,36.99'}
G[91318]={'641:48.71,88.36'}
G[91324]={'534:33.45,37.31'}
G[91348]={'534:26.75,44.21'}
G[91351]={'534:32.57,37.47 N:48559'}
G[91354]={'641:53.80,79.79'}
G[91361]={'587:33.40,42.30'}
G[91362]={'587:33.68,42.34 N:91361'}
G[91364]={'587:33.37,42.84 N:91361'}	-- garrison level 3
G[91371]={'630:45.27,11.99'}
G[91384]={'649:59.92,40.10'}
G[91387]={'649:34.32,28.16'}
G[91403]={'630:61.69,41.10 N:88867'}
G[91404]={'581:34.21,32.74'}	-- garrison level 3
G[91414]={'634:38.81,20.75'}
G[91417]={'634:42.64,65.72'}
G[91419]={'630:56.61,59.60'}
G[91423]={'634:39.50,65.25'}
G[91431]={'631:68.83,13.73'}
G[91457]={'630:56.62,59.56'}
G[91458]={'634:35.00,36.57'}
G[91459]={'646:0.00,0.00'}
G[91462]={'641:54.69,72.85 N:33091'}
G[91470]={'634:33.35,31.41'}
G[91472]={'641:54.19,85.81'}
G[91473]={'634:36.08,27.56'}
G[91474]={'641:53.84,81.64'}
G[91481]={'634:42.02,64.49 N:91222'}
G[91486]={'634:45.19,70.33'}
G[91519]={'634:43.80,68.21 N:91222'}
G[91527]={'649:64.49,43.88'}
G[91529]={'634:41.47,66.74'}
G[91531]={'649:64.58,43.35'}
G[91535]={'634:36.91,31.44'}
G[91553]={'634:46.24,70.37 N:91222'}
G[91558]={'Near634 N:91222'}
G[91566]={'634:44.07,81.44'}
G[91569]={'634:34.69,26.78'}
G[91571]={'535:44.30,65.39 N:90177'}
G[91573]={'534:32.79,37.48 N:81280'}
G[91575]={'649:54.65,39.99'}
G[91579]={'630:43.14,28.16'}
G[91581]={'634:39.56,19.32'}
G[91589]={'581:33.77,36.37'}
G[91590]={'634:36.11,27.36'}
G[91593]={'543:51.06,10.95'}
G[91596]={'543:49.69,11.60'}
G[91598]={'641:46.89,68.78'}
G[91601]={'543:51.16,15.26'}
G[91645]={'641:49.31,87.78'}
G[91650]={'641:65.18,67.03 N:100573'}
G[91657]={'649:21.78,60.76'}
G[91721]={'534:48.09,44.96'}
G[91731]={'627:47.30,33.45'}
G[91737]={'634:41.69,81.48'}
G[91750]={'535:44.32,65.33 N:75121'}
G[91751]={'535:44.30,65.39 N:90177'}
G[91756]={'630:57.22,31.20'}
G[91758]={'630:49.46,57.75'}
G[91759]={'634:45.36,80.05'}
G[91760]={'534:46.50,41.93'}
G[91764]={'534:46.99,44.36'}
G[91771]={'634:37.30,63.72'}
G[91780]={'634:35.48,18.48'}
G[91795]={'634:49.61,71.81'}
G[91797]={'713:0.00,0.00'}
G[91803]={'634:46.56,83.92'}
G[91818]={'649:69.70,29.54'}
G[91824]={'634:32.69,51.72'}
G[91847]={'641:40.30,59.79'}
G[91860]={'641:40.26,52.37'}
G[91866]={'24:73.79,19.68'}
G[91871]={'534:52.79,39.99'}
G[91874]={'634:46.08,77.26'}
G[91892]={'634:40.67,72.39'}
G[91894]={'634:41.16,71.90'}
G[91895]={'634:41.38,71.70'}
G[91913]={'534:73.42,71.12 N:90177'}
G[91923]={'572:69.47,52.98 N:80079'}
G[91935]={'534:9.83,53.59 N:79537'}
G[91948]={'649:45.69,64.86'}
G[91954]={'393:75.10,43.74'}
G[92002]={'534:57.63,24.37'}
G[92026]={'534:58.64,21.33'}
G[92031]={'534:57.31,26.31'}
G[92034]={'630:49.36,45.34'}
G[92040]={'649:85.10,50.23'}
G[92055]={'534:47.37,70.38 N:21183'}
G[92083]={'534:60.12,21.36'}
G[92115]={'71:50.84,29.93'}
G[92117]={'641:60.05,77.49'}
G[92120]={'534:62.59,31.11 N:21183'}
G[92128]={'634:44.85,80.21'}
G[92152]={'634:36.37,51.88'}
G[92180]={'641:41.61,78.24'}
G[92183]={'627:44.54,28.71'}
G[92213]={'539:27.60,10.28 N:78558'}
G[92218]={'634:40.87,80.98'}
G[92219]={'581:32.03,31.94 N:29611'}
G[92223]={'581:34.27,32.82'}
G[92224]={'634:35.71,54.06'}
G[92264]={'680:29.91,53.61'}
G[92274]={'534:53.73,21.12'}
G[92317]={'534:32.79,37.47 N:48559'}
G[92321]={'641:64.07,58.45'}
G[92326]={'641:65.19,58.24'}
G[92332]={'641:65.20,59.27'}
G[92335]={'641:67.27,57.97'}
G[92338]={'534:62.76,27.85 N:21183'}
G[92383]={'641:65.90,44.00'}
G[92396]={'534:55.29,22.33'}
G[92397]={'534:52.79,19.44'}
G[92398]={'534:51.76,24.25'}
G[92400]={'587:39.13,54.84 N:38966'}	-- garrison level 3
G[92401]={'543:56.74,17.16 N:70860'}
G[92408]={'534:60,21'}
G[92414]={'636:77.23,48.27 634:31.19,57.95'}
G[92415]={'636:26.52,56.42'}
G[92420]={'641:60.57,61.47 N:40289'}
G[92423]={'641:38.19,52.77'}
G[92445]={'630:67.27,26.71'}
G[92447]={'630:66.94,26.02'}
G[92450]={'630:65.41,29.11'}
G[92451]={'534:27.52,32.76'}
G[92458]={'627:41.37,33.09'}
G[92464]={'627:42.97,33.55'}
G[92465]={'534:49.00,72.58'}
G[92466]={'534:53.80,76.46'}
G[92495]={'534:62.93,72.48'}
G[92508]={'534:63.11,80.66'}
G[92539]={'634:60.14,50.76 N:96254'}
G[92545]={'534:58.15,58.57'}
G[92546]={'534:31.88,71.33'}
G[92552]={'534:35.56,46.66'}
G[92561]={'634:44.83,59.35 N:91473'}
G[92566]={'634:46.55,67.78 N:91473'}
G[92567]={'634:43.70,67.85 N:91473'}
G[92569]={'634:45.87,72.69 N:91473'}
G[92573]={'634:47.01,71.71 N:91473'}
G[92575]={'534:31.37,73.36'}
G[92590]={'634:41.98,57.72'}
G[92591]={'634:42.42,58.15'}
G[92596]={'534:49.96,76.82'}
G[92599]={'634:38.19,42.66'}
G[92600]={'634:39.00,44.73'}
G[92604]={'634:44.32,22.76'}
G[92616]={'534:50.42,44.28'}
G[92618]={'641:38.91,61.45'}
G[92619]={'641:42.35,59.00'}
G[92620]={'641:42.47,58.97 N:40619'}
G[92626]={'634:44.19,22.86'}
G[92636]={'534:38.47,77.69'}
G[92647]={'534:45.89,47.24'}
G[92657]={'534:50.92,74.55'}
G[92680]={'641:51.44,57.00'}
G[92683]={'641:42.13,59.03'}
G[92685]={'634:57.93,45.21'}
G[92688]={'641:54.79,52.78'}
G[92697]={'641:51.49,56.85'}
G[92706]={'534:24.02,52.90'}
G[92707]={'641:39.58,58.98'}
G[92710]={'641:64.97,61.18 N:40289'}
G[92715]={'534:14.50,62.80'}
G[92718]={'677:80.10,36.55'}
G[92738]={'641:38.63,65.67'}
G[92742]={'641:52.46,63.42 N:40289'}
G[92751]={'634:60.68,67.76'}
G[92763]={'634:67.26,39.73'}
G[92764]={'634:61.85,62.99'}
G[92766]={'534:54.28,80.72'}
G[92776]={'677:46.70,27.65'}
G[92782]={'677:70.42,30.74'}
G[92783]={'641:66.20,44.54'}
G[92788]={'641:57.55,55.90'}
G[92789]={'641:57.22,57.52'}
G[92794]={'641:56.43,53.84'}
G[92802]={'641:56.13,54.68'}
G[92805]={'534:55.27,74.74'}
G[92817]={'534:54.26,80.83'}
G[92819]={'534:54.40,80.87'}
G[92837]={'641:64.95,61.15'}
G[92842]={'641:40.85,53.01 N:40619'}
G[92850]={'641:40.73,53.01 N:40619'}
G[92873]={'534:10.77,55.11'}
G[92874]={'641:42.62,78.25'}
G[92909]={'Near625 N:11034'}
G[92910]={'534:54.89,90.82'}
G[92920]={'634:66.75,45.46'}
G[92941]={'534:32.65,35.93'}
G[92951]={'634:47.52,57.77'}
G[92954]={'641:43.88,50.36'}
G[92956]={'634:46.86,56.57'}
G[92965]={'641:43.43,54.03'}
G[92966]={'641:42.60,52.60'}
G[92977]={'534:12.21,56.94'}
G[92980]={'677:74.45,35.96 N:93011'}
G[92986]={'677:74.41,37.18 N:18417'}
G[92987]={'642:23.18,40.75 N:92718'}
G[92989]={'641:67.99,35.29'}
G[93001]={'534:16.33,57.18'}
G[93002]={'534:52.35,65.10'}
G[93003]={'534:54.60,57.07'}
G[93011]={'672:22.08,55.83'}
G[93024]={'534:56.97,35.16'}
G[93027]={'641:23.18,40.75 N:92718'}
G[93029]={'641:43.16,82.08'}
G[93030]={'641:58.87,33.65'}
G[93039]={'534:52.70,42.82'}
G[93057]={'534:16.07,59.23'}
G[93061]={'1018:44.18,51.94'}
G[93064]={'641:38.35,63.17'}
G[93066]={'634:67.85,57.82'}
G[93070]={'634:68.50,50.93'}
G[93071]={'634:69.12,42.06'}
G[93076]={'534:36.12,79.14'}
G[93094]={'634:65.35,43.05'}
G[93095]={'634:71.22,47.80'}
G[93110]={'634:49.68,47.20'}
G[93111]={'641:60.74,32.44'}
G[93112]={'672:40.05,67.19'}
G[93115]={'672:40.36,69.90'}
G[93125]={'534:34.56,78.17'}
G[93127]={'672:60.51,44.76 N:93011'}
G[93149]={'641:38.87,50.93 N:92718'}
G[93155]={'641:67.45,39.15'}
G[93157]={'641:56.96,56.34'}
G[93159]={'641:55.38,41.83'}
G[93166]={'634:45.75,49.73'}
G[93188]={'627:46.20,26.56'}
G[93189]={'627:46.10,26.63'}
G[93205]={'641:62.66,47.49'}
G[93231]={'634:68.50,54.35'}
G[93234]={'634:71.44,42.51'}
G[93313]={'641:56.33,65.74'}
G[93318]={'641:61.07,69.83'}
G[93326]={'630:43.55,43.42 N:78558'}
G[93329]={'641:60.43,67.04'}
G[93337]={'630:45.09,42.90 N:78558'}
G[93354]={'630:47.95,27.21 N:78558'}
G[93371]={'634:72.24,50.16'}
G[93377]={'649:28.99,44.72'}
G[93396]={'534:59.69,45.92'}
G[93399]={'23:74.27,53.16 N:11034'}
G[93401]={'634:64.94,51.78'}
G[93437]={'648:51.03,51.33'}
G[93444]={'641:55.97,83.73'}
G[93446]={'634:68.16,48.73'}
G[93456]={'648:55.97,30.75'}
G[93464]={'641:54.52,72.65'}
G[93489]={'641:54.49,82.42'}
G[93520]={'627:38.82,24.75'}
G[93522]={'627:35.54,29.93'}
G[93523]={'627:35.29,29.61'}
G[93530]={'627:38.24,41.81'}
G[93531]={'627:38.32,40.36'}
G[93538]={'627:40.95,26.63'}
G[93539]={'627:38.36,24.55'}
G[93541]={'627:35.85,28.80'}
G[93550]={'648:0.00,0.00'}
G[93568]={'647:0.00,0.00'}
G[93581]={'641:46.28,84.55'}
G[93584]={'634:60.59,60.30'}
G[93596]={'534:49.26,40.96'}
G[93600]={'641:53.75,79.83'}
G[93603]={'634:55.04,72.56 N:91158'}
G[93622]={'630:40.61,44.66'}
G[93654]={'641:60.99,88.37'}
G[93658]={'534:62.66,27.66 N:90177'}
G[93659]={'534:62.90,27.87 N:74272'}
G[93677]={'641:52.81,87.54'}
G[93679]={'641:49.24,49.18'}
G[93684]={'641:52.82,87.46'}
G[93686]={'641:52.77,87.49'}
G[93691]={'650:55.09,84.06'}
G[93716]={'672:62.74,48.37'}
G[93758]={'641:64.54,85.46'}
G[93759]={'672:38.79,60.64 N:109196'}
G[93779]={'634:63.59,61.75'}
G[93787]={'24:53.44,78.63'}
G[93805]={'650:38.57,69.03'}
G[93812]={'539:28.68,10.85'}
G[93822]={'539:28.20,10.63'}
G[93823]={'695:58.99,29.86'}
G[93826]={'1080[6]54.95,63.16 652:54.95,63.22'}
G[93833]={'650:43.63,59.90 N:95956'}
G[93836]={'653:59.70,32.62'}
G[93841]={'650:52.47,44.72 N:95410'}
G[93846]={'650:53.27,64.04 N:93826'} -- 1024:53.20,70.02 ?
G[93860]={'634:57.13,73.87'}
G[93890]={'641:48.40,84.65'}
G[93940]={'641:42.67,58.08'}
G[94009]={'641:37.59,59.48'}
G[94046]={'641:38.72,58.80'}
G[94051]={'650:49.09,42.36'}
G[94068]={'650:49.45,39.24'}
G[94085]={'650:54.14,41.66'}
G[94098]={'650:56.34,54.86'}
G[94101]={'650:40.00,52.30'}
G[94117]={'641:37.05,58.48'}
G[94138]={'626:42.49,75.94'}
G[94141]={'626:42.48,74.69'}
G[94147]={'650:47.65,44.01'}
G[94149]={'650:44.16,45.37'}
G[94152]={'650:46.02,47.89'}
G[94153]={'650:46.09,46.27'}
G[94159]={'626:41.15,74.32'}
G[94179]={'641:54.38,73.58'}
G[94196]={'650:45.37,43.79'}
G[94208]={'641:45.94,71.92'}
G[94227]={'634:56.78,66.29 N:10181'}
G[94228]={'634:62.56,68.07 N:10181'}
G[94261]={'651:59.31,81.15'}
G[94318]={'634:71.56,59.82'}
G[94337]={'634:74.90,61.87'}
G[94338]={'634:73.28,61.26'}
G[94346]={'634:59.97,51.36'}
G[94347]={'634:74.38,59.55'}
G[94366]={'641:38.92,64.70'}
G[94383]={'641:36.04,57.59'}
G[94386]={'650:47.47,47.01'}
G[94409]={'650:40.04,52.25 N:18180'}
G[94410]={'672:33.94,70.05 N:95238'}
G[94413]={'634:62.06,60.44'}
G[94414]={'641:34.36,58.32'}
G[94429]={'539:29.77,10.65 N:91242'}
G[94434]={'650:39.93,52.24'}
G[94472]={'534:39.50,28.26'}
G[94485]={'641:67.00,46.19'}
G[94507]={'650:53.07,52.21'}
G[94518]={'641:34.40,58.37'}
G[94522]={'650:47.17,47.99'}
G[94561]={'650:49.03,55.26'}
G[94571]={'650:44.88,65.71 N:99153'}
G[94589]={'71:41.87,62.89'}
G[94594]={'641:51.36,51.31'}
G[94624]={'634:45.20,70.72'}
G[94654]={'672:39.61,53.04'}
G[94687]={'650:40.07,63.67'}
G[94688]={'650:43.09,59.54'}
G[94691]={'650:43.68,57.72'}
G[94719]={'10:48.85,58.59'}
G[94789]={'525:41.59,72.31'}
G[94801]={'525:40.04,72.22'}
G[94825]={'634:55.83,70.69'}
G[94856]={'634:60.53,69.47'}
G[94863]={'641:69.44,49.38'}
G[94864]={'588:45.97,29.10 N:83837'}
G[94870]={'581:33.11,37.10'}
G[94877]={'650:56.18,72.45'}
G[94902]={'723:50.56,70.58 N:93011'}
G[94960]={'705:48.16,40.02'}
G[94974]={'641:40.05,43.31'}
G[94977]={'641:40.73,53.03 N:40619'}
G[94983]={'650:52.80,42.30'}
G[94984]={'650:50.14,41.88'}
G[94986]={'650:49.65,37.67'}
G[95002]={'539:29.82,10.69'}
G[95013]={'650:38.74,63.41'}
G[95028]={'641:39.13,51.05 N:108326'}
G[95044]={'534:12.69,55.40'}
G[95053]={'534:23.70,39.81'}
G[95054]={'534:31.91,73.09'}
G[95055]={'643:61.72,81.23'}
G[95056]={'534:47.20,52.50'}
G[95078]={'750:14.10,56.06'}
G[95117]={'641:69.49,49.33'}
G[95118]={'641:69.54,49.42'}
G[95123]={'641:65.82,53.37'}
G[95130]={'650:37.47,64.30'}
G[95137]={'25:57.03,46.46'}
G[95138]={'641:67.38,53.42'}
G[95152]={'641:67.46,51.22'}
G[95153]={'650:45.92,39.27'}
G[95186]={'650:41.13,61.57'}
G[95191]={'650:43.70,59.90'}
G[95194]={'650:52.48,33.29'}
G[95196]={'650:50.81,35.10'}
G[95202]={'641:54.29,68.32'}
G[95204]={'650:47.14,73.38'}
G[95221]={'641:47.24,58.08'}
G[95226]={'672:38.27,73.66'}
G[95234]={'86:53.12,57.60'}
G[95235]={'534:21.21,49.56'}
G[95236]={'534:19.00,39.96'}
G[95237]={'720:57.70,67.42 N:18417'}
G[95238]={'721:59.38,51.31, 720:60.20,68.35'}	-- in both places for acceptance of quest 41066, and turnin, but not giving next quest...only downstairs location for that.
G[95240]={'720:57.69,67.48 N:93011'}
G[95247]={'641:40.49,44.63'}
G[95256]={'650:39.42,36.94'}
G[95265]={'650:53.05,35.70'}
G[95266]={'650:46.76,37.87'}
G[95270]={'650:41.63,30.84'}
G[95272]={'650:45.24,27.43'}
G[95290]={'650:48.49,27.71'}
G[95310]={'650:42.35,29.65'}
G[95318]={'641:61.08,69.33'}
G[95319]={'641:62.79,70.32'}
G[95329]={'680:25.15,60.66'}
G[95392]={'659:40.30,53.18 N:97667'}
G[95395]={'641:61.05,73.23 N:95396'}
G[95396]={'641:62.77,71.71'}
G[95399]={'641:64.37,77.52'}
G[95410]={'650:52.32,36.43'}
G[95421]={'650:45.21,32.52 N:97667'}
G[95424]={'534:57.96,59.34'}
G[95430]={'641:40.05,54.79'}
G[95438]={'650:40.02,52.36'}
G[95451]={'671:69.75,79.79'}
G[95599]={'641:60.97,70.21'}
G[95611]={'634:60.93,65.32 N:10181'}
G[95617]={'641:61.66,73.67'}
G[95620]={'634:67.68,64.35'}
G[95675]={'705:0.00,0.00'}
G[95676]={'703:51.99,86.54'}
G[95688]={'750:45.37,39.21'}
G[95693]={'650:45.53,48.99'}
G[95726]={'641:61.88,72.60'}
G[95727]={'641:63.88,74.87'}
G[95748]={'634:58.44,25.85'}
G[95753]={'659:74.57,55.57'}
G[95755]={'634:55.07,72.64 N:10181'}
G[95799]={'659:52.38,62.60'}
G[95804]={'634:62.30,68.09'}
G[95842]={'705:52.82,66.03'}
G[95852]={'671:69.01,74.78'}
G[95866]={'655:60.76,58.14'}
G[95872]={'650:51.38,31.98'}
G[95881]={'656:47.46,23.61'}
G[95888]={'712:50.10,79.48'}
G[95916]={'655:49.24,43.21'}
G[95921]={'634:60.59,65.08'}
G[95932]={'634:71.46,60.58'}
G[95937]={'650:44.36,67.77'}
G[95951]={'641:63.90,45.50'}
G[95956]={'650:41.19,61.49'}
G[96014]={'534:61.66,45.70 N:18013'}
G[96028]={'713:55.57,54.09'}
G[96038]={'Near650 N:95956'}
G[96068]={'650:43.56,74.91'}
G[96072]={'650:43.80,75.52'}
G[96083]={'650:40.25,64.05'}
G[96084]={'650:40.01,57.96'}
G[96124]={'650:40.45,62.52'}
G[96129]={'634:44.47,47.16'}
G[96135]={'634:47.39,45.66'}
G[96146]={'650:37.44,43.48'}
G[96147]={'534:57.83,59.79'}
G[96183]={'627:74.64,44.96'}
G[96215]={'634:49.54,42.44'}
G[96229]={'634:42.44,47.87'}
G[96236]={'634:43.12,41.30'}
G[96254]={'634:43.17,49.16'}
G[96257]={'634:46.73,44.44'}
G[96258]={'634:46.32,44.82 N:96257'}
G[96268]={'750:0.00,0.00'}
G[96270]={'657:61.26,72.64'}
G[96277]={'672:75.25,36.64'}
G[96278]={'672:72.82,32.79'}
G[96280]={'672:73.80,31.99'}
G[96286]={'1024[8]Near N:97667'}
G[96304]={'582:41.83,47.68 539:29.98,17.60'}	-- 581:41.85,47.73
G[96362]={'582:44.22,51.04 539:30.23,17.95'}	-- 581:44.29,50.98
G[96400]={'672:44.95,77.83'}
G[96410]={'650:47.26,33.40'}
G[96420]={'672:60.58,44.86 N:97297'}
G[96436]={'672:64.05,52.30 N:109196'}
G[96441]={'672:64.30,59.17'}
G[96451]={'582:44.00,51.45 539:30.20,17.99'}	-- 581:44.01,51.42
G[96453]={'Near650 N:97667'}
G[96465]={'634:42.79,82.69'}
G[96469]={'695:58.38,84.60'}
G[96494]={'673:47.21,19.13'}
G[96513]={'650:57.62,56.61'}
G[96520]={'650:38.40,61.24 N:95956'}
G[96527]={'725:36.17,74.95'}
G[96541]={'725:34.10,74.37'}
G[96586]={'695:41.01,37.13'}
G[96590]={'650:55.83,61.48'}
G[96615]={'650:48.22,27.13'}
G[96621]={'650:48.76,27.19'}
G[96644]={'627:29.10,46.88 N:66292'}
G[96655]={'672:60.53,44.66 N:95238'}
G[96663]={'84:18.67,51.08 N:48736'}
G[96665]={'677:49.14,49.44 N:93011'}
G[96666]={'679:62.27,53.31 N:93011'}
G[96669]={'679:62.27,53.31 N:18417'}
G[96675]={'678:41.09,47.17 N:95238'}
G[96682]={'678:46.94,18.72'}
G[96683]={'1:61.35,8.92'}
G[96686]={'1:61.37,8.87 N:10181'}
G[96691]={'650:53.72,62.73'}
G[96705]={'581:44.00,51.46'}
G[96735]={'587:47.21,37.75'}
G[96821]={'627:42.81,80.06'}
G[96853]={'650:55.33,41.09'}
G[96878]={'650:53.32,42.12'}
G[96984]={'650:54.71,44.98'}
G[96986]={'650:53.46,43.54'}
G[96989]={'650:54.73,41.00'}
G[96997]={'677:49.39,33.21'}
G[97012]={'627:48.73,73.59'}
G[97057]={'672:80.16,41.69'}
G[97059]={'672:74.18,57.30'}
G[97064]={'654:60.89,25.18'}
G[97069]={'677:71.36,36.36'}
G[97072]={'647:59.42,60.33'}
G[97074]={'634:48.02,54.57'}
G[97091]={'634:50.45,56.09'}
G[97093]={'650:51.03,25.69'}
G[97094]={'654:51.92,81.44 650:41.06,45.52>650'}	-- outer map I think is 1024:41.06,45.52
G[97102]={'650:52.33,51.49'}
G[97103]={'650:39.13,43.18'}
G[97111]={'648:51.53,52.94'}
G[97130]={'650:55.28,41.79'}
G[97140]={'680:37.08,46.22'}	-- moves to 1033:36.51,46.75 after turning in 43318
G[97193]={'Near650 N:97094'}
G[97203]={'650:41.96,41.65'}
G[97220]={'650:48.99,49.93'}
G[97225]={'678:46.69,43.33'}
G[97228]={'678:46.81,33.91'}
G[97250]={'634:36.48,36.61'}
G[97258]={'634:51.46,56.94'}
G[97261]={'627:44.46,28.28'}
G[97266]={'650:53.19,70.28'}
G[97270]={'634:69.90,45.50 N:93446'}
G[97296]={'84:72.55,47.02 N:78558'}
G[97297]={'672:69.93,44.23'}
G[97301]={'650:53.38,64.11 N:97667'}
G[97303]={'672:69.86,37.91 N:93011'}
G[97305]={'634:36.78,31.11 N:97074'}
G[97306]={'634:33.75,45.85'}
G[97319]={'649:65.56,47.14 N:93234'}
G[97326]={'650:51.04,48.09'}
G[97333]={'678:0.00,0.00'}
G[97337]={'641:68.32,40.52'}
G[97338]={'641:66.05,37.96'}
G[97344]={'650:53.37,64.01 N:95956'}
G[97345]={'650:48.39,40.22'}
G[97361]={'628:67.28,17.83'}
G[97370]={'672:68.74,27.59'}
G[97389]={'695:59.22,13.44'}
G[97407]={'650:53.16,68.76 N:93841'}
G[97419]={'Near649 N:93234'}
G[97429]={'627:39.85,30.46'}
G[97445]={'649:56.07,65.11'}
G[97449]={'650:38.11,45.51'}
G[97480]={'649:46.78,49.01 N:93234'}
G[97504]={'641:66.85,36.66'}
G[97517]={'641:60.18,44.28'}
G[97548]={'641:62.07,37.93'}
G[97553]={'650:41.28,72.59'}
G[97554]={'641:62.49,34.86'}
G[97558]={'Near649 N:93234'}
G[97572]={'750:32.17,38.21'}
G[97593]={'650:54.70,40.60'}
G[97630]={'649:28.54,64.20'}
G[97643]={'678:41.33,47.36 N:97644'}
G[97644]={'679:24.44,55.73'}
G[97653]={'650:53.71,51.28','In cave at bottom of falls'}
G[97661]={'650:38.90,43.43'}
G[97662]={'650:40.36,71.69 N:95956'}
G[97666]={'627:70.51,44.35 N:97553'}
G[97667]={'650:39.00,37.32'}
G[97671]={'641:69.48,59.99'}
G[97672]={'641:69.45,61.80'}
G[97706]={'672:73.45,48.92'}
G[97718]={'627:38.32,40.88'}
G[97729]={'680:46.04,31.56'}
G[97755]={'634:42.81,45.00'}
G[97793]={'650:41.29,58.07'}
G[97808]={'697:30.26,48.27'}
G[97812]={'654:51.13,63.51'}
G[97822]={'634:69.18,65.92'}
G[97825]={'634:68.88,64.97'}
G[97843]={'10:67.92,72.26'}
G[97846]={'654:30.61,62.79 N:97094'}
G[97851]={'634:68.37,64.98'}
G[97854]={'750:53.92,45.79'}
G[97858]={'750:41.57,52.93'}
G[97859]={'634:68.06,68.94'}
G[97890]={'634:65.58,58.50'}
G[97891]={'697:29.45,39.33'}
G[97892]={'697:27.90,51.76 N:33091'}
G[97895]={'650:39.18,44.84'}
G[97903]={'697:31.30,52.50'}
G[97906]={'634:70.04,63.66'}
G[97919]={'650:46.50,7.95'}
G[97920]={'650:46.26,8.02'}
G[97923]={'747:30.92,54.26 N:101195'}
G[97925]={'650:32.19,66.86 N:41308'}
G[97933]={'650:44.16,12.28'}
G[97957]={'650:57.43,56.33'}
G[97973]={'634:58.95,42.85'}
G[97974]={'650:57.59,56.43'}
G[97978]={'679:62.54,53.52 N:78558'}
G[97979]={'634:65.91,59.49 N:96465'}
G[97986]={'634:70.20,69.48 N:96465'}
G[97988]={'634:70.27,69.26 N:96254'}
G[97999]={'650:49.04,36.31'}
G[98000]={'747:52.72,51.06 N:98613'}	-- Druid class hall scouting map
G[98002]={'747:52.56,51.45 N:40997'}	-- in release 21796 at: 1077:52.62,51.45
G[98003]={'650:50.21,38.64'}
G[98008]={'Near715'}
G[98013]={'747:47.27,7.51 N:38243'}
G[98015]={'634:54.67,34.96'}
G[98017]={'750:44.49,45.51'}
G[98018]={'634:54.02,42.41'}
G[98024]={'650:50.80,34.57'}
G[98038]={'650:48.54,41.71'}
G[98067]={'650:42.73,10.93 N:25197'}
G[98092]={'626:37.84,45.09'}
G[98093]={'626:37.41,44.25'}
G[98102]={'626:40.78,75.40'}
G[98105]={'634:53.69,70.61'}
G[98109]={'634:71.18,60.54'}
G[98135]={'641:54.79,71.70'}
G[98141]={'641:61.05,69.39'}
G[98156]={'641:54.40,57.70'}
G[98159]={'630:46.88,40.80'}
G[98188]={'634:41.88,33.78'}
G[98194]={'650:47.06,12.20'}
G[98208]={'749:0.00,0.00'}
G[98229]={'672:28.60,63.06 N:93011'}
G[98232]={'630:47.70,71.91'}
G[98233]={'680:35.63,47.52'}
G[98234]={'641:38.90,54.63'}
G[98241]={'641:61.78,30.36'}
G[98268]={'634:61.13,44.41'}
G[98273]={'650:56.34,54.86'}
G[98283]={'534:83.43,43.58'}
G[98285]={'534:88.36,55.75'}
G[98299]={'650:36.67,15.88'}
G[98306]={'680:48.25,40.97'}
G[98311]={'650:46.64,7.37'}
G[98312]={'680:34.63,53.41'}
G[98367]={'634:39.36,42.52'}
G[98371]={'27:73.45,52.19'}
G[98381]={'630:46.84,40.87'}
G[98408]={'534:40.86,56.37'}
G[98411]={'634:73.28,47.20'}
G[98412]={'634:73.18,45.71'}
G[98421]={'634:72.75,47.05'}
G[98486]={'672:26.89,63.06'}
G[98498]={'634:78.89,59.40'}
G[98500]={'634:79.79,58.75'}
G[98501]={'634:79.30,58.48'}
G[98502]={'634:79.32,58.68'}
G[98503]={'634:78.62,61.19'}
G[98519]={'627:69.69,46.82'}
G[98548]={'680:36.60,46.96'}
G[98555]={'680:35.10,50.79'}
G[98584]={'641:52.46,63.42 N:40289'}
G[98587]={'634:78.25,58.64'}
G[98613]={'720:58.64,54.38'}
G[98632]={'720:58.01,54.59 N:109295'}
G[98646]={'720:0.00,0.00'}
G[98648]={'720:0.00,0.00'}
G[98653]={'651:81.57,46.46'}
G[98675]={'630:63.84,30.29'}
G[98685]={'111:54,39'}
G[98690]={'125:50.40,46.16'}
G[98695]={'734:81.28,61.13 N:98613'}
G[98698]={'630:36.53,34.09'}
G[98711]={'672:73.15,33.81 N:97644'}
G[98720]={'680:30.60,33.36'}
G[98721]={'634:45.79,25.65'}
G[98725]={'627:59.21,39.48'}
G[98757]={'697:29.95,50.87'}
G[98784]={'747:59.29,53.19'}
G[98791]={'630:47.04,45.15'}
G[98794]={'697:27.96,47.35'}
G[98801]={'680:30.88,59.14'}
G[98808]={'650:40.86,52.92'}
G[98825]={'652:74.74,74.96 N:93805'}
G[98890]={'650:41.52,31.81'}
G[98931]={'627:34.71,28.81'}
G[98945]={'709:48.98,58.42'}
G[98948]={'750:36.91,78.88'}
G[98955]={'634:58.66,65.51'}
G[98957]={'657:60.19,54.07'}
G[98964]={'630:47.50,44.12'}
G[98969]={'680:26.57,71.64'}
G[98970]={'754:0.00,0.00'}
G[98979]={'680:45.88,39.24'}
G[99035]={'641:46.95,39.70'}
G[99041]={'709:52.86,60.19'}
G[99045]={'672:60.52,44.83 N:97644'}
G[99065]={'680:45.60,40.81'}
G[99070]={'680:69.15,55.08'}
G[99075]={'680:70.60,54.66'}
G[99088]={'680:36.85,46.52'}
G[99093]={'680:49.15,43.89'}
G[99153]={'657:43.21,28.25'}
G[99179]={'709:52.76,59.64'}
G[99180]={'534:59.74,46.18'}
G[99181]={'709:51.39,54.26'}
G[99183]={'534:59.87,46.22'}
G[99190]={'657:49.21,72.35 N:99153'}
G[99192]={'733:84.26,88.07'}
G[99216]={'650:54.60,58.95'}
G[99223]={'634:44.31,26.26'}
G[99247]={'627:74.95,49.00 N:93011'}
G[99254]={'627:74.99,49.06 N:18417'}
G[99262]={'627:74.42,51.28 N:109196'}
G[99267]={'680:39.60,52.89'}
G[99304]={'680:76.54,63.45'}
G[99343]={'Near625 N:97644'}
G[99370]={'76:40.93,58.69'}
G[99379]={'634:40.59,68.45'}
G[99384]={'650:39.82,57.44'}
G[99398]={'25:28.74,37.32 N:67996'}
G[99406]={'650:40.02,63.86'}
G[99415]={'25:28.73,37.19'}
G[99420]={'630:47.27,26.34'}
G[99452]={'76:39.91,57.66'}
G[99468]={'650:57.66,56.56'}
G[99481]={'650:40.84,51.48'}
G[99483]={'680:47.29,33.49'}
G[99485]={'680:26.02,85.75'}
G[99491]={'750:34.00,56.53 N:95956'}
G[99502]={'680:75.19,62.20'}
G[99514]={'680:30.87,59.15'}
G[99544]={'680:69.02,54.13'}
G[99559]={'680:68.98,54.10'}
G[99575]={'680:45.07,30.95'}
G[99581]={'680:32.01,68.57'}
G[99584]={'680:28.65,85.09'}
G[99588]={'680:47.39,76.34'}
G[99589]={'680:51.01,76.74'}
G[99593]={'680:44.56,22.81'}
G[99610]={'680:53.38,30.11'}
G[99632]={'677:78.17,36.38'}
G[99689]={'632:82.88,85.55'}
G[99749]={'680:40.77,53.09'}
G[99759]={'672:74.29,54.49'}
G[99762]={'680:28.86,85.25'}
G[99764]={'680:30.07,74.92'}
G[99765]={'682:61.44,65.05'}
G[99770]={'680:74.44,56.72'}
G[99784]={'650:53.62,42.13'}
G[99788]={'680:43.38,41.72'}
G[99789]={'680:43.44,31.73'}
G[99791]={'680:21.34,54.42'}
G[99792]={'680:22.21,51.58'}
G[99890]={'680:30.02,69.41'}
G[99893]={'680:74.93,63.38'}
G[99905]={'750:42.30,46.93'}
G[99910]={'641:72.59,51.04'}
G[99929]={'650:49.10,7.66'}
G[99948]={'680:70.58,48.81'}
G[100014]={'680:28.15,38.70'}
G[100019]={'680:33.13,75.07'}
G[100031]={'24:63.10,37.23'}
G[100047]={'682:46.30,37.96'}
G[100185]={'680:34.31,56.15'}
G[100192]={'680:41.37,60.71'}
G[100237]={'680:64.47,37.51'}
G[100301]={'680:37.86,61.65'}
G[100323]={'47:77.42,36.30'}
G[100331]={'680:37.82,61.57'}
G[100387]={'641:52.52,64.15 N:33091'}
G[100395]={'84:20.09,34.90 N:48736'}
G[100409]={'641:38.35,68.23'}
G[100429]={'84:85.89,31.58 N:1747'}
G[100430]={'650:55.18,44.30'}
G[100433]={'634:45.98,40.93'}
G[100435]={'634:42.81,47.09'}
G[100438]={'709:51.44,48.48'}
G[100441]={'709:52.94,60.17'}
G[100446]={'634:45.22,71.21'}
G[100453]={'1:57.17,10.53'}
G[100459]={'641:56.23,57.34'}
G[100475]={'709:49.12,58.63'}
G[100477]={'650:49.38,39.26'}
G[100482]={'630:47.97,25.90 N:89975'}
G[100495]={'650:54.42,41.17'}
G[100571]={'249:54.85,32.91'}
G[100573]={'641:62.33,76.23'}
G[100622]={'695:43.63,34.63'}
G[100635]={'695:59.76,13.49'}
G[100675]={'84:85.32,32.28 N:109196'}
G[100729]={'42:52.41,34.42'}
G[100738]={'634:62.75,68.10'}
G[100775]={'680:61.88,49.06'}
G[100778]={'680:60.95,46.49'}
G[100779]={'680:44.95,23.82'}
G[100786]={'Near625'}
G[100812]={'42:49.46,74.73'}	-- old was 32:46.91,69.48
G[100823]={'680:31.04,85.01'}
G[100841]={'650:38.89,14.14'}
G[100864]={'680:68.19,58.55'}
G[100866]={'1:45.71,15.88'}
G[100873]={'1:45.82,15.12 N:95238'}
G[100878]={'680:31.16,84.61'}
G[100888]={'680:70.95,50.41'}
G[100891]={'680:71.48,49.75'}
G[100949]={'680:69.27,68.38'}
G[100973]={'84:85.76,31.77 N:1747'}
G[100982]={'672:33.93,69.96'}
G[100986]={'628:71.05,18.37'}
G[100998]={'680:80.26,58.98'}
G[100999]={'680:82.29,62.61'}
G[101004]={'84:40.28,77.72'}
G[101008]={'751:0.00,0.00'}
G[101035]={'1:45.68,15.93 N:10181'}
G[101046]={'709:49.20,58.63'}
G[101061]={'Near625'}	-- before we marked him as moving we had: 1014[10]:57.56,45.72
G[101064]={'80:56.27,31.84 N:101061'}
G[101076]={'680:26.79,70.80'}
G[101077]={'650:45.15,55.89'}
G[101080]={'680:37.89,47.28'}
G[101082]={'680:37.94,47.37'}
G[101083]={'680:37.83,47.26'}
G[101097]={'628:55.77,65.36'}
G[101195]={'747:44.66,51.97'}	-- in release 21796 he is at 1077:44.66,51.97, does he move?, older was 1077:44.50,51.08
G[101259]={'747:0.00,0.00'}	-- could not get map to appear near her
G[101282]={'46:68.28,27.10'}	-- old value 32[1]:68.22,27.23
G[101310]={'627:46.15,21.35 N:42129'}
G[101313]={'627:46.30,20.57 N:17468'}
G[101314]={'18:78.96,40.98'}
G[101411]={'713:38.56,28.60'}
G[101441]={'627:72.80,46.66'}
G[101456]={'628:57.76,60.14'}
G[101476]={'731:17.21,59.43'}
G[101499]={'680:49.68,48.12'}
G[101513]={'626:41.44,78.07'}
G[101527]={'627:53.92,40.32'}
G[101532]={'630:55.91,56.84'}
G[101547]={'42:46.99,75.09 N:78558'}
G[101554]={'630:63.07,55.75'}
G[101581]={'680:52.22,29.91'}
G[101644]={'650:49.26,54.46'}
G[101645]={'650:50.01,71.59'}
G[101649]={'650:52.17,79.78'}
G[101651]={'47:48.83,34.22'}
G[101656]={'47:48.90,34.31'}
G[101700]={'650:31.17,31.69'}
G[101759]={'84:76,17'}
G[101765]={'680:32.21,12.73'}
G[101766]={'680:27.83,21.19'}
G[101767]={'680:33.72,18.08'}
G[101768]={'680:36.44,22.40'}
G[101783]={'680:26.81,17.02'}
G[101784]={'680:27.83,19.11'}
G[101785]={'650:55.47,77.70'}
G[101793]={'650:27.54,41.96'}
G[101794]={'650:31.18,26.48'}
G[101808]={'650:27.07,44.30'}
G[101821]={'680:59.71,34.38'}
G[101825]={'680:52.44,45.10'}
G[101827]={'650:24.56,42.29'}
G[101832]={'650:24.55,42.34'}
G[101846]={'627:40.09,65.97'}
G[101848]={'680:30.32,47.89'}
G[101868]={'680:30.87,62.02'}
G[101878]={'680:29.45,82.96'}
G[101900]={'680:25.94,59.13'}
G[101927]={'630:43.55,43.47 N:18417'}
G[101943]={'630:42.48,46.93'}
G[101957]={'650:40.89,48.54'}
G[101967]={'641:38.69,87.35'}
G[101997]={'650:42.63,48.11'}
G[102018]={'Near625'}
G[102019]={'703:0.00,0.00'}
G[102059]={'630:41.66,73.37'}
G[102064]={'630:37.33,83.83'}
G[102066]={'630:40.20,84.26'}
G[102075]={'630:52.54,81.16'}
G[102120]={'210:40.76,69.12'}
G[102123]={'650:54.04,77.76'}
G[102142]={'680:34.46,48.73'}
G[102166]={'641:39.26,86.65'}
G[102170]={'634:75.87,90.12'}
G[102193]={'628:65.95,52.87'}
G[102195]={'630:65.21,24.91'}
G[102196]={'630:42.99,62.84'}
G[102197]={'641:59.83,62.26'}
G[102198]={'634:78.29,57.24'}
G[102218]={'650:54.08,80.57'}
G[102232]={'731:0.00,0.00'}
G[102242]={'680:30.80,13.02'}
G[102274]={'650:38.86,68.72'}
G[102297]={'650:45.80,75.73'}
G[102303]={'680:48.76,56.74'}
G[102309]={'680:65.20,51.12'}
G[102333]={'Near625'}
G[102334]={'680:72.26,59.08'}
G[102361]={'650:37.77,43.14'}
G[102365]={'680:27.09,86.07'}
G[102381]={'Near680'}
G[102387]={'732:50.72,48.19'}
G[102390]={'680:75.95,52.72'}
G[102410]={'680:70.68,48.78'}
G[102425]={'680:31.43,23.18'}
G[102426]={'680:31.51,23.17'}
G[102446]={'732:50.54,58.90'}
G[102450]={'680:28.17,82.25'}
G[102468]={'650:53.25,52.29'}
G[102478]={'627:60.03,53.44'}
G[102501]={'650:53.13,54.11'}
G[102516]={'641:22.47,67.48'}
G[102546]={'Near'}
G[102574]={'739:43.54,24.65 N:102478'}
G[102578]={'739:36.64,29.13 N:102478'}
G[102585]={'84:84.39,33.74 N:109196'}
G[102589]={'702:49.97,53.67'}
G[102594]={'626:30.47,70.42'}
G[102600]={'688:39.81,29.61'}
G[102622]={'641:40.36,86.12'}
G[102625]={'634:74.15,86.82'}
G[102655]={'702:49.36,53.43 N:101314'}
G[102666]={'630:44.21,64.29'}
G[102669]={'739:42.81,46.61 N:98613'}
G[102700]={'735:58.86,42.94'}
G[102709]={'702:49.34,37.71'}
G[102727]={'650:24.53,42.28'}
G[102728]={'650:26.42,41.80'}
G[102736]={'650:26.67,44.23'}
G[102743]={'650:52.48,52.76'}
G[102744]={'680:31.40,23.54'}
G[102746]={'680:50.43,82.34'}
G[102747]={'680:48.12,75.01'}
G[102748]={'680:52.23,80.37'}
G[102778]={'627:56.80,52.65'}
G[102799]={'627:73.85,46.04 N:97644'}
G[102820]={'709:55.24,57.09'}
G[102827]={'650:43.97,74.14'}
G[102841]={'680:75.90,72.45'}
G[102843]={'634:62.16,20.79'}
G[102845]={'680:70.60,49.17'}
G[102855]={'709:31.13,40.57'}
G[102864]={'641:33.51,44.10'}
G[102866]={'634:62.16,91.69'}
G[102867]={'641:33.65,42.83'}
G[102868]={'650:61.34,58.13'}
G[102869]={'634:60.39,88.36'}
G[102871]={'650:24.72,57.80'}
G[102872]={'650:24.57,56.88'}
G[102873]={'641:33.77,44.47'}
G[102874]={'650:25.47,57.83'}
G[102875]={'634:62.48,93.32'}
G[102876]={'650:61.37,58.12'}
G[102877]={'634:48.97,23.00'}
G[102878]={'634:62.41,93.42'}
G[102884]={'650:43.67,59.53'}
G[102886]={'650:43.45,74.50'}
G[102887]={'650:43.47,59.55'}
G[102890]={'650:43.29,59.25'}
G[102898]={'680:32.70,67.58'}
G[102902]={'709:51.11,49.50'}
G[102913]={'680:83.12,62.65'}
G[102917]={'650:42.77,57.25'}
G[102938]={'641:67.45,56.12 N:7999'}
G[102940]={'739:47.29,53.94'}
G[102969]={'680:35.55,11.71'}
G[102982]={'650:44.40,45.79'}
G[102983]={'650:44.03,48.02'}
G[102988]={'630:49.66,26.80 N:78558'}
G[102996]={'634:44.91,71.76'}
G[103022]={'641:69.54,49.52 N:7999'}
G[103023]={'739:42.82,46.91'}
G[103025]={'721:59.72,45.71'}
G[103049]={'704:0.00,0.00'}
G[103090]={'650:54.68,75.62'}
G[103092]={'627:48.48,63.37'}
G[103129]={'680:30.09,10.40'}
G[103131]={'680:47.26,56.47'}
G[103155]={'680:37.02,46.23'}
G[103156]={'627:65.64,67.29 N:18417'}
G[103174]={'650:54.18,79.39'}
G[103175]={'680:41.52,71.23'}
G[103176]={'630:38.39,47.80'}
G[103177]={'650:54.11,81.07'}
G[103180]={'630:37.51,49.20'}
G[103181]={'680:41.65,71.11'}
G[103183]={'680:79.64,72.66'}
G[103185]={'680:79.63,72.78'}
G[103204]={'680:28.46,82.66'}
G[103208]={'630:48.07,27.23'}
G[103210]={'650:60.83,58.65'}
G[103214]={'680:67.80,70.94'}
G[103215]={'634:60.64,88.88'}
G[103223]={'680:61.28,39.67'}
G[103231]={'630:37.77,49.81'}
G[103235]={'650:54.49,81.46'}
G[103245]={'634:49.03,23.65'}
G[103307]={'650:25.08,56.21'}
G[103326]={'680:35.94,21.47'}
G[103363]={'630:39.00,57.68'}
G[103430]={'634:61.63,90.39'}
G[103431]={'634:62.25,93.48'}
G[103437]={'Near680'}
G[103446]={'650:27.45,54.95'}
G[103449]={'634:47.33,20.56'}
G[103453]={'634:61.72,90.26'}
G[103457]={'641:37.45,77.88'}
G[103482]={'630:47.43,42.57'}
G[103484]={'634:52.19,52.66'}
G[103485]={'750:45.89,45.04'}
G[103502]={'680:77.90,57.13'}
G[103506]={'627:57.70,45.31'}
G[103514]={'641:57.83,61.21'}
G[103527]={'680:31.35,30.47'}
G[103534]={'680:77.47,59.84'}
G[103568]={'680:25.68,30.87'}
G[103569]={'680:28.30,29.70'}
G[103570]={'680:25.67,30.92'}
G[103571]={'680:30.34,30.81'}
G[103575]={'680:76.73,57.65'}
G[103614]={'469:41.92,31.63'}
G[103616]={'680:33.34,28.77'}
G[103643]={'650:33.15,64.63'}
G[103653]={'650:25.28,56.78'}
G[103656]={'650:42.07,33.40'}
G[103671]={'680:35.40,70.64'}
G[103681]={'650:42.76,33.96'}
G[103712]={'680:21.34,30.50'}
G[103729]={'634:62.67,89.95'}
G[103732]={'720:0.00,0.00'}
G[103734]={'750:13.66,55.45'}
G[103745]={'650:61.05,56.36'}
G[103757]={'634:61.99,93.87'}
G[103761]={'720:59.30,57.60 N:97644'}
G[103778]={'747:67.28,75.72 N:37570'}	-- 1077:68.99,75.89
G[103784]={'630:33.78,11.56'}
G[103785]={'641:49.35,46.74'}
G[103786]={'634:52.42,59.02'}
G[103787]={'680:24.68,49.34'}
G[103797]={'634:60.47,50.68'}
G[103827]={'680:87.45,62.17'}
G[103832]={'747:44.68,50.18'}
G[103837]={'650:59.13,66.75'}
G[103841]={'680:16.93,26.81'}
G[103842]={'630:61.54,41.75'}
G[103844]={'641:47.65,77.00'}
G[103846]={'634:55.28,31.09'}
G[103848]={'680:35.64,38.38'}
G[103850]={'650:60.01,67.18'}
G[103875]={'80:66.74,60.53 N:33091'}
G[103975]={'630:40.37,76.79'}
G[103976]={'628:0.00,0.00'}
G[104110]={'25:38.75,59.99'}
G[104147]={'680:19.00,24.95'}
G[104161]={'680:35.78,72.42'}
G[104220]={'680:21.75,29.43'}
G[104224]={'680:28.35,34.75'}
G[104226]={'680:30.03,32.89'}
G[104240]={'747:52.65,51.16'}
G[104241]={'747:45.93,51.03 N:33091'}
G[104243]={'650:51.06,79.34'}
G[104248]={'650:50.75,79.75'}
G[104258]={'630:53.15,30.35'}
G[104287]={'10:49.86,60.67'}
G[104289]={'641:34.01,40.65'}
G[104290]={'650:61.20,56.98'}
G[104292]={'634:48.82,20.68'}
G[104294]={'634:48.79,20.13'}
G[104302]={'650:52.38,48.08'}
G[104310]={'650:50.88,50.67'}
G[104311]={'650:50.93,50.40'}
G[104323]={'650:48.57,27.41'}
G[104328]={'650:46.70,28.12'}
G[104343]={'687:58.08,18.11'}
G[104344]={'680:38.72,61.96'}
G[104349]={'747:0.00,0.00'}
G[104369]={'680:42.39,76.87'}
G[104378]={'641:53.75,87.28'}
G[104381]={'627:71.39,50.63'}
G[104385]={'116:50.51,37.61'}
G[104394]={'680:41.61,59.91'}
G[104404]={'680:60.45,46.22'}
G[104406]={'680:74.94,63.39'}
G[104419]={'25:65.18,67.34'}
G[104423]={'25:47.91,55.07'}
G[104425]={'52:51.30,53.51'}
G[104426]={'27:76.46,56.20'}
G[104432]={'27:64.84,56.60'}
G[104445]={'10:49.30,59.13'}
G[104450]={'71:50.88,28.19'}
G[104463]={'71:51.44,29.83'}
G[104475]={'71:51.54,29.49'}
G[104481]={'650:28.15,52.83'}
G[104484]={'650:33.85,21.25'}
G[104489]={'52:54.47,43.63'}
G[104513]={'650:56.76,48.32'}
G[104517]={'650:58.40,71.53'}
G[104518]={'750:67.35,74.07'}
G[104519]={'680:24.44,54.44'}
G[104521]={'680:24.44,54.44'}
G[104522]={'680:23.56,56.91'}
G[104523]={'641:52.10,39.77'}
G[104524]={'650:52.63,58.30'}
G[104535]={'116:51.28,36.83 N:101259'}
G[104576]={'680:77.45,57.19'}
G[104577]={'747:45.20,51.82'}
G[104582]={'650:52.77,13.85'}
G[104585]={'650:51.99,11.80'}
G[104586]={'680:77.55,59.77'}
G[104597]={'650:52.49,13.30'}
G[104614]={'750:57.37,61.27'}
G[104615]={'750:41.01,69.64'}
G[104618]={'680:20.65,55.14'}
G[104624]={'750:48.75,43.98'}
G[104630]={'680:75.90,52.54'}
G[104640]={'630:52.19,43.55'}
G[104661]={'680:22.93,52.70'}
G[104690]={'650:54.86,82.66'}
G[104692]={'750:29.87,58.17'}
G[104728]={'641:66.21,44.78 N:7999'}
G[104744]={'371:45.50,25.12'}
G[104745]={'371:38.34,25.77'}
G[104784]={'371:38.95,24.94'}
G[104799]={'641:57.82,38.59 N:7999'}
G[104850]={'371:42.06,25.45'}
G[104875]={'27:53.54,51.15'}
G[104885]={'641:66.93,50.13 N:7999'}
G[104900]={'10:49.68,61.24'}
G[104901]={'10:49.66,59.07'}
G[104921]={'641:53.71,55.89 N:7999'}
G[104926]={'71:51.51,29.21'}
G[104984]={'709:51.11,49.50'}
G[105019]={'709:54.48,57.16'}
G[105046]={'709:51.85,49.57'}
G[105056]={'709:51.85,49.57'}
G[105058]={'709:51.85,49.57'}
G[105071]={'680:40.11,70.80'}
G[105072]={'634:67.79,70.45'}
G[105081]={'627:28.83,49.48'}
G[105088]={'634:68.04,70.42'}
G[105104]={'641:38.90,61.98'}
G[105152]={'634:68.09,70.39'}
G[105316]={'672:34.78,70.24'}
G[105339]={'628:0.00,0.00'}
G[105342]={'680:43.37,78.71'}
G[105360]={'630:35.74,15.32'}
G[105361]={'630:37.06,19.93'}
G[105362]={'630:36.54,16.35'}
G[105433]={'634:61.13,68.18'}
G[105436]={'634:66.82,41.40'}
G[105443]={'634:64.28,46.51'}
G[105464]={'628:67.36,62.69'}
G[105486]={'680:21.19,44.63'}
G[105502]={'634:61.63,43.76'}
G[105525]={'634:60.13,42.54'}
G[105526]={'634:60.81,42.74'}
G[105532]={'634:58.41,46.66'}
G[105547]={'680:23.92,25.69'}
G[105554]={'680:22.18,33.95'}
G[105613]={'684:38.38,41.37'}
G[105623]={'680:21.91,39.46'}
G[105625]={'680:21.53,42.27'}
G[105632]={'685:67.02,51.67'}
G[105676]={'680:23.93,43.74'}
G[105685]={'680:24.62,43.95'}
G[105686]={'680:25.09,44.30'}
G[105710]={'634:61.20,41.76'}
G[105718]={'634:56.00,41.76'}
G[105728]={'680:23.30,44.84'}
G[105739]={'685:35.78,32.35'}
G[105746]={'634:54.27,44.94'}
G[105748]={'634:56.18,45.94'}
G[105749]={'634:56.59,39.29'}
G[105753]={'680:23.88,44.89'}
G[105756]={'680:22.06,38.67'}
G[105759]={'680:50.55,60.25'}
G[105785]={'680:22.57,49.64'}
G[105793]={'641:60.04,67.39'}
G[105823]={'641:73.09,50.67'}
G[105826]={'641:60.93,66.29'}
G[105838]={'630:62.46,50.96'}
G[105885]={'680:20.17,50.08'}
G[105897]={'641:57.61,69.84'}
G[105899]={'680:65.87,54.30'}
G[105903]={'641:57.17,71.26'}
G[105919]={'630:43.55,24.44'}
G[105932]={'641:63.96,58.45'}
G[105933]={'641:67.21,58.21'}
G[105938]={'630:43.60,24.58'}
G[105948]={'641:56.76,71.54'}
G[105960]={'641:49.59,87.80'}
G[105973]={'641:47.56,88.21'}
G[106009]={'641:41.44,59.32'}
G[106032]={'680:51.13,76.24'}
G[106074]={'650:30.40,27.11'}
G[106077]={'650:29.45,29.44'}
G[106091]={'747:48.99,47.23'}
G[106093]={'747:49.02,46.80'}
G[106095]={'680:29.69,18.63'}
G[106106]={'630:54.52,45.82'}
G[106115]={'650:51.30,66.95'}
G[106119]={'680:17.76,47.36'}
G[106135]={'715:43.02,30.33'}
G[106136]={'715:45.20,32.61'}
G[106182]={'680:33.71,18.02'}
G[106195]={'650:52.23,65.90'}
G[106204]={'715:43.32,30.77'}
G[106250]={'198:60.46,23.62'}
G[106275]={'680:35.53,18.99'}
G[106286]={'641:71.24,54.90'}
G[106288]={'641:69.32,46.67'}
G[106297]={'630:46.59,14.48'}
G[106299]={'747:44.47,51.51'}
G[106331]={'641:69.23,43.71'}
G[106339]={'680:30.38,74.05'}
G[106340]={'641:74.99,44.35'}
G[106351]={'680:33.76,15.09'}
G[106358]={'641:49.92,77.25'}
G[106369]={'641:50.33,75.24'}
G[106372]={'641:50.38,73.19'}
G[106384]={'641:50.28,73.76'}
G[106419]={'641:67.16,30.15'}
G[106430]={'71:51.45,30.08'}
G[106442]={'747:38.48,34.12'}
G[106467]={'641:68.50,33.82'}
G[106482]={'778:55.42,48.89'}
G[106522]={'772:0.00,0.00'}
G[106526]={'680:35.38,66.80'}
G[106537]={'630:68.13,28.36'}
G[106558]={'745:44.92,37.37'}
G[106568]={'634:36.07,68.31'}
G[106582]={'630:68.37,26.15'}
G[106583]={'630:67.29,30.72'}
G[106629]={'630:38.81,53.26'}
G[106630]={'630:49.51,21.91'}
G[106638]={'641:73.62,39.44'}
G[106654]={'680:49.56,79.58'}
G[106655]={'627:45.21,29.07'}
G[106665]={'630:51.54,20.07'}
G[106695]={'630:64.97,48.94'}
G[106696]={'680:19.59,22.38'}
G[106764]={'680:20.02,21.21'}
G[106765]={'680:16.70,22.84'}
G[106780]={'713:55.53,54.29'}
G[106788]={'630:65.97,49.07'}
G[106804]={'680:18.16,28.03'}
G[106842]={'641:65.68,45.55'}
G[106879]={'627:69.69,43.06 N:104381'}
G[106881]={'630:64.25,56.12'}
G[106883]={'641:59.85,75.18'}
G[106897]={'680:61.83,49.10'}
G[106901]={'641:54.70,73.24'}
G[106902]={'750:38.08,46.04'}
G[106904]={'634:60.27,51.38'}
G[106905]={'760:66.24,66.84'}
G[106914]={'630:50.41,30.79'}
G[106915]={'630:50.46,30.73'}
G[106919]={'680:47.73,72.10'}
G[106920]={'630:62.68,32.25'}
G[106930]={'627:29.43,75.60'}
G[106942]={'709:46.70,46.77'}
G[106951]={'627:60.33,17.31'}
G[106990]={'630:65.55,56.77'}
G[107008]={'630:40.47,40.84'}
G[107020]={'634:59.02,30.88'}
G[107023]={'634:46.62,29.72'}
G[107025]={'747:48.37,55.61'}
G[107026]={'Near747'}
G[107075]={'680:33.70,28.89'}
G[107098]={'630:49.73,25.48'}
G[107102]={'630:34.70,43.96'}
G[107103]={'630:31.99,42.89'}
G[107105]={'630:33.37,41.36'}
G[107108]={'630:40.49,44.99'}
G[107113]={'630:37.21,43.25'}
G[107126]={'680:36.85,46.55'}	-- he moves to 1033:36.54,46.80 when 43318 turned in
G[107127]={'630:55.46,46.14'}
G[107132]={'760:61.47,65.69'}
G[107133]={'630:28.14,51.78'}
G[107135]={'630:30.80,45.97'}
G[107136]={'630:30.77,48.32'}
G[107139]={'630:46.86,40.95'}
G[107163]={'760:61.22,65.20'}
G[107201]={'630:26.32,44.18'}
G[107212]={'760:42.15,27.98'}
G[107216]={'630:28.34,45.67'}
G[107225]={'680:51.18,76.14'}
G[107244]={'630:63.85,28.94 N:106914'}
G[107245]={'630:63.88,28.88 N:106915'}
G[107251]={'630:58.48,44.89'}
G[107253]={'680:48.93,73.44'}
G[107258]={'634:44.26,34.56'}
G[107266]={'630:27.75,51.07'}
G[107269]={'630:28.32,52.08'}
G[107302]={'680:15.87,54.87'}
G[107323]={'630:33.22,56.28'}
G[107327]={'630:29.29,53.61'}
G[107328]={'630:35.12,45.97'}
G[107334]={'631:30.32,45.31'}
G[107335]={'630:29.09,52.46'}
G[107362]={'630:33.03,54.02'}
G[107363]={'630:32.89,52.79'}
G[107367]={'630:49.80,38.54'}
G[107368]={'630:33.03,53.18'}
G[107376]={'630:46.91,41.43'}
G[107379]={'630:48.18,73.90'}
G[107392]={'641:70.40,46.68'}
G[107398]={'680:17.17,37.89'}
G[107439]={'630:51.88,33.06'}
G[107440]={'630:34.55,42.24'}
G[107447]={'646:0.00,0.00'}
G[107449]={'680:49.93,65.02'}
G[107455]={'634:44.92,38.11'}
G[107460]={'634:30.27,40.56'}
G[107463]={'634:58.90,32.09'}
G[107469]={'634:51.84,29.67'}
G[107487]={'634:54.65,28.98'}
G[107498]={'634:54.05,30.20'}
G[107499]={'634:50.31,34.04'}
G[107545]={'630:31.48,51.11'}
G[107554]={'1:47.31,17.74'}
G[107567]={'680:39.25,60.80'}
G[107574]={'84:85.69,31.78'}
G[107588]={'634:72.32,51.66'}
G[107598]={'680:47.85,82.97'}
G[107616]={'10:66.84,39.41'}
G[107624]={'630:34.60,33.79'}
G[107625]={'630:39.15,34.72'}
G[107628]={'630:36.85,33.13'}
G[107629]={'630:36.94,35.04'}
G[107632]={'680:47.05,61.97'}
G[107657]={'630:34.93,33.87'}
G[107659]={'47:19.53,57.18'}
G[107660]={'750:42.95,38.80'}
G[107666]={'641:65.92,46.16'}
G[107667]={'634:57.80,21.02'}
G[107674]={'634:51.31,56.97'}
G[107675]={'634:51.37,57.25'}
G[107696]={'630:34.41,33.82'}
G[107712]={'680:48.31,83.25'}
G[107715]={'630:34.54,33.90'}
G[107720]={'680:47.47,71.32'}
G[107723]={'721:58.41,51.62 N:18417'}
G[107724]={'720:0.00,0.00'}
G[107753]={'634:46.99,56.45'}
G[107755]={'634:51.72,53.40'}
G[107758]={'634:49.83,57.80'}
G[107763]={'680:21.11,40.06'}
G[107801]={'630:59.84,12.03'}
G[107803]={'634:58.48,51.07'}
G[107805]={'634:50.77,51.64'}
G[107811]={'680:19.43,41.83'}
G[107840]={'634:36.96,31.84 634:44.86,59.26 634:37.35,63.77 634:33.82,45.75 634:63.46,61.63 634:51.35,57.27 634:75.01,55.53 634:56.51,67.59 634:54.46,68.77 634:52.55,64.11'}
G[107846]={'680:66.70,67.20'}
G[107883]={'634:53.18,76.34'}
G[107926]={'634:51.60,74.72'}
G[107934]={'84:37.08,43.09'}
G[107945]={'630:28.33,52.13'}
G[107959]={'685:0.00,0.00'}
G[107965]={'634:42.36,61.18'}
G[107968]={'627:26.01,52.08 N:20735'}
G[107979]={'37:36.78,52.57'}
G[107995]={'630:57.56,13.55 N:89794'}
G[107997]={'680:48.36,83.30'}
G[108009]={'657:60.19,54.07'}
G[108014]={'650:47.94,70.80'}
G[108017]={'652:54.91,77.94'}
G[108029]={'634:75.18,49.52'}
G[108030]={'634:72.41,55.73'}
G[108062]={'634:76.98,52.97'}
G[108063]={'680:44.21,73.05'}
G[108069]={'1024[29]Near N:99153'}
G[108072]={'634:74.90,55.57'}
G[108096]={'680:44.40,66.26'}
G[108101]={'685:0.00,0.00'}
G[108133]={'630:58.25,70.05'}
G[108136]={'630:58.50,78.98'}
G[108137]={'630:61.16,68.70'}
G[108139]={'630:60.16,65.14'}
G[108146]={'630:58.32,71.16'}
G[108153]={'630:57.69,75.06'}
G[108185]={'650:49.99,68.33'}
G[108190]={'680:65.70,62.73'}
G[108239]={'720:57.95,56.86'}
G[108250]={'720:57.87,57.14'}
G[108259]={'641:56.96,80.90'}
G[108283]={'634:42.59,43.10'}
G[108289]={'634:43.98,44.92'}
G[108304]={'641:59.42,84.12'}
G[108305]={'650:47.47,84.73 N:93826'}
G[108313]={'634:43.23,40.51'}
G[108314]={'680:35.14,73.85'}
G[108326]={'720:56.22,38.86'}
G[108327]={'641:59.76,81.72'}
G[108328]={'630:53.39,45.43'}
G[108334]={'630:55.50,70.25'}
G[108335]={'630:56.56,64.17'}
G[108338]={'630:55.47,70.28'}
G[108339]={'630:55.80,64.43'}
G[108340]={'630:57.52,63.11'}
G[108343]={'630:56.54,64.99'}
G[108348]={'630:56.12,68.37'}
G[108358]={'641:59.46,82.02'}
G[108389]={'680:15.22,51.83'}
G[108390]={'680:15.23,51.76'}
G[108411]={'680:48.29,83.24'}
G[108434]={'750:54.83,63.20 N:93826'}
G[108440]={'630:54.22,71.23'}
G[108446]={'630:54.73,68.82'}
G[108447]={'630:56.80,72.02'}
G[108450]={'630:54.96,72.46'}
G[108451]={'630:56.80,72.02'}
G[108454]={'630:53.93,72.15'}
G[108464]={'71:55.32,59.14'}
G[108489]={'657:40.30,50.57'}
G[108499]={'650:31.16,47.26'}
G[108504]={'650:29.78,40.09'}
G[108526]={'634:41.59,66.56'}
G[108528]={'680:55.29,39.97'}
G[108529]={'650:41.18,11.04'}
G[108535]={'680:13.64,48.45'}
G[108571]={'720:58.63,57.85 N:18417'}
G[108572]={'720:58.59,57.85 N:93011'}
G[108576]={'634:64.96,59.06'}
G[108600]={'641:59.04,82.44'}
G[108628]={'627:56.31,52.41'}
G[108663]={'634:66.51,63.84'}
G[108675]={'641:57.82,81.38'}
G[108678]={'641:55.45,43.38'}
G[108685]={'634:37.47,64.18'}
G[108721]={'630:48.47,27.09'}
G[108776]={'22:51.56,79.05 N:11034'}
G[108777]={'22:51.44,79.03 N:1854'}
G[108778]={'22:51.34,79.01 N:78577'}
G[108782]={'720:57.59,52.31'}
G[108784]={'720:59.64,49.13'}
G[108790]={'634:38.46,69.72'}
G[108825]={'627:0.00,0.00'}
G[108827]={'634:66.72,51.14'}
G[108829]={'630:43.24,68.02'}
G[108856]={'634:68.45,49.87'}
G[108870]={'680:58.21,53.04'}
G[108871]={'680:57.82,51.06'}
G[108872]={'680:54.53,52.24'}
G[108875]={'680:61.32,56.27'}
G[108876]={'641:46.22,50.35'}
G[108879]={'641:24.68,69.58'}
G[108885]={'634:52.46,23.80'}
G[108887]={'641:59.33,84.00'}
G[108916]={'84:18.99,26.45'}
G[108927]={'634:37.25,38.61'}
G[108940]={'634:70.84,44.35'}
G[108942]={'680:23.63,48.63'}
G[108949]={'634:52.48,23.95'}
G[108961]={'Near625'}
G[109008]={'680:22.80,36.18'}
G[109015]={'634:61.98,73.20'}
G[109022]={'680:30.54,40.01'}
G[109023]={'680:61.04,57.71'}
G[109025]={'680:62.17,58.93'}
G[109045]={'641:66.82,75.67'}
G[109053]={'630:61.43,41.71'}
G[109054]={'680:26.25,41.19'}
G[109073]={'641:68.26,71.82'}
G[109110]={'634:71.97,59.77'}
G[109113]={'634:30.72,33.86'}
G[109125]={'641:45.53,83.75'}
G[109154]={'630:45.74,40.13'}
G[109157]={'634:55.33,31.09'}
G[109163]={'649:70.67,19.92'}
G[109174]={'630:49.8,40'}
G[109180]={'680:62.87,58.49'}
G[109195]={'635:58.49,16.01'}
G[109196]={'627:95.16,64.90'}
G[109199]={'680:51.08,78.59'}
G[109201]={'641:47.79,76.91'}
G[109202]={'680:60.66,56.58'}
G[109212]={'680:60.59,56.38'}
G[109281]={'641:43.03,74.78'}
G[109295]={'627:95.13,65.14'}
G[109318]={'634:77.89,9.13'}
G[109324]={'922:36.15,59.78'}
G[109326]={'630:50.07,21.42'}
G[109331]={'630:38.31,84.57'}
G[109334]={'630:51.94,61.79 N:88873'}
G[109349]={'630:65.62,47.18'}
G[109368]={'630:47.39,40.02'}
G[109408]={'680:50.52,77.18'}
G[109409]={'680:45.77,74.89'}
G[109442]={'680:50.57,78.25'}
G[109466]={'84:85.79,31.71'}
G[109498]={'650:51.96,59.90'}
G[109504]={'630:32.65,48.76'}
G[109521]={'634:76.81,63.57'}
G[109575]={'630:58.27,21.38'}
G[109584]={'630:66.15,39.85'}
G[109594]={'630:51.07,58.10'}
G[109618]={'27:64.10,54.60'}
G[109620]={'630:43.16,7.61'}
G[109630]={'630:29.09,48.95'}
G[109631]={'641:66.68,77.25'}
G[109633]={'634:56.60,73.36'}
G[109635]={'634:57.37,72.43'}
G[109639]={'634:72.74,62.08'}
G[109640]={'634:73.98,58.61'}
G[109641]={'630:56.72,10.95'}
G[109647]={'680:55.48,64.87'}
G[109648]={'641:23.79,70.97'}
G[109653]={'630:33.65,28.65'}
G[109677]={'630:58.94,76.61'}
G[109692]={'641:33.64,61.58'}
G[109702]={'630:55.77,63.57'}
G[109708]={'641:67.09,69.55'}
G[109714]={'641:66.97,69.56'}
G[109734]={'641:35.00,56.04'}
G[109738]={'641:56.31,73.86'}
G[109741]={'10:48.57,58.90'}
G[109752]={'641:27.34,48.38'}
G[109788]={'648:0.00,0.00'}
G[109795]={'634:68.13,48.80'}
G[109803]={'680:15.23,51.87'}
G[109819]={'641:66.96,69.91'}
G[109823]={'709:31.31,40.72'}
G[109826]={'630:55.60,16.99'}
G[109839]={'641:32.41,47.89'}
G[109854]={'627:47.34,40.68'}
G[109867]={'634:69.03,20.25'}
G[109890]={'648:40.33,68.57'}
G[109912]={'10:51.33,57.59'}
G[109928]={'641:60.21,31.77'}
G[109929]={'641:60.31,33.80'}
G[109943]={'680:31.13,65.89'}
G[109954]={'680:42.10,80.20'}
G[109967]={'634:60.74,24.65'}
G[109990]={'641:32.40,47.93'}
G[110018]={'627:50.13,22.63'}
G[110024]={'680:34.13,60.98'}
G[110034]={'84:84.62,24.88'}
G[110035]={'86:36.38,74.25'}
G[110042]={'680:60.54,52.00'}
G[110073]={'630:37.16,17.21'}
G[110102]={'630:58.69,13.59'}
G[110253]={'680:69.87,63.07'}
G[110258]={'634:78.66,61.21'}
G[110321]={'685:35.75,67.13'}
G[110340]={'680:39.51,34.61'}
G[110342]={'641:69.51,57.52'}
G[110346]={'641:59.61,50.58'}
G[110347]={'630:35.84,18.67'}
G[110361]={'641:70.33,52.27'}
G[110363]={'634:58.41,34.23'}
G[110365]={'680:56.62,60.83'}
G[110371]={'680:21.32,33.45'}
G[110378]={'650:58.02,72.29'}
G[110415]={'680:44.66,74.40'}
G[110418]={'680:44.59,74.42'}
G[110423]={'641:64.77,46.27'}
G[110433]={'720:59.72,44.53'}
G[110435]={'630:35.97,18.60'}
G[110438]={'680:36.37,22.18'}
G[110448]={'630:35.42,13.25'}
G[110466]={'634:74.59,41.12'}
G[110468]={'630:38.41,17.52'}
G[110472]={'630:35.59,17.44'}
G[110482]={'720:0.00,0.00'}
G[110496]={'650:33.28,64.30'}
G[110502]={'650:55.39,68.56'}
G[110531]={'641:56.67,56.34'}
G[110538]={'684:42.28,14.99'}
G[110562]={'641:45.59,88.75'}
G[110577]={'680:24.44,47.51'}
G[110619]={'630:31.33,50.83'}
G[110642]={'628:76.10,83.57'}
G[110645]={'634:46.65,61.51'}
G[110656]={'680:65.52,59.24'}
G[110667]={'634:29.37,53.41'}
G[110679]={'680:57.54,57.58'}
G[110695]={'775:44.91,9.39 N:17204'}
G[110698]={'680:48.27,66.85'}
G[110702]={'680:35.40,41.33'}
G[110703]={'680:23.14,33.49'}
G[110726]={'680:62.67,47.38'}
G[110742]={'775:44.30,8.03'}
G[110768]={'720:0.00,0.00'}
G[110771]={'680:55.35,39.35'}
G[110773]={'630:48.14,25.60'}
G[110791]={'765:0.00,0.00'}
G[110805]={'680:30.03,76.85'}
G[110817]={'709:53.41,57.74'}
G[110824]={'680:18.61,61.12'}
G[110832]={'680:27.46,65.57'}
G[110838]={'630:37.89,15.37'}
G[110870]={'680:42.40,56.66'}
G[110896]={'641:56.95,53.27'}
G[110903]={'650:28.62,55.31'}
G[110904]={'650:32.39,60.15'}
G[110915]={'680:38.45,23.20'}
G[110916]={'650:58.16,18.85'}
G[110944]={'680:56.82,50.50'}
G[110949]={'680:38.22,87.08'}
G[110971]={'630:31.72,47.07'}
G[110975]={'650:39.81,62.69'}
G[110981]={'634:54.11,49.23'}
G[110987]={'680:50.68,56.58'}
G[111002]={'680:55.83,57.85'}
G[111007]={'680:49.65,79.06'}
G[111019]={'680:48.00,52.29'}
G[111062]={'680:46.98,53.05'}
G[111086]={'775:44.15,11.30'}
G[111109]={'627:57.61,45.75'}
G[111162]={'680:56.12,58.00'}
G[111184]={'750:45.70,38.88'}
G[111197]={'680:33.71,52.24'}
G[111206]={'634:44.40,24.96'}
G[111243]={'627:57.40,66.94'}
G[111246]={'627:63.57,54.84'}
G[111252]={'641:47.50,45.22'}
G[111278]={'641:46.79,44.72'}
G[111279]={'641:46.21,41.71'}
G[111280]={'641:46.94,43.94'}
G[111281]={'641:47.45,46.58'}
G[111291]={'634:47.92,62.46'}
G[111318]={'680:41.60,56.18'}
G[111323]={'646:49.67,21.03'}
G[111325]={'634:84.73,13.81'}
G[111327]={'634:52.09,33.47'}
G[111328]={'634:89.01,15.31'}
G[111329]={'680:36.03,34.23'}
G[111338]={'634:80.86,9.30'}
G[111383]={'641:33.62,55.42'}
G[111384]={'641:34.26,55.02'}
G[111397]={'634:88.90,11.02'}
G[111446]={'680:49.10,73.29'}
G[111456]={'630:45.91,79.33'}
G[111457]={'630:38.16,85.50'}
G[111459]={'641:24.41,66.48'}
G[111460]={'641:21.59,68.46'}
G[111469]={'630:43.64,82.13'}
G[111472]={'641:21.17,65.12'}
G[111473]={'641:21.87,65.07'}
G[111474]={'641:22.27,65.31'}
G[111479]={'630:43.64,82.13'}
G[111484]={'680:57.03,62.28'}
G[111489]={'680:54.54,63.12'}
G[111490]={'680:58.81,64.17'}
G[111530]={'680:34.82,22.39'}
G[111561]={'641:63.39,64.16'}
G[111578]={'650:41.03,43.41'}
G[111586]={'630:48.09,89.70'}
G[111599]={'680:33.10,18.43'}
G[111609]={'680:30.97,11.34'}
G[111611]={'680:32.02,13.61'}
G[111627]={'630:48.36,73.18'}
G[111636]={'790:52.23,67.58'}
G[111637]={'790:52.76,51.92'}
G[111641]={'790:40.61,53.08'}
G[111644]={'790:40.80,52.87'}
G[111647]={'790:54.28,36.18'}
G[111649]={'1033:55.04,64.31'}
G[111653]={'1033:62.46,63.67'}
G[111675]={'680:33.28,49.05'}
G[111736]={'720:0.00,0.00'}
G[111737]={'747:33.90,32.57'}
G[111751]={'630:42.85,79.16'}
G[111752]={'630:42.27,73.55'}
G[111760]={'634:55.13,65.87'}
G[111761]={'634:54.80,66.22'}
G[111763]={'630:43.13,74.87'}
G[111786]={'747:43.29,63.23'}
G[111814]={'634:62.53,68.22'}
G[111823]={'630:43.52,89.48'}
G[111826]={'680:37.81,47.40'}
G[111869]={'680:64.72,37.84'}
G[111871]={'680:64.66,37.79'}
G[111900]={'680:47.86,81.50'}
G[111903]={'680:47.81,82.87'}
G[111918]={'680:37.78,47.63'}
G[111921]={'680:58.90,41.80'}
G[111930]={'634:38.73,30.59'}
G[111939]={'630:43.62,89.80'}
G[111949]={'680:16.35,25.35'}
G[111952]={'680:16.34,25.33'}
G[111981]={'641:59.76,32.92'}
G[112016]={'680:56.02,64.95'}
G[112021]={'641:61.02,35.76'}
G[112052]={'641:63.31,39.52'}
G[112067]={'680:22.44,15.41'}
G[112130]={'629:26.76,35.01 N:78558'}
G[112140]={'680:35.40,28.94'}
G[112146]={'680:36.52,46.79'}
G[112154]={'634:38.54,55.16'}
G[112211]={'634:38.80,55.23'}
G[112217]={'634:38.64,55.44'}
G[112289]={'641:54.07,73.48'}
G[112323]={'747:40.08,24.78'}
G[112334]={'680:26.18,20.72'}
G[112338]={'709:50.36,58.95'}
G[112342]={'630:52.55,80.47'}
G[112350]={'630:52.58,80.85'}
G[112370]={'680:54.36,49.10'}
G[112407]={'720:59.16,54.30'}
G[112441]={'627:25.33,45.09'}
G[112444]={'680:26.21,20.66'}
G[112481]={'634:64.80,58.79'}
G[112497]={'680:24.88,34.59'}
G[112512]={'76:25.44,75.88'}
G[112530]={'680:61.89,60.90'}
G[112531]={'680:57.83,61.98'}
G[112544]={'715:31.19,36.61'}
G[112546]={'715:34.63,62.08'}
G[112548]={'715:30.76,50.86'}
G[112549]={'715:40.93,58.96'}
G[112570]={'71:51.89,28.54'}
G[112620]={'634:38.13,54.96'}
G[112624]={'634:38.44,55.28'}
G[112653]={'680:61.30,56.06'}
G[112666]={'Near625 N:108326'}
G[112696]={'627:60.92,44.73'}
G[112705]={'680:56.33,74.83'}
G[112727]={'630:69.47,30.41'}
G[112756]={'680:29.17,89.03'}
G[112757]={'680:50.13,79.15'}
G[112758]={'680:57.48,67.15'}
G[112759]={'680:81.37,62.35'}
G[112760]={'680:49.61,58.09'}
G[112796]={'680:65.51,55.45'}
G[112802]={'680:13.43,53.49'}
G[112856]={'641:73.79,54.42'}
G[112861]={'641:43.07,88.25'}
G[112866]={'630:56.43,59.35'}
G[112905]={'680:61.94,44.31'}
G[112910]={'680:38.70,33.33'}
G[112948]={'680:46.42,46.53'}
G[112953]={'720:58.66,43.11'}
G[112967]={'684:42.28,14.99'}
G[112972]={'680:64.90,49.73'}
G[113102]={'684:44.69,26.96'}
G[113125]={'680:41.25,40.43'}
G[113126]={'680:35.16,43.22'}
G[113127]={'680:26.66,68.92'}
G[113137]={'630:53.24,35.44'}
G[113162]={'680:17.87,49.09'}
G[113185]={'680:32.87,47.24'}
G[113190]={'680:34.42,44.18'}
G[113195]={'680:26.23,41.18'}
G[113205]={'680:61.60,51.45'}
G[113284]={'680:37.87,47.46'}
G[113355]={'793:43.76,50.34'}
G[113361]={'793:38.73,53.09'}
G[113417]={'680:54.61,44.42'}
G[113420]={'680:54.72,45.83'}
G[113457]={'680:50.32,79.39'}
G[113515]={'680:37.39,45.79'}
G[113525]={'747:52.30,52.79'}
G[113547]={'1:55.65,11.04'}
G[113567]={'680:35.10,58.89'}
G[113571]={'680:58.95,38.14'}
G[113572]={'680:50.03,39.19'}
G[113573]={'680:45.96,40.47'}
G[113597]={'680:48.50,63.57'}
G[113618]={'680:45.42,70.46'}
G[113619]={'680:44.77,67.20'}
G[113637]={'42:29.78,48.84 N:78558'}
G[113646]={'641:62.61,34.41'}
G[113655]={'42:30.86,49.03 N:28070'}
G[113679]={'680:46.29,69.37'}
G[113686]={'Near747'}
G[113706]={'680:39.35,60.88'}
G[113738]={'680:45.64,70.94'}
G[113765]={'680:44.44,75.78'}
G[113801]={'630:54.84,52.16'}
G[113813]={'627:66.30,68.11'}
G[113836]={'42:30.16,51.16 N:67996'}
G[113857]={'720:58.49,43.97'}
G[113911]={'634:33.33,31.42'}
G[113986]={'42:50.06,48.39 N:78558'}
G[113987]={'630:31.28,43.89'}
G[114113]={'680:31.27,54.46'}
G[114255]={'630:37.72,17.11'}
G[114263]={'808:0.00,0.00'}
G[114282]={'627:61.36,46.27'}
G[114299]={'680:33.00,18.57'}
G[114300]={'680:36.76,19.23'}
G[114303]={'680:36.54,20.68'}
G[114305]={'680:31.88,20.27'}
G[114310]={'42:47.01,75.30'}
G[114318]={'811:0.00,0.00'}
G[114442]={'641:44.28,52.31'}
G[114468]={'680:47.46,70.50'}
G[114470]={'680:50.01,77.05'}
G[114472]={'680:48.60,77.75'}
G[114474]={'680:48.10,72.08'}
G[114480]={'680:50.65,79.90'}
G[114488]={'542:48.01,44.72'}
G[114489]={'535:43.46,71.81'}
G[114490]={'550:80.54,47.70'}
G[114491]={'543:43.92,93.78'}
G[114492]={'630:48.26,29.68'}
G[114493]={'641:44.88,57.93'}
G[114494]={'650:55.52,84.45'}
G[114496]={'634:32.50,42.16'}
G[114499]={'525:72.59,65.09'}
G[114500]={'539:42.63,35.99'}
G[114518]={'680:30.47,45.39'}
G[114519]={'680:23.03,58.35'}
G[114550]={'581:29.23,34.25'}
G[114561]={'998:69.01,43.96'}
G[114562]={'747:31.22,53.75'}
G[114624]={'809:0.00,0.00'}
G[114631]={'42:46.94,75.38'}
G[114676]={'641:47.21,50.32'}
G[114719]={'627:42.32,27.03'}
G[114790]={'822:0.00,0.00'}
G[114793]={'680:20.94,40.83'}
G[114838]={'680:41.65,51.50'}
G[114841]={'680:40.6,53'}
G[114868]={'680:48.22,83.42'}
G[114876]={'680:47.61,81.26'}
G[114883]={'680:40.4,53.2'}
G[114908]={'680:41.60,51.66'}
G[114909]={'680:41.66,51.64'}
G[114946]={'627:73.86,41.70'}
G[114948]={'680:47.83,82.92'}
G[114956]={'680:52.08,79.19'}
G[114963]={'680:41.70,51.55'}
G[115002]={'680:25.80,88.53'}
G[115008]={'641:48.36,40.75'}
G[115015]={'641:56.19,78.34'}
G[115018]={'680:49.69,85.38'}
G[115021]={'641:55.25,77.32'}
G[115025]={'630:32.78,28.99'}
G[115039]={'680:52.24,68.72'}
G[115054]={'646:45.32,65.97'}
G[115056]={'646:47.64,70.83'}
G[115067]={'680:24.86,88.69'}
G[115119]={'641:55.59,79.07'}
G[115132]={'650:37.99,15.77'}
G[115164]={'42:40.48,76.05'}
G[115216]={'680:49.41,72.97'}
G[115247]={'680:43.29,78.76'}
G[115248]={'680:43.33,78.81'}
G[115249]={'680:49.39,72.51'}
G[115264]={'627:44.75,31.93'}
G[115273]={'680:41.08,69.62'}
G[115286]={'10:63.6,35.8'}
G[115291]={'634:54.06,45.67'}
G[115338]={'680:50.81,80.47'}
G[115342]={'680:39.90,51.39'}
G[115367]={'680:44.18,60.12'}
G[115371]={'680:37.07,46.59'}
G[115372]={'680:36.64,44.98'}
G[115376]={'680:24.75,88.88'}
G[115389]={'641:66.88,69.14'}
G[115462]={'630:51.07,36.68'}
G[115465]={'627:22.22,39.06'}
G[115466]={'627:22.48,40.51'}
G[115468]={'627:23.8,39.4'}
G[115469]={'680:53.93,39.81'}
G[115497]={'822:41.68,80.16'}
G[115499]={'680:39.93,50.95'}
G[115506]={'680:54.98,72.77'}
G[115517]={'680:46.45,58.18'}
G[115521]={'680:40.63,64.49'}
G[115524]={'680:44.02,59.73'}
G[115529]={'680:55.61,73.65'}
G[115546]={'111:64.13,71.29'}
G[115557]={'680:52.23,79.05'}
G[115561]={'680:31.63,53.20'}
G[115562]={'680:31.99,54.44'}
G[115566]={'680:31.25,54.52'}
G[115594]={'680:42.09,60.44'}
G[115601]={'646:44.32,62.81'}
G[115604]={'680:48.89,67.10'}
G[115620]={'646:44.31,62.76'}
G[115648]={'646:42.27,66.06'}
G[115656]={'641:40.42,49.27'}
G[115658]={'641:39.73,49.17'}
G[115663]={'634:78.55,77.01'}
G[115664]={'641:48.13,9.48'}
G[115665]={'650:33.22,26.02'}
G[115666]={'630:36.99,6.49'}
G[115667]={'634:77.92,72.10'}
G[115668]={'641:49.47,7.74'}
G[115669]={'650:33.59,25.06'}
G[115670]={'630:34.68,6.18'}
G[115671]={'634:78.16,77.56'}
G[115672]={'641:47.98,9.32'}
G[115673]={'650:34.99,21.83'}
G[115674]={'630:35.49,5.70'}
G[115675]={'630:38.42,6.03'}
G[115676]={'641:47.98,9.57'}
G[115677]={'650:33.05,25.32'}
G[115678]={'634:78.22,76.29'}
G[115679]={'650:36.53,20.22'}
G[115680]={'634:76.75,82.90'}
G[115682]={'641:52.75,9.61'}
G[115690]={'680:61.20,48.35'}
G[115691]={'680:66.68,57.42'}
G[115692]={'680:65.22,54.48'}
G[115693]={'630:59.81,14.05'}
G[115696]={'680:45.71,70.69'}
G[115697]={'680:45.98,79.87'}
G[115701]={'630:59.81,13.99'}
G[115703]={'680:50.80,77.89'}
G[115710]={'680:36.62,45.09'}
G[115724]={'680:65.26,55.28'}
G[115730]={'822:0.00,0.00'}
G[115736]={'680:36.50,46.72'}
G[115738]={'680:65.58,54.63'}
G[115749]={'198:44.32,47.97'}
G[115750]={'80:68.12,55.28'}
G[115755]={'680:64.83,54.85'}
G[115791]={'76:25.04,38.56'}
G[115802]={'198:40.94,42.57'}
G[115805]={'36:46.70,44.80'}
G[115806]={'680:47.87,81.19'}
G[115846]={'634:73.85,86.38'}
G[115866]={'646:79.50,42.23'}
G[115874]={'646:81.47,49.92'}
G[115876]={'646:81.42,49.91'}
G[115880]={'680:41.35,18.24'}
G[115891]={'641:49.62,41.85'}
G[115906]={'634:38.15,56.71'}
G[115924]={'680:40.79,52.71'}
G[115969]={'630:60.00,21.53'}
G[115987]={'680:28.05,61.95'}
G[116007]={'680:56.56,45.41'}
G[116010]={'680:35.82,47.10'}
G[116025]={'630:62.55,25.45'}
G[116026]={'630:61.37,22.52'}
G[116038]={'634:60.02,20.03'}
G[116039]={'634:61.42,20.31'}
G[116042]={'680:56.65,43.53'}
G[116048]={'76:25.20,37.95'}
G[116050]={'680:45.58,52.28'}
G[116060]={'680:55.30,39.95'}
G[116062]={'1033:56.11,40.16'}
G[116068]={'680:57.38,49.50'}
G[116084]={'680:35.78,78.93'}
G[116118]={'680:42.95,78.81'}
G[116119]={'680:65.81,54.54'}
G[116121]={'646:34.31,58.09'}
G[116159]={'771:0.00,0.00'}
G[116175]={'627:49.37,39.78'}
G[116180]={'634:72.95,88.99'}
G[116189]={'630:25.67,57.76'}
G[116205]={'630:35.29,34.47'}
G[116206]={'680:40.54,64.68'}
G[116218]={'680:60.56,48.20'}
G[116219]={'630:37.56,34.92'}
G[116223]={'680:60.59,48.17'}
G[116225]={'680:58.57,42.57'}
G[116256]={'680:39.78,51.28'}
G[116297]={'630:35.19,33.44'}
G[116302]={'646:44.74,63.28'}
G[116308]={'Near625'}
G[116360]={'680:51.68,63.08'}
G[116362]={'628:37.86,52.47'}
G[116393]={'646:59.56,27.26'}
G[116396]={'627:40.44,24.56'}
G[116421]={'1033:64.84,34.80'}
G[116424]={'630:66.70,48.36'}
G[116427]={'646:54.65,16.25'}
G[116428]={'630:64.89,48.47'}
G[116433]={'630:66.57,44.96'}
G[116436]={'630:67.09,51.43'}
G[116466]={'646:56.52,13.83'}
G[116469]={'646:52.80,18.83'}
G[116470]={'646:56.58,13.81'}
G[116472]={'646:50.01,16.43'}
G[116479]={'646:55.85,18.77'}
G[116489]={'680:83.59,61.64'}
G[116518]={'646:39.35,42.13'}
G[116521]={'630:63.07,20.04'}
G[116523]={'646:37.64,46.52'}
G[116529]={'680:62.65,52.91'}
G[116554]={'680:60.57,52.03'}
G[116555]={'680:60.13,52.06'}
G[116576]={'646:44.54,63.52'}
G[116580]={'634:47.50,17.58'}
G[116601]={'634:73.28,86.82'}
G[116675]={'680:22.92,27.48'}
G[116714]={'629:52.73,59.37'}
G[116736]={'770:0.00,0.00'}
G[116760]={'806:40.57,26.24'}
G[116781]={'10:38.93,68.14'}
G[116868]={'634:90.03,11.15'}
G[116880]={'627:52.05,19.58'}
G[116929]={'709:51.58,48.72'}
G[116951]={'646:52.74,46.39'}
G[116953]={'646:61.21,52.87'}
G[116955]={'630:59.53,36.18'}
G[116961]={'646:50.82,51.26'}
G[116981]={'634:79.43,58.43'}
G[116985]={'646:71.95,40.19'}
G[117018]={'634:80.94,61.80'}
G[117035]={'650:40.73,12.65'}
G[117036]={'630:42.78,41.38'}
G[117038]={'634:37.86,42.37'}
G[117039]={'641:55.73,68.57'}
G[117040]={'650:55.45,45.86'}
G[117042]={'627:74.71,45.55'}
G[117047]={'650:55.82,69.90'}
G[117049]={'641:57.45,87.54'}
G[117053]={'650:51.09,50.11'}
G[117054]={'641:35.96,63.63'}
G[117055]={'634:38.22,66.05'}
G[117056]={'630:48.91,44.15'}
G[117060]={'634:56.48,47.75'}
G[117061]={'630:43.60,32.73'}
G[117066]={'650:35.14,70.28'}
G[117068]={'630:51.97,11.67'}
G[117069]={'641:47.39,55.39'}
G[117080]={'634:60.12,28.43'}
G[117086]={'646:52.33,44.61'}
G[117088]={'646:49.89,57.39'}
G[117089]={'646:61.98,38.53'}
G[117090]={'646:49.03,47.79'}
G[117091]={'646:40.63,44.74'}
G[117093]={'646:58.25,47.50'}
G[117094]={'646:42.55,42.84'}
G[117095]={'646:57.48,30.78'}
G[117096]={'646:56.84,56.35'}
G[117101]={'646:49.34,56.29'}
G[117103]={'646:89.65,30.96'}
G[117136]={'646:49.79,37.14'}
G[117140]={'646:65.59,31.80'}
G[117141]={'646:59.56,27.39'}
G[117155]={'680:31.72,52.92'}
G[117165]={'646:47.77,55.52'}
G[117168]={'646:49.26,55.64'}
G[117212]={'650:55.02,55.71'}
G[117225]={'650:35.68,24.04'}
G[117239]={'646:59.90,29.00'}
G[117249]={'650:31.37,25.12'}
G[117250]={'750:27.62,24.31'}
G[117291]={'646:71.97,40.69'}
G[117292]={'650:29.13,30.12'}
G[117303]={'646:58.83,26.50'}
G[117304]={'646:50.86,55.67'}
G[117305]={'646:53.61,53.38'}
G[117306]={'646:50.27,55.64'}
G[117325]={'646:41.80,16.57'}
G[117334]={'750:25.56,46.70'}
G[117339]={'750:29.24,24.67'}
G[117350]={'646:39.76,35.13'}
G[117351]={'646:39.85,34.20'}
G[117352]={'646:37.87,22.34'}
G[117353]={'650:29.33,28.75'}
G[117354]={'646:37.71,30.33'}
G[117361]={'650:31.34,25.13'}
G[117412]={'680:61.36,43.07'}
G[117413]={'646:74.25,28.50'}
G[117425]={'646:38.75,26.10'}
G[117430]={'646:72.20,39.83'}
G[117432]={'81:33.91,81.82'}
G[117433]={'81:33.94,81.91'}
G[117434]={'81:34.01,80.48'}
G[117435]={'81:34.06,80.43'}
G[117470]={'646:89.75,33.04'}
G[117486]={'641:49.43,41.85'}
G[117487]={'646:88.90,31.83'}
G[117489]={'81:32.57,52.12'}
G[117490]={'81:55.76,72.44'}
G[117491]={'81:46.73,22.32'}
G[117492]={'646:77.05,28.79'}
G[117504]={'709:51.57,48.60'}
G[117509]={'646:37.71,33.26'}
G[117516]={'646:37.16,29.29'}
G[117555]={'646:59.16,45.08'}
G[117567]={'646:56.89,45.07'}
G[117593]={'646:78.31,39.97'}
G[117597]={'646:58.12,47.29'}
G[117611]={'646:83.95,51.09'}
G[117673]={'634:63.41,24.87'}
G[117718]={'646:77.16,39.95'}
G[117719]={'646:78.10,43.03'}
G[117735]={'630:56.55,62.46'}
G[117774]={'630:55.09,67.40'}
G[117780]={'630:51.39,36.78'}
G[117792]={'630:60.66,23.75'}
G[117793]={'646:53.29,50.51'}
G[117871]={'646:45.69,62.06'}
G[117873]={'646:44.77,63.18'}
G[117949]={'646:80.69,46.12'}
G[117950]={'646:46.41,20.67'}
G[117953]={'646:77.87,40.59'}
G[117954]={'646:79.90,43.50'}
G[117955]={'646:78.47,39.24'}
G[117956]={'646:78.02,39.43'}
G[117959]={'634:53.33,86.19'}
G[117962]={'650:25.60,44.71'}
G[117967]={'650:55.40,64.88'}
G[117969]={'634:51.81,33.38'}
G[117970]={'630:34.29,28.08'}
G[117971]={'650:35.49,63.47'}
G[117991]={'641:36.01,53.96'}
G[117993]={'650:58.21,64.02'}
G[117997]={'630:55.18,29.73'}
G[118000]={'630:42.47,11.19'}
G[118002]={'634:66.39,44.21'}
G[118006]={'634:76.13,57.46'}
G[118012]={'630:62.42,47.23'}
G[118016]={'641:50.64,73.64'}
G[118017]={'641:43.64,81.51'}
G[118050]={'650:34.67,32.18'}
G[118051]={'650:34.67,32.18'}
G[118057]={'646:54.48,79.98'}
G[118062]={'646:58.27,51.86'}
G[118077]={'641:49.65,77.09'}
G[118105]={'646:43.82,62.98'}
G[118134]={'646:57.70,59.46'}
G[118162]={'646:33.63,33.20'}
G[118177]={'649:49.72,45.01'}
G[118180]={'641:0.00,0.00'}
G[118183]={'641:39.10,51.63'}
G[118184]={'646:54.59,79.74'}
G[118223]={'646:56.45,76.47'}
G[118250]={'641:44.08,50.64'}
G[118255]={'646:44.12,75.80'}
G[118266]={'646:41.01,77.50'}
G[118280]={'634:37.51,38.68'}
G[118281]={'646:53.85,50.56'}
G[118322]={'646:42.65,17.28'}
G[118323]={'646:54.55,45.98'}
G[118335]={'646:54.86,18.02'}
G[118336]={'646:53.78,14.19'}
G[118342]={'646:67.53,29.23'}
G[118390]={'646:56.94,56.65'}
G[118410]={'634:37.45,38.56'}
G[118422]={'646:64.31,30.55'}
G[118431]={'747:46.40,48.70'}
G[118440]={'641:54.97,73.39'}
G[118441]={'646:48.85,54.84'}
G[118454]={'646:49.80,43.25'}
G[118455]={'646:52.69,46.93'}
G[118459]={'646:49.80,43.25'}
G[118472]={'646:49.03,39.08'}
G[118499]={'646:67.11,29.43'}
G[118657]={'646:52.84,39.90'}
G[118660]={'646:49.92,43.66'}
G[118676]={'646:54.97,32.09'}
G[118679]={'646:76.05,25.36'}
G[118680]={'646:77.87,29.67'}
G[118683]={'646:75.71,21.59'}
G[118721]={'646:42.74,40.39'}
G[118752]={'641:42.24,58.96'}
G[118753]={'630:63.65,18.32'}
G[118776]={'646:59.01,29.59'}
G[118778]={'634:81.68,7.17'}
G[118781]={'634:71.99,71.84'}
G[118782]={'630:63.04,19.38'}
G[118783]={'630:63.99,18.36'}
G[118786]={'646:34.62,56.20'}
G[118787]={'646:59.00,29.25'}
G[118788]={'646:32.64,57.42'}
G[118819]={'646:61.46,24.67'}
G[118828]={'554:43.09,55.22'}
G[118836]={'630:44.66,48.96'}
G[118840]={'634:64.03,60.12'}
G[118841]={'646:44.84,40.61'}
G[118846]={'646:44.92,41.73'}
G[118851]={'646:43.18,37.88'}
G[118857]={'646:43.10,38.25'}
G[118942]={'630:55.97,60.82'}
G[118943]={'646:42.95,16.32'}
G[118947]={'641:39.10,58.14'}
G[118954]={'641:39.09,58.07'}
G[118971]={'646:38.48,59.66'}
G[118975]={'630:0.00,0.00'}
G[118980]={'641:38.94,51.30'}
G[118993]={'646:39.32,79.83'}
G[119002]={'630:58.39,21.45'}
G[119015]={'646:42.06,55.02'}
G[119032]={'634:45.47,18.58'}
G[119053]={'646:46.01,45.03'}
G[119104]={'650:30.35,27.19'}
G[119105]={'650:31.37,28.87'}
G[119139]={'646:53.99,51.34'}
G[119143]={'634:32.21,35.24'}
G[119155]={'634:32.72,34.18'}
G[119173]={'646:43.43,46.81'}
G[119184]={'646:49.19,55.39'}
G[119187]={'646:43.44,56.00'}
G[119191]={'650:49.33,45.13'}
G[119203]={'646:77.65,26.05'}
G[119211]={'650:54.84,55.92'}
G[119305]={'646:44.57,62.99'}
G[119338]={'84:85.89,31.96'}
G[119340]={'84:86.52,35.90'}
G[119357]={'84:49.74,45.01'}
G[119388]={'830:56.56,67.57'}
G[119397]={'830:51.94,52.79'}
G[119489]={'650:51.52,61.15'}
G[119490]={'650:50.35,59.58'}
G[119533]={'830:58.81,75.28'}
G[119535]={'830:60.91,79.20'}
G[119543]={'830:60.83,79.40'}
G[119579]={'650:44.81,54.27'}
G[119597]={'830:56.30,75.66'}
G[119602]={'830:55.05,81.73'}
G[119603]={'646:44.23,53.58'}
G[119605]={'646:44.42,48.31'}
G[119629]={'646:44.53,53.26'}
G[119634]={'646:68.02,28.41'}
G[119654]={'650:45.02,9.27'}
G[119664]={'709:51.35,48.49'}
G[119673]={'650:45.80,9.14'}
G[119674]={'646:77.69,39.93'}
G[119676]={'650:50.14,64.36'}
G[119677]={'650:43.99,8.74'}
G[119692]={'646:40.26,50.86'}
G[119701]={'650:43.81,11.66'}
G[119718]={'646:60.38,45.01'}
G[119723]={'850:0.00,0.00'}
G[119749]={'882:40.98,68.62'}
G[119765]={'709:51.52,48.57'}
G[119767]={'750:62.40,67.09'}
G[119788]={'646:54.94,32.89'}
G[119869]={'627:47.99,40.99'}
G[119884]={'882:39.13,12.66'}
G[119886]={'646:39.54,71.67'}
G[119905]={'634:45.68,59.87'}
G[119908]={'634:45.46,57.89'}
G[119944]={'650:44.15,57.38'}
G[119982]={'Near198'}
G[120031]={'646:39.84,43.18'}
G[120032]={'80:68.18,54.78'}
G[120041]={'Near80'}
G[120068]={'646:28.57,62.77'}
G[120070]={'646:43.57,58.32'}
G[120071]={'630:46.75,11.90'}
G[120074]={'630:44.32,9.27'}
G[120076]={'646:45.04,52.07'}
G[120084]={'Near646'}
G[120085]={'646:63.62,57.27'}
G[120107]={'630:47.82,9.56'}
G[120112]={'646:60.10,50.12'}
G[120118]={'646:70.75,47.60'}
G[120126]={'646:72.12,41.49'}
G[120136]={'641:38.05,62.42'}
G[120144]={'641:40.94,60.58'}
G[120168]={'862:57.62,43.80'}
G[120170]={'1164:40.73,70.29 1165:49.43,45.91 862:57.78,44.38'}
G[120183]={'646:44.55,63.15'}
G[120200]={'641:66.42,70.95'}
G[120206]={'630:63.58,18.46'}
G[120208]={'646:56.92,56.66'}
G[120215]={'627:69.38,43.93'}
G[120216]={'646:71.63,33.28'}
G[120221]={'646:41.16,59.36'}
G[120226]={'646:31.38,60.71'}
G[120268]={'84:86.10,34.31'}
G[120272]={'646:44.59,63.14'}
G[120281]={'646:41.62,59.62'}
G[120288]={'646:60.47,25.02'}
G[120303]={'641:68.20,32.78'}
G[120304]={'641:73.61,54.32'}
G[120310]={'641:43.25,88.60'}
G[120321]={'641:71.14,36.45'}
G[120354]={'830:61.28,65.70'}
G[120372]={'646:44.56,63.39'}
G[120392]={'646:68.85,29.73'}
G[120393]={'830:58.31,75.72'}
G[120395]={'830:59.87,75.63'}
G[120414]={'646:42.13,58.85'}
G[120481]={'646:77.62,26.00'}
G[120529]={'830:56.65,67.43'}
G[120533]={'883:46.88,23.20'}
G[120551]={'863:75.28,56.47'}
G[120570]={'646:67.61,48.19'}
G[120590]={'84:27.64,21.29'}
G[120601]={'830:54.63,56.70'}
G[120603]={'882:53.48,69.53'}
G[120604]={'882:52.26,69.65'}
G[120631]={'646:83.20,29.44'}
G[120636]={'646:47.96,71.59'}
G[120637]={'830:57.45,56.07'}
G[120664]={'630:42.81,24.82'}
G[120692]={'630:49.14,44.02'}
G[120723]={'830:51.41,56.78'}
G[120725]={'646:54.86,76.51'}
G[120738]={'830:51.56,52.81'}
G[120740]={'1165:49.93,46.62 862:57.95,44.61'}
G[120745]={'646:32.85,57.10'}
G[120749]={'646:30.85,60.95'}
G[120756]={'84:85.31,32.28'}
G[120760]={'830:59.95,66.37'}
G[120763]={'830:60.84,47.25'}
G[120788]={'1161:68.01,22.18 895:73.81,25.14'}
G[120800]={'646:40.08,60.28'}
G[120816]={'646:39.46,60.96'}
G[120820]={'646:38.51,59.96'}
G[120837]={'646:30.85,60.95'}
G[120844]={'831:42.65,27.23'}
G[120855]={'641:51.24,78.49'}
G[120896]={'646:65.51,32.25'}
G[120898]={'646:44.39,62.25'}
G[120904]={'863:43.00,86.04'}
G[120922]={'1161:65.57,50.75 895:73.21,32.05'}
G[120932]={'646:54.63,64.74'}
G[120933]={'646:55.15,67.13'}
G[120934]={'646:52.72,72.60'}
G[120935]={'646:82.44,27.56'}
G[120938]={'646:82.47,28.03'}
G[120945]={'646:82.89,31.01'}
G[120947]={'747:29.95,4.24'}
G[120950]={'1165:56.24,87.05 862:60.05,58.06'}
G[120952]={'646:80.41,28.61'}
G[120953]={'830:50.41,53.83'}
G[120962]={'646:83.34,29.25'}
G[120963]={'646:65.03,44.67'}
G[120966]={'646:67.74,43.34'}
G[120977]={'893:33.78,65.53'}
G[120978]={'831:39.99,20.79 830:61.74,86.60'}
G[120998]={'646:39.79,60.61'}
G[121016]={'646:54.04,79.34'}
G[121022]={'630:53.95,26.41'}
G[121029]={'646:39.54,32.96'}
G[121031]={'646:66.93,42.18'}
G[121034]={'646:70.11,47.49'}
G[121035]={'646:67.16,42.97'}
G[121037]={'646:77.62,23.76'}
G[121039]={'641:62.94,64.08'}
G[121046]={'646:78.45,39.49'}
G[121058]={'646:65.98,45.19'}
G[121081]={'646:43.50,64.08'}
G[121107]={'646:42.65,17.46'}
G[121124]={'646:59.95,62.34'}
G[121134]={'646:78.05,27.42'}
G[121137]={'646:41.15,64.44'}
G[121144]={'1161:48.41,80.85 895:69.06,39.34'}
G[121151]={'650:30.04,30.34'}
G[121176]={'646:53.21,49.91'}
G[121210]={'862:57.96,62.77'}
G[121224]={'646:41.44,59.34'}
G[121226]={'646:52.62,48.43'}
G[121230]={'882:52.59,90.77'}
G[121235]={'1161:75.74,23.58 895:75.66,25.47'}
G[121237]={'646:58.20,26.52'}
G[121239]={'1169:47.36,46.25'}	-- was 876:79.84,59.33
G[121241]={'863:45.65,74.79'}
G[121242]={'863:68.71,57.08'}
G[121250]={'882:47.46,66.24'}
G[121251]={'882:46.11,64.82'}
G[121260]={'830:40.64,70.06'}
G[121263]={'831:43.44,23.30'}	-- in Vindicaar over Krokuun
G[121288]={'863:39.15,79.08'}
G[121345]={'830:59.91,69.14'}
G[121517]={'830:31.47,63.79'}
G[121518]={'882:43.47,67.71'}
G[121519]={'830:40.52,63.63'}
G[121520]={'830:40.64,64.33'}
G[121521]={'830:39.92,63.12'}
G[121531]={'830:40.61,63.22'}
G[121546]={'882:35.78,58.49'}
G[121548]={'830:41.52,69.58'}
G[121563]={'882:40.84,57.75'}
G[121577]={'862:57.96,21.01'}
G[121578]={'830:31.82,71.84'}
G[121584]={'862:57.99,19.87'}
G[121589]={'646:44.45,62.22'}
G[121597]={'882:31.93,37.43'}
G[121599]={'862:60.38,22.05'}
G[121601]={'862:56.87,19.05'}
G[121603]={'896:54.37,39.04'}
G[121629]={'882:24.66,40.35'}
G[121670]={'882:26.09,38.45'}
G[121671]={'882:24.62,41.30'}
G[121674]={'882:25.23,30.09'}
G[121684]={'896:55.60,41.18'}
G[121706]={'862:66.81,42.48'}
G[121754]={'84:21.37,30.46'}
G[121756]={'892:20.64,53.26'}
G[122004]={'862:71.17,32.44'}
G[122009]={'862:67.56,43.46'}
G[122014]={'882:35.15,36.28'}
G[122065]={'1:58.29,12.15'}
G[122078]={'862:58.37,19.91'}
G[122102]={'863:36.62,53.93'}
G[122113]={'862:66.69,32.47'}
G[122129]={'862:66.86,42.61'}
G[122153]={'864:48.89,74.49'}
G[122169]={'Near896'}
G[122239]={'863:68.45,52.79'}
G[122289]={'864:53.14,66.09'}
G[122297]={'1032:59.92,41.61'}
G[122320]={'1165:49.90,31.65 862:57.94,39.63'}
G[122353]={'882:56.01,63.79'}
G[122370]={'1161:67.99,21.89 895:73.79,25.07'}
G[122378]={'831:42.09,25.71'}
G[122403]={''}
G[122454]={'895:79.99,48.73'}
G[122493]={'896:54.74,49.14'}
G[122504]={'862:70.66,38.99'}
G[122510]={'898:59.98,54.50'}
G[122528]={'898:31.48,30.93'}
G[122551]={'898:55.44,64.23'}
G[122552]={'898:54.81,67.68'}
G[122553]={'898:56.74,65.99'}
G[122583]={'864:56.77,50.47'}
G[122621]={'830:40.37,63.36'}
G[122639]={'862:57.94,48.98'}
G[122641]={'862:57.90,44.55'}
G[122661]={'862:57.97,56.50'}
G[122663]={'898:59.76,53.57'}
G[122671]={'895:76.83,43.43'}
G[122672]={'895:76.81,43.48'}
G[122684]={'863:39.57,32.41'}
G[122688]={'863:39.56,24.72'}
G[122698]={'1165:43.99,34.62 862:55.97,40.62'}
G[122699]={'1165:43.66,34.62 862:55.86,40.62'}
G[122706]={'863:36.66,27.40'}
G[122723]={'864:43.65,59.94'}
G[122725]={'864:43.69,60.19'}
G[122760]={'862:50.66,29.67'}
G[122766]={'863:39.54,30.29'}
G[122795]={'863:39.63,43.86'}
G[122815]={'830:68.90,60.92'}
G[122817]={'1165:51.63,31.90 862:58.52,39.71'}
G[122835]={'830:69.54,56.48'}
G[122838]={'882:45.75,71.11'}
G[122871]={'899:0.00,0.00'}
G[122874]={'898:47.62,48.86'}
G[122875]={'898:63.92,72.39'}
G[122911]={'830:38.50,59.61'}
G[122912]={'830:33.19,75.42'}
G[122915]={'862:57.91,44.59'}
G[122924]={'830:59.83,77.98'}
G[122926]={'627:26.40,44.52'}
G[122939]={'862:65.62,41.33'}
G[122942]={'830:53.35,57.89'}
G[122958]={'885:61.83,36.95'}
G[122961]={'896:56.36,43.61'}
G[122968]={''}
G[122974]={'830:56.40,59.05'}
G[122991]={'863:67.38,42.10'}
G[122999]={'885:55.81,45.84'}
G[123000]={'1165:44.53,95.46 862:56.16,60.86'}
G[123005]={'862:67.51,17.72'}
G[123019]={'862:67.50,17.66'}
G[123022]={'862:67.51,17.72'}
G[123026]={'862:67.47,17.71'}
G[123052]={'864:56.62,10.32'}
G[123063]={'864:61.64,20.54'}
G[123095]={'862:69.29,21.62'}
G[123109]={'830:31.83,71.83'}
G[123110]={'830:38.23,67.56'}
G[123116]={'863:74.24,48.16'}
G[123118]={'862:68.83,19.45'}
G[123123]={'896:57.71,47.75'}
G[123130]={'830:69.82,66.27'}
G[123148]={'830:54.31,75.22'}
G[123149]={'830:54.23,75.43'}
G[123178]={'863:74.60,38.93'}
G[123236]={'895:54.54,35.10'}
G[123252]={'111:54.75,38.90'}
G[123335]={'1165:39.38,13.68 862:54.44,33.65'}
G[123395]={'831:45.39,73.69'}
G[123413]={'882:59.71,50.50'}
G[123415]={'895:50.31,37.23'}
G[123421]={'830:54.85,81.39'}
G[123422]={'830:60.28,74.39'}
G[123436]={'863:74.77,39.04'}
G[123453]={'863:81.97,30.22'}
G[123458]={'898:63.07,75.57'}
G[123464]={'830:52.81,30.97'}
G[123467]={'830:43.67,74.54'}
G[123508]={'882:65.27,56.84'}
G[123513]={'830:47.43,76.58'}
G[123544]={'863:82.31,27.20'}
G[123545]={'863:82.26,27.34'}
G[123548]={'863:82.31,27.17'}
G[123571]={'864:36.86,52.39'}
G[123586]={'864:56.81,50.47'}
G[123659]={'830:64.65,25.09'}
G[123667]={'882:43.37,67.60'}
G[123668]={'882:62.69,39.28 831:51.42,74.70 886:64.09,53.43 883:50.23,69.50'}	-- in Vindicaar, above Krokuun, Antoran Wastes and Mac'Aree
G[123689]={'830:54.67,81.26'}
G[123712]={'895:75.76,55.45'}
G[123729]={'864:42.80,61.11'}
G[123730]={'864:43.57,59.92'}
G[123781]={'897:56.32,68.40'}
G[123790]={'897:47.31,70.43'}
G[123813]={'864:60.57,14.47'}
G[123877]={'863:82.29,27.19'}
G[123878]={'863:81.36,26.11'}
G[124015]={'830:64.53,23.33'}
G[124019]={'864:58.21,40.56'}
G[124062]={'862:76.69,16.15'}
G[124063]={'862:76.47,16.13'}
G[124066]={'862:74.07,25.02'}
G[124069]={'862:74.17,25.09'}
G[124070]={'882:59.99,50.50'}
G[124083]={'862:76.70,16.21'}
G[124170]={'896:58.61,33.51'}
G[124185]={'862:74.08,28.20'}
G[124211]={'864:47.69,45.19'}
G[124289]={'1161:72.20,16.07 895:74.81,23.66'}
G[124303]={'830:71.23,33.12'}
G[124312]={'883:45.88,24.03'}	-- in Vindicaar above Mac'Aree
G[124348]={'830:56.34,67.46'}
G[124376]={'863:68.61,46.76'}
G[124398]={'882:41.10,71.07'}
G[124417]={'896:55.87,35.13'}
G[124428]={'863:39.52,43.84'}
G[124430]={'882:60.56,38.78'}
G[124432]={'882:56.05,29.93'}
G[124440]={'882:58.74,37.60'}
G[124444]={'882:57.70,32.32'}
G[124448]={'882:54.30,29.48'}
G[124468]={'864:45.65,82.35'}
G[124513]={'863:39.56,32.62'}
G[124527]={'864:43.36,28.72'}
G[124547]={'863:67.42,52.25'}
G[124595]={'830:56.75,67.49'}
G[124629]={'1165:42.64,21.57 862:55.53,36.27'}
G[124630]={'Near1161'}	-- Near895
G[124631]={'863:77.14,45.95'}
G[124635]={'864:49.02,87.53'}
G[124641]={'863:75.21,56.64'}
G[124654]={'864:43.65,59.97'}
G[124655]={'862:72.03,21.04'}
G[124656]={'862:72.08,21.15'}
G[124666]={'863:55.17,36.85'}
G[124667]={'864:42.83,92.48'}
G[124670]={'830:46.75,77.02'}
G[124687]={'830:47.12,76.93'}
G[124722]={'864:42.52,92.05 862:22.65,21.66'}
G[124729]={'903:0.00,0.00'}
G[124737]={'863:55.78,32.17'}
G[124749]={'862:48.33,32.15'}
G[124756]={'862:52.11,32.80'}
G[124775]={'830:45.34,58.87'}
G[124786]={'896:63.24,27.04'}
G[124802]={'895:51.57,27.27'}
G[124804]={'830:69.56,56.45'}
G[124827]={'862:48.39,32.10'}
G[124890]={'896:57.06,28.90'}
G[124906]={'830:31.68,58.21'}
G[124915]={'862:70.99,29.93'}
G[124922]={'896:60.51,31.64'}
G[124933]={'863:51.83,33.23'}
G[124948]={'862:70.88,29.84'}
G[124972]={'830:60.62,43.99'}
G[124974]={'830:61.04,47.77'}
G[124975]={'830:60.69,47.29'}
G[124987]={'830:60.73,47.55'}
G[124988]={'830:55.21,20.93'}
G[125024]={'863:55.84,32.28'}
G[125039]={'862:79.22,42.28'}
G[125041]={'862:79.21,42.10'}
G[125042]={'895:51.59,27.24'}
G[125047]={'862:81.35,45.79'}
G[125093]={'896:60.85,30.65'}
G[125109]={'830:57.19,33.88'}
G[125110]={'830:53.00,31.07'}
G[125129]={'830:59.48,42.52'}
G[125130]={'896:66.29,50.98'}
G[125137]={'924:68.73,57.34'}
G[125148]={'925:59.85,42.32'}
G[125174]={'862:82.08,39.90'}
G[125232]={'863:81.85,30.90'}
G[125246]={'830:56.90,68.65'}
G[125247]={'830:56.16,70.14'}
G[125250]={'863:67.47,29.72'}
G[125252]={'925:64.89,45.94'}
G[125280]={'926:49.10,45.50'}
G[125309]={'895:55.45,24.67'}
G[125312]={'862:59.95,58.65'}
G[125314]={'922:45.20,46.55'}
G[125317]={'863:77.74,53.19'}
G[125341]={'830:62.04,91.02'}
G[125342]={'895:86.36,79.74'}
G[125346]={'830:56.12,66.76'}
G[125366]={'863:75.66,47.04'}
G[125380]={'896:70.07,42.83'}
G[125385]={'896:69.67,43.18'}
G[125388]={'830:60.91,19.80'}
G[125394]={'896:70.08,42.94'}
G[125398]={'895:55.52,24.59'}
G[125401]={'896:65.54,40.54'}
G[125443]={'830:61.56,46.72'}
G[125452]={'896:69.52,39.93'}
G[125457]={'896:64.58,54.80'}
G[125460]={'1165:44.70,81.17 862:56.21,56.10'}
G[125468]={'830:68.75,81.31'}
G[125479]={'830:70.04,81.23'}
G[125483]={'924:69.31,42.00'}
G[125486]={'862:69.01,40.81'}
G[125497]={'882:57.67,25.88'}
G[125498]={'882:60.81,29.59'}
G[125512]={''}
G[125525]={'884:41.99,68.31'}	-- in Vindicaar above Mac'Aree
G[125527]={'923:65.39,66.31'}
G[125532]={'882:49.91,43.28'}
G[125578]={'923:61.34,61.85'}
G[125587]={'921:21.87,52.60'}
G[125634]={'922:47.20,42.46'}
G[125655]={'921:17.25,52.19'}
G[125666]={'925:61.05,40.61'}
G[125682]={'910:0.00,0.00'}
G[125757]={'925:66.64,43.23'}
G[125820]={'830:42.12,70.27'}
G[125824]={'833:40.33,42.66 830:50.36,17.39'}
G[125842]={'882:59.93,32.35'}
G[125862]={'864:43.29,77.01'}
G[125904]={'864:38.86,77.36'}
G[125922]={'895:42.28,29.30'}
G[125926]={'882:54.57,30.30'}
G[125952]={'863:77.11,47.96'}
G[125953]={'862:57.99,44.58'}
G[125962]={'895:37.57,29.54'}
G[125967]={'924:58.00,58.25'}
G[125970]={'925:47.64,44.00'}
G[126006]={'895:41.35,28.67'}
G[126017]={'863:52.53,31.36'}
G[126039]={'863:69.14,50.46'}
G[126040]={'885:65.07,21.28'}
G[126056]={'863:49.44,37.44'}
G[126062]={'85:37.97,80.65 1:41.69,7.29'}
G[126065]={'85:37.98,80.95 1:41.69,7.39'}
G[126066]={'85:37.75,80.65 1:41.62,7.29'}
G[126079]={'863:38.94,59.93'}
G[126080]={'863:38.90,59.91'}
G[126085]={'864:42.13,76.25'}
G[126108]={'864:43.66,76.75'}
G[126109]={'885:63.89,57.10'}
G[126111]={'885:65.96,51.93'}
G[126115]={'885:62.99,57.35'}
G[126146]={'863:41.29,53.48'}
G[126148]={'862:56.06,56.44 1165:44.26,82.17'}
G[126152]={'882:21.93,40.97'}
G[126158]={'895:84.90,76.06'}
G[126160]={'830:64.44,62.61'}
G[126164]={'885:71.37,70.25'}
G[126165]={'885:72.02,67.38'}
G[126167]={'885:70.70,70.13'}
G[126168]={'885:64.50,67.31'}
G[126174]={'885:52.92,34.97'}
G[126187]={'863:41.18,53.51'}
G[126196]={'885:72.53,67.56'}
G[126197]={'885:64.52,51.06'}
G[126198]={'885:59.99,52.82'}
G[126199]={'885:52.96,35.84'}
G[126208]={'885:64.83,50.82'}
G[126210]={'896:62.62,42.97'}
G[126213]={'863:67.40,42.27'}
G[126231]={'924:60.86,57.31'}
G[126233]={'885:75.81,64.64'}
G[126239]={'830:58.76,78.35'}
G[126254]={'885:62.08,53.27'}
G[126288]={'863:26.21,38.31'}
G[126289]={'863:28.59,43.80'}
G[126298]={'895:39.55,26.69'}
G[126301]={'84:52.08,13.43'}
G[126307]={'831:40.18,23.46'}	-- in Vindicaar above Krokuun
G[126308]={'895:39.52,26.74'}
G[126310]={'896:70.07,60.27'}
G[126319]={'84:52.12,13.69'}
G[126321]={'84:52.23,13.50'}
G[126334]={'1165:35.44,7.79 862:53.13,31.69'}
G[126335]={'885:59.83,62.58'}
G[126336]={'885:57.99,68.14'}
G[126337]={'885:62.39,70.84'}
G[126338]={'885:61.34,65.14'}
G[126346]={'863:28.62,43.84'}
G[126377]={'863:26.52,37.94'}
G[126389]={'884:57.23,68.30 887:63.05,42.82 832:59.09,70.86'}	-- in Vindicaar above Mac'Aree, Antoran Wastes and Krokuun
G[126408]={'831:40.06,19.20'}	-- in Vindicaar above Krokuun
G[126419]={'830:71.07,32.77'}
G[126438]={'895:86.19,79.00'}
G[126440]={'895:87.97,75.02'}
G[126457]={'885:60.77,44.40'}
G[126460]={'863:31.43,38.48'}
G[126472]={'943:61.68,26.23'}
G[126502]={'864:43.18,73.93'}
G[126511]={'895:82.71,72.74'}
G[126549]={'862:58.53,42.84'}
G[126560]={'1165:45.26,24.01'}
G[126564]={'1165:51.89,11.89 862:58.60,33.05'}
G[126576]={'864:43.39,75.38'}
G[126588]={'863:42.57,31.44'}
G[126606]={'863:41.11,30.54'}
G[126620]={'895:80.20,75.26'}
G[126626]={'895:59.01,24.63'}
G[126629]={'896:69.18,61.29'}
G[126637]={'862:68.51,48.85'}
G[126684]={'862:58.00,57.30'}
G[126696]={'864:52.94,66.50'}
G[126702]={'863:33.02,81.81'}
G[126713]={'863:38.83,77.70'}
G[126723]={'863:31.50,74.35'}
G[126749]={'863:29.49,74.34'}
G[126765]={'830:33.52,71.48'}
G[126770]={'895:78.58,79.71'}
G[126784]={'830:38.86,69.99'}
G[126804]={'895:55.97,17.52'}
G[126807]={'863:30.57,47.55'}
G[126814]={'864:53.88,69.42'}
G[126815]={'882:52.92,66.80'}
G[126817]={'864:53.21,70.12'}
G[126846]={'863:31.98,44.54'}
G[126852]={'882:55.55,60.50'}
G[126860]={'882:37.83,54.66'}
G[126862]={'882:43.67,60.85'}
G[126864]={'882:41.53,11.51'}
G[126865]={'882:36.66,24.06'}
G[126866]={'882:63.77,64.37'}
G[126867]={'882:33.64,48.10'}
G[126868]={'882:38.45,64.33'}
G[126869]={'882:27.14,30.10'}
G[126885]={'882:35.15,37.44'}
G[126887]={'882:30.30,40.68'}
G[126889]={'882:70.30,45.95'}
G[126896]={'882:36.03,58.88'}
G[126898]={'882:43.65,49.56'}
G[126899]={'882:48.09,40.54'}
G[126900]={'882:61.33,50.18'}
G[126910]={'882:56.71,15.07'}
G[126912]={'882:49.82,9.65'}
G[126913]={'882:48.69,53.09'}
G[126917]={'885:51.41,52.88'}
G[126926]={'863:29.13,50.21'}
G[126941]={'885:57.22,33.57'}
G[126942]={'885:55.78,29.85'}
G[126943]={'885:52.43,35.14'}
G[126944]={'885:56.77,35.34'}
G[126946]={'885:60.62,48.36'}
G[126950]={'886:26.92,65.69'}
G[126954]={'886:33.36,64.80'}
G[126973]={'896:59.18,20.09'}
G[126979]={'896:59.36,21.99'}
G[126995]={'882:54.47,10.29'}
G[126996]={'882:51.96,12.14'}
G[126997]={'882:55.30,13.00'}
G[126998]={'882:55.30,13.00'}
G[127004]={'863:39.51,43.77'}
G[127006]={'895:55.60,24.60'}
G[127012]={'885:78.01,65.68'}
G[127015]={'896:53.92,26.99'}
G[127029]={'1165:50.78,13.51 862:58.23,33.59'}
G[127033]={'885:72.39,74.84'}
G[127037]={'882:43.98,60.91'}
G[127051]={'885:68.78,26.09'}
G[127057]={'887:30.31,59.44'}
G[127068]={'943:51.22,47.02'}
G[127080]={'896:59.45,21.91'}
G[127083]={'882:46.78,55.51'}
G[127084]={'885:82.72,65.58'}
G[127091]={'895:55.67,14.76'}
G[127096]={'885:75.84,56.31'}
G[127097]={'885:57.65,15.61'}
G[127103]={'885:57.71,15.24'}
G[127114]={'885:51.11,54.45'}
G[127118]={'885:50.90,55.50'}
G[127120]={'886:62.58,63.96 883:43.36,67.09 831:43.24,74.41'}	-- in Vindicaar above Antoran Wastes, Mac'Aree and Krokuun
G[127132]={'863:31.56,74.76'}
G[127144]={'895:54.47,19.39'}
G[127150]={'895:58.43,16.52'}
G[127151]={'883:66.74,58.92'}	-- in Vindicaar above Mac'Aree
G[127157]={'896:51.37,23.27'}
G[127161]={'895:75.84,65.85'}
G[127162]={'885:54.24,25.53'}
G[127173]={'885:66.69,28.94'}
G[127178]={'885:72.00,50.35'}
G[127188]={'885:67.32,39.21'}
G[127189]={'885:66.89,33.13'}
G[127212]={'863:30.89,52.01'}
G[127215]={'863:31.06,52.02'}
G[127216]={'863:30.95,52.10'}
G[127217]={'895:76.69,65.03'}
G[127224]={'863:30.60,54.73'}
G[127247]={'863:32.97,53.92'}
G[127253]={'863:30.44,56.17'}
G[127255]={'863:29.96,57.32'}
G[127270]={'885:65.55,28.42'}
G[127281]={'882:27.01,30.07'}
G[127288]={'885:63.71,22.96'}
G[127291]={'885:52.86,28.84'}
G[127296]={'896:62.56,23.93'}
G[127300]={'885:55.80,21.90'}
G[127333]={'896:59.02,17.35 895:41.37,34.59'}
G[127374]={'885:61.21,21.22'}
G[127376]={'885:61.40,20.87'}
G[127391]={'863:33.34,45.86'}
G[127396]={'896:59.03,22.38'}
G[127418]={'896:56.54,24.05'}
G[127476]={'832:69.61,54.39 887:55.25,26.52 884:68.15,57.20'}	-- in Vindicaar above Krokuun, Antoran Wastes and Mac'Aree
G[127481]={'895:70.90,61.99'}
G[127489]={'1165:49.92,33.42 862:57.95,40.22'}
G[127492]={'895:51.29,25.87'}
G[127530]={'896:70.60,52.83'}
G[127537]={'895:79.19,76.32'}
G[127557]={'885:67.19,50.85'}
G[127558]={'896:71.81,50.42'}
G[127559]={'895:52.54,28.50'}
G[127570]={'864:53.19,90.17'}
G[127579]={'885:55.89,19.24'}
G[127581]={'885:55.02,38.93'}
G[127584]={'885:62.02,22.99'}
G[127586]={'895:51.31,25.91'}
G[127596]={'885:64.68,69.28'}
G[127614]={'895:51.80,26.39'}
G[127626]={'895:75.75,55.44'}
G[127646]={'895:75.82,65.78'}
G[127664]={'1165:40.31,19.23 862:54.75,35.50'}
G[127665]={'1165:40.25,19.06'}
G[127670]={'885:71.18,70.12'}
G[127671]={'885:72.25,67.51'}
G[127691]={'864:52.83,89.23'}
G[127709]={'Near895'}
G[127715]={'896:46.11,33.42'}
G[127722]={'885:52.58,39.03'}
G[127743]={'896:69.48,43.74'}
G[127751]={'830:62.50,46.98'}
G[127776]={'864:44.55,79.99'}
G[127777]={'882:47.91,45.69'}
G[127803]={'895:58.29,25.40'}
G[127811]={'885:57.66,15.36'}
G[127814]={'862:47.88,60.41'}
G[127815]={'862:47.94,60.44'}
G[127835]={'862:71.73,64.15'}
G[127837]={'862:47.18,60.42'}
G[127839]={'862:72.04,63.23'}
G[127874]={'896:58.87,53.81'}
G[127903]={'863:61.49,13.11'}
G[127934]={'882:50.59,17.63'}
G[127942]={'830:31.16,58.58'}
G[127958]={'863:56.54,26.79'}
G[127960]={'863:39.46,44.00'}
G[127961]={'863:39.46,44.01'}
G[127966]={'864:53.15,90.24'}
G[127980]={'864:53.57,91.39'}
G[127989]={'864:53.03,78.71'}
G[127992]={'864:53.19,90.23'}
G[128096]={'863:56.59,26.68'}
G[128152]={'864:53.17,91.57'}
G[128228]={'895:85.47,80.72'}
G[128229]={'895:85.47,80.81'}
G[128261]={'864:35.47,83.76'}
G[128276]={'863:31.24,46.85'}
G[128319]={'882:35.64,23.77'}
G[128334]={'864:53.70,89.23'}
G[128349]={'1171:58.64,37.78 895:63.54,24.19'}
G[128353]={'1171:51.20,70.60 895:63.13,26.01'}
G[128354]={'1171:50.44,70.50 895:63.08,26.00'}
G[128357]={'882:55.40,65.85'}
G[128359]={'882:66.31,53.06'}
G[128366]={'885:52.57,26.57'}
G[128367]={'885:54.41,27.32'}
G[128370]={'885:73.60,49.05'}
G[128377]={'895:85.80,83.53'}
G[128381]={'895:62.72,29.95'}
G[128422]={'864:47.62,86.19'}
G[128457]={'896:55.16,35.14'}
G[128467]={'896:55.57,34.80'}
G[128494]={'896:66.92,42.16'}
G[128497]={'864:31.23,80.48'}
G[128553]={'864:48.96,89.03'}
G[128584]={'863:46.82,34.55'}
G[128610]={'863:49.74,67.33'}
G[128618]={'864:44.59,88.25'}
G[128620]={'863:71.02,60.43'}
G[128632]={'862:76.72,65.29'}
G[128652]={'876:58.53,61.19 947:73.01,50.59'}
G[128658]={'863:75.07,60.75'}
G[128674]={'864:64.01,47.66'}
G[128676]={'895:42.37,28.27'}
G[128679]={'895:34.96,24.22'}
G[128680]={'895:42.19,29.32'}
G[128686]={'864:35.03,51.82'}
G[128687]={'864:27.21,53.94'}
G[128691]={'864:32.33,48.35'}
G[128694]={'864:27.10,52.55'}
G[128696]={'864:27.20,53.86'}
G[128699]={'862:59.84,18.36'}
G[128702]={'895:79.70,81.85'}
G[128722]={'883:53.32,50.02'}	-- in Vindacaar above Mac'Aree
G[128725]={'883:46.94,23.16'}	-- in Vindicaar above Mac'Aree
G[128735]={'883:57.14,60.52 882:52.49,90.87'}	-- in Vindicaar above Mac'Aree
G[128888]={'862:70.30,65.07'}
G[128889]={'862:73.69,60.94'}
G[128903]={'895:76.89,85.97'}
G[128909]={'862:60.57,59.79'}
G[128925]={'862:75.22,61.48'}
G[128927]={'895:77.35,83.93'}
G[128930]={'863:52.69,53.21'}
G[128949]={'919:0.00,0.00'}
G[128965]={'863:44.12,49.04'}
G[128973]={'896:64.99,21.39'}
G[128997]={'942:66.97,12.07'}
G[129003]={'895:42.36,22.27'}
G[129027]={'864:59.57,8.54'}
G[129088]={'862:50.18,64.52'}
G[129097]={'895:77.07,81.23'}
G[129098]={'895:77.04,82.90'}
G[129107]={'943:46.05,19.53'}
G[129110]={'895:48.88,17.99'}
G[129127]={'863:62.39,24.61'}
G[129164]={'863:62.68,53.55'}
G[129165]={'863:63.16,52.71'}
G[129170]={'895:42.49,22.71'}
G[129180]={'864:37.06,45.90'}
G[129181]={'895:76.00,83.02'}
G[129291]={'895:42.00,16.76'}
G[129318]={'862:60.61,66.11'}
G[129343]={'862:49.76,57.47'}
G[129378]={'863:33.37,45.84'}
G[129392]={'895:47.71,17.64'}
G[129394]={'1165:56.47,92.73 862:60.13,59.95'}
G[129429]={'919:0.00,0.00'}
G[129436]={'864:48.03,43.84'}
G[129450]={'864:45.36,46.21'}
G[129451]={'864:45.36,46.21'}
G[129453]={'864:45.37,46.20'}
G[129476]={'864:48.84,50.06'}
G[129491]={'1165:38.92,27.20 862:54.29,38.15'}
G[129514]={'864:47.73,82.05'}
G[129515]={'862:49.60,43.91'}
G[129519]={'864:27.62,52.56'}
G[129561]={'862:49.33,44.38'}
G[129578]={'895:47.85,16.39'}
G[129586]={'862:70.44,65.11'}
G[129588]={'864:27.08,52.59'}
G[129590]={'895:48.62,14.51'}
G[129602]={''}
G[129613]={'895:68.96,20.59'}
G[129624]={'895:68.89,17.67'}
G[129633]={'896:37.82,50.17'}
G[129642]={'896:36.86,50.14'}
G[129643]={'896:36.97,50.09'}
G[129655]={'Near895'}
G[129657]={'863:38.84,26.90'}
G[129668]={'1165:43.64,31.82 862:55.86,39.68'}
G[129669]={'895:68.89,19.85'}
G[129670]={'895:66.62,17.32'}
G[129674]={'832:39.58,65.21 887:56.67,67.14 884:41.38,58.29'}	-- in Vindicaar above Krokuun, Antoran Wastes and Mac'Aree
G[129703]={'862:49.64,37.91'}
G[129717]={'862:70.56,64.89'}
G[129740]={'862:49.28,44.35'}
G[129750]={'942:50.13,63.32'}
G[129757]={'862:42.73,37.69'}
G[129763]={'864:47.18,39.25'}
G[129764]={'896:57.21,44.67'}
G[129768]={'895:68.38,19.72'}
G[129776]={'864:52.09,26.10'}
G[129806]={'942:47.57,63.28'}
G[129808]={'942:50.76,73.14'}
G[129812]={'896:52.45,28.04'}
G[129835]={'896:57.10,44.30 895:39.89,55.46'}
G[129858]={'895:67.50,55.81'}
G[129870]={'942:47.50,68.81'}
G[129877]={'896:55.78,44.50'}
G[129907]={'862:62.81,32.58'}
G[129940]={'895:75.47,22.18'}
G[129950]={'896:31.95,40.67 895:20.42,52.64'}
G[129956]={'895:65.84,50.10'}
G[129961]={'862:80.87,21.66'}
G[129983]={'896:40.22,56.50'}
G[129999]={'942:59.18,69.49'}
G[130006]={'942:64.12,61.13'}
G[130030]={'81:69.36,17.62'}
G[130032]={'81:68.96,19.09'}
G[130033]={'81:66.38,56.80'}
G[130039]={'942:68.25,51.53'}
G[130073]={'942:47.00,69.60'}
G[130088]={'942:67.89,45.40'}
G[130094]={'942:67.52,44.74'}
G[130101]={'895:62.95,29.92'}
G[130131]={'942:61.26,63.74'}
G[130133]={'110:58.09,19.60'}
G[130159]={'895:77.12,82.91'}
G[130190]={'942:57.61,66.42'}
G[130216]={'81:42.23,44.26'}
G[130221]={'862:66.36,29.60'}
G[130233]={'864:43.63,78.54'}
G[130303]={'1032:48.02,44.49'}
G[130341]={'864:56.82,50.47'}
G[130348]={'864:37.43,42.60'}
G[130349]={'864:37.46,44.25'}
G[130375]={'895:81.10,42.48'}
G[130377]={'1161:69.23,11.39 895:74.10,22.53'}
G[130401]={'864:57.23,73.02'}
G[130414]={'862:46.15,23.88'}
G[130419]={'896:55.87,35.06'}
G[130424]={'895:43.68,15.25'}
G[130427]={'864:35.54,43.83'}
G[130450]={'862:47.29,24.97'}
G[130455]={'864:66.00,36.72'}
G[130468]={'862:46.24,23.36'}
G[130474]={'864:65.99,36.73'}
G[130478]={'895:44.91,15.50'}
G[130481]={'863:39.06,60.68'}
G[130549]={'940:43.88,27.09'}
G[130576]={'942:59.23,68.63'}
G[130643]={'862:76.75,27.68'}
G[130660]={'864:53.54,91.68'}
G[130667]={'864:52.82,89.27'}
G[130694]={'942:57.63,66.49'}
G[130697]={'895:58.31,60.67'}
G[130706]={'862:63.62,31.75'}
G[130714]={'942:63.32,64.99'}
G[130715]={'942:63.45,64.96'}
G[130720]={'863:23.40,53.79'}
G[130722]={'863:23.42,62.98'}
G[130727]={'863:24.89,59.11'}
G[130735]={'863:23.61,47.34'}
G[130750]={'862:54.71,89.75'}
G[130785]={'1165:51.98,41.40 862:58.63,42.87'}
G[130786]={'942:66.90,56.47'}
G[130809]={'942:38.10,27.03'}
G[130810]={'940:47.14,40.02'}
G[130821]={'1176:43.58,49.17 862:52.10,87.36'}
G[130822]={'942:31.29,41.64'}
G[130833]={'862:57.82,76.68'}
G[130840]={'862:52.48,87.49'}
G[130844]={'863:47.24,79.74'}
G[130897]={'942:47.34,65.32'}
G[130902]={''}
G[130904]={'942:64.60,62.11'}
G[130905]={'862:64.03,35.49'}
G[130919]={'95:79.70,19.73'}
G[130928]={'863:28.36,52.08'}
G[130929]={'862:64.10,35.34'}
G[130930]={'863:24.15,53.18'}
G[130932]={'1164:65.34,83.66 1165:51.00,46.77 862:58.31,44.66'}
G[130933]={'Near896'}
G[130934]={'Near942'}
G[130947]={'862:50.19,54.55'}
G[130953]={'862:48.64,52.88'}
G[130954]={'862:48.45,52.98'}
G[130993]={'940:49.26,43.75'}
G[131000]={'942:34.11,54.87'}
G[131001]={'942:34.77,47.49'}
G[131002]={'942:30.16,59.20'}
G[131003]={'942:34.58,47.16'}
G[131004]={'942:59.51,69.94'}
G[131014]={'942:35.01,47.68'}
G[131048]={'895:56.68,61.18'}
G[131049]={'862:43.68,39.36'}
G[131069]={'25:38.55,64.24'}
G[131155]={'863:69.86,33.54'}
G[131169]={'863:67.98,36.87'}
G[131187]={'862:51.65,50.53'}
G[131213]={'863:67.40,42.29'}
G[131231]={'863:24.15,53.19'}
G[131233]={'862:58.60,74.18'}
G[131248]={'942:66.49,56.43'}
G[131249]={'942:66.49,56.51'}
G[131252]={'895:43.18,17.14'}
G[131253]={'863:66.98,38.82'}
G[131258]={'862:47.42,52.37'}
G[131262]={'895:39.10,15.39'}
G[131285]={'863:69.76,33.65'}
G[131287]={'862:58.35,44.40'}
G[131290]={'1161:66.87,33.23 895:73.53,27.81'}
G[131302]={'895:58.38,65.66'}
G[131306]={'895:58.43,67.07'}
G[131326]={'680:59.36,85.50'}
G[131328]={'85:49.66,76.50 1:45.53,5.92'}
G[131334]={'84:62.50,29.75'}
G[131345]={'971:28.53,22.27'}
G[131347]={'84:62.48,29.74'}
G[131354]={'862:47.33,25.07'}
G[131389]={'895:63.74,50.34'}
G[131404]={'942:64.48,65.89'}
G[131442]={'896:26.67,72.19'}
G[131443]={'1163:68.25,74.89 1165:51.19,46.21 862:58.37,44.47'}
G[131448]={'896:25.29,67.88'}
G[131461]={'Near862'}
G[131469]={'896:25.54,70.10'}
G[131475]={'862:82.77,42.32'}
G[131478]={'680:65.88,63.74'}
G[131490]={'862:80.19,36.78'}
G[131530]={'896:32.05,20.11'}
G[131579]={'896:26.16,66.49'}
G[131580]={'862:43.91,72.10'}
G[131582]={'862:43.93,72.10'}
G[131596]={'863:48.79,28.98'}
G[131602]={'943:60.79,25.18'}
G[131624]={'862:40.79,71.13'}
G[131627]={'895:49.46,31.26'}
G[131633]={'864:60.27,14.03'}
G[131636]={'896:32.05,30.95'}
G[131638]={'896:32.02,31.00'}	-- once we start 50003 she moves to 896:31.97,31.15 and then when 50003 is ready for turn in she moves to 896:31.23,29.92 and when 50149 is ready to turn in she moves to 896:31.43,30.25.  When 50457 is ready to turn in she moves to 896:31.01,20.25.  When 50588 ready to turn in she has moved to 896:32.82,15.34.  When you accept 50639 she moves into the dungeon.  At this point she also goes back to being (129642) at 896:36.87,50.11 where you can turn them all in.
G[131639]={'896:28.54,25.64'}
G[131640]={'896:31.27,22.72'}
G[131641]={'896:26.23,36.10'}
G[131642]={'896:30.63,21.64'}
G[131654]={'895:58.59,61.50'}
G[131656]={'942:51.02,70.18'}
G[131684]={'895:55.49,35.93'}
G[131687]={'862:77.66,11.08'}
G[131718]={'862:66.67,32.21'}
G[131727]={'981:63.13,35.89'}
G[131750]={'943:61.59,25.38'}
G[131763]={'862:41.35,71.45'}
G[131775]={'895:51.10,35.80'}
G[131777]={'862:41.33,71.42'}
G[131793]={'942:68.88,65.16'}
G[131814]={'862:38.86,73.23'}
G[131872]={'863:28.76,72.63'}
G[131878]={'862:40.91,76.53'}
G[131879]={'896:26.91,65.81'}
G[131963]={'81:69.41,17.65'}
G[131978]={'863:67.48,42.04'}
G[131988]={'863:67.19,40.86'}
G[131993]={'863:66.89,41.95'}
G[132005]={'1044:51.10,47.10'}
G[132007]={'942:71.53,54.20'}
G[132017]={'Near942'}
G[132040]={'81:66.84,56.46'}
G[132041]={'862:49.68,37.94'}
G[132045]={'81:66.18,55.69'}
G[132088]={'895:38.44,20.71'}
G[132118]={'942:51.59,65.97'}
G[132147]={'81:65.88,54.79'}
G[132179]={'895:64.70,58.53 896:89.17,48.28'}
G[132188]={'862:39.30,73.02'}
G[132192]={'81:69.44,19.25'}
G[132193]={'896:31.78,29.57'}
G[132211]={'895:90.38,77.57'}
G[132226]={'942:48.18,65.33'}
G[132254]={'85:49.79,75.35'}
G[132255]={'84:38.97,62.83'}
G[132267]={'862:51.61,50.57'}
G[132280]={'895:80.82,82.81'}
G[132292]={'942:74.13,72.74'}
G[132297]={'942:51.57,65.91'}
G[132317]={'896:35.82,30.05'}
G[132318]={'896:35.53,32.75'}
G[132332]={'862:57.95,62.46'}
G[132333]={'863:44.96,68.58'}
G[132349]={'943:42.59,40.55'}
G[132374]={'896:34.60,30.73'}
G[132409]={'862:62.09,17.18'}
G[132412]={'862:64.14,19.39'}
G[132446]={'1032:44.36,54.28'}
G[132606]={'81:69.42,19.00'}
G[132617]={'862:51.60,50.57'}
G[132624]={'863:42.28,72.80'}
G[132637]={'862:76.50,15.98'}
G[132647]={'942:71.04,69.25'}
G[132701]={'863:35.89,31.29'}
G[132720]={'895:80.63,42.09'}
G[132832]={'71:52.08,30.14'}
G[132966]={'896:26.99,71.38'}
G[132988]={'863:44.96,68.38'}
G[132994]={'896:24.22,15.09'}
G[133035]={'895:81.10,42.48'}
G[133050]={'862:57.79,44.30'}
G[133098]={'896:20.64,57.46'}
G[133101]={'896:21.17,55.07'}
G[133105]={'896:20.60,57.55'}
G[133122]={'863:49.26,51.01'}
G[133125]={'863:44.19,62.84'}
G[133126]={'896:20.63,57.50'}
G[133197]={'84:52.03,13.76'}
G[133204]={'942:71.00,69.24'}
G[133214]={'895:66.24,24.30'}
G[133234]={'864:58.09,42.74'}
G[133252]={'896:20.61,57.49'}
G[133302]={'1165:42.51,17.91 862:55.49,35.06'}
G[133324]={'1165:43.68,7.33 862:55.87,31.54'}
G[133327]={'895:79.85,47.24'}
G[133338]={'863:48.29,53.54'}
G[133356]={'895:61.02,17.25 942:50.78,97.92'}
G[133362]={'84:53.06,15.28'}
G[133373]={'863:45.37,51.89'}
G[133374]={'943:58.53,25.92'}
G[133392]={''}
G[133407]={'85:39.36,79.53 1:42.15,6.92'}
G[133417]={'862:73.66,60.98'}
G[133471]={'863:45.46,58.62'}
G[133475]={'863:44.44,54.06'}
G[133476]={'863:49.42,57.15'}
G[133480]={'863:50.62,58.48'}
G[133490]={'862:66.22,16.60'}
G[133501]={'896:19.08,58.67'}
G[133527]={'863:28.16,33.84'}
G[133539]={'863:77.57,45.18'}
G[133550]={'895:75.69,50.63'}
G[133551]={'895:78.15,55.93'}
G[133552]={'895:78.12,56.00'}
G[133565]={'864:53.97,87.90'}
G[133576]={'942:26.00,55.23'}
G[133577]={'942:25.90,55.17'}
G[133578]={'942:25.84,55.24'}
G[133621]={'895:75.56,59.36'}
G[133640]={'942:78.85,54.54'}
G[133653]={'862:50.68,29.61'}
G[133693]={'62:43.59,89.26'}
G[133812]={'863:38.76,71.45'}
G[133832]={'862:80.27,36.09'}
G[133833]={'864:40.43,55.35'}
G[133839]={'896:27.06,25.23'}
G[133843]={'864:41.09,24.20'}
G[133859]={'864:42.09,72.06'}
G[133865]={'862:46.00,59.96'}
G[133896]={'864:41.46,61.43'}
G[133904]={'864:42.70,62.99'}
G[133929]={'864:47.20,60.15'}
G[133953]={'942:44.73,64.61'}
G[133959]={'943:60.62,28.11'}
G[133962]={'863:38.82,55.31'}
G[133988]={'896:28.87,26.84'}
G[134002]={'863:55.35,57.55'}
G[134009]={'896:29.29,29.80'}
G[134023]={'896:27.19,29.65'}
G[134028]={'942:72.80,72.24'}
G[134048]={'862:61.92,46.20'}
G[134057]={'863:31.20,78.30'}
G[134068]={'864:66.80,24.58'}
G[134080]={'896:24.98,53.73'}
G[134098]={'864:62.01,22.30'}
G[134106]={'895:68.29,19.92'}
G[134119]={'863:39.55,27.95'}
G[134128]={'864:61.96,22.19'}
G[134133]={'864:58.55,11.81'}
G[134134]={'864:58.48,11.71'}
G[134139]={''}
G[134148]={'864:47.34,72.75'}
G[134156]={'862:63.87,31.21'}
G[134162]={'864:47.05,75.65'}
G[134164]={'864:47.41,72.64'}
G[134166]={'895:75.84,49.14'}
G[134169]={'864:47.33,72.75'}
G[134209]={'943:43.74,46.28'}
G[134213]={'896:31.99,19.72'}
G[134296]={'863:68.28,20.01'}
G[134298]={'863:54.10,80.99'}
G[134301]={'Near896'}
G[134310]={'896:34.89,20.01'}
G[134325]={'895:72.95,17.56'}
G[134345]={'862:71.51,30.31'}
G[134346]={'1165:56.10,91.67 862:60.00,59.60'}
G[134447]={'Near942'}
G[134451]={'863:62.14,41.02'}
G[134509]={'895:66.69,50.03'}
G[134533]={'864:47.04,75.73'}
G[134550]={'864:56.66,10.38'}
G[134554]={'90:57.98,92.13'}
G[134571]={'864:46.97,25.17'}
G[134573]={'63:38.90,55.31'}
G[134574]={'10:50.87,45.91'}
G[134578]={'63:35.86,50.43'}
G[134611]={'864:32.64,48.40'}
G[134613]={'864:26.86,52.81'}
G[134619]={'862:70.82,39.89'}
G[134623]={'942:66.31,47.09'}
G[134628]={'895:75.53,59.29'}
G[134637]={'862:63.22,14.02 863:58.77,83.92 864:92.93,82.56'}
G[134638]={'864:30.17,52.57'}
G[134639]={'942:66.17,47.45'}
G[134641]={'942:66.02,47.12'}
G[134643]={'864:29.70,46.38'}
G[134702]={'942:44.46,55.52'}
G[134706]={'896:18.48,61.06 895:10.00,68.43'}
G[134710]={'942:44.43,55.62'}
G[134711]={'85:48.38,71.23 1:45.11,4.19'}
G[134717]={'862:49.09,29.21'}
G[134720]={'942:42.98,56.60'}
G[134738]={'862:42.13,36.19'}
G[134743]={'864:54.78,87.09'}
G[134752]={'942:44.75,64.51'}
G[134754]={'896:22.97,49.48'}
G[134759]={'863:24.37,45.72'}
G[134761]={'863:49.55,34.15'}
G[134776]={'895:67.40,24.14'}
G[134782]={'862:60.70,66.16'}
G[134803]={'864:45.51,63.53'}
G[134812]={'863:41.91,36.59'}
G[134816]={'863:37.94,41.25'}
G[134844]={'942:38.87,66.66'}
G[134845]={'1161:61.89,42.75 895:72.32,30.12'}
G[134855]={'943:58.47,21.75'}
G[134869]={'863:37.15,74.64'}
G[134882]={'Near942'}
G[134884]={'942:41.32,73.97'}
G[134897]={'942:67.78,40.07'}
G[134937]={'942:43.42,54.83'}
G[134953]={'896:23.29,12.60'}
G[134983]={'942:66.53,43.65'}
G[135003]={'63:37.82,56.25'}
G[135012]={'864:55.24,48.40'}
G[135021]={'896:37.27,50.33'}
G[135032]={'863:46.77,48.15'}
G[135033]={'942:42.55,54.36'}
G[135054]={'863:49.24,47.26'}
G[135066]={'864:53.56,91.70'}
G[135067]={'942:42.67,54.31'}
G[135072]={'863:61.89,41.48'}
G[135085]={'896:39.69,57.97'}
G[135090]={'864:46.17,33.31'}
G[135099]={'864:55.43,35.02'}
G[135110]={'864:47.16,39.06'}
G[135111]={'864:51.96,28.72'}
G[135133]={'864:27.07,52.63'}
G[135154]={'864:47.05,75.65'}
G[135172]={'864:47.96,36.40'}
G[135179]={'864:26.22,73.69'}
G[135180]={'864:26.17,73.68'}
G[135200]={'896:23.30,17.42'}
G[135205]={'85:54.49,78.40'}
G[135256]={'863:60.77,53.22'}
G[135259]={'1161:49.10,75.73 895:69.23,38.10'}
G[135264]={'942:50.54,31.81'}
G[135311]={'864:39.85,75.05'}
G[135325]={'895:69.14,40.16'}
G[135330]={'942:41.12,54.08'}
G[135335]={'Near1161 Near895'}
G[135355]={'864:48.00,36.42'}
G[135367]={'942:44.20,54.09'}
G[135390]={'864:51.98,27.67'}
G[135395]={'863:59.82,70.18'}
G[135400]={'864:29.53,59.36'}
G[135415]={'942:59.89,39.10'}
G[135441]={'862:57.99,57.40 1165:50.05,85.06'}
G[135443]={'63:12.12,33.70'}
G[135446]={'1161:68.97,24.72 895:74.03,25.76'}
G[135447]={'862:58.06,62.65'}
G[135459]={'863:39.09,79.43'}
G[135501]={'62:44.58,86.49'}
G[135506]={'942:61.65,38.03'}
G[135511]={'942:60.67,39.19'}
G[135517]={'942:60.90,41.38'}
G[135534]={'942:63.16,43.15'}
G[135565]={'863:38.13,57.69'}
G[135576]={'862:54.40,86.99'}
G[135607]={'62:41.24,68.20'}
G[135612]={'1161:69.28,27.01 895:74.11,26.31'}
G[135614]={'1161:70.72,27.09 895:74.46,26.33'}
G[135618]={'1161:69.73,27.80 895:74.22,26.50'}
G[135620]={'862:77.50,55.22'}
G[135625]={'864:43.05,68.20'}
G[135673]={'896:34.61,39.80'}
G[135681]={'1161:67.95,26.71 895:73.79,26.24'}
G[135682]={'942:57.85,55.32'}
G[135691]={'862:58.44,62.67'}
G[135708]={'862:57.99,17.86'}
G[135740]={'863:39.13,79.86'}
G[135775]={'862:57.80,44.36'}
G[135777]={'896:28.61,13.20'}
G[135784]={'863:29.27,52.05'}
G[135793]={'942:40.54,36.41'}
G[135794]={'942:40.68,45.61'}
G[135795]={'942:40.59,45.46'}
G[135796]={'896:28.20,13.92 895:17.53,31.94'}
G[135800]={'942:59.28,69.33'}
G[135803]={'862:76.38,48.75'}
G[135804]={'864:56.69,49.75'}
G[135808]={'1161:67.51,21.55 895:73.68,24.99'}
G[135815]={'896:37.89,49.00'}
G[135855]={'862:76.43,48.76'}
G[135858]={'862:76.77,53.43'}
G[135861]={'896:33.43,65.10'}
G[135865]={'862:46.84,70.74'}
G[135874]={'942:57.95,55.57'}
G[135887]={'1165:49.92,46.54 862:57.95,44.58'}
G[135890]={'862:60.06,22.19'}
G[135901]={'896:25.71,41.97'}
G[135902]={'896:25.72,41.96'}
G[135903]={''}
G[135905]={'896:28.51,43.17'}
G[135946]={'942:41.17,54.16'}
G[135961]={'1034:59.86,22.30'}
G[135962]={'1032:42.17,54.77'}
G[135976]={'896:29.92,40.43'}
G[135977]={'896:35.01,68.81'}
G[136030]={'1165:43.80,7.56 862:55.91,31.62'}
G[136034]={'1165:43.79,7.35 862:55.91,31.54'}
G[136041]={'1161:74.03,11.55 895:75.26,22.57'}
G[136053]={'942:63.11,43.17'}
G[136109]={'864:27.08,62.89'}
G[136140]={'896:20.91,43.65'}
G[136160]={''}
G[136182]={'863:54.07,70.73'}
G[136184]={'896:20.83,46.02'}
G[136192]={'862:77.13,55.59'}
G[136195]={'862:77.12,55.54'}
G[136197]={'862:77.54,54.58'}
G[136204]={'942:52.80,51.56'}
G[136227]={'896:20.84,46.19'}
G[136233]={'896:19.89,44.25'}
G[136234]={'896:20.62,46.19'}
G[136282]={'896:19.64,44.69'}
G[136284]={'1161:64.07,62.28 895:72.85,34.84'}
G[136287]={'864:35.46,83.45'}
G[136293]={'863:23.67,63.91'}
G[136305]={'863:21.72,64.28'}
G[136309]={'864:35.33,83.20'}
G[136310]={'864:33.26,81.78'}
G[136317]={'864:29.55,88.45'}
G[136318]={'942:61.60,57.13'}
G[136323]={'864:53.64,34.86'}
G[136336]={'864:32.70,64.90'}
G[136339]={'942:61.76,36.26'}
G[136341]={'864:60.66,17.57'}
G[136385]={'895:62.19,24.46'}
G[136393]={'864:55.76,53.31'}
G[136414]={'942:31.86,69.52'}
G[136419]={'942:32.34,75.96'}
G[136428]={'862:44.00,76.36'}
G[136432]={'863:62.03,41.59'}
G[136458]={'896:22.88,46.24'}
G[136466]={'864:29.40,87.73'}
G[136481]={'942:60.19,54.62'}
G[136486]={'896:37.44,52.08'}
G[136490]={'896:44.49,28.31'}
G[136497]={'942:61.80,36.29'}
G[136498]={'942:60.03,37.89'}
G[136537]={'Z1034'}
G[136545]={'864:58.65,61.35'}
G[136546]={'864:59.57,61.43'}
G[136547]={'864:33.90,63.89'}
G[136550]={'862:55.86,23.84'}
G[136551]={'862:55.50,21.04'}
G[136552]={'862:57.13,22.71'}
G[136559]={'864:36.22,36.85'}
G[136562]={'864:36.58,32.31'}
G[136568]={'863:45.00,57.15'}
G[136574]={'942:30.42,66.92'}
G[136576]={'895:75.06,49.71'}
G[136579]={'896:19.19,43.51'}
G[136613]={'896:40.81,36.92'}
G[136614]={'896:40.73,37.55'}
G[136615]={'896:40.23,43.92'}
G[136616]={'863:24.77,62.78'}
G[136641]={'863:31.15,46.71'}
G[136645]={'Near863'}
G[136658]={'942:30.34,66.81'}
G[136664]={'864:59.13,40.36'}
G[136675]={'863:49.97,50.90'}
G[136683]={'862:58.45,62.63'}
G[136686]={'942:28.47,67.96'}
G[136699]={'862:65.54,30.33'}
G[136702]={'862:56.87,23.01 863:48.53,98.40 864:85.03,93.72'}
G[136710]={'942:40.72,45.69'}
G[136725]={'896:20.73,43.88'}
G[136732]={'864:60.65,62.43'}
G[136733]={'862:65.42,29.44'}
G[136779]={'864:30.27,86.49'}
G[136902]={'1032:44.73,54.68'}
G[136907]={'1021:50.17,53.60'}
G[136926]={'864:30.06,46.02'}
G[136933]={'942:69.90,36.11'}
G[136939]={'942:25.10,74.57'}
G[136985]={'864:28.04,50.53'}
G[136993]={'864:43.87,24.41'}
G[136997]={'864:46.09,53.14'}
G[137008]={'864:39.64,35.69'}
G[137075]={'862:76.63,48.59'}
G[137094]={'942:54.97,67.97'}
G[137112]={'863:51.77,65.71'}
G[137113]={'863:51.89,65.54'}
G[137126]={'942:27.46,66.28'}
G[137131]={'896:58.76,53.18'}
G[137132]={'896:40.75,38.05'}
G[137134]={'896:58.83,53.54'}
G[137144]={'895:61.15,47.68'}
G[137147]={'1184:43.96,37.76 895:79.74,53.27'}
G[137153]={'942:38.00,70.88'}
G[137155]={'942:37.24,70.19'}
G[137156]={'942:69.95,84.46'}
G[137157]={'895:62.07,44.63'}
G[137162]={'942:70.81,86.27'}
G[137167]={'864:60.47,17.70'}
G[137208]={'864:54.58,60.44'}
G[137209]={'864:39.68,69.68'}
G[137211]={'864:41.17,69.34'}
G[137213]={'864:37.71,35.83'}
G[137220]={'Near942'}
G[137323]={'862:57.56,43.87'}
G[137337]={'864:38.96,42.92'}
G[137368]={'896:31.49,30.07'}
G[137374]={'14:37.50,41.39'}
G[137400]={'862:40.74,70.82'}
G[137401]={'862:40.74,70.85'}
G[137434]={'864:38.96,42.98'}
G[137453]={'942:35.68,31.24'}
G[137458]={''}
G[137468]={'896:25.76,19.94'}
G[137506]={'942:75.61,27.06'}
G[137537]={'864:27.22,53.94'}
G[137543]={'864:27.19,53.93'}
G[137554]={'942:34.37,26.32'}
G[137559]={'864:27.56,52.61'}
G[137568]={'896:31.20,18.87'}
G[137585]={'942:48.35,64.36'}
G[137586]={'895:73.76,25.12'}
G[137613]={'896:36.95,27.11'}
G[137629]={'864:54.71,42.46'}
G[137631]={'864:54.65,42.49'}
G[137653]={'863:22.50,64.79'}
G[137654]={'863:26.40,79.27'}
G[137663]={'863:23.52,62.81'}
G[137665]={'896:27.51,54.81'}
G[137671]={'896:27.16,54.83'}
G[137675]={'895:89.35,53.44'}
G[137677]={'942:35.75,31.29'}
G[137681]={'864:38.18,41.17'}
G[137691]={'942:78.33,28.78'}
G[137692]={'942:78.32,28.85'}
G[137694]={'895:64.99,60.61'}
G[137698]={'1044:48.03,80.01'}
G[137700]={'1044:47.46,75.37'}
G[137704]={'896:34.70,19.75 895:22.56,36.45'}
G[137708]={'896:50.11,43.24'}
G[137715]={'896:50.18,43.29'}
G[137727]={'895:87.28,49.97'}
G[137732]={'896:33.52,65.12'}
G[137742]={'895:87.28,49.97'}
G[137763]={'895:60.77,47.06'}
G[137773]={'862:40.33,67.49'}
G[137781]={'1161:37.62,39.57 895:66.45,29.35'}
G[137818]={'1165:45.04,39.60 862:56.32,42.27'}
G[137821]={'1161:32.12,67.22 895:65.12,36.04'}
G[137822]={'1161:24.96,70.26 895:63.39,36.78'}
G[137824]={'896:29.09,68.85'}
G[137829]={'862:51.95,45.57'}
G[137837]={'1170:36.32,69.44'}
G[137866]={'895:73.16,36.46'}
G[137867]={'864:32.91,34.86'}
G[137871]={'Near895'}
G[137909]={'896:23.88,14.38'}
G[137970]={'864:42.94,35.72'}
G[137981]={'864:46.16,33.23'}
G[137982]={'864:47.98,36.41'}
G[138022]={'896:37.48,25.50'}
G[138031]={'942:65.01,47.83'}
G[138055]={'942:56.10,58.22'}
G[138131]={'942:50.41,26.18'}
G[138148]={''}
G[138171]={'895:59.05,49.14'}
G[138189]={'895:61.12,47.08'}
G[138212]={'942:37.03,52.93'}
G[138226]={'895:60.52,47.20 896:83.77,33.64'}
G[138243]={'896:39.73,37.45'}
G[138245]={'896:40.88,38.68'}
G[138253]={'864:46.47,80.66'}
G[138256]={'864:53.60,37.68'}
G[138258]={'864:59.14,55.65'}
G[138267]={'896:54.79,44.53'}
G[138279]={'895:85.50,43.19'}
G[138285]={'895:87.38,50.53'}
G[138287]={'895:72.01,51.75'}
G[138288]={'895:69.50,46.83 896:95.38,33.17'}
G[138295]={'896:39.86,37.74'}
G[138299]={'895:58.74,33.40'}
G[138332]={'942:70.61,85.94 895:76.21,8.08'}
G[138352]={'862:58.44,62.47'}
G[138356]={'896:65.95,42.06'}
G[138365]={'942:51.11,21.16'}
G[138382]={'864:52.26,79.91'}
G[138395]={'864:43.19,77.06'}
G[138411]={'864:51.96,28.73'}
G[138476]={'896:21.79,22.45 895:12.56,38.54'}
G[138478]={'896:21.62,26.58 895:12.43,41.74'}
G[138480]={'864:63.27,23.37 863:20.31,7.17'}
G[138519]={'864:52.00,27.74'}
G[138520]={'862:79.33,16.76'}
G[138525]={'896:70.67,57.78'}
G[138594]={'864:45.54,63.48'}
G[138618]={'896:23.46,30.17'}
G[138659]={'1032:62.01,54.44'}
G[138667]={'896:36.02,11.23'}
G[138669]={'862:63.48,16.16'}
G[138675]={'896:28.03,26.00 895:17.39,41.29'}
G[138677]={'942:51.68,29.88'}
G[138688]={'942:51.66,29.83'}
G[138708]={'862:58.47,63.06'}
G[138732]={'896:50.84,36.98'}
G[138735]={'942:46.88,47.69'}
G[138749]={'864:37.43,51.13'}
G[138752]={'896:50.88,36.88'}
G[138777]={'942:51.24,36.73'}
G[138791]={'896:19.31,8.32'}
G[138794]={'864:43.98,56.97'}
G[138867]={'942:49.25,34.26'}
G[138869]={'942:49.19,34.21'}
G[138871]={'896:24.34,21.95'}
G[138876]={'942:52.13,33.66'}
G[138886]={'942:52.12,33.73'}
G[138924]={'1182:66.44,38.33 942:45.74,35.75'}
G[138949]={'1165:53.03,94.53 862:58.98,60.55'}
G[139069]={'864:44.69,86.91'}
G[139070]={'864:43.20,90.90'}
G[139071]={'864:26.85,66.35'}
G[139079]={'896:23.33,56.50'}
G[139084]={'942:50.90,26.64'}
G[139085]={'942:51.48,25.98'}
G[139086]={'942:32.33,28.54'}
G[139089]={'895:66.32,24.80'}
G[139093]={'85:47.85,71.75 1:44.94,4.36'}
G[139103]={'1044:49.60,76.61'}
G[139106]={'1044:50.73,72.18'}
G[139135]={'895:48.94,37.04'}
G[139141]={'942:50.33,25.81'}
G[139145]={'895:85.24,73.48'}
G[139152]={'895:72.47,81.01 896:99.21,77.32'}
G[139164]={'864:43.23,90.61'}
G[139186]={'942:56.10,58.28'}
G[139205]={'895:65.53,65.04'}
G[139233]={'895:57.82,55.88 896:80.28,44.85'}
G[139278]={'895:68.32,63.61'}
G[139280]={'895:66.90,13.34 942:58.46,92.81'}
G[139285]={'895:55.03,32.85'}
G[139287]={'895:76.52,31.44'}
G[139289]={'895:55.25,51.41 896:76.95,39.07'}
G[139290]={'895:58.36,50.40 896:80.98,37.77'}
G[139311]={'862:65.56,41.22'}
G[139316]={'863:71.76,15.22'}
G[139317]={'863:70.56,16.09'}
G[139319]={'942:41.64,28.43'}
G[139322]={'896:29.34,63.86 895:18.40,70.59'}
G[139380]={'896:64.85,83.36'}
G[139385]={'942:53.35,50.81'}
G[139446]={'1044:36.42,59.53'}
G[139453]={'864:51.77,35.46'}
G[139478]={'1044:42.61,41.58'}
G[139495]={'863:70.03,13.58'}
G[139510]={'863:70.53,15.55'}
G[139515]={'942:72.32,49.51'}
G[139522]={'1161:68.38,22.09 895:73.89,25.12'}
G[139568]={'864:37.47,35.84'}
G[139609]={'863:61.79,41.32'}
G[139631]={'863:24.41,45.75'}
G[139635]={'942:46.68,47.97'}
G[139705]={'864:37.70,35.95'}
G[139714]={'896:37.13,49.38'}
G[139719]={'864:40.74,47.83'}
G[139722]={'864:41.14,72.41'}
G[139727]={'1044:46.04,73.34'}
G[139792]={'864:27.70,69.96'}
G[139793]={'942:37.31,66.03'}
G[139798]={'84:85.13,32.35'}
G[139801]={'942:41.47,65.43'}
G[139912]={'896:61.91,59.29'}
G[139926]={'896:61.88,59.31'}
G[139958]={'1044:43.72,34.23'}
G[139970]={''}
G[139988]={'942:73.24,60.57'}
G[140038]={''}
G[140046]={'864:28.42,68.58'}
G[140048]={'896:58.44,63.17'}
G[140085]={'1035:54.69,58.40'}
G[140140]={'862:76.70,16.22'}
G[140163]={'942:82.93,48.81'}
G[140176]={'85:142560.00,-435689.99'}
G[140257]={'862:40.77,70.86'}
G[140258]={'863:61.97,41.25'}
G[140309]={'1159:57.04,30.36'}
G[140315]={'942:36.53,33.65'}
G[140348]={'1161:69.36,26.58 895:74.13,26.20'}
G[140398]={'942:31.61,55.28'}
G[140404]={'895:43.44,12.90'}
G[140444]={'1034:63.82,57.47'}
G[140447]={'876:58.60,61.10 947:73.03,50.57'}
G[140477]={'862:40.59,70.68'}
G[140495]={'895:66.96,36.22'}
G[140519]={'863:42.13,39.74'}
G[140530]={'864:29.34,76.07'}
G[140588]={'62:40.94,59.87'}
G[140590]={'1165:46.04,94.61 862:56.66,60.58'}
G[140608]={'62:43.89,75.41'}
G[140649]={'895:66.96,36.19'}
G[140656]={'863:50.57,58.35'}
G[140686]={'62:41.71,79.31'}
G[140701]={'62:44.00,75.40'}
G[140712]={'862:40.33,39.71'}
G[140715]={'62:44.31,57.10'}
G[140724]={'862:57.62,62.54'}
G[140725]={'862:57.59,62.97'}
G[140728]={'62:43.35,80.48'}
G[140732]={'1161:67.59,22.14 895:73.70,25.13'}
G[140735]={'62:39.14,53.15'}
G[140738]={'62:40.29,49.18'}
G[140740]={'Near76'}
G[140741]={'62:41.13,68.63'}
G[140752]={'895:60.98,30.87'}
G[140877]={'57:58.47,89.50'}
G[140904]={'1161:60.73,16.03'}
G[140907]={'1165:45.18,20.09 862:56.37,35.78'}
G[140947]={'896:62.41,17.00'}
G[140977]={'1036:65.21,33.52'}
G[140997]={'942:22.54,73.02'}
G[141032]={'Near895'}
G[141059]={'942:63.14,74.74'}
G[141078]={'895:60.92,59.17'}
G[141087]={'942:60.21,25.05'}
G[141143]={'942:61.56,56.81'}
G[141145]={'1044:47.13,74.21'}
G[141159]={'896:45.21,45.84'}
G[141175]={'942:70.98,32.15'}
G[141223]={'942:70.37,36.38'}
G[141226]={'942:34.91,78.07 895:48.87,2.05'}	-- quest had A:-1440895,-810942 but I converted
G[141274]={'1161:77.17,16.48 895:76.02,23.76'}
G[141286]={'942:34.70,67.86'}
G[141287]={'862:40.80,70.90'}
G[141288]={'862:48.90,68.58'}
G[141289]={'862:57.64,87.55'}
G[141290]={'862:57.64,87.59'}
G[141291]={'862:48.88,68.56'}
G[141352]={'62:38.59,42.15'}
G[141353]={'942:59.88,70.11'}
G[141356]={'1161:69.29,27.15 895:74.11,26.34'}
G[141359]={'62:43.02,78.90'}
G[141365]={'62:44.40,75.06'}
G[141539]={'863:39.17,78.94'}
G[141541]={'Near1156'}
G[141549]={'1164:29.09,50.09 1165:48.68,44.62 862:57.54,43.95'}
G[141555]={'862:57.80,44.41'}
G[141567]={'Near1156'}
G[141584]={'1165:53.93,88.56 862:59.28,58.56'}
G[141598]={'942:39.40,68.57'}
G[141603]={'942:64.88,76.77'}
G[141668]={'14:56.91,34.65'}
G[141698]={'1161:57.81,22.84'}
G[141719]={'862:35.14,77.31'}
G[141725]={'14:30.58,43.48'}
G[141748]={'895:58.72,41.68'}
G[141769]={'942:60.18,70.49'}
G[141785]={'896:27.51,58.93'}
G[141806]={''}
G[141828]={'62:40.56,68.46'}
G[141884]={'862:44.25,36.49'}
G[141894]={'896:45.22,45.84'}
G[141905]={'863:67.68,21.22'}
G[141931]={'864:47.67,20.20 863:0.07,3.06'}
G[141936]={'1165:44.21,32.32 862:56.05,39.85'}
G[141942]={'14:47.62,77.99'}
G[141946]={'14:48.20,78.13'}
G[141948]={'862:68.01,18.06'}
G[141949]={'862:44.87,27.39'}
G[141952]={'862:68.16,41.71'}
G[141959]={'862:75.29,42.18'}
G[141970]={'896:22.16,30.26 895:12.85,44.59'}
G[141980]={'895:52.65,21.03'}
G[141985]={'942:72.18,52.11'}
G[142054]={'864:45.09,46.18'}
G[142063]={'1161:71.59,13.67 895:74.67,23.08'}
G[142095]={'1161:73.23,11.33 895:75.06,22.51'}
G[142101]={'862:54.87,25.56'}
G[142109]={'1170:45.12,52.14'}
G[142112]={'14:49.06,82.65'}
G[142157]={'1165:51.69,95.32 862:58.53,60.81'}
G[142158]={'1165:51.75,95.30 862:58.56,60.81'}
G[142159]={'1165:51.64,99.73 862:58.52,62.28'}
G[142228]={'1156:41.75,57.01'}
G[142232]={'1156:41.65,55.43'}
G[142275]={'1170:45.21,52.09'}
G[142287]={'896:27.50,59.39'}
G[142288]={'862:64.46,47.30'}
G[142310]={'62:52.14,22.41'}
G[142360]={'863:33.88,63.22'}
G[142393]={'895:56.47,61.73'}
G[142422]={'1170:44.93,53.07'}
G[142437]={'14:57.25,43.31'}
G[142478]={'863:34.31,63.21'}
G[142555]={'864:53.71,37.72'}
G[142609]={'942:64.99,48.09'}
G[142651]={'896:36.05,51.18'}
G[142661]={'942:22.49,73.14'}
G[142662]={'14:79.48,29.32'}
G[142675]={'14:61.46,64.98'}
G[142685]={'1161:66.26,27.63 895:73.38,26.46'}
G[142688]={'14:50.67,61.15'}
G[142690]={'14:51.16,40.08'}
G[142692]={'14:67.54,60.72'}
G[142694]={'14:24.52,48.24'}
G[142700]={'1161:66.06,27.20 895:73.33,26.35'}
G[142713]={'62:40.27,54.33'}
G[142716]={'14:52.02,76.65'}
G[142721]={'1161:65.87,26.05 895:73.28,26.08'}
G[142723]={'14:22.29,60.41'}
G[142729]={'14:50.24,59.56'}
G[142854]={'864:36.21,78.42'}
G[142930]={'84:27.64,21.27'}
G[142969]={'1165:52.58,94.69 862:58.83,60.60'}
G[142970]={'1165:53.44,92.81 862:59.12,59.98'}
G[142973]={'1165:53.80,94.32 862:59.24,60.48'}
G[142975]={'1165:52.60,93.36 862:58.84,60.16'}
G[142977]={'1165:51.77,93.25 862:58.56,60.13'}
G[142978]={'89:43.09,78.63'}
G[142984]={'942:47.04,47.55'}
G[142993]={'1161:66.67,23.48 895:73.48,25.45'}
G[142994]={'1161:66.05,28.50 895:73.33,26.67'}
G[142995]={'1161:67.23,29.16 895:73.61,26.83'}
G[142997]={'1161:66.97,27.23 895:73.55,26.36'}
G[143004]={'1161:67.57,24.08 895:73.69,25.60'}
G[143005]={'1161:67.48,23.77 895:73.67,25.52'}
G[143007]={'1161:66.35,25.10 895:73.40,25.85'}
G[143008]={'1161:66.31,25.45 895:73.39,25.93'}
G[143018]={'14:19.31,56.78'}
G[143019]={'14:26.03,35.45'}
G[143172]={'14:21.70,64.89'}
G[143208]={'84:85.94,23.93'}
G[143380]={'1161:66.25,24.78 895:73.38,25.77'}
G[143381]={'14:27.27,29.89'}
G[143388]={'1165:51.78,94.39 862:58.57,60.50'}
G[143430]={'862:44.94,27.25'}
G[143446]={'62:61.77,14.31'}
G[143455]={'62:62.36,9.26'}
G[143456]={'62:58.53,21.30'}
G[143457]={'62:62.70,9.69'}
G[143458]={'62:61.71,20.66'}
G[143459]={'62:61.69,10.94'}
G[143512]={'62:62.27,10.01'}
G[143536]={'862:51.56,58.22'}
G[143551]={'862:51.54,58.02'}
G[143565]={'942:78.91,54.76'}
G[143642]={'62:49.50,21.36'}
G[143692]={'17:54.38,50.13'}
G[143777]={'895:85.31,80.53'}
G[143785]={'895:39.03,16.40'}
G[143787]={'862:51.53,52.97'}
G[143792]={'862:50.19,54.59'}
G[143800]={'896:37.65,25.93'}
G[143845]={'1:41.23,16.78'}
G[143846]={'1161:70.67,27.39 895:74.44,26.40'}
G[143851]={'1161:67.94,26.27 895:73.78,26.13'}
G[143871]={'896:34.57,30.72'}
G[143878]={'896:36.43,25.84'}
G[143885]={'862:47.42,52.42'}
G[143909]={'62:38.81,43.08'}
G[143913]={'862:58.54,62.72'}
G[143930]={'62:44.34,61.16'}
G[143938]={'62:42.00,79.11'}
G[143945]={'62:44.79,57.14'}
G[143976]={'62:49.96,18.14'}
G[143978]={'84:62.49,29.75'}
G[143979]={'85:49.82,76.38 1:45.59,5.88'}
G[144023]={'62:38.74,25.70'}
G[144024]={'Near862'}
G[144095]={'84:22.36,32.43'}
G[144152]={'1186:56.41,31.87'}
G[144215]={'896:65.35,50.30'}
G[144346]={'62:35.81,84.80'}
G[144350]={'895:63.60,57.22 896:87.74,46.58'}
G[144351]={'942:40.33,34.35'}
G[144352]={'863:72.14,40.64'}
G[144353]={'864:27.41,50.28'}
G[144354]={'862:37.79,78.90'}
G[144355]={'942:30.34,56.81'}
G[144356]={'895:58.03,76.14 896:80.54,71.02'}
G[144357]={'863:73.95,10.71'}
G[144358]={'864:66.62,21.54 863:24.65,4.80'}
G[144359]={'862:63.60,68.68'}
G[144360]={'942:22.64,70.95'}
G[144361]={'895:61.84,31.29 896:85.48,13.09'}
G[144362]={'862:81.80,37.65'}
G[144383]={'1161:74.11,14.19 895:75.28,23.21'}
G[144384]={'1165:56.62,88.60 862:60.18,58.58'}
G[144416]={'62:42.80,67.76'}
G[144466]={'62:45.52,18.19'}
G[144612]={'943:69.65,47.73'}
G[144635]={'1161:69.39,26.95 895:74.13,26.29'}
G[144720]={'895:79.42,38.24'}
G[144759]={'1203:55.94,44.48'}
G[144763]={'1203:56.45,65.39'}
G[144786]={'1203:49.41,34.55'}
G[144855]={'896:35.33,41.66 895:23.04,53.41'}
G[144859]={'1203:51.15,56.61'}
G[144861]={'896:39.65,42.39'}
G[145008]={'942:40.51,62.42'}
G[145163]={'942:46.08,56.02'}
G[145278]={'942:34.63,58.00'}
G[145337]={'1355:43.25,41.03'}
G[145357]={'Near'}
G[145415]={'942:37.67,47.67'}
G[145422]={'895:47.51,21.77'}
G[145572]={'942:44.41,55.04'}
G[145580]={'895:66.99,36.23'}
G[145593]={'895:41.52,27.03'}
G[145632]={'895:42.17,29.78'}
G[145751]={'862:36.32,72.03'}
G[145770]={'1203:51.01,56.74'}
G[145779]={'1203:52.00,55.50'}
G[145786]={'896:37.16,25.83'}
G[145816]={'896:37.25,25.95'}
G[146010]={'37:30.54,57.66'}
G[146011]={'51:80.81,78.54'}
G[146012]={'49:81.55,52.49'}
G[146013]={'862:58.38,62.67'}
G[146019]={'1182:47.16,15.59 942:44.54,34.34'}
G[146050]={'84:86.64,35.72'}
G[146073]={'895:54.57,64.57'}
G[146373]={'62:30.62,98.16'}
G[146374]={'62:30.67,98.13'}
G[146375]={'62:30.61,98.23'}
G[146462]={'895:52.18,26.68'}
G[146466]={'895:48.94,25.02'}
G[146623]={'895:87.61,53.44'}
G[146716]={'49:28.92,68.13'}
G[146791]={'37:34.67,63.23'}
G[146806]={'49:11.40,66.79'}
G[146931]={'895:82.97,49.58'}
G[146937]={'49:25.96,40.15'}
G[146982]={'862:40.59,70.70'}
G[147088]={'895:82.97,49.53'}
G[147148]={'862:41.10,70.60'}
G[147149]={'862:41.07,70.61'}
G[147151]={'862:41.08,70.65'}
G[147210]={'49:80.65,46.94'}
G[147228]={'862:48.20,55.55'}
G[147276]={'49:81.55,52.49'}
G[147293]={'862:46.90,50.71'}
G[147297]={'51:79.75,74.99'}
G[147311]={'862:41.07,70.61'}
G[147519]={'862:41.15,70.68'}
G[147566]={'942:58.72,69.39'}
G[147747]={'895:86.31,81.28'}
G[147751]={'62:43.71,29.10'}
G[147773]={'896:37.92,49.28'}
G[147798]={'1161:38.97,77.18 895:66.78,38.45'}
G[147819]={'1161:38.98,76.91 895:66.78,38.38'}
G[147842]={'863:31.04,29.49'}
G[147843]={'863:30.96,29.45'}
G[147844]={'863:33.36,45.92'}
G[147885]={'1161:49.33,85.50 895:69.28,40.46'}
G[147936]={'1036:69.15,47.00'}
G[148015]={'895:42.13,29.87'}
G[148031]={'62:40.97,55.96'}
G[148129]={'896:33.11,47.58'}
G[148155]={'896:33.71,37.66 895:21.79,50.32'}
G[148185]={'896:36.07,48.48'}
G[148339]={'862:36.27,72.03'}
G[148798]={'84:52.29,13.42'}
G[148805]={'1203:45.77,47.87'}
G[148870]={'942:50.23,49.86'}
G[149252]={'896:45.41,45.63'}
G[149518]={'84:22.53,18.39'}
G[149612]={'1161:69.53,26.84 895:74.17,26.27'}
G[149623]={'62:46.91,35.52'}
G[149624]={'62:46.41,36.64'}
G[149631]={'62:46.31,35.18'}
G[149803]={'1355:39.47,53.44'}
G[149804]={'1355:39.45,53.53'}
G[149805]={'1355:39.38,53.54'}
G[149816]={'1462:74.12,37.00'}
G[149823]={'1381:47.69,16.26'}
G[149864]={'895:65.59,65.03'}
G[149867]={'863:57.89,50.47'}
G[149877]={'895:65.82,66.36'}
G[150086]={'1462:63.14,39.28'}
G[150087]={'1355:48.33,92.62'}
G[150101]={'1355:48.80,89.32'}
G[150145]={'1161:43.24,31.99 895:67.81,27.51'}
G[150202]={'Near1355'}
G[150208]={'1161:67.22,15.76 895:73.61,23.59'}
G[150282]={'1462:74.00,37.03'}
G[150344]={'1355:58.13,35.23'}
G[150359]={'1462:71.34,32.29'}
G[150515]={'942:59.40,70.28'}
G[150555]={'1462:73.13,33.35'}
G[150573]={'1462:71.50,38.77'}
G[150574]={'1161:69.33,27.15 895:74.12,26.34'}
G[150630]={'1462:70.85,39.14'}
G[150631]={'1462:70.74,38.42'}
G[150633]={'1161:45.21,62.61 895:68.28,34.92'}
G[150637]={'942:48.28,41.45'}
G[150640]={'942:48.83,32.75'}
G[150696]={'1355:56.69,53.35'}
G[150698]={'1462:74.21,58.96'}
G[150759]={'896:21.36,26.44'}
G[150796]={'895:80.11,75.04'}
G[150884]={'896:33.17,30.37'}
G[150885]={'896:36.59,28.84'}
G[150937]={'1462:19.38,80.30'}
G[150941]={'1161:67.74,21.83 895:73.73,25.05'}
G[150947]={'84:62.49,29.75'}
G[150956]={'1462:56.70,60.02'}
G[151000]={'1355:49.00,67.36'}
G[151006]={'1462:69.80,33.10'}
G[151100]={'1161:67.23,15.91 895:73.61,23.62'}
G[151129]={'71:27.13,60.06'}
G[151132]={'71:62.18,45.34'}
G[151301]={'1462:67.31,38.81'}
G[151462]={'1462:37.03,47.14'}
G[151470]={'895:57.71,76.28'}
G[151522]={'895:57.42,61.79'}
G[151523]={'942:34.89,47.97'}
G[151569]={'1462:35.73,43.16'}
G[151626]={'1355:39.40,53.46'}
G[151641]={'650:49.53,68.37'}
G[151695]={'1472:26.76,46.16'}
G[151741]={'1355:43.51,49.79'}
G[151763]={'1355:37.76,55.32'}
G[151772]={'1355:39.92,54.12'}
G[151777]={'1462:63.04,41.20'}
G[151891]={'376:45.11,33.81 N:63054'}
G[151936]={'1462:72.17,37.27'}
G[151947]={'1462:71.29,35.87'}
G[152084]={'1355:48.19,45.35'}
G[152164]={'1355:70.64,29.67'}
G[152194]={'1473:48.26,72.40'}
G[152206]={'1473:50.15,59.24'}
G[152238]={'1499:53.83,20.49 1355:84.55,32.32'}
G[152295]={'1462:71.19,32.33'}
G[152321]={'1462:63.32,42.97'}
G[152385]={'1472:17.08,62.69'}
G[152407]={'1355:31.59,37.55'}
G[152445]={'1355:43.80,54.70'}
G[152484]={'1462:77.58,40.43'}
G[152492]={'1355:80.12,30.76'}
G[152494]={'1355:74.22,24.77'}
G[152501]={'1462:70.46,31.08'}
G[152502]={'1462:70.51,31.04'}
G[152532]={'1355:78.84,42.45'}
G[152633]={'Near1462'}
G[152747]={'1462:69.76,32.35'}
G[152820]={'1462:59.00,54.89'}
G[152851]={'1462:71.10,38.32'}
G[152864]={'895:65.82,66.36'}
G[152883]={'1355:41.00,76.39'}
G[152919]={'1355:78.90,35.32'}
G[152921]={'1355:42.74,41.51'}
G[152942]={'1355:40.03,55.53'}
G[152968]={'1355:68.19,24.94'}
G[153147]={'1355:56.63,29.27'}
G[153193]={'1355:50.00,23.00'}
G[153226]={'1462:25.58,77.73'}
G[153253]={'1355:50.38,24.07'}
G[153300]={'1355:77.47,43.76'}
G[153312]={'1355:41.64,23.68'}
G[153315]={'1355:53.34,24.18'}
G[153327]={'1355:65.38,33.78'}
G[153373]={'1462:70.90,37.67'}
G[153384]={'1355:38.90,30.53'}
G[153385]={'1355:38.86,30.42'}
G[153462]={'1462:40.28,39.31'}
G[153496]={'1355:38.97,30.38'}
G[153499]={'1355:39.00,30.43'}
G[153504]={'1355:33.36,39.96'}
G[153509]={'1355:37.90,55.84'}
G[153510]={'1355:37.85,55.71'}
G[153538]={'1462:75.24,69.84'}
G[153591]={'1355:40.08,55.69'}
G[153617]={'1355:40.29,55.37'}
G[153641]={'1462:73.57,35.65'}
G[153670]={'Near1462'}
G[153750]={'1462:59.07,31.62'}
G[153811]={'1355:37.93,53.19'}
G[153884]={'1355:25.47,26.39'}
G[153893]={'1355:64.85,14.71'}
G[153897]={'1355:39.55,53.90'}
G[153932]={'1161:70.66,27.18 895:74.44,26.35'}
G[153936]={'1355:36.97,27.01'}
G[153944]={'1355:43.55,27.30'}
G[153982]={'1462:72.96,33.88'}
G[153991]={'1462:65.75,32.20'}
G[153993]={'1462:70.21,30.92'}
G[154122]={'1462:63.50,56.94'}
G[154140]={'1355:38.01,55.71'}
G[154143]={'1355:66.47,47.35'}
G[154166]={'1355:40.01,55.13'}
G[154180]={'1355:38.01,59.21'}
G[154214]={'1462:71.84,35.84'}
G[154239]={'1355:45.71,19.69'}
G[154241]={'1355:41.29,58.36'}
G[154243]={'1355:71.61,31.52'}
G[154245]={'1355:45.91,76.54'}
G[154248]={'1355:39.47,53.44'}
G[154297]={'Near1355'}
G[154304]={'Near1355'}
G[154335]={'1462:71.74,38.86'}
G[154436]={'1355:37.90,53.44'}
G[154457]={'Near1462'}
G[154485]={'1462:21.53,81.89'}
G[154511]={'1462:24.20,75.31'}
G[154514]={'1355:80.09,31.44'}
G[154522]={'1355:76.15,45.78'}
G[154534]={'1462:61.24,37.39'}
G[154574]={'1355:74.16,24.92'}
G[154601]={'1355:80.22,31.90'}
G[154640]={'1355:38.07,55.32'}
G[154660]={'1355:73.98,41.75'}
G[154906]={'1462:42.81,29.40'}
G[154967]={'1462:73.49,33.40'}
G[154982]={'1462:72.00,36.58'}
G[155071]={'1355:79.76,44.94'}
G[155139]={'1355:60.65,33.29'}
G[155187]={'1462:72.16,37.16'}
G[155188]={'1462:72.23,37.29'}
G[155237]={'1355:79.77,44.95'}
G[155254]={'1462:72.79,37.98'}
G[155357]={'1462:70.18,30.51'}
G[155450]={'1462:70.25,32.96'}
G[155482]={'Near1355'}
G[155940]={'1355:37.79,55.47'}
G[155941]={'1355:39.61,55.54'}
G[156152]={'1355:38.87,54.95'}
G[156179]={'1355:39.47,53.63'}
G[500001]={'205:39.12,78.71 A:40643 N:40643'}
G[500002]={'205:39.08,78.53 A:40642 N:39887'}
G[500003]={'205:49.22,57.01 A:39881 N:39881'}
G[500004]={'205:39.23,78.63 A:39881 N:39881'}
G[500005]={'205:29.55,78.93 A:39881 N:39881'}
G[500006]={'HC 87:33.29,48.01 A:14305 N:14305','Down stairs underground'}
G[500007]={'HC 52:57.52,52.55 A:14305 N:14305'}
G[500008]={'HC 84:48.99,89.74 A:14305 N:14305'}
G[500009]={'HC 115:71.68,39.58 A:33532 N:33532'}
G[500010]={'HC 116:50.70,44.45 A:33532 N:33532'}
G[500011]={'HC 115:59.80,54.23 A:33532 N:33532'}
G[500012]={'HC 119:27.09,58.75 A:33532 N:33532'}
G[500013]={'HC 100:88.33,50.39 A:22818 N:22818'}
G[500014]={'HC 71:59.79,57.40 A:22818 N:22818'}
G[500015]={'Near198 A:39627 N:39627'}
G[500016]={'338:51.54,85.50 A:52477 N:40278'}
G[500017]={'338:66.03,66.08 A:52478 N:39925'}
G[500018]={'338:66.23,66.10 A:52477 N:40278'}
G[500019]={'338:41.90,61.48 A:52478 N:39925'}
G[500020]={'22:39.82,69.73 A:45165 N:45165'}
G[500021]={'15:15.96,33.40 A:46654 N:46654'}
G[500022]={'HW 241:78.87,77.79 A:1208129'}
G[500023]={'HW 52:52.91,53.74 A:1190047 N:500022'}
G[500024]={'84:60.08,75.08 A:1209076'}
G[500025]={'86:54.5,77.8 A:1209095'}
G[500026]={'217:79.66,75.66 A:45312 N:44789'}
G[500027]={'310:27.94,60.56 A:47293 N:44789'}
G[500028]={'313:60.32,40.82 A:47293 N:44789'}
G[500029]={'315:58.84,52.46 A:47293 N:44789'}
G[500030]={'65:45.53,33.71 A:42039 N:42039'}
G[500031]={'398:25.98,62.92 A:57864 N:57864'}
G[500032]={'398:71.61,80.63 A:55624'}
G[500033]={'398:87.86,49.89 A:57864 N:57864'}
G[500034]={'174:53.16,36.55 A:38124 N:36077','In mine'}
G[500035]={'174:54.39,16.93 A:38124 N:36077'}
G[500036]={'174:43.63,25.32 A:38387 N:34668'}
G[500037]={'174:43.85,25.30 A:38120 N:36379'}
G[500038]={'HC 115:72.83,36.41 A:33533 N:33533'}
G[500039]={'HC 116:50.57,45.16 A:33533 N:33533'}
G[500040]={'HC 115:59.80,54.22 A:33533 N:33533'}
G[500041]={'HC 78:47.39,9.20 119:40.25,82.73>78 A:33533 N:33533'}
G[500042]={'HC 7:60.75,23.10 A:14444 N:14444'}
G[500043]={'HC 998:58.05,91.77 A:14444 N:14444'}
G[500044]={'23:53.02,53.20 A:45400 N:45400'}
G[500045]={'23:52.92,53.07 A:45417 N:45417'}
G[500046]={'23:61.61,42.60 A:45400 N:45400'}
G[500047]={'23:61.47,42.69 A:45417 N:45417'}
G[500048]={'23:50.59,20.09 A:45400 N:45400'}
G[500049]={'23:50.44,20.15 A:45729 N:45429'}
G[500050]={'23:50.54,20.17 A:45417 N:45417'}
G[500051]={'23:27.61,21.17 A:45729 N:45429'}
G[500052]={'23:73.71,52.09 A:45417 N:45417'}	-- this is the final resting place and I believe exists once 27526 is turned in
G[500053]={'23:73.62,51.87 A:45400 N:45400'} -- see comments for npc 500052
G[500054]={'378:65.98,22.81 A:53566 N:53566'}
G[500055]={'376:68.85,43.40 A:56133 N:56133'}
G[500056]={'376:55.89,49.43 A:56133 N:56133'}
G[500057]={'376:18.09,55.68 A:56474 N:56474'}
G[500058]={'376:52.68,62.82 A:56138 N:56138'}
G[500059]={'376:55.83,49.35 A:56133 N:56133'}
G[500060]={'376:32.25,68.55 A:56133 N:56133'}
G[500062]={'376:32.24,68.29 A:56474 N:56474'}
G[500063]={'376:32.33,68.47 A:56138 N:56138'}
G[500064]={'376:36.03,68.97 A:56133 N:56133'}
G[500065]={'376:35.99,69.09 A:56474 N:56474'}
G[500066]={'376:36.12,69.05 A:56138 N:56138'}
G[500067]={'376:36.00,69.11 A:56133 N:56133'}
G[500068]={'376:75.27,35.50 N:56133'}
G[500069]={'418:60.42,25.57 A:58113 N:58113'}
G[500070]={'418:66.40,32.53 A:56114 N:56112'}
G[500071]={'379:54.17,83.42 A:63542 N:63542'}
G[500072]={'418:24.70,33.99 A:58745 N:58745'}
G[500073]={'379:53.91,83.56 A:59441 N:55122','Wandering around camp'}
G[500074]={'422:50.18,10.19 A:62779 N:56133'}
G[500075]={'422:56.58,75.92 A:63317 N:63317'}
G[500076]={'379:74.93,88.55 A:60973 N:60973'}
G[500077]={'422:44.42,16.80 A:62779 N:56133','Down in Morrowchamber'}
G[500078]={'422:50.29,12.06 A:62667 N:62667'}
G[500079]={'422:50.22,12.10 A:62666 N:62666'}
G[500080]={'379:35.12,59.66 A:61819 N:60687'}
G[500081]={'371:46.47,96.30 A:54617 N:54617'}
G[500082]={'371:46.20,84.81 A:54617 N:54617'}
G[500083]={'371:30.79,52.27 A:56406 N:55521'}
G[500084]={'390:56.45,43.24 A:58468 N:58468'}
G[500085]={'478:48.98,21.22 A:64563 N:64563'}	-- Baron location for turnin
G[500086]={'478:49.08,20.63 A:64562 N:64563'}	-- Spirit location for turnin
G[500087]={'463:58.59,62.04 A:68025 N:4949'}
G[500088]={'HL 89:45.16,52.25 A:15892 N:15892'}
G[500089]={'376:52.92,51.83 A:58646 N:58646'}
G[500090]={'577:48.54,14.18 A:78554 N:78554'}
G[500091]={'84:73.90,55.87 A:18927 N:18927'}
G[500092]={'84:63.75,31.97 A:18927 N:18927'}
G[500093]={'84:49.73,90.01 A:18927 N:18927'}
G[500094]={'125:46.33,72.69 A:18927 N:18927'}
G[500095]={'125:44.16,58.91 A:18927 N:18927'}
G[500096]={'103:60.94,28.57 A:19171 N:19171'}
G[500097]={'103:68.01,61.73 A:19171 N:19171'}
G[500098]={'97:21.36,54.25 A:19171 N:19171'}
G[500099]={'94:54.18,50.76 A:19169 N:19169'}
G[500100]={'110:62.50,73.92 A:19169 N:19169'}
G[500101]={'110:59.09,60.91 A:19169 N:19169'}
G[500102]={'110:78.14,57.64 A:19169 N:19169'}
G[500103]={'125:62.73,30.31 A:19169 N:19169'}
G[500104]={'125:50.89,22.41 A:19169 N:19169'}
G[500105]={'86:32.32,65.85 A:19177 N:19177'}
G[500106]={'10:67.52,74.16 A:20102 N:20102'}
G[500107]={'71:50.89,30.10 A:20102 N:20102'}
G[500108]={'71:51.52,26.68 A:20102 N:20102'}
G[500109]={'71:52.24,28.58 A:20102 N:20102'}
G[500110]={'71:51.95,29.38 A:20102 N:20102'}
G[500111]={'83:58.74,48.38 A:20102 N:20102'}
G[500112]={'83:59.76,49.70 A:20102 N:20102'}
G[500113]={'83:59.89,50.89 A:20102 N:20102'}
G[500114]={'83:61.04,48.87 A:20102 N:20102'}
G[500115]={'109:32.30,64.80 A:20102 N:20102'}
G[500116]={'109:32.90,66.72 A:20102 N:20102'}
G[500117]={'109:33.85,64.11 A:20102 N:20102'}
G[500118]={'111:28.12,47.06 A:20102 N:20102'}
G[500119]={'111:49.17,31.50 A:20102 N:20102'}
G[500120]={'111:53.00,51.12 A:20102 N:20102'}
G[500121]={'111:55.26,80.52 A:20102 N:20102'}
G[500122]={'111:58.02,46.14 A:20102 N:20102'}
G[500123]={'111:54.92,38.48 A:20102 N:20102'}
G[500124]={'111:58.97,58.09 A:20102 N:20102'}
G[500125]={'111:63.60,39.76 A:20102 N:20102'}
G[500126]={'120:40.77,84.50 A:20102 N:20102'}
G[500127]={'126:33.15,52.45 A:20102 N:20102'}
G[500128]={'210:40.56,68.29 A:20102 N:20102'}
G[500129]={'210:40.51,73.08 A:20102 N:20102'}
G[500130]={'210:41.70,74.21 A:20102 N:20102'}
G[500131]={'525:82.83,76.33 A:77210 N:77210'}
G[500132]={'543:45.86,70.30 A:74594 N:70860'}
G[500133]={'543:46.10,70.20 A:74594 N:70860'}
G[500134]={'539:62.58,26.22 A:80073 N:79537'}
G[500135]={'581:44.28,53.92 A:1230865 N:1230865'}	-- garrison level 2 location
G[500136]={'543:53.00,59.78 A:75136 N:78568'}
G[500137]={'543:53.31,59.89 A:75146 N:79576'}
G[500138]={'581:29.26,33.14 A:77209 N:79243'}	-- garrison level 3 location
G[500139]={'581:51.19,63.58 A:77383 N:77383'}	-- location is top of stairs for plot 20
G[500140]={'581:51.19,63.58 A:78207 N:78207'}	-- location is top of stairs for plot 20
G[500141]={'581:51.19,63.58 A:77365 N:77365'}	-- plot 20
G[500142]={'581:51.19,63.58 A:77831 N:77831'}	-- plot 20
G[500143]={'542:51.57,31.36 A:79519 N:79519'}
G[500144]={'542:60.52,39.01 A:80648 N:80648'}
G[500145]={'542:46.50,46.66 A:81770 N:79519'}
G[500146]={'581:28.76,35.02 A:79953 N:79953'}	-- garrison level 3 location
G[500147]={'581:34.11,32.57 A:1234243 N:1234243'}	-- garrison level 3 position
G[500148]={'581:51.19,63.58 A:77372 N:77372'}	-- plot 20
G[500149]={'581:51.19,63.58 A:77777 N:77777'}	-- plot 20
G[500150]={'578:81.54,44.81 A:78553 N:4949'}
G[500151]={'525:57.43,48.31 A:78466 N:3391'}	-- garrison level 1, barracks position
G[500152]={'525:19.74,44.76 A:70860 N:70860'}
G[500153]={'525:55.48,56.63 A:72274 N:72274'}
G[500154]={'525:42.16,55.51 A:78466 N:3391'}	-- garrison level 2 position
G[500155]={'581:51.19,63.58 A:77354 N:77354'}	-- plot 20
G[500156]={'581:51.19,63.58 A:77781 N:77781'}	-- plot 20
G[500157]={'581:51.19,63.58 A:77356 N:77356'}	-- plot 20
G[500158]={'581:51.19,63.58 A:77775 N:77775'}	-- plot 20
G[500159]={'543:46.19,55.09 A:82610 N:82610'}
G[500160]={'539:65.23,26.18 A:73395 N:78994'}
G[500161]={'539:65.33,25.98 A:80078 N:72413'}
G[500162]={'539:65.39,26.17 A:80079 N:80079'}
G[500163]={'539:65.32,26.38 A:80073 N:79537'}
G[500164]={'535:59.97,16.48 A:1225726 N:1225726'}
G[500165]={'535:55.55,40.97 A:75808 N:74651'}
G[500166]={'587:51.43,57.39 A:88013 N:47269'} -- plot 22
G[500167]={'587:58,27 A:88013 N:47269'} -- plot 25
G[500168]={'587:51.43,57.39 A:88017 N:46338'} -- plot 22
G[500169]={'587:58,27 A:88017 N:46338'} -- plot 25
G[500170]={'587:51.43,57.39 A:88022 N:47869'} -- plot 22
G[500171]={'587:58,27 A:88022 N:47869'} -- plot 25
G[500172]={'587:51.43,57.39 A:88023 N:61021'} -- plot 22
G[500173]={'587:58,27 A:88023 N:61021'} -- plot 25
G[500174]={'587:51.43,57.39 A:88024 N:9177'} -- plot 22
G[500175]={'587:58,27 A:88024 N:9177'} -- plot 25
G[500176]={'587:51.43,57.39 A:88027 N:47366'} -- plot 22
G[500177]={'587:58,27 A:88027 N:47366'} -- plot 25
G[500178]={'587:51.43,57.39 A:88025 N:39930'}	-- plot 22
G[500179]={'587:58,27 A:88025 N:39930'}	-- plot 25
G[500180]={'587:51.43,57.39 A:88026 N:43184'}	-- plot 22
G[500181]={'587:58,27 A:88026 N:43184'}	-- plot 25
G[500182]={'587:51.43,57.39 A:87991 N:87991'}	-- plot 22
G[500183]={'587:58,27 A:87991 N:87991'}	-- plot 25
G[500184]={'587:51.43,57.39 A:87992 N:46854'}	-- plot 22
G[500185]={'587:58,27 A:87992 N:46854'}	-- plot 25
G[500186]={'587:51.43,57.39 A:87997 N:11036'}	-- plot 22
G[500187]={'587:58,27 A:87997 N:11036'}	-- plot 25
G[500188]={'587:51.43,57.39 A:87995 N:2487'}	-- plot 22
G[500189]={'587:58,27 A:87995 N:2487'}	-- plot 25
G[500190]={'587:51.43,57.39 A:87996 N:64842'}	-- plot 22
G[500191]={'587:58,27 A:87996 N:64842'}	-- plot 25
G[500192]={'587:51.43,57.39 A:87994 N:87994'}	-- plot 22
G[500193]={'587:58,27 A:87994 N:87994'}	-- plot 25
G[500194]={'587:51.43,57.39 A:87998 N:58113'}	-- plot 22
G[500195]={'587:58,27 A:87998 N:58113'}	-- plot 25
G[500196]={'587:51.43,57.39 A:87999 N:40997'}	-- plot 22
G[500197]={'587:58,27 A:87999 N:40997'}	-- plot 25
G[500198]={'587:51.43,57.39 A:88007 N:88007'}	-- plot 22
G[500199]={'587:58,27 A:88007 N:88007'}	-- plot 25
G[500200]={'587:51.43,57.39 A:88000 N:49444'}	-- plot 22
G[500201]={'587:58,27 A:88000 N:49444'}	-- plot 25
G[500202]={'587:51.43,57.39 A:88001 N:38237'}	-- plot 22
G[500203]={'587:58,27 A:88001 N:38237'}	-- plot 25
G[500204]={'587:51.43,57.39 A:88002 N:28444'}	-- plot 22
G[500205]={'587:58,27 A:88002 N:28444'}	-- plot 25
G[500206]={'587:51.43,57.39 A:88003 N:88003'}	-- plot 22
G[500207]={'587:58,27 A:88003 N:88003'}	-- plot 25
G[500208]={'587:51.43,57.39 A:88004 N:88004'}	-- plot 22
G[500209]={'587:58,27 A:88004 N:88004'}	-- plot 25
G[500210]={'587:51.43,57.39 A:88005 N:54961'}	-- plot 22
G[500211]={'587:58,27 A:88005 N:54961'}	-- plot 25
G[500212]={'587:51.43,57.39 A:88006 N:88006'}	-- plot 22
G[500213]={'587:58,27 A:88006 N:88006'}	-- plot 25
G[500214]={'587:51.43,57.39 A:88009 N:88009'}	-- plot 22
G[500215]={'587:58,27 A:88009 N:88009'}	-- plot 25
G[500216]={'539:27.52,11.26 A:91242 N:91242'}
G[500217]={'581:51.19,63.58 A:84857 N:84857'}	-- plot 20
G[500218]={'581:51.19,63.58 A:77363 N:77363'}	-- plot 20
G[500219]={'581:51.19,63.58 A:77791 N:77791'}	-- plot 20
G[500220]={'581:31.01,31.07 A:81152 N:81152'}	-- garrison level 3 location
G[500221]={'581:51.19,63.58 A:77359 N:77359'}	-- plot 20
G[500222]={'581:51.19,63.58 A:77792 N:77792'}	-- plot 20
G[500223]={'581:51.19,63.58 A:77382 N:77382'}	-- plot 20
G[500224]={'581:51.19,63.58 A:77778 N:77778'}	-- plot 20
G[500225]={'539:75.07,57.89 A:92213 N:78558'}
G[500226]={'316:48.89,82.50 A:47006 N:47006'}
G[500227]={'313:60.41,41.03 A:47006 N:47006'}
G[500228]={'315:58.69,53.52 A:47006 N:47006'}
G[500229]={'525:37.65,50.29 A:78466 N:3391'}	-- garrison level 3 position
G[500230]={'525:41.46,69.89 A:91242 N:91242'}
G[500231]={'587:52.59,40.81 A:79813 N:79813'}	-- plot 20 location
G[500232]={'587:52.59,40.81 A:79814 N:79814'}	-- plot 20 location
G[500233]={'587:52.59,40.81 A:79867 N:79867'}	-- plot 20 location
G[500234]={'587:52.59,40.81 A:79817 N:79817'}	-- plot 20 location
G[500235]={'587:52.59,40.81 A:79821 N:79821'}	-- plot 20 location
G[500236]={'587:52.59,40.81 A:79820 N:79820'}	-- plot 20 location
G[500237]={'587:52.59,40.81 A:79826 N:79826'}	-- plot 20 location
G[500238]={'587:52.59,40.81 A:86696 N:86696'}	-- plot 20 location
G[500239]={'587:52.59,40.81 A:79829 N:79829'}	-- plot 20 location
G[500240]={'587:52.59,40.81 A:79831 N:79831'}	-- plot 20 location
G[500241]={'587:52.59,40.81 A:79832 N:79832'}	-- plot 20 location
G[500242]={'587:52.59,40.81 A:79830 N:79830'}	-- plot 20 location
G[500243]={'587:52.59,40.81 A:79834 N:79834'}	-- plot 20 location
G[500244]={'587:52.59,40.81 A:79833 N:79833'}	-- plot 20 location
G[500245]={'587:52.59,40.81 A:79864 N:79864'}	-- plot 20 location
G[500246]={'587:52.59,40.81 A:79863 N:79863'}	-- plot 20 location
G[500247]={'587:43.92,48.57 A:1234243 N:1234243'}	-- garrison level 3 position
G[500248]={'525:74.02,29.68 A:72230 N:74651'}
G[500249]={'525:73.93,29.61 A:74253 N:74272'}
G[500250]={'587:37.61,50.28 A:78466 N:3391'}	-- garrison level 3 Horde
G[500251]={'587:52.59,40.81 A:79857 N:79857'}	-- plot 20 location
G[500252]={'581:51.19,63.58 A:77378 N:77378'}	-- plot 20
G[500253]={'581:51.19,63.58 A:88545 N:88545'}	-- plot 20
G[500254]={'587:52.59,40.81 A:88546 N:88546'}	-- plot 20
G[500255]={'581:51.19,63.58 A:88145 N:88145'}	-- plot 20
G[500256]={'587:52.59,40.81 A:88392 N:88392'}	-- plot 20
G[500257]={'543:51.85,50.03 A:1234474 N:1234474'}	-- Lumber Mill-based location
G[500258]={'720:56.20,54.14 N:103025'}
G[500259]={'630:53.33,45.41 A:108328 N:108328'}
G[500260]={'723:49.40,54.86 N:18417'}
G[500261]={'643:62.94,48.95 A:91223 N:91223'}
G[500262]={'641:63.20,42.22 A:104728 N:7999'}
G[500263]={'628:68.03,62.99 A:98102 N:98102'}
G[500264]={'627:49.49,41.19 A:98102 N:98102'}
G[500265]={'628:67.64,62.13 A:98102 N:98102'}
G[500382]={'49:29.73,44.51 A:382 N:382'}
G[501759]={'86:52,41 A:101759 N:101759'}
G[502079]={'57:58.13,38.94 A:2079 N:2079'}
G[502080]={'57:43.93,44.19 A:2080 N:2080'}	-- TODO: Determine if the original stuff with him can be given to the second location.  I know "The Shimmering Frond" and "Timberling Sprouts" can go to both.  If the early stuff needs to be done at the original dude, I think it would be best to alias the second one and just make other quests be able to be turned in to either one.
G[502081]={'504:53.93,49.77 A:67985 N:70358'}	-- phase 2 location at Beast Pens
G[502487]={'210:41.53,72.93 A:2487 N:2487'}
G[503515]={'57:41.05,45.56 A:3515 N:3515','Wanders a bit around here'}
G[504508]={'301:65.29,81.51 A:4508 N:4508'}
G[509271]={'78:43.9,7.3 A:9271 N:9271'}
G[514305]={'HC 89:43.16,78.05 A:14305 N:14305'}
G[514444]={'HC 76:25.79,50.47 A:14444 N:14444'}
G[514625]={'32:50.01,39.05 A:14625 N:14625'}
G[514626]={'32:42.24,34.51 A:14626 N:14626'}
G[515732]={'18:61.02,59.36 71:52.57,28.06 86:50.20,61.82 94:56.46,51.80 125:49.33,44.85 210:40.28,67.64 A:15732 N:15732'}
G[515892]={'HL 84:61.74,75.71 A:15892 N:15892'}
G[516116]={'23:76.09,75.35 A:16116 N:16116'}
G[518927]={'84:66.95,72.50 A:18927 N:18927'}
G[519169]={'110:90.23,57.58 A:19169 N:19169'}
G[519171]={'103:60.14,48.91 A:19171 N:19171'}
G[519175]={'86:69.87,49.50 A:19175 N:19175'}
G[519176]={'88:40.91,56.15 A:19176 N:19176'}
G[519177]={'86:39.56,78.21 A:19177 N:19177'}
G[519178]={'998:67.69,39.24 A:19178 N:19178'}
G[520102]={'10:68.21,71.38 A:20102 N:20102'}
G[522818]={'HC 108:39.73,64.56 A:22818 N:22818'}
G[526221]={'HM 86:47.24,37.87 88:21.21,24.06 998:66.89,13.51 110:68.68,42.91 111:60.67,30.63 A:26221 N:26221'} -- Horde version since Blizzard really is doing some odd things
G[526935]={'116:64.94,43.42 A:26935 N:26935'}
G[528401]={'121:60.22,57.70 A:28401 N:28401'}
G[528518]={'Near121 A:28518 N:28518'}
G[532959]={'62:50.13,19.46 A:32959 N:32959'}
G[532971]={'62:50.68,19.73 A:32971 N:32971'}
G[532972]={'62:50.80,18.71 A:32972 N:32972'}
G[533178]={'62:72.37,18.81 A:33178 N:33178'}
G[533532]={'HC 115:46.85,59.37 A:33532 N:33532'}
G[533533]={'HC 114:43.75,14.13 A:33533 N:33533'}
G[534668]={'194:59.67,77.05 A:34668 N:34668'}
G[534872]={'194:60.14,74.61 A:34872 N:34872'}
G[534874]={'194:60.00,78.19 A:34874 N:34874'}
G[535120]={'194:29.66,71.91 A:35120 N:35120'}
G[535222]={'194:20.87,13.69 A:35222 N:35222'}
G[535867]={'76:66.55,20.35 A:35867 N:35867'}
G[536163]={'66:73.34,41.64 A:36163 N:36163'}
G[536210]={'76:53.26,49.96 A:36210 N:36210'}
G[536471]={'174:51.85,47.20 A:36471 N:34872'}
G[536749]={'76:60.64,50.59 A:36749 N:36749'}
G[537570]={'199:48.20,38.65 A:37570 N:37570'}
G[537675]={'HA 86:53.03,77.14 110:64.54,67.31 88:43.61,53.00 998:65.89,38.71 A:37675 N:37675'}
G[538120]={'174:68.94,46.45 A:38120 N:36379'}
G[538124]={'174:51.72,47.39 A:38124 N:36077'}
G[538242]={'463:50.72,52.09 A:38242 N:38242'}
G[538243]={'463:57.66,52.64 1:67.53,84.17>463 A:38243 N:38243'}
G[538387]={'174:37.35,41.91 A:38387 N:34668'}
G[538647]={'174:54.00,16.98 A:38647 N:38647'}
G[538738]={'174:54.44,16.92 A:38738 N:37106'}
G[538935]={'174:42.15,17.38 A:38935 N:4949'}
G[539433]={'198:28.22,29.76 A:39433 N:39433'}
G[539627]={'198:29.64,29.27 A:39627 N:39627'}
G[539858]={'198:19.54,37.82 A:39858 N:5769'}
G[539877]={'205:53.28,33.09 A:39877 N:39877'}
G[539881]={'205:40.59,75.04 A:39881 N:39881'}
G[539908]={'297:56.17,3.73 A:39908 N:28070'}
G[540639]={'205:32.91,69.24 A:40639 N:40639'}
G[540642]={'205:33.23,68.35 A:40642 N:39887'}
G[540643]={'205:33.00,67.55 205:33.00,67.70 205:32.99,67.89 A:40643 N:40643'}
G[540645]={'205:56.59,80.25 A:40645 N:40645','At surface'}
G[540772]={'198:72.08,74.02 A:40772 N:40619'}
G[541006]={'198:32.78,70.75 A:41006 N:41006'}
G[541600]={'204:55.71,72.98 A:41600 N:36915'}
G[542039]={'65:45.62,34.23 A:42039 N:42039'}
G[542076]={'205:46.39,79.05 A:42076 N:40640'}
G[542077]={'205:33.13,75.87 A:42077 N:40640'}
G[542466]={'207:33.11,24.11 A:42466 N:42466'}
G[542790]={'50:38.47,48.62 A:42790 N:42790'}
G[543733]={'49:77.20,65.91 A:43733 N:43221'}
G[543885]={'Near50 A:43885 N:43885'}
G[544293]={'84:80.27,62.12 A:44293 N:1747','Up on third floor'}
G[544365]={'21:44.89,41.65 A:44365 N:10181'}
G[544402]={'301:23.40,31.57 A:44402 N:44402'}
G[544415]={'301:23.78,30.70 A:44415 N:44415'}
G[544453]={'22:39.91,69.47 A:44453 N:26170'}
G[544467]={'22:40.03,69.23 A:44467 N:44467'}
G[544640]={'21:44.82,40.92 A:44640 N:44640'}
G[544806]={'84:26.13,47.29 A:44806 N:44806'}
G[544916]={'21:45.81,41.94 A:44916 N:44916'}
G[544917]={'21:45.76,41.91 A:44917 N:44917'}
G[545165]={'22:53.84,64.68 A:45165 N:45165'}
G[545172]={'241:79.22,78.29 A:45172 N:45172'}
G[545200]={'317:21.59,80.75 23:27.07,15.77>317 A:45200 N:16115'}
G[545201]={'317:24.15,76.31 23:27.07,15.77>317 A:45201 N:45201'}	-- this location is valid after 35563 is completed
G[545206]={'318:43.87,14.12 23:43.45,19.36>317 A:45206 N:16112'}
G[545277]={'Near64 A:45277 N:45277'}
G[545278]={'Near64 A:45278 N:45278'}
G[545312]={'217:72.96,30.11 A:45312 N:44789'}
G[545323]={'317:21.66,79.72 23:27.07,15.77>317 A:45323 N:45323'}
G[545328]={'318:49.73,22.34 23:43.45,19.36>317 A:45328 N:45323'}
G[545329]={'318:44.82,20.47 23:43.45,19.36>317 A:45329 N:16115'}
G[545330]={'318:42.45,12.70 23:43.45,19.36>317 A:45330 N:16116'}
G[545331]={'318:49.82,18.49 23:43.45,19.36>317 A:45331 N:45201'}
G[545400]={'23:35.01,69.28 A:45400 N:45400'}	-- the first stop...still only has three original quests
G[545417]={'23:34.85,69.14 A:45417 N:45417'}
G[545429]={'23:35.26,68.86 A:45429 N:45429'}
G[545451]={'23:50.49,20.22 A:45451 N:45451'}
G[545474]={'217:79.66,75.66 A:45474 N:44789'}
G[545574]={'23:60.61,43.33 A:45574 N:45574'}
G[545729]={'23:61.57,43.22 A:45729 N:45429'}
G[545730]={'23:73.75,52.17 A:45730 N:45428'}
G[546409]={'225:22.07,27.20 A:46409 N:46409'}
G[546612]={'292:59.05,36.56 292:60.31,38.84 A:46612 N:42308'}
G[546654]={'15:21.17,57.77 A:46654 N:46654'}
G[546664]={'15:17.98,30.55 A:46664 N:46664'}
G[546804]={'241:60.18,57.83 A:46804 N:46804'}
G[547006]={'310:63.09,71.36 310:59.36,61.16 A:47006 N:47006'}
G[547293]={'310:63.09,71.36 A:47293 N:44789'}
G[547393]={'32:40.81,51.67 A:47393 N:47393'}
G[547429]={'32:38.97,26.02 A:47429 N:47269'}
G[547900]={'25:36.64,61.20 A:47900 N:47900'}
G[548020]={'25:36.56,58.07 A:48020 N:47900'}
G[548021]={'25:38.16,56.41 A:48021 N:47869'}
G[548218]={'25:50.03,74.34 A:48218 N:48218'}
G[548306]={'36:73.49,67.19 A:48306 N:43184'}
G[549020]={'241:78.92,76.65 A:49020 N:44806'}
G[549476]={'284:68.84,55.96 A:49476 N:49444'}
G[549480]={'Near57 A:49480 N:1992','In cave'}
G[552234]={'Near210 A:52234 N:52234'}
G[552477]={'338:41.57,61.32 A:52477 N:40278','In Molten Flow cave'}
G[552478]={'338:51.30,85.81 A:52478 N:39925'}
G[552823]={'338:57.73,49.51 A:52823 N:52823'}
G[552838]={'198:27.11,62.81 A:52838 N:5769'}
G[552845]={'198:27.02,62.69 A:52845 N:33091'}
G[552924]={'333:93.31,53.54 A:52924 N:38966'}
G[552925]={'333:91.77,55.19 A:52925 N:52925'}
G[553073]={'198:27.49,61.58 A:53073 N:53073'}
G[553080]={'338:45.60,86.22 A:53080 N:41492'}
G[553566]={'378:59.68,19.10 A:53566 N:53566'}
G[553738]={'207:64.05,46.09 A:53738 N:35875'}
G[554616]={'371:41.39,79.57 A:54616 N:54616'}
G[554617]={'371:46.47,96.30 A:54617 N:54617'}
G[554786]={'378:51.58,48.33 A:54786 N:53566'}
G[554914]={'371:42.74,23.17 A:54914 N:54914'}
G[554943]={'378:55.10,32.39 A:54943 N:54943'}
G[554960]={'371:58.05,80.56 A:54960 N:54960'}
G[554975]={'378:79.81,39.28 A:54975 N:54567'}
G[555020]={'378:78.48,42.84 A:55020 N:55020'}
G[555521]={'371:28.10,24.70 A:55521 N:55521'}
G[555595]={'378:24.78,69.76 A:55595 N:54567'}
G[555624]={'398:29.34,39.98 A:55624 N:54476'}
G[556111]={'376:18.06,31.01 A:56111 N:54913'}
G[556112]={'418:28.85,50.57 A:56112 N:56112'}
G[556114]={'418:25.19,34.54 A:56114 N:56112'}
G[556133]={'376:68.87,43.14 A:56133 N:56133'}
G[556138]={'376:68.77,43.43 A:56138 N:56138'}
G[556312]={'376:74.41,34.52 A:56312 N:56312'}
G[556339]={'371:28.67,47.54 A:56339 N:54870'}	-- this location is after turn in of 29824
G[556406]={'371:27.23,50.78 A:56406 N:55521'}	-- this move was during 29937
G[556474]={'376:54.27,38.73 A:56474 N:56474'}
G[556720]={'376:17.85,56.25 A:56720 N:56720'}
G[557298]={'376:48.29,33.87 A:57298 N:57298'}	-- at home
G[557402]={'376:52.99,51.74 A:57402 N:57402'}	-- at Halfhill
G[557864]={'401:51.06,43.48 A:57864 N:57864'}
G[558113]={'418:59.88,24.68 A:58113 N:58113'}
G[558114]={'418:28.70,50.88 A:58114 N:58114'}
G[558422]={'376:19.90,75.67 A:58422 N:715'}
G[558465]={'390:56.57,43.60 A:58465 N:58465'}
G[558468]={'390:56.51,43.39 A:58468 N:58468'}
G[558471]={'390:56.51,43.60 A:58471 N:58471'}
G[558607]={'418:28.90,50.86 A:58607 N:58113'}
G[558630]={'418:24.87,34.36 A:58630 N:58630'}
G[558646]={'376:52.25,48.79 A:58646 N:58646'}
G[558647]={'376:31.51,58.07 A:58647 N:58647'}	-- at home
G[558705]={'376:41.72,30.02 A:58705 N:58705'}	-- at home
G[558707]={'376:30.95,53.10 A:58707 N:58707'}	-- at home
G[558708]={'376:29.53,30.60 A:58708 N:58708'}	-- at home
G[558709]={'376:53.07,52.05 A:58709 N:58709'}	-- at Halfhill
G[558745]={'418:15.09,39.43 A:58745 N:58745'}
G[558761]={'376:52.97,51.79 A:58761 N:58761'}	-- Halfhill
G[559441]={'379:53.77,82.68 A:59441 N:55122'}
G[559856]={'376:17.91,55.75 A:59856 N:56714'}
G[559905]={'390:44.77,76.33 A:59905 N:59905'}
G[560622]={'388:76.19,72.91 A:60622 N:60622'}
G[560679]={'379:36.94,76.22 A:60679 N:60679'}
G[560687]={'388:71.02,56.55 A:60687 N:60687'}
G[560795]={'379:43.76,51.11 A:60795 N:54961'}
G[560973]={'379:75.20,88.26 A:60973 N:60973'}
G[561021]={'388:74.23,85.04 A:61021 N:61021'}
G[561161]={'388:35.40,56.65 A:61161 N:61161'}
G[561482]={'389:56.18,20.17 A:61482 N:61482'}
G[561539]={'388:39.45,61.93 A:61539 N:61539'}
G[561819]={'379:35.32,49.56 A:61819 N:60687'}
G[561820]={'379:31.82,60.12 A:61820 N:61016'}
G[561822]={'213:31.67,76.37 A:61822 N:61822'}	-- at end of dungeon
G[561823]={'213:32.07,75.90 A:61823 N:61823'}	-- at end of dungeon
G[562151]={'422:28.65,42.14 A:62151 N:62151'}
G[562180]={'Near422 A:62180'}
G[562274]={'388:54.07,77.87 A:62274 N:60688'}
G[562295]={'Near388 A:62295'}
G[562304]={'388:49.18,71.05 A:62304 N:60687'}
G[562378]={'Near388 A:62378'}
G[562379]={'Near388 A:62379 N:562295'}
G[562666]={'422:38.18,17.18 A:62666 N:62666'}
G[562667]={'422:38.30,17.13 A:62667 N:62667'}
G[562668]={'422:38.20,17.11 A:62668 N:62668'}
G[562774]={'422:55.06,35.47 A:62774 N:62774'}
G[562779]={'422:54.10,20.48 A:62779 N:56133'}
G[563195]={'Near388 A:63195'}
G[563196]={'Near388 A:63196'}
G[563197]={'Near388 A:63197'}
G[563310]={'463:51.95,52.02 A:63310 N:63310'}
G[563317]={'422:54.77,72.11 A:63317 N:63317'}
G[563349]={'422:56.57,75.83 A:63349 N:63349'}	-- only appears here after OCC:31190
G[563367]={'433:51.91,43.74 A:63367 N:63367'}
G[563535]={'379:61.20,82.22 A:63535 N:63535'}
G[563542]={'379:54.70,84.22 A:63542 N:63542'}
G[563622]={'Near388 A:63622'}
G[563623]={'Near388 A:63623'}
G[563624]={'Near388 A:63624'}
G[563751]={'379:63.67,86.65 N:63751'}
G[563754]={'379:61.25,82.29 A:63754 N:63754'}
G[564259]={'422:53.64,76.05 A:64259 N:64259'}
G[564432]={'455:38.68,81.40 390:80.82,32.72>453 A:64432 N:63266'}
G[564467]={'437:52.30,60.57 390:15.84,74.39>437 A:64467 N:62112'}
G[564521]={'379:72.03,94.25 A:64521 N:64521'}	-- Location for quest 31393 when I checked last
G[564562]={'Near476 A:64562 N:64562'}	-- skull location floating through dungeon
G[564563]={'Near476 A:64563 N:64562'}	-- skull location floating through dungeon
G[564738]={'431:31.91,84.42 A:64738 N:64764'}
G[564764]={'431:31.92,84.41 A:64764 N:64764'}
G[565558]={'Near378'}
G[566292]={'371:48.05,88.39 A:66292 N:66292'}
G[567660]={'504:46.86,66.91 A:67660 N:30116'}	-- phase 2 location
G[567662]={'504:28.40,53.36 A:67662 N:67662'}	-- phase 1 location on ship.  phase 2 is NPC 67662
G[567663]={'504:28.60,52.46 A:67663 N:36670'}	-- phase 1 location on ship.  phase 2 is NPC 67663
G[567673]={'504:28.42,52.44 A:67673 N:34771'}	-- phase 1 location on ship.  phase 2 is NPC 67673
G[567734]={'379:32.90,26.27 A:67734 N:67734'}
G[567984]={'504:36.76,64.90 A:67984 N:33538'}	-- phase 2 location	[TODO: Deal with the location 928:32.52,35.68 which is at camp when not in the field]
G[567985]={'504:53.93,49.77 A:67985 N:70358'}	-- phase 2 location at Conqueror's Terrace	; Beast Pens NPC is 502081
G[567986]={'504:47.2,40.6 A:67986 N:33542'}	-- Beast Pens
G[567990]={'504:28.36,52.43 A:67990 N:16802'}	-- phase 1 location on ship.  phase 2 is NPC 67990
G[567992]={'424:19.34,18.86 A:67992 N:4968'}
G[567993]={'504:63.25,72.13 A:67993 N:30115'}	-- Phase 2 location.  Phase 1 is NPC 67993.
G[567995]={'504:62.70,73.56 A:67995 N:67995'}	-- Phase 2 location.  Phase 1 is NPC 67995.
G[567996]={'504:55.74,74.40 N:67996'}	-- Phase 2 location.  Phase 1 is NPC 67996.
G[567997]={'504:40.19,59.56 N:34880'}	-- Phase 2 location.  Phase 1 is NPC 67997.
G[567998]={'504:61.88,51.99 A:67998 N:67998'}	-- Conqueror's Terrace location
G[567999]={'504:61.89,52.09 A:67999 N:67999'}	-- Conqueror's Terrace location
G[568004]={'418:88.98,31.71 A:68004 N:1747'}
G[568025]={'463:38.39,46.47 A:68025 N:4949'}
G[568072]={'Near418 A:68072 N:68072'}
G[568399]={'Near418 A:68399 N:68399'}
G[568651]={'57:39.98,50.48 A:68651 N:4968'}
G[569418]={'504:36.64,64.68 A:69418 N:69418'}	-- phase 2 location [TODO: Deal with the location 928:32.53,35.74 which is the location at camp when not in the field]
G[569433]={'504:46.92,66.90 A:69433 N:69433'}	-- phase 2 location
G[569668]={'504:40.15,59.30 N:69668'}	-- Phase 2 location.  Phase 1 is NPC 69668.
G[569670]={'504:64.83,73.11 N:69670'}	-- Phase 5 location.
G[569673]={'504:42.16,66.45 N:69673'}	-- Phase 2 location.  Phase 1 is NPC 69673.
G[569674]={'504:42.30,66.32 N:69674'}	-- Phase 2 location.  Phase 1 is NPC 69674
G[569675]={'504:55.89,74.41 N:58735'}	-- Phase 2 location.  Phase 1 NPC is 69675.
G[569677]={'504:55.55,74.44 N:69677'}	-- Phase 2 location.  Phase 1 is NPC 69677.
G[569678]={'504:55.61,74.52 N:19644'}	-- Phase 2 location.  Phase 1 is NPC 69678.
G[570297]={'504:32.89,32.68 A:70297 N:61021'}	-- Horde version of Taoshi
G[570517]={'504:42.21,66.33 A:70517 N:20735'}	-- Phase 2 position.  Phase 1 is NPC 70517.
G[570860]={'525:20.75,57.97 A:70860 N:70860'}
G[570941]={'532:49.72,51.91 A:70941 N:79917'}
G[570980]={'379:43.76,51.12 A:70980 N:70980'}
G[571333]={'1:49.80,40.10 A:71333 N:71333'}
G[572230]={'525:57.41,41.47 A:72230 N:74651'}
G[572274]={'525:47.57,45.57 A:72274 N:72274'}
G[573395]={'539:52.23,46.15 A:73395 N:78994'}
G[573480]={'525:19.88,14.62 A:73480 N:77417'}
G[574009]={'222:87.74,86.41 63:16.52,11.03>222 A:74009 N:44375'}
G[574043]={'539:49.30,37.40 A:74043 N:17468'}
G[574163]={'587:50.14,37.92 A:74163 N:70860'}
G[574253]={'525:57.38,41.42 A:74253 N:74272'}
G[574594]={'543:41.49,74.08 A:74594 N:70860'}
G[574606]={'543:46.58,71.53 A:74606 N:74606'}
G[574611]={'543:41.48,74.14 A:74611 N:74611'}
G[574635]={'525:24.44,29.04 A:74635 N:74635'}
G[575136]={'543:53.43,60.33 A:75136 N:78568'}
G[575146]={'543:53.48,60.43 A:75146 N:79576'}
G[575177]={'527:50.40,32.67 A:75177 N:70860'}
G[575256]={'535:60.92,72.45 A:75256 N:78519'}
G[575606]={'222:87.74,86.41 63:16.52,11.03>222 A:75606 N:33260'}
G[575803]={'535:63.04,25.89 A:75803 N:78554'}
G[575804]={'535:63.06,25.83 A:75804 N:78994'}
G[575808]={'535:62.01,10.99 A:75808 N:74651'}
G[575874]={'535:63.08,26.11 A:75874 N:78568'}
G[575884]={'539:45.84,25.58 A:75884 N:75884'}
G[576411]={'525:40.77,67.09 A:76411 N:74272'}
G[577160]={'543:69.63,26.10 A:77160 N:14627'}
G[577161]={'525:88.40,49.48 A:77161 N:78568'}
G[577184]={'539:29.21,25.73 A:77184 N:78558'}
G[577209]={'581:31.68,31.17 A:77209 N:79243'}	-- garrison level 2 location
G[577210]={'525:82.61,69.75 A:77210 N:77210'}
G[577282]={'539:35.72,36.89 A:77282 N:17468'}
G[577354]={'581:50.03,57.75 A:77354 N:77354'}	-- plot 19
G[577356]={'581:50.03,57.75 A:77356 N:77356'}	-- plot 19
G[577359]={'581:50.03,57.75 A:77359 N:77359'}	-- plot 19
G[577363]={'581:50.03,57.75 A:77363 N:77363'}	-- plot 19
G[577365]={'581:50.03,57.75 A:77365 N:77365'}	-- plot 19
G[577367]={'581:45.25,42.49 A:77367 N:77367'}	-- plot 23
G[577372]={'581:50.03,57.75 A:77372 N:77372'}	-- plot 19
G[577377]={'581:45.25,42.49 A:77377 N:77377'}	-- plot 23
G[577378]={'581:50.03,57.75 A:77378 N:77378'}	-- plot 19
G[577382]={'581:50.03,57.75 A:77382 N:77382'}	-- plot 19
G[577383]={'581:50.03,57.75 A:77383 N:77383'}	-- location is top of stairs for plot 19
G[577737]={'536:68.38,19.34 A:77737 N:77737'}
G[577775]={'581:50.03,57.75 A:77775 N:77775'}	-- plot 19
G[577777]={'581:50.03,57.75 A:77777 N:77777'}	-- plot 19
G[577778]={'581:50.03,57.75 A:77778 N:77778'}	-- plot 19
G[577781]={'581:50.03,57.75 A:77781 N:77781'}	-- plot 19
G[577791]={'581:50.03,57.75 A:77791 N:77791'}	-- plot 19
G[577792]={'581:50.03,57.75 A:77792 N:77792'}	-- plot 19
G[577831]={'581:50.03,57.75 A:77831 N:77831'}	-- plot 19
G[577928]={'525:50.04,56.20 A:77928 N:3391'}
G[578028]={'535:60.90,72.54 A:78028 N:77737'}
G[578207]={'581:50.03,57.75 A:78207 N:78207'}	-- location is top of stairs for plot 19
G[578323]={'525:88.40,49.55 A:78323 N:3391'}
G[578466]={'525:48.72,68.93 A:78466 N:3391'}	-- pre-garrison position
G[578487]={'587:45.95,42.71 A:78487 N:26859'}	-- Garrison Level 3 position
G[578553]={'577:71.92,62.06 A:78553 N:4949'}
G[578554]={'578:80.72,45.23 A:78554 N:78554'}
G[578559]={'577:71.54,62.37 A:78559 N:78558'}
G[578560]={'577:73.02,38.09 A:78560 N:78558'}
G[578563]={'577:43.14,28.74 A:78563 N:78558'}
G[578564]={'581:38.47,31.46 A:78564 N:78564'}	-- garrison level 3 location
G[578994]={'578:50.59,48.31 A:78994 N:78994'}
G[578996]={'577:73.18,38.94 A:78996 N:74272'}
G[579043]={'539:35.27,49.14 A:79043 N:17468'}
G[579519]={'542:45.39,18.26 A:79519 N:79519'}
G[579537]={'578:50.25,48.25 A:79537 N:79537'}
G[579573]={'535:71.59,29.90 A:79573 N:79573'}
G[579740]={'587:39.31,55.42 A:79740 N:79740'}	-- Garrison Level 3 position
G[579748]={'542:40.18,60.26 A:79748 N:79748'}
G[579813]={'587:48.38,33.59 A:79813 N:79813'}	-- plot 19 location
G[579814]={'587:48.38,33.59 A:79814 N:79814'}	-- plot 19 location
G[579815]={'587:58.88,49.06 A:79815 N:79815'}	-- plot 23 location
G[579817]={'587:48.38,33.59 A:79817 N:79817'}	-- plot 19 location
G[579820]={'587:48.38,33.59 A:79820 N:79820'}	-- plot 19 location
G[579821]={'587:48.38,33.59 A:79821 N:79821'}	-- plot 19 location
G[579826]={'587:48.38,33.59 A:79826 N:79826'}	-- plot 19 location
G[579829]={'587:48.38,33.59 A:79829 N:79829'}	-- plot 19 location
G[579830]={'587:48.38,33.59 A:79830 N:79830'}	-- plot 19 location
G[579831]={'587:48.38,33.59 A:79831 N:79831'}	-- plot 19 location
G[579832]={'587:48.38,33.59 A:79832 N:79832'}	-- plot 19 location
G[579833]={'587:48.38,33.59 A:79833 N:79833'}	-- plot 19 location
G[579834]={'587:48.38,33.59 A:79834 N:79834'}	-- plot 19 location
G[579857]={'587:48.38,33.59 A:79857 N:79857'}	-- plot 19 location
G[579862]={'587:48.38,33.59 A:79862 N:79862'}	-- plot 19 location
G[579863]={'587:48.38,33.59 A:79863 N:79863'}	-- plot 19 location
G[579864]={'587:48.38,33.59 A:79864 N:79864'}	-- plot 19 location
G[579867]={'587:48.38,33.59 A:79867 N:79867'}	-- plot 19 location
G[579953]={'581:31.17,32.85 A:79953 N:79953'}	-- garrison level 2 location
G[580073]={'539:62.45,26.28 A:80073 N:79537'}
G[580078]={'539:61.92,29.61 A:80078 N:72413'}
G[580079]={'539:62.48,26.22 A:80079 N:80079'}
G[580153]={'542:45.93,45.77 A:80153 N:75288'}
G[580159]={'581:48.96,41.09 A:80159 N:80159'}	-- garrison level 1 location
G[580163]={'581:37.94,63.85 A:80163 N:80163'}	-- garrison level 2 location
G[580193]={'Near535 A:80193 N:79393'}
G[580648]={'542:66.84,51.70 A:80648 N:80648'}
G[580758]={'542:46.72,46.38 A:80758 N:80758'}
G[581152]={'581:46.52,54.30 A:81152 N:81152'}
G[581530]={'539:50.57,82.29 A:81530 N:81530'}
G[581770]={'542:45.87,45.73 A:81770 N:79519'}
G[581790]={'550:64.24,59.55 A:81790 N:18261'}
G[582574]={'543:60.71,64.77 A:82574 N:85147'}
G[582610]={'543:44.90,63.95 A:82610 N:82610'}
G[583606]={'550:63.49,60.70 A:83606 N:83606'}
G[583823]={'535:84.81,31.43 A:83823 N:78558'}
G[583858]={'587:48.19,47.01 A:83858 N:83858'}
G[584248]={'581:35.53,49.36 A:84248 N:84248'}	-- plot 22
G[584524]={'581:51.21,47.04 A:84524 N:84524'}	-- plot 25
G[584702]={'550:92.34,31.43 A:84702 N:78558'}
G[584857]={'581:50.03,57.75 A:84857 N:84857'}	-- plot 19
G[584947]={'581:51.21,47.04 A:84947 N:84947'}	-- plot 25 location
G[585048]={'587:57.75,28.14 A:85048 N:85048'}	-- plot 25 location
G[585413]={'581:35.53,49.36 A:85413 N:45109'}	-- entrance to plot 22
G[585414]={'587:51.43,57.39 A:85414 N:45110'}	-- plot 22 location
G[585431]={'543:52.04,49.49 A:85431 N:85436'}	-- Lumber Mill-based location
G[585777]={'581:53.48,69.35 A:85777 N:77031'}	-- garrison level 1 position
G[585984]={'587:38,72 A:85984 N:12919'}
G[586475]={'542:66.75,51.58 A:86475 N:80758'}
G[586629]={'587:57.75,28.14 A:86629 N:86629'}	-- plot 25 location
G[586696]={'587:48.38,33.59 A:86696 N:86696'}	-- plot 19 location
G[586946]={'Near A:86946 N:23066'}
G[586973]={'581:40.09,56.58 A:86973 N:46804'}	-- plot 24 location
G[586974]={'581:40.09,56.58 A:86974 N:86974'}	-- plot 24 location
G[586979]={'587:60.36,36.51 A:86979 N:27221'}	-- plot 24 location
G[587121]={'587:57.75,28.14 A:87121 N:87121'}	-- plot 25 location
G[587206]={'581:51.21,47.04 A:87206'}	-- plot 25 location
G[587217]={'581:51.21,47.04 A:87217 N:87215'}	-- plot 25 location
G[587242]={'587:60.36,36.51 A:87242 N:26584'}	-- plot 24 location
G[587305]={'587:57.75,28.14 A:87305 N:87305'}	-- plot 25 location
G[587561]={'Near A:87561 N:87561'}
G[587991]={'581:51.21,47.04 A:87991 N:87991'}	-- plot 25
G[587992]={'581:51.21,47.04 A:87992 N:46854'}	-- plot 25
G[587994]={'581:51.21,47.04 A:87994 N:87994'}	-- plot 25
G[587995]={'581:51.21,47.04 A:87995 N:2487'}	-- plot 25
G[587996]={'581:51.21,47.04 A:87996 N:64842'}	-- plot 25
G[587997]={'581:51.21,47.04 A:87997 N:11036'}	-- plot 25
G[587998]={'581:51.21,47.04 A:87998 N:58113'}	-- plot 25
G[587999]={'581:51.21,47.04 A:87999 N:40997'}	-- plot 25
G[588000]={'581:51.21,47.04 A:88000 N:49444'}	-- plot 25
G[588001]={'581:51.21,47.04 A:88001 N:38237'}	-- plot 25
G[588002]={'581:51.21,47.04 A:88002 N:28444'}	-- plot 25
G[588003]={'581:51.21,47.04 A:88003 N:88003'}	-- plot 25
G[588004]={'581:51.21,47.04 A:88004 N:88004'}	-- plot 25
G[588005]={'581:51.21,47.04 A:88005 N:54961'}	-- plot 25
G[588006]={'581:51.21,47.04 A:88006 N:88006'}	-- plot 25
G[588007]={'581:51.21,47.04 A:88007 N:88007'}	-- plot 25
G[588009]={'581:51.21,47.04 A:88009 N:88009'}	-- plot 25
G[588013]={'581:51.21,47.04 A:88013 N:47269'} -- plot 25
G[588017]={'581:51.21,47.04 A:88017 N:46338'} -- plot 25
G[588022]={'581:51.21,47.04 A:88022 N:47869'} -- plot 25
G[588023]={'581:51.21,47.04 A:88023 N:61021'} -- plot 25
G[588024]={'581:51.21,47.04 A:88024 N:9177'} -- plot 25
G[588025]={'581:51.21,47.04 A:88025 N:39930'}	-- plot 25
G[588026]={'581:51.21,47.04 A:88026 N:43184'}	-- plot 25
G[588027]={'581:51.21,47.04 A:88027 N:47366'} -- plot 25
G[588145]={'581:50.03,57.75 A:88145 N:88145'}	-- plot 19
G[588392]={'587:48.38,33.59 A:88392 N:88392'}	-- plot 19
G[588545]={'581:50.03,57.75 A:88545 N:88545'}	-- plot 19
G[588546]={'587:48.38,33.59 A:88546 N:88546'}	-- plot 19
G[588892]={'587:54.66,14.42 A:88892 N:88892'}
G[589023]={'630:46.96,41.22 A:89023 N:89023'}
G[589793]={'587:40.18,56.62 A:89793 N:26814'}	-- Horde location
G[590238]={'534:62.57,50.89 A:90238 N:90238'}
G[590749]={'634:33.81,46.03 A:90749 N:66292'}
G[591166]={'630:61.30,50.79 A:91166 N:91165'}
G[591223]={'643:62.71,48.73 A:91223 N:91223'}
G[591242]={'543:50.61,16.69 A:91242 N:91242'}
G[591750]={'538:53.57,69.07 A:91750 N:75121'}
G[591751]={'538:56.75,66.65 A:91751 N:90177'}
G[591913]={'539:75.13,57.79 A:91913 N:90177'}
G[591923]={'572:62.45,54.23 A:91923 N:80079'}
G[592213]={'525:40.8,73.2 A:92213 N:78558'}
G[592718]={'677:49.45,49.82 A:92718 N:92718'}
G[592842]={'641:43.82,50.29 A:92842 N:40619'}
G[592850]={'641:43.24,80.95 A:92850 N:40619'}	-- i think outer map location is 1018:40.58,44.28
G[592986]={'677:48.68,49.31 A:92986 N:18417'}
G[593805]={'650:38.62,68.42 A:93805 N:93805'}
G[593822]={'539:28.20,11.69 A:93822 N:93822'}
G[594429]={'525:40.71,70.25 A:94429 N:91242'}
G[594789]={'525:42.10,71.04 A:94789 N:94789'}	-- location after accepting 39243
G[594870]={'587:41.46,47.18 A:94870 N:94870'}
G[594902]={'627:65.64,67.30 A:94902 N:93011'}
G[595237]={'720:58.58,57.88 A:95237 N:18417'}
G[595240]={'720:58.62,57.78 A:95240 N:93011'}
G[595424]={'534:60.42,46.73 A:95424 N:95424'}
G[596362]={'587:47.35,38.45 A:96362 N:96362'}
G[596644]={'84:18.92,42.75 A:96644 N:66292'}
G[596665]={'677:50.80,72.79 A:96665 N:93011'}
G[596683]={'627:29.12,46.89 A:96683 N:96683'}
G[596686]={'1:61.48,8.77 A:96686 N:10181'}
G[596705]={'587:47.11,37.54 A:96705 N:96705'}
G[597296]={'86:52.53,88.16 A:97296 N:78558'}
G[597553]={'651:47.35,44.42 A:97553 N:97553'}
G[598102]={'627:51.70,70.46 A:98102 N:98102'}
G[598632]={'720:59.93,48.92 A:98632 N:109295'}
G[600000]={'554:36.69,34.07'}
G[600001]={'554:25.48,27.18 N:600000'}
G[600002]={'554:27.35,39.07 N:600000'}
G[600003]={'554:30.60,36.51 N:600000'}
G[600004]={'554:22.39,35.41 N:600000'}
G[600005]={'554:22.15,49.27 N:600000'}
G[600006]={'554:24.80,53.04 N:600000'}
G[600007]={'554:25.68,45.84 N:600000'}
G[600008]={'554:22.26,68.07 N:600000'}
G[600009]={'554:26.85,68.75 N:600000'}
G[600010]={'554:30.99,76.30 N:600000'}
G[600011]={'554:35.34,76.44 N:600000'}
G[600012]={'554:38.74,71.62 N:600000'}
G[600013]={'554:39.81,79.50 N:600000'}
G[600014]={'554:34.84,84.20 N:600000'}
G[600015]={'554:43.560,84.040 N:600000'}
G[600016]={'554:46.99,53.73 N:600000'}
G[600017]={'554:46.70,46.74 N:600000'}
G[600018]={'554:51.16,45.69 N:600000'}
G[600019]={'554:55.55,44.33 N:600000'}
G[600020]={'554:58.02,50.68 N:600000'}
G[600021]={'554:65.61,47.87 N:600000'}
G[600022]={'554:63.80,59.15 N:600000'}
G[600023]={'554:64.90,75.57 N:600000'}
G[600024]={'554:60.16,66.05 N:600000'}
G[600025]={'554:49.72,65.73 N:600000'}
G[600026]={'554:53.10,70.82 N:600000'}
G[600027]={'554:52.66,62.75 N:600000'}
G[600028]={'554:44.13,65.42 N:600000'}
G[600029]={'554:26.02,61.44 N:600000'}
G[600030]={'554:24.63,38.56 N:600000'}
G[600031]={'554:59.93,31.33 N:600000'}
G[600032]={'554:29.77,31.73 N:600000'}
G[600034]={'554:28.16,35.12 N:600000 N:600001'}
G[600035]={'554:26.69,64.98 N:600000 N:600001'}
G[600036]={'554:64.55,70.32 N:600000 N:600001'}
G[600037]={'554:59.25,49.48 N:600000 N:600001'}
G[600038]={'554:69.46,33.09 N:600000 N:600002'}
G[600039]={'554:54.02,78.20 N:600000 N:600002'}
G[600040]={'554:47,26 N:600000'}
G[600041]={'554:61.69,88.53 N:600000'}
G[700000]={'23:74.29,53.24 A:90369'}
G[700001]={'22:51.62,81.85 A:108776'}
G[700002]={'22:52.11,83.19 A:108776'}
G[700003]={'747:45.65,50.03 A:114562'}
G[700004]={'630:49.21,16.09 A:90383'}
G[700005]={'630:49.10,16.69 A:89978'}
G[700006]={'84:60.71,70.69 A:77789'}
G[700007]={'581:32.57,49.68 A:88024'}
G[700008]={'630:51.49,16.06 A:114562'}
G[700009]={'627:37.32,43.85 A:77789'}
G[700010]={'627:71.58,44.60 A:77789'}
G[700011]={'630:42.17,43.50 A:101943'}
G[700012]={'747:67.28,75.72 A:103778'}
G[700013]={'84:40.17,77.84 A:114562'}
G[700014]={'627:57.72,48.55 A:101061'}
G[700015]={'747:60.20,52.02 A:112953'}
G[700016]={'634:49.80,32.62 A:107498'}
G[700017]={'653:41.73,79.78 A:96286'}
G[700018]={'543:57.05,35.83 A:86264'}
G[700019]={'581:28.90,40.02 A:91017'}
G[700020]={'581:36.17,62.62 A:77377'}
G[700021]={'535:69.28,46.46 A:79724'}
G[700022]={'525:37.49,18.28 A:88437'}
G[700023]={'720:56.47,54.66 A:103025'}
G[700024]={'627:0.00,0.00 A:112130'}
G[700025]={'246:67.21,53.79 A:16808'}
G[700026]={'650:43.42,33.55 A:95290'}
G[700027]={'534:25.53,32.42 A:90265'}
G[700028]={'265:83.76,73.35 A:17942'}
G[700029]={'650:46.73,29.41 A:95290'}
G[700030]={'659:52.51,61.62 A:95799'}
G[700031]={'543:47.82,74.39 A:81617'}
G[700032]={'390:85.74,63.53 A:77789'}
G[700033]={'659:65.27,42.79 A:95753'}
G[700034]={'87:70.01,20.61 A:5637'}
G[700035]={'543:42.46,77.72 A:81575'}
G[700036]={'439:76.97,37.18 A:59704'}
G[700037]={'882:53.48,90.73 A:127151'}
G[700038]={'543:48.06,94.21 A:81751'}
G[700039]={'439:76.97,37.18 A:59822'}
G[700040]={'440:0.00,0.00 A:59479'}
G[700041]={'650:53.23,64.04 A:93846'}
G[700042]={'641:38.16,65.26 A:91847'}
G[700043]={'581:38.31,40.28 A:83858'}
G[700044]={'650:52.28,65.92 A:93846'}
G[700045]={'440:0.00,0.00 A:59074'}
G[700046]={'436:0.00,0.00 A:64827'}
G[700047]={'650:53.25,64.43 A:97407'}
G[700048]={'436:48.86,76.88 A:64841'}
G[700049]={'75:41.94,49.29 A:15192'}
G[700050]={'440:0.00,0.00 A:64361'}
G[700051]={'431:0.00,0.00 A:64738'}
G[700052]={'477:0.00,0.00 A:59080'}
G[700053]={'273:49.01,72.43 A:15608'}
G[700054]={'445:83.76,54.66 A:62236'}
G[700055]={'317:49.96,21.37 A:10808'}
G[700056]={'84:48.97,87.21 A:77789'}
G[700057]={'446:21.16,24.50 A:56541'}
G[700058]={'641:44.36,48.34 A:92954'}
G[700059]={'317:29.15,41.43 A:11032'}
G[700060]={'650:50.89,36.57 A:94068'}
G[700061]={'317:21.18,81.32 A:10813'}
G[700062]={'444:72.39,47.48 A:56884'}
G[700063]={'535:47.81,90.26 A:77426'}
G[700064]={'641:40.56,44.33 A:92850'}
G[700065]={'51:74.69,49.14 A:46424'}
G[700066]={'51:77.52,46.19 A:46623'}
G[700067]={'444:71.08,48.14 A:64387'}
G[700068]={'642:43.21,82.18 641:40.56,44.32 A:93029'}
G[700069]={'459:63.33,79.51 A:64517'}
G[700070]={'459:0.00,0.00 A:64517'}
G[700071]={'581:55.71,72.47 A:85777'}
G[700072]={'641:39.48,42.12 A:92987'}
G[700073]={'436:0.00,0.00 A:64838'}
G[700074]={'431:0.00,0.00 A:64764'}
G[700075]={'535:82.88,27.60 A:79335'}
G[700076]={'641:39.46,42.16 A:93027'}
G[700077]={'641:40.15,42.84 A:95247'}
G[700078]={'750:44.57,51.04 A:93826'}
G[700079]={'535:61.31,41.10 A:75968'}
G[700080]={'534:49.59,42.39 A:91764'}
G[700081]={'542:41.56,16.52 A:79598'}
G[700082]={'634:81.50,61.70 A:98498'}
G[700083]={'550:43.55,38.19 A:72571'}
G[700084]={'436:49.01,76.84 A:64842'}
G[700085]={'634:45.81,68.95 A:91202'}
G[700086]={'51:76.68,41.44 A:46656'}
G[700087]={'220:63.80,86.97 A:5709'}
G[700088]={'230:38.90,8.01 A:1131474'}
G[700089]={'310:67.46,72.17 A:47006'}
G[700090]={'311:0.00,0.00 A:47006'}
G[700091]={'313:57.90,41.66 A:47006'}
G[700092]={'313:0.00,0.00 A:47006'}
G[700093]={'393:0.00,0.00 A:77789'}
G[700094]={'499:0.00,0.00 A:70752'}
G[700095]={'36:18.32,25.11 A:14387'}
G[700096]={'650:42.64,63.37 A:95013'}
G[700097]={'650:39.43,64.01 A:96124'}
G[700098]={'650:42.66,9.89 A:97919'}
G[700099]={'347:35.78,82.66 A:17307'}
G[700100]={'129:18.89,51.44 A:26798'}
G[700101]={'393:35.12,58.13 A:77789'}
G[700102]={'650:49.57,15.96 A:98067'}
G[700103]={'129:34.70,66.48 A:26723'}
G[700104]={'581:54.30,16.58 A:77733'}
G[700105]={'184:44.37,22.57 A:36658'}
G[700106]={'543:72.33,43.76 A:86260'}
G[700107]={'750:54.17,64.31 A:93826'}
G[700108]={'140:50.53,16.22 A:27978'}
G[700109]={'750:73.92,75.66 A:98825'}
G[700110]={'542:31.96,25.54 A:82123'}
G[700111]={'750:51.31,54.25 A:98825'}
G[700112]={'616:0.00,0.00 A:77120'}
G[700113]={'649:45.55,62.07 A:97558'}
G[700114]={'750:56.02,78.42 A:108017'}
G[700115]={'243:0.00,0.00 A:45850'}
G[700116]={'32:32.24,94.87 A:14387'}
G[700117]={'750:44.32,55.54 A:108017'}
G[700118]={'680:35.31,47.36 A:98312'}
G[700119]={'252:38.03,50.38 A:10299'}
G[700120]={'253:0.00,0.00 A:10299'}
G[700121]={'634:74.49,53.88 A:108030'}
G[700122]={'650:47.37,70.29 A:99153'}
G[700123]={'131:86.49,61.57 A:26527'}
G[700124]={'258:0.00,0.00 A:18473'}
G[700125]={'131:47.74,40.07 A:27915'}
G[700126]={'262:25.99,44.01 A:17882'}
G[700127]={'1161:68.17,21.97 895:73.84,25.09 A:121235'}
G[700128]={'634:63.47,64.67 A:1251571'}
G[700129]={'143:49.88,80.30 A:27658'}
G[700130]={'720:0.00,0.00 A:113686'}
G[700131]={'393:34.74,67.14 A:77789'}
G[700132]={'657:49.58,55.05 A:108069'}
G[700133]={'657:43.83,60.83 A:98957'}
G[700134]={'543:45.53,25.41 A:86577'}
G[700135]={'148:0.00,0.00 A:32867'}
G[700136]={'750:44.32,50.87 A:108434'}
G[700137]={'148:0.00,0.00 A:1194555'}
G[700138]={'148:0.00,0.00 A:33957'}
G[700139]={'720:57.64,44.53 A:112407'}
G[700140]={'634:60.78,66.09 A:92764'}
G[700141]={'720:57.64,44.53 A:113686'}
G[700142]={'721:0.00,0.00 A:95240'}
G[700143]={'721:0.00,0.00 A:98613'}
G[700144]={'534:10.69,54.64 A:90482'}
G[700145]={'534:42.91,36.19 A:89936'}
G[700146]={'393:33.04,63.86 A:77789'}
G[700147]={'149:15.48,88.83 A:33957'}
G[700148]={'273:50.44,58.62 A:17881'}
G[700149]={'534:24.34,35.66 A:89686'}
G[700150]={'149:15.59,89.47 A:1194555'}
G[700151]={'168:53.87,63.04 A:31134'}
G[700152]={'650:50.11,43.13 A:94986'}
G[700153]={'581:52.58,14.89 A:77733'}
G[700154]={'650:45.70,39.14 A:95410'}
G[700155]={'168:51.08,59.48 A:31134'}
G[700156]={'157:62.45,48.58 A:55564'}
G[700157]={'132:87.09,72.81 A:55658'}
G[700158]={'137:42.65,53.31 A:26861'}
G[700159]={'183:64.19,90.87 A:37597'}
G[700160]={'183:44.02,12.64 A:38160'}
G[700161]={'186:40.14,21.49 A:38316'}
G[700162]={'185:44.95,76.59 A:37221'}
G[700163]={'750:45.88,54.91 A:96084'}
G[700164]={'185:41.87,62.37 A:38113'}
G[700165]={'185:76.09,76.83 A:36955'}
G[700166]={'649:60.74,42.60 A:91575'}
G[700167]={'138:0.00,0.00 A:28923'}
G[700168]={'601:0.00,0.00 A:76266'}
G[700169]={'138:0.00,0.00 A:56027'}
G[700170]={'650:49.22,36.59 A:95410'}
G[700171]={'534:30.36,71.91 A:90286'}
G[700172]={'750:55.62,62.37 A:108434'}
G[700173]={'550:77.62,60.49 A:79899'}
G[700174]={'649:59.74,34.96 A:91575'}
G[700175]={'630:47.95,8.45 A:90985'}
G[700176]={'581:48.87,59.25 A:83858'}
G[700177]={'226:0.00,0.00 A:44560'}
G[700178]={'227:22.26,66.78 A:6235'}
G[700179]={'649:63.15,35.61 A:91575'}
G[700180]={'228:0.00,0.00 A:44563'}
G[700181]={'219:30.34,39.11 A:7795'}
G[700182]={'649:68.97,27.23 A:91575'}
G[700183]={'534:33.19,35.80 A:91313'}
G[700184]={'319:0.00,0.00 A:15379'}
G[700185]={'300:28.21,23.56 A:74367'}
G[700186]={'300:37.53,71.33 A:74888'}
G[700187]={'534:37.87,71.99 A:92636'}
G[700188]={'534:28.36,73.86 A:90425'}
G[700189]={'882:49.37,41.62 A:126899'}
G[700190]={'393:51.84,66.53 A:77789'}
G[700191]={'649:43.59,65.64 A:91948'}
G[700192]={'534:61.13,36.25 A:90517'}
G[700193]={'649:44.05,64.88 A:97558'}
G[700194]={'274:28.91,48.14 A:18723'}
G[700195]={'348:13.05,49.85 A:55007'}
G[700196]={'534:44.70,43.08 A:91721'}
G[700197]={'349:60.93,24.28 A:24822'}
G[700198]={'534:43.99,43.75 A:90066'}
G[700199]={'349:94.05,35.48 A:24848'}
G[700200]={'581:37.46,61.49 A:77377'}
G[700201]={'534:50.84,45.93 A:91760'}
G[700202]={'291:36.35,61.09 A:47162'}
G[700203]={'292:60.90,44.38 A:47739'}
G[700204]={'320:59.01,68.38 A:15503'}
G[700205]={'319:0.00,0.00 A:15727'}
G[700206]={'154:52.89,20.39 A:55738'}
G[700207]={'136:0.00,0.00 A:30871'}
G[700208]={'136:0.00,0.00 A:56072'}
G[700209]={'550:50.43,70.58 A:81054'}
G[700210]={'650:38.99,51.00 A:99481'}
G[700211]={'550:47.32,57.93 A:81216'}
G[700212]={'581:52.00,44.95 A:84524'}
G[700213]={'534:46.34,46.45 A:91721'}
G[700214]={'427:65.58,41.85 A:658'}
G[700215]={'634:46.61,49.76 A:93166'}
G[700216]={'427:62.54,20.23 A:37087'}
G[700217]={'550:46.46,34.54 A:72571'}
G[700218]={'249:54.89,34.25 A:77789'}
G[700219]={'27:54.07,50.90 A:32639'}
G[700220]={'534:17.42,41.55 A:90312'}
G[700221]={'537:36.61,46.47 A:79540'}
G[700222]={'273:56.58,70.82 A:17881'}
G[700223]={'723:50.56,70.58 A:94902'}
G[700224]={'543:56.57,45.08 A:88279'}
G[700225]={'300:44.51,59.53 A:74888'}
G[700226]={'301:21.33,33.07 A:4421'}
G[700227]={'627:95.38,66.46 A:109196'}
G[700228]={'534:48.27,48.48 A:91721'}
G[700229]={'535:68.94,77.54 A:79231'}
G[700230]={'279:60.80,69.52 A:3674'}
G[700231]={'213:33.86,80.73 A:61823'}
G[700232]={'720:0.00,0.00 A:103025'}
G[700233]={'534:57.60,59.17 A:77789'}
G[700234]={'720:0.00,0.00 A:95238'}
G[700235]={'534:39.31,38.79 A:89857'}
G[700236]={'238:0.00,0.00 A:14358'}
G[700237]={'235:28.35,55.54 A:14338'}
G[700238]={'650:39.15,34.55 A:95256'}
G[700239]={'235:49.17,78.19 A:14325'}
G[700240]={'235:69.61,75.75 A:14326'}
G[700241]={'650:38.47,35.36 A:93836'}
G[700242]={'235:62.19,66.08 A:14322'}
G[700243]={'526:28.74,45.00 A:78222'}
G[700244]={'703:52.67,83.39 A:95676'}
G[700245]={'634:36.40,51.81 A:89829'}
G[700246]={'630:62.78,49.72 A:109349'}
G[700247]={'587:15.87,69.44 A:77789'}
G[700248]={'587:52.99,41.26 A:79862'}
G[700249]={'587:37.72,70.49 A:79892'}
G[700250]={'587:51.68,59.47 A:88026'}
G[700251]={'630:47.26,37.94 A:88084'}
G[700252]={'630:60.81,59.57 A:89283'}
G[700253]={'587:51.68,59.47 A:88000'}
G[700254]={'587:18.95,65.69 A:77789'}
G[700255]={'534:14.27,56.82 A:92873'}
G[700256]={'630:50.20,50.28 A:88873'}
G[700257]={'534:12.75,56.80 A:90482'}
G[700258]={'624:54.10,33.84 A:81765'}
G[700259]={'709:52.49,57.84 A:104744'}
G[700260]={'630:47.85,52.00 A:1239120'}
G[700261]={'630:50.02,62.48 A:90109'}
G[700262]={'534:54.89,24.03 A:92397'}
G[700263]={'632:75.38,73.33 A:90109'}
G[700264]={'630:50.97,56.88 A:90109'}
G[700265]={'641:56.43,53.84 A:92788'}
G[700266]={'503:59.93,75.67 A:70751'}
G[700267]={'630:53.20,45.51 A:88086'}
G[700268]={'630:54.91,43.52 A:107447'}
G[700269]={'543:48.87,32.67 A:85124'}
G[700270]={'630:53.63,39.83 A:88086'}
G[700271]={'630:52.95,36.97 A:89849'}
G[700272]={'587:40.01,53.69 A:114562'}
G[700273]={'630:52.95,36.97 A:89660'}
G[700274]={'643:60.15,19.13 A:91223'}
G[700275]={'641:62.74,71.71 A:95599'}
G[700276]={'630:51.01,36.54 A:89661'}
G[700277]={'657:49.05,52.49 A:108069'}
G[700278]={'641:49.87,88.16 A:91223'}
G[700279]={'630:51.13,36.74 A:107334'}
G[700280]={'641:63.73,71.79 A:95726'}
G[700281]={'650:48.01,72.96 A:108069'}
G[700282]={'641:48.86,81.57 A:91223'}
G[700283]={'641:42.67,58.05 A:32639'}
G[700284]={'641:59.21,32.62 A:113646'}
G[700285]={'641:42.35,53.42 A:92954'}
G[700286]={'634:33.79,50.81 A:89829'}
G[700287]={'636:77.20,47.54 A:92414'}
G[700288]={'636:31.15,67.81 A:92415'}
G[700289]={'634:28.13,59.24 A:92415'}
G[700290]={'634:29.29,57.30 A:92415'}
G[700291]={'525:30.07,40.37 A:75186'}
G[700292]={'650:48.29,72.32 A:108014'}
G[700293]={'526:0.00,0.00 A:75177'}
G[700294]={'525:28.00,35.67 A:75177'}
G[700295]={'534:42.01,38.63 A:89777'}
G[700296]={'527:0.00,0.00 A:70860'}
G[700297]={'534:41.71,38.29 A:89857'}
G[700298]={'634:49.05,42.66 A:96129'}
G[700299]={'649:46.38,64.80 A:97558'}
G[700300]={'525:25.37,36.54 A:81678'}
G[700301]={'86:49.95,59.10 A:3216'}
G[700302]={'86:53.01,64.33 A:77789'}
G[700303]={'86:52.05,77.38 A:77789'}
G[700304]={'86:41.43,60.83 A:77789'}
G[700305]={'84:41.27,78.84 A:114550'}
G[700306]={'85:48.28,64.53 A:114561'}
G[700307]={'10:49.96,59.09 A:104900'}
G[700308]={'10:49.44,58.35 A:32641'}
G[700309]={'71:44.81,60.66 A:94589'}
G[700310]={'76:41.92,60.38 A:97843'}
G[700311]={'86:53.17,74.41 A:77789'}
G[700312]={'76:40.57,56.69 A:99370'}
G[700313]={'85:48.28,64.53 A:43929'}
G[700314]={'86:42.93,51.86 A:114561'}
G[700315]={'627:43.49,55.98 A:77789'}
G[700316]={'641:73.22,42.63 A:107392'}
G[700317]={'641:73.83,38.43 A:107392'}
G[700318]={'627:44.25,37.24 A:77789'}
G[700319]={'630:64.51,58.59 A:89283'}
G[700320]={'650:38.91,43.67 A:97846'}
G[700321]={'654:30.26,67.70 A:97064'}
G[700322]={'654:48.07,36.16 A:97064'}
G[700323]={'680:26.37,44.90 A:100014'}
G[700324]={'630:36.35,51.47 A:103176'}
G[700325]={'630:43.41,43.36 A:32639'}
G[700326]={'680:37.67,47.78 A:101848'}
G[700327]={'627:60.92,44.73 A:77789'}
G[700328]={'680:21.45,30.62 A:103570'}
G[700329]={'680:36.08,47.27 A:98555'}
G[700330]={'680:36.53,46.96 A:102600'}
G[700331]={'75:42.68,39.59 A:19935'}
G[700332]={'680:30.19,31.05 A:104224'}
G[700333]={'680:26.18,31.32 A:103569'}
G[700334]={'680:26.21,31.30 A:103571'}
G[700335]={'393:52.72,57.02 A:77789'}
G[700336]={'273:55.32,73.47 A:17881'}
G[700337]={'627:56.73,42.51 A:77789'}
G[700338]={'630:60.41,42.37 A:89024'}
G[700339]={'630:55.72,44.51 A:88087'}
G[700340]={'630:55.34,45.99 A:88086'}
G[700341]={'631:62.17,84.79 A:91459'}
G[700342]={'631:55.11,51.68 A:89849'}
G[700343]={'631:26.85,47.28 A:107334'}
G[700344]={'631:64.51,30.00 A:89660'}
G[700345]={'630:60.18,40.03 A:89025'}
G[700346]={'650:35.96,65.75 A:97666'}
G[700347]={'650:59.02,65.47 A:97666'}
G[700348]={'680:43.49,41.52 A:99789'}
G[700349]={'680:38.91,53.81 A:98555'}
G[700350]={'680:45.29,27.77 A:113573'}
G[700351]={'641:63.10,67.25 A:95599'}
G[700352]={'641:63.24,73.95 A:95599'}
G[700353]={'680:36.32,45.07 A:98548'}
G[700354]={'550:40.00,13.09 A:83848'}
G[700355]={'680:40.11,31.17 A:112910'}
G[700356]={'627:42.23,28.38 A:90463'} -- in 7.2 we have 1014[10]:42.68,28.48
G[700357]={'690:58.70,83.87 A:112067'}
G[700358]={'627:59.03,43.91 A:77789'}
G[700359]={'630:49.98,41.40 A:88099'}
G[700360]={'650:40.48,30.71 A:95310'}
G[700361]={'680:22.37,41.00 A:105623'}
G[700362]={'680:36.04,19.67 A:1252260'}
G[700363]={'680:21.39,42.35 A:107126'}
G[700364]={'687:42.45,52.07 A:113571'}
G[700365]={'680:30.07,10.35 A:101766'}
G[700366]={'650:42.95,56.34 A:94688'}
G[700367]={'630:46.33,10.49 A:90985'}
G[700368]={'680:61.38,55.11 A:108870'}
G[700369]={'680:44.93,73.59 A:108096'}
G[700370]={'641:46.60,77.03 A:91598'}
G[700371]={'684:39.30,36.45 A:105756'}
G[700372]={'641:46.38,84.50 A:91288'}
G[700373]={'685:45.16,56.85 A:105623'}
G[700374]={'650:50.24,27.06 A:104328'}
G[700375]={'680:60.69,56.55 A:108872'}
G[700376]={'634:46.35,20.51 A:103446'}
G[700377]={'680:30.54,33.77 A:104224'}
G[700378]={'793:41.60,50.42 A:113355'}
G[700379]={'684:42.32,60.85 A:105554'}
G[700380]={'684:0.00,0.00 A:105756'}
G[700381]={'634:42.02,63.56 A:91423'}
G[700382]={'680:19.60,39.79 A:105739'}
G[700383]={'680:33.21,79.67 A:106339'}
G[700384]={'650:46.08,46.28 A:94386'}
G[700385]={'534:38.52,39.24 A:89777'}
G[700386]={'534:50.64,42.14 A:89754'}
G[700387]={'680:80.31,70.48 A:99502'}
G[700388]={'731:18.57,60.47 A:101476'}
G[700389]={'393:48.57,46.04 A:77789'}
G[700390]={'581:37.29,59.90 A:77377'}
G[700391]={'581:29.06,40.02 A:91014'}
G[700392]={'627:74.45,48.19 A:77789'}
G[700393]={'641:59.11,81.32 A:108259'}
G[700394]={'680:61.28,57.19 A:109180'}
G[700395]={'641:70.20,57.07 A:92326'}
G[700396]={'627:47.33,67.00 A:77789'}
G[700397]={'650:53.40,52.39 A:101644'}
G[700398]={'534:17.45,58.10 A:92873'}
G[700399]={'641:66.39,50.82 A:95138'}
G[700400]={'650:24.71,56.37 A:103446'}
G[700401]={'534:41.95,36.86 A:89810'}
G[700402]={'393:48.13,49.62 A:77789'}
G[700403]={'703:50.57,82.80 A:95676'}
G[700404]={'634:61.20,93.00 A:103245'}
G[700405]={'534:27.20,30.12 A:89683'}
G[700406]={'641:62.69,38.67 A:113646'}
G[700407]={'534:55.86,76.95 A:89746'}
G[700408]={'627:0.00,0.00 A:1246466'}
G[700409]={'634:67.58,57.19 A:108927'}
G[700410]={'634:39.11,67.58 A:100446'}
G[700411]={'680:60.10,54.40 A:108875'}
G[700412]={'793:40.35,53.01 A:113361'}
G[700413]={'682:42.38,47.14 A:99765'}
G[700414]={'682:53.45,76.59 A:99765'}
G[700415]={'680:33.99,49.21 A:77789'}
G[700416]={'680:47.88,82.94 A:107632'}
G[700417]={'534:26.96,32.48 A:89686'}
G[700418]={'393:47.04,46.61 A:77789'}
G[700419]={'534:47.34,48.23 A:90066'}
G[700420]={'581:47.18,54.99 A:83858'}
G[700421]={'641:54.32,81.41 A:91354'}
G[700422]={'535:44.14,43.10 A:84871'}
G[700423]={'641:63.37,67.09 A:95726'}
G[700424]={'680:57.18,60.76 A:107253'}
G[700425]={'581:54.45,14.13 A:85708'}
G[700426]={'680:43.26,62.23 A:107632'}
G[700427]={'649:45.17,67.91 A:91948'}
G[700428]={'680:37.65,58.73 A:98555'}
G[700429]={'650:43.70,29.55 A:95290'}
G[700430]={'685:40.89,35.06 A:105739'}
G[700431]={'650:42.92,56.08 A:94691'}
G[700432]={'581:55.42,15.26 A:77733'}
G[700433]={'550:43.35,35.38 A:72571'}
G[700434]={'634:60.27,54.85 A:107803'}
G[700435]={'634:63.30,53.11 A:107803'}
G[700436]={'641:42.47,58.74 A:91847'}
G[700437]={'650:40.79,34.57 A:95310'}
G[700438]={'671:70.03,77.21 A:95852'}
G[700439]={'747:44.52,51.48 A:103778'}
G[700440]={'641:66.82,75.66 A:109631'}
G[700441]={'630:61.01,50.58 A:109349'}
G[700442]={'643:54.96,60.52 A:91645'}
G[700443]={'641:61.68,73.40 A:95599'}
G[700444]={'643:60.46,17.54 A:91223'}
G[700445]={'680:63.14,59.21 A:109180'}
G[700446]={'636:36.45,57.36 A:90903'}
G[700447]={'636:69.41,55.60 A:92415'}
G[700448]={'636:72.78,52.35 A:92415'}
G[700449]={'650:41.03,45.54 A:97094'}
G[700450]={'634:50.47,31.55 A:107469'}
G[700451]={'703:51.11,88.04 A:95676'}
G[700452]={'650:43.47,10.88 A:97933'}
G[700453]={'634:53.85,29.89 A:107469'}
G[700454]={'705:0.00,0.00 A:95676'}
G[700455]={'634:44.19,29.64 A:99223'}
G[700456]={'650:51.86,42.38 A:94986'}
G[700457]={'634:44.60,65.58 A:108526'}
G[700458]={'630:39.96,48.46 A:103176'}
G[700459]={'634:81.46,51.45 A:98498'}
G[700460]={'630:53.43,30.67 A:90313'}
G[700461]={'747:32.55,53.93 A:101195'}
G[700462]={'680:31.31,23.47 A:101783'}
G[700463]={'630:67.73,27.17 A:92450'}
G[700464]={'680:35.85,55.63 A:98555'}
G[700465]={'630:48.89,35.19 A:88084'}
G[700466]={'634:33.15,36.18 A:91458'}
G[700467]={'650:42.25,27.32 A:95310'}
G[700468]={'650:40.80,34.47 A:95270'}
G[700469]={'653:39.71,82.58 A:96286'}
G[700470]={'650:44.13,32.08 A:95290'}
G[700471]={'650:49.30,24.18 A:95290'}
G[700472]={'650:43.96,23.19 A:95392'}
G[700473]={'650:47.64,32.66 A:96410'}
G[700474]={'650:44.80,23.84 A:95799'}
G[700475]={'659:55.96,77.89 A:95753'}
G[700476]={'634:43.02,44.88 A:96229'}
G[700477]={'747:52.49,42.51 A:113686'}
G[700478]={'630:53.08,64.42 A:89051'}
G[700479]={'680:35.07,51.45 A:111197'}
G[700480]={'680:81.04,61.12 A:100998'}
G[700481]={'711:0.00,0.00 A:1258979'}
G[700482]={'641:56.96,36.97 A:111981'}
G[700483]={'685:53.70,39.75 A:105756'}
G[700484]={'641:36.92,58.34 A:102546'}
G[700485]={'642:31.24,65.73 A:94974'}
G[700486]={'642:23.91,41.86 A:93027'}
G[700487]={'630:65.19,56.52 A:89284'}
G[700488]={'685:0.00,0.00 A:105756'}
G[700489]={'634:46.56,45.52 A:96129'}
G[700490]={'634:39.60,65.02 A:100446'}
G[700491]={'715:43.27,50.21 A:98008'}
G[700492]={'680:40.35,79.74 A:110949'}
G[700493]={'634:43.75,68.54 A:91486'}
G[700494]={'634:43.78,68.21 A:91204'}
G[700495]={'750:47.44,52.12 A:93826'}
G[700496]={'634:45.00,69.51 A:100446'}
G[700497]={'650:37.88,61.92 A:99406'}
G[700498]={'634:49.12,59.93 A:97091'}
G[700499]={'641:22.76,67.02 A:111459'}
G[700500]={'641:66.45,38.60 A:97337'}
G[700501]={'641:22.10,65.53 A:111460'}
G[700502]={'715:31.66,54.75 A:98008'}
G[700503]={'630:60.98,23.08 A:91308'}
G[700504]={'715:39.74,56.38 A:98008'}
G[700505]={'627:0.00,0.00 A:1246465'}
G[700506]={'650:37.34,58.19 A:95916'}
G[700507]={'680:29.42,53.38 A:98555'}
G[700508]={'504:34.63,89.51 A:67992'}
G[700509]={'684:27.92,52.46 A:105756'}
G[700510]={'630:46.06,14.40 A:106297'}
G[700511]={'680:22.49,37.71 A:113102'}
G[700512]={'680:27.62,73.50 A:98969'}
G[700513]={'630:38.83,45.00 A:103176'}
G[700514]={'680:30.36,39.89 A:113195'}
G[700515]={'680:52.75,31.40 A:101581'}
G[700516]={'680:32.02,78.46 A:108314'}
G[700517]={'715:31.75,61.46 A:98008'}
G[700518]={'650:37.67,59.53 A:95866'}
G[700519]={'634:67.75,43.22 A:108927'}
G[700520]={'655:47.33,54.56 A:95916'}
G[700521]={'680:51.90,34.91 A:101825'}
G[700522]={'656:44.46,27.65 A:95881'}
G[700523]={'650:39.28,70.49 A:102274'}
G[700524]={'680:31.94,17.45 A:101783'}
G[700525]={'680:59.75,34.25 A:101825'}
G[700526]={'715:41.85,47.71 A:98008'}
G[700527]={'750:55.41,63.33 A:93826'}
G[700528]={'650:53.03,39.48 A:94983'}
G[700529]={'644:0.00,0.00 A:91223'}
G[700530]={'641:52.72,80.03 A:91474'}
G[700531]={'680:30.62,13.47 A:102242'}
G[700532]={'680:27.33,86.46 A:101878'}
G[700533]={'641:62.46,36.62 A:112052'}
G[700534]={'641:46.47,86.32 A:91288'}
G[700535]={'715:30.33,39.95 A:98008'}
G[700536]={'680:15.24,52.35 A:107302'}
G[700537]={'680:37.84,75.30 A:99584'}
G[700538]={'634:39.91,31.31 A:111206'}
G[700539]={'634:60.72,42.43 A:105502'}
G[700540]={'634:37.08,66.93 A:106568'}
G[700541]={'634:57.98,63.47 A:94856'}
G[700542]={'680:34.42,53.56 A:98555'}
G[700543]={'393:47.94,40.40 A:77789'}
G[700544]={'581:47.38,34.90 A:77377'}
G[700545]={'581:31.25,33.33 A:81492'}
G[700546]={'641:54.03,87.84 A:91354'}
G[700547]={'650:53.00,35.71 A:95266'}
G[700548]={'643:61.75,59.91 A:91645'}
G[700549]={'680:25.67,58.64 A:101878'}
G[700550]={'650:46.58,31.07 A:96410'}
G[700551]={'649:43.92,63.73 A:91948'}
G[700552]={'650:50.12,39.76 A:94983'}
G[700553]={'650:39.45,14.21 A:108529'}
G[700554]={'680:30.44,66.08 A:101878'}
G[700555]={'634:71.23,89.49 A:102170'}
G[700556]={'750:49.99,45.14 A:108017'}
G[700557]={'650:56.26,60.04 A:96590'}
G[700558]={'634:54.21,66.27 A:111291'}
G[700559]={'650:48.70,82.32 A:98957'}
G[700560]={'650:51.75,62.83 A:108185'}
G[700561]={'657:48.11,78.70 A:98957'}
G[700562]={'750:54.82,64.04 A:108434'}
G[700563]={'680:56.07,51.90 A:108872'}
G[700564]={'634:63.55,64.59 A:94856'}
G[700565]={'680:29.71,88.00 A:101878'}
G[700566]={'641:52.75,83.05 A:91474'}
G[700567]={'641:53.74,55.94 A:92697'}
G[700568]={'680:34.24,73.93 A:103437'}
G[700569]={'680:17.41,37.95 A:107126'}
G[700570]={'641:63.70,47.31 A:93205'}
G[700571]={'680:35.83,70.76 A:103437'}
G[700572]={'641:62.46,36.94 A:93111'}
G[700573]={'641:59.84,55.14 A:93157'}
G[700574]={'747:39.21,32.68 A:106442'}
G[700575]={'642:43.26,80.92 A:92850'}
G[700576]={'641:44.24,51.97 A:92965'}
G[700577]={'648:49.20,51.21 A:93568'}
G[700578]={'227:68.16,62.43 A:6391'}
G[700579]={'227:24.88,67.08 A:6235'}
G[700580]={'634:41.81,43.05 A:96254'}
G[700581]={'647:0.00,0.00 A:93437'}
G[700582]={'63:71.25,74.08 A:12676'}
G[700583]={'646:98.49,57.22 A:77789'}
G[700584]={'194:62.85,77.69 A:34872'}
G[700585]={'175:41.94,24.38 A:35837'}
G[700586]={'291:41.01,60.08 A:47162'}
G[700587]={'627:38.97,30.11 A:77789'}
G[700588]={'320:59.31,68.05 A:15502'}
G[700589]={'94:34.23,58.55 A:15968'}
G[700590]={'1:40.75,17.64 A:77789'}
G[700591]={'627:58.23,45.23 A:98519'}
G[700592]={'672:33.30,70.56 A:93112'}
G[700593]={'634:44.88,36.99 A:107258'}
G[700594]={'319:0.00,0.00 A:15378'}
G[700595]={'1:40.27,17.09 A:24499'}
G[700596]={'279:16.41,46.45 A:3653'}
G[700597]={'310:28.28,67.59 A:4278'}
G[700598]={'672:42.19,49.05 A:96400'}
G[700599]={'672:41.40,40.86 A:93115'}
G[700600]={'213:32.80,78.34 A:61716'}
G[700601]={'672:56.15,43.43 A:93716'}
G[700602]={'647:57.70,59.57 A:109788'}
G[700603]={'213:31.92,76.47 A:61724'}
G[700604]={'673:55.13,58.21 A:96441'}
G[700605]={'221:10.90,37.95 A:74476'}
G[700606]={'672:78.71,50.47 A:96277'}
G[700607]={'672:82.05,50.48 A:96277'}
G[700608]={'672:68.43,52.62 A:99759'}
G[700609]={'634:45.12,63.86 A:100446'}
G[700610]={'672:76.25,39.09 A:96277'}
G[700611]={'677:46.47,33.64 A:92782'}
G[700612]={'672:68.07,23.79 A:96278'}
G[700613]={'678:41.59,32.81 A:96682'}
G[700614]={'678:44.62,55.63 A:92782'}
G[700615]={'677:66.19,41.22 A:92782'}
G[700616]={'678:46.83,56.15 A:97225'}
G[700617]={'678:45.90,49.87 A:92782'}
G[700618]={'634:32.78,27.89 A:91569'}
G[700619]={'291:28.75,26.22 A:46906'}
G[700620]={'679:83.70,82.67 A:96666'}
G[700621]={'634:37.95,21.59 A:91158'}
G[700622]={'291:28.75,26.22 A:46889'}
G[700623]={'679:85.72,84.04 A:97978'}
G[700624]={'468:51.75,43.35 A:16502'}
G[700625]={'291:29.47,25.42 A:46902'}
G[700626]={'1:58.63,48.28 A:39270'}
G[700627]={'94:33.27,60.71 A:15968'}
G[700628]={'291:38.65,60.91 A:47162'}
G[700629]={'292:58.07,39.65 A:46906'}
G[700630]={'634:44.09,18.14 A:91158'}
G[700631]={'1:41.52,17.72 A:27216'}
G[700632]={'292:61.01,37.47 A:46902'}
G[700633]={'310:67.63,72.06 A:47293'}
G[700634]={'321:54.24,61.20 A:15727'}
G[700635]={'672:32.64,69.22 A:93115'}
G[700636]={'292:63.27,39.93 A:46889'}
G[700637]={'634:44.28,17.68 A:107840'}
G[700638]={'311:29.96,72.03 A:3887'}
G[700639]={'313:59.23,43.52 A:47293'}
G[700640]={'221:48.27,12.13 A:74409'}
G[700641]={'634:44.31,22.79 A:111206'}
G[700642]={'10:27.63,31.45 A:3278'}
G[700643]={'634:39.61,32.85 A:111206'}
G[700644]={'432:38.90,15.89 A:64738'}
G[700645]={'436:49.14,70.07 A:64841'}
G[700646]={'226:75.98,62.99 A:7361'}
G[700647]={'226:0.00,0.00 A:1175085'}
G[700648]={'227:63.28,67.61 A:6391'}
G[700649]={'634:46.52,44.45 A:35642'}
G[700650]={'634:33.96,54.24 A:90899'}
G[700651]={'636:26.74,67.18 A:92415'}
G[700652]={'627:68.29,45.37 A:101527'}
G[700653]={'703:52.12,81.11 A:95676'}
G[700654]={'634:45.72,70.81 A:91202'}
G[700655]={'634:66.70,62.32 A:98955'}
G[700656]={'634:41.42,66.66 A:91202'}
G[700657]={'649:62.24,43.39 A:93377'}
G[700658]={'747:57.38,46.85 A:107026'}
G[700659]={'649:45.40,62.94 A:91948'}
G[700660]={'680:26.32,41.30 A:35642'}
G[700661]={'649:44.58,56.39 A:97558'}
G[700662]={'634:68.01,47.98 A:108940'}
G[700663]={'627:40.24,29.08 A:93538'}
G[700664]={'634:69.08,46.14 A:108940'}
G[700665]={'715:36.59,60.54 A:98008'}
G[700666]={'715:41.35,55.69 A:98008'}
G[700667]={'655:47.99,40.56 A:95916'}
G[700668]={'651:50.74,38.29 A:98653'}
G[700669]={'630:54.28,36.64 A:110915 N:110915'}
G[700670]={'680:38.37,23.87 A:110915 N:110915'}
G[700671]={'680:28.72,80.23 A:99584'}
G[700672]={'680:28.26,18.76 A:101783'}
G[700673]={'680:38.20,90.09 A:103482'}
G[700674]={'680:28.53,82.69 A:99584'}
G[700675]={'684:35.68,59.86 A:105554'}
G[700676]={'641:54.50,71.91 A:112289'}
G[700677]={'641:44.29,76.31 A:91122'}
G[700678]={'627:40.36,24.09 A:93538'}
G[700679]={'790:0.00,0.00 A:99343'}
G[700680]={'790:0.00,0.00 A:97644'}
G[700681]={'790:0.00,0.00 A:108069'}
G[700682]={'790:0.00,0.00 A:96666'}
G[700683]={'790:0.00,0.00 A:115264'}
G[700684]={'790:0.00,0.00 A:97978'}
G[700685]={'650:40.83,32.81 A:95270'}
G[700686]={'790:0.00,0.00 A:97296'}
G[700687]={'790:0.00,0.00 A:99247'}
G[700688]={'790:0.00,0.00 A:96286'}
G[700689]={'790:0.00,0.00 A:102585'}
G[700690]={'790:0.00,0.00 A:93826'}
G[700691]={'790:0.00,0.00 A:100973'}
G[700692]={'790:0.00,0.00 A:101004'}
G[700693]={'657:42.09,33.10 A:108014'}
G[700694]={'790:0.00,0.00 A:96675'}
G[700695]={'790:0.00,0.00 A:111109'}
G[700696]={'641:38.88,81.68 A:103482'}
G[700697]={'790:0.00,0.00 A:96453'}
G[700698]={'747:60.14,52.10 A:113857'}
G[700699]={'750:40.69,47.19 A:106902'}
G[700700]={'650:34.43,23.14 A:115669'}
G[700701]={'627:57.87,58.63 A:77789'}
G[700702]={'650:49.98,25.84 A:96410'}
G[700703]={'650:27.31,44.85 A:101700'}
G[700704]={'685:57.69,42.31 A:105756'}
G[700705]={'650:53.19,70.04 A:93846'}
G[700706]={'630:39.16,38.74 A:103484'}
G[700707]={'790:0.00,0.00 A:108434'}
G[700708]={'790:0.00,0.00 A:93846'}
G[700709]={'650:50.66,42.42 A:94983'}
G[700710]={'634:72.36,61.03 A:94337'}
G[700711]={'634:61.23,69.43 A:92764'}
G[700712]={'747:47.12,50.08 A:77789'}
G[700713]={'650:46.58,46.12 A:94152'}
G[700714]={'650:52.02,54.37 A:102468'}
G[700715]={'747:52.76,51.70 A:77789'}
G[700716]={'641:68.60,38.22 A:97337'}
G[700717]={'685:48.90,43.44 A:107126'}
G[700718]={'627:38.11,32.20 A:77789'}
G[700719]={'685:49.96,42.65 A:105623'}
G[700720]={'790:0.00,0.00 A:102600'}
G[700721]={'684:35.22,54.33 A:108101'}
G[700722]={'680:36.88,46.61 A:97140'}
G[700723]={'680:44.90,73.47 A:106032'}
G[700724]={'680:22.71,36.10 A:35642'}
G[700725]={'685:34.94,64.62 A:105756'}
G[700726]={'627:45.51,59.07 A:101527'}
G[700727]={'680:26.14,31.32 A:103568'}
G[700728]={'680:28.69,33.03 A:104224'}
G[700729]={'680:31.02,28.60 A:103527'}
G[700730]={'680:45.71,35.52 A:98979'}
G[700731]={'680:44.51,26.23 A:113573'}
G[700732]={'627:45.21,57.27 A:77789'}
G[700733]={'650:55.76,56.45 A:97957'}
G[700734]={'630:35.05,6.68 A:115675'}
G[700735]={'682:53.60,36.77 A:1252107'}
G[700736]={'650:55.19,56.07 A:98273'}
G[700737]={'680:29.40,62.55 A:101868'}
G[700738]={'690:48.59,48.28 A:1252261'}
G[700739]={'680:78.57,56.41 A:103575'}
G[700740]={'690:48.62,49.55 A:112067'}
G[700741]={'690:48.59,44.85 A:112067'}
G[700742]={'680:74.49,56.68 A:103575'}
G[700743]={'680:31.46,23.13 A:101784'}
G[700744]={'680:29.51,15.24 A:102242'}
G[700745]={'680:50.57,78.25 A:109409'}
G[700746]={'685:68.32,51.13 A:105756'}
G[700747]={'680:24.08,19.13 A:112067'}
G[700748]={'680:21.15,48.48 A:105486'}
G[700749]={'680:19.41,41.97 A:105756'}
G[700750]={'680:31.49,50.05 A:115561'}
G[700751]={'634:50.13,58.31 A:107755'}
G[700752]={'634:64.07,51.76 A:93066'}
G[700753]={'680:60.19,43.69 A:100778'}
G[700754]={'641:38.24,62.87 A:94046'}
G[700755]={'641:67.02,44.24 A:94485'}
G[700756]={'630:52.34,28.62 A:90313'}
G[700757]={'687:44.42,70.41 A:103482'}
G[700758]={'680:61.76,44.46 A:100778'}
G[700759]={'630:34.96,33.80 A:107628'}
G[700760]={'680:58.14,40.77 A:103482'}
G[700761]={'627:51.74,38.19 A:77789'}
G[700762]={'680:30.17,35.49 A:104224'}
G[700763]={'680:24.30,45.61 A:100014'}
G[700764]={'680:31.82,46.79 A:110904'}
G[700765]={'627:53.87,39.67 A:77789'}
G[700766]={'680:49.11,71.02 A:109409'}
G[700767]={'680:49.77,36.93 A:110903'}
G[700768]={'680:59.80,47.63 A:104404'}
G[700769]={'680:36.06,82.29 A:99762'}
G[700770]={'703:0.00,0.00 A:1251991'}
G[700771]={'680:46.65,70.66 A:106032'}
G[700772]={'685:56.34,58.51 A:105756'}
G[700773]={'629:49.45,62.52 A:1251992'}
G[700774]={'680:35.78,78.93 A:99762'}
G[700775]={'680:25.02,44.10 A:105632'}
G[700776]={'750:41.26,49.37 A:104615'}
G[700777]={'641:57.22,57.52 A:92788'}
G[700778]={'750:42.04,46.28 A:104615'}
G[700779]={'731:0.00,0.00 A:1250548'}
G[700780]={'629:40.98,52.30 A:1246463'}
G[700781]={'634:46.40,56.26 A:97091'}
G[700782]={'713:0.00,0.00 A:106780'}
G[700783]={'747:52.42,50.33 A:103832'}
G[700784]={'680:51.20,83.56 A:109409'}
G[700785]={'634:57.68,49.85 A:116010'}
G[700786]={'634:40.61,69.06 A:91423'}
G[700787]={'630:47.04,53.58 A:116010'}
G[700788]={'641:52.10,56.68 A:116010'}
G[700789]={'641:58.00,89.31 A:110904'}
G[700790]={'680:39.52,51.17 A:101848'}
G[700791]={'680:51.16,80.09 A:109409'}
G[700792]={'682:52.14,70.75 A:99762'}
G[700793]={'641:55.98,57.71 A:110903'}
G[700794]={'680:34.84,81.26 A:99762'}
G[700795]={'680:34.66,76.77 A:116084'}
G[700796]={'680:23.19,44.54 A:105756'}
G[700797]={'680:22.34,36.90 A:105623'}
G[700798]={'680:28.58,80.50 A:101878'}
G[700799]={'680:20.38,44.79 A:105756'}
G[700800]={'680:36.47,46.61 A:107598'}
G[700801]={'680:52.10,79.16 A:114948'}
G[700802]={'680:36.35,45.45 A:111903'}
G[700803]={'680:27.06,70.17 A:103484'}
G[700804]={'680:33.34,68.43 A:99762'}
G[700805]={'687:58.72,17.22 A:103484'}
G[700806]={'680:52.09,79.19 A:115248'}
G[700807]={'680:75.89,50.14 A:103787'}
G[700808]={'680:52.19,80.47 A:114474'}
G[700809]={'627:41.25,42.96 A:77789'}
G[700810]={'682:40.48,48.35 A:99762'}
G[700811]={'680:44.22,53.89 A:116050'}
G[700812]={'680:47.89,75.73 A:113457'}
G[700813]={'680:54.89,72.87 A:115039'}
G[700814]={'680:40.54,53.09 A:114909'}
G[700815]={'680:40.54,53.09 A:114908'}
G[700816]={'680:59.11,42.31 A:100778'}
G[700817]={'680:55.30,44.92 A:112370'}
G[700818]={'634:67.99,39.99 A:105436'}
G[700819]={'641:54.98,53.57 A:110903'}
G[700820]={'680:41.22,21.40 A:115906'}
G[700821]={'634:43.27,44.03 A:100435'}
G[700822]={'750:40.45,50.01 A:106902'}
G[700823]={'634:42.50,48.68 A:100435'}
G[700824]={'630:36.85,6.70 A:115675'}
G[700825]={'641:32.22,56.56 A:111383'}
G[700826]={'650:44.55,8.56 A:97919'}
G[700827]={'650:55.48,85.67 A:116010'}
G[700828]={'634:49.81,57.73 A:97091'}
G[700829]={'650:35.72,22.22 A:115665'}
G[700830]={'650:35.05,22.01 A:115677'}
G[700831]={'641:68.03,71.33 A:109045'}
G[700832]={'680:62.47,55.98 A:109023'}
G[700833]={'650:23.87,42.65 A:101700'}
G[700834]={'697:32.45,48.54 A:98757'}
G[700835]={'750:40.66,53.34 A:106902'}
G[700836]={'634:71.67,42.51 A:108940'}
G[700837]={'1:58.43,43.54 A:39270'}
G[700838]={'630:46.16,44.53 A:110903'}
G[700839]={'650:35.50,36.74 A:115906'}
G[700840]={'650:43.29,71.33 A:95937'}
G[700841]={'641:67.46,38.70 A:97338'}
G[700842]={'680:21.57,42.54 A:105756'}
G[700843]={'650:30.06,27.67 A:101794'}
G[700844]={'627:59.02,47.14 A:101527'}
G[700845]={'685:36.20,32.40 A:114793'}
G[700846]={'680:48.26,34.46 A:110903'}
G[700847]={'650:54.92,54.28 A:97957'}
G[700848]={'641:60.26,35.41 A:113646'}
G[700849]={'650:44.44,7.99 A:97920'}
G[700850]={'184:0.00,0.00 A:36658'}
G[700851]={'137:0.00,0.00 A:30871'}
G[700852]={'630:45.55,14.93 A:90379'}
G[700853]={'630:46.15,17.12 A:106297'}
G[700854]={'641:67.81,32.70 A:106419'}
G[700855]={'634:41.99,67.23 A:91204'}
G[700856]={'641:42.41,58.62 A:101527'}
G[700857]={'627:45.36,69.95 A:101527'}
G[700858]={'114:34.40,25.20 A:52835'}
G[700859]={'370:0.00,0.00 A:53567'}
G[700860]={'641:61.74,87.73 A:103484'}
G[700861]={'630:35.96,8.73 A:115666'}
G[700862]={'634:48.68,46.02 A:96129'}
G[700863]={'634:47.61,36.21 A:107258'}
G[700864]={'539:32.43,25.31 A:77789'}
G[700865]={'641:56.29,53.46 A:92789'}
G[700866]={'634:50.74,61.43 A:107674'}
G[700867]={'650:49.73,40.88 A:97999'}
G[700868]={'654:30.66,64.95 A:97661'}
G[700869]={'626:0.00,0.00 A:32725'}
G[700870]={'654:48.12,39.72 A:97103'}
G[700871]={'650:49.06,13.75 A:98194'}
G[700872]={'650:46.76,48.32 A:94153'}
G[700873]={'393:57.97,49.91 A:43929'}
G[700874]={'630:63.12,29.92 A:110904'}
G[700875]={'750:52.02,49.26 A:104624'}
G[700876]={'630:66.75,44.88 A:110903'}
G[700877]={'641:59.04,82.41 A:108675'}
G[700878]={'750:49.56,61.95 A:104615'}
G[700879]={'733:0.00,0.00 A:99192'}
G[700880]={'634:34.13,45.67 A:103786'}
G[700881]={'717:64.69,49.96 A:103485'}
G[700882]={'750:64.69,49.96 A:103485'}
G[700883]={'634:62.25,93.48 A:104289'}
G[700884]={'634:60.35,51.17 A:101527'}
G[700885]={'641:42.87,75.60 A:91122'}
G[700886]={'750:39.49,45.24 A:106902'}
G[700887]={'650:40.55,65.43 A:94687'}
G[700888]={'650:37.46,64.30 A:96083'}
G[700889]={'629:46.28,55.73 A:90417'}
G[700890]={'747:31.08,4.74 A:106299'}
G[700891]={'Near641 A:118954'}
G[700892]={'641:39.03,51.35 A:118954'}
G[700893]={'641:39.21,61.81 A:118954'}
G[700894]={'100:85.30,50.12 A:116880'}
G[700895]={'627:57.26,44.06 A:101527'}
G[700896]={'731:0.00,0.00 A:101476'}
G[700897]={'778:0.00,0.00 A:106482'}
G[700898]={'627:58.42,45.26 A:101527'}
G[700899]={'646:52.16,54.95 A:118390'}
G[700900]={'629:57.95,72.70 A:116714'}
G[700901]={'634:45.12,37.00 A:99223'}
G[700902]={'646:56.46,27.34 A:116175'}
G[700903]={'646:59.79,27.44 A:116308'}
G[700904]={'634:77.46,80.20 A:115678'}
G[700905]={'627:46.92,39.16 A:116175'}
G[700906]={'646:59.79,27.44 A:116175'}
G[700907]={'747:45.35,40.53 A:101527'}
G[700908]={'80:69.42,47.99 A:120041'}
G[700909]={'646:31.39,32.51 A:120084'}
G[700910]={'198:39.86,43.98 A:119982'}
G[700911]={'641:53.85,83.01 A:91354'}
G[700912]={'646:54.65,48.27 A:119139'}
G[700913]={'641:69.35,34.13 A:106419'}
G[700914]={'715:37.86,37.73 A:101527'}
G[700915]={'646:74.90,26.12 A:117413'}
G[700916]={'747:52.59,46.82 A:101527'}
G[700917]={'646:52.63,47.10 A:117086'}
G[700918]={'646:52.21,64.85 A:120932'}
G[700919]={'646:78.64,40.60 A:115866'}
G[700920]={'646:52.24,69.57 A:120932'}
G[700921]={'646:42.80,77.69 A:118255'}
G[700922]={'641:39.47,89.29 A:102166'}
G[700923]={'641:56.36,44.42 A:93157'}
G[700924]={'646:43.52,41.39 A:117094'}
G[700925]={'646:50.24,44.07 A:118657'}
G[700926]={'646:79.16,37.76 A:117593'}
G[700927]={'646:52.39,46.57 A:118657'}
G[700928]={'646:40.75,53.55 A:119015'}
G[700929]={'646:59.30,27.93 A:118776'}
G[700930]={'634:72.90,46.94 A:93066'}
G[700931]={'630:28.63,45.94 A:107135'}
G[700932]={'634:78.69,61.17 A:98501'}
G[700933]={'634:78.69,61.17 A:98498'}
G[700934]={'646:66.93,42.18 A:121034'}
G[700935]={'641:56.27,78.50 A:115008'}
G[700936]={'499:0.00,0.00 A:68526'}
G[700937]={'646:41.33,80.89 A:118255'}
G[700938]={'646:45.04,52.30 A:119886'}
G[700939]={'646:41.20,16.69 A:121107'}
G[700940]={'646:65.15,28.69 A:118422'}
G[700941]={'646:58.82,45.42 A:117093'}
G[700942]={'630:58.30,43.83 A:91756'}
G[700943]={'646:48.21,40.96 A:118657'}
G[700944]={'646:29.22,60.74 A:120745'}
G[700945]={'646:81.46,48.20 A:115866'}
G[700946]={'630:55.61,43.29 A:88086'}
G[700947]={'630:61.51,58.35 A:89053'}
G[700948]={'747:53.45,49.20 A:101527'}
G[700949]={'646:58.85,32.54 A:117095'}
G[700950]={'680:25.64,61.35 A:106339'}
G[700951]={'646:55.54,27.06 A:117141'}
G[700952]={'630:56.56,65.74 A:117735'}
G[700953]={'634:35.79,70.33 A:110904'}
G[700954]={'650:51.23,49.71 A:104302'}
G[700955]={'634:29.43,50.03 A:90903'}
G[700956]={'634:38.02,32.76 A:110903'}
G[700957]={'634:35.81,70.15 A:110903'}
G[700958]={'646:48.25,68.97 A:115054'}
G[700959]={'646:74.90,27.10 A:120945'}
G[700960]={'680:33.25,76.77 A:108314'}
G[700961]={'646:57.60,28.02 A:118787'}
G[700962]={'646:46.22,50.51 A:119173'}
G[700963]={'646:49.81,78.58 A:118223'}
G[700964]={'646:59.44,27.13 A:118787'}
G[700965]={'646:40.97,80.81 A:118993'}
G[700966]={'646:48.36,70.89 A:115054'}
G[700967]={'646:68.29,30.50 A:118499'}
G[700968]={'646:29.40,63.03 A:120745'}
G[700969]={'646:45.67,38.75 A:118846'}
G[700970]={'646:30.05,66.25 A:118786'}
G[700971]={'646:45.67,38.75 A:118851'}
G[700972]={'747:40.58,26.48 A:111737'}
G[700973]={'646:42.58,42.46 A:118841'}
G[700974]={'646:53.70,57.45 A:32639'}
G[700975]={'646:68.88,28.64 A:118499'}
G[700976]={'899:0.00,0.00 A:122663'}
G[700977]={'646:42.94,18.05 A:118943'}
G[700978]={'646:41.88,34.13 A:111469'}
G[700979]={'747:54.70,54.96 A:101527'}
G[700980]={'898:56.50,66.08 A:122663'}
G[700981]={'646:42.62,66.73 A:115620'}
G[700982]={'646:31.27,56.35 A:120745'}
G[700983]={'646:28.14,56.46 A:120745'}
G[700984]={'646:43.15,79.43 A:118255'}
G[700985]={'641:43.46,60.53 A:92620'}
G[700986]={'641:38.15,60.38 A:91847'}
G[700987]={'630:64.84,27.14 A:32639'}
G[700988]={'680:33.80,74.31 A:116084'}
G[700989]={'630:55.48,44.96 A:91459'}
G[700990]={'680:43.23,29.87 A:110916'}
G[700991]={'680:33.73,76.10 A:99581'}
G[700992]={'680:41.17,18.39 A:111826'}
G[700993]={'680:32.84,66.55 A:106339'}
G[700994]={'634:48.74,79.00 A:91566'}
G[700995]={'646:78.62,41.28 A:117955'}
G[700996]={'634:61.79,90.84 A:103446'}
G[700997]={'680:43.45,29.43 A:32639'}
G[700998]={'646:38.81,80.59 A:118255'}
G[700999]={'646:52.45,42.83 A:116961'}
G[701000]={'646:82.83,52.61 A:115866'}
G[701001]={'646:28.89,56.95 A:118786'}
G[701002]={'646:53.79,67.19 A:120932'}
G[701003]={'646:51.66,75.26 A:118223'}
G[701004]={'646:81.17,30.66 A:32639'}
G[701005]={'630:57.13,73.13 A:115906'}
G[701006]={'892:35.28,45.84 A:120977'}
G[701007]={'830:56.75,67.67 A:121345'}
G[701008]={'831:40.17,23.59 A:120977'}
G[701009]={'830:37.38,53.55 A:122621'}
G[701010]={'831:48.86,44.15 A:122378'}
G[701011]={'886:32.71,55.51 A:121263'}	-- in Vindicaar above Antoran Wastes
G[701012]={'830:36.33,56.92 A:122621'}
G[701013]={'830:56.97,65.68 A:124595'}
G[701014]={'832:0.00,0.00 A:126307'}
G[701015]={'832:0.00,0.00 A:122378'}
G[701016]={'882:54.50,77.91 A:120533'}
G[701017]={'882:63.28,39.73 A:123413'}
G[701018]={'882:52.87,75.86 A:120533'}
G[701019]={'884:0.00,0.00 A:120533'}
G[701020]={'898:47.84,49.31 A:122663'}
G[701021]={'646:82.88,52.49 A:32639'}
G[701022]={'650:43.70,75.50 A:96072'}
G[701023]={'650:26.77,43.68 A:101832'}
G[701024]={'898:63.92,72.39 A:122663'}
G[701025]={'630:46.20,51.08 A:110903'}
G[701026]={'680:50.13,79.70 A:114472'}
G[701027]={'646:55.55,30.04 A:118776'}
G[701028]={'641:49.92,7.57 A:115664'}
G[701029]={'764:0.00,0.00 A:110791'}
G[701030]={'646:44.40,62.68 A:101527'}
G[701031]={'885:72.90,50.23 A:126954'}
G[701032]={'680:28.04,84.94 A:101878'}
G[701033]={'704:0.00,0.00 A:1251991'}
G[701034]={'680:27.26,65.73 A:99581'}
G[701035]={'709:51.75,48.47 A:113686'}
G[701036]={'650:42.22,27.27 A:32638'}
G[701037]={'627:68.39,43.04 A:77789'}
G[701038]={'650:44.81,24.87 A:95753'}
G[701039]={'709:51.75,48.21 A:113857'}
G[701040]={'650:45.51,46.19 A:94196'}
G[701041]={'650:49.17,54.56 A:94507'}
G[701042]={'731:21.03,58.64 A:91007'}
G[701043]={'650:53.72,54.24 A:94507'}
G[701044]={'680:51.93,82.17 A:32639'}
G[701045]={'634:48.13,57.55 A:97091'}
G[701046]={'731:19.09,60.06 A:91007'}
G[701047]={'710:0.00,0.00 A:1258979'}
G[701048]={'704:0.00,0.00 A:95676'}
G[701049]={'650:40.51,63.45 A:95013'}
G[701050]={'641:70.20,57.04 A:32639'}
G[701051]={'641:62.86,48.53 A:95951'}
G[701052]={'641:48.66,73.79 A:32639'}
G[701053]={'641:40.80,58.95 A:94046'}
G[701054]={'641:43.21,54.89 A:32639'}
G[701055]={'641:39.93,61.38 A:93064'}
G[701056]={'641:33.86,58.23 A:32638'}
G[701057]={'641:38.64,67.20 A:32639'}
G[701058]={'641:64.73,51.27 A:32639'}
G[701059]={'680:71.35,57.82 A:99075'}
G[701060]={'634:60.42,66.81 A:94856'}
G[701061]={'680:75.70,62.25 A:104576'}
G[701062]={'634:61.20,62.03 A:94413'}
G[701063]={'680:31.81,19.52 A:111609'}
G[701064]={'627:0.00,0.00 A:110642'}
G[701065]={'630:49.91,35.77 A:88101'}
G[701066]={'751:0.00,0.00 A:98970'}
G[701067]={'750:36.62,6.56 A:101077'}
G[701068]={'680:46.69,76.24 A:106032'}
G[701069]={'680:17.55,46.52 A:105885'}
G[701070]={'650:35.29,22.20 A:32638'}
G[701071]={'680:17.30,54.62 A:32639'}
G[701072]={'750:53.35,46.51 A:104615'}
G[701073]={'680:44.47,75.88 A:32638'}
G[701074]={'892:21.39,55.12 A:121756'}
G[701075]={'680:23.23,49.16 A:1252263'}
G[701076]={'831:43.12,27.58 A:121263'}
G[701077]={'893:34.02,65.72 A:120977'}
G[701078]={'630:37.45,51.36 A:90661'}
G[701079]={'680:22.85,48.79 A:114793'}
G[701080]={'634:57.79,52.33 A:32639'}
G[701081]={'886:32.30,59.70 A:126950'}	-- in Vindicaar above Antoran Wastes
G[701082]={'634:78.19,74.81 A:32639'}
G[701083]={'894:39.25,78.21 A:120977'}
G[701084]={'650:48.04,29.71 A:96410'}
G[701085]={'630:26.24,47.12 A:32638'}
G[701086]={'634:64.29,39.56 A:32638'}
G[701087]={'650:37.02,39.38 A:96286'}
G[701088]={'885:75.85,37.60 A:126954'}
G[701089]={'830:61.81,86.86 A:126307'}
G[701090]={'630:28.29,48.76 A:107133'}
G[701091]={'882:51.44,87.09 A:128725'}
G[701092]={'627:42.64,27.86 A:115264'}
G[701093]={'883:53.33,49.98 A:120533'}	-- in Vindicaar, turning in quest for returning piece
G[701094]={'634:74.29,59.51 A:94338'}
G[701095]={'830:61.87,86.99 A:122378'}
G[701096]={'882:51.45,86.74 A:126408'}
G[701097]={'886:33.57,58.25 A:126954'}	-- in Vindicaar about Antoran Wastes
G[701098]={'830:31.71,57.87 A:1271124'}
G[701099]={'831:45.58,35.60 A:126307'}
G[701100]={'830:62.01,87.12 A:121263'}
G[701101]={'831:39.10,24.87 830:61.67,86.92 A:124312'}	-- on Vindicaar when it is over Krokuun
G[701102]={'882:51.83,87.01 A:124312'}
G[701103]={'680:22.33,30.75 A:113102'}
G[701104]={'680:36.86,46.52 A:107126'}
G[701105]={'641:61.67,73.66 A:32638'}
G[701106]={'634:48.58,22.89 A:102873'}
G[701107]={'634:38.38,66.51 A:91423'}
G[701108]={'680:45.36,28.20 A:110903'}
G[701109]={'630:41.37,58.39 A:90659'}
G[701110]={'627:48.75,32.94 A:101527'}
G[701111]={'630:46.82,14.53 A:90380'}
G[701112]={'641:57.40,88.46 A:98234'}
G[701113]={'641:36.16,63.60 A:111384'}
G[701114]={'650:36.19,41.38 A:102361'}
G[701115]={'650:31.66,38.30 A:108499'}
G[701116]={'634:60.20,27.13 A:107463'}
G[701117]={'634:37.99,68.56 A:91423'}
G[701118]={'650:60.07,57.72 A:102866'}
G[701119]={'634:66.33,55.12 A:108827'}
G[701120]={'634:59.74,88.59 A:102871'}
G[701121]={'634:61.92,93.64 A:104294'}
G[701122]={'641:40.96,62.34 A:91847'}
G[701123]={'646:50.53,9.97 A:116469'}
G[701124]={'680:48.67,77.09 A:109409'}
G[701125]={'646:0.00,0.00 A:107126'}
G[701126]={'680:20.80,35.58 A:105756'}
G[701127]={'641:56.80,82.06 A:110903'}
G[701128]={'641:55.91,74.65 A:106901'}
G[701129]={'641:0.00,0.00 A:103643'}
G[701130]={'641:48.14,47.95 A:114676'}
G[701131]={'680:17.91,47.02 A:113162'}
G[701132]={'630:36.76,34.77 A:107715'}
G[701133]={'650:60.22,57.67 A:102877'}
G[701134]={'641:70.28,51.77 A:92326'}
G[701135]={'641:65.53,58.77 A:105932'}
G[701136]={'641:56.80,62.55 A:110903'}
G[701137]={'641:57.78,72.04 A:110903'}
G[701138]={'641:48.91,89.43 A:105960'}
G[701139]={'850:0.00,0.00 A:77789'}
G[701140]={'634:60.66,88.93 A:102873'}
G[701141]={'634:36.73,49.16 A:103643'}
G[701142]={'634:56.46,38.44 A:105746'}
G[701143]={'634:69.66,47.71 A:93066'}
G[701144]={'646:53.84,72.16 A:118184'}
G[701145]={'650:37.39,15.89 A:108529'}
G[701146]={'650:36.73,18.66 A:115677'}
G[701147]={'634:61.80,26.91 A:117080'}
G[701148]={'709:50.52,57.84 A:119765'}
G[701149]={'646:48.76,53.45 A:117168'}
G[701150]={'634:55.38,77.25 A:107883'}
G[701151]={'641:57.80,56.45 A:110896'}
G[701152]={'630:38.72,54.35 A:103363'}
G[701153]={'630:52.74,45.37 A:89846'}
G[701154]={'630:53.74,38.75 A:89834'}
G[701155]={'680:20.19,33.34 A:105554'}
G[701156]={'680:48.65,72.76 A:114472'}
G[701157]={'650:47.48,45.94 A:94196'}
G[701158]={'641:33.40,40.85 A:102874'}
G[701159]={'641:64.64,56.02 A:32641'}
G[701160]={'750:29.68,40.02 A:104615'}
G[701161]={'634:43.56,46.49 A:108289'}
G[701162]={'646:68.50,45.90 A:120896'}
G[701163]={'646:65.72,46.14 A:121034'}
G[701164]={'650:51.31,52.54 A:101644'}
G[701165]={'650:43.95,11.96 A:97919'}
G[701166]={'641:41.10,90.72 A:115675'}
G[701167]={'646:37.13,56.21 A:118786'}
G[701168]={'630:35.94,48.87 A:107328'}
G[701169]={'630:33.68,45.18 A:107440'}
G[701170]={'630:39.11,15.70 A:114255'}
G[701171]={'750:34.83,44.13 A:104615'}
G[701172]={'650:61.10,56.22 A:102867'}
G[701173]={'650:60.59,58.14 A:102873'}
G[701174]={'697:29.77,46.47 A:98757'}
G[701175]={'709:52.93,60.12 A:105019'}
G[701176]={'641:43.15,46.04 A:91860'}
G[701177]={'630:44.79,51.55 A:118836'}
G[701178]={'680:21.31,21.42 A:32641'}
G[701179]={'641:68.29,55.54 A:92326'}
G[701180]={'650:40.78,31.90 A:103656'}
G[701181]={'650:61.22,56.64 A:104294'}
G[701182]={'634:43.67,81.65 A:91759'}
G[701183]={'680:23.23,46.02 A:105676'}
G[701184]={'646:47.84,17.03 A:118943'}
G[701185]={'680:20.00,46.44 A:105625'}
G[701186]={'646:64.46,51.18 A:121031'}
G[701187]={'646:45.42,40.83 A:118851'}
G[701188]={'634:62.86,51.42 A:93070'}
G[701189]={'630:56.08,68.21 A:108338'}
G[701190]={'650:26.47,53.83 A:102868'}
G[701191]={'630:57.15,65.32 A:108340'}
G[701192]={'630:67.25,46.20 A:109349'}
G[701193]={'641:46.50,74.56 A:91598'}
G[701194]={'634:68.09,47.20 A:93094'}
G[701195]={'630:38.39,45.71 A:103231'}
G[701196]={'641:33.13,40.81 A:102875'}
G[701197]={'630:35.86,18.63 A:114255'}
G[701198]={'634:0.00,0.00 A:91575'}
G[701199]={'650:36.87,17.81 A:115669'}
G[701200]={'634:51.22,25.50 A:107469'}
G[701201]={'641:59.46,64.65 A:93318'}
G[701202]={'641:41.83,75.73 A:102877'}
G[701203]={'634:40.16,28.07 A:89829'}
G[701204]={'680:44.16,37.90 A:99789'}
G[701205]={'641:34.89,64.23 A:111383'}
G[701206]={'641:41.61,55.40 A:92954'}
G[701207]={'630:67.09,28.68 A:92450'}
G[701208]={'634:48.21,17.41 A:119032'}
G[701209]={'627:51.84,66.21 A:111243'}
G[701210]={'650:44.15,57.31 A:119944'}
G[701211]={'680:23.30,57.96 A:104521'}
G[701212]={'630:42.65,34.91 A:90134'}
G[701213]={'680:31.29,80.79 A:99581'}
G[701214]={'680:47.47,71.33 A:111446'}
G[701215]={'641:40.79,76.83 A:102864'}
G[701216]={'641:53.61,39.14 A:93159'}
G[701217]={'680:20.06,43.15 A:105885'}
G[701218]={'680:48.12,72.69 A:114468'}
G[701219]={'641:68.61,73.87 A:109045'}
G[701220]={'641:48.51,40.79 A:93318'}
G[701221]={'630:32.74,55.00 A:107363'}
G[701222]={'630:58.75,67.08 A:108146'}
G[701223]={'630:55.30,30.57 A:90313'}
G[701224]={'641:64.22,72.48 A:95599'}
G[701225]={'641:46.50,41.86 A:111280'}
G[701226]={'630:59.26,72.74 A:108133'}
G[701227]={'641:65.68,39.69 A:93155'}
G[701228]={'680:29.01,61.76 A:106339'}
G[701229]={'630:42.35,87.80 A:111479'}
G[701230]={'650:28.69,36.33 A:110903'}
G[701231]={'634:43.75,44.38 A:108283'}
G[701232]={'630:25.99,44.49 A:107216'}
G[701233]={'680:31.94,47.44 A:110903'}
G[701234]={'641:66.94,35.37 A:97338'}
G[701235]={'634:63.07,27.84 A:117080'}
G[701236]={'641:32.63,58.16 A:111383'}
G[701237]={'650:30.21,48.47 A:95937'}
G[701238]={'680:48.64,79.61 A:32641'}
G[701239]={'634:54.00,44.72 A:105748'}
G[701240]={'634:62.21,93.65 A:102877'}
G[701241]={'630:58.79,38.67 A:89025'}
G[701242]={'650:41.76,48.70 A:94149'}
G[701243]={'634:45.89,79.00 A:91244'}
G[701244]={'634:34.83,71.09 A:106568'}
G[701245]={'650:0.00,0.00 A:97808'}
G[701246]={'630:43.92,37.13 A:90134'}
G[701247]={'634:49.74,56.12 A:107755'}
G[701248]={'650:60.83,57.47 A:102869'}
G[701249]={'646:0.00,0.00 A:105362'}
G[701250]={'634:53.57,46.52 A:105748'}
G[701251]={'634:64.41,50.18 A:93070'}
G[701252]={'634:46.79,80.10 A:92128'}
G[701253]={'641:43.63,91.03 A:115675'}
G[701254]={'641:33.83,46.67 A:102866'}
G[701255]={'630:51.38,20.37 A:109326'}
G[701256]={'680:61.93,45.52 A:104404'}
G[701257]={'641:58.74,56.58 A:93157'}
G[701258]={'641:48.21,7.59 A:115682'}
G[701259]={'680:62.74,59.55 A:109023'}
G[701260]={'641:37.98,62.22 A:103643'}
G[701261]={'680:48.71,40.89 A:110903'}
G[701262]={'680:62.08,53.89 A:116555'}
G[701263]={'680:17.69,47.21 A:105676'}
G[701264]={'641:60.16,36.75 A:112052'}
G[701265]={'680:29.51,34.50 A:110903'}
G[701266]={'680:31.98,79.33 A:99581'}
G[701267]={'627:70.43,46.17 A:101527'}
G[701268]={'634:48.63,20.99 A:102871'}
G[701269]={'680:43.37,37.57 A:98979'}
G[701270]={'641:57.61,54.65 A:92789'}
G[701271]={'641:68.57,52.78 A:92326'}
G[701272]={'641:62.26,39.03 A:93111'}
G[701273]={'650:26.08,57.25 A:102869'}
G[701274]={'650:42.87,49.81 A:101997'}
G[701275]={'630:44.43,33.95 A:90134'}
G[701276]={'630:38.28,49.53 A:90661'}
G[701277]={'634:45.70,56.73 A:119905'}
G[701278]={'680:29.40,72.84 A:110805'}
G[701279]={'630:44.29,9.28 A:120107'}
G[701280]={'641:62.95,60.78 A:92326'}
G[701281]={'680:28.73,24.67 A:103616'}
G[701282]={'650:60.97,56.44 A:102876'}
G[701283]={'650:61.15,56.45 A:103653'}
G[701284]={'634:42.38,57.52 A:110903'}
G[701285]={'649:56.40,31.85 A:91384'}
G[701286]={'650:55.42,58.80 A:96691'}
G[701287]={'650:29.82,29.85 A:119105'}
G[701288]={'650:33.08,23.22 A:115677'}
G[701289]={'630:31.96,49.30 A:107335'}
G[701290]={'750:34.82,44.12 A:111184'}
G[701291]={'634:48.65,20.70 A:102867'}
G[701292]={'634:60.68,25.45 A:107463'}
G[701293]={'650:30.95,29.88 A:119104'}
G[701294]={'680:83.17,58.93 A:100999'}
G[701295]={'634:42.32,69.70 A:91205'}
G[701296]={'634:67.30,39.89 A:108927'}
G[701297]={'634:48.45,21.48 A:102875'}
G[701298]={'129:0.00,0.00 A:55535'}
G[701299]={'129:0.00,0.00 A:55537'}
G[701300]={'129:0.00,0.00 A:55536'}
G[701301]={'129:0.00,0.00 A:55531'}
G[701302]={'129:0.00,0.00 A:26723'}
G[701303]={'646:42.05,28.64 A:117509'}
G[701304]={'646:57.35,28.18 A:32642'}
G[701305]={'646:63.65,33.44 A:119634'}
G[701306]={'646:82.16,30.20 A:118683'}
G[701307]={'627:51.01,27.97 A:77789'}
G[701308]={'646:45.02,77.99 A:118266'}
G[701309]={'630:64.56,31.47 A:92445'}
G[701310]={'680:18.33,50.18 A:105885'}
G[701311]={'680:28.61,41.42 A:100014'}
G[701312]={'641:60.51,43.81 A:32641'}
G[701313]={'641:33.12,42.54 A:102876'}
G[701314]={'641:33.60,62.70 A:111383'}
G[701315]={'630:43.50,31.97 A:98232'}
G[701316]={'680:21.59,33.85 A:105756'}
G[701317]={'641:62.76,60.05 A:92837'}
G[701318]={'634:34.14,46.32 A:90903'}
G[701319]={'646:44.71,69.71 A:115054'}
G[701320]={'646:52.52,75.68 A:118057'}
G[701321]={'634:58.39,47.00 A:105502'}
G[701322]={'646:81.50,49.70 A:116121'}
G[701323]={'646:48.08,40.84 A:118455'}
G[701324]={'646:69.53,47.15 A:121031'}
G[701325]={'646:59.71,28.89 A:118819'}
G[701326]={'646:38.57,25.09 A:117354'}
G[701327]={'641:60.36,47.69 A:92383'}
G[701328]={'641:44.37,50.09 A:95430'}
G[701329]={'641:44.24,48.45 A:95430'}
G[701330]={'634:48.73,24.17 A:102875'}
G[701331]={'641:26.95,71.16 A:98234'}
G[701332]={'641:66.58,68.45 A:98234'}
G[701333]={'641:66.36,72.72 A:109045'}
G[701334]={'630:27.36,41.94 A:107201'}
G[701335]={'680:25.22,34.70 A:104224'}
G[701336]={'634:61.61,92.41 A:102864'}
G[701337]={'646:49.02,72.95 A:115056'}
G[701338]={'680:83.84,57.90 A:100998'}
G[701339]={'649:56.64,39.17 A:91575'}
G[701340]={'649:56.59,39.23 A:91384'}
G[701341]={'650:51.63,42.99 A:94984'}
G[701342]={'650:24.52,56.88 A:102867'}
G[701343]={'641:56.83,57.07 A:32641'}
G[701344]={'630:51.06,58.64 A:90109'}
G[701345]={'630:47.44,53.08 A:32641'}
G[701346]={'646:49.70,70.34 A:120636'}
G[701347]={'634:0.00,0.00 A:91384'}
G[701348]={'634:72.32,53.65 A:108030'}
G[701349]={'630:36.19,16.31 A:114255'}
G[701350]={'630:41.88,37.75 A:90134'}
G[701351]={'680:44.82,42.77 A:99789'}
G[701352]={'646:0.00,0.00 A:107376'}
G[701353]={'680:21.53,21.60 A:106764'}
G[701354]={'646:56.13,64.86 A:98232'}
G[701355]={'646:0.00,0.00 A:90134'}
G[701356]={'680:42.36,36.03 A:98979'}
G[701357]={'630:62.34,24.10 A:116026'}
G[701358]={'634:67.93,44.29 A:93094'}
G[701359]={'641:55.26,88.40 A:91474'}
G[701360]={'680:29.29,79.44 A:102450'}
G[701361]={'630:68.29,28.96 A:103643'}
G[701362]={'650:42.53,47.60 A:102982'}
G[701363]={'680:20.84,31.04 A:116675'}
G[701364]={'630:64.78,47.13 A:106695'}
G[701365]={'680:45.52,69.85 A:106654'}
G[701366]={'646:0.00,0.00 A:105525'}
G[701367]={'634:60.16,44.19 A:105532'}
G[701368]={'641:66.33,67.01 A:115008'}
G[701369]={'650:25.64,41.46 A:102736'}
G[701370]={'634:35.51,37.12 A:110903'}
G[701371]={'634:55.41,43.03 A:105748'}
G[701372]={'641:59.63,58.90 A:92789'}
G[701373]={'680:28.44,62.14 A:99762'}
G[701374]={'634:69.96,42.71 A:108940'}
G[701375]={'641:49.00,38.69 A:115008'}
G[701376]={'650:43.82,70.33 A:102886'}
G[701377]={'634:78.61,71.88 A:115678'}
G[701378]={'634:75.26,61.24 A:103643'}
G[701379]={'641:59.56,91.72 A:110903'}
G[701380]={'650:26.57,42.08 A:101700'}
G[701381]={'630:58.99,64.41 A:108146'}
G[701382]={'641:65.42,42.44 A:95951'}
G[701383]={'634:45.87,49.43 A:96129'}
G[701384]={'627:40.33,50.26 A:77789'}
G[701385]={'641:39.99,75.25 A:102868'}
G[701386]={'641:23.90,69.66 A:111460'}
G[701387]={'634:54.62,39.08 A:105718'}
G[701388]={'630:38.85,55.70 A:103231'}
G[701389]={'650:25.84,56.04 A:102877'}
G[701390]={'650:60.13,57.83 A:102871'}
G[701391]={'630:39.45,34.63 A:107628'}
G[701392]={'641:36.48,59.72 A:98234'}
G[701393]={'641:32.19,43.33 A:102877'}
G[701394]={'630:47.52,14.72 A:90379'}
G[701395]={'634:48.88,21.08 A:103653'}
G[701396]={'680:45.23,67.49 A:111446'}
G[701397]={'650:51.27,52.60 A:102468'}
G[701398]={'630:30.61,48.39 A:107135'}
G[701399]={'634:50.95,60.67 A:107755'}
G[701400]={'641:53.32,77.05 A:115021'}
G[701401]={'641:53.14,50.56 A:110903'}
G[701402]={'630:36.72,35.06 A:107624'}
G[701403]={'630:57.57,75.11 A:108139'}
G[701404]={'641:55.09,82.18 A:91472'}
G[701405]={'630:57.18,45.13 A:91756'}
G[701406]={'766:0.00,0.00 A:43929'}
G[701407]={'641:72.57,36.87 A:106331'}
G[701408]={'630:39.06,54.18 A:90659'}
G[701409]={'634:32.77,42.37 A:110903'}
G[701410]={'641:68.03,48.41 A:95951'}
G[701411]={'641:47.19,55.28 A:100409'}
G[701412]={'641:40.40,62.06 A:120144'}
G[701413]={'634:70.67,41.50 A:93071'}
G[701414]={'680:22.01,29.42 A:116675'}
G[701415]={'634:80.17,69.67 A:115663'}
G[701416]={'641:61.65,48.65 A:92383'}
G[701417]={'634:78.93,75.26 A:115671'}
G[701418]={'646:0.00,0.00 A:93071'}
G[701419]={'650:35.48,19.80 A:115677'}
G[701420]={'634:61.61,90.61 A:103245'}
G[701421]={'630:50.90,33.36 A:88101'}
G[701422]={'680:23.20,40.19 A:105625'}
G[701423]={'630:62.70,54.87 A:109349'}
G[701424]={'630:68.31,24.53 A:92450'}
G[701425]={'634:73.40,89.35 A:102170'}
G[701426]={'650:45.53,71.16 A:108069'}
G[701427]={'680:31.08,83.20 A:110805'}
G[701428]={'650:61.06,58.19 A:102867'}
G[701429]={'630:58.89,66.90 A:108139'}
G[701430]={'641:66.80,35.65 A:97337'}
G[701431]={'680:47.18,68.20 A:108096'}
G[701432]={'641:50.33,72.42 A:106369'}
G[701433]={'650:25.92,56.29 A:102864'}
G[701434]={'634:51.64,32.87 A:107469'}
G[701435]={'634:80.11,61.86 A:98502'}
G[701436]={'641:38.07,71.48 A:102876'}
G[701437]={'650:31.89,61.07 A:110496'}
G[701438]={'646:15.92,31.89 A:120215'}
G[701439]={'630:35.85,14.23 A:105361'}
G[701440]={'630:47.47,10.46 A:120107'}
G[701441]={'641:38.72,83.04 A:102622'}
G[701442]={'680:29.59,71.49 A:99581'}
G[701443]={'641:42.56,37.10 A:111281'}
G[701444]={'680:38.97,66.56 A:116206'}
G[701445]={'630:59.68,24.60 A:116026'}
G[701446]={'634:60.52,89.47 A:102875'}
G[701447]={'641:37.69,77.88 A:102868'}
G[701448]={'634:61.68,92.05 A:102873'}
G[701449]={'641:57.82,83.00 A:108327'}
G[701450]={'680:35.56,38.16 A:112910'}
G[701451]={'634:76.78,82.98 A:115663'}
G[701452]={'680:61.96,53.72 A:116554'}
G[701453]={'680:20.11,24.32 A:106764'}
G[701454]={'641:58.81,64.91 A:105823'}
G[701455]={'634:40.75,82.83 A:91759'}
G[701456]={'646:59.62,26.05 A:118819'}
G[701457]={'634:40.75,82.83 A:92128'}
G[701458]={'641:40.66,76.95 A:102875'}
G[701459]={'641:39.81,75.28 A:102877'}
G[701460]={'680:31.09,51.18 A:115562'}
G[701461]={'641:21.80,67.78 A:111474'}
G[701462]={'646:0.00,0.00 A:97140'}
G[701463]={'634:0.00,0.00 A:91948'}
G[701464]={'680:45.27,70.43 A:113619'}
G[701465]={'641:52.07,9.36 A:115664'}
G[701466]={'680:29.03,57.63 A:101868'}
G[701467]={'641:40.82,74.62 A:102871'}
G[701468]={'680:28.63,60.75 A:101868'}
G[701469]={'680:17.97,59.66 A:109803'}
G[701470]={'641:30.06,71.02 A:103643'}
G[701471]={'630:53.26,44.27 A:107801'}
G[701472]={'630:57.51,75.16 A:108133'}
G[701473]={'630:37.72,17.58 A:110838'}
G[701474]={'650:44.53,49.65 A:102982'}
G[701475]={'650:44.09,49.80 A:94149'}
G[701476]={'650:57.82,61.66 A:102871'}
G[701477]={'650:61.04,56.41 A:102872'}
G[701478]={'680:18.96,47.94 A:105623'}
G[701479]={'627:47.78,30.52 A:106655'}
G[701480]={'630:60.57,26.41 A:116026'}
G[701481]={'630:48.95,10.22 A:90480'}
G[701482]={'641:43.28,88.55 A:102166'}
G[701483]={'641:45.44,38.80 A:111281'}
G[701484]={'650:32.38,60.20 A:110903'}
G[701485]={'650:28.11,52.68 A:110903'}
G[701486]={'634:47.36,22.52 A:102868'}
G[701487]={'641:45.65,40.27 A:111252'}
G[701488]={'680:25.74,61.33 A:101900'}
G[701489]={'634:30.22,52.60 A:90903'}
G[701490]={'641:46.88,43.61 A:111279'}
G[701491]={'680:47.03,53.09 A:116050'}
G[701492]={'680:23.01,41.32 A:105676'}
G[701493]={'641:60.87,81.27 A:108259'}
G[701494]={'634:44.86,43.45 A:96236'}
G[701495]={'634:56.29,44.39 A:105748'}
G[701496]={'680:57.34,45.49 A:116225'}
G[701497]={'627:50.27,35.45 A:101527'}
G[701498]={'680:29.21,66.41 A:101868'}
G[701499]={'680:24.53,32.33 A:98233'}
G[701500]={'630:66.61,48.98 A:116428'}
G[701501]={'630:62.63,23.43 A:116025'}
G[701502]={'641:61.47,81.09 A:108600'}
G[701503]={'641:62.55,74.71 A:95726'}
G[701504]={'680:59.13,49.05 A:116225'}
G[701505]={'634:61.51,91.41 A:102868'}
G[701506]={'630:63.83,14.59 A:110824'}
G[701507]={'650:54.49,41.40 A:107945'}
G[701508]={'646:53.42,15.06 A:116470'}
G[701509]={'641:39.02,62.67 A:94009'}
G[701510]={'680:47.37,67.47 A:105759'}
G[701511]={'630:62.15,46.39 A:89024'}
G[701512]={'630:43.31,11.33 A:120074'}
G[701513]={'646:0.00,0.00 A:92794'}
G[701514]={'646:40.42,60.57 A:120820'}
G[701515]={'646:67.54,46.90 A:121034'}
G[701516]={'646:79.48,42.13 A:117718'}
G[701517]={'646:55.00,63.44 A:120934'}
G[701518]={'641:49.30,7.51 A:32641'}
G[701519]={'634:79.02,74.34 A:115663'}
G[701520]={'641:47.15,51.06 A:115906'}
G[701521]={'641:53.48,77.96 A:109819'}
G[701522]={'641:53.85,77.95 A:115119'}
G[701523]={'646:67.35,48.18 A:121031'}
G[701524]={'641:68.75,34.45 A:32641'}
G[701525]={'641:59.38,67.53 A:105897'}
G[701526]={'641:57.48,67.98 A:105897'}
G[701527]={'641:40.07,75.71 A:102873'}
G[701528]={'641:43.78,53.53 A:91860'}
G[701529]={'680:22.66,36.08 A:32642'}
G[701530]={'641:57.27,64.73 A:110903'}
G[701531]={'641:56.21,85.77 A:110903'}
G[701532]={'641:57.55,81.16 A:32641'}
G[701533]={'641:39.44,84.45 A:102622'}
G[701534]={'641:39.91,75.96 A:102866'}
G[701535]={'641:38.77,59.74 A:98234'}
G[701536]={'650:24.30,56.82 A:102875'}
G[701537]={'650:49.34,28.60 A:96410'}
G[701538]={'646:53.22,55.52 A:119139'}
G[701539]={'646:54.37,57.91 A:118390'}
G[701540]={'646:35.08,34.59 A:118162'}
G[701541]={'641:44.63,51.54 A:91860'}
G[701542]={'680:28.70,18.43 A:114305'}
G[701543]={'630:67.73,50.62 A:106695'}
G[701544]={'630:56.03,41.53 A:106106'}
G[701545]={'641:64.18,70.27 A:95726'}
G[701546]={'627:63.16,56.41 A:111246'}
G[701547]={'646:53.05,72.31 A:118057'}
G[701548]={'641:63.77,54.26 A:92321'}
G[701549]={'630:40.16,79.62 A:111457'}
G[701550]={'680:47.90,63.07 A:105759'}
G[701551]={'634:62.30,27.29 A:109967'}
G[701552]={'646:67.32,43.90 A:120896'}
G[701553]={'680:28.30,45.19 A:100014'}
G[701554]={'641:58.00,59.03 A:98234'}
G[701555]={'646:51.52,71.04 A:120934'}
G[701556]={'646:51.92,71.55 A:120932'}
G[701557]={'646:33.35,56.59 A:120226'}
G[701558]={'641:44.27,76.10 A:91121'}
G[701559]={'650:36.27,18.67 A:115665'}
G[701560]={'630:62.56,43.17 A:89024'}
G[701561]={'750:33.06,57.10 A:104615'}
G[701562]={'680:64.34,42.96 A:113205'}
G[701563]={'641:72.96,51.16 A:105826'}
G[701564]={'750:33.35,57.10 A:111184'}
G[701565]={'630:56.51,17.89 A:90318'}
G[701566]={'750:31.96,41.78 A:104615'}
G[701567]={'646:0.00,0.00 A:90903'}
G[701568]={'641:75.01,44.24 A:106331'}
G[701569]={'680:63.63,57.45 A:109023'}
G[701570]={'650:49.74,44.22 A:94984'}
G[701571]={'650:33.76,25.01 A:115679'}
G[701572]={'680:62.81,56.64 A:109180'}
G[701573]={'680:47.98,65.37 A:108096'}
G[701574]={'650:37.73,40.77 A:102361'}
G[701575]={'634:29.30,57.15 A:90903'}
G[701576]={'634:45.87,38.89 A:107258'}
G[701577]={'680:65.23,46.50 A:110253'}
G[701578]={'630:34.47,6.24 A:115666'}
G[701579]={'634:71.02,52.13 A:93095'}
G[701580]={'630:50.75,39.49 A:88099'}
G[701581]={'641:45.12,73.41 A:91122'}
G[701582]={'680:21.49,39.78 A:107811'}
G[701583]={'634:43.80,43.45 A:97755'}
G[701584]={'650:29.24,29.46 A:101794'}
G[701585]={'680:33.75,51.61 A:115562'}
G[701586]={'680:62.85,56.60 A:109025'}
G[701587]={'680:23.05,36.17 A:105676'}
G[701588]={'680:17.81,48.21 A:105885'}
G[701589]={'634:29.77,59.71 A:90903'}
G[701590]={'680:58.57,51.43 A:110944'}
G[701591]={'641:33.41,51.27 A:98234'}
G[701592]={'680:44.64,33.15 A:97729'}
G[701593]={'680:45.40,35.05 A:97729'}
G[701594]={'630:35.22,10.25 A:115675'}
G[701595]={'630:57.20,16.23 A:90318'}
G[701596]={'634:27.26,57.25 A:90903'}
G[701597]={'680:55.70,47.05 A:112370'}
G[701598]={'641:32.59,41.19 A:102877'}
G[701599]={'634:46.97,42.65 A:96129'}
G[701600]={'680:80.33,70.56 A:103183'}
G[701601]={'641:40.90,76.14 A:98234'}
G[701602]={'641:69.53,54.47 A:110342'}
G[701603]={'630:66.77,48.59 A:106695'}
G[701604]={'634:46.84,35.63 A:99223'}
G[701605]={'641:32.58,41.21 A:102867'}
G[701606]={'650:26.65,55.74 A:102873'}
G[701607]={'641:62.70,35.30 A:112021'}
G[701608]={'650:37.97,41.15 A:96146'}
G[701609]={'680:64.65,36.66 A:110253'}
G[701610]={'650:58.31,64.83 A:103850'}
G[701611]={'634:61.72,46.25 A:105502'}
G[701612]={'703:0.00,0.00 A:95676'}
G[701613]={'650:33.32,22.99 A:115665'}
G[701614]={'649:53.92,33.40 A:91948'}
G[701615]={'634:60.72,29.80 A:107463'}
G[701616]={'641:33.63,40.18 A:103653'}
G[701617]={'634:64.87,44.69 A:109795'}
G[701618]={'650:51.74,39.89 A:94984'}
G[701619]={'709:52.61,58.84 A:101527'}
G[701620]={'627:49.08,31.02 A:101527'}
G[701621]={'680:22.33,39.81 A:105676'}
G[701622]={'650:52.42,80.25 A:103174'}
G[701623]={'630:50.67,20.40 A:106630'}
G[701624]={'650:60.51,59.63 A:102868'}
G[701625]={'630:53.63,36.34 A:91431'}
G[701626]={'630:62.66,42.95 A:89802'}
G[701627]={'634:36.34,67.12 A:91423'}
G[701628]={'630:48.10,53.15 A:89097'}
G[701629]={'627:69.82,38.31 A:101846'}
G[701630]={'630:61.94,42.93 A:89025'}
G[701631]={'646:0.00,0.00 A:116038'}
G[701632]={'680:50.71,78.26 A:106032'}
G[701633]={'634:71.60,87.59 A:102170'}
G[701634]={'646:0.00,0.00 A:92332'}
G[701635]={'641:59.44,71.20 A:105897'}
G[701636]={'680:42.84,25.10 A:110903'}
G[701637]={'641:48.88,74.12 A:98234'}
G[701638]={'634:28.64,47.65 A:90903'}
G[701639]={'641:60.68,70.26 A:95727'}
G[701640]={'641:59.51,50.86 A:93157'}
G[701641]={'634:71.21,44.81 A:93071'}
G[701642]={'630:58.67,59.02 A:89283'}
G[701643]={'630:63.58,21.59 A:106920'}
G[701644]={'634:78.98,74.49 A:115678'}
G[701645]={'680:48.07,71.30 A:114472'}
G[701646]={'680:21.81,46.80 A:105486'}
G[701647]={'680:62.55,50.76 A:116529'}
G[701648]={'634:29.89,54.58 A:90903'}
G[701649]={'634:47.48,38.01 A:107258'}
G[701650]={'882:52.49,91.70 A:126389'}
G[701651]={'882:31.88,37.47 A:121230'}
G[701652]={'882:51.34,91.46 A:121589'}
G[701653]={'883:57.19,60.51 A:120533'}	-- in Vindicaar above Mac'Aree
G[701654]={'882:28.43,47.21 A:121230'}
G[701655]={'882:62.65,39.43 A:124312'}
G[701656]={'882:43.42,67.59 A:121230'}
G[701657]={'882:59.08,20.08 A:120533'}
G[701658]={'882:52.08,89.74 A:128722'}
G[701659]={'882:59.14,20.22 A:124312'}
G[701660]={'882:48.79,19.73 A:120533'}
G[701661]={'882:35.34,59.55 A:121230'}
G[701662]={'882:50.14,17.91 A:120533'}
G[701663]={'747:53.59,49.45 A:98002'}
G[701664]={'831:49.60,43.63 A:121263'}
G[701665]={'883:49.71,23.91 A:121263'}	-- in Vindicaar above Mac'Aree
G[701666]={'883:47.26,19.37 A:126408'}	-- in Vindicaar above Mac'Aree
G[701667]={'831:44.71,22.30 A:124312'}	-- on Vindicaar (later position) when it is over Krokuun
G[701668]={'883:50.91,23.27 882:51.83,87.01 A:124312'}	-- in Vindicaar (later position) above Mac'Aree
G[701669]={'884:41.99,68.31 A:125525'}
G[701670]={'830:61.75,86.48 A:126408'}
G[701671]={'886:56.30,28.48 N:127151'}	-- in Vindicaar above Antoran Wastes
G[701672]={'831:68.26,56.88 N:127151'}	-- in Vindicaar above Krokuun
G[701673]={'831:51.70,51.53 A:120533'}	-- in Vindicaar above Krokuun
G[701674]={'883:45.51,24.58 831:38.83,25.62 A:121230'}	-- in Vindicaar above Mac'Areee and Krokuun
G[701675]={'883:58.30,59.77 A:121230'}
G[701676]={'830:63.26,90.56 A:126389'}
G[701677]={'832:0.00,0.00 A:121230'}
G[701678]={'882:44.89,57.37 A:32639'}
G[701679]={'37:45.38,49.00 A:6774'}
G[701680]={'882:24.20,39.25 A:121670'}
G[701681]={'882:22.30,40.56 A:121671'}
G[701682]={'630:49.24,46.35 A:110916'}
G[701683]={'882:60.62,27.65 A:125926'}
G[701684]={'650:34.74,72.94 A:117066'}
G[701685]={'882:56.74,29.73 A:125497'}
G[701686]={'882:54.89,25.17 A:125842'}
G[701687]={'831:0.00,0.00 A:121589'}
G[701688]={'630:41.14,76.53 A:102059'}
G[701689]={'650:50.20,64.60 A:32639'}
G[701690]={'535:61.80,27.53 A:75874'}
G[701691]={'641:54.66,9.38 A:115664'}
G[701692]={'641:53.67,9.17 A:115676'}
G[701693]={'832:0.00,0.00 A:124312'}
G[701694]={'885:78.69,38.13 A:127120'}
G[701695]={'882:60.39,38.88 A:124440'}
G[701696]={'680:49.28,71.41 A:115216'}
G[701697]={'832:0.00,0.00 A:126408'}
G[701698]={'680:49.12,79.58 A:109409'}
G[701699]={'646:46.56,16.53 A:117325'}
G[701700]={'883:50.23,69.50 A:123668'}
G[701701]={'646:29.88,57.94 A:120745'}
G[701702]={'922:44.63,47.45 A:125587'}
G[701703]={'885:78.66,36.88 A:77789'}
G[701704]={'830:62.01,90.86 A:127120'}
G[701705]={'882:51.27,87.16 A:121230'}
G[701706]={'630:47.02,40.86 A:101527'}
G[701707]={'750:30.39,47.84 A:110915'}
G[701708]={'641:49.62,41.85 A:115008'}
G[701709]={'887:62.44,60.00 A:101527'}
G[701710]={'634:56.59,39.71 A:105532'}
G[701711]={'887:33.54,58.25 A:126954'}
G[701712]={'924:75.24,51.21 A:125634'}
G[701713]={'650:43.23,57.31 A:102890'}
G[701714]={'710:0.00,0.00 A:95888'}
G[701715]={'921:17.23,57.84 A:125483'}
G[701716]={'705:0.00,0.00 A:102019'}
G[701717]={'921:21.27,45.98 A:125314'}
G[701718]={'882:55.65,58.57 A:126852'}
G[701719]={'885:75.57,37.70 A:127057'}
G[701720]={'882:51.22,91.65 A:127151'}
G[701721]={'883:49.14,68.98 A:123395'}
G[701722]={'887:62.51,66.17 A:125525'}
G[701723]={'887:55.53,26.01 A:127476'}
G[701724]={'887:60.53,57.37 A:101527'}
G[701725]={'883:0.00,0.00 A:127476'}
G[701726]={'882:57.70,32.32 A:124430'}
G[701727]={'882:39.66,68.51 A:124398'}
G[701728]={'831:43.73,24.86 A:121263'}
G[701729]={'832:39.63,64.66 A:129674'}
G[701730]={'883:45.94,25.15 A:124312'}
G[701731]={'885:75.86,37.35 A:121263'}
G[701732]={'882:57.53,76.14 A:32642'}
G[701733]={'850:0.00,0.00 A:124312'}
G[701734]={'630:47.18,9.62 A:91048'}
G[701735]={'884:0.00,0.00 A:124312'}
G[701736]={'897:49.25,71.75 A:123790'}
G[701737]={'884:0.00,0.00 A:126408'}
G[701738]={'731:0.00,0.00 A:91007'}
G[701739]={'885:76.23,56.08 A:127596'}
G[701740]={'882:52.47,91.36 A:101527'}
G[701741]={'206:0.00,0.00 A:77789'}
G[701742]={'898:0.00,0.00 A:123781'}
G[701743]={'882:51.61,91.84 A:123395'}
G[701744]={'747:54.13,48.47 A:77789'}
G[701745]={'554:47.62,78.46 A:72875'}
G[701746]={'830:35.08,66.41 A:123109'}
G[701747]={'554:60.78,62.82 A:72970'}
G[701748]={'882:57.24,37.36 A:124432'}
G[701749]={'882:61.14,36.41 A:124444'}
G[701750]={'627:44.75,59.14 A:97012'}
G[701751]={'882:51.23,91.69 A:125525'}
G[701752]={'922:46.08,53.12 A:125280'}
G[701753]={'535:43.85,28.64 A:86934'}
G[701754]={'535:34.87,17.52 A:86934'}
G[701755]={'882:54.53,64.38 A:128357'}
G[701756]={'504:42.30,66.33 A:69674'}
G[701757]={'882:40.27,66.47 A:124398'}
G[701758]={'926:54.16,36.44 A:125634'}
G[701759]={'630:40.24,49.10 A:103180'}
G[701760]={'630:38.11,58.01 A:90660'}
G[701761]={'630:66.05,50.70 A:106695'}
G[701762]={'630:58.23,17.90 A:90005'}
G[701763]={'627:40.03,32.23 A:101527'}
G[701764]={'630:54.99,18.83 A:90616'}
G[701765]={'732:0.00,0.00 A:102446'}
G[701766]={'646:29.46,63.37 A:118786'}
G[701767]={'646:40.89,78.63 A:118993'}
G[701768]={'630:62.75,38.74 A:89024'}
G[701769]={'884:67.65,56.39 A:127476'}
G[701770]={'634:49.03,20.82 A:104290'}
G[701771]={'885:77.95,34.50 A:127476'}
G[701772]={'886:0.00,0.00 A:127476'}
G[701773]={'885:72.98,71.07 A:126233'}
G[701774]={'650:43.21,57.24 A:102884'}
G[701775]={'321:0.00,0.00 A:15727'}
G[701776]={'926:58.43,41.21 A:125634'}
G[701777]={'882:53.91,14.76 A:126998'}
G[701778]={'321:0.00,0.00 A:15379'}
G[701779]={'830:63.64,89.35 A:125525'}
G[701780]={'882:57.51,17.66 A:126995'}
G[701781]={'882:58.03,15.04 A:126996'}
G[701782]={'641:45.52,41.60 A:110916'}
G[701783]={'379:66.89,56.23 A:60968'}
G[701784]={'395:47.11,83.05 A:96541'}
G[701785]={'628:55.90,65.35 A:101097'}
G[701786]={'641:41.55,52.64 A:95430'}
G[701787]={'641:43.05,51.38 A:91860'}
G[701788]={'42:49.46,74.73 A:100812'}
G[701789]={'46:68.28,27.10 A:101282'}
G[701790]={'717:37.57,31.26 A:101097'}
G[701791]={'646:81.51,27.70 A:120945'}
G[701792]={'940:48.43,39.46 A:130549'}
G[701793]={'883:0.00,0.00 A:121589'}
G[701794]={'923:60.48,67.98 A:125655'}
G[701795]={'535:68.89,22.53 A:79608'}
G[701796]={'830:60.81,19.62 A:125129'}
G[701797]={'886:29.97,59.17 A:127057'}
G[701798]={'833:37.91,39.50 A:125824'}
G[701799]={'885:78.09,34.63 A:127151'}
G[701800]={'832:63.31,54.03 A:101527'}
G[701801]={'830:38.86,69.99 A:123109'}
G[701802]={'830:57.97,78.02 A:119597'}
G[701803]={'627:47.92,70.13 A:97012'}
G[701804]={'830:56.45,35.17 A:125110'}
G[701805]={'885:55.52,49.37 A:127114'}
G[701806]={'923:55.54,71.69 A:125666'}
G[701807]={'832:68.50,53.96 A:101527'}
G[701808]={'646:52.74,44.75 A:118657'}
G[701809]={'882:56.23,29.97 A:124430'}
G[701810]={'830:64.08,89.29 A:127476'}
G[701811]={'641:43.09,74.79 A:91121'}
G[701812]={'831:49.00,74.89 A:123395'}
G[701813]={'809:0.00,0.00 A:114790'}
G[701814]={'750:35.23,33.56 A:117334'}
G[701815]={'831:0.00,0.00 A:127476'}
G[701816]={'641:62.43,70.87 A:95617'}
G[701817]={'830:42.00,70.28 A:123110'}
G[701818]={'830:58.52,76.34 A:123422'}
G[701819]={'832:42.14,74.96 A:125525'}
G[701820]={'641:51.36,43.66 A:115008'}
G[701821]={'921:22.03,52.14 A:125666'}
G[701822]={'830:57.98,77.44 A:119602'}
G[701823]={'921:24.71,55.91 A:125666'}
G[701824]={'923:61.98,82.34 A:125137'}
G[701825]={'832:68.97,54.46 A:125525'}
G[701826]={'885:78.44,37.35 A:121589'}
G[701827]={'921:24.52,44.81 A:125587'}
G[701828]={'630:53.91,58.78 A:101554'}
G[701829]={'830:58.02,75.19 A:119602'}
G[701830]={'830:63.97,89.47 A:127151'}
G[701831]={'910:0.00,0.00 A:77789'}
G[701832]={'830:50.78,20.48 A:124988'}
G[701833]={'830:69.51,35.45 A:126419'}
G[701834]={'922:52.62,57.69 A:125655'}
G[701835]={'646:48.05,67.36 A:115056'}
G[701836]={'324:0.00,0.00 A:42333'}
G[701837]={'646:50.22,70.76 A:115054'}
G[701838]={'830:32.70,74.42 A:123110'}
G[701839]={'646:43.89,64.77 A:115620'}
G[701840]={'830:61.09,21.17 A:123659'}
G[701841]={'646:66.11,30.23 A:117140'}
G[701842]={'22:47.02,63.83 A:44452'}
G[701843]={'52:54.68,31.00 A:114'}
G[701844]={'22:48.98,63.70 A:44466'}
G[701845]={'634:60.67,88.91 A:103453'}
G[701846]={'225:0.00,0.00 A:46417'}
G[701847]={'641:74.03,35.63 A:106331'}
G[701848]={'23:4.23,36.07 A:45431'}
G[701849]={'225:0.00,0.00 A:46410'}
G[701850]={'9:0.00,0.00 A:2988'}
G[701851]={'627:37.88,40.12 A:103976'}
G[701852]={'225:0.00,0.00 A:46409'}
G[701853]={'7:42.72,17.61 A:3056'}
G[701854]={'23:61.41,44.41 A:45736'}
G[701855]={'18:37.34,47.91 A:1535'}
G[701856]={'634:62.02,24.66 A:117080'}
G[701857]={'52:56.44,49.59 A:234'}
G[701858]={'217:50.50,24.04 A:45301'}
G[701859]={'882:57.46,39.56 A:124440'}
G[701860]={'317:0.00,0.00 A:45323'}
G[701861]={'21:52.00,65.06 A:45878'}
G[701862]={'393:35.29,65.67 A:43929'}
G[701863]={'21:52.00,65.06 A:45880'}
G[701864]={'924:41.50,39.17 A:126231'}
G[701865]={'886:35.00,56.24 A:77789'}
G[701866]={'21:52.00,65.06 A:45879'}
G[701867]={'21:44.21,72.96 A:45878'}
G[701868]={'15:18.17,42.33 A:46654'}
G[701869]={'885:57.07,51.02 A:127114'}
G[701870]={'885:60.34,46.81 A:126457'}
G[701871]={'49:60.64,36.36 A:43733'}
G[701872]={'650:51.99,39.44 A:94986'}
G[701873]={'199:45.12,85.45 A:37847'}
G[701874]={'680:26.00,13.74 A:112334'}
G[701875]={'650:25.14,59.40 A:103215'}
G[701876]={'15:18.85,42.82 A:47024'}
G[701877]={'301:0.00,0.00 A:44402'}
G[701878]={'291:0.00,0.00 A:46612'}
G[701879]={'630:38.69,6.28 A:115666'}
G[701880]={'630:58.89,58.12 A:89053'}
G[701881]={'15:18.85,42.82 A:47022'}
G[701882]={'66:78.65,23.23 A:4672'}
G[701883]={'641:24.47,71.44 A:108879'}
G[701884]={'15:14.42,64.22 A:47021'}
G[701885]={'66:53.52,82.52 A:35591'}
G[701886]={'66:27.30,63.04 A:36196'}
G[701887]={'641:33.79,42.95 A:103307'}
G[701888]={'15:14.42,64.22 A:47024'}
G[701889]={'291:0.00,0.00 A:48445'}
G[701890]={'66:27.26,63.26 A:1196393'}
G[701891]={'695:55.99,18.70 A:101527'}
G[701892]={'641:45.26,45.52 A:93318'}
G[701893]={'15:14.42,64.22 A:47022'}
G[701894]={'641:54.31,85.70 A:91474'}
G[701895]={'680:60.46,43.88 A:104404'}
G[701896]={'641:52.70,80.08 A:93489'}
G[701897]={'32:58.59,52.62 A:47281'}
G[701898]={'292:0.00,0.00 A:47626'}
G[701899]={'189:0.00,0.00 A:37120'}
G[701900]={'186:0.00,0.00 A:38608'}
G[701901]={'21:43.20,74.58 A:45879'}
G[701902]={'21:44.06,74.61 A:45880'}
G[701903]={'21:44.06,74.61 A:45878'}
G[701904]={'21:42.54,79.17 A:45878'}
G[701905]={'292:0.00,0.00 A:46612'}
G[701906]={'21:40.90,79.73 A:45879'}
G[701907]={'21:40.90,79.73 A:45878'}
G[701908]={'21:46.60,82.69 A:45896'}
G[701909]={'21:46.60,82.69 A:45878'}
G[701910]={'630:60.49,19.92 A:115969'}
G[701911]={'695:59.73,14.15 A:101527'}
G[701912]={'310:0.00,0.00 A:47293'}
G[701913]={'86:76.44,34.46 A:3355'}
G[701914]={'186:0.00,0.00 A:38609'}
G[701915]={'750:46.15,40.42 A:111184'}
G[701916]={'641:38.03,78.06 A:104290'}
G[701917]={'186:0.00,0.00 A:38607'}
G[701918]={'650:43.23,71.91 A:102886'}
G[701919]={'750:56.50,25.44 A:104615'}
G[701920]={'186:0.00,0.00 A:38606'}
G[701921]={'650:36.54,20.32 A:115665'}
G[701922]={'32:38.76,27.94 A:14628'}
G[701923]={'646:48.09,40.12 A:121176'}
G[701924]={'36:54.64,24.54 A:48567'}
G[701925]={'36:77.91,55.32 A:48567'}
G[701926]={'630:60.48,57.28 A:89283'}
G[701927]={'634:48.68,56.91 A:107753'}
G[701928]={'36:65.01,59.58 A:48567'}
G[701929]={'646:79.56,41.21 A:117611'}
G[701930]={'630:45.97,36.47 A:88084'}
G[701931]={'634:56.15,39.96 A:115291'}
G[701932]={'830:57.88,57.53 A:122974'}
G[701933]={'630:30.43,25.71 A:103784'}
G[701934]={'630:46.98,11.67 A:90648'}
G[701935]={'646:40.61,60.37 A:118971'}
G[701936]={'220:0.00,0.00 A:46077'}
G[701937]={'641:38.36,70.90 A:103245'}
G[701938]={'641:23.18,68.63 A:111459'}
G[701939]={'695:61.65,17.37 A:101527'}
G[701940]={'641:23.18,68.63 A:111474'}
G[701941]={'650:35.59,22.07 A:115669'}
G[701942]={'650:51.96,11.01 A:104582'}
G[701943]={'630:50.84,59.36 A:89097'}
G[701944]={'680:38.82,59.30 A:113190'}
G[701945]={'634:55.38,42.62 A:103514'}
G[701946]={'646:53.78,79.61 A:118223'}
G[701947]={'634:65.13,55.74 A:108856'}
G[701948]={'630:65.02,71.40 A:103784'}
G[701949]={'646:46.29,50.46 A:119053'}
G[701950]={'646:38.22,27.64 A:117509'}
G[701951]={'634:54.97,38.74 A:105532'}
G[701952]={'17:39.29,35.84 A:7783'}
G[701953]={'646:39.17,28.82 A:117516'}
G[701954]={'634:48.78,20.06 A:104289'}
G[701955]={'646:81.52,27.30 A:120952'}
G[701956]={'634:47.69,22.07 A:103729'}
G[701957]={'77:51.22,80.31 A:10920'}
G[701958]={'646:39.27,41.89 A:117091'}
G[701959]={'630:37.51,14.01 A:110448'}
G[701960]={'634:45.53,81.89 A:91244'}
G[701961]={'634:48.73,23.39 A:103453'}
G[701962]={'650:25.49,56.85 A:103210'}
G[701963]={'925:57.90,48.21 A:125148'}
G[701964]={'650:49.84,12.13 A:98194'}
G[701965]={'885:65.14,50.69 A:126198'}
G[701966]={'650:60.62,59.03 A:103431'}
G[701967]={'650:60.12,57.83 A:103457'}
G[701968]={'650:27.11,54.56 A:103729'}
G[701969]={'885:62.60,54.50 A:126233'}
G[701970]={'634:62.77,89.89 A:103210'}
G[701971]={'649:69.53,31.63 A:91575'}
G[701972]={'650:45.06,12.22 A:97920'}
G[701973]={'641:51.39,7.34 A:115668'}
G[701974]={'649:59.88,39.73 A:93377'}
G[701975]={'634:51.97,55.00 A:107755'}
G[701976]={'405:0.00,0.00 A:54432'}
G[701977]={'641:60.35,79.47 A:108675'}
G[701978]={'77:61.84,12.64 A:7156'}
G[701979]={'885:65.41,69.33 A:126165'}
G[701980]={'646:60.15,28.22 A:117303'}
G[701981]={'641:37.72,61.33 A:120144'}
G[701982]={'322:0.00,0.00 A:44566'}
G[701983]={'83:57.21,75.39 A:7453'}
G[701984]={'77:67.43,8.33 A:11556'}
G[701985]={'830:57.29,55.41 A:122942'}
G[701986]={'650:57.22,92.55 A:103514'}
G[701987]={'885:64.45,55.40 A:126109'}
G[701988]={'630:50.18,37.82 A:88101'}
G[701989]={'219:0.00,0.00 A:40712'}
G[701990]={'337:0.00,0.00 A:52053'}
G[701991]={'641:59.73,66.79 A:103785'}
G[701992]={'831:39.32,21.37 A:126408'}
G[701993]={'406:0.00,0.00 A:54432'}
G[701994]={'641:64.98,55.91 A:105932'}
G[701995]={'832:0.00,0.00 A:125346'}
G[701996]={'219:0.00,0.00 A:7272'}
G[701997]={'641:42.31,76.16 A:109281'}
G[701998]={'630:60.59,23.96 A:106920'}
G[701999]={'641:33.05,60.17 A:111383'}
G[702000]={'78:70.97,73.92 A:34320'}
G[702001]={'641:38.68,76.11 A:103729'}
G[702002]={'646:76.61,26.38 A:120962'}
G[702003]={'650:51.87,60.80 A:108185'}
G[702004]={'695:58.72,28.20 A:77789'}
G[702005]={'924:59.97,72.43 A:125634'}
G[702006]={'71:36.01,49.48 A:34320'}
G[702007]={'641:45.40,41.06 A:111281'}
G[702008]={'695:71.50,35.28 A:77789'}
G[702009]={'646:55.21,56.38 A:118390'}
G[702010]={'646:27.76,62.61 A:118786'}
G[702011]={'71:31.80,45.11 A:34320'}
G[702012]={'69:52.63,57.34 A:39896'}
G[702013]={'239:0.00,0.00 A:44969'}
G[702014]={'71:33.72,59.99 A:34320'}
G[702015]={'646:54.55,73.01 A:118057'}
G[702016]={'830:33.26,70.23 A:123109'}
G[702017]={'646:75.95,28.19 A:120935'}
G[702018]={'393:58.86,50.06 A:101527'}
G[702019]={'81:43.65,47.45 A:34320'}
G[702020]={'646:45.80,20.30 A:118322'}
G[702021]={'78:43.19,82.91 A:34320'}
G[702022]={'830:72.00,62.26 A:122835'}
G[702023]={'921:24.28,54.79 A:125483'}
G[702024]={'830:57.76,72.86 A:119533'}
G[702025]={'402:0.00,0.00 A:54432'}
G[702026]={'885:71.05,70.54 A:126168'}
G[702027]={'926:56.01,36.71 A:125148'}
G[702028]={'292:0.00,0.00 A:47739'}
G[702029]={'86:61.23,34.75 A:4752'}
G[702030]={'320:0.00,0.00 A:15503'}
G[702031]={'310:0.00,0.00 A:4278'}
G[702032]={'885:65.52,63.33 A:126165'}
G[702033]={'213:0.00,0.00 A:61724'}
G[702034]={'76:29.84,74.80 A:35095'}
G[702035]={'320:0.00,0.00 A:15502'}
G[702036]={'221:0.00,0.00 A:74409'}
G[702037]={'634:67.63,52.66 A:108827'}
G[702038]={'76:56.97,50.14 A:1201578'}
G[702039]={'641:38.84,76.43 A:103210'}
G[702040]={'627:46.45,64.01 A:77789'}
G[702041]={'226:0.00,0.00 A:1175084'}
G[702042]={'221:0.00,0.00 A:74565'}
G[702043]={'634:60.17,28.62 A:109967'}
G[702044]={'627:45.89,59.22 A:77789'}
G[702045]={'831:67.65,55.71 A:127151'}
G[702046]={'221:0.00,0.00 A:75155'}
G[702047]={'226:0.00,0.00 A:1142487'}
G[702048]={'634:61.26,92.50 A:103745'}
G[702049]={'221:0.00,0.00 A:74408'}
G[702050]={'63:61.60,52.33 A:12677'}
G[702051]={'227:0.00,0.00 A:6235'}
G[702052]={'646:64.44,16.22 A:118819'}
G[702053]={'634:44.27,80.58 A:91244'}
G[702054]={'63:40.22,66.32 A:12678'}
G[702055]={'650:38.10,60.25 A:95916'}
G[702056]={'695:56.24,25.82 A:101527'}
G[702057]={'634:74.49,58.76 A:94337'}
G[702058]={'630:58.17,53.17 A:109349'}
G[702059]={'634:81.40,56.24 A:98501'}
G[702060]={'695:72.97,33.15 A:101527'}
G[702061]={'568:0.00,0.00 A:73335'}
G[702062]={'882:58.48,13.34 A:126997'}
G[702063]={'650:30.92,29.24 A:101794'}
G[702064]={'568:0.00,0.00 A:73318'}
G[702065]={'922:45.93,59.79 A:125634'}
G[702066]={'57:59.85,59.74 A:1007510'}
G[702067]={'627:38.66,31.06 A:101527'}
G[702068]={'634:53.94,28.43 A:103786'}
G[702069]={'650:51.64,73.75 A:104243'}
G[702070]={'641:69.18,59.32 A:103785'}
G[702071]={'646:38.55,58.03 A:118971'}
G[702072]={'641:52.83,9.72 A:115668'}
G[702073]={'695:71.84,35.26 A:43929'}
G[702074]={'641:48.10,7.43 A:115664'}
G[702075]={'630:38.06,17.53 A:110448'}
G[702076]={'630:51.34,34.72 A:109174'}
G[702077]={'634:66.45,41.70 A:109795'}
G[702078]={'646:72.44,25.77 A:118680'}
G[702079]={'641:48.10,7.43 A:115676'}
G[702080]={'650:57.49,60.61 A:103681'}
G[702081]={'633:59.24,41.75 A:108334'}
G[702082]={'627:73.19,46.92 A:101527'}
G[702083]={'25:38.90,57.59 A:48020'}
G[702084]={'641:33.14,42.87 A:103745'}
G[702085]={'627:58.77,48.37 A:77789'}
G[702086]={'630:59.39,42.16 A:89025'}
G[702087]={'25:58.21,72.47 A:2373'}
G[702088]={'646:76.05,25.36 A:118683'}
G[702089]={'630:38.24,17.49 A:105361'}
G[702090]={'831:39.61,22.67 A:124312'}
G[702091]={'650:49.23,7.48 A:97920'}
G[702092]={'630:49.03,57.77 A:89097'}
G[702093]={'25:24.64,87.56 A:48470'}
G[702094]={'695:57.52,16.57 A:101527'}
G[702095]={'630:35.69,14.84 A:105362'}
G[702096]={'649:65.36,26.27 A:91575'}
G[702097]={'641:33.09,40.55 A:103745'}
G[702098]={'25:24.64,87.56 A:48503'}
G[702099]={'685:49.02,39.92 A:105623'}
G[702100]={'634:61.71,93.41 A:104290'}
G[702101]={'650:44.50,27.68 A:104328'}
G[702102]={'25:50.19,46.38 A:49035'}
G[702103]={'680:32.75,75.04 A:108314'}
G[702104]={'885:59.88,52.03 A:126197'}
G[702105]={'695:58.55,28.03 A:101527'}
G[702106]={'25:44.06,49.31 A:49035'}
G[702107]={'641:32.65,60.32 A:109692'}
G[702108]={'886:62.56,62.03 A:127120'}
G[702109]={'831:0.00,0.00 A:119388'}
G[702110]={'630:31.43,53.90 A:107368'}
G[702111]={'401:0.00,0.00 A:54432'}
G[702112]={'831:0.00,0.00 A:125346'}
G[702113]={'830:57.63,74.41 A:120395'}
G[702114]={'831:0.00,0.00 A:124595'}
G[702115]={'830:56.04,75.82 A:119602'}
G[702116]={'830:60.02,77.31 A:119533'}
G[702117]={'86:53.14,55.11 A:43062'}
G[702118]={'695:55.49,21.99 A:101527'}
G[702119]={'790:44.28,37.54 A:111647'}
G[702120]={'830:36.10,71.77 A:123109'}
G[702121]={'22:40.65,52.03 A:44466'}
G[702122]={'50:43.90,52.27 A:1144'}
G[702123]={'650:42.04,49.45 A:103681'}
G[702124]={'641:58.65,61.36 A:93318'}
G[702125]={'650:56.11,90.22 A:103514'}
G[702126]={'213:0.00,0.00 A:61716'}
G[702127]={'279:0.00,0.00 A:5768'}
G[702128]={'279:0.00,0.00 A:5767'}
G[702129]={'279:0.00,0.00 A:3653'}
G[702130]={'646:77.37,39.70 A:117611'}
G[702131]={'641:46.27,51.13 A:110915'}
G[702132]={'942:50.67,77.02 A:129808'}
G[702133]={'942:46.65,73.83 A:133953'}
G[702134]={'942:58.64,70.44 A:134752'}
G[702135]={'1183:71.23,52.11 942:44.85,75.89 A:133953'}
G[702136]={'895:73.76,39.46 A:137871'}
G[702137]={'942:57.89,85.92 A:137866'}
G[702138]={'895:52.49,28.55 A:125042'}
G[702139]={'942:46.40,36.98 A:138735'}
G[702140]={'942:66.34,56.51 A:130714'}
G[702141]={'942:51.29,36.96 A:138735'}
G[702142]={'1161:67.60,22.21 895:73.70,25.15 A:121239'}
G[702143]={'895:85.72,76.62 A:125342'}
G[702144]={'942:40.41,36.96 A:135794'}
G[702145]={'942:40.20,37.66 A:135795'}	-- 942:40.11,37.13
G[702146]={'942:36.22,74.72 A:136574'}
G[702147]={'895:78.10,47.84 A:122671'}
G[702148]={'895:80.35,81.46 A:126620'}
G[702149]={'895:77.33,83.97 A:126620'}
G[702150]={'895:78.11,47.94 A:121239'}
G[702151]={'863:45.71,57.47 A:136675'}
G[702152]={'895:42.46,29.35 A:126298'}
G[702153]={'895:41.29,27.00 A:125922'}
G[702154]={'895:39.50,26.67 A:125922'}
G[702155]={'895:70.09,18.57 A:129669'}
G[702156]={'895:68.85,13.17 A:129613'}
G[702157]={'895:35.20,24.19 A:126298'}
G[702158]={'895:35.24,24.17 A:126308'}
G[702159]={'895:35.24,24.27 A:125922'}
G[702160]={'895:56.47,61.73 A:121235'}
G[702161]={'895:39.52,12.71 A:129655'}
G[702162]={'1161:50.01,87.58 895:69.45,40.97 A:135259'}
G[702163]={'896:50.60,24.43 A:127015'}
G[702164]={'896:44.80,28.56 A:127715'}
G[702165]={'896:42.59,25.24 A:127715'}
G[702166]={'1161:69.71,26.81 A:135614'}
G[702167]={'1161:66.86,33.25 895:73.52,27.82 A:131290'}
G[702168]={'896:19.19,43.51 A:136234'}
G[702169]={'863:34.08,78.56 A:126713'}
G[702170]={'1161:59.29,29.79 A:140904'}
G[702171]={'863:45.21,71.05 A:130844'}
G[702172]={'863:28.76,72.63 A:126713'}
G[702173]={'1165:46.22,19.25 862:56.72,35.50 A:126560'}
G[702174]={'62:43.41,75.57 A:134578'}
G[702175]={'1165:42.29,9.09 862:55.41,32.12 A:126560'}
G[702176]={'1165:40.92,11.33 862:54.96,32.87 A:126564'}
G[702177]={'62:45.20,74.96 A:134578'}
G[702178]={'1165:46.10,13.08 862:56.68,33.45 A:126560'}
G[702179]={'1165:42.54,9.47 862:55.50,32.25 A:126564'}
G[702180]={'62:34.73,85.11 A:134578'}
G[702181]={'62:42.30,66.80 A:133693'}
G[702182]={'89:40.01,50.44 A:134578'}
G[702183]={'62:50.44,19.69 A:134578'}
G[702184]={'62:50.42,20.01 A:140877'}
G[702185]={'864:44.65,87.00 A:124468'}
G[702186]={'864:47.06,75.80 A:129514'}
G[702187]={'85:48.59,70.94 1:45.18,4.09 A:14720'}
G[702188]={'85:49.02,91.80 1:45.32,10.96 A:140176'}
G[702189]={'864:61.85,33.70 A:130474'}
G[702190]={'862:74.88,24.91 A:124655'}
G[702191]={'862:65.70,30.23 A:129907'}
G[702192]={'863:56.54,26.71 A:127961'}
G[702193]={'896:32.30,54.65 A:136683'}
G[702194]={'863:46.21,82.93 A:121241'}
G[702195]={'896:37.21,27.25 A:136725'}
G[702196]={'862:54.38,87.01 A:130821'}
G[702197]={'896:37.17,27.11 A:136683'}
G[702198]={'862:48.56,26.79 A:122760'}
G[702199]={'862:48.87,42.74 A:132041'}
G[702200]={'1165:42.51,9.58 862:55.48,32.29 A:133302'}
G[702201]={'862:62.87,28.27 A:129907'}
G[702202]={'1165:42.46,9.49 862:55.47,32.26 A:133324'}
G[702203]={'862:49.61,64.46 A:127837'}
G[702204]={'896:32.36,54.57 A:136725'}
G[702205]={'862:40.03,76.55 A:131580'}
G[702206]={'892:34.04,65.56 891:22.75,47.08 A:120977'}
G[702207]={'63:35.18,49.48 A:134574'}
G[702208]={'893:39.51,77.09 891:34.85,46.98 A:120977'}
G[702209]={'62:44.10,90.45 A:134554'}
G[702210]={'62:42.72,67.77 A:134554'}
G[702211]={'62:44.75,86.76 A:134554'}
G[702212]={'627:73.00,44.27 A:98519'}
G[702213]={'63:12.02,33.77 A:134554'}
G[702214]={'62:42.84,87.42 A:134554'}
G[702215]={'62:42.39,82.08 A:134554'}
G[702216]={'62:43.36,75.64 A:135003'}
G[702217]={'62:43.32,84.74 A:134554'}
G[702218]={'1188[11]:0.00,0.00 A:128949'}
G[702219]={'891:21.36,55.11 A:121756'}
G[702220]={'1033:49.19,82.75 A:115806'}
G[702221]={'1165:42.51,9.58 862:55.48,32.29 A:133302'}
G[702222]={'1165:42.46,9.49 862:55.47,32.26 A:133324'}
G[702223]={'863:56.57,26.71 A:127960'}
G[702224]={'863:65.69,17.94 A:127958'}
G[702225]={'863:58.53,13.76 A:127958'}
G[702226]={'863:58.50,13.78 A:127961'}
G[702227]={'863:58.50,13.78 A:127960'}
G[702228]={'85:48.59,70.94 1:45.18,4.09 A:14720'}
G[702229]={'85:49.02,91.80 1:45.32,10.96 A:140176'}
G[702230]={'863:68.68,35.15 A:131253'}
G[702231]={'863:72.48,29.32 A:131253'}
G[702232]={'863:25.82,35.98 A:126346'}
G[702233]={'1165:42.51,9.58 862:55.48,32.29 A:133302'}
G[702234]={'1165:42.46,9.49 862:55.47,32.26 A:133324'}
G[702235]={'863:45.20,60.44 A:133125'}
G[702236]={'85:48.59,70.94 1:45.18,4.09 A:14720'}
G[702237]={'85:49.02,91.80 1:45.32,10.96 A:140176'}
G[702238]={'863:43.94,70.06 A:132624'}
G[702239]={'525:55.03,71.49 A:80782'}
G[702240]={'590:38.43,74.02 525:47.27,68.86 A:79892'}
G[702241]={'62:45.81,69.00 A:101527'}
G[702242]={'590:39.41,54.38 525:47.39,66.60 A:92400'}
G[702243]={'543:57.01,14.58 A:91601'}
G[702244]={'525:41.66,72.27 A:91242'}
G[702245]={'590:37.51,76.32 525:47.17,69.12 A:79892'}
G[702246]={'892:34.04,65.56 891:22.75,47.08 A:120977'}
G[702247]={'893:39.51,77.09 891:34.85,46.98 A:120977'}
G[702248]={'62:62.46,7.77 A:143512'}
G[702249]={'62:40.23,52.60 A:142713'}
G[702250]={'85:48.60,70.81 1:45.19,4.05 A:14720'}
G[702251]={'85:48.96,91.65 1:45.30,10.91 A:140176'}
G[702252]={'895:77.52,49.89 A:138287'}
G[702253]={'895:87.98,75.03 A:32641'}
G[702254]={'863:31.17,49.78 A:32641'}
G[702255]={'1169:47.36,46.25 A:121239'}
G[702256]={'864:51.41,32.97 A:124527'}
G[702257]={'863:35.66,85.63 A:32641'}
G[702258]={'862:64.73,21.71 A:32641'}
G[702259]={'863:39.37,57.52 A:126079'}
G[702260]={'863:32.68,55.86 A:127224'}
G[702261]={'862:49.27,54.44 A:130953'}
G[702262]={'862:51.99,32.71 A:124749'}
G[702263]={'942:66.87,60.78 A:32642'}
G[702264]={'862:74.87,24.94 A:124656'}
G[702265]={'862:81.82,37.54 A:32641'}
G[702266]={'895:71.19,50.90 A:138285'}
G[702267]={'862:48.84,39.52 A:132041'}
G[702268]={'1021:50.43,53.00 A:136907'}
G[702269]={'864:60.90,32.45 A:130474'}
G[702270]={'862:65.29,28.26 A:129907'}
G[702271]={'862:62.28,35.88 A:130905'}
G[702272]={'862:64.29,44.62 A:139311'}
G[702273]={'862:64.34,44.66 A:122939'}
G[702274]={'863:48.57,37.10 A:32641'}
G[702275]={'863:60.77,20.93 A:32642'}
G[702276]={'862:40.76,70.67 A:135620'}
G[702277]={'942:70.32,36.14 A:136933'}
G[702278]={'942:68.71,54.41 A:1280727'}
G[702279]={'942:40.52,37.73 A:43929'}
G[702280]={'942:70.96,69.10 A:133204'}
G[702281]={'896:69.61,43.32 A:125380'}
G[702282]={'896:45.01,27.77 A:127715'}
G[702283]={'896:44.98,27.54 A:127715'}
G[702284]={'896:36.88,50.08 A:129642'}
G[702285]={'896:31.01,20.25 A:131638'}
G[702286]={'896:23.25,12.70 A:132994'}
G[702287]={'896:32.82,15.34 A:131638'}
G[702288]={'896:31.03,20.25 A:131636'}
G[702289]={'864:27.02,52.50 A:137543'}
G[702290]={'896:64.18,56.13 A:125130'}
G[702291]={'896:62.78,59.45 A:35642'}
G[702292]={'896:25.55,70.13 A:131442'}
G[702293]={'896:40.56,62.56 A:130933'}
G[702294]={'896:24.57,56.65 A:133098'}
G[702295]={'896:25.13,67.39 A:131469'}
G[702296]={'896:24.58,56.73 A:133105'}
G[702297]={'896:25.13,67.43 A:131879'}
G[702298]={'896:25.79,70.27 A:131879'}
G[702299]={'896:53.50,23.24 A:127015'}
G[702300]={'942:59.51,68.34 A:1281348'}
G[702301]={'864:29.93,78.56 A:139719'}
G[702302]={'864:40.70,47.84 A:139705'}
G[702303]={'864:44.99,58.75 A:139719'}
G[702304]={'864:44.96,58.78 A:139705'}
G[702305]={'864:39.65,83.91 A:139705'}
G[702306]={'864:41.09,72.61 A:139705'}
G[702307]={'864:41.11,72.57 A:139719'}
G[702308]={'1161:70.31,26.74 895:74.36,26.24 A:101527'}
G[702309]={'863:20.45,64.29 A:136615'}
G[702310]={'863:22.94,63.81 A:136615'}
G[702311]={'862:40.98,67.90 A:136550'}
G[702312]={'1021:50.16,58.16 A:136907'}
G[702313]={'862:73.68,62.41 A:127839'}
G[702314]={'862:54.77,22.55 A:136615'}
G[702315]={'1184:44.92,41.33 895:79.80,53.49 A:137147'}
G[702316]={'942:41.59,63.60 A:139793'}
G[702317]={'863:25.73,48.00 A:134759'}
G[702318]={'862:57.99,62.39 A:101527'}
G[702319]={'81:41.53,45.22 A:101527'}
G[702320]={'1163:48.28,67.97 1165:49.91,45.77 862:57.95,44.33 A:101527'}
G[702321]={'1165:52.69,88.77 862:58.87,58.63 A:129394'}
G[702322]={' A:135903'}
G[702323]={'864:60.64,60.47 A:136545'}
G[702324]={' A:136160'}
G[702325]={'864:35.01,64.67 A:136545'}
G[702326]={'863:25.57,62.40 A:136615'}
G[702327]={'379:68.89,43.98 A:143692'}
G[702328]={' A:55624'}
G[702329]={' A:55624'}
G[702330]={' A:136160'}
G[702331]={'895:61.22,46.83 A:136616'}
G[702332]={'1163:66.79,75.47 1165:51.10,46.25 862:58.34,44.49 A:131443'}
G[702333]={' A:136160'}
G[702334]={'862:55.59,22.14 A:136616'}
G[702335]={'896:39.61,39.24 A:136616'}
G[702336]={'864:34.11,63.15 A:136545'}
G[702337]={'942:36.14,69.52 A:137156'}
G[702338]={'85:39.63,78.07 1:42.23,6.44 A:19177'}
G[702339]={'1165:51.18,95.46 862:58.37,60.86 A:142159'}
G[702340]={'895:61.28,46.54 A:136615'}
G[702341]={'1163:46.96,36.98 1165:49.83,43.78 862:57.92,43.67 A:101527'}
G[702342]={'862:50.16,41.09 A:129515'}
G[702343]={'896:42.92,37.01 A:136614'}
G[702344]={'863:22.23,65.48 A:136615'}
G[702345]={' A:42333'}
G[702346]={' A:42333'}
G[702347]={'863:50.22,36.40 A:134761'}
G[702348]={'895:43.44,23.16 A:129110'}
G[702349]={'942:36.87,68.83 A:139793'}
G[702350]={'85:52.07,41.48 A:101759'}
G[702351]={'864:57.11,41.10 A:136664'}
G[702352]={'864:42.21,61.29 A:32642'}
G[702353]={'1162:48.96,99.27 A:128652'}
G[702354]={' A:54432'}
G[702355]={' A:49943'}
G[702356]={'862:76.55,27.31 A:124066'}
G[702357]={' A:54751'}
G[702358]={' A:49943'}
G[702359]={'864:59.26,59.34 A:136613'}
G[702360]={'85:70.51,44.54 A:143845'}
G[702361]={' A:57864'}
G[702362]={' A:57864'}
G[702363]={' A:54432'}
G[702364]={' A:54751'}
G[702365]={' A:54751'}
G[702366]={'864:59.61,60.77 A:136615'}
G[702367]={'942:36.45,67.93 A:137155'}
G[702368]={'863:40.58,30.39 A:122684'}
G[702369]={'863:39.57,27.95 A:122684'}
G[702370]={'1163:70.17,71.57 1165:51.31,46.00 862:58.41,44.40 A:126066'}
G[702371]={'1165:52.30,90.38 862:58.74,59.17 A:129394'}
G[702372]={'863:70.50,17.14 A:139495'}
G[702373]={'863:26.70,82.88 A:137654'}
G[702374]={'863:22.36,62.79 A:137654'}
G[702375]={'862:55.00,21.44 A:136614'}
G[702376]={'862:41.49,69.83 A:136550'}
G[702377]={'863:36.18,79.80 A:134869'}
G[702378]={'1163:49.38,35.21 1165:49.98,43.67 862:57.97,43.63 A:77789'}
G[702379]={'863:36.36,80.45 A:126723'}
G[702380]={' A:138148'}
G[702381]={'896:66.13,40.18 A:125452'}
G[702382]={'895:59.90,48.52 A:136615'}
G[702383]={'864:34.85,64.11 A:136546'}
G[702384]={'862:56.29,23.24 A:136551'}
G[702385]={'1165:50.52,89.85 862:58.15,58.99 A:129394'}
G[702386]={'863:23.55,61.30 A:136616'}
G[702387]={'896:40.83,40.60 A:136614'}
G[702388]={'863:60.93,58.19 A:135256'}
G[702389]={'863:43.61,25.48 A:122684'}
G[702390]={'1165:43.35,37.09 862:55.76,41.44 A:101527'}
G[702391]={'1185:28.79,22.37 895:79.23,53.15 A:137147'}
G[702392]={'942:70.90,85.65 A:136615'}
G[702393]={'863:69.33,15.32 A:139495'}
G[702394]={'1184:53.60,73.93 895:80.34,55.54 A:137147'}
G[702395]={'863:51.27,21.89 A:139609'}
G[702396]={'863:51.34,21.87 A:140258'}
G[702397]={'1161:69.51,20.05 895:74.16,24.63 A:101527'}
G[702398]={'896:65.53,52.76 A:144215'}
G[702399]={'862:39.80,67.96 A:136552'}
G[702400]={'85:49.16,72.34 1:45.37,4.55 A:3144'}
G[702401]={'85:47.81,71.28 1:44.93,4.21 A:35068'}
G[702402]={'864:45.01,51.31 A:136997'}
G[702403]={' A:136160'}
G[702404]={'862:66.98,34.41 A:122113'}
G[702405]={'862:57.12,22.42 A:136616'}
G[702406]={'863:34.69,82.03 A:126702'}
G[702407]={'864:59.93,61.68 A:136547'}
G[702408]={'942:72.28,85.71 A:136613'}
G[702409]={'864:58.71,60.92 A:136616'}
G[702410]={'863:45.66,46.81 A:135054'}
G[702411]={'862:80.07,35.97 A:125174'}
G[702412]={'862:40.69,67.64 A:136551'}
G[702413]={'942:70.89,84.27 A:137155'}
G[702414]={'864:53.54,88.55 A:134743'}
G[702415]={'896:40.87,37.59 A:136615'}
G[702416]={'896:66.53,41.75 A:125401'}
G[702417]={'895:61.95,46.17 A:136613'}
G[702418]={' A:136160'}
G[702419]={'863:28.65,77.22 A:134057'}
G[702420]={' A:138148'}
G[702421]={' A:135903'}
G[702422]={' A:136160'}
G[702423]={' A:56439'}
G[702424]={'862:58.10,19.04 A:121577'}
G[702425]={' A:136160'}
G[702426]={' A:54432'}
G[702427]={' A:54751'}
G[702428]={' A:42333'}
G[702429]={' A:42333'}
G[702430]={' A:54751'}
G[702431]={' A:49943'}
G[702432]={' A:54751'}
G[702433]={' A:49943'}
G[702434]={' A:55624'}
G[702435]={' A:57864'}
G[702436]={' A:55624'}
G[702437]={' A:57864'}
G[702438]={' A:54432'}
G[702439]={' A:136160'}
G[702440]={'942:31.73,31.74 A:139086'}
G[702441]={'895:48.94,25.02 A:145422'}
G[702442]={'895:50.03,26.57 A:146462'}
G[702443]={'895:53.02,30.44 A:145422'}
G[702444]={'49:28.92,67.16 A:146937'}
G[702445]={'895:50.03,26.57 A:146466'}
G[702446]={'1156:38.50,45.62 A:141541'}
G[702447]={'942:35.66,62.74 A:139793'}
G[702448]={'896:42.04,81.98 A:137732'}
G[702449]={'942:38.21,70.63 A:137156'}
G[702450]={'896:40.67,37.17 A:137131'}
G[702451]={'84:85.51,31.88 A:141291'}
G[702452]={'895:78.62,77.84 A:127537'}
G[702453]={'896:38.20,52.41 A:101527'}
G[702454]={'627:58.52,46.07 A:77789'}
G[702455]={'895:75.35,48.86 A:140732'}
G[702456]={'896:59.21,54.26 A:138245'}
G[702457]={'895:56.50,61.72 A:121239'}
G[702458]={'895:56.50,61.25 A:142393'}
G[702459]={'1161:48.28,80.61 895:69.03,39.28 A:135259'}
G[702460]={'1161:44.65,62.77 895:68.15,34.96 A:141785'}
G[702461]={'14:21.65,64.70 A:101527'}
G[702462]={'895:37.40,24.94 A:145580'}
G[702463]={'942:21.37,69.61 A:141223'}
G[702464]={'942:6.67,31.63 A:141223'}
G[702465]={'896:37.97,52.23 A:43929'}
G[702466]={'896:41.17,37.17 A:136616'}
G[702467]={'895:76.94,82.84 A:140732'}
G[702468]={'895:36.26,29.81 A:145580'}
G[702469]={'895:42.16,29.85 A:145580'}
G[702470]={'895:41.53,27.08 A:145632'}
G[702471]={'862:46.80,50.49 A:147228'}
G[702472]={'895:37.50,24.89 A:145593'}
G[702473]={'895:37.47,24.97 A:145632'}
G[702474]={'63:11.47,17.80 A:146375'}
G[702475]={'63:11.55,17.68 A:146374'}
G[702476]={'63:11.49,17.71 A:146373'}
G[702477]={'942:69.09,84.19 A:136615'}
G[702478]={'896:39.22,37.40 A:136615'}
G[702479]={'895:51.67,29.68 A:1278252'}
G[702480]={'895:42.44,29.31 A:126308'}
G[702481]={'864:35.65,62.46 A:136545'}
G[702482]={'942:66.13,47.36 A:148870'}
G[702483]={'896:26.56,13.07 A:135777'}
G[702484]={'942:66.51,44.22 A:148870'}
G[702485]={'895:59.89,46.66 A:137156'}
G[702486]={'942:66.51,44.28 A:148798'}
G[702487]={'942:71.13,44.02 A:148798'}
G[702488]={'896:40.31,40.27 A:136615'}
G[702489]={'895:59.41,48.40 A:136616'}
G[702490]={'634:32.26,49.62 A:92224'}
G[702491]={'863:33.65,47.66 A:147842'}
G[702492]={'863:35.78,68.25 A:147842'}
G[702493]={'863:44.25,78.87 A:147842'}
G[702494]={'863:44.23,78.64 A:147843'}
G[702495]={'863:22.75,64.13 A:136616'}
G[702496]={'863:44.27,78.56 A:147844'}
G[702497]={'863:50.36,84.17 A:147842'}
G[702498]={'863:50.45,84.24 A:147843'}
G[702499]={'863:50.43,84.08 A:147844'}
G[702500]={'896:66.81,51.59 A:144215'}
G[702501]={'942:52.13,39.26 A:150637'}
G[702502]={'942:50.13,63.32 A:132226'}
G[702503]={'1161:69.33,27.15 895:74.12,26.34 A:150633'}
G[702504]={'895:68.95,20.54 A:148870'}
G[702505]={'895:67.10,12.33 A:148870'}
G[702506]={'1382:52.27,68.68 A:149823'}
G[702507]={'1355:40.31,55.24 A:150101'}
G[702508]={'1355:48.80,87.02 A:150101'}
G[702509]={'1355:41.56,76.18 A:155482'}
G[702510]={'1355:45.49,74.76 A:150101'}
G[702511]={'1472:19.54,61.92 A:152385'}
G[702512]={'627:60.31,44.43 A:101527'}
G[702513]={' A:56884'}
G[702514]={'1355:39.10,54.32 A:152084'}
G[702515]={'1355:38.77,55.04 A:101527'}
G[702516]={' A:56884'}
G[702517]={'1355:39.11,54.20 A:150101'}
G[702518]={' A:56884'}
G[702519]={'1355:39.00,54.63 A:151000'}
G[702520]={' A:56884'}
G[702521]={'1462:56.77,60.17 A:153670'}
G[702522]={' A:56884'}
G[702523]={' A:56884'}
G[702524]={' A:56884'}
G[702525]={'1355:50.62,45.93 A:145337'}
G[702526]={' A:56884'}
G[702527]={' A:56884'}
G[702528]={'1355:39.98,53.13 A:156152'}
G[702529]={' A:56884'}
G[702530]={'1462:73.96,60.25 A:152633'}
G[702531]={'1355:39.45,53.53 A:154436'}
G[702532]={' A:56884'}
G[702533]={' A:56884'}
G[702534]={' A:56884'}
G[702535]={'1161:71.37,18.10 895:74.61,24.15 A:153897'}
G[702536]={'1462:71.43,38.60 A:154214'}
G[702537]={' A:56884'}
G[702538]={'1462:72.29,34.30 A:154457'}
G[702539]={'1355:39.45,53.53 A:155940'}
G[702540]={'1462:67.38,35.25 A:155450'}
G[702541]={'1462:56.38,59.24 A:32639'}
G[702542]={'1462:19.62,80.30 A:32639'}
G[702543]={'1462:71.27,42.11 A:151301'}
G[702544]={'1355:62.55,36.12 A:151000'}
G[702545]={'1355:74.65,25.80 A:151000'}
G[702546]={'1355:74.68,25.87 A:153617'}
G[702547]={'1355:74.28,40.16 A:153617'}
G[702548]={'1161:70.12,27.03 895:74.31,26.31 A:153897'}
G[702549]={'1355:66.10,43.79 A:153617'}
G[702550]={'1355:62.56,36.01 A:153617'}
G[702551]={' A:56884'}
G[702552]={' A:56884'}
G[1000033]={'52:25.97,16.90'}
G[1000034]={'52:40.63,17.03'}
G[1000035]={'52:25.90,47.75'}
G[1000036]={'52:40.52,47.78'}
G[1000055]={'37:72.65,60.33'}
G[1000056]={'37:79.80,55.50'}
G[1000061]={'47:17.72,29.04'}
G[1000068]={'37:24.55,74.68'}
G[1000256]={'48:37.3,46.5'}
G[1000259]={'56:13.94,34.81'}
G[1000261]={'56:13.52,41.38'}
G[1002059]={'27:87.63,50.14'}
G[1002076]={'50:38.51,48.52'}
G[1002083]={'210:41.26,61.17'}
G[1002688]={'14:29.87,59.77'}
G[1002701]={'14:79.81,31.65','In cave'}
G[1002702]={'14:30.02,59.03'}
G[1002713]={'14:40.2,49'}
G[1002908]={'7:53.52,48.28'}
G[1003972]={'10:68.26,71.25'}
G[1004141]={'10:50.28,25.69'}
G[1006751]={'57:57.64,63.01'}
G[1006752]={'57:37.17,25.33'}
G[1007510]={'57:43.94,44.04 57:43.91,43.99 57:43.95,44.08'}	-- TODO: Determine what the locs are when turned in at original dude.  because turned it at 2nd dude only keeps them there.
G[1007923]={'57:59.84,59.86'}
G[1020985]={'70:55.44,25.92'}
G[1020992]={'70:29.63,48.59'}
G[1021042]={'70:29.84,48.24'}
G[1024776]={'21:44.2,42.6'}
G[1035251]={'66:36.1,30.4 66:36.1,30.5'}
G[1112948]={'56:14.38,24.05'}
G[1131474]={'231:50.01,33.39 15:34.28,10.37>230'}
G[1138492]={'14:57.21,34.55'}
G[1142151]={'56:13.61,38.21'}
G[1142195]={'69:71.7,55.9'}
G[1142487]={'227:68.60,62.21'}
G[1151286]={'76:59.5,31.2'}
G[1152097]={'300:46.1,22.2 300:46.5,22.3 300:46.5,23'}
G[1156561]={'37:24.57,78.22 N:1000068'}
G[1161521]={'78:38.44,66.07'}
G[1161526]={'78:68.54,36.54'}
G[1164869]={'242:54.1,27.2'}
G[1164955]={'78:56.50,12.53'}
G[1164956]={'78:23.57,50.03'}
G[1164957]={'78:77.18,49.99'}
G[1175084]={'227:63.19,67.86 N:1142487'}
G[1175085]={'227:65.73,57.83 N:1142487'}
G[1176091]={'77:59.68,8.12'}
G[1176392]={'22:62.58,58.56'}
G[1177544]={'23:32.22,83.42'}
G[1179485]={'234:26.4,57.3 234:26.4,58.3 234:26.4,58.5 234:26.5,58.5 234:26.6,57.3 234:26.6,58.3'}
G[1179517]={'238:70.69,24.11'}
G[1179551]={'76:79.2,74.8'}
G[1179697]={'210:46.4,26.1'}
G[1179880]={'250:33.3,44.7 250:33.4,44.1 250:33.5,44.9 250:33.7,44.3'}
G[1180025]={'37:84.7,64.4'}
G[1180056]={'7:35.1,61.6 7:35.8,60.9'}
G[1180366]={''}
G[1180448]={'81:55.06,35.99'}
G[1180503]={'81:43.56,42.07'}
G[1180715]={'84:62.40,69.4'}
G[1180743]={'87:33.83,65.70 86:49.29,78.27'}
G[1180746]={'87:33.47,65.58 86:49.15,78.06'}
G[1180747]={'87:33.76,66.33 86:49.55,78.11'}
G[1180748]={'87:33.85,66.64 86:49.17,77.75'}
G[1180793]={'87:33.4,66 86:49.53,77.81'}
G[1180918]={'94:48.17,46.29'}
G[1181011]={'94:69.24,52.10'}
G[1181147]={'95:48.3,31.6 N:1000068'}
G[1181150]={'95:79.63,17.58'}
G[1181153]={'95:72.2,31.2'}
G[1181638]={'100:28,60.3 N:1000068'}
G[1181748]={'97:50.5,11.6'}
G[1181756]={'106:61.2,41.8'}
G[1181758]={'106:61.2,49.4 106:61.2,49.6'}
G[1181889]={'106:55.2,59.1 N:1000068'}
G[1182032]={'106:37.6,61.3'}
G[1182115]={'102:79.08,64.83 N:1000068'}
G[1182165]={'102:32,49.4 102:32,49.5 N:1000068'}
G[1182392]={'107:55.7,37.9'}
G[1182393]={'107:54.68,70.74'}
G[1182549]={'108:67.9,53.4 108:67.9,53.5'}
G[1182587]={'108:57.59,54.70 N:1000068'}
G[1182588]={'108:49.8,45.2 N:1000068'}
G[1182947]={'260:53.31,58.78 108:39.63,73.54>260'}
G[1183284]={'102:41.74,27.27 N:1000068'}
G[1183770]={'109:23.2,68.1'}
G[1183811]={'109:32.1,64.7 N:1000068'}
G[1183877]={''}
G[1184300]={'109:60.3,78'}
G[1184660]={'105:51.9,57.8 N:1000068'}
G[1184825]={'105:34.3,77.3 105:34.4,77.8 105:34.5,77.7 105:35.7,79.1'}
G[1184945]={'104:30.4,30.9 104:30.5,30.8 N:1000068'}
G[1184946]={'104:38.3,54 N:1000068'}
G[1185035]={'105:36.6,67.3 N:1000068'}
G[1185126]={'104:51.4,72.8 104:51.5,72.7'}
G[1185165]={'105:73.3,40.1'}
G[1185166]={'100:61.2,80.6 N:1000068'}
G[1186426]={'70:41.75,73.11 N:1000068'}
G[1186585]={'117:75.93,19.74'}
G[1186887]={'27:53.50,50.45 37:42.39,65.87 1:52.6,42.4 97:48.9,51.0 94:47.6,46.4'} -- for Alliance 20:61,52.7 is not right PS Seemed right this year
G[1187236]={'86:49.39,77.61 87:33.65,65.63'}
G[1187273]={'70:29.70,47.63'}
G[1187559]={'HM 21:49.62,38.60'}
G[1187564]={'HM 52:45.1,62.48'}
G[1187565]={'114:54.63,35.88'}
G[1187851]={'114:57.56,69.13'}
G[1187905]={'114:48.55,59.03'}
G[1187914]={'HM 14:44.58,46.1 N:1187564'}
G[1187916]={'HM 63:86.77,41.51 N:1187564'}
G[1187917]={'HM 97:44.7,52.5 N:1187564'}
G[1187919]={'HM 105:41.8,65.9 N:1187564'}
G[1187920]={'HM 17:55.2,15.3 N:1187564'}
G[1187921]={'HM 106:55.8,68.7 N:1187564'}
G[1187922]={'HM 36:68.5,59.8 N:1187564'}
G[1187923]={'HM 62:48.92,22.58 N:1187564'}
G[1187924]={'HM 66:65.89,16.93 N:1187564'}
G[1187925]={'HM 27:53.8,44.7 N:1187564'}
G[1187926]={'HM 47:73.2,55.1 N:1187564'}
G[1187927]={'HM 70:62.04,40.41 N:1187564'}
G[1187928]={'HM 37:43.22,62.92 N:1187564'}
G[1187929]={'HM 69:46.66,43.72 N:1187564'}
G[1187930]={'HM 100:51.9,58.5 N:1187564'}
G[1187932]={'HM 48:32.32,40.2 N:1187564'}
G[1187933]={'HM 107:49.6,69.9 N:1187564'}
G[1187934]={'HM 49:24.6,54 N:1187564'}
G[1187935]={'HM 104:39.6,54.3 N:1187564'}
G[1187936]={'HM 57:54.7,52.7 N:1187564'}
G[1187937]={'HM 108:54.2,55.4 N:1187564'}
G[1187938]={'HM 26:14.47,49.81 N:1187564'}
G[1187939]={'HM 22:43.6,82.4 N:1187564'}
G[1187940]={'HM 56:13.2,47.4 N:1187564'}
G[1187941]={'HM 102:68.5,52.2 N:1187564'}
G[1187942]={'HM 109:31,62.8 N:1187564'}
G[1187943]={'HM 81:60.4,33.14 N:1187564'}
G[1187944]={'HM 210:51.7,67.2 N:1187564'}
G[1187945]={'HM 71:52.64,30.07 N:1187564'}
G[1187946]={'HM 83:61.38,47.17 N:1187564'}
G[1187947]={'HM 14:69.15,42.83 N:1187559'}
G[1187948]={'HM 63:51.58,66.66 N:1187559'}
G[1187949]={'HM 109:32.29,68.26 N:1187559'}
G[1187950]={'HM 81:50.86,41.80 N:1187559'}
G[1187951]={'HM 210:50.50,70.69 N:1187559'}
G[1187952]={'HM 71:49.81,28.17 N:1187559'}
G[1187953]={'HM 83:58.05,47.24 N:1187559'}
G[1187954]={'HM 15:24.05,37.08 N:1187559'}
G[1187955]={'HM 105:50.01,59.00 N:1187559'}
G[1187956]={'HM 36:51.45,29.11 N:1187559'}
G[1187957]={'HM 66:26.19,77.29 N:1187559'}
G[1187958]={'HM 1:51.98,47.19 N:1187559'}
G[1187959]={'HM 70:33.26,30.71 N:1187559'}
G[1187960]={'HM 94:46.38,50.35 N:1187559'}
G[1187961]={'HM 69:72.45,47.57 N:1187559'}
G[1187962]={'HM 95:47.12,25.97 N:1187559'}
G[1187963]={'HM 100:57.16,41.82 N:1187559'}
G[1187964]={'HM 25:54.56,49.85 N:1187559'}
G[1187965]={'HM 7:51.93,59.46 N:1187559'}
G[1187966]={'HM 107:51.07,34.02 N:1187559'}
G[1187967]={'HM 104:33.49,30.32 N:1187559'}
G[1187968]={'HM 65:52.99,62.27 N:1187559'}
G[1187969]={'HM 51:76.70,14.12 N:1187559'}
G[1187970]={'HM 108:51.94,43.18 N:1187559'}
G[1187971]={'HM 10:49.86,54.39 N:1187559'}
G[1187972]={'HM 26:76.69,74.60 N:1187559'}
G[1187974]={'HM 18:57.04,51.72 N:1187559'}
G[1187975]={'HM 102:35.57,51.75 N:1187559'}
G[1188085]={'114:56.81,55.56'}
G[1188261]={'116:64.29,19.76'}
G[1188364]={'115:47.70,80.01'}
G[1188365]={'116:36.95,32.35'}
G[1188418]={'115:37.6,46.5 115:37.7,46.4 N:1000256'}
G[1188419]={'115:36.64,64.97'}
G[1188649]={'115:77,62.8 N:1000068'}
G[1188667]={'116:31.80,59.55'}
G[1189303]={'HW 37:43.73,65.90 N:500022'}
G[1189311]={'115:78.62,52.29'}
G[1189989]={'HB 27:56.01,37.05'}
G[1189990]={'HB 1:40.67,17.38 N:1189989'}
G[1190020]={'115:77.34,51.43 N:1000256'}
G[1190034]={'HW 57:55.36,52.28 N:500022'}
G[1190035]={'HW 63:37.01,49.26 N:500022'}
G[1190036]={'HW 27:54.49,50.77 N:500022'}
G[1190037]={'HW 97:48.49,49.04 N:500022'}
G[1190038]={'HW 89:62.26,33.16 N:500022'}
G[1190039]={'HW 87:18.32,50.98 N:500022'}
G[1190040]={'HW 84:60.51,75.34 N:500022'}
G[1190041]={'HW 103:59.23,18.50 N:500022'}
G[1190042]={'HW 62:37,44.1 N:500022'}	-- was removed
G[1190043]={'HW 48:35.54,48.50 N:500022'}
G[1190044]={'HW 56:10.81,61.00 N:500022'}
G[1190045]={'HW 106:55.70,59.96 N:500022'}
G[1190046]={'HW 49:26.46,41.51 N:500022'}
G[1190047]={'HW 52:56.81,47.32 N:500022'}
G[1190048]={'HW 47:73.79,44.25 N:500022'}
G[1190050]={'HW 65:40.53,17.69 N:500022'}
G[1190051]={'HW 66:66.33,6.58 N:500022'}
G[1190052]={'HW 70:66.59,45.28 N:500022'}	-- Theramore...now destroyed
G[1190053]={'HW 69:46.33,45.19 N:500022'}
G[1190054]={'HW 26:14.19,44.60 N:500022'}
G[1190055]={'HW 100:54.25,63.70 N:500022'}
G[1190056]={'HW 100:23.42,36.38 N:500022'}
G[1190057]={'HW 102:67.16,48.94 N:500022'}
G[1190058]={'HW 102:41.91,26.17 N:500022'}
G[1190059]={'HW 108:56.59,53.23 N:500022'}
G[1190060]={'HW 107:54.19,75.87 N:500022'}
G[1190061]={'HW 105:35.83,63.73 N:500022'}
G[1190062]={'HW 105:61.05,68.08 N:500022'}
G[1190063]={'HW 104:37.02,58.29 N:500022'}
G[1190064]={'HW 1:51.54,41.59 N:500022'}
G[1190065]={'HW 7:46.79,60.41 N:500022'}
G[1190066]={'HW 18:60.98,51.40 N:500022'}
G[1190067]={'HW 94:48.20,47.87 N:500022'}
G[1190068]={'HW 94:43.70,71.03 N:500022'}
G[1190069]={'HW 86:53.91,78.93 N:500022'}
G[1190070]={'HW 88:45.62,64.85 N:500022'}
G[1190071]={'HW 998:67.74,37.75 N:500022'}
G[1190072]={'HW 110:79.43,57.65 N:500022'}
G[1190073]={'HW 110:67.60,72.92 N:500022'}
G[1190074]={'HW 21:46.45,42.90 N:500022'}
G[1190075]={'HW 95:48.68,31.91 N:500022'}
G[1190076]={'HW 10:49.51,57.91 N:500022'}
G[1190077]={'HW N:500022'}	-- was removed
G[1190078]={'HW 25:57.86,47.27 N:500022'}
G[1190079]={'HW 63:73.96,60.60 N:500022'}
G[1190080]={'HW 65:50.39,63.80 N:500022'}
G[1190081]={'HW 64:46.1,51.4 64:46.1,51.5 N:500022'}	-- was removed
G[1190082]={'HW 14:69.01,33.28 N:500022'}
G[1190083]={'HW 66:24.08,68.29 N:500022'}
G[1190084]={'HW 50:37.37,51.77 N:500022'}
G[1190085]={'HW 70:36.78,32.43 N:500022'}
G[1190086]={'HW 51:46.89,56.90 N:500022'}
G[1190087]={'HW 15:3,46.1 N:500022'}	-- was removed
G[1190088]={'HW 69:74.83,45.14 N:500022'}
G[1190089]={'HW 26:78.19,81.46 N:500022'}
G[1190090]={'HW 100:56.80,37.45 N:500022'}
G[1190091]={'HW 100:26.90,59.47 N:500022'}
G[1190096]={'HW 102:30.63,50.87 N:500022'}
G[1190097]={'HW 108:48.73,45.18 N:500022'}
G[1190098]={'HW 107:56.68,34.49 N:500022'}
G[1190099]={'HW 105:53.43,55.54 N:500022'}
G[1190100]={'HW 105:76.22,60.39 N:500022'}
G[1190101]={'HW 104:30.27,27.70 N:500022'}
G[1190102]={'HW 10:67.34,74.66 N:500022'}
G[1190103]={'HW 210:40.91,73.72 N:500022'}
G[1190104]={'HW 70:41.86,74.09 N:500022'}
G[1190105]={'HW 71:52.56,27.10 N:500022'}
G[1190106]={'HW 83:59.83,51.22 N:500022'}
G[1190107]={'HW 81:55.47,36.79 N:500022'}
G[1190108]={'HW 23:75.57,52.31 N:500022'}
G[1190109]={'HW 102:78.46,62.88 N:500022'}
G[1190110]={'HW 111:28.21,49.07 N:500022'}
G[1190111]={'HW 111:56.31,81.93 N:500022'}
G[1190112]={'HW 105:62.90,38.33 N:500022'}
G[1190113]={'HW 109:32.02,64.44 N:500022'}
G[1190114]={'HW 109:43.32,36.10 N:500022'}
G[1190115]={'HW 104:61.00,28.17 N:500022'}
G[1190116]={'HW 104:56.37,59.82 N:500022'}
G[1190535]={'121:36.71,72.77'}
G[1190602]={'121:59.52,57.20'}
G[1190657]={'121:59.42,44.33'}
G[1190768]={'119:80.41,55.81'}
G[1190777]={'119:72.14,57.53'}
G[1190917]={'124:55.2,46.2'}
G[1190936]={'124:55.8,51.1 124:56.1,52.1'}
G[1191728]={'121:32.27,75.67 N:1000256'}
G[1191760]={'120:37.43,46.84'}
G[1191761]={'120:37.6,46.8'}
G[1191766]={'121:34.94,83.90'}
G[1191878]={'HW 121:59.32,57.20 N:500022'}
G[1191879]={'HW 121:40.86,66.04 N:500022'}
G[1191880]={'HW 116:20.89,64.76 N:500022'}
G[1191881]={'HW 116:65.36,47.00 N:500022'}
G[1191882]={'HW 116:31.94,60.21 N:500022'}
G[1191883]={'HW 116:59.63,26.36 N:500022'}
G[1192018]={'HW 119:26.61,59.20 N:500022'}
G[1192060]={'120:77.15,62.87'}
G[1192071]={'120:63.14,62.3 N:1192060'}
G[1192072]={'120:24.05,61.71'}
G[1192078]={'120:64,64.7 120:64.1,64.4'}
G[1192079]={'120:64.6,61.7 120:65,60.9 120:65.4,60.4'}
G[1192080]={'120:64.2,59.4 120:64.2,59.6 120:64.5,59.4 120:64.5,59.6'}
G[1192524]={'120:67.4,60'}
G[1192833]={'118:79.8,30.9'}
G[1193195]={'118:54,87.3'}
G[1193400]={'118:54.4,86.2'}
G[1194032]={'HM 114:55.21,20.18 N:1187564'}
G[1194033]={'HM 114:51.05,11.80 N:1187559'}
G[1194034]={'HM 119:47.30,61.49 N:1187559'}
G[1194035]={'HM 119:47.9,66.1 N:1187564'}
G[1194036]={'HM 115:75.07,43.83 N:1187564'}
G[1194037]={'HM 115:38.47,48.19 N:1187559'}
G[1194038]={'HM 117:57.7,15.7 N:1187564'}
G[1194039]={'HM 117:48.41,13.34 N:1187559'}
G[1194041]={'HM 116:34.16,60.59 N:1187564'}
G[1194042]={'HM 116:19.13,61.46 N:1187559'}
G[1194043]={'HM 120:40.38,85.59 N:1187559'}
G[1194044]={'HM 120:41.3,87 N:1187564'}
G[1194045]={'HM 127:77.60,75.23 N:1187564'}
G[1194046]={'HM 127:80.34,52.70 N:1187559'}
G[1194048]={'HM 121:43.32,71.35 N:1187559'}
G[1194049]={'HM 121:40.4,61 N:1187564'}
G[1194056]={'HW 117:58.32,62.82 N:500022'}
G[1194057]={'HW 117:30.83,41.43 N:500022'}
G[1194058]={'HW 117:60.48,15.90 N:500022'}
G[1194059]={'HW 114:58.52,67.87 N:500022'}
G[1194060]={'HW 114:57.12,18.82 N:500022'}
G[1194061]={'HW 115:28.95,56.22 N:500022'}
G[1194062]={'HW 115:77.50,51.29 N:500022'}
G[1194063]={'HW 120:28.72,74.28 N:500022'}
G[1194064]={'HW 125:42.35,63.14 N:500022'}
G[1194065]={'HW 117:25.44,59.82 N:500022'}
G[1194066]={'HW 115:60.15,53.45 N:500022'}
G[1194067]={'HW 115:48.11,74.66 N:500022'}
G[1194068]={'HW 114:78.45,49.16 N:500022'}
G[1194069]={'HW 120:41.07,85.85 N:500022'}
G[1194070]={'HW 120:30.92,37.16 N:500022'}
G[1194071]={'HW 125:48.15,41.30 N:500022'}
G[1194072]={'HW 126:38.16,59.63 N:500022'}
G[1194073]={'HW 117:49.44,10.75 N:500022'}
G[1194074]={'HW 117:52.10,66.15 N:500022'}
G[1194075]={'HW 117:79.26,30.62 N:500022'}
G[1194076]={'HW 114:76.66,37.47 N:500022'}
G[1194077]={'HW 114:41.71,54.40 N:500022'}
G[1194078]={'HW 115:37.83,46.47 N:500022'}
G[1194079]={'HW 115:76.82,63.28 N:500022'}
G[1194080]={'HW 120:67.65,50.69 N:500022'}
G[1194081]={'HW 125:66.82,29.61 N:500022'}
G[1194084]={'HW 114:49.74,9.98 N:500022'}
G[1194105]={'62:53.25,19.65'}
G[1194119]={'HW 120:37.09,49.51 N:500022'}
G[1194122]={'62:54.2,29.3'}
G[1194378]={'48:41.37,38.98'}
G[1194387]={'48:36.75,61.14 N:1194378'}
G[1194388]={'48:61.70,73.18 N:1194378'}
G[1194389]={'48:68.11,66.14 N:1194378'}
G[1194390]={'48:73.17,35.89 N:1194378'}
G[1194391]={'48:53.70,38.10 N:1194378'}
G[1194555]={'147:15.6,89.3'}
G[1194714]={'62:57.4,33.8'}
G[1195134]={'63:46.3,61.3'}
G[1195431]={'76:20.26,70.40'}
G[1195433]={'66:69.3,29.2'}
G[1195435]={'76:20.03,69.98'}
G[1195438]={'66:77.00,18.08'}
G[1195445]={'66:74.8,13.3'}
G[1195497]={'66:78.74,23.16'}
G[1195517]={'66:75.88,26.61'}
G[1195600]={'66:69.31,21.19'}
G[1195642]={'76:58.98,71.85'}
G[1195676]={'76:43.81,77.37'}
G[1196393]={'280:38.2,58.1 67:12.57,49.33>280'}
G[1196394]={'179:32.77,66.39'}
G[1196832]={'76:49.52,28.77'}
G[1196833]={'76:53.00,29.06'}
G[1201578]={'76:55.14,51.94'}
G[1201742]={''}
G[1202135]={'78:45.49,7.74'}
G[1202264]={'78:53.1,51.9'}
G[1202335]={'199:67,46.6'}
G[1202407]={'71:41.88,57.52'}
G[1202474]={'249:84.48,43.21 71:37.78,82.38>249'}
G[1202598]={'199:40.4,77.8'}
G[1202613]={'174:51.37,13.08'}
G[1202697]={'198:27.18,35.22'}
G[1202701]={'198:88.26,58.56'}
G[1202706]={'198:28.43,36.38'}
G[1202712]={'198:25.81,41.66',"In cave Gar'gol's Hovel"}
G[1202714]={'205:40.49,75.47'}
G[1202759]={'201:57.86,35.10'}
G[1202859]={'201:46.53,47.38'}
G[1202871]={'201:49.67,40.89'}
G[1202916]={'201:55.11,54.98'}
G[1202975]={'64:79.61,75.08'}
G[1203128]={'201:56.42,30.08'}
G[1203134]={'69:65.91,62.87'}
G[1203140]={'205:40.4,75.4'}
G[1203186]={'65:64.97,49.37'}
G[1203207]={'198:31.28,77.08'}
G[1203301]={'201:60.39,69.83'}
G[1203305]={'205:57.26,89.93'}
G[1203395]={'201:38.9,26.9'}
G[1203733]={'37:74.04,73.32'}
G[1203734]={'37:24.78,95.26'}
G[1203755]={'76:52.31,50.30 N:1201578'}
G[1204050]={'76:53.54,47.37'}
G[1204274]={'207:53.59,73.79'}
G[1204344]={'49:16.24,65.34 49:16.03,64.65 N:1000256'}
G[1204351]={'49:17.87,18.62'}
G[1204406]={'210:62.39,46.79 210:48.51,81.00 210:50.2,75.9 210:54.2,65.4 210:54.2,65.5 210:57,54.4 210:57,54.5'}
G[1204450]={'210:50.24,91.45','Inside lower ship'}
G[1204578]={'210:40.63,73.22'}
G[1204817]={'47:23.45,35.41'}
G[1204824]={'47:20.37,27.46','In catacombs'}
G[1204825]={'47:18.02,25.37','In catacombs'}
G[1204959]={'207:66.45,20.61'}
G[1205134]={'207:63.72,55.40'}
G[1205143]={'21:53.85,12.95'}
G[1205198]={'84:50.19,42.64','In catacombs'}
G[1205207]={'207:67.20,70.18'}
G[1205258]={'22:53.76,80.44','Bottom of crypt'}
G[1205266]={'249:64.85,29.57'}
G[1205332]={'70:37.46,31.52 N:1000068'}
G[1205350]={'21:59.2,34.3'}
G[1205540]={'249:65.17,33.80'}
G[1205874]={'249:39.64,45.42'}
G[1205875]={'23:77.56,79.41'}
G[1206109]={'86:49.66,76.48'}
G[1206111]={'84:62.91,71.54'}
G[1206116]={'86:66.42,49.29 N:1206109'}
G[1206293]={'249:74.14,64.44'}
G[1206294]={'84:62.28,29.93 N:1206111'}
G[1206335]={'15:50.25,54.28'}
G[1206336]={'15:47.97,50.91'}
G[1206374]={'15:50.26,53.27'}
G[1206504]={'15:18.84,30.28','In the cave'}
G[1206569]={'241:57.94,33.50 N:1202697'}
G[1206585]={'77:51.48,83.81'}
G[1206944]={'25:39.72,63.04'}
G[1207104]={'77:60.4,22.3 77:60.5,22.2'}
G[1207125]={'36:73.73,67.33'}
G[1207179]={'83:24.47,47.61'}
G[1207279]={'25:56.54,47.11 25:59.91,63.56 N:1206109'}
G[1207291]={'83:67.06,55.09'}
G[1207303]={'36:17,51.6'}
G[1207304]={'36:72.92,65.14 N:1207303'}
G[1207320]={'87:25.56,69.62 N:1206111'}
G[1207321]={'89:44.93,49.88 N:1206111'}
G[1207322]={'103:55.30,47.33 N:1206111'}
G[1207323]={'88:42.33,57.81 N:1206109'}
G[1207324]={'998:65.93,50.00 N:1206109'}
G[1207325]={'110:62.17,60.44 N:1206109'}
G[1207359]={'198:59.15,83.87'}
G[1207406]={'322:51.11,43.05'}
G[1207407]={'324:60.18,71.32'}
G[1207408]={'325:62.1,31.7 249:76.75,84.45>325'}
G[1207409]={'277:31.57,24.82 249:60.52,64.19>277'}
G[1207410]={'297:47.95,61.73'}
G[1207411]={'293:26.66,30.02 241:19.18,54.01>293'}
G[1207412]={'283:42.17,69.44'}
G[1207982]={'HM 50:51.7,63.1 N:1187564'}
G[1207983]={'HM 50:40.70,51.80 N:1187559'}
G[1207984]={'HM 15:18.6,55.8 N:1187564'}
G[1207985]={'HM 199:48.27,72.46 N:1187564'}
G[1207986]={'HM 199:40.71,67.35 N:1187559'}
G[1207987]={'HM 78:59.78,62.90 N:1187564'}
G[1207988]={'HM 51:70.1,14.2 N:1187564'}
G[1207989]={'HM 17:46.31,14.13 N:1187559'}
G[1207990]={'HM 22:29.09,56.60 N:1187559'}
G[1207991]={'HM 76:60.45,53.57 N:1187559'}
G[1207992]={'HM 78:56.50,65.85 N:1187559'}
G[1207993]={'HM 65:49.50,51.14 N:1187564'}
G[1208089]={'HM 241:47.15,28.32 N:1187564'}
G[1208090]={'HM 241:53.27,46.37 N:1187559'}
G[1208093]={'HM 249:53,32 N:1187564'}
G[1208094]={'HM 249:52.98,34.58 N:1187559'}
G[1208115]={'HW 62:50.79,18.89 N:500022'}
G[1208116]={'HW 69:51.07,17.82 N:500022'}
G[1208117]={'HW 63:50.25,67.26 N:500022'}
G[1208118]={'HW 63:38.65,42.35 N:500022'}
G[1208119]={'HW 63:12.99,34.10 N:500022'}
G[1208120]={'HW 14:40.07,49.09 N:500022'}
G[1208121]={'HW 15:20.87,56.32 N:500022'}
G[1208122]={'HW 17:60.69,14.08 N:500022'}
G[1208123]={'HW 17:44.35,87.60 N:500022'}
G[1208124]={'HW 48:83.03,63.53 N:500022'}
G[1208125]={'HW 50:53.16,66.98 N:500022'}
G[1208126]={'HW 51:28.93,32.40 N:500022'}
G[1208127]={'HW 26:66.16,44.44 N:500022'}
G[1208128]={'HW 241:60.35,58.25 N:500022'}
G[1208129]={'HW 241:79.48,78.54 N:500022'}
G[1208130]={'HW 241:49.60,30.36 N:500022'}
G[1208131]={'HW 241:43.50,57.27 N:500022'}
G[1208132]={'HW 204:54.68,72.12 N:500022'}
G[1208133]={'HW 205:49.72,57.39 N:500022'}
G[1208134]={'HW 22:43.38,84.36 N:500022'}
G[1208135]={'HW 56:58.21,39.20 N:500022'}
G[1208136]={'HW 56:26.07,25.99 N:500022'}
G[1208137]={'HW 15:65.85,35.65 N:500022'}
G[1208138]={'HW 32:39.48,66.02 N:500022'}
G[1208139]={'HW 51:71.65,14.10 N:500022'}
G[1208140]={'HW 76:57.10,50.17 N:500022'}
G[1208141]={'HW 201:63.49,60.17 N:500022'}
G[1208142]={'HW 205:49.19,41.88 N:500022'}
G[1208143]={'HW 15:18.36,42.73 N:500022'}
G[1208144]={'HW 17:40.47,11.29 N:500022'}
G[1208145]={'HW 25:60.26,63.75 N:500022'}
G[1208146]={'HW 21:44.30,20.29 N:500022'}
G[1208147]={'HW 210:35.04,27.22 N:500022'}
G[1208148]={'HW 26:31.82,57.87 N:500022'}
G[1208149]={'HW 18:83.04,72.08 N:500022'}
G[1208150]={'HW 241:53.40,42.85 N:500022'}
G[1208151]={'HW 241:45.11,76.80 N:500022'}
G[1208152]={'HW 241:75.36,54.92 N:500022'}
G[1208153]={'HW 241:75.41,16.53 N:500022'}
G[1208154]={'HW 205:51.48,62.39 N:500022'}
G[1208155]={'HW 204:51.35,60.56 N:500022'}
G[1208156]={'HW 22:48.28,63.66 N:500022'}
G[1208157]={'HW 66:56.72,50.12 N:500022'}
G[1208158]={'HW 77:44.58,28.99 N:500022'}
G[1208159]={'HW 77:61.86,26.71 N:500022'}
G[1208160]={'HW 69:41.45,15.68 N:500022'}
G[1208161]={'HW 69:51.97,47.63 N:500022'}
G[1208162]={'HW 198:63.05,24.15 N:500022'}
G[1208163]={'HW 198:18.63,37.32 N:500022'}
G[1208164]={'HW 198:42.68,45.71 N:500022'}
G[1208165]={'HW 10:56.21,40.03 N:500022'}
G[1208166]={'HW 10:62.51,16.60 N:500022'}
G[1208167]={'HW 199:39.29,20.10 N:500022'}
G[1208168]={'HW 199:40.71,69.31 N:500022'}
G[1208169]={'HW 199:39.01,10.99 N:500022'}
G[1208170]={'HW 199:65.60,46.54 N:500022'}
G[1208171]={'HW 199:49.05,68.50 N:500022'}
G[1208172]={'HW 65:66.49,64.19 N:500022'}
G[1208173]={'HW 65:71.02,79.08 N:500022'}
G[1208174]={'HW 65:59.05,56.33 N:500022'}
G[1208175]={'HW 65:39.48,32.81 N:500022'}
G[1208176]={'HW 65:31.53,60.66 N:500022'}
G[1208177]={'HW 71:55.70,60.96 N:500022'}
G[1208178]={'HW 249:26.59,7.24 N:500022'}
G[1208179]={'HW 249:54.68,33.01 N:500022'}
G[1208180]={'HW 78:55.27,62.12 N:500022'}
G[1208181]={'HW 207:51.19,49.91 N:500022'}
G[1208183]={'HW 207:47.36,51.71 N:500022'}
G[1208184]={'HM 198:62.78,22.99'}
G[1208187]={'HM 205:49.29,41.91 N:1208184'}
G[1208188]={'HM 207:49.41,51.43 N:1208184'}
G[1208316]={'125:37.55,62.97 N:1206111'}
G[1208317]={'125:59.2,27.4 N:1206109'}
G[1208420]={'210:35.51,63.57'}
G[1208535]={'338:69,42'}
G[1208549]={'333:15.99,55.99'}
G[1208550]={'X 337:31.42,48.17 50:72.09,32.91>337 N:1208549'}
G[1208825]={'89:69.42,39.69'}
G[1209072]={'84:55.40,43.40','In catacombs'}
G[1209076]={'84:65.07,33.52 N:500024'}
G[1209094]={'998:65.8,74.7 N:1209072'}
G[1209095]={'86:54.5,77.8 86:71.6,49.8 N:500025'}
G[1209673]={'378:26.46,33.68'}
G[1209845]={'371:53.71,91.51'}
G[1211316]={'376:19.84,55.93'}
G[1211754]={'379:57.11,47.89'}
G[1212181]={'371:30.89,17.49'}
G[1212389]={'422:53.08,12.36','Down in the Amber Vault'}
G[1213767]={'377:31.36,52.90','In a cave whose entrance is 35,19'}
G[1213770]={'380:41.66,44.11','In back of cave whose entrance is 809:59.20,53.14'}
G[1213771]={'379:72.02,33.98'}
G[1213793]={'379:52.57,51.54'}
G[1214062]={'422:41.88,63.72'}
G[1214205]={'390:83.0,30.4 N:1214218'}
G[1214206]={'390:83.0,30.4 N:1214218'}
G[1214207]={'390:83.0,30.4 N:1214218'}
G[1214208]={'390:83.0,30.4 N:1214218'}
G[1214209]={'390:83.08,30.43 N:1214218'}
G[1214210]={'390:83.5,30.5 N:1214218'}
G[1214211]={'390:83.5,30.5 N:1214218'}
G[1214212]={'390:83.5,30.5 N:1214218'}
G[1214213]={'390:83.5,30.5 N:1214218'}
G[1214214]={'390:83.5,30.5 N:1214218'}
G[1214215]={'390:83.70,30.66 N:1214218'}
G[1214217]={'390:83.5,30.5 N:1214218'}
G[1214218]={'390:83.55,30.59 N:1214218'}
G[1214219]={'390:83.5,30.5 N:1214218'}
G[1214220]={'390:83.5,30.5 N:1214218'}
G[1214221]={'390:83.5,30.5 N:1214218'}
G[1214222]={'390:83.5,30.5 N:1214218'}
G[1214223]={'390:83.5,30.5 N:1214218'}
G[1214224]={'390:83.5,30.5 N:1214218'}
G[1214225]={'390:83.7,30.8 N:1214218'}
G[1214226]={'390:83.7,30.8 N:1214218'}
G[1214438]={'379:64.23,45.11'}
G[1214562]={'422:44.57,41.32'}
G[1214871]={'371:48.57,20.61'}
G[1215705]={'376:52.03,49.06'}
G[1215844]={'371:27.60,24.29'}
G[1215873]={'418:28.25,50.74 N:500022'}
G[1215874]={'HW 371:41.68,23.14 N:500022'}
G[1215875]={'HW 392:58.88,78.25 N:500022'}
G[1215876]={'HW 422:55.21,71.19 N:500022'}
G[1215877]={'HW 422:55.93,32.28 N:500022'}
G[1215879]={'HW 433:55.10,72.24 N:500022'}
G[1215880]={'HW 371:45.77,43.60 N:500022'}
G[1215881]={'HW 371:28.01,47.39 N:500022'}
G[1215884]={'HW 371:48.09,34.62 N:500022'}
G[1215886]={'HW 371:55.71,24.41 N:500022'}
G[1215889]={'HW 371:54.61,63.32 N:500022'}
G[1215891]={'HW 371:59.56,83.24 N:500022'}
G[1215892]={'HW 418:51.40,77.29 N:500022'}
G[1215894]={'HW 418:75.92,6.87 N:500022'}
G[1215895]={'HW 379:57.45,59.95 N:500022'}
G[1215897]={'HW 379:72.73,92.28 N:500022'}
G[1215898]={'HW 379:62.7,80.5 N:500022'}
G[1215899]={'HW 379:64.21,61.27 N:500022'}
G[1215900]={'HW 379:54.07,82.81 N:500022'}
G[1215902]={'HW 388:71.12,57.79 N:500022'}
G[1215903]={'HW 390:35.13,77.78 N:500022'}
G[1215904]={'HW 418:61.02,25.14 N:500022'}
G[1215905]={'HW 376:83.64,20.14 N:500022'}
G[1215906]={'HW 376:19.87,55.79 N:500022'}
G[1215907]={'HW 371:44.80,84.37 N:500022'}
G[1215908]={'HW 371:28.45,13.27 N:500022'}
G[1215914]={'HW 379:62.50,28.90 N:500022'}
G[1215915]={'HW 393:37.86,65.93 N:500022'}
G[1216161]={'418:39.21,61.92 N:1181758'}
G[1216162]={'418:13.87,41.34 N:1181758'}
G[1216163]={'418:56.30,42.05 N:1181758'}
G[1216274]={'418:8.45,63.92'}
G[1216322]={'418:12.73,56.70 N:1203733'}
G[1216609]={'HM 418:85.59,29.16'}
G[1216837]={'433:54.99,72.65'}
G[1217845]={'HM 422:56.06,69.44 N:1217848'}
G[1217846]={'HM 371:47.14,47.09 N:1217848'}
G[1217847]={'HM 418:73.94,9.39 N:1217848'}
G[1217848]={'HM 379:71.09,90.98'}
G[1217849]={'HM 388:71.43,56.33 N:1217848'}
G[1217850]={'HM 376:51.81,51.19 N:1217848'}
G[1217851]={'HM 390:79.92,37.29 N:1187564'}
G[1217852]={'HM 390:77.78,33.66 N:1187559'}
G[1218072]={'504:39.12,56.01 504:40.65,71.43 504:50.18,85.91 504:53.18,81.39 504:52.95,45.10 504:54.27,48.85'}
G[1218077]={'504:34.62,64.83','In cave from beach'}
G[1218750]={'376:52.28,48.69'}
G[1218765]={'376:51.61,48.67'}
G[1218951]={'390:82,31 N:1214218'}
G[1218952]={'390:82.93,31.13 N:1214218'}
G[1218953]={'390:82,31 N:1214218'}
G[1218954]={'390:82,31 N:1214218'}
G[1218955]={'390:82.89,31.41 N:1214218'}
G[1218956]={'390:82,31 N:1214218'}
G[1218957]={'390:82,31 N:1214218'}
G[1218958]={'390:82,31 N:1214218'}
G[1220832]={'554:40.40,92.98'}
G[1220901]={'554:49.71,69.42'}
G[1220902]={'554:53.94,47.21'}
G[1220903]={'554:58.51,60.06'}
G[1220986]={'554:22.69,58.94'}
G[1221036]={'554:70.7,80.9'}
G[1221376]={'554:52.09,46.14'}
G[1221413]={'429:69.09,58.08'}
G[1221617]={'555:62.91,34.88','In cave'}
G[1222684]={'Z554'}
G[1223533]={'539:44.48,63.57'}
G[1224228]={'539:37.18,23.13 N:1002076','In cave'}
G[1224305]={'525:60.28,27.20'}
G[1224306]={'525:58.37,31.09'}
G[1224750]={'539:47.14,46.03'}
G[1224753]={'539:67.04,84.18','In cave'}
G[1224754]={'539:39.19,83.91'}
G[1224755]={'539:37.52,59.24'}
G[1224756]={'539:54.92,45.01'}
G[1224770]={'539:45.82,24.57','In cave'}
G[1224780]={'539:29.99,45.35'}
G[1224781]={'540:56.27,49.19'}
G[1224783]={'539:51.75,35.49'}
G[1224784]={'539:51.14,79.13'}
G[1224785]={'539:20.37,30.64'}
G[1225501]={'539:45.21,60.49 N:1223533'}
G[1225502]={'539:43.75,60.62 N:1223533'}
G[1225503]={'539:44.49,59.14 N:1223533'}
G[1225726]={'535:61.80,27.54'}
G[1225778]={'535:76.27,42.76'}
G[1226702]={'539:45.60,37.80 N:1000068'}	-- this does not exist until the garrison is constructed (or something else)...perhaps they are no longer here
G[1226831]={'539:49.39,37.59','Upstairs'}
G[1226861]={'539:31.26,39.12'}
G[1226862]={'539:34.40,46.17'}
G[1226865]={'539:84.56,44.78'}
G[1226961]={'526:28.87,44.85 N:1203733'}
G[1226987]={'535:30.89,70.82'}
G[1227069]={'535:49.21,88.05'}
G[1227134]={'539:42.10,61.22'}
G[1227504]={'525:84.09,65.14'}
G[1227737]={'535:37.25,79.39'}
G[1227743]={'539:26.53,5.68'}
G[1227793]={'535:36.52,95.98'}
G[1227806]={'525:82.64,69.83'}
G[1227951]={'535:64.91,13.31'}
G[1227953]={'535:65.46,11.37','In cave'}
G[1227954]={'535:52.56,29.54'}
G[1227955]={'535:62.08,32.40'}
G[1227956]={'535:57.37,28.66'}
G[1227996]={'535:66.50,86.94'}
G[1228012]={'535:77.03,49.95'}
G[1228013]={'535:35.40,96.56'}
G[1228014]={'535:75.78,44.72','On platform'}
G[1228015]={'535:64.58,79.20'}
G[1228016]={'535:62.42,47.97'}
G[1228017]={'535:55.25,66.73'}
G[1228018]={'537:28.25,34.96'}
G[1228019]={'535:65.44,88.61'}
G[1228020]={'535:46.95,91.74'}
G[1228021]={'535:38.33,84.51'}
G[1228022]={'535:38.16,12.34'}
G[1228023]={'535:33.29,76.81'}
G[1228024]={'535:81.85,34.94','In mine'}
G[1228025]={'535:75.68,41.40','Under bridge'}
G[1228026]={'535:78.21,14.72'}
G[1228483]={'535:65.96,85.14','Very deep in water'}
G[1229314]={'539:59.79,94.46'}
G[1229330]={'543:39.70,39.90'}
G[1229331]={'535:45.27,37.06'}
G[1229333]={'525:68.00,18.92'}
G[1229344]={'550:46.37,16.04'}
G[1229354]={'535:73.52,51.37','In water'}
G[1230303]={'550:78.97,58.93 N:1203733'}	-- 950:78.63,48.32
G[1230665]={'535:69.77,20.70'}
G[1230741]={'550:63.10,62.02'}
G[1230865]={'581:48.38,40.93'}	-- garrison level 1 location
G[1230882]={'550:71.04,52.31'}
G[1230933]={'539:56.95,34.73'}
G[1230977]={'550:82.94,44.22'}
G[1231100]={'525:54.22,67.52'}
G[1231183]={'542:66.61,51.69'}
G[1231184]={'542:66.80,51.39'}
G[1231901]={'550:81.33,70.35'}
G[1231903]={'543:47.60,72.75'}
G[1231918]={'539:50.00,81.23'}
G[1232024]={'550:51.87,62.10'}
G[1232089]={'542:39.70,60.76'}
G[1232353]={'542:35.49,32.04'}
G[1232397]={'581:42.92,44.59'}
G[1232398]={'581:42.68,44.77 N:1203733'}
G[1232400]={'581:42.67,44.73 N:1232397'}	-- garrison level 2 location
G[1232405]={'539:57.46,57.26 N:1000068'}
G[1232406]={'550:69.93,52.50 N:1233511','Hanging in tree'}
G[1232416]={'587:49.04,41.72 N:1233291'}	-- garrison level 1 location
G[1232489]={'543:47.88,94.25'}	-- it seems Blizzard took this out of a dungeon map 949[17]:44.39,25.67
G[1232492]={'543:47.96,94.35'}
G[1232494]={'539:52.88,24.86','Bottom of water'}
G[1232571]={'550:47.21,74.27','In tree'}
G[1232579]={'539:57.91,45.32 N:80470'}
G[1232582]={'539:37.75,44.27'}
G[1232583]={'539:33.49,39.65'}
G[1232584]={'550:50.12,82.29 N:1232598'}
G[1232586]={'539:36.68,44.46'}
G[1232587]={'539:35.88,40.88'}
G[1232588]={'539:38.49,43.05'}
G[1232589]={'539:34.17,43.48'}
G[1232590]={'550:50.02,66.48'}
G[1232591]={'539:36.79,41.41'}
G[1232592]={'539:55.28,74.87'}
G[1232595]={'550:52.67,80.08 N:1232598'}
G[1232596]={'539:52.82,48.38'}
G[1232598]={'550:77.83,51.94','On top of tower'}
G[1232621]={'539:55.82,20.00','On top of mushroom'}
G[1232624]={'539:58.88,21.93'}
G[1232985]={'550:88.27,42.62 N:1232598'}
G[1233033]={'550:70.59,18.60 N:1232598'}
G[1233034]={'550:64.59,17.62 N:1232598'}
G[1233099]={'542:39.78,42.65 N:1000068'}
G[1233100]={'542:39.46,61.66 N:1000068'}
G[1233101]={'539:37.18,26.02'}
G[1233107]={'634:67.94,57.76 N:1244694'}
G[1233134]={'550:58.27,52.48','In tree'}
G[1233135]={'550:51.72,60.29'}
G[1233206]={'550:67.65,59.72'}
G[1233229]={'539:60.92,24.43','In cave'}
G[1233241]={'539:48.72,47.53'}
G[1233263]={'550:55.43,55.95 550:51.83,58.74 550:46.76,57.46 550:52.03,68.74'}
G[1233291]={'587:49.05,41.69'}	-- Garrison Level 1 position
G[1233391]={'543:47.72,52.07'}
G[1233505]={'543:45.31,81.94'}	-- arbitrarily mapped ID to location...cannot tell which for sure
G[1233511]={'550:45.62,52.01'}
G[1233520]={'543:45.97,93.57'}
G[1233525]={'543:41.98,81.55'}
G[1233539]={'550:43.22,57.55 N:1233549'}
G[1233549]={'550:48.06,60.12'}
G[1233551]={'550:44.69,67.57 N:1233549'}
G[1233555]={'550:48.58,72.77 N:1233549'}
G[1233557]={'550:55.34,68.27 N:1233549'}
G[1233559]={'543:45.80,89.31'}
G[1233560]={'550:45.85,66.29'}
G[1233561]={'550:58.30,59.32','In tree'}
G[1233611]={'550:67.38,49.08'}
G[1233613]={'550:64.70,65.82'}
G[1233623]={'550:56.57,72.94'}
G[1233641]={'550:64.77,35.72'}
G[1233642]={'550:38.36,49.33'}
G[1233645]={'550:52.41,44.38'}
G[1233649]={'550:75.37,47.10'}
G[1233651]={'550:61.76,57.46','In tree'}
G[1233658]={'553:65.92,57.54 N:1233623'}
G[1233715]={'550:38.35,58.73'}
G[1233768]={'550:57.80,62.04','On rock outcropping'}
G[1233773]={'550:62.54,67.08'}
G[1234147]={'542:36.81,17.14'}
G[1234154]={'542:42.69,18.32'}
G[1234157]={'542:50.50,22.10'}
G[1234159]={'542:50.76,28.75','Under bridge'}
G[1234243]={'581:36.11,34.87'}	-- garrison level 2 position
G[1234432]={'542:58.70,60.24'}
G[1234449]={'542:43.23,27.24','In tree'}
G[1234454]={'542:60.24,53.87 N:1234449','In tree'}
G[1234455]={'542:51.89,48.92 N:1234449','On wall'}
G[1234456]={'542:47.92,30.68'}
G[1234458]={'542:56.23,28.78'}
G[1234461]={'542:54.36,32.54'}
G[1234471]={'542:59.63,81.33'}
G[1234472]={'542:59.16,90.62'}
G[1234473]={'542:55.53,90.84','On high shelf'}
G[1234474]={'543:51.04,51.62'}	-- Sparring Arena-based location
G[1234618]={'542:61.11,55.38'}
G[1234703]={'542:43.90,15.01 N:1234704'}
G[1234704]={'542:43.82,24.63'}
G[1234705]={'542:69.15,43.34 N:1234704'}
G[1234734]={'542:48.97,62.56 N:1234704'}
G[1234735]={'542:55.66,22.09 N:1234704'}
G[1234736]={'542:53.13,84.50 N:1234704'}
G[1234740]={'542:36.29,39.34'}
G[1234744]={'542:53.31,55.52 N:1235073'}
G[1234746]={'542:48.35,52.61 N:1235073'}
G[1234748]={'542:48.35,52.61 N:1235073'}
G[1235073]={'542:51.88,64.65'}
G[1235090]={'542:60.97,63.87 N:1235073'}
G[1235091]={'542:47.77,36.12'}
G[1235095]={'542:52.47,42.80'}
G[1235097]={'542:36.44,57.79'}
G[1235103]={'542:37.15,47.50'}
G[1235104]={'542:34.14,27.52'}
G[1235105]={'542:33.29,27.27 N:1235104'}
G[1235129]={'543:49.47,70.95'}
G[1235135]={'542:56.30,45.30'}
G[1235141]={'542:50.33,25.80'}
G[1235143]={'542:49.21,37.20'}
G[1235168]={'542:46.92,34.04','In tree'}
G[1235172]={'542:42.17,21.69 N:1234147'}
G[1235282]={'542:71.64,48.59'}
G[1235289]={'542:41.86,50.42'}
G[1235299]={'542:68.42,88.98'}
G[1235300]={'542:63.58,67.37'}
G[1235307]={'542:66.47,56.53'}
G[1235310]={'542:60.87,84.60'}
G[1235313]={'542:40.59,54.98'}
G[1235365]={'542:36.19,54.46'}
G[1235860]={'539:66.97,33.48'}
G[1236140]={'547:34.56,66.76'}
G[1236141]={'543:42.36,83.41'}
G[1236165]={'587:50,50 N:1236206'}	-- Arbitrarily set this to Horde
G[1236206]={'581:31.44,31.04'}	-- Arbitrarily set this to Alliance
G[1236483]={'535:28.39,74.19','In cave'}
G[1236610]={'550:35.47,57.25'}
G[1236935]={'535:70.13,7.11'}
G[1237016]={'539:33.27,30.73'}	-- this exists prior to garrison construction
G[1237021]={'539:26.40,32.88'}	-- this exists prior to garrison construction
G[1237022]={'587:48.51,41.44 N:1233291'}
G[1237705]={'550:79.73,30.23'}
G[1237790]={'539:73.76,55.81'}
G[1237821]={'543:40.32,40.30'}
G[1237946]={'550:40.34,68.63','In cave'}
G[1239120]={'632:43.92,24.68 630:47.87,52.08'}	-- the second coordinates is if you have not looked at map in cave
G[1239328]={'630:65.69,56.92'}
G[1239791]={'581:34.32,32.48'}	-- Alliance version	-- TODO: Make Horde version 976:40,56.2
G[1239902]={'534:58.50,60.45'}	-- Arbitrarily set to Alliance
G[1240003]={'534:36.31,43.50'}
G[1240289]={'534:15.93,49.78','In cave'}
G[1240317]={'534:16.09,44.25'}
G[1240519]={'641:46.45,86.31 N:1244694'}
G[1240543]={'534:17.01,52.93'}
G[1240547]={'534:32.44,37.40'}
G[1240552]={'631:68.88,13.24'}
G[1240577]={'534:19.30,40.95'}
G[1240580]={'534:28.73,23.34'}
G[1240605]={'641:64.70,51.25 N:1244694'}
G[1240609]={'641:43.39,75.90 N:1244694'}
G[1240612]={'641:48.68,73.79 N:1244694'}
G[1240614]={'641:39.95,54.61 N:1244694'}
G[1240616]={'83:68.03,73.87'}
G[1240617]={'63:56.39,49.26'}
G[1240619]={'641:73.80,32.27 N:1244694'}
G[1240625]={'89:43.03,75.74','Upstairs'}
G[1240629]={'630:53.18,64.44 N:1208420'}
G[1240630]={'630:49.65,34.48 N:1244694'}
G[1240631]={'630:40.57,57.67 N:1208420'}
G[1240634]={'630:57.87,12.26 N:1208420'}
G[1240635]={'630:58.38,12.28 N:1208420'}
G[1240637]={'630:42.62,8.08 N:1240639'}
G[1240638]={'630:55.88,56.85'}
G[1240639]={'630:58.35,43.79'}
G[1240641]={'630:49.41,57.98 N:1208420'}
G[1240642]={'630:56.45,34.81 N:1208420'}
G[1240643]={'630:49.36,45.37'}
G[1240644]={'630:53.03,37.27 N:1244694'}
G[1240645]={'632:69.26,48.27 N:1240639'}
G[1240646]={'630:44.47,39.48 N:1208420'}
G[1240651]={'641:67.39,53.41 N:1244694'}
G[1240652]={'641:44.34,82.57 N:1208420','In cave under inn'}
G[1240653]={'641:51.50,77.73 N:1244694','Under trees'}
G[1240654]={'641:63.37,88.41 N:1244694'}
G[1240690]={'630:57.15,31.06 N:1208420'}
G[1240855]={'534:32.42,70.40'}
G[1241146]={'634:42.62,65.80 N:1208420'}
G[1241147]={'634:40.64,68.52 N:1244694'}
G[1241148]={'634:48.13,74.22 N:1244694'}
G[1241149]={'634:42.34,61.13 N:1244694'}
G[1241150]={'634:35.17,68.98 N:1244694'}
G[1241151]={'634:52.02,80.59 N:1244694'}
G[1241152]={'634:46.76,80.40 N:1208420'}
G[1241153]={'634:50.33,40.99 N:1244694'}
G[1241154]={'634:49.76,78.00 N:1244694'}
G[1241155]={'634:39.47,65.19 N:1208420'}
G[1241180]={'634:35.03,36.59 N:1208420'}
G[1241206]={'634:41.75,46.04 N:1244694'}
G[1241207]={'634:44.16,69.97 N:1244694'}
G[1241208]={'634:32.74,27.92 N:1208420'}
G[1241212]={'634:33.14,36.08 N:1208420'}
G[1241213]={'634:39.56,19.32 N:1244694'}
G[1241272]={'649:19.58,46.87 N:1208420'}
G[1241280]={'636:19.97,41.27 N:1208420'}
G[1241433]={'534:56.97,65.05'}
G[1241434]={'534:54.82,69.31','Up in a tree'}
G[1241449]={'534:61.24,75.88'}
G[1241450]={'534:62.13,70.73'}
G[1241504]={'534:30.38,71.98'}
G[1241518]={'634:69.15,44.78 N:1244694'}
G[1241521]={'534:40.61,79.80'}
G[1241522]={'534:40.78,75.58'}
G[1241524]={'534:37.05,46.27'}
G[1241533]={'534:41.58,73.28'}
G[1241557]={'634:31.11,55.98 N:1208420'}
G[1241558]={'634:35.73,54.10 N:1208420'}
G[1241560]={'534:22.00,47.77'}
G[1241561]={'534:58.5,25.3'}
G[1241562]={'634:35.92,47.94 N:1244694'}
G[1241563]={'534:62.60,20.53'}
G[1241564]={'634:46.60,64.96 N:1244694'}
G[1241565]={'534:26.7,44.3'}
G[1241566]={'534:51.73,24.27'}
G[1241599]={'534:64.59,42.11','In tree'}
G[1241600]={'534:49.90,81.24'}
G[1241601]={'534:49.95,79.62'}
G[1241602]={'534:69.75,55.99'}
G[1241605]={'534:47.90,70.40'}
G[1241656]={'534:50.81,64.99'}
G[1241657]={'534:31.41,31.07'}
G[1241664]={'534:25.3,50.2'}
G[1241665]={'634:48.00,62.37 N:1208420'}
G[1241666]={'534:46.27,72.77'}
G[1241671]={'534:63.40,28.07'}
G[1241673]={'534:26.54,62.96 N:1241565','Up in tower'}
G[1241674]={'534:34.69,34.65','Down in Vault of Eyes'}
G[1241692]={'534:14.96,54.42','In building'}
G[1241699]={'534:17.36,56.92'}
G[1241712]={'534:35.9,78.6'}
G[1241713]={'534:15.99,59.40','In tower'}
G[1241714]={'534:33.90,78.13'}
G[1241715]={'534:35.03,77.33 N:1241714'}
G[1241716]={'534:34.41,78.30 N:1241714'}
G[1241717]={'634:49.69,47.33'}
G[1241725]={'534:61.50,45.88 N:1239902'}	-- Arbitrarily set to Horde
G[1241742]={'534:46.87,36.65'}
G[1241745]={'534:46.93,44.36'}
G[1241760]={'534:46.85,42.16'}
G[1241764]={'534:73.64,43.24'}
G[1241767]={'641:69.43,59.94 N:1208420','In cave'}
G[1241772]={'641:67.20,59.27 N:1208420','In cave'}
G[1241773]={'641:70.16,57.00 N:1244694'}
G[1241775]={'534:37.73,80.74'}
G[1241835]={'534:49.95,76.77', 'In cave'}
G[1241840]={'634:69.82,45.72'}
G[1241841]={'534:48.55,75.21'}
G[1241847]={'534:43.1,38.3'}
G[1241848]={'534:42.85,35.38','Top of tower'}
G[1242242]={'641:56.03,83.76 N:1244694'}
G[1242249]={'534:28.86,34.59','In cave'}
G[1242250]={'641:54.94,80.56 N:1244694','Under water, in cave'}
G[1242328]={'641:48.99,86.14 N:1244694'}
G[1242346]={'641:60.49,82.14 N:1244694'}
G[1242446]={'641:59.89,72.26 N:1244694'}
G[1242642]={'641:62.79,70.32 N:1244694'}
G[1242643]={'641:63.03,76.96 N:1244694'}
G[1242644]={'641:62.06,67.36 N:1208420','In cave'}
G[1242645]={'641:56.22,57.30 N:1244694'}
G[1242646]={'641:68.33,40.61 N:1244694'}
G[1242647]={'641:65.38,86.26 N:1208420'}
G[1242649]={'534:51.64,32.64'}
G[1242660]={'641:42.66,58.01 N:1244694'}
G[1242662]={'641:38.64,67.18 N:1244694'}
G[1242663]={'641:38.45,65.32 N:1244694'}
G[1242664]={'641:33.81,58.26 N:1208420'}
G[1242665]={'641:45.09,61.15 N:1244694'}
G[1242666]={'641:43.23,54.87 N:1208420'}
G[1242667]={'641:40.51,44.70 642:41.99,88.45 N:1244694'}
G[1242668]={'642:50.85,51.63 641:40.99,42.69 N:1240639'}
G[1242669]={'641:61.63,73.69 N:1244694'}
G[1242670]={'641:61.08,34.21 N:1208420'}
G[1242671]={'641:61.01,79.18 N:1240639'}
G[1242675]={'641:54.18,70.59 N:1244694'}
G[1242678]={'641:54.51,60.48 N:1208420'}
G[1242683]={'641:63.27,74.01 N:1208420'}
G[1242959]={'641:66.56,40.91 N:1208420'}
G[1243402]={'650:39.00,37.32'}
G[1243454]={'634:57.65,71.88'}
G[1243690]={'534:65.88,85.04'}
G[1243693]={'534:54.94,90.65'}
G[1243700]={'634:72.40,61.00'}
G[1243773]={'650:47.64,44.06 N:1208420'}
G[1243798]={'750:63.49,59.32'}
G[1243836]={'634:46.73,44.44'}
G[1243912]={'581:43.73,51.59 N:500022'}
G[1244446]={'650:52.40,51.50'}
G[1244453]={'634:36.74,31.12'}
G[1244466]={'672:69.84,37.50'}
G[1244494]={'650:39.53,57.44 N:1208420'}
G[1244519]={'650:53.60,51.04 N:1208420'}
G[1244555]={'627:38.00,29.67'}
G[1244559]={'649:34.17,27.92'}
G[1244692]={'672:63.42,54.17 N:1244694'}
G[1244694]={'672:54.78,59.26'}
G[1244708]={'634:63.00,48.61'}
G[1244887]={'634:58.04,47.52 N:1244694'}
G[1244899]={'634:73.32,41.50 N:1244694'}
G[1244901]={'634:68.97,41.83 N:1208420'}
G[1244902]={'634:59.31,58.46 N:1208420'}
G[1244903]={'634:61.81,62.78 N:1208420'}
G[1244904]={'634:57.94,63.34 N:1244694'}
G[1244905]={'634:62.65,73.60 N:1244694','Top of tower'}
G[1244909]={'634:61.41,44.40 N:1244694'}
G[1244912]={'634:60.84,42.73 N:1208420'}
G[1244913]={'634:55.01,47.14 N:1208420'}
G[1244917]={'634:81.86,67.50 N:1208420'}
G[1244923]={'677:77.91,35.63'}
G[1244928]={'634:68.46,29.60 N:1240639'}
G[1244983]={'942:49.86,73.52'}
G[1245328]={'680:30.27,39.66'}
G[1245528]={'650:39.38,62.28 N:1208420'}
G[1245529]={'750:32.37,41.67 N:1244694'}
G[1245530]={'650:37.14,57.74 N:1240639'}
G[1245531]={'650:37.35,33.79 N:1244694'}
G[1245532]={'659:34.30,80.46 N:1208420'}
G[1245533]={'650:42.20,27.31 N:1208420'}
G[1245534]={'650:42.50,35.03 N:1244694'}
G[1245535]={'650:45.55,34.59 N:1244694'}
G[1245536]={'650:46.67,28.13 N:1240639'}
G[1245537]={'650:54.18,41.60 N:1240639'}
G[1245538]={'650:53.46,43.55 N:1244694'}
G[1245542]={'650:36.62,62.14 N:1208420'}
G[1245545]={'750:13.71,55.42 N:1244694'}
G[1245547]={'650:53.04,52.22 N:1244694','In cave'}
G[1245548]={'654:60.66,25.11 N:1208420'}
G[1245550]={'650:50.98,36.46 N:1208420','In cave'}
G[1245553]={'650:50.98,38.80 N:1208420'}
G[1245579]={'650:52.03,32.42 N:1208420'}
G[1245580]={'650:50.81,35.05 N:1244694'}
G[1245581]={'650:46.81,40.14 N:1244694'}
G[1245601]={'657:60.52,54.68 N:1244694'}
G[1245602]={'650:47.03,72.69 N:1208420'}
G[1245603]={'650:43.75,72.75 N:1244694'}
G[1245688]={'680:49.10,34.32'}
G[1245793]={'42:52.32,33.80'}
G[1246037]={'630:55.63,18.55 N:1208420'}
G[1246205]={'630:66.06,43.44 N:1244694'}
G[1246206]={'630:58.64,53.38 N:1244694'}
G[1246254]={'680:52.74,31.31'}
G[1246353]={'672:82.08,50.44 N:1244694'}
G[1246438]={'71:69.55,68.46'}
G[1246463]={'629:40.98,52.30'}
G[1246465]={'629:39.89,58.33'}
G[1246466]={'629:45.84,65.30 N:1248534'}
G[1246555]={'677:58.68,34.72 N:1244694'}
G[1246556]={'677:47.34,54.63 N:1244694'}
G[1246557]={'678:32.09,48.17 N:1244694'}
G[1246558]={'678:41.41,32.86 N:1244694'}
G[1246559]={'678:57.04,40.18 N:1244694'}
G[1246560]={'678:41.47,63.59 N:1244694'}
G[1246561]={'679:24.44,9.94 N:1244694'}
G[1246562]={'679:17.98,81.04 679:23.23,81.63 N:1244694'}
G[1246713]={'680:36.10,47.24'}
G[1246884]={'680:30.82,85.02'}
G[1246885]={'680:31.19,85.23'}
G[1246944]={'627:42.78,27.09'}
G[1247694]={'680:20.92,52.29'}
G[1247704]={'641:49.39,49.25'}
G[1248534]={'641:53.47,55.96'}
G[1249997]={'630:59.88,63.19 N:1244694'}
G[1250080]={'630:62.38,58.40 N:1244694'}
G[1250081]={'630:62.99,54.17 N:1244694'}
G[1250083]={'630:52.01,42.11 N:1244694'}
G[1250084]={'630:53.62,44.15 N:1244694'}
G[1250085]={'630:53.49,45.46 N:1244694'}
G[1250087]={'631:62.02,83.83 N:1244694'}
G[1250088]={'631:71.71,21.60 N:1244694'}
G[1250090]={'630:54.41,36.34 N:1244694'}
G[1250091]={'630:55.37,27.74 N:1244694'}
G[1250092]={'630:51.53,24.33 N:1208420'}
G[1250097]={'630:50.20,50.29 N:1244694'}
G[1250098]={'632:45.36,66.87 630:48.01,56.24 N:1244694'}	-- second value is outer map version of cave point
G[1250102]={'630:41.39,30.75 N:1208420'}
G[1250103]={'630:63.64,39.17 N:1244694'}
G[1250104]={'630:62.81,44.79 N:1244694'}
G[1250106]={'630:47.85,7.73 N:1244694'}
G[1250107]={'630:43.41,22.39 N:1240639'}
G[1250108]={'630:57.19,25.23 N:1244694'}
G[1250383]={'680:17.26,37.73'}
G[1250536]={'634:49.98,32.66'}
G[1250541]={'650:52.54,66.38 N:1244694'}
G[1250548]={'731:19.34,56.80'}
G[1250612]={'634:51.42,57.35'}
G[1250984]={'634:72.12,54.88 N:1244694'}
G[1250985]={'634:75.15,49.47 N:1208420'}
G[1250987]={'634:73.96,52.24 N:1244694'}
G[1250990]={'634:75.53,50.80'}
G[1251032]={'680:65.69,62.68'}
G[1251124]={'657:59.46,41.16 N:1240639'}
G[1251218]={'634:64.97,59.11'}
G[1251220]={'634:64.91,58.91'}
G[1251221]={'634:64.99,58.96'}
G[1251425]={'641:66.82,75.67'}
G[1251552]={'630:65.47,29.56 N:1244694'}
G[1251571]={'634:63.45,64.74'}
G[1251670]={'627:47.99,41.72 N:500022'}
G[1251671]={'627:41.48,64.00 N:500022'}
G[1251713]={'634:65.58,57.38 N:1244694'}
G[1251714]={'634:6999,67.17 N:1244694'}
G[1251716]={'634:42.47,34.08 N:1240639','Top of statue'}
G[1251720]={'634:82.40,54.53 N:1244694'}
G[1251723]={'634:73.14,45.68 N:1244694'}
G[1251737]={'634:50.05,18.17 N:1244694'}
G[1251738]={'634:32.07,47.20 N:1208420'}
G[1251761]={'634:65.37,43.11 N:1244694'}
G[1251762]={'634:49.08,59.99 N:1244694'}
G[1251764]={'634:37.20,38.66 N:1244694'}
G[1251772]={'634:73.98,58.59 N:1244694'}
G[1251776]={'634:43.16,40.49 N:1244694'}
G[1251780]={'634:43.69,80.10 N:1244694'}
G[1251782]={'634:44.98,38.23 N:1244694'}
G[1251820]={'634:47.45,34.10 N:1208420'}
G[1251853]={'634:75.67,60.60 N:1244694'}
G[1251854]={'634:71.93,44.24 N:1244694'}
G[1251856]={'634:74.41,41.84 N:1244694'}
G[1251857]={'634:78.42,71.39 N:1208420'}
G[1251870]={'634:68.89,26.05'}
G[1251991]={'703:50.86,88.18'}
G[1251992]={'629:49.45,62.52'}
G[1252107]={'682:53.60,36.77 680:39.32,76.28'}
G[1252258]={'680:64.66,37.60'}
G[1252259]={'680:58.89,38.15 N:1252258'}
G[1252260]={'689:53.75,45.16 N:1252258'}
G[1252261]={'690:48.59,48.28 680:22.44,15.41 N:1252258'}
G[1252262]={'685:66.32,52.44 N:1252258'}
G[1252263]={'685:58.02,75.20 N:1252258'}
G[1252264]={'680:27.22,86.45 N:1252258'}
G[1252447]={'680:46.56,26.01'}
G[1252806]={'682:54.63,37.94 N:1244694'}
G[1252807]={'684:38.63,54.11 N:1244694'}
G[1252808]={'685:48.66,42.63 N:1244694'}
G[1252810]={'680:23.40,48.78 N:1244694'}
G[1252814]={'680:30.83,11.03'}
G[1252815]={'680:43.69,79.25 N:1252814'}
G[1252816]={'680:43.41,60.55 N:1252814'}
G[1252817]={'680:42.03,35.25 N:1252814'}
G[1252828]={'680:48.14,33.99 N:1244694'}
G[1252829]={'680:52.27,29.90 N:1244694'}
G[1252835]={'680:76.86,61.50 N:1244694'}
G[1252836]={'680:81.96,57.46 N:1244694'}
G[1252876]={'680:55.69,54.80 N:1244694'}
G[1252880]={'680:61.35,55.49 N:1208420'}
G[1252881]={'680:57.36,60.54 N:1208420'}
G[1252882]={'680:57.68,61.97 N:1208420'}
G[1252883]={'680:54.32,60.32 N:1208420'}
G[1254024]={'630:34.58,35.56 N:1244694'}
G[1254025]={'630:68.86,29.74 N:1244694','In cave under water'}
G[1254027]={'630:53.62,18.13 N:1244694'}
G[1254028]={'630:26.25,47.15 N:1244694'}
G[1254126]={'641:73.82,54.37 N:1244694'}
G[1254127]={'641:62.70,85.26 N:1244694'}
G[1254141]={'641:63.91,45.57 N:1244694'}
G[1258690]={'630:54.86,52.14 N:1244694'}
G[1258978]={'45:39.07,73.76'}
G[1258979]={'712:54.75,35.75'}
G[1259862]={'535:43.53,71.85'}
G[1259863]={'550:80.57,47.66'}
G[1259864]={'543:43.92,93.83'}
G[1259865]={'630:48.30,29.65'}
G[1259866]={'641:44.85,57.88'}
G[1259867]={'650:55.56,84.47'}
G[1259868]={'634:32.53,42.00'}
G[1259870]={'525:72.71,65.23'}
G[1259871]={'539:42.77,35.81'}
G[1259926]={'680:30.31,45.27'}
G[1259927]={'680:22.90,58.38'}
G[1265435]={'680:36.86,46.45'}
G[1265532]={'680:51.99,78.75'}
G[1268478]={'646:53.34,80.45'}
G[1268703]={'646:41.27,59.38'}
G[1269043]={'641:51.32,78.46 N:1244694'}
G[1270917]={'896:55.62,41.19'}
G[1271103]={'882:46.77,68.99'}
G[1271124]={'830:31.78,57.73'}
G[1271706]={'862:67.52,17.90'}
G[1272179]={'896:56.14,35.30'}
G[1272422]={'896:60.58,31.46'}
G[1272456]={'830:62.61,25.82'}
G[1273222]={'830:68.56,60.51 N:1272456'}
G[1273407]={'882:63.33,22.53'}
G[1273415]={'882:53.36,8.47 N:1273407'}
G[1273519]={'885:68.45,70.81 N:1273523'}
G[1273521]={'885:51.86,34.10 N:1273523'}
G[1273523]={'885:59.08,19.42'}	-- this seems old 1171:64.15,23.05
G[1273527]={'885:65.56,28.28 N:1273523'}
G[1273538]={'885:62.09,45.83 N:1273523'}
G[1273814]={'896:70.07,62.99'}
G[1273854]={'864:40.42,73.65'}
G[1273900]={'895:78.37,77.61 A:1244694'}
G[1273902]={'895:76.37,80.89 895:77.55,82.68 895:77.03,85.57 A:1244694'}
G[1273903]={'895:73.02,83.12 A:1244694'}
G[1273905]={'895:39.62,32.34 895:37.23,28.35 895:38.14,31.92 A:1244694'}
G[1273910]={'895:41.88,26.52 895:38.97,24.95 A:1244694'}
G[1273917]={'895:78.79,47.54 A:1244694'}
G[1273918]={'895:76.20,67.24 A:1244694'}
G[1273919]={'895:65.95,57.76 895:67.34,64.02 A:1244694'}
G[1273955]={'895:53.05,31.33 895:48.49,26.27 895:52.78,23.90 A:1244694'}
G[1273956]={'895:56.03,23.93 895:54.55,24.13 895:57.43,22.18 A:1244694'}
G[1275070]={'895:55.44,17.20 895:55.70,15.77 895:57.33,17.59 A:1244694'}
G[1275071]={'895:87.78,75.92 895:89.01,76.31 A:1244694'}
G[1275074]={'895:67.03,21.37 895:68.81,17.39 A:1244694'}
G[1275076]={'895:47.43,19.57 895:45.42,22.32 A:1244694'}
G[1275099]={'864:44.55,79.99'}
G[1276187]={'864:43.41,78.65'}
G[1276251]={'896:51.81,22.81'}
G[1276256]={'895:56.56,15.55'}
G[1276488]={'895:78.61,77.85 895:77.58,76.36'}
G[1276513]={'896:70.75,50.74'}
G[1276515]={'896:71.14,52.36'}
G[1276735]={'1165:38.29,7.17 862:54.08,31.48'}
G[1276837]={'895:56.16,17.96'}
G[1277199]={'895:76.13,65.52'}
G[1277373]={'895:87.98,75.01'}
G[1277459]={'896:63.35,30.11'}
G[1277530]={'864:31.76,79.28'}
G[1277561]={'862:49.51,65.26'}
G[1277715]={'863:43.06,50.79'}
G[1277871]={'896:62.06,51.94 A:1244694'}
G[1277874]={'896:57.60,56.01 A:1244694'}
G[1277880]={'896:63.49,31.20 A:1244694'}
G[1277885]={'863:35.43,54.99'}
G[1278197]={'863:64.02,50.41'}
G[1278252]={'895:42.46,27.25 895:51.67,29.68'}
G[1278313]={'895:77.19,84.85'}
G[1278368]={'864:54.37,34.25'}
G[1278436]={'863:66.80,17.33','Up in tree'}
G[1278437]={'863:42.77,26.20','Up tree, then down in building'}
G[1278447]={'864:47.14,38.71'}
G[1278452]={'862:62.71,28.45'}
G[1278461]={'862:48.07,29.44 A:1208420'}
G[1278462]={'862:67.51,33.04 862:62.53,38.38 A:1208420'}
G[1278585]={'896:55.87,35.07'}
G[1278669]={'896:55.64,35.75'}
G[1278675]={'896:55.87,35.06 N:1278585'}
G[1278694]={'862:80.51,13.93 A:1208420'}
G[1278713]={'862:64.94,28.47'}
G[1278793]={'862:64.65,19.53 A:1208420'}
G[1278808]={'895:47.94,16.40'}
G[1279042]={'942:58.61,83.87'}
G[1279253]={'863:77.70,36.12'}
G[1279260]={'863:35.64,85.61'}
G[1279299]={'863:46.22,82.95'}
G[1279337]={'896:37.72,50.39'}
G[1279366]={'863:40.71,26.86 A:1208420'}
G[1279373]={'863:41.60,50.38 A:1208420'}
G[1279379]={'863:54.31,19.60 A:1208420'}
G[1279609]={'1177:23.43,23.59 862:51.72,86.87'}
G[1279689]={'863:62.10,34.86'}
G[1279705]={'862:82.77,42.32'}
G[1279750]={'895:67.36,51.64'}
G[1280504]={'863:76.87,62.19'}
G[1280522]={'863:77.90,46.37'}
G[1280576]={'942:32.20,40.01'}
G[1280619]={'942:42.85,47.21'}
G[1280727]={'942:68.71,54.41'}
G[1280751]={'895:41.51,14.00 895:41.01,12.08 A:1244694'}
G[1280815]={'111:65.54,69.50'}
G[1280836]={'650:57.40,27.91'}
G[1280837]={'364:46.07,26.53'}
G[1280838]={'947:44.10,56.98'}
G[1280842]={'198:44.43,46.62'}
G[1280843]={'118:70.75,73.37'}
G[1280844]={'388:37.81,62.99'}
G[1280845]={'114:27.54,27.08'}
G[1280948]={'81:29.59,69.44'}
G[1280951]={'864:44.32,92.22'}
G[1281092]={'862:64.71,21.68'}
G[1281176]={'862:71.64,41.26'}
G[1281230]={'895:67.14,24.80'}
G[1281348]={'942:49.95,31.76'}
G[1281397]={'895:72.49,58.14'}
G[1281494]={'942:48.98,84.10'}
G[1281551]={'895:75.55,49.94'}
G[1281583]={'864:48.94,74.21'}
G[1281639]={'864:48.93,74.45'}
G[1281646]={'942:66.56,71.12'}
G[1281647]={'895:79.02,45.77 895:80.12,46.90 895:79.48,48.90 895:80.52,49.39'}
G[1281655]={'862:51.44,26.63'}
G[1281673]={'896:30.75,19.57'}
G[1281718]={'895:53.10,28.39'}
G[1281898]={'862:38.79,34.43'}
G[1281903]={'862:39.86,76.54 862:43.87,74.20 A:1208420'}
G[1281905]={'862:81.82,37.51 862:81.09,40.72 862:81.18,38.56 A:1208420'}
G[1281906]={'862:53.47,87.15 A:1208420'}
G[1282153]={'942:67.22,43.20'}
G[1282448]={'942:46.08,61.85'}
G[1282457]={'942:44.04,72.46'}
G[1282478]={'942:46.28,76.96'}
G[1282498]={'864:28.96,54.66'}
G[1282721]={'863:76.46,48.75 A:1208420'}
G[1282722]={'863:32.26,48.60 A:1208420'}
G[1282723]={'863:49.81,79.45 863:33.69,76.15 A:1208420'}
G[1284412]={'864:66.15,25.79 864:64.24,22.23 A:1208420'}
G[1284413]={'864:36.86,52.39 864:36.88,41.42 A:1208420'}
G[1284414]={'864:43.28,90.68 A:1208420'}
G[1284415]={'864:46,48 A:1208420'}
G[1284416]={'864:30.49,53.81 864:28.91,48.04 A:1208420'}
G[1284417]={'864:27.70,69.96 A:1208420'}
G[1284419]={'864:43.63,78.54 A:1208420'}
G[1284420]={'864:54.46,72.84 A:1208420'}
G[1284426]={'896:34.78,40.01'}
G[1284448]={'942:59.91,39.06'}
G[1284454]={'862:61.07,58.58'}
G[1284455]={'862:71.83,16.78'}
G[1286016]={'896:27.45,11.60'}
G[1287081]={'863:52.89,76.03'}
G[1287189]={'862:51.62,45.45'}
G[1287228]={'862:40.79,71.14'}
G[1287229]={'862:44.31,72.12'}
G[1287232]={'863:39.56,79.95'}
G[1287239]={'864:48.17,64.69'}
G[1287304]={'864:49.78,79.39','In cave'}
G[1287318]={'864:47.20,58.44','Top of ruins'}
G[1287320]={'864:44.51,26.13'}
G[1287324]={'864:57.73,64.64','In tunnel'}
G[1287326]={'864:29.38,87.42'}
G[1287327]={'863:62.14,41.02'}
G[1287441]={'864:27.39,53.22'}
G[1287531]={'942:62.04,65.69 942:62.16,62.56 942:65.56,59.88 942:61.80,65.24 A:1244694'}
G[1287958]={'942:30.69,68.14'}
G[1288157]={'942:57.84,55.83'}
G[1288167]={'942:33.77,59.39'}
G[1288214]={'896:19.55,43.61'}
G[1288596]={'1165:44.47,26.91 862:56.14,38.05'}
G[1288604]={'862:80.14,55.05 862:79.11,53.00 A:1208420'}
G[1288622]={'896:31.75,30.79'}
G[1288641]={'895:66.85,24.36'}
G[1289310]={'895:53.10,28.39'}
G[1289313]={'895:42.16,22.99'}
G[1289361]={'895:42.29,27.26'}
G[1289365]={'896:26.43,72.19'}
G[1289647]={'942:66.93,12.07'}
G[1289728]={'864:35.09,80.42'}
G[1290138]={'942:37.85,28.47'}
G[1290419]={'896:55.74,34.99'}
G[1290537]={'942:66.34,57.23'}
G[1290725]={'862:52.96,47.20'}
G[1290750]={'862:65.31,28.21'}
G[1290765]={'942:50.86,56.71'}
G[1290770]={'864:49.36,80.11 864:51.64,87.11 A:1208420'}
G[1290993]={'942:35.89,56.10'}
G[1291013]={'862:67.48,18.85'}
G[1291143]={'864:50.71,64.64'}
G[1291201]={'896:65.15,27.16 896:63.79,32.33 A:1244694'}
G[1291204]={'896:60.44,21.20 896:57.69,28.95 896:58.96,30.43 A:1244694'}
G[1291211]={'896:44.12,28.06 896:43.48,33.08 A:1244694'}
G[1291213]={'896:56.87,42.22 896:55.93,38.46 A:1244694'}
G[1291217]={'896:63.26,58.16 896:66.29,53.77 A:1244694'}
G[1291222]={'896:59.52,69.69 896:64.70,61.96 N:1244694'}
G[1291223]={'896:70.95,63.30 896:69.20,64.71 896:71.61,58.08 A:1244694'}
G[1291224]={'896:34.31,19.48 A:1244694'}
G[1291225]={'896:25.22,25.26 896:30.05,26.89 896:28.70,28.25 A:1244694'}
G[1291226]={'896:26.17,17.57 896:23.31,15.64 896:27.35,13.27 A:1244694'}
G[1291227]={'896:24.29,36.79 896:27.31,38.67 896:24.60,37.57 A:1244694'}
G[1291228]={'896:24.05,56.48 896:20.35,51.97 896:26.69,51.54 896:23.13,52.70 A:1244694'}
G[1291229]={'896:25.13,63.23 896:24.32,60.51 A:1244694'}
G[1291230]={'896:38.76,64.75 A:1244694'}
G[1291244]={'942:69.94,52.71 A:1244694'}
G[1291246]={'942:66.31,43.71 A:1244694'}
G[1291254]={'942:61.20,40.31 A:1244694'}
G[1291255]={'942:75.16,35.17 A:1244694'}
G[1291257]={'942:64.33,70.22 942:69.53,68.07 942:72.71,72.79 A:1244694'}
G[1291258]={'942:46.93,63.86 942:49.82,66.14 942:48.75,71.35 942:48.42,64.65, 942:50.36,62.57 A:1244694'}
G[1291259]={'942:41.80,54.95 942:40.09,57.44 942:40.94,53.20 942:35.37,53.46 A:1244694'}
G[1291263]={'942:42.18,73.45 1183:57.73,55.30 942:44.21,76.05 A:1244694'}
G[1291264]={'942:34.30,75.92 942:28.06,67.51 942:29.78,69.55 A:1244694'}
G[1291265]={'942:32.11,51.56 942:30.45,43.25 942:33.31,45.05 942:28.22,61.38 A:1244694'}
G[1291266]={'942:35.11,34.44 942:39.00,44.74 942:38.49,38.16 A:1244694'}
G[1291267]={'942:59.43,51.53 A:1244694'}
G[1291291]={'862:69.02,40.83'}
G[1292523]={'896:41.25,40.98'}
G[1292673]={'1161:55.98,91.29 895:70.89,41.86'}
G[1292674]={'1161:61.17,77.91 895:72.14,38.63'}
G[1292675]={'1161:63.12,81.87 895:72.62,39.58'}
G[1292676]={'1161:71.01,84.40 895:74.53,40.20'}
G[1292677]={'1161:67.08,79.67 895:73.58,39.05'}
G[1292686]={'1161:55.70,91.09 895:70.82,41.91'}
G[1293349]={'942:58.21,63.67'}
G[1293350]={'942:44.44,73.53'}
G[1293568]={'863:62.40,41.31'}
G[1293821]={'1156:36.94,52.46'}
G[1293852]={'895:54.98,46.07'}
G[1293880]={'895:29.22,25.33'}
G[1293881]={'895:90.51,75.50'}
G[1293884]={'895:48.97,37.59'}
G[1293962]={'895:56.03,33.17'}
G[1293964]={'895:61.78,62.75'}
G[1293965]={'895:72.64,21.33'}
G[1293985]={'942:46.74,48.13'}
G[1294173]={'942:36.70,23.26'}
G[1294174]={'942:46.00,30.69'}
G[1294311]={'942:85.44,50.50 A:1244694'}
G[1294316]={'864:57.05,11.19','Top of temple'}
G[1294317]={'864:40.57,85.75','Top of rocks'}
G[1294319]={'864:26.48,45.35'}
G[1296479]={'1162:64.16,56.83'}
G[1296574]={'864:36.21,78.42'}
G[1296583]={'864:43.19,77.06'}
G[1296584]={'864:47.05,75.80'}
G[1297071]={'942:43.02,56.54'}
G[1297492]={'942:51.02,33.64'}
G[1297825]={'896:33.71,30.09'}
G[1297828]={'896:25.76,19.94'}
G[1297878]={'896:18.53,51.31'}
G[1297879]={'896:55.62,51.83'}
G[1297880]={'896:67.75,73.69'}
G[1297881]={'896:25.46,24.17'}
G[1297891]={'896:63.30,65.85'}
G[1297892]={'896:44.22,27.70'}
G[1297893]={'896:33.69,71.73'}
G[1298858]={'896:37.48,25.63'}
G[1298920]={'896:24.26,48.31'}
G[1303039]={'942:32.15,66.23'}
G[1303170]={'942:32.88,69.65 A:1303039'}
G[1319211]={'62:50.56,22.74 A:1319222'}
G[1319212]={'62:41.06,41.60 A:1319222'}
G[1319222]={'62:41.31,48.21'}
G[1319226]={'62:38.46,60.51 A:1319222'}
G[1322533]={'1355:60.66,33.29'}
G[1322651]={'896:33.12,30.29'}
G[1325659]={'1462:52.11,53.25 1462:56.98,38.61 N:1325662'}
G[1325660]={'1462:35.67,38.35 1462:40.17,54.08 1462:30.82,51.81 N:1325662'}
G[1325661]={'1462:80.38,48.39 1462:73.59,53.27 N:1325662'}
G[1325662]={'1462:81.18,61.49 1462:72.59,47.34 1462:73.01,49.46'}
G[1325664]={'1462:56.75,29.17 N:1325662'}
G[1325665]={'1462:67.32,22.87 N:1325662'}
G[1325667]={'1462:76.50,65.98 1462:72.15,65.43 N:1325662'}
G[1325668]={'1462:12.09,85.69 1462:21.77,83.02 1462:20.53,76.96 N:1325662'}
G[1325853]={'1355:78.43,28.64'}
G[1325869]={'1355:59.57,41.90'}
G[1326027]={'1462:55.85,62.67'}
G[1326047]={'1355:45.12,22.13'}
G[1326140]={'1355:39.11,54.19'}
G[1326141]={'1355:39.11,54.20'}
G[1326142]={'1355:39.11,54.19'}
G[1326148]={'1355:37.22,19.26'}
G[1326393]={'1355:46.11,52.04'}
G[1326401]={'1355:80.35,29.81'}	-- Arcane Chest
G[1327170]={'1355:34.66,21.10'}
G[1327591]={'1355:81.45,45.50'}
G[1327592]={'1355:78.89,41.14'}
G[1329641]={'1462:67.37,35.24'}
G[1329715]={'1462:43.14,41.34'}
G[1329805]={'1355:32.83,39.61'}
G[1332622]={'1355:39.45,53.53'}
G[1334100]={'1355:60.49,33.58'}
G[3234618]={'542:42.42,26.67 N:1234618'}
G[3243912]={'587:47.08,37.93 A:1243912 N:500022'}
G[5102700]={'735:60.43,34.52 A:102700 N:102700'}
G[5103092]={'734:81.59,60.22 A:103092 N:103092'}
G[5106558]={'745:43.65,38.81 A:106558 N:106558'}
G[100001307]={'D:13159 Q:123'}
G[100001357]={'D:515,126,456,171,513 Q:26353'}
G[100003082]={'D:1658 Q:25030'}
G[100004854]={'D:3056 Q:770'}
G[100005179]={'D:3535 Q:927'}
G[100008244]={'D:8301,8299,45258,45262,45257,7846,8298,45260,8302,8303,8297,8300,8304,8296,42334 Q:25772'}
G[100008623]={'D:5457,7269,5419 Q:351'}
G[100008704]={'D:2650,2653,2654,2707,4468,7995,42536,42555,42609 Q:485'}
G[100008705]={'D:39896 Q:25475'}
G[100009326]={'D:6212 Q:2945'}
G[100010593]={'D:8301,8299,45258,45262,45257,7846,8298,45260,8302,8303,8297,8300,8304,8296,42334 Q:25771'}
G[100012842]={'D:10738 Q:28471'}
G[100016303]={'D:12678 Q:23'}
G[100016304]={'D:12677 Q:24'}
G[100016305]={'D:12676 Q:2'}
G[100016408]={'D:12759 Q:1918'}
G[100016782]={'D:12876 Q:6922'}
G[100017203]={'Q:7604'}
G[100018356]={'Z234 Q:7498'}
G[100018357]={'Z234 Q:7499'}
G[100018358]={'Z234 Q:7500'}
G[100018359]={'Z234 Q:7501'}
G[100018360]={'Z234 Q:7502'}
G[100018361]={'Z234 Q:7503'}
G[100018362]={'Z234 Q:7504'}
G[100018363]={'Z234 Q:7505'}
G[100018364]={'Z234 Q:7506'}
G[100018628]={'D:12944 Q:7604'}
G[100018706]={'D:1179697 Q:7810'}
G[100018769]={'Created Q:7649'}
G[100018770]={'Created Q:7650 N:100018769'}
G[100018771]={'Created Q:7651 N:100018769'}
G[100018987]={'D:9046 Q:7761'}
G[100019002]={'D:11583 Q:7783'}
G[100019003]={'D:11583 Q:7781 N:100019002'}
G[100019016]={'D:14347 Q:7785'}	-- TODO: Technically should not be D: since you get it if you have one of two other objects...another thing to think about
G[100019018]={'D:14435 Q:7787'}
G[100019228]={'Created Q:7907'}
G[100019257]={'Created Q:7928'}
G[100019267]={'Created Q:7929'}
G[100019277]={'Created Q:7927'}
G[100019423]={'Created Q:7937'}
G[100019424]={'Created Q:7938'}
G[100019443]={'Created Q:7944'}
G[100019452]={'Created Q:7945'}
G[100019802]={'Preowned Q:8183'}
G[100020461]={'D:11732,11730,13136 Q:8308'}
G[100020483]={'D:15298 Q:8338'}
G[100020644]={'Preowned Q:8446'}
G[100020741]={'D:7156,7157,7158 Q:8470'}
G[100020765]={'D:15968 Q:8482'}
G[100021220]={'D:15339 Q:8791'}
G[100021221]={'D:15727 Q:8801'}
G[100021230]={'Z319 Q:8784'}
G[100021776]={'D:15670 Q:8887'}
G[100022597]={'D:16314 Q:9175'}
G[100022727]={'Preowned Q:9250'}
G[100022733]={'Preowned Q:9251'}
G[100023179]={'86:46.16,37.49 Q:9324'}	-- this is the location of "Flame of Orgrimmar" that you need to click to get the item
G[100023180]={'88:21.45,27.02 Q:9325'}	-- this is the location of "Flame of Thunder Bluff" that you need to click to get the item
G[100023181]={'998:68.25,8.83 Q:9326'}	-- this is the location of "Flame of the Undercity" that you need to click to get the item
G[100023182]={'84:49.79,72.68 Q:9330'}	-- this is the location of "Flame of Stormwind" that you need to click to get the item
G[100023183]={'87:64.47,24.94 Q:9331'}	-- this is the location of "Flame of Ironforge" that you need to click to get the item
G[100023184]={'89:63.99,47.03 Q:9332'}	-- this is the location of "Flame of Darnassus" that you need to click to get the item
G[100023228]={'D:15409 Q:8474'}
G[100023249]={'D:15407 Q:9360'}
G[100023338]={'D:16857 Q:9373'}
G[100023580]={'D:17084 Q:9418'}
G[100023678]={'Z97 Q:9455'}
G[100023759]={'Z97 Q:9514'}
G[100023777]={'D:6073,6115,11697 Q:26443'}
G[100023797]={'D:6073,6115,11697 Q:26447 N:100023777'}
G[100023837]={'Z106 Q:9550'}
G[100023850]={'Z97 Q:9564'}
G[100023870]={'Z106 Q:9576'}
G[100023900]={'D:17528 Q:9594'}
G[100023910]={'Z97 Q:9616'}
G[100024132]={'Mailbox476 Q:9672'}	-- moved from Z464
G[100024330]={'Z102 Q:9731'}
G[100024367]={'Z263 Q:9764'}
G[100024407]={'Z102 Q:9875'}
G[100024414]={'D:16522 Q:9798'}
G[100024483]={'D:18124 Q:9827'}
G[100024484]={'D:18124 Q:9828 N:100024483'}
G[100024504]={'Z107 Q:9861'}
G[100024558]={'Z107 Q:9872'}
G[100024559]={'Z107 Q:9871 N:100024558'}
G[100025459]={'D:18285 Q:9911'}
G[100028552]={'Z100 Q:10229'}
G[100029233]={'Z109 Q:10182'}
G[100029234]={'Z109 Q:10305'}
G[100029235]={'Z109 Q:10306'}
G[100029236]={'Z109 Q:10307'}
G[100029476]={'D:19188 Q:10134'}
G[100029588]={'Z100 Q:10395'}
G[100029590]={'Z100 Q:10393 N:100029588'}
G[100029738]={'D:20779 Q:10413'}
G[100030431]={'D:19995,19998 Q:10524'}
G[100030579]={'D:21499 Q:10623'}
G[100030756]={'D:21499 Q:10621 N:100030579'}
G[100031120]={'D:21810 Q:10719'}
G[100031345]={'Z104 Q:10793'}
G[100031363]={'Z105 Q:10797'}
G[100031384]={'Z105 Q:10810'}
G[100031489]={'D:19990 Q:10825'}
G[100031707]={'Z108 Q:10880'}
G[100031890]={'Created Q:10938'}
G[100031891]={'Created Q:10939'}
G[100031907]={'Created Q:10940'}
G[100031914]={'Created Q:10941'}
G[100032385]={'Z331 Q:11002'}
G[100032386]={'Z331 Q:11003 N:100032385'}
G[100032405]={'Z334 Q:11007'}
G[100032523]={'D:23066 Q:11021'}
G[100032621]={'D:23267 Q:11041'}
G[100032726]={'D:23286,23324 Q:11081'}
G[100033289]={'Z117 Q:11237'}
G[100033314]={'Z117 Q:11249'}
G[100033345]={'Z117 Q:11260 N:100033314'}
G[100033347]={'Z117 Q:11266 N:100033289'}
G[100033961]={'Z117 Q:11395'}
G[100033962]={'Z117 Q:11398 N:100033961'}
G[100034090]={'D:24018 Q:11452'}
G[100034091]={'D:24018 Q:11453 N:100034090'}
G[100034469]={'Z102 Q:11531'}
G[100034777]={'Z114 Q:11632'}
G[100034815]={'Z114 Q:11654'}
G[100034984]={'Z114 Q:11729'}
G[100035568]={'110:69.17,43.42 Q:11935'}	-- this is the location of "Flame of Silvermoon" that you need to click to get the item
G[100035569]={'103:41.12,26.11 Q:11933'}	-- this is the location of "Flame of the Exodar" that you need to click to get the item
G[100035648]={'Z114 Q:11941'}
G[100035723]={'Z265 Q:11972'}
G[100036742]={'Z115 Q:12055'}
G[100036744]={'Z115 Q:12057'}
G[100036746]={'Z115 Q:12059 N:100036742'}
G[100036756]={'Z115 Q:12067'}
G[100036780]={'Z115 Q:12085'}
G[100036855]={'Z115 Q:12146'}
G[100036856]={'Z115 Q:12147 N:100036855'}
G[100036940]={'D:27546 Q:12105'}
G[100036958]={'Z115 Q:12168'}
G[100037163]={'Created Q:12517'}
G[100037164]={'Created Q:12798'}
G[100037432]={'Z115 Q:12271'}
G[100037571]={'Created Q:12278 N:100037736'}
G[100037599]={'Created Q:12306 N:100037736'}
G[100037736]={'Created Q:12420'} -- technically bought for 200 tokens
G[100037737]={'Created Q:12421 N:100037736'} -- technically bought for 200 tokens
G[100037830]={'Z116 Q:12423 N:100036940'}
G[100037833]={'Z115 Q:12419'}
G[100038280]={'Z242 Q:12491'}
G[100038281]={'Z242 Q:12492 N:100038280'}
G[100038321]={'D:28034,28035,28036 Q:12507'}
G[100038567]={'D:4656 Q:14330'}
G[100038660]={'D:28519 Q:12631'}
G[100038673]={'D:28519 Q:12633'}
G[100040666]={'Z118 Q:12839'}
G[100041267]={'Z120 Q:12888'}
G[100041556]={'D:29375 Q:12922'}
G[100042203]={'D:29380 Q:12979'}
G[100042772]={'Z118 Q:13043'}
G[100043039]={'Created Q:12517 N:100037163'}
G[100043242]={'Z118 Q:13136'}
G[100043297]={'Z118 Q:13148'}
G[100043512]={'D:30329 Q:13204'}
G[100043876]={'Q:13265,13268,13269,13270,13272'}	-- perhaps not related
G[100044148]={'Created Q:12518'}
G[100044158]={'Created Q:13311'}
G[100044259]={'Created Q:13324'}
G[100044276]={'Created Q:13325'}
G[100044294]={'Created Q:13327'}
G[100044326]={'Created Q:13326'}
G[100044569]={'Z162 Q:13372'}
G[100044577]={'Z162 Q:13375'}
G[100044725]={'Z120 Q:13420'}
G[100044927]={'D:33022 Q:13557'}
G[100044979]={'D:32863 Q:13506'}
G[100045040]={'D:32970 Q:13510'}
G[100045506]={'Z147 Q:13604'}
G[100045857]={'Z147 Q:13817 N:100045506'}
G[100045858]={'Created Q:6607,13826'}
G[100046004]={'D:28742 Q:13845'}
G[100046052]={'Z147 Q:13631'}
G[100046053]={'A:32871 Q:13819 N:100046052'}
G[100046128]={'Z63 Q:13868'}
G[100046318]={'D:32862 Q:13591'}
G[100046544]={''}
G[100046545]={''}
G[100046856]={'Z194 Q:28607'}
G[100046955]={'Z118 Q:14095'}
G[100047039]={'D:35095 Q:14127'}
G[100048679]={'D:28742 Q:14203'}
G[100049010]={'D:4667,4664,4663,4666,4665 Q:14232'}
G[100049200]={'D:35591 Q:14344'}
G[100049203]={'D:4667,4664,4663,4666,4665 Q:14362 N:100049010'}
G[100049220]={'D:35591 Q:14376 N:100049200'}
G[100049643]={'D:10184 Q:24429'}
G[100049644]={'D:10184 Q:24428 N:100049643'}
G[100049667]={'D:28742 Q:24431 N:100048679'}
G[100049676]={'Z118 Q:24442'}
G[100049776]={'Z199 Q:24518'}
G[100049932]={'Z199 Q:24606'}
G[100050320]={'D:36296 Q:14483,24745'}
G[100050379]={'Z183 Q:14443'}
G[100050380]={'Z183 Q:24554 N:100050379'}
G[100051315]={'Z186 Q:24914'}
G[100052079]={'D:1535 Q:24979'}
G[100052197]={'Z207 Q:25047'}
G[100052843]={'Q:28799,28803,28804'}
G[100053053]={'D:39918 Q:25377'}
G[100054345]={'D:40276 Q:25467'}
G[100054614]={'D:40510 Q:25442'}
G[100054639]={'D:41183 Q:25503'}
G[100055166]={'D:39896 Q:25451'}
G[100055167]={'D:39896 Q:25454'}
G[100055181]={'D:40905 Q:25647'}
G[100055186]={'D:41017 Q:25419'}
G[100055243]={'D:41167 Q:25736'}
G[100056474]={'D:41937 Q:26016'}
G[100056571]={'D:41925,41926 Q:26019'}
G[100056812]={'D:41925,41926 Q:26090 N:100056571'}
G[100056836]={'Created Q:29396,29397'}
G[100057102]={'D:41652,41657 Q:26144'}
G[100057118]={'D:41652,41657 Q:26149 N:100057102'}
G[100057935]={'D:114 Q:26252'}
G[100058117]={'D:42677 Q:26296'}
G[100058491]={'D:1142,1144 Q:26407'}
G[100058898]={'D:430,445,446 Q:26519'}
G[100059143]={'D:43454 Q:26617'}
G[100060816]={'D:43158 Q:27100'}
G[100060956]={'D:45301,46657 Q:27322'}
G[100061310]={'D:45728 Q:27480 N:45728'}
G[100061378]={'D:45867,45868 Q:27551'}
G[100061505]={'D:45896 Q:27574'}
G[100062021]={'Created Q:27664'}
G[100062044]={'Created Q:27666'}
G[100062045]={'Created Q:27665'}
G[100062046]={'Created Q:27667'}
G[100062056]={'Created Q:27675'}
G[100062138]={'D:40987 Q:27687'}
G[100062281]={'D:39638,41227 Q:27716'}
G[100062282]={'D:39638,41227 Q:27717 N:100062281'}
G[100062483]={'D:46590,46920,47014 Q:27760'}
G[100062768]={'D:46993 Q:27925,28132'}
G[100062933]={'D:14636 32:45,30.8 Q:28058'} -- from Pillaclencher's Ornate Pillow
G[100063090]={'D:47759 Q:28154'}
G[100063127]={'Q:28798'}
G[100063128]={'Q:29261,29262'}
G[100063250]={'D:47789 Q:28196'}
G[100063276]={'Created Q:27686 N:100062056'}
G[100063686]={'D:2368,2369,2370,2371 Q:28356'}
G[100063700]={'D:48428 Q:28376'}
G[100064353]={'D:10916,7438,7439,7440,7441,7442 Q:28462'}
G[100064397]={'Q:28800,28801,28802'}
G[100064450]={'D:48764 Q:28529'}
G[100065894]={'Z244 Q:28777'}
G[100065895]={'Z249 Q:28778'}
G[100065896]={'Z249 Q:28775'}
G[100065897]={'Z249 Q:28776'}
G[100069854]={'Mailbox Q:29298'}
G[100071635]={'Z407'} -- bogus zone just to get it to appear
G[100071636]={'Z407'} -- bogus zone just to get it to appear
G[100071637]={'Z407'} -- bogus zone just to get it to appear
G[100071638]={'Z407'} -- bogus zone just to get it to appear
G[100071715]={'Z407'} -- bogus zone just to get it to appear
G[100071716]={'Z407'} -- bogus zone just to get it to appear
G[100071951]={'Z407'} -- bogus zone just to get it to appear
G[100071952]={'Z407'} -- bogus zone just to get it to appear
G[100071953]={'Z407'} -- bogus zone just to get it to appear
G[100074642]={'Z376 Q:30414'}
G[100074643]={'Z376 Q:30439'}
G[100074644]={'Z376 Q:30390'}
G[100074645]={'Z376 Q:30408'}
G[100074647]={'Z376 Q:30402'}
G[100074649]={'Z376 Q:30396'}
G[100074651]={'Z376 Q:30386'}
G[100074652]={'Z376 Q:30433'}
G[100074654]={'Z376 Q:30421'}
G[100074655]={'Z376 Q:30427'}
G[100077957]={'D:54590,54968 Q:30105'}
G[100078960]={'Z371 Q:30140'}
G[100078961]={'Z371 Q:30141'}
G[100078962]={'Z371 Q:30139'}
G[100079264]={'Z376 Q:30422'}
G[100079265]={'Z376 Q:30425'}
G[100079266]={'Z376 Q:30424'}
G[100079267]={'Z376 Q:30423'}
G[100079268]={'Z376 Q:30389'}
G[100079323]={'Created Q:30452'}
G[100079326]={'Created Q:30451'}
G[100080240]={'Z376 Q:30597'}	-- actually any Pandaria zone
G[100080241]={'D:59335 Q:30582'}
G[100080827]={'D:60299 Q:30675'}
G[100082870]={'D:61970 Q:31023'}
G[100083767]={'D:56833 Q:29758'}
G[100083769]={'Mailbox Q:31055'}
G[100083770]={'Mailbox Q:31093'}
G[100083771]={'Mailbox Q:31094'}
G[100083772]={'Mailbox Q:31095'}
G[100083773]={'Mailbox Q:31097'}
G[100083774]={'Mailbox Q:31096'}
G[100083777]={'Mailbox Q:31100'}
G[100083779]={'Mailbox Q:31102'}
G[100083780]={'Mailbox Q:31103'}
G[100085477]={'Created Q:31794'}
G[100085557]={'Created Q:31795'}
G[100085558]={'Created Q:31796'}
G[100085783]={'D:63809 Q:31261'}
G[100086404]={'D:59639 Q:31312'}
G[100086425]={'Q:31332'}
G[100086433]={'D:59119,59121 Q:31325'}	-- TODO: Make this available from the chief one kills as well
G[100086434]={'D:59119,59121 Q:31326'}
G[100086435]={'D:59123 Q:31328'}
G[100086436]={'D:59123 Q:31329'}
G[100086542]={'Z371 Z376 Z379 Z388 Z390 Z433 Z554 Q:31443'}	-- From Fishing in Jade Forest
G[100086544]={'Z422 Q:31444'}	-- From Fishing in Dread Wastes
G[100086545]={'Z418 Q:31446'}	-- From Fishing in Krasarang Wilds
G[100087871]={'D:65229 Q:31598'}
G[100087878]={'D:64724 Q:31599'}
G[100088715]={'D:65502 Q:31677'}
G[100089155]={'Z371 Q:31784'}
G[100089169]={'Created Q:31786'}
G[100089170]={'Created Q:31787'}
G[100089171]={'Created Q:31788'}
G[100089172]={'Created Q:31789'}
G[100089173]={'Created Q:31790'}
G[100089174]={'Created Q:31791'}
G[100089175]={'Created Q:31792'}
G[100089176]={'Created Q:31793'}
G[100089178]={'Created Q:31797'}
G[100089179]={'Created Q:31798'}
G[100089180]={'Created Q:31799'}
G[100089181]={'Created Q:31800'}
G[100089182]={'Created Q:31801'}
G[100089183]={'Created Q:31802'}
G[100089184]={'Created Q:31803'}
G[100089185]={'Created Q:31804'}
G[100089209]={'Created Q:31805'}
G[100089317]={'D:60491 Q:31809'}
G[100089812]={'D:58706 Q:31936'}	-- TODO: Need to make a "Buy from" instead of kill :-)
G[100089813]={'D:58706 Q:31937'}
G[100089814]={'D:58706 Q:31938'}
G[100091819]={'Q:32161'}
G[100091821]={'Q:32162'}
G[100091822]={'Q:32163'}
G[100091854]={'D:67881 Q:32164 N:100091819'}
G[100091855]={'D:67881 Q:32165 N:100091821'}
G[100091856]={'D:67881 Q:32166 N:100091822'}
G[100092441]={'Created Q:32295'}
G[100094721]={'D:69461 Q:32621'}
G[100094862]={'D:69461 Q:32630'}
G[100095383]={'Created Q:32686'}
G[100095384]={'Created Q:32687'}
G[100095385]={'Created Q:32688'}
G[100095386]={'Created Q:32689'}
G[100095387]={'Created Q:32690'}
G[100095388]={'Created Q:32691'}
G[100095389]={'Created Q:32692'}
G[100095390]={'Created Q:32693'}
G[100097979]={'Q:32838'}
G[100097982]={'Q:32844'}
G[100097985]={'D:43929,77789 Q:32850'}
G[100097986]={'Q:32852'}
G[100097988]={'Q:32856'}
G[100102225]={'D:1222684 Q:32974'}
G[100104257]={'Q:33239'}
G[100104264]={'Q:33234'}
G[100104265]={'Q:33235'}
G[100104266]={'D:72842,72843,72844,73160 Q:33236'}
G[100104267]={'Q:33238'}
G[100109121]={'D:77106 Q:34067'}
G[100109258]={'Q:37669'}
G[100111812]={'Q:37669'}
G[100111813]={'Q:37669'}
G[100111814]={'Q:37669'}
G[100111815]={'Q:37669'}
G[100111816]={'Q:37669'}
G[100111817]={'Q:37669'}
G[100111818]={'Q:37669'}
G[100112378]={'D:80714 Q:35021'}
G[100112566]={'D:74254 Q:35058 N:100113103'}
G[100113080]={'D:80586 Q:33928'}
G[100113103]={'D:75043 Q:35342'}
G[100113107]={'Q:35356'}
G[100113109]={'Q:35377'}
G[100113260]={'D:80714 Q:35642 N:100112378'}
G[100113448]={'D:81528 Q:35811'}
G[100113449]={'D:81528 Q:35812 N:100113448'}
G[100113453]={'D:80785 Q:35813'}
G[100113454]={'D:80785 Q:35814 N:100113453'}
G[100113461]={'D:81537 Q:35820'}
G[100113586]={'D:81775 Q:35944'}
G[100113590]={'D:81775 Q:35948 N:100113586'}
G[100114018]={'D:81240 Q:36075'}
G[100114019]={'D:81240 Q:36076 N:100114018'}
G[100114020]={'D:80685 Q:36078'}
G[100114021]={'D:80685 Q:36080 N:100114020'}
G[100114022]={'D:80689 Q:36081'}
G[100114023]={'D:80689 Q:36083 N:100114022'}
G[100114024]={'D:80696 Q:36084'}
G[100114025]={'D:80696 Q:36086 N:100114024'}
G[100114026]={'D:81617 Q:36090'}
G[100114027]={'D:81617 Q:36091 N:100114026'}
G[100114029]={'D:81630 Q:36092'}
G[100114030]={'D:81630 Q:36094 N:100114029'}
G[100114031]={'D:85779 Q:36096'}
G[100114032]={'D:85779 Q:36097 N:100114031'}
G[100114033]={'D:85695 Q:36098'}
G[100114034]={'D:85695 Q:36101 N:100114033'}
G[100114035]={'D:85694 Q:36103'}
G[100114036]={'D:85694 Q:36104 N:100114035'}
G[100114037]={'D:83458,81685,80725,78257,86439,85924 Q:36105'}
G[100114038]={'D:83458,81685,80725,78257,86439,85924 Q:36106 N:100114037'}
G[100114054]={'Q:36109'}
G[100114146]={'Created Q:36744'}
G[100114877]={'D:75043 Q:36176'}
G[100114965]={'D:74254 Q:36205'}
G[100114972]={'D:75043 Q:36236'}
G[100114973]={'D:74254 Q:36301'}
G[100114984]={'D:75043 Q:36239'}
G[100115008]={'D:74254 Q:36255'}
G[100115278]={'D:75043 Q:36286'}
G[100115281]={'D:75043 Q:36308 N:100115008'}
G[100115287]={'D:74254 Q:36314'}
G[100115343]={'D:75043 Q:36309'}
G[100115467]={'D:85199 Q:36385'}
G[100115507]={'D:75043 Q:36408'}
G[100115593]={'D:74254 Q:36435'}
G[100116120]={'542:37.73,56.32'}
G[100116159]={'D:75207 Q:36502'}
G[100116173]={'D:74254 Q:36505'}
G[100116395]={'Q:37290'}
G[100116438]={'D:74254 Q:36589'}
G[100119208]={'Mail Q:37322'}
G[100119310]={'D:77325 Q:37540'}
G[100119316]={'D:77325 Q:37541'}
G[100119317]={'D:82318 Q:37332'}
G[100119323]={'D:77325 Q:37543'}
G[100120206]={'D:77325 Q:37551'}
G[100120207]={'D:77325 Q:37547'}
G[100120208]={'D:77325 Q:37549'}
G[100120209]={'D:77325 Q:37552'}
G[100120210]={'D:77325 Q:37548'}
G[100120211]={'D:77325 Q:37550'}
G[100120277]={'D:77325 Q:37553'}
G[100120278]={'D:77325 Q:37554'}
G[100120279]={'D:77325 Q:37555'}
G[100120280]={'D:77325 Q:37557'}
G[100120281]={'D:77325 Q:37559'}
G[100120282]={'D:77325 Q:37558'}
G[100120283]={'D:77325 Q:37560'}
G[100120284]={'D:77325 Q:37562'}
G[100120285]={'D:77325 Q:37561'}
G[100122224]={'D:1240616 Q:38089'}
G[100122226]={'D:1240617 Q:38090'}
G[100122239]={'D:1240625 Q:38100'}
G[100122399]={'D:578564,78564 Q:38190'}	-- really sold by...do not kill NPC :-)
G[100122400]={'D:79774 Q:38179 N:100122404'}
G[100122401]={'D:578564,78564 Q:38189'}	-- really sold by...do not kill NPC :-)
G[100122402]={'D:79774 Q:38178 N:100122406'}
G[100122403]={'D:79774 Q:38177 N:100122399'}
G[100122404]={'D:578564,78564 Q:38192'}	-- really sold by...do not kill NPC :-)
G[100122405]={'D:79774 Q:38176 N:100122401'}
G[100122406]={'D:578564,78564 Q:38191'}	-- really sold by...do not kill NPC :-)
G[100122407]={'D:578564,78564 Q:38200'}	-- really sold by...do not kill NPC :-)
G[100122408]={'D:79774 Q:38186 N:100122407'}
G[100122409]={'D:578564,78564 Q:38199'}	-- really sold by...do not kill NPC :-)
G[100122410]={'D:578564,78564 Q:38201 N:100122412'}	-- really sold by...do not kill NPC :-)
G[100122411]={'D:79774 Q:38185 N:100122409'}
G[100122412]={'D:79774 Q:38187'}
G[100122413]={'D:79774 Q:38184 N:100122414'}
G[100122414]={'D:578564,78564 Q:38198'}	-- really sold by...do not kill NPC :-)
G[100122415]={'D:578564,78564 Q:38197'}	-- really sold by...do not kill NPC :-)
G[100122416]={'D:79774 Q:38183 N:100122415'}
G[100122417]={'D:578564,78564 Q:38196'}	-- really sold by...do not kill NPC :-)
G[100122418]={'D:79774 Q:38182 N:100122417'}
G[100122419]={'D:79774 N:100122420'}
G[100122420]={'D:578564,78564'}	-- really sold by...do not kill NPC :-)
G[100122421]={'D:79774 Q:38181 N:100122422'}
G[100122422]={'D:578564,78564 Q:38195'}	-- really sold by...do not kill NPC :-)
G[100122423]={'D:578564,78564 Q:38193'}	-- really sold by...do not kill NPC :-)
G[100122424]={'D:79774 Q:38180 N:100122423'}
G[100122699]={'D:109174 Q:38407'}
G[100123980]={'D:91474 Q:38862'}
G[100124131]={'D:92802 Q:38656'}
G[100126950]={'D:92552 Q:38932'}
G[100127860]={'D:94366 Q:38711'}
G[100127989]={'Q:39278'}
G[100128231]={'D:94472 Q:39355'}
G[100128232]={'D:92408 Q:39356'}
G[100128250]={'D:90974,96014 Q:39358'}	-- really is sold, no need to kill NPC :-)	-- TODO: Set up NPC 96014
G[100128252]={'D:90122 Q:39360'}
G[100128255]={'D:90519 Q:39363'}
G[100128256]={'D:90284 Q:39364'}	-- TODO: Set up NPC 90284
G[100128257]={'D:93076 Q:39365'}
G[100128258]={'D:92647 Q:39366'}
G[100128340]={'D:91318 Q:38146'}
G[100128491]={'D:90974,96014 Q:39359'}	-- really is sold, no need to kill NPC :-)	-- TODO: Set up NPC 96014
G[100128511]={'D:96229 Q:39595'}
G[100129747]={'Q:40168'}	-- TODO: Need to get list of bosses that can drop this
G[100129928]={'Q:40173'}	-- TODO: Need to get list of bosses that can drop this
G[100130921]={'Q:40349'}	-- TODO: This is created from highborne artifacts using archaeology
G[100130923]={'Q:40351'}	-- TODO: This is created from highborne artifacts using archaeology
G[100130925]={'Q:40353'}	-- TODO: This is created from highborne artifacts using archaeology
G[100130926]={'Q:40354'}	-- TODO: This is created from highmountain artifacts using archaeology
G[100130927]={'Q:40355'}	-- TODO: This is created from highmountain artifacts using archaeology
G[100130928]={'Q:40356'}	-- TODO: This is created from highmountain artifacts using archaeology
G[100130929]={'Q:40357'}	-- TODO: This is created from highmountain artifacts using archaeology
G[100130931]={'Q:40359'}	-- TODO: This is created from daemon artifacts using archaeology
G[100130933]={'Q:40361'}	-- TODO: This is created from daemon artifacts using archaeology
G[100130934]={'Q:40362'}	-- TODO: This is created from daemon artifacts using archaeology
G[100133377]={'Q:40786'}	-- TODO: Need to get list of bosses that can drop this
G[100133378]={'Q:40787 N:100133377'}	-- TODO: Need to get list of bosses that can drop this
G[100133675]={'D:101784 Q:41030'}
G[100138441]={'Q:42786'}
G[100138992]={'Q:42978'}
G[100139480]={'Q:43546'}	-- Gotten from Scouting Map follower mission
G[100139481]={'Q:43547'}	-- Gotten from Scouting Map follower mission
G[100140147]={'Q:43882'}	-- Gotten from Scouting Map follower mission
G[100140149]={'Q:43889'}	-- Gotten from Scouting Map follower mission
G[100140163]={'Q:43902'}	-- Gotten from Scouting Map follower mission
G[100140164]={'Q:43903'}	-- Gotten from Scouting Map follower mission
G[100140171]={'Q:43910'}	-- Gotten from Scouting Map follower mission
G[100140173]={'Q:43912'}	-- Gotten from Scouting Map follower mission
G[100140174]={'Q:43913'}	-- Gotten from Scouting Map follower mission
G[100140175]={'Q:43914'}	-- Gotten from Scouting Map follower mission
G[100140177]={'Q:43915'}	-- Gotten from Scouting Map follower mission
G[100140249]={'D:114255 Q:43942'}
G[100140495]={'Q:44057'}	-- Gotten from a Nightfallen emissary reward (after having gotten Revered rep)
G[100140778]={'Q:44176'}	-- looted from Suramar world quest
G[100141186]={'Q:44259'}	-- Gotten from Scouting Map follower mission
G[100141187]={'Q:44260'}	-- Gotten from Scouting Map follower mission
G[100141190]={'Q:44263'}	-- Gotten from Scouting Map follower mission
G[100141191]={'Q:44264'}	-- Gotten from Scouting Map follower mission
G[100141192]={'Q:44265'}	-- Gotten from Scouting Map follower mission
G[100141193]={'D:127476 Q:44266'}	-- Gotten from Scouting Map follower mission
G[100141194]={'D:127476 Q:44267'}	-- Gotten from Scouting Map follower mission
G[100141196]={'D:127476 Q:44269'}	-- Gotten from Scouting Map follower mission
G[100141197]={'D:127476 Q:44270'}	-- Gotten from Scouting Map follower mission
G[100141198]={'D:127476 Q:44271'}	-- Gotten from Scouting Map follower mission
G[100141199]={'D:127476 Q:44272'}	-- Gotten from Scouting Map follower mission
G[100141200]={'D:127476 Q:44273'}	-- Gotten from Scouting Map follower mission
G[100141201]={'D:127476 Q:44274'}	-- Gotten from Scouting Map follower mission
G[100141202]={'D:127476 Q:44275'}	-- Gotten from Scouting Map follower mission
G[100141204]={'D:127476 Q:44277'}	-- Gotten from Scouting Map follower mission
G[100142340]={'D:127476 Q:44917'}	-- Gotten from Scouting Map follower mission
G[100142344]={'D:7025 Q:44926'}
G[100142522]={'D:127476 Q:45111'}	-- Gotten from Scouting Map follower mission
G[100142553]={'D:127476 Q:45162'}	-- Gotten from Scouting Map follower mission
G[100142554]={'D:127476 Q:45163'}	-- Gotten from Scouting Map follower mission
G[100142559]={'D:104415 Q:45159'}
G[100143328]={'D:127476 Q:45172'}	-- Gotten from Scouting Map follower mission
G[100143329]={'D:127476 Q:45173'}	-- Gotten from Scouting Map follower mission
G[100143478]={'D:127476 Q:45179'}	-- Gotten from Scouting Map follower mission
G[100143479]={'D:127476 Q:45180'}	-- Gotten from Scouting Map follower mission
G[100143561]={'D:127476 Q:45304'}	-- Gotten from Scouting Map follower mission
G[100147497]={'D:127476 Q:47714'}	-- Gotten from Scouting Map follower mission
G[100147501]={'D:127476 Q:47718'}	-- Gotten from Scouting Map follower mission
G[100147505]={'D:127476,98000,98613,98695,102669,102589,98093,97389,93787 Q:47122'}	-- Gotten from Scouting Map follower mission -- Need DK, Monk, Shaman, Warlock
G[100147506]={'D:127476 Q:47123'}	-- Gotten from Scouting Map follower mission
G[100147507]={'D:127476 Q:47124'}	-- Gotten from Scouting Map follower mission
G[100147508]={'D:127476 Q:47125'}	-- Gotten from Scouting Map follower mission
G[100147509]={'D:127476 Q:47126'}	-- Gotten from Scouting Map follower mission
G[100151462]={'Q:47793'}	-- gotten from Nightfallen cache (from 10K after exalted reward)
G[100152204]={'D:122403 Q:48230'}
G[100152313]={'D:127476 Q:48288'}	-- Gotten from Scouting Map follower mission
G[100152317]={'D:127476 Q:48292'}	-- Gotten from Scouting Map follower mission
G[100152321]={'D:127476 Q:48293'}	-- Gotten from Scouting Map follower mission
G[100152325]={'D:127476 Q:48294'}	-- Gotten from Scouting Map follower mission
G[100157849]={'D:130073 Q:50367'}
G[100158195]={'D:130094,130088 Q:50593'}
G[100159748]={'D:136490 Q:51134'}
G[100163710]={'D137468 Q:53357'}
G[100235344]={'Created Q:36770'}
G[100299011]={'D:129633 Q:49806'}
G[200033529]={100046544,''}
G[200033530]={100046545,''}
end

local N = Grail.npc
for key, value in pairs(Grail.npcs) do
	if value[1] then
		N.locations[key] = {}
		local codeArray = { strsplit(" ", value[1]) }
		local controlCode
		for _, code in pairs(codeArray) do
			controlCode = strsub(code, 1, 1)
			if 'A' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					local alias = tonumber(strsub(code, 3))
					if nil ~= alias then
						N.nameIndex[key] = alias
						N.aliases[alias] = N.aliases[alias] or {}
						tinsert(N.aliases[alias], key)
					else
						print("*** NPC processing of",key,"has improper alias")
					end
				end
			elseif 'C' == controlCode then
				tinsert(N.locations[key], { created = true })
			elseif 'D' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					N.droppedBy[key] = N.droppedBy[key] or {}
					local npcIds = { strsplit(',', strsub(code, 3)) }
					for _, anNPCId in pairs(npcIds) do
						local npcNumber = tonumber(anNPCId)
						if nil ~= npcNumber then
							tinsert(N.droppedBy[key], npcNumber)
							N.has[npcNumber] = N.has[npcNumber] or {}
							tinsert(N.has[npcNumber], key)
						end
					end
				end
			elseif 'H' == controlCode then
				-- the "has" codes are deprecated as we will populate the data based on "drop" codes instead
				if 2 < strlen(code) then
					local subcode = strsub(code, 2, 2)
					if ':' ~= subcode then
						local holidays = N.holiday[key]
						if nil == holidays then
							holidays = ''
						end
						N.holiday[key] = holidays .. subcode
					end
				end
			elseif 'K' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					N.kill[key] = N.kill[key] or {}
					local questList = { strsplit(',', strsub(code, 3)) }
					for _, questId in pairs(questList) do
						tinsert(N.kill[key], tonumber(questId))
					end
				end
			elseif 'M' == controlCode then
				local t1 = { mailbox = true }
				if 7 < strlen(code) then
					t1.mapArea = tonumber(strsub(code, 8))
				end
				tinsert(N.locations[key], t1)
			elseif 'N' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					local nameIndexToUse = tonumber(strsub(code, 3))
					N.nameIndex[key] = nameIndexToUse
				else
					local t1 = { near = true }
					if 4 < strlen(code) then
						t1.mapArea = tonumber(strsub(code, 5))
					end
					tinsert(N.locations[key], t1)
				end
			elseif 'P' == controlCode then
				-- we do nothing special for "Preowned" at the moment
			elseif 'Q' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					N.questAssociations[key] = N.questAssociations[key] or {}
					local questList = { strsplit(',', strsub(code, 3)) }
					for _, questId in pairs(questList) do
						tinsert(N.questAssociations[key], tonumber(questId))
					end
				end
			elseif 'S' == controlCode then
				-- we do nothing special for "Self" at the moment
			elseif 'X' == controlCode then
				N.heroic[key] = true
			elseif 'Z' == controlCode then
				tinsert(N.locations[key], { ["mapArea"]=tonumber(strsub(code, 2)) })
			else	-- a real coordinate
				tinsert(N.locations[key], Grail:_LocationStructure(code))
			end
		end
	end
	if value[2] then N.comment[key] = value[2] end
	if value[3] then N.faction[key] = value[3] end

end
-- TODO: Go through all the Grail.npc.droppedBy values and make sure the locations for the NPCs are added to those keys

Grail.npcs = nil
--	18.84/19.29 idle after a couple minutes at startup without these changes.
--	18.25/18.69	idle after a couple minutes at startup WITH these changes.

Grail.memoryUsage.NPCs = gcinfo() - originalMem

-- 81152 garrison level 1: 582:46.56,54.33 539:30.46,18.28

