/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReadExcel {
    private static Logger logger = Logger.getLogger(ReadExcel.class.getName());
    private static final String OFFICE_EXCEL_XLS = "xls";
    private static final String OFFICE_EXCEL_XLSX = "xlsx";

    public static Workbook getWorkbook(InputStream inputStream, String fileType) {
        HSSFWorkbook workbook = null;
        try {
            if (fileType.equals(OFFICE_EXCEL_XLS)) {
                workbook = new HSSFWorkbook(inputStream);
            } else if (fileType.equals(OFFICE_EXCEL_XLSX)) {
                workbook = new XSSFWorkbook(inputStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ArrayList<String>> readExcelContent(String fileName, int titleNumber) {
        Workbook workbook = null;
        FileInputStream inputStream = null;
        try {
            List<ArrayList<String>> excelList;
            String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            File excelFile = new File(fileName);
            if (!excelFile.exists()) {
                logger.warning("\u6307\u5b9a\u7684Excel\u6587\u4ef6\u4e0d\u5b58\u5728");
                List<ArrayList<String>> list = null;
                return list;
            }
            inputStream = new FileInputStream(excelFile);
            workbook = ReadExcel.getWorkbook(inputStream, fileType);
            List<ArrayList<String>> list = excelList = ReadExcel.parseExcelFile(workbook, titleNumber);
            return list;
        }
        catch (Exception e) {
            logger.warning("\u89e3\u6790Excel\u5931\u8d25\uff0c\u6587\u4ef6\u540d\uff1a" + fileName + "\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
            e.printStackTrace();
            List<ArrayList<String>> list = null;
            return list;
        }
        finally {
            try {
                if (null != workbook) {
                    workbook.close();
                }
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                logger.warning("\u5173\u95ed\u6570\u636e\u6d41\u51fa\u9519\uff1a" + e.getMessage());
                e.printStackTrace();
                return null;
            }
        }
    }

    public static List<ArrayList<String>> parseExcelFile(Workbook workbook, int titleRowNum) {
        ArrayList<ArrayList<String>> resultDataList = new ArrayList<ArrayList<String>>();
        int is = workbook.getNumberOfSheets();
        System.out.println("\u6b64\u5de5\u4f5c\u84b2\u5bf9\u8c61\u5171\u6709\uff1a" + is + "\u9875");
        int workbookSize = workbook.getNumberOfSheets();
        for (int sheetNumber = 0; sheetNumber < workbookSize; ++sheetNumber) {
            Sheet sheet = workbook.getSheetAt(sheetNumber);
            if (sheet == null) continue;
            int firstRowNum = titleRowNum;
            int lastRow = sheet.getPhysicalNumberOfRows();
            System.out.println("lastRow\u5171\uff1a" + lastRow + "\u884c\u6570\u636e");
            for (int rowNum = firstRowNum; rowNum < lastRow; ++rowNum) {
                Row row = sheet.getRow(rowNum);
                ArrayList<String> cellList = new ArrayList<String>();
                int cellLast = row.getLastCellNum();
                for (int i = 0; i < cellLast; ++i) {
                    String value = ReadExcel.convertCellToString(row.getCell(i));
                    if (value == null || "".equals(value)) {
                        cellList.add("");
                        continue;
                    }
                    cellList.add(value);
                }
                resultDataList.add(cellList);
            }
        }
        return resultDataList;
    }

    private static String convertCellToString(Cell cell) {
        if (cell == null) {
            return null;
        }
        String returnValue = null;
        switch (cell.getCellType()) {
            case NUMERIC: {
                Double doubleValue = cell.getNumericCellValue();
                if ((double)doubleValue.intValue() - doubleValue == 0.0) {
                    returnValue = String.valueOf(doubleValue.intValue());
                    break;
                }
                returnValue = String.valueOf(doubleValue);
                break;
            }
            case STRING: {
                returnValue = cell.getStringCellValue();
                break;
            }
            case BLANK: {
                break;
            }
            case BOOLEAN: {
                Boolean booleanCellValue = cell.getBooleanCellValue();
                returnValue = booleanCellValue.toString();
                break;
            }
            case FORMULA: {
                returnValue = cell.getCellFormula();
                break;
            }
        }
        return returnValue;
    }
}

