<?php

    /***************************************************************\
    |                                                               |
    |   开单大师（专业的房产ERP管理系统）                           |
    |                                                               |
    |   © 2017-2023 淮南市银泰软件科技有限公司 All rights reserved  |
    |                                                               |
    |   http://www.kaidandashi.com                                  |
    |                                                               |
    |   QQ号：984784483                                             |
    |                                                               |
    \***************************************************************/

    namespace Admin\Controller;
    use Think\Controller;
    use QL\QueryList;
    class AjaxController extends CommonController {

        public function bumen_choice(){
            $node=I('node');
            if ($node) {
                $x = _rbac_lists_where($node,0);
            } else {
                $x = "null";
            }
            $result = M('bumen')->order(array("sort" => "ASC"))->select();
            foreach ($result as $key => $r) {
                if ($x && $x != "all" && $x != "me" && $x != "null") {
                    $b = explode(",",$x);
                    if (in_array($r['id'],$b)) {
                        $array[] = $r;
                    }
                }elseif($x == 'me' || $x == false){
                    $array = "";
                }elseif($x == 'all' || $x == 'null'){
                    $array[] = $r;
                }
            }
            $a = 0;
            $l = 999;
            if ($x && $x != "all" && $x != "me" && $x != "null") {
                foreach ($array as $key => $value) {
                    if ($value['level'] < $l) {
                        $a = $value['parentid'];
                        $l = $value['level'];
                    }
                }
            }
            $result = $array;
            $tree = new \Org\Util\Tree();
            $tree->icon = array('&nbsp;&nbsp;&nbsp;│ ', '&nbsp;&nbsp;&nbsp;├─ ', '&nbsp;&nbsp;&nbsp;└─ ');
                $tree->nbsp = '&nbsp;&nbsp;&nbsp;';
            foreach ($result as $n=> $r) {
                $result[$n]['parentid_node'] = ($r['parentid']) ? ' class="child-of-node-' . $r['parentid'] . '"' : '';
                $result[$n]['ico_type'] = ' <i class="layui-icon">&#xe68e;</i> ';
                $px = $r['level']*20;
                $result[$n]['px'] =  $px.'px';
            }
            $tree->init($result);
            $str = "<tr id='node-\$id' \$parentid_node style='\$style' data-type='\$type' data-value='\$id' data-name='\$bmming'>
                        <td style='padding-left: \$px;'>\$ico_type\$bmming</td>
                    </tr>";
            $bumen = $tree->get_tree(0, $str);
            $this->ajaxReturn($bumen);
        }

        public function yonghu_choice(){
            $node=I('node');
            $map['id'] = array('gt',0);
            if ($node) {
                $x = _rbac_lists_where($node,0);
                if ($x && $x != "all" && $x != "me") {
                    $map['bumen'] = array('in',$x);
                }elseif ($x == "me") {
                    $map['id'] = session('uid');
                }elseif ($x == false) {
                    $map['id'] = 0;
                }
            } else {
                $x = "null";
            }
            $result = M('bumen')->order(array("sort" => "ASC"))->select();
            foreach ($result as $key => $r) {
                if ($x && $x != "all" && $x != "me" && $x != "null") {
                    $b = explode(",",$x);
                    if (in_array($r['id'],$b)) {
                        $array[] = $r;
                    }
                }elseif($x == 'me' || $x == false){
                    $array = "";
                }elseif($x == 'all' || $x == 'null'){
                    $array[] = $r;
                }
            }
            $a = 0;
            $l = 999;
            if ($x && $x != "all" && $x != "me" && $x != "null") {
                foreach ($array as $key => $value) {
                    if ($value['level'] < $l) {
                        $a = $value['parentid'];
                        $l = $value['level'];
                    }
                }
            }
            $result = $array;
            $user = M('yonghu')->where(array('lock1'=>0,'status'=>1,$map))->select();
            foreach ($user as $key => $value) {
                $result[time().$value['id']] = array(
                    'bmming'=>$value['ygmingcheng'],
                    'parentid'=>$value['bumen'],
                    'uid'=>$value['id'],
                    'type'=>1
                );
            }
            $tree = new \Org\Util\Tree();
            foreach ($result as $n=> $r) {
                $result[$n]['parentid_node'] = ($r['parentid']) ? ' class="child-of-node-' . $r['parentid'] . '"' : '';
                $result[$n]['ico_type'] = ($r['type']) ? ' <i class="layui-icon">&#xe612;</i>  ' : ' <i class="layui-icon">&#xe68e;</i> ';
            }
            $tree->init($result);
            $str = "<tr id='node-\$id' \$parentid_node style='\$style' data-type='\$type' data-value='\$uid' data-name='\$bmming'>
                        <td>\$ico_type\$bmming</td>
                    </tr>";
            $bumen = $tree->get_tree(0, $str);
            $this->ajaxReturn($bumen);
        }

        public function tixing(){
            $condition = "gongsiid=".session('gongsiid');
            $sousuo=I('sousuo');
            if ($sousuo == 0) {//搜索
                $condition.=" and txuid=".session('uid')." and txshijian<".time()." and isyidu=0";
            } elseif ($sousuo == 1) {
                $condition.=" and txuid=".session('uid')." and txshijian<".time()." and isyidu=1";
            } elseif ($sousuo == 2) {
                $condition.=" and txuid=".session('uid')." and isyidu=0";
            } elseif ($sousuo == 3) {
                $condition.=" and txuid=".session('uid')." and isyidu=1";
            } elseif ($sousuo == 4) {
                $condition.=" and txuid=".session('uid');
            }
            $shijian1=I('shijian1');
            $shijian2=I('shijian2');
            if ($shijian1) {
                $this->shijian1=$shijian1;
                $shijian3=strtotime($shijian1);
            }
            if ($shijian2) {
                $this->shijian2=$shijian2;
                $shijian4=strtotime($shijian2)+86400;
            }
            if ($shijian3 and $shijian4){
                if ($shijian3 > $shijian4){
                    $condition.=" and txshijian>".$shijian4." and txshijian<".$shijian3;
                    $this->shijian1=$shijian2;
                    $this->shijian2=$shijian1;
                } else {
                    $condition.=" and txshijian>".$shijian3." and txshijian<".$shijian4;
                }
            } elseif ($shijian3) {
                $condition.=" and txshijian>".$shijian3;
            } elseif ($shijian4) {
                $condition.=" and txshijian<".$shijian4;
            }
            $txlx=I('txlx');
            if ($txlx == 1) {
                $txb1=M('kytixing');
                $txb2='__KYTIXING__';
            } elseif ($txlx == 2) {
                $txb1=M('fjtixing');
                $txb2='__FJTIXING__';
                $fjtx1=',c.fanghao';
                $fjtx2=' left join (select id as c_id,fanghao from __FJXINXI__) c on a.fjid = c.c_id';
            }
            $count=$txb1->query("select count(*) from ".$txb2." where {$condition}");
            $Page=new \Think\Page($count['0']['count(*)'],20);
            $show  = $Page->show();
            $list="select a.*,b.ygmingcheng,b.dianhua".$fjtx1." from ".$txb2." a left join (select id as b_id,ygmingcheng,dianhua from __YONGHU__) b on a.adduid = b.b_id".$fjtx2." where {$condition} order by txshijian DESC limit ".$Page->firstRow.','.$Page->listRows;
            $tixing=$txb1->query($list);
            $this->assign('firstRow',$Page->firstRow);
            $this->assign('tixing',$tixing);
            $this->assign('count',$count);
            $this->assign('page',$show);
            $this->display();
        }

        public function tixingxq(){
            $id=I('id');
            $txlx=I('txlx');
            if ($txlx == 1) {
                $txb1=M('kytixing');
            } elseif ($txlx == 2) {
                $txb1=M('fjtixing');
            }
            $tixing=$txb1->where(array('id'=>$id))->find();
            if ($txlx == 2) {
                $this->xiaoqum=M('xiaoqu')->where(array('id'=>$tixing['xqid']))->getField('xiaoqum');
                $this->zdming=M('zdxinxi')->where(array('id'=>$tixing['zdid']))->getField('zdming');
                $this->dyming=M('dyxinxi')->where(array('id'=>$tixing['dyid']))->getField('dyming');
                $this->lcming=M('lcxinxi')->where(array('id'=>$tixing['lcid']))->getField('lcming');
                $this->fanghao=M('fjxinxi')->where(array('id'=>$tixing['lcid']))->getField('fanghao');
            }
            if ($tixing['txshijian'] < time()) {
                $isok=$txb1->where(array('id'=>$id))->setField('isyidu',1);
            }
            $this->txren=M('yonghu')->where(array('id'=>$tixing['txuid']))->getField('ygmingcheng');
            $this->tjren=M('yonghu')->where(array('id'=>$tixing['adduid']))->getField('ygmingcheng');
            $this->tixing=$tixing;
            $this->display();
        }

        //错误提示
        public function error(){
            $this->error = I('error');
            $this->display();
        }

        //错误提示1
        public function error1(){
            $this->error = I('error');
            $this->display();
        }

        public function get_pinyin(){
            $txt=I('txt');
            $py = new \Lib\Pinyin\Pinyin;
            $s = $py->qupinyin($txt ,true);
            $q = $py->qupinyin($txt);
            $h = $s.' '.$q.' '.$txt;
            $data=array('status'=>1,'pyjs'=>$h);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        public function get_bumen(){
            $select_categorys = bumen_option( 0, I('jiedian'));
            $data=array('status'=>1,'sousuo'=>$select_categorys);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        public function get_bumen_yonghu(){
            $bmid=I('bmid');
            $User = M("yonghu"); // 实例化User对象
            $map['id'] = array('gt',2);
            $map['status'] = 1;
            $map['bumen'] = $bmid;
            $list=$User->where($map)->order('pinyinjs asc')->select(); 
            $data=array('status'=>1,'sousuo'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        public function get_yonghu(){
            $node=I('node');
            $txt=sql_check_param(I('txt'));
            $map['status'] = 1;
            $map['lock1'] = 0;
            $map['_string']='(pinyinjs like "%'.$txt.'%") OR (ygmingcheng like "%'.$txt.'%") OR (dianhua like "%'.$txt.'%")';
            if ($node) {
                $x = _rbac_lists_where($node,0);
                if ($x && $x != "all" && $x != "me") {
                    $map['bumen'] = array('in',$x);
                }elseif ($x == "me") {
                    $map['id'] = session('uid');
                }elseif ($x == false) {
                    $map['id'] = 0;
                }
            }
            $list=M("yonghu")->where($map)->limit(10)->order('pinyinjs asc')->select(); 
            $data=array('status'=>1,'district'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        public function get_rsyonghu(){
            $txt=sql_check_param(I('txt'));
            $node=I('node');
            if ($node) {
                $x = _rbac_lists_where($node,0);
                if ($x && $x != "all" && $x != "me") {
                    $map['bumen'] = array('in',$x);
                }elseif ($x == "me") {
                    $map['id'] = session('uid');
                }elseif ($x == false) {
                    $map['id'] = 0;
                }
            }
            $map['status'] = 1;
            $map['gongsiid'] = session('gongsiid');
            $map['_string']='(pinyinjs like "%'.$txt.'%") or (ygmingcheng like "%'.$txt.'%") or (ygbianhao like "%'.$txt.'%") or (dianhua like "%'.$txt.'%")';
            $list=M('yonghu')->where($map)->field('id,ygmingcheng')->limit(10)->order('pinyinjs asc')->select();
            $data=array('status'=>1,'district'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        // 房源打印模板管理图片上传（异步）
        public function upload(){
            $file = $_FILES['file'];//得到传输的数据
            $name = $file['name'];//得到文件名称
            $type = strtolower(substr($name,strrpos($name,'.')+1)); //得到文件类型，并且都转化成小写
            $allow_type = array('jpg','jpeg','png'); //定义允许上传的类型
            //判断文件类型是否被允许上传
            if (!in_array($type, $allow_type)) {
                //如果不被允许，则直接停止程序运行
                $data=array(
                    'info' => '只可以上传jpg、jpeg、png格式的图片！',
                    'status' => 0,
                );
                $this->ajaxReturn($data);
            }
            $upload_path = "/Upload/".session('gongsiid')."/dayinmoban/"; //上传文件的存放路径
            //开始移动文件到相应的文件夹
            $xname=explode('.',$name);//文件名打散成数组
            $xname['0']= date("Ymdhis",time()).rand(1,9);
            $newname = $xname['0'].'.'.$xname[1];
            $src = $upload_path.$newname;
            if (move_uploaded_file($file['tmp_name'],'.'.$src)) {
                $data=array(
                    'info' => '上传成功',
                    'upfilename' => $newname,
                    'status' => 1,
                );
                $this->ajaxReturn($data);
            } else {
                $data=array(
                    'info' => '上传失败！',
                    'status' => 0,
                );
                $this->ajaxReturn($data);
            }
        }

        //模糊查询小区
        public function get_xiaoqu_txt(){
            $txt=sql_check_param(I('txt'));
            $listObj = M('xiaoqu');
            $where['_string']='(xiaoqum like "%'.$txt.'%") OR (pinyinjs like "%'.$txt.'%")';
            $where['gongsiid'] = session('gongsiid');
            $list = $listObj->where($where)->limit(10)->select();
            $data=array('status'=>1,'lists'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        // 添加坐标
        public function addzb(){
            $zuobiao = I('zuobiao');
            if ($zuobiao) {
                $zb = $zuobiao;
                $this->isedit = 1;
            }else{
                $zb = $this->jcpz['dtzuobiao'];
            }
            $this->zb = $zb;
            $this->display();
        }

        public function get_fybianhao_txt(){
            $txt = sql_check_param(I('txt'));
            $mmzl = I('mmzl');
            $listObj = M('Fangyuan');
            $where['_string']='(bianhao like "%'.$txt.'%")';
            $where['gongsiid'] = session('gongsiid');
            $where['leixing'] = $mmzl;
            $list = $listObj->where($where)->field('bianhao')->limit(10)->select();
            $data = array('status'=>1,'lists'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        // 中介黑名单搜索框异步下拉
        public function get_zjhmd_ziyuan(){
            $txt=sql_check_param(I('txt'));
            $listObj = M('Qtjjr');
            $where['_string']='(sjh like "%'.$txt.'%")';
            $where['gongsiid'] = session('gongsiid');
            $list = $listObj->where($where)->limit(10)->select();
            $data=array('district'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        public function get_pzxsj(){
            $listObj = M('peizhi');
            $list = $listObj->order('id desc')->find();
            $data=array('pics'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        public function get_jsxsj(){
            $listObj = M('role');
            $list = $listObj->order('id desc')->find();
            $data=array('pics'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        //关联
        public function guanlian(){
            $qxpdep = _rbac_node_show(425) == true? '1': '0';
            $qxpddp = _rbac_node_show(427) == true? '1': '0';
            $id=I('id');
            $where['gongsiid']=session('gongsiid');
            $where['id']=$id;
            $pzming=M('peizhi')->where(array('id'=>I('id')))->getField('pzming');
            $leixing=M('peizhi')->where(array('pzming'=>$pzming,'zhuangtai'=>'1'))->order('xsshunxu asc')->select();
            $data=array('status'=>0,'leixing'=>$leixing,'qxpdep'=>$qxpdep,'qxpddp'=>$qxpddp);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        // 异步获取打印模板新数据
        public function get_mobanxsj_ziyuan(){
            $listObj = M('fydayin');
            $list = $listObj->order('id desc')->find();
            $data=array('pics'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        // 房源打印模板搜索框异步下拉
        public function get_moban_ziyuan(){
            $txt=sql_check_param(I('txt'));
            $listObj = M('fydayin');
            $where['_string']='(mbmingcheng like "%'.$txt.'%")';
            $where['gongsiid'] = session('gongsiid');
            $list = $listObj->where($where)->limit(10)->select();
            $data=array('status'=>0,'district'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        } 

        /**
         * [get_fy_img 异步返回图片列表]
         * @return [json] [图片相关的数组]
         */
        public function get_fy_img(){
            $listObj = M('Photo');
            $where['p.fybh'] = I('fy_bh');
            $fangyuan = M('fangyuan')->where(array('bianhao'=>I('fy_bh')))->find();
            $list = $listObj->alias('p')->join(' jjrxt_yonghu as y on p.uid=y.id ')->field('p.id,p.leixing,p.leixing as lxming,p.fengmian,p.gongsiid,p.image,FROM_UNIXTIME(p.create_time,"%Y-%m-%d") AS create_time,p.fybh,y.ygmingcheng,p.uid')->where($where)->order('p.id desc')->select();
            if ($list) {
                $pzming='';
                switch ($list[0]['yonghu']) {
                    case 1:
                        $pzming='zztplx';   //住宅
                        break;
                    case 2:
                        $pzming='bstplx';   //别墅
                        break;
                    case 3:
                        $pzming='sptplx';   //商铺
                        break;    
                    case 4:
                        $pzming='cktplx';   //仓库
                        break;
                    case 5:
                        $pzming='chftplx';   //厂房
                        break;
                    case 6:
                        $pzming='tdtplx';   //土地
                        break;
                    case 7:
                        $pzming='chktplx';   //车库
                        break;
                    case 8:
                        $pzming='xzltplx';   //写字楼
                        break;
                    default:
                        $pzming='zztplx';
                        break;
                }
            }
            foreach ($list as &$value) {
                $temp = get_peizhi($pzming,$value['leixing'],3);
                $value['lxming'] = $value['leixing']?$temp:'未设置图片类型';
                $value['fm'] = _rbac_btn_show(481,$fangyuan['zhuangtai'],$value['uid']) == true? '1': '0';
                $value['del']  = _rbac_btn_show(50,$fangyuan['zhuangtai'],$value['uid']) == true? '1': '0';           
            }
            //p($list);die;
            //返回查询结果到异步json
            $data=array('pics'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        /**
         * [get_xq_img 异步返回图片列表]
         * @return [json] [图片相关的数组]
         */
        public function get_xq_img(){
            $listObj = M('xqphoto');
            $where['p.xqid'] = I('xq_id');
            $list = $listObj->alias('p')->join(' jjrxt_yonghu as y on p.uid=y.id ')->field('p.id,p.leixing,p.leixing as lxming,p.fengmian,p.gongsiid,p.image,FROM_UNIXTIME(p.create_time,"%Y-%m-%d") AS create_time,p.xqid,y.ygmingcheng')->where($where)->order('p.id desc')->select();
            if ($list) {
                $pzming='xqtplx';
            }
            foreach ($list as &$value) {
                $temp = get_peizhi($pzming,$value['leixing'],3);
                $value['lxming'] = $value['leixing']?$temp:'未设置图片类型';
                $value['fm'] = _rbac_btn_show(485,0,$value['uid']) == true? '1': '0';
                $value['del']  = _rbac_btn_show(134,0,$value['uid']) == true? '1': '0';
            }
            //返回查询结果到异步json
            $data=array('pics'=>$list);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        public function fyppky(){
            $leixing=I('leixing');
            $shoujia=I('shoujia');
            $zujia=I('zujia');
            $mianji=I('mianji');
            $shi=I('shi');
            $louceng=I('louceng');
            $niandai=I('niandai');
            $yongtu=I('yongtu');
            $xiaoqum=sql_check_param(I('xiaoqum'));
            $zhuangxiu=I('zhuangxiu');
            $chaoxiang=I('chaoxiang');
            $chengjiao_options=M('options')->where(array('option_name'=>'chengjiao_options'))->find();
            $options_arr = json_decode($chengjiao_options['option_value'],true);
            if (!$shoujia && !$zujia && !$mianji && !$shi && !$louceng && !$niandai && !$yongtu && !$xiaoqum && !$zhuangxiu && !$chaoxiang) {
                $this->error('请选择匹配条件！');
            }
            $condition="gongsiid=".session('gongsiid');
            $condition.=" and zhuangtai > 0 and zhuangtai not in (".$options_arr['kyfengpan_zhuangtai'].")";
            if ($leixing == 1) {
                $condition.=" and mmzl = 1";
                if ($shoujia) {
                    $condition.=" and xqjiage1 <= ".$shoujia." and ( xqjiage2 >= ".$shoujia." or xqjiage2 < 1 )";
                }
            } elseif ($leixing == 2) {
                $condition.=" and mmzl = 2";
                if ($zujia) {
                    $condition.=" and xqjiage1 <= ".$zujia." and ( xqjiage2 >= ".$zujia." or xqjiage2 < 1 )";
                }
            }
            if (($leixing == 1) || ($leixing == 2)) {
                if ($mianji) {
                    $condition.=" and xqmianji1 <= ".$mianji." and ( xqmianji2 >= ".$mianji." or xqmianji2 < 1 )";
                }
                if ($shi) {
                    $condition.=" and xqhuxing1 <= ".$shi." and ( xqhuxing2 >= ".$shi." or xqhuxing2 < 1 )";
                }
                if ($louceng) {
                    $condition.=" and louceng1 <= ".$louceng." and ( louceng2 >= ".$louceng." or louceng2 < 1 )";
                }
                if ($niandai) {
                    $fyfl=date("Y",time())-$niandai+1;
                    $condition.=" and fangling1 <= ".$fyfl." and ( fangling2 >= ".$fyfl." or fangling2 < 1 )";
                }
                if ($yongtu) {
                    $condition.=" and xqyongtu = ".$yongtu;
                }
                if ($xiaoqum) {
                    $condition.=" and xqxiaoqu like '%".$xiaoqum."%'";
                }
                if ($zhuangxiu) {
                    $condition.=" and zhuangxiu like '%".$zhuangxiu."%'";
                }
                if ($chaoxiang) {
                    $condition.=" and chaoxiang like '%".$chaoxiang."%'";
                }
                $yxkeyuan=M('keyuan')->query("select a.*,b.ygmingcheng,b.dianhua,b.bumen,c.bmming,d.yezhulx,e.khzt from (select * from __KEYUAN__ where {$condition}) a left join (select id as yhid,ygmingcheng,dianhua,bumen from __YONGHU__ ) b on a.weihurenid=b.yhid left join (select id as bmid,bmming from __BUMEN__ ) c on b.bumen=c.bmid left join (select lxid as yzlxid,lxming as yezhulx from __PEIZHI__ where pzming = 'yezhulx' ) d on a.kehulx=d.yzlxid left join (select lxid as ztlxid,lxming as khzt from __PEIZHI__ where pzming = 'khzhuangtai' ) e on a.zhuangtai=e.ztlxid ");
                foreach ($yxkeyuan as $key => $value) {
                    $yxkeyuan[$key]['xqqxpb']=_rbac_btn_show(75,$value['zhuangtai'],$value['weihurenid']) == true? '1': '0';
                }
                $data=array(
                    'info' => '匹配成功',
                    'status' => 1,
                    'data' => $yxkeyuan,
                );
                $this->ajaxReturn($data);
            }
        }

        public function kyppfy(){
            $mmzl=I('mmzl');
            $xqjiage=I('xqjiage');
            $xqmianji=I('xqmianji');
            $xqhuxing=I('xqhuxing');
            $louceng=I('louceng');
            $fangling=I('fangling');
            $chengjiao_options=M('options')->where(array('option_name'=>'chengjiao_options'))->find();
            $options_arr = json_decode($chengjiao_options['option_value'],true);
            if (!$xqjiage && !$xqmianji && !$xqhuxing && !$louceng && !$fangling) {
                $this->error('请选择匹配条件！');
            }
            if ($xqjiage) {
                $xqjg1=explode(",", $xqjiage);
                $xqjg2=explode(",", $xqjiage);
                $xqjiage1=$xqjg1[0];
                $xqjiage2=$xqjg2[1];
            }
            if ($xqmianji) {
                $xqmj1=explode(",", $xqmianji);
                $xqmj2=explode(",", $xqmianji);
                $xqmianji1=$xqmj1[0];
                $xqmianji2=$xqmj2[1];
            }
            if ($xqhuxing) {
                $xqhx1=explode(",", $xqhuxing);
                $xqhx2=explode(",", $xqhuxing);
                $xqhuxing1=$xqhx1[0];
                $xqhuxing2=$xqhx2[1];
            }
            if ($louceng) {
                $xqlc1=explode(",", $louceng);
                $xqlc2=explode(",", $louceng);
                $louceng1=$xqlc1[0];
                $louceng2=$xqlc2[1];
            }
            if ($fangling) {
                $xqfl1=explode(",", $fangling);
                $xqfl2=explode(",", $fangling);
                $fangling1=$xqfl1[0];
                $fangling2=$xqfl2[1];
            }
            $xqyongtu=I('xqyongtu');
            $xqxiaoqu=I('xqxiaoqu');
            $zhuangxiu=I('zhuangxiu');
            $chaoxiang=I('chaoxiang');
            $condition="gongsiid=".session('gongsiid');
            $condition.=" and zhuangtai > 0 and zhuangtai not in (".$options_arr['fyfengpan_zhuangtai'].")";
            if ($mmzl == 1) {
                $condition.=" and leixing = 1";
                if ($xqjiage1 && $xqjiage2) {
                    $condition.=" and shoujia >= ".$xqjiage1." and shoujia <= ".$xqjiage2;
                }else if ($xqjiage1) {
                    $condition.=" and shoujia >= ".$xqjiage1;
                }else if ($xqjiage2) {
                    $condition.=" and shoujia <= ".$xqjiage2;
                }
            } elseif ($mmzl == 2) {
                $condition.=" and leixing = 2";
                if ($xqjiage1 && $xqjiage2) {
                    $condition.=" and zujia >= ".$xqjiage1." and zujia <= ".$xqjiage2;
                }else if ($xqjiage1) {
                    $condition.=" and zujia >= ".$xqjiage1;
                }else if ($xqjiage2) {
                    $condition.=" and zujia <= ".$xqjiage2;
                }
            }
            if (($mmzl == 1) || ($mmzl == 2)) {
                if ($xqmianji1 && $xqmianji2) {
                    $condition.=" and mianji >= ".$xqmianji1." and mianji <= ".$xqmianji2;
                }else if ($xqmianji1) {
                    $condition.=" and mianji >= ".$xqmianji1;
                }else if ($xqmianji2) {
                    $condition.=" and mianji <= ".$xqmianji2;
                }
                if ($xqhuxing1 && $xqhuxing2) {
                    $condition.=" and shi >= ".$xqhuxing1." and shi <= ".$xqhuxing2;
                }else if ($xqhuxing1) {
                    $condition.=" and shi >= ".$xqhuxing1;
                }else if ($xqhuxing2) {
                    $condition.=" and shi <= ".$xqhuxing2;
                }
                if ($louceng1 && $louceng2) {
                    $condition.=" and louceng >= ".$louceng1." and louceng <= ".$louceng2;
                }else if ($louceng1) {
                    $condition.=" and louceng >= ".$louceng1;
                }else if ($louceng2) {
                    $condition.=" and louceng <= ".$louceng2;
                }
                if ($fangling1 && $fangling2) {
                    $fyfl1=date("Y",time())-$fangling1+1;
                    $fyfl2=date("Y",time())-$fangling2+1;
                    $condition.=" and niandai <= ".$fyfl1." and niandai >= ".$fyfl2;
                }else if ($fangling1) {
                    $fyfl1=date("Y",time())-$fangling1+1;
                    $condition.=" and niandai <= ".$fyfl1;
                }else if ($fangling2) {
                    $fyfl2=date("Y",time())-$fangling2+1;
                    $condition.=" and niandai >= ".$fyfl2;
                }
                if ($xqyongtu) {
                    $condition.=" and yongtu = ".$xqyongtu;
                }
                if ($xqxiaoqu) {
                    $xqxiaoqud = explode("；", $xqxiaoqu);
                    $conditionxq="";
                    foreach ($xqxiaoqud as $key => $value) {
                        if ($value) {
                            if ($key == 0) {
                                $conditionxq.=" xiaoqum = '".$value."'";
                            } else {
                                $conditionxq.=" or xiaoqum = '".$value."'";
                            }
                        }
                    }
                    $condition.=" and (".$conditionxq.")";
                }
                if ($zhuangxiu) {
                    $condition.=" and zhuangxiu in (".$zhuangxiu.")";
                }
                if ($chaoxiang) {
                    $condition.=" and chaoxiang in (".$chaoxiang.")";
                }
                $xqfangyuan=M('fangyuan')->query("select a.*,b.ygmingcheng,b.dianhua,b.bumen,c.bmming,d.fyzt from (select * from __FANGYUAN__ where {$condition}) a left join (select id as yhid,ygmingcheng,dianhua,bumen from __YONGHU__ ) b on a.weihurenid=b.yhid left join (select id as bmid,bmming from __BUMEN__ ) c on b.bumen=c.bmid left join (select lxid as ztlxid,lxming as fyzt from __PEIZHI__ where pzming = 'zhuangtai' ) d on a.zhuangtai=d.ztlxid ");
                foreach ($xqfangyuan as $key => $value) {
                    $xqfangyuan[$key]['xqqxpb']=_rbac_btn_show(46,$value['zhuangtai'],$value['weihurenid']) == true? '1': '0';
                }
                $data=array(
                    'info' => '匹配成功',
                    'status' => 1,
                    'data' => $xqfangyuan,
                );
                $this->ajaxReturn($data);
            }
        }

        //选择部门查询当前部门下的用户
        public function select_yuangong(){
            $id = I('id');
            $status['status']=1;
            $user = M('yonghu')->where(array('bumen'=>$id))->where($status)->field('id,ygmingcheng')->order('pinyinjs asc')->select();
            if($user){
                $this->ajaxReturn($user);
            }else{
                $this->ajaxReturn(array('status'=>0,'info'=>'当前部门下没有用户'));
            }
        }

        //搜索行政区
        public function ss_xzq(){
            $map .= " where gongsiid=".session('gongsiid');
            $x = _rbac_lists_where(372,0);
            if ($x && $x != "all" && $x != "me") {
                $map .= " and bumen in ({$x})";
            }elseif ($x == "me") {
                $map .= " and id=".session('uid');
            }elseif ($x == false) {
                $map .= " and id=0";
            }
            $condition="gongsiid=".session('gongsiid');
            $txt=sql_check_param(I('txt'));
            if ($txt) {
                $condition.=" and ((xzqming like '%$txt%') or (pinyinjs like '%$txt%'))";
            }
            $list="select a.id,a.xzqming from (select id,xzqming,whrid,pinyinjs from __XINGZHENGQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id order by a.pinyinjs asc limit 10 ";
            $xzq=M('xingzhengqu')->query($list);
            $data=array('status'=>1,'lists'=>$xzq);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        //搜索片区
        public function ss_pq(){
            $map .= " where gongsiid=".session('gongsiid');
            $x = _rbac_lists_where(123,0);
            if ($x && $x != "all" && $x != "me") {
                $map .= " and bumen in ({$x})";
            }elseif ($x == "me") {
                $map .= " and id=".session('uid');
            }elseif ($x == false) {
                $map .= " and id=0";
            }
            $condition="gongsiid=".session('gongsiid');
            $txt=sql_check_param(I('txt'));
            if ($txt) {
                $condition.=" and ((pianqum like '%$txt%') or (pinyinjs like '%$txt%'))";
            }
            $list="select a.id,a.pianqum from (select id,pianqum,whrid,pinyinjs from __PIANQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id order by a.pinyinjs asc limit 10 ";
            $pq=M('pianqu')->query($list);
            $data=array('status'=>1,'lists'=>$pq);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        //搜索小区
        public function ss_xq(){
            $map .= " where gongsiid=".session('gongsiid');
            $x = _rbac_lists_where(129,0);
            if ($x && $x != "all" && $x != "me") {
                $map .= " and bumen in ({$x})";
            }elseif ($x == "me") {
                $map .= " and id=".session('uid');
            }elseif ($x == false) {
                $map .= " and id=0";
            }
            $condition="gongsiid=".session('gongsiid');
            $txt=sql_check_param(I('txt'));
            if ($txt) {
                $condition.=" and ((xiaoqum like '%$txt%') or (pinyinjs like '%$txt%'))";
            }
            $list="select a.id,a.xiaoqum from (select id,xiaoqum,whrid,pinyinjs from __XIAOQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id order by a.pinyinjs asc limit 10 ";
            $xq=M('xiaoqu')->query($list);
            $data=array('status'=>1,'lists'=>$xq);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        //搜索学区
        public function ss_xx(){
            $map .= " where gongsiid=".session('gongsiid');
            $x = _rbac_lists_where(135,0);
            if ($x && $x != "all" && $x != "me") {
                $map .= " and bumen in ({$x})";
            }elseif ($x == "me") {
                $map .= " and id=".session('uid');
            }elseif ($x == false) {
                $map .= " and id=0";
            }
            $condition="gongsiid=".session('gongsiid');
            $txt=sql_check_param(I('txt'));
            if ($txt) {
                $condition.=" and ((xuexiaom like '%$txt%') or (pinyinjs like '%$txt%'))";
            }
            $list="select a.id,a.xuexiaom from (select id,xuexiaom,whrid,pinyinjs from __XUEQU__ where {$condition}) a join (select id as e_id from __YONGHU__ {$map}) e on a.whrid=e.e_id order by a.pinyinjs asc limit 10 ";
            $xx=M('xuequ')->query($list);
            $data=array('status'=>1,'lists'=>$xx);
            header("Content-type: application/json");
            exit(json_encode($data));
        }

        //重复房源判断
        public function cffypd(){
            $id = I('id',0,'int');
            $xiaoqu = I('xiaoqu',0,'int');
            $zuodong = I('zuodong');
            $danyuan = I('danyuan');
            $fanghao = I('fanghao');
            $leixing = I('leixing',0,'int');
            $condition['gongsiid'] = session('gongsiid');
            $condition['zhuangtai'] = array('neq',get_options('chengjiao_options','fychengjiao_zhuangtai'));
            if ($id > 0) {
                $condition['id'] = array('neq',$id);
            }
            $condition['isdel'] = 2;
            $condition['xiaoqu'] = $xiaoqu;
            $condition['zuodong'] = $zuodong;
            $condition['danyuan'] = $danyuan;
            $condition['fanghao'] = $fanghao;
            $condition['leixing'] = $leixing;
            $cffy = M('fangyuan')->where($condition)->find();
            if ($cffy) {
                $this->ajaxReturn(array('status'=>1,'info'=>'房源已存在！'));
            } else {
                $this->ajaxReturn(array('status'=>2));
            }
        }

        /**
            * 获取递归数组深度
            * @param $id
            * @param $array
            * @param $i
        */
        public function get_level($id, $array = array(), $i = 0) {
            if ($array[$id]['parentid']==0 || empty($array[$array[$id]['parentid']]) || $array[$id]['parentid']==$id){
                return  $i;
            }else{
                $i++;
                return $this->get_level($array[$id]['parentid'],$array,$i);
            }
        }

    }