<?php

    /***************************************************************\
    |                                                               |
    |   开单大师（专业的房产ERP管理系统）                           |
    |                                                               |
    |   © 2017-2023 淮南市银泰软件科技有限公司 All rights reserved  |
    |                                                               |
    |   http://www.kaidandashi.com                                  |
    |                                                               |
    |   QQ号：984784483                                             |
    |                                                               |
    \***************************************************************/

    namespace Admin\Controller;
    use Think\Controller;
    class YaoshiController extends CommonController {
        public function index(){
            if (I('is_ajax')) {
                /*权限控制开始*/
                $condition = "e.gongsiid=".session('gongsiid');
                $x = _rbac_lists_where(747,0);
                if ($x && $x != "all" && $x != "me") {
                    $condition .= " and e.bumen in ({$x})";
                }elseif ($x == "me") {
                    $condition .= " and e.id=".session('uid');
                }elseif ($x == false) {
                    $condition .= " and e.id=0";
                }
                /*权限控制结束*/
                $sousuo = I('sousuo');
                $bumen = I("get.bumen",0,'intval');
                if ($bumen) {
                    $string = get_bm_sz($bumen,2);
                    $condition .= " and a.ys_bumen in ($string)";
                }
                $shijian = I('shijian');
                if ($shijian) {
                    $time_s = explode(' - ',$shijian);
                    $time_s1 = strtotime($time_s[0]);
                    $time_s2 = strtotime($time_s[1])+86400;
                    $condition .= " and a.addtime>=".$time_s1." and a.addtime<".$time_s2;
                }
                if ($sousuo) {
                    $condition .= " and ((e.pinyinjs like '%$sousuo%') or (e.ygmingcheng like '%$sousuo%') or (e.dianhua like '%$sousuo%') or (a.fybianhao like '%$sousuo%') or (a.ys_bianhao like '%$sousuo%'))";
                }
                $field = I('field'); //排序字段名
                $order = I('order'); //排序方式
                $limit = I('limit',30,'int'); //每页条数
                $limit = $limit > 150 ? 150 : $limit;
                if ($field && $order) {
                    $yspx = "order by a.".$field." ".$order;
                } else {
                    $yspx = "order by a.id desc";
                }
                $Model = new \Think\Model();
                $sqlcount = "select count(*) from __YAOSHI__ a join __YONGHU__ e on a.ys_uid=e.id where {$condition}";
                $Page = new \Think\Page($count['0']['count(*)'],$limit);
                $list = "select a.*,e.ygmingcheng from __YAOSHI__ a join __YONGHU__ e on a.ys_uid=e.id where {$condition} ".$yspx." limit ".$Page->firstRow.','.$Page->listRows;
                $data = $Model->query($list);
                foreach ($data as $key => $value) {
                    $data[$key]['fyxqlj'] = U('fangyuan/neirong',array('bianhao'=>$value['fybianhao']));
                    $fy = M('fangyuan')->where(array('bianhao'=>$value['fybianhao']))->field('zhuangtai,weihurenid')->find();
                    $q_bumen = M('yaoshi_log')->where(array('ys_id'=>$value['id']))->getField('q_bumen');
                    $data[$key]['fyxqqx'] = _rbac_btn_show(46,$fy['zhuangtai'],$fy['weihurenid']) == true ? '1' : '0';
                    $data[$key]['rbacxq'] = _rbac_btn_show(748,0,$value['ys_uid']) ? '1' : '0';
                    $data[$key]['rbacgx'] = _rbac_btn_show(749,0,$value['ys_uid']) ? '1' : '0';
                    $data[$key]['rbacsc'] = _rbac_btn_show(752,0,$value['ys_uid']) ? '1' : '0';
                    $fybh = explode("-", $value['fybianhao']);
                    $data[$key]['fybh'] = $value['fybianhao'];
                    $data[$key]['fybianhao'] = $fybh[1];
                    $data[$key]['tjren'] = zym($value['adduid'],5);
                    $data[$key]['ybumen'] = zym($value['ys_bumen'],6);
                    $data[$key]['xbumen'] = $q_bumen ? zym($q_bumen,6) : zym($value['ys_bumen'],6);
                    $data[$key]['ys_time'] = date('Y-m-d',$value['ys_time']);
                    $data[$key]['addtime'] = date('Y-m-d H:i:s',$value['addtime']);
                    $data[$key]['status'] = $value['status'] ? '有效' : '待审核';
                    $data[$key]['ys_menjin'] = $value['ys_menjin'] ? '是' : '否';
                    $data[$key]['ys_weizhihao'] = $value['ys_weizhihao'] ? $value['ys_weizhihao'] : '——';
                    $data[$key]['beizhu'] = $value['beizhu'] ? $value['beizhu'] : '——';
                }
                $return_data = array(
                    'code'=>0,
                    'count'=>$count['0']['count(*)'],
                    'data'=>$data
                );
                $this->ajaxReturn($return_data);
            } else {
                $select_categorys = bumen_option(0,747);
                $this->assign("select_categorys", $select_categorys);
                $this->display();
            }
        }
        public function edityaoshi(){
            $id = I('id',0,'int');
            $uid = M('yaoshi')->where(array('id'=>$id))->getField('ys_uid');
            $is_rbac = _rbac_btn_show(749,0,$uid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            if (IS_POST) {
                $this->error('请联系客服（19965783436）获取正式版功能！');
            }else{
                $yaoshi = M('yaoshi')->where(array('id'=>$id))->find();
                $yaoshi['ys_user'] = M('yonghu')->where(array('id'=>$yaoshi['ys_uid']))->getField('ygmingcheng');
                $parentid = $yaoshi['ys_bumen'];
                $select_categorys = bumen_option( $parentid, 739);
                $this->assign("select_categorys", $select_categorys);
                $this->assign("yaoshi", $yaoshi);
                $this->ygmingcheng=M('Yonghu')->where("gongsiid = ".session('gongsiid')." and lock1 = 0 and status = 1 and bumen=".$parentid)->select();
                $this->display();
            }
        }
        public function content(){
            $id = I('get.id',0 ,'int');
            $find = M('yaoshi')->where(array('id'=>$id))->find();
            if (!$find) {
                echo "没找到资源！ -400";
                die;
            }
            $is_rbac = _rbac_btn_show(748,0,$find['ys_uid']);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $imgs = M('photos')->where(array('data_id'=>$id,'data_table'=>'yaoshi','status'=>1))->select();
            $user = M('yonghu')->where(array('id'=>$find['ys_uid']))->field('ygmingcheng,bumen')->find();
            $useradd = M('yonghu')->where(array('id'=>$find['adduid']))->field('ygmingcheng,bumen')->find();
            $Model = new \Think\Model();
            $sql_log = "select a.*,b.ygmingcheng as q_uid, c.ygmingcheng as adduid FROM 
            (select * from __YAOSHI_LOG__ where ys_id=".$find['id'].") as a join __YONGHU__  as b on a.q_uid=b.id left join __YONGHU__ as c on a.adduid=c.id order by q_time DESC";
            $this->yaoshi_log = $Model->query($sql_log);
            $this->user = $user;
            $this->useradd = $useradd;
            $this->find = $find;
            $this->imgs = $imgs;
            $this->display();
        }
        public function delyaoshi(){
            $id = I('post.id',0 ,'int');
            $uid = M('yaoshi')->where(array('id'=>$id))->getField('ys_uid');
            $is_rbac = _rbac_btn_show(752,0,$uid);
            if (!$is_rbac) {
                $this->error('异常错误！');
            }
            $this->error('请联系客服（19965783436）获取正式版功能！');
        }
    }
?>